/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "SmContextCreateData.h"
#include <iostream>
#include <nlohmann/json.hpp>
namespace oai {
namespace smf {
namespace model {

SmContextCreateData::SmContextCreateData() {
  m_Supi                         = utility::conversions::to_string_t("");
  m_SupiIsSet                    = false;
  m_UnauthenticatedSupi          = false;
  m_UnauthenticatedSupiIsSet     = false;
  m_Pei                          = utility::conversions::to_string_t("");
  m_PeiIsSet                     = false;
  m_Gpsi                         = utility::conversions::to_string_t("");
  m_GpsiIsSet                    = false;
  m_PduSessionId                 = 0;
  m_PduSessionIdIsSet            = false;
  m_Dnn                          = utility::conversions::to_string_t("");
  m_DnnIsSet                     = false;
  m_SNssaiIsSet                  = false;
  m_HplmnSnssaiIsSet             = false;
  m_ServingNfId                  = utility::conversions::to_string_t("");
  m_GuamiIsSet                   = false;
  m_ServiceNameIsSet             = false;
  m_RequestTypeIsSet             = false;
  m_N1SmMsgIsSet                 = false;
  m_SecondAnTypeIsSet            = false;
  m_RatTypeIsSet                 = false;
  m_PresenceInLadnIsSet          = false;
  m_UeLocationIsSet              = false;
  m_UeTimeZone                   = utility::conversions::to_string_t("");
  m_UeTimeZoneIsSet              = false;
  m_AddUeLocationIsSet           = false;
  m_SmContextStatusUri           = utility::conversions::to_string_t("");
  m_HSmfUri                      = utility::conversions::to_string_t("");
  m_HSmfUriIsSet                 = false;
  m_AdditionalHsmfUriIsSet       = false;
  m_OldPduSessionId              = 0;
  m_OldPduSessionIdIsSet         = false;
  m_PduSessionsActivateListIsSet = false;
  m_UeEpsPdnConnection           = utility::conversions::to_string_t("");
  m_UeEpsPdnConnectionIsSet      = false;
  m_HoStateIsSet                 = false;
  m_PcfId                        = utility::conversions::to_string_t("");
  m_PcfIdIsSet                   = false;
  m_NrfUri                       = utility::conversions::to_string_t("");
  m_NrfUriIsSet                  = false;
  m_SupportedFeatures            = utility::conversions::to_string_t("");
  m_SupportedFeaturesIsSet       = false;
  m_SelModeIsSet                 = false;
  m_BackupAmfInfoIsSet           = false;
  m_TraceDataIsSet               = false;
  m_UdmGroupId                   = utility::conversions::to_string_t("");
  m_UdmGroupIdIsSet              = false;
  m_RoutingIndicator             = utility::conversions::to_string_t("");
  m_RoutingIndicatorIsSet        = false;
  m_EpsInterworkingIndIsSet      = false;
  m_IndirectForwardingFlag       = false;
  m_IndirectForwardingFlagIsSet  = false;
  m_TargetIdIsSet                = false;
  m_EpsBearerCtxStatus           = utility::conversions::to_string_t("");
  m_EpsBearerCtxStatusIsSet      = false;
  m_CpCiotEnabled                = false;
  m_CpCiotEnabledIsSet           = false;
  m_InvokeNef                    = false;
  m_InvokeNefIsSet               = false;
  m_MaPduIndication              = false;
  m_MaPduIndicationIsSet         = false;
  m_N2SmInfoIsSet                = false;
  m_SmContextRef                 = utility::conversions::to_string_t("");
  m_SmContextRefIsSet            = false;
}

SmContextCreateData::~SmContextCreateData() {}

void SmContextCreateData::validate() {
  // TODO: implement validation
}

web::json::value SmContextCreateData::toJson() const {
  web::json::value val = web::json::value::object();

  if (m_SupiIsSet) {
    val[utility::conversions::to_string_t("supi")] = ModelBase::toJson(m_Supi);
  }
  if (m_UnauthenticatedSupiIsSet) {
    val[utility::conversions::to_string_t("unauthenticatedSupi")] =
        ModelBase::toJson(m_UnauthenticatedSupi);
  }
  if (m_PeiIsSet) {
    val[utility::conversions::to_string_t("pei")] = ModelBase::toJson(m_Pei);
  }
  if (m_GpsiIsSet) {
    val[utility::conversions::to_string_t("gpsi")] = ModelBase::toJson(m_Gpsi);
  }
  if (m_PduSessionIdIsSet) {
    val[utility::conversions::to_string_t("pduSessionId")] =
        ModelBase::toJson(m_PduSessionId);
  }
  if (m_DnnIsSet) {
    val[utility::conversions::to_string_t("dnn")] = ModelBase::toJson(m_Dnn);
  }
  if (m_SNssaiIsSet) {
    val[utility::conversions::to_string_t("sNssai")] =
        ModelBase::toJson(m_SNssai);
  }
  if (m_HplmnSnssaiIsSet) {
    val[utility::conversions::to_string_t("hplmnSnssai")] =
        ModelBase::toJson(m_HplmnSnssai);
  }
  val[utility::conversions::to_string_t("servingNfId")] =
      ModelBase::toJson(m_ServingNfId);
  if (m_GuamiIsSet) {
    val[utility::conversions::to_string_t("guami")] =
        ModelBase::toJson(m_Guami);
  }
  if (m_ServiceNameIsSet) {
    val[utility::conversions::to_string_t("serviceName")] =
        ModelBase::toJson(m_ServiceName);
  }
  val[utility::conversions::to_string_t("servingNetwork")] =
      ModelBase::toJson(m_ServingNetwork);
  if (m_RequestTypeIsSet) {
    val[utility::conversions::to_string_t("requestType")] =
        ModelBase::toJson(m_RequestType);
  }
  if (m_N1SmMsgIsSet) {
    val[utility::conversions::to_string_t("n1SmMsg")] =
        ModelBase::toJson(m_N1SmMsg);
  }
  val[utility::conversions::to_string_t("anType")] =
      ModelBase::toJson(m_AnType);
  if (m_SecondAnTypeIsSet) {
    val[utility::conversions::to_string_t("secondAnType")] =
        ModelBase::toJson(m_SecondAnType);
  }
  if (m_RatTypeIsSet) {
    val[utility::conversions::to_string_t("ratType")] =
        ModelBase::toJson(m_RatType);
  }
  if (m_PresenceInLadnIsSet) {
    val[utility::conversions::to_string_t("presenceInLadn")] =
        ModelBase::toJson(m_PresenceInLadn);
  }
  if (m_UeLocationIsSet) {
    val[utility::conversions::to_string_t("ueLocation")] =
        ModelBase::toJson(m_UeLocation);
  }
  if (m_UeTimeZoneIsSet) {
    val[utility::conversions::to_string_t("ueTimeZone")] =
        ModelBase::toJson(m_UeTimeZone);
  }
  if (m_AddUeLocationIsSet) {
    val[utility::conversions::to_string_t("addUeLocation")] =
        ModelBase::toJson(m_AddUeLocation);
  }
  val[utility::conversions::to_string_t("smContextStatusUri")] =
      ModelBase::toJson(m_SmContextStatusUri);
  if (m_HSmfUriIsSet) {
    val[utility::conversions::to_string_t("hSmfUri")] =
        ModelBase::toJson(m_HSmfUri);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_AdditionalHsmfUri) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("additionalHsmfUri")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_OldPduSessionIdIsSet) {
    val[utility::conversions::to_string_t("oldPduSessionId")] =
        ModelBase::toJson(m_OldPduSessionId);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_PduSessionsActivateList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("pduSessionsActivateList")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_UeEpsPdnConnectionIsSet) {
    val[utility::conversions::to_string_t("ueEpsPdnConnection")] =
        ModelBase::toJson(m_UeEpsPdnConnection);
  }
  if (m_HoStateIsSet) {
    val[utility::conversions::to_string_t("hoState")] =
        ModelBase::toJson(m_HoState);
  }
  if (m_PcfIdIsSet) {
    val[utility::conversions::to_string_t("pcfId")] =
        ModelBase::toJson(m_PcfId);
  }
  if (m_NrfUriIsSet) {
    val[utility::conversions::to_string_t("nrfUri")] =
        ModelBase::toJson(m_NrfUri);
  }
  if (m_SupportedFeaturesIsSet) {
    val[utility::conversions::to_string_t("supportedFeatures")] =
        ModelBase::toJson(m_SupportedFeatures);
  }
  if (m_SelModeIsSet) {
    val[utility::conversions::to_string_t("selMode")] =
        ModelBase::toJson(m_SelMode);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_BackupAmfInfo) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("backupAmfInfo")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_TraceDataIsSet) {
    val[utility::conversions::to_string_t("traceData")] =
        ModelBase::toJson(m_TraceData);
  }
  if (m_UdmGroupIdIsSet) {
    val[utility::conversions::to_string_t("udmGroupId")] =
        ModelBase::toJson(m_UdmGroupId);
  }
  if (m_RoutingIndicatorIsSet) {
    val[utility::conversions::to_string_t("routingIndicator")] =
        ModelBase::toJson(m_RoutingIndicator);
  }
  if (m_EpsInterworkingIndIsSet) {
    val[utility::conversions::to_string_t("epsInterworkingInd")] =
        ModelBase::toJson(m_EpsInterworkingInd);
  }
  if (m_IndirectForwardingFlagIsSet) {
    val[utility::conversions::to_string_t("indirectForwardingFlag")] =
        ModelBase::toJson(m_IndirectForwardingFlag);
  }
  if (m_TargetIdIsSet) {
    val[utility::conversions::to_string_t("targetId")] =
        ModelBase::toJson(m_TargetId);
  }
  if (m_EpsBearerCtxStatusIsSet) {
    val[utility::conversions::to_string_t("epsBearerCtxStatus")] =
        ModelBase::toJson(m_EpsBearerCtxStatus);
  }
  if (m_CpCiotEnabledIsSet) {
    val[utility::conversions::to_string_t("cpCiotEnabled")] =
        ModelBase::toJson(m_CpCiotEnabled);
  }
  if (m_InvokeNefIsSet) {
    val[utility::conversions::to_string_t("invokeNef")] =
        ModelBase::toJson(m_InvokeNef);
  }
  if (m_MaPduIndicationIsSet) {
    val[utility::conversions::to_string_t("maPduIndication")] =
        ModelBase::toJson(m_MaPduIndication);
  }
  if (m_N2SmInfoIsSet) {
    val[utility::conversions::to_string_t("n2SmInfo")] =
        ModelBase::toJson(m_N2SmInfo);
  }
  if (m_SmContextRefIsSet) {
    val[utility::conversions::to_string_t("smContextRef")] =
        ModelBase::toJson(m_SmContextRef);
  }

  return val;
}

void SmContextCreateData::fromJson(const web::json::value& val) {
  if (val.has_field(utility::conversions::to_string_t("supi"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("supi"));
    if (!fieldValue.is_null()) {
      setSupi(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("unauthenticatedSupi"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("unauthenticatedSupi"));
    if (!fieldValue.is_null()) {
      setUnauthenticatedSupi(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pei"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pei"));
    if (!fieldValue.is_null()) {
      setPei(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("gpsi"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("gpsi"));
    if (!fieldValue.is_null()) {
      setGpsi(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pduSessionId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pduSessionId"));
    if (!fieldValue.is_null()) {
      setPduSessionId(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("dnn"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("dnn"));
    if (!fieldValue.is_null()) {
      setDnn(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("sNssai"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("sNssai"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromJson(fieldValue);
      setSNssai(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("hplmnSnssai"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("hplmnSnssai"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromJson(fieldValue);
      setHplmnSnssai(newItem);
    }
  }
  setServingNfId(ModelBase::stringFromJson(
      val.at(utility::conversions::to_string_t("servingNfId"))));
  if (val.has_field(utility::conversions::to_string_t("guami"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("guami"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Guami> newItem(new Guami());
      newItem->fromJson(fieldValue);
      setGuami(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("serviceName"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("serviceName"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<ServiceName> newItem(new ServiceName());
      newItem->fromJson(fieldValue);
      setServiceName(newItem);
    }
  }
  std::shared_ptr<PlmnId> newServingNetwork(new PlmnId());
  newServingNetwork->fromJson(
      val.at(utility::conversions::to_string_t("servingNetwork")));
  setServingNetwork(newServingNetwork);
  if (val.has_field(utility::conversions::to_string_t("requestType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("requestType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RequestType> newItem(new RequestType());
      newItem->fromJson(fieldValue);
      setRequestType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n1SmMsg"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n1SmMsg"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN1SmMsg(newItem);
    }
  }
  std::shared_ptr<AccessType> newAnType(new AccessType());
  newAnType->fromJson(val.at(utility::conversions::to_string_t("anType")));
  setAnType(newAnType);
  if (val.has_field(utility::conversions::to_string_t("secondAnType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("secondAnType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromJson(fieldValue);
      setSecondAnType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ratType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ratType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromJson(fieldValue);
      setRatType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("presenceInLadn"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("presenceInLadn"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<PresenceState> newItem(new PresenceState());
      newItem->fromJson(fieldValue);
      setPresenceInLadn(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setUeLocation(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueTimeZone"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueTimeZone"));
    if (!fieldValue.is_null()) {
      setUeTimeZone(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("addUeLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("addUeLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setAddUeLocation(newItem);
    }
  }
  setSmContextStatusUri(ModelBase::stringFromJson(
      val.at(utility::conversions::to_string_t("smContextStatusUri"))));
  if (val.has_field(utility::conversions::to_string_t("hSmfUri"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("hSmfUri"));
    if (!fieldValue.is_null()) {
      setHSmfUri(ModelBase::stringFromJson(fieldValue));
    }
  }
  {
    m_AdditionalHsmfUri.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("additionalHsmfUri"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("additionalHsmfUri"))
               .as_array()) {
        m_AdditionalHsmfUri.push_back(ModelBase::stringFromJson(item));
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("oldPduSessionId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("oldPduSessionId"));
    if (!fieldValue.is_null()) {
      setOldPduSessionId(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  {
    m_PduSessionsActivateList.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(
            utility::conversions::to_string_t("pduSessionsActivateList"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("pduSessionsActivateList"))
               .as_array()) {
        m_PduSessionsActivateList.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueEpsPdnConnection"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueEpsPdnConnection"));
    if (!fieldValue.is_null()) {
      setUeEpsPdnConnection(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("hoState"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("hoState"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<HoState> newItem(new HoState());
      newItem->fromJson(fieldValue);
      setHoState(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pcfId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pcfId"));
    if (!fieldValue.is_null()) {
      setPcfId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("nrfUri"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("nrfUri"));
    if (!fieldValue.is_null()) {
      setNrfUri(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("supportedFeatures"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("supportedFeatures"));
    if (!fieldValue.is_null()) {
      setSupportedFeatures(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("selMode"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("selMode"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<DnnSelectionMode> newItem(new DnnSelectionMode());
      newItem->fromJson(fieldValue);
      setSelMode(newItem);
    }
  }
  {
    m_BackupAmfInfo.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("backupAmfInfo"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("backupAmfInfo"))
               .as_array()) {
        if (item.is_null()) {
          m_BackupAmfInfo.push_back(std::shared_ptr<BackupAmfInfo>(nullptr));
        } else {
          std::shared_ptr<BackupAmfInfo> newItem(new BackupAmfInfo());
          newItem->fromJson(item);
          m_BackupAmfInfo.push_back(newItem);
        }
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("traceData"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("traceData"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<TraceData> newItem(new TraceData());
      newItem->fromJson(fieldValue);
      setTraceData(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("udmGroupId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("udmGroupId"));
    if (!fieldValue.is_null()) {
      setUdmGroupId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("routingIndicator"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("routingIndicator"));
    if (!fieldValue.is_null()) {
      setRoutingIndicator(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("epsInterworkingInd"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("epsInterworkingInd"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromJson(fieldValue);
      setEpsInterworkingInd(newItem);
    }
  }
  if (val.has_field(
          utility::conversions::to_string_t("indirectForwardingFlag"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("indirectForwardingFlag"));
    if (!fieldValue.is_null()) {
      setIndirectForwardingFlag(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("targetId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("targetId"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<NgRanTargetId> newItem(new NgRanTargetId());
      newItem->fromJson(fieldValue);
      setTargetId(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("epsBearerCtxStatus"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("epsBearerCtxStatus"));
    if (!fieldValue.is_null()) {
      setEpsBearerCtxStatus(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("cpCiotEnabled"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("cpCiotEnabled"));
    if (!fieldValue.is_null()) {
      setCpCiotEnabled(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("invokeNef"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("invokeNef"));
    if (!fieldValue.is_null()) {
      setInvokeNef(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("maPduIndication"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("maPduIndication"));
    if (!fieldValue.is_null()) {
      setMaPduIndication(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n2SmInfo"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n2SmInfo"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN2SmInfo(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("smContextRef"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("smContextRef"));
    if (!fieldValue.is_null()) {
      setSmContextRef(ModelBase::stringFromJson(fieldValue));
    }
  }
}

void SmContextCreateData::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  nlohmann::json pdu_session_establishment_request;
  pdu_session_establishment_request["supi"]          = "imsi-200000000000001";
  pdu_session_establishment_request["pei"]           = "imei-200000000000001";
  pdu_session_establishment_request["gpsi"]          = "msisdn-200000000001";
  pdu_session_establishment_request["dnn"]           = "carrier.com";
  pdu_session_establishment_request["sNssai"]["sst"] = 222;
  pdu_session_establishment_request["sNssai"]["sd"]  = "0000D4";
  pdu_session_establishment_request["pduSessionId"]  = 1;
  pdu_session_establishment_request["requestType"]   = "INITIAL_REQUEST";
  pdu_session_establishment_request["servingNfId"]   = "servingNfId";
  pdu_session_establishment_request["servingNetwork"]["mcc"] = "234";
  pdu_session_establishment_request["servingNetwork"]["mnc"] = "067";
  pdu_session_establishment_request["anType"]                = "3GPP_ACCESS";
  pdu_session_establishment_request["smContextStatusUri"] =
      "smContextStatusUri";
  pdu_session_establishment_request["n1MessageContainer"]["n1MessageClass"] =
      "SM";
  pdu_session_establishment_request["n1MessageContainer"]["n1MessageContent"]
                                   ["contentId"] = "n1SmMsg";  // part 2
  std::string json_part = pdu_session_establishment_request.dump();

  std::shared_ptr<HttpContent> jsonData(new HttpContent);
  // jsonData->setName(prefix);
  // jsonData->setContentDisposition("form-data");
  jsonData->setContentType("application/json");
  std::string value = "";
  // value += "{" + "\"supi\":\"SUPI\", " + "\"pei\":\"PEI\"" + "}";
  value = "{\"supi\":\"SUPI\", \"pei\":\"PEI\",";
  std::string n1sm =
      "\"n1MessageContainer\":{\"n1MessageClass\":\"SM\", "
      "\"n1MessageContent\":{\"contentId\":\"n1SmMsg\"}}";
  value += n1sm;
  std::string ngsId = ", \"servingNfId\":\"servingNfId\"";
  value += ngsId;
  // std::string sn = ", \"servingNetwork\":{\"mcc\":\"460\", \"mnc\":\"011\"}";
  std::string sn = ", \"servingNetwork\":{\"mcc\":\"110\", \"mnc\":\"011\"}";
  value += sn;
  std::string anType = ", \"anType\":\"3GPP_ACCESS\"";
  value += anType;
  std::string uri = ", \"smContextStatusUri\":\"smContextStatusUri\"";
  value += "}";
  std::cout << "ERRO" << std::endl;
  std::cout << value.c_str() << std::endl;
  jsonData->setData(std::shared_ptr<std::istream>(
      new std::stringstream(utility::conversions::to_utf8string(json_part))));
  multipart->add(jsonData);

  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  if (m_SupiIsSet) {
    ////multipart->add(ModelBase::toHttpContent(namePrefix +
    /// utility::conversions::to_string_t("supi"), m_Supi));
  }
  if (m_UnauthenticatedSupiIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("unauthenticatedSupi"),
    // m_UnauthenticatedSupi));
  }
  if (m_PeiIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("pei"), m_Pei));
  }
  if (m_GpsiIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("gpsi"), m_Gpsi));
  }
  if (m_PduSessionIdIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("pduSessionId"), m_PduSessionId));
  }
  if (m_DnnIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("dnn"), m_Dnn));
  }
  if (m_SNssaiIsSet) {
    if (m_SNssai.get()) {
      // m_SNssai->toMultipart(multipart,
      // utility::conversions::to_string_t("sNssai."));
    }
  }
  if (m_HplmnSnssaiIsSet) {
    if (m_HplmnSnssai.get()) {
      // m_HplmnSnssai->toMultipart(multipart,
      // utility::conversions::to_string_t("hplmnSnssai."));
    }
  }
  // multipart->add(ModelBase::toHttpContent(namePrefix +
  // utility::conversions::to_string_t("servingNfId"), m_ServingNfId));
  if (m_GuamiIsSet) {
    if (m_Guami.get()) {
      // m_Guami->toMultipart(multipart,
      // utility::conversions::to_string_t("guami."));
    }
  }
  if (m_ServiceNameIsSet) {
    if (m_ServiceName.get()) {
      // m_ServiceName->toMultipart(multipart,
      // utility::conversions::to_string_t("serviceName."));
    }
  }
  // m_ServingNetwork->toMultipart(multipart,
  // utility::conversions::to_string_t("servingNetwork."));
  if (m_RequestTypeIsSet) {
    if (m_RequestType.get()) {
      // m_RequestType->toMultipart(multipart,
      // utility::conversions::to_string_t("requestType."));
    }
  }
  if (m_N1SmMsgIsSet) {
    if (m_N1SmMsg.get()) {
      // m_N1SmMsg->toMultipart(multipart,
      // utility::conversions::to_string_t("n1SmMsg."));
    }
  }
  // m_AnType->toMultipart(multipart,
  // utility::conversions::to_string_t("anType."));
  if (m_SecondAnTypeIsSet) {
    if (m_SecondAnType.get()) {
      // m_SecondAnType->toMultipart(multipart,
      // utility::conversions::to_string_t("secondAnType."));
    }
  }
  if (m_RatTypeIsSet) {
    if (m_RatType.get()) {
      // m_RatType->toMultipart(multipart,
      // utility::conversions::to_string_t("ratType."));
    }
  }
  if (m_PresenceInLadnIsSet) {
    if (m_PresenceInLadn.get()) {
      // m_PresenceInLadn->toMultipart(multipart,
      // utility::conversions::to_string_t("presenceInLadn."));
    }
  }
  if (m_UeLocationIsSet) {
    if (m_UeLocation.get()) {
      // m_UeLocation->toMultipart(multipart,
      // utility::conversions::to_string_t("ueLocation."));
    }
  }
  if (m_UeTimeZoneIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("ueTimeZone"), m_UeTimeZone));
  }
  if (m_AddUeLocationIsSet) {
    if (m_AddUeLocation.get()) {
      // m_AddUeLocation->toMultipart(multipart,
      // utility::conversions::to_string_t("addUeLocation."));
    }
  }
  // multipart->add(ModelBase::toHttpContent(namePrefix +
  // utility::conversions::to_string_t("smContextStatusUri"),
  // m_SmContextStatusUri));
  if (m_HSmfUriIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("hSmfUri"), m_HSmfUri));
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_AdditionalHsmfUri) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      // multipart->add(ModelBase::toHttpContent(namePrefix +
      // utility::conversions::to_string_t("additionalHsmfUri"),
      // web::json::value::array(jsonArray),
      // utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_OldPduSessionIdIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("oldPduSessionId"),
    // m_OldPduSessionId));
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_PduSessionsActivateList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      // multipart->add(ModelBase::toHttpContent(namePrefix +
      // utility::conversions::to_string_t("pduSessionsActivateList"),
      // web::json::value::array(jsonArray),
      // utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_UeEpsPdnConnectionIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("ueEpsPdnConnection"),
    // m_UeEpsPdnConnection));
  }
  if (m_HoStateIsSet) {
    if (m_HoState.get()) {
      // m_HoState->toMultipart(multipart,
      // utility::conversions::to_string_t("hoState."));
    }
  }
  if (m_PcfIdIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("pcfId"), m_PcfId));
  }
  if (m_NrfUriIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("nrfUri"), m_NrfUri));
  }
  if (m_SupportedFeaturesIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("supportedFeatures"),
    // m_SupportedFeatures));
  }
  if (m_SelModeIsSet) {
    if (m_SelMode.get()) {
      // m_SelMode->toMultipart(multipart,
      // utility::conversions::to_string_t("selMode."));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_BackupAmfInfo) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      // multipart->add(ModelBase::toHttpContent(namePrefix +
      // utility::conversions::to_string_t("backupAmfInfo"),
      // web::json::value::array(jsonArray),
      // utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_TraceDataIsSet) {
    if (m_TraceData.get()) {
      // m_TraceData->toMultipart(multipart,
      // utility::conversions::to_string_t("traceData."));
    }
  }
  if (m_UdmGroupIdIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("udmGroupId"), m_UdmGroupId));
  }
  if (m_RoutingIndicatorIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("routingIndicator"),
    // m_RoutingIndicator));
  }
  if (m_EpsInterworkingIndIsSet) {
    if (m_EpsInterworkingInd.get()) {
      // m_EpsInterworkingInd->toMultipart(multipart,
      // utility::conversions::to_string_t("epsInterworkingInd."));
    }
  }
  if (m_IndirectForwardingFlagIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("indirectForwardingFlag"),
    // m_IndirectForwardingFlag));
  }
  if (m_TargetIdIsSet) {
    if (m_TargetId.get()) {
      // m_TargetId->toMultipart(multipart,
      // utility::conversions::to_string_t("targetId."));
    }
  }
  if (m_EpsBearerCtxStatusIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("epsBearerCtxStatus"),
    // m_EpsBearerCtxStatus));
  }
  if (m_CpCiotEnabledIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("cpCiotEnabled"), m_CpCiotEnabled));
  }
  if (m_InvokeNefIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("invokeNef"), m_InvokeNef));
  }
  if (m_MaPduIndicationIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("maPduIndication"),
    // m_MaPduIndication));
  }
  if (m_N2SmInfoIsSet) {
    if (m_N2SmInfo.get()) {
      // m_N2SmInfo->toMultipart(multipart,
      // utility::conversions::to_string_t("n2SmInfo."));
    }
  }
  if (m_SmContextRefIsSet) {
    // multipart->add(ModelBase::toHttpContent(namePrefix +
    // utility::conversions::to_string_t("smContextRef"), m_SmContextRef));
  }
}

void SmContextCreateData::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  if (multipart->hasContent(utility::conversions::to_string_t("supi"))) {
    setSupi(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("supi"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("unauthenticatedSupi"))) {
    setUnauthenticatedSupi(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("unauthenticatedSupi"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("pei"))) {
    setPei(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("pei"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("gpsi"))) {
    setGpsi(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("gpsi"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("pduSessionId"))) {
    setPduSessionId(ModelBase::int32_tFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("pduSessionId"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("dnn"))) {
    setDnn(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("dnn"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("sNssai"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("sNssai"))) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("sNssai."));
      setSNssai(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("hplmnSnssai"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("hplmnSnssai"))) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("hplmnSnssai."));
      setHplmnSnssai(newItem);
    }
  }
  setServingNfId(ModelBase::stringFromHttpContent(
      multipart->getContent(utility::conversions::to_string_t("servingNfId"))));
  if (multipart->hasContent(utility::conversions::to_string_t("guami"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("guami"))) {
      std::shared_ptr<Guami> newItem(new Guami());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("guami."));
      setGuami(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("serviceName"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("serviceName"))) {
      std::shared_ptr<ServiceName> newItem(new ServiceName());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("serviceName."));
      setServiceName(newItem);
    }
  }
  std::shared_ptr<PlmnId> newServingNetwork(new PlmnId());
  newServingNetwork->fromMultiPart(
      multipart, utility::conversions::to_string_t("servingNetwork."));
  setServingNetwork(newServingNetwork);
  if (multipart->hasContent(utility::conversions::to_string_t("requestType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("requestType"))) {
      std::shared_ptr<RequestType> newItem(new RequestType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("requestType."));
      setRequestType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("n1SmMsg"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("n1SmMsg"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n1SmMsg."));
      setN1SmMsg(newItem);
    }
  }
  std::shared_ptr<AccessType> newAnType(new AccessType());
  newAnType->fromMultiPart(
      multipart, utility::conversions::to_string_t("anType."));
  setAnType(newAnType);
  if (multipart->hasContent(
          utility::conversions::to_string_t("secondAnType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("secondAnType"))) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("secondAnType."));
      setSecondAnType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ratType."));
      setRatType(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("presenceInLadn"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("presenceInLadn"))) {
      std::shared_ptr<PresenceState> newItem(new PresenceState());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("presenceInLadn."));
      setPresenceInLadn(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("ueLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ueLocation."));
      setUeLocation(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueTimeZone"))) {
    setUeTimeZone(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("ueTimeZone"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("addUeLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("addUeLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("addUeLocation."));
      setAddUeLocation(newItem);
    }
  }
  setSmContextStatusUri(ModelBase::stringFromHttpContent(multipart->getContent(
      utility::conversions::to_string_t("smContextStatusUri"))));
  if (multipart->hasContent(utility::conversions::to_string_t("hSmfUri"))) {
    setHSmfUri(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("hSmfUri"))));
  }
  {
    m_AdditionalHsmfUri.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("additionalHsmfUri"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("additionalHsmfUri"))));
      for (auto& item : jsonArray.as_array()) {
        m_AdditionalHsmfUri.push_back(ModelBase::stringFromJson(item));
      }
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("oldPduSessionId"))) {
    setOldPduSessionId(ModelBase::int32_tFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("oldPduSessionId"))));
  }
  {
    m_PduSessionsActivateList.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("pduSessionsActivateList"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("pduSessionsActivateList"))));
      for (auto& item : jsonArray.as_array()) {
        m_PduSessionsActivateList.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("ueEpsPdnConnection"))) {
    setUeEpsPdnConnection(
        ModelBase::stringFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("ueEpsPdnConnection"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("hoState"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("hoState"))) {
      std::shared_ptr<HoState> newItem(new HoState());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("hoState."));
      setHoState(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("pcfId"))) {
    setPcfId(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("pcfId"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("nrfUri"))) {
    setNrfUri(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("nrfUri"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("supportedFeatures"))) {
    setSupportedFeatures(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("supportedFeatures"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("selMode"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("selMode"))) {
      std::shared_ptr<DnnSelectionMode> newItem(new DnnSelectionMode());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("selMode."));
      setSelMode(newItem);
    }
  }
  {
    m_BackupAmfInfo.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("backupAmfInfo"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("backupAmfInfo"))));
      for (auto& item : jsonArray.as_array()) {
        if (item.is_null()) {
          m_BackupAmfInfo.push_back(std::shared_ptr<BackupAmfInfo>(nullptr));
        } else {
          std::shared_ptr<BackupAmfInfo> newItem(new BackupAmfInfo());
          newItem->fromJson(item);
          m_BackupAmfInfo.push_back(newItem);
        }
      }
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("traceData"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("traceData"))) {
      std::shared_ptr<TraceData> newItem(new TraceData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("traceData."));
      setTraceData(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("udmGroupId"))) {
    setUdmGroupId(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("udmGroupId"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("routingIndicator"))) {
    setRoutingIndicator(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("routingIndicator"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("epsInterworkingInd"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("epsInterworkingInd"))) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("epsInterworkingInd."));
      setEpsInterworkingInd(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("indirectForwardingFlag"))) {
    setIndirectForwardingFlag(
        ModelBase::boolFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("indirectForwardingFlag"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("targetId"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("targetId"))) {
      std::shared_ptr<NgRanTargetId> newItem(new NgRanTargetId());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("targetId."));
      setTargetId(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("epsBearerCtxStatus"))) {
    setEpsBearerCtxStatus(
        ModelBase::stringFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("epsBearerCtxStatus"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("cpCiotEnabled"))) {
    setCpCiotEnabled(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("cpCiotEnabled"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("invokeNef"))) {
    setInvokeNef(ModelBase::boolFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("invokeNef"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("maPduIndication"))) {
    setMaPduIndication(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("maPduIndication"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("n2SmInfo"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("n2SmInfo"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n2SmInfo."));
      setN2SmInfo(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("smContextRef"))) {
    setSmContextRef(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("smContextRef"))));
  }
}

utility::string_t SmContextCreateData::getSupi() const {
  return m_Supi;
}

void SmContextCreateData::setSupi(const utility::string_t& value) {
  m_Supi      = value;
  m_SupiIsSet = true;
}

bool SmContextCreateData::supiIsSet() const {
  return m_SupiIsSet;
}

void SmContextCreateData::unsetSupi() {
  m_SupiIsSet = false;
}

bool SmContextCreateData::isUnauthenticatedSupi() const {
  return m_UnauthenticatedSupi;
}

void SmContextCreateData::setUnauthenticatedSupi(bool value) {
  m_UnauthenticatedSupi      = value;
  m_UnauthenticatedSupiIsSet = true;
}

bool SmContextCreateData::unauthenticatedSupiIsSet() const {
  return m_UnauthenticatedSupiIsSet;
}

void SmContextCreateData::unsetUnauthenticatedSupi() {
  m_UnauthenticatedSupiIsSet = false;
}

utility::string_t SmContextCreateData::getPei() const {
  return m_Pei;
}

void SmContextCreateData::setPei(const utility::string_t& value) {
  m_Pei      = value;
  m_PeiIsSet = true;
}

bool SmContextCreateData::peiIsSet() const {
  return m_PeiIsSet;
}

void SmContextCreateData::unsetPei() {
  m_PeiIsSet = false;
}

utility::string_t SmContextCreateData::getGpsi() const {
  return m_Gpsi;
}

void SmContextCreateData::setGpsi(const utility::string_t& value) {
  m_Gpsi      = value;
  m_GpsiIsSet = true;
}

bool SmContextCreateData::gpsiIsSet() const {
  return m_GpsiIsSet;
}

void SmContextCreateData::unsetGpsi() {
  m_GpsiIsSet = false;
}

int32_t SmContextCreateData::getPduSessionId() const {
  return m_PduSessionId;
}

void SmContextCreateData::setPduSessionId(int32_t value) {
  m_PduSessionId      = value;
  m_PduSessionIdIsSet = true;
}

bool SmContextCreateData::pduSessionIdIsSet() const {
  return m_PduSessionIdIsSet;
}

void SmContextCreateData::unsetPduSessionId() {
  m_PduSessionIdIsSet = false;
}

utility::string_t SmContextCreateData::getDnn() const {
  return m_Dnn;
}

void SmContextCreateData::setDnn(const utility::string_t& value) {
  m_Dnn      = value;
  m_DnnIsSet = true;
}

bool SmContextCreateData::dnnIsSet() const {
  return m_DnnIsSet;
}

void SmContextCreateData::unsetDnn() {
  m_DnnIsSet = false;
}

std::shared_ptr<Snssai> SmContextCreateData::getSNssai() const {
  return m_SNssai;
}

void SmContextCreateData::setSNssai(const std::shared_ptr<Snssai>& value) {
  m_SNssai      = value;
  m_SNssaiIsSet = true;
}

bool SmContextCreateData::sNssaiIsSet() const {
  return m_SNssaiIsSet;
}

void SmContextCreateData::unsetSNssai() {
  m_SNssaiIsSet = false;
}

std::shared_ptr<Snssai> SmContextCreateData::getHplmnSnssai() const {
  return m_HplmnSnssai;
}

void SmContextCreateData::setHplmnSnssai(const std::shared_ptr<Snssai>& value) {
  m_HplmnSnssai      = value;
  m_HplmnSnssaiIsSet = true;
}

bool SmContextCreateData::hplmnSnssaiIsSet() const {
  return m_HplmnSnssaiIsSet;
}

void SmContextCreateData::unsetHplmnSnssai() {
  m_HplmnSnssaiIsSet = false;
}

utility::string_t SmContextCreateData::getServingNfId() const {
  return m_ServingNfId;
}

void SmContextCreateData::setServingNfId(const utility::string_t& value) {
  m_ServingNfId = value;
}

std::shared_ptr<Guami> SmContextCreateData::getGuami() const {
  return m_Guami;
}

void SmContextCreateData::setGuami(const std::shared_ptr<Guami>& value) {
  m_Guami      = value;
  m_GuamiIsSet = true;
}

bool SmContextCreateData::guamiIsSet() const {
  return m_GuamiIsSet;
}

void SmContextCreateData::unsetGuami() {
  m_GuamiIsSet = false;
}

std::shared_ptr<ServiceName> SmContextCreateData::getServiceName() const {
  return m_ServiceName;
}

void SmContextCreateData::setServiceName(
    const std::shared_ptr<ServiceName>& value) {
  m_ServiceName      = value;
  m_ServiceNameIsSet = true;
}

bool SmContextCreateData::serviceNameIsSet() const {
  return m_ServiceNameIsSet;
}

void SmContextCreateData::unsetServiceName() {
  m_ServiceNameIsSet = false;
}

std::shared_ptr<PlmnId> SmContextCreateData::getServingNetwork() const {
  return m_ServingNetwork;
}

void SmContextCreateData::setServingNetwork(
    const std::shared_ptr<PlmnId>& value) {
  m_ServingNetwork = value;
}

std::shared_ptr<RequestType> SmContextCreateData::getRequestType() const {
  return m_RequestType;
}

void SmContextCreateData::setRequestType(
    const std::shared_ptr<RequestType>& value) {
  m_RequestType      = value;
  m_RequestTypeIsSet = true;
}

bool SmContextCreateData::requestTypeIsSet() const {
  return m_RequestTypeIsSet;
}

void SmContextCreateData::unsetRequestType() {
  m_RequestTypeIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextCreateData::getN1SmMsg() const {
  return m_N1SmMsg;
}

void SmContextCreateData::setN1SmMsg(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N1SmMsg      = value;
  m_N1SmMsgIsSet = true;
}

bool SmContextCreateData::n1SmMsgIsSet() const {
  return m_N1SmMsgIsSet;
}

void SmContextCreateData::unsetN1SmMsg() {
  m_N1SmMsgIsSet = false;
}

std::shared_ptr<AccessType> SmContextCreateData::getAnType() const {
  return m_AnType;
}

void SmContextCreateData::setAnType(const std::shared_ptr<AccessType>& value) {
  m_AnType = value;
}

std::shared_ptr<AccessType> SmContextCreateData::getSecondAnType() const {
  return m_SecondAnType;
}

void SmContextCreateData::setSecondAnType(
    const std::shared_ptr<AccessType>& value) {
  m_SecondAnType      = value;
  m_SecondAnTypeIsSet = true;
}

bool SmContextCreateData::secondAnTypeIsSet() const {
  return m_SecondAnTypeIsSet;
}

void SmContextCreateData::unsetSecondAnType() {
  m_SecondAnTypeIsSet = false;
}

std::shared_ptr<RatType> SmContextCreateData::getRatType() const {
  return m_RatType;
}

void SmContextCreateData::setRatType(const std::shared_ptr<RatType>& value) {
  m_RatType      = value;
  m_RatTypeIsSet = true;
}

bool SmContextCreateData::ratTypeIsSet() const {
  return m_RatTypeIsSet;
}

void SmContextCreateData::unsetRatType() {
  m_RatTypeIsSet = false;
}

std::shared_ptr<PresenceState> SmContextCreateData::getPresenceInLadn() const {
  return m_PresenceInLadn;
}

void SmContextCreateData::setPresenceInLadn(
    const std::shared_ptr<PresenceState>& value) {
  m_PresenceInLadn      = value;
  m_PresenceInLadnIsSet = true;
}

bool SmContextCreateData::presenceInLadnIsSet() const {
  return m_PresenceInLadnIsSet;
}

void SmContextCreateData::unsetPresenceInLadn() {
  m_PresenceInLadnIsSet = false;
}

std::shared_ptr<UserLocation> SmContextCreateData::getUeLocation() const {
  return m_UeLocation;
}

void SmContextCreateData::setUeLocation(
    const std::shared_ptr<UserLocation>& value) {
  m_UeLocation      = value;
  m_UeLocationIsSet = true;
}

bool SmContextCreateData::ueLocationIsSet() const {
  return m_UeLocationIsSet;
}

void SmContextCreateData::unsetUeLocation() {
  m_UeLocationIsSet = false;
}

utility::string_t SmContextCreateData::getUeTimeZone() const {
  return m_UeTimeZone;
}

void SmContextCreateData::setUeTimeZone(const utility::string_t& value) {
  m_UeTimeZone      = value;
  m_UeTimeZoneIsSet = true;
}

bool SmContextCreateData::ueTimeZoneIsSet() const {
  return m_UeTimeZoneIsSet;
}

void SmContextCreateData::unsetUeTimeZone() {
  m_UeTimeZoneIsSet = false;
}

std::shared_ptr<UserLocation> SmContextCreateData::getAddUeLocation() const {
  return m_AddUeLocation;
}

void SmContextCreateData::setAddUeLocation(
    const std::shared_ptr<UserLocation>& value) {
  m_AddUeLocation      = value;
  m_AddUeLocationIsSet = true;
}

bool SmContextCreateData::addUeLocationIsSet() const {
  return m_AddUeLocationIsSet;
}

void SmContextCreateData::unsetAddUeLocation() {
  m_AddUeLocationIsSet = false;
}

utility::string_t SmContextCreateData::getSmContextStatusUri() const {
  return m_SmContextStatusUri;
}

void SmContextCreateData::setSmContextStatusUri(
    const utility::string_t& value) {
  m_SmContextStatusUri = value;
}

utility::string_t SmContextCreateData::getHSmfUri() const {
  return m_HSmfUri;
}

void SmContextCreateData::setHSmfUri(const utility::string_t& value) {
  m_HSmfUri      = value;
  m_HSmfUriIsSet = true;
}

bool SmContextCreateData::hSmfUriIsSet() const {
  return m_HSmfUriIsSet;
}

void SmContextCreateData::unsetHSmfUri() {
  m_HSmfUriIsSet = false;
}

std::vector<utility::string_t>& SmContextCreateData::getAdditionalHsmfUri() {
  return m_AdditionalHsmfUri;
}

void SmContextCreateData::setAdditionalHsmfUri(
    const std::vector<utility::string_t>& value) {
  m_AdditionalHsmfUri      = value;
  m_AdditionalHsmfUriIsSet = true;
}

bool SmContextCreateData::additionalHsmfUriIsSet() const {
  return m_AdditionalHsmfUriIsSet;
}

void SmContextCreateData::unsetAdditionalHsmfUri() {
  m_AdditionalHsmfUriIsSet = false;
}

int32_t SmContextCreateData::getOldPduSessionId() const {
  return m_OldPduSessionId;
}

void SmContextCreateData::setOldPduSessionId(int32_t value) {
  m_OldPduSessionId      = value;
  m_OldPduSessionIdIsSet = true;
}

bool SmContextCreateData::oldPduSessionIdIsSet() const {
  return m_OldPduSessionIdIsSet;
}

void SmContextCreateData::unsetOldPduSessionId() {
  m_OldPduSessionIdIsSet = false;
}

std::vector<int32_t>& SmContextCreateData::getPduSessionsActivateList() {
  return m_PduSessionsActivateList;
}

void SmContextCreateData::setPduSessionsActivateList(
    std::vector<int32_t> value) {
  m_PduSessionsActivateList      = value;
  m_PduSessionsActivateListIsSet = true;
}

bool SmContextCreateData::pduSessionsActivateListIsSet() const {
  return m_PduSessionsActivateListIsSet;
}

void SmContextCreateData::unsetPduSessionsActivateList() {
  m_PduSessionsActivateListIsSet = false;
}

utility::string_t SmContextCreateData::getUeEpsPdnConnection() const {
  return m_UeEpsPdnConnection;
}

void SmContextCreateData::setUeEpsPdnConnection(
    const utility::string_t& value) {
  m_UeEpsPdnConnection      = value;
  m_UeEpsPdnConnectionIsSet = true;
}

bool SmContextCreateData::ueEpsPdnConnectionIsSet() const {
  return m_UeEpsPdnConnectionIsSet;
}

void SmContextCreateData::unsetUeEpsPdnConnection() {
  m_UeEpsPdnConnectionIsSet = false;
}

std::shared_ptr<HoState> SmContextCreateData::getHoState() const {
  return m_HoState;
}

void SmContextCreateData::setHoState(const std::shared_ptr<HoState>& value) {
  m_HoState      = value;
  m_HoStateIsSet = true;
}

bool SmContextCreateData::hoStateIsSet() const {
  return m_HoStateIsSet;
}

void SmContextCreateData::unsetHoState() {
  m_HoStateIsSet = false;
}

utility::string_t SmContextCreateData::getPcfId() const {
  return m_PcfId;
}

void SmContextCreateData::setPcfId(const utility::string_t& value) {
  m_PcfId      = value;
  m_PcfIdIsSet = true;
}

bool SmContextCreateData::pcfIdIsSet() const {
  return m_PcfIdIsSet;
}

void SmContextCreateData::unsetPcfId() {
  m_PcfIdIsSet = false;
}

utility::string_t SmContextCreateData::getNrfUri() const {
  return m_NrfUri;
}

void SmContextCreateData::setNrfUri(const utility::string_t& value) {
  m_NrfUri      = value;
  m_NrfUriIsSet = true;
}

bool SmContextCreateData::nrfUriIsSet() const {
  return m_NrfUriIsSet;
}

void SmContextCreateData::unsetNrfUri() {
  m_NrfUriIsSet = false;
}

utility::string_t SmContextCreateData::getSupportedFeatures() const {
  return m_SupportedFeatures;
}

void SmContextCreateData::setSupportedFeatures(const utility::string_t& value) {
  m_SupportedFeatures      = value;
  m_SupportedFeaturesIsSet = true;
}

bool SmContextCreateData::supportedFeaturesIsSet() const {
  return m_SupportedFeaturesIsSet;
}

void SmContextCreateData::unsetSupportedFeatures() {
  m_SupportedFeaturesIsSet = false;
}

std::shared_ptr<DnnSelectionMode> SmContextCreateData::getSelMode() const {
  return m_SelMode;
}

void SmContextCreateData::setSelMode(
    const std::shared_ptr<DnnSelectionMode>& value) {
  m_SelMode      = value;
  m_SelModeIsSet = true;
}

bool SmContextCreateData::selModeIsSet() const {
  return m_SelModeIsSet;
}

void SmContextCreateData::unsetSelMode() {
  m_SelModeIsSet = false;
}

std::vector<std::shared_ptr<BackupAmfInfo>>&
SmContextCreateData::getBackupAmfInfo() {
  return m_BackupAmfInfo;
}

void SmContextCreateData::setBackupAmfInfo(
    const std::vector<std::shared_ptr<BackupAmfInfo>>& value) {
  m_BackupAmfInfo      = value;
  m_BackupAmfInfoIsSet = true;
}

bool SmContextCreateData::backupAmfInfoIsSet() const {
  return m_BackupAmfInfoIsSet;
}

void SmContextCreateData::unsetBackupAmfInfo() {
  m_BackupAmfInfoIsSet = false;
}

std::shared_ptr<TraceData> SmContextCreateData::getTraceData() const {
  return m_TraceData;
}

void SmContextCreateData::setTraceData(
    const std::shared_ptr<TraceData>& value) {
  m_TraceData      = value;
  m_TraceDataIsSet = true;
}

bool SmContextCreateData::traceDataIsSet() const {
  return m_TraceDataIsSet;
}

void SmContextCreateData::unsetTraceData() {
  m_TraceDataIsSet = false;
}

utility::string_t SmContextCreateData::getUdmGroupId() const {
  return m_UdmGroupId;
}

void SmContextCreateData::setUdmGroupId(const utility::string_t& value) {
  m_UdmGroupId      = value;
  m_UdmGroupIdIsSet = true;
}

bool SmContextCreateData::udmGroupIdIsSet() const {
  return m_UdmGroupIdIsSet;
}

void SmContextCreateData::unsetUdmGroupId() {
  m_UdmGroupIdIsSet = false;
}

utility::string_t SmContextCreateData::getRoutingIndicator() const {
  return m_RoutingIndicator;
}

void SmContextCreateData::setRoutingIndicator(const utility::string_t& value) {
  m_RoutingIndicator      = value;
  m_RoutingIndicatorIsSet = true;
}

bool SmContextCreateData::routingIndicatorIsSet() const {
  return m_RoutingIndicatorIsSet;
}

void SmContextCreateData::unsetRoutingIndicator() {
  m_RoutingIndicatorIsSet = false;
}

std::shared_ptr<EpsInterworkingIndication>
SmContextCreateData::getEpsInterworkingInd() const {
  return m_EpsInterworkingInd;
}

void SmContextCreateData::setEpsInterworkingInd(
    const std::shared_ptr<EpsInterworkingIndication>& value) {
  m_EpsInterworkingInd      = value;
  m_EpsInterworkingIndIsSet = true;
}

bool SmContextCreateData::epsInterworkingIndIsSet() const {
  return m_EpsInterworkingIndIsSet;
}

void SmContextCreateData::unsetEpsInterworkingInd() {
  m_EpsInterworkingIndIsSet = false;
}

bool SmContextCreateData::isIndirectForwardingFlag() const {
  return m_IndirectForwardingFlag;
}

void SmContextCreateData::setIndirectForwardingFlag(bool value) {
  m_IndirectForwardingFlag      = value;
  m_IndirectForwardingFlagIsSet = true;
}

bool SmContextCreateData::indirectForwardingFlagIsSet() const {
  return m_IndirectForwardingFlagIsSet;
}

void SmContextCreateData::unsetIndirectForwardingFlag() {
  m_IndirectForwardingFlagIsSet = false;
}

std::shared_ptr<NgRanTargetId> SmContextCreateData::getTargetId() const {
  return m_TargetId;
}

void SmContextCreateData::setTargetId(
    const std::shared_ptr<NgRanTargetId>& value) {
  m_TargetId      = value;
  m_TargetIdIsSet = true;
}

bool SmContextCreateData::targetIdIsSet() const {
  return m_TargetIdIsSet;
}

void SmContextCreateData::unsetTargetId() {
  m_TargetIdIsSet = false;
}

utility::string_t SmContextCreateData::getEpsBearerCtxStatus() const {
  return m_EpsBearerCtxStatus;
}

void SmContextCreateData::setEpsBearerCtxStatus(
    const utility::string_t& value) {
  m_EpsBearerCtxStatus      = value;
  m_EpsBearerCtxStatusIsSet = true;
}

bool SmContextCreateData::epsBearerCtxStatusIsSet() const {
  return m_EpsBearerCtxStatusIsSet;
}

void SmContextCreateData::unsetEpsBearerCtxStatus() {
  m_EpsBearerCtxStatusIsSet = false;
}

bool SmContextCreateData::isCpCiotEnabled() const {
  return m_CpCiotEnabled;
}

void SmContextCreateData::setCpCiotEnabled(bool value) {
  m_CpCiotEnabled      = value;
  m_CpCiotEnabledIsSet = true;
}

bool SmContextCreateData::cpCiotEnabledIsSet() const {
  return m_CpCiotEnabledIsSet;
}

void SmContextCreateData::unsetCpCiotEnabled() {
  m_CpCiotEnabledIsSet = false;
}

bool SmContextCreateData::isInvokeNef() const {
  return m_InvokeNef;
}

void SmContextCreateData::setInvokeNef(bool value) {
  m_InvokeNef      = value;
  m_InvokeNefIsSet = true;
}

bool SmContextCreateData::invokeNefIsSet() const {
  return m_InvokeNefIsSet;
}

void SmContextCreateData::unsetInvokeNef() {
  m_InvokeNefIsSet = false;
}

bool SmContextCreateData::isMaPduIndication() const {
  return m_MaPduIndication;
}

void SmContextCreateData::setMaPduIndication(bool value) {
  m_MaPduIndication      = value;
  m_MaPduIndicationIsSet = true;
}

bool SmContextCreateData::maPduIndicationIsSet() const {
  return m_MaPduIndicationIsSet;
}

void SmContextCreateData::unsetMaPduIndication() {
  m_MaPduIndicationIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextCreateData::getN2SmInfo() const {
  return m_N2SmInfo;
}

void SmContextCreateData::setN2SmInfo(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N2SmInfo      = value;
  m_N2SmInfoIsSet = true;
}

bool SmContextCreateData::n2SmInfoIsSet() const {
  return m_N2SmInfoIsSet;
}

void SmContextCreateData::unsetN2SmInfo() {
  m_N2SmInfoIsSet = false;
}

utility::string_t SmContextCreateData::getSmContextRef() const {
  return m_SmContextRef;
}

void SmContextCreateData::setSmContextRef(const utility::string_t& value) {
  m_SmContextRef      = value;
  m_SmContextRefIsSet = true;
}

bool SmContextCreateData::smContextRefIsSet() const {
  return m_SmContextRefIsSet;
}

void SmContextCreateData::unsetSmContextRef() {
  m_SmContextRefIsSet = false;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
