# OpenXG-AMF



OpenXG-AMF Arch

├── build:         Build directory, contains targets and object files generated by compilation of network functions. 
    ├── log:       Directory containing build log files.
    ├── scripts:   Directory containing scripts for building network functions
    └── smf:       Directory containing CMakefile.txt and object files generated by compilation of AMF network function. 
├── etc:           Directory containing the configuration file to be deployed for AMF.
└── src:           Source files of AMF.
    ├── amf-app:   AMF Procedures handling logic. 
    ├── common:    Common definitions for 3GPP specifications.
    ├── contexts:  communication contexts used in the AMF. 
    ├── itti:      Inter task interface 
    ├── nas:       NAS protocol implememtation
    ├── ngap:      NGAP protocol implememtation
    ├── oai_amf:   AMF main directory, contains the "main" CMakeLists.txt file.
    ├── sbi:       AMF service endpoints and curl http client. 
    ├── sctp:      Build SCTP server.
    ├── secu_algorithms:   algorithms for 5G-AKA authentication procedures.
    ├── test:      Minimal implementation for AMF, UDM network functions for testing purpose.
    └── utils:     Common utilities.  .
    
## Download source code from Gitlab
git clone http://git.opensource5g.org/openxg/amf.git
cd amf/
git checkout master

## install dependencies
cd /amf/build/scripts
./build_amf -I -f
## build AMF
./build_amf -c -V -b Debug -j
## launch AMF
sudo amf -c etc/amf.conf -o