/*
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.1  (the "License"); you may not use this
 *file except in compliance with the License. You may obtain a copy of the
 *License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 *-------------------------------------------------------------------------------
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

/*! \file
 \brief
 \author  Keliang DU, BUPT
 \date 2020
 \email: contact@openairinterface.org
 */

#ifndef _UEIDENTITYINDEXVALUE_H_
#define _UEIDENTITYINDEXVALUE_H_

extern "C" {
#include "Ngap_UEIdentityIndexValue.h"
}

namespace ngap {

class UEIdentityIndexValue {
 public:
  UEIdentityIndexValue();
  virtual ~UEIdentityIndexValue();

  void setUEIdentityIndexValue(uint16_t m_indexLength10 /*10bits限制*/);
  void getUEIdentityIndexValue(uint16_t& m_indexLength10 /*10bits限制*/);

  bool encode2UEIdentityIndexValue(
      Ngap_UEIdentityIndexValue_t* ueIdentityIndexValue);
  bool decodefromUEIdentityIndexValue(
      Ngap_UEIdentityIndexValue_t* ueIdentityIndexValue);

 private:
  uint16_t indexLength10;
};

}  // namespace ngap

#endif
