/**
 * Namf_Communication
 * AMF Communication Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi.h"
#include "Helpers.h"

namespace oai {
namespace amf {
namespace api {

using namespace org::openapitools::server::helpers;
using namespace oai::amf::model;

N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi::
    N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi(
        std::shared_ptr<Pistache::Rest::Router> rtr) {
  router = rtr;
}

void N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi::init() {
  setupRoutes();
}

void N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi::
    setupRoutes() {
  using namespace Pistache::Rest;

  Routes::Post(
      *router, base + "/ue-contexts/:ueContextId/n1-n2-messages/subscriptions",
      Routes::bind(
          &N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi::
              n1_n2_message_subscribe_handler,
          this));

  // Default handler, called when a route is not found
  router->addCustomHandler(Routes::bind(
      &N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi::
          n1_n2_subscriptions_collection_for_individual_ue_contexts_document_api_default_handler,
      this));
}

void N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi::
    n1_n2_message_subscribe_handler(
        const Pistache::Rest::Request& request,
        Pistache::Http::ResponseWriter response) {
  // Getting the path params
  auto ueContextId = request.param(":ueContextId").as<std::string>();

  // Getting the body param

  UeN1N2InfoSubscriptionCreateData ueN1N2InfoSubscriptionCreateData;

  try {
    nlohmann::json::parse(request.body())
        .get_to(ueN1N2InfoSubscriptionCreateData);
    this->n1_n2_message_subscribe(
        ueContextId, ueN1N2InfoSubscriptionCreateData, response);
  } catch (nlohmann::detail::exception& e) {
    // send a 400 error
    response.send(Pistache::Http::Code::Bad_Request, e.what());
    return;
  } catch (std::exception& e) {
    // send a 500 error
    response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    return;
  }
}

void N1N2SubscriptionsCollectionForIndividualUEContextsDocumentApi::
    n1_n2_subscriptions_collection_for_individual_ue_contexts_document_api_default_handler(
        const Pistache::Rest::Request&,
        Pistache::Http::ResponseWriter response) {
  response.send(
      Pistache::Http::Code::Not_Found, "The requested method does not exist");
}

}  // namespace api
}  // namespace amf
}  // namespace oai
