/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "PduSessionCreateData.h"

namespace oai {
namespace smf {
namespace model {

PduSessionCreateData::PduSessionCreateData() {
  m_Supi                         = utility::conversions::to_string_t("");
  m_SupiIsSet                    = false;
  m_UnauthenticatedSupi          = false;
  m_UnauthenticatedSupiIsSet     = false;
  m_Pei                          = utility::conversions::to_string_t("");
  m_PeiIsSet                     = false;
  m_PduSessionId                 = 0;
  m_PduSessionIdIsSet            = false;
  m_Dnn                          = utility::conversions::to_string_t("");
  m_SNssaiIsSet                  = false;
  m_VsmfId                       = utility::conversions::to_string_t("");
  m_RequestTypeIsSet             = false;
  m_EpsBearerIdIsSet             = false;
  m_PgwS8cFteidIsSet             = false;
  m_VsmfPduSessionUri            = utility::conversions::to_string_t("");
  m_VcnTunnelInfoIsSet           = false;
  m_SecondAnTypeIsSet            = false;
  m_RatTypeIsSet                 = false;
  m_UeLocationIsSet              = false;
  m_UeTimeZone                   = utility::conversions::to_string_t("");
  m_UeTimeZoneIsSet              = false;
  m_AddUeLocationIsSet           = false;
  m_Gpsi                         = utility::conversions::to_string_t("");
  m_GpsiIsSet                    = false;
  m_N1SmInfoFromUeIsSet          = false;
  m_UnknownN1SmInfoIsSet         = false;
  m_SupportedFeatures            = utility::conversions::to_string_t("");
  m_SupportedFeaturesIsSet       = false;
  m_HPcfId                       = utility::conversions::to_string_t("");
  m_HPcfIdIsSet                  = false;
  m_HoPreparationIndication      = false;
  m_HoPreparationIndicationIsSet = false;
  m_SelModeIsSet                 = false;
  m_AlwaysOnRequested            = false;
  m_AlwaysOnRequestedIsSet       = false;
  m_UdmGroupId                   = utility::conversions::to_string_t("");
  m_UdmGroupIdIsSet              = false;
  m_RoutingIndicator             = utility::conversions::to_string_t("");
  m_RoutingIndicatorIsSet        = false;
  m_EpsInterworkingIndIsSet      = false;
  m_VSmfServiceInstanceId        = utility::conversions::to_string_t("");
  m_VSmfServiceInstanceIdIsSet   = false;
  m_RecoveryTime                 = utility::datetime();
  m_RecoveryTimeIsSet            = false;
  m_RoamingChargingProfileIsSet  = false;
  m_ChargingId                   = utility::conversions::to_string_t("");
  m_ChargingIdIsSet              = false;
  m_OldPduSessionId              = 0;
  m_OldPduSessionIdIsSet         = false;
  m_EpsBearerCtxStatus           = utility::conversions::to_string_t("");
  m_EpsBearerCtxStatusIsSet      = false;
  m_AmfNfId                      = utility::conversions::to_string_t("");
  m_AmfNfIdIsSet                 = false;
  m_GuamiIsSet                   = false;
  m_CpCiotEnabled                = false;
  m_CpCiotEnabledIsSet           = false;
  m_InvokeNef                    = false;
  m_InvokeNefIsSet               = false;
  m_MaPduIndication              = false;
  m_MaPduIndicationIsSet         = false;
}

PduSessionCreateData::~PduSessionCreateData() {}

void PduSessionCreateData::validate() {
  // TODO: implement validation
}

web::json::value PduSessionCreateData::toJson() const {
  web::json::value val = web::json::value::object();

  if (m_SupiIsSet) {
    val[utility::conversions::to_string_t("supi")] = ModelBase::toJson(m_Supi);
  }
  if (m_UnauthenticatedSupiIsSet) {
    val[utility::conversions::to_string_t("unauthenticatedSupi")] =
        ModelBase::toJson(m_UnauthenticatedSupi);
  }
  if (m_PeiIsSet) {
    val[utility::conversions::to_string_t("pei")] = ModelBase::toJson(m_Pei);
  }
  if (m_PduSessionIdIsSet) {
    val[utility::conversions::to_string_t("pduSessionId")] =
        ModelBase::toJson(m_PduSessionId);
  }
  val[utility::conversions::to_string_t("dnn")] = ModelBase::toJson(m_Dnn);
  if (m_SNssaiIsSet) {
    val[utility::conversions::to_string_t("sNssai")] =
        ModelBase::toJson(m_SNssai);
  }
  val[utility::conversions::to_string_t("vsmfId")] =
      ModelBase::toJson(m_VsmfId);
  val[utility::conversions::to_string_t("servingNetwork")] =
      ModelBase::toJson(m_ServingNetwork);
  if (m_RequestTypeIsSet) {
    val[utility::conversions::to_string_t("requestType")] =
        ModelBase::toJson(m_RequestType);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_EpsBearerId) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("epsBearerId")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_PgwS8cFteidIsSet) {
    val[utility::conversions::to_string_t("pgwS8cFteid")] =
        ModelBase::toJson(m_PgwS8cFteid);
  }
  val[utility::conversions::to_string_t("vsmfPduSessionUri")] =
      ModelBase::toJson(m_VsmfPduSessionUri);
  if (m_VcnTunnelInfoIsSet) {
    val[utility::conversions::to_string_t("vcnTunnelInfo")] =
        ModelBase::toJson(m_VcnTunnelInfo);
  }
  val[utility::conversions::to_string_t("anType")] =
      ModelBase::toJson(m_AnType);
  if (m_SecondAnTypeIsSet) {
    val[utility::conversions::to_string_t("secondAnType")] =
        ModelBase::toJson(m_SecondAnType);
  }
  if (m_RatTypeIsSet) {
    val[utility::conversions::to_string_t("ratType")] =
        ModelBase::toJson(m_RatType);
  }
  if (m_UeLocationIsSet) {
    val[utility::conversions::to_string_t("ueLocation")] =
        ModelBase::toJson(m_UeLocation);
  }
  if (m_UeTimeZoneIsSet) {
    val[utility::conversions::to_string_t("ueTimeZone")] =
        ModelBase::toJson(m_UeTimeZone);
  }
  if (m_AddUeLocationIsSet) {
    val[utility::conversions::to_string_t("addUeLocation")] =
        ModelBase::toJson(m_AddUeLocation);
  }
  if (m_GpsiIsSet) {
    val[utility::conversions::to_string_t("gpsi")] = ModelBase::toJson(m_Gpsi);
  }
  if (m_N1SmInfoFromUeIsSet) {
    val[utility::conversions::to_string_t("n1SmInfoFromUe")] =
        ModelBase::toJson(m_N1SmInfoFromUe);
  }
  if (m_UnknownN1SmInfoIsSet) {
    val[utility::conversions::to_string_t("unknownN1SmInfo")] =
        ModelBase::toJson(m_UnknownN1SmInfo);
  }
  if (m_SupportedFeaturesIsSet) {
    val[utility::conversions::to_string_t("supportedFeatures")] =
        ModelBase::toJson(m_SupportedFeatures);
  }
  if (m_HPcfIdIsSet) {
    val[utility::conversions::to_string_t("hPcfId")] =
        ModelBase::toJson(m_HPcfId);
  }
  if (m_HoPreparationIndicationIsSet) {
    val[utility::conversions::to_string_t("hoPreparationIndication")] =
        ModelBase::toJson(m_HoPreparationIndication);
  }
  if (m_SelModeIsSet) {
    val[utility::conversions::to_string_t("selMode")] =
        ModelBase::toJson(m_SelMode);
  }
  if (m_AlwaysOnRequestedIsSet) {
    val[utility::conversions::to_string_t("alwaysOnRequested")] =
        ModelBase::toJson(m_AlwaysOnRequested);
  }
  if (m_UdmGroupIdIsSet) {
    val[utility::conversions::to_string_t("udmGroupId")] =
        ModelBase::toJson(m_UdmGroupId);
  }
  if (m_RoutingIndicatorIsSet) {
    val[utility::conversions::to_string_t("routingIndicator")] =
        ModelBase::toJson(m_RoutingIndicator);
  }
  if (m_EpsInterworkingIndIsSet) {
    val[utility::conversions::to_string_t("epsInterworkingInd")] =
        ModelBase::toJson(m_EpsInterworkingInd);
  }
  if (m_VSmfServiceInstanceIdIsSet) {
    val[utility::conversions::to_string_t("vSmfServiceInstanceId")] =
        ModelBase::toJson(m_VSmfServiceInstanceId);
  }
  if (m_RecoveryTimeIsSet) {
    val[utility::conversions::to_string_t("recoveryTime")] =
        ModelBase::toJson(m_RecoveryTime);
  }
  if (m_RoamingChargingProfileIsSet) {
    val[utility::conversions::to_string_t("roamingChargingProfile")] =
        ModelBase::toJson(m_RoamingChargingProfile);
  }
  if (m_ChargingIdIsSet) {
    val[utility::conversions::to_string_t("chargingId")] =
        ModelBase::toJson(m_ChargingId);
  }
  if (m_OldPduSessionIdIsSet) {
    val[utility::conversions::to_string_t("oldPduSessionId")] =
        ModelBase::toJson(m_OldPduSessionId);
  }
  if (m_EpsBearerCtxStatusIsSet) {
    val[utility::conversions::to_string_t("epsBearerCtxStatus")] =
        ModelBase::toJson(m_EpsBearerCtxStatus);
  }
  if (m_AmfNfIdIsSet) {
    val[utility::conversions::to_string_t("amfNfId")] =
        ModelBase::toJson(m_AmfNfId);
  }
  if (m_GuamiIsSet) {
    val[utility::conversions::to_string_t("guami")] =
        ModelBase::toJson(m_Guami);
  }
  if (m_CpCiotEnabledIsSet) {
    val[utility::conversions::to_string_t("cpCiotEnabled")] =
        ModelBase::toJson(m_CpCiotEnabled);
  }
  if (m_InvokeNefIsSet) {
    val[utility::conversions::to_string_t("invokeNef")] =
        ModelBase::toJson(m_InvokeNef);
  }
  if (m_MaPduIndicationIsSet) {
    val[utility::conversions::to_string_t("maPduIndication")] =
        ModelBase::toJson(m_MaPduIndication);
  }

  return val;
}

void PduSessionCreateData::fromJson(const web::json::value& val) {
  if (val.has_field(utility::conversions::to_string_t("supi"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("supi"));
    if (!fieldValue.is_null()) {
      setSupi(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("unauthenticatedSupi"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("unauthenticatedSupi"));
    if (!fieldValue.is_null()) {
      setUnauthenticatedSupi(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pei"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pei"));
    if (!fieldValue.is_null()) {
      setPei(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pduSessionId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pduSessionId"));
    if (!fieldValue.is_null()) {
      setPduSessionId(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  setDnn(ModelBase::stringFromJson(
      val.at(utility::conversions::to_string_t("dnn"))));
  if (val.has_field(utility::conversions::to_string_t("sNssai"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("sNssai"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromJson(fieldValue);
      setSNssai(newItem);
    }
  }
  setVsmfId(ModelBase::stringFromJson(
      val.at(utility::conversions::to_string_t("vsmfId"))));
  std::shared_ptr<PlmnId> newServingNetwork(new PlmnId());
  newServingNetwork->fromJson(
      val.at(utility::conversions::to_string_t("servingNetwork")));
  setServingNetwork(newServingNetwork);
  if (val.has_field(utility::conversions::to_string_t("requestType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("requestType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RequestType> newItem(new RequestType());
      newItem->fromJson(fieldValue);
      setRequestType(newItem);
    }
  }
  {
    m_EpsBearerId.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("epsBearerId"))) {
      for (auto& item : val.at(utility::conversions::to_string_t("epsBearerId"))
                            .as_array()) {
        m_EpsBearerId.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pgwS8cFteid"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pgwS8cFteid"));
    if (!fieldValue.is_null()) {
      setPgwS8cFteid(ModelBase::stringFromJson(fieldValue));
    }
  }
  setVsmfPduSessionUri(ModelBase::stringFromJson(
      val.at(utility::conversions::to_string_t("vsmfPduSessionUri"))));
  if (val.has_field(utility::conversions::to_string_t("vcnTunnelInfo"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("vcnTunnelInfo"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<TunnelInfo> newItem(new TunnelInfo());
      newItem->fromJson(fieldValue);
      setVcnTunnelInfo(newItem);
    }
  }
  std::shared_ptr<AccessType> newAnType(new AccessType());
  newAnType->fromJson(val.at(utility::conversions::to_string_t("anType")));
  setAnType(newAnType);
  if (val.has_field(utility::conversions::to_string_t("secondAnType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("secondAnType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromJson(fieldValue);
      setSecondAnType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ratType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ratType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromJson(fieldValue);
      setRatType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setUeLocation(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueTimeZone"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueTimeZone"));
    if (!fieldValue.is_null()) {
      setUeTimeZone(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("addUeLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("addUeLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setAddUeLocation(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("gpsi"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("gpsi"));
    if (!fieldValue.is_null()) {
      setGpsi(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n1SmInfoFromUe"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n1SmInfoFromUe"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN1SmInfoFromUe(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("unknownN1SmInfo"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("unknownN1SmInfo"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setUnknownN1SmInfo(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("supportedFeatures"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("supportedFeatures"));
    if (!fieldValue.is_null()) {
      setSupportedFeatures(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("hPcfId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("hPcfId"));
    if (!fieldValue.is_null()) {
      setHPcfId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(
          utility::conversions::to_string_t("hoPreparationIndication"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("hoPreparationIndication"));
    if (!fieldValue.is_null()) {
      setHoPreparationIndication(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("selMode"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("selMode"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<DnnSelectionMode> newItem(new DnnSelectionMode());
      newItem->fromJson(fieldValue);
      setSelMode(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("alwaysOnRequested"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("alwaysOnRequested"));
    if (!fieldValue.is_null()) {
      setAlwaysOnRequested(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("udmGroupId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("udmGroupId"));
    if (!fieldValue.is_null()) {
      setUdmGroupId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("routingIndicator"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("routingIndicator"));
    if (!fieldValue.is_null()) {
      setRoutingIndicator(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("epsInterworkingInd"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("epsInterworkingInd"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromJson(fieldValue);
      setEpsInterworkingInd(newItem);
    }
  }
  if (val.has_field(
          utility::conversions::to_string_t("vSmfServiceInstanceId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("vSmfServiceInstanceId"));
    if (!fieldValue.is_null()) {
      setVSmfServiceInstanceId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("recoveryTime"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("recoveryTime"));
    if (!fieldValue.is_null()) {
      setRecoveryTime(ModelBase::dateFromJson(fieldValue));
    }
  }
  if (val.has_field(
          utility::conversions::to_string_t("roamingChargingProfile"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("roamingChargingProfile"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RoamingChargingProfile> newItem(
          new RoamingChargingProfile());
      newItem->fromJson(fieldValue);
      setRoamingChargingProfile(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("chargingId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("chargingId"));
    if (!fieldValue.is_null()) {
      setChargingId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("oldPduSessionId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("oldPduSessionId"));
    if (!fieldValue.is_null()) {
      setOldPduSessionId(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("epsBearerCtxStatus"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("epsBearerCtxStatus"));
    if (!fieldValue.is_null()) {
      setEpsBearerCtxStatus(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("amfNfId"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("amfNfId"));
    if (!fieldValue.is_null()) {
      setAmfNfId(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("guami"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("guami"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Guami> newItem(new Guami());
      newItem->fromJson(fieldValue);
      setGuami(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("cpCiotEnabled"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("cpCiotEnabled"));
    if (!fieldValue.is_null()) {
      setCpCiotEnabled(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("invokeNef"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("invokeNef"));
    if (!fieldValue.is_null()) {
      setInvokeNef(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("maPduIndication"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("maPduIndication"));
    if (!fieldValue.is_null()) {
      setMaPduIndication(ModelBase::boolFromJson(fieldValue));
    }
  }
}

void PduSessionCreateData::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  if (m_SupiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("supi"), m_Supi));
  }
  if (m_UnauthenticatedSupiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("unauthenticatedSupi"),
        m_UnauthenticatedSupi));
  }
  if (m_PeiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("pei"), m_Pei));
  }
  if (m_PduSessionIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("pduSessionId"),
        m_PduSessionId));
  }
  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("dnn"), m_Dnn));
  if (m_SNssaiIsSet) {
    if (m_SNssai.get()) {
      m_SNssai->toMultipart(
          multipart, utility::conversions::to_string_t("sNssai."));
    }
  }
  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("vsmfId"), m_VsmfId));
  m_ServingNetwork->toMultipart(
      multipart, utility::conversions::to_string_t("servingNetwork."));
  if (m_RequestTypeIsSet) {
    if (m_RequestType.get()) {
      m_RequestType->toMultipart(
          multipart, utility::conversions::to_string_t("requestType."));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_EpsBearerId) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("epsBearerId"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_PgwS8cFteidIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("pgwS8cFteid"),
        m_PgwS8cFteid));
  }
  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("vsmfPduSessionUri"),
      m_VsmfPduSessionUri));
  if (m_VcnTunnelInfoIsSet) {
    if (m_VcnTunnelInfo.get()) {
      m_VcnTunnelInfo->toMultipart(
          multipart, utility::conversions::to_string_t("vcnTunnelInfo."));
    }
  }
  m_AnType->toMultipart(
      multipart, utility::conversions::to_string_t("anType."));
  if (m_SecondAnTypeIsSet) {
    if (m_SecondAnType.get()) {
      m_SecondAnType->toMultipart(
          multipart, utility::conversions::to_string_t("secondAnType."));
    }
  }
  if (m_RatTypeIsSet) {
    if (m_RatType.get()) {
      m_RatType->toMultipart(
          multipart, utility::conversions::to_string_t("ratType."));
    }
  }
  if (m_UeLocationIsSet) {
    if (m_UeLocation.get()) {
      m_UeLocation->toMultipart(
          multipart, utility::conversions::to_string_t("ueLocation."));
    }
  }
  if (m_UeTimeZoneIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("ueTimeZone"),
        m_UeTimeZone));
  }
  if (m_AddUeLocationIsSet) {
    if (m_AddUeLocation.get()) {
      m_AddUeLocation->toMultipart(
          multipart, utility::conversions::to_string_t("addUeLocation."));
    }
  }
  if (m_GpsiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("gpsi"), m_Gpsi));
  }
  if (m_N1SmInfoFromUeIsSet) {
    if (m_N1SmInfoFromUe.get()) {
      m_N1SmInfoFromUe->toMultipart(
          multipart, utility::conversions::to_string_t("n1SmInfoFromUe."));
    }
  }
  if (m_UnknownN1SmInfoIsSet) {
    if (m_UnknownN1SmInfo.get()) {
      m_UnknownN1SmInfo->toMultipart(
          multipart, utility::conversions::to_string_t("unknownN1SmInfo."));
    }
  }
  if (m_SupportedFeaturesIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("supportedFeatures"),
        m_SupportedFeatures));
  }
  if (m_HPcfIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("hPcfId"), m_HPcfId));
  }
  if (m_HoPreparationIndicationIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix +
            utility::conversions::to_string_t("hoPreparationIndication"),
        m_HoPreparationIndication));
  }
  if (m_SelModeIsSet) {
    if (m_SelMode.get()) {
      m_SelMode->toMultipart(
          multipart, utility::conversions::to_string_t("selMode."));
    }
  }
  if (m_AlwaysOnRequestedIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("alwaysOnRequested"),
        m_AlwaysOnRequested));
  }
  if (m_UdmGroupIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("udmGroupId"),
        m_UdmGroupId));
  }
  if (m_RoutingIndicatorIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("routingIndicator"),
        m_RoutingIndicator));
  }
  if (m_EpsInterworkingIndIsSet) {
    if (m_EpsInterworkingInd.get()) {
      m_EpsInterworkingInd->toMultipart(
          multipart, utility::conversions::to_string_t("epsInterworkingInd."));
    }
  }
  if (m_VSmfServiceInstanceIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("vSmfServiceInstanceId"),
        m_VSmfServiceInstanceId));
  }
  if (m_RecoveryTimeIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("recoveryTime"),
        m_RecoveryTime));
  }
  if (m_RoamingChargingProfileIsSet) {
    if (m_RoamingChargingProfile.get()) {
      m_RoamingChargingProfile->toMultipart(
          multipart,
          utility::conversions::to_string_t("roamingChargingProfile."));
    }
  }
  if (m_ChargingIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("chargingId"),
        m_ChargingId));
  }
  if (m_OldPduSessionIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("oldPduSessionId"),
        m_OldPduSessionId));
  }
  if (m_EpsBearerCtxStatusIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("epsBearerCtxStatus"),
        m_EpsBearerCtxStatus));
  }
  if (m_AmfNfIdIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("amfNfId"), m_AmfNfId));
  }
  if (m_GuamiIsSet) {
    if (m_Guami.get()) {
      m_Guami->toMultipart(
          multipart, utility::conversions::to_string_t("guami."));
    }
  }
  if (m_CpCiotEnabledIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("cpCiotEnabled"),
        m_CpCiotEnabled));
  }
  if (m_InvokeNefIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("invokeNef"),
        m_InvokeNef));
  }
  if (m_MaPduIndicationIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("maPduIndication"),
        m_MaPduIndication));
  }
}

void PduSessionCreateData::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  if (multipart->hasContent(utility::conversions::to_string_t("supi"))) {
    setSupi(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("supi"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("unauthenticatedSupi"))) {
    setUnauthenticatedSupi(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("unauthenticatedSupi"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("pei"))) {
    setPei(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("pei"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("pduSessionId"))) {
    setPduSessionId(ModelBase::int32_tFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("pduSessionId"))));
  }
  setDnn(ModelBase::stringFromHttpContent(
      multipart->getContent(utility::conversions::to_string_t("dnn"))));
  if (multipart->hasContent(utility::conversions::to_string_t("sNssai"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("sNssai"))) {
      std::shared_ptr<Snssai> newItem(new Snssai());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("sNssai."));
      setSNssai(newItem);
    }
  }
  setVsmfId(ModelBase::stringFromHttpContent(
      multipart->getContent(utility::conversions::to_string_t("vsmfId"))));
  std::shared_ptr<PlmnId> newServingNetwork(new PlmnId());
  newServingNetwork->fromMultiPart(
      multipart, utility::conversions::to_string_t("servingNetwork."));
  setServingNetwork(newServingNetwork);
  if (multipart->hasContent(utility::conversions::to_string_t("requestType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("requestType"))) {
      std::shared_ptr<RequestType> newItem(new RequestType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("requestType."));
      setRequestType(newItem);
    }
  }
  {
    m_EpsBearerId.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("epsBearerId"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("epsBearerId"))));
      for (auto& item : jsonArray.as_array()) {
        m_EpsBearerId.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("pgwS8cFteid"))) {
    setPgwS8cFteid(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("pgwS8cFteid"))));
  }
  setVsmfPduSessionUri(ModelBase::stringFromHttpContent(multipart->getContent(
      utility::conversions::to_string_t("vsmfPduSessionUri"))));
  if (multipart->hasContent(
          utility::conversions::to_string_t("vcnTunnelInfo"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("vcnTunnelInfo"))) {
      std::shared_ptr<TunnelInfo> newItem(new TunnelInfo());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("vcnTunnelInfo."));
      setVcnTunnelInfo(newItem);
    }
  }
  std::shared_ptr<AccessType> newAnType(new AccessType());
  newAnType->fromMultiPart(
      multipart, utility::conversions::to_string_t("anType."));
  setAnType(newAnType);
  if (multipart->hasContent(
          utility::conversions::to_string_t("secondAnType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("secondAnType"))) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("secondAnType."));
      setSecondAnType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ratType."));
      setRatType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("ueLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ueLocation."));
      setUeLocation(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueTimeZone"))) {
    setUeTimeZone(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("ueTimeZone"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("addUeLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("addUeLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("addUeLocation."));
      setAddUeLocation(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("gpsi"))) {
    setGpsi(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("gpsi"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("n1SmInfoFromUe"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("n1SmInfoFromUe"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n1SmInfoFromUe."));
      setN1SmInfoFromUe(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("unknownN1SmInfo"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("unknownN1SmInfo"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("unknownN1SmInfo."));
      setUnknownN1SmInfo(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("supportedFeatures"))) {
    setSupportedFeatures(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("supportedFeatures"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("hPcfId"))) {
    setHPcfId(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("hPcfId"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("hoPreparationIndication"))) {
    setHoPreparationIndication(
        ModelBase::boolFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("hoPreparationIndication"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("selMode"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("selMode"))) {
      std::shared_ptr<DnnSelectionMode> newItem(new DnnSelectionMode());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("selMode."));
      setSelMode(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("alwaysOnRequested"))) {
    setAlwaysOnRequested(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("alwaysOnRequested"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("udmGroupId"))) {
    setUdmGroupId(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("udmGroupId"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("routingIndicator"))) {
    setRoutingIndicator(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("routingIndicator"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("epsInterworkingInd"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("epsInterworkingInd"))) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("epsInterworkingInd."));
      setEpsInterworkingInd(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("vSmfServiceInstanceId"))) {
    setVSmfServiceInstanceId(
        ModelBase::stringFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("vSmfServiceInstanceId"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("recoveryTime"))) {
    setRecoveryTime(ModelBase::dateFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("recoveryTime"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("roamingChargingProfile"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("roamingChargingProfile"))) {
      std::shared_ptr<RoamingChargingProfile> newItem(
          new RoamingChargingProfile());
      newItem->fromMultiPart(
          multipart,
          utility::conversions::to_string_t("roamingChargingProfile."));
      setRoamingChargingProfile(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("chargingId"))) {
    setChargingId(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("chargingId"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("oldPduSessionId"))) {
    setOldPduSessionId(ModelBase::int32_tFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("oldPduSessionId"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("epsBearerCtxStatus"))) {
    setEpsBearerCtxStatus(
        ModelBase::stringFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("epsBearerCtxStatus"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("amfNfId"))) {
    setAmfNfId(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("amfNfId"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("guami"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("guami"))) {
      std::shared_ptr<Guami> newItem(new Guami());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("guami."));
      setGuami(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("cpCiotEnabled"))) {
    setCpCiotEnabled(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("cpCiotEnabled"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("invokeNef"))) {
    setInvokeNef(ModelBase::boolFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("invokeNef"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("maPduIndication"))) {
    setMaPduIndication(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("maPduIndication"))));
  }
}

utility::string_t PduSessionCreateData::getSupi() const {
  return m_Supi;
}

void PduSessionCreateData::setSupi(const utility::string_t& value) {
  m_Supi      = value;
  m_SupiIsSet = true;
}

bool PduSessionCreateData::supiIsSet() const {
  return m_SupiIsSet;
}

void PduSessionCreateData::unsetSupi() {
  m_SupiIsSet = false;
}

bool PduSessionCreateData::isUnauthenticatedSupi() const {
  return m_UnauthenticatedSupi;
}

void PduSessionCreateData::setUnauthenticatedSupi(bool value) {
  m_UnauthenticatedSupi      = value;
  m_UnauthenticatedSupiIsSet = true;
}

bool PduSessionCreateData::unauthenticatedSupiIsSet() const {
  return m_UnauthenticatedSupiIsSet;
}

void PduSessionCreateData::unsetUnauthenticatedSupi() {
  m_UnauthenticatedSupiIsSet = false;
}

utility::string_t PduSessionCreateData::getPei() const {
  return m_Pei;
}

void PduSessionCreateData::setPei(const utility::string_t& value) {
  m_Pei      = value;
  m_PeiIsSet = true;
}

bool PduSessionCreateData::peiIsSet() const {
  return m_PeiIsSet;
}

void PduSessionCreateData::unsetPei() {
  m_PeiIsSet = false;
}

int32_t PduSessionCreateData::getPduSessionId() const {
  return m_PduSessionId;
}

void PduSessionCreateData::setPduSessionId(int32_t value) {
  m_PduSessionId      = value;
  m_PduSessionIdIsSet = true;
}

bool PduSessionCreateData::pduSessionIdIsSet() const {
  return m_PduSessionIdIsSet;
}

void PduSessionCreateData::unsetPduSessionId() {
  m_PduSessionIdIsSet = false;
}

utility::string_t PduSessionCreateData::getDnn() const {
  return m_Dnn;
}

void PduSessionCreateData::setDnn(const utility::string_t& value) {
  m_Dnn = value;
}

std::shared_ptr<Snssai> PduSessionCreateData::getSNssai() const {
  return m_SNssai;
}

void PduSessionCreateData::setSNssai(const std::shared_ptr<Snssai>& value) {
  m_SNssai      = value;
  m_SNssaiIsSet = true;
}

bool PduSessionCreateData::sNssaiIsSet() const {
  return m_SNssaiIsSet;
}

void PduSessionCreateData::unsetSNssai() {
  m_SNssaiIsSet = false;
}

utility::string_t PduSessionCreateData::getVsmfId() const {
  return m_VsmfId;
}

void PduSessionCreateData::setVsmfId(const utility::string_t& value) {
  m_VsmfId = value;
}

std::shared_ptr<PlmnId> PduSessionCreateData::getServingNetwork() const {
  return m_ServingNetwork;
}

void PduSessionCreateData::setServingNetwork(
    const std::shared_ptr<PlmnId>& value) {
  m_ServingNetwork = value;
}

std::shared_ptr<RequestType> PduSessionCreateData::getRequestType() const {
  return m_RequestType;
}

void PduSessionCreateData::setRequestType(
    const std::shared_ptr<RequestType>& value) {
  m_RequestType      = value;
  m_RequestTypeIsSet = true;
}

bool PduSessionCreateData::requestTypeIsSet() const {
  return m_RequestTypeIsSet;
}

void PduSessionCreateData::unsetRequestType() {
  m_RequestTypeIsSet = false;
}

std::vector<int32_t>& PduSessionCreateData::getEpsBearerId() {
  return m_EpsBearerId;
}

void PduSessionCreateData::setEpsBearerId(std::vector<int32_t> value) {
  m_EpsBearerId      = value;
  m_EpsBearerIdIsSet = true;
}

bool PduSessionCreateData::epsBearerIdIsSet() const {
  return m_EpsBearerIdIsSet;
}

void PduSessionCreateData::unsetEpsBearerId() {
  m_EpsBearerIdIsSet = false;
}

utility::string_t PduSessionCreateData::getPgwS8cFteid() const {
  return m_PgwS8cFteid;
}

void PduSessionCreateData::setPgwS8cFteid(const utility::string_t& value) {
  m_PgwS8cFteid      = value;
  m_PgwS8cFteidIsSet = true;
}

bool PduSessionCreateData::pgwS8cFteidIsSet() const {
  return m_PgwS8cFteidIsSet;
}

void PduSessionCreateData::unsetPgwS8cFteid() {
  m_PgwS8cFteidIsSet = false;
}

utility::string_t PduSessionCreateData::getVsmfPduSessionUri() const {
  return m_VsmfPduSessionUri;
}

void PduSessionCreateData::setVsmfPduSessionUri(
    const utility::string_t& value) {
  m_VsmfPduSessionUri = value;
}

std::shared_ptr<TunnelInfo> PduSessionCreateData::getVcnTunnelInfo() const {
  return m_VcnTunnelInfo;
}

void PduSessionCreateData::setVcnTunnelInfo(
    const std::shared_ptr<TunnelInfo>& value) {
  m_VcnTunnelInfo      = value;
  m_VcnTunnelInfoIsSet = true;
}

bool PduSessionCreateData::vcnTunnelInfoIsSet() const {
  return m_VcnTunnelInfoIsSet;
}

void PduSessionCreateData::unsetVcnTunnelInfo() {
  m_VcnTunnelInfoIsSet = false;
}

std::shared_ptr<AccessType> PduSessionCreateData::getAnType() const {
  return m_AnType;
}

void PduSessionCreateData::setAnType(const std::shared_ptr<AccessType>& value) {
  m_AnType = value;
}

std::shared_ptr<AccessType> PduSessionCreateData::getSecondAnType() const {
  return m_SecondAnType;
}

void PduSessionCreateData::setSecondAnType(
    const std::shared_ptr<AccessType>& value) {
  m_SecondAnType      = value;
  m_SecondAnTypeIsSet = true;
}

bool PduSessionCreateData::secondAnTypeIsSet() const {
  return m_SecondAnTypeIsSet;
}

void PduSessionCreateData::unsetSecondAnType() {
  m_SecondAnTypeIsSet = false;
}

std::shared_ptr<RatType> PduSessionCreateData::getRatType() const {
  return m_RatType;
}

void PduSessionCreateData::setRatType(const std::shared_ptr<RatType>& value) {
  m_RatType      = value;
  m_RatTypeIsSet = true;
}

bool PduSessionCreateData::ratTypeIsSet() const {
  return m_RatTypeIsSet;
}

void PduSessionCreateData::unsetRatType() {
  m_RatTypeIsSet = false;
}

std::shared_ptr<UserLocation> PduSessionCreateData::getUeLocation() const {
  return m_UeLocation;
}

void PduSessionCreateData::setUeLocation(
    const std::shared_ptr<UserLocation>& value) {
  m_UeLocation      = value;
  m_UeLocationIsSet = true;
}

bool PduSessionCreateData::ueLocationIsSet() const {
  return m_UeLocationIsSet;
}

void PduSessionCreateData::unsetUeLocation() {
  m_UeLocationIsSet = false;
}

utility::string_t PduSessionCreateData::getUeTimeZone() const {
  return m_UeTimeZone;
}

void PduSessionCreateData::setUeTimeZone(const utility::string_t& value) {
  m_UeTimeZone      = value;
  m_UeTimeZoneIsSet = true;
}

bool PduSessionCreateData::ueTimeZoneIsSet() const {
  return m_UeTimeZoneIsSet;
}

void PduSessionCreateData::unsetUeTimeZone() {
  m_UeTimeZoneIsSet = false;
}

std::shared_ptr<UserLocation> PduSessionCreateData::getAddUeLocation() const {
  return m_AddUeLocation;
}

void PduSessionCreateData::setAddUeLocation(
    const std::shared_ptr<UserLocation>& value) {
  m_AddUeLocation      = value;
  m_AddUeLocationIsSet = true;
}

bool PduSessionCreateData::addUeLocationIsSet() const {
  return m_AddUeLocationIsSet;
}

void PduSessionCreateData::unsetAddUeLocation() {
  m_AddUeLocationIsSet = false;
}

utility::string_t PduSessionCreateData::getGpsi() const {
  return m_Gpsi;
}

void PduSessionCreateData::setGpsi(const utility::string_t& value) {
  m_Gpsi      = value;
  m_GpsiIsSet = true;
}

bool PduSessionCreateData::gpsiIsSet() const {
  return m_GpsiIsSet;
}

void PduSessionCreateData::unsetGpsi() {
  m_GpsiIsSet = false;
}

std::shared_ptr<RefToBinaryData> PduSessionCreateData::getN1SmInfoFromUe()
    const {
  return m_N1SmInfoFromUe;
}

void PduSessionCreateData::setN1SmInfoFromUe(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N1SmInfoFromUe      = value;
  m_N1SmInfoFromUeIsSet = true;
}

bool PduSessionCreateData::n1SmInfoFromUeIsSet() const {
  return m_N1SmInfoFromUeIsSet;
}

void PduSessionCreateData::unsetN1SmInfoFromUe() {
  m_N1SmInfoFromUeIsSet = false;
}

std::shared_ptr<RefToBinaryData> PduSessionCreateData::getUnknownN1SmInfo()
    const {
  return m_UnknownN1SmInfo;
}

void PduSessionCreateData::setUnknownN1SmInfo(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_UnknownN1SmInfo      = value;
  m_UnknownN1SmInfoIsSet = true;
}

bool PduSessionCreateData::unknownN1SmInfoIsSet() const {
  return m_UnknownN1SmInfoIsSet;
}

void PduSessionCreateData::unsetUnknownN1SmInfo() {
  m_UnknownN1SmInfoIsSet = false;
}

utility::string_t PduSessionCreateData::getSupportedFeatures() const {
  return m_SupportedFeatures;
}

void PduSessionCreateData::setSupportedFeatures(
    const utility::string_t& value) {
  m_SupportedFeatures      = value;
  m_SupportedFeaturesIsSet = true;
}

bool PduSessionCreateData::supportedFeaturesIsSet() const {
  return m_SupportedFeaturesIsSet;
}

void PduSessionCreateData::unsetSupportedFeatures() {
  m_SupportedFeaturesIsSet = false;
}

utility::string_t PduSessionCreateData::getHPcfId() const {
  return m_HPcfId;
}

void PduSessionCreateData::setHPcfId(const utility::string_t& value) {
  m_HPcfId      = value;
  m_HPcfIdIsSet = true;
}

bool PduSessionCreateData::hPcfIdIsSet() const {
  return m_HPcfIdIsSet;
}

void PduSessionCreateData::unsetHPcfId() {
  m_HPcfIdIsSet = false;
}

bool PduSessionCreateData::isHoPreparationIndication() const {
  return m_HoPreparationIndication;
}

void PduSessionCreateData::setHoPreparationIndication(bool value) {
  m_HoPreparationIndication      = value;
  m_HoPreparationIndicationIsSet = true;
}

bool PduSessionCreateData::hoPreparationIndicationIsSet() const {
  return m_HoPreparationIndicationIsSet;
}

void PduSessionCreateData::unsetHoPreparationIndication() {
  m_HoPreparationIndicationIsSet = false;
}

std::shared_ptr<DnnSelectionMode> PduSessionCreateData::getSelMode() const {
  return m_SelMode;
}

void PduSessionCreateData::setSelMode(
    const std::shared_ptr<DnnSelectionMode>& value) {
  m_SelMode      = value;
  m_SelModeIsSet = true;
}

bool PduSessionCreateData::selModeIsSet() const {
  return m_SelModeIsSet;
}

void PduSessionCreateData::unsetSelMode() {
  m_SelModeIsSet = false;
}

bool PduSessionCreateData::isAlwaysOnRequested() const {
  return m_AlwaysOnRequested;
}

void PduSessionCreateData::setAlwaysOnRequested(bool value) {
  m_AlwaysOnRequested      = value;
  m_AlwaysOnRequestedIsSet = true;
}

bool PduSessionCreateData::alwaysOnRequestedIsSet() const {
  return m_AlwaysOnRequestedIsSet;
}

void PduSessionCreateData::unsetAlwaysOnRequested() {
  m_AlwaysOnRequestedIsSet = false;
}

utility::string_t PduSessionCreateData::getUdmGroupId() const {
  return m_UdmGroupId;
}

void PduSessionCreateData::setUdmGroupId(const utility::string_t& value) {
  m_UdmGroupId      = value;
  m_UdmGroupIdIsSet = true;
}

bool PduSessionCreateData::udmGroupIdIsSet() const {
  return m_UdmGroupIdIsSet;
}

void PduSessionCreateData::unsetUdmGroupId() {
  m_UdmGroupIdIsSet = false;
}

utility::string_t PduSessionCreateData::getRoutingIndicator() const {
  return m_RoutingIndicator;
}

void PduSessionCreateData::setRoutingIndicator(const utility::string_t& value) {
  m_RoutingIndicator      = value;
  m_RoutingIndicatorIsSet = true;
}

bool PduSessionCreateData::routingIndicatorIsSet() const {
  return m_RoutingIndicatorIsSet;
}

void PduSessionCreateData::unsetRoutingIndicator() {
  m_RoutingIndicatorIsSet = false;
}

std::shared_ptr<EpsInterworkingIndication>
PduSessionCreateData::getEpsInterworkingInd() const {
  return m_EpsInterworkingInd;
}

void PduSessionCreateData::setEpsInterworkingInd(
    const std::shared_ptr<EpsInterworkingIndication>& value) {
  m_EpsInterworkingInd      = value;
  m_EpsInterworkingIndIsSet = true;
}

bool PduSessionCreateData::epsInterworkingIndIsSet() const {
  return m_EpsInterworkingIndIsSet;
}

void PduSessionCreateData::unsetEpsInterworkingInd() {
  m_EpsInterworkingIndIsSet = false;
}

utility::string_t PduSessionCreateData::getVSmfServiceInstanceId() const {
  return m_VSmfServiceInstanceId;
}

void PduSessionCreateData::setVSmfServiceInstanceId(
    const utility::string_t& value) {
  m_VSmfServiceInstanceId      = value;
  m_VSmfServiceInstanceIdIsSet = true;
}

bool PduSessionCreateData::vSmfServiceInstanceIdIsSet() const {
  return m_VSmfServiceInstanceIdIsSet;
}

void PduSessionCreateData::unsetVSmfServiceInstanceId() {
  m_VSmfServiceInstanceIdIsSet = false;
}

utility::datetime PduSessionCreateData::getRecoveryTime() const {
  return m_RecoveryTime;
}

void PduSessionCreateData::setRecoveryTime(const utility::datetime& value) {
  m_RecoveryTime      = value;
  m_RecoveryTimeIsSet = true;
}

bool PduSessionCreateData::recoveryTimeIsSet() const {
  return m_RecoveryTimeIsSet;
}

void PduSessionCreateData::unsetRecoveryTime() {
  m_RecoveryTimeIsSet = false;
}

std::shared_ptr<RoamingChargingProfile>
PduSessionCreateData::getRoamingChargingProfile() const {
  return m_RoamingChargingProfile;
}

void PduSessionCreateData::setRoamingChargingProfile(
    const std::shared_ptr<RoamingChargingProfile>& value) {
  m_RoamingChargingProfile      = value;
  m_RoamingChargingProfileIsSet = true;
}

bool PduSessionCreateData::roamingChargingProfileIsSet() const {
  return m_RoamingChargingProfileIsSet;
}

void PduSessionCreateData::unsetRoamingChargingProfile() {
  m_RoamingChargingProfileIsSet = false;
}

utility::string_t PduSessionCreateData::getChargingId() const {
  return m_ChargingId;
}

void PduSessionCreateData::setChargingId(const utility::string_t& value) {
  m_ChargingId      = value;
  m_ChargingIdIsSet = true;
}

bool PduSessionCreateData::chargingIdIsSet() const {
  return m_ChargingIdIsSet;
}

void PduSessionCreateData::unsetChargingId() {
  m_ChargingIdIsSet = false;
}

int32_t PduSessionCreateData::getOldPduSessionId() const {
  return m_OldPduSessionId;
}

void PduSessionCreateData::setOldPduSessionId(int32_t value) {
  m_OldPduSessionId      = value;
  m_OldPduSessionIdIsSet = true;
}

bool PduSessionCreateData::oldPduSessionIdIsSet() const {
  return m_OldPduSessionIdIsSet;
}

void PduSessionCreateData::unsetOldPduSessionId() {
  m_OldPduSessionIdIsSet = false;
}

utility::string_t PduSessionCreateData::getEpsBearerCtxStatus() const {
  return m_EpsBearerCtxStatus;
}

void PduSessionCreateData::setEpsBearerCtxStatus(
    const utility::string_t& value) {
  m_EpsBearerCtxStatus      = value;
  m_EpsBearerCtxStatusIsSet = true;
}

bool PduSessionCreateData::epsBearerCtxStatusIsSet() const {
  return m_EpsBearerCtxStatusIsSet;
}

void PduSessionCreateData::unsetEpsBearerCtxStatus() {
  m_EpsBearerCtxStatusIsSet = false;
}

utility::string_t PduSessionCreateData::getAmfNfId() const {
  return m_AmfNfId;
}

void PduSessionCreateData::setAmfNfId(const utility::string_t& value) {
  m_AmfNfId      = value;
  m_AmfNfIdIsSet = true;
}

bool PduSessionCreateData::amfNfIdIsSet() const {
  return m_AmfNfIdIsSet;
}

void PduSessionCreateData::unsetAmfNfId() {
  m_AmfNfIdIsSet = false;
}

std::shared_ptr<Guami> PduSessionCreateData::getGuami() const {
  return m_Guami;
}

void PduSessionCreateData::setGuami(const std::shared_ptr<Guami>& value) {
  m_Guami      = value;
  m_GuamiIsSet = true;
}

bool PduSessionCreateData::guamiIsSet() const {
  return m_GuamiIsSet;
}

void PduSessionCreateData::unsetGuami() {
  m_GuamiIsSet = false;
}

bool PduSessionCreateData::isCpCiotEnabled() const {
  return m_CpCiotEnabled;
}

void PduSessionCreateData::setCpCiotEnabled(bool value) {
  m_CpCiotEnabled      = value;
  m_CpCiotEnabledIsSet = true;
}

bool PduSessionCreateData::cpCiotEnabledIsSet() const {
  return m_CpCiotEnabledIsSet;
}

void PduSessionCreateData::unsetCpCiotEnabled() {
  m_CpCiotEnabledIsSet = false;
}

bool PduSessionCreateData::isInvokeNef() const {
  return m_InvokeNef;
}

void PduSessionCreateData::setInvokeNef(bool value) {
  m_InvokeNef      = value;
  m_InvokeNefIsSet = true;
}

bool PduSessionCreateData::invokeNefIsSet() const {
  return m_InvokeNefIsSet;
}

void PduSessionCreateData::unsetInvokeNef() {
  m_InvokeNefIsSet = false;
}

bool PduSessionCreateData::isMaPduIndication() const {
  return m_MaPduIndication;
}

void PduSessionCreateData::setMaPduIndication(bool value) {
  m_MaPduIndication      = value;
  m_MaPduIndicationIsSet = true;
}

bool PduSessionCreateData::maPduIndicationIsSet() const {
  return m_MaPduIndicationIsSet;
}

void PduSessionCreateData::unsetMaPduIndication() {
  m_MaPduIndicationIsSet = false;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
