/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

/*
 * PduSessionCreateData.h
 *
 *
 */

#ifndef OAI_SMF_MODEL_PduSessionCreateData_H_
#define OAI_SMF_MODEL_PduSessionCreateData_H_

#include "../ModelBase.h"

#include "RatType.h"
#include "RefToBinaryData.h"
#include "PlmnId.h"
#include "Snssai.h"
#include <vector>
#include "AccessType.h"
#include "DnnSelectionMode.h"
#include "EpsInterworkingIndication.h"
#include "UserLocation.h"
#include "RoamingChargingProfile.h"
#include <cpprest/details/basic_types.h>
#include "RequestType.h"
#include "TunnelInfo.h"
#include "Guami.h"

namespace oai {
namespace smf {
namespace model {

/// <summary>
///
/// </summary>
class PduSessionCreateData : public ModelBase {
 public:
  PduSessionCreateData();
  virtual ~PduSessionCreateData();

  /////////////////////////////////////////////
  /// ModelBase overrides

  void validate() override;

  web::json::value toJson() const override;
  void fromJson(const web::json::value& json) override;

  void toMultipart(
      std::shared_ptr<MultipartFormData> multipart,
      const utility::string_t& namePrefix) const override;
  void fromMultiPart(
      std::shared_ptr<MultipartFormData> multipart,
      const utility::string_t& namePrefix) override;

  /////////////////////////////////////////////
  /// PduSessionCreateData members

  /// <summary>
  ///
  /// </summary>
  utility::string_t getSupi() const;
  bool supiIsSet() const;
  void unsetSupi();

  void setSupi(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  bool isUnauthenticatedSupi() const;
  bool unauthenticatedSupiIsSet() const;
  void unsetUnauthenticatedSupi();

  void setUnauthenticatedSupi(bool value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getPei() const;
  bool peiIsSet() const;
  void unsetPei();

  void setPei(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  int32_t getPduSessionId() const;
  bool pduSessionIdIsSet() const;
  void unsetPduSessionId();

  void setPduSessionId(int32_t value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getDnn() const;

  void setDnn(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<Snssai> getSNssai() const;
  bool sNssaiIsSet() const;
  void unsetSNssai();

  void setSNssai(const std::shared_ptr<Snssai>& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getVsmfId() const;

  void setVsmfId(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<PlmnId> getServingNetwork() const;

  void setServingNetwork(const std::shared_ptr<PlmnId>& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<RequestType> getRequestType() const;
  bool requestTypeIsSet() const;
  void unsetRequestType();

  void setRequestType(const std::shared_ptr<RequestType>& value);

  /// <summary>
  ///
  /// </summary>
  std::vector<int32_t>& getEpsBearerId();
  bool epsBearerIdIsSet() const;
  void unsetEpsBearerId();

  void setEpsBearerId(std::vector<int32_t> value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getPgwS8cFteid() const;
  bool pgwS8cFteidIsSet() const;
  void unsetPgwS8cFteid();

  void setPgwS8cFteid(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getVsmfPduSessionUri() const;

  void setVsmfPduSessionUri(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<TunnelInfo> getVcnTunnelInfo() const;
  bool vcnTunnelInfoIsSet() const;
  void unsetVcnTunnelInfo();

  void setVcnTunnelInfo(const std::shared_ptr<TunnelInfo>& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<AccessType> getAnType() const;

  void setAnType(const std::shared_ptr<AccessType>& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<AccessType> getSecondAnType() const;
  bool secondAnTypeIsSet() const;
  void unsetSecondAnType();

  void setSecondAnType(const std::shared_ptr<AccessType>& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<RatType> getRatType() const;
  bool ratTypeIsSet() const;
  void unsetRatType();

  void setRatType(const std::shared_ptr<RatType>& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<UserLocation> getUeLocation() const;
  bool ueLocationIsSet() const;
  void unsetUeLocation();

  void setUeLocation(const std::shared_ptr<UserLocation>& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getUeTimeZone() const;
  bool ueTimeZoneIsSet() const;
  void unsetUeTimeZone();

  void setUeTimeZone(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<UserLocation> getAddUeLocation() const;
  bool addUeLocationIsSet() const;
  void unsetAddUeLocation();

  void setAddUeLocation(const std::shared_ptr<UserLocation>& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getGpsi() const;
  bool gpsiIsSet() const;
  void unsetGpsi();

  void setGpsi(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<RefToBinaryData> getN1SmInfoFromUe() const;
  bool n1SmInfoFromUeIsSet() const;
  void unsetN1SmInfoFromUe();

  void setN1SmInfoFromUe(const std::shared_ptr<RefToBinaryData>& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<RefToBinaryData> getUnknownN1SmInfo() const;
  bool unknownN1SmInfoIsSet() const;
  void unsetUnknownN1SmInfo();

  void setUnknownN1SmInfo(const std::shared_ptr<RefToBinaryData>& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getSupportedFeatures() const;
  bool supportedFeaturesIsSet() const;
  void unsetSupportedFeatures();

  void setSupportedFeatures(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getHPcfId() const;
  bool hPcfIdIsSet() const;
  void unsetHPcfId();

  void setHPcfId(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  bool isHoPreparationIndication() const;
  bool hoPreparationIndicationIsSet() const;
  void unsetHoPreparationIndication();

  void setHoPreparationIndication(bool value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<DnnSelectionMode> getSelMode() const;
  bool selModeIsSet() const;
  void unsetSelMode();

  void setSelMode(const std::shared_ptr<DnnSelectionMode>& value);

  /// <summary>
  ///
  /// </summary>
  bool isAlwaysOnRequested() const;
  bool alwaysOnRequestedIsSet() const;
  void unsetAlwaysOnRequested();

  void setAlwaysOnRequested(bool value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getUdmGroupId() const;
  bool udmGroupIdIsSet() const;
  void unsetUdmGroupId();

  void setUdmGroupId(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getRoutingIndicator() const;
  bool routingIndicatorIsSet() const;
  void unsetRoutingIndicator();

  void setRoutingIndicator(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<EpsInterworkingIndication> getEpsInterworkingInd() const;
  bool epsInterworkingIndIsSet() const;
  void unsetEpsInterworkingInd();

  void setEpsInterworkingInd(
      const std::shared_ptr<EpsInterworkingIndication>& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getVSmfServiceInstanceId() const;
  bool vSmfServiceInstanceIdIsSet() const;
  void unsetVSmfServiceInstanceId();

  void setVSmfServiceInstanceId(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  utility::datetime getRecoveryTime() const;
  bool recoveryTimeIsSet() const;
  void unsetRecoveryTime();

  void setRecoveryTime(const utility::datetime& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<RoamingChargingProfile> getRoamingChargingProfile() const;
  bool roamingChargingProfileIsSet() const;
  void unsetRoamingChargingProfile();

  void setRoamingChargingProfile(
      const std::shared_ptr<RoamingChargingProfile>& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getChargingId() const;
  bool chargingIdIsSet() const;
  void unsetChargingId();

  void setChargingId(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  int32_t getOldPduSessionId() const;
  bool oldPduSessionIdIsSet() const;
  void unsetOldPduSessionId();

  void setOldPduSessionId(int32_t value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getEpsBearerCtxStatus() const;
  bool epsBearerCtxStatusIsSet() const;
  void unsetEpsBearerCtxStatus();

  void setEpsBearerCtxStatus(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  utility::string_t getAmfNfId() const;
  bool amfNfIdIsSet() const;
  void unsetAmfNfId();

  void setAmfNfId(const utility::string_t& value);

  /// <summary>
  ///
  /// </summary>
  std::shared_ptr<Guami> getGuami() const;
  bool guamiIsSet() const;
  void unsetGuami();

  void setGuami(const std::shared_ptr<Guami>& value);

  /// <summary>
  ///
  /// </summary>
  bool isCpCiotEnabled() const;
  bool cpCiotEnabledIsSet() const;
  void unsetCpCiotEnabled();

  void setCpCiotEnabled(bool value);

  /// <summary>
  ///
  /// </summary>
  bool isInvokeNef() const;
  bool invokeNefIsSet() const;
  void unsetInvokeNef();

  void setInvokeNef(bool value);

  /// <summary>
  ///
  /// </summary>
  bool isMaPduIndication() const;
  bool maPduIndicationIsSet() const;
  void unsetMaPduIndication();

  void setMaPduIndication(bool value);

 protected:
  utility::string_t m_Supi;
  bool m_SupiIsSet;
  bool m_UnauthenticatedSupi;
  bool m_UnauthenticatedSupiIsSet;
  utility::string_t m_Pei;
  bool m_PeiIsSet;
  int32_t m_PduSessionId;
  bool m_PduSessionIdIsSet;
  utility::string_t m_Dnn;
  std::shared_ptr<Snssai> m_SNssai;
  bool m_SNssaiIsSet;
  utility::string_t m_VsmfId;
  std::shared_ptr<PlmnId> m_ServingNetwork;
  std::shared_ptr<RequestType> m_RequestType;
  bool m_RequestTypeIsSet;
  std::vector<int32_t> m_EpsBearerId;
  bool m_EpsBearerIdIsSet;
  utility::string_t m_PgwS8cFteid;
  bool m_PgwS8cFteidIsSet;
  utility::string_t m_VsmfPduSessionUri;
  std::shared_ptr<TunnelInfo> m_VcnTunnelInfo;
  bool m_VcnTunnelInfoIsSet;
  std::shared_ptr<AccessType> m_AnType;
  std::shared_ptr<AccessType> m_SecondAnType;
  bool m_SecondAnTypeIsSet;
  std::shared_ptr<RatType> m_RatType;
  bool m_RatTypeIsSet;
  std::shared_ptr<UserLocation> m_UeLocation;
  bool m_UeLocationIsSet;
  utility::string_t m_UeTimeZone;
  bool m_UeTimeZoneIsSet;
  std::shared_ptr<UserLocation> m_AddUeLocation;
  bool m_AddUeLocationIsSet;
  utility::string_t m_Gpsi;
  bool m_GpsiIsSet;
  std::shared_ptr<RefToBinaryData> m_N1SmInfoFromUe;
  bool m_N1SmInfoFromUeIsSet;
  std::shared_ptr<RefToBinaryData> m_UnknownN1SmInfo;
  bool m_UnknownN1SmInfoIsSet;
  utility::string_t m_SupportedFeatures;
  bool m_SupportedFeaturesIsSet;
  utility::string_t m_HPcfId;
  bool m_HPcfIdIsSet;
  bool m_HoPreparationIndication;
  bool m_HoPreparationIndicationIsSet;
  std::shared_ptr<DnnSelectionMode> m_SelMode;
  bool m_SelModeIsSet;
  bool m_AlwaysOnRequested;
  bool m_AlwaysOnRequestedIsSet;
  utility::string_t m_UdmGroupId;
  bool m_UdmGroupIdIsSet;
  utility::string_t m_RoutingIndicator;
  bool m_RoutingIndicatorIsSet;
  std::shared_ptr<EpsInterworkingIndication> m_EpsInterworkingInd;
  bool m_EpsInterworkingIndIsSet;
  utility::string_t m_VSmfServiceInstanceId;
  bool m_VSmfServiceInstanceIdIsSet;
  utility::datetime m_RecoveryTime;
  bool m_RecoveryTimeIsSet;
  std::shared_ptr<RoamingChargingProfile> m_RoamingChargingProfile;
  bool m_RoamingChargingProfileIsSet;
  utility::string_t m_ChargingId;
  bool m_ChargingIdIsSet;
  int32_t m_OldPduSessionId;
  bool m_OldPduSessionIdIsSet;
  utility::string_t m_EpsBearerCtxStatus;
  bool m_EpsBearerCtxStatusIsSet;
  utility::string_t m_AmfNfId;
  bool m_AmfNfIdIsSet;
  std::shared_ptr<Guami> m_Guami;
  bool m_GuamiIsSet;
  bool m_CpCiotEnabled;
  bool m_CpCiotEnabledIsSet;
  bool m_InvokeNef;
  bool m_InvokeNefIsSet;
  bool m_MaPduIndication;
  bool m_MaPduIndicationIsSet;
};

}  // namespace model
}  // namespace smf
}  // namespace oai

#endif /* OAI_SMF_MODEL_PduSessionCreateData_H_ */
