/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "QosFlowAddModifyRequestItem.h"

namespace oai {
namespace smf {
namespace model {

QosFlowAddModifyRequestItem::QosFlowAddModifyRequestItem() {
  m_Qfi                     = 0;
  m_Ebi                     = 0;
  m_EbiIsSet                = false;
  m_QosRulesIsSet           = false;
  m_QosFlowDescriptionIsSet = false;
  m_QosFlowProfileIsSet     = false;
}

QosFlowAddModifyRequestItem::~QosFlowAddModifyRequestItem() {}

void QosFlowAddModifyRequestItem::validate() {
  // TODO: implement validation
}

web::json::value QosFlowAddModifyRequestItem::toJson() const {
  web::json::value val = web::json::value::object();

  val[utility::conversions::to_string_t("qfi")] = ModelBase::toJson(m_Qfi);
  if (m_EbiIsSet) {
    val[utility::conversions::to_string_t("ebi")] = ModelBase::toJson(m_Ebi);
  }
  if (m_QosRulesIsSet) {
    val[utility::conversions::to_string_t("qosRules")] =
        ModelBase::toJson(m_QosRules);
  }
  if (m_QosFlowDescriptionIsSet) {
    val[utility::conversions::to_string_t("qosFlowDescription")] =
        ModelBase::toJson(m_QosFlowDescription);
  }
  if (m_QosFlowProfileIsSet) {
    val[utility::conversions::to_string_t("qosFlowProfile")] =
        ModelBase::toJson(m_QosFlowProfile);
  }

  return val;
}

void QosFlowAddModifyRequestItem::fromJson(const web::json::value& val) {
  setQfi(ModelBase::int32_tFromJson(
      val.at(utility::conversions::to_string_t("qfi"))));
  if (val.has_field(utility::conversions::to_string_t("ebi"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ebi"));
    if (!fieldValue.is_null()) {
      setEbi(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("qosRules"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("qosRules"));
    if (!fieldValue.is_null()) {
      setQosRules(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("qosFlowDescription"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("qosFlowDescription"));
    if (!fieldValue.is_null()) {
      setQosFlowDescription(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("qosFlowProfile"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("qosFlowProfile"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<QosFlowProfile> newItem(new QosFlowProfile());
      newItem->fromJson(fieldValue);
      setQosFlowProfile(newItem);
    }
  }
}

void QosFlowAddModifyRequestItem::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  multipart->add(ModelBase::toHttpContent(
      namePrefix + utility::conversions::to_string_t("qfi"), m_Qfi));
  if (m_EbiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("ebi"), m_Ebi));
  }
  if (m_QosRulesIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("qosRules"),
        m_QosRules));
  }
  if (m_QosFlowDescriptionIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("qosFlowDescription"),
        m_QosFlowDescription));
  }
  if (m_QosFlowProfileIsSet) {
    if (m_QosFlowProfile.get()) {
      m_QosFlowProfile->toMultipart(
          multipart, utility::conversions::to_string_t("qosFlowProfile."));
    }
  }
}

void QosFlowAddModifyRequestItem::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  setQfi(ModelBase::int32_tFromHttpContent(
      multipart->getContent(utility::conversions::to_string_t("qfi"))));
  if (multipart->hasContent(utility::conversions::to_string_t("ebi"))) {
    setEbi(ModelBase::int32_tFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("ebi"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("qosRules"))) {
    setQosRules(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("qosRules"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("qosFlowDescription"))) {
    setQosFlowDescription(
        ModelBase::stringFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("qosFlowDescription"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("qosFlowProfile"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("qosFlowProfile"))) {
      std::shared_ptr<QosFlowProfile> newItem(new QosFlowProfile());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("qosFlowProfile."));
      setQosFlowProfile(newItem);
    }
  }
}

int32_t QosFlowAddModifyRequestItem::getQfi() const {
  return m_Qfi;
}

void QosFlowAddModifyRequestItem::setQfi(int32_t value) {
  m_Qfi = value;
}

int32_t QosFlowAddModifyRequestItem::getEbi() const {
  return m_Ebi;
}

void QosFlowAddModifyRequestItem::setEbi(int32_t value) {
  m_Ebi      = value;
  m_EbiIsSet = true;
}

bool QosFlowAddModifyRequestItem::ebiIsSet() const {
  return m_EbiIsSet;
}

void QosFlowAddModifyRequestItem::unsetEbi() {
  m_EbiIsSet = false;
}

utility::string_t QosFlowAddModifyRequestItem::getQosRules() const {
  return m_QosRules;
}

void QosFlowAddModifyRequestItem::setQosRules(const utility::string_t& value) {
  m_QosRules      = value;
  m_QosRulesIsSet = true;
}

bool QosFlowAddModifyRequestItem::qosRulesIsSet() const {
  return m_QosRulesIsSet;
}

void QosFlowAddModifyRequestItem::unsetQosRules() {
  m_QosRulesIsSet = false;
}

utility::string_t QosFlowAddModifyRequestItem::getQosFlowDescription() const {
  return m_QosFlowDescription;
}

void QosFlowAddModifyRequestItem::setQosFlowDescription(
    const utility::string_t& value) {
  m_QosFlowDescription      = value;
  m_QosFlowDescriptionIsSet = true;
}

bool QosFlowAddModifyRequestItem::qosFlowDescriptionIsSet() const {
  return m_QosFlowDescriptionIsSet;
}

void QosFlowAddModifyRequestItem::unsetQosFlowDescription() {
  m_QosFlowDescriptionIsSet = false;
}

std::shared_ptr<QosFlowProfile> QosFlowAddModifyRequestItem::getQosFlowProfile()
    const {
  return m_QosFlowProfile;
}

void QosFlowAddModifyRequestItem::setQosFlowProfile(
    const std::shared_ptr<QosFlowProfile>& value) {
  m_QosFlowProfile      = value;
  m_QosFlowProfileIsSet = true;
}

bool QosFlowAddModifyRequestItem::qosFlowProfileIsSet() const {
  return m_QosFlowProfileIsSet;
}

void QosFlowAddModifyRequestItem::unsetQosFlowProfile() {
  m_QosFlowProfileIsSet = false;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
