/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved. 
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */



#include "N3gaLocation.h"

namespace oai {
namespace smf {
namespace model {




N3gaLocation::N3gaLocation()
{
    m_N3gppTaiIsSet = false;
    m_N3IwfId = utility::conversions::to_string_t("");
    m_N3IwfIdIsSet = false;
    m_UeIpv4Addr = utility::conversions::to_string_t("");
    m_UeIpv4AddrIsSet = false;
    m_UeIpv6AddrIsSet = false;
    m_PortNumber = 0;
    m_PortNumberIsSet = false;
}

N3gaLocation::~N3gaLocation()
{
}

void N3gaLocation::validate()
{
    // TODO: implement validation
}

web::json::value N3gaLocation::toJson() const
{
    web::json::value val = web::json::value::object();

    if(m_N3gppTaiIsSet)
    {
        val[utility::conversions::to_string_t("n3gppTai")] = ModelBase::toJson(m_N3gppTai);
    }
    if(m_N3IwfIdIsSet)
    {
        val[utility::conversions::to_string_t("n3IwfId")] = ModelBase::toJson(m_N3IwfId);
    }
    if(m_UeIpv4AddrIsSet)
    {
        val[utility::conversions::to_string_t("ueIpv4Addr")] = ModelBase::toJson(m_UeIpv4Addr);
    }
    if(m_UeIpv6AddrIsSet)
    {
        val[utility::conversions::to_string_t("ueIpv6Addr")] = ModelBase::toJson(m_UeIpv6Addr);
    }
    if(m_PortNumberIsSet)
    {
        val[utility::conversions::to_string_t("portNumber")] = ModelBase::toJson(m_PortNumber);
    }

    return val;
}

void N3gaLocation::fromJson(const web::json::value& val)
{
    if(val.has_field(utility::conversions::to_string_t("n3gppTai")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n3gppTai"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<Tai> newItem(new Tai());
            newItem->fromJson(fieldValue);
            setN3gppTai( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("n3IwfId")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n3IwfId"));
        if(!fieldValue.is_null())
        {
            setN3IwfId(ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("ueIpv4Addr")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("ueIpv4Addr"));
        if(!fieldValue.is_null())
        {
            setUeIpv4Addr(ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("ueIpv6Addr")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("ueIpv6Addr"));
        if(!fieldValue.is_null())
        {
            //std::shared_ptr<utility::string_t> newItem(new Ipv6Addr());
            //newItem->fromJson(fieldValue);
            setUeIpv6Addr( ModelBase::stringFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("portNumber")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("portNumber"));
        if(!fieldValue.is_null())
        {
            setPortNumber(ModelBase::int32_tFromJson(fieldValue));
        }
    }
}

void N3gaLocation::toMultipart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix) const
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    if(m_N3gppTaiIsSet)
    {
        if (m_N3gppTai.get())
        {
            m_N3gppTai->toMultipart(multipart, utility::conversions::to_string_t("n3gppTai."));
        }
    }
    if(m_N3IwfIdIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("n3IwfId"), m_N3IwfId));
    }
    if(m_UeIpv4AddrIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("ueIpv4Addr"), m_UeIpv4Addr));
    }
    if(m_UeIpv6AddrIsSet)
    {
        //if (m_UeIpv6Addr.get())
       // {
           // m_UeIpv6Addr->toMultipart(multipart, utility::conversions::to_string_t("ueIpv6Addr."));
              multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("ueIpv6Addr"), m_UeIpv6Addr));
        //}
    }
    if(m_PortNumberIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("portNumber"), m_PortNumber));
    }
}

void N3gaLocation::fromMultiPart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix)
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    if(multipart->hasContent(utility::conversions::to_string_t("n3gppTai")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("n3gppTai")))
        {
            std::shared_ptr<Tai> newItem(new Tai());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("n3gppTai."));
            setN3gppTai( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("n3IwfId")))
    {
        setN3IwfId(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("n3IwfId"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("ueIpv4Addr")))
    {
        setUeIpv4Addr(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("ueIpv4Addr"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("ueIpv6Addr")))
    {
       // if(multipart->hasContent(utility::conversions::to_string_t("ueIpv6Addr")))
       // {
       //     std::shared_ptr<utility::string_t> newItem(new Ipv6Addr());
       //     newItem->fromMultiPart(multipart, utility::conversions::to_string_t("ueIpv6Addr."));
            setUeIpv6Addr(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("ueIpv6Addr"))) );
       // }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("portNumber")))
    {
        setPortNumber(ModelBase::int32_tFromHttpContent(multipart->getContent(utility::conversions::to_string_t("portNumber"))));
    }
}

std::shared_ptr<Tai> N3gaLocation::getN3gppTai() const
{
    return m_N3gppTai;
}

void N3gaLocation::setN3gppTai(const std::shared_ptr<Tai>& value)
{
    m_N3gppTai = value;
    m_N3gppTaiIsSet = true;
}

bool N3gaLocation::n3gppTaiIsSet() const
{
    return m_N3gppTaiIsSet;
}

void N3gaLocation::unsetN3gppTai()
{
    m_N3gppTaiIsSet = false;
}

utility::string_t N3gaLocation::getN3IwfId() const
{
    return m_N3IwfId;
}

void N3gaLocation::setN3IwfId(const utility::string_t& value)
{
    m_N3IwfId = value;
    m_N3IwfIdIsSet = true;
}

bool N3gaLocation::n3IwfIdIsSet() const
{
    return m_N3IwfIdIsSet;
}

void N3gaLocation::unsetN3IwfId()
{
    m_N3IwfIdIsSet = false;
}

utility::string_t N3gaLocation::getUeIpv4Addr() const
{
    return m_UeIpv4Addr;
}

void N3gaLocation::setUeIpv4Addr(const utility::string_t& value)
{
    m_UeIpv4Addr = value;
    m_UeIpv4AddrIsSet = true;
}

bool N3gaLocation::ueIpv4AddrIsSet() const
{
    return m_UeIpv4AddrIsSet;
}

void N3gaLocation::unsetUeIpv4Addr()
{
    m_UeIpv4AddrIsSet = false;
}

utility::string_t N3gaLocation::getUeIpv6Addr() const
{
    return m_UeIpv6Addr;
}

void N3gaLocation::setUeIpv6Addr(const utility::string_t& value)
{
    m_UeIpv6Addr = value;
    m_UeIpv6AddrIsSet = true;
}

bool N3gaLocation::ueIpv6AddrIsSet() const
{
    return m_UeIpv6AddrIsSet;
}

void N3gaLocation::unsetUeIpv6Addr()
{
    m_UeIpv6AddrIsSet = false;
}

int32_t N3gaLocation::getPortNumber() const
{
    return m_PortNumber;
}

void N3gaLocation::setPortNumber(int32_t value)
{
    m_PortNumber = value;
    m_PortNumberIsSet = true;
}

bool N3gaLocation::portNumberIsSet() const
{
    return m_PortNumberIsSet;
}

void N3gaLocation::unsetPortNumber()
{
    m_PortNumberIsSet = false;
}

}
}
}


