/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS, CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved. 
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */



#include "SmContextUpdatedData.h"

namespace oai {
namespace smf {
namespace model {




SmContextUpdatedData::SmContextUpdatedData()
{
    m_UpCnxStateIsSet = false;
    m_HoStateIsSet = false;
    m_ReleaseEbiListIsSet = false;
    m_AllocatedEbiListIsSet = false;
    m_ModifiedEbiListIsSet = false;
    m_N1SmMsgIsSet = false;
    m_N2SmInfoIsSet = false;
    m_N2SmInfoTypeIsSet = false;
    m_EpsBearerSetupIsSet = false;
    m_DataForwarding = false;
    m_DataForwardingIsSet = false;
    m_CauseIsSet = false;
}

SmContextUpdatedData::~SmContextUpdatedData()
{
}

void SmContextUpdatedData::validate()
{
    // TODO: implement validation
}

web::json::value SmContextUpdatedData::toJson() const
{
    web::json::value val = web::json::value::object();

    if(m_UpCnxStateIsSet)
    {
        val[utility::conversions::to_string_t("upCnxState")] = ModelBase::toJson(m_UpCnxState);
    }
    if(m_HoStateIsSet)
    {
        val[utility::conversions::to_string_t("hoState")] = ModelBase::toJson(m_HoState);
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_ReleaseEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        if(jsonArray.size() > 0)
        {
            val[utility::conversions::to_string_t("releaseEbiList")] = web::json::value::array(jsonArray);
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_AllocatedEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        if(jsonArray.size() > 0)
        {
            val[utility::conversions::to_string_t("allocatedEbiList")] = web::json::value::array(jsonArray);
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_ModifiedEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        if(jsonArray.size() > 0)
        {
            val[utility::conversions::to_string_t("modifiedEbiList")] = web::json::value::array(jsonArray);
        }
    }
    if(m_N1SmMsgIsSet)
    {
        val[utility::conversions::to_string_t("n1SmMsg")] = ModelBase::toJson(m_N1SmMsg);
    }
    if(m_N2SmInfoIsSet)
    {
        val[utility::conversions::to_string_t("n2SmInfo")] = ModelBase::toJson(m_N2SmInfo);
    }
    if(m_N2SmInfoTypeIsSet)
    {
        val[utility::conversions::to_string_t("n2SmInfoType")] = ModelBase::toJson(m_N2SmInfoType);
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_EpsBearerSetup )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        if(jsonArray.size() > 0)
        {
            val[utility::conversions::to_string_t("epsBearerSetup")] = web::json::value::array(jsonArray);
        }
    }
    if(m_DataForwardingIsSet)
    {
        val[utility::conversions::to_string_t("dataForwarding")] = ModelBase::toJson(m_DataForwarding);
    }
    if(m_CauseIsSet)
    {
        val[utility::conversions::to_string_t("cause")] = ModelBase::toJson(m_Cause);
    }

    return val;
}

void SmContextUpdatedData::fromJson(const web::json::value& val)
{
    if(val.has_field(utility::conversions::to_string_t("upCnxState")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("upCnxState"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<UpCnxState> newItem(new UpCnxState());
            newItem->fromJson(fieldValue);
            setUpCnxState( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("hoState")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("hoState"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<HoState> newItem(new HoState());
            newItem->fromJson(fieldValue);
            setHoState( newItem );
        }
    }
    {
        m_ReleaseEbiList.clear();
        std::vector<web::json::value> jsonArray;
        if(val.has_field(utility::conversions::to_string_t("releaseEbiList")))
        {
        for( auto& item : val.at(utility::conversions::to_string_t("releaseEbiList")).as_array() )
        {
            m_ReleaseEbiList.push_back(ModelBase::int32_tFromJson(item));
        }
        }
    }
    {
        m_AllocatedEbiList.clear();
        std::vector<web::json::value> jsonArray;
        if(val.has_field(utility::conversions::to_string_t("allocatedEbiList")))
        {
        for( auto& item : val.at(utility::conversions::to_string_t("allocatedEbiList")).as_array() )
        {
            if(item.is_null())
            {
                m_AllocatedEbiList.push_back( std::shared_ptr<EbiArpMapping>(nullptr) );
            }
            else
            {
                std::shared_ptr<EbiArpMapping> newItem(new EbiArpMapping());
                newItem->fromJson(item);
                m_AllocatedEbiList.push_back( newItem );
            }
        }
        }
    }
    {
        m_ModifiedEbiList.clear();
        std::vector<web::json::value> jsonArray;
        if(val.has_field(utility::conversions::to_string_t("modifiedEbiList")))
        {
        for( auto& item : val.at(utility::conversions::to_string_t("modifiedEbiList")).as_array() )
        {
            if(item.is_null())
            {
                m_ModifiedEbiList.push_back( std::shared_ptr<EbiArpMapping>(nullptr) );
            }
            else
            {
                std::shared_ptr<EbiArpMapping> newItem(new EbiArpMapping());
                newItem->fromJson(item);
                m_ModifiedEbiList.push_back( newItem );
            }
        }
        }
    }
    if(val.has_field(utility::conversions::to_string_t("n1SmMsg")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n1SmMsg"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromJson(fieldValue);
            setN1SmMsg( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("n2SmInfo")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n2SmInfo"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromJson(fieldValue);
            setN2SmInfo( newItem );
        }
    }
    if(val.has_field(utility::conversions::to_string_t("n2SmInfoType")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("n2SmInfoType"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
            newItem->fromJson(fieldValue);
            setN2SmInfoType( newItem );
        }
    }
    {
        m_EpsBearerSetup.clear();
        std::vector<web::json::value> jsonArray;
        if(val.has_field(utility::conversions::to_string_t("epsBearerSetup")))
        {
        for( auto& item : val.at(utility::conversions::to_string_t("epsBearerSetup")).as_array() )
        {
            m_EpsBearerSetup.push_back(ModelBase::stringFromJson(item));
        }
        }
    }
    if(val.has_field(utility::conversions::to_string_t("dataForwarding")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("dataForwarding"));
        if(!fieldValue.is_null())
        {
            setDataForwarding(ModelBase::boolFromJson(fieldValue));
        }
    }
    if(val.has_field(utility::conversions::to_string_t("cause")))
    {
        const web::json::value& fieldValue = val.at(utility::conversions::to_string_t("cause"));
        if(!fieldValue.is_null())
        {
            std::shared_ptr<Cause> newItem(new Cause());
            newItem->fromJson(fieldValue);
            setCause( newItem );
        }
    }
}

void SmContextUpdatedData::toMultipart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix) const
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    if(m_UpCnxStateIsSet)
    {
        if (m_UpCnxState.get())
        {
            m_UpCnxState->toMultipart(multipart, utility::conversions::to_string_t("upCnxState."));
        }
    }
    if(m_HoStateIsSet)
    {
        if (m_HoState.get())
        {
            m_HoState->toMultipart(multipart, utility::conversions::to_string_t("hoState."));
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_ReleaseEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        
        if(jsonArray.size() > 0)
        {
            multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("releaseEbiList"), web::json::value::array(jsonArray), utility::conversions::to_string_t("application/json")));
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_AllocatedEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        
        if(jsonArray.size() > 0)
        {
            multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("allocatedEbiList"), web::json::value::array(jsonArray), utility::conversions::to_string_t("application/json")));
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_ModifiedEbiList )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        
        if(jsonArray.size() > 0)
        {
            multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("modifiedEbiList"), web::json::value::array(jsonArray), utility::conversions::to_string_t("application/json")));
        }
    }
    if(m_N1SmMsgIsSet)
    {
        if (m_N1SmMsg.get())
        {
            m_N1SmMsg->toMultipart(multipart, utility::conversions::to_string_t("n1SmMsg."));
        }
    }
    if(m_N2SmInfoIsSet)
    {
        if (m_N2SmInfo.get())
        {
            m_N2SmInfo->toMultipart(multipart, utility::conversions::to_string_t("n2SmInfo."));
        }
    }
    if(m_N2SmInfoTypeIsSet)
    {
        if (m_N2SmInfoType.get())
        {
            m_N2SmInfoType->toMultipart(multipart, utility::conversions::to_string_t("n2SmInfoType."));
        }
    }
    {
        std::vector<web::json::value> jsonArray;
        for( auto& item : m_EpsBearerSetup )
        {
            jsonArray.push_back(ModelBase::toJson(item));
        }
        
        if(jsonArray.size() > 0)
        {
            multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("epsBearerSetup"), web::json::value::array(jsonArray), utility::conversions::to_string_t("application/json")));
        }
    }
    if(m_DataForwardingIsSet)
    {
        multipart->add(ModelBase::toHttpContent(namePrefix + utility::conversions::to_string_t("dataForwarding"), m_DataForwarding));
    }
    if(m_CauseIsSet)
    {
        if (m_Cause.get())
        {
            m_Cause->toMultipart(multipart, utility::conversions::to_string_t("cause."));
        }
    }
}

void SmContextUpdatedData::fromMultiPart(std::shared_ptr<MultipartFormData> multipart, const utility::string_t& prefix)
{
    utility::string_t namePrefix = prefix;
    if(namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) != utility::conversions::to_string_t("."))
    {
        namePrefix += utility::conversions::to_string_t(".");
    }

    if(multipart->hasContent(utility::conversions::to_string_t("upCnxState")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("upCnxState")))
        {
            std::shared_ptr<UpCnxState> newItem(new UpCnxState());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("upCnxState."));
            setUpCnxState( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("hoState")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("hoState")))
        {
            std::shared_ptr<HoState> newItem(new HoState());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("hoState."));
            setHoState( newItem );
        }
    }
    {
        m_ReleaseEbiList.clear();
        if(multipart->hasContent(utility::conversions::to_string_t("releaseEbiList")))
        {

        web::json::value jsonArray = web::json::value::parse(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("releaseEbiList"))));
        for( auto& item : jsonArray.as_array() )
        {
            m_ReleaseEbiList.push_back(ModelBase::int32_tFromJson(item));
        }
        }
    }
    {
        m_AllocatedEbiList.clear();
        if(multipart->hasContent(utility::conversions::to_string_t("allocatedEbiList")))
        {

        web::json::value jsonArray = web::json::value::parse(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("allocatedEbiList"))));
        for( auto& item : jsonArray.as_array() )
        {
            if(item.is_null())
            {
                m_AllocatedEbiList.push_back( std::shared_ptr<EbiArpMapping>(nullptr) );
            }
            else
            {
                std::shared_ptr<EbiArpMapping> newItem(new EbiArpMapping());
                newItem->fromJson(item);
                m_AllocatedEbiList.push_back( newItem );
            }
        }
        }
    }
    {
        m_ModifiedEbiList.clear();
        if(multipart->hasContent(utility::conversions::to_string_t("modifiedEbiList")))
        {

        web::json::value jsonArray = web::json::value::parse(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("modifiedEbiList"))));
        for( auto& item : jsonArray.as_array() )
        {
            if(item.is_null())
            {
                m_ModifiedEbiList.push_back( std::shared_ptr<EbiArpMapping>(nullptr) );
            }
            else
            {
                std::shared_ptr<EbiArpMapping> newItem(new EbiArpMapping());
                newItem->fromJson(item);
                m_ModifiedEbiList.push_back( newItem );
            }
        }
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("n1SmMsg")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("n1SmMsg")))
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("n1SmMsg."));
            setN1SmMsg( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("n2SmInfo")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("n2SmInfo")))
        {
            std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("n2SmInfo."));
            setN2SmInfo( newItem );
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("n2SmInfoType")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("n2SmInfoType")))
        {
            std::shared_ptr<N2SmInfoType> newItem(new N2SmInfoType());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("n2SmInfoType."));
            setN2SmInfoType( newItem );
        }
    }
    {
        m_EpsBearerSetup.clear();
        if(multipart->hasContent(utility::conversions::to_string_t("epsBearerSetup")))
        {

        web::json::value jsonArray = web::json::value::parse(ModelBase::stringFromHttpContent(multipart->getContent(utility::conversions::to_string_t("epsBearerSetup"))));
        for( auto& item : jsonArray.as_array() )
        {
            m_EpsBearerSetup.push_back(ModelBase::stringFromJson(item));
        }
        }
    }
    if(multipart->hasContent(utility::conversions::to_string_t("dataForwarding")))
    {
        setDataForwarding(ModelBase::boolFromHttpContent(multipart->getContent(utility::conversions::to_string_t("dataForwarding"))));
    }
    if(multipart->hasContent(utility::conversions::to_string_t("cause")))
    {
        if(multipart->hasContent(utility::conversions::to_string_t("cause")))
        {
            std::shared_ptr<Cause> newItem(new Cause());
            newItem->fromMultiPart(multipart, utility::conversions::to_string_t("cause."));
            setCause( newItem );
        }
    }
}

std::shared_ptr<UpCnxState> SmContextUpdatedData::getUpCnxState() const
{
    return m_UpCnxState;
}

void SmContextUpdatedData::setUpCnxState(const std::shared_ptr<UpCnxState>& value)
{
    m_UpCnxState = value;
    m_UpCnxStateIsSet = true;
}

bool SmContextUpdatedData::upCnxStateIsSet() const
{
    return m_UpCnxStateIsSet;
}

void SmContextUpdatedData::unsetUpCnxState()
{
    m_UpCnxStateIsSet = false;
}

std::shared_ptr<HoState> SmContextUpdatedData::getHoState() const
{
    return m_HoState;
}

void SmContextUpdatedData::setHoState(const std::shared_ptr<HoState>& value)
{
    m_HoState = value;
    m_HoStateIsSet = true;
}

bool SmContextUpdatedData::hoStateIsSet() const
{
    return m_HoStateIsSet;
}

void SmContextUpdatedData::unsetHoState()
{
    m_HoStateIsSet = false;
}

std::vector<int32_t>& SmContextUpdatedData::getReleaseEbiList()
{
    return m_ReleaseEbiList;
}

void SmContextUpdatedData::setReleaseEbiList(std::vector<int32_t> value)
{
    m_ReleaseEbiList = value;
    m_ReleaseEbiListIsSet = true;
}

bool SmContextUpdatedData::releaseEbiListIsSet() const
{
    return m_ReleaseEbiListIsSet;
}

void SmContextUpdatedData::unsetReleaseEbiList()
{
    m_ReleaseEbiListIsSet = false;
}

std::vector<std::shared_ptr<EbiArpMapping>>& SmContextUpdatedData::getAllocatedEbiList()
{
    return m_AllocatedEbiList;
}

void SmContextUpdatedData::setAllocatedEbiList(const std::vector<std::shared_ptr<EbiArpMapping>>& value)
{
    m_AllocatedEbiList = value;
    m_AllocatedEbiListIsSet = true;
}

bool SmContextUpdatedData::allocatedEbiListIsSet() const
{
    return m_AllocatedEbiListIsSet;
}

void SmContextUpdatedData::unsetAllocatedEbiList()
{
    m_AllocatedEbiListIsSet = false;
}

std::vector<std::shared_ptr<EbiArpMapping>>& SmContextUpdatedData::getModifiedEbiList()
{
    return m_ModifiedEbiList;
}

void SmContextUpdatedData::setModifiedEbiList(const std::vector<std::shared_ptr<EbiArpMapping>>& value)
{
    m_ModifiedEbiList = value;
    m_ModifiedEbiListIsSet = true;
}

bool SmContextUpdatedData::modifiedEbiListIsSet() const
{
    return m_ModifiedEbiListIsSet;
}

void SmContextUpdatedData::unsetModifiedEbiList()
{
    m_ModifiedEbiListIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextUpdatedData::getN1SmMsg() const
{
    return m_N1SmMsg;
}

void SmContextUpdatedData::setN1SmMsg(const std::shared_ptr<RefToBinaryData>& value)
{
    m_N1SmMsg = value;
    m_N1SmMsgIsSet = true;
}

bool SmContextUpdatedData::n1SmMsgIsSet() const
{
    return m_N1SmMsgIsSet;
}

void SmContextUpdatedData::unsetN1SmMsg()
{
    m_N1SmMsgIsSet = false;
}

std::shared_ptr<RefToBinaryData> SmContextUpdatedData::getN2SmInfo() const
{
    return m_N2SmInfo;
}

void SmContextUpdatedData::setN2SmInfo(const std::shared_ptr<RefToBinaryData>& value)
{
    m_N2SmInfo = value;
    m_N2SmInfoIsSet = true;
}

bool SmContextUpdatedData::n2SmInfoIsSet() const
{
    return m_N2SmInfoIsSet;
}

void SmContextUpdatedData::unsetN2SmInfo()
{
    m_N2SmInfoIsSet = false;
}

std::shared_ptr<N2SmInfoType> SmContextUpdatedData::getN2SmInfoType() const
{
    return m_N2SmInfoType;
}

void SmContextUpdatedData::setN2SmInfoType(const std::shared_ptr<N2SmInfoType>& value)
{
    m_N2SmInfoType = value;
    m_N2SmInfoTypeIsSet = true;
}

bool SmContextUpdatedData::n2SmInfoTypeIsSet() const
{
    return m_N2SmInfoTypeIsSet;
}

void SmContextUpdatedData::unsetN2SmInfoType()
{
    m_N2SmInfoTypeIsSet = false;
}

std::vector<utility::string_t>& SmContextUpdatedData::getEpsBearerSetup()
{
    return m_EpsBearerSetup;
}

void SmContextUpdatedData::setEpsBearerSetup(const std::vector<utility::string_t>& value)
{
    m_EpsBearerSetup = value;
    m_EpsBearerSetupIsSet = true;
}

bool SmContextUpdatedData::epsBearerSetupIsSet() const
{
    return m_EpsBearerSetupIsSet;
}

void SmContextUpdatedData::unsetEpsBearerSetup()
{
    m_EpsBearerSetupIsSet = false;
}

bool SmContextUpdatedData::isDataForwarding() const
{
    return m_DataForwarding;
}

void SmContextUpdatedData::setDataForwarding(bool value)
{
    m_DataForwarding = value;
    m_DataForwardingIsSet = true;
}

bool SmContextUpdatedData::dataForwardingIsSet() const
{
    return m_DataForwardingIsSet;
}

void SmContextUpdatedData::unsetDataForwarding()
{
    m_DataForwardingIsSet = false;
}

std::shared_ptr<Cause> SmContextUpdatedData::getCause() const
{
    return m_Cause;
}

void SmContextUpdatedData::setCause(const std::shared_ptr<Cause>& value)
{
    m_Cause = value;
    m_CauseIsSet = true;
}

bool SmContextUpdatedData::causeIsSet() const
{
    return m_CauseIsSet;
}

void SmContextUpdatedData::unsetCause()
{
    m_CauseIsSet = false;
}

}
}
}


