/**
 * Namf_Communication
 * AMF Communication Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "NonUEN2MessagesCollectionDocumentApi.h"
#include "Helpers.h"
#include "amf_config.hpp"

extern config::amf_config amf_cfg;

namespace oai {
namespace amf {
namespace api {

using namespace oai::amf::helpers;
using namespace oai::amf::model;

NonUEN2MessagesCollectionDocumentApi::NonUEN2MessagesCollectionDocumentApi(
    std::shared_ptr<Pistache::Rest::Router> rtr) {
  router = rtr;
}

void NonUEN2MessagesCollectionDocumentApi::init() {
  setupRoutes();
}

void NonUEN2MessagesCollectionDocumentApi::setupRoutes() {
  using namespace Pistache::Rest;

  Routes::Post(
      *router, base + amf_cfg.sbi_api_version + "/non-ue-n2-messages/transfer",
      Routes::bind(
          &NonUEN2MessagesCollectionDocumentApi::
              non_ue_n2_message_transfer_handler,
          this));

  // Default handler, called when a route is not found
  router->addCustomHandler(Routes::bind(
      &NonUEN2MessagesCollectionDocumentApi::
          non_uen2_messages_collection_document_api_default_handler,
      this));
}

void NonUEN2MessagesCollectionDocumentApi::non_ue_n2_message_transfer_handler(
    const Pistache::Rest::Request& request,
    Pistache::Http::ResponseWriter response) {
  // Getting the body param

  N2InformationTransferReqData n2InformationTransferReqData;

  try {
    nlohmann::json::parse(request.body()).get_to(n2InformationTransferReqData);
    this->non_ue_n2_message_transfer(n2InformationTransferReqData, response);
  } catch (nlohmann::detail::exception& e) {
    // send a 400 error
    response.send(Pistache::Http::Code::Bad_Request, e.what());
    return;
  } catch (std::exception& e) {
    // send a 500 error
    response.send(Pistache::Http::Code::Internal_Server_Error, e.what());
    return;
  }
}

void NonUEN2MessagesCollectionDocumentApi::
    non_uen2_messages_collection_document_api_default_handler(
        const Pistache::Rest::Request&,
        Pistache::Http::ResponseWriter response) {
  response.send(
      Pistache::Http::Code::Not_Found, "The requested method does not exist");
}

}  // namespace api
}  // namespace amf
}  // namespace oai
