/**
 * Namf_EventExposure
 * AMF Event Exposure Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "AmfEvent.h"
#include "Helpers.h"

#include <sstream>

namespace oai::amf::model {

AmfEvent::AmfEvent() {
  m_ImmediateFlag           = false;
  m_ImmediateFlagIsSet      = false;
  m_AreaListIsSet           = false;
  m_LocationFilterListIsSet = false;
  m_RefId                   = 0;
  m_RefIdIsSet              = false;
}

void AmfEvent::validate() const {
  std::stringstream msg;
  if (!validate(msg)) {
    throw oai::amf::helpers::ValidationException(msg.str());
  }
}

bool AmfEvent::validate(std::stringstream& msg) const {
  return validate(msg, "");
}

bool AmfEvent::validate(
    std::stringstream& msg, const std::string& pathPrefix) const {
  bool success                  = true;
  const std::string _pathPrefix = pathPrefix.empty() ? "AmfEvent" : pathPrefix;

  if (areaListIsSet()) {
    const std::vector<AmfEventArea>& value = m_AreaList;
    const std::string currentValuePath     = _pathPrefix + ".areaList";

    if (value.size() < 1) {
      success = false;
      msg << currentValuePath << ": must have at least 1 elements;";
    }
    {  // Recursive validation of array elements
      const std::string oldValuePath = currentValuePath;
      int i                          = 0;
      for (const AmfEventArea& value : value) {
        const std::string currentValuePath =
            oldValuePath + "[" + std::to_string(i) + "]";

        success =
            value.validate(msg, currentValuePath + ".areaList") && success;

        i++;
      }
    }
  }

  if (locationFilterListIsSet()) {
    const std::vector<LocationFilter>& value = m_LocationFilterList;
    const std::string currentValuePath = _pathPrefix + ".locationFilterList";

    if (value.size() < 1) {
      success = false;
      msg << currentValuePath << ": must have at least 1 elements;";
    }
    {  // Recursive validation of array elements
      const std::string oldValuePath = currentValuePath;
      int i                          = 0;
      for (const LocationFilter& value : value) {
        const std::string currentValuePath =
            oldValuePath + "[" + std::to_string(i) + "]";

        success =
            value.validate(msg, currentValuePath + ".locationFilterList") &&
            success;

        i++;
      }
    }
  }

  return success;
}

bool AmfEvent::operator==(const AmfEvent& rhs) const {
  return

      ((getType() == rhs.getType()) &&

       ((!immediateFlagIsSet() && !rhs.immediateFlagIsSet()) ||
        (immediateFlagIsSet() && rhs.immediateFlagIsSet() &&
         isImmediateFlag() == rhs.isImmediateFlag())) &&

       ((!areaListIsSet() && !rhs.areaListIsSet()) ||
        (areaListIsSet() && rhs.areaListIsSet() &&
         getAreaList() == rhs.getAreaList())) &&

       ((!locationFilterListIsSet() && !rhs.locationFilterListIsSet()) ||
        (locationFilterListIsSet() && rhs.locationFilterListIsSet() &&
         getLocationFilterList() == rhs.getLocationFilterList())) &&

       ((!refIdIsSet() && !rhs.refIdIsSet()) ||
        (refIdIsSet() && rhs.refIdIsSet() && getRefId() == rhs.getRefId())))

          ;
}

bool AmfEvent::operator!=(const AmfEvent& rhs) const {
  return !(*this == rhs);
}

void to_json(nlohmann::json& j, const AmfEvent& o) {
  j         = nlohmann::json();
  j["type"] = o.m_Type;
  if (o.immediateFlagIsSet()) j["immediateFlag"] = o.m_ImmediateFlag;
  if (o.areaListIsSet() || !o.m_AreaList.empty()) j["areaList"] = o.m_AreaList;
  if (o.locationFilterListIsSet() || !o.m_LocationFilterList.empty())
    j["locationFilterList"] = o.m_LocationFilterList;
  if (o.refIdIsSet()) j["refId"] = o.m_RefId;
}

void from_json(const nlohmann::json& j, AmfEvent& o) {
  j.at("type").get_to(o.m_Type);
  if (j.find("immediateFlag") != j.end()) {
    j.at("immediateFlag").get_to(o.m_ImmediateFlag);
    o.m_ImmediateFlagIsSet = true;
  }
  if (j.find("areaList") != j.end()) {
    j.at("areaList").get_to(o.m_AreaList);
    o.m_AreaListIsSet = true;
  }
  if (j.find("locationFilterList") != j.end()) {
    j.at("locationFilterList").get_to(o.m_LocationFilterList);
    o.m_LocationFilterListIsSet = true;
  }
  if (j.find("refId") != j.end()) {
    j.at("refId").get_to(o.m_RefId);
    o.m_RefIdIsSet = true;
  }
}

AmfEventType AmfEvent::getType() const {
  return m_Type;
}
void AmfEvent::setType(AmfEventType const& value) {
  m_Type = value;
}
bool AmfEvent::isImmediateFlag() const {
  return m_ImmediateFlag;
}
void AmfEvent::setImmediateFlag(bool const value) {
  m_ImmediateFlag      = value;
  m_ImmediateFlagIsSet = true;
}
bool AmfEvent::immediateFlagIsSet() const {
  return m_ImmediateFlagIsSet;
}
void AmfEvent::unsetImmediateFlag() {
  m_ImmediateFlagIsSet = false;
}
std::vector<AmfEventArea> AmfEvent::getAreaList() const {
  return m_AreaList;
}
void AmfEvent::setAreaList(std::vector<AmfEventArea> const& value) {
  m_AreaList      = value;
  m_AreaListIsSet = true;
}
bool AmfEvent::areaListIsSet() const {
  return m_AreaListIsSet;
}
void AmfEvent::unsetAreaList() {
  m_AreaListIsSet = false;
}
std::vector<LocationFilter> AmfEvent::getLocationFilterList() const {
  return m_LocationFilterList;
}
void AmfEvent::setLocationFilterList(std::vector<LocationFilter> const& value) {
  m_LocationFilterList      = value;
  m_LocationFilterListIsSet = true;
}
bool AmfEvent::locationFilterListIsSet() const {
  return m_LocationFilterListIsSet;
}
void AmfEvent::unsetLocationFilterList() {
  m_LocationFilterListIsSet = false;
}
int32_t AmfEvent::getRefId() const {
  return m_RefId;
}
void AmfEvent::setRefId(int32_t const value) {
  m_RefId      = value;
  m_RefIdIsSet = true;
}
bool AmfEvent::refIdIsSet() const {
  return m_RefIdIsSet;
}
void AmfEvent::unsetRefId() {
  m_RefIdIsSet = false;
}

}  // namespace oai::amf::model
