/**
 * Namf_EventExposure
 * AMF Event Exposure Service © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 *
 * NOTE: This class is auto generated by OpenAPI Generator
 * (https://openapi-generator.tech). https://openapi-generator.tech Do not edit
 * the class manually.
 */

#include "AmfEventState.h"
#include "Helpers.h"

#include <sstream>

namespace oai::amf::model {

AmfEventState::AmfEventState() {
  m_Active              = false;
  m_RemainReports       = 0;
  m_RemainReportsIsSet  = false;
  m_RemainDuration      = 0;
  m_RemainDurationIsSet = false;
}

void AmfEventState::validate() const {
  std::stringstream msg;
  if (!validate(msg)) {
    throw oai::amf::helpers::ValidationException(msg.str());
  }
}

bool AmfEventState::validate(std::stringstream& msg) const {
  return validate(msg, "");
}

bool AmfEventState::validate(
    std::stringstream& msg, const std::string& pathPrefix) const {
  bool success = true;
  const std::string _pathPrefix =
      pathPrefix.empty() ? "AmfEventState" : pathPrefix;

  return success;
}

bool AmfEventState::operator==(const AmfEventState& rhs) const {
  return

      (isActive() == rhs.isActive()) &&

      ((!remainReportsIsSet() && !rhs.remainReportsIsSet()) ||
       (remainReportsIsSet() && rhs.remainReportsIsSet() &&
        getRemainReports() == rhs.getRemainReports())) &&

      ((!remainDurationIsSet() && !rhs.remainDurationIsSet()) ||
       (remainDurationIsSet() && rhs.remainDurationIsSet() &&
        getRemainDuration() == rhs.getRemainDuration()))

          ;
}

bool AmfEventState::operator!=(const AmfEventState& rhs) const {
  return !(*this == rhs);
}

void to_json(nlohmann::json& j, const AmfEventState& o) {
  j           = nlohmann::json();
  j["active"] = o.m_Active;
  if (o.remainReportsIsSet()) j["remainReports"] = o.m_RemainReports;
  if (o.remainDurationIsSet()) j["remainDuration"] = o.m_RemainDuration;
}

void from_json(const nlohmann::json& j, AmfEventState& o) {
  j.at("active").get_to(o.m_Active);
  if (j.find("remainReports") != j.end()) {
    j.at("remainReports").get_to(o.m_RemainReports);
    o.m_RemainReportsIsSet = true;
  }
  if (j.find("remainDuration") != j.end()) {
    j.at("remainDuration").get_to(o.m_RemainDuration);
    o.m_RemainDurationIsSet = true;
  }
}

bool AmfEventState::isActive() const {
  return m_Active;
}
void AmfEventState::setActive(bool const value) {
  m_Active = value;
}
int32_t AmfEventState::getRemainReports() const {
  return m_RemainReports;
}
void AmfEventState::setRemainReports(int32_t const value) {
  m_RemainReports      = value;
  m_RemainReportsIsSet = true;
}
bool AmfEventState::remainReportsIsSet() const {
  return m_RemainReportsIsSet;
}
void AmfEventState::unsetRemainReports() {
  m_RemainReportsIsSet = false;
}
int32_t AmfEventState::getRemainDuration() const {
  return m_RemainDuration;
}
void AmfEventState::setRemainDuration(int32_t const value) {
  m_RemainDuration      = value;
  m_RemainDurationIsSet = true;
}
bool AmfEventState::remainDurationIsSet() const {
  return m_RemainDurationIsSet;
}
void AmfEventState::unsetRemainDuration() {
  m_RemainDurationIsSet = false;
}

}  // namespace oai::amf::model
