/**
 * Nsmf_PDUSession
 * SMF PDU Session Service. © 2019, 3GPP Organizational Partners (ARIB, ATIS,
 * CCSA, ETSI, TSDSI, TTA, TTC). All rights reserved.
 *
 * The version of the OpenAPI document: 1.1.0.alpha-1
 *
 * NOTE: This class is auto generated by OpenAPI-Generator 4.1.1-SNAPSHOT.
 * https://openapi-generator.tech
 * Do not edit the class manually.
 */

#include "HsmfUpdateData.h"

namespace oai {
namespace smf {
namespace model {

HsmfUpdateData::HsmfUpdateData() {
  m_Pei                          = utility::conversions::to_string_t("");
  m_PeiIsSet                     = false;
  m_VcnTunnelInfoIsSet           = false;
  m_ServingNetworkIsSet          = false;
  m_AnTypeIsSet                  = false;
  m_SecondAnTypeIsSet            = false;
  m_RatTypeIsSet                 = false;
  m_UeLocationIsSet              = false;
  m_UeTimeZone                   = utility::conversions::to_string_t("");
  m_UeTimeZoneIsSet              = false;
  m_AddUeLocationIsSet           = false;
  m_PauseCharging                = false;
  m_PauseChargingIsSet           = false;
  m_Pti                          = 0;
  m_PtiIsSet                     = false;
  m_N1SmInfoFromUeIsSet          = false;
  m_UnknownN1SmInfoIsSet         = false;
  m_QosFlowsRelNotifyListIsSet   = false;
  m_QosFlowsNotifyListIsSet      = false;
  m_NotifyListIsSet              = false;
  m_EpsBearerIdIsSet             = false;
  m_HoPreparationIndication      = false;
  m_HoPreparationIndicationIsSet = false;
  m_RevokeEbiListIsSet           = false;
  m_CauseIsSet                   = false;
  m_NgApCauseIsSet               = false;
  m__5gMmCauseValue              = 0;
  m__5gMmCauseValueIsSet         = false;
  m_AlwaysOnRequested            = false;
  m_AlwaysOnRequestedIsSet       = false;
  m_EpsInterworkingIndIsSet      = false;
  m_SecondaryRatUsageReportIsSet = false;
  m_SecondaryRatUsageInfoIsSet   = false;
  m_AnTypeCanBeChanged           = false;
  m_AnTypeCanBeChangedIsSet      = false;
  m_MaReleaseIndIsSet            = false;
}

HsmfUpdateData::~HsmfUpdateData() {}

void HsmfUpdateData::validate() {
  // TODO: implement validation
}

web::json::value HsmfUpdateData::toJson() const {
  web::json::value val = web::json::value::object();

  val[utility::conversions::to_string_t("requestIndication")] =
      ModelBase::toJson(m_RequestIndication);
  if (m_PeiIsSet) {
    val[utility::conversions::to_string_t("pei")] = ModelBase::toJson(m_Pei);
  }
  if (m_VcnTunnelInfoIsSet) {
    val[utility::conversions::to_string_t("vcnTunnelInfo")] =
        ModelBase::toJson(m_VcnTunnelInfo);
  }
  if (m_ServingNetworkIsSet) {
    val[utility::conversions::to_string_t("servingNetwork")] =
        ModelBase::toJson(m_ServingNetwork);
  }
  if (m_AnTypeIsSet) {
    val[utility::conversions::to_string_t("anType")] =
        ModelBase::toJson(m_AnType);
  }
  if (m_SecondAnTypeIsSet) {
    val[utility::conversions::to_string_t("secondAnType")] =
        ModelBase::toJson(m_SecondAnType);
  }
  if (m_RatTypeIsSet) {
    val[utility::conversions::to_string_t("ratType")] =
        ModelBase::toJson(m_RatType);
  }
  if (m_UeLocationIsSet) {
    val[utility::conversions::to_string_t("ueLocation")] =
        ModelBase::toJson(m_UeLocation);
  }
  if (m_UeTimeZoneIsSet) {
    val[utility::conversions::to_string_t("ueTimeZone")] =
        ModelBase::toJson(m_UeTimeZone);
  }
  if (m_AddUeLocationIsSet) {
    val[utility::conversions::to_string_t("addUeLocation")] =
        ModelBase::toJson(m_AddUeLocation);
  }
  if (m_PauseChargingIsSet) {
    val[utility::conversions::to_string_t("pauseCharging")] =
        ModelBase::toJson(m_PauseCharging);
  }
  if (m_PtiIsSet) {
    val[utility::conversions::to_string_t("pti")] = ModelBase::toJson(m_Pti);
  }
  if (m_N1SmInfoFromUeIsSet) {
    val[utility::conversions::to_string_t("n1SmInfoFromUe")] =
        ModelBase::toJson(m_N1SmInfoFromUe);
  }
  if (m_UnknownN1SmInfoIsSet) {
    val[utility::conversions::to_string_t("unknownN1SmInfo")] =
        ModelBase::toJson(m_UnknownN1SmInfo);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_QosFlowsRelNotifyList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("qosFlowsRelNotifyList")] =
          web::json::value::array(jsonArray);
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_QosFlowsNotifyList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("qosFlowsNotifyList")] =
          web::json::value::array(jsonArray);
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_NotifyList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("NotifyList")] =
          web::json::value::array(jsonArray);
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_EpsBearerId) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("epsBearerId")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_HoPreparationIndicationIsSet) {
    val[utility::conversions::to_string_t("hoPreparationIndication")] =
        ModelBase::toJson(m_HoPreparationIndication);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_RevokeEbiList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("revokeEbiList")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_CauseIsSet) {
    val[utility::conversions::to_string_t("cause")] =
        ModelBase::toJson(m_Cause);
  }
  if (m_NgApCauseIsSet) {
    val[utility::conversions::to_string_t("ngApCause")] =
        ModelBase::toJson(m_NgApCause);
  }
  if (m__5gMmCauseValueIsSet) {
    val[utility::conversions::to_string_t("5gMmCauseValue")] =
        ModelBase::toJson(m__5gMmCauseValue);
  }
  if (m_AlwaysOnRequestedIsSet) {
    val[utility::conversions::to_string_t("alwaysOnRequested")] =
        ModelBase::toJson(m_AlwaysOnRequested);
  }
  if (m_EpsInterworkingIndIsSet) {
    val[utility::conversions::to_string_t("epsInterworkingInd")] =
        ModelBase::toJson(m_EpsInterworkingInd);
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_SecondaryRatUsageReport) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("secondaryRatUsageReport")] =
          web::json::value::array(jsonArray);
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_SecondaryRatUsageInfo) {
      jsonArray.push_back(ModelBase::toJson(item));
    }
    if (jsonArray.size() > 0) {
      val[utility::conversions::to_string_t("secondaryRatUsageInfo")] =
          web::json::value::array(jsonArray);
    }
  }
  if (m_AnTypeCanBeChangedIsSet) {
    val[utility::conversions::to_string_t("anTypeCanBeChanged")] =
        ModelBase::toJson(m_AnTypeCanBeChanged);
  }
  if (m_MaReleaseIndIsSet) {
    val[utility::conversions::to_string_t("maReleaseInd")] =
        ModelBase::toJson(m_MaReleaseInd);
  }

  return val;
}

void HsmfUpdateData::fromJson(const web::json::value& val) {
  std::shared_ptr<RequestIndication> newRequestIndication(
      new RequestIndication());
  newRequestIndication->fromJson(
      val.at(utility::conversions::to_string_t("requestIndication")));
  setRequestIndication(newRequestIndication);
  if (val.has_field(utility::conversions::to_string_t("pei"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pei"));
    if (!fieldValue.is_null()) {
      setPei(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("vcnTunnelInfo"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("vcnTunnelInfo"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<TunnelInfo> newItem(new TunnelInfo());
      newItem->fromJson(fieldValue);
      setVcnTunnelInfo(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("servingNetwork"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("servingNetwork"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<PlmnId> newItem(new PlmnId());
      newItem->fromJson(fieldValue);
      setServingNetwork(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("anType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("anType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromJson(fieldValue);
      setAnType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("secondAnType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("secondAnType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromJson(fieldValue);
      setSecondAnType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ratType"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ratType"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromJson(fieldValue);
      setRatType(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setUeLocation(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ueTimeZone"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ueTimeZone"));
    if (!fieldValue.is_null()) {
      setUeTimeZone(ModelBase::stringFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("addUeLocation"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("addUeLocation"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromJson(fieldValue);
      setAddUeLocation(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pauseCharging"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pauseCharging"));
    if (!fieldValue.is_null()) {
      setPauseCharging(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("pti"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("pti"));
    if (!fieldValue.is_null()) {
      setPti(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("n1SmInfoFromUe"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("n1SmInfoFromUe"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setN1SmInfoFromUe(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("unknownN1SmInfo"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("unknownN1SmInfo"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromJson(fieldValue);
      setUnknownN1SmInfo(newItem);
    }
  }
  {
    m_QosFlowsRelNotifyList.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(
            utility::conversions::to_string_t("qosFlowsRelNotifyList"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("qosFlowsRelNotifyList"))
               .as_array()) {
        if (item.is_null()) {
          m_QosFlowsRelNotifyList.push_back(
              std::shared_ptr<QosFlowItem>(nullptr));
        } else {
          std::shared_ptr<QosFlowItem> newItem(new QosFlowItem());
          newItem->fromJson(item);
          m_QosFlowsRelNotifyList.push_back(newItem);
        }
      }
    }
  }
  {
    m_QosFlowsNotifyList.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(
            utility::conversions::to_string_t("qosFlowsNotifyList"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("qosFlowsNotifyList"))
               .as_array()) {
        if (item.is_null()) {
          m_QosFlowsNotifyList.push_back(
              std::shared_ptr<QosFlowNotifyItem>(nullptr));
        } else {
          std::shared_ptr<QosFlowNotifyItem> newItem(new QosFlowNotifyItem());
          newItem->fromJson(item);
          m_QosFlowsNotifyList.push_back(newItem);
        }
      }
    }
  }
  {
    m_NotifyList.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("NotifyList"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("NotifyList")).as_array()) {
        if (item.is_null()) {
          m_NotifyList.push_back(
              std::shared_ptr<PduSessionNotifyItem>(nullptr));
        } else {
          std::shared_ptr<PduSessionNotifyItem> newItem(
              new PduSessionNotifyItem());
          newItem->fromJson(item);
          m_NotifyList.push_back(newItem);
        }
      }
    }
  }
  {
    m_EpsBearerId.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("epsBearerId"))) {
      for (auto& item : val.at(utility::conversions::to_string_t("epsBearerId"))
                            .as_array()) {
        m_EpsBearerId.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (val.has_field(
          utility::conversions::to_string_t("hoPreparationIndication"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("hoPreparationIndication"));
    if (!fieldValue.is_null()) {
      setHoPreparationIndication(ModelBase::boolFromJson(fieldValue));
    }
  }
  {
    m_RevokeEbiList.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(utility::conversions::to_string_t("revokeEbiList"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("revokeEbiList"))
               .as_array()) {
        m_RevokeEbiList.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("cause"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("cause"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<Cause> newItem(new Cause());
      newItem->fromJson(fieldValue);
      setCause(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("ngApCause"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("ngApCause"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<NgApCause> newItem(new NgApCause());
      newItem->fromJson(fieldValue);
      setNgApCause(newItem);
    }
  }
  if (val.has_field(utility::conversions::to_string_t("5gMmCauseValue"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("5gMmCauseValue"));
    if (!fieldValue.is_null()) {
      set5gMmCauseValue(ModelBase::int32_tFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("alwaysOnRequested"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("alwaysOnRequested"));
    if (!fieldValue.is_null()) {
      setAlwaysOnRequested(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("epsInterworkingInd"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("epsInterworkingInd"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromJson(fieldValue);
      setEpsInterworkingInd(newItem);
    }
  }
  {
    m_SecondaryRatUsageReport.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(
            utility::conversions::to_string_t("secondaryRatUsageReport"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("secondaryRatUsageReport"))
               .as_array()) {
        if (item.is_null()) {
          m_SecondaryRatUsageReport.push_back(
              std::shared_ptr<SecondaryRatUsageReport>(nullptr));
        } else {
          std::shared_ptr<SecondaryRatUsageReport> newItem(
              new SecondaryRatUsageReport());
          newItem->fromJson(item);
          m_SecondaryRatUsageReport.push_back(newItem);
        }
      }
    }
  }
  {
    m_SecondaryRatUsageInfo.clear();
    std::vector<web::json::value> jsonArray;
    if (val.has_field(
            utility::conversions::to_string_t("secondaryRatUsageInfo"))) {
      for (auto& item :
           val.at(utility::conversions::to_string_t("secondaryRatUsageInfo"))
               .as_array()) {
        if (item.is_null()) {
          m_SecondaryRatUsageInfo.push_back(
              std::shared_ptr<SecondaryRatUsageInfo>(nullptr));
        } else {
          std::shared_ptr<SecondaryRatUsageInfo> newItem(
              new SecondaryRatUsageInfo());
          newItem->fromJson(item);
          m_SecondaryRatUsageInfo.push_back(newItem);
        }
      }
    }
  }
  if (val.has_field(utility::conversions::to_string_t("anTypeCanBeChanged"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("anTypeCanBeChanged"));
    if (!fieldValue.is_null()) {
      setAnTypeCanBeChanged(ModelBase::boolFromJson(fieldValue));
    }
  }
  if (val.has_field(utility::conversions::to_string_t("maReleaseInd"))) {
    const web::json::value& fieldValue =
        val.at(utility::conversions::to_string_t("maReleaseInd"));
    if (!fieldValue.is_null()) {
      std::shared_ptr<MaReleaseIndication> newItem(new MaReleaseIndication());
      newItem->fromJson(fieldValue);
      setMaReleaseInd(newItem);
    }
  }
}

void HsmfUpdateData::toMultipart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) const {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  m_RequestIndication->toMultipart(
      multipart, utility::conversions::to_string_t("requestIndication."));
  if (m_PeiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("pei"), m_Pei));
  }
  if (m_VcnTunnelInfoIsSet) {
    if (m_VcnTunnelInfo.get()) {
      m_VcnTunnelInfo->toMultipart(
          multipart, utility::conversions::to_string_t("vcnTunnelInfo."));
    }
  }
  if (m_ServingNetworkIsSet) {
    if (m_ServingNetwork.get()) {
      m_ServingNetwork->toMultipart(
          multipart, utility::conversions::to_string_t("servingNetwork."));
    }
  }
  if (m_AnTypeIsSet) {
    if (m_AnType.get()) {
      m_AnType->toMultipart(
          multipart, utility::conversions::to_string_t("anType."));
    }
  }
  if (m_SecondAnTypeIsSet) {
    if (m_SecondAnType.get()) {
      m_SecondAnType->toMultipart(
          multipart, utility::conversions::to_string_t("secondAnType."));
    }
  }
  if (m_RatTypeIsSet) {
    if (m_RatType.get()) {
      m_RatType->toMultipart(
          multipart, utility::conversions::to_string_t("ratType."));
    }
  }
  if (m_UeLocationIsSet) {
    if (m_UeLocation.get()) {
      m_UeLocation->toMultipart(
          multipart, utility::conversions::to_string_t("ueLocation."));
    }
  }
  if (m_UeTimeZoneIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("ueTimeZone"),
        m_UeTimeZone));
  }
  if (m_AddUeLocationIsSet) {
    if (m_AddUeLocation.get()) {
      m_AddUeLocation->toMultipart(
          multipart, utility::conversions::to_string_t("addUeLocation."));
    }
  }
  if (m_PauseChargingIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("pauseCharging"),
        m_PauseCharging));
  }
  if (m_PtiIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("pti"), m_Pti));
  }
  if (m_N1SmInfoFromUeIsSet) {
    if (m_N1SmInfoFromUe.get()) {
      m_N1SmInfoFromUe->toMultipart(
          multipart, utility::conversions::to_string_t("n1SmInfoFromUe."));
    }
  }
  if (m_UnknownN1SmInfoIsSet) {
    if (m_UnknownN1SmInfo.get()) {
      m_UnknownN1SmInfo->toMultipart(
          multipart, utility::conversions::to_string_t("unknownN1SmInfo."));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_QosFlowsRelNotifyList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix +
              utility::conversions::to_string_t("qosFlowsRelNotifyList"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_QosFlowsNotifyList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("qosFlowsNotifyList"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_NotifyList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("NotifyList"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_EpsBearerId) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("epsBearerId"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_HoPreparationIndicationIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix +
            utility::conversions::to_string_t("hoPreparationIndication"),
        m_HoPreparationIndication));
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_RevokeEbiList) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix + utility::conversions::to_string_t("revokeEbiList"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_CauseIsSet) {
    if (m_Cause.get()) {
      m_Cause->toMultipart(
          multipart, utility::conversions::to_string_t("cause."));
    }
  }
  if (m_NgApCauseIsSet) {
    if (m_NgApCause.get()) {
      m_NgApCause->toMultipart(
          multipart, utility::conversions::to_string_t("ngApCause."));
    }
  }
  if (m__5gMmCauseValueIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("5gMmCauseValue"),
        m__5gMmCauseValue));
  }
  if (m_AlwaysOnRequestedIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("alwaysOnRequested"),
        m_AlwaysOnRequested));
  }
  if (m_EpsInterworkingIndIsSet) {
    if (m_EpsInterworkingInd.get()) {
      m_EpsInterworkingInd->toMultipart(
          multipart, utility::conversions::to_string_t("epsInterworkingInd."));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_SecondaryRatUsageReport) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix +
              utility::conversions::to_string_t("secondaryRatUsageReport"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  {
    std::vector<web::json::value> jsonArray;
    for (auto& item : m_SecondaryRatUsageInfo) {
      jsonArray.push_back(ModelBase::toJson(item));
    }

    if (jsonArray.size() > 0) {
      multipart->add(ModelBase::toHttpContent(
          namePrefix +
              utility::conversions::to_string_t("secondaryRatUsageInfo"),
          web::json::value::array(jsonArray),
          utility::conversions::to_string_t("application/json")));
    }
  }
  if (m_AnTypeCanBeChangedIsSet) {
    multipart->add(ModelBase::toHttpContent(
        namePrefix + utility::conversions::to_string_t("anTypeCanBeChanged"),
        m_AnTypeCanBeChanged));
  }
  if (m_MaReleaseIndIsSet) {
    if (m_MaReleaseInd.get()) {
      m_MaReleaseInd->toMultipart(
          multipart, utility::conversions::to_string_t("maReleaseInd."));
    }
  }
}

void HsmfUpdateData::fromMultiPart(
    std::shared_ptr<MultipartFormData> multipart,
    const utility::string_t& prefix) {
  utility::string_t namePrefix = prefix;
  if (namePrefix.size() > 0 && namePrefix.substr(namePrefix.size() - 1) !=
                                   utility::conversions::to_string_t(".")) {
    namePrefix += utility::conversions::to_string_t(".");
  }

  std::shared_ptr<RequestIndication> newRequestIndication(
      new RequestIndication());
  newRequestIndication->fromMultiPart(
      multipart, utility::conversions::to_string_t("requestIndication."));
  setRequestIndication(newRequestIndication);
  if (multipart->hasContent(utility::conversions::to_string_t("pei"))) {
    setPei(ModelBase::stringFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("pei"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("vcnTunnelInfo"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("vcnTunnelInfo"))) {
      std::shared_ptr<TunnelInfo> newItem(new TunnelInfo());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("vcnTunnelInfo."));
      setVcnTunnelInfo(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("servingNetwork"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("servingNetwork"))) {
      std::shared_ptr<PlmnId> newItem(new PlmnId());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("servingNetwork."));
      setServingNetwork(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("anType"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("anType"))) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("anType."));
      setAnType(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("secondAnType"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("secondAnType"))) {
      std::shared_ptr<AccessType> newItem(new AccessType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("secondAnType."));
      setSecondAnType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("ratType"))) {
      std::shared_ptr<RatType> newItem(new RatType());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ratType."));
      setRatType(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("ueLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ueLocation."));
      setUeLocation(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ueTimeZone"))) {
    setUeTimeZone(ModelBase::stringFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("ueTimeZone"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("addUeLocation"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("addUeLocation"))) {
      std::shared_ptr<UserLocation> newItem(new UserLocation());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("addUeLocation."));
      setAddUeLocation(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("pauseCharging"))) {
    setPauseCharging(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("pauseCharging"))));
  }
  if (multipart->hasContent(utility::conversions::to_string_t("pti"))) {
    setPti(ModelBase::int32_tFromHttpContent(
        multipart->getContent(utility::conversions::to_string_t("pti"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("n1SmInfoFromUe"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("n1SmInfoFromUe"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("n1SmInfoFromUe."));
      setN1SmInfoFromUe(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("unknownN1SmInfo"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("unknownN1SmInfo"))) {
      std::shared_ptr<RefToBinaryData> newItem(new RefToBinaryData());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("unknownN1SmInfo."));
      setUnknownN1SmInfo(newItem);
    }
  }
  {
    m_QosFlowsRelNotifyList.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("qosFlowsRelNotifyList"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("qosFlowsRelNotifyList"))));
      for (auto& item : jsonArray.as_array()) {
        if (item.is_null()) {
          m_QosFlowsRelNotifyList.push_back(
              std::shared_ptr<QosFlowItem>(nullptr));
        } else {
          std::shared_ptr<QosFlowItem> newItem(new QosFlowItem());
          newItem->fromJson(item);
          m_QosFlowsRelNotifyList.push_back(newItem);
        }
      }
    }
  }
  {
    m_QosFlowsNotifyList.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("qosFlowsNotifyList"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("qosFlowsNotifyList"))));
      for (auto& item : jsonArray.as_array()) {
        if (item.is_null()) {
          m_QosFlowsNotifyList.push_back(
              std::shared_ptr<QosFlowNotifyItem>(nullptr));
        } else {
          std::shared_ptr<QosFlowNotifyItem> newItem(new QosFlowNotifyItem());
          newItem->fromJson(item);
          m_QosFlowsNotifyList.push_back(newItem);
        }
      }
    }
  }
  {
    m_NotifyList.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("NotifyList"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("NotifyList"))));
      for (auto& item : jsonArray.as_array()) {
        if (item.is_null()) {
          m_NotifyList.push_back(
              std::shared_ptr<PduSessionNotifyItem>(nullptr));
        } else {
          std::shared_ptr<PduSessionNotifyItem> newItem(
              new PduSessionNotifyItem());
          newItem->fromJson(item);
          m_NotifyList.push_back(newItem);
        }
      }
    }
  }
  {
    m_EpsBearerId.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("epsBearerId"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("epsBearerId"))));
      for (auto& item : jsonArray.as_array()) {
        m_EpsBearerId.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("hoPreparationIndication"))) {
    setHoPreparationIndication(
        ModelBase::boolFromHttpContent(multipart->getContent(
            utility::conversions::to_string_t("hoPreparationIndication"))));
  }
  {
    m_RevokeEbiList.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("revokeEbiList"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("revokeEbiList"))));
      for (auto& item : jsonArray.as_array()) {
        m_RevokeEbiList.push_back(ModelBase::int32_tFromJson(item));
      }
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("cause"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("cause"))) {
      std::shared_ptr<Cause> newItem(new Cause());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("cause."));
      setCause(newItem);
    }
  }
  if (multipart->hasContent(utility::conversions::to_string_t("ngApCause"))) {
    if (multipart->hasContent(utility::conversions::to_string_t("ngApCause"))) {
      std::shared_ptr<NgApCause> newItem(new NgApCause());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("ngApCause."));
      setNgApCause(newItem);
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("5gMmCauseValue"))) {
    set5gMmCauseValue(ModelBase::int32_tFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("5gMmCauseValue"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("alwaysOnRequested"))) {
    setAlwaysOnRequested(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("alwaysOnRequested"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("epsInterworkingInd"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("epsInterworkingInd"))) {
      std::shared_ptr<EpsInterworkingIndication> newItem(
          new EpsInterworkingIndication());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("epsInterworkingInd."));
      setEpsInterworkingInd(newItem);
    }
  }
  {
    m_SecondaryRatUsageReport.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("secondaryRatUsageReport"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("secondaryRatUsageReport"))));
      for (auto& item : jsonArray.as_array()) {
        if (item.is_null()) {
          m_SecondaryRatUsageReport.push_back(
              std::shared_ptr<SecondaryRatUsageReport>(nullptr));
        } else {
          std::shared_ptr<SecondaryRatUsageReport> newItem(
              new SecondaryRatUsageReport());
          newItem->fromJson(item);
          m_SecondaryRatUsageReport.push_back(newItem);
        }
      }
    }
  }
  {
    m_SecondaryRatUsageInfo.clear();
    if (multipart->hasContent(
            utility::conversions::to_string_t("secondaryRatUsageInfo"))) {
      web::json::value jsonArray = web::json::value::parse(
          ModelBase::stringFromHttpContent(multipart->getContent(
              utility::conversions::to_string_t("secondaryRatUsageInfo"))));
      for (auto& item : jsonArray.as_array()) {
        if (item.is_null()) {
          m_SecondaryRatUsageInfo.push_back(
              std::shared_ptr<SecondaryRatUsageInfo>(nullptr));
        } else {
          std::shared_ptr<SecondaryRatUsageInfo> newItem(
              new SecondaryRatUsageInfo());
          newItem->fromJson(item);
          m_SecondaryRatUsageInfo.push_back(newItem);
        }
      }
    }
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("anTypeCanBeChanged"))) {
    setAnTypeCanBeChanged(ModelBase::boolFromHttpContent(multipart->getContent(
        utility::conversions::to_string_t("anTypeCanBeChanged"))));
  }
  if (multipart->hasContent(
          utility::conversions::to_string_t("maReleaseInd"))) {
    if (multipart->hasContent(
            utility::conversions::to_string_t("maReleaseInd"))) {
      std::shared_ptr<MaReleaseIndication> newItem(new MaReleaseIndication());
      newItem->fromMultiPart(
          multipart, utility::conversions::to_string_t("maReleaseInd."));
      setMaReleaseInd(newItem);
    }
  }
}

std::shared_ptr<RequestIndication> HsmfUpdateData::getRequestIndication()
    const {
  return m_RequestIndication;
}

void HsmfUpdateData::setRequestIndication(
    const std::shared_ptr<RequestIndication>& value) {
  m_RequestIndication = value;
}

utility::string_t HsmfUpdateData::getPei() const {
  return m_Pei;
}

void HsmfUpdateData::setPei(const utility::string_t& value) {
  m_Pei      = value;
  m_PeiIsSet = true;
}

bool HsmfUpdateData::peiIsSet() const {
  return m_PeiIsSet;
}

void HsmfUpdateData::unsetPei() {
  m_PeiIsSet = false;
}

std::shared_ptr<TunnelInfo> HsmfUpdateData::getVcnTunnelInfo() const {
  return m_VcnTunnelInfo;
}

void HsmfUpdateData::setVcnTunnelInfo(
    const std::shared_ptr<TunnelInfo>& value) {
  m_VcnTunnelInfo      = value;
  m_VcnTunnelInfoIsSet = true;
}

bool HsmfUpdateData::vcnTunnelInfoIsSet() const {
  return m_VcnTunnelInfoIsSet;
}

void HsmfUpdateData::unsetVcnTunnelInfo() {
  m_VcnTunnelInfoIsSet = false;
}

std::shared_ptr<PlmnId> HsmfUpdateData::getServingNetwork() const {
  return m_ServingNetwork;
}

void HsmfUpdateData::setServingNetwork(const std::shared_ptr<PlmnId>& value) {
  m_ServingNetwork      = value;
  m_ServingNetworkIsSet = true;
}

bool HsmfUpdateData::servingNetworkIsSet() const {
  return m_ServingNetworkIsSet;
}

void HsmfUpdateData::unsetServingNetwork() {
  m_ServingNetworkIsSet = false;
}

std::shared_ptr<AccessType> HsmfUpdateData::getAnType() const {
  return m_AnType;
}

void HsmfUpdateData::setAnType(const std::shared_ptr<AccessType>& value) {
  m_AnType      = value;
  m_AnTypeIsSet = true;
}

bool HsmfUpdateData::anTypeIsSet() const {
  return m_AnTypeIsSet;
}

void HsmfUpdateData::unsetAnType() {
  m_AnTypeIsSet = false;
}

std::shared_ptr<AccessType> HsmfUpdateData::getSecondAnType() const {
  return m_SecondAnType;
}

void HsmfUpdateData::setSecondAnType(const std::shared_ptr<AccessType>& value) {
  m_SecondAnType      = value;
  m_SecondAnTypeIsSet = true;
}

bool HsmfUpdateData::secondAnTypeIsSet() const {
  return m_SecondAnTypeIsSet;
}

void HsmfUpdateData::unsetSecondAnType() {
  m_SecondAnTypeIsSet = false;
}

std::shared_ptr<RatType> HsmfUpdateData::getRatType() const {
  return m_RatType;
}

void HsmfUpdateData::setRatType(const std::shared_ptr<RatType>& value) {
  m_RatType      = value;
  m_RatTypeIsSet = true;
}

bool HsmfUpdateData::ratTypeIsSet() const {
  return m_RatTypeIsSet;
}

void HsmfUpdateData::unsetRatType() {
  m_RatTypeIsSet = false;
}

std::shared_ptr<UserLocation> HsmfUpdateData::getUeLocation() const {
  return m_UeLocation;
}

void HsmfUpdateData::setUeLocation(const std::shared_ptr<UserLocation>& value) {
  m_UeLocation      = value;
  m_UeLocationIsSet = true;
}

bool HsmfUpdateData::ueLocationIsSet() const {
  return m_UeLocationIsSet;
}

void HsmfUpdateData::unsetUeLocation() {
  m_UeLocationIsSet = false;
}

utility::string_t HsmfUpdateData::getUeTimeZone() const {
  return m_UeTimeZone;
}

void HsmfUpdateData::setUeTimeZone(const utility::string_t& value) {
  m_UeTimeZone      = value;
  m_UeTimeZoneIsSet = true;
}

bool HsmfUpdateData::ueTimeZoneIsSet() const {
  return m_UeTimeZoneIsSet;
}

void HsmfUpdateData::unsetUeTimeZone() {
  m_UeTimeZoneIsSet = false;
}

std::shared_ptr<UserLocation> HsmfUpdateData::getAddUeLocation() const {
  return m_AddUeLocation;
}

void HsmfUpdateData::setAddUeLocation(
    const std::shared_ptr<UserLocation>& value) {
  m_AddUeLocation      = value;
  m_AddUeLocationIsSet = true;
}

bool HsmfUpdateData::addUeLocationIsSet() const {
  return m_AddUeLocationIsSet;
}

void HsmfUpdateData::unsetAddUeLocation() {
  m_AddUeLocationIsSet = false;
}

bool HsmfUpdateData::isPauseCharging() const {
  return m_PauseCharging;
}

void HsmfUpdateData::setPauseCharging(bool value) {
  m_PauseCharging      = value;
  m_PauseChargingIsSet = true;
}

bool HsmfUpdateData::pauseChargingIsSet() const {
  return m_PauseChargingIsSet;
}

void HsmfUpdateData::unsetPauseCharging() {
  m_PauseChargingIsSet = false;
}

int32_t HsmfUpdateData::getPti() const {
  return m_Pti;
}

void HsmfUpdateData::setPti(int32_t value) {
  m_Pti      = value;
  m_PtiIsSet = true;
}

bool HsmfUpdateData::ptiIsSet() const {
  return m_PtiIsSet;
}

void HsmfUpdateData::unsetPti() {
  m_PtiIsSet = false;
}

std::shared_ptr<RefToBinaryData> HsmfUpdateData::getN1SmInfoFromUe() const {
  return m_N1SmInfoFromUe;
}

void HsmfUpdateData::setN1SmInfoFromUe(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_N1SmInfoFromUe      = value;
  m_N1SmInfoFromUeIsSet = true;
}

bool HsmfUpdateData::n1SmInfoFromUeIsSet() const {
  return m_N1SmInfoFromUeIsSet;
}

void HsmfUpdateData::unsetN1SmInfoFromUe() {
  m_N1SmInfoFromUeIsSet = false;
}

std::shared_ptr<RefToBinaryData> HsmfUpdateData::getUnknownN1SmInfo() const {
  return m_UnknownN1SmInfo;
}

void HsmfUpdateData::setUnknownN1SmInfo(
    const std::shared_ptr<RefToBinaryData>& value) {
  m_UnknownN1SmInfo      = value;
  m_UnknownN1SmInfoIsSet = true;
}

bool HsmfUpdateData::unknownN1SmInfoIsSet() const {
  return m_UnknownN1SmInfoIsSet;
}

void HsmfUpdateData::unsetUnknownN1SmInfo() {
  m_UnknownN1SmInfoIsSet = false;
}

std::vector<std::shared_ptr<QosFlowItem>>&
HsmfUpdateData::getQosFlowsRelNotifyList() {
  return m_QosFlowsRelNotifyList;
}

void HsmfUpdateData::setQosFlowsRelNotifyList(
    const std::vector<std::shared_ptr<QosFlowItem>>& value) {
  m_QosFlowsRelNotifyList      = value;
  m_QosFlowsRelNotifyListIsSet = true;
}

bool HsmfUpdateData::qosFlowsRelNotifyListIsSet() const {
  return m_QosFlowsRelNotifyListIsSet;
}

void HsmfUpdateData::unsetQosFlowsRelNotifyList() {
  m_QosFlowsRelNotifyListIsSet = false;
}

std::vector<std::shared_ptr<QosFlowNotifyItem>>&
HsmfUpdateData::getQosFlowsNotifyList() {
  return m_QosFlowsNotifyList;
}

void HsmfUpdateData::setQosFlowsNotifyList(
    const std::vector<std::shared_ptr<QosFlowNotifyItem>>& value) {
  m_QosFlowsNotifyList      = value;
  m_QosFlowsNotifyListIsSet = true;
}

bool HsmfUpdateData::qosFlowsNotifyListIsSet() const {
  return m_QosFlowsNotifyListIsSet;
}

void HsmfUpdateData::unsetQosFlowsNotifyList() {
  m_QosFlowsNotifyListIsSet = false;
}

std::vector<std::shared_ptr<PduSessionNotifyItem>>&
HsmfUpdateData::getNotifyList() {
  return m_NotifyList;
}

void HsmfUpdateData::setNotifyList(
    const std::vector<std::shared_ptr<PduSessionNotifyItem>>& value) {
  m_NotifyList      = value;
  m_NotifyListIsSet = true;
}

bool HsmfUpdateData::notifyListIsSet() const {
  return m_NotifyListIsSet;
}

void HsmfUpdateData::unsetNotifyList() {
  m_NotifyListIsSet = false;
}

std::vector<int32_t>& HsmfUpdateData::getEpsBearerId() {
  return m_EpsBearerId;
}

void HsmfUpdateData::setEpsBearerId(std::vector<int32_t> value) {
  m_EpsBearerId      = value;
  m_EpsBearerIdIsSet = true;
}

bool HsmfUpdateData::epsBearerIdIsSet() const {
  return m_EpsBearerIdIsSet;
}

void HsmfUpdateData::unsetEpsBearerId() {
  m_EpsBearerIdIsSet = false;
}

bool HsmfUpdateData::isHoPreparationIndication() const {
  return m_HoPreparationIndication;
}

void HsmfUpdateData::setHoPreparationIndication(bool value) {
  m_HoPreparationIndication      = value;
  m_HoPreparationIndicationIsSet = true;
}

bool HsmfUpdateData::hoPreparationIndicationIsSet() const {
  return m_HoPreparationIndicationIsSet;
}

void HsmfUpdateData::unsetHoPreparationIndication() {
  m_HoPreparationIndicationIsSet = false;
}

std::vector<int32_t>& HsmfUpdateData::getRevokeEbiList() {
  return m_RevokeEbiList;
}

void HsmfUpdateData::setRevokeEbiList(std::vector<int32_t> value) {
  m_RevokeEbiList      = value;
  m_RevokeEbiListIsSet = true;
}

bool HsmfUpdateData::revokeEbiListIsSet() const {
  return m_RevokeEbiListIsSet;
}

void HsmfUpdateData::unsetRevokeEbiList() {
  m_RevokeEbiListIsSet = false;
}

std::shared_ptr<Cause> HsmfUpdateData::getCause() const {
  return m_Cause;
}

void HsmfUpdateData::setCause(const std::shared_ptr<Cause>& value) {
  m_Cause      = value;
  m_CauseIsSet = true;
}

bool HsmfUpdateData::causeIsSet() const {
  return m_CauseIsSet;
}

void HsmfUpdateData::unsetCause() {
  m_CauseIsSet = false;
}

std::shared_ptr<NgApCause> HsmfUpdateData::getNgApCause() const {
  return m_NgApCause;
}

void HsmfUpdateData::setNgApCause(const std::shared_ptr<NgApCause>& value) {
  m_NgApCause      = value;
  m_NgApCauseIsSet = true;
}

bool HsmfUpdateData::ngApCauseIsSet() const {
  return m_NgApCauseIsSet;
}

void HsmfUpdateData::unsetNgApCause() {
  m_NgApCauseIsSet = false;
}

int32_t HsmfUpdateData::get5gMmCauseValue() const {
  return m__5gMmCauseValue;
}

void HsmfUpdateData::set5gMmCauseValue(int32_t value) {
  m__5gMmCauseValue      = value;
  m__5gMmCauseValueIsSet = true;
}

bool HsmfUpdateData::_5gMmCauseValueIsSet() const {
  return m__5gMmCauseValueIsSet;
}

void HsmfUpdateData::unset_5gMmCauseValue() {
  m__5gMmCauseValueIsSet = false;
}

bool HsmfUpdateData::isAlwaysOnRequested() const {
  return m_AlwaysOnRequested;
}

void HsmfUpdateData::setAlwaysOnRequested(bool value) {
  m_AlwaysOnRequested      = value;
  m_AlwaysOnRequestedIsSet = true;
}

bool HsmfUpdateData::alwaysOnRequestedIsSet() const {
  return m_AlwaysOnRequestedIsSet;
}

void HsmfUpdateData::unsetAlwaysOnRequested() {
  m_AlwaysOnRequestedIsSet = false;
}

std::shared_ptr<EpsInterworkingIndication>
HsmfUpdateData::getEpsInterworkingInd() const {
  return m_EpsInterworkingInd;
}

void HsmfUpdateData::setEpsInterworkingInd(
    const std::shared_ptr<EpsInterworkingIndication>& value) {
  m_EpsInterworkingInd      = value;
  m_EpsInterworkingIndIsSet = true;
}

bool HsmfUpdateData::epsInterworkingIndIsSet() const {
  return m_EpsInterworkingIndIsSet;
}

void HsmfUpdateData::unsetEpsInterworkingInd() {
  m_EpsInterworkingIndIsSet = false;
}

std::vector<std::shared_ptr<SecondaryRatUsageReport>>&
HsmfUpdateData::getSecondaryRatUsageReport() {
  return m_SecondaryRatUsageReport;
}

void HsmfUpdateData::setSecondaryRatUsageReport(
    const std::vector<std::shared_ptr<SecondaryRatUsageReport>>& value) {
  m_SecondaryRatUsageReport      = value;
  m_SecondaryRatUsageReportIsSet = true;
}

bool HsmfUpdateData::secondaryRatUsageReportIsSet() const {
  return m_SecondaryRatUsageReportIsSet;
}

void HsmfUpdateData::unsetSecondaryRatUsageReport() {
  m_SecondaryRatUsageReportIsSet = false;
}

std::vector<std::shared_ptr<SecondaryRatUsageInfo>>&
HsmfUpdateData::getSecondaryRatUsageInfo() {
  return m_SecondaryRatUsageInfo;
}

void HsmfUpdateData::setSecondaryRatUsageInfo(
    const std::vector<std::shared_ptr<SecondaryRatUsageInfo>>& value) {
  m_SecondaryRatUsageInfo      = value;
  m_SecondaryRatUsageInfoIsSet = true;
}

bool HsmfUpdateData::secondaryRatUsageInfoIsSet() const {
  return m_SecondaryRatUsageInfoIsSet;
}

void HsmfUpdateData::unsetSecondaryRatUsageInfo() {
  m_SecondaryRatUsageInfoIsSet = false;
}

bool HsmfUpdateData::isAnTypeCanBeChanged() const {
  return m_AnTypeCanBeChanged;
}

void HsmfUpdateData::setAnTypeCanBeChanged(bool value) {
  m_AnTypeCanBeChanged      = value;
  m_AnTypeCanBeChangedIsSet = true;
}

bool HsmfUpdateData::anTypeCanBeChangedIsSet() const {
  return m_AnTypeCanBeChangedIsSet;
}

void HsmfUpdateData::unsetAnTypeCanBeChanged() {
  m_AnTypeCanBeChangedIsSet = false;
}

std::shared_ptr<MaReleaseIndication> HsmfUpdateData::getMaReleaseInd() const {
  return m_MaReleaseInd;
}

void HsmfUpdateData::setMaReleaseInd(
    const std::shared_ptr<MaReleaseIndication>& value) {
  m_MaReleaseInd      = value;
  m_MaReleaseIndIsSet = true;
}

bool HsmfUpdateData::maReleaseIndIsSet() const {
  return m_MaReleaseIndIsSet;
}

void HsmfUpdateData::unsetMaReleaseInd() {
  m_MaReleaseIndIsSet = false;
}

}  // namespace model
}  // namespace smf
}  // namespace oai
