/*
 * Copyright 2022 Sequans Communications.
 *
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.0  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

#include "adbgSys.h"

static const char* adbgSys__EUTRA_CellId_Type__ToString(EUTRA_CellId_Type v)
{
	switch(v) {
		case eutra_Cell_NonSpecific: return "eutra_Cell_NonSpecific";
		case eutra_Cell1: return "eutra_Cell1";
		case eutra_Cell2: return "eutra_Cell2";
		case eutra_Cell3: return "eutra_Cell3";
		case eutra_Cell4: return "eutra_Cell4";
		case eutra_Cell6: return "eutra_Cell6";
		case eutra_Cell10: return "eutra_Cell10";
		case eutra_Cell11: return "eutra_Cell11";
		case eutra_Cell12: return "eutra_Cell12";
		case eutra_Cell13: return "eutra_Cell13";
		case eutra_Cell14: return "eutra_Cell14";
		case eutra_Cell23: return "eutra_Cell23";
		case eutra_Cell28: return "eutra_Cell28";
		case eutra_Cell29: return "eutra_Cell29";
		case eutra_Cell30: return "eutra_Cell30";
		case eutra_Cell31: return "eutra_Cell31";
		case eutra_CellA: return "eutra_CellA";
		case eutra_CellB: return "eutra_CellB";
		case eutra_CellC: return "eutra_CellC";
		case eutra_CellD: return "eutra_CellD";
		case eutra_CellE: return "eutra_CellE";
		case eutra_CellG: return "eutra_CellG";
		case eutra_CellH: return "eutra_CellH";
		case eutra_CellI: return "eutra_CellI";
		case eutra_CellJ: return "eutra_CellJ";
		case eutra_CellK: return "eutra_CellK";
		case eutra_CellL: return "eutra_CellL";
		case eutra_CellM: return "eutra_CellM";
		default: return "Unknown";
	}
}

static void _adbgSys__PmchLogicalChannel_Type(acpCtx_t _ctx, const struct PmchLogicalChannel_Type* p)
{
	adbgPrintLog(_ctx, "Pmch_InfoIndex := %u", (unsigned int)p->Pmch_InfoIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "LogicalChannelIdentity := %u", (unsigned int)p->LogicalChannelIdentity);
}

static void _adbgSys__MRB_Identity_Type(acpCtx_t _ctx, const struct MRB_Identity_Type* p)
{
	adbgPrintLog(_ctx, "Mbsfn_AreaId := %u", (unsigned int)p->Mbsfn_AreaId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PmchLogicalChannel := { ");
	_adbgSys__PmchLogicalChannel_Type(_ctx, &p->PmchLogicalChannel);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_MCC_SQN_PLMN_Identity_mcc_Optional(acpCtx_t _ctx, const struct SQN_MCC_SQN_PLMN_Identity_mcc_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 3; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_PLMN_Identity(acpCtx_t _ctx, const struct SQN_PLMN_Identity* p)
{
	adbgPrintLog(_ctx, "mcc := ");
	_adbgSys__SQN_MCC_SQN_PLMN_Identity_mcc_Optional(_ctx, &p->mcc);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mnc := '");
	for (size_t i1 = 0; i1 < p->mnc.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->mnc.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_TMGI_r9_plmn_Id_r9_Value(acpCtx_t _ctx, const union SQN_TMGI_r9_plmn_Id_r9_Value* p, enum SQN_TMGI_r9_plmn_Id_r9_Sel d)
{
	if (d == SQN_TMGI_r9_plmn_Id_r9_plmn_Index_r9) {
		adbgPrintLog(_ctx, "plmn_Index_r9 := %u", (unsigned int)p->plmn_Index_r9);
		return;
	}
	if (d == SQN_TMGI_r9_plmn_Id_r9_explicitValue_r9) {
		adbgPrintLog(_ctx, "explicitValue_r9 := { ");
		_adbgSys__SQN_PLMN_Identity(_ctx, &p->explicitValue_r9);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_TMGI_r9_plmn_Id_r9(acpCtx_t _ctx, const struct SQN_TMGI_r9_plmn_Id_r9* p)
{
	_adbgSys__SQN_TMGI_r9_plmn_Id_r9_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_TMGI_r9(acpCtx_t _ctx, const struct SQN_TMGI_r9* p)
{
	adbgPrintLog(_ctx, "plmn_Id_r9 := { ");
	_adbgSys__SQN_TMGI_r9_plmn_Id_r9(_ctx, &p->plmn_Id_r9);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "serviceId_r9 := '");
	for (size_t i1 = 0; i1 < 3; i1++) {
		adbgPrintLog(_ctx, "%02X", p->serviceId_r9[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__O1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional(acpCtx_t _ctx, const struct O1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 1; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MBMSSessionInfo_r13(acpCtx_t _ctx, const struct SQN_MBMSSessionInfo_r13* p)
{
	adbgPrintLog(_ctx, "tmgi_r13 := { ");
	_adbgSys__SQN_TMGI_r9(_ctx, &p->tmgi_r13);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sessionId_r13 := ");
	_adbgSys__O1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional(_ctx, &p->sessionId_r13);
}

static void _adbgSys__SC_MRB_Identity_Type(acpCtx_t _ctx, const struct SC_MRB_Identity_Type* p)
{
	adbgPrintLog(_ctx, "MbmsSessionInfo := { ");
	_adbgSys__SQN_MBMSSessionInfo_r13(_ctx, &p->MbmsSessionInfo);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__RadioBearerId_Type_Value(acpCtx_t _ctx, const union RadioBearerId_Type_Value* p, enum RadioBearerId_Type_Sel d)
{
	if (d == RadioBearerId_Type_Srb) {
		adbgPrintLog(_ctx, "Srb := %u", (unsigned int)p->Srb);
		return;
	}
	if (d == RadioBearerId_Type_Drb) {
		adbgPrintLog(_ctx, "Drb := %u", (unsigned int)p->Drb);
		return;
	}
	if (d == RadioBearerId_Type_Mrb) {
		adbgPrintLog(_ctx, "Mrb := { ");
		_adbgSys__MRB_Identity_Type(_ctx, &p->Mrb);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == RadioBearerId_Type_ScMrb) {
		adbgPrintLog(_ctx, "ScMrb := { ");
		_adbgSys__SC_MRB_Identity_Type(_ctx, &p->ScMrb);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__RadioBearerId_Type(acpCtx_t _ctx, const struct RadioBearerId_Type* p)
{
	_adbgSys__RadioBearerId_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__QosFlow_Identification_Type(acpCtx_t _ctx, const struct QosFlow_Identification_Type* p)
{
	adbgPrintLog(_ctx, "PDU_SessionId := %d", (int)p->PDU_SessionId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "QFI := %d", (int)p->QFI);
}

static void _adbgSys__RoutingInfo_Type_Value(acpCtx_t _ctx, const union RoutingInfo_Type_Value* p, enum RoutingInfo_Type_Sel d)
{
	if (d == RoutingInfo_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == RoutingInfo_Type_RadioBearerId) {
		adbgPrintLog(_ctx, "RadioBearerId := { ");
		_adbgSys__RadioBearerId_Type(_ctx, &p->RadioBearerId);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == RoutingInfo_Type_QosFlow) {
		adbgPrintLog(_ctx, "QosFlow := { ");
		_adbgSys__QosFlow_Identification_Type(_ctx, &p->QosFlow);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__RoutingInfo_Type(acpCtx_t _ctx, const struct RoutingInfo_Type* p)
{
	_adbgSys__RoutingInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SystemFrameNumberInfo_Type_Value(acpCtx_t _ctx, const union SystemFrameNumberInfo_Type_Value* p, enum SystemFrameNumberInfo_Type_Sel d)
{
	if (d == SystemFrameNumberInfo_Type_Number) {
		adbgPrintLog(_ctx, "Number := %u", (unsigned int)p->Number);
		return;
	}
	if (d == SystemFrameNumberInfo_Type_Any) {
		adbgPrintLog(_ctx, "Any := %s", (p->Any ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SystemFrameNumberInfo_Type(acpCtx_t _ctx, const struct SystemFrameNumberInfo_Type* p)
{
	_adbgSys__SystemFrameNumberInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SubFrameInfo_Type_Value(acpCtx_t _ctx, const union SubFrameInfo_Type_Value* p, enum SubFrameInfo_Type_Sel d)
{
	if (d == SubFrameInfo_Type_Number) {
		adbgPrintLog(_ctx, "Number := %u", (unsigned int)p->Number);
		return;
	}
	if (d == SubFrameInfo_Type_Any) {
		adbgPrintLog(_ctx, "Any := %s", (p->Any ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SubFrameInfo_Type(acpCtx_t _ctx, const struct SubFrameInfo_Type* p)
{
	_adbgSys__SubFrameInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__HyperSystemFrameNumberInfo_Type(acpCtx_t _ctx, const HyperSystemFrameNumberInfo_Type* p)
{
	_adbgSys__SystemFrameNumberInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SlotOffset_Type_Value(acpCtx_t _ctx, const union SlotOffset_Type_Value* p, enum SlotOffset_Type_Sel d)
{
	if (d == SlotOffset_Type_Numerology0) {
		adbgPrintLog(_ctx, "Numerology0 := %s", (p->Numerology0 ? "true" : "false"));
		return;
	}
	if (d == SlotOffset_Type_Numerology1) {
		adbgPrintLog(_ctx, "Numerology1 := %u", (unsigned int)p->Numerology1);
		return;
	}
	if (d == SlotOffset_Type_Numerology2) {
		adbgPrintLog(_ctx, "Numerology2 := %u", (unsigned int)p->Numerology2);
		return;
	}
	if (d == SlotOffset_Type_Numerology3) {
		adbgPrintLog(_ctx, "Numerology3 := %u", (unsigned int)p->Numerology3);
		return;
	}
	if (d == SlotOffset_Type_Numerology4) {
		adbgPrintLog(_ctx, "Numerology4 := %u", (unsigned int)p->Numerology4);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SlotOffset_Type(acpCtx_t _ctx, const struct SlotOffset_Type* p)
{
	_adbgSys__SlotOffset_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SlotTimingInfo_Type_Value(acpCtx_t _ctx, const union SlotTimingInfo_Type_Value* p, enum SlotTimingInfo_Type_Sel d)
{
	if (d == SlotTimingInfo_Type_SlotOffset) {
		adbgPrintLog(_ctx, "SlotOffset := { ");
		_adbgSys__SlotOffset_Type(_ctx, &p->SlotOffset);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SlotTimingInfo_Type_FirstSlot) {
		adbgPrintLog(_ctx, "FirstSlot := %s", (p->FirstSlot ? "true" : "false"));
		return;
	}
	if (d == SlotTimingInfo_Type_Any) {
		adbgPrintLog(_ctx, "Any := %s", (p->Any ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SlotTimingInfo_Type(acpCtx_t _ctx, const struct SlotTimingInfo_Type* p)
{
	_adbgSys__SlotTimingInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SubFrameTiming_Type(acpCtx_t _ctx, const struct SubFrameTiming_Type* p)
{
	adbgPrintLog(_ctx, "SFN := { ");
	_adbgSys__SystemFrameNumberInfo_Type(_ctx, &p->SFN);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Subframe := { ");
	_adbgSys__SubFrameInfo_Type(_ctx, &p->Subframe);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "HSFN := { ");
	_adbgSys__HyperSystemFrameNumberInfo_Type(_ctx, &p->HSFN);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Slot := { ");
	_adbgSys__SlotTimingInfo_Type(_ctx, &p->Slot);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__TimingInfo_Type_Value(acpCtx_t _ctx, const union TimingInfo_Type_Value* p, enum TimingInfo_Type_Sel d)
{
	if (d == TimingInfo_Type_SubFrame) {
		adbgPrintLog(_ctx, "SubFrame := { ");
		_adbgSys__SubFrameTiming_Type(_ctx, &p->SubFrame);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == TimingInfo_Type_Now) {
		adbgPrintLog(_ctx, "Now := %s", (p->Now ? "true" : "false"));
		return;
	}
	if (d == TimingInfo_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__TimingInfo_Type(acpCtx_t _ctx, const struct TimingInfo_Type* p)
{
	_adbgSys__TimingInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__ReqAspControlInfo_Type(acpCtx_t _ctx, const struct ReqAspControlInfo_Type* p)
{
	adbgPrintLog(_ctx, "CnfFlag := %s", (p->CnfFlag ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "FollowOnFlag := %s", (p->FollowOnFlag ? "true" : "false"));
}

static const char* adbgSys__NR_CellId_Type__ToString(NR_CellId_Type v)
{
	switch(v) {
		case nr_Cell_NonSpecific: return "nr_Cell_NonSpecific";
		case nr_Cell1: return "nr_Cell1";
		case nr_Cell2: return "nr_Cell2";
		case nr_Cell3: return "nr_Cell3";
		case nr_Cell4: return "nr_Cell4";
		case nr_Cell6: return "nr_Cell6";
		case nr_Cell10: return "nr_Cell10";
		case nr_Cell11: return "nr_Cell11";
		case nr_Cell12: return "nr_Cell12";
		case nr_Cell13: return "nr_Cell13";
		case nr_Cell14: return "nr_Cell14";
		case nr_Cell23: return "nr_Cell23";
		case nr_Cell28: return "nr_Cell28";
		case nr_Cell29: return "nr_Cell29";
		case nr_Cell30: return "nr_Cell30";
		case nr_Cell31: return "nr_Cell31";
		default: return "Unknown";
	}
}

static void _adbgSys__RlcBearerRouting_Type_Value(acpCtx_t _ctx, const union RlcBearerRouting_Type_Value* p, enum RlcBearerRouting_Type_Sel d)
{
	if (d == RlcBearerRouting_Type_EUTRA) {
		adbgPrintLog(_ctx, "EUTRA := %s (%d)", adbgSys__EUTRA_CellId_Type__ToString(p->EUTRA), (int)p->EUTRA);
		return;
	}
	if (d == RlcBearerRouting_Type_NR) {
		adbgPrintLog(_ctx, "NR := %s (%d)", adbgSys__NR_CellId_Type__ToString(p->NR), (int)p->NR);
		return;
	}
	if (d == RlcBearerRouting_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__RlcBearerRouting_Type(acpCtx_t _ctx, const struct RlcBearerRouting_Type* p)
{
	_adbgSys__RlcBearerRouting_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__RlcBearerRouting_Type_ReqAspCommonPart_Type_RlcBearerRouting_Optional(acpCtx_t _ctx, const struct RlcBearerRouting_Type_ReqAspCommonPart_Type_RlcBearerRouting_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__RlcBearerRouting_Type(_ctx, &p->v);
}

static void _adbgSys__ReqAspCommonPart_Type(acpCtx_t _ctx, const struct ReqAspCommonPart_Type* p)
{
	adbgPrintLog(_ctx, "CellId := %s (%d)", adbgSys__EUTRA_CellId_Type__ToString(p->CellId), (int)p->CellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RoutingInfo := { ");
	_adbgSys__RoutingInfo_Type(_ctx, &p->RoutingInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TimingInfo := { ");
	_adbgSys__TimingInfo_Type(_ctx, &p->TimingInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ControlInfo := { ");
	_adbgSys__ReqAspControlInfo_Type(_ctx, &p->ControlInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RlcBearerRouting := ");
	if (p->RlcBearerRouting.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__RlcBearerRouting_Type_ReqAspCommonPart_Type_RlcBearerRouting_Optional(_ctx, &p->RlcBearerRouting);
	if (p->RlcBearerRouting.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__CellConfigCapability_Type__ToString(CellConfigCapability_Type v)
{
	switch(v) {
		case Capability_broadcastOnlyCell: return "Capability_broadcastOnlyCell";
		case Capability_minimumUplinkCell: return "Capability_minimumUplinkCell";
		case Capability_fullCell: return "Capability_fullCell";
		default: return "Unknown";
	}
}

static void _adbgSys__CellConfigCapability_Type_ConfigCapability_Optional(acpCtx_t _ctx, const struct CellConfigCapability_Type_ConfigCapability_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__CellConfigCapability_Type__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_TDD_Config_subframeAssignment_e__ToString(SQN_TDD_Config_subframeAssignment_e v)
{
	switch(v) {
		case SQN_TDD_Config_subframeAssignment_e_sa0: return "SQN_TDD_Config_subframeAssignment_e_sa0";
		case SQN_TDD_Config_subframeAssignment_e_sa1: return "SQN_TDD_Config_subframeAssignment_e_sa1";
		case SQN_TDD_Config_subframeAssignment_e_sa2: return "SQN_TDD_Config_subframeAssignment_e_sa2";
		case SQN_TDD_Config_subframeAssignment_e_sa3: return "SQN_TDD_Config_subframeAssignment_e_sa3";
		case SQN_TDD_Config_subframeAssignment_e_sa4: return "SQN_TDD_Config_subframeAssignment_e_sa4";
		case SQN_TDD_Config_subframeAssignment_e_sa5: return "SQN_TDD_Config_subframeAssignment_e_sa5";
		case SQN_TDD_Config_subframeAssignment_e_sa6: return "SQN_TDD_Config_subframeAssignment_e_sa6";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_TDD_Config_specialSubframePatterns_e__ToString(SQN_TDD_Config_specialSubframePatterns_e v)
{
	switch(v) {
		case SQN_TDD_Config_specialSubframePatterns_e_ssp0: return "SQN_TDD_Config_specialSubframePatterns_e_ssp0";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp1: return "SQN_TDD_Config_specialSubframePatterns_e_ssp1";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp2: return "SQN_TDD_Config_specialSubframePatterns_e_ssp2";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp3: return "SQN_TDD_Config_specialSubframePatterns_e_ssp3";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp4: return "SQN_TDD_Config_specialSubframePatterns_e_ssp4";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp5: return "SQN_TDD_Config_specialSubframePatterns_e_ssp5";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp6: return "SQN_TDD_Config_specialSubframePatterns_e_ssp6";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp7: return "SQN_TDD_Config_specialSubframePatterns_e_ssp7";
		case SQN_TDD_Config_specialSubframePatterns_e_ssp8: return "SQN_TDD_Config_specialSubframePatterns_e_ssp8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_TDD_Config(acpCtx_t _ctx, const struct SQN_TDD_Config* p)
{
	adbgPrintLog(_ctx, "subframeAssignment := %s (%d)", adbgSys__SQN_TDD_Config_subframeAssignment_e__ToString(p->subframeAssignment), (int)p->subframeAssignment);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "specialSubframePatterns := %s (%d)", adbgSys__SQN_TDD_Config_specialSubframePatterns_e__ToString(p->specialSubframePatterns), (int)p->specialSubframePatterns);
}

static const char* adbgSys__SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e__ToString(SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e v)
{
	switch(v) {
		case SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e_ssp7: return "SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e_ssp7";
		case SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e_ssp9: return "SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e_ssp9";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_TDD_Config_v1130(acpCtx_t _ctx, const struct SQN_TDD_Config_v1130* p)
{
	adbgPrintLog(_ctx, "specialSubframePatterns_v1130 := %s (%d)", adbgSys__SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e__ToString(p->specialSubframePatterns_v1130), (int)p->specialSubframePatterns_v1130);
}

static void _adbgSys__SQN_TDD_Config_v1130_tdd_Config_v1130_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_v1130_tdd_Config_v1130_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config_v1130(_ctx, &p->v);
}

static void _adbgSys__TDD_Config_R8andLater_Type(acpCtx_t _ctx, const struct TDD_Config_R8andLater_Type* p)
{
	adbgPrintLog(_ctx, "R8 := { ");
	_adbgSys__SQN_TDD_Config(_ctx, &p->R8);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tdd_Config_v1130 := ");
	if (p->tdd_Config_v1130.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_TDD_Config_v1130_tdd_Config_v1130_Optional(_ctx, &p->tdd_Config_v1130);
	if (p->tdd_Config_v1130.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__TDD_Config_Type_Value(acpCtx_t _ctx, const union TDD_Config_Type_Value* p, enum TDD_Config_Type_Sel d)
{
	if (d == TDD_Config_Type_R8andLater) {
		adbgPrintLog(_ctx, "R8andLater := { ");
		_adbgSys__TDD_Config_R8andLater_Type(_ctx, &p->R8andLater);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__TDD_Config_Type(acpCtx_t _ctx, const struct TDD_Config_Type* p)
{
	_adbgSys__TDD_Config_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__EUTRA_TDD_Info_Type(acpCtx_t _ctx, const struct EUTRA_TDD_Info_Type* p)
{
	adbgPrintLog(_ctx, "Configuration := { ");
	_adbgSys__TDD_Config_Type(_ctx, &p->Configuration);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__EUTRA_HalfDuplexFDD_Info_Type(acpCtx_t _ctx, const struct EUTRA_HalfDuplexFDD_Info_Type* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgSys__EUTRA_RAT_Type_Value(acpCtx_t _ctx, const union EUTRA_RAT_Type_Value* p, enum EUTRA_RAT_Type_Sel d)
{
	if (d == EUTRA_RAT_Type_FDD) {
		adbgPrintLog(_ctx, "FDD := %s", (p->FDD ? "true" : "false"));
		return;
	}
	if (d == EUTRA_RAT_Type_TDD) {
		adbgPrintLog(_ctx, "TDD := { ");
		_adbgSys__EUTRA_TDD_Info_Type(_ctx, &p->TDD);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == EUTRA_RAT_Type_HalfDuplexFDD) {
		adbgPrintLog(_ctx, "HalfDuplexFDD := { ");
		_adbgSys__EUTRA_HalfDuplexFDD_Info_Type(_ctx, &p->HalfDuplexFDD);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__EUTRA_RAT_Type(acpCtx_t _ctx, const struct EUTRA_RAT_Type* p)
{
	_adbgSys__EUTRA_RAT_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_CellIdentity_eNB_CellId_Optional(acpCtx_t _ctx, const struct SQN_CellIdentity_eNB_CellId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 28; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__Uint8_t_TcOffset_Optional(acpCtx_t _ctx, const struct uint8_t_TcOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__CellTimingInfo_Type(acpCtx_t _ctx, const struct CellTimingInfo_Type* p)
{
	adbgPrintLog(_ctx, "TcOffset := ");
	_adbgSys__Uint8_t_TcOffset_Optional(_ctx, &p->TcOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Tcell := %u", (unsigned int)p->Tcell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SfnOffset := %u", (unsigned int)p->SfnOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "HsfnOffset := %u", (unsigned int)p->HsfnOffset);
}

static void _adbgSys__CommonStaticCellInfo_Type(acpCtx_t _ctx, const struct CommonStaticCellInfo_Type* p)
{
	adbgPrintLog(_ctx, "RAT := { ");
	_adbgSys__EUTRA_RAT_Type(_ctx, &p->RAT);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PhysicalCellId := %u", (unsigned int)p->PhysicalCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "eNB_CellId := ");
	_adbgSys__SQN_CellIdentity_eNB_CellId_Optional(_ctx, &p->eNB_CellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "EutraBand := %d", (int)p->EutraBand);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CellTimingInfo := { ");
	_adbgSys__CellTimingInfo_Type(_ctx, &p->CellTimingInfo);
	adbgPrintLog(_ctx, " }");
}

static const char* adbgSys__Dl_Bandwidth_Type__ToString(Dl_Bandwidth_Type v)
{
	switch(v) {
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n6: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n6";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n15: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n15";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n25: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n25";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n50: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n50";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n75: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n75";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n100: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n100";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare10: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare10";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare9: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare9";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare8: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare8";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare7: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare7";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare6: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare6";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare5: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare5";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare4: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare4";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare3: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare3";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare2: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare2";
		case SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare1: return "SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__EUTRA_RBSize_Type__ToString(EUTRA_RBSize_Type v)
{
	switch(v) {
		case n_RB_SC_12: return "n_RB_SC_12";
		case n_RB_SC_24: return "n_RB_SC_24";
		default: return "Unknown";
	}
}

static const char* adbgSys__EUTRA_CyclicPrefix_Type__ToString(EUTRA_CyclicPrefix_Type v)
{
	switch(v) {
		case CyclicPrefix_normal: return "CyclicPrefix_normal";
		case CyclicPrefix_extended: return "CyclicPrefix_extended";
		default: return "Unknown";
	}
}

static void _adbgSys__DownlinkStaticCellInfo_Type(acpCtx_t _ctx, const struct DownlinkStaticCellInfo_Type* p)
{
	adbgPrintLog(_ctx, "Earfcn := %d", (int)p->Earfcn);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Bandwidth := %s (%d)", adbgSys__Dl_Bandwidth_Type__ToString(p->Bandwidth), (int)p->Bandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RBSize := %s (%d)", adbgSys__EUTRA_RBSize_Type__ToString(p->RBSize), (int)p->RBSize);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CyclicPrefix := %s (%d)", adbgSys__EUTRA_CyclicPrefix_Type__ToString(p->CyclicPrefix), (int)p->CyclicPrefix);
}

static const char* adbgSys__Ul_Bandwidth_Type__ToString(Ul_Bandwidth_Type v)
{
	switch(v) {
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n6: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n6";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n15: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n15";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n25: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n25";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n50: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n50";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n75: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n75";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n100: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n100";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare10: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare10";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare9: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare9";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare8: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare8";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare7: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare7";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare6: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare6";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare5: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare5";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare4: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare4";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare3: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare3";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare2: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare2";
		case SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare1: return "SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__UplinkStaticCellInfo_Type(acpCtx_t _ctx, const struct UplinkStaticCellInfo_Type* p)
{
	adbgPrintLog(_ctx, "Earfcn := %d", (int)p->Earfcn);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Bandwidth := %s (%d)", adbgSys__Ul_Bandwidth_Type__ToString(p->Bandwidth), (int)p->Bandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CyclicPrefix := %s (%d)", adbgSys__EUTRA_CyclicPrefix_Type__ToString(p->CyclicPrefix), (int)p->CyclicPrefix);
}

static void _adbgSys__UplinkStaticCellInfo_Type_Uplink_Optional(acpCtx_t _ctx, const struct UplinkStaticCellInfo_Type_Uplink_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__UplinkStaticCellInfo_Type(_ctx, &p->v);
}

static void _adbgSys__StaticCellInfo_Type(acpCtx_t _ctx, const struct StaticCellInfo_Type* p)
{
	adbgPrintLog(_ctx, "Common := { ");
	_adbgSys__CommonStaticCellInfo_Type(_ctx, &p->Common);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Downlink := { ");
	_adbgSys__DownlinkStaticCellInfo_Type(_ctx, &p->Downlink);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Uplink := ");
	if (p->Uplink.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__UplinkStaticCellInfo_Type_Uplink_Optional(_ctx, &p->Uplink);
	if (p->Uplink.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__StaticCellInfo_Type_StaticCellInfo_Optional(acpCtx_t _ctx, const struct StaticCellInfo_Type_StaticCellInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__StaticCellInfo_Type(_ctx, &p->v);
}

static const char* adbgSys__SQN_AntennaInfoCommon_antennaPortsCount_e__ToString(SQN_AntennaInfoCommon_antennaPortsCount_e v)
{
	switch(v) {
		case SQN_AntennaInfoCommon_antennaPortsCount_e_an1: return "SQN_AntennaInfoCommon_antennaPortsCount_e_an1";
		case SQN_AntennaInfoCommon_antennaPortsCount_e_an2: return "SQN_AntennaInfoCommon_antennaPortsCount_e_an2";
		case SQN_AntennaInfoCommon_antennaPortsCount_e_an4: return "SQN_AntennaInfoCommon_antennaPortsCount_e_an4";
		case SQN_AntennaInfoCommon_antennaPortsCount_e_spare1: return "SQN_AntennaInfoCommon_antennaPortsCount_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_AntennaInfoCommon(acpCtx_t _ctx, const struct SQN_AntennaInfoCommon* p)
{
	adbgPrintLog(_ctx, "antennaPortsCount := %s (%d)", adbgSys__SQN_AntennaInfoCommon_antennaPortsCount_e__ToString(p->antennaPortsCount), (int)p->antennaPortsCount);
}

static void _adbgSys__AntennaInfoCommon_Type_Value(acpCtx_t _ctx, const union AntennaInfoCommon_Type_Value* p, enum AntennaInfoCommon_Type_Sel d)
{
	if (d == AntennaInfoCommon_Type_R8) {
		adbgPrintLog(_ctx, "R8 := { ");
		_adbgSys__SQN_AntennaInfoCommon(_ctx, &p->R8);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__AntennaInfoCommon_Type(acpCtx_t _ctx, const struct AntennaInfoCommon_Type* p)
{
	_adbgSys__AntennaInfoCommon_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__AntennaPortInfo_Type(acpCtx_t _ctx, const struct AntennaPortInfo_Type* p)
{
	adbgPrintLog(_ctx, "PowerAttenuation := %s", (p->PowerAttenuation ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PropagationDelay := %s", (p->PropagationDelay ? "true" : "false"));
}

static void _adbgSys__AntennaPortConfig_Type_Value(acpCtx_t _ctx, const union AntennaPortConfig_Type_Value* p, enum AntennaPortConfig_Type_Sel d)
{
	if (d == AntennaPortConfig_Type_AddOrReconfigure) {
		adbgPrintLog(_ctx, "AddOrReconfigure := { ");
		_adbgSys__AntennaPortInfo_Type(_ctx, &p->AddOrReconfigure);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == AntennaPortConfig_Type_Release) {
		adbgPrintLog(_ctx, "Release := %s", (p->Release ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__AntennaPortConfig_Type(acpCtx_t _ctx, const struct AntennaPortConfig_Type* p)
{
	_adbgSys__AntennaPortConfig_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__AntennaPort_Type(acpCtx_t _ctx, const struct AntennaPort_Type* p)
{
	adbgPrintLog(_ctx, "Id := %u", (unsigned int)p->Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Config := { ");
	_adbgSys__AntennaPortConfig_Type(_ctx, &p->Config);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__DownlinkAntennaGroupConfig_Type(acpCtx_t _ctx, const struct DownlinkAntennaGroupConfig_Type* p)
{
	adbgPrintLog(_ctx, "AntennaInfoCommon := { ");
	_adbgSys__AntennaInfoCommon_Type(_ctx, &p->AntennaInfoCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "AntennaPort := { ");
	for (size_t i1 = 0; i1 < p->AntennaPort.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__AntennaPort_Type(_ctx, &p->AntennaPort.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->AntennaPort.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__DownlinkAntennaGroupConfig_Type_AntennaGroup_Optional(acpCtx_t _ctx, const struct DownlinkAntennaGroupConfig_Type_AntennaGroup_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__DownlinkAntennaGroupConfig_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratio_Type_RA_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratio_Type_RA_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__ToRS_EPRE_Ratio_Type_RB_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratio_Type_RB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type* p)
{
	adbgPrintLog(_ctx, "RA := ");
	_adbgSys__ToRS_EPRE_Ratio_Type_RA_Optional(_ctx, &p->RA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RB := ");
	_adbgSys__ToRS_EPRE_Ratio_Type_RB_Optional(_ctx, &p->RB);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_PbchConfig_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_PbchConfig_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PbchConfig_Type(acpCtx_t _ctx, const struct PbchConfig_Type* p)
{
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_PbchConfig_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PbchConfig_Type_Pbch_Optional(acpCtx_t _ctx, const struct PbchConfig_Type_Pbch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PbchConfig_Type(_ctx, &p->v);
}

static void _adbgSys__CfiValue_Type_CfiValue_Optional(acpCtx_t _ctx, const struct CfiValue_Type_CfiValue_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_PcfichConfig_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_PcfichConfig_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PcfichConfig_Type(acpCtx_t _ctx, const struct PcfichConfig_Type* p)
{
	adbgPrintLog(_ctx, "CfiValue := ");
	_adbgSys__CfiValue_Type_CfiValue_Optional(_ctx, &p->CfiValue);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_PcfichConfig_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PcfichConfig_Type_Pcfich_Optional(acpCtx_t _ctx, const struct PcfichConfig_Type_Pcfich_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PcfichConfig_Type(_ctx, &p->v);
}

static const char* adbgSys__SQN_PHICH_Config_phich_Duration_e__ToString(SQN_PHICH_Config_phich_Duration_e v)
{
	switch(v) {
		case SQN_PHICH_Config_phich_Duration_e_normal: return "SQN_PHICH_Config_phich_Duration_e_normal";
		case SQN_PHICH_Config_phich_Duration_e_extended: return "SQN_PHICH_Config_phich_Duration_e_extended";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_PHICH_Config_phich_Resource_e__ToString(SQN_PHICH_Config_phich_Resource_e v)
{
	switch(v) {
		case SQN_PHICH_Config_phich_Resource_e_oneSixth: return "SQN_PHICH_Config_phich_Resource_e_oneSixth";
		case SQN_PHICH_Config_phich_Resource_e_half: return "SQN_PHICH_Config_phich_Resource_e_half";
		case SQN_PHICH_Config_phich_Resource_e_one: return "SQN_PHICH_Config_phich_Resource_e_one";
		case SQN_PHICH_Config_phich_Resource_e_two: return "SQN_PHICH_Config_phich_Resource_e_two";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PHICH_Config(acpCtx_t _ctx, const struct SQN_PHICH_Config* p)
{
	adbgPrintLog(_ctx, "phich_Duration := %s (%d)", adbgSys__SQN_PHICH_Config_phich_Duration_e__ToString(p->phich_Duration), (int)p->phich_Duration);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "phich_Resource := %s (%d)", adbgSys__SQN_PHICH_Config_phich_Resource_e__ToString(p->phich_Resource), (int)p->phich_Resource);
}

static void _adbgSys__PHICH_Config_Type_Value(acpCtx_t _ctx, const union PHICH_Config_Type_Value* p, enum PHICH_Config_Type_Sel d)
{
	if (d == PHICH_Config_Type_R8) {
		adbgPrintLog(_ctx, "R8 := { ");
		_adbgSys__SQN_PHICH_Config(_ctx, &p->R8);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__PHICH_Config_Type(acpCtx_t _ctx, const struct PHICH_Config_Type* p)
{
	_adbgSys__PHICH_Config_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__PHICH_Config_Type_PhichConfig_Optional(acpCtx_t _ctx, const struct PHICH_Config_Type_PhichConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PHICH_Config_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_PhichConfig_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_PhichConfig_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PhichConfig_Type(acpCtx_t _ctx, const struct PhichConfig_Type* p)
{
	adbgPrintLog(_ctx, "PhichConfig := ");
	if (p->PhichConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PHICH_Config_Type_PhichConfig_Optional(_ctx, &p->PhichConfig);
	if (p->PhichConfig.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_PhichConfig_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PhichConfig_Type_Phich_Optional(acpCtx_t _ctx, const struct PhichConfig_Type_Phich_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PhichConfig_Type(_ctx, &p->v);
}

static void _adbgSys__Uint8_t_CommonSearchSpaceFormat_Optional(acpCtx_t _ctx, const struct uint8_t_CommonSearchSpaceFormat_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__Uint8_t_UeSpecificSearchSpaceFormat_Optional(acpCtx_t _ctx, const struct uint8_t_UeSpecificSearchSpaceFormat_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__CCE_StartIndex_DL_UL_Type(acpCtx_t _ctx, const struct CCE_StartIndex_DL_UL_Type* p)
{
	adbgPrintLog(_ctx, "CCE_StartIndex_DL := %d", (int)p->CCE_StartIndex_DL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CCE_StartIndex_UL := %d", (int)p->CCE_StartIndex_UL);
}

static void _adbgSys__PdcchCandidate_Type(acpCtx_t _ctx, const struct PdcchCandidate_Type* p)
{
	adbgPrintLog(_ctx, "RNTI := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->RNTI[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CCE_StartIndexList := { ");
	for (size_t i2 = 0; i2 < p->CCE_StartIndexList.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__CCE_StartIndex_DL_UL_Type(_ctx, &p->CCE_StartIndexList.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->CCE_StartIndexList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__PdcchCandidateList_Type_PdcchCandidateList_Optional(acpCtx_t _ctx, const struct PdcchCandidateList_Type_PdcchCandidateList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__PdcchCandidate_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_PdcchConfig_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_PdcchConfig_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PdcchConfig_Type(acpCtx_t _ctx, const struct PdcchConfig_Type* p)
{
	adbgPrintLog(_ctx, "CommonSearchSpaceFormat := ");
	_adbgSys__Uint8_t_CommonSearchSpaceFormat_Optional(_ctx, &p->CommonSearchSpaceFormat);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "UeSpecificSearchSpaceFormat := ");
	_adbgSys__Uint8_t_UeSpecificSearchSpaceFormat_Optional(_ctx, &p->UeSpecificSearchSpaceFormat);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdcchCandidateList := ");
	if (p->PdcchCandidateList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PdcchCandidateList_Type_PdcchCandidateList_Optional(_ctx, &p->PdcchCandidateList);
	if (p->PdcchCandidateList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_PdcchConfig_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PdcchConfig_Type_Pdcch_Optional(acpCtx_t _ctx, const struct PdcchConfig_Type_Pdcch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PdcchConfig_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_RachResponse_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_RachResponse_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_BcchOnPdsch_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_BcchOnPdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_PcchOnPdsch_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_PcchOnPdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_CcchOnPdsch_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_CcchOnPdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_DcchDtchOnPdsch_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_DcchDtchOnPdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_OcngOnPdsch_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_OcngOnPdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PdschRelativeTxPower_Type(acpCtx_t _ctx, const struct PdschRelativeTxPower_Type* p)
{
	adbgPrintLog(_ctx, "RachResponse := ");
	if (p->RachResponse.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_RachResponse_Optional(_ctx, &p->RachResponse);
	if (p->RachResponse.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BcchOnPdsch := ");
	if (p->BcchOnPdsch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_BcchOnPdsch_Optional(_ctx, &p->BcchOnPdsch);
	if (p->BcchOnPdsch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PcchOnPdsch := ");
	if (p->PcchOnPdsch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_PcchOnPdsch_Optional(_ctx, &p->PcchOnPdsch);
	if (p->PcchOnPdsch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CcchOnPdsch := ");
	if (p->CcchOnPdsch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_CcchOnPdsch_Optional(_ctx, &p->CcchOnPdsch);
	if (p->CcchOnPdsch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DcchDtchOnPdsch := ");
	if (p->DcchDtchOnPdsch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_DcchDtchOnPdsch_Optional(_ctx, &p->DcchDtchOnPdsch);
	if (p->DcchDtchOnPdsch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "OcngOnPdsch := ");
	if (p->OcngOnPdsch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_OcngOnPdsch_Optional(_ctx, &p->OcngOnPdsch);
	if (p->OcngOnPdsch.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PdschRelativeTxPower_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct PdschRelativeTxPower_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PdschRelativeTxPower_Type(_ctx, &p->v);
}

static const char* adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e__ToString(SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e v)
{
	switch(v) {
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_r16: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_r16";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_r32: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_r32";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional(acpCtx_t _ctx, const struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e__ToString(SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e v)
{
	switch(v) {
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r192: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r192";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r256: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r256";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r384: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r384";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r512: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r512";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r768: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r768";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r1024: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r1024";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r1536: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r1536";
		case SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r2048: return "SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r2048";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional(acpCtx_t _ctx, const struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_PDSCH_ConfigCommon_v1310(acpCtx_t _ctx, const struct SQN_PDSCH_ConfigCommon_v1310* p)
{
	adbgPrintLog(_ctx, "pdsch_maxNumRepetitionCEmodeA_r13 := ");
	_adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional(_ctx, &p->pdsch_maxNumRepetitionCEmodeA_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_maxNumRepetitionCEmodeB_r13 := ");
	_adbgSys__SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional(_ctx, &p->pdsch_maxNumRepetitionCEmodeB_r13);
}

static void _adbgSys__SQN_PDSCH_ConfigCommon_v1310_PDSCH_ConfigCommon_Optional(acpCtx_t _ctx, const struct SQN_PDSCH_ConfigCommon_v1310_PDSCH_ConfigCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PDSCH_ConfigCommon_v1310(_ctx, &p->v);
}

static void _adbgSys__PdschConfig_Type(acpCtx_t _ctx, const struct PdschConfig_Type* p)
{
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PdschRelativeTxPower_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PDSCH_ConfigCommon := ");
	if (p->PDSCH_ConfigCommon.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PDSCH_ConfigCommon_v1310_PDSCH_ConfigCommon_Optional(_ctx, &p->PDSCH_ConfigCommon);
	if (p->PDSCH_ConfigCommon.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PdschConfig_Type_Pdsch_Optional(acpCtx_t _ctx, const struct PdschConfig_Type_Pdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PdschConfig_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_PrimarySyncSignal_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_PrimarySyncSignal_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PrimarySyncSignal_Type(acpCtx_t _ctx, const struct PrimarySyncSignal_Type* p)
{
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_PrimarySyncSignal_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PrimarySyncSignal_Type_Pss_Optional(acpCtx_t _ctx, const struct PrimarySyncSignal_Type_Pss_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PrimarySyncSignal_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_SecondarySyncSignal_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_SecondarySyncSignal_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__SecondarySyncSignal_Type(acpCtx_t _ctx, const struct SecondarySyncSignal_Type* p)
{
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_SecondarySyncSignal_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SecondarySyncSignal_Type_Sss_Optional(acpCtx_t _ctx, const struct SecondarySyncSignal_Type_Sss_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SecondarySyncSignal_Type(_ctx, &p->v);
}

static const char* adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e__ToString(SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e v)
{
	switch(v) {
		case SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an1: return "SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an1";
		case SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an2: return "SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an2";
		case SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an4: return "SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an4";
		case SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an8: return "SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_setup(acpCtx_t _ctx, const struct SQN_CSI_RS_Config_r10_csi_RS_r10_setup* p)
{
	adbgPrintLog(_ctx, "antennaPortsCount_r10 := %s (%d)", adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e__ToString(p->antennaPortsCount_r10), (int)p->antennaPortsCount_r10);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceConfig_r10 := %u", (unsigned int)p->resourceConfig_r10);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subframeConfig_r10 := %u", (unsigned int)p->subframeConfig_r10);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_C_r10 := %d", (int)p->p_C_r10);
}

static void _adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_Value(acpCtx_t _ctx, const union SQN_CSI_RS_Config_r10_csi_RS_r10_Value* p, enum SQN_CSI_RS_Config_r10_csi_RS_r10_Sel d)
{
	if (d == SQN_CSI_RS_Config_r10_csi_RS_r10_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_CSI_RS_Config_r10_csi_RS_r10_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10(acpCtx_t _ctx, const struct SQN_CSI_RS_Config_r10_csi_RS_r10* p)
{
	_adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10(_ctx, &p->v);
}

static void _adbgSys__SQN_ZeroTxPowerCSI_RS_r12(acpCtx_t _ctx, const struct SQN_ZeroTxPowerCSI_RS_r12* p)
{
	adbgPrintLog(_ctx, "zeroTxPowerResourceConfigList_r12 := '");
	for (size_t i1 = 0; i1 < 16; i1++) {
		adbgPrintLog(_ctx, "%02X", p->zeroTxPowerResourceConfigList_r12[i1]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zeroTxPowerSubframeConfig_r12 := %u", (unsigned int)p->zeroTxPowerSubframeConfig_r12);
}

static void _adbgSys__SQN_ZeroTxPowerCSI_RS_Conf_r12_Value(acpCtx_t _ctx, const union SQN_ZeroTxPowerCSI_RS_Conf_r12_Value* p, enum SQN_ZeroTxPowerCSI_RS_Conf_r12_Sel d)
{
	if (d == SQN_ZeroTxPowerCSI_RS_Conf_r12_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_ZeroTxPowerCSI_RS_Conf_r12_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_ZeroTxPowerCSI_RS_r12(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_ZeroTxPowerCSI_RS_Conf_r12(acpCtx_t _ctx, const struct SQN_ZeroTxPowerCSI_RS_Conf_r12* p)
{
	_adbgSys__SQN_ZeroTxPowerCSI_RS_Conf_r12_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional(acpCtx_t _ctx, const struct SQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ZeroTxPowerCSI_RS_Conf_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_CSI_RS_Config_r10(acpCtx_t _ctx, const struct SQN_CSI_RS_Config_r10* p)
{
	adbgPrintLog(_ctx, "csi_RS_r10 := ");
	if (p->csi_RS_r10.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional(_ctx, &p->csi_RS_r10);
	if (p->csi_RS_r10.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zeroTxPowerCSI_RS_r10 := ");
	if (p->zeroTxPowerCSI_RS_r10.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional(_ctx, &p->zeroTxPowerCSI_RS_r10);
	if (p->zeroTxPowerCSI_RS_r10.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CSI_RS_Config_r10_CSI_RS_Config_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_Config_r10_CSI_RS_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSI_RS_Config_r10(_ctx, &p->v);
}

static const char* adbgSys__SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e__ToString(SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e v)
{
	switch(v) {
		case SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an1: return "SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an1";
		case SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an2: return "SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an2";
		case SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an4: return "SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an4";
		case SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an8: return "SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an8";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e__ToString(SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e v)
{
	switch(v) {
		case SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n1: return "SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n1";
		case SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n2: return "SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n2";
		case SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n4: return "SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n4";
		case SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_spare1: return "SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e__ToString(SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e v)
{
	switch(v) {
		case SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n1: return "SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n1";
		case SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n2: return "SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n2";
		case SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n4: return "SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n4";
		case SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n8: return "SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n8";
		case SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n16: return "SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n16";
		case SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n32: return "SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n32";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBSFN_SubframeConfig_subframeAllocation_Value(acpCtx_t _ctx, const union SQN_MBSFN_SubframeConfig_subframeAllocation_Value* p, enum SQN_MBSFN_SubframeConfig_subframeAllocation_Sel d)
{
	if (d == SQN_MBSFN_SubframeConfig_subframeAllocation_oneFrame) {
		adbgPrintLog(_ctx, "oneFrame := '");
		for (size_t i3 = 0; i3 < 6; i3++) {
			adbgPrintLog(_ctx, "%02X", p->oneFrame[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_MBSFN_SubframeConfig_subframeAllocation_fourFrames) {
		adbgPrintLog(_ctx, "fourFrames := '");
		for (size_t i3 = 0; i3 < 24; i3++) {
			adbgPrintLog(_ctx, "%02X", p->fourFrames[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_MBSFN_SubframeConfig_subframeAllocation(acpCtx_t _ctx, const struct SQN_MBSFN_SubframeConfig_subframeAllocation* p)
{
	_adbgSys__SQN_MBSFN_SubframeConfig_subframeAllocation_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_MBSFN_SubframeConfig(acpCtx_t _ctx, const struct SQN_MBSFN_SubframeConfig* p)
{
	adbgPrintLog(_ctx, "radioframeAllocationPeriod := %s (%d)", adbgSys__SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e__ToString(p->radioframeAllocationPeriod), (int)p->radioframeAllocationPeriod);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "radioframeAllocationOffset := %u", (unsigned int)p->radioframeAllocationOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subframeAllocation := { ");
	_adbgSys__SQN_MBSFN_SubframeConfig_subframeAllocation(_ctx, &p->subframeAllocation);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup* p)
{
	adbgPrintLog(_ctx, "subframeConfigList := { ");
	for (size_t i2 = 0; i2 < p->subframeConfigList.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_MBSFN_SubframeConfig(_ctx, &p->subframeConfigList.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->subframeConfigList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value(acpCtx_t _ctx, const union SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value* p, enum SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Sel d)
{
	if (d == SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11* p)
{
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11* p)
{
	adbgPrintLog(_ctx, "qcl_ScramblingIdentity_r11 := %u", (unsigned int)p->qcl_ScramblingIdentity_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "crs_PortsCount_r11 := %s (%d)", adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e__ToString(p->crs_PortsCount_r11), (int)p->crs_PortsCount_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbsfn_SubframeConfigList_r11 := ");
	if (p->mbsfn_SubframeConfigList_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional(_ctx, &p->mbsfn_SubframeConfigList_r11);
	if (p->mbsfn_SubframeConfigList_r11.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional(acpCtx_t _ctx, const struct SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_NZP_FrequencyDensity_r14_e__ToString(SQN_NZP_FrequencyDensity_r14_e v)
{
	switch(v) {
		case SQN_NZP_FrequencyDensity_r14_e_d1: return "SQN_NZP_FrequencyDensity_r14_e_d1";
		case SQN_NZP_FrequencyDensity_r14_e_d2: return "SQN_NZP_FrequencyDensity_r14_e_d2";
		case SQN_NZP_FrequencyDensity_r14_e_d3: return "SQN_NZP_FrequencyDensity_r14_e_d3";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional(acpCtx_t _ctx, const struct SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_NZP_FrequencyDensity_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value(acpCtx_t _ctx, const union SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value* p, enum SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Sel d)
{
	if (d == SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_oneFrame_v1430) {
		adbgPrintLog(_ctx, "oneFrame_v1430 := '");
		for (size_t i3 = 0; i3 < 2; i3++) {
			adbgPrintLog(_ctx, "%02X", p->oneFrame_v1430[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_fourFrames_v1430) {
		adbgPrintLog(_ctx, "fourFrames_v1430 := '");
		for (size_t i3 = 0; i3 < 8; i3++) {
			adbgPrintLog(_ctx, "%02X", p->fourFrames_v1430[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430(acpCtx_t _ctx, const struct SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430* p)
{
	_adbgSys__SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_MBSFN_SubframeConfig_v1430(acpCtx_t _ctx, const struct SQN_MBSFN_SubframeConfig_v1430* p)
{
	adbgPrintLog(_ctx, "subframeAllocation_v1430 := { ");
	_adbgSys__SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430(_ctx, &p->subframeAllocation_v1430);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup* p)
{
	adbgPrintLog(_ctx, "subframeConfigList_v1430 := { ");
	for (size_t i2 = 0; i2 < p->subframeConfigList_v1430.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_MBSFN_SubframeConfig_v1430(_ctx, &p->subframeConfigList_v1430.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->subframeConfigList_v1430.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value(acpCtx_t _ctx, const union SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value* p, enum SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Sel d)
{
	if (d == SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430* p)
{
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430(_ctx, &p->v);
}

static void _adbgSys__SQN_CSI_RS_ConfigNZP_r11(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZP_r11* p)
{
	adbgPrintLog(_ctx, "csi_RS_ConfigNZPId_r11 := %u", (unsigned int)p->csi_RS_ConfigNZPId_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "antennaPortsCount_r11 := %s (%d)", adbgSys__SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e__ToString(p->antennaPortsCount_r11), (int)p->antennaPortsCount_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceConfig_r11 := %u", (unsigned int)p->resourceConfig_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subframeConfig_r11 := %u", (unsigned int)p->subframeConfig_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scramblingIdentity_r11 := %u", (unsigned int)p->scramblingIdentity_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qcl_CRS_Info_r11 := ");
	if (p->qcl_CRS_Info_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional(_ctx, &p->qcl_CRS_Info_r11);
	if (p->qcl_CRS_Info_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csi_RS_ConfigNZPId_v1310 := ");
	_adbgSys__SQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional(_ctx, &p->csi_RS_ConfigNZPId_v1310);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transmissionComb_r14 := ");
	_adbgSys__SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional(_ctx, &p->transmissionComb_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyDensity_r14 := ");
	_adbgSys__SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional(_ctx, &p->frequencyDensity_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbsfn_SubframeConfigList_v1430 := ");
	if (p->mbsfn_SubframeConfigList_v1430.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional(_ctx, &p->mbsfn_SubframeConfigList_v1430);
	if (p->mbsfn_SubframeConfigList_v1430.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CSI_RS_ConfigNZPToAddModList_r11_CSI_RS_ConfigNZPToAddModList_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZPToAddModList_r11_CSI_RS_ConfigNZPToAddModList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__SQN_CSI_RS_ConfigNZP_r11(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CSI_RS_ConfigNZPToReleaseList_r11_CSI_RS_ConfigNZPToReleaseModList_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigNZPToReleaseList_r11_CSI_RS_ConfigNZPToReleaseModList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_CSI_RS_ConfigZP_r11(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigZP_r11* p)
{
	adbgPrintLog(_ctx, "csi_RS_ConfigZPId_r11 := %u", (unsigned int)p->csi_RS_ConfigZPId_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceConfigList_r11 := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->resourceConfigList_r11[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subframeConfig_r11 := %u", (unsigned int)p->subframeConfig_r11);
}

static void _adbgSys__SQN_CSI_RS_ConfigZPToAddModList_r11_CSI_RS_ConfigZPToAddModList_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigZPToAddModList_r11_CSI_RS_ConfigZPToAddModList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__SQN_CSI_RS_ConfigZP_r11(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CSI_RS_ConfigZPToReleaseList_r11_CSI_RS_ConfigZPToReleaseModList_Optional(acpCtx_t _ctx, const struct SQN_CSI_RS_ConfigZPToReleaseList_r11_CSI_RS_ConfigZPToReleaseModList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_CSI_RS_Config_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_CSI_RS_Config_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__CSI_RS_Config_Type(acpCtx_t _ctx, const struct CSI_RS_Config_Type* p)
{
	adbgPrintLog(_ctx, "CSI_RS_Config := ");
	if (p->CSI_RS_Config.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_Config_r10_CSI_RS_Config_Optional(_ctx, &p->CSI_RS_Config);
	if (p->CSI_RS_Config.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CSI_RS_ConfigNZPToAddModList := ");
	if (p->CSI_RS_ConfigNZPToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_ConfigNZPToAddModList_r11_CSI_RS_ConfigNZPToAddModList_Optional(_ctx, &p->CSI_RS_ConfigNZPToAddModList);
	if (p->CSI_RS_ConfigNZPToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CSI_RS_ConfigNZPToReleaseModList := ");
	if (p->CSI_RS_ConfigNZPToReleaseModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_ConfigNZPToReleaseList_r11_CSI_RS_ConfigNZPToReleaseModList_Optional(_ctx, &p->CSI_RS_ConfigNZPToReleaseModList);
	if (p->CSI_RS_ConfigNZPToReleaseModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CSI_RS_ConfigZPToAddModList := ");
	if (p->CSI_RS_ConfigZPToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_ConfigZPToAddModList_r11_CSI_RS_ConfigZPToAddModList_Optional(_ctx, &p->CSI_RS_ConfigZPToAddModList);
	if (p->CSI_RS_ConfigZPToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CSI_RS_ConfigZPToReleaseModList := ");
	if (p->CSI_RS_ConfigZPToReleaseModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSI_RS_ConfigZPToReleaseList_r11_CSI_RS_ConfigZPToReleaseModList_Optional(_ctx, &p->CSI_RS_ConfigZPToReleaseModList);
	if (p->CSI_RS_ConfigZPToReleaseModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_CSI_RS_Config_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__CSI_RS_Config_Type_CSI_RS_Config_Optional(acpCtx_t _ctx, const struct CSI_RS_Config_Type_CSI_RS_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__CSI_RS_Config_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_PmchConfig_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_PmchConfig_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PmchConfig_Type(acpCtx_t _ctx, const struct PmchConfig_Type* p)
{
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_PmchConfig_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PmchConfig_Type_Pmch_Optional(acpCtx_t _ctx, const struct PmchConfig_Type_Pmch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PmchConfig_Type(_ctx, &p->v);
}

static void _adbgSys__ToRS_EPRE_Ratios_Type_EpdcchConfig_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct ToRS_EPRE_Ratios_Type_EpdcchConfig_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__ToRS_EPRE_Ratios_Type(_ctx, &p->v);
}

static void _adbgSys__PdcchCandidateList_Type_ePdcchCandidateList_Optional(acpCtx_t _ctx, const struct PdcchCandidateList_Type_ePdcchCandidateList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__PdcchCandidate_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value(acpCtx_t _ctx, const union SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value* p, enum SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Sel d)
{
	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig1_5_r10) {
		adbgPrintLog(_ctx, "subframeConfig1_5_r10 := '");
		for (size_t i1 = 0; i1 < 20; i1++) {
			adbgPrintLog(_ctx, "%02X", p->subframeConfig1_5_r10[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig0_r10) {
		adbgPrintLog(_ctx, "subframeConfig0_r10 := '");
		for (size_t i1 = 0; i1 < 70; i1++) {
			adbgPrintLog(_ctx, "%02X", p->subframeConfig0_r10[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig6_r10) {
		adbgPrintLog(_ctx, "subframeConfig6_r10 := '");
		for (size_t i1 = 0; i1 < 60; i1++) {
			adbgPrintLog(_ctx, "%02X", p->subframeConfig6_r10[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_MeasSubframePattern_r10_subframePatternTDD_r10(acpCtx_t _ctx, const struct SQN_MeasSubframePattern_r10_subframePatternTDD_r10* p)
{
	_adbgSys__SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_MeasSubframePattern_r10_Value(acpCtx_t _ctx, const union SQN_MeasSubframePattern_r10_Value* p, enum SQN_MeasSubframePattern_r10_Sel d)
{
	if (d == SQN_MeasSubframePattern_r10_subframePatternFDD_r10) {
		adbgPrintLog(_ctx, "subframePatternFDD_r10 := '");
		for (size_t i1 = 0; i1 < 40; i1++) {
			adbgPrintLog(_ctx, "%02X", p->subframePatternFDD_r10[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10) {
		adbgPrintLog(_ctx, "subframePatternTDD_r10 := { ");
		_adbgSys__SQN_MeasSubframePattern_r10_subframePatternTDD_r10(_ctx, &p->subframePatternTDD_r10);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_MeasSubframePattern_r10(acpCtx_t _ctx, const struct SQN_MeasSubframePattern_r10* p)
{
	_adbgSys__SQN_MeasSubframePattern_r10_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup(acpCtx_t _ctx, const struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup* p)
{
	adbgPrintLog(_ctx, "subframePattern_r11 := { ");
	_adbgSys__SQN_MeasSubframePattern_r10(_ctx, &p->subframePattern_r11);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value(acpCtx_t _ctx, const union SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value* p, enum SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Sel d)
{
	if (d == SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11(acpCtx_t _ctx, const struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11* p)
{
	_adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional(acpCtx_t _ctx, const struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11(_ctx, &p->v);
}

static void _adbgSys__Uint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e__ToString(SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e_localised: return "SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e_localised";
		case SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e_distributed: return "SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e_distributed";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e__ToString(SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n2: return "SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n2";
		case SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n4: return "SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n4";
		case SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n8: return "SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11* p)
{
	adbgPrintLog(_ctx, "numberPRB_Pairs_r11 := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e__ToString(p->numberPRB_Pairs_r11), (int)p->numberPRB_Pairs_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceBlockAssignment_r11 := '");
	for (size_t i2 = 0; i2 < p->resourceBlockAssignment_r11.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->resourceBlockAssignment_r11.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional(acpCtx_t _ctx, const struct SQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value(acpCtx_t _ctx, const union SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value* p, enum SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Sel d)
{
	if (d == SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_setup) {
		adbgPrintLog(_ctx, "setup := %u", (unsigned int)p->setup);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12* p)
{
	_adbgSys__SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12(_ctx, &p->v);
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e__ToString(SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e_n6: return "SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e_n6";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value(acpCtx_t _ctx, const union SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value* p, enum SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Sel d)
{
	if (d == SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup) {
		adbgPrintLog(_ctx, "setup := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e__ToString(p->setup), (int)p->setup);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310* p)
{
	_adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310(_ctx, &p->v);
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e__ToString(SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf1: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf1";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf2: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf2";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf4: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf4";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf8: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf8";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf16: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf16";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf32: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf32";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e__ToString(SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e_on: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e_on";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e_off: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e_off";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e__ToString(SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v1: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v1";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v1dot5: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v1dot5";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v2: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v2";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v2dot5: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v2dot5";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v4: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v4";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v5: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v5";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v8: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v8";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v10: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v10";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e__ToString(SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v1: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v1";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v2: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v2";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v4: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v4";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v5: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v5";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v8: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v8";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v10: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v10";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v20: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v20";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_spare1: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value(acpCtx_t _ctx, const union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value* p, enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Sel d)
{
	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13) {
		adbgPrintLog(_ctx, "fdd_r13 := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e__ToString(p->fdd_r13), (int)p->fdd_r13);
		return;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13) {
		adbgPrintLog(_ctx, "tdd_r13 := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e__ToString(p->tdd_r13), (int)p->tdd_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13* p)
{
	_adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value(_ctx, &p->v, p->d);
}

static const char* adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e__ToString(SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e v)
{
	switch(v) {
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r1: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r1";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r2: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r2";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r4: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r4";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r8: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r8";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r16: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r16";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r32: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r32";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r64: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r64";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r128: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r128";
		case SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r256: return "SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r256";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup* p)
{
	adbgPrintLog(_ctx, "csi_NumRepetitionCE_r13 := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e__ToString(p->csi_NumRepetitionCE_r13), (int)p->csi_NumRepetitionCE_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_pdsch_HoppingConfig_r13 := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e__ToString(p->mpdcch_pdsch_HoppingConfig_r13), (int)p->mpdcch_pdsch_HoppingConfig_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_StartSF_UESS_r13 := { ");
	_adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13(_ctx, &p->mpdcch_StartSF_UESS_r13);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_NumRepetition_r13 := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e__ToString(p->mpdcch_NumRepetition_r13), (int)p->mpdcch_NumRepetition_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_Narrowband_r13 := %u", (unsigned int)p->mpdcch_Narrowband_r13);
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value(acpCtx_t _ctx, const union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value* p, enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Sel d)
{
	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13* p)
{
	_adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_EPDCCH_SetConfig_r11(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfig_r11* p)
{
	adbgPrintLog(_ctx, "setConfigId_r11 := %u", (unsigned int)p->setConfigId_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transmissionType_r11 := %s (%d)", adbgSys__SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e__ToString(p->transmissionType_r11), (int)p->transmissionType_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceBlockAssignment_r11 := { ");
	_adbgSys__SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11(_ctx, &p->resourceBlockAssignment_r11);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_ScramblingSequenceInt_r11 := %u", (unsigned int)p->dmrs_ScramblingSequenceInt_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_ResourceStartOffset_r11 := %u", (unsigned int)p->pucch_ResourceStartOffset_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "re_MappingQCL_ConfigId_r11 := ");
	_adbgSys__SQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional(_ctx, &p->re_MappingQCL_ConfigId_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csi_RS_ConfigZPId2_r12 := ");
	if (p->csi_RS_ConfigZPId2_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional(_ctx, &p->csi_RS_ConfigZPId2_r12);
	if (p->csi_RS_ConfigZPId2_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberPRB_Pairs_v1310 := ");
	if (p->numberPRB_Pairs_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional(_ctx, &p->numberPRB_Pairs_v1310);
	if (p->numberPRB_Pairs_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_config_r13 := ");
	if (p->mpdcch_config_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional(_ctx, &p->mpdcch_config_r13);
	if (p->mpdcch_config_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional(acpCtx_t _ctx, const struct SQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__SQN_EPDCCH_SetConfig_r11(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup(acpCtx_t _ctx, const struct SQN_EPDCCH_Config_r11_config_r11_setup* p)
{
	adbgPrintLog(_ctx, "subframePatternConfig_r11 := ");
	if (p->subframePatternConfig_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional(_ctx, &p->subframePatternConfig_r11);
	if (p->subframePatternConfig_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbol_r11 := ");
	_adbgSys__Uint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional(_ctx, &p->startSymbol_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "setConfigToReleaseList_r11 := ");
	if (p->setConfigToReleaseList_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional(_ctx, &p->setConfigToReleaseList_r11);
	if (p->setConfigToReleaseList_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "setConfigToAddModList_r11 := ");
	if (p->setConfigToAddModList_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional(_ctx, &p->setConfigToAddModList_r11);
	if (p->setConfigToAddModList_r11.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_EPDCCH_Config_r11_config_r11_Value(acpCtx_t _ctx, const union SQN_EPDCCH_Config_r11_config_r11_Value* p, enum SQN_EPDCCH_Config_r11_config_r11_Sel d)
{
	if (d == SQN_EPDCCH_Config_r11_config_r11_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_EPDCCH_Config_r11_config_r11_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_EPDCCH_Config_r11_config_r11_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_EPDCCH_Config_r11_config_r11(acpCtx_t _ctx, const struct SQN_EPDCCH_Config_r11_config_r11* p)
{
	_adbgSys__SQN_EPDCCH_Config_r11_config_r11_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_EPDCCH_Config_r11(acpCtx_t _ctx, const struct SQN_EPDCCH_Config_r11* p)
{
	adbgPrintLog(_ctx, "config_r11 := { ");
	_adbgSys__SQN_EPDCCH_Config_r11_config_r11(_ctx, &p->config_r11);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_EPDCCH_Config_r11_EPDCCH_Config_Optional(acpCtx_t _ctx, const struct SQN_EPDCCH_Config_r11_EPDCCH_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_EPDCCH_Config_r11(_ctx, &p->v);
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_dummy_e__ToString(SQN_FreqHoppingParameters_r13_dummy_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_dummy_e_nb2: return "SQN_FreqHoppingParameters_r13_dummy_e_nb2";
		case SQN_FreqHoppingParameters_r13_dummy_e_nb4: return "SQN_FreqHoppingParameters_r13_dummy_e_nb4";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_dummy_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int1: return "SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int1";
		case SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int2: return "SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int2";
		case SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int4: return "SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int4";
		case SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int8: return "SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int8";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int1: return "SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int1";
		case SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int5: return "SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int5";
		case SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int10: return "SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int10";
		case SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int20: return "SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int20";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_dummy2_Value(acpCtx_t _ctx, const union SQN_FreqHoppingParameters_r13_dummy2_Value* p, enum SQN_FreqHoppingParameters_r13_dummy2_Sel d)
{
	if (d == SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13) {
		adbgPrintLog(_ctx, "interval_FDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e__ToString(p->interval_FDD_r13), (int)p->interval_FDD_r13);
		return;
	}
	if (d == SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13) {
		adbgPrintLog(_ctx, "interval_TDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e__ToString(p->interval_TDD_r13), (int)p->interval_TDD_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_dummy2(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_dummy2* p)
{
	_adbgSys__SQN_FreqHoppingParameters_r13_dummy2_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_FreqHoppingParameters_r13_dummy2(_ctx, &p->v);
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int2: return "SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int2";
		case SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int4: return "SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int4";
		case SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int8: return "SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int8";
		case SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int16: return "SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int16";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int5: return "SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int5";
		case SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int10: return "SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int10";
		case SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int20: return "SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int20";
		case SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int40: return "SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int40";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_dummy3_Value(acpCtx_t _ctx, const union SQN_FreqHoppingParameters_r13_dummy3_Value* p, enum SQN_FreqHoppingParameters_r13_dummy3_Sel d)
{
	if (d == SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13) {
		adbgPrintLog(_ctx, "interval_FDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e__ToString(p->interval_FDD_r13), (int)p->interval_FDD_r13);
		return;
	}
	if (d == SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13) {
		adbgPrintLog(_ctx, "interval_TDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e__ToString(p->interval_TDD_r13), (int)p->interval_TDD_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_dummy3(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_dummy3* p)
{
	_adbgSys__SQN_FreqHoppingParameters_r13_dummy3_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_FreqHoppingParameters_r13_dummy3(_ctx, &p->v);
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int1: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int1";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int2: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int2";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int4: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int4";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int8: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int8";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int1: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int1";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int5: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int5";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int10: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int10";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int20: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int20";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value(acpCtx_t _ctx, const union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value* p, enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Sel d)
{
	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13) {
		adbgPrintLog(_ctx, "interval_FDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e__ToString(p->interval_FDD_r13), (int)p->interval_FDD_r13);
		return;
	}
	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13) {
		adbgPrintLog(_ctx, "interval_TDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e__ToString(p->interval_TDD_r13), (int)p->interval_TDD_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13* p)
{
	_adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13(_ctx, &p->v);
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int2: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int2";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int4: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int4";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int8: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int8";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int16: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int16";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e__ToString(SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e v)
{
	switch(v) {
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int5: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int5";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int10: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int10";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int20: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int20";
		case SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int40: return "SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int40";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value(acpCtx_t _ctx, const union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value* p, enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Sel d)
{
	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13) {
		adbgPrintLog(_ctx, "interval_FDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e__ToString(p->interval_FDD_r13), (int)p->interval_FDD_r13);
		return;
	}
	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13) {
		adbgPrintLog(_ctx, "interval_TDD_r13 := %s (%d)", adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e__ToString(p->interval_TDD_r13), (int)p->interval_TDD_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13* p)
{
	_adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13(_ctx, &p->v);
}

static void _adbgSys__Uint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_FreqHoppingParameters_r13(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13* p)
{
	adbgPrintLog(_ctx, "dummy := ");
	_adbgSys__SQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional(_ctx, &p->dummy);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy2 := ");
	if (p->dummy2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional(_ctx, &p->dummy2);
	if (p->dummy2.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy3 := ");
	if (p->dummy3.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional(_ctx, &p->dummy3);
	if (p->dummy3.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interval_ULHoppingConfigCommonModeA_r13 := ");
	if (p->interval_ULHoppingConfigCommonModeA_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional(_ctx, &p->interval_ULHoppingConfigCommonModeA_r13);
	if (p->interval_ULHoppingConfigCommonModeA_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interval_ULHoppingConfigCommonModeB_r13 := ");
	if (p->interval_ULHoppingConfigCommonModeB_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional(_ctx, &p->interval_ULHoppingConfigCommonModeB_r13);
	if (p->interval_ULHoppingConfigCommonModeB_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy4 := ");
	_adbgSys__Uint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional(_ctx, &p->dummy4);
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_mPDCCH_FreqHoppingParameters_r13_Optional(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_mPDCCH_FreqHoppingParameters_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_FreqHoppingParameters_r13(_ctx, &p->v);
}

static void _adbgSys__EpdcchConfig_Type(acpCtx_t _ctx, const struct EpdcchConfig_Type* p)
{
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__ToRS_EPRE_Ratios_Type_EpdcchConfig_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ePdcchCandidateList := ");
	if (p->ePdcchCandidateList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PdcchCandidateList_Type_ePdcchCandidateList_Optional(_ctx, &p->ePdcchCandidateList);
	if (p->ePdcchCandidateList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "EPDCCH_Config := ");
	if (p->EPDCCH_Config.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EPDCCH_Config_r11_EPDCCH_Config_Optional(_ctx, &p->EPDCCH_Config);
	if (p->EPDCCH_Config.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mPDCCH_FreqHoppingParameters_r13 := ");
	if (p->mPDCCH_FreqHoppingParameters_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_FreqHoppingParameters_r13_mPDCCH_FreqHoppingParameters_r13_Optional(_ctx, &p->mPDCCH_FreqHoppingParameters_r13);
	if (p->mPDCCH_FreqHoppingParameters_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__EpdcchConfig_Type_Epdcch_Optional(acpCtx_t _ctx, const struct EpdcchConfig_Type_Epdcch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__EpdcchConfig_Type(_ctx, &p->v);
}

static void _adbgSys__SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value(acpCtx_t _ctx, const union SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value* p, enum SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Sel d)
{
	if (d == SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms40_r12) {
		adbgPrintLog(_ctx, "ms40_r12 := %u", (unsigned int)p->ms40_r12);
		return;
	}
	if (d == SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms80_r12) {
		adbgPrintLog(_ctx, "ms80_r12 := %u", (unsigned int)p->ms80_r12);
		return;
	}
	if (d == SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms160_r12) {
		adbgPrintLog(_ctx, "ms160_r12 := %u", (unsigned int)p->ms160_r12);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__DMTC_PeriodOffset_r12_Type(acpCtx_t _ctx, const DMTC_PeriodOffset_r12_Type* p)
{
	_adbgSys__SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__DMTC_PeriodOffset_r12_Type_DMTC_PeriodOffset_Optional(acpCtx_t _ctx, const struct DMTC_PeriodOffset_r12_Type_DMTC_PeriodOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__DMTC_PeriodOffset_r12_Type(_ctx, &p->v);
}

static void _adbgSys__SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value(acpCtx_t _ctx, const union SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value* p, enum SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Sel d)
{
	if (d == SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_durationFDD_r12) {
		adbgPrintLog(_ctx, "durationFDD_r12 := %u", (unsigned int)p->durationFDD_r12);
		return;
	}
	if (d == SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_durationTDD_r12) {
		adbgPrintLog(_ctx, "durationTDD_r12 := %u", (unsigned int)p->durationTDD_r12);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__DS_OccasionDuration_r12_Type(acpCtx_t _ctx, const DS_OccasionDuration_r12_Type* p)
{
	_adbgSys__SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__DS_OccasionDuration_r12_Type_DS_OccasionDuration_r12_Optional(acpCtx_t _ctx, const struct DS_OccasionDuration_r12_Type_DS_OccasionDuration_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__DS_OccasionDuration_r12_Type(_ctx, &p->v);
}

static void _adbgSys__DS_RS_Config_Type(acpCtx_t _ctx, const struct DS_RS_Config_Type* p)
{
	adbgPrintLog(_ctx, "DMTC_PeriodOffset := ");
	if (p->DMTC_PeriodOffset.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__DMTC_PeriodOffset_r12_Type_DMTC_PeriodOffset_Optional(_ctx, &p->DMTC_PeriodOffset);
	if (p->DMTC_PeriodOffset.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DS_OccasionDuration_r12 := ");
	if (p->DS_OccasionDuration_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__DS_OccasionDuration_r12_Type_DS_OccasionDuration_r12_Optional(_ctx, &p->DS_OccasionDuration_r12);
	if (p->DS_OccasionDuration_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__DS_RS_Config_Type_DS_RS_Config_Optional(acpCtx_t _ctx, const struct DS_RS_Config_Type_DS_RS_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__DS_RS_Config_Type(_ctx, &p->v);
}

static void _adbgSys__PhysicalLayerConfigDL_Type(acpCtx_t _ctx, const struct PhysicalLayerConfigDL_Type* p)
{
	adbgPrintLog(_ctx, "AntennaGroup := ");
	if (p->AntennaGroup.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__DownlinkAntennaGroupConfig_Type_AntennaGroup_Optional(_ctx, &p->AntennaGroup);
	if (p->AntennaGroup.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pbch := ");
	if (p->Pbch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PbchConfig_Type_Pbch_Optional(_ctx, &p->Pbch);
	if (p->Pbch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pcfich := ");
	if (p->Pcfich.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PcfichConfig_Type_Pcfich_Optional(_ctx, &p->Pcfich);
	if (p->Pcfich.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Phich := ");
	if (p->Phich.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PhichConfig_Type_Phich_Optional(_ctx, &p->Phich);
	if (p->Phich.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pdcch := ");
	if (p->Pdcch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PdcchConfig_Type_Pdcch_Optional(_ctx, &p->Pdcch);
	if (p->Pdcch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pdsch := ");
	if (p->Pdsch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PdschConfig_Type_Pdsch_Optional(_ctx, &p->Pdsch);
	if (p->Pdsch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pss := ");
	if (p->Pss.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PrimarySyncSignal_Type_Pss_Optional(_ctx, &p->Pss);
	if (p->Pss.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Sss := ");
	if (p->Sss.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SecondarySyncSignal_Type_Sss_Optional(_ctx, &p->Sss);
	if (p->Sss.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CSI_RS_Config := ");
	if (p->CSI_RS_Config.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__CSI_RS_Config_Type_CSI_RS_Config_Optional(_ctx, &p->CSI_RS_Config);
	if (p->CSI_RS_Config.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pmch := ");
	if (p->Pmch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__PmchConfig_Type_Pmch_Optional(_ctx, &p->Pmch);
	if (p->Pmch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Epdcch := ");
	if (p->Epdcch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__EpdcchConfig_Type_Epdcch_Optional(_ctx, &p->Epdcch);
	if (p->Epdcch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DS_RS_Config := ");
	if (p->DS_RS_Config.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__DS_RS_Config_Type_DS_RS_Config_Optional(_ctx, &p->DS_RS_Config);
	if (p->DS_RS_Config.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__PhysicalLayerConfigDL_Type_PhysicalLayerConfigDL_Optional(acpCtx_t _ctx, const struct PhysicalLayerConfigDL_Type_PhysicalLayerConfigDL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__PhysicalLayerConfigDL_Type(_ctx, &p->v);
}

static void _adbgSys__Attenuation_Type_Value(acpCtx_t _ctx, const union Attenuation_Type_Value* p, enum Attenuation_Type_Sel d)
{
	if (d == Attenuation_Type_Value) {
		adbgPrintLog(_ctx, "Value := %u", (unsigned int)p->Value);
		return;
	}
	if (d == Attenuation_Type_Off) {
		adbgPrintLog(_ctx, "Off := %s", (p->Off ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__InitialAttenuation_Type(acpCtx_t _ctx, const InitialAttenuation_Type* p)
{
	_adbgSys__Attenuation_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__InitialCellPower_Type(acpCtx_t _ctx, const struct InitialCellPower_Type* p)
{
	adbgPrintLog(_ctx, "MaxReferencePower := %d", (int)p->MaxReferencePower);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Attenuation := { ");
	_adbgSys__InitialAttenuation_Type(_ctx, &p->Attenuation);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__InitialCellPower_Type_InitialCellPower_Optional(acpCtx_t _ctx, const struct InitialCellPower_Type_InitialCellPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__InitialCellPower_Type(_ctx, &p->v);
}

static void _adbgSys__BcchToPbchConfig_Type_Pbch_Optional(acpCtx_t _ctx, const struct BcchToPbchConfig_Type_Pbch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static const char* adbgSys__PdcchDciFormat_Type__ToString(PdcchDciFormat_Type v)
{
	switch(v) {
		case dci_0: return "dci_0";
		case dci_0A: return "dci_0A";
		case dci_0B: return "dci_0B";
		case dci_1: return "dci_1";
		case dci_1A: return "dci_1A";
		case dci_1B: return "dci_1B";
		case dci_1C: return "dci_1C";
		case dci_1D: return "dci_1D";
		case dci_2: return "dci_2";
		case dci_2A: return "dci_2A";
		case dci_2B: return "dci_2B";
		case dci_2C: return "dci_2C";
		case dci_2D: return "dci_2D";
		case dci_3: return "dci_3";
		case dci_3A: return "dci_3A";
		case dci_4: return "dci_4";
		case dci_4A: return "dci_4A";
		case dci_4B: return "dci_4B";
		case dci_6_0A: return "dci_6_0A";
		case dci_6_0B: return "dci_6_0B";
		case dci_6_1A: return "dci_6_1A";
		case dci_6_1B: return "dci_6_1B";
		case dci_6_2: return "dci_6_2";
		default: return "Unknown";
	}
}

static const char* adbgSys__PdcchResourceAllocation_Type__ToString(PdcchResourceAllocation_Type v)
{
	switch(v) {
		case ra_0: return "ra_0";
		case ra_1: return "ra_1";
		case ra_2_Localised: return "ra_2_Localised";
		case ra_2_Distributed: return "ra_2_Distributed";
		case ra_Unspecified: return "ra_Unspecified";
		default: return "Unknown";
	}
}

static const char* adbgSys__Modulation_Type__ToString(Modulation_Type v)
{
	switch(v) {
		case Modulation_unused: return "Modulation_unused";
		case Modulation_qpsk: return "Modulation_qpsk";
		case Modulation_qam16: return "Modulation_qam16";
		case Modulation_qam64: return "Modulation_qam64";
		default: return "Unknown";
	}
}

static void _adbgSys__FreqDomainSchedulCommon_Type(acpCtx_t _ctx, const struct FreqDomainSchedulCommon_Type* p)
{
	adbgPrintLog(_ctx, "FirstRbIndex := %d", (int)p->FirstRbIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "MaxRbCnt := %d", (int)p->MaxRbCnt);
}

static void _adbgSys__RepetitionNumber_Type_DciDlInfoCommon_Type_RepetitionNumber_Optional(acpCtx_t _ctx, const struct RepetitionNumber_Type_DciDlInfoCommon_Type_RepetitionNumber_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__DCISubframeRepetitionNumber_Type_DciDlInfoCommon_Type_DCISubframeRepetitionNumber_Optional(acpCtx_t _ctx, const struct DCISubframeRepetitionNumber_Type_DciDlInfoCommon_Type_DCISubframeRepetitionNumber_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__DciDlInfoCommon_Type(acpCtx_t _ctx, const struct DciDlInfoCommon_Type* p)
{
	adbgPrintLog(_ctx, "Format := %s (%d)", adbgSys__PdcchDciFormat_Type__ToString(p->Format), (int)p->Format);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ResourceAllocType := %s (%d)", adbgSys__PdcchResourceAllocation_Type__ToString(p->ResourceAllocType), (int)p->ResourceAllocType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Modulation_1stCW := %s (%d)", adbgSys__Modulation_Type__ToString(p->Modulation_1stCW), (int)p->Modulation_1stCW);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Modulation_2ndCW := %s (%d)", adbgSys__Modulation_Type__ToString(p->Modulation_2ndCW), (int)p->Modulation_2ndCW);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "FreqDomainSchedul := { ");
	_adbgSys__FreqDomainSchedulCommon_Type(_ctx, &p->FreqDomainSchedul);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RedundancyVersionList := '");
	for (size_t i1 = 0; i1 < p->RedundancyVersionList.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->RedundancyVersionList.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RepetitionNumber := ");
	_adbgSys__RepetitionNumber_Type_DciDlInfoCommon_Type_RepetitionNumber_Optional(_ctx, &p->RepetitionNumber);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DCISubframeRepetitionNumber := ");
	_adbgSys__DCISubframeRepetitionNumber_Type_DciDlInfoCommon_Type_DCISubframeRepetitionNumber_Optional(_ctx, &p->DCISubframeRepetitionNumber);
}

static void _adbgSys__DciDlInfoCommon_Type_Sib1Schedul_Type_DciInfo_Optional(acpCtx_t _ctx, const struct DciDlInfoCommon_Type_Sib1Schedul_Type_DciInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__DciDlInfoCommon_Type(_ctx, &p->v);
}

static void _adbgSys__Sib1Schedul_Type(acpCtx_t _ctx, const struct Sib1Schedul_Type* p)
{
	adbgPrintLog(_ctx, "DciInfo := ");
	if (p->DciInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__DciDlInfoCommon_Type_Sib1Schedul_Type_DciInfo_Optional(_ctx, &p->DciInfo);
	if (p->DciInfo.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__Sib1Schedul_Type_Sib1Schedul_Optional(acpCtx_t _ctx, const struct Sib1Schedul_Type_Sib1Schedul_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__Sib1Schedul_Type(_ctx, &p->v);
}

static const char* adbgSys__SiWindowLength_Type__ToString(SiWindowLength_Type v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms1: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms1";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms2: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms2";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms5: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms5";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms10: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms10";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms15: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms15";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms20: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms20";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms40: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms40";
		default: return "Unknown";
	}
}

static void _adbgSys__SiWindowLength_Type_WindowLength_Optional(acpCtx_t _ctx, const struct SiWindowLength_Type_WindowLength_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SiWindowLength_Type__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SI_Periodicity_r12_e__ToString(SQN_SI_Periodicity_r12_e v)
{
	switch(v) {
		case SQN_SI_Periodicity_r12_e_rf8: return "SQN_SI_Periodicity_r12_e_rf8";
		case SQN_SI_Periodicity_r12_e_rf16: return "SQN_SI_Periodicity_r12_e_rf16";
		case SQN_SI_Periodicity_r12_e_rf32: return "SQN_SI_Periodicity_r12_e_rf32";
		case SQN_SI_Periodicity_r12_e_rf64: return "SQN_SI_Periodicity_r12_e_rf64";
		case SQN_SI_Periodicity_r12_e_rf128: return "SQN_SI_Periodicity_r12_e_rf128";
		case SQN_SI_Periodicity_r12_e_rf256: return "SQN_SI_Periodicity_r12_e_rf256";
		case SQN_SI_Periodicity_r12_e_rf512: return "SQN_SI_Periodicity_r12_e_rf512";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SI_Periodicity_r12_e_Periodicity_Optional(acpCtx_t _ctx, const struct SQN_SI_Periodicity_r12_e_Periodicity_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SI_Periodicity_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__DciDlInfoCommon_Type_SingleSiSchedul_Type_DciInfo_Optional(acpCtx_t _ctx, const struct DciDlInfoCommon_Type_SingleSiSchedul_Type_DciInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__DciDlInfoCommon_Type(_ctx, &p->v);
}

static void _adbgSys__Int32_t_SubframeOffset_Optional(acpCtx_t _ctx, const struct int32_t_SubframeOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SingleSiSchedul_Type(acpCtx_t _ctx, const struct SingleSiSchedul_Type* p)
{
	adbgPrintLog(_ctx, "DciInfo := ");
	if (p->DciInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__DciDlInfoCommon_Type_SingleSiSchedul_Type_DciInfo_Optional(_ctx, &p->DciInfo);
	if (p->DciInfo.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SubframeOffset := ");
	_adbgSys__Int32_t_SubframeOffset_Optional(_ctx, &p->SubframeOffset);
}

static void _adbgSys__SingleSiSchedul_Type_Window_DynamicOptional(acpCtx_t _ctx, const struct SingleSiSchedul_Type_Window_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SingleSiSchedul_Type(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SiSchedul_Type(acpCtx_t _ctx, const struct SiSchedul_Type* p)
{
	adbgPrintLog(_ctx, "Periodicity := ");
	_adbgSys__SQN_SI_Periodicity_r12_e_Periodicity_Optional(_ctx, &p->Periodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Window := ");
	if (p->Window.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SingleSiSchedul_Type_Window_DynamicOptional(_ctx, &p->Window);
	if (p->Window.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SiSchedulList_Type_SiList_Optional(acpCtx_t _ctx, const struct SiSchedulList_Type_SiList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__SiSchedul_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SiSchedulList_Type_SegmentedSiList_Optional(acpCtx_t _ctx, const struct SiSchedulList_Type_SegmentedSiList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__SiSchedul_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__AllSiSchedul_Type(acpCtx_t _ctx, const struct AllSiSchedul_Type* p)
{
	adbgPrintLog(_ctx, "WindowLength := ");
	_adbgSys__SiWindowLength_Type_WindowLength_Optional(_ctx, &p->WindowLength);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SiList := ");
	if (p->SiList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SiSchedulList_Type_SiList_Optional(_ctx, &p->SiList);
	if (p->SiList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SegmentedSiList := ");
	if (p->SegmentedSiList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SiSchedulList_Type_SegmentedSiList_Optional(_ctx, &p->SegmentedSiList);
	if (p->SegmentedSiList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__AllSiSchedul_Type_SiSchedul_Optional(acpCtx_t _ctx, const struct AllSiSchedul_Type_SiSchedul_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__AllSiSchedul_Type(_ctx, &p->v);
}

static void _adbgSys__BcchToPdschConfig_Type(acpCtx_t _ctx, const struct BcchToPdschConfig_Type* p)
{
	adbgPrintLog(_ctx, "Sib1Schedul := ");
	if (p->Sib1Schedul.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__Sib1Schedul_Type_Sib1Schedul_Optional(_ctx, &p->Sib1Schedul);
	if (p->Sib1Schedul.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SiSchedul := ");
	if (p->SiSchedul.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__AllSiSchedul_Type_SiSchedul_Optional(_ctx, &p->SiSchedul);
	if (p->SiSchedul.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__BcchToPdschConfig_Type_Pdsch_Optional(acpCtx_t _ctx, const struct BcchToPdschConfig_Type_Pdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__BcchToPdschConfig_Type(_ctx, &p->v);
}

static const char* adbgSys__SQN_MasterInformationBlock_dl_Bandwidth_e__ToString(SQN_MasterInformationBlock_dl_Bandwidth_e v)
{
	switch(v) {
		case SQN_MasterInformationBlock_dl_Bandwidth_e_n6: return "SQN_MasterInformationBlock_dl_Bandwidth_e_n6";
		case SQN_MasterInformationBlock_dl_Bandwidth_e_n15: return "SQN_MasterInformationBlock_dl_Bandwidth_e_n15";
		case SQN_MasterInformationBlock_dl_Bandwidth_e_n25: return "SQN_MasterInformationBlock_dl_Bandwidth_e_n25";
		case SQN_MasterInformationBlock_dl_Bandwidth_e_n50: return "SQN_MasterInformationBlock_dl_Bandwidth_e_n50";
		case SQN_MasterInformationBlock_dl_Bandwidth_e_n75: return "SQN_MasterInformationBlock_dl_Bandwidth_e_n75";
		case SQN_MasterInformationBlock_dl_Bandwidth_e_n100: return "SQN_MasterInformationBlock_dl_Bandwidth_e_n100";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MasterInformationBlock(acpCtx_t _ctx, const struct SQN_MasterInformationBlock* p)
{
	adbgPrintLog(_ctx, "dl_Bandwidth := %s (%d)", adbgSys__SQN_MasterInformationBlock_dl_Bandwidth_e__ToString(p->dl_Bandwidth), (int)p->dl_Bandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "phich_Config := { ");
	_adbgSys__SQN_PHICH_Config(_ctx, &p->phich_Config);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "systemFrameNumber := '");
	for (size_t i1 = 0; i1 < 8; i1++) {
		adbgPrintLog(_ctx, "%02X", p->systemFrameNumber[i1]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "schedulingInfoSIB1_BR_r13 := %u", (unsigned int)p->schedulingInfoSIB1_BR_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "systemInfoUnchanged_BR_r15 := %s", (p->systemInfoUnchanged_BR_r15 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spare := '");
	for (size_t i1 = 0; i1 < 4; i1++) {
		adbgPrintLog(_ctx, "%02X", p->spare[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_BCCH_BCH_Message(acpCtx_t _ctx, const struct SQN_BCCH_BCH_Message* p)
{
	adbgPrintLog(_ctx, "message := { ");
	_adbgSys__SQN_MasterInformationBlock(_ctx, &p->message);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_BCCH_BCH_Message_BcchInfo_Type_MIB_Optional(acpCtx_t _ctx, const struct SQN_BCCH_BCH_Message_BcchInfo_Type_MIB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_BCCH_BCH_Message(_ctx, &p->v);
}

static const char* adbgSys__SQN_AC_BarringConfig_ac_BarringFactor_e__ToString(SQN_AC_BarringConfig_ac_BarringFactor_e v)
{
	switch(v) {
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p00: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p00";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p05: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p05";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p10: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p10";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p15: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p15";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p20: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p20";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p25: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p25";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p30: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p30";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p40: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p40";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p50: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p50";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p60: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p60";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p70: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p70";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p75: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p75";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p80: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p80";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p85: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p85";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p90: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p90";
		case SQN_AC_BarringConfig_ac_BarringFactor_e_p95: return "SQN_AC_BarringConfig_ac_BarringFactor_e_p95";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_AC_BarringConfig_ac_BarringTime_e__ToString(SQN_AC_BarringConfig_ac_BarringTime_e v)
{
	switch(v) {
		case SQN_AC_BarringConfig_ac_BarringTime_e_s4: return "SQN_AC_BarringConfig_ac_BarringTime_e_s4";
		case SQN_AC_BarringConfig_ac_BarringTime_e_s8: return "SQN_AC_BarringConfig_ac_BarringTime_e_s8";
		case SQN_AC_BarringConfig_ac_BarringTime_e_s16: return "SQN_AC_BarringConfig_ac_BarringTime_e_s16";
		case SQN_AC_BarringConfig_ac_BarringTime_e_s32: return "SQN_AC_BarringConfig_ac_BarringTime_e_s32";
		case SQN_AC_BarringConfig_ac_BarringTime_e_s64: return "SQN_AC_BarringConfig_ac_BarringTime_e_s64";
		case SQN_AC_BarringConfig_ac_BarringTime_e_s128: return "SQN_AC_BarringConfig_ac_BarringTime_e_s128";
		case SQN_AC_BarringConfig_ac_BarringTime_e_s256: return "SQN_AC_BarringConfig_ac_BarringTime_e_s256";
		case SQN_AC_BarringConfig_ac_BarringTime_e_s512: return "SQN_AC_BarringConfig_ac_BarringTime_e_s512";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_AC_BarringConfig(acpCtx_t _ctx, const struct SQN_AC_BarringConfig* p)
{
	adbgPrintLog(_ctx, "ac_BarringFactor := %s (%d)", adbgSys__SQN_AC_BarringConfig_ac_BarringFactor_e__ToString(p->ac_BarringFactor), (int)p->ac_BarringFactor);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringTime := %s (%d)", adbgSys__SQN_AC_BarringConfig_ac_BarringTime_e__ToString(p->ac_BarringTime), (int)p->ac_BarringTime);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringForSpecialAC := '");
	for (size_t i2 = 0; i2 < 5; i2++) {
		adbgPrintLog(_ctx, "%02X", p->ac_BarringForSpecialAC[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType2_ac_BarringInfo(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_ac_BarringInfo* p)
{
	adbgPrintLog(_ctx, "ac_BarringForEmergency := %s", (p->ac_BarringForEmergency ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringForMO_Signalling := ");
	if (p->ac_BarringForMO_Signalling.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional(_ctx, &p->ac_BarringForMO_Signalling);
	if (p->ac_BarringForMO_Signalling.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringForMO_Data := ");
	if (p->ac_BarringForMO_Data.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional(_ctx, &p->ac_BarringForMO_Data);
	if (p->ac_BarringForMO_Data.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType2_ac_BarringInfo(_ctx, &p->v);
}

static const char* adbgSys__SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e__ToString(SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n4: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n4";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n8: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n8";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n12: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n12";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n16: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n16";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n20: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n20";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n24: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n24";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n28: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n28";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n32: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n32";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n36: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n36";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n40: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n40";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n44: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n44";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n48: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n48";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n52: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n52";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n56: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n56";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n60: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n60";
		case SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n64: return "SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e__ToString(SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n4: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n4";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n8: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n8";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n12: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n12";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n16: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n16";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n20: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n20";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n24: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n24";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n28: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n28";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n32: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n32";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n36: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n36";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n40: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n40";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n44: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n44";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n48: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n48";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n52: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n52";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n56: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n56";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n60: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n60";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e__ToString(SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b56: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b56";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b144: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b144";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b208: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b208";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b256: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b256";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e__ToString(SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_minusinfinity: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_minusinfinity";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB0: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB0";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB5: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB5";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB8: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB8";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB10: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB10";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB12: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB12";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB15: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB15";
		case SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB18: return "SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB18";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig* p)
{
	adbgPrintLog(_ctx, "sizeOfRA_PreamblesGroupA := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e__ToString(p->sizeOfRA_PreamblesGroupA), (int)p->sizeOfRA_PreamblesGroupA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "messageSizeGroupA := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e__ToString(p->messageSizeGroupA), (int)p->messageSizeGroupA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "messagePowerOffsetGroupB := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e__ToString(p->messagePowerOffsetGroupB), (int)p->messagePowerOffsetGroupB);
}

static void _adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_RACH_ConfigCommon_preambleInfo(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_preambleInfo* p)
{
	adbgPrintLog(_ctx, "numberOfRA_Preambles := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e__ToString(p->numberOfRA_Preambles), (int)p->numberOfRA_Preambles);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "preamblesGroupAConfig := ");
	if (p->preamblesGroupAConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional(_ctx, &p->preamblesGroupAConfig);
	if (p->preamblesGroupAConfig.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_PowerRampingParameters_powerRampingStep_e__ToString(SQN_PowerRampingParameters_powerRampingStep_e v)
{
	switch(v) {
		case SQN_PowerRampingParameters_powerRampingStep_e_dB0: return "SQN_PowerRampingParameters_powerRampingStep_e_dB0";
		case SQN_PowerRampingParameters_powerRampingStep_e_dB2: return "SQN_PowerRampingParameters_powerRampingStep_e_dB2";
		case SQN_PowerRampingParameters_powerRampingStep_e_dB4: return "SQN_PowerRampingParameters_powerRampingStep_e_dB4";
		case SQN_PowerRampingParameters_powerRampingStep_e_dB6: return "SQN_PowerRampingParameters_powerRampingStep_e_dB6";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e__ToString(SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e v)
{
	switch(v) {
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_120: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_120";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_118: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_118";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_116: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_116";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_114: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_114";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_112: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_112";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_110: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_110";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_108: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_108";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_106: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_106";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_104: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_104";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_102: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_102";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_100: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_100";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_98: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_98";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_96: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_96";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_94: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_94";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_92: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_92";
		case SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_90: return "SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_90";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PowerRampingParameters(acpCtx_t _ctx, const struct SQN_PowerRampingParameters* p)
{
	adbgPrintLog(_ctx, "powerRampingStep := %s (%d)", adbgSys__SQN_PowerRampingParameters_powerRampingStep_e__ToString(p->powerRampingStep), (int)p->powerRampingStep);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "preambleInitialReceivedTargetPower := %s (%d)", adbgSys__SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e__ToString(p->preambleInitialReceivedTargetPower), (int)p->preambleInitialReceivedTargetPower);
}

static const char* adbgSys__SQN_PreambleTransMax_e__ToString(SQN_PreambleTransMax_e v)
{
	switch(v) {
		case SQN_PreambleTransMax_e_n3: return "SQN_PreambleTransMax_e_n3";
		case SQN_PreambleTransMax_e_n4: return "SQN_PreambleTransMax_e_n4";
		case SQN_PreambleTransMax_e_n5: return "SQN_PreambleTransMax_e_n5";
		case SQN_PreambleTransMax_e_n6: return "SQN_PreambleTransMax_e_n6";
		case SQN_PreambleTransMax_e_n7: return "SQN_PreambleTransMax_e_n7";
		case SQN_PreambleTransMax_e_n8: return "SQN_PreambleTransMax_e_n8";
		case SQN_PreambleTransMax_e_n10: return "SQN_PreambleTransMax_e_n10";
		case SQN_PreambleTransMax_e_n20: return "SQN_PreambleTransMax_e_n20";
		case SQN_PreambleTransMax_e_n50: return "SQN_PreambleTransMax_e_n50";
		case SQN_PreambleTransMax_e_n100: return "SQN_PreambleTransMax_e_n100";
		case SQN_PreambleTransMax_e_n200: return "SQN_PreambleTransMax_e_n200";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e__ToString(SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf2: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf2";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf3: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf3";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf4: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf4";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf5: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf5";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf6: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf6";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf7: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf7";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf8: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf8";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf10: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf10";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e__ToString(SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf8: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf8";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf16: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf16";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf24: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf24";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf32: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf32";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf40: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf40";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf48: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf48";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf56: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf56";
		case SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf64: return "SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf64";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RACH_ConfigCommon_ra_SupervisionInfo(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_ra_SupervisionInfo* p)
{
	adbgPrintLog(_ctx, "preambleTransMax := %s (%d)", adbgSys__SQN_PreambleTransMax_e__ToString(p->preambleTransMax), (int)p->preambleTransMax);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ResponseWindowSize := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e__ToString(p->ra_ResponseWindowSize), (int)p->ra_ResponseWindowSize);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mac_ContentionResolutionTimer := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e__ToString(p->mac_ContentionResolutionTimer), (int)p->mac_ContentionResolutionTimer);
}

static void _adbgSys__SQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional(acpCtx_t _ctx, const struct SQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PreambleTransMax_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13(acpCtx_t _ctx, const struct SQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13* p)
{
	adbgPrintLog(_ctx, "firstPreamble_r13 := %u", (unsigned int)p->firstPreamble_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lastPreamble_r13 := %u", (unsigned int)p->lastPreamble_r13);
}

static const char* adbgSys__SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e__ToString(SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e v)
{
	switch(v) {
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf20: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf20";
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf50: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf50";
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf80: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf80";
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf120: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf120";
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf180: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf180";
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf240: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf240";
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf320: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf320";
		case SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf400: return "SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf400";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e__ToString(SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e v)
{
	switch(v) {
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf80: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf80";
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf100: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf100";
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf120: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf120";
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf160: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf160";
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf200: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf200";
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf240: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf240";
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf480: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf480";
		case SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf960: return "SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf960";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e__ToString(SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e v)
{
	switch(v) {
		case SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e_on: return "SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e_on";
		case SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e_off: return "SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e_off";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e__ToString(SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e v)
{
	switch(v) {
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b328: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b328";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b408: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b408";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b504: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b504";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b600: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b600";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b712: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b712";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b808: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b808";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b936: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b936";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b1000or456: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b1000or456";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e__ToString(SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e v)
{
	switch(v) {
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf240: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf240";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf480: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf480";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf960: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf960";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf1920: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf1920";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf3840: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf3840";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf5760: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf5760";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf7680: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf7680";
		case SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf10240: return "SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf10240";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional(acpCtx_t _ctx, const struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15(acpCtx_t _ctx, const struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15* p)
{
	adbgPrintLog(_ctx, "edt_LastPreamble_r15 := %u", (unsigned int)p->edt_LastPreamble_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "edt_SmallTBS_Enabled_r15 := %s", (p->edt_SmallTBS_Enabled_r15 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "edt_TBS_r15 := %s (%d)", adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e__ToString(p->edt_TBS_r15), (int)p->edt_TBS_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mac_ContentionResolutionTimer_r15 := ");
	_adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional(_ctx, &p->mac_ContentionResolutionTimer_r15);
}

static void _adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional(acpCtx_t _ctx, const struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_RACH_CE_LevelInfo_r13(acpCtx_t _ctx, const struct SQN_RACH_CE_LevelInfo_r13* p)
{
	adbgPrintLog(_ctx, "preambleMappingInfo_r13 := { ");
	_adbgSys__SQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13(_ctx, &p->preambleMappingInfo_r13);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ResponseWindowSize_r13 := %s (%d)", adbgSys__SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e__ToString(p->ra_ResponseWindowSize_r13), (int)p->ra_ResponseWindowSize_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mac_ContentionResolutionTimer_r13 := %s (%d)", adbgSys__SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e__ToString(p->mac_ContentionResolutionTimer_r13), (int)p->mac_ContentionResolutionTimer_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rar_HoppingConfig_r13 := %s (%d)", adbgSys__SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e__ToString(p->rar_HoppingConfig_r13), (int)p->rar_HoppingConfig_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "edt_Parameters_r15 := ");
	if (p->edt_Parameters_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional(_ctx, &p->edt_Parameters_r15);
	if (p->edt_Parameters_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional(acpCtx_t _ctx, const struct SQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_RACH_CE_LevelInfo_r13(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e__ToString(SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_true: return "SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_RACH_ConfigCommon(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "preambleInfo := { ");
	_adbgSys__SQN_RACH_ConfigCommon_preambleInfo(_ctx, &p->preambleInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "powerRampingParameters := { ");
	_adbgSys__SQN_PowerRampingParameters(_ctx, &p->powerRampingParameters);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_SupervisionInfo := { ");
	_adbgSys__SQN_RACH_ConfigCommon_ra_SupervisionInfo(_ctx, &p->ra_SupervisionInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxHARQ_Msg3Tx := %u", (unsigned int)p->maxHARQ_Msg3Tx);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "preambleTransMax_CE_r13 := ");
	_adbgSys__SQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional(_ctx, &p->preambleTransMax_CE_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rach_CE_LevelInfoList_r13 := ");
	if (p->rach_CE_LevelInfoList_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional(_ctx, &p->rach_CE_LevelInfoList_r13);
	if (p->rach_CE_LevelInfoList_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "edt_SmallTBS_Subset_r15 := ");
	_adbgSys__SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional(_ctx, &p->edt_SmallTBS_Subset_r15);
}

static const char* adbgSys__SQN_BCCH_Config_modificationPeriodCoeff_e__ToString(SQN_BCCH_Config_modificationPeriodCoeff_e v)
{
	switch(v) {
		case SQN_BCCH_Config_modificationPeriodCoeff_e_n2: return "SQN_BCCH_Config_modificationPeriodCoeff_e_n2";
		case SQN_BCCH_Config_modificationPeriodCoeff_e_n4: return "SQN_BCCH_Config_modificationPeriodCoeff_e_n4";
		case SQN_BCCH_Config_modificationPeriodCoeff_e_n8: return "SQN_BCCH_Config_modificationPeriodCoeff_e_n8";
		case SQN_BCCH_Config_modificationPeriodCoeff_e_n16: return "SQN_BCCH_Config_modificationPeriodCoeff_e_n16";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_BCCH_Config(acpCtx_t _ctx, const struct SQN_BCCH_Config* p)
{
	adbgPrintLog(_ctx, "modificationPeriodCoeff := %s (%d)", adbgSys__SQN_BCCH_Config_modificationPeriodCoeff_e__ToString(p->modificationPeriodCoeff), (int)p->modificationPeriodCoeff);
}

static const char* adbgSys__SQN_PCCH_Config_defaultPagingCycle_e__ToString(SQN_PCCH_Config_defaultPagingCycle_e v)
{
	switch(v) {
		case SQN_PCCH_Config_defaultPagingCycle_e_rf32: return "SQN_PCCH_Config_defaultPagingCycle_e_rf32";
		case SQN_PCCH_Config_defaultPagingCycle_e_rf64: return "SQN_PCCH_Config_defaultPagingCycle_e_rf64";
		case SQN_PCCH_Config_defaultPagingCycle_e_rf128: return "SQN_PCCH_Config_defaultPagingCycle_e_rf128";
		case SQN_PCCH_Config_defaultPagingCycle_e_rf256: return "SQN_PCCH_Config_defaultPagingCycle_e_rf256";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_PCCH_Config_nB_e__ToString(SQN_PCCH_Config_nB_e v)
{
	switch(v) {
		case SQN_PCCH_Config_nB_e_fourT: return "SQN_PCCH_Config_nB_e_fourT";
		case SQN_PCCH_Config_nB_e_twoT: return "SQN_PCCH_Config_nB_e_twoT";
		case SQN_PCCH_Config_nB_e_oneT: return "SQN_PCCH_Config_nB_e_oneT";
		case SQN_PCCH_Config_nB_e_halfT: return "SQN_PCCH_Config_nB_e_halfT";
		case SQN_PCCH_Config_nB_e_quarterT: return "SQN_PCCH_Config_nB_e_quarterT";
		case SQN_PCCH_Config_nB_e_oneEighthT: return "SQN_PCCH_Config_nB_e_oneEighthT";
		case SQN_PCCH_Config_nB_e_oneSixteenthT: return "SQN_PCCH_Config_nB_e_oneSixteenthT";
		case SQN_PCCH_Config_nB_e_oneThirtySecondT: return "SQN_PCCH_Config_nB_e_oneThirtySecondT";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PCCH_Config(acpCtx_t _ctx, const struct SQN_PCCH_Config* p)
{
	adbgPrintLog(_ctx, "defaultPagingCycle := %s (%d)", adbgSys__SQN_PCCH_Config_defaultPagingCycle_e__ToString(p->defaultPagingCycle), (int)p->defaultPagingCycle);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nB := %s (%d)", adbgSys__SQN_PCCH_Config_nB_e__ToString(p->nB), (int)p->nB);
}

static void _adbgSys__SQN_PRACH_ConfigInfo(acpCtx_t _ctx, const struct SQN_PRACH_ConfigInfo* p)
{
	adbgPrintLog(_ctx, "prach_ConfigIndex := %u", (unsigned int)p->prach_ConfigIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedFlag := %s", (p->highSpeedFlag ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zeroCorrelationZoneConfig := %u", (unsigned int)p->zeroCorrelationZoneConfig);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_FreqOffset := %u", (unsigned int)p->prach_FreqOffset);
}

static void _adbgSys__SQN_PRACH_ConfigSIB(acpCtx_t _ctx, const struct SQN_PRACH_ConfigSIB* p)
{
	adbgPrintLog(_ctx, "rootSequenceIndex := %u", (unsigned int)p->rootSequenceIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ConfigInfo := { ");
	_adbgSys__SQN_PRACH_ConfigInfo(_ctx, &p->prach_ConfigInfo);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_PDSCH_ConfigCommon(acpCtx_t _ctx, const struct SQN_PDSCH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "referenceSignalPower := %d", (int)p->referenceSignalPower);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_b := %u", (unsigned int)p->p_b);
}

static const char* adbgSys__SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e__ToString(SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e v)
{
	switch(v) {
		case SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e_interSubFrame: return "SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e_interSubFrame";
		case SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e_intraAndInterSubFrame: return "SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e_intraAndInterSubFrame";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUSCH_ConfigCommon_pusch_ConfigBasic(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon_pusch_ConfigBasic* p)
{
	adbgPrintLog(_ctx, "n_SB := %u", (unsigned int)p->n_SB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "hoppingMode := %s (%d)", adbgSys__SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e__ToString(p->hoppingMode), (int)p->hoppingMode);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_HoppingOffset := %u", (unsigned int)p->pusch_HoppingOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "enable64QAM := %s", (p->enable64QAM ? "true" : "false"));
}

static void _adbgSys__SQN_UL_ReferenceSignalsPUSCH(acpCtx_t _ctx, const struct SQN_UL_ReferenceSignalsPUSCH* p)
{
	adbgPrintLog(_ctx, "groupHoppingEnabled := %s", (p->groupHoppingEnabled ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "groupAssignmentPUSCH := %u", (unsigned int)p->groupAssignmentPUSCH);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sequenceHoppingEnabled := %s", (p->sequenceHoppingEnabled ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cyclicShift := %u", (unsigned int)p->cyclicShift);
}

static void _adbgSys__SQN_PUSCH_ConfigCommon(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "pusch_ConfigBasic := { ");
	_adbgSys__SQN_PUSCH_ConfigCommon_pusch_ConfigBasic(_ctx, &p->pusch_ConfigBasic);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ul_ReferenceSignalsPUSCH := { ");
	_adbgSys__SQN_UL_ReferenceSignalsPUSCH(_ctx, &p->ul_ReferenceSignalsPUSCH);
	adbgPrintLog(_ctx, " }");
}

static const char* adbgSys__SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e__ToString(SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e v)
{
	switch(v) {
		case SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds1: return "SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds1";
		case SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds2: return "SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds2";
		case SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds3: return "SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds3";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUCCH_ConfigCommon(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "deltaPUCCH_Shift := %s (%d)", adbgSys__SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e__ToString(p->deltaPUCCH_Shift), (int)p->deltaPUCCH_Shift);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nRB_CQI := %u", (unsigned int)p->nRB_CQI);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nCS_AN := %u", (unsigned int)p->nCS_AN);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n1PUCCH_AN := %u", (unsigned int)p->n1PUCCH_AN);
}

static const char* adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e__ToString(SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e v)
{
	switch(v) {
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw0: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw0";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw1: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw1";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw2: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw2";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw3: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw3";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw4: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw4";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw5: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw5";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw6: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw6";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw7: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw7";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e__ToString(SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e v)
{
	switch(v) {
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc0: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc0";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc1: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc1";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc2: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc2";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc3: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc3";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc4: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc4";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc5: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc5";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc6: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc6";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc7: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc7";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc8: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc8";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc9: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc9";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc10: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc10";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc11: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc11";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc12: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc12";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc13: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc13";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc14: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc14";
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc15: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc15";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e__ToString(SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e v)
{
	switch(v) {
		case SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_true: return "SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional(acpCtx_t _ctx, const struct SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup(acpCtx_t _ctx, const struct SQN_SoundingRS_UL_ConfigCommon_setup* p)
{
	adbgPrintLog(_ctx, "srs_BandwidthConfig := %s (%d)", adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e__ToString(p->srs_BandwidthConfig), (int)p->srs_BandwidthConfig);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_SubframeConfig := %s (%d)", adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e__ToString(p->srs_SubframeConfig), (int)p->srs_SubframeConfig);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ackNackSRS_SimultaneousTransmission := %s", (p->ackNackSRS_SimultaneousTransmission ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_MaxUpPts := ");
	_adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional(_ctx, &p->srs_MaxUpPts);
}

static void _adbgSys__SQN_SoundingRS_UL_ConfigCommon_Value(acpCtx_t _ctx, const union SQN_SoundingRS_UL_ConfigCommon_Value* p, enum SQN_SoundingRS_UL_ConfigCommon_Sel d)
{
	if (d == SQN_SoundingRS_UL_ConfigCommon_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_SoundingRS_UL_ConfigCommon_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_SoundingRS_UL_ConfigCommon_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SoundingRS_UL_ConfigCommon(acpCtx_t _ctx, const struct SQN_SoundingRS_UL_ConfigCommon* p)
{
	_adbgSys__SQN_SoundingRS_UL_ConfigCommon_Value(_ctx, &p->v, p->d);
}

static const char* adbgSys__SQN_Alpha_r12_e__ToString(SQN_Alpha_r12_e v)
{
	switch(v) {
		case SQN_Alpha_r12_e_al0: return "SQN_Alpha_r12_e_al0";
		case SQN_Alpha_r12_e_al04: return "SQN_Alpha_r12_e_al04";
		case SQN_Alpha_r12_e_al05: return "SQN_Alpha_r12_e_al05";
		case SQN_Alpha_r12_e_al06: return "SQN_Alpha_r12_e_al06";
		case SQN_Alpha_r12_e_al07: return "SQN_Alpha_r12_e_al07";
		case SQN_Alpha_r12_e_al08: return "SQN_Alpha_r12_e_al08";
		case SQN_Alpha_r12_e_al09: return "SQN_Alpha_r12_e_al09";
		case SQN_Alpha_r12_e_al1: return "SQN_Alpha_r12_e_al1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e__ToString(SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e v)
{
	switch(v) {
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF_2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF_2";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF0: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF0";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF2";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e__ToString(SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e v)
{
	switch(v) {
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF1: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF1";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF3: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF3";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF5: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF5";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e__ToString(SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e v)
{
	switch(v) {
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF_2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF_2";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF0: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF0";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF1: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF1";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF2";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e__ToString(SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e v)
{
	switch(v) {
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF_2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF_2";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF0: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF0";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF2";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e__ToString(SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e v)
{
	switch(v) {
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF_2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF_2";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF0: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF0";
		case SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF2: return "SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF2";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_PUCCH(acpCtx_t _ctx, const struct SQN_DeltaFList_PUCCH* p)
{
	adbgPrintLog(_ctx, "deltaF_PUCCH_Format1 := %s (%d)", adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e__ToString(p->deltaF_PUCCH_Format1), (int)p->deltaF_PUCCH_Format1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_Format1b := %s (%d)", adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e__ToString(p->deltaF_PUCCH_Format1b), (int)p->deltaF_PUCCH_Format1b);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_Format2 := %s (%d)", adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e__ToString(p->deltaF_PUCCH_Format2), (int)p->deltaF_PUCCH_Format2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_Format2a := %s (%d)", adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e__ToString(p->deltaF_PUCCH_Format2a), (int)p->deltaF_PUCCH_Format2a);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_Format2b := %s (%d)", adbgSys__SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e__ToString(p->deltaF_PUCCH_Format2b), (int)p->deltaF_PUCCH_Format2b);
}

static void _adbgSys__SQN_UplinkPowerControlCommon(acpCtx_t _ctx, const struct SQN_UplinkPowerControlCommon* p)
{
	adbgPrintLog(_ctx, "p0_NominalPUSCH := %d", (int)p->p0_NominalPUSCH);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "alpha := %s (%d)", adbgSys__SQN_Alpha_r12_e__ToString(p->alpha), (int)p->alpha);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_NominalPUCCH := %d", (int)p->p0_NominalPUCCH);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaFList_PUCCH := { ");
	_adbgSys__SQN_DeltaFList_PUCCH(_ctx, &p->deltaFList_PUCCH);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaPreambleMsg3 := %d", (int)p->deltaPreambleMsg3);
}

static const char* adbgSys__SQN_UL_CyclicPrefixLength_e__ToString(SQN_UL_CyclicPrefixLength_e v)
{
	switch(v) {
		case SQN_UL_CyclicPrefixLength_e_len1: return "SQN_UL_CyclicPrefixLength_e_len1";
		case SQN_UL_CyclicPrefixLength_e_len2: return "SQN_UL_CyclicPrefixLength_e_len2";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e__ToString(SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e v)
{
	switch(v) {
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF_1: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF_1";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF0: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF0";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF1: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF1";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF2: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF2";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF3: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF3";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF4: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF4";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF5: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF5";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF6: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF6";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e__ToString(SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e v)
{
	switch(v) {
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_deltaF1: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_deltaF1";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_deltaF2: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_deltaF2";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_spare2: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_spare2";
		case SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_spare1: return "SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UplinkPowerControlCommon_v1020(acpCtx_t _ctx, const struct SQN_UplinkPowerControlCommon_v1020* p)
{
	adbgPrintLog(_ctx, "deltaF_PUCCH_Format3_r10 := %s (%d)", adbgSys__SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e__ToString(p->deltaF_PUCCH_Format3_r10), (int)p->deltaF_PUCCH_Format3_r10);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_Format1bCS_r10 := %s (%d)", adbgSys__SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e__ToString(p->deltaF_PUCCH_Format1bCS_r10), (int)p->deltaF_PUCCH_Format1bCS_r10);
}

static void _adbgSys__SQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional(acpCtx_t _ctx, const struct SQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_UplinkPowerControlCommon_v1020(_ctx, &p->v);
}

static const char* adbgSys__SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e__ToString(SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n1: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n1";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n2: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n2";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n3: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n3";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n4: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n4";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e__ToString(SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e v)
{
	switch(v) {
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s30: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s30";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s60: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s60";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s120: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s120";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s240: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s240";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s300: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s300";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s420: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s420";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s600: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s600";
		case SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s900: return "SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s900";
		default: return "Unknown";
	}
}

static void _adbgSys__Uint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RACH_ConfigCommon_v1250_txFailParams_r12(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_v1250_txFailParams_r12* p)
{
	adbgPrintLog(_ctx, "connEstFailCount_r12 := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e__ToString(p->connEstFailCount_r12), (int)p->connEstFailCount_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "connEstFailOffsetValidity_r12 := %s (%d)", adbgSys__SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e__ToString(p->connEstFailOffsetValidity_r12), (int)p->connEstFailOffsetValidity_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "connEstFailOffset_r12 := ");
	_adbgSys__Uint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional(_ctx, &p->connEstFailOffset_r12);
}

static void _adbgSys__SQN_RACH_ConfigCommon_v1250(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_v1250* p)
{
	adbgPrintLog(_ctx, "txFailParams_r12 := { ");
	_adbgSys__SQN_RACH_ConfigCommon_v1250_txFailParams_r12(_ctx, &p->txFailParams_r12);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional(acpCtx_t _ctx, const struct SQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RACH_ConfigCommon_v1250(_ctx, &p->v);
}

static const char* adbgSys__SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e__ToString(SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e v)
{
	switch(v) {
		case SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e_true: return "SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUSCH_ConfigCommon_v1270(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon_v1270* p)
{
	adbgPrintLog(_ctx, "enable64QAM_v1270 := %s (%d)", adbgSys__SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e__ToString(p->enable64QAM_v1270), (int)p->enable64QAM_v1270);
}

static void _adbgSys__SQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PUSCH_ConfigCommon_v1270(_ctx, &p->v);
}

static const char* adbgSys__SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e__ToString(SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e v)
{
	switch(v) {
		case SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e_n64: return "SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e_n64";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_BCCH_Config_v1310(acpCtx_t _ctx, const struct SQN_BCCH_Config_v1310* p)
{
	adbgPrintLog(_ctx, "modificationPeriodCoeff_v1310 := %s (%d)", adbgSys__SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e__ToString(p->modificationPeriodCoeff_v1310), (int)p->modificationPeriodCoeff_v1310);
}

static void _adbgSys__SQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional(acpCtx_t _ctx, const struct SQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_BCCH_Config_v1310(_ctx, &p->v);
}

static const char* adbgSys__SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e__ToString(SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e v)
{
	switch(v) {
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r1: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r1";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r2: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r2";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r4: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r4";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r8: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r8";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r16: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r16";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r32: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r32";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r64: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r64";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r128: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r128";
		case SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r256: return "SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r256";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_PCCH_Config_v1310_nB_v1310_e__ToString(SQN_PCCH_Config_v1310_nB_v1310_e v)
{
	switch(v) {
		case SQN_PCCH_Config_v1310_nB_v1310_e_one64thT: return "SQN_PCCH_Config_v1310_nB_v1310_e_one64thT";
		case SQN_PCCH_Config_v1310_nB_v1310_e_one128thT: return "SQN_PCCH_Config_v1310_nB_v1310_e_one128thT";
		case SQN_PCCH_Config_v1310_nB_v1310_e_one256thT: return "SQN_PCCH_Config_v1310_nB_v1310_e_one256thT";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional(acpCtx_t _ctx, const struct SQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PCCH_Config_v1310_nB_v1310_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_PCCH_Config_v1310(acpCtx_t _ctx, const struct SQN_PCCH_Config_v1310* p)
{
	adbgPrintLog(_ctx, "paging_narrowBands_r13 := %u", (unsigned int)p->paging_narrowBands_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_NumRepetition_Paging_r13 := %s (%d)", adbgSys__SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e__ToString(p->mpdcch_NumRepetition_Paging_r13), (int)p->mpdcch_NumRepetition_Paging_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nB_v1310 := ");
	_adbgSys__SQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional(_ctx, &p->nB_v1310);
}

static void _adbgSys__SQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional(acpCtx_t _ctx, const struct SQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PCCH_Config_v1310(_ctx, &p->v);
}

static void _adbgSys__SQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional(acpCtx_t _ctx, const struct SQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_FreqHoppingParameters_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional(acpCtx_t _ctx, const struct SQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PDSCH_ConfigCommon_v1310(_ctx, &p->v);
}

static const char* adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e__ToString(SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e v)
{
	switch(v) {
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r8: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r8";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r16: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r16";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r32: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r32";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e__ToString(SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e v)
{
	switch(v) {
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r192: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r192";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r256: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r256";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r384: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r384";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r512: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r512";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r768: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r768";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r1024: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r1024";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r1536: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r1536";
		case SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r2048: return "SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r2048";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__Uint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_PUSCH_ConfigCommon_v1310(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon_v1310* p)
{
	adbgPrintLog(_ctx, "pusch_maxNumRepetitionCEmodeA_r13 := ");
	_adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional(_ctx, &p->pusch_maxNumRepetitionCEmodeA_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_maxNumRepetitionCEmodeB_r13 := ");
	_adbgSys__SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional(_ctx, &p->pusch_maxNumRepetitionCEmodeB_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_HoppingOffset_v1310 := ");
	_adbgSys__Uint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional(_ctx, &p->pusch_HoppingOffset_v1310);
}

static void _adbgSys__SQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional(acpCtx_t _ctx, const struct SQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PUSCH_ConfigCommon_v1310(_ctx, &p->v);
}

static const char* adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e__ToString(SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e v)
{
	switch(v) {
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1dot5: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1dot5";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2dot5: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2dot5";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v4: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v4";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v5: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v5";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v8: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v8";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v10: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v10";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e__ToString(SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e v)
{
	switch(v) {
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v1: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v1";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v2: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v2";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v4: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v4";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v5: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v5";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v8: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v8";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v10: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v10";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v20: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v20";
		case SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_spare: return "SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_spare";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value(acpCtx_t _ctx, const union SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value* p, enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Sel d)
{
	if (d == SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13) {
		adbgPrintLog(_ctx, "fdd_r13 := %s (%d)", adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e__ToString(p->fdd_r13), (int)p->fdd_r13);
		return;
	}
	if (d == SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13) {
		adbgPrintLog(_ctx, "tdd_r13 := %s (%d)", adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e__ToString(p->tdd_r13), (int)p->tdd_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13(acpCtx_t _ctx, const struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13* p)
{
	_adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional(acpCtx_t _ctx, const struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13(_ctx, &p->v);
}

static void _adbgSys__Uint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e__ToString(SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e v)
{
	switch(v) {
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf2: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf2";
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf4: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf4";
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf8: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf8";
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf16: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf16";
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf32: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf32";
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf64: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf64";
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf128: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf128";
		case SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf256: return "SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf256";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional(acpCtx_t _ctx, const struct SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e__ToString(SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e v)
{
	switch(v) {
		case SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n3: return "SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n3";
		case SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n4: return "SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n4";
		case SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n5: return "SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n5";
		case SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n6: return "SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n6";
		case SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n7: return "SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n7";
		case SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n8: return "SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n8";
		case SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n10: return "SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n10";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional(acpCtx_t _ctx, const struct SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e__ToString(SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e v)
{
	switch(v) {
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n1: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n1";
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n2: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n2";
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n4: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n4";
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n8: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n8";
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n16: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n16";
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n32: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n32";
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n64: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n64";
		case SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n128: return "SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n128";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e__ToString(SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e v)
{
	switch(v) {
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r1: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r1";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r2: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r2";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r4: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r4";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r8: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r8";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r16: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r16";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r32: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r32";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r64: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r64";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r128: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r128";
		case SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r256: return "SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r256";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e__ToString(SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e v)
{
	switch(v) {
		case SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e_on: return "SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e_on";
		case SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e_off: return "SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e_off";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PRACH_ParametersCE_r13(acpCtx_t _ctx, const struct SQN_PRACH_ParametersCE_r13* p)
{
	adbgPrintLog(_ctx, "prach_ConfigIndex_r13 := %u", (unsigned int)p->prach_ConfigIndex_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_FreqOffset_r13 := %u", (unsigned int)p->prach_FreqOffset_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_StartingSubframe_r13 := ");
	_adbgSys__SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional(_ctx, &p->prach_StartingSubframe_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxNumPreambleAttemptCE_r13 := ");
	_adbgSys__SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional(_ctx, &p->maxNumPreambleAttemptCE_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numRepetitionPerPreambleAttempt_r13 := %s (%d)", adbgSys__SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e__ToString(p->numRepetitionPerPreambleAttempt_r13), (int)p->numRepetitionPerPreambleAttempt_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_NarrowbandsToMonitor_r13 := '");
	for (size_t i3 = 0; i3 < p->mpdcch_NarrowbandsToMonitor_r13.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->mpdcch_NarrowbandsToMonitor_r13.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_NumRepetition_RA_r13 := %s (%d)", adbgSys__SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e__ToString(p->mpdcch_NumRepetition_RA_r13), (int)p->mpdcch_NumRepetition_RA_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_HoppingConfig_r13 := %s (%d)", adbgSys__SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e__ToString(p->prach_HoppingConfig_r13), (int)p->prach_HoppingConfig_r13);
}

static void _adbgSys__SQN_PRACH_ConfigSIB_v1310(acpCtx_t _ctx, const struct SQN_PRACH_ConfigSIB_v1310* p)
{
	adbgPrintLog(_ctx, "rsrp_ThresholdsPrachInfoList_r13 := '");
	for (size_t i2 = 0; i2 < p->rsrp_ThresholdsPrachInfoList_r13.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->rsrp_ThresholdsPrachInfoList_r13.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_startSF_CSS_RA_r13 := ");
	if (p->mpdcch_startSF_CSS_RA_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional(_ctx, &p->mpdcch_startSF_CSS_RA_r13);
	if (p->mpdcch_startSF_CSS_RA_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_HoppingOffset_r13 := ");
	_adbgSys__Uint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional(_ctx, &p->prach_HoppingOffset_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ParametersListCE_r13 := { ");
	for (size_t i2 = 0; i2 < p->prach_ParametersListCE_r13.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_PRACH_ParametersCE_r13(_ctx, &p->prach_ParametersListCE_r13.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->prach_ParametersListCE_r13.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional(acpCtx_t _ctx, const struct SQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PRACH_ConfigSIB_v1310(_ctx, &p->v);
}

static void _adbgSys__SQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional(acpCtx_t _ctx, const struct SQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e__ToString(SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e v)
{
	switch(v) {
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n1: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n1";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n2: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n2";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n4: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n4";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n8: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e__ToString(SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e v)
{
	switch(v) {
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n1: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n1";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n2: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n2";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n4: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n4";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n8: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e__ToString(SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e v)
{
	switch(v) {
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n4: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n4";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n8: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n8";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n16: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n16";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n32: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n32";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e__ToString(SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e v)
{
	switch(v) {
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n4: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n4";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n8: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n8";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n16: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n16";
		case SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n32: return "SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n32";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1310(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1310* p)
{
	adbgPrintLog(_ctx, "n1PUCCH_AN_InfoList_r13 := ");
	if (p->n1PUCCH_AN_InfoList_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional(_ctx, &p->n1PUCCH_AN_InfoList_r13);
	if (p->n1PUCCH_AN_InfoList_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_NumRepetitionCE_Msg4_Level0_r13 := ");
	_adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional(_ctx, &p->pucch_NumRepetitionCE_Msg4_Level0_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_NumRepetitionCE_Msg4_Level1_r13 := ");
	_adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional(_ctx, &p->pucch_NumRepetitionCE_Msg4_Level1_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_NumRepetitionCE_Msg4_Level2_r13 := ");
	_adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional(_ctx, &p->pucch_NumRepetitionCE_Msg4_Level2_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_NumRepetitionCE_Msg4_Level3_r13 := ");
	_adbgSys__SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional(_ctx, &p->pucch_NumRepetitionCE_Msg4_Level3_r13);
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PUCCH_ConfigCommon_v1310(_ctx, &p->v);
}

static const char* adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e__ToString(SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e v)
{
	switch(v) {
		case SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_true: return "SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e__ToString(SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e v)
{
	switch(v) {
		case SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_true: return "SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_HighSpeedConfig_r14(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_r14* p)
{
	adbgPrintLog(_ctx, "highSpeedEnhancedMeasFlag_r14 := ");
	_adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional(_ctx, &p->highSpeedEnhancedMeasFlag_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedEnhancedDemodulationFlag_r14 := ");
	_adbgSys__SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional(_ctx, &p->highSpeedEnhancedDemodulationFlag_r14);
}

static void _adbgSys__SQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_HighSpeedConfig_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_PRACH_Config_v1430(acpCtx_t _ctx, const struct SQN_PRACH_Config_v1430* p)
{
	adbgPrintLog(_ctx, "rootSequenceIndexHighSpeed_r14 := %u", (unsigned int)p->rootSequenceIndexHighSpeed_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zeroCorrelationZoneConfigHighSpeed_r14 := %u", (unsigned int)p->zeroCorrelationZoneConfigHighSpeed_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ConfigIndexHighSpeed_r14 := %u", (unsigned int)p->prach_ConfigIndexHighSpeed_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_FreqOffsetHighSpeed_r14 := %u", (unsigned int)p->prach_FreqOffsetHighSpeed_r14);
}

static void _adbgSys__SQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional(acpCtx_t _ctx, const struct SQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PRACH_Config_v1430(_ctx, &p->v);
}

static const char* adbgSys__SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e__ToString(SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e v)
{
	switch(v) {
		case SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_n64: return "SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_n64";
		case SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_n128: return "SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_n128";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1430(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1430* p)
{
	adbgPrintLog(_ctx, "pucch_NumRepetitionCE_Msg4_Level3_r14 := ");
	_adbgSys__SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional(_ctx, &p->pucch_NumRepetitionCE_Msg4_Level3_r14);
}

static void _adbgSys__SQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional(acpCtx_t _ctx, const struct SQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PUCCH_ConfigCommon_v1430(_ctx, &p->v);
}

static const char* adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e__ToString(SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e v)
{
	switch(v) {
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf2: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf2";
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf4: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf4";
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf8: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf8";
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf16: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf16";
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf32: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf32";
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf64: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf64";
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf128: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf128";
		case SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf256: return "SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf256";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional(acpCtx_t _ctx, const struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15(acpCtx_t _ctx, const struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15* p)
{
	adbgPrintLog(_ctx, "prach_ConfigIndex_r15 := %u", (unsigned int)p->prach_ConfigIndex_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_FreqOffset_r15 := %u", (unsigned int)p->prach_FreqOffset_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_StartingSubframe_r15 := ");
	_adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional(_ctx, &p->prach_StartingSubframe_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_NarrowbandsToMonitor_r15 := '");
	for (size_t i3 = 0; i3 < p->mpdcch_NarrowbandsToMonitor_r15.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->mpdcch_NarrowbandsToMonitor_r15.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional(acpCtx_t _ctx, const struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_EDT_PRACH_ParametersCE_r15(acpCtx_t _ctx, const struct SQN_EDT_PRACH_ParametersCE_r15* p)
{
	adbgPrintLog(_ctx, "edt_PRACH_ParametersCE_r15 := ");
	if (p->edt_PRACH_ParametersCE_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional(_ctx, &p->edt_PRACH_ParametersCE_r15);
	if (p->edt_PRACH_ParametersCE_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_PRACH_ConfigSIB_v1530(acpCtx_t _ctx, const struct SQN_PRACH_ConfigSIB_v1530* p)
{
	adbgPrintLog(_ctx, "edt_PRACH_ParametersListCE_r15 := { ");
	for (size_t i2 = 0; i2 < p->edt_PRACH_ParametersListCE_r15.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_EDT_PRACH_ParametersCE_r15(_ctx, &p->edt_PRACH_ParametersListCE_r15.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->edt_PRACH_ParametersListCE_r15.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional(acpCtx_t _ctx, const struct SQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PRACH_ConfigSIB_v1530(_ctx, &p->v);
}

static const char* adbgSys__SQN_RSS_Config_r15_duration_r15_e__ToString(SQN_RSS_Config_r15_duration_r15_e v)
{
	switch(v) {
		case SQN_RSS_Config_r15_duration_r15_e_sf8: return "SQN_RSS_Config_r15_duration_r15_e_sf8";
		case SQN_RSS_Config_r15_duration_r15_e_sf16: return "SQN_RSS_Config_r15_duration_r15_e_sf16";
		case SQN_RSS_Config_r15_duration_r15_e_sf32: return "SQN_RSS_Config_r15_duration_r15_e_sf32";
		case SQN_RSS_Config_r15_duration_r15_e_sf40: return "SQN_RSS_Config_r15_duration_r15_e_sf40";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RSS_Config_r15_periodicity_r15_e__ToString(SQN_RSS_Config_r15_periodicity_r15_e v)
{
	switch(v) {
		case SQN_RSS_Config_r15_periodicity_r15_e_ms160: return "SQN_RSS_Config_r15_periodicity_r15_e_ms160";
		case SQN_RSS_Config_r15_periodicity_r15_e_ms320: return "SQN_RSS_Config_r15_periodicity_r15_e_ms320";
		case SQN_RSS_Config_r15_periodicity_r15_e_ms640: return "SQN_RSS_Config_r15_periodicity_r15_e_ms640";
		case SQN_RSS_Config_r15_periodicity_r15_e_ms1280: return "SQN_RSS_Config_r15_periodicity_r15_e_ms1280";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RSS_Config_r15_powerBoost_r15_e__ToString(SQN_RSS_Config_r15_powerBoost_r15_e v)
{
	switch(v) {
		case SQN_RSS_Config_r15_powerBoost_r15_e_dB0: return "SQN_RSS_Config_r15_powerBoost_r15_e_dB0";
		case SQN_RSS_Config_r15_powerBoost_r15_e_dB3: return "SQN_RSS_Config_r15_powerBoost_r15_e_dB3";
		case SQN_RSS_Config_r15_powerBoost_r15_e_dB4dot8: return "SQN_RSS_Config_r15_powerBoost_r15_e_dB4dot8";
		case SQN_RSS_Config_r15_powerBoost_r15_e_dB6: return "SQN_RSS_Config_r15_powerBoost_r15_e_dB6";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RSS_Config_r15(acpCtx_t _ctx, const struct SQN_RSS_Config_r15* p)
{
	adbgPrintLog(_ctx, "duration_r15 := %s (%d)", adbgSys__SQN_RSS_Config_r15_duration_r15_e__ToString(p->duration_r15), (int)p->duration_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqLocation_r15 := %u", (unsigned int)p->freqLocation_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicity_r15 := %s (%d)", adbgSys__SQN_RSS_Config_r15_periodicity_r15_e__ToString(p->periodicity_r15), (int)p->periodicity_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "powerBoost_r15 := %s (%d)", adbgSys__SQN_RSS_Config_r15_powerBoost_r15_e__ToString(p->powerBoost_r15), (int)p->powerBoost_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffset_r15 := %u", (unsigned int)p->timeOffset_r15);
}

static void _adbgSys__SQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional(acpCtx_t _ctx, const struct SQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RSS_Config_r15(_ctx, &p->v);
}

static const char* adbgSys__SQN_WUS_Config_r15_maxDurationFactor_r15_e__ToString(SQN_WUS_Config_r15_maxDurationFactor_r15_e v)
{
	switch(v) {
		case SQN_WUS_Config_r15_maxDurationFactor_r15_e_one32th: return "SQN_WUS_Config_r15_maxDurationFactor_r15_e_one32th";
		case SQN_WUS_Config_r15_maxDurationFactor_r15_e_one16th: return "SQN_WUS_Config_r15_maxDurationFactor_r15_e_one16th";
		case SQN_WUS_Config_r15_maxDurationFactor_r15_e_one8th: return "SQN_WUS_Config_r15_maxDurationFactor_r15_e_one8th";
		case SQN_WUS_Config_r15_maxDurationFactor_r15_e_one4th: return "SQN_WUS_Config_r15_maxDurationFactor_r15_e_one4th";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_WUS_Config_r15_numPOs_r15_e__ToString(SQN_WUS_Config_r15_numPOs_r15_e v)
{
	switch(v) {
		case SQN_WUS_Config_r15_numPOs_r15_e_n1: return "SQN_WUS_Config_r15_numPOs_r15_e_n1";
		case SQN_WUS_Config_r15_numPOs_r15_e_n2: return "SQN_WUS_Config_r15_numPOs_r15_e_n2";
		case SQN_WUS_Config_r15_numPOs_r15_e_n4: return "SQN_WUS_Config_r15_numPOs_r15_e_n4";
		case SQN_WUS_Config_r15_numPOs_r15_e_spare1: return "SQN_WUS_Config_r15_numPOs_r15_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional(acpCtx_t _ctx, const struct SQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_WUS_Config_r15_numPOs_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_WUS_Config_r15_freqLocation_r15_e__ToString(SQN_WUS_Config_r15_freqLocation_r15_e v)
{
	switch(v) {
		case SQN_WUS_Config_r15_freqLocation_r15_e_n0: return "SQN_WUS_Config_r15_freqLocation_r15_e_n0";
		case SQN_WUS_Config_r15_freqLocation_r15_e_n2: return "SQN_WUS_Config_r15_freqLocation_r15_e_n2";
		case SQN_WUS_Config_r15_freqLocation_r15_e_n4: return "SQN_WUS_Config_r15_freqLocation_r15_e_n4";
		case SQN_WUS_Config_r15_freqLocation_r15_e_spare1: return "SQN_WUS_Config_r15_freqLocation_r15_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_WUS_Config_r15_timeOffsetDRX_r15_e__ToString(SQN_WUS_Config_r15_timeOffsetDRX_r15_e v)
{
	switch(v) {
		case SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms40: return "SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms40";
		case SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms80: return "SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms80";
		case SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms160: return "SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms160";
		case SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms240: return "SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms240";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e__ToString(SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e v)
{
	switch(v) {
		case SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms40: return "SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms40";
		case SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms80: return "SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms80";
		case SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms160: return "SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms160";
		case SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms240: return "SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms240";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e__ToString(SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e v)
{
	switch(v) {
		case SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_ms1000: return "SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_ms1000";
		case SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_ms2000: return "SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_ms2000";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional(acpCtx_t _ctx, const struct SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_WUS_Config_r15(acpCtx_t _ctx, const struct SQN_WUS_Config_r15* p)
{
	adbgPrintLog(_ctx, "maxDurationFactor_r15 := %s (%d)", adbgSys__SQN_WUS_Config_r15_maxDurationFactor_r15_e__ToString(p->maxDurationFactor_r15), (int)p->maxDurationFactor_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numPOs_r15 := ");
	_adbgSys__SQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional(_ctx, &p->numPOs_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqLocation_r15 := %s (%d)", adbgSys__SQN_WUS_Config_r15_freqLocation_r15_e__ToString(p->freqLocation_r15), (int)p->freqLocation_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffsetDRX_r15 := %s (%d)", adbgSys__SQN_WUS_Config_r15_timeOffsetDRX_r15_e__ToString(p->timeOffsetDRX_r15), (int)p->timeOffsetDRX_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffset_eDRX_Short_r15 := %s (%d)", adbgSys__SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e__ToString(p->timeOffset_eDRX_Short_r15), (int)p->timeOffset_eDRX_Short_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffset_eDRX_Long_r15 := ");
	_adbgSys__SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional(_ctx, &p->timeOffset_eDRX_Long_r15);
}

static void _adbgSys__SQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional(acpCtx_t _ctx, const struct SQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WUS_Config_r15(_ctx, &p->v);
}

static const char* adbgSys__SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e__ToString(SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e v)
{
	switch(v) {
		case SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e_true: return "SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_HighSpeedConfig_v1530(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_v1530* p)
{
	adbgPrintLog(_ctx, "highSpeedMeasGapCE_ModeA_r15 := %s (%d)", adbgSys__SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e__ToString(p->highSpeedMeasGapCE_ModeA_r15), (int)p->highSpeedMeasGapCE_ModeA_r15);
}

static void _adbgSys__SQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_HighSpeedConfig_v1530(_ctx, &p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_1: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_1";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF0: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF0";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF1: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF1";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF2: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF2";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF3: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF3";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF4: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF4";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF5: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF5";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF6: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF6";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF1: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF1";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF2: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF2";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF3: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF3";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF4: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF4";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF5: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF5";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF6: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF6";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF7: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF7";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF8: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF3: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF3";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF4: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF4";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF5: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF5";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF6: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF6";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF7: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF7";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF8: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF8";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF9: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF9";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF10: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF10";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF4: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF4";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF5: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF5";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF6: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF6";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF7: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF7";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF8: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF8";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF9: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF9";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF10: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF10";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF11: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF11";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF13: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF13";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF14: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF14";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF15: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF15";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF16: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF16";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF17: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF17";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF18: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF18";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF19: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF19";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF20: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF20";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF10: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF10";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF11: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF11";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF12: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF12";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF13: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF13";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF14: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF14";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF15: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF15";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF16: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF16";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF17: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF17";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF5: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF5";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF6: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF6";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF7: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF7";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF8: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF8";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF9: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF9";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF10: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF10";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF11: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF11";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF12: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF12";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF6: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF6";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF7: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF7";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF8: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF8";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF9: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF9";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF10: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF10";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF11: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF11";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF12: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF12";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF13: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF13";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF15: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF15";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF16: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF16";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF17: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF17";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF18: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF18";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF19: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF19";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF20: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF20";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF21: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF21";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF22: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF22";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e__ToString(SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e v)
{
	switch(v) {
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF10: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF10";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF11: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF11";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF12: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF12";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF13: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF13";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF14: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF14";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF15: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF15";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF16: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF16";
		case SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF17: return "SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF17";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_setup(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15_setup* p)
{
	adbgPrintLog(_ctx, "deltaF_slotSPUCCH_Format1_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional(_ctx, &p->deltaF_slotSPUCCH_Format1_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_slotSPUCCH_Format1a_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional(_ctx, &p->deltaF_slotSPUCCH_Format1a_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_slotSPUCCH_Format1b_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional(_ctx, &p->deltaF_slotSPUCCH_Format1b_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_slotSPUCCH_Format3_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional(_ctx, &p->deltaF_slotSPUCCH_Format3_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_slotSPUCCH_RM_Format4_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional(_ctx, &p->deltaF_slotSPUCCH_RM_Format4_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_slotSPUCCH_TBCC_Format4_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional(_ctx, &p->deltaF_slotSPUCCH_TBCC_Format4_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_subslotSPUCCH_Format1and1a_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional(_ctx, &p->deltaF_subslotSPUCCH_Format1and1a_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_subslotSPUCCH_Format1b_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional(_ctx, &p->deltaF_subslotSPUCCH_Format1b_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_subslotSPUCCH_RM_Format4_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional(_ctx, &p->deltaF_subslotSPUCCH_RM_Format4_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_subslotSPUCCH_TBCC_Format4_r15 := ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional(_ctx, &p->deltaF_subslotSPUCCH_TBCC_Format4_r15);
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15_Value(acpCtx_t _ctx, const union SQN_DeltaFList_SPUCCH_r15_Value* p, enum SQN_DeltaFList_SPUCCH_r15_Sel d)
{
	if (d == SQN_DeltaFList_SPUCCH_r15_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_DeltaFList_SPUCCH_r15_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_DeltaFList_SPUCCH_r15_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_DeltaFList_SPUCCH_r15(acpCtx_t _ctx, const struct SQN_DeltaFList_SPUCCH_r15* p)
{
	_adbgSys__SQN_DeltaFList_SPUCCH_r15_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_UplinkPowerControlCommon_v1530(acpCtx_t _ctx, const struct SQN_UplinkPowerControlCommon_v1530* p)
{
	adbgPrintLog(_ctx, "deltaFList_SPUCCH_r15 := { ");
	_adbgSys__SQN_DeltaFList_SPUCCH_r15(_ctx, &p->deltaFList_SPUCCH_r15);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional(acpCtx_t _ctx, const struct SQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_UplinkPowerControlCommon_v1530(_ctx, &p->v);
}

static const char* adbgSys__SQN_WUS_Config_v1560_powerBoost_r15_e__ToString(SQN_WUS_Config_v1560_powerBoost_r15_e v)
{
	switch(v) {
		case SQN_WUS_Config_v1560_powerBoost_r15_e_dB0: return "SQN_WUS_Config_v1560_powerBoost_r15_e_dB0";
		case SQN_WUS_Config_v1560_powerBoost_r15_e_dB1dot8: return "SQN_WUS_Config_v1560_powerBoost_r15_e_dB1dot8";
		case SQN_WUS_Config_v1560_powerBoost_r15_e_dB3: return "SQN_WUS_Config_v1560_powerBoost_r15_e_dB3";
		case SQN_WUS_Config_v1560_powerBoost_r15_e_dB4dot8: return "SQN_WUS_Config_v1560_powerBoost_r15_e_dB4dot8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_WUS_Config_v1560(acpCtx_t _ctx, const struct SQN_WUS_Config_v1560* p)
{
	adbgPrintLog(_ctx, "powerBoost_r15 := %s (%d)", adbgSys__SQN_WUS_Config_v1560_powerBoost_r15_e__ToString(p->powerBoost_r15), (int)p->powerBoost_r15);
}

static void _adbgSys__SQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional(acpCtx_t _ctx, const struct SQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WUS_Config_v1560(_ctx, &p->v);
}

static const char* adbgSys__SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e__ToString(SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e v)
{
	switch(v) {
		case SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n1: return "SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n1";
		case SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n2: return "SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n2";
		case SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n4: return "SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n4";
		case SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n8: return "SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_WUS_Config_v1610(acpCtx_t _ctx, const struct SQN_WUS_Config_v1610* p)
{
	adbgPrintLog(_ctx, "numDRX_CyclesRelaxed_r16 := %s (%d)", adbgSys__SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e__ToString(p->numDRX_CyclesRelaxed_r16), (int)p->numDRX_CyclesRelaxed_r16);
}

static void _adbgSys__SQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional(acpCtx_t _ctx, const struct SQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WUS_Config_v1610(_ctx, &p->v);
}

static const char* adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e__ToString(SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e v)
{
	switch(v) {
		case SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_true: return "SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e__ToString(SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e v)
{
	switch(v) {
		case SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_true: return "SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_HighSpeedConfig_v1610(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_v1610* p)
{
	adbgPrintLog(_ctx, "highSpeedEnhMeasFlag2_r16 := ");
	_adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional(_ctx, &p->highSpeedEnhMeasFlag2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedEnhDemodFlag2_r16 := ");
	_adbgSys__SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional(_ctx, &p->highSpeedEnhDemodFlag2_r16);
}

static void _adbgSys__SQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional(acpCtx_t _ctx, const struct SQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_HighSpeedConfig_v1610(_ctx, &p->v);
}

static const char* adbgSys__SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e__ToString(SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e v)
{
	switch(v) {
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_4dot77: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_4dot77";
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_3: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_3";
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_1dot77: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_1dot77";
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB0: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB0";
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB1: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB1";
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB2: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB2";
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB3: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB3";
		case SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB4dot77: return "SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB4dot77";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CRS_ChEstMPDCCH_ConfigCommon_r16(acpCtx_t _ctx, const struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16* p)
{
	adbgPrintLog(_ctx, "powerRatio_r16 := %s (%d)", adbgSys__SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e__ToString(p->powerRatio_r16), (int)p->powerRatio_r16);
}

static void _adbgSys__SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional(acpCtx_t _ctx, const struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CRS_ChEstMPDCCH_ConfigCommon_r16(_ctx, &p->v);
}

static const char* adbgSys__SQN_GWUS_Config_r16_groupAlternation_r16_e__ToString(SQN_GWUS_Config_r16_groupAlternation_r16_e v)
{
	switch(v) {
		case SQN_GWUS_Config_r16_groupAlternation_r16_e_true: return "SQN_GWUS_Config_r16_groupAlternation_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_Config_r16_groupAlternation_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_GWUS_Config_r16_commonSequence_r16_e__ToString(SQN_GWUS_Config_r16_commonSequence_r16_e v)
{
	switch(v) {
		case SQN_GWUS_Config_r16_commonSequence_r16_e_g0: return "SQN_GWUS_Config_r16_commonSequence_r16_e_g0";
		case SQN_GWUS_Config_r16_commonSequence_r16_e_g126: return "SQN_GWUS_Config_r16_commonSequence_r16_e_g126";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_Config_r16_commonSequence_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e__ToString(SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e v)
{
	switch(v) {
		case SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one32th: return "SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one32th";
		case SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one16th: return "SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one16th";
		case SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one8th: return "SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one8th";
		case SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one4th: return "SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one4th";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_GWUS_TimeParameters_r16_numPOs_r16_e__ToString(SQN_GWUS_TimeParameters_r16_numPOs_r16_e v)
{
	switch(v) {
		case SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n1: return "SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n1";
		case SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n2: return "SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n2";
		case SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n4: return "SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n4";
		case SQN_GWUS_TimeParameters_r16_numPOs_r16_e_spare1: return "SQN_GWUS_TimeParameters_r16_numPOs_r16_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_TimeParameters_r16_numPOs_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e__ToString(SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e v)
{
	switch(v) {
		case SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms40: return "SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms40";
		case SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms80: return "SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms80";
		case SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms160: return "SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms160";
		case SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms240: return "SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms240";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e__ToString(SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e v)
{
	switch(v) {
		case SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms40: return "SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms40";
		case SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms80: return "SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms80";
		case SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms160: return "SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms160";
		case SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms240: return "SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms240";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e__ToString(SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e v)
{
	switch(v) {
		case SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_ms1000: return "SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_ms1000";
		case SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_ms2000: return "SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_ms2000";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e__ToString(SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e v)
{
	switch(v) {
		case SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n1: return "SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n1";
		case SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n2: return "SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n2";
		case SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n4: return "SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n4";
		case SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n8: return "SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_GWUS_TimeParameters_r16_powerBoost_r16_e__ToString(SQN_GWUS_TimeParameters_r16_powerBoost_r16_e v)
{
	switch(v) {
		case SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB0: return "SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB0";
		case SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB1dot8: return "SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB1dot8";
		case SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB3: return "SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB3";
		case SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB4dot8: return "SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB4dot8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_TimeParameters_r16_powerBoost_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_GWUS_TimeParameters_r16(acpCtx_t _ctx, const struct SQN_GWUS_TimeParameters_r16* p)
{
	adbgPrintLog(_ctx, "maxDurationFactor_r16 := %s (%d)", adbgSys__SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e__ToString(p->maxDurationFactor_r16), (int)p->maxDurationFactor_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numPOs_r16 := ");
	_adbgSys__SQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional(_ctx, &p->numPOs_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffsetDRX_r16 := %s (%d)", adbgSys__SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e__ToString(p->timeOffsetDRX_r16), (int)p->timeOffsetDRX_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffset_eDRX_Short_r16 := %s (%d)", adbgSys__SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e__ToString(p->timeOffset_eDRX_Short_r16), (int)p->timeOffset_eDRX_Short_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffset_eDRX_Long_r16 := ");
	_adbgSys__SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional(_ctx, &p->timeOffset_eDRX_Long_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numDRX_CyclesRelaxed_r16 := ");
	_adbgSys__SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional(_ctx, &p->numDRX_CyclesRelaxed_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "powerBoost_r16 := ");
	_adbgSys__SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional(_ctx, &p->powerBoost_r16);
}

static void _adbgSys__SQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_GWUS_TimeParameters_r16(_ctx, &p->v);
}

static const char* adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e__ToString(SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e v)
{
	switch(v) {
		case SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_primary: return "SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_primary";
		case SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_secondary: return "SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_secondary";
		case SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_primary3FDM: return "SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_primary3FDM";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e__ToString(SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e v)
{
	switch(v) {
		case SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e_n0: return "SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e_n0";
		case SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e_n2: return "SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e_n2";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value(acpCtx_t _ctx, const union SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value* p, enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Sel d)
{
	if (d == SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS) {
		adbgPrintLog(_ctx, "resourceLocationWithWUS := %s (%d)", adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e__ToString(p->resourceLocationWithWUS), (int)p->resourceLocationWithWUS);
		return;
	}
	if (d == SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS) {
		adbgPrintLog(_ctx, "resourceLocationWithoutWUS := %s (%d)", adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e__ToString(p->resourceLocationWithoutWUS), (int)p->resourceLocationWithoutWUS);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16(acpCtx_t _ctx, const struct SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16* p)
{
	_adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value(_ctx, &p->v, p->d);
}

static const char* adbgSys__SQN_GWUS_NumGroups_r16_e__ToString(SQN_GWUS_NumGroups_r16_e v)
{
	switch(v) {
		case SQN_GWUS_NumGroups_r16_e_n1: return "SQN_GWUS_NumGroups_r16_e_n1";
		case SQN_GWUS_NumGroups_r16_e_n2: return "SQN_GWUS_NumGroups_r16_e_n2";
		case SQN_GWUS_NumGroups_r16_e_n4: return "SQN_GWUS_NumGroups_r16_e_n4";
		case SQN_GWUS_NumGroups_r16_e_n8: return "SQN_GWUS_NumGroups_r16_e_n8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_NumGroups_r16_e__ToString(p->v.v[i2]), (int)p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_GWUS_ResourceConfig_r16(acpCtx_t _ctx, const struct SQN_GWUS_ResourceConfig_r16* p)
{
	adbgPrintLog(_ctx, "resourceMappingPattern_r16 := { ");
	_adbgSys__SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16(_ctx, &p->resourceMappingPattern_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numGroupsList_r16 := ");
	if (p->numGroupsList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional(_ctx, &p->numGroupsList_r16);
	if (p->numGroupsList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "groupsForServiceList_r16 := ");
	if (p->groupsForServiceList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional(_ctx, &p->groupsForServiceList_r16);
	if (p->groupsForServiceList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_GWUS_ResourceConfig_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_GWUS_ResourceConfig_r16(_ctx, &p->v);
}

static const char* adbgSys__SQN_GWUS_PagingProbThresh_r16_e__ToString(SQN_GWUS_PagingProbThresh_r16_e v)
{
	switch(v) {
		case SQN_GWUS_PagingProbThresh_r16_e_p20: return "SQN_GWUS_PagingProbThresh_r16_e_p20";
		case SQN_GWUS_PagingProbThresh_r16_e_p30: return "SQN_GWUS_PagingProbThresh_r16_e_p30";
		case SQN_GWUS_PagingProbThresh_r16_e_p40: return "SQN_GWUS_PagingProbThresh_r16_e_p40";
		case SQN_GWUS_PagingProbThresh_r16_e_p50: return "SQN_GWUS_PagingProbThresh_r16_e_p50";
		case SQN_GWUS_PagingProbThresh_r16_e_p60: return "SQN_GWUS_PagingProbThresh_r16_e_p60";
		case SQN_GWUS_PagingProbThresh_r16_e_p70: return "SQN_GWUS_PagingProbThresh_r16_e_p70";
		case SQN_GWUS_PagingProbThresh_r16_e_p80: return "SQN_GWUS_PagingProbThresh_r16_e_p80";
		case SQN_GWUS_PagingProbThresh_r16_e_p90: return "SQN_GWUS_PagingProbThresh_r16_e_p90";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_GWUS_PagingProbThresh_r16_e__ToString(p->v.v[i2]), (int)p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_GWUS_Config_r16(acpCtx_t _ctx, const struct SQN_GWUS_Config_r16* p)
{
	adbgPrintLog(_ctx, "groupAlternation_r16 := ");
	_adbgSys__SQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional(_ctx, &p->groupAlternation_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commonSequence_r16 := ");
	_adbgSys__SQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional(_ctx, &p->commonSequence_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeParameters_r16 := ");
	if (p->timeParameters_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional(_ctx, &p->timeParameters_r16);
	if (p->timeParameters_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceConfigDRX_r16 := { ");
	_adbgSys__SQN_GWUS_ResourceConfig_r16(_ctx, &p->resourceConfigDRX_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceConfig_eDRX_Short_r16 := ");
	if (p->resourceConfig_eDRX_Short_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional(_ctx, &p->resourceConfig_eDRX_Short_r16);
	if (p->resourceConfig_eDRX_Short_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceConfig_eDRX_Long_r16 := ");
	if (p->resourceConfig_eDRX_Long_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional(_ctx, &p->resourceConfig_eDRX_Long_r16);
	if (p->resourceConfig_eDRX_Long_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "probThreshList_r16 := ");
	if (p->probThreshList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional(_ctx, &p->probThreshList_r16);
	if (p->probThreshList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "groupNarrowBandList_r16 := ");
	if (p->groupNarrowBandList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional(_ctx, &p->groupNarrowBandList_r16);
	if (p->groupNarrowBandList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional(acpCtx_t _ctx, const struct SQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_GWUS_Config_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_UplinkPowerControlCommon_v1610(acpCtx_t _ctx, const struct SQN_UplinkPowerControlCommon_v1610* p)
{
	adbgPrintLog(_ctx, "alphaSRS_Add_r16 := %s (%d)", adbgSys__SQN_Alpha_r12_e__ToString(p->alphaSRS_Add_r16), (int)p->alphaSRS_Add_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_NominalSRS_Add_r16 := %d", (int)p->p0_NominalSRS_Add_r16);
}

static void _adbgSys__SQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional(acpCtx_t _ctx, const struct SQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_UplinkPowerControlCommon_v1610(_ctx, &p->v);
}

static const char* adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e__ToString(SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e v)
{
	switch(v) {
		case SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_enabled: return "SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional(acpCtx_t _ctx, const struct SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e__ToString(SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e v)
{
	switch(v) {
		case SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_enabled: return "SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional(acpCtx_t _ctx, const struct SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__B2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional(acpCtx_t _ctx, const struct B2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__Bool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional(acpCtx_t _ctx, const struct bool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static void _adbgSys__SQN_RadioResourceConfigCommonSIB(acpCtx_t _ctx, const struct SQN_RadioResourceConfigCommonSIB* p)
{
	adbgPrintLog(_ctx, "rach_ConfigCommon := { ");
	_adbgSys__SQN_RACH_ConfigCommon(_ctx, &p->rach_ConfigCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bcch_Config := { ");
	_adbgSys__SQN_BCCH_Config(_ctx, &p->bcch_Config);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pcch_Config := { ");
	_adbgSys__SQN_PCCH_Config(_ctx, &p->pcch_Config);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_Config := { ");
	_adbgSys__SQN_PRACH_ConfigSIB(_ctx, &p->prach_Config);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_ConfigCommon := { ");
	_adbgSys__SQN_PDSCH_ConfigCommon(_ctx, &p->pdsch_ConfigCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_ConfigCommon := { ");
	_adbgSys__SQN_PUSCH_ConfigCommon(_ctx, &p->pusch_ConfigCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_ConfigCommon := { ");
	_adbgSys__SQN_PUCCH_ConfigCommon(_ctx, &p->pucch_ConfigCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "soundingRS_UL_ConfigCommon := { ");
	_adbgSys__SQN_SoundingRS_UL_ConfigCommon(_ctx, &p->soundingRS_UL_ConfigCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uplinkPowerControlCommon := { ");
	_adbgSys__SQN_UplinkPowerControlCommon(_ctx, &p->uplinkPowerControlCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ul_CyclicPrefixLength := %s (%d)", adbgSys__SQN_UL_CyclicPrefixLength_e__ToString(p->ul_CyclicPrefixLength), (int)p->ul_CyclicPrefixLength);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uplinkPowerControlCommon_v1020 := ");
	if (p->uplinkPowerControlCommon_v1020.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional(_ctx, &p->uplinkPowerControlCommon_v1020);
	if (p->uplinkPowerControlCommon_v1020.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rach_ConfigCommon_v1250 := ");
	if (p->rach_ConfigCommon_v1250.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional(_ctx, &p->rach_ConfigCommon_v1250);
	if (p->rach_ConfigCommon_v1250.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_ConfigCommon_v1270 := ");
	if (p->pusch_ConfigCommon_v1270.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional(_ctx, &p->pusch_ConfigCommon_v1270);
	if (p->pusch_ConfigCommon_v1270.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bcch_Config_v1310 := ");
	if (p->bcch_Config_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional(_ctx, &p->bcch_Config_v1310);
	if (p->bcch_Config_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pcch_Config_v1310 := ");
	if (p->pcch_Config_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional(_ctx, &p->pcch_Config_v1310);
	if (p->pcch_Config_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqHoppingParameters_r13 := ");
	if (p->freqHoppingParameters_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional(_ctx, &p->freqHoppingParameters_r13);
	if (p->freqHoppingParameters_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_ConfigCommon_v1310 := ");
	if (p->pdsch_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional(_ctx, &p->pdsch_ConfigCommon_v1310);
	if (p->pdsch_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_ConfigCommon_v1310 := ");
	if (p->pusch_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional(_ctx, &p->pusch_ConfigCommon_v1310);
	if (p->pusch_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ConfigCommon_v1310 := ");
	if (p->prach_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional(_ctx, &p->prach_ConfigCommon_v1310);
	if (p->prach_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_ConfigCommon_v1310 := ");
	if (p->pucch_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional(_ctx, &p->pucch_ConfigCommon_v1310);
	if (p->pucch_ConfigCommon_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedConfig_r14 := ");
	if (p->highSpeedConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional(_ctx, &p->highSpeedConfig_r14);
	if (p->highSpeedConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_Config_v1430 := ");
	if (p->prach_Config_v1430.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional(_ctx, &p->prach_Config_v1430);
	if (p->prach_Config_v1430.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_ConfigCommon_v1430 := ");
	if (p->pucch_ConfigCommon_v1430.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional(_ctx, &p->pucch_ConfigCommon_v1430);
	if (p->pucch_ConfigCommon_v1430.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_Config_v1530 := ");
	if (p->prach_Config_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional(_ctx, &p->prach_Config_v1530);
	if (p->prach_Config_v1530.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ce_RSS_Config_r15 := ");
	if (p->ce_RSS_Config_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional(_ctx, &p->ce_RSS_Config_r15);
	if (p->ce_RSS_Config_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "wus_Config_r15 := ");
	if (p->wus_Config_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional(_ctx, &p->wus_Config_r15);
	if (p->wus_Config_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedConfig_v1530 := ");
	if (p->highSpeedConfig_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional(_ctx, &p->highSpeedConfig_v1530);
	if (p->highSpeedConfig_v1530.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uplinkPowerControlCommon_v1540 := ");
	if (p->uplinkPowerControlCommon_v1540.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional(_ctx, &p->uplinkPowerControlCommon_v1540);
	if (p->uplinkPowerControlCommon_v1540.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "wus_Config_v1560 := ");
	if (p->wus_Config_v1560.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional(_ctx, &p->wus_Config_v1560);
	if (p->wus_Config_v1560.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "wus_Config_v1610 := ");
	if (p->wus_Config_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional(_ctx, &p->wus_Config_v1610);
	if (p->wus_Config_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedConfig_v1610 := ");
	if (p->highSpeedConfig_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional(_ctx, &p->highSpeedConfig_v1610);
	if (p->highSpeedConfig_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "crs_ChEstMPDCCH_ConfigCommon_r16 := ");
	if (p->crs_ChEstMPDCCH_ConfigCommon_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional(_ctx, &p->crs_ChEstMPDCCH_ConfigCommon_r16);
	if (p->crs_ChEstMPDCCH_ConfigCommon_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "gwus_Config_r16 := ");
	if (p->gwus_Config_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional(_ctx, &p->gwus_Config_r16);
	if (p->gwus_Config_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uplinkPowerControlCommon_v1610 := ");
	if (p->uplinkPowerControlCommon_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional(_ctx, &p->uplinkPowerControlCommon_v1610);
	if (p->uplinkPowerControlCommon_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rss_MeasConfig_r16 := ");
	_adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional(_ctx, &p->rss_MeasConfig_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rss_MeasNonNCL_r16 := ");
	_adbgSys__SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional(_ctx, &p->rss_MeasNonNCL_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "puncturedSubcarriersDL_r16 := ");
	_adbgSys__B2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional(_ctx, &p->puncturedSubcarriersDL_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedInterRAT_NR_r16 := ");
	_adbgSys__Bool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional(_ctx, &p->highSpeedInterRAT_NR_r16);
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t300_e__ToString(SQN_UE_TimersAndConstants_t300_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t300_e_ms100: return "SQN_UE_TimersAndConstants_t300_e_ms100";
		case SQN_UE_TimersAndConstants_t300_e_ms200: return "SQN_UE_TimersAndConstants_t300_e_ms200";
		case SQN_UE_TimersAndConstants_t300_e_ms300: return "SQN_UE_TimersAndConstants_t300_e_ms300";
		case SQN_UE_TimersAndConstants_t300_e_ms400: return "SQN_UE_TimersAndConstants_t300_e_ms400";
		case SQN_UE_TimersAndConstants_t300_e_ms600: return "SQN_UE_TimersAndConstants_t300_e_ms600";
		case SQN_UE_TimersAndConstants_t300_e_ms1000: return "SQN_UE_TimersAndConstants_t300_e_ms1000";
		case SQN_UE_TimersAndConstants_t300_e_ms1500: return "SQN_UE_TimersAndConstants_t300_e_ms1500";
		case SQN_UE_TimersAndConstants_t300_e_ms2000: return "SQN_UE_TimersAndConstants_t300_e_ms2000";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t301_e__ToString(SQN_UE_TimersAndConstants_t301_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t301_e_ms100: return "SQN_UE_TimersAndConstants_t301_e_ms100";
		case SQN_UE_TimersAndConstants_t301_e_ms200: return "SQN_UE_TimersAndConstants_t301_e_ms200";
		case SQN_UE_TimersAndConstants_t301_e_ms300: return "SQN_UE_TimersAndConstants_t301_e_ms300";
		case SQN_UE_TimersAndConstants_t301_e_ms400: return "SQN_UE_TimersAndConstants_t301_e_ms400";
		case SQN_UE_TimersAndConstants_t301_e_ms600: return "SQN_UE_TimersAndConstants_t301_e_ms600";
		case SQN_UE_TimersAndConstants_t301_e_ms1000: return "SQN_UE_TimersAndConstants_t301_e_ms1000";
		case SQN_UE_TimersAndConstants_t301_e_ms1500: return "SQN_UE_TimersAndConstants_t301_e_ms1500";
		case SQN_UE_TimersAndConstants_t301_e_ms2000: return "SQN_UE_TimersAndConstants_t301_e_ms2000";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t310_e__ToString(SQN_UE_TimersAndConstants_t310_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t310_e_ms0: return "SQN_UE_TimersAndConstants_t310_e_ms0";
		case SQN_UE_TimersAndConstants_t310_e_ms50: return "SQN_UE_TimersAndConstants_t310_e_ms50";
		case SQN_UE_TimersAndConstants_t310_e_ms100: return "SQN_UE_TimersAndConstants_t310_e_ms100";
		case SQN_UE_TimersAndConstants_t310_e_ms200: return "SQN_UE_TimersAndConstants_t310_e_ms200";
		case SQN_UE_TimersAndConstants_t310_e_ms500: return "SQN_UE_TimersAndConstants_t310_e_ms500";
		case SQN_UE_TimersAndConstants_t310_e_ms1000: return "SQN_UE_TimersAndConstants_t310_e_ms1000";
		case SQN_UE_TimersAndConstants_t310_e_ms2000: return "SQN_UE_TimersAndConstants_t310_e_ms2000";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UE_TimersAndConstants_n310_e__ToString(SQN_UE_TimersAndConstants_n310_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_n310_e_n1: return "SQN_UE_TimersAndConstants_n310_e_n1";
		case SQN_UE_TimersAndConstants_n310_e_n2: return "SQN_UE_TimersAndConstants_n310_e_n2";
		case SQN_UE_TimersAndConstants_n310_e_n3: return "SQN_UE_TimersAndConstants_n310_e_n3";
		case SQN_UE_TimersAndConstants_n310_e_n4: return "SQN_UE_TimersAndConstants_n310_e_n4";
		case SQN_UE_TimersAndConstants_n310_e_n6: return "SQN_UE_TimersAndConstants_n310_e_n6";
		case SQN_UE_TimersAndConstants_n310_e_n8: return "SQN_UE_TimersAndConstants_n310_e_n8";
		case SQN_UE_TimersAndConstants_n310_e_n10: return "SQN_UE_TimersAndConstants_n310_e_n10";
		case SQN_UE_TimersAndConstants_n310_e_n20: return "SQN_UE_TimersAndConstants_n310_e_n20";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t311_e__ToString(SQN_UE_TimersAndConstants_t311_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t311_e_ms1000: return "SQN_UE_TimersAndConstants_t311_e_ms1000";
		case SQN_UE_TimersAndConstants_t311_e_ms3000: return "SQN_UE_TimersAndConstants_t311_e_ms3000";
		case SQN_UE_TimersAndConstants_t311_e_ms5000: return "SQN_UE_TimersAndConstants_t311_e_ms5000";
		case SQN_UE_TimersAndConstants_t311_e_ms10000: return "SQN_UE_TimersAndConstants_t311_e_ms10000";
		case SQN_UE_TimersAndConstants_t311_e_ms15000: return "SQN_UE_TimersAndConstants_t311_e_ms15000";
		case SQN_UE_TimersAndConstants_t311_e_ms20000: return "SQN_UE_TimersAndConstants_t311_e_ms20000";
		case SQN_UE_TimersAndConstants_t311_e_ms30000: return "SQN_UE_TimersAndConstants_t311_e_ms30000";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UE_TimersAndConstants_n311_e__ToString(SQN_UE_TimersAndConstants_n311_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_n311_e_n1: return "SQN_UE_TimersAndConstants_n311_e_n1";
		case SQN_UE_TimersAndConstants_n311_e_n2: return "SQN_UE_TimersAndConstants_n311_e_n2";
		case SQN_UE_TimersAndConstants_n311_e_n3: return "SQN_UE_TimersAndConstants_n311_e_n3";
		case SQN_UE_TimersAndConstants_n311_e_n4: return "SQN_UE_TimersAndConstants_n311_e_n4";
		case SQN_UE_TimersAndConstants_n311_e_n5: return "SQN_UE_TimersAndConstants_n311_e_n5";
		case SQN_UE_TimersAndConstants_n311_e_n6: return "SQN_UE_TimersAndConstants_n311_e_n6";
		case SQN_UE_TimersAndConstants_n311_e_n8: return "SQN_UE_TimersAndConstants_n311_e_n8";
		case SQN_UE_TimersAndConstants_n311_e_n10: return "SQN_UE_TimersAndConstants_n311_e_n10";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t300_v1310_e__ToString(SQN_UE_TimersAndConstants_t300_v1310_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms2500: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms2500";
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms3000: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms3000";
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms3500: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms3500";
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms4000: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms4000";
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms5000: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms5000";
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms6000: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms6000";
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms8000: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms8000";
		case SQN_UE_TimersAndConstants_t300_v1310_e_ms10000: return "SQN_UE_TimersAndConstants_t300_v1310_e_ms10000";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional(acpCtx_t _ctx, const struct SQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_UE_TimersAndConstants_t300_v1310_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t301_v1310_e__ToString(SQN_UE_TimersAndConstants_t301_v1310_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms2500: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms2500";
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms3000: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms3000";
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms3500: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms3500";
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms4000: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms4000";
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms5000: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms5000";
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms6000: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms6000";
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms8000: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms8000";
		case SQN_UE_TimersAndConstants_t301_v1310_e_ms10000: return "SQN_UE_TimersAndConstants_t301_v1310_e_ms10000";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional(acpCtx_t _ctx, const struct SQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_UE_TimersAndConstants_t301_v1310_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t310_v1330_e__ToString(SQN_UE_TimersAndConstants_t310_v1330_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t310_v1330_e_ms4000: return "SQN_UE_TimersAndConstants_t310_v1330_e_ms4000";
		case SQN_UE_TimersAndConstants_t310_v1330_e_ms6000: return "SQN_UE_TimersAndConstants_t310_v1330_e_ms6000";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional(acpCtx_t _ctx, const struct SQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_UE_TimersAndConstants_t310_v1330_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_UE_TimersAndConstants_t300_r15_e__ToString(SQN_UE_TimersAndConstants_t300_r15_e v)
{
	switch(v) {
		case SQN_UE_TimersAndConstants_t300_r15_e_ms4000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms4000";
		case SQN_UE_TimersAndConstants_t300_r15_e_ms6000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms6000";
		case SQN_UE_TimersAndConstants_t300_r15_e_ms8000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms8000";
		case SQN_UE_TimersAndConstants_t300_r15_e_ms10000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms10000";
		case SQN_UE_TimersAndConstants_t300_r15_e_ms15000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms15000";
		case SQN_UE_TimersAndConstants_t300_r15_e_ms25000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms25000";
		case SQN_UE_TimersAndConstants_t300_r15_e_ms40000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms40000";
		case SQN_UE_TimersAndConstants_t300_r15_e_ms60000: return "SQN_UE_TimersAndConstants_t300_r15_e_ms60000";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional(acpCtx_t _ctx, const struct SQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_UE_TimersAndConstants_t300_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_UE_TimersAndConstants(acpCtx_t _ctx, const struct SQN_UE_TimersAndConstants* p)
{
	adbgPrintLog(_ctx, "t300 := %s (%d)", adbgSys__SQN_UE_TimersAndConstants_t300_e__ToString(p->t300), (int)p->t300);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t301 := %s (%d)", adbgSys__SQN_UE_TimersAndConstants_t301_e__ToString(p->t301), (int)p->t301);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t310 := %s (%d)", adbgSys__SQN_UE_TimersAndConstants_t310_e__ToString(p->t310), (int)p->t310);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n310 := %s (%d)", adbgSys__SQN_UE_TimersAndConstants_n310_e__ToString(p->n310), (int)p->n310);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t311 := %s (%d)", adbgSys__SQN_UE_TimersAndConstants_t311_e__ToString(p->t311), (int)p->t311);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n311 := %s (%d)", adbgSys__SQN_UE_TimersAndConstants_n311_e__ToString(p->n311), (int)p->n311);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t300_v1310 := ");
	_adbgSys__SQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional(_ctx, &p->t300_v1310);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t301_v1310 := ");
	_adbgSys__SQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional(_ctx, &p->t301_v1310);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t310_v1330 := ");
	_adbgSys__SQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional(_ctx, &p->t310_v1330);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t300_r15 := ");
	_adbgSys__SQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional(_ctx, &p->t300_r15);
}

static void _adbgSys__SQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional(acpCtx_t _ctx, const struct SQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e__ToString(SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n6: return "SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n6";
		case SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n15: return "SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n15";
		case SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n25: return "SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n25";
		case SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n50: return "SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n50";
		case SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n75: return "SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n75";
		case SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n100: return "SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n100";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType2_freqInfo(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_freqInfo* p)
{
	adbgPrintLog(_ctx, "ul_CarrierFreq := ");
	_adbgSys__SQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional(_ctx, &p->ul_CarrierFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ul_Bandwidth := ");
	_adbgSys__SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(_ctx, &p->ul_Bandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmission := %u", (unsigned int)p->additionalSpectrumEmission);
}

static void _adbgSys__SQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_MBSFN_SubframeConfig(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_TimeAlignmentTimer_e__ToString(SQN_TimeAlignmentTimer_e v)
{
	switch(v) {
		case SQN_TimeAlignmentTimer_e_sf500: return "SQN_TimeAlignmentTimer_e_sf500";
		case SQN_TimeAlignmentTimer_e_sf750: return "SQN_TimeAlignmentTimer_e_sf750";
		case SQN_TimeAlignmentTimer_e_sf1280: return "SQN_TimeAlignmentTimer_e_sf1280";
		case SQN_TimeAlignmentTimer_e_sf1920: return "SQN_TimeAlignmentTimer_e_sf1920";
		case SQN_TimeAlignmentTimer_e_sf2560: return "SQN_TimeAlignmentTimer_e_sf2560";
		case SQN_TimeAlignmentTimer_e_sf5120: return "SQN_TimeAlignmentTimer_e_sf5120";
		case SQN_TimeAlignmentTimer_e_sf10240: return "SQN_TimeAlignmentTimer_e_sf10240";
		case SQN_TimeAlignmentTimer_e_infinity: return "SQN_TimeAlignmentTimer_e_infinity";
		default: return "Unknown";
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e__ToString(SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_true: return "SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e__ToString(SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_true: return "SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e__ToString(SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_true: return "SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12(acpCtx_t _ctx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12* p)
{
	adbgPrintLog(_ctx, "ac_BarringForEmergency_r12 := %s", (p->ac_BarringForEmergency_r12 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringForMO_Signalling_r12 := ");
	if (p->ac_BarringForMO_Signalling_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional(_ctx, &p->ac_BarringForMO_Signalling_r12);
	if (p->ac_BarringForMO_Signalling_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringForMO_Data_r12 := ");
	if (p->ac_BarringForMO_Data_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional(_ctx, &p->ac_BarringForMO_Data_r12);
	if (p->ac_BarringForMO_Data_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12(_ctx, &p->v);
}

static const char* adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e__ToString(SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e v)
{
	switch(v) {
		case SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_true: return "SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e__ToString(SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e v)
{
	switch(v) {
		case SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_true: return "SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e__ToString(SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e v)
{
	switch(v) {
		case SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_true: return "SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringPerPLMN_r12(acpCtx_t _ctx, const struct SQN_AC_BarringPerPLMN_r12* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityIndex_r12 := %u", (unsigned int)p->plmn_IdentityIndex_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringInfo_r12 := ");
	if (p->ac_BarringInfo_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional(_ctx, &p->ac_BarringInfo_r12);
	if (p->ac_BarringInfo_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringSkipForMMTELVoice_r12 := ");
	_adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(_ctx, &p->ac_BarringSkipForMMTELVoice_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringSkipForMMTELVideo_r12 := ");
	_adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(_ctx, &p->ac_BarringSkipForMMTELVideo_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringSkipForSMS_r12 := ");
	_adbgSys__SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(_ctx, &p->ac_BarringSkipForSMS_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringForCSFB_r12 := ");
	if (p->ac_BarringForCSFB_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional(_ctx, &p->ac_BarringForCSFB_r12);
	if (p->ac_BarringForCSFB_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssac_BarringForMMTEL_Voice_r12 := ");
	if (p->ssac_BarringForMMTEL_Voice_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional(_ctx, &p->ssac_BarringForMMTEL_Voice_r12);
	if (p->ssac_BarringForMMTEL_Voice_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssac_BarringForMMTEL_Video_r12 := ");
	if (p->ssac_BarringForMMTEL_Video_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional(_ctx, &p->ssac_BarringForMMTEL_Video_r12);
	if (p->ssac_BarringForMMTEL_Video_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_AC_BarringPerPLMN_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e__ToString(SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_true: return "SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e__ToString(SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e v)
{
	switch(v) {
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p00: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p00";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p05: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p05";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p10: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p10";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p15: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p15";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p20: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p20";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p25: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p25";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p30: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p30";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p40: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p40";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p50: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p50";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p60: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p60";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p70: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p70";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p75: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p75";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p80: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p80";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p85: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p85";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p90: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p90";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p95: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p95";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e__ToString(SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e v)
{
	switch(v) {
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s4: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s4";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s8: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s8";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s16: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s16";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s32: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s32";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s64: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s64";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s128: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s128";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s256: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s256";
		case SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s512: return "SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s512";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13(acpCtx_t _ctx, const struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13* p)
{
	adbgPrintLog(_ctx, "ac_BarringFactor_r13 := %s (%d)", adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e__ToString(p->ac_BarringFactor_r13), (int)p->ac_BarringFactor_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringTime_r13 := %s (%d)", adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e__ToString(p->ac_BarringTime_r13), (int)p->ac_BarringTime_r13);
}

static void _adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional(acpCtx_t _ctx, const struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_BarringPerACDC_Category_r13(acpCtx_t _ctx, const struct SQN_BarringPerACDC_Category_r13* p)
{
	adbgPrintLog(_ctx, "acdc_Category_r13 := %u", (unsigned int)p->acdc_Category_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "acdc_BarringConfig_r13 := ");
	if (p->acdc_BarringConfig_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional(_ctx, &p->acdc_BarringConfig_r13);
	if (p->acdc_BarringConfig_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_ACDC_BarringForCommon_r13(acpCtx_t _ctx, const struct SQN_ACDC_BarringForCommon_r13* p)
{
	adbgPrintLog(_ctx, "acdc_HPLMNonly_r13 := %s", (p->acdc_HPLMNonly_r13 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "barringPerACDC_CategoryList_r13 := { ");
	for (size_t i2 = 0; i2 < p->barringPerACDC_CategoryList_r13.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_BarringPerACDC_Category_r13(_ctx, &p->barringPerACDC_CategoryList_r13.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->barringPerACDC_CategoryList_r13.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional(acpCtx_t _ctx, const struct SQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ACDC_BarringForCommon_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_ACDC_BarringPerPLMN_r13(acpCtx_t _ctx, const struct SQN_ACDC_BarringPerPLMN_r13* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityIndex_r13 := %u", (unsigned int)p->plmn_IdentityIndex_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "acdc_OnlyForHPLMN_r13 := %s", (p->acdc_OnlyForHPLMN_r13 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "barringPerACDC_CategoryList_r13 := { ");
	for (size_t i3 = 0; i3 < p->barringPerACDC_CategoryList_r13.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_BarringPerACDC_Category_r13(_ctx, &p->barringPerACDC_CategoryList_r13.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->barringPerACDC_CategoryList_r13.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional(acpCtx_t _ctx, const struct SQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_ACDC_BarringPerPLMN_r13(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_UDT_Restricting_r13_udt_Restricting_r13_e__ToString(SQN_UDT_Restricting_r13_udt_Restricting_r13_e v)
{
	switch(v) {
		case SQN_UDT_Restricting_r13_udt_Restricting_r13_e_true: return "SQN_UDT_Restricting_r13_udt_Restricting_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional(acpCtx_t _ctx, const struct SQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_UDT_Restricting_r13_udt_Restricting_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e__ToString(SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e v)
{
	switch(v) {
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s4: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s4";
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s8: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s8";
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s16: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s16";
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s32: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s32";
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s64: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s64";
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s128: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s128";
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s256: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s256";
		case SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s512: return "SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s512";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional(acpCtx_t _ctx, const struct SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_UDT_Restricting_r13(acpCtx_t _ctx, const struct SQN_UDT_Restricting_r13* p)
{
	adbgPrintLog(_ctx, "udt_Restricting_r13 := ");
	_adbgSys__SQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional(_ctx, &p->udt_Restricting_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "udt_RestrictingTime_r13 := ");
	_adbgSys__SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional(_ctx, &p->udt_RestrictingTime_r13);
}

static void _adbgSys__SQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional(acpCtx_t _ctx, const struct SQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_UDT_Restricting_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional(acpCtx_t _ctx, const struct SQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_UDT_Restricting_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_UDT_RestrictingPerPLMN_r13(acpCtx_t _ctx, const struct SQN_UDT_RestrictingPerPLMN_r13* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityIndex_r13 := %u", (unsigned int)p->plmn_IdentityIndex_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "udt_Restricting_r13 := ");
	if (p->udt_Restricting_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional(_ctx, &p->udt_Restricting_r13);
	if (p->udt_Restricting_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional(acpCtx_t _ctx, const struct SQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_UDT_RestrictingPerPLMN_r13(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e__ToString(SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e v)
{
	switch(v) {
		case SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_true: return "SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional(acpCtx_t _ctx, const struct SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e__ToString(SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e v)
{
	switch(v) {
		case SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_true: return "SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional(acpCtx_t _ctx, const struct SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e__ToString(SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e v)
{
	switch(v) {
		case SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_true: return "SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional(acpCtx_t _ctx, const struct SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CIOT_OptimisationPLMN_r13(acpCtx_t _ctx, const struct SQN_CIOT_OptimisationPLMN_r13* p)
{
	adbgPrintLog(_ctx, "up_CIoT_EPS_Optimisation_r13 := ");
	_adbgSys__SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional(_ctx, &p->up_CIoT_EPS_Optimisation_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cp_CIoT_EPS_Optimisation_r13 := ");
	_adbgSys__SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional(_ctx, &p->cp_CIoT_EPS_Optimisation_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "attachWithoutPDN_Connectivity_r13 := ");
	_adbgSys__SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional(_ctx, &p->attachWithoutPDN_Connectivity_r13);
}

static void _adbgSys__SQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional(acpCtx_t _ctx, const struct SQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CIOT_OptimisationPLMN_r13(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType2_useFullResumeID_r13_e__ToString(SQN_SystemInformationBlockType2_useFullResumeID_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_useFullResumeID_r13_e_true: return "SQN_SystemInformationBlockType2_useFullResumeID_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_useFullResumeID_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e__ToString(SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_true: return "SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_MBSFN_SubframeConfig_v1430(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e__ToString(SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_true: return "SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_PLMN_Info_r15_upperLayerIndication_r15_e__ToString(SQN_PLMN_Info_r15_upperLayerIndication_r15_e v)
{
	switch(v) {
		case SQN_PLMN_Info_r15_upperLayerIndication_r15_e_true: return "SQN_PLMN_Info_r15_upperLayerIndication_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional(acpCtx_t _ctx, const struct SQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PLMN_Info_r15_upperLayerIndication_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_PLMN_Info_r15(acpCtx_t _ctx, const struct SQN_PLMN_Info_r15* p)
{
	adbgPrintLog(_ctx, "upperLayerIndication_r15 := ");
	_adbgSys__SQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional(_ctx, &p->upperLayerIndication_r15);
}

static void _adbgSys__SQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional(acpCtx_t _ctx, const struct SQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_PLMN_Info_r15(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType2_cp_EDT_r15_e__ToString(SQN_SystemInformationBlockType2_cp_EDT_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_cp_EDT_r15_e_true: return "SQN_SystemInformationBlockType2_cp_EDT_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_cp_EDT_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_up_EDT_r15_e__ToString(SQN_SystemInformationBlockType2_up_EDT_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_up_EDT_r15_e_true: return "SQN_SystemInformationBlockType2_up_EDT_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_up_EDT_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e__ToString(SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_true: return "SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e__ToString(SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_true: return "SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e__ToString(SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_true: return "SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_rlos_Enabled_r16_e__ToString(SQN_SystemInformationBlockType2_rlos_Enabled_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_true: return "SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_rlos_Enabled_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e__ToString(SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_true: return "SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e__ToString(SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_true: return "SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e__ToString(SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_true: return "SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e__ToString(SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_true: return "SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e__ToString(SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_true: return "SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e__ToString(SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_true: return "SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e__ToString(SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_true: return "SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e__ToString(SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_fourBits: return "SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_fourBits";
		case SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_both: return "SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_both";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e__ToString(SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_true: return "SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e__ToString(SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_true: return "SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType2(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType2* p)
{
	adbgPrintLog(_ctx, "ac_BarringInfo := ");
	if (p->ac_BarringInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional(_ctx, &p->ac_BarringInfo);
	if (p->ac_BarringInfo.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "radioResourceConfigCommon := { ");
	_adbgSys__SQN_RadioResourceConfigCommonSIB(_ctx, &p->radioResourceConfigCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ue_TimersAndConstants := { ");
	_adbgSys__SQN_UE_TimersAndConstants(_ctx, &p->ue_TimersAndConstants);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqInfo := { ");
	_adbgSys__SQN_SystemInformationBlockType2_freqInfo(_ctx, &p->freqInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbsfn_SubframeConfigList := ");
	if (p->mbsfn_SubframeConfigList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional(_ctx, &p->mbsfn_SubframeConfigList);
	if (p->mbsfn_SubframeConfigList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeAlignmentTimerCommon := %s (%d)", adbgSys__SQN_TimeAlignmentTimer_e__ToString(p->timeAlignmentTimerCommon), (int)p->timeAlignmentTimerCommon);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssac_BarringForMMTEL_Voice_r9 := ");
	if (p->ssac_BarringForMMTEL_Voice_r9.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional(_ctx, &p->ssac_BarringForMMTEL_Voice_r9);
	if (p->ssac_BarringForMMTEL_Voice_r9.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssac_BarringForMMTEL_Video_r9 := ");
	if (p->ssac_BarringForMMTEL_Video_r9.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional(_ctx, &p->ssac_BarringForMMTEL_Video_r9);
	if (p->ssac_BarringForMMTEL_Video_r9.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringForCSFB_r10 := ");
	if (p->ac_BarringForCSFB_r10.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional(_ctx, &p->ac_BarringForCSFB_r10);
	if (p->ac_BarringForCSFB_r10.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringSkipForMMTELVoice_r12 := ");
	_adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(_ctx, &p->ac_BarringSkipForMMTELVoice_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringSkipForMMTELVideo_r12 := ");
	_adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(_ctx, &p->ac_BarringSkipForMMTELVideo_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringSkipForSMS_r12 := ");
	_adbgSys__SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(_ctx, &p->ac_BarringSkipForSMS_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringPerPLMN_List_r12 := ");
	if (p->ac_BarringPerPLMN_List_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional(_ctx, &p->ac_BarringPerPLMN_List_r12);
	if (p->ac_BarringPerPLMN_List_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "voiceServiceCauseIndication_r12 := ");
	_adbgSys__SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional(_ctx, &p->voiceServiceCauseIndication_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "acdc_BarringForCommon_r13 := ");
	if (p->acdc_BarringForCommon_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional(_ctx, &p->acdc_BarringForCommon_r13);
	if (p->acdc_BarringForCommon_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "acdc_BarringPerPLMN_List_r13 := ");
	if (p->acdc_BarringPerPLMN_List_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional(_ctx, &p->acdc_BarringPerPLMN_List_r13);
	if (p->acdc_BarringPerPLMN_List_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "udt_RestrictingForCommon_r13 := ");
	if (p->udt_RestrictingForCommon_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional(_ctx, &p->udt_RestrictingForCommon_r13);
	if (p->udt_RestrictingForCommon_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "udt_RestrictingPerPLMN_List_r13 := ");
	if (p->udt_RestrictingPerPLMN_List_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional(_ctx, &p->udt_RestrictingPerPLMN_List_r13);
	if (p->udt_RestrictingPerPLMN_List_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cIoT_EPS_OptimisationInfo_r13 := ");
	if (p->cIoT_EPS_OptimisationInfo_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional(_ctx, &p->cIoT_EPS_OptimisationInfo_r13);
	if (p->cIoT_EPS_OptimisationInfo_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "useFullResumeID_r13 := ");
	_adbgSys__SQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional(_ctx, &p->useFullResumeID_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "unicastFreqHoppingInd_r13 := ");
	_adbgSys__SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional(_ctx, &p->unicastFreqHoppingInd_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbsfn_SubframeConfigList_v1430 := ");
	if (p->mbsfn_SubframeConfigList_v1430.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional(_ctx, &p->mbsfn_SubframeConfigList_v1430);
	if (p->mbsfn_SubframeConfigList_v1430.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "videoServiceCauseIndication_r14 := ");
	_adbgSys__SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional(_ctx, &p->videoServiceCauseIndication_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "plmn_InfoList_r15 := ");
	if (p->plmn_InfoList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional(_ctx, &p->plmn_InfoList_r15);
	if (p->plmn_InfoList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cp_EDT_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional(_ctx, &p->cp_EDT_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "up_EDT_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional(_ctx, &p->up_EDT_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "idleModeMeasurements_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional(_ctx, &p->idleModeMeasurements_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reducedCP_LatencyEnabled_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional(_ctx, &p->reducedCP_LatencyEnabled_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbms_ROM_ServiceIndication_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional(_ctx, &p->mbms_ROM_ServiceIndication_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rlos_Enabled_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional(_ctx, &p->rlos_Enabled_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "earlySecurityReactivation_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional(_ctx, &p->earlySecurityReactivation_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cp_EDT_5GC_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional(_ctx, &p->cp_EDT_5GC_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "up_EDT_5GC_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional(_ctx, &p->up_EDT_5GC_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cp_PUR_EPC_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional(_ctx, &p->cp_PUR_EPC_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "up_PUR_EPC_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional(_ctx, &p->up_PUR_EPC_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cp_PUR_5GC_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional(_ctx, &p->cp_PUR_5GC_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "up_PUR_5GC_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional(_ctx, &p->up_PUR_5GC_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_CQI_Reporting_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional(_ctx, &p->mpdcch_CQI_Reporting_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rai_ActivationEnh_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional(_ctx, &p->rai_ActivationEnh_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "idleModeMeasurementsNR_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional(_ctx, &p->idleModeMeasurementsNR_r16);
}

static const char* adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e__ToString(SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB0: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB0";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB1: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB1";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB2: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB2";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB3: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB3";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB4: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB4";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB5: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB5";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB6: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB6";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB8: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB8";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB10: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB10";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB12: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB12";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB14: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB14";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB16: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB16";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB18: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB18";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB20: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB20";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB22: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB22";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB24: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB24";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MobilityStateParameters_t_Evaluation_e__ToString(SQN_MobilityStateParameters_t_Evaluation_e v)
{
	switch(v) {
		case SQN_MobilityStateParameters_t_Evaluation_e_s30: return "SQN_MobilityStateParameters_t_Evaluation_e_s30";
		case SQN_MobilityStateParameters_t_Evaluation_e_s60: return "SQN_MobilityStateParameters_t_Evaluation_e_s60";
		case SQN_MobilityStateParameters_t_Evaluation_e_s120: return "SQN_MobilityStateParameters_t_Evaluation_e_s120";
		case SQN_MobilityStateParameters_t_Evaluation_e_s180: return "SQN_MobilityStateParameters_t_Evaluation_e_s180";
		case SQN_MobilityStateParameters_t_Evaluation_e_s240: return "SQN_MobilityStateParameters_t_Evaluation_e_s240";
		case SQN_MobilityStateParameters_t_Evaluation_e_spare3: return "SQN_MobilityStateParameters_t_Evaluation_e_spare3";
		case SQN_MobilityStateParameters_t_Evaluation_e_spare2: return "SQN_MobilityStateParameters_t_Evaluation_e_spare2";
		case SQN_MobilityStateParameters_t_Evaluation_e_spare1: return "SQN_MobilityStateParameters_t_Evaluation_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MobilityStateParameters_t_HystNormal_e__ToString(SQN_MobilityStateParameters_t_HystNormal_e v)
{
	switch(v) {
		case SQN_MobilityStateParameters_t_HystNormal_e_s30: return "SQN_MobilityStateParameters_t_HystNormal_e_s30";
		case SQN_MobilityStateParameters_t_HystNormal_e_s60: return "SQN_MobilityStateParameters_t_HystNormal_e_s60";
		case SQN_MobilityStateParameters_t_HystNormal_e_s120: return "SQN_MobilityStateParameters_t_HystNormal_e_s120";
		case SQN_MobilityStateParameters_t_HystNormal_e_s180: return "SQN_MobilityStateParameters_t_HystNormal_e_s180";
		case SQN_MobilityStateParameters_t_HystNormal_e_s240: return "SQN_MobilityStateParameters_t_HystNormal_e_s240";
		case SQN_MobilityStateParameters_t_HystNormal_e_spare3: return "SQN_MobilityStateParameters_t_HystNormal_e_spare3";
		case SQN_MobilityStateParameters_t_HystNormal_e_spare2: return "SQN_MobilityStateParameters_t_HystNormal_e_spare2";
		case SQN_MobilityStateParameters_t_HystNormal_e_spare1: return "SQN_MobilityStateParameters_t_HystNormal_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MobilityStateParameters(acpCtx_t _ctx, const struct SQN_MobilityStateParameters* p)
{
	adbgPrintLog(_ctx, "t_Evaluation := %s (%d)", adbgSys__SQN_MobilityStateParameters_t_Evaluation_e__ToString(p->t_Evaluation), (int)p->t_Evaluation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_HystNormal := %s (%d)", adbgSys__SQN_MobilityStateParameters_t_HystNormal_e__ToString(p->t_HystNormal), (int)p->t_HystNormal);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n_CellChangeMedium := %u", (unsigned int)p->n_CellChangeMedium);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n_CellChangeHigh := %u", (unsigned int)p->n_CellChangeHigh);
}

static const char* adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e__ToString(SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_6: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_6";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_4: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_4";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_2: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_2";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB0: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB0";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e__ToString(SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_6: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_6";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_4: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_4";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_2: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_2";
		case SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB0: return "SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB0";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF* p)
{
	adbgPrintLog(_ctx, "sf_Medium := %s (%d)", adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e__ToString(p->sf_Medium), (int)p->sf_Medium);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sf_High := %s (%d)", adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e__ToString(p->sf_High), (int)p->sf_High);
}

static void _adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars* p)
{
	adbgPrintLog(_ctx, "mobilityStateParameters := { ");
	_adbgSys__SQN_MobilityStateParameters(_ctx, &p->mobilityStateParameters);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_HystSF := { ");
	_adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(_ctx, &p->q_HystSF);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon* p)
{
	adbgPrintLog(_ctx, "q_Hyst := %s (%d)", adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e__ToString(p->q_Hyst), (int)p->q_Hyst);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "speedStateReselectionPars := ");
	if (p->speedStateReselectionPars.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(_ctx, &p->speedStateReselectionPars);
	if (p->speedStateReselectionPars.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional(acpCtx_t _ctx, const struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo* p)
{
	adbgPrintLog(_ctx, "s_NonIntraSearch := ");
	_adbgSys__SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional(_ctx, &p->s_NonIntraSearch);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshServingLow := %u", (unsigned int)p->threshServingLow);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := %u", (unsigned int)p->cellReselectionPriority);
}

static void _adbgSys__SQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional(acpCtx_t _ctx, const struct SQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional(acpCtx_t _ctx, const struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_AllowedMeasBandwidth_e__ToString(SQN_AllowedMeasBandwidth_e v)
{
	switch(v) {
		case SQN_AllowedMeasBandwidth_e_mbw6: return "SQN_AllowedMeasBandwidth_e_mbw6";
		case SQN_AllowedMeasBandwidth_e_mbw15: return "SQN_AllowedMeasBandwidth_e_mbw15";
		case SQN_AllowedMeasBandwidth_e_mbw25: return "SQN_AllowedMeasBandwidth_e_mbw25";
		case SQN_AllowedMeasBandwidth_e_mbw50: return "SQN_AllowedMeasBandwidth_e_mbw50";
		case SQN_AllowedMeasBandwidth_e_mbw75: return "SQN_AllowedMeasBandwidth_e_mbw75";
		case SQN_AllowedMeasBandwidth_e_mbw100: return "SQN_AllowedMeasBandwidth_e_mbw100";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional(acpCtx_t _ctx, const struct SQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_AllowedMeasBandwidth_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SpeedStateScaleFactors_sf_Medium_e__ToString(SQN_SpeedStateScaleFactors_sf_Medium_e v)
{
	switch(v) {
		case SQN_SpeedStateScaleFactors_sf_Medium_e_oDot25: return "SQN_SpeedStateScaleFactors_sf_Medium_e_oDot25";
		case SQN_SpeedStateScaleFactors_sf_Medium_e_oDot5: return "SQN_SpeedStateScaleFactors_sf_Medium_e_oDot5";
		case SQN_SpeedStateScaleFactors_sf_Medium_e_oDot75: return "SQN_SpeedStateScaleFactors_sf_Medium_e_oDot75";
		case SQN_SpeedStateScaleFactors_sf_Medium_e_lDot0: return "SQN_SpeedStateScaleFactors_sf_Medium_e_lDot0";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SpeedStateScaleFactors_sf_High_e__ToString(SQN_SpeedStateScaleFactors_sf_High_e v)
{
	switch(v) {
		case SQN_SpeedStateScaleFactors_sf_High_e_oDot25: return "SQN_SpeedStateScaleFactors_sf_High_e_oDot25";
		case SQN_SpeedStateScaleFactors_sf_High_e_oDot5: return "SQN_SpeedStateScaleFactors_sf_High_e_oDot5";
		case SQN_SpeedStateScaleFactors_sf_High_e_oDot75: return "SQN_SpeedStateScaleFactors_sf_High_e_oDot75";
		case SQN_SpeedStateScaleFactors_sf_High_e_lDot0: return "SQN_SpeedStateScaleFactors_sf_High_e_lDot0";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SpeedStateScaleFactors(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors* p)
{
	adbgPrintLog(_ctx, "sf_Medium := %s (%d)", adbgSys__SQN_SpeedStateScaleFactors_sf_Medium_e__ToString(p->sf_Medium), (int)p->sf_Medium);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sf_High := %s (%d)", adbgSys__SQN_SpeedStateScaleFactors_sf_High_e__ToString(p->sf_High), (int)p->sf_High);
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo* p)
{
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_Max := ");
	_adbgSys__SQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional(_ctx, &p->p_Max);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_IntraSearch := ");
	_adbgSys__SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional(_ctx, &p->s_IntraSearch);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedMeasBandwidth := ");
	_adbgSys__SQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional(_ctx, &p->allowedMeasBandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "presenceAntennaPort1 := %s", (p->presenceAntennaPort1 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "neighCellConfig := '");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->neighCellConfig[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA := %u", (unsigned int)p->t_ReselectionEUTRA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_SF := ");
	if (p->t_ReselectionEUTRA_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional(_ctx, &p->t_ReselectionEUTRA_SF);
	if (p->t_ReselectionEUTRA_SF.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType3_s_IntraSearch_v920(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_s_IntraSearch_v920* p)
{
	adbgPrintLog(_ctx, "s_IntraSearchP_r9 := %u", (unsigned int)p->s_IntraSearchP_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_IntraSearchQ_r9 := %u", (unsigned int)p->s_IntraSearchQ_r9);
}

static void _adbgSys__SQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType3_s_IntraSearch_v920(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType3_s_NonIntraSearch_v920(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920* p)
{
	adbgPrintLog(_ctx, "s_NonIntraSearchP_r9 := %u", (unsigned int)p->s_NonIntraSearchP_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_NonIntraSearchQ_r9 := %u", (unsigned int)p->s_NonIntraSearchQ_r9);
}

static void _adbgSys__SQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType3_s_NonIntraSearch_v920(_ctx, &p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional(acpCtx_t _ctx, const struct SQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static const char* adbgSys__SQN_CellReselectionSubPriority_r13_e__ToString(SQN_CellReselectionSubPriority_r13_e v)
{
	switch(v) {
		case SQN_CellReselectionSubPriority_r13_e_oDot2: return "SQN_CellReselectionSubPriority_r13_e_oDot2";
		case SQN_CellReselectionSubPriority_r13_e_oDot4: return "SQN_CellReselectionSubPriority_r13_e_oDot4";
		case SQN_CellReselectionSubPriority_r13_e_oDot6: return "SQN_CellReselectionSubPriority_r13_e_oDot6";
		case SQN_CellReselectionSubPriority_r13_e_oDot8: return "SQN_CellReselectionSubPriority_r13_e_oDot8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CellReselectionServingFreqInfo_v1310(acpCtx_t _ctx, const struct SQN_CellReselectionServingFreqInfo_v1310* p)
{
	adbgPrintLog(_ctx, "cellReselectionSubPriority_r13 := %s (%d)", adbgSys__SQN_CellReselectionSubPriority_r13_e__ToString(p->cellReselectionSubPriority_r13), (int)p->cellReselectionSubPriority_r13);
}

static void _adbgSys__SQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionServingFreqInfo_v1310(_ctx, &p->v);
}

static const char* adbgSys__SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e__ToString(SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e v)
{
	switch(v) {
		case SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_true: return "SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional(acpCtx_t _ctx, const struct SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_RedistributionServingInfo_r13_t360_r13_e__ToString(SQN_RedistributionServingInfo_r13_t360_r13_e v)
{
	switch(v) {
		case SQN_RedistributionServingInfo_r13_t360_r13_e_min4: return "SQN_RedistributionServingInfo_r13_t360_r13_e_min4";
		case SQN_RedistributionServingInfo_r13_t360_r13_e_min8: return "SQN_RedistributionServingInfo_r13_t360_r13_e_min8";
		case SQN_RedistributionServingInfo_r13_t360_r13_e_min16: return "SQN_RedistributionServingInfo_r13_t360_r13_e_min16";
		case SQN_RedistributionServingInfo_r13_t360_r13_e_min32: return "SQN_RedistributionServingInfo_r13_t360_r13_e_min32";
		case SQN_RedistributionServingInfo_r13_t360_r13_e_infinity: return "SQN_RedistributionServingInfo_r13_t360_r13_e_infinity";
		case SQN_RedistributionServingInfo_r13_t360_r13_e_spare3: return "SQN_RedistributionServingInfo_r13_t360_r13_e_spare3";
		case SQN_RedistributionServingInfo_r13_t360_r13_e_spare2: return "SQN_RedistributionServingInfo_r13_t360_r13_e_spare2";
		case SQN_RedistributionServingInfo_r13_t360_r13_e_spare1: return "SQN_RedistributionServingInfo_r13_t360_r13_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e__ToString(SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e v)
{
	switch(v) {
		case SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_true: return "SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional(acpCtx_t _ctx, const struct SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_RedistributionServingInfo_r13(acpCtx_t _ctx, const struct SQN_RedistributionServingInfo_r13* p)
{
	adbgPrintLog(_ctx, "redistributionFactorServing_r13 := %u", (unsigned int)p->redistributionFactorServing_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "redistributionFactorCell_r13 := ");
	_adbgSys__SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional(_ctx, &p->redistributionFactorCell_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t360_r13 := %s (%d)", adbgSys__SQN_RedistributionServingInfo_r13_t360_r13_e__ToString(p->t360_r13), (int)p->t360_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "redistrOnPagingOnly_r13 := ");
	_adbgSys__SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional(_ctx, &p->redistrOnPagingOnly_r13);
}

static void _adbgSys__SQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional(acpCtx_t _ctx, const struct SQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RedistributionServingInfo_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_CellSelectionInfoCE_r13(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE_r13* p)
{
	adbgPrintLog(_ctx, "q_RxLevMinCE_r13 := %d", (int)p->q_RxLevMinCE_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinRSRQ_CE_r13 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional(_ctx, &p->q_QualMinRSRQ_CE_r13);
}

static void _adbgSys__SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional(acpCtx_t _ctx, const struct SQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_CellSelectionInfoCE1_r13(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE1_r13* p)
{
	adbgPrintLog(_ctx, "q_RxLevMinCE1_r13 := %d", (int)p->q_RxLevMinCE1_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinRSRQ_CE1_r13 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional(_ctx, &p->q_QualMinRSRQ_CE1_r13);
}

static void _adbgSys__SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE1_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_CellSelectionInfoCE1_v1360(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE1_v1360* p)
{
	adbgPrintLog(_ctx, "delta_RxLevMinCE1_v1360 := %d", (int)p->delta_RxLevMinCE1_v1360);
}

static void _adbgSys__SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE1_v1360(_ctx, &p->v);
}

static const char* adbgSys__SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e__ToString(SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e v)
{
	switch(v) {
		case SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB6: return "SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB6";
		case SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB9: return "SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB9";
		case SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB12: return "SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB12";
		case SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB15: return "SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB15";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CellReselectionInfoCommon_v1460(acpCtx_t _ctx, const struct SQN_CellReselectionInfoCommon_v1460* p)
{
	adbgPrintLog(_ctx, "s_SearchDeltaP_r14 := %s (%d)", adbgSys__SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e__ToString(p->s_SearchDeltaP_r14), (int)p->s_SearchDeltaP_r14);
}

static void _adbgSys__SQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionInfoCommon_v1460(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionInfoHSDN_r15(acpCtx_t _ctx, const struct SQN_CellReselectionInfoHSDN_r15* p)
{
	adbgPrintLog(_ctx, "cellEquivalentSize_r15 := %u", (unsigned int)p->cellEquivalentSize_r15);
}

static void _adbgSys__SQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionInfoHSDN_r15(_ctx, &p->v);
}

static const char* adbgSys__SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e__ToString(SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e v)
{
	switch(v) {
		case SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB_6: return "SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB_6";
		case SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB_3: return "SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB_3";
		case SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB3: return "SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB3";
		case SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB6: return "SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB6";
		case SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB9: return "SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB9";
		case SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB12: return "SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB12";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CellSelectionInfoCE_v1530(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE_v1530* p)
{
	adbgPrintLog(_ctx, "powerClass14dBm_Offset_r15 := %s (%d)", adbgSys__SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e__ToString(p->powerClass14dBm_Offset_r15), (int)p->powerClass14dBm_Offset_r15);
}

static void _adbgSys__SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE_v1530(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e__ToString(SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_enabled: return "SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CellReselectionSubPriority_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CellReselectionServingFreqInfo_v1610(acpCtx_t _ctx, const struct SQN_CellReselectionServingFreqInfo_v1610* p)
{
	adbgPrintLog(_ctx, "altCellReselectionPriority_r16 := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional(_ctx, &p->altCellReselectionPriority_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "altCellReselectionSubPriority_r16 := ");
	_adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(_ctx, &p->altCellReselectionSubPriority_r16);
}

static void _adbgSys__SQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionServingFreqInfo_v1610(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType3(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType3* p)
{
	adbgPrintLog(_ctx, "cellReselectionInfoCommon := { ");
	_adbgSys__SQN_SystemInformationBlockType3_cellReselectionInfoCommon(_ctx, &p->cellReselectionInfoCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionServingFreqInfo := { ");
	_adbgSys__SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo(_ctx, &p->cellReselectionServingFreqInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqCellReselectionInfo := { ");
	_adbgSys__SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo(_ctx, &p->intraFreqCellReselectionInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_IntraSearch_v920 := ");
	if (p->s_IntraSearch_v920.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional(_ctx, &p->s_IntraSearch_v920);
	if (p->s_IntraSearch_v920.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_NonIntraSearch_v920 := ");
	if (p->s_NonIntraSearch_v920.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional(_ctx, &p->s_NonIntraSearch_v920);
	if (p->s_NonIntraSearch_v920.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin_r9 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional(_ctx, &p->q_QualMin_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshServingLowQ_r9 := ");
	_adbgSys__SQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional(_ctx, &p->threshServingLowQ_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinWB_r11 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional(_ctx, &p->q_QualMinWB_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinRSRQ_OnAllSymbols_r12 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional(_ctx, &p->q_QualMinRSRQ_OnAllSymbols_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionServingFreqInfo_v1310 := ");
	if (p->cellReselectionServingFreqInfo_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional(_ctx, &p->cellReselectionServingFreqInfo_v1310);
	if (p->cellReselectionServingFreqInfo_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "redistributionServingInfo_r13 := ");
	if (p->redistributionServingInfo_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional(_ctx, &p->redistributionServingInfo_r13);
	if (p->redistributionServingInfo_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellSelectionInfoCE_r13 := ");
	if (p->cellSelectionInfoCE_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional(_ctx, &p->cellSelectionInfoCE_r13);
	if (p->cellSelectionInfoCE_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_CE_r13 := ");
	_adbgSys__SQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional(_ctx, &p->t_ReselectionEUTRA_CE_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellSelectionInfoCE1_r13 := ");
	if (p->cellSelectionInfoCE1_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional(_ctx, &p->cellSelectionInfoCE1_r13);
	if (p->cellSelectionInfoCE1_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellSelectionInfoCE1_v1360 := ");
	if (p->cellSelectionInfoCE1_v1360.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional(_ctx, &p->cellSelectionInfoCE1_v1360);
	if (p->cellSelectionInfoCE1_v1360.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionInfoCommon_v1460 := ");
	if (p->cellReselectionInfoCommon_v1460.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional(_ctx, &p->cellReselectionInfoCommon_v1460);
	if (p->cellReselectionInfoCommon_v1460.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionInfoHSDN_r15 := ");
	if (p->cellReselectionInfoHSDN_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional(_ctx, &p->cellReselectionInfoHSDN_r15);
	if (p->cellReselectionInfoHSDN_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellSelectionInfoCE_v1530 := ");
	if (p->cellSelectionInfoCE_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional(_ctx, &p->cellSelectionInfoCE_v1530);
	if (p->cellSelectionInfoCE_v1530.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "crs_IntfMitigNeighCellsCE_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional(_ctx, &p->crs_IntfMitigNeighCellsCE_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionServingFreqInfo_v1610 := ");
	if (p->cellReselectionServingFreqInfo_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional(_ctx, &p->cellReselectionServingFreqInfo_v1610);
	if (p->cellReselectionServingFreqInfo_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_Q_OffsetRange_e__ToString(SQN_Q_OffsetRange_e v)
{
	switch(v) {
		case SQN_Q_OffsetRange_e_dB_24: return "SQN_Q_OffsetRange_e_dB_24";
		case SQN_Q_OffsetRange_e_dB_22: return "SQN_Q_OffsetRange_e_dB_22";
		case SQN_Q_OffsetRange_e_dB_20: return "SQN_Q_OffsetRange_e_dB_20";
		case SQN_Q_OffsetRange_e_dB_18: return "SQN_Q_OffsetRange_e_dB_18";
		case SQN_Q_OffsetRange_e_dB_16: return "SQN_Q_OffsetRange_e_dB_16";
		case SQN_Q_OffsetRange_e_dB_14: return "SQN_Q_OffsetRange_e_dB_14";
		case SQN_Q_OffsetRange_e_dB_12: return "SQN_Q_OffsetRange_e_dB_12";
		case SQN_Q_OffsetRange_e_dB_10: return "SQN_Q_OffsetRange_e_dB_10";
		case SQN_Q_OffsetRange_e_dB_8: return "SQN_Q_OffsetRange_e_dB_8";
		case SQN_Q_OffsetRange_e_dB_6: return "SQN_Q_OffsetRange_e_dB_6";
		case SQN_Q_OffsetRange_e_dB_5: return "SQN_Q_OffsetRange_e_dB_5";
		case SQN_Q_OffsetRange_e_dB_4: return "SQN_Q_OffsetRange_e_dB_4";
		case SQN_Q_OffsetRange_e_dB_3: return "SQN_Q_OffsetRange_e_dB_3";
		case SQN_Q_OffsetRange_e_dB_2: return "SQN_Q_OffsetRange_e_dB_2";
		case SQN_Q_OffsetRange_e_dB_1: return "SQN_Q_OffsetRange_e_dB_1";
		case SQN_Q_OffsetRange_e_dB0: return "SQN_Q_OffsetRange_e_dB0";
		case SQN_Q_OffsetRange_e_dB1: return "SQN_Q_OffsetRange_e_dB1";
		case SQN_Q_OffsetRange_e_dB2: return "SQN_Q_OffsetRange_e_dB2";
		case SQN_Q_OffsetRange_e_dB3: return "SQN_Q_OffsetRange_e_dB3";
		case SQN_Q_OffsetRange_e_dB4: return "SQN_Q_OffsetRange_e_dB4";
		case SQN_Q_OffsetRange_e_dB5: return "SQN_Q_OffsetRange_e_dB5";
		case SQN_Q_OffsetRange_e_dB6: return "SQN_Q_OffsetRange_e_dB6";
		case SQN_Q_OffsetRange_e_dB8: return "SQN_Q_OffsetRange_e_dB8";
		case SQN_Q_OffsetRange_e_dB10: return "SQN_Q_OffsetRange_e_dB10";
		case SQN_Q_OffsetRange_e_dB12: return "SQN_Q_OffsetRange_e_dB12";
		case SQN_Q_OffsetRange_e_dB14: return "SQN_Q_OffsetRange_e_dB14";
		case SQN_Q_OffsetRange_e_dB16: return "SQN_Q_OffsetRange_e_dB16";
		case SQN_Q_OffsetRange_e_dB18: return "SQN_Q_OffsetRange_e_dB18";
		case SQN_Q_OffsetRange_e_dB20: return "SQN_Q_OffsetRange_e_dB20";
		case SQN_Q_OffsetRange_e_dB22: return "SQN_Q_OffsetRange_e_dB22";
		case SQN_Q_OffsetRange_e_dB24: return "SQN_Q_OffsetRange_e_dB24";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_IntraFreqNeighCellInfo(acpCtx_t _ctx, const struct SQN_IntraFreqNeighCellInfo* p)
{
	adbgPrintLog(_ctx, "physCellId := %u", (unsigned int)p->physCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_OffsetCell := %s (%d)", adbgSys__SQN_Q_OffsetRange_e__ToString(p->q_OffsetCell), (int)p->q_OffsetCell);
}

static void _adbgSys__SQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional(acpCtx_t _ctx, const struct SQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_IntraFreqNeighCellInfo(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_PhysCellIdRange_range_e__ToString(SQN_PhysCellIdRange_range_e v)
{
	switch(v) {
		case SQN_PhysCellIdRange_range_e_n4: return "SQN_PhysCellIdRange_range_e_n4";
		case SQN_PhysCellIdRange_range_e_n8: return "SQN_PhysCellIdRange_range_e_n8";
		case SQN_PhysCellIdRange_range_e_n12: return "SQN_PhysCellIdRange_range_e_n12";
		case SQN_PhysCellIdRange_range_e_n16: return "SQN_PhysCellIdRange_range_e_n16";
		case SQN_PhysCellIdRange_range_e_n24: return "SQN_PhysCellIdRange_range_e_n24";
		case SQN_PhysCellIdRange_range_e_n32: return "SQN_PhysCellIdRange_range_e_n32";
		case SQN_PhysCellIdRange_range_e_n48: return "SQN_PhysCellIdRange_range_e_n48";
		case SQN_PhysCellIdRange_range_e_n64: return "SQN_PhysCellIdRange_range_e_n64";
		case SQN_PhysCellIdRange_range_e_n84: return "SQN_PhysCellIdRange_range_e_n84";
		case SQN_PhysCellIdRange_range_e_n96: return "SQN_PhysCellIdRange_range_e_n96";
		case SQN_PhysCellIdRange_range_e_n128: return "SQN_PhysCellIdRange_range_e_n128";
		case SQN_PhysCellIdRange_range_e_n168: return "SQN_PhysCellIdRange_range_e_n168";
		case SQN_PhysCellIdRange_range_e_n252: return "SQN_PhysCellIdRange_range_e_n252";
		case SQN_PhysCellIdRange_range_e_n504: return "SQN_PhysCellIdRange_range_e_n504";
		case SQN_PhysCellIdRange_range_e_spare2: return "SQN_PhysCellIdRange_range_e_spare2";
		case SQN_PhysCellIdRange_range_e_spare1: return "SQN_PhysCellIdRange_range_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PhysCellIdRange_range_e_range_Optional(acpCtx_t _ctx, const struct SQN_PhysCellIdRange_range_e_range_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PhysCellIdRange_range_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_PhysCellIdRange(acpCtx_t _ctx, const struct SQN_PhysCellIdRange* p)
{
	adbgPrintLog(_ctx, "start := %u", (unsigned int)p->start);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "range := ");
	_adbgSys__SQN_PhysCellIdRange_range_e_range_Optional(_ctx, &p->range);
}

static void _adbgSys__SQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional(acpCtx_t _ctx, const struct SQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional(acpCtx_t _ctx, const struct SQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional(acpCtx_t _ctx, const struct SQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e__ToString(SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e v)
{
	switch(v) {
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g1: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g1";
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g2: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g2";
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g4: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g4";
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g8: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g8";
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g16: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g16";
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g32: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g32";
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g64: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g64";
		case SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g128: return "SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g128";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RSS_ConfigCarrierInfo_r16(acpCtx_t _ctx, const struct SQN_RSS_ConfigCarrierInfo_r16* p)
{
	adbgPrintLog(_ctx, "narrowbandIndex_r16 := '");
	for (size_t i2 = 0; i2 < p->narrowbandIndex_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->narrowbandIndex_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeOffsetGranularity_r16 := %s (%d)", adbgSys__SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e__ToString(p->timeOffsetGranularity_r16), (int)p->timeOffsetGranularity_r16);
}

static void _adbgSys__SQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional(acpCtx_t _ctx, const struct SQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RSS_ConfigCarrierInfo_r16(_ctx, &p->v);
}

static const char* adbgSys__SQN_RSS_MeasPowerBias_r16_e__ToString(SQN_RSS_MeasPowerBias_r16_e v)
{
	switch(v) {
		case SQN_RSS_MeasPowerBias_r16_e_dB_6: return "SQN_RSS_MeasPowerBias_r16_e_dB_6";
		case SQN_RSS_MeasPowerBias_r16_e_dB_3: return "SQN_RSS_MeasPowerBias_r16_e_dB_3";
		case SQN_RSS_MeasPowerBias_r16_e_dB0: return "SQN_RSS_MeasPowerBias_r16_e_dB0";
		case SQN_RSS_MeasPowerBias_r16_e_dB3: return "SQN_RSS_MeasPowerBias_r16_e_dB3";
		case SQN_RSS_MeasPowerBias_r16_e_dB6: return "SQN_RSS_MeasPowerBias_r16_e_dB6";
		case SQN_RSS_MeasPowerBias_r16_e_dB9: return "SQN_RSS_MeasPowerBias_r16_e_dB9";
		case SQN_RSS_MeasPowerBias_r16_e_dB12: return "SQN_RSS_MeasPowerBias_r16_e_dB12";
		case SQN_RSS_MeasPowerBias_r16_e_rssNotUsed: return "SQN_RSS_MeasPowerBias_r16_e_rssNotUsed";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_IntraFreqNeighCellInfo_v1610(acpCtx_t _ctx, const struct SQN_IntraFreqNeighCellInfo_v1610* p)
{
	adbgPrintLog(_ctx, "rss_MeasPowerBias_r16 := %s (%d)", adbgSys__SQN_RSS_MeasPowerBias_r16_e__ToString(p->rss_MeasPowerBias_r16), (int)p->rss_MeasPowerBias_r16);
}

static void _adbgSys__SQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional(acpCtx_t _ctx, const struct SQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_IntraFreqNeighCellInfo_v1610(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType4(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType4* p)
{
	adbgPrintLog(_ctx, "intraFreqNeighCellList := ");
	if (p->intraFreqNeighCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional(_ctx, &p->intraFreqNeighCellList);
	if (p->intraFreqNeighCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqBlackCellList := ");
	if (p->intraFreqBlackCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional(_ctx, &p->intraFreqBlackCellList);
	if (p->intraFreqBlackCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csg_PhysCellIdRange := ");
	if (p->csg_PhysCellIdRange.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional(_ctx, &p->csg_PhysCellIdRange);
	if (p->csg_PhysCellIdRange.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqNeighHSDN_CellList_r15 := ");
	if (p->intraFreqNeighHSDN_CellList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional(_ctx, &p->intraFreqNeighHSDN_CellList_r15);
	if (p->intraFreqNeighHSDN_CellList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rss_ConfigCarrierInfo_r16 := ");
	if (p->rss_ConfigCarrierInfo_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional(_ctx, &p->rss_ConfigCarrierInfo_r16);
	if (p->rss_ConfigCarrierInfo_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqNeighCellList_v1610 := ");
	if (p->intraFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional(_ctx, &p->intraFreqNeighCellList_v1610);
	if (p->intraFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional(acpCtx_t _ctx, const struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(acpCtx_t _ctx, const struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_Q_OffsetRange_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_InterFreqNeighCellInfo(acpCtx_t _ctx, const struct SQN_InterFreqNeighCellInfo* p)
{
	adbgPrintLog(_ctx, "physCellId := %u", (unsigned int)p->physCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_OffsetCell := %s (%d)", adbgSys__SQN_Q_OffsetRange_e__ToString(p->q_OffsetCell), (int)p->q_OffsetCell);
}

static void _adbgSys__SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(acpCtx_t _ctx, const struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_InterFreqNeighCellInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(acpCtx_t _ctx, const struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_threshX_Q_r9(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9* p)
{
	adbgPrintLog(_ctx, "threshX_HighQ_r9 := %u", (unsigned int)p->threshX_HighQ_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowQ_r9 := %u", (unsigned int)p->threshX_LowQ_r9);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_InterFreqCarrierFreqInfo_threshX_Q_r9(_ctx, &p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo* p)
{
	adbgPrintLog(_ctx, "dl_CarrierFreq := %u", (unsigned int)p->dl_CarrierFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_Max := ");
	_adbgSys__SQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional(_ctx, &p->p_Max);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA := %u", (unsigned int)p->t_ReselectionEUTRA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_SF := ");
	if (p->t_ReselectionEUTRA_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional(_ctx, &p->t_ReselectionEUTRA_SF);
	if (p->t_ReselectionEUTRA_SF.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High := %u", (unsigned int)p->threshX_High);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low := %u", (unsigned int)p->threshX_Low);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedMeasBandwidth := %s (%d)", adbgSys__SQN_AllowedMeasBandwidth_e__ToString(p->allowedMeasBandwidth), (int)p->allowedMeasBandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "presenceAntennaPort1 := %s", (p->presenceAntennaPort1 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(_ctx, &p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "neighCellConfig := '");
	for (size_t i3 = 0; i3 < 2; i3++) {
		adbgPrintLog(_ctx, "%02X", p->neighCellConfig[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_OffsetFreq := ");
	_adbgSys__SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(_ctx, &p->q_OffsetFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqNeighCellList := ");
	if (p->interFreqNeighCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(_ctx, &p->interFreqNeighCellList);
	if (p->interFreqNeighCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqBlackCellList := ");
	if (p->interFreqBlackCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(_ctx, &p->interFreqBlackCellList);
	if (p->interFreqBlackCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin_r9 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional(_ctx, &p->q_QualMin_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Q_r9 := ");
	if (p->threshX_Q_r9.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional(_ctx, &p->threshX_Q_r9);
	if (p->threshX_Q_r9.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinWB_r11 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional(_ctx, &p->q_QualMinWB_r11);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e__ToString(SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e v)
{
	switch(v) {
		case SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_true: return "SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v1250(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v1250* p)
{
	adbgPrintLog(_ctx, "reducedMeasPerformance_r12 := ");
	_adbgSys__SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_ctx, &p->reducedMeasPerformance_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinRSRQ_OnAllSymbols_r12 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional(_ctx, &p->q_QualMinRSRQ_OnAllSymbols_r12);
}

static void _adbgSys__SQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1250(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional(acpCtx_t _ctx, const struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional(acpCtx_t _ctx, const struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_Q_OffsetRange_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional(acpCtx_t _ctx, const struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_InterFreqNeighCellInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional(acpCtx_t _ctx, const struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12* p)
{
	adbgPrintLog(_ctx, "threshX_HighQ_r12 := %u", (unsigned int)p->threshX_HighQ_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowQ_r12 := %u", (unsigned int)p->threshX_LowQ_r12);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional(acpCtx_t _ctx, const struct SQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e__ToString(SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e v)
{
	switch(v) {
		case SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_true: return "SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional(acpCtx_t _ctx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_r12(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_r12* p)
{
	adbgPrintLog(_ctx, "dl_CarrierFreq_r12 := %u", (unsigned int)p->dl_CarrierFreq_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin_r12 := %d", (int)p->q_RxLevMin_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_Max_r12 := ");
	_adbgSys__SQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional(_ctx, &p->p_Max_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_r12 := %u", (unsigned int)p->t_ReselectionEUTRA_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_SF_r12 := ");
	if (p->t_ReselectionEUTRA_SF_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional(_ctx, &p->t_ReselectionEUTRA_SF_r12);
	if (p->t_ReselectionEUTRA_SF_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High_r12 := %u", (unsigned int)p->threshX_High_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low_r12 := %u", (unsigned int)p->threshX_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedMeasBandwidth_r12 := %s (%d)", adbgSys__SQN_AllowedMeasBandwidth_e__ToString(p->allowedMeasBandwidth_r12), (int)p->allowedMeasBandwidth_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "presenceAntennaPort1_r12 := %s", (p->presenceAntennaPort1_r12 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority_r12 := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional(_ctx, &p->cellReselectionPriority_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "neighCellConfig_r12 := '");
	for (size_t i3 = 0; i3 < 2; i3++) {
		adbgPrintLog(_ctx, "%02X", p->neighCellConfig_r12[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_OffsetFreq_r12 := ");
	_adbgSys__SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional(_ctx, &p->q_OffsetFreq_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqNeighCellList_r12 := ");
	if (p->interFreqNeighCellList_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional(_ctx, &p->interFreqNeighCellList_r12);
	if (p->interFreqNeighCellList_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqBlackCellList_r12 := ");
	if (p->interFreqBlackCellList_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional(_ctx, &p->interFreqBlackCellList_r12);
	if (p->interFreqBlackCellList_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin_r12 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional(_ctx, &p->q_QualMin_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Q_r12 := ");
	if (p->threshX_Q_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional(_ctx, &p->threshX_Q_r12);
	if (p->threshX_Q_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinWB_r12 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional(_ctx, &p->q_QualMinWB_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multiBandInfoList_r12 := ");
	if (p->multiBandInfoList_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional(_ctx, &p->multiBandInfoList_r12);
	if (p->multiBandInfoList_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reducedMeasPerformance_r12 := ");
	_adbgSys__SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_ctx, &p->reducedMeasPerformance_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinRSRQ_OnAllSymbols_r12 := ");
	_adbgSys__SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional(_ctx, &p->q_QualMinRSRQ_OnAllSymbols_r12);
}

static void _adbgSys__SQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional(acpCtx_t _ctx, const struct SQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_NS_PmaxValue_r10(acpCtx_t _ctx, const struct SQN_NS_PmaxValue_r10* p)
{
	adbgPrintLog(_ctx, "additionalPmax_r10 := ");
	_adbgSys__SQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional(_ctx, &p->additionalPmax_r10);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmission := %u", (unsigned int)p->additionalSpectrumEmission);
}

static void _adbgSys__SQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional(acpCtx_t _ctx, const struct SQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_NS_PmaxValue_r10(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional(acpCtx_t _ctx, const struct SQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		for (size_t i4 = 0; i4 < p->v.v[i3].d; i4++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgSys__SQN_NS_PmaxValue_r10(_ctx, &p->v.v[i3].v[i4]);
			adbgPrintLog(_ctx, " }");
			if (i4 != p->v.v[i3].d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v10j0(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v10j0* p)
{
	adbgPrintLog(_ctx, "freqBandInfo_r10 := ");
	if (p->freqBandInfo_r10.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional(_ctx, &p->freqBandInfo_r10);
	if (p->freqBandInfo_r10.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multiBandInfoList_v10j0 := ");
	if (p->multiBandInfoList_v10j0.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional(_ctx, &p->multiBandInfoList_v10j0);
	if (p->multiBandInfoList_v10j0.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v10j0(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CellReselectionSubPriority_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional(acpCtx_t _ctx, const struct SQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RedistributionNeighCell_r13(acpCtx_t _ctx, const struct SQN_RedistributionNeighCell_r13* p)
{
	adbgPrintLog(_ctx, "physCellId_r13 := %u", (unsigned int)p->physCellId_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "redistributionFactorCell_r13 := %u", (unsigned int)p->redistributionFactorCell_r13);
}

static void _adbgSys__SQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional(acpCtx_t _ctx, const struct SQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_RedistributionNeighCell_r13(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_RedistributionInterFreqInfo_r13(acpCtx_t _ctx, const struct SQN_RedistributionInterFreqInfo_r13* p)
{
	adbgPrintLog(_ctx, "redistributionFactorFreq_r13 := ");
	_adbgSys__SQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional(_ctx, &p->redistributionFactorFreq_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "redistributionNeighCellList_r13 := ");
	if (p->redistributionNeighCellList_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional(_ctx, &p->redistributionNeighCellList_r13);
	if (p->redistributionNeighCellList_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional(acpCtx_t _ctx, const struct SQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RedistributionInterFreqInfo_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional(acpCtx_t _ctx, const struct SQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v1310(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v1310* p)
{
	adbgPrintLog(_ctx, "cellReselectionSubPriority_r13 := ");
	_adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional(_ctx, &p->cellReselectionSubPriority_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "redistributionInterFreqInfo_r13 := ");
	if (p->redistributionInterFreqInfo_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional(_ctx, &p->redistributionInterFreqInfo_r13);
	if (p->redistributionInterFreqInfo_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellSelectionInfoCE_r13 := ");
	if (p->cellSelectionInfoCE_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional(_ctx, &p->cellSelectionInfoCE_r13);
	if (p->cellSelectionInfoCE_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_CE_r13 := ");
	_adbgSys__SQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional(_ctx, &p->t_ReselectionEUTRA_CE_r13);
}

static void _adbgSys__SQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1310(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1310(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE1_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v1350(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v1350* p)
{
	adbgPrintLog(_ctx, "cellSelectionInfoCE1_r13 := ");
	if (p->cellSelectionInfoCE1_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional(_ctx, &p->cellSelectionInfoCE1_r13);
	if (p->cellSelectionInfoCE1_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1350(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1350(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE1_v1360(_ctx, &p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v1360(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v1360* p)
{
	adbgPrintLog(_ctx, "cellSelectionInfoCE1_v1360 := ");
	if (p->cellSelectionInfoCE1_v1360.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional(_ctx, &p->cellSelectionInfoCE1_v1360);
	if (p->cellSelectionInfoCE1_v1360.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1360(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__Uint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional(acpCtx_t _ctx, const struct SQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE_v1530(_ctx, &p->v);
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v1530(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v1530* p)
{
	adbgPrintLog(_ctx, "hsdn_Indication_r15 := %s", (p->hsdn_Indication_r15 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqNeighHSDN_CellList_r15 := ");
	if (p->interFreqNeighHSDN_CellList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional(_ctx, &p->interFreqNeighHSDN_CellList_r15);
	if (p->interFreqNeighHSDN_CellList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellSelectionInfoCE_v1530 := ");
	if (p->cellSelectionInfoCE_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional(_ctx, &p->cellSelectionInfoCE_v1530);
	if (p->cellSelectionInfoCE_v1530.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1530(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1530(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional(acpCtx_t _ctx, const struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional(acpCtx_t _ctx, const struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PhysCellIdRange(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e__ToString(SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e v)
{
	switch(v) {
		case SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_rsrp: return "SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_rsrp";
		case SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_rsrq: return "SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_rsrq";
		case SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_both: return "SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_both";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional(acpCtx_t _ctx, const struct SQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional(acpCtx_t _ctx, const struct SQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15* p)
{
	adbgPrintLog(_ctx, "idleRSRP_Threshold_r15 := ");
	_adbgSys__SQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional(_ctx, &p->idleRSRP_Threshold_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "idleRSRQ_Threshold_r15 := ");
	_adbgSys__SQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional(_ctx, &p->idleRSRQ_Threshold_r15);
}

static void _adbgSys__SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_MeasIdleCarrierEUTRA_r15(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierEUTRA_r15* p)
{
	adbgPrintLog(_ctx, "carrierFreq_r15 := %u", (unsigned int)p->carrierFreq_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedMeasBandwidth_r15 := %s (%d)", adbgSys__SQN_AllowedMeasBandwidth_e__ToString(p->allowedMeasBandwidth_r15), (int)p->allowedMeasBandwidth_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "validityArea_r15 := ");
	if (p->validityArea_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional(_ctx, &p->validityArea_r15);
	if (p->validityArea_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measCellList_r15 := ");
	if (p->measCellList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional(_ctx, &p->measCellList_r15);
	if (p->measCellList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reportQuantities := %s (%d)", adbgSys__SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e__ToString(p->reportQuantities), (int)p->reportQuantities);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qualityThreshold_r15 := ");
	if (p->qualityThreshold_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional(_ctx, &p->qualityThreshold_r15);
	if (p->qualityThreshold_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_MeasIdleConfigSIB_r15(acpCtx_t _ctx, const struct SQN_MeasIdleConfigSIB_r15* p)
{
	adbgPrintLog(_ctx, "measIdleCarrierListEUTRA_r15 := { ");
	for (size_t i2 = 0; i2 < p->measIdleCarrierListEUTRA_r15.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_MeasIdleCarrierEUTRA_r15(_ctx, &p->measIdleCarrierListEUTRA_r15.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->measIdleCarrierListEUTRA_r15.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional(acpCtx_t _ctx, const struct SQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MeasIdleConfigSIB_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CellReselectionSubPriority_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional(acpCtx_t _ctx, const struct SQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_RSS_ConfigCarrierInfo_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_InterFreqNeighCellInfo_v1610(acpCtx_t _ctx, const struct SQN_InterFreqNeighCellInfo_v1610* p)
{
	adbgPrintLog(_ctx, "rss_MeasPowerBias_r16 := %s (%d)", adbgSys__SQN_RSS_MeasPowerBias_r16_e__ToString(p->rss_MeasPowerBias_r16), (int)p->rss_MeasPowerBias_r16);
}

static void _adbgSys__SQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(acpCtx_t _ctx, const struct SQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_InterFreqNeighCellInfo_v1610(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqInfo_v1610(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqInfo_v1610* p)
{
	adbgPrintLog(_ctx, "altCellReselectionPriority_r16 := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional(_ctx, &p->altCellReselectionPriority_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "altCellReselectionSubPriority_r16 := ");
	_adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(_ctx, &p->altCellReselectionSubPriority_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rss_ConfigCarrierInfo_r16 := ");
	if (p->rss_ConfigCarrierInfo_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional(_ctx, &p->rss_ConfigCarrierInfo_r16);
	if (p->rss_ConfigCarrierInfo_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqNeighCellList_v1610 := ");
	if (p->interFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(_ctx, &p->interFreqNeighCellList_v1610);
	if (p->interFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1610(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional(acpCtx_t _ctx, const struct SQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_InterFreqCarrierFreqInfo_v1610(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e__ToString(SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e v)
{
	switch(v) {
		case SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz15: return "SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz15";
		case SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz30: return "SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz30";
		case SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz120: return "SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz120";
		case SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz240: return "SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz240";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional(acpCtx_t _ctx, const struct SQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_PhysCellIdRangeNR_r16_range_e__ToString(SQN_PhysCellIdRangeNR_r16_range_e v)
{
	switch(v) {
		case SQN_PhysCellIdRangeNR_r16_range_e_n4: return "SQN_PhysCellIdRangeNR_r16_range_e_n4";
		case SQN_PhysCellIdRangeNR_r16_range_e_n8: return "SQN_PhysCellIdRangeNR_r16_range_e_n8";
		case SQN_PhysCellIdRangeNR_r16_range_e_n12: return "SQN_PhysCellIdRangeNR_r16_range_e_n12";
		case SQN_PhysCellIdRangeNR_r16_range_e_n16: return "SQN_PhysCellIdRangeNR_r16_range_e_n16";
		case SQN_PhysCellIdRangeNR_r16_range_e_n24: return "SQN_PhysCellIdRangeNR_r16_range_e_n24";
		case SQN_PhysCellIdRangeNR_r16_range_e_n32: return "SQN_PhysCellIdRangeNR_r16_range_e_n32";
		case SQN_PhysCellIdRangeNR_r16_range_e_n48: return "SQN_PhysCellIdRangeNR_r16_range_e_n48";
		case SQN_PhysCellIdRangeNR_r16_range_e_n64: return "SQN_PhysCellIdRangeNR_r16_range_e_n64";
		case SQN_PhysCellIdRangeNR_r16_range_e_n84: return "SQN_PhysCellIdRangeNR_r16_range_e_n84";
		case SQN_PhysCellIdRangeNR_r16_range_e_n96: return "SQN_PhysCellIdRangeNR_r16_range_e_n96";
		case SQN_PhysCellIdRangeNR_r16_range_e_n128: return "SQN_PhysCellIdRangeNR_r16_range_e_n128";
		case SQN_PhysCellIdRangeNR_r16_range_e_n168: return "SQN_PhysCellIdRangeNR_r16_range_e_n168";
		case SQN_PhysCellIdRangeNR_r16_range_e_n252: return "SQN_PhysCellIdRangeNR_r16_range_e_n252";
		case SQN_PhysCellIdRangeNR_r16_range_e_n504: return "SQN_PhysCellIdRangeNR_r16_range_e_n504";
		case SQN_PhysCellIdRangeNR_r16_range_e_n1008: return "SQN_PhysCellIdRangeNR_r16_range_e_n1008";
		case SQN_PhysCellIdRangeNR_r16_range_e_spare1: return "SQN_PhysCellIdRangeNR_r16_range_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PhysCellIdRangeNR_r16_range_e_range_Optional(acpCtx_t _ctx, const struct SQN_PhysCellIdRangeNR_r16_range_e_range_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_PhysCellIdRangeNR_r16_range_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_PhysCellIdRangeNR_r16(acpCtx_t _ctx, const struct SQN_PhysCellIdRangeNR_r16* p)
{
	adbgPrintLog(_ctx, "start := %u", (unsigned int)p->start);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "range := ");
	_adbgSys__SQN_PhysCellIdRangeNR_r16_range_e_range_Optional(_ctx, &p->range);
}

static void _adbgSys__SQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(acpCtx_t _ctx, const struct SQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PhysCellIdRangeNR_r16(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e__ToString(SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e v)
{
	switch(v) {
		case SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_rsrp: return "SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_rsrp";
		case SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_rsrq: return "SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_rsrq";
		case SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_both: return "SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_both";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional(acpCtx_t _ctx, const struct SQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional(acpCtx_t _ctx, const struct SQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16* p)
{
	adbgPrintLog(_ctx, "idleRSRP_ThresholdNR_r16 := ");
	_adbgSys__SQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional(_ctx, &p->idleRSRP_ThresholdNR_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "idleRSRQ_ThresholdNR_r16 := ");
	_adbgSys__SQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional(_ctx, &p->idleRSRQ_ThresholdNR_r16);
}

static void _adbgSys__SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional(acpCtx_t _ctx, const struct SQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional(acpCtx_t _ctx, const struct SQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional(acpCtx_t _ctx, const struct SQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional(acpCtx_t _ctx, const struct SQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_ThresholdListNR_r15(acpCtx_t _ctx, const struct SQN_ThresholdListNR_r15* p)
{
	adbgPrintLog(_ctx, "nr_RSRP_r15 := ");
	_adbgSys__SQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional(_ctx, &p->nr_RSRP_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nr_RSRQ_r15 := ");
	_adbgSys__SQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional(_ctx, &p->nr_RSRQ_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nr_SINR_r15 := ");
	_adbgSys__SQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional(_ctx, &p->nr_SINR_r15);
}

static void _adbgSys__SQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional(acpCtx_t _ctx, const struct SQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ThresholdListNR_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value(acpCtx_t _ctx, const union SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value* p, enum SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Sel d)
{
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf5_r15) {
		adbgPrintLog(_ctx, "sf5_r15 := %u", (unsigned int)p->sf5_r15);
		return;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf10_r15) {
		adbgPrintLog(_ctx, "sf10_r15 := %u", (unsigned int)p->sf10_r15);
		return;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf20_r15) {
		adbgPrintLog(_ctx, "sf20_r15 := %u", (unsigned int)p->sf20_r15);
		return;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf40_r15) {
		adbgPrintLog(_ctx, "sf40_r15 := %u", (unsigned int)p->sf40_r15);
		return;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf80_r15) {
		adbgPrintLog(_ctx, "sf80_r15 := %u", (unsigned int)p->sf80_r15);
		return;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf160_r15) {
		adbgPrintLog(_ctx, "sf160_r15 := %u", (unsigned int)p->sf160_r15);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15(acpCtx_t _ctx, const struct SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15* p)
{
	_adbgSys__SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value(_ctx, &p->v, p->d);
}

static const char* adbgSys__SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e__ToString(SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e v)
{
	switch(v) {
		case SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf1: return "SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf1";
		case SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf2: return "SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf2";
		case SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf3: return "SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf3";
		case SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf4: return "SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf4";
		case SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf5: return "SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf5";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MTC_SSB_NR_r15(acpCtx_t _ctx, const struct SQN_MTC_SSB_NR_r15* p)
{
	adbgPrintLog(_ctx, "periodicityAndOffset_r15 := { ");
	_adbgSys__SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15(_ctx, &p->periodicityAndOffset_r15);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_Duration_r15 := %s (%d)", adbgSys__SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e__ToString(p->ssb_Duration_r15), (int)p->ssb_Duration_r15);
}

static void _adbgSys__SQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional(acpCtx_t _ctx, const struct SQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MTC_SSB_NR_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_SSB_ToMeasure_r15_Value(acpCtx_t _ctx, const union SQN_SSB_ToMeasure_r15_Value* p, enum SQN_SSB_ToMeasure_r15_Sel d)
{
	if (d == SQN_SSB_ToMeasure_r15_shortBitmap_r15) {
		adbgPrintLog(_ctx, "shortBitmap_r15 := '");
		for (size_t i3 = 0; i3 < 4; i3++) {
			adbgPrintLog(_ctx, "%02X", p->shortBitmap_r15[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SSB_ToMeasure_r15_mediumBitmap_r15) {
		adbgPrintLog(_ctx, "mediumBitmap_r15 := '");
		for (size_t i3 = 0; i3 < 8; i3++) {
			adbgPrintLog(_ctx, "%02X", p->mediumBitmap_r15[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SSB_ToMeasure_r15_longBitmap_r15) {
		adbgPrintLog(_ctx, "longBitmap_r15 := '");
		for (size_t i3 = 0; i3 < 64; i3++) {
			adbgPrintLog(_ctx, "%02X", p->longBitmap_r15[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SSB_ToMeasure_r15(acpCtx_t _ctx, const struct SQN_SSB_ToMeasure_r15* p)
{
	_adbgSys__SQN_SSB_ToMeasure_r15_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(acpCtx_t _ctx, const struct SQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SSB_ToMeasure_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_SS_RSSI_Measurement_r15(acpCtx_t _ctx, const struct SQN_SS_RSSI_Measurement_r15* p)
{
	adbgPrintLog(_ctx, "measurementSlots_r15 := '");
	for (size_t i3 = 0; i3 < p->measurementSlots_r15.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->measurementSlots_r15.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "endSymbol_r15 := %u", (unsigned int)p->endSymbol_r15);
}

static void _adbgSys__SQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(acpCtx_t _ctx, const struct SQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SS_RSSI_Measurement_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16* p)
{
	adbgPrintLog(_ctx, "maxRS_IndexCellQual_r16 := ");
	_adbgSys__SQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional(_ctx, &p->maxRS_IndexCellQual_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshRS_Index_r16 := ");
	if (p->threshRS_Index_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional(_ctx, &p->threshRS_Index_r16);
	if (p->threshRS_Index_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measTimingConfig_r16 := ");
	if (p->measTimingConfig_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional(_ctx, &p->measTimingConfig_r16);
	if (p->measTimingConfig_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_ToMeasure_r16 := ");
	if (p->ssb_ToMeasure_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(_ctx, &p->ssb_ToMeasure_r16);
	if (p->ssb_ToMeasure_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deriveSSB_IndexFromCell_r16 := %s", (p->deriveSSB_IndexFromCell_r16 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ss_RSSI_Measurement_r16 := ");
	if (p->ss_RSSI_Measurement_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(_ctx, &p->ss_RSSI_Measurement_r16);
	if (p->ss_RSSI_Measurement_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(_ctx, &p->v);
}

static const char* adbgSys__SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e__ToString(SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e v)
{
	switch(v) {
		case SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_rsrp: return "SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_rsrp";
		case SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_rsrq: return "SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_rsrq";
		case SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_both: return "SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_both";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_BeamMeasConfigIdleNR_r16(acpCtx_t _ctx, const struct SQN_BeamMeasConfigIdleNR_r16* p)
{
	adbgPrintLog(_ctx, "reportQuantityRS_IndexNR_r16 := %s (%d)", adbgSys__SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e__ToString(p->reportQuantityRS_IndexNR_r16), (int)p->reportQuantityRS_IndexNR_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxReportRS_Index_r16 := %u", (unsigned int)p->maxReportRS_Index_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reportRS_IndexResultsNR_r16 := %s", (p->reportRS_IndexResultsNR_r16 ? "true" : "false"));
}

static void _adbgSys__SQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(acpCtx_t _ctx, const struct SQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_BeamMeasConfigIdleNR_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_MeasIdleCarrierNR_r16(acpCtx_t _ctx, const struct SQN_MeasIdleCarrierNR_r16* p)
{
	adbgPrintLog(_ctx, "carrierFreqNR_r16 := %u", (unsigned int)p->carrierFreqNR_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subcarrierSpacingSSB_r16 := %s (%d)", adbgSys__SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e__ToString(p->subcarrierSpacingSSB_r16), (int)p->subcarrierSpacingSSB_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyBandList := ");
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional(_ctx, &p->frequencyBandList);
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measCellListNR_r16 := ");
	if (p->measCellListNR_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(_ctx, &p->measCellListNR_r16);
	if (p->measCellListNR_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reportQuantitiesNR_r16 := %s (%d)", adbgSys__SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e__ToString(p->reportQuantitiesNR_r16), (int)p->reportQuantitiesNR_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qualityThresholdNR_r16 := ");
	if (p->qualityThresholdNR_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional(_ctx, &p->qualityThresholdNR_r16);
	if (p->qualityThresholdNR_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_MeasConfig_r16 := ");
	if (p->ssb_MeasConfig_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(_ctx, &p->ssb_MeasConfig_r16);
	if (p->ssb_MeasConfig_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "beamMeasConfigIdle_r16 := ");
	if (p->beamMeasConfigIdle_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(_ctx, &p->beamMeasConfigIdle_r16);
	if (p->beamMeasConfigIdle_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_MeasIdleConfigSIB_NR_r16(acpCtx_t _ctx, const struct SQN_MeasIdleConfigSIB_NR_r16* p)
{
	adbgPrintLog(_ctx, "measIdleCarrierListNR_r16 := { ");
	for (size_t i2 = 0; i2 < p->measIdleCarrierListNR_r16.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_MeasIdleCarrierNR_r16(_ctx, &p->measIdleCarrierListNR_r16.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->measIdleCarrierListNR_r16.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional(acpCtx_t _ctx, const struct SQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MeasIdleConfigSIB_NR_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType5(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType5* p)
{
	adbgPrintLog(_ctx, "interFreqCarrierFreqList := { ");
	for (size_t i2 = 0; i2 < p->interFreqCarrierFreqList.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_InterFreqCarrierFreqInfo(_ctx, &p->interFreqCarrierFreqList.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->interFreqCarrierFreqList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqList_v1250 := ");
	if (p->interFreqCarrierFreqList_v1250.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional(_ctx, &p->interFreqCarrierFreqList_v1250);
	if (p->interFreqCarrierFreqList_v1250.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqListExt_r12 := ");
	if (p->interFreqCarrierFreqListExt_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional(_ctx, &p->interFreqCarrierFreqListExt_r12);
	if (p->interFreqCarrierFreqListExt_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqListExt_v1280 := ");
	if (p->interFreqCarrierFreqListExt_v1280.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional(_ctx, &p->interFreqCarrierFreqListExt_v1280);
	if (p->interFreqCarrierFreqListExt_v1280.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqList_v1310 := ");
	if (p->interFreqCarrierFreqList_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional(_ctx, &p->interFreqCarrierFreqList_v1310);
	if (p->interFreqCarrierFreqList_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqListExt_v1310 := ");
	if (p->interFreqCarrierFreqListExt_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional(_ctx, &p->interFreqCarrierFreqListExt_v1310);
	if (p->interFreqCarrierFreqListExt_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqList_v1350 := ");
	if (p->interFreqCarrierFreqList_v1350.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional(_ctx, &p->interFreqCarrierFreqList_v1350);
	if (p->interFreqCarrierFreqList_v1350.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqListExt_v1350 := ");
	if (p->interFreqCarrierFreqListExt_v1350.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional(_ctx, &p->interFreqCarrierFreqListExt_v1350);
	if (p->interFreqCarrierFreqListExt_v1350.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqListExt_v1360 := ");
	if (p->interFreqCarrierFreqListExt_v1360.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional(_ctx, &p->interFreqCarrierFreqListExt_v1360);
	if (p->interFreqCarrierFreqListExt_v1360.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scptm_FreqOffset_r14 := ");
	_adbgSys__Uint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional(_ctx, &p->scptm_FreqOffset_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqList_v1530 := ");
	if (p->interFreqCarrierFreqList_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional(_ctx, &p->interFreqCarrierFreqList_v1530);
	if (p->interFreqCarrierFreqList_v1530.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqListExt_v1530 := ");
	if (p->interFreqCarrierFreqListExt_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional(_ctx, &p->interFreqCarrierFreqListExt_v1530);
	if (p->interFreqCarrierFreqListExt_v1530.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measIdleConfigSIB_r15 := ");
	if (p->measIdleConfigSIB_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional(_ctx, &p->measIdleConfigSIB_r15);
	if (p->measIdleConfigSIB_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqList_v1610 := ");
	if (p->interFreqCarrierFreqList_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional(_ctx, &p->interFreqCarrierFreqList_v1610);
	if (p->interFreqCarrierFreqList_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqListExt_v1610 := ");
	if (p->interFreqCarrierFreqListExt_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional(_ctx, &p->interFreqCarrierFreqListExt_v1610);
	if (p->interFreqCarrierFreqListExt_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measIdleConfigSIB_NR_r16 := ");
	if (p->measIdleConfigSIB_NR_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional(_ctx, &p->measIdleConfigSIB_NR_r16);
	if (p->measIdleConfigSIB_NR_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CarrierFreqUTRA_FDD_threshX_Q_r9(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9* p)
{
	adbgPrintLog(_ctx, "threshX_HighQ_r9 := %u", (unsigned int)p->threshX_HighQ_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowQ_r9 := %u", (unsigned int)p->threshX_LowQ_r9);
}

static void _adbgSys__SQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CarrierFreqUTRA_FDD_threshX_Q_r9(_ctx, &p->v);
}

static void _adbgSys__SQN_CarrierFreqUTRA_FDD(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_FDD* p)
{
	adbgPrintLog(_ctx, "carrierFreq := %u", (unsigned int)p->carrierFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional(_ctx, &p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High := %u", (unsigned int)p->threshX_High);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low := %u", (unsigned int)p->threshX_Low);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_MaxUTRA := %d", (int)p->p_MaxUTRA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin := %d", (int)p->q_QualMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Q_r9 := ");
	if (p->threshX_Q_r9.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional(_ctx, &p->threshX_Q_r9);
	if (p->threshX_Q_r9.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqUTRA_FDD(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CarrierFreqUTRA_TDD(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_TDD* p)
{
	adbgPrintLog(_ctx, "carrierFreq := %u", (unsigned int)p->carrierFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional(_ctx, &p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High := %u", (unsigned int)p->threshX_High);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low := %u", (unsigned int)p->threshX_Low);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_MaxUTRA := %d", (int)p->p_MaxUTRA);
}

static void _adbgSys__SQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqUTRA_TDD(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e__ToString(SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e v)
{
	switch(v) {
		case SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_true: return "SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CarrierFreqInfoUTRA_v1250(acpCtx_t _ctx, const struct SQN_CarrierFreqInfoUTRA_v1250* p)
{
	adbgPrintLog(_ctx, "reducedMeasPerformance_r12 := ");
	_adbgSys__SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_ctx, &p->reducedMeasPerformance_r12);
}

static void _adbgSys__SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional(acpCtx_t _ctx, const struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_CarrierFreqInfoUTRA_v1250(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional(acpCtx_t _ctx, const struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_CarrierFreqInfoUTRA_v1250(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12* p)
{
	adbgPrintLog(_ctx, "threshX_HighQ_r12 := %u", (unsigned int)p->threshX_HighQ_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowQ_r12 := %u", (unsigned int)p->threshX_LowQ_r12);
}

static void _adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional(acpCtx_t _ctx, const struct SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e__ToString(SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e v)
{
	switch(v) {
		case SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_true: return "SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12* p)
{
	adbgPrintLog(_ctx, "carrierFreq_r12 := %u", (unsigned int)p->carrierFreq_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority_r12 := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional(_ctx, &p->cellReselectionPriority_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High_r12 := %u", (unsigned int)p->threshX_High_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low_r12 := %u", (unsigned int)p->threshX_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin_r12 := %d", (int)p->q_RxLevMin_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_MaxUTRA_r12 := %d", (int)p->p_MaxUTRA_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin_r12 := %d", (int)p->q_QualMin_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Q_r12 := ");
	if (p->threshX_Q_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional(_ctx, &p->threshX_Q_r12);
	if (p->threshX_Q_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multiBandInfoList_r12 := ");
	_adbgSys__SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional(_ctx, &p->multiBandInfoList_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reducedMeasPerformance_r12 := ");
	_adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_ctx, &p->reducedMeasPerformance_r12);
}

static void _adbgSys__SQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqUTRA_FDD_Ext_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e__ToString(SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e v)
{
	switch(v) {
		case SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_true: return "SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CarrierFreqUTRA_TDD_r12(acpCtx_t _ctx, const struct SQN_CarrierFreqUTRA_TDD_r12* p)
{
	adbgPrintLog(_ctx, "carrierFreq_r12 := %u", (unsigned int)p->carrierFreq_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority_r12 := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional(_ctx, &p->cellReselectionPriority_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High_r12 := %u", (unsigned int)p->threshX_High_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low_r12 := %u", (unsigned int)p->threshX_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin_r12 := %d", (int)p->q_RxLevMin_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_MaxUTRA_r12 := %d", (int)p->p_MaxUTRA_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reducedMeasPerformance_r12 := ");
	_adbgSys__SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_ctx, &p->reducedMeasPerformance_r12);
}

static void _adbgSys__SQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqUTRA_TDD_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType6(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType6* p)
{
	adbgPrintLog(_ctx, "carrierFreqListUTRA_FDD := ");
	if (p->carrierFreqListUTRA_FDD.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional(_ctx, &p->carrierFreqListUTRA_FDD);
	if (p->carrierFreqListUTRA_FDD.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqListUTRA_TDD := ");
	if (p->carrierFreqListUTRA_TDD.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional(_ctx, &p->carrierFreqListUTRA_TDD);
	if (p->carrierFreqListUTRA_TDD.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionUTRA := %u", (unsigned int)p->t_ReselectionUTRA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionUTRA_SF := ");
	if (p->t_ReselectionUTRA_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional(_ctx, &p->t_ReselectionUTRA_SF);
	if (p->t_ReselectionUTRA_SF.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqListUTRA_FDD_v1250 := ");
	if (p->carrierFreqListUTRA_FDD_v1250.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional(_ctx, &p->carrierFreqListUTRA_FDD_v1250);
	if (p->carrierFreqListUTRA_FDD_v1250.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqListUTRA_TDD_v1250 := ");
	if (p->carrierFreqListUTRA_TDD_v1250.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional(_ctx, &p->carrierFreqListUTRA_TDD_v1250);
	if (p->carrierFreqListUTRA_TDD_v1250.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqListUTRA_FDD_Ext_r12 := ");
	if (p->carrierFreqListUTRA_FDD_Ext_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional(_ctx, &p->carrierFreqListUTRA_FDD_Ext_r12);
	if (p->carrierFreqListUTRA_FDD_Ext_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqListUTRA_TDD_Ext_r12 := ");
	if (p->carrierFreqListUTRA_TDD_Ext_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional(_ctx, &p->carrierFreqListUTRA_TDD_Ext_r12);
	if (p->carrierFreqListUTRA_TDD_Ext_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static const char* adbgSys__SQN_BandIndicatorGERAN_e__ToString(SQN_BandIndicatorGERAN_e v)
{
	switch(v) {
		case SQN_BandIndicatorGERAN_e_dcs1800: return "SQN_BandIndicatorGERAN_e_dcs1800";
		case SQN_BandIndicatorGERAN_e_pcs1900: return "SQN_BandIndicatorGERAN_e_pcs1900";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs(acpCtx_t _ctx, const struct SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs* p)
{
	adbgPrintLog(_ctx, "arfcn_Spacing := %u", (unsigned int)p->arfcn_Spacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberOfFollowingARFCNs := %u", (unsigned int)p->numberOfFollowingARFCNs);
}

static void _adbgSys__SQN_CarrierFreqsGERAN_followingARFCNs_Value(acpCtx_t _ctx, const union SQN_CarrierFreqsGERAN_followingARFCNs_Value* p, enum SQN_CarrierFreqsGERAN_followingARFCNs_Sel d)
{
	if (d == SQN_CarrierFreqsGERAN_followingARFCNs_explicitListOfARFCNs) {
		adbgPrintLog(_ctx, "explicitListOfARFCNs := '");
		for (size_t i3 = 0; i3 < p->explicitListOfARFCNs.d; i3++) {
			adbgPrintLog(_ctx, "%02X", p->explicitListOfARFCNs.v[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs) {
		adbgPrintLog(_ctx, "equallySpacedARFCNs := { ");
		_adbgSys__SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs(_ctx, &p->equallySpacedARFCNs);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_CarrierFreqsGERAN_followingARFCNs_variableBitMapOfARFCNs) {
		adbgPrintLog(_ctx, "variableBitMapOfARFCNs := '");
		for (size_t i3 = 0; i3 < p->variableBitMapOfARFCNs.d; i3++) {
			adbgPrintLog(_ctx, "%02X", p->variableBitMapOfARFCNs.v[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_CarrierFreqsGERAN_followingARFCNs(acpCtx_t _ctx, const struct SQN_CarrierFreqsGERAN_followingARFCNs* p)
{
	_adbgSys__SQN_CarrierFreqsGERAN_followingARFCNs_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_CarrierFreqsGERAN(acpCtx_t _ctx, const struct SQN_CarrierFreqsGERAN* p)
{
	adbgPrintLog(_ctx, "startingARFCN := %u", (unsigned int)p->startingARFCN);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bandIndicator := %s (%d)", adbgSys__SQN_BandIndicatorGERAN_e__ToString(p->bandIndicator), (int)p->bandIndicator);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "followingARFCNs := { ");
	_adbgSys__SQN_CarrierFreqsGERAN_followingARFCNs(_ctx, &p->followingARFCNs);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__Uint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CarrierFreqsInfoGERAN_commonInfo(acpCtx_t _ctx, const struct SQN_CarrierFreqsInfoGERAN_commonInfo* p)
{
	adbgPrintLog(_ctx, "cellReselectionPriority := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional(_ctx, &p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ncc_Permitted := '");
	for (size_t i3 = 0; i3 < 8; i3++) {
		adbgPrintLog(_ctx, "%02X", p->ncc_Permitted[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin := %u", (unsigned int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_MaxGERAN := ");
	_adbgSys__Uint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional(_ctx, &p->p_MaxGERAN);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High := %u", (unsigned int)p->threshX_High);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low := %u", (unsigned int)p->threshX_Low);
}

static void _adbgSys__SQN_CarrierFreqsInfoGERAN(acpCtx_t _ctx, const struct SQN_CarrierFreqsInfoGERAN* p)
{
	adbgPrintLog(_ctx, "carrierFreqs := { ");
	_adbgSys__SQN_CarrierFreqsGERAN(_ctx, &p->carrierFreqs);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commonInfo := { ");
	_adbgSys__SQN_CarrierFreqsInfoGERAN_commonInfo(_ctx, &p->commonInfo);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqsInfoGERAN(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType7(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType7* p)
{
	adbgPrintLog(_ctx, "t_ReselectionGERAN := %u", (unsigned int)p->t_ReselectionGERAN);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionGERAN_SF := ");
	if (p->t_ReselectionGERAN_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional(_ctx, &p->t_ReselectionGERAN_SF);
	if (p->t_ReselectionGERAN_SF.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqsInfoList := ");
	if (p->carrierFreqsInfoList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional(_ctx, &p->carrierFreqsInfoList);
	if (p->carrierFreqsInfoList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value(acpCtx_t _ctx, const union SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value* p, enum SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Sel d)
{
	if (d == SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_synchronousSystemTime) {
		adbgPrintLog(_ctx, "synchronousSystemTime := '");
		for (size_t i2 = 0; i2 < 39; i2++) {
			adbgPrintLog(_ctx, "%02X", p->synchronousSystemTime[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_asynchronousSystemTime) {
		adbgPrintLog(_ctx, "asynchronousSystemTime := '");
		for (size_t i2 = 0; i2 < 49; i2++) {
			adbgPrintLog(_ctx, "%02X", p->asynchronousSystemTime[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemTimeInfoCDMA2000_cdma_SystemTime(acpCtx_t _ctx, const struct SQN_SystemTimeInfoCDMA2000_cdma_SystemTime* p)
{
	_adbgSys__SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemTimeInfoCDMA2000(acpCtx_t _ctx, const struct SQN_SystemTimeInfoCDMA2000* p)
{
	adbgPrintLog(_ctx, "cdma_EUTRA_Synchronisation := %s", (p->cdma_EUTRA_Synchronisation ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cdma_SystemTime := { ");
	_adbgSys__SQN_SystemTimeInfoCDMA2000_cdma_SystemTime(_ctx, &p->cdma_SystemTime);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional(acpCtx_t _ctx, const struct SQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemTimeInfoCDMA2000(_ctx, &p->v);
}

static void _adbgSys__Uint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional(acpCtx_t _ctx, const struct SQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional(acpCtx_t _ctx, const struct SQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_PreRegistrationInfoHRPD(acpCtx_t _ctx, const struct SQN_PreRegistrationInfoHRPD* p)
{
	adbgPrintLog(_ctx, "preRegistrationAllowed := %s", (p->preRegistrationAllowed ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "preRegistrationZoneId := ");
	_adbgSys__SQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional(_ctx, &p->preRegistrationZoneId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "secondaryPreRegistrationZoneIdList := ");
	if (p->secondaryPreRegistrationZoneIdList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional(_ctx, &p->secondaryPreRegistrationZoneIdList);
	if (p->secondaryPreRegistrationZoneIdList.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_BandclassCDMA2000_e__ToString(SQN_BandclassCDMA2000_e v)
{
	switch(v) {
		case SQN_BandclassCDMA2000_e_bc0: return "SQN_BandclassCDMA2000_e_bc0";
		case SQN_BandclassCDMA2000_e_bc1: return "SQN_BandclassCDMA2000_e_bc1";
		case SQN_BandclassCDMA2000_e_bc2: return "SQN_BandclassCDMA2000_e_bc2";
		case SQN_BandclassCDMA2000_e_bc3: return "SQN_BandclassCDMA2000_e_bc3";
		case SQN_BandclassCDMA2000_e_bc4: return "SQN_BandclassCDMA2000_e_bc4";
		case SQN_BandclassCDMA2000_e_bc5: return "SQN_BandclassCDMA2000_e_bc5";
		case SQN_BandclassCDMA2000_e_bc6: return "SQN_BandclassCDMA2000_e_bc6";
		case SQN_BandclassCDMA2000_e_bc7: return "SQN_BandclassCDMA2000_e_bc7";
		case SQN_BandclassCDMA2000_e_bc8: return "SQN_BandclassCDMA2000_e_bc8";
		case SQN_BandclassCDMA2000_e_bc9: return "SQN_BandclassCDMA2000_e_bc9";
		case SQN_BandclassCDMA2000_e_bc10: return "SQN_BandclassCDMA2000_e_bc10";
		case SQN_BandclassCDMA2000_e_bc11: return "SQN_BandclassCDMA2000_e_bc11";
		case SQN_BandclassCDMA2000_e_bc12: return "SQN_BandclassCDMA2000_e_bc12";
		case SQN_BandclassCDMA2000_e_bc13: return "SQN_BandclassCDMA2000_e_bc13";
		case SQN_BandclassCDMA2000_e_bc14: return "SQN_BandclassCDMA2000_e_bc14";
		case SQN_BandclassCDMA2000_e_bc15: return "SQN_BandclassCDMA2000_e_bc15";
		case SQN_BandclassCDMA2000_e_bc16: return "SQN_BandclassCDMA2000_e_bc16";
		case SQN_BandclassCDMA2000_e_bc17: return "SQN_BandclassCDMA2000_e_bc17";
		case SQN_BandclassCDMA2000_e_bc18_v9a0: return "SQN_BandclassCDMA2000_e_bc18_v9a0";
		case SQN_BandclassCDMA2000_e_bc19_v9a0: return "SQN_BandclassCDMA2000_e_bc19_v9a0";
		case SQN_BandclassCDMA2000_e_bc20_v9a0: return "SQN_BandclassCDMA2000_e_bc20_v9a0";
		case SQN_BandclassCDMA2000_e_bc21_v9a0: return "SQN_BandclassCDMA2000_e_bc21_v9a0";
		case SQN_BandclassCDMA2000_e_spare10: return "SQN_BandclassCDMA2000_e_spare10";
		case SQN_BandclassCDMA2000_e_spare9: return "SQN_BandclassCDMA2000_e_spare9";
		case SQN_BandclassCDMA2000_e_spare8: return "SQN_BandclassCDMA2000_e_spare8";
		case SQN_BandclassCDMA2000_e_spare7: return "SQN_BandclassCDMA2000_e_spare7";
		case SQN_BandclassCDMA2000_e_spare6: return "SQN_BandclassCDMA2000_e_spare6";
		case SQN_BandclassCDMA2000_e_spare5: return "SQN_BandclassCDMA2000_e_spare5";
		case SQN_BandclassCDMA2000_e_spare4: return "SQN_BandclassCDMA2000_e_spare4";
		case SQN_BandclassCDMA2000_e_spare3: return "SQN_BandclassCDMA2000_e_spare3";
		case SQN_BandclassCDMA2000_e_spare2: return "SQN_BandclassCDMA2000_e_spare2";
		case SQN_BandclassCDMA2000_e_spare1: return "SQN_BandclassCDMA2000_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_BandClassInfoCDMA2000(acpCtx_t _ctx, const struct SQN_BandClassInfoCDMA2000* p)
{
	adbgPrintLog(_ctx, "bandClass := %s (%d)", adbgSys__SQN_BandclassCDMA2000_e__ToString(p->bandClass), (int)p->bandClass);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional(_ctx, &p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High := %u", (unsigned int)p->threshX_High);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low := %u", (unsigned int)p->threshX_Low);
}

static void _adbgSys__SQN_NeighCellsPerBandclassCDMA2000(acpCtx_t _ctx, const struct SQN_NeighCellsPerBandclassCDMA2000* p)
{
	adbgPrintLog(_ctx, "arfcn := %u", (unsigned int)p->arfcn);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "physCellIdList := '");
	for (size_t i4 = 0; i4 < p->physCellIdList.d; i4++) {
		adbgPrintLog(_ctx, "%02X", p->physCellIdList.v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_NeighCellCDMA2000(acpCtx_t _ctx, const struct SQN_NeighCellCDMA2000* p)
{
	adbgPrintLog(_ctx, "bandClass := %s (%d)", adbgSys__SQN_BandclassCDMA2000_e__ToString(p->bandClass), (int)p->bandClass);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "neighCellsPerFreqList := { ");
	for (size_t i3 = 0; i3 < p->neighCellsPerFreqList.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_NeighCellsPerBandclassCDMA2000(_ctx, &p->neighCellsPerFreqList.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->neighCellsPerFreqList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000* p)
{
	adbgPrintLog(_ctx, "bandClassList := { ");
	for (size_t i2 = 0; i2 < p->bandClassList.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_BandClassInfoCDMA2000(_ctx, &p->bandClassList.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->bandClassList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "neighCellList := { ");
	for (size_t i2 = 0; i2 < p->neighCellList.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_NeighCellCDMA2000(_ctx, &p->neighCellList.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->neighCellList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionCDMA2000 := %u", (unsigned int)p->t_ReselectionCDMA2000);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionCDMA2000_SF := ");
	if (p->t_ReselectionCDMA2000_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional(_ctx, &p->t_ReselectionCDMA2000_SF);
	if (p->t_ReselectionCDMA2000_SF.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionParametersCDMA2000(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType8_parametersHRPD(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType8_parametersHRPD* p)
{
	adbgPrintLog(_ctx, "preRegistrationInfoHRPD := { ");
	_adbgSys__SQN_PreRegistrationInfoHRPD(_ctx, &p->preRegistrationInfoHRPD);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionParametersHRPD := ");
	if (p->cellReselectionParametersHRPD.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional(_ctx, &p->cellReselectionParametersHRPD);
	if (p->cellReselectionParametersHRPD.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType8_parametersHRPD(_ctx, &p->v);
}

static void _adbgSys__SQN_CSFB_RegistrationParam1XRTT(acpCtx_t _ctx, const struct SQN_CSFB_RegistrationParam1XRTT* p)
{
	adbgPrintLog(_ctx, "sid := '");
	for (size_t i2 = 0; i2 < 15; i2++) {
		adbgPrintLog(_ctx, "%02X", p->sid[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nid := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->nid[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multipleSID := %s", (p->multipleSID ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multipleNID := %s", (p->multipleNID ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "homeReg := %s", (p->homeReg ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "foreignSIDReg := %s", (p->foreignSIDReg ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "foreignNIDReg := %s", (p->foreignNIDReg ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parameterReg := %s", (p->parameterReg ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "powerUpReg := %s", (p->powerUpReg ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "registrationPeriod := '");
	for (size_t i2 = 0; i2 < 7; i2++) {
		adbgPrintLog(_ctx, "%02X", p->registrationPeriod[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "registrationZone := '");
	for (size_t i2 = 0; i2 < 12; i2++) {
		adbgPrintLog(_ctx, "%02X", p->registrationZone[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "totalZone := '");
	for (size_t i2 = 0; i2 < 3; i2++) {
		adbgPrintLog(_ctx, "%02X", p->totalZone[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zoneTimer := '");
	for (size_t i2 = 0; i2 < 3; i2++) {
		adbgPrintLog(_ctx, "%02X", p->zoneTimer[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional(acpCtx_t _ctx, const struct SQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT(_ctx, &p->v);
}

static void _adbgSys__B42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional(acpCtx_t _ctx, const struct B42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 42; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionParametersCDMA2000(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType8_parameters1XRTT(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType8_parameters1XRTT* p)
{
	adbgPrintLog(_ctx, "csfb_RegistrationParam1XRTT := ");
	if (p->csfb_RegistrationParam1XRTT.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional(_ctx, &p->csfb_RegistrationParam1XRTT);
	if (p->csfb_RegistrationParam1XRTT.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "longCodeState1XRTT := ");
	_adbgSys__B42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional(_ctx, &p->longCodeState1XRTT);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionParameters1XRTT := ");
	if (p->cellReselectionParameters1XRTT.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional(_ctx, &p->cellReselectionParameters1XRTT);
	if (p->cellReselectionParameters1XRTT.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType8_parameters1XRTT(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__Bool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional(acpCtx_t _ctx, const struct bool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static void _adbgSys__SQN_NeighCellsPerBandclassCDMA2000_v920(acpCtx_t _ctx, const struct SQN_NeighCellsPerBandclassCDMA2000_v920* p)
{
	adbgPrintLog(_ctx, "physCellIdList_v920 := '");
	for (size_t i4 = 0; i4 < p->physCellIdList_v920.d; i4++) {
		adbgPrintLog(_ctx, "%02X", p->physCellIdList_v920.v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_NeighCellCDMA2000_v920(acpCtx_t _ctx, const struct SQN_NeighCellCDMA2000_v920* p)
{
	adbgPrintLog(_ctx, "neighCellsPerFreqList_v920 := { ");
	for (size_t i3 = 0; i3 < p->neighCellsPerFreqList_v920.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_NeighCellsPerBandclassCDMA2000_v920(_ctx, &p->neighCellsPerFreqList_v920.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->neighCellsPerFreqList_v920.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_v920(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_v920* p)
{
	adbgPrintLog(_ctx, "neighCellList_v920 := { ");
	for (size_t i2 = 0; i2 < p->neighCellList_v920.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_NeighCellCDMA2000_v920(_ctx, &p->neighCellList_v920.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->neighCellList_v920.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionParametersCDMA2000_v920(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionParametersCDMA2000_v920(_ctx, &p->v);
}

static const char* adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e__ToString(SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e v)
{
	switch(v) {
		case SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e_true: return "SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920(acpCtx_t _ctx, const struct SQN_CSFB_RegistrationParam1XRTT_v920* p)
{
	adbgPrintLog(_ctx, "powerDownReg_r9 := %s (%d)", adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e__ToString(p->powerDownReg_r9), (int)p->powerDownReg_r9);
}

static void _adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional(acpCtx_t _ctx, const struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig1XRTT_r9(acpCtx_t _ctx, const struct SQN_AC_BarringConfig1XRTT_r9* p)
{
	adbgPrintLog(_ctx, "ac_Barring0to9_r9 := %u", (unsigned int)p->ac_Barring0to9_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_Barring10_r9 := %u", (unsigned int)p->ac_Barring10_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_Barring11_r9 := %u", (unsigned int)p->ac_Barring11_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_Barring12_r9 := %u", (unsigned int)p->ac_Barring12_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_Barring13_r9 := %u", (unsigned int)p->ac_Barring13_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_Barring14_r9 := %u", (unsigned int)p->ac_Barring14_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_Barring15_r9 := %u", (unsigned int)p->ac_Barring15_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringMsg_r9 := %u", (unsigned int)p->ac_BarringMsg_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringReg_r9 := %u", (unsigned int)p->ac_BarringReg_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringEmg_r9 := %u", (unsigned int)p->ac_BarringEmg_r9);
}

static void _adbgSys__SQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig1XRTT_r9(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e__ToString(SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_true: return "SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value(acpCtx_t _ctx, const union SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value* p, enum SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Sel d)
{
	if (d == SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_explicitValue) {
		adbgPrintLog(_ctx, "explicitValue := { ");
		_adbgSys__SQN_SystemTimeInfoCDMA2000(_ctx, &p->explicitValue);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_defaultValue) {
		adbgPrintLog(_ctx, "defaultValue := %s", (p->defaultValue ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_systemTimeInfo_r11(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11* p)
{
	_adbgSys__SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ParametersCDMA2000_r11_systemTimeInfo_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_NeighCellsPerBandclassCDMA2000_r11(acpCtx_t _ctx, const struct SQN_NeighCellsPerBandclassCDMA2000_r11* p)
{
	adbgPrintLog(_ctx, "arfcn := %u", (unsigned int)p->arfcn);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "physCellIdList_r11 := '");
	for (size_t i5 = 0; i5 < p->physCellIdList_r11.d; i5++) {
		adbgPrintLog(_ctx, "%02X", p->physCellIdList_r11.v[i5]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_NeighCellCDMA2000_r11(acpCtx_t _ctx, const struct SQN_NeighCellCDMA2000_r11* p)
{
	adbgPrintLog(_ctx, "bandClass := %s (%d)", adbgSys__SQN_BandclassCDMA2000_e__ToString(p->bandClass), (int)p->bandClass);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "neighFreqInfoList_r11 := { ");
	for (size_t i4 = 0; i4 < p->neighFreqInfoList_r11.d; i4++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_NeighCellsPerBandclassCDMA2000_r11(_ctx, &p->neighFreqInfoList_r11.v[i4]);
		adbgPrintLog(_ctx, " }");
		if (i4 != p->neighFreqInfoList_r11.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_r11(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_r11* p)
{
	adbgPrintLog(_ctx, "bandClassList := { ");
	for (size_t i3 = 0; i3 < p->bandClassList.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_BandClassInfoCDMA2000(_ctx, &p->bandClassList.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->bandClassList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "neighCellList_r11 := { ");
	for (size_t i3 = 0; i3 < p->neighCellList_r11.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_NeighCellCDMA2000_r11(_ctx, &p->neighCellList_r11.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->neighCellList_r11.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionCDMA2000 := %u", (unsigned int)p->t_ReselectionCDMA2000);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionCDMA2000_SF := ");
	if (p->t_ReselectionCDMA2000_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional(_ctx, &p->t_ReselectionCDMA2000_SF);
	if (p->t_ReselectionCDMA2000_SF.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionParametersCDMA2000_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_parametersHRPD_r11(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11* p)
{
	adbgPrintLog(_ctx, "preRegistrationInfoHRPD_r11 := { ");
	_adbgSys__SQN_PreRegistrationInfoHRPD(_ctx, &p->preRegistrationInfoHRPD_r11);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionParametersHRPD_r11 := ");
	if (p->cellReselectionParametersHRPD_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional(_ctx, &p->cellReselectionParametersHRPD_r11);
	if (p->cellReselectionParametersHRPD_r11.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ParametersCDMA2000_r11_parametersHRPD_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional(acpCtx_t _ctx, const struct SQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT(_ctx, &p->v);
}

static void _adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional(acpCtx_t _ctx, const struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920(_ctx, &p->v);
}

static void _adbgSys__B42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional(acpCtx_t _ctx, const struct B42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < 42; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellReselectionParametersCDMA2000_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional(acpCtx_t _ctx, const struct SQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_AC_BarringConfig1XRTT_r9(_ctx, &p->v);
}

static void _adbgSys__Bool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional(acpCtx_t _ctx, const struct bool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static const char* adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e__ToString(SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e v)
{
	switch(v) {
		case SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_true: return "SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11* p)
{
	adbgPrintLog(_ctx, "csfb_RegistrationParam1XRTT_r11 := ");
	if (p->csfb_RegistrationParam1XRTT_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional(_ctx, &p->csfb_RegistrationParam1XRTT_r11);
	if (p->csfb_RegistrationParam1XRTT_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csfb_RegistrationParam1XRTT_Ext_r11 := ");
	if (p->csfb_RegistrationParam1XRTT_Ext_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional(_ctx, &p->csfb_RegistrationParam1XRTT_Ext_r11);
	if (p->csfb_RegistrationParam1XRTT_Ext_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "longCodeState1XRTT_r11 := ");
	_adbgSys__B42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional(_ctx, &p->longCodeState1XRTT_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionParameters1XRTT_r11 := ");
	if (p->cellReselectionParameters1XRTT_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional(_ctx, &p->cellReselectionParameters1XRTT_r11);
	if (p->cellReselectionParameters1XRTT_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringConfig1XRTT_r11 := ");
	if (p->ac_BarringConfig1XRTT_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional(_ctx, &p->ac_BarringConfig1XRTT_r11);
	if (p->ac_BarringConfig1XRTT_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csfb_SupportForDualRxUEs_r11 := ");
	_adbgSys__Bool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional(_ctx, &p->csfb_SupportForDualRxUEs_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csfb_DualRxTxSupport_r11 := ");
	_adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional(_ctx, &p->csfb_DualRxTxSupport_r11);
}

static void _adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_ParametersCDMA2000_r11(acpCtx_t _ctx, const struct SQN_ParametersCDMA2000_r11* p)
{
	adbgPrintLog(_ctx, "systemTimeInfo_r11 := ");
	if (p->systemTimeInfo_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional(_ctx, &p->systemTimeInfo_r11);
	if (p->systemTimeInfo_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "searchWindowSize_r11 := %u", (unsigned int)p->searchWindowSize_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parametersHRPD_r11 := ");
	if (p->parametersHRPD_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional(_ctx, &p->parametersHRPD_r11);
	if (p->parametersHRPD_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parameters1XRTT_r11 := ");
	if (p->parameters1XRTT_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional(_ctx, &p->parameters1XRTT_r11);
	if (p->parameters1XRTT_r11.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value(acpCtx_t _ctx, const union SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value* p, enum SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Sel d)
{
	if (d == SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_explicitValue) {
		adbgPrintLog(_ctx, "explicitValue := { ");
		_adbgSys__SQN_ParametersCDMA2000_r11(_ctx, &p->explicitValue);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_defaultValue) {
		adbgPrintLog(_ctx, "defaultValue := %s", (p->defaultValue ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11(acpCtx_t _ctx, const struct SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11* p)
{
	_adbgSys__SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SIB8_PerPLMN_r11(acpCtx_t _ctx, const struct SQN_SIB8_PerPLMN_r11* p)
{
	adbgPrintLog(_ctx, "plmn_Identity_r11 := %u", (unsigned int)p->plmn_Identity_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parametersCDMA2000_r11 := { ");
	_adbgSys__SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11(_ctx, &p->parametersCDMA2000_r11);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional(acpCtx_t _ctx, const struct SQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SIB8_PerPLMN_r11(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType8(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType8* p)
{
	adbgPrintLog(_ctx, "systemTimeInfo := ");
	if (p->systemTimeInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional(_ctx, &p->systemTimeInfo);
	if (p->systemTimeInfo.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "searchWindowSize := ");
	_adbgSys__Uint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional(_ctx, &p->searchWindowSize);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parametersHRPD := ");
	if (p->parametersHRPD.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional(_ctx, &p->parametersHRPD);
	if (p->parametersHRPD.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parameters1XRTT := ");
	if (p->parameters1XRTT.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional(_ctx, &p->parameters1XRTT);
	if (p->parameters1XRTT.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csfb_SupportForDualRxUEs_r9 := ");
	_adbgSys__Bool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional(_ctx, &p->csfb_SupportForDualRxUEs_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionParametersHRPD_v920 := ");
	if (p->cellReselectionParametersHRPD_v920.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional(_ctx, &p->cellReselectionParametersHRPD_v920);
	if (p->cellReselectionParametersHRPD_v920.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionParameters1XRTT_v920 := ");
	if (p->cellReselectionParameters1XRTT_v920.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional(_ctx, &p->cellReselectionParameters1XRTT_v920);
	if (p->cellReselectionParameters1XRTT_v920.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csfb_RegistrationParam1XRTT_v920 := ");
	if (p->csfb_RegistrationParam1XRTT_v920.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional(_ctx, &p->csfb_RegistrationParam1XRTT_v920);
	if (p->csfb_RegistrationParam1XRTT_v920.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ac_BarringConfig1XRTT_r9 := ");
	if (p->ac_BarringConfig1XRTT_r9.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional(_ctx, &p->ac_BarringConfig1XRTT_r9);
	if (p->ac_BarringConfig1XRTT_r9.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csfb_DualRxTxSupport_r10 := ");
	_adbgSys__SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional(_ctx, &p->csfb_DualRxTxSupport_r10);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sib8_PerPLMN_List_r11 := ");
	if (p->sib8_PerPLMN_List_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional(_ctx, &p->sib8_PerPLMN_List_r11);
	if (p->sib8_PerPLMN_List_r11.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType9(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType9* p)
{
	adbgPrintLog(_ctx, "hnb_Name := ");
	if (p->hnb_Name.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional(_ctx, &p->hnb_Name);
	if (p->hnb_Name.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__O50_SQN_SystemInformationBlockType10_dummy_Optional(acpCtx_t _ctx, const struct O50_SQN_SystemInformationBlockType10_dummy_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 50; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType10(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType10* p)
{
	adbgPrintLog(_ctx, "messageIdentifier := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->messageIdentifier[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "serialNumber := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->serialNumber[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningType := '");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->warningType[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy := ");
	_adbgSys__O50_SQN_SystemInformationBlockType10_dummy_Optional(_ctx, &p->dummy);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_SystemInformationBlockType11_warningMessageSegmentType_e__ToString(SQN_SystemInformationBlockType11_warningMessageSegmentType_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType11_warningMessageSegmentType_e_notLastSegment: return "SQN_SystemInformationBlockType11_warningMessageSegmentType_e_notLastSegment";
		case SQN_SystemInformationBlockType11_warningMessageSegmentType_e_lastSegment: return "SQN_SystemInformationBlockType11_warningMessageSegmentType_e_lastSegment";
		default: return "Unknown";
	}
}

static void _adbgSys__O1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional(acpCtx_t _ctx, const struct O1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 1; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType11(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType11* p)
{
	adbgPrintLog(_ctx, "messageIdentifier := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->messageIdentifier[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "serialNumber := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->serialNumber[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentType := %s (%d)", adbgSys__SQN_SystemInformationBlockType11_warningMessageSegmentType_e__ToString(p->warningMessageSegmentType), (int)p->warningMessageSegmentType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentNumber := %u", (unsigned int)p->warningMessageSegmentNumber);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegment := '");
	for (size_t i2 = 0; i2 < p->warningMessageSegment.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->warningMessageSegment.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataCodingScheme := ");
	_adbgSys__O1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional(_ctx, &p->dataCodingScheme);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e__ToString(SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e_notLastSegment: return "SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e_notLastSegment";
		case SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e_lastSegment: return "SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e_lastSegment";
		default: return "Unknown";
	}
}

static void _adbgSys__O1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional(acpCtx_t _ctx, const struct O1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 1; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType12_r9(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType12_r9* p)
{
	adbgPrintLog(_ctx, "messageIdentifier_r9 := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->messageIdentifier_r9[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "serialNumber_r9 := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->serialNumber_r9[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentType_r9 := %s (%d)", adbgSys__SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e__ToString(p->warningMessageSegmentType_r9), (int)p->warningMessageSegmentType_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentNumber_r9 := %u", (unsigned int)p->warningMessageSegmentNumber_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegment_r9 := '");
	for (size_t i2 = 0; i2 < p->warningMessageSegment_r9.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->warningMessageSegment_r9.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataCodingScheme_r9 := ");
	_adbgSys__O1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional(_ctx, &p->dataCodingScheme_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningAreaCoordinatesSegment_r15 := ");
	if (p->warningAreaCoordinatesSegment_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional(_ctx, &p->warningAreaCoordinatesSegment_r15);
	if (p->warningAreaCoordinatesSegment_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e__ToString(SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e_s1: return "SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e_s1";
		case SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e_s2: return "SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e_s2";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e__ToString(SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf32: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf32";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf64: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf64";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf128: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf128";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf256: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf256";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e__ToString(SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e_rf512: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e_rf512";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e_rf1024: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e_rf1024";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e__ToString(SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n2: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n2";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n7: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n7";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n13: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n13";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n19: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n19";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r9* p)
{
	adbgPrintLog(_ctx, "mcch_RepetitionPeriod_r9 := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e__ToString(p->mcch_RepetitionPeriod_r9), (int)p->mcch_RepetitionPeriod_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_Offset_r9 := %u", (unsigned int)p->mcch_Offset_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_ModificationPeriod_r9 := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e__ToString(p->mcch_ModificationPeriod_r9), (int)p->mcch_ModificationPeriod_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sf_AllocInfo_r9 := '");
	for (size_t i3 = 0; i3 < 6; i3++) {
		adbgPrintLog(_ctx, "%02X", p->sf_AllocInfo_r9[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "signallingMCS_r9 := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e__ToString(p->signallingMCS_r9), (int)p->signallingMCS_r9);
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e__ToString(SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf1: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf1";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf2: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf2";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf4: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf4";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf8: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf8";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf16: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf16";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e__ToString(SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf1: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf1";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf2: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf2";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf4: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf4";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf8: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf8";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf16: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf16";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf32: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf32";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf64: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf64";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf128: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf128";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf256: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf256";
		case SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_spare7: return "SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_spare7";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14* p)
{
	adbgPrintLog(_ctx, "mcch_RepetitionPeriod_v1430 := ");
	_adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional(_ctx, &p->mcch_RepetitionPeriod_v1430);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_ModificationPeriod_v1430 := ");
	_adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional(_ctx, &p->mcch_ModificationPeriod_v1430);
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14(_ctx, &p->v);
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e__ToString(SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_kHz7dot5: return "SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_kHz7dot5";
		case SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_kHz1dot25: return "SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_kHz1dot25";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r9(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r9* p)
{
	adbgPrintLog(_ctx, "mbsfn_AreaId_r9 := %u", (unsigned int)p->mbsfn_AreaId_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "non_MBSFNregionLength := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e__ToString(p->non_MBSFNregionLength), (int)p->non_MBSFNregionLength);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "notificationIndicator_r9 := %u", (unsigned int)p->notificationIndicator_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_Config_r9 := { ");
	_adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r9(_ctx, &p->mcch_Config_r9);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_Config_r14 := ");
	if (p->mcch_Config_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional(_ctx, &p->mcch_Config_r14);
	if (p->mcch_Config_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subcarrierSpacingMBMS_r14 := ");
	_adbgSys__SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional(_ctx, &p->subcarrierSpacingMBMS_r14);
}

static const char* adbgSys__SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e__ToString(SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e v)
{
	switch(v) {
		case SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e_n2: return "SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e_n2";
		case SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e_n4: return "SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e_n4";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBMS_NotificationConfig_r9(acpCtx_t _ctx, const struct SQN_MBMS_NotificationConfig_r9* p)
{
	adbgPrintLog(_ctx, "notificationRepetitionCoeff_r9 := %s (%d)", adbgSys__SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e__ToString(p->notificationRepetitionCoeff_r9), (int)p->notificationRepetitionCoeff_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "notificationOffset_r9 := %u", (unsigned int)p->notificationOffset_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "notificationSF_Index_r9 := %u", (unsigned int)p->notificationSF_Index_r9);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MBMS_NotificationConfig_v1430(acpCtx_t _ctx, const struct SQN_MBMS_NotificationConfig_v1430* p)
{
	adbgPrintLog(_ctx, "notificationSF_Index_v1430 := %u", (unsigned int)p->notificationSF_Index_v1430);
}

static void _adbgSys__SQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional(acpCtx_t _ctx, const struct SQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MBMS_NotificationConfig_v1430(_ctx, &p->v);
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e__ToString(SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf1: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf1";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf2: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf2";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf4: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf4";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf8: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf8";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf16: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf16";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf32: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf32";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf64: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf64";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf128: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf128";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf256: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf256";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare7: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare7";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare6: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare6";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare5: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare5";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare4: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare4";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare3: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare3";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare2: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare2";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare1: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e__ToString(SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf1: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf1";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf2: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf2";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf4: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf4";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf8: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf8";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf16: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf16";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf32: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf32";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf64: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf64";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf128: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf128";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf256: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf256";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf512: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf512";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf1024: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf1024";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare5: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare5";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare4: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare4";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare3: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare3";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare2: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare2";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare1: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e__ToString(SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n2: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n2";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n7: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n7";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n13: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n13";
		case SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n19: return "SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n19";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r16_mcch_Config_r16* p)
{
	adbgPrintLog(_ctx, "mcch_RepetitionPeriod_r16 := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e__ToString(p->mcch_RepetitionPeriod_r16), (int)p->mcch_RepetitionPeriod_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_ModificationPeriod_r16 := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e__ToString(p->mcch_ModificationPeriod_r16), (int)p->mcch_ModificationPeriod_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_Offset_r16 := %u", (unsigned int)p->mcch_Offset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sf_AllocInfo_r16 := '");
	for (size_t i3 = 0; i3 < 10; i3++) {
		adbgPrintLog(_ctx, "%02X", p->sf_AllocInfo_r16[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "signallingMCS_r16 := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e__ToString(p->signallingMCS_r16), (int)p->signallingMCS_r16);
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e__ToString(SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz7dot5: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz7dot5";
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz2dot5: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz2dot5";
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz1dot25: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz1dot25";
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz0dot37: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz0dot37";
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare4: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare4";
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare3: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare3";
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare2: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare2";
		case SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare1: return "SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e__ToString(SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e v)
{
	switch(v) {
		case SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_sl2: return "SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_sl2";
		case SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_sl4: return "SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_sl4";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_MBSFN_AreaInfo_r16(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfo_r16* p)
{
	adbgPrintLog(_ctx, "mbsfn_AreaId_r16 := %u", (unsigned int)p->mbsfn_AreaId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "notificationIndicator_r16 := %u", (unsigned int)p->notificationIndicator_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcch_Config_r16 := { ");
	_adbgSys__SQN_MBSFN_AreaInfo_r16_mcch_Config_r16(_ctx, &p->mcch_Config_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subcarrierSpacingMBMS_r16 := %s (%d)", adbgSys__SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e__ToString(p->subcarrierSpacingMBMS_r16), (int)p->subcarrierSpacingMBMS_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeSeparation_r16 := ");
	_adbgSys__SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional(_ctx, &p->timeSeparation_r16);
}

static void _adbgSys__SQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional(acpCtx_t _ctx, const struct SQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_MBSFN_AreaInfo_r16(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType13_r9(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType13_r9* p)
{
	adbgPrintLog(_ctx, "mbsfn_AreaInfoList_r9 := { ");
	for (size_t i2 = 0; i2 < p->mbsfn_AreaInfoList_r9.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_MBSFN_AreaInfo_r9(_ctx, &p->mbsfn_AreaInfoList_r9.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->mbsfn_AreaInfoList_r9.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "notificationConfig_r9 := { ");
	_adbgSys__SQN_MBMS_NotificationConfig_r9(_ctx, &p->notificationConfig_r9);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "notificationConfig_v1430 := ");
	if (p->notificationConfig_v1430.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional(_ctx, &p->notificationConfig_v1430);
	if (p->notificationConfig_v1430.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbsfn_AreaInfoList_r16 := ");
	if (p->mbsfn_AreaInfoList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional(_ctx, &p->mbsfn_AreaInfoList_r16);
	if (p->mbsfn_AreaInfoList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_EAB_Config_r11_eab_Category_r11_e__ToString(SQN_EAB_Config_r11_eab_Category_r11_e v)
{
	switch(v) {
		case SQN_EAB_Config_r11_eab_Category_r11_e_a: return "SQN_EAB_Config_r11_eab_Category_r11_e_a";
		case SQN_EAB_Config_r11_eab_Category_r11_e_b: return "SQN_EAB_Config_r11_eab_Category_r11_e_b";
		case SQN_EAB_Config_r11_eab_Category_r11_e_c: return "SQN_EAB_Config_r11_eab_Category_r11_e_c";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_EAB_Config_r11(acpCtx_t _ctx, const struct SQN_EAB_Config_r11* p)
{
	adbgPrintLog(_ctx, "eab_Category_r11 := %s (%d)", adbgSys__SQN_EAB_Config_r11_eab_Category_r11_e__ToString(p->eab_Category_r11), (int)p->eab_Category_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "eab_BarringBitmap_r11 := '");
	for (size_t i2 = 0; i2 < 10; i2++) {
		adbgPrintLog(_ctx, "%02X", p->eab_BarringBitmap_r11[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional(acpCtx_t _ctx, const struct SQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_EAB_Config_r11(_ctx, &p->v);
}

static void _adbgSys__SQN_EAB_ConfigPLMN_r11(acpCtx_t _ctx, const struct SQN_EAB_ConfigPLMN_r11* p)
{
	adbgPrintLog(_ctx, "eab_Config_r11 := ");
	if (p->eab_Config_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional(_ctx, &p->eab_Config_r11);
	if (p->eab_Config_r11.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType14_r11_eab_Param_r11_Value(acpCtx_t _ctx, const union SQN_SystemInformationBlockType14_r11_eab_Param_r11_Value* p, enum SQN_SystemInformationBlockType14_r11_eab_Param_r11_Sel d)
{
	if (d == SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Common_r11) {
		adbgPrintLog(_ctx, "eab_Common_r11 := { ");
		_adbgSys__SQN_EAB_Config_r11(_ctx, &p->eab_Common_r11);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_PerPLMN_List_r11) {
		adbgPrintLog(_ctx, "eab_PerPLMN_List_r11 := { ");
		for (size_t i2 = 0; i2 < p->eab_PerPLMN_List_r11.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgSys__SQN_EAB_ConfigPLMN_r11(_ctx, &p->eab_PerPLMN_List_r11.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->eab_PerPLMN_List_r11.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformationBlockType14_r11_eab_Param_r11(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType14_r11_eab_Param_r11* p)
{
	_adbgSys__SQN_SystemInformationBlockType14_r11_eab_Param_r11_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType14_r11_eab_Param_r11(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e__ToString(SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh0: return "SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh0";
		case SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh1: return "SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh1";
		case SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh2: return "SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh2";
		case SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh3: return "SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh3";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType14_r11(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType14_r11* p)
{
	adbgPrintLog(_ctx, "eab_Param_r11 := ");
	if (p->eab_Param_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional(_ctx, &p->eab_Param_r11);
	if (p->eab_Param_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "eab_PerRSRP_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional(_ctx, &p->eab_PerRSRP_r15);
}

static void _adbgSys__SQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional(acpCtx_t _ctx, const struct SQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MBMS_SAI_InterFreq_r11(acpCtx_t _ctx, const struct SQN_MBMS_SAI_InterFreq_r11* p)
{
	adbgPrintLog(_ctx, "dl_CarrierFreq_r11 := %u", (unsigned int)p->dl_CarrierFreq_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbms_SAI_List_r11 := '");
	for (size_t i3 = 0; i3 < p->mbms_SAI_List_r11.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->mbms_SAI_List_r11.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional(acpCtx_t _ctx, const struct SQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_MBMS_SAI_InterFreq_r11(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional(acpCtx_t _ctx, const struct SQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MBMS_SAI_InterFreq_v1140(acpCtx_t _ctx, const struct SQN_MBMS_SAI_InterFreq_v1140* p)
{
	adbgPrintLog(_ctx, "multiBandInfoList_r11 := ");
	if (p->multiBandInfoList_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional(_ctx, &p->multiBandInfoList_r11);
	if (p->multiBandInfoList_r11.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional(acpCtx_t _ctx, const struct SQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_MBMS_SAI_InterFreq_v1140(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_MBMS_CarrierType_r14_carrierType_r14_e__ToString(SQN_MBMS_CarrierType_r14_carrierType_r14_e v)
{
	switch(v) {
		case SQN_MBMS_CarrierType_r14_carrierType_r14_e_mbms: return "SQN_MBMS_CarrierType_r14_carrierType_r14_e_mbms";
		case SQN_MBMS_CarrierType_r14_carrierType_r14_e_fembmsMixed: return "SQN_MBMS_CarrierType_r14_carrierType_r14_e_fembmsMixed";
		case SQN_MBMS_CarrierType_r14_carrierType_r14_e_fembmsDedicated: return "SQN_MBMS_CarrierType_r14_carrierType_r14_e_fembmsDedicated";
		default: return "Unknown";
	}
}

static void _adbgSys__Uint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_MBMS_CarrierType_r14(acpCtx_t _ctx, const struct SQN_MBMS_CarrierType_r14* p)
{
	adbgPrintLog(_ctx, "carrierType_r14 := %s (%d)", adbgSys__SQN_MBMS_CarrierType_r14_carrierType_r14_e__ToString(p->carrierType_r14), (int)p->carrierType_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frameOffset_r14 := ");
	_adbgSys__Uint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional(_ctx, &p->frameOffset_r14);
}

static void _adbgSys__SQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional(acpCtx_t _ctx, const struct SQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MBMS_CarrierType_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional(acpCtx_t _ctx, const struct SQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_MBMS_CarrierType_r14(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType15_r11(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType15_r11* p)
{
	adbgPrintLog(_ctx, "mbms_SAI_IntraFreq_r11 := ");
	if (p->mbms_SAI_IntraFreq_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional(_ctx, &p->mbms_SAI_IntraFreq_r11);
	if (p->mbms_SAI_IntraFreq_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbms_SAI_InterFreqList_r11 := ");
	if (p->mbms_SAI_InterFreqList_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional(_ctx, &p->mbms_SAI_InterFreqList_r11);
	if (p->mbms_SAI_InterFreqList_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbms_SAI_InterFreqList_v1140 := ");
	if (p->mbms_SAI_InterFreqList_v1140.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional(_ctx, &p->mbms_SAI_InterFreqList_v1140);
	if (p->mbms_SAI_InterFreqList_v1140.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbms_IntraFreqCarrierType_r14 := ");
	if (p->mbms_IntraFreqCarrierType_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional(_ctx, &p->mbms_IntraFreqCarrierType_r14);
	if (p->mbms_IntraFreqCarrierType_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbms_InterFreqCarrierTypeList_r14 := ");
	if (p->mbms_InterFreqCarrierTypeList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional(_ctx, &p->mbms_InterFreqCarrierTypeList_r14);
	if (p->mbms_InterFreqCarrierTypeList_r14.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__B2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional(acpCtx_t _ctx, const struct B2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__Int16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional(acpCtx_t _ctx, const struct int16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__Int8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional(acpCtx_t _ctx, const struct int8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType16_r11_timeInfo_r11(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType16_r11_timeInfo_r11* p)
{
	adbgPrintLog(_ctx, "timeInfoUTC_r11 := %u", (unsigned int)p->timeInfoUTC_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dayLightSavingTime_r11 := ");
	_adbgSys__B2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional(_ctx, &p->dayLightSavingTime_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "leapSeconds_r11 := ");
	_adbgSys__Int16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional(_ctx, &p->leapSeconds_r11);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "localTimeOffset_r11 := ");
	_adbgSys__Int8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional(_ctx, &p->localTimeOffset_r11);
}

static void _adbgSys__SQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType16_r11_timeInfo_r11(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_ReferenceTime_r15(acpCtx_t _ctx, const struct SQN_ReferenceTime_r15* p)
{
	adbgPrintLog(_ctx, "refDays_r15 := %u", (unsigned int)p->refDays_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "refSeconds_r15 := %u", (unsigned int)p->refSeconds_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "refMilliSeconds_r15 := %u", (unsigned int)p->refMilliSeconds_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "refQuarterMicroSeconds_r15 := %u", (unsigned int)p->refQuarterMicroSeconds_r15);
}

static void _adbgSys__Uint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_TimeReferenceInfo_r15_timeInfoType_r15_e__ToString(SQN_TimeReferenceInfo_r15_timeInfoType_r15_e v)
{
	switch(v) {
		case SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_localClock: return "SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_localClock";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional(acpCtx_t _ctx, const struct SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_TimeReferenceInfo_r15_timeInfoType_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__Uint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_TimeReferenceInfo_r15(acpCtx_t _ctx, const struct SQN_TimeReferenceInfo_r15* p)
{
	adbgPrintLog(_ctx, "time_r15 := { ");
	_adbgSys__SQN_ReferenceTime_r15(_ctx, &p->time_r15);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uncertainty_r15 := ");
	_adbgSys__Uint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional(_ctx, &p->uncertainty_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeInfoType_r15 := ");
	_adbgSys__SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional(_ctx, &p->timeInfoType_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSFN_r15 := ");
	_adbgSys__Uint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional(_ctx, &p->referenceSFN_r15);
}

static void _adbgSys__SQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional(acpCtx_t _ctx, const struct SQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TimeReferenceInfo_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType16_r11(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType16_r11* p)
{
	adbgPrintLog(_ctx, "timeInfo_r11 := ");
	if (p->timeInfo_r11.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional(_ctx, &p->timeInfo_r11);
	if (p->timeInfo_r11.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeReferenceInfo_r15 := ");
	if (p->timeReferenceInfo_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional(_ctx, &p->timeReferenceInfo_r15);
	if (p->timeReferenceInfo_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12* p)
{
	adbgPrintLog(_ctx, "thresholdRSRP_Low_r12 := %u", (unsigned int)p->thresholdRSRP_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRP_High_r12 := %u", (unsigned int)p->thresholdRSRP_High_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12* p)
{
	adbgPrintLog(_ctx, "thresholdRSRQ_Low_r12 := %u", (unsigned int)p->thresholdRSRQ_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_High_r12 := %u", (unsigned int)p->thresholdRSRQ_High_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12* p)
{
	adbgPrintLog(_ctx, "thresholdRSRQ_OnAllSymbolsWithWB_Low_r12 := %u", (unsigned int)p->thresholdRSRQ_OnAllSymbolsWithWB_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_OnAllSymbolsWithWB_High_r12 := %u", (unsigned int)p->thresholdRSRQ_OnAllSymbolsWithWB_High_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12* p)
{
	adbgPrintLog(_ctx, "thresholdRSRQ_OnAllSymbolsLow_r12 := %u", (unsigned int)p->thresholdRSRQ_OnAllSymbolsLow_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_OnAllSymbolsHigh_r12 := %u", (unsigned int)p->thresholdRSRQ_OnAllSymbolsHigh_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12* p)
{
	adbgPrintLog(_ctx, "thresholdRSRQ_WB_Low_r12 := %u", (unsigned int)p->thresholdRSRQ_WB_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_WB_High_r12 := %u", (unsigned int)p->thresholdRSRQ_WB_High_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12* p)
{
	adbgPrintLog(_ctx, "thresholdChannelUtilizationLow_r12 := %u", (unsigned int)p->thresholdChannelUtilizationLow_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdChannelUtilizationHigh_r12 := %u", (unsigned int)p->thresholdChannelUtilizationHigh_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12(_ctx, &p->v);
}

static const char* adbgSys__SQN_WLAN_backhaulRate_r12_e__ToString(SQN_WLAN_backhaulRate_r12_e v)
{
	switch(v) {
		case SQN_WLAN_backhaulRate_r12_e_r0: return "SQN_WLAN_backhaulRate_r12_e_r0";
		case SQN_WLAN_backhaulRate_r12_e_r4: return "SQN_WLAN_backhaulRate_r12_e_r4";
		case SQN_WLAN_backhaulRate_r12_e_r8: return "SQN_WLAN_backhaulRate_r12_e_r8";
		case SQN_WLAN_backhaulRate_r12_e_r16: return "SQN_WLAN_backhaulRate_r12_e_r16";
		case SQN_WLAN_backhaulRate_r12_e_r32: return "SQN_WLAN_backhaulRate_r12_e_r32";
		case SQN_WLAN_backhaulRate_r12_e_r64: return "SQN_WLAN_backhaulRate_r12_e_r64";
		case SQN_WLAN_backhaulRate_r12_e_r128: return "SQN_WLAN_backhaulRate_r12_e_r128";
		case SQN_WLAN_backhaulRate_r12_e_r256: return "SQN_WLAN_backhaulRate_r12_e_r256";
		case SQN_WLAN_backhaulRate_r12_e_r512: return "SQN_WLAN_backhaulRate_r12_e_r512";
		case SQN_WLAN_backhaulRate_r12_e_r1024: return "SQN_WLAN_backhaulRate_r12_e_r1024";
		case SQN_WLAN_backhaulRate_r12_e_r2048: return "SQN_WLAN_backhaulRate_r12_e_r2048";
		case SQN_WLAN_backhaulRate_r12_e_r4096: return "SQN_WLAN_backhaulRate_r12_e_r4096";
		case SQN_WLAN_backhaulRate_r12_e_r8192: return "SQN_WLAN_backhaulRate_r12_e_r8192";
		case SQN_WLAN_backhaulRate_r12_e_r16384: return "SQN_WLAN_backhaulRate_r12_e_r16384";
		case SQN_WLAN_backhaulRate_r12_e_r32768: return "SQN_WLAN_backhaulRate_r12_e_r32768";
		case SQN_WLAN_backhaulRate_r12_e_r65536: return "SQN_WLAN_backhaulRate_r12_e_r65536";
		case SQN_WLAN_backhaulRate_r12_e_r131072: return "SQN_WLAN_backhaulRate_r12_e_r131072";
		case SQN_WLAN_backhaulRate_r12_e_r262144: return "SQN_WLAN_backhaulRate_r12_e_r262144";
		case SQN_WLAN_backhaulRate_r12_e_r524288: return "SQN_WLAN_backhaulRate_r12_e_r524288";
		case SQN_WLAN_backhaulRate_r12_e_r1048576: return "SQN_WLAN_backhaulRate_r12_e_r1048576";
		case SQN_WLAN_backhaulRate_r12_e_r2097152: return "SQN_WLAN_backhaulRate_r12_e_r2097152";
		case SQN_WLAN_backhaulRate_r12_e_r4194304: return "SQN_WLAN_backhaulRate_r12_e_r4194304";
		case SQN_WLAN_backhaulRate_r12_e_r8388608: return "SQN_WLAN_backhaulRate_r12_e_r8388608";
		case SQN_WLAN_backhaulRate_r12_e_r16777216: return "SQN_WLAN_backhaulRate_r12_e_r16777216";
		case SQN_WLAN_backhaulRate_r12_e_r33554432: return "SQN_WLAN_backhaulRate_r12_e_r33554432";
		case SQN_WLAN_backhaulRate_r12_e_r67108864: return "SQN_WLAN_backhaulRate_r12_e_r67108864";
		case SQN_WLAN_backhaulRate_r12_e_r134217728: return "SQN_WLAN_backhaulRate_r12_e_r134217728";
		case SQN_WLAN_backhaulRate_r12_e_r268435456: return "SQN_WLAN_backhaulRate_r12_e_r268435456";
		case SQN_WLAN_backhaulRate_r12_e_r536870912: return "SQN_WLAN_backhaulRate_r12_e_r536870912";
		case SQN_WLAN_backhaulRate_r12_e_r1073741824: return "SQN_WLAN_backhaulRate_r12_e_r1073741824";
		case SQN_WLAN_backhaulRate_r12_e_r2147483648: return "SQN_WLAN_backhaulRate_r12_e_r2147483648";
		case SQN_WLAN_backhaulRate_r12_e_r4294967296: return "SQN_WLAN_backhaulRate_r12_e_r4294967296";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12* p)
{
	adbgPrintLog(_ctx, "thresholdBackhaulDL_BandwidthLow_r12 := %s (%d)", adbgSys__SQN_WLAN_backhaulRate_r12_e__ToString(p->thresholdBackhaulDL_BandwidthLow_r12), (int)p->thresholdBackhaulDL_BandwidthLow_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdBackhaulDL_BandwidthHigh_r12 := %s (%d)", adbgSys__SQN_WLAN_backhaulRate_r12_e__ToString(p->thresholdBackhaulDL_BandwidthHigh_r12), (int)p->thresholdBackhaulDL_BandwidthHigh_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdBackhaulUL_BandwidthLow_r12 := %s (%d)", adbgSys__SQN_WLAN_backhaulRate_r12_e__ToString(p->thresholdBackhaulUL_BandwidthLow_r12), (int)p->thresholdBackhaulUL_BandwidthLow_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdBackhaulUL_BandwidthHigh_r12 := %s (%d)", adbgSys__SQN_WLAN_backhaulRate_r12_e__ToString(p->thresholdBackhaulUL_BandwidthHigh_r12), (int)p->thresholdBackhaulUL_BandwidthHigh_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12* p)
{
	adbgPrintLog(_ctx, "thresholdWLAN_RSSI_Low_r12 := %u", (unsigned int)p->thresholdWLAN_RSSI_Low_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdWLAN_RSSI_High_r12 := %u", (unsigned int)p->thresholdWLAN_RSSI_High_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12(_ctx, &p->v);
}

static void _adbgSys__B16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional(acpCtx_t _ctx, const struct B16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < 16; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional(acpCtx_t _ctx, const struct SQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12* p)
{
	adbgPrintLog(_ctx, "thresholdRSRP_r12 := ");
	if (p->thresholdRSRP_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional(_ctx, &p->thresholdRSRP_r12);
	if (p->thresholdRSRP_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_r12 := ");
	if (p->thresholdRSRQ_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional(_ctx, &p->thresholdRSRQ_r12);
	if (p->thresholdRSRQ_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_OnAllSymbolsWithWB_r12 := ");
	if (p->thresholdRSRQ_OnAllSymbolsWithWB_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional(_ctx, &p->thresholdRSRQ_OnAllSymbolsWithWB_r12);
	if (p->thresholdRSRQ_OnAllSymbolsWithWB_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_OnAllSymbols_r12 := ");
	if (p->thresholdRSRQ_OnAllSymbols_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional(_ctx, &p->thresholdRSRQ_OnAllSymbols_r12);
	if (p->thresholdRSRQ_OnAllSymbols_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ_WB_r12 := ");
	if (p->thresholdRSRQ_WB_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional(_ctx, &p->thresholdRSRQ_WB_r12);
	if (p->thresholdRSRQ_WB_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdChannelUtilization_r12 := ");
	if (p->thresholdChannelUtilization_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional(_ctx, &p->thresholdChannelUtilization_r12);
	if (p->thresholdChannelUtilization_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdBackhaul_Bandwidth_r12 := ");
	if (p->thresholdBackhaul_Bandwidth_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional(_ctx, &p->thresholdBackhaul_Bandwidth_r12);
	if (p->thresholdBackhaul_Bandwidth_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdWLAN_RSSI_r12 := ");
	if (p->thresholdWLAN_RSSI_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional(_ctx, &p->thresholdWLAN_RSSI_r12);
	if (p->thresholdWLAN_RSSI_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "offloadPreferenceIndicator_r12 := ");
	_adbgSys__B16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional(_ctx, &p->offloadPreferenceIndicator_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_SteeringWLAN_r12 := ");
	_adbgSys__SQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional(_ctx, &p->t_SteeringWLAN_r12);
}

static void _adbgSys__SQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_WLAN_OffloadConfig_r12(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__O6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional(acpCtx_t _ctx, const struct O6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i4 = 0; i4 < 6; i4++) {
		adbgPrintLog(_ctx, "%02X", p->v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__O6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional(acpCtx_t _ctx, const struct O6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i4 = 0; i4 < 6; i4++) {
		adbgPrintLog(_ctx, "%02X", p->v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_WLAN_Identifiers_r12(acpCtx_t _ctx, const struct SQN_WLAN_Identifiers_r12* p)
{
	adbgPrintLog(_ctx, "ssid_r12 := ");
	if (p->ssid_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional(_ctx, &p->ssid_r12);
	if (p->ssid_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bssid_r12 := ");
	_adbgSys__O6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional(_ctx, &p->bssid_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "hessid_r12 := ");
	_adbgSys__O6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional(_ctx, &p->hessid_r12);
}

static void _adbgSys__SQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional(acpCtx_t _ctx, const struct SQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_WLAN_Identifiers_r12(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_WLAN_OffloadInfoPerPLMN_r12(acpCtx_t _ctx, const struct SQN_WLAN_OffloadInfoPerPLMN_r12* p)
{
	adbgPrintLog(_ctx, "wlan_OffloadConfigCommon_r12 := ");
	if (p->wlan_OffloadConfigCommon_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional(_ctx, &p->wlan_OffloadConfigCommon_r12);
	if (p->wlan_OffloadConfigCommon_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "wlan_Id_List_r12 := ");
	if (p->wlan_Id_List_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional(_ctx, &p->wlan_Id_List_r12);
	if (p->wlan_Id_List_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional(acpCtx_t _ctx, const struct SQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_WLAN_OffloadInfoPerPLMN_r12(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType17_r12(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType17_r12* p)
{
	adbgPrintLog(_ctx, "wlan_OffloadInfoPerPLMN_List_r12 := ");
	if (p->wlan_OffloadInfoPerPLMN_List_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional(_ctx, &p->wlan_OffloadInfoPerPLMN_List_r12);
	if (p->wlan_OffloadInfoPerPLMN_List_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_SL_CP_Len_r12_e__ToString(SQN_SL_CP_Len_r12_e v)
{
	switch(v) {
		case SQN_SL_CP_Len_r12_e_normal: return "SQN_SL_CP_Len_r12_e_normal";
		case SQN_SL_CP_Len_r12_e_extended: return "SQN_SL_CP_Len_r12_e_extended";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SL_PeriodComm_r12_e__ToString(SQN_SL_PeriodComm_r12_e v)
{
	switch(v) {
		case SQN_SL_PeriodComm_r12_e_sf40: return "SQN_SL_PeriodComm_r12_e_sf40";
		case SQN_SL_PeriodComm_r12_e_sf60: return "SQN_SL_PeriodComm_r12_e_sf60";
		case SQN_SL_PeriodComm_r12_e_sf70: return "SQN_SL_PeriodComm_r12_e_sf70";
		case SQN_SL_PeriodComm_r12_e_sf80: return "SQN_SL_PeriodComm_r12_e_sf80";
		case SQN_SL_PeriodComm_r12_e_sf120: return "SQN_SL_PeriodComm_r12_e_sf120";
		case SQN_SL_PeriodComm_r12_e_sf140: return "SQN_SL_PeriodComm_r12_e_sf140";
		case SQN_SL_PeriodComm_r12_e_sf160: return "SQN_SL_PeriodComm_r12_e_sf160";
		case SQN_SL_PeriodComm_r12_e_sf240: return "SQN_SL_PeriodComm_r12_e_sf240";
		case SQN_SL_PeriodComm_r12_e_sf280: return "SQN_SL_PeriodComm_r12_e_sf280";
		case SQN_SL_PeriodComm_r12_e_sf320: return "SQN_SL_PeriodComm_r12_e_sf320";
		case SQN_SL_PeriodComm_r12_e_spare6: return "SQN_SL_PeriodComm_r12_e_spare6";
		case SQN_SL_PeriodComm_r12_e_spare5: return "SQN_SL_PeriodComm_r12_e_spare5";
		case SQN_SL_PeriodComm_r12_e_spare4: return "SQN_SL_PeriodComm_r12_e_spare4";
		case SQN_SL_PeriodComm_r12_e_spare3: return "SQN_SL_PeriodComm_r12_e_spare3";
		case SQN_SL_PeriodComm_r12_e_spare2: return "SQN_SL_PeriodComm_r12_e_spare2";
		case SQN_SL_PeriodComm_r12_e_spare: return "SQN_SL_PeriodComm_r12_e_spare";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_OffsetIndicator_r12_Value(acpCtx_t _ctx, const union SQN_SL_OffsetIndicator_r12_Value* p, enum SQN_SL_OffsetIndicator_r12_Sel d)
{
	if (d == SQN_SL_OffsetIndicator_r12_small_r12) {
		adbgPrintLog(_ctx, "small_r12 := %u", (unsigned int)p->small_r12);
		return;
	}
	if (d == SQN_SL_OffsetIndicator_r12_large_r12) {
		adbgPrintLog(_ctx, "large_r12 := %u", (unsigned int)p->large_r12);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_OffsetIndicator_r12(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicator_r12* p)
{
	_adbgSys__SQN_SL_OffsetIndicator_r12_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SubframeBitmapSL_r12_Value(acpCtx_t _ctx, const union SQN_SubframeBitmapSL_r12_Value* p, enum SQN_SubframeBitmapSL_r12_Sel d)
{
	if (d == SQN_SubframeBitmapSL_r12_bs4_r12) {
		adbgPrintLog(_ctx, "bs4_r12 := '");
		for (size_t i3 = 0; i3 < 4; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs4_r12[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs8_r12) {
		adbgPrintLog(_ctx, "bs8_r12 := '");
		for (size_t i3 = 0; i3 < 8; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs8_r12[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs12_r12) {
		adbgPrintLog(_ctx, "bs12_r12 := '");
		for (size_t i3 = 0; i3 < 12; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs12_r12[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs16_r12) {
		adbgPrintLog(_ctx, "bs16_r12 := '");
		for (size_t i3 = 0; i3 < 16; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs16_r12[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs30_r12) {
		adbgPrintLog(_ctx, "bs30_r12 := '");
		for (size_t i3 = 0; i3 < 30; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs30_r12[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs40_r12) {
		adbgPrintLog(_ctx, "bs40_r12 := '");
		for (size_t i3 = 0; i3 < 40; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs40_r12[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs42_r12) {
		adbgPrintLog(_ctx, "bs42_r12 := '");
		for (size_t i3 = 0; i3 < 42; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs42_r12[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SubframeBitmapSL_r12(acpCtx_t _ctx, const struct SQN_SubframeBitmapSL_r12* p)
{
	_adbgSys__SQN_SubframeBitmapSL_r12_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_TF_ResourceConfig_r12(acpCtx_t _ctx, const struct SQN_SL_TF_ResourceConfig_r12* p)
{
	adbgPrintLog(_ctx, "prb_Num_r12 := %u", (unsigned int)p->prb_Num_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prb_Start_r12 := %u", (unsigned int)p->prb_Start_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prb_End_r12 := %u", (unsigned int)p->prb_End_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "offsetIndicator_r12 := { ");
	_adbgSys__SQN_SL_OffsetIndicator_r12(_ctx, &p->offsetIndicator_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subframeBitmap_r12 := { ");
	_adbgSys__SQN_SubframeBitmapSL_r12(_ctx, &p->subframeBitmap_r12);
	adbgPrintLog(_ctx, " }");
}

static const char* adbgSys__SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e__ToString(SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e v)
{
	switch(v) {
		case SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns1: return "SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns1";
		case SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns2: return "SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns2";
		case SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns4: return "SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns4";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_HoppingConfigComm_r12(acpCtx_t _ctx, const struct SQN_SL_HoppingConfigComm_r12* p)
{
	adbgPrintLog(_ctx, "hoppingParameter_r12 := %u", (unsigned int)p->hoppingParameter_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numSubbands_r12 := %s (%d)", adbgSys__SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e__ToString(p->numSubbands_r12), (int)p->numSubbands_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rb_Offset_r12 := %u", (unsigned int)p->rb_Offset_r12);
}

static void _adbgSys__SQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12(acpCtx_t _ctx, const struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12* p)
{
	adbgPrintLog(_ctx, "data_TF_ResourceConfig_r12 := { ");
	_adbgSys__SQN_SL_TF_ResourceConfig_r12(_ctx, &p->data_TF_ResourceConfig_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "trpt_Subset_r12 := ");
	if (p->trpt_Subset_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional(_ctx, &p->trpt_Subset_r12);
	if (p->trpt_Subset_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_CommResourcePool_r12_rxParametersNCell_r12(acpCtx_t _ctx, const struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12* p)
{
	adbgPrintLog(_ctx, "tdd_Config_r12 := ");
	if (p->tdd_Config_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional(_ctx, &p->tdd_Config_r12);
	if (p->tdd_Config_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncConfigIndex_r12 := %u", (unsigned int)p->syncConfigIndex_r12);
}

static void _adbgSys__SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommResourcePool_r12_rxParametersNCell_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_TxParameters_r12(acpCtx_t _ctx, const struct SQN_SL_TxParameters_r12* p)
{
	adbgPrintLog(_ctx, "alpha_r12 := %s (%d)", adbgSys__SQN_Alpha_r12_e__ToString(p->alpha_r12), (int)p->alpha_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_r12 := %d", (int)p->p0_r12);
}

static void _adbgSys__SQN_SL_CommResourcePool_r12_txParameters_r12(acpCtx_t _ctx, const struct SQN_SL_CommResourcePool_r12_txParameters_r12* p)
{
	adbgPrintLog(_ctx, "sc_TxParameters_r12 := { ");
	_adbgSys__SQN_SL_TxParameters_r12(_ctx, &p->sc_TxParameters_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataTxParameters_r12 := { ");
	_adbgSys__SQN_SL_TxParameters_r12(_ctx, &p->dataTxParameters_r12);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommResourcePool_r12_txParameters_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_CommResourcePool_r12(acpCtx_t _ctx, const struct SQN_SL_CommResourcePool_r12* p)
{
	adbgPrintLog(_ctx, "sc_CP_Len_r12 := %s (%d)", adbgSys__SQN_SL_CP_Len_r12_e__ToString(p->sc_CP_Len_r12), (int)p->sc_CP_Len_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_Period_r12 := %s (%d)", adbgSys__SQN_SL_PeriodComm_r12_e__ToString(p->sc_Period_r12), (int)p->sc_Period_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_TF_ResourceConfig_r12 := { ");
	_adbgSys__SQN_SL_TF_ResourceConfig_r12(_ctx, &p->sc_TF_ResourceConfig_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "data_CP_Len_r12 := %s (%d)", adbgSys__SQN_SL_CP_Len_r12_e__ToString(p->data_CP_Len_r12), (int)p->data_CP_Len_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataHoppingConfig_r12 := { ");
	_adbgSys__SQN_SL_HoppingConfigComm_r12(_ctx, &p->dataHoppingConfig_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ue_SelectedResourceConfig_r12 := ");
	if (p->ue_SelectedResourceConfig_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(_ctx, &p->ue_SelectedResourceConfig_r12);
	if (p->ue_SelectedResourceConfig_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rxParametersNCell_r12 := ");
	if (p->rxParametersNCell_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional(_ctx, &p->rxParametersNCell_r12);
	if (p->rxParametersNCell_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txParameters_r12 := ");
	if (p->txParameters_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional(_ctx, &p->txParameters_r12);
	if (p->txParameters_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "priorityList_r13 := ");
	if (p->priorityList_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional(_ctx, &p->priorityList_r13);
	if (p->priorityList_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CommResourcePool_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CommResourcePool_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__B19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional(acpCtx_t _ctx, const struct B19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < 19; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_SyncConfig_r12_txParameters_r12(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12_txParameters_r12* p)
{
	adbgPrintLog(_ctx, "syncTxParameters_r12 := { ");
	_adbgSys__SQN_SL_TxParameters_r12(_ctx, &p->syncTxParameters_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncTxThreshIC_r12 := %u", (unsigned int)p->syncTxThreshIC_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncInfoReserved_r12 := ");
	_adbgSys__B19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional(_ctx, &p->syncInfoReserved_r12);
}

static void _adbgSys__SQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_SyncConfig_r12_txParameters_r12(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e__ToString(SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e v)
{
	switch(v) {
		case SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e_w1: return "SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e_w1";
		case SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e_w2: return "SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e_w2";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfig_r12_rxParamsNCell_r12(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12* p)
{
	adbgPrintLog(_ctx, "physCellId_r12 := %u", (unsigned int)p->physCellId_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discSyncWindow_r12 := %s (%d)", adbgSys__SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e__ToString(p->discSyncWindow_r12), (int)p->discSyncWindow_r12);
}

static void _adbgSys__SQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_SyncConfig_r12_rxParamsNCell_r12(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e__ToString(SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e v)
{
	switch(v) {
		case SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_true: return "SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SL_SyncConfig_r12_gnss_Sync_r14_e__ToString(SQN_SL_SyncConfig_r12_gnss_Sync_r14_e v)
{
	switch(v) {
		case SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_true: return "SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncConfig_r12_gnss_Sync_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e__ToString(SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e v)
{
	switch(v) {
		case SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_true: return "SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_SyncConfig_r12(acpCtx_t _ctx, const struct SQN_SL_SyncConfig_r12* p)
{
	adbgPrintLog(_ctx, "syncCP_Len_r12 := %s (%d)", adbgSys__SQN_SL_CP_Len_r12_e__ToString(p->syncCP_Len_r12), (int)p->syncCP_Len_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator_r12 := %u", (unsigned int)p->syncOffsetIndicator_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slssid_r12 := %u", (unsigned int)p->slssid_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txParameters_r12 := ");
	if (p->txParameters_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional(_ctx, &p->txParameters_r12);
	if (p->txParameters_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rxParamsNCell_r12 := ");
	if (p->rxParamsNCell_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional(_ctx, &p->rxParamsNCell_r12);
	if (p->rxParamsNCell_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncTxPeriodic_r13 := ");
	_adbgSys__SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(_ctx, &p->syncTxPeriodic_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator_v1430 := ");
	_adbgSys__SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional(_ctx, &p->syncOffsetIndicator_v1430);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "gnss_Sync_r14 := ");
	_adbgSys__SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional(_ctx, &p->gnss_Sync_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator2_r14 := ");
	_adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional(_ctx, &p->syncOffsetIndicator2_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator3_r14 := ");
	_adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional(_ctx, &p->syncOffsetIndicator3_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slss_TxDisabled_r15 := ");
	_adbgSys__SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(_ctx, &p->slss_TxDisabled_r15);
}

static void _adbgSys__SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_SyncConfig_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType18_r12_commConfig_r12(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType18_r12_commConfig_r12* p)
{
	adbgPrintLog(_ctx, "commRxPool_r12 := { ");
	for (size_t i2 = 0; i2 < p->commRxPool_r12.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SL_CommResourcePool_r12(_ctx, &p->commRxPool_r12.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->commRxPool_r12.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commTxPoolNormalCommon_r12 := ");
	if (p->commTxPoolNormalCommon_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional(_ctx, &p->commTxPoolNormalCommon_r12);
	if (p->commTxPoolNormalCommon_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commTxPoolExceptional_r12 := ");
	if (p->commTxPoolExceptional_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional(_ctx, &p->commTxPoolExceptional_r12);
	if (p->commTxPoolExceptional_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commSyncConfig_r12 := ");
	if (p->commSyncConfig_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional(_ctx, &p->commSyncConfig_r12);
	if (p->commSyncConfig_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType18_r12_commConfig_r12(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CommResourcePool_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e__ToString(SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_true: return "SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e__ToString(SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_true: return "SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType18_r12(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType18_r12* p)
{
	adbgPrintLog(_ctx, "commConfig_r12 := ");
	if (p->commConfig_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional(_ctx, &p->commConfig_r12);
	if (p->commConfig_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commTxPoolNormalCommonExt_r13 := ");
	if (p->commTxPoolNormalCommonExt_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional(_ctx, &p->commTxPoolNormalCommonExt_r13);
	if (p->commTxPoolNormalCommonExt_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commTxResourceUC_ReqAllowed_r13 := ");
	_adbgSys__SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional(_ctx, &p->commTxResourceUC_ReqAllowed_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "commTxAllowRelayCommon_r13 := ");
	_adbgSys__SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional(_ctx, &p->commTxAllowRelayCommon_r13);
}

static const char* adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_r12_e__ToString(SQN_SL_DiscResourcePool_r12_discPeriod_r12_e v)
{
	switch(v) {
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf32: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf32";
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf64: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf64";
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf128: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf128";
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf256: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf256";
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf512: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf512";
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf1024: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf1024";
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf16_v1310: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf16_v1310";
		case SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_spare: return "SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_spare";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_PoolSelectionConfig_r12(acpCtx_t _ctx, const struct SQN_SL_PoolSelectionConfig_r12* p)
{
	adbgPrintLog(_ctx, "threshLow_r12 := %u", (unsigned int)p->threshLow_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshHigh_r12 := %u", (unsigned int)p->threshHigh_r12);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value(acpCtx_t _ctx, const union SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value* p, enum SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Sel d)
{
	if (d == SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_rsrpBased_r12) {
		adbgPrintLog(_ctx, "rsrpBased_r12 := { ");
		_adbgSys__SQN_SL_PoolSelectionConfig_r12(_ctx, &p->rsrpBased_r12);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_random_r12) {
		adbgPrintLog(_ctx, "random_r12 := %s", (p->random_r12 ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12* p)
{
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value(_ctx, &p->v, p->d);
}

static const char* adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e__ToString(SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e v)
{
	switch(v) {
		case SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p25: return "SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p25";
		case SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p50: return "SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p50";
		case SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p75: return "SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p75";
		case SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p100: return "SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p100";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12* p)
{
	adbgPrintLog(_ctx, "poolSelection_r12 := { ");
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12(_ctx, &p->poolSelection_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txProbability_r12 := %s (%d)", adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e__ToString(p->txProbability_r12), (int)p->txProbability_r12);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12* p)
{
	adbgPrintLog(_ctx, "txParametersGeneral_r12 := { ");
	_adbgSys__SQN_SL_TxParameters_r12(_ctx, &p->txParametersGeneral_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ue_SelectedResourceConfig_r12 := ");
	if (p->ue_SelectedResourceConfig_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(_ctx, &p->ue_SelectedResourceConfig_r12);
	if (p->ue_SelectedResourceConfig_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_rxParameters_r12(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_rxParameters_r12* p)
{
	adbgPrintLog(_ctx, "tdd_Config_r12 := ");
	if (p->tdd_Config_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional(_ctx, &p->tdd_Config_r12);
	if (p->tdd_Config_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncConfigIndex_r12 := %u", (unsigned int)p->syncConfigIndex_r12);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscResourcePool_r12_rxParameters_r12(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e__ToString(SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e v)
{
	switch(v) {
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf4: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf4";
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf6: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf6";
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf7: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf7";
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf8: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf8";
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf12: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf12";
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf14: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf14";
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf24: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf24";
		case SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf28: return "SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf28";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value(acpCtx_t _ctx, const union SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value* p, enum SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Sel d)
{
	if (d == SQN_SL_DiscResourcePool_r12_discPeriod_v1310_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup) {
		adbgPrintLog(_ctx, "setup := %s (%d)", adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e__ToString(p->setup), (int)p->setup);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310* p)
{
	_adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup* p)
{
	adbgPrintLog(_ctx, "physCellId_r13 := '");
	for (size_t i3 = 0; i3 < p->physCellId_r13.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->physCellId_r13.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value(acpCtx_t _ctx, const union SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value* p, enum SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Sel d)
{
	if (d == SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13* p)
{
	_adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional(acpCtx_t _ctx, const struct SQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config(_ctx, &p->v);
}

static void _adbgSys__SQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config_v1130(_ctx, &p->v);
}

static void _adbgSys__SQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional(acpCtx_t _ctx, const struct SQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e__ToString(SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e v)
{
	switch(v) {
		case SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n6: return "SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n6";
		case SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n15: return "SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n15";
		case SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n25: return "SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n25";
		case SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n50: return "SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n50";
		case SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n75: return "SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n75";
		case SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n100: return "SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n100";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo* p)
{
	adbgPrintLog(_ctx, "ul_CarrierFreq := ");
	_adbgSys__SQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional(_ctx, &p->ul_CarrierFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ul_Bandwidth := ");
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(_ctx, &p->ul_Bandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmission := %u", (unsigned int)p->additionalSpectrumEmission);
}

static void _adbgSys__Uint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup* p)
{
	adbgPrintLog(_ctx, "physCellId_r13 := '");
	for (size_t i3 = 0; i3 < p->physCellId_r13.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->physCellId_r13.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_Max := ");
	_adbgSys__SQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional(_ctx, &p->p_Max);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tdd_Config_r13 := ");
	if (p->tdd_Config_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional(_ctx, &p->tdd_Config_r13);
	if (p->tdd_Config_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tdd_Config_v1130 := ");
	if (p->tdd_Config_v1130.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional(_ctx, &p->tdd_Config_v1130);
	if (p->tdd_Config_v1130.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqInfo := { ");
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo(_ctx, &p->freqInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignalPower := %d", (int)p->referenceSignalPower);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncConfigIndex_r13 := ");
	_adbgSys__Uint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional(_ctx, &p->syncConfigIndex_r13);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value(acpCtx_t _ctx, const union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value* p, enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Sel d)
{
	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13* p)
{
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370* p)
{
	adbgPrintLog(_ctx, "additionalSpectrumEmission_v1370 := %u", (unsigned int)p->additionalSpectrumEmission_v1370);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup* p)
{
	adbgPrintLog(_ctx, "freqInfo_v1370 := { ");
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370(_ctx, &p->freqInfo_v1370);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value(acpCtx_t _ctx, const union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value* p, enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Sel d)
{
	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370* p)
{
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscResourcePool_r12(acpCtx_t _ctx, const struct SQN_SL_DiscResourcePool_r12* p)
{
	adbgPrintLog(_ctx, "cp_Len_r12 := %s (%d)", adbgSys__SQN_SL_CP_Len_r12_e__ToString(p->cp_Len_r12), (int)p->cp_Len_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discPeriod_r12 := %s (%d)", adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_r12_e__ToString(p->discPeriod_r12), (int)p->discPeriod_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numRetx_r12 := %u", (unsigned int)p->numRetx_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numRepetition_r12 := %u", (unsigned int)p->numRepetition_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tf_ResourceConfig_r12 := { ");
	_adbgSys__SQN_SL_TF_ResourceConfig_r12(_ctx, &p->tf_ResourceConfig_r12);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txParameters_r12 := ");
	if (p->txParameters_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional(_ctx, &p->txParameters_r12);
	if (p->txParameters_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rxParameters_r12 := ");
	if (p->rxParameters_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional(_ctx, &p->rxParameters_r12);
	if (p->rxParameters_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discPeriod_v1310 := ");
	if (p->discPeriod_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional(_ctx, &p->discPeriod_v1310);
	if (p->discPeriod_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rxParamsAddNeighFreq_r13 := ");
	if (p->rxParamsAddNeighFreq_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional(_ctx, &p->rxParamsAddNeighFreq_r13);
	if (p->rxParamsAddNeighFreq_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txParamsAddNeighFreq_r13 := ");
	if (p->txParamsAddNeighFreq_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional(_ctx, &p->txParamsAddNeighFreq_r13);
	if (p->txParamsAddNeighFreq_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txParamsAddNeighFreq_v1370 := ");
	if (p->txParamsAddNeighFreq_v1370.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional(_ctx, &p->txParamsAddNeighFreq_v1370);
	if (p->txParamsAddNeighFreq_v1370.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_DiscResourcePool_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_DiscTxPowerInfo_r12(acpCtx_t _ctx, const struct SQN_SL_DiscTxPowerInfo_r12* p)
{
	adbgPrintLog(_ctx, "discMaxTxPower_r12 := %d", (int)p->discMaxTxPower_r12);
}

static void _adbgSys__SQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < 3; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SL_DiscTxPowerInfo_r12(_ctx, &p->v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != 3 - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_SyncConfig_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_r12(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfig_r12* p)
{
	adbgPrintLog(_ctx, "discRxPool_r12 := { ");
	for (size_t i2 = 0; i2 < p->discRxPool_r12.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SL_DiscResourcePool_r12(_ctx, &p->discRxPool_r12.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->discRxPool_r12.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discTxPoolCommon_r12 := ");
	if (p->discTxPoolCommon_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional(_ctx, &p->discTxPoolCommon_r12);
	if (p->discTxPoolCommon_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discTxPowerInfo_r12 := ");
	if (p->discTxPowerInfo_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional(_ctx, &p->discTxPowerInfo_r12);
	if (p->discTxPowerInfo_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discSyncConfig_r12 := ");
	if (p->discSyncConfig_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional(_ctx, &p->discSyncConfig_r12);
	if (p->discSyncConfig_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_PLMN_IdentityInfo2_r12_Value(acpCtx_t _ctx, const union SQN_PLMN_IdentityInfo2_r12_Value* p, enum SQN_PLMN_IdentityInfo2_r12_Sel d)
{
	if (d == SQN_PLMN_IdentityInfo2_r12_plmn_Index_r12) {
		adbgPrintLog(_ctx, "plmn_Index_r12 := %u", (unsigned int)p->plmn_Index_r12);
		return;
	}
	if (d == SQN_PLMN_IdentityInfo2_r12_plmnIdentity_r12) {
		adbgPrintLog(_ctx, "plmnIdentity_r12 := { ");
		_adbgSys__SQN_PLMN_Identity(_ctx, &p->plmnIdentity_r12);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_PLMN_IdentityInfo2_r12(acpCtx_t _ctx, const struct SQN_PLMN_IdentityInfo2_r12* p)
{
	_adbgSys__SQN_PLMN_IdentityInfo2_r12_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional(acpCtx_t _ctx, const struct SQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PLMN_IdentityInfo2_r12(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CarrierFreqInfo_r12(acpCtx_t _ctx, const struct SQN_SL_CarrierFreqInfo_r12* p)
{
	adbgPrintLog(_ctx, "carrierFreq_r12 := %u", (unsigned int)p->carrierFreq_r12);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "plmn_IdentityList_r12 := ");
	if (p->plmn_IdentityList_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional(_ctx, &p->plmn_IdentityList_r12);
	if (p->plmn_IdentityList_r12.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional(acpCtx_t _ctx, const struct SQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CarrierFreqInfo_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_SL_DiscResourcePool_r12(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_DiscTxResourcesInterFreq_r13_Value(acpCtx_t _ctx, const union SQN_SL_DiscTxResourcesInterFreq_r13_Value* p, enum SQN_SL_DiscTxResourcesInterFreq_r13_Sel d)
{
	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_acquireSI_FromCarrier_r13) {
		adbgPrintLog(_ctx, "acquireSI_FromCarrier_r13 := %s", (p->acquireSI_FromCarrier_r13 ? "true" : "false"));
		return;
	}
	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_discTxPoolCommon_r13) {
		adbgPrintLog(_ctx, "discTxPoolCommon_r13 := { ");
		for (size_t i3 = 0; i3 < p->discTxPoolCommon_r13.d; i3++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgSys__SQN_SL_DiscResourcePool_r12(_ctx, &p->discTxPoolCommon_r13.v[i3]);
			adbgPrintLog(_ctx, " }");
			if (i3 != p->discTxPoolCommon_r13.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_requestDedicated_r13) {
		adbgPrintLog(_ctx, "requestDedicated_r13 := %s", (p->requestDedicated_r13 ? "true" : "false"));
		return;
	}
	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_noTxOnCarrier_r13) {
		adbgPrintLog(_ctx, "noTxOnCarrier_r13 := %s", (p->noTxOnCarrier_r13 ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_DiscTxResourcesInterFreq_r13(acpCtx_t _ctx, const struct SQN_SL_DiscTxResourcesInterFreq_r13* p)
{
	_adbgSys__SQN_SL_DiscTxResourcesInterFreq_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscTxResourcesInterFreq_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_ResourcesInterFreq_r13(acpCtx_t _ctx, const struct SQN_SL_ResourcesInterFreq_r13* p)
{
	adbgPrintLog(_ctx, "discRxResourcesInterFreq_r13 := ");
	if (p->discRxResourcesInterFreq_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional(_ctx, &p->discRxResourcesInterFreq_r13);
	if (p->discRxResourcesInterFreq_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discTxResourcesInterFreq_r13 := ");
	if (p->discTxResourcesInterFreq_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional(_ctx, &p->discTxResourcesInterFreq_r13);
	if (p->discTxResourcesInterFreq_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_ResourcesInterFreq_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_ResourcesInterFreq_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < 3; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SL_DiscTxPowerInfo_r12(_ctx, &p->v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != 3 - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e__ToString(SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e v)
{
	switch(v) {
		case SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_pCell: return "SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_pCell";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13* p)
{
	adbgPrintLog(_ctx, "syncCP_Len_r13 := %s (%d)", adbgSys__SQN_SL_CP_Len_r12_e__ToString(p->syncCP_Len_r13), (int)p->syncCP_Len_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator_r13 := %u", (unsigned int)p->syncOffsetIndicator_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slssid_r13 := %u", (unsigned int)p->slssid_r13);
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13(_ctx, &p->v);
}

static void _adbgSys__B19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional(acpCtx_t _ctx, const struct B19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i4 = 0; i4 < 19; i4++) {
		adbgPrintLog(_ctx, "%02X", p->v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e__ToString(SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e v)
{
	switch(v) {
		case SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_true: return "SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13* p)
{
	adbgPrintLog(_ctx, "syncTxParameters_r13 := { ");
	_adbgSys__SQN_SL_TxParameters_r12(_ctx, &p->syncTxParameters_r13);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncTxThreshIC_r13 := %u", (unsigned int)p->syncTxThreshIC_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncInfoReserved_r13 := ");
	_adbgSys__B19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional(_ctx, &p->syncInfoReserved_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncTxPeriodic_r13 := ");
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(_ctx, &p->syncTxPeriodic_r13);
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e__ToString(SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e v)
{
	switch(v) {
		case SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e_w1: return "SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e_w1";
		case SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e_w2: return "SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e_w2";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_rxParameters_r13(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13* p)
{
	adbgPrintLog(_ctx, "discSyncWindow_r13 := %s (%d)", adbgSys__SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e__ToString(p->discSyncWindow_r13), (int)p->discSyncWindow_r13);
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_rxParameters_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e__ToString(SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e v)
{
	switch(v) {
		case SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_true: return "SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e__ToString(SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e v)
{
	switch(v) {
		case SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_true: return "SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_SyncConfigNFreq_r13(acpCtx_t _ctx, const struct SQN_SL_SyncConfigNFreq_r13* p)
{
	adbgPrintLog(_ctx, "asyncParameters_r13 := ");
	if (p->asyncParameters_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional(_ctx, &p->asyncParameters_r13);
	if (p->asyncParameters_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txParameters_r13 := ");
	if (p->txParameters_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional(_ctx, &p->txParameters_r13);
	if (p->txParameters_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rxParameters_r13 := ");
	if (p->rxParameters_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional(_ctx, &p->rxParameters_r13);
	if (p->rxParameters_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator_v1430 := ");
	_adbgSys__SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional(_ctx, &p->syncOffsetIndicator_v1430);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "gnss_Sync_r14 := ");
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional(_ctx, &p->gnss_Sync_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator2_r14 := ");
	_adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional(_ctx, &p->syncOffsetIndicator2_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncOffsetIndicator3_r14 := ");
	_adbgSys__SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional(_ctx, &p->syncOffsetIndicator3_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slss_TxDisabled_r15 := ");
	_adbgSys__SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(_ctx, &p->slss_TxDisabled_r15);
}

static void _adbgSys__SQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_SL_SyncConfigNFreq_r13(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__Uint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e__ToString(SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e v)
{
	switch(v) {
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB0: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB0";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB1: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB1";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB2: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB2";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB3: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB3";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB4: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB4";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB5: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB5";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB6: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB6";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB8: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB8";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB10: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB10";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB12: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB12";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB14: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB14";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB16: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB16";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB18: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB18";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB20: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB20";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB22: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB22";
		case SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB24: return "SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB24";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CellSelectionInfoNFreq_r13(acpCtx_t _ctx, const struct SQN_CellSelectionInfoNFreq_r13* p)
{
	adbgPrintLog(_ctx, "q_RxLevMin_r13 := %d", (int)p->q_RxLevMin_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinOffset := ");
	_adbgSys__Uint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional(_ctx, &p->q_RxLevMinOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_Hyst_r13 := %s (%d)", adbgSys__SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e__ToString(p->q_Hyst_r13), (int)p->q_Hyst_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinReselection_r13 := %d", (int)p->q_RxLevMinReselection_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_r13 := %u", (unsigned int)p->t_ReselectionEUTRA_r13);
}

static void _adbgSys__SQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoNFreq_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13(acpCtx_t _ctx, const struct SQN_SL_DiscConfigOtherInterFreq_r13* p)
{
	adbgPrintLog(_ctx, "txPowerInfo_r13 := ");
	if (p->txPowerInfo_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional(_ctx, &p->txPowerInfo_r13);
	if (p->txPowerInfo_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "refCarrierCommon_r13 := ");
	_adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional(_ctx, &p->refCarrierCommon_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discSyncConfig_r13 := ");
	if (p->discSyncConfig_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional(_ctx, &p->discSyncConfig_r13);
	if (p->discSyncConfig_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discCellSelectionInfo_r13 := ");
	if (p->discCellSelectionInfo_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional(_ctx, &p->discCellSelectionInfo_r13);
	if (p->discCellSelectionInfo_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_CarrierFreqInfo_v1310(acpCtx_t _ctx, const struct SQN_SL_CarrierFreqInfo_v1310* p)
{
	adbgPrintLog(_ctx, "discResourcesNonPS_r13 := ");
	if (p->discResourcesNonPS_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional(_ctx, &p->discResourcesNonPS_r13);
	if (p->discResourcesNonPS_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discResourcesPS_r13 := ");
	if (p->discResourcesPS_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional(_ctx, &p->discResourcesPS_r13);
	if (p->discResourcesPS_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discConfigOther_r13 := ");
	if (p->discConfigOther_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional(_ctx, &p->discConfigOther_r13);
	if (p->discConfigOther_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional(acpCtx_t _ctx, const struct SQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CarrierFreqInfo_v1310(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e__ToString(SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_true: return "SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfig_v1310* p)
{
	adbgPrintLog(_ctx, "discInterFreqList_v1310 := ");
	if (p->discInterFreqList_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional(_ctx, &p->discInterFreqList_v1310);
	if (p->discInterFreqList_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "gapRequestsAllowedCommon := ");
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional(_ctx, &p->gapRequestsAllowedCommon);
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310(_ctx, &p->v);
}

static void _adbgSys__SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional(acpCtx_t _ctx, const struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional(acpCtx_t _ctx, const struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e__ToString(SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e v)
{
	switch(v) {
		case SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB0: return "SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB0";
		case SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB3: return "SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB3";
		case SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB6: return "SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB6";
		case SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB9: return "SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB9";
		case SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB12: return "SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB12";
		case SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dBinf: return "SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dBinf";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e__ToString(SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e v)
{
	switch(v) {
		case SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB0: return "SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB0";
		case SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB3: return "SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB3";
		case SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB6: return "SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB6";
		case SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB9: return "SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB9";
		case SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB12: return "SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB12";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_DiscConfigRelayUE_r13(acpCtx_t _ctx, const struct SQN_SL_DiscConfigRelayUE_r13* p)
{
	adbgPrintLog(_ctx, "threshHigh_r13 := ");
	_adbgSys__SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional(_ctx, &p->threshHigh_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshLow_r13 := ");
	_adbgSys__SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional(_ctx, &p->threshLow_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "hystMax_r13 := ");
	_adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional(_ctx, &p->hystMax_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "hystMin_r13 := ");
	_adbgSys__SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional(_ctx, &p->hystMin_r13);
}

static void _adbgSys__SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional(acpCtx_t _ctx, const struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e__ToString(SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e v)
{
	switch(v) {
		case SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB0: return "SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB0";
		case SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB3: return "SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB3";
		case SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB6: return "SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB6";
		case SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB9: return "SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB9";
		case SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB12: return "SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB12";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_FilterCoefficient_e__ToString(SQN_FilterCoefficient_e v)
{
	switch(v) {
		case SQN_FilterCoefficient_e_fc0: return "SQN_FilterCoefficient_e_fc0";
		case SQN_FilterCoefficient_e_fc1: return "SQN_FilterCoefficient_e_fc1";
		case SQN_FilterCoefficient_e_fc2: return "SQN_FilterCoefficient_e_fc2";
		case SQN_FilterCoefficient_e_fc3: return "SQN_FilterCoefficient_e_fc3";
		case SQN_FilterCoefficient_e_fc4: return "SQN_FilterCoefficient_e_fc4";
		case SQN_FilterCoefficient_e_fc5: return "SQN_FilterCoefficient_e_fc5";
		case SQN_FilterCoefficient_e_fc6: return "SQN_FilterCoefficient_e_fc6";
		case SQN_FilterCoefficient_e_fc7: return "SQN_FilterCoefficient_e_fc7";
		case SQN_FilterCoefficient_e_fc8: return "SQN_FilterCoefficient_e_fc8";
		case SQN_FilterCoefficient_e_fc9: return "SQN_FilterCoefficient_e_fc9";
		case SQN_FilterCoefficient_e_fc11: return "SQN_FilterCoefficient_e_fc11";
		case SQN_FilterCoefficient_e_fc13: return "SQN_FilterCoefficient_e_fc13";
		case SQN_FilterCoefficient_e_fc15: return "SQN_FilterCoefficient_e_fc15";
		case SQN_FilterCoefficient_e_fc17: return "SQN_FilterCoefficient_e_fc17";
		case SQN_FilterCoefficient_e_fc19: return "SQN_FilterCoefficient_e_fc19";
		case SQN_FilterCoefficient_e_spare1: return "SQN_FilterCoefficient_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_ReselectionInfoRelay_r13_minHyst_r13_e__ToString(SQN_ReselectionInfoRelay_r13_minHyst_r13_e v)
{
	switch(v) {
		case SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB0: return "SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB0";
		case SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB3: return "SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB3";
		case SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB6: return "SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB6";
		case SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB9: return "SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB9";
		case SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB12: return "SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB12";
		case SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dBinf: return "SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dBinf";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional(acpCtx_t _ctx, const struct SQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_ReselectionInfoRelay_r13_minHyst_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_ReselectionInfoRelay_r13(acpCtx_t _ctx, const struct SQN_ReselectionInfoRelay_r13* p)
{
	adbgPrintLog(_ctx, "q_RxLevMin_r13 := %d", (int)p->q_RxLevMin_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "filterCoefficient_r13 := %s (%d)", adbgSys__SQN_FilterCoefficient_e__ToString(p->filterCoefficient_r13), (int)p->filterCoefficient_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "minHyst_r13 := ");
	_adbgSys__SQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional(_ctx, &p->minHyst_r13);
}

static void _adbgSys__SQN_SL_DiscConfigRemoteUE_r13(acpCtx_t _ctx, const struct SQN_SL_DiscConfigRemoteUE_r13* p)
{
	adbgPrintLog(_ctx, "threshHigh_r13 := ");
	_adbgSys__SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional(_ctx, &p->threshHigh_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "hystMax_r13 := ");
	_adbgSys__SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional(_ctx, &p->hystMax_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reselectionInfoIC_r13 := { ");
	_adbgSys__SQN_ReselectionInfoRelay_r13(_ctx, &p->reselectionInfoIC_r13);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfigRelay_r13(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13* p)
{
	adbgPrintLog(_ctx, "relayUE_Config_r13 := { ");
	_adbgSys__SQN_SL_DiscConfigRelayUE_r13(_ctx, &p->relayUE_Config_r13);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "remoteUE_Config_r13 := { ");
	_adbgSys__SQN_SL_DiscConfigRemoteUE_r13(_ctx, &p->remoteUE_Config_r13);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfigRelay_r13(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional(acpCtx_t _ctx, const struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_DiscResourcePool_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfigPS_13(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfigPS_13* p)
{
	adbgPrintLog(_ctx, "discRxPoolPS_r13 := { ");
	for (size_t i2 = 0; i2 < p->discRxPoolPS_r13.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SL_DiscResourcePool_r12(_ctx, &p->discRxPoolPS_r13.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->discRxPoolPS_r13.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discTxPoolPS_Common_r13 := ");
	if (p->discTxPoolPS_Common_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional(_ctx, &p->discTxPoolPS_Common_r13);
	if (p->discTxPoolPS_Common_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfigPS_13(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType19_r12(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType19_r12* p)
{
	adbgPrintLog(_ctx, "discConfig_r12 := ");
	if (p->discConfig_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional(_ctx, &p->discConfig_r12);
	if (p->discConfig_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discInterFreqList_r12 := ");
	if (p->discInterFreqList_r12.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional(_ctx, &p->discInterFreqList_r12);
	if (p->discInterFreqList_r12.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discConfig_v1310 := ");
	if (p->discConfig_v1310.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional(_ctx, &p->discConfig_v1310);
	if (p->discConfig_v1310.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discConfigRelay_r13 := ");
	if (p->discConfigRelay_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional(_ctx, &p->discConfigRelay_r13);
	if (p->discConfigRelay_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "discConfigPS_13 := ");
	if (p->discConfigPS_13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional(_ctx, &p->discConfigPS_13);
	if (p->discConfigPS_13.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e__ToString(SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf2: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf2";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf4: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf4";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf8: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf8";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf16: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf16";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf32: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf32";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf64: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf64";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf128: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf128";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf256: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf256";
		default: return "Unknown";
	}
}

static void _adbgSys__Uint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e__ToString(SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf2: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf2";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf4: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf4";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf8: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf8";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf16: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf16";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf32: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf32";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf64: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf64";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf128: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf128";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf256: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf256";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf512: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf512";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf1024: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf1024";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_r2048: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_r2048";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf4096: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf4096";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf8192: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf8192";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf16384: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf16384";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf32768: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf32768";
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf65536: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf65536";
		default: return "Unknown";
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e_rf1: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e_rf1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e_rf1: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e_rf1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r1: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r1";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r2: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r2";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r4: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r4";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r8: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r8";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r16: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r16";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r32: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r32";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r64: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r64";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r128: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r128";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r256: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r256";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v1: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v1";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v1dot5: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v1dot5";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v2: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v2";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v2dot5: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v2dot5";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v4: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v4";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v5: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v5";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v8: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v8";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v10: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v10";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v1: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v1";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v2: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v2";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v4: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v4";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v5: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v5";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v8: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v8";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v10: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v10";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v20: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v20";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value(acpCtx_t _ctx, const union SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value* p, enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Sel d)
{
	if (d == SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14) {
		adbgPrintLog(_ctx, "fdd_r14 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e__ToString(p->fdd_r14), (int)p->fdd_r14);
		return;
	}
	if (d == SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14) {
		adbgPrintLog(_ctx, "tdd_r14 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e__ToString(p->tdd_r14), (int)p->tdd_r14);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14* p)
{
	_adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value(_ctx, &p->v, p->d);
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_off: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_off";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_ce_ModeA: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_ce_ModeA";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_ce_ModeB: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_ce_ModeB";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf32: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf32";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf128: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf128";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf512: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf512";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf1024: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf1024";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf2048: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf2048";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf4096: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf4096";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf8192: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf8192";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf16384: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf16384";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e__ToString(SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf32: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf32";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf128: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf128";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf256: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf256";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf512: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf512";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf1024: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf1024";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf2048: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf2048";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf4096: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf4096";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf8192: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf8192";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf16384: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf16384";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf32768: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf32768";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf65536: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf65536";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf131072: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf131072";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf262144: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf262144";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf524288: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf524288";
		case SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf1048576: return "SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf1048576";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14* p)
{
	adbgPrintLog(_ctx, "dummy := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e__ToString(p->dummy), (int)p->dummy);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy2 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e__ToString(p->dummy2), (int)p->dummy2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_Narrowband_SC_MCCH_r14 := %u", (unsigned int)p->mpdcch_Narrowband_SC_MCCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_NumRepetition_SC_MCCH_r14 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e__ToString(p->mpdcch_NumRepetition_SC_MCCH_r14), (int)p->mpdcch_NumRepetition_SC_MCCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_StartSF_SC_MCCH_r14 := { ");
	_adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14(_ctx, &p->mpdcch_StartSF_SC_MCCH_r14);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e__ToString(p->mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14), (int)p->mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_CarrierFreq_r14 := %u", (unsigned int)p->sc_mcch_CarrierFreq_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_Offset_BR_r14 := %u", (unsigned int)p->sc_mcch_Offset_BR_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_RepetitionPeriod_BR_r14 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e__ToString(p->sc_mcch_RepetitionPeriod_BR_r14), (int)p->sc_mcch_RepetitionPeriod_BR_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_ModificationPeriod_BR_r14 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e__ToString(p->sc_mcch_ModificationPeriod_BR_r14), (int)p->sc_mcch_ModificationPeriod_BR_r14);
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14(_ctx, &p->v);
}

static const char* adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e__ToString(SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e v)
{
	switch(v) {
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf10: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf10";
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf20: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf20";
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf100: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf100";
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf300: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf300";
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf500: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf500";
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1000: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1000";
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1200: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1200";
		case SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1600: return "SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1600";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e__ToString(SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e v)
{
	switch(v) {
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf0: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf0";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf1: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf1";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf2: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf2";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf4: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf4";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf8: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf8";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf16: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf16";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf32: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf32";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf64: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf64";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf128: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf128";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf256: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf256";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_ps512: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_ps512";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf1024: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf1024";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf2048: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf2048";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf4096: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf4096";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf8192: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf8192";
		case SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf16384: return "SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf16384";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value(acpCtx_t _ctx, const union SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value* p, enum SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Sel d)
{
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf10) {
		adbgPrintLog(_ctx, "sf10 := %u", (unsigned int)p->sf10);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf20) {
		adbgPrintLog(_ctx, "sf20 := %u", (unsigned int)p->sf20);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf32) {
		adbgPrintLog(_ctx, "sf32 := %u", (unsigned int)p->sf32);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf40) {
		adbgPrintLog(_ctx, "sf40 := %u", (unsigned int)p->sf40);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf64) {
		adbgPrintLog(_ctx, "sf64 := %u", (unsigned int)p->sf64);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf80) {
		adbgPrintLog(_ctx, "sf80 := %u", (unsigned int)p->sf80);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf128) {
		adbgPrintLog(_ctx, "sf128 := %u", (unsigned int)p->sf128);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf160) {
		adbgPrintLog(_ctx, "sf160 := %u", (unsigned int)p->sf160);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf256) {
		adbgPrintLog(_ctx, "sf256 := %u", (unsigned int)p->sf256);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf320) {
		adbgPrintLog(_ctx, "sf320 := %u", (unsigned int)p->sf320);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf512) {
		adbgPrintLog(_ctx, "sf512 := %u", (unsigned int)p->sf512);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf640) {
		adbgPrintLog(_ctx, "sf640 := %u", (unsigned int)p->sf640);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf1024) {
		adbgPrintLog(_ctx, "sf1024 := %u", (unsigned int)p->sf1024);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf2048) {
		adbgPrintLog(_ctx, "sf2048 := %u", (unsigned int)p->sf2048);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf4096) {
		adbgPrintLog(_ctx, "sf4096 := %u", (unsigned int)p->sf4096);
		return;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf8192) {
		adbgPrintLog(_ctx, "sf8192 := %u", (unsigned int)p->sf8192);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14(acpCtx_t _ctx, const struct SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14* p)
{
	_adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SC_MCCH_SchedulingInfo_r14(acpCtx_t _ctx, const struct SQN_SC_MCCH_SchedulingInfo_r14* p)
{
	adbgPrintLog(_ctx, "onDurationTimerSCPTM_r14 := %s (%d)", adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e__ToString(p->onDurationTimerSCPTM_r14), (int)p->onDurationTimerSCPTM_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "drx_InactivityTimerSCPTM_r14 := %s (%d)", adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e__ToString(p->drx_InactivityTimerSCPTM_r14), (int)p->drx_InactivityTimerSCPTM_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "schedulingPeriodStartOffsetSCPTM_r14 := { ");
	_adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14(_ctx, &p->schedulingPeriodStartOffsetSCPTM_r14);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional(acpCtx_t _ctx, const struct SQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SC_MCCH_SchedulingInfo_r14(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e__ToString(SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_r16: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_r16";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_r32: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_r32";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e__ToString(SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r192: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r192";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r256: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r256";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r384: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r384";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r512: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r512";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r768: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r768";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r1024: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r1024";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r1536: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r1536";
		case SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r2048: return "SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r2048";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e__ToString(SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_rf1: return "SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_rf1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e__ToString(SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_rf1: return "SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_rf1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType20_r13(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType20_r13* p)
{
	adbgPrintLog(_ctx, "sc_mcch_RepetitionPeriod_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e__ToString(p->sc_mcch_RepetitionPeriod_r13), (int)p->sc_mcch_RepetitionPeriod_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_Offset_r13 := %u", (unsigned int)p->sc_mcch_Offset_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_FirstSubframe_r13 := %u", (unsigned int)p->sc_mcch_FirstSubframe_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_duration_r13 := ");
	_adbgSys__Uint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional(_ctx, &p->sc_mcch_duration_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_ModificationPeriod_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e__ToString(p->sc_mcch_ModificationPeriod_r13), (int)p->sc_mcch_ModificationPeriod_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "br_BCCH_Config_r14 := ");
	if (p->br_BCCH_Config_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional(_ctx, &p->br_BCCH_Config_r14);
	if (p->br_BCCH_Config_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_SchedulingInfo_r14 := ");
	if (p->sc_mcch_SchedulingInfo_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional(_ctx, &p->sc_mcch_SchedulingInfo_r14);
	if (p->sc_mcch_SchedulingInfo_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14 := ");
	_adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional(_ctx, &p->pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14 := ");
	_adbgSys__SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional(_ctx, &p->pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_RepetitionPeriod_v1470 := ");
	_adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional(_ctx, &p->sc_mcch_RepetitionPeriod_v1470);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sc_mcch_ModificationPeriod_v1470 := ");
	_adbgSys__SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional(_ctx, &p->sc_mcch_ModificationPeriod_v1470);
}

static void _adbgSys__SQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_OffsetIndicator_r12(_ctx, &p->v);
}

static void _adbgSys__SQN_SubframeBitmapSL_r14_Value(acpCtx_t _ctx, const union SQN_SubframeBitmapSL_r14_Value* p, enum SQN_SubframeBitmapSL_r14_Sel d)
{
	if (d == SQN_SubframeBitmapSL_r14_bs10_r14) {
		adbgPrintLog(_ctx, "bs10_r14 := '");
		for (size_t i3 = 0; i3 < 10; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs10_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs16_r14) {
		adbgPrintLog(_ctx, "bs16_r14 := '");
		for (size_t i3 = 0; i3 < 16; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs16_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs20_r14) {
		adbgPrintLog(_ctx, "bs20_r14 := '");
		for (size_t i3 = 0; i3 < 20; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs20_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs30_r14) {
		adbgPrintLog(_ctx, "bs30_r14 := '");
		for (size_t i3 = 0; i3 < 30; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs30_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs40_r14) {
		adbgPrintLog(_ctx, "bs40_r14 := '");
		for (size_t i3 = 0; i3 < 40; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs40_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs50_r14) {
		adbgPrintLog(_ctx, "bs50_r14 := '");
		for (size_t i3 = 0; i3 < 50; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs50_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs60_r14) {
		adbgPrintLog(_ctx, "bs60_r14 := '");
		for (size_t i3 = 0; i3 < 60; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs60_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs100_r14) {
		adbgPrintLog(_ctx, "bs100_r14 := '");
		for (size_t i3 = 0; i3 < 100; i3++) {
			adbgPrintLog(_ctx, "%02X", p->bs100_r14[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SubframeBitmapSL_r14(acpCtx_t _ctx, const struct SQN_SubframeBitmapSL_r14* p)
{
	_adbgSys__SQN_SubframeBitmapSL_r14_Value(_ctx, &p->v, p->d);
}

static const char* adbgSys__SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e__ToString(SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e v)
{
	switch(v) {
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n4: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n4";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n5: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n5";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n6: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n6";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n8: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n8";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n9: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n9";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n10: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n10";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n12: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n12";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n15: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n15";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n16: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n16";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n18: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n18";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n20: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n20";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n25: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n25";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n30: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n30";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n48: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n48";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n50: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n50";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n72: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n72";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n75: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n75";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n96: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n96";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n100: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n100";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare13: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare13";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare12: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare12";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare11: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare11";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare10: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare10";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare9: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare9";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare8: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare8";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare7: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare7";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare6: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare6";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare5: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare5";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare4: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare4";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare3: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare3";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare2: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare2";
		case SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare1: return "SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e__ToString(SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e v)
{
	switch(v) {
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n1: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n1";
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n3: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n3";
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n5: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n5";
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n8: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n8";
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n10: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n10";
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n15: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n15";
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n20: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n20";
		case SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_spare1: return "SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__Uint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14(acpCtx_t _ctx, const struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14* p)
{
	adbgPrintLog(_ctx, "tdd_Config_r14 := ");
	if (p->tdd_Config_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional(_ctx, &p->tdd_Config_r14);
	if (p->tdd_Config_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncConfigIndex_r14 := %u", (unsigned int)p->syncConfigIndex_r14);
}

static void _adbgSys__SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_TxParameters_r12(_ctx, &p->v);
}

static void _adbgSys__Uint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__Uint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_PPPP_TxConfigIndex_r14(acpCtx_t _ctx, const struct SQN_SL_PPPP_TxConfigIndex_r14* p)
{
	adbgPrintLog(_ctx, "priorityThreshold_r14 := %u", (unsigned int)p->priorityThreshold_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "defaultTxConfigIndex_r14 := %u", (unsigned int)p->defaultTxConfigIndex_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cbr_ConfigIndex_r14 := %u", (unsigned int)p->cbr_ConfigIndex_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tx_ConfigIndexList_r14 := '");
	for (size_t i4 = 0; i4 < p->tx_ConfigIndexList_r14.d; i4++) {
		adbgPrintLog(_ctx, "%02X", p->tx_ConfigIndexList_r14.v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_SL_PPPP_TxConfigIndex_r14(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e__ToString(SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e v)
{
	switch(v) {
		case SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_true: return "SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e__ToString(SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e v)
{
	switch(v) {
		case SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_true: return "SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14(acpCtx_t _ctx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14* p)
{
	adbgPrintLog(_ctx, "partialSensing_r14 := ");
	_adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional(_ctx, &p->partialSensing_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "randomSelection_r14 := ");
	_adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional(_ctx, &p->randomSelection_r14);
}

static void _adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e__ToString(SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e v)
{
	switch(v) {
		case SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_true: return "SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SL_SyncAllowed_r14_enb_Sync_r14_e__ToString(SQN_SL_SyncAllowed_r14_enb_Sync_r14_e v)
{
	switch(v) {
		case SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_true: return "SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncAllowed_r14_enb_Sync_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SL_SyncAllowed_r14_ue_Sync_r14_e__ToString(SQN_SL_SyncAllowed_r14_ue_Sync_r14_e v)
{
	switch(v) {
		case SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_true: return "SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_SyncAllowed_r14_ue_Sync_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_SyncAllowed_r14(acpCtx_t _ctx, const struct SQN_SL_SyncAllowed_r14* p)
{
	adbgPrintLog(_ctx, "gnss_Sync_r14 := ");
	_adbgSys__SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional(_ctx, &p->gnss_Sync_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "enb_Sync_r14 := ");
	_adbgSys__SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional(_ctx, &p->enb_Sync_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ue_Sync_r14 := ");
	_adbgSys__SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional(_ctx, &p->ue_Sync_r14);
}

static void _adbgSys__SQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_SyncAllowed_r14(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_RestrictResourceReservationPeriod_r14_e__ToString(SQN_SL_RestrictResourceReservationPeriod_r14_e v)
{
	switch(v) {
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v0dot2: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v0dot2";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v0dot5: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v0dot5";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v1: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v1";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v2: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v2";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v3: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v3";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v4: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v4";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v5: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v5";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v6: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v6";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v7: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v7";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v8: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v8";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v9: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v9";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_v10: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_v10";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_spare4: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_spare4";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_spare3: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_spare3";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_spare2: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_spare2";
		case SQN_SL_RestrictResourceReservationPeriod_r14_e_spare1: return "SQN_SL_RestrictResourceReservationPeriod_r14_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_RestrictResourceReservationPeriod_r14_e__ToString(p->v.v[i3]), (int)p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_MinT2Value_r15(acpCtx_t _ctx, const struct SQN_SL_MinT2Value_r15* p)
{
	adbgPrintLog(_ctx, "priorityList_r15 := '");
	for (size_t i4 = 0; i4 < p->priorityList_r15.d; i4++) {
		adbgPrintLog(_ctx, "%02X", p->priorityList_r15.v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "minT2Value_r15 := %u", (unsigned int)p->minT2Value_r15);
}

static void _adbgSys__SQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_SL_MinT2Value_r15(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_MCS_PSSCH_Range_r15(acpCtx_t _ctx, const struct SQN_MCS_PSSCH_Range_r15* p)
{
	adbgPrintLog(_ctx, "minMCS_PSSCH_r15 := %u", (unsigned int)p->minMCS_PSSCH_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxMCS_PSSCH_r15 := %u", (unsigned int)p->maxMCS_PSSCH_r15);
}

static void _adbgSys__SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional(acpCtx_t _ctx, const struct SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_MCS_PSSCH_Range_r15(_ctx, &p->v.v[i4]);
		adbgPrintLog(_ctx, " }");
		if (i4 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_PPPP_TxConfigIndex_v1530(acpCtx_t _ctx, const struct SQN_SL_PPPP_TxConfigIndex_v1530* p)
{
	adbgPrintLog(_ctx, "mcs_PSSCH_RangeList_r15 := ");
	if (p->mcs_PSSCH_RangeList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional(_ctx, &p->mcs_PSSCH_RangeList_r15);
	if (p->mcs_PSSCH_RangeList_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional(acpCtx_t _ctx, const struct SQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_SL_PPPP_TxConfigIndex_v1530(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommResourcePoolV2X_r14(acpCtx_t _ctx, const struct SQN_SL_CommResourcePoolV2X_r14* p)
{
	adbgPrintLog(_ctx, "sl_OffsetIndicator_r14 := ");
	if (p->sl_OffsetIndicator_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional(_ctx, &p->sl_OffsetIndicator_r14);
	if (p->sl_OffsetIndicator_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_Subframe_r14 := { ");
	_adbgSys__SQN_SubframeBitmapSL_r14(_ctx, &p->sl_Subframe_r14);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "adjacencyPSCCH_PSSCH_r14 := %s", (p->adjacencyPSCCH_PSSCH_r14 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sizeSubchannel_r14 := %s (%d)", adbgSys__SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e__ToString(p->sizeSubchannel_r14), (int)p->sizeSubchannel_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numSubchannel_r14 := %s (%d)", adbgSys__SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e__ToString(p->numSubchannel_r14), (int)p->numSubchannel_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startRB_Subchannel_r14 := %u", (unsigned int)p->startRB_Subchannel_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startRB_PSCCH_Pool_r14 := ");
	_adbgSys__Uint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional(_ctx, &p->startRB_PSCCH_Pool_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rxParametersNCell_r14 := ");
	if (p->rxParametersNCell_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional(_ctx, &p->rxParametersNCell_r14);
	if (p->rxParametersNCell_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataTxParameters_r14 := ");
	if (p->dataTxParameters_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional(_ctx, &p->dataTxParameters_r14);
	if (p->dataTxParameters_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zoneID_r14 := ");
	_adbgSys__Uint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional(_ctx, &p->zoneID_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshS_RSSI_CBR_r14 := ");
	_adbgSys__Uint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional(_ctx, &p->threshS_RSSI_CBR_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "poolReportId_r14 := ");
	_adbgSys__SQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional(_ctx, &p->poolReportId_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cbr_pssch_TxConfigList_r14 := ");
	if (p->cbr_pssch_TxConfigList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional(_ctx, &p->cbr_pssch_TxConfigList_r14);
	if (p->cbr_pssch_TxConfigList_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceSelectionConfigP2X_r14 := ");
	if (p->resourceSelectionConfigP2X_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional(_ctx, &p->resourceSelectionConfigP2X_r14);
	if (p->resourceSelectionConfigP2X_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncAllowed_r14 := ");
	if (p->syncAllowed_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional(_ctx, &p->syncAllowed_r14);
	if (p->syncAllowed_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "restrictResourceReservationPeriod_r14 := ");
	if (p->restrictResourceReservationPeriod_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional(_ctx, &p->restrictResourceReservationPeriod_r14);
	if (p->restrictResourceReservationPeriod_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_MinT2ValueList_r15 := ");
	if (p->sl_MinT2ValueList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional(_ctx, &p->sl_MinT2ValueList_r15);
	if (p->sl_MinT2ValueList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cbr_pssch_TxConfigList_v1530 := ");
	if (p->cbr_pssch_TxConfigList_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional(_ctx, &p->cbr_pssch_TxConfigList_v1530);
	if (p->cbr_pssch_TxConfigList_v1530.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_SyncConfig_r12(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e__ToString(SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e v)
{
	switch(v) {
		case SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e_reserved: return "SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e_reserved";
		case SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e_notReserved: return "SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e_notReserved";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_PLMN_IdentityInfo(acpCtx_t _ctx, const struct SQN_PLMN_IdentityInfo* p)
{
	adbgPrintLog(_ctx, "plmn_Identity := { ");
	_adbgSys__SQN_PLMN_Identity(_ctx, &p->plmn_Identity);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReservedForOperatorUse := %s (%d)", adbgSys__SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e__ToString(p->cellReservedForOperatorUse), (int)p->cellReservedForOperatorUse);
}

static void _adbgSys__SQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional(acpCtx_t _ctx, const struct SQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_PLMN_IdentityInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional(acpCtx_t _ctx, const struct SQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static const char* adbgSys__SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e__ToString(SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e v)
{
	switch(v) {
		case SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n6: return "SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n6";
		case SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n15: return "SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n15";
		case SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n25: return "SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n25";
		case SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n50: return "SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n50";
		case SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n75: return "SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n75";
		case SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n100: return "SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n100";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional(acpCtx_t _ctx, const struct SQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SL_TypeTxSync_r14_e__ToString(SQN_SL_TypeTxSync_r14_e v)
{
	switch(v) {
		case SQN_SL_TypeTxSync_r14_e_gnss: return "SQN_SL_TypeTxSync_r14_e_gnss";
		case SQN_SL_TypeTxSync_r14_e_enb: return "SQN_SL_TypeTxSync_r14_e_enb";
		case SQN_SL_TypeTxSync_r14_e_ue: return "SQN_SL_TypeTxSync_r14_e_ue";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_TypeTxSync_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_adbgSys__SQN_SL_SyncConfigNFreq_r13(_ctx, &p->v.v[i4]);
		if (i4 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v.v[i4]);
		if (i4 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v.v[i4]);
		if (i4 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v.v[i4]);
		if (i4 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_TypeTxSync_r14_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e__ToString(SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e v)
{
	switch(v) {
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph60: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph60";
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph80: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph80";
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph100: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph100";
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph120: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph120";
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph140: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph140";
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph160: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph160";
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph180: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph180";
		case SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph200: return "SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph200";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e__ToString(SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e v)
{
	switch(v) {
		case SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_n0: return "SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_n0";
		case SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_n1: return "SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_n1";
		case SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_both: return "SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_both";
		case SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_spare1: return "SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_TxPower_r14_Value(acpCtx_t _ctx, const union SQN_SL_TxPower_r14_Value* p, enum SQN_SL_TxPower_r14_Sel d)
{
	if (d == SQN_SL_TxPower_r14_minusinfinity_r14) {
		adbgPrintLog(_ctx, "minusinfinity_r14 := %s", (p->minusinfinity_r14 ? "true" : "false"));
		return;
	}
	if (d == SQN_SL_TxPower_r14_txPower_r14) {
		adbgPrintLog(_ctx, "txPower_r14 := %d", (int)p->txPower_r14);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_TxPower_r14(acpCtx_t _ctx, const struct SQN_SL_TxPower_r14* p)
{
	_adbgSys__SQN_SL_TxPower_r14_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_TxPower_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_PSSCH_TxParameters_r14(acpCtx_t _ctx, const struct SQN_SL_PSSCH_TxParameters_r14* p)
{
	adbgPrintLog(_ctx, "minMCS_PSSCH_r14 := %u", (unsigned int)p->minMCS_PSSCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxMCS_PSSCH_r14 := %u", (unsigned int)p->maxMCS_PSSCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "minSubChannel_NumberPSSCH_r14 := %u", (unsigned int)p->minSubChannel_NumberPSSCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxSubchannel_NumberPSSCH_r14 := %u", (unsigned int)p->maxSubchannel_NumberPSSCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedRetxNumberPSSCH_r14 := %s (%d)", adbgSys__SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e__ToString(p->allowedRetxNumberPSSCH_r14), (int)p->allowedRetxNumberPSSCH_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxTxPower_r14 := ");
	if (p->maxTxPower_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional(_ctx, &p->maxTxPower_r14);
	if (p->maxTxPower_r14.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_PSSCH_TxParameters_v1530(acpCtx_t _ctx, const struct SQN_SL_PSSCH_TxParameters_v1530* p)
{
	adbgPrintLog(_ctx, "minMCS_PSSCH_r15 := %u", (unsigned int)p->minMCS_PSSCH_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxMCS_PSSCH_r15 := %u", (unsigned int)p->maxMCS_PSSCH_r15);
}

static void _adbgSys__SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional(acpCtx_t _ctx, const struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_PSSCH_TxParameters_v1530(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional(acpCtx_t _ctx, const struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_PSSCH_TxParameters_v1530(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_PSSCH_TxConfig_r14(acpCtx_t _ctx, const struct SQN_SL_PSSCH_TxConfig_r14* p)
{
	adbgPrintLog(_ctx, "typeTxSync_r14 := ");
	_adbgSys__SQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional(_ctx, &p->typeTxSync_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresUE_Speed_r14 := %s (%d)", adbgSys__SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e__ToString(p->thresUE_Speed_r14), (int)p->thresUE_Speed_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parametersAboveThres_r14 := { ");
	_adbgSys__SQN_SL_PSSCH_TxParameters_r14(_ctx, &p->parametersAboveThres_r14);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parametersBelowThres_r14 := { ");
	_adbgSys__SQN_SL_PSSCH_TxParameters_r14(_ctx, &p->parametersBelowThres_r14);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parametersAboveThres_v1530 := ");
	if (p->parametersAboveThres_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional(_ctx, &p->parametersAboveThres_v1530);
	if (p->parametersAboveThres_v1530.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "parametersBelowThres_v1530 := ");
	if (p->parametersBelowThres_v1530.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional(_ctx, &p->parametersBelowThres_v1530);
	if (p->parametersBelowThres_v1530.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_RestrictResourceReservationPeriod_r14_e__ToString(p->v.v[i4]), (int)p->v.v[i4]);
		if (i4 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e__ToString(SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e v)
{
	switch(v) {
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0";
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot2: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot2";
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot4: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot4";
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot6: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot6";
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot8: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot8";
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare3: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare3";
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare2: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare2";
		case SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare1: return "SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14* p)
{
	adbgPrintLog(_ctx, "minNumCandidateSF_r14 := %u", (unsigned int)p->minNumCandidateSF_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "gapCandidateSensing_r14 := '");
	for (size_t i4 = 0; i4 < 10; i4++) {
		adbgPrintLog(_ctx, "%02X", p->gapCandidateSensing_r14[i4]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e__ToString(SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e v)
{
	switch(v) {
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n1: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n1";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n2: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n2";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n3: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n3";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n4: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n4";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n5: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n5";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n6: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n6";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n7: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n7";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n8: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n8";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n9: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n9";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare7: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare7";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare6: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare6";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare5: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare5";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare4: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare4";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare3: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare3";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare2: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare2";
		case SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare1: return "SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_CommTxPoolSensingConfig_r14(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolSensingConfig_r14* p)
{
	adbgPrintLog(_ctx, "pssch_TxConfigList_r14 := { ");
	for (size_t i4 = 0; i4 < p->pssch_TxConfigList_r14.d; i4++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SL_PSSCH_TxConfig_r14(_ctx, &p->pssch_TxConfigList_r14.v[i4]);
		adbgPrintLog(_ctx, " }");
		if (i4 != p->pssch_TxConfigList_r14.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresPSSCH_RSRP_List_r14 := '");
	for (size_t i4 = 0; i4 < 64; i4++) {
		adbgPrintLog(_ctx, "%02X", p->thresPSSCH_RSRP_List_r14[i4]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "restrictResourceReservationPeriod_r14 := ");
	if (p->restrictResourceReservationPeriod_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional(_ctx, &p->restrictResourceReservationPeriod_r14);
	if (p->restrictResourceReservationPeriod_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "probResourceKeep_r14 := %s (%d)", adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e__ToString(p->probResourceKeep_r14), (int)p->probResourceKeep_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p2x_SensingConfig_r14 := ");
	if (p->p2x_SensingConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional(_ctx, &p->p2x_SensingConfig_r14);
	if (p->p2x_SensingConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_ReselectAfter_r14 := ");
	_adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional(_ctx, &p->sl_ReselectAfter_r14);
}

static void _adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommTxPoolSensingConfig_r14(_ctx, &p->v);
}

static const char* adbgSys__SQN_SL_ZoneConfig_r14_zoneLength_r14_e__ToString(SQN_SL_ZoneConfig_r14_zoneLength_r14_e v)
{
	switch(v) {
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m5: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m5";
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m10: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m10";
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m20: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m20";
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m50: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m50";
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m100: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m100";
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m200: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m200";
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m500: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m500";
		case SQN_SL_ZoneConfig_r14_zoneLength_r14_e_spare1: return "SQN_SL_ZoneConfig_r14_zoneLength_r14_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SL_ZoneConfig_r14_zoneWidth_r14_e__ToString(SQN_SL_ZoneConfig_r14_zoneWidth_r14_e v)
{
	switch(v) {
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m5: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m5";
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m10: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m10";
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m20: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m20";
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m50: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m50";
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m100: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m100";
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m200: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m200";
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m500: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m500";
		case SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_spare1: return "SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SL_ZoneConfig_r14(acpCtx_t _ctx, const struct SQN_SL_ZoneConfig_r14* p)
{
	adbgPrintLog(_ctx, "zoneLength_r14 := %s (%d)", adbgSys__SQN_SL_ZoneConfig_r14_zoneLength_r14_e__ToString(p->zoneLength_r14), (int)p->zoneLength_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zoneWidth_r14 := %s (%d)", adbgSys__SQN_SL_ZoneConfig_r14_zoneWidth_r14_e__ToString(p->zoneWidth_r14), (int)p->zoneWidth_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zoneIdLongiMod_r14 := %u", (unsigned int)p->zoneIdLongiMod_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zoneIdLatiMod_r14 := %u", (unsigned int)p->zoneIdLatiMod_r14);
}

static void _adbgSys__SQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_ZoneConfig_r14(_ctx, &p->v);
}

static void _adbgSys__Uint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_V2X_InterFreqUE_Config_r14(acpCtx_t _ctx, const struct SQN_SL_V2X_InterFreqUE_Config_r14* p)
{
	adbgPrintLog(_ctx, "physCellIdList_r14 := ");
	if (p->physCellIdList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional(_ctx, &p->physCellIdList_r14);
	if (p->physCellIdList_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "typeTxSync_r14 := ");
	_adbgSys__SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional(_ctx, &p->typeTxSync_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_SyncConfig_r14 := ");
	if (p->v2x_SyncConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional(_ctx, &p->v2x_SyncConfig_r14);
	if (p->v2x_SyncConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_CommRxPool_r14 := ");
	if (p->v2x_CommRxPool_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional(_ctx, &p->v2x_CommRxPool_r14);
	if (p->v2x_CommRxPool_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_CommTxPoolNormal_r14 := ");
	if (p->v2x_CommTxPoolNormal_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional(_ctx, &p->v2x_CommTxPoolNormal_r14);
	if (p->v2x_CommTxPoolNormal_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p2x_CommTxPoolNormal_r14 := ");
	if (p->p2x_CommTxPoolNormal_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional(_ctx, &p->p2x_CommTxPoolNormal_r14);
	if (p->p2x_CommTxPoolNormal_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_CommTxPoolExceptional_r14 := ");
	if (p->v2x_CommTxPoolExceptional_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional(_ctx, &p->v2x_CommTxPoolExceptional_r14);
	if (p->v2x_CommTxPoolExceptional_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_ResourceSelectionConfig_r14 := ");
	if (p->v2x_ResourceSelectionConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional(_ctx, &p->v2x_ResourceSelectionConfig_r14);
	if (p->v2x_ResourceSelectionConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zoneConfig_r14 := ");
	if (p->zoneConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional(_ctx, &p->zoneConfig_r14);
	if (p->zoneConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "offsetDFN_r14 := ");
	_adbgSys__Uint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional(_ctx, &p->offsetDFN_r14);
}

static void _adbgSys__SQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_SL_V2X_InterFreqUE_Config_r14(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value(acpCtx_t _ctx, const union SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value* p, enum SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Sel d)
{
	if (d == SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmission_r14) {
		adbgPrintLog(_ctx, "additionalSpectrumEmission_r14 := %u", (unsigned int)p->additionalSpectrumEmission_r14);
		return;
	}
	if (d == SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmission_v1440) {
		adbgPrintLog(_ctx, "additionalSpectrumEmission_v1440 := %u", (unsigned int)p->additionalSpectrumEmission_v1440);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14(acpCtx_t _ctx, const struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14* p)
{
	_adbgSys__SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_V2X_FreqSelectionConfig_r15(acpCtx_t _ctx, const struct SQN_SL_V2X_FreqSelectionConfig_r15* p)
{
	adbgPrintLog(_ctx, "priorityList_r15 := '");
	for (size_t i4 = 0; i4 < p->priorityList_r15.d; i4++) {
		adbgPrintLog(_ctx, "%02X", p->priorityList_r15.v[i4]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshCBR_FreqReselection_r15 := ");
	_adbgSys__SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional(_ctx, &p->threshCBR_FreqReselection_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshCBR_FreqKeeping_r15 := ");
	_adbgSys__SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional(_ctx, &p->threshCBR_FreqKeeping_r15);
}

static void _adbgSys__SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_SL_V2X_FreqSelectionConfig_r15(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_InterFreqInfoV2X_r14(acpCtx_t _ctx, const struct SQN_SL_InterFreqInfoV2X_r14* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityList_r14 := ");
	if (p->plmn_IdentityList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional(_ctx, &p->plmn_IdentityList_r14);
	if (p->plmn_IdentityList_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_CommCarrierFreq_r14 := %u", (unsigned int)p->v2x_CommCarrierFreq_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_MaxTxPower_r14 := ");
	_adbgSys__SQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional(_ctx, &p->sl_MaxTxPower_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_Bandwidth_r14 := ");
	_adbgSys__SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional(_ctx, &p->sl_Bandwidth_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_SchedulingPool_r14 := ");
	if (p->v2x_SchedulingPool_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional(_ctx, &p->v2x_SchedulingPool_r14);
	if (p->v2x_SchedulingPool_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_UE_ConfigList_r14 := ");
	if (p->v2x_UE_ConfigList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional(_ctx, &p->v2x_UE_ConfigList_r14);
	if (p->v2x_UE_ConfigList_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmissionV2X_r14 := ");
	if (p->additionalSpectrumEmissionV2X_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional(_ctx, &p->additionalSpectrumEmissionV2X_r14);
	if (p->additionalSpectrumEmissionV2X_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_FreqSelectionConfigList_r15 := ");
	if (p->v2x_FreqSelectionConfigList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional(_ctx, &p->v2x_FreqSelectionConfigList_r15);
	if (p->v2x_FreqSelectionConfigList_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_InterFreqInfoV2X_r14(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CommTxPoolSensingConfig_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_ZoneConfig_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SL_TypeTxSync_r14_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__Uint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SL_CBR_PSSCH_TxConfig_r14(acpCtx_t _ctx, const struct SQN_SL_CBR_PSSCH_TxConfig_r14* p)
{
	adbgPrintLog(_ctx, "cr_Limit_r14 := %u", (unsigned int)p->cr_Limit_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tx_Parameters_r14 := { ");
	_adbgSys__SQN_SL_PSSCH_TxParameters_r14(_ctx, &p->tx_Parameters_r14);
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SL_CBR_CommonTxConfigList_r14(acpCtx_t _ctx, const struct SQN_SL_CBR_CommonTxConfigList_r14* p)
{
	adbgPrintLog(_ctx, "cbr_RangeCommonConfigList_r14 := { ");
	for (size_t i2 = 0; i2 < p->cbr_RangeCommonConfigList_r14.d; i2++) {
		adbgPrintLog(_ctx, "'");
		for (size_t i3 = 0; i3 < p->cbr_RangeCommonConfigList_r14.v[i2].d; i3++) {
			adbgPrintLog(_ctx, "%02X", p->cbr_RangeCommonConfigList_r14.v[i2].v[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		if (i2 != p->cbr_RangeCommonConfigList_r14.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_CBR_PSSCH_TxConfigList_r14 := { ");
	for (size_t i2 = 0; i2 < p->sl_CBR_PSSCH_TxConfigList_r14.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SL_CBR_PSSCH_TxConfig_r14(_ctx, &p->sl_CBR_PSSCH_TxConfigList_r14.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->sl_CBR_PSSCH_TxConfigList_r14.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_CBR_CommonTxConfigList_r14(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_V2X_ConfigCommon_r14(acpCtx_t _ctx, const struct SQN_SL_V2X_ConfigCommon_r14* p)
{
	adbgPrintLog(_ctx, "v2x_CommRxPool_r14 := ");
	if (p->v2x_CommRxPool_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional(_ctx, &p->v2x_CommRxPool_r14);
	if (p->v2x_CommRxPool_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_CommTxPoolNormalCommon_r14 := ");
	if (p->v2x_CommTxPoolNormalCommon_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional(_ctx, &p->v2x_CommTxPoolNormalCommon_r14);
	if (p->v2x_CommTxPoolNormalCommon_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p2x_CommTxPoolNormalCommon_r14 := ");
	if (p->p2x_CommTxPoolNormalCommon_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional(_ctx, &p->p2x_CommTxPoolNormalCommon_r14);
	if (p->p2x_CommTxPoolNormalCommon_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_CommTxPoolExceptional_r14 := ");
	if (p->v2x_CommTxPoolExceptional_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional(_ctx, &p->v2x_CommTxPoolExceptional_r14);
	if (p->v2x_CommTxPoolExceptional_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_SyncConfig_r14 := ");
	if (p->v2x_SyncConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional(_ctx, &p->v2x_SyncConfig_r14);
	if (p->v2x_SyncConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_InterFreqInfoList_r14 := ");
	if (p->v2x_InterFreqInfoList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional(_ctx, &p->v2x_InterFreqInfoList_r14);
	if (p->v2x_InterFreqInfoList_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_ResourceSelectionConfig_r14 := ");
	if (p->v2x_ResourceSelectionConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional(_ctx, &p->v2x_ResourceSelectionConfig_r14);
	if (p->v2x_ResourceSelectionConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zoneConfig_r14 := ");
	if (p->zoneConfig_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional(_ctx, &p->zoneConfig_r14);
	if (p->zoneConfig_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "typeTxSync_r14 := ");
	_adbgSys__SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional(_ctx, &p->typeTxSync_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresSL_TxPrioritization_r14 := ");
	_adbgSys__SQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional(_ctx, &p->thresSL_TxPrioritization_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "anchorCarrierFreqList_r14 := ");
	if (p->anchorCarrierFreqList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional(_ctx, &p->anchorCarrierFreqList_r14);
	if (p->anchorCarrierFreqList_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "offsetDFN_r14 := ");
	_adbgSys__Uint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional(_ctx, &p->offsetDFN_r14);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cbr_CommonTxConfigList_r14 := ");
	if (p->cbr_CommonTxConfigList_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional(_ctx, &p->cbr_CommonTxConfigList_r14);
	if (p->cbr_CommonTxConfigList_r14.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional(acpCtx_t _ctx, const struct SQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_V2X_ConfigCommon_r14(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional(acpCtx_t _ctx, const struct SQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType21_r14(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType21_r14* p)
{
	adbgPrintLog(_ctx, "sl_V2X_ConfigCommon_r14 := ");
	if (p->sl_V2X_ConfigCommon_r14.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional(_ctx, &p->sl_V2X_ConfigCommon_r14);
	if (p->sl_V2X_ConfigCommon_r14.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "anchorCarrierFreqListNR_r16 := ");
	if (p->anchorCarrierFreqListNR_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional(_ctx, &p->anchorCarrierFreqListNR_r16);
	if (p->anchorCarrierFreqListNR_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional(acpCtx_t _ctx, const struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional(acpCtx_t _ctx, const struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional(acpCtx_t _ctx, const struct SQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MTC_SSB_NR_r15(_ctx, &p->v);
}

static const char* adbgSys__SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e__ToString(SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e v)
{
	switch(v) {
		case SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz15: return "SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz15";
		case SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz30: return "SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz30";
		case SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz120: return "SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz120";
		case SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz240: return "SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz240";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional(acpCtx_t _ctx, const struct SQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SS_RSSI_Measurement_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional(acpCtx_t _ctx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CellReselectionSubPriority_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CarrierFreqNR_r15_threshX_Q_r15(acpCtx_t _ctx, const struct SQN_CarrierFreqNR_r15_threshX_Q_r15* p)
{
	adbgPrintLog(_ctx, "threshX_HighQ_r15 := %u", (unsigned int)p->threshX_HighQ_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowQ_r15 := %u", (unsigned int)p->threshX_LowQ_r15);
}

static void _adbgSys__SQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CarrierFreqNR_r15_threshX_Q_r15(_ctx, &p->v);
}

static void _adbgSys__Int8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional(acpCtx_t _ctx, const struct int8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional(acpCtx_t _ctx, const struct SQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_NS_PmaxValueNR_r15(acpCtx_t _ctx, const struct SQN_NS_PmaxValueNR_r15* p)
{
	adbgPrintLog(_ctx, "additionalPmaxNR_r15 := ");
	_adbgSys__SQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional(_ctx, &p->additionalPmaxNR_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmissionNR_r15 := %u", (unsigned int)p->additionalSpectrumEmissionNR_r15);
}

static void _adbgSys__SQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional(acpCtx_t _ctx, const struct SQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgSys__SQN_NS_PmaxValueNR_r15(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__Int8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional(acpCtx_t _ctx, const struct int8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgSys__SQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional(acpCtx_t _ctx, const struct SQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional(acpCtx_t _ctx, const struct SQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ThresholdListNR_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional(acpCtx_t _ctx, const struct SQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		for (size_t i4 = 0; i4 < p->v.v[i3].d; i4++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgSys__SQN_NS_PmaxValueNR_r15(_ctx, &p->v.v[i3].v[i4]);
			adbgPrintLog(_ctx, " }");
			if (i4 != p->v.v[i3].d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional(acpCtx_t _ctx, const struct SQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		for (size_t i4 = 0; i4 < p->v.v[i3].d; i4++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgSys__SQN_NS_PmaxValueNR_r15(_ctx, &p->v.v[i3].v[i4]);
			adbgPrintLog(_ctx, " }");
			if (i4 != p->v.v[i3].d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional(acpCtx_t _ctx, const struct SQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SSB_ToMeasure_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_CarrierFreqNR_r15(acpCtx_t _ctx, const struct SQN_CarrierFreqNR_r15* p)
{
	adbgPrintLog(_ctx, "carrierFreq_r15 := %u", (unsigned int)p->carrierFreq_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multiBandInfoList_r15 := ");
	if (p->multiBandInfoList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional(_ctx, &p->multiBandInfoList_r15);
	if (p->multiBandInfoList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multiBandInfoListSUL_r15 := ");
	if (p->multiBandInfoListSUL_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional(_ctx, &p->multiBandInfoListSUL_r15);
	if (p->multiBandInfoListSUL_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measTimingConfig_r15 := ");
	if (p->measTimingConfig_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional(_ctx, &p->measTimingConfig_r15);
	if (p->measTimingConfig_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subcarrierSpacingSSB_r15 := %s (%d)", adbgSys__SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e__ToString(p->subcarrierSpacingSSB_r15), (int)p->subcarrierSpacingSSB_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ss_RSSI_Measurement_r15 := ");
	if (p->ss_RSSI_Measurement_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional(_ctx, &p->ss_RSSI_Measurement_r15);
	if (p->ss_RSSI_Measurement_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority_r15 := ");
	_adbgSys__SQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional(_ctx, &p->cellReselectionPriority_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionSubPriority_r15 := ");
	_adbgSys__SQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional(_ctx, &p->cellReselectionSubPriority_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High_r15 := %u", (unsigned int)p->threshX_High_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low_r15 := %u", (unsigned int)p->threshX_Low_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Q_r15 := ");
	if (p->threshX_Q_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional(_ctx, &p->threshX_Q_r15);
	if (p->threshX_Q_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin_r15 := %d", (int)p->q_RxLevMin_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinSUL_r15 := ");
	_adbgSys__Int8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional(_ctx, &p->q_RxLevMinSUL_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_MaxNR_r15 := %d", (int)p->p_MaxNR_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ns_PmaxListNR_r15 := ");
	if (p->ns_PmaxListNR_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional(_ctx, &p->ns_PmaxListNR_r15);
	if (p->ns_PmaxListNR_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin_r15 := ");
	_adbgSys__Int8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional(_ctx, &p->q_QualMin_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deriveSSB_IndexFromCell_r15 := %s", (p->deriveSSB_IndexFromCell_r15 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxRS_IndexCellQual_r15 := ");
	_adbgSys__SQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional(_ctx, &p->maxRS_IndexCellQual_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshRS_Index_r15 := ");
	if (p->threshRS_Index_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional(_ctx, &p->threshRS_Index_r15);
	if (p->threshRS_Index_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multiBandNsPmaxListNR_v1550 := ");
	if (p->multiBandNsPmaxListNR_v1550.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional(_ctx, &p->multiBandNsPmaxListNR_v1550);
	if (p->multiBandNsPmaxListNR_v1550.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multiBandNsPmaxListNR_SUL_v1550 := ");
	if (p->multiBandNsPmaxListNR_SUL_v1550.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional(_ctx, &p->multiBandNsPmaxListNR_SUL_v1550);
	if (p->multiBandNsPmaxListNR_SUL_v1550.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_ToMeasure_r15 := ");
	if (p->ssb_ToMeasure_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional(_ctx, &p->ssb_ToMeasure_r15);
	if (p->ssb_ToMeasure_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqNR_r15(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional(acpCtx_t _ctx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e__ToString(SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e v)
{
	switch(v) {
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf10: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf10";
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf20: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf20";
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf40: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf40";
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf80: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf80";
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf160: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf160";
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare3: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare3";
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare2: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare2";
		case SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare1: return "SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_MTC_SSB2_LP_NR_r16(acpCtx_t _ctx, const struct SQN_MTC_SSB2_LP_NR_r16* p)
{
	adbgPrintLog(_ctx, "pci_List_r16 := ");
	_adbgSys__SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional(_ctx, &p->pci_List_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicity_r16 := %s (%d)", adbgSys__SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e__ToString(p->periodicity_r16), (int)p->periodicity_r16);
}

static void _adbgSys__SQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional(acpCtx_t _ctx, const struct SQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_MTC_SSB2_LP_NR_r16(_ctx, &p->v);
}

static const char* adbgSys__SQN_SSB_PositionQCL_RelationNR_r16_e__ToString(SQN_SSB_PositionQCL_RelationNR_r16_e v)
{
	switch(v) {
		case SQN_SSB_PositionQCL_RelationNR_r16_e_n1: return "SQN_SSB_PositionQCL_RelationNR_r16_e_n1";
		case SQN_SSB_PositionQCL_RelationNR_r16_e_n2: return "SQN_SSB_PositionQCL_RelationNR_r16_e_n2";
		case SQN_SSB_PositionQCL_RelationNR_r16_e_n4: return "SQN_SSB_PositionQCL_RelationNR_r16_e_n4";
		case SQN_SSB_PositionQCL_RelationNR_r16_e_n8: return "SQN_SSB_PositionQCL_RelationNR_r16_e_n8";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional(acpCtx_t _ctx, const struct SQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SSB_PositionQCL_RelationNR_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional(acpCtx_t _ctx, const struct SQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e__ToString(SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e v)
{
	switch(v) {
		case SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_true: return "SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CarrierFreqNR_v1610(acpCtx_t _ctx, const struct SQN_CarrierFreqNR_v1610* p)
{
	adbgPrintLog(_ctx, "smtc2_LP_r16 := ");
	if (p->smtc2_LP_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional(_ctx, &p->smtc2_LP_r16);
	if (p->smtc2_LP_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_PositionQCL_CommonNR_r16 := ");
	_adbgSys__SQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional(_ctx, &p->ssb_PositionQCL_CommonNR_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "whiteCellListNR_r16 := ");
	if (p->whiteCellListNR_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional(_ctx, &p->whiteCellListNR_r16);
	if (p->whiteCellListNR_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highSpeedCarrierNR_r16 := ");
	_adbgSys__SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional(_ctx, &p->highSpeedCarrierNR_r16);
}

static void _adbgSys__SQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqNR_v1610(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType24_r15(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType24_r15* p)
{
	adbgPrintLog(_ctx, "carrierFreqListNR_r15 := ");
	if (p->carrierFreqListNR_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional(_ctx, &p->carrierFreqListNR_r15);
	if (p->carrierFreqListNR_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionNR_r15 := %u", (unsigned int)p->t_ReselectionNR_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionNR_SF_r15 := ");
	if (p->t_ReselectionNR_SF_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional(_ctx, &p->t_ReselectionNR_SF_r15);
	if (p->t_ReselectionNR_SF_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqListNR_v1610 := ");
	if (p->carrierFreqListNR_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional(_ctx, &p->carrierFreqListNR_v1610);
	if (p->carrierFreqListNR_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_UAC_BarringPerCat_r15(acpCtx_t _ctx, const struct SQN_UAC_BarringPerCat_r15* p)
{
	adbgPrintLog(_ctx, "accessCategory_r15 := %u", (unsigned int)p->accessCategory_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uac_barringInfoSetIndex_r15 := %u", (unsigned int)p->uac_barringInfoSetIndex_r15);
}

static void _adbgSys__SQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional(acpCtx_t _ctx, const struct SQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_UAC_BarringPerCat_r15(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value(acpCtx_t _ctx, const union SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value* p, enum SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Sel d)
{
	if (d == SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_ImplicitAC_BarringList_r15) {
		adbgPrintLog(_ctx, "uac_ImplicitAC_BarringList_r15 := '");
		for (size_t i3 = 0; i3 < 63; i3++) {
			adbgPrintLog(_ctx, "%02X", p->uac_ImplicitAC_BarringList_r15[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_ExplicitAC_BarringList_r15) {
		adbgPrintLog(_ctx, "uac_ExplicitAC_BarringList_r15 := { ");
		for (size_t i3 = 0; i3 < p->uac_ExplicitAC_BarringList_r15.d; i3++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgSys__SQN_UAC_BarringPerCat_r15(_ctx, &p->uac_ExplicitAC_BarringList_r15.v[i3]);
			adbgPrintLog(_ctx, " }");
			if (i3 != p->uac_ExplicitAC_BarringList_r15.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15(acpCtx_t _ctx, const struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15* p)
{
	_adbgSys__SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional(acpCtx_t _ctx, const struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_UAC_BarringPerPLMN_r15(acpCtx_t _ctx, const struct SQN_UAC_BarringPerPLMN_r15* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityIndex_r15 := %u", (unsigned int)p->plmn_IdentityIndex_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uac_AC_BarringListType_r15 := ");
	if (p->uac_AC_BarringListType_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional(_ctx, &p->uac_AC_BarringListType_r15);
	if (p->uac_AC_BarringListType_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional(acpCtx_t _ctx, const struct SQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_UAC_BarringPerPLMN_r15(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgSys__SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e__ToString(SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e v)
{
	switch(v) {
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p00: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p00";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p05: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p05";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p10: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p10";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p15: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p15";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p20: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p20";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p25: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p25";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p30: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p30";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p40: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p40";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p50: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p50";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p60: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p60";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p70: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p70";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p75: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p75";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p80: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p80";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p85: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p85";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p90: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p90";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p95: return "SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p95";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e__ToString(SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e v)
{
	switch(v) {
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s4: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s4";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s8: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s8";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s16: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s16";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s32: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s32";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s64: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s64";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s128: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s128";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s256: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s256";
		case SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s512: return "SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s512";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_UAC_BarringInfoSet_r15(acpCtx_t _ctx, const struct SQN_UAC_BarringInfoSet_r15* p)
{
	adbgPrintLog(_ctx, "uac_BarringFactor_r15 := %s (%d)", adbgSys__SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e__ToString(p->uac_BarringFactor_r15), (int)p->uac_BarringFactor_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uac_BarringTime_r15 := %s (%d)", adbgSys__SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e__ToString(p->uac_BarringTime_r15), (int)p->uac_BarringTime_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uac_BarringForAccessIdentity_r15 := '");
	for (size_t i3 = 0; i3 < 7; i3++) {
		adbgPrintLog(_ctx, "%02X", p->uac_BarringForAccessIdentity_r15[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_UAC_AC1_SelectAssistInfo_r15_e__ToString(SQN_UAC_AC1_SelectAssistInfo_r15_e v)
{
	switch(v) {
		case SQN_UAC_AC1_SelectAssistInfo_r15_e_a: return "SQN_UAC_AC1_SelectAssistInfo_r15_e_a";
		case SQN_UAC_AC1_SelectAssistInfo_r15_e_b: return "SQN_UAC_AC1_SelectAssistInfo_r15_e_b";
		case SQN_UAC_AC1_SelectAssistInfo_r15_e_c: return "SQN_UAC_AC1_SelectAssistInfo_r15_e_c";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value(acpCtx_t _ctx, const union SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value* p, enum SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Sel d)
{
	if (d == SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_plmnCommon_r15) {
		adbgPrintLog(_ctx, "plmnCommon_r15 := %s (%d)", adbgSys__SQN_UAC_AC1_SelectAssistInfo_r15_e__ToString(p->plmnCommon_r15), (int)p->plmnCommon_r15);
		return;
	}
	if (d == SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_individualPLMNList_r15) {
		adbgPrintLog(_ctx, "individualPLMNList_r15 := { ");
		for (size_t i2 = 0; i2 < p->individualPLMNList_r15.d; i2++) {
			adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_UAC_AC1_SelectAssistInfo_r15_e__ToString(p->individualPLMNList_r15.v[i2]), (int)p->individualPLMNList_r15.v[i2]);
			if (i2 != p->individualPLMNList_r15.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15* p)
{
	_adbgSys__SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e__ToString(SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh0: return "SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh0";
		case SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh1: return "SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh1";
		case SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh2: return "SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh2";
		case SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh3: return "SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh3";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType25_r15(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType25_r15* p)
{
	adbgPrintLog(_ctx, "uac_BarringForCommon_r15 := ");
	if (p->uac_BarringForCommon_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional(_ctx, &p->uac_BarringForCommon_r15);
	if (p->uac_BarringForCommon_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uac_BarringPerPLMN_List_r15 := ");
	if (p->uac_BarringPerPLMN_List_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional(_ctx, &p->uac_BarringPerPLMN_List_r15);
	if (p->uac_BarringPerPLMN_List_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uac_BarringInfoSetList_r15 := { ");
	for (size_t i2 = 0; i2 < p->uac_BarringInfoSetList_r15.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_UAC_BarringInfoSet_r15(_ctx, &p->uac_BarringInfoSetList_r15.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->uac_BarringInfoSetList_r15.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uac_AC1_SelectAssistInfo_r15 := ");
	if (p->uac_AC1_SelectAssistInfo_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional(_ctx, &p->uac_AC1_SelectAssistInfo_r15);
	if (p->uac_AC1_SelectAssistInfo_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ab_PerRSRP_r16 := ");
	_adbgSys__SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional(_ctx, &p->ab_PerRSRP_r16);
}

static void _adbgSys__SQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_InterFreqInfoV2X_r14(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_PPPP_TxConfigIndex_r15(acpCtx_t _ctx, const struct SQN_SL_PPPP_TxConfigIndex_r15* p)
{
	adbgPrintLog(_ctx, "priorityThreshold_r15 := %u", (unsigned int)p->priorityThreshold_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "defaultTxConfigIndex_r15 := %u", (unsigned int)p->defaultTxConfigIndex_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cbr_ConfigIndex_r15 := %u", (unsigned int)p->cbr_ConfigIndex_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tx_ConfigIndexList_r15 := '");
	for (size_t i3 = 0; i3 < p->tx_ConfigIndexList_r15.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->tx_ConfigIndexList_r15.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_PSSCH_RangeList_r15 := { ");
	for (size_t i3 = 0; i3 < p->mcs_PSSCH_RangeList_r15.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_MCS_PSSCH_Range_r15(_ctx, &p->mcs_PSSCH_RangeList_r15.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->mcs_PSSCH_RangeList_r15.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_PPPP_TxConfigIndex_r15(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "{");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "'");
		for (size_t i4 = 0; i4 < 24; i4++) {
			adbgPrintLog(_ctx, "%02X", p->v.v[i3][i4]);
		}
		adbgPrintLog(_ctx, "'O");
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_SL_AllowedCarrierFreqList_r15(acpCtx_t _ctx, const struct SQN_SL_AllowedCarrierFreqList_r15* p)
{
	adbgPrintLog(_ctx, "allowedCarrierFreqSet1 := '");
	for (size_t i3 = 0; i3 < p->allowedCarrierFreqSet1.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->allowedCarrierFreqSet1.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedCarrierFreqSet2 := '");
	for (size_t i3 = 0; i3 < p->allowedCarrierFreqSet2.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->allowedCarrierFreqSet2.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_AllowedCarrierFreqList_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_PPPR_Dest_CarrierFreq(acpCtx_t _ctx, const struct SQN_SL_PPPR_Dest_CarrierFreq* p)
{
	adbgPrintLog(_ctx, "destinationInfoList_r15 := ");
	if (p->destinationInfoList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional(_ctx, &p->destinationInfoList_r15);
	if (p->destinationInfoList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedCarrierFreqList_r15 := ");
	if (p->allowedCarrierFreqList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional(_ctx, &p->allowedCarrierFreqList_r15);
	if (p->allowedCarrierFreqList_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_PPPR_Dest_CarrierFreq(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SL_V2X_PacketDuplicationConfig_r15(acpCtx_t _ctx, const struct SQN_SL_V2X_PacketDuplicationConfig_r15* p)
{
	adbgPrintLog(_ctx, "threshSL_Reliability_r15 := %u", (unsigned int)p->threshSL_Reliability_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedCarrierFreqConfig_r15 := ");
	if (p->allowedCarrierFreqConfig_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional(_ctx, &p->allowedCarrierFreqConfig_r15);
	if (p->allowedCarrierFreqConfig_r15.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SL_V2X_PacketDuplicationConfig_r15(_ctx, &p->v);
}

static void _adbgSys__SQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e__ToString(SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_true: return "SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional(acpCtx_t _ctx, const struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_SL_V2X_FreqSelectionConfig_r15(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__Uint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType26_r15(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType26_r15* p)
{
	adbgPrintLog(_ctx, "v2x_InterFreqInfoList_r15 := ");
	if (p->v2x_InterFreqInfoList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional(_ctx, &p->v2x_InterFreqInfoList_r15);
	if (p->v2x_InterFreqInfoList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cbr_pssch_TxConfigList_r15 := ");
	if (p->cbr_pssch_TxConfigList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional(_ctx, &p->cbr_pssch_TxConfigList_r15);
	if (p->cbr_pssch_TxConfigList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_PacketDuplicationConfig_r15 := ");
	if (p->v2x_PacketDuplicationConfig_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional(_ctx, &p->v2x_PacketDuplicationConfig_r15);
	if (p->v2x_PacketDuplicationConfig_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "syncFreqList_r15 := ");
	if (p->syncFreqList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional(_ctx, &p->syncFreqList_r15);
	if (p->syncFreqList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slss_TxMultiFreq_r15 := ");
	_adbgSys__SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional(_ctx, &p->slss_TxMultiFreq_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v2x_FreqSelectionConfigList_r15 := ");
	if (p->v2x_FreqSelectionConfigList_r15.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional(_ctx, &p->v2x_FreqSelectionConfigList_r15);
	if (p->v2x_FreqSelectionConfigList_r15.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshS_RSSI_CBR_r15 := ");
	_adbgSys__Uint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional(_ctx, &p->threshS_RSSI_CBR_r15);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__B10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional(acpCtx_t _ctx, const struct B10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < 10; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_PLMN_Info_r16(acpCtx_t _ctx, const struct SQN_PLMN_Info_r16* p)
{
	adbgPrintLog(_ctx, "nr_BandList_r16 := ");
	_adbgSys__B10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional(_ctx, &p->nr_BandList_r16);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType26a_r16(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType26a_r16* p)
{
	adbgPrintLog(_ctx, "plmn_InfoList_r16 := { ");
	for (size_t i2 = 0; i2 < p->plmn_InfoList_r16.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_PLMN_Info_r16(_ctx, &p->plmn_InfoList_r16.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->plmn_InfoList_r16.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bandListENDC_r16 := '");
	for (size_t i2 = 0; i2 < p->bandListENDC_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->bandListENDC_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e__ToString(SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e v)
{
	switch(v) {
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_10: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_10";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_9: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_9";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_8dot5: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_8dot5";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_8: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_8";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_7: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_7";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_6: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_6";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_5: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_5";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_4dot5: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_4dot5";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_4: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_4";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_3: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_3";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_2: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_2";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_1: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_1";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_0dot5: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_0dot5";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v0: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v0";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v1: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v1";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v2: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v2";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v3: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v3";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v3dot5: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v3dot5";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v4: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v4";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v5: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v5";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v6: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v6";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v7: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v7";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v7dot5: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v7dot5";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v8: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v8";
		case SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v9: return "SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v9";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CarrierFreqNBIOT_r16(acpCtx_t _ctx, const struct SQN_CarrierFreqNBIOT_r16* p)
{
	adbgPrintLog(_ctx, "carrierFreq_r16 := %u", (unsigned int)p->carrierFreq_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqOffset_r16 := %s (%d)", adbgSys__SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e__ToString(p->carrierFreqOffset_r16), (int)p->carrierFreqOffset_r16);
}

static void _adbgSys__SQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional(acpCtx_t _ctx, const struct SQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgSys__SQN_CarrierFreqNBIOT_r16(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType27_r16(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType27_r16* p)
{
	adbgPrintLog(_ctx, "carrierFreqListNBIOT_r16 := ");
	if (p->carrierFreqListNBIOT_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional(_ctx, &p->carrierFreqListNBIOT_r16);
	if (p->carrierFreqListNBIOT_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgSys__SQN_SystemInformationBlockType28_r16_segmentType_r16_e__ToString(SQN_SystemInformationBlockType28_r16_segmentType_r16_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType28_r16_segmentType_r16_e_notLastSegment: return "SQN_SystemInformationBlockType28_r16_segmentType_r16_e_notLastSegment";
		case SQN_SystemInformationBlockType28_r16_segmentType_r16_e_lastSegment: return "SQN_SystemInformationBlockType28_r16_segmentType_r16_e_lastSegment";
		default: return "Unknown";
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType28_r16(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType28_r16* p)
{
	adbgPrintLog(_ctx, "segmentNumber_r16 := %u", (unsigned int)p->segmentNumber_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "segmentType_r16 := %s (%d)", adbgSys__SQN_SystemInformationBlockType28_r16_segmentType_r16_e__ToString(p->segmentType_r16), (int)p->segmentType_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "segmentContainer_r16 := '");
	for (size_t i2 = 0; i2 < p->segmentContainer_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->segmentContainer_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_PeriodicityStartPos_r16_Value(acpCtx_t _ctx, const union SQN_PeriodicityStartPos_r16_Value* p, enum SQN_PeriodicityStartPos_r16_Sel d)
{
	if (d == SQN_PeriodicityStartPos_r16_periodicity10ms) {
		adbgPrintLog(_ctx, "periodicity10ms := %s", (p->periodicity10ms ? "true" : "false"));
		return;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity20ms) {
		adbgPrintLog(_ctx, "periodicity20ms := %u", (unsigned int)p->periodicity20ms);
		return;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity40ms) {
		adbgPrintLog(_ctx, "periodicity40ms := %u", (unsigned int)p->periodicity40ms);
		return;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity80ms) {
		adbgPrintLog(_ctx, "periodicity80ms := %u", (unsigned int)p->periodicity80ms);
		return;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity160ms) {
		adbgPrintLog(_ctx, "periodicity160ms := %u", (unsigned int)p->periodicity160ms);
		return;
	}
	if (d == SQN_PeriodicityStartPos_r16_spare3) {
		adbgPrintLog(_ctx, "spare3 := %s", (p->spare3 ? "true" : "false"));
		return;
	}
	if (d == SQN_PeriodicityStartPos_r16_spare2) {
		adbgPrintLog(_ctx, "spare2 := %s", (p->spare2 ? "true" : "false"));
		return;
	}
	if (d == SQN_PeriodicityStartPos_r16_spare1) {
		adbgPrintLog(_ctx, "spare1 := %s", (p->spare1 ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_PeriodicityStartPos_r16(acpCtx_t _ctx, const struct SQN_PeriodicityStartPos_r16* p)
{
	_adbgSys__SQN_PeriodicityStartPos_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value(acpCtx_t _ctx, const union SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value* p, enum SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Sel d)
{
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap1dot4) {
		adbgPrintLog(_ctx, "rbg_Bitmap1dot4 := '");
		for (size_t i2 = 0; i2 < 6; i2++) {
			adbgPrintLog(_ctx, "%02X", p->rbg_Bitmap1dot4[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap3) {
		adbgPrintLog(_ctx, "rbg_Bitmap3 := '");
		for (size_t i2 = 0; i2 < 8; i2++) {
			adbgPrintLog(_ctx, "%02X", p->rbg_Bitmap3[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap5) {
		adbgPrintLog(_ctx, "rbg_Bitmap5 := '");
		for (size_t i2 = 0; i2 < 13; i2++) {
			adbgPrintLog(_ctx, "%02X", p->rbg_Bitmap5[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap10) {
		adbgPrintLog(_ctx, "rbg_Bitmap10 := '");
		for (size_t i2 = 0; i2 < 17; i2++) {
			adbgPrintLog(_ctx, "%02X", p->rbg_Bitmap10[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap15) {
		adbgPrintLog(_ctx, "rbg_Bitmap15 := '");
		for (size_t i2 = 0; i2 < 19; i2++) {
			adbgPrintLog(_ctx, "%02X", p->rbg_Bitmap15[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap20) {
		adbgPrintLog(_ctx, "rbg_Bitmap20 := '");
		for (size_t i2 = 0; i2 < 25; i2++) {
			adbgPrintLog(_ctx, "%02X", p->rbg_Bitmap20[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16* p)
{
	_adbgSys__SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value(acpCtx_t _ctx, const union SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value* p, enum SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Sel d)
{
	if (d == SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_slotPattern10ms) {
		adbgPrintLog(_ctx, "slotPattern10ms := '");
		for (size_t i2 = 0; i2 < 20; i2++) {
			adbgPrintLog(_ctx, "%02X", p->slotPattern10ms[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_slotPattern40ms) {
		adbgPrintLog(_ctx, "slotPattern40ms := '");
		for (size_t i2 = 0; i2 < 80; i2++) {
			adbgPrintLog(_ctx, "%02X", p->slotPattern40ms[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_ResourceReservationConfigDL_r16_slotBitmap_r16(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigDL_r16_slotBitmap_r16* p)
{
	_adbgSys__SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional(acpCtx_t _ctx, const struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 7; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional(acpCtx_t _ctx, const struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 7; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_ResourceReservationConfigDL_r16(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigDL_r16* p)
{
	adbgPrintLog(_ctx, "periodicityStartPos_r16 := { ");
	_adbgSys__SQN_PeriodicityStartPos_r16(_ctx, &p->periodicityStartPos_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceReservationFreq_r16 := ");
	if (p->resourceReservationFreq_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional(_ctx, &p->resourceReservationFreq_r16);
	if (p->resourceReservationFreq_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slotBitmap_r16 := { ");
	_adbgSys__SQN_ResourceReservationConfigDL_r16_slotBitmap_r16(_ctx, &p->slotBitmap_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "symbolBitmap1_r16 := ");
	_adbgSys__B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional(_ctx, &p->symbolBitmap1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "symbolBitmap2_r16 := ");
	_adbgSys__B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional(_ctx, &p->symbolBitmap2_r16);
}

static void _adbgSys__SQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ResourceReservationConfigDL_r16(_ctx, &p->v);
}

static void _adbgSys__SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value(acpCtx_t _ctx, const union SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value* p, enum SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Sel d)
{
	if (d == SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotPattern10ms) {
		adbgPrintLog(_ctx, "slotPattern10ms := '");
		for (size_t i2 = 0; i2 < 20; i2++) {
			adbgPrintLog(_ctx, "%02X", p->slotPattern10ms[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotPattern40ms) {
		adbgPrintLog(_ctx, "slotPattern40ms := '");
		for (size_t i2 = 0; i2 < 80; i2++) {
			adbgPrintLog(_ctx, "%02X", p->slotPattern40ms[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_ResourceReservationConfigUL_r16_slotBitmap_r16(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16* p)
{
	_adbgSys__SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ResourceReservationConfigUL_r16_slotBitmap_r16(_ctx, &p->v);
}

static void _adbgSys__B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional(acpCtx_t _ctx, const struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 7; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional(acpCtx_t _ctx, const struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 7; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_ResourceReservationConfigUL_r16(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigUL_r16* p)
{
	adbgPrintLog(_ctx, "periodicityStartPos_r16 := { ");
	_adbgSys__SQN_PeriodicityStartPos_r16(_ctx, &p->periodicityStartPos_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slotBitmap_r16 := ");
	if (p->slotBitmap_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional(_ctx, &p->slotBitmap_r16);
	if (p->slotBitmap_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "symbolBitmap1_r16 := ");
	_adbgSys__B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional(_ctx, &p->symbolBitmap1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "symbolBitmap2_r16 := ");
	_adbgSys__B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional(_ctx, &p->symbolBitmap2_r16);
}

static void _adbgSys__SQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional(acpCtx_t _ctx, const struct SQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_ResourceReservationConfigUL_r16(_ctx, &p->v);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType29_r16(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType29_r16* p)
{
	adbgPrintLog(_ctx, "resourceReservationConfigCommonDL_r16 := ");
	if (p->resourceReservationConfigCommonDL_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional(_ctx, &p->resourceReservationConfigCommonDL_r16);
	if (p->resourceReservationConfigCommonDL_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceReservationConfigCommonUL_r16 := ");
	if (p->resourceReservationConfigCommonUL_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional(_ctx, &p->resourceReservationConfigCommonUL_r16);
	if (p->resourceReservationConfigCommonUL_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value(acpCtx_t _ctx, const union SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value* p, enum SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Sel d)
{
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib2) {
		adbgPrintLog(_ctx, "sib2 := { ");
		_adbgSys__SQN_SystemInformationBlockType2(_ctx, &p->sib2);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib3) {
		adbgPrintLog(_ctx, "sib3 := { ");
		_adbgSys__SQN_SystemInformationBlockType3(_ctx, &p->sib3);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib4) {
		adbgPrintLog(_ctx, "sib4 := { ");
		_adbgSys__SQN_SystemInformationBlockType4(_ctx, &p->sib4);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib5) {
		adbgPrintLog(_ctx, "sib5 := { ");
		_adbgSys__SQN_SystemInformationBlockType5(_ctx, &p->sib5);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib6) {
		adbgPrintLog(_ctx, "sib6 := { ");
		_adbgSys__SQN_SystemInformationBlockType6(_ctx, &p->sib6);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib7) {
		adbgPrintLog(_ctx, "sib7 := { ");
		_adbgSys__SQN_SystemInformationBlockType7(_ctx, &p->sib7);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib8) {
		adbgPrintLog(_ctx, "sib8 := { ");
		_adbgSys__SQN_SystemInformationBlockType8(_ctx, &p->sib8);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib9) {
		adbgPrintLog(_ctx, "sib9 := { ");
		_adbgSys__SQN_SystemInformationBlockType9(_ctx, &p->sib9);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib10) {
		adbgPrintLog(_ctx, "sib10 := { ");
		_adbgSys__SQN_SystemInformationBlockType10(_ctx, &p->sib10);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib11) {
		adbgPrintLog(_ctx, "sib11 := { ");
		_adbgSys__SQN_SystemInformationBlockType11(_ctx, &p->sib11);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib12_v920) {
		adbgPrintLog(_ctx, "sib12_v920 := { ");
		_adbgSys__SQN_SystemInformationBlockType12_r9(_ctx, &p->sib12_v920);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib13_v920) {
		adbgPrintLog(_ctx, "sib13_v920 := { ");
		_adbgSys__SQN_SystemInformationBlockType13_r9(_ctx, &p->sib13_v920);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib14_v1130) {
		adbgPrintLog(_ctx, "sib14_v1130 := { ");
		_adbgSys__SQN_SystemInformationBlockType14_r11(_ctx, &p->sib14_v1130);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib15_v1130) {
		adbgPrintLog(_ctx, "sib15_v1130 := { ");
		_adbgSys__SQN_SystemInformationBlockType15_r11(_ctx, &p->sib15_v1130);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib16_v1130) {
		adbgPrintLog(_ctx, "sib16_v1130 := { ");
		_adbgSys__SQN_SystemInformationBlockType16_r11(_ctx, &p->sib16_v1130);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib17_v1250) {
		adbgPrintLog(_ctx, "sib17_v1250 := { ");
		_adbgSys__SQN_SystemInformationBlockType17_r12(_ctx, &p->sib17_v1250);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib18_v1250) {
		adbgPrintLog(_ctx, "sib18_v1250 := { ");
		_adbgSys__SQN_SystemInformationBlockType18_r12(_ctx, &p->sib18_v1250);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib19_v1250) {
		adbgPrintLog(_ctx, "sib19_v1250 := { ");
		_adbgSys__SQN_SystemInformationBlockType19_r12(_ctx, &p->sib19_v1250);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib20_v1310) {
		adbgPrintLog(_ctx, "sib20_v1310 := { ");
		_adbgSys__SQN_SystemInformationBlockType20_r13(_ctx, &p->sib20_v1310);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib21_v1430) {
		adbgPrintLog(_ctx, "sib21_v1430 := { ");
		_adbgSys__SQN_SystemInformationBlockType21_r14(_ctx, &p->sib21_v1430);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib24_v1530) {
		adbgPrintLog(_ctx, "sib24_v1530 := { ");
		_adbgSys__SQN_SystemInformationBlockType24_r15(_ctx, &p->sib24_v1530);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib25_v1530) {
		adbgPrintLog(_ctx, "sib25_v1530 := { ");
		_adbgSys__SQN_SystemInformationBlockType25_r15(_ctx, &p->sib25_v1530);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib26_v1530) {
		adbgPrintLog(_ctx, "sib26_v1530 := { ");
		_adbgSys__SQN_SystemInformationBlockType26_r15(_ctx, &p->sib26_v1530);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib26a_v1610) {
		adbgPrintLog(_ctx, "sib26a_v1610 := { ");
		_adbgSys__SQN_SystemInformationBlockType26a_r16(_ctx, &p->sib26a_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib27_v1610) {
		adbgPrintLog(_ctx, "sib27_v1610 := { ");
		_adbgSys__SQN_SystemInformationBlockType27_r16(_ctx, &p->sib27_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib28_v1610) {
		adbgPrintLog(_ctx, "sib28_v1610 := { ");
		_adbgSys__SQN_SystemInformationBlockType28_r16(_ctx, &p->sib28_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib29_v1610) {
		adbgPrintLog(_ctx, "sib29_v1610 := { ");
		_adbgSys__SQN_SystemInformationBlockType29_r16(_ctx, &p->sib29_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s(acpCtx_t _ctx, const struct SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s* p)
{
	_adbgSys__SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformation_v8a0_IEs_nonCriticalExtension(acpCtx_t _ctx, const struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgSys__SQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional(acpCtx_t _ctx, const struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformation_v8a0_IEs_nonCriticalExtension(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformation_v8a0_IEs(acpCtx_t _ctx, const struct SQN_SystemInformation_v8a0_IEs* p)
{
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nonCriticalExtension := ");
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_ctx, &p->nonCriticalExtension);
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional(acpCtx_t _ctx, const struct SQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformation_v8a0_IEs(_ctx, &p->v);
}

static void _adbgSys__SQN_SystemInformation_r8_IEs(acpCtx_t _ctx, const struct SQN_SystemInformation_r8_IEs* p)
{
	adbgPrintLog(_ctx, "sib_TypeAndInfo := { ");
	for (size_t i1 = 0; i1 < p->sib_TypeAndInfo.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s(_ctx, &p->sib_TypeAndInfo.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->sib_TypeAndInfo.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nonCriticalExtension := ");
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional(_ctx, &p->nonCriticalExtension);
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockPos_r15(acpCtx_t _ctx, const struct SQN_SystemInformationBlockPos_r15* p)
{
	adbgPrintLog(_ctx, "assistanceDataSIB_Element_r15 := '");
	for (size_t i2 = 0; i2 < p->assistanceDataSIB_Element_r15.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->assistanceDataSIB_Element_r15.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value(acpCtx_t _ctx, const union SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value* p, enum SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Sel d)
{
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_1_r15) {
		adbgPrintLog(_ctx, "posSib1_1_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib1_1_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_2_r15) {
		adbgPrintLog(_ctx, "posSib1_2_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib1_2_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_3_r15) {
		adbgPrintLog(_ctx, "posSib1_3_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib1_3_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_4_r15) {
		adbgPrintLog(_ctx, "posSib1_4_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib1_4_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_5_r15) {
		adbgPrintLog(_ctx, "posSib1_5_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib1_5_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_6_r15) {
		adbgPrintLog(_ctx, "posSib1_6_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib1_6_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_7_r15) {
		adbgPrintLog(_ctx, "posSib1_7_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib1_7_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_1_r15) {
		adbgPrintLog(_ctx, "posSib2_1_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_1_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_2_r15) {
		adbgPrintLog(_ctx, "posSib2_2_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_2_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_3_r15) {
		adbgPrintLog(_ctx, "posSib2_3_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_3_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_4_r15) {
		adbgPrintLog(_ctx, "posSib2_4_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_4_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_5_r15) {
		adbgPrintLog(_ctx, "posSib2_5_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_5_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_6_r15) {
		adbgPrintLog(_ctx, "posSib2_6_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_6_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_7_r15) {
		adbgPrintLog(_ctx, "posSib2_7_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_7_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_8_r15) {
		adbgPrintLog(_ctx, "posSib2_8_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_8_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_9_r15) {
		adbgPrintLog(_ctx, "posSib2_9_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_9_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_10_r15) {
		adbgPrintLog(_ctx, "posSib2_10_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_10_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_11_r15) {
		adbgPrintLog(_ctx, "posSib2_11_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_11_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_12_r15) {
		adbgPrintLog(_ctx, "posSib2_12_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_12_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_13_r15) {
		adbgPrintLog(_ctx, "posSib2_13_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_13_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_14_r15) {
		adbgPrintLog(_ctx, "posSib2_14_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_14_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_15_r15) {
		adbgPrintLog(_ctx, "posSib2_15_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_15_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_16_r15) {
		adbgPrintLog(_ctx, "posSib2_16_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_16_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_17_r15) {
		adbgPrintLog(_ctx, "posSib2_17_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_17_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_18_r15) {
		adbgPrintLog(_ctx, "posSib2_18_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_18_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_19_r15) {
		adbgPrintLog(_ctx, "posSib2_19_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib2_19_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib3_1_r15) {
		adbgPrintLog(_ctx, "posSib3_1_r15 := { ");
		_adbgSys__SQN_SystemInformationBlockPos_r15(_ctx, &p->posSib3_1_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s(acpCtx_t _ctx, const struct SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s* p)
{
	_adbgSys__SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__OCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_PosSystemInformation_r15_IEs_nonCriticalExtension(acpCtx_t _ctx, const struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgSys__SQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional(acpCtx_t _ctx, const struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_PosSystemInformation_r15_IEs_nonCriticalExtension(_ctx, &p->v);
}

static void _adbgSys__SQN_PosSystemInformation_r15_IEs(acpCtx_t _ctx, const struct SQN_PosSystemInformation_r15_IEs* p)
{
	adbgPrintLog(_ctx, "posSIB_TypeAndInfo_r15 := { ");
	for (size_t i1 = 0; i1 < p->posSIB_TypeAndInfo_r15.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s(_ctx, &p->posSIB_TypeAndInfo_r15.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->posSIB_TypeAndInfo_r15.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__OCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nonCriticalExtension := ");
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_ctx, &p->nonCriticalExtension);
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture(acpCtx_t _ctx, const struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgSys__SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value(acpCtx_t _ctx, const union SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value* p, enum SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Sel d)
{
	if (d == SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_posSystemInformation_r15) {
		adbgPrintLog(_ctx, "posSystemInformation_r15 := { ");
		_adbgSys__SQN_PosSystemInformation_r15_IEs(_ctx, &p->posSystemInformation_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture) {
		adbgPrintLog(_ctx, "criticalExtensionsFuture := { ");
		_adbgSys__SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture(_ctx, &p->criticalExtensionsFuture);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15(acpCtx_t _ctx, const struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15* p)
{
	_adbgSys__SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemInformation_criticalExtensions_Value(acpCtx_t _ctx, const union SQN_SystemInformation_criticalExtensions_Value* p, enum SQN_SystemInformation_criticalExtensions_Sel d)
{
	if (d == SQN_SystemInformation_criticalExtensions_systemInformation_r8) {
		adbgPrintLog(_ctx, "systemInformation_r8 := { ");
		_adbgSys__SQN_SystemInformation_r8_IEs(_ctx, &p->systemInformation_r8);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15) {
		adbgPrintLog(_ctx, "criticalExtensionsFuture_r15 := { ");
		_adbgSys__SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15(_ctx, &p->criticalExtensionsFuture_r15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformation_criticalExtensions(acpCtx_t _ctx, const struct SQN_SystemInformation_criticalExtensions* p)
{
	_adbgSys__SQN_SystemInformation_criticalExtensions_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemInformation(acpCtx_t _ctx, const struct SQN_SystemInformation* p)
{
	adbgPrintLog(_ctx, "criticalExtensions := { ");
	_adbgSys__SQN_SystemInformation_criticalExtensions(_ctx, &p->criticalExtensions);
	adbgPrintLog(_ctx, " }");
}

static const char* adbgSys__SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e__ToString(SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e_barred: return "SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e_barred";
		case SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e_notBarred: return "SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e_notBarred";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e__ToString(SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e_allowed: return "SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e_allowed";
		case SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e_notAllowed: return "SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e_notAllowed";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional(acpCtx_t _ctx, const struct SQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 27; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType1_cellAccessRelatedInfo(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_cellAccessRelatedInfo* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityList := { ");
	for (size_t i1 = 0; i1 < p->plmn_IdentityList.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgSys__SQN_PLMN_IdentityInfo(_ctx, &p->plmn_IdentityList.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->plmn_IdentityList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "trackingAreaCode := '");
	for (size_t i1 = 0; i1 < 16; i1++) {
		adbgPrintLog(_ctx, "%02X", p->trackingAreaCode[i1]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellIdentity := '");
	for (size_t i1 = 0; i1 < 28; i1++) {
		adbgPrintLog(_ctx, "%02X", p->cellIdentity[i1]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellBarred := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e__ToString(p->cellBarred), (int)p->cellBarred);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqReselection := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e__ToString(p->intraFreqReselection), (int)p->intraFreqReselection);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csg_Indication := %s", (p->csg_Indication ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csg_Identity := ");
	_adbgSys__SQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional(_ctx, &p->csg_Identity);
}

static void _adbgSys__Uint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType1_cellSelectionInfo(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_cellSelectionInfo* p)
{
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinOffset := ");
	_adbgSys__Uint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional(_ctx, &p->q_RxLevMinOffset);
}

static void _adbgSys__SQN_P_Max_SQN_SystemInformationBlockType1_p_Max_Optional(acpCtx_t _ctx, const struct SQN_P_Max_SQN_SystemInformationBlockType1_p_Max_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static const char* adbgSys__SQN_SIB_Type_e__ToString(SQN_SIB_Type_e v)
{
	switch(v) {
		case SQN_SIB_Type_e_sibType3: return "SQN_SIB_Type_e_sibType3";
		case SQN_SIB_Type_e_sibType4: return "SQN_SIB_Type_e_sibType4";
		case SQN_SIB_Type_e_sibType5: return "SQN_SIB_Type_e_sibType5";
		case SQN_SIB_Type_e_sibType6: return "SQN_SIB_Type_e_sibType6";
		case SQN_SIB_Type_e_sibType7: return "SQN_SIB_Type_e_sibType7";
		case SQN_SIB_Type_e_sibType8: return "SQN_SIB_Type_e_sibType8";
		case SQN_SIB_Type_e_sibType9: return "SQN_SIB_Type_e_sibType9";
		case SQN_SIB_Type_e_sibType10: return "SQN_SIB_Type_e_sibType10";
		case SQN_SIB_Type_e_sibType11: return "SQN_SIB_Type_e_sibType11";
		case SQN_SIB_Type_e_sibType12_v920: return "SQN_SIB_Type_e_sibType12_v920";
		case SQN_SIB_Type_e_sibType13_v920: return "SQN_SIB_Type_e_sibType13_v920";
		case SQN_SIB_Type_e_sibType14_v1130: return "SQN_SIB_Type_e_sibType14_v1130";
		case SQN_SIB_Type_e_sibType15_v1130: return "SQN_SIB_Type_e_sibType15_v1130";
		case SQN_SIB_Type_e_sibType16_v1130: return "SQN_SIB_Type_e_sibType16_v1130";
		case SQN_SIB_Type_e_sibType17_v1250: return "SQN_SIB_Type_e_sibType17_v1250";
		case SQN_SIB_Type_e_sibType18_v1250: return "SQN_SIB_Type_e_sibType18_v1250";
		case SQN_SIB_Type_e_sibType19_v1250: return "SQN_SIB_Type_e_sibType19_v1250";
		case SQN_SIB_Type_e_sibType20_v1310: return "SQN_SIB_Type_e_sibType20_v1310";
		case SQN_SIB_Type_e_sibType21_v1430: return "SQN_SIB_Type_e_sibType21_v1430";
		case SQN_SIB_Type_e_sibType24_v1530: return "SQN_SIB_Type_e_sibType24_v1530";
		case SQN_SIB_Type_e_sibType25_v1530: return "SQN_SIB_Type_e_sibType25_v1530";
		case SQN_SIB_Type_e_sibType26_v1530: return "SQN_SIB_Type_e_sibType26_v1530";
		case SQN_SIB_Type_e_sibType26a_v1610: return "SQN_SIB_Type_e_sibType26a_v1610";
		case SQN_SIB_Type_e_sibType27_v1610: return "SQN_SIB_Type_e_sibType27_v1610";
		case SQN_SIB_Type_e_sibType28_v1610: return "SQN_SIB_Type_e_sibType28_v1610";
		case SQN_SIB_Type_e_sibType29_v1610: return "SQN_SIB_Type_e_sibType29_v1610";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SchedulingInfo(acpCtx_t _ctx, const struct SQN_SchedulingInfo* p)
{
	adbgPrintLog(_ctx, "si_Periodicity := %s (%d)", adbgSys__SQN_SI_Periodicity_r12_e__ToString(p->si_Periodicity), (int)p->si_Periodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sib_MappingInfo := { ");
	for (size_t i2 = 0; i2 < p->sib_MappingInfo.d; i2++) {
		adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SIB_Type_e__ToString(p->sib_MappingInfo.v[i2]), (int)p->sib_MappingInfo.v[i2]);
		if (i2 != p->sib_MappingInfo.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgSys__SQN_TDD_Config_SQN_SystemInformationBlockType1_tdd_Config_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_SQN_SystemInformationBlockType1_tdd_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType1_si_WindowLength_e__ToString(SQN_SystemInformationBlockType1_si_WindowLength_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms1: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms1";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms2: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms2";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms5: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms5";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms10: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms10";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms15: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms15";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms20: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms20";
		case SQN_SystemInformationBlockType1_si_WindowLength_e_ms40: return "SQN_SystemInformationBlockType1_si_WindowLength_e_ms40";
		default: return "Unknown";
	}
}

static void _adbgSys__OCTET_STRING_SQN_SystemInformationBlockType1_v890_IEs_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_SystemInformationBlockType1_v890_IEs_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e__ToString(SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_true: return "SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_ims_EmergencySupport_r9_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_ims_EmergencySupport_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__Uint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgSys__SQN_CellSelectionInfo_v920(acpCtx_t _ctx, const struct SQN_CellSelectionInfo_v920* p)
{
	adbgPrintLog(_ctx, "q_QualMin_r9 := %d", (int)p->q_QualMin_r9);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinOffset_r9 := ");
	_adbgSys__Uint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional(_ctx, &p->q_QualMinOffset_r9);
}

static void _adbgSys__SQN_CellSelectionInfo_v920_SQN_SystemInformationBlockType1_v920_IEs_cellSelectionInfo_v920_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfo_v920_SQN_SystemInformationBlockType1_v920_IEs_cellSelectionInfo_v920_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfo_v920(_ctx, &p->v);
}

static void _adbgSys__SQN_TDD_Config_v1130_SQN_SystemInformationBlockType1_v1130_IEs_tdd_Config_v1130_Optional(acpCtx_t _ctx, const struct SQN_TDD_Config_v1130_SQN_SystemInformationBlockType1_v1130_IEs_tdd_Config_v1130_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_TDD_Config_v1130(_ctx, &p->v);
}

static void _adbgSys__SQN_CellSelectionInfo_v1130(acpCtx_t _ctx, const struct SQN_CellSelectionInfo_v1130* p)
{
	adbgPrintLog(_ctx, "q_QualMinWB_r11 := %d", (int)p->q_QualMinWB_r11);
}

static void _adbgSys__SQN_CellSelectionInfo_v1130_SQN_SystemInformationBlockType1_v1130_IEs_cellSelectionInfo_v1130_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfo_v1130_SQN_SystemInformationBlockType1_v1130_IEs_cellSelectionInfo_v1130_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfo_v1130(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e__ToString(SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_true: return "SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250* p)
{
	adbgPrintLog(_ctx, "category0Allowed_r12 := ");
	_adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional(_ctx, &p->category0Allowed_r12);
}

static void _adbgSys__SQN_CellSelectionInfo_v1250(acpCtx_t _ctx, const struct SQN_CellSelectionInfo_v1250* p)
{
	adbgPrintLog(_ctx, "q_QualMinRSRQ_OnAllSymbols_r12 := %d", (int)p->q_QualMinRSRQ_OnAllSymbols_r12);
}

static void _adbgSys__SQN_CellSelectionInfo_v1250_SQN_SystemInformationBlockType1_v1250_IEs_cellSelectionInfo_v1250_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfo_v1250_SQN_SystemInformationBlockType1_v1250_IEs_cellSelectionInfo_v1250_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfo_v1250(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e__ToString(SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_true: return "SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_freqBandIndicatorPriority_r12_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_freqBandIndicatorPriority_r12_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__B10_SQN_SystemInformationBlockType1_v1310_IEs_hyperSFN_r13_Optional(acpCtx_t _ctx, const struct B10_SQN_SystemInformationBlockType1_v1310_IEs_hyperSFN_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 10; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e__ToString(SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_true: return "SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_eDRX_Allowed_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_eDRX_Allowed_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType1_v1310_IEs_cellSelectionInfoCE_r13_Optional(acpCtx_t _ctx, const struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType1_v1310_IEs_cellSelectionInfoCE_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_CellSelectionInfoCE_r13(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e__ToString(SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms20: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms20";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms40: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms40";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms60: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms60";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms80: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms80";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms120: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms120";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms160: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms160";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms200: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms200";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_spare: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_spare";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e__ToString(SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_everyRF: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_everyRF";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every2ndRF: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every2ndRF";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every4thRF: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every4thRF";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every8thRF: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every8thRF";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SchedulingInfo_BR_r13_si_TBS_r13_e__ToString(SQN_SchedulingInfo_BR_r13_si_TBS_r13_e v)
{
	switch(v) {
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b152: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b152";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b208: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b208";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b256: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b256";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b328: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b328";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b408: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b408";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b504: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b504";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b600: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b600";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b712: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b712";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b808: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b808";
		case SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b936: return "SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b936";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SchedulingInfo_BR_r13(acpCtx_t _ctx, const struct SQN_SchedulingInfo_BR_r13* p)
{
	adbgPrintLog(_ctx, "si_Narrowband_r13 := %u", (unsigned int)p->si_Narrowband_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "si_TBS_r13 := %s (%d)", adbgSys__SQN_SchedulingInfo_BR_r13_si_TBS_r13_e__ToString(p->si_TBS_r13), (int)p->si_TBS_r13);
}

static void _adbgSys__SQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional(acpCtx_t _ctx, const struct SQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgSys__SQN_SchedulingInfo_BR_r13(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value(acpCtx_t _ctx, const union SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value* p, enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Sel d)
{
	if (d == SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_subframePattern10_r13) {
		adbgPrintLog(_ctx, "subframePattern10_r13 := '");
		for (size_t i1 = 0; i1 < 10; i1++) {
			adbgPrintLog(_ctx, "%02X", p->subframePattern10_r13[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_subframePattern40_r13) {
		adbgPrintLog(_ctx, "subframePattern40_r13 := '");
		for (size_t i1 = 0; i1 < 40; i1++) {
			adbgPrintLog(_ctx, "%02X", p->subframePattern40_r13[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13* p)
{
	_adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13(_ctx, &p->v);
}

static void _adbgSys__B10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional(acpCtx_t _ctx, const struct B10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 10; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e__ToString(SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e_on: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e_on";
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e_off: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e_off";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e__ToString(SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_true: return "SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_true";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e__ToString(p->v), (int)p->v);
}

static void _adbgSys__SQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13* p)
{
	adbgPrintLog(_ctx, "si_WindowLength_BR_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e__ToString(p->si_WindowLength_BR_r13), (int)p->si_WindowLength_BR_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "si_RepetitionPattern_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e__ToString(p->si_RepetitionPattern_r13), (int)p->si_RepetitionPattern_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "schedulingInfoList_BR_r13 := ");
	if (p->schedulingInfoList_BR_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional(_ctx, &p->schedulingInfoList_BR_r13);
	if (p->schedulingInfoList_BR_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "fdd_DownlinkOrTddSubframeBitmapBR_r13 := ");
	if (p->fdd_DownlinkOrTddSubframeBitmapBR_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional(_ctx, &p->fdd_DownlinkOrTddSubframeBitmapBR_r13);
	if (p->fdd_DownlinkOrTddSubframeBitmapBR_r13.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "fdd_UplinkSubframeBitmapBR_r13 := ");
	_adbgSys__B10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional(_ctx, &p->fdd_UplinkSubframeBitmapBR_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbolBR_r13 := %u", (unsigned int)p->startSymbolBR_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "si_HoppingConfigCommon_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e__ToString(p->si_HoppingConfigCommon_r13), (int)p->si_HoppingConfigCommon_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "si_ValidityTime_r13 := ");
	_adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional(_ctx, &p->si_ValidityTime_r13);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "systemInfoValueTagList_r13 := ");
	if (p->systemInfoValueTagList_r13.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgSys__SQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional(_ctx, &p->systemInfoValueTagList_r13);
	if (p->systemInfoValueTagList_r13.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_bandwidthReducedAccessRelatedInfo_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_bandwidthReducedAccessRelatedInfo_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e__ToString(SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_nb2: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_nb2";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_nb4: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_nb4";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_mpdcch_pdsch_HoppingNB_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_mpdcch_pdsch_HoppingNB_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e__ToString(p->v), (int)p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e__ToString(SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int1: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int1";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int2: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int2";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int4: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int4";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int8: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int8";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e__ToString(SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int1: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int1";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int5: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int5";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int10: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int10";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int20: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int20";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value(acpCtx_t _ctx, const union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value* p, enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Sel d)
{
	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13) {
		adbgPrintLog(_ctx, "interval_FDD_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e__ToString(p->interval_FDD_r13), (int)p->interval_FDD_r13);
		return;
	}
	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13) {
		adbgPrintLog(_ctx, "interval_TDD_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e__ToString(p->interval_TDD_r13), (int)p->interval_TDD_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13* p)
{
	_adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_DLHoppingConfigCommonModeA_r13_Optional(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_DLHoppingConfigCommonModeA_r13_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13(_ctx, &p->v);
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e__ToString(SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int2: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int2";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int4: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int4";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int8: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int8";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int16: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int16";
		default: return "Unknown";
	}
}

static const char* adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e__ToString(SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e v)
{
	switch(v) {
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int5: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int5";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int10: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int10";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int20: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int20";
		case SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int40: return "SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int40";
		default: return "Unknown";
	}
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value(acpCtx_t _ctx, const union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value* p, enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Sel d)
{
	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13) {
		adbgPrintLog(_ctx, "interval_FDD_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e__ToString(p->interval_FDD_r13), (int)p->interval_FDD_r13);
		return;
	}
	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13) {
		adbgPrintLog(_ctx, "interval_TDD_r13 := %s (%d)", adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e__ToString(p->interval_TDD_r13), (int)p->interval_TDD_r13);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13(acpCtx_t _ctx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13* p)
{
	_adbgSys__SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value(_ctx, &p->v, p->d);
}

static void _adbgSys__SQN_SystemInformationBlockType1_