/*
 * Copyright 2022 Sequans Communications.
 *
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.0  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

#include "adbgNrSys.h"

static const char* adbgNrSys__NR_CellId_Type__ToString(NR_CellId_Type v)
{
	switch(v) {
		case nr_Cell_NonSpecific: return "nr_Cell_NonSpecific";
		case nr_Cell1: return "nr_Cell1";
		case nr_Cell2: return "nr_Cell2";
		case nr_Cell3: return "nr_Cell3";
		case nr_Cell4: return "nr_Cell4";
		case nr_Cell6: return "nr_Cell6";
		case nr_Cell10: return "nr_Cell10";
		case nr_Cell11: return "nr_Cell11";
		case nr_Cell12: return "nr_Cell12";
		case nr_Cell13: return "nr_Cell13";
		case nr_Cell14: return "nr_Cell14";
		case nr_Cell23: return "nr_Cell23";
		case nr_Cell28: return "nr_Cell28";
		case nr_Cell29: return "nr_Cell29";
		case nr_Cell30: return "nr_Cell30";
		case nr_Cell31: return "nr_Cell31";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_RadioBearerId_Type_Value(acpCtx_t _ctx, const union NR_RadioBearerId_Type_Value* p, enum NR_RadioBearerId_Type_Sel d)
{
	if (d == NR_RadioBearerId_Type_Srb) {
		adbgPrintLog(_ctx, "Srb := %u", (unsigned int)p->Srb);
		return;
	}
	if (d == NR_RadioBearerId_Type_Drb) {
		adbgPrintLog(_ctx, "Drb := %u", (unsigned int)p->Drb);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_RadioBearerId_Type(acpCtx_t _ctx, const struct NR_RadioBearerId_Type* p)
{
	_adbgNrSys__NR_RadioBearerId_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__QosFlow_Identification_Type(acpCtx_t _ctx, const struct QosFlow_Identification_Type* p)
{
	adbgPrintLog(_ctx, "PDU_SessionId := %d", (int)p->PDU_SessionId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "QFI := %d", (int)p->QFI);
}

static void _adbgNrSys__NR_RoutingInfo_Type_Value(acpCtx_t _ctx, const union NR_RoutingInfo_Type_Value* p, enum NR_RoutingInfo_Type_Sel d)
{
	if (d == NR_RoutingInfo_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_RoutingInfo_Type_RadioBearerId) {
		adbgPrintLog(_ctx, "RadioBearerId := { ");
		_adbgNrSys__NR_RadioBearerId_Type(_ctx, &p->RadioBearerId);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_RoutingInfo_Type_QosFlow) {
		adbgPrintLog(_ctx, "QosFlow := { ");
		_adbgNrSys__QosFlow_Identification_Type(_ctx, &p->QosFlow);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_RoutingInfo_Type(acpCtx_t _ctx, const struct NR_RoutingInfo_Type* p)
{
	_adbgNrSys__NR_RoutingInfo_Type_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__EUTRA_CellId_Type__ToString(EUTRA_CellId_Type v)
{
	switch(v) {
		case eutra_Cell_NonSpecific: return "eutra_Cell_NonSpecific";
		case eutra_Cell1: return "eutra_Cell1";
		case eutra_Cell2: return "eutra_Cell2";
		case eutra_Cell3: return "eutra_Cell3";
		case eutra_Cell4: return "eutra_Cell4";
		case eutra_Cell6: return "eutra_Cell6";
		case eutra_Cell10: return "eutra_Cell10";
		case eutra_Cell11: return "eutra_Cell11";
		case eutra_Cell12: return "eutra_Cell12";
		case eutra_Cell13: return "eutra_Cell13";
		case eutra_Cell14: return "eutra_Cell14";
		case eutra_Cell23: return "eutra_Cell23";
		case eutra_Cell28: return "eutra_Cell28";
		case eutra_Cell29: return "eutra_Cell29";
		case eutra_Cell30: return "eutra_Cell30";
		case eutra_Cell31: return "eutra_Cell31";
		case eutra_CellA: return "eutra_CellA";
		case eutra_CellB: return "eutra_CellB";
		case eutra_CellC: return "eutra_CellC";
		case eutra_CellD: return "eutra_CellD";
		case eutra_CellE: return "eutra_CellE";
		case eutra_CellG: return "eutra_CellG";
		case eutra_CellH: return "eutra_CellH";
		case eutra_CellI: return "eutra_CellI";
		case eutra_CellJ: return "eutra_CellJ";
		case eutra_CellK: return "eutra_CellK";
		case eutra_CellL: return "eutra_CellL";
		case eutra_CellM: return "eutra_CellM";
		default: return "Unknown";
	}
}

static void _adbgNrSys__RlcBearerRouting_Type_Value(acpCtx_t _ctx, const union RlcBearerRouting_Type_Value* p, enum RlcBearerRouting_Type_Sel d)
{
	if (d == RlcBearerRouting_Type_EUTRA) {
		adbgPrintLog(_ctx, "EUTRA := %s (%d)", adbgNrSys__EUTRA_CellId_Type__ToString(p->EUTRA), (int)p->EUTRA);
		return;
	}
	if (d == RlcBearerRouting_Type_NR) {
		adbgPrintLog(_ctx, "NR := %s (%d)", adbgNrSys__NR_CellId_Type__ToString(p->NR), (int)p->NR);
		return;
	}
	if (d == RlcBearerRouting_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__RlcBearerRouting_Type(acpCtx_t _ctx, const struct RlcBearerRouting_Type* p)
{
	_adbgNrSys__RlcBearerRouting_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SystemFrameNumberInfo_Type_Value(acpCtx_t _ctx, const union SystemFrameNumberInfo_Type_Value* p, enum SystemFrameNumberInfo_Type_Sel d)
{
	if (d == SystemFrameNumberInfo_Type_Number) {
		adbgPrintLog(_ctx, "Number := %u", (unsigned int)p->Number);
		return;
	}
	if (d == SystemFrameNumberInfo_Type_Any) {
		adbgPrintLog(_ctx, "Any := %s", (p->Any ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SystemFrameNumberInfo_Type(acpCtx_t _ctx, const struct SystemFrameNumberInfo_Type* p)
{
	_adbgNrSys__SystemFrameNumberInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SubFrameInfo_Type_Value(acpCtx_t _ctx, const union SubFrameInfo_Type_Value* p, enum SubFrameInfo_Type_Sel d)
{
	if (d == SubFrameInfo_Type_Number) {
		adbgPrintLog(_ctx, "Number := %u", (unsigned int)p->Number);
		return;
	}
	if (d == SubFrameInfo_Type_Any) {
		adbgPrintLog(_ctx, "Any := %s", (p->Any ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SubFrameInfo_Type(acpCtx_t _ctx, const struct SubFrameInfo_Type* p)
{
	_adbgNrSys__SubFrameInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__HyperSystemFrameNumberInfo_Type(acpCtx_t _ctx, const HyperSystemFrameNumberInfo_Type* p)
{
	_adbgNrSys__SystemFrameNumberInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SlotOffset_Type_Value(acpCtx_t _ctx, const union SlotOffset_Type_Value* p, enum SlotOffset_Type_Sel d)
{
	if (d == SlotOffset_Type_Numerology0) {
		adbgPrintLog(_ctx, "Numerology0 := %s", (p->Numerology0 ? "true" : "false"));
		return;
	}
	if (d == SlotOffset_Type_Numerology1) {
		adbgPrintLog(_ctx, "Numerology1 := %u", (unsigned int)p->Numerology1);
		return;
	}
	if (d == SlotOffset_Type_Numerology2) {
		adbgPrintLog(_ctx, "Numerology2 := %u", (unsigned int)p->Numerology2);
		return;
	}
	if (d == SlotOffset_Type_Numerology3) {
		adbgPrintLog(_ctx, "Numerology3 := %u", (unsigned int)p->Numerology3);
		return;
	}
	if (d == SlotOffset_Type_Numerology4) {
		adbgPrintLog(_ctx, "Numerology4 := %u", (unsigned int)p->Numerology4);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SlotOffset_Type(acpCtx_t _ctx, const struct SlotOffset_Type* p)
{
	_adbgNrSys__SlotOffset_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SlotTimingInfo_Type_Value(acpCtx_t _ctx, const union SlotTimingInfo_Type_Value* p, enum SlotTimingInfo_Type_Sel d)
{
	if (d == SlotTimingInfo_Type_SlotOffset) {
		adbgPrintLog(_ctx, "SlotOffset := { ");
		_adbgNrSys__SlotOffset_Type(_ctx, &p->SlotOffset);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SlotTimingInfo_Type_FirstSlot) {
		adbgPrintLog(_ctx, "FirstSlot := %s", (p->FirstSlot ? "true" : "false"));
		return;
	}
	if (d == SlotTimingInfo_Type_Any) {
		adbgPrintLog(_ctx, "Any := %s", (p->Any ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SlotTimingInfo_Type(acpCtx_t _ctx, const struct SlotTimingInfo_Type* p)
{
	_adbgNrSys__SlotTimingInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SubFrameTiming_Type(acpCtx_t _ctx, const struct SubFrameTiming_Type* p)
{
	adbgPrintLog(_ctx, "SFN := { ");
	_adbgNrSys__SystemFrameNumberInfo_Type(_ctx, &p->SFN);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Subframe := { ");
	_adbgNrSys__SubFrameInfo_Type(_ctx, &p->Subframe);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "HSFN := { ");
	_adbgNrSys__HyperSystemFrameNumberInfo_Type(_ctx, &p->HSFN);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Slot := { ");
	_adbgNrSys__SlotTimingInfo_Type(_ctx, &p->Slot);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__TimingInfo_Type_Value(acpCtx_t _ctx, const union TimingInfo_Type_Value* p, enum TimingInfo_Type_Sel d)
{
	if (d == TimingInfo_Type_SubFrame) {
		adbgPrintLog(_ctx, "SubFrame := { ");
		_adbgNrSys__SubFrameTiming_Type(_ctx, &p->SubFrame);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == TimingInfo_Type_Now) {
		adbgPrintLog(_ctx, "Now := %s", (p->Now ? "true" : "false"));
		return;
	}
	if (d == TimingInfo_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__TimingInfo_Type(acpCtx_t _ctx, const struct TimingInfo_Type* p)
{
	_adbgNrSys__TimingInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__ReqAspControlInfo_Type(acpCtx_t _ctx, const struct ReqAspControlInfo_Type* p)
{
	adbgPrintLog(_ctx, "CnfFlag := %s", (p->CnfFlag ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "FollowOnFlag := %s", (p->FollowOnFlag ? "true" : "false"));
}

static void _adbgNrSys__NR_ReqAspCommonPart_Type(acpCtx_t _ctx, const struct NR_ReqAspCommonPart_Type* p)
{
	adbgPrintLog(_ctx, "CellId := %s (%d)", adbgNrSys__NR_CellId_Type__ToString(p->CellId), (int)p->CellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RoutingInfo := { ");
	_adbgNrSys__NR_RoutingInfo_Type(_ctx, &p->RoutingInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RlcBearerRouting := { ");
	_adbgNrSys__RlcBearerRouting_Type(_ctx, &p->RlcBearerRouting);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TimingInfo := { ");
	_adbgNrSys__TimingInfo_Type(_ctx, &p->TimingInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ControlInfo := { ");
	_adbgNrSys__ReqAspControlInfo_Type(_ctx, &p->ControlInfo);
	adbgPrintLog(_ctx, " }");
}

static const char* adbgNrSys__NR_CellCapability_Type__ToString(NR_CellCapability_Type v)
{
	switch(v) {
		case NR_CellCapability_broadcastOnlyCell: return "NR_CellCapability_broadcastOnlyCell";
		case NR_CellCapability_minimumUplinkCell: return "NR_CellCapability_minimumUplinkCell";
		case NR_CellCapability_fullCell: return "NR_CellCapability_fullCell";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__NR_CellInitialCAConfig_Type__ToString(NR_CellInitialCAConfig_Type v)
{
	switch(v) {
		case NR_CellInitialCAConfig_SpCell: return "NR_CellInitialCAConfig_SpCell";
		case NR_CellInitialCAConfig_Scell_Active: return "NR_CellInitialCAConfig_Scell_Active";
		case NR_CellInitialCAConfig_Scell_Inactive: return "NR_CellInitialCAConfig_Scell_Inactive";
		case NR_CellInitialCAConfig_Scell_None: return "NR_CellInitialCAConfig_Scell_None";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_SS_StaticCellResourceConfig_Type(acpCtx_t _ctx, const struct NR_SS_StaticCellResourceConfig_Type* p)
{
	adbgPrintLog(_ctx, "CellCapability := %s (%d)", adbgNrSys__NR_CellCapability_Type__ToString(p->CellCapability), (int)p->CellCapability);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CarrierAggregation := %s (%d)", adbgNrSys__NR_CellInitialCAConfig_Type__ToString(p->CarrierAggregation), (int)p->CarrierAggregation);
}

static void _adbgNrSys__NR_SS_StaticCellResourceConfig_Type_StaticResourceConfig_Optional(acpCtx_t _ctx, const struct NR_SS_StaticCellResourceConfig_Type_StaticResourceConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SS_StaticCellResourceConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__RNTI_Value_Type_C_RNTI_Optional(acpCtx_t _ctx, const struct RNTI_Value_Type_C_RNTI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_TcOffset_Optional(acpCtx_t _ctx, const struct uint8_t_TcOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__CellTimingInfo_Type(acpCtx_t _ctx, const struct CellTimingInfo_Type* p)
{
	adbgPrintLog(_ctx, "TcOffset := ");
	_adbgNrSys__Uint8_t_TcOffset_Optional(_ctx, &p->TcOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Tcell := %u", (unsigned int)p->Tcell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SfnOffset := %u", (unsigned int)p->SfnOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "HsfnOffset := %u", (unsigned int)p->HsfnOffset);
}

static void _adbgNrSys__CellTimingInfo_Type_CellTimingInfo_Optional(acpCtx_t _ctx, const struct CellTimingInfo_Type_CellTimingInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__CellTimingInfo_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_Attenuation_Type_Value(acpCtx_t _ctx, const union NR_Attenuation_Type_Value* p, enum NR_Attenuation_Type_Sel d)
{
	if (d == NR_Attenuation_Type_Value) {
		adbgPrintLog(_ctx, "Value := %u", (unsigned int)p->Value);
		return;
	}
	if (d == NR_Attenuation_Type_Off) {
		adbgPrintLog(_ctx, "Off := %s", (p->Off ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_InitialAttenuation_Type(acpCtx_t _ctx, const NR_InitialAttenuation_Type* p)
{
	_adbgNrSys__NR_Attenuation_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_InitialCellPower_Type(acpCtx_t _ctx, const struct NR_InitialCellPower_Type* p)
{
	adbgPrintLog(_ctx, "MaxReferencePower := %d", (int)p->MaxReferencePower);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Attenuation := { ");
	_adbgNrSys__NR_InitialAttenuation_Type(_ctx, &p->Attenuation);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__NR_InitialCellPower_Type_InitialCellPower_Optional(acpCtx_t _ctx, const struct NR_InitialCellPower_Type_InitialCellPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_InitialCellPower_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_CellConfigCommon_Type(acpCtx_t _ctx, const struct NR_CellConfigCommon_Type* p)
{
	adbgPrintLog(_ctx, "C_RNTI := ");
	_adbgNrSys__RNTI_Value_Type_C_RNTI_Optional(_ctx, &p->C_RNTI);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CellTimingInfo := ");
	if (p->CellTimingInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__CellTimingInfo_Type_CellTimingInfo_Optional(_ctx, &p->CellTimingInfo);
	if (p->CellTimingInfo.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "InitialCellPower := ");
	if (p->InitialCellPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_InitialCellPower_Type_InitialCellPower_Optional(_ctx, &p->InitialCellPower);
	if (p->InitialCellPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_CellConfigCommon_Type_CellConfigCommon_Optional(acpCtx_t _ctx, const struct NR_CellConfigCommon_Type_CellConfigCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CellConfigCommon_Type(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PhysCellId_PhysicalCellId_Optional(acpCtx_t _ctx, const struct SQN_NR_PhysCellId_PhysicalCellId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__NR_FDD_Info_Type(acpCtx_t _ctx, const struct NR_FDD_Info_Type* p)
{
	(void)_ctx;
	(void)p;
}

static const char* adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(SQN_NR_SubcarrierSpacing_e v)
{
	switch(v) {
		case SQN_NR_SubcarrierSpacing_e_kHz15: return "SQN_NR_SubcarrierSpacing_e_kHz15";
		case SQN_NR_SubcarrierSpacing_e_kHz30: return "SQN_NR_SubcarrierSpacing_e_kHz30";
		case SQN_NR_SubcarrierSpacing_e_kHz60: return "SQN_NR_SubcarrierSpacing_e_kHz60";
		case SQN_NR_SubcarrierSpacing_e_kHz120: return "SQN_NR_SubcarrierSpacing_e_kHz120";
		case SQN_NR_SubcarrierSpacing_e_kHz240: return "SQN_NR_SubcarrierSpacing_e_kHz240";
		case SQN_NR_SubcarrierSpacing_e_spare3: return "SQN_NR_SubcarrierSpacing_e_spare3";
		case SQN_NR_SubcarrierSpacing_e_spare2: return "SQN_NR_SubcarrierSpacing_e_spare2";
		case SQN_NR_SubcarrierSpacing_e_spare1: return "SQN_NR_SubcarrierSpacing_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e__ToString(SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e v)
{
	switch(v) {
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms0p5: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms0p5";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms0p625: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms0p625";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms1: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms1";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms1p25: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms1p25";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms2: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms2";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms2p5: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms2p5";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms5: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms5";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms10: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e_ms10";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e__ToString(SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e v)
{
	switch(v) {
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_ms3: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_ms3";
		case SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_ms4: return "SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_ms4";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_dl_UL_TransmissionPeriodicity_v1530_Optional(acpCtx_t _ctx, const struct SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_dl_UL_TransmissionPeriodicity_v1530_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_Pattern(acpCtx_t _ctx, const struct SQN_NR_TDD_UL_DL_Pattern* p)
{
	adbgPrintLog(_ctx, "dl_UL_TransmissionPeriodicity := %s (%d)", adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_e__ToString(p->dl_UL_TransmissionPeriodicity), (int)p->dl_UL_TransmissionPeriodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofDownlinkSlots := %u", (unsigned int)p->nrofDownlinkSlots);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofDownlinkSymbols := %u", (unsigned int)p->nrofDownlinkSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofUplinkSlots := %u", (unsigned int)p->nrofUplinkSlots);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofUplinkSymbols := %u", (unsigned int)p->nrofUplinkSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dl_UL_TransmissionPeriodicity_v1530 := ");
	_adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_dl_UL_TransmissionPeriodicity_v1530_Optional(_ctx, &p->dl_UL_TransmissionPeriodicity_v1530);
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_SQN_NR_TDD_UL_DL_ConfigCommon_pattern2_Optional(acpCtx_t _ctx, const struct SQN_NR_TDD_UL_DL_Pattern_SQN_NR_TDD_UL_DL_ConfigCommon_pattern2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_TDD_UL_DL_Pattern(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_TDD_UL_DL_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "referenceSubcarrierSpacing := %s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->referenceSubcarrierSpacing), (int)p->referenceSubcarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pattern1 := { ");
	_adbgNrSys__SQN_NR_TDD_UL_DL_Pattern(_ctx, &p->pattern1);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pattern2 := ");
	if (p->pattern2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_TDD_UL_DL_Pattern_SQN_NR_TDD_UL_DL_ConfigCommon_pattern2_Optional(_ctx, &p->pattern2);
	if (p->pattern2.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Value(acpCtx_t _ctx, const union NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Value* p, enum NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Sel d)
{
	if (d == NR_ASN1_TDD_UL_DL_ConfigCommon_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_TDD_UL_DL_ConfigCommon(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_TDD_UL_DL_ConfigCommon_Type(acpCtx_t _ctx, const struct NR_ASN1_TDD_UL_DL_ConfigCommon_Type* p)
{
	_adbgNrSys__NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Common_Optional(acpCtx_t _ctx, const struct NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Common_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_TDD_UL_DL_ConfigCommon_Type(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofDownlinkSymbols_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofDownlinkSymbols_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofUplinkSymbols_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofUplinkSymbols_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_(acpCtx_t _ctx, const struct SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_* p)
{
	adbgPrintLog(_ctx, "nrofDownlinkSymbols := ");
	_adbgNrSys__Uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofDownlinkSymbols_Optional(_ctx, &p->nrofDownlinkSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofUplinkSymbols := ");
	_adbgNrSys__Uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofUplinkSymbols_Optional(_ctx, &p->nrofUplinkSymbols);
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig_symbols_Value(acpCtx_t _ctx, const union SQN_NR_TDD_UL_DL_SlotConfig_symbols_Value* p, enum SQN_NR_TDD_UL_DL_SlotConfig_symbols_Sel d)
{
	if (d == SQN_NR_TDD_UL_DL_SlotConfig_symbols_allDownlink) {
		adbgPrintLog(_ctx, "allDownlink := %s", (p->allDownlink ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_TDD_UL_DL_SlotConfig_symbols_allUplink) {
		adbgPrintLog(_ctx, "allUplink := %s", (p->allUplink ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_) {
		adbgPrintLog(_ctx, "explicit_ := { ");
		_adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_(_ctx, &p->explicit_);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig_symbols(acpCtx_t _ctx, const struct SQN_NR_TDD_UL_DL_SlotConfig_symbols* p)
{
	_adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig_symbols_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig(acpCtx_t _ctx, const struct SQN_NR_TDD_UL_DL_SlotConfig* p)
{
	adbgPrintLog(_ctx, "slotIndex := %u", (unsigned int)p->slotIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "symbols := { ");
	_adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig_symbols(_ctx, &p->symbols);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__NR_ASN1_TDD_UL_DL_SlotConfig_Type_Value(acpCtx_t _ctx, const union NR_ASN1_TDD_UL_DL_SlotConfig_Type_Value* p, enum NR_ASN1_TDD_UL_DL_SlotConfig_Type_Sel d)
{
	if (d == NR_ASN1_TDD_UL_DL_SlotConfig_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_TDD_UL_DL_SlotConfig(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_TDD_UL_DL_SlotConfig_Type(acpCtx_t _ctx, const struct NR_ASN1_TDD_UL_DL_SlotConfig_Type* p)
{
	_adbgNrSys__NR_ASN1_TDD_UL_DL_SlotConfig_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_TDD_UL_DL_SlotConfigList_Type_Dedicated_Optional(acpCtx_t _ctx, const struct NR_TDD_UL_DL_SlotConfigList_Type_Dedicated_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_ASN1_TDD_UL_DL_SlotConfig_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_TDD_Config_Type(acpCtx_t _ctx, const struct NR_TDD_Config_Type* p)
{
	adbgPrintLog(_ctx, "Common := ");
	if (p->Common.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Common_Optional(_ctx, &p->Common);
	if (p->Common.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Dedicated := ");
	if (p->Dedicated.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_TDD_UL_DL_SlotConfigList_Type_Dedicated_Optional(_ctx, &p->Dedicated);
	if (p->Dedicated.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_TDD_Info_Type_Value(acpCtx_t _ctx, const union NR_TDD_Info_Type_Value* p, enum NR_TDD_Info_Type_Sel d)
{
	if (d == NR_TDD_Info_Type_Config) {
		adbgPrintLog(_ctx, "Config := { ");
		_adbgNrSys__NR_TDD_Config_Type(_ctx, &p->Config);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_TDD_Info_Type_FullFlexible) {
		adbgPrintLog(_ctx, "FullFlexible := %s", (p->FullFlexible ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_TDD_Info_Type(acpCtx_t _ctx, const struct NR_TDD_Info_Type* p)
{
	_adbgNrSys__NR_TDD_Info_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DuplexMode_Type_Value(acpCtx_t _ctx, const union NR_DuplexMode_Type_Value* p, enum NR_DuplexMode_Type_Sel d)
{
	if (d == NR_DuplexMode_Type_FDD) {
		adbgPrintLog(_ctx, "FDD := { ");
		_adbgNrSys__NR_FDD_Info_Type(_ctx, &p->FDD);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_DuplexMode_Type_TDD) {
		adbgPrintLog(_ctx, "TDD := { ");
		_adbgNrSys__NR_TDD_Info_Type(_ctx, &p->TDD);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DuplexMode_Type(acpCtx_t _ctx, const struct NR_DuplexMode_Type* p)
{
	_adbgNrSys__NR_DuplexMode_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DuplexMode_Type_DuplexMode_Optional(acpCtx_t _ctx, const struct NR_DuplexMode_Type_DuplexMode_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DuplexMode_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_CellConfigPhysicalLayerCommon_Type(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayerCommon_Type* p)
{
	adbgPrintLog(_ctx, "PhysicalCellId := ");
	_adbgNrSys__SQN_NR_PhysCellId_PhysicalCellId_Optional(_ctx, &p->PhysicalCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DuplexMode := ");
	if (p->DuplexMode.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DuplexMode_Type_DuplexMode_Optional(_ctx, &p->DuplexMode);
	if (p->DuplexMode.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_CellConfigPhysicalLayerCommon_Type_Common_Optional(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayerCommon_Type_Common_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CellConfigPhysicalLayerCommon_Type(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoDL_absoluteFrequencySSB_Optional(acpCtx_t _ctx, const struct SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoDL_absoluteFrequencySSB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_SCS_SpecificCarrier_txDirectCurrentLocation_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_SCS_SpecificCarrier_txDirectCurrentLocation_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SCS_SpecificCarrier(acpCtx_t _ctx, const struct SQN_NR_SCS_SpecificCarrier* p)
{
	adbgPrintLog(_ctx, "offsetToCarrier := %u", (unsigned int)p->offsetToCarrier);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subcarrierSpacing := %s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->subcarrierSpacing), (int)p->subcarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierBandwidth := %u", (unsigned int)p->carrierBandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txDirectCurrentLocation := ");
	_adbgNrSys__Uint16_t_SQN_NR_SCS_SpecificCarrier_txDirectCurrentLocation_Optional(_ctx, &p->txDirectCurrentLocation);
}

static void _adbgNrSys__SQN_NR_FrequencyInfoDL(acpCtx_t _ctx, const struct SQN_NR_FrequencyInfoDL* p)
{
	adbgPrintLog(_ctx, "absoluteFrequencySSB := ");
	_adbgNrSys__SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoDL_absoluteFrequencySSB_Optional(_ctx, &p->absoluteFrequencySSB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyBandList := '");
	for (size_t i1 = 0; i1 < p->frequencyBandList.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->frequencyBandList.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "absoluteFrequencyPointA := %u", (unsigned int)p->absoluteFrequencyPointA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scs_SpecificCarrierList := { ");
	for (size_t i1 = 0; i1 < p->scs_SpecificCarrierList.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SCS_SpecificCarrier(_ctx, &p->scs_SpecificCarrierList.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->scs_SpecificCarrierList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__NR_ASN1_FrequencyInfoDL_Type_Value(acpCtx_t _ctx, const union NR_ASN1_FrequencyInfoDL_Type_Value* p, enum NR_ASN1_FrequencyInfoDL_Type_Sel d)
{
	if (d == NR_ASN1_FrequencyInfoDL_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_FrequencyInfoDL(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_FrequencyInfoDL_Type(acpCtx_t _ctx, const struct NR_ASN1_FrequencyInfoDL_Type* p)
{
	_adbgNrSys__NR_ASN1_FrequencyInfoDL_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_FrequencyInfoDL_Type_FrequencyInfoDL_Optional(acpCtx_t _ctx, const struct NR_ASN1_FrequencyInfoDL_Type_FrequencyInfoDL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_FrequencyInfoDL_Type(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SubcarrierSpacing_e_SubCarrierSpacing_Optional(acpCtx_t _ctx, const struct SQN_NR_SubcarrierSpacing_e_SubCarrierSpacing_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Int32_t_NR_SSB_Config_Type_SubcarrierOffset_Optional(acpCtx_t _ctx, const struct int32_t_NR_SSB_Config_Type_SubcarrierOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static const char* adbgNrSys__NR_SSB_Periodicity_Type__ToString(NR_SSB_Periodicity_Type v)
{
	switch(v) {
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms5: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms5";
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms10: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms10";
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms20: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms20";
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms40: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms40";
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms80: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms80";
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms160: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_ms160";
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_spare2: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_spare2";
		case SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_spare1: return "SQN_NR_ServingCellConfigCommon_ssb_periodicityServingCell_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_SSB_Periodicity_Type_Periodicity_Optional(acpCtx_t _ctx, const struct NR_SSB_Periodicity_Type_Periodicity_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_SSB_Periodicity_Type__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Int32_t_NR_SSB_Config_Type_HalfFrameOffset_Optional(acpCtx_t _ctx, const struct int32_t_NR_SSB_Config_Type_HalfFrameOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static const char* adbgNrSys__NR_SS_BlockPattern_Type__ToString(NR_SS_BlockPattern_Type v)
{
	switch(v) {
		case NR_SS_BlockPattern_caseA: return "NR_SS_BlockPattern_caseA";
		case NR_SS_BlockPattern_caseB: return "NR_SS_BlockPattern_caseB";
		case NR_SS_BlockPattern_caseC: return "NR_SS_BlockPattern_caseC";
		case NR_SS_BlockPattern_caseD: return "NR_SS_BlockPattern_caseD";
		case NR_SS_BlockPattern_caseE: return "NR_SS_BlockPattern_caseE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_SS_BlockPattern_Type_BlockPattern_Optional(acpCtx_t _ctx, const struct NR_SS_BlockPattern_Type_BlockPattern_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_SS_BlockPattern_Type__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Value(acpCtx_t _ctx, const union SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Value* p, enum SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Sel d)
{
	if (d == SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_shortBitmap) {
		adbgPrintLog(_ctx, "shortBitmap := '");
		for (size_t i1 = 0; i1 < 4; i1++) {
			adbgPrintLog(_ctx, "%02X", p->shortBitmap[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_mediumBitmap) {
		adbgPrintLog(_ctx, "mediumBitmap := '");
		for (size_t i1 = 0; i1 < 8; i1++) {
			adbgPrintLog(_ctx, "%02X", p->mediumBitmap[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_longBitmap) {
		adbgPrintLog(_ctx, "longBitmap := '");
		for (size_t i1 = 0; i1 < 64; i1++) {
			adbgPrintLog(_ctx, "%02X", p->longBitmap[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_SSB_PositionsInBurst_Type(acpCtx_t _ctx, const NR_SSB_PositionsInBurst_Type* p)
{
	_adbgNrSys__SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_SSB_PositionsInBurst_Type_PositionsInBurst_Optional(acpCtx_t _ctx, const struct NR_SSB_PositionsInBurst_Type_PositionsInBurst_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SSB_PositionsInBurst_Type(_ctx, &p->v);
}

static void _adbgNrSys__Int32_t_NR_SSB_Beam_Type_SsbIndex_Optional(acpCtx_t _ctx, const struct int32_t_NR_SSB_Beam_Type_SsbIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int32_t_NR_SSB_Beam_Type_Attenuation_Optional(acpCtx_t _ctx, const struct int32_t_NR_SSB_Beam_Type_Attenuation_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_SSB_Beam_Type(acpCtx_t _ctx, const struct NR_SSB_Beam_Type* p)
{
	adbgPrintLog(_ctx, "SsbIndex := ");
	_adbgNrSys__Int32_t_NR_SSB_Beam_Type_SsbIndex_Optional(_ctx, &p->SsbIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Attenuation := ");
	_adbgNrSys__Int32_t_NR_SSB_Beam_Type_Attenuation_Optional(_ctx, &p->Attenuation);
}

static void _adbgNrSys__NR_SSB_BeamArray_Type_BeamArray_Optional(acpCtx_t _ctx, const struct NR_SSB_BeamArray_Type_BeamArray_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_SSB_Beam_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_SSB_BurstConfig_Type(acpCtx_t _ctx, const struct NR_SSB_BurstConfig_Type* p)
{
	adbgPrintLog(_ctx, "BlockPattern := ");
	_adbgNrSys__NR_SS_BlockPattern_Type_BlockPattern_Optional(_ctx, &p->BlockPattern);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PositionsInBurst := ");
	if (p->PositionsInBurst.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SSB_PositionsInBurst_Type_PositionsInBurst_Optional(_ctx, &p->PositionsInBurst);
	if (p->PositionsInBurst.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BeamArray := ");
	if (p->BeamArray.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SSB_BeamArray_Type_BeamArray_Optional(_ctx, &p->BeamArray);
	if (p->BeamArray.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_SSB_BurstConfig_Type_BurstConfig_Optional(acpCtx_t _ctx, const struct NR_SSB_BurstConfig_Type_BurstConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SSB_BurstConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_PbchToDmrs_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_PbchToDmrs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_PssToSss_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_PssToSss_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_SssToSsbBeam_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_SssToSsbBeam_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_DmrsToSss_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_DmrsToSss_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_SSB_EPREs_Type(acpCtx_t _ctx, const struct NR_SSB_EPREs_Type* p)
{
	adbgPrintLog(_ctx, "PbchToDmrs := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_PbchToDmrs_Optional(_ctx, &p->PbchToDmrs);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PssToSss := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_PssToSss_Optional(_ctx, &p->PssToSss);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SssToSsbBeam := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_SssToSsbBeam_Optional(_ctx, &p->SssToSsbBeam);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DmrsToSss := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_DmrsToSss_Optional(_ctx, &p->DmrsToSss);
}

static void _adbgNrSys__NR_SSB_EPREs_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct NR_SSB_EPREs_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SSB_EPREs_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_SSB_Config_Type(acpCtx_t _ctx, const struct NR_SSB_Config_Type* p)
{
	adbgPrintLog(_ctx, "SubCarrierSpacing := ");
	_adbgNrSys__SQN_NR_SubcarrierSpacing_e_SubCarrierSpacing_Optional(_ctx, &p->SubCarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SubcarrierOffset := ");
	_adbgNrSys__Int32_t_NR_SSB_Config_Type_SubcarrierOffset_Optional(_ctx, &p->SubcarrierOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Periodicity := ");
	_adbgNrSys__NR_SSB_Periodicity_Type_Periodicity_Optional(_ctx, &p->Periodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "HalfFrameOffset := ");
	_adbgNrSys__Int32_t_NR_SSB_Config_Type_HalfFrameOffset_Optional(_ctx, &p->HalfFrameOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BurstConfig := ");
	if (p->BurstConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SSB_BurstConfig_Type_BurstConfig_Optional(_ctx, &p->BurstConfig);
	if (p->BurstConfig.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SSB_EPREs_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_SSB_Config_Type_SSPbchBlock_Optional(acpCtx_t _ctx, const struct NR_SSB_Config_Type_SSPbchBlock_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SSB_Config_Type(_ctx, &p->v);
}

static const char* adbgNrSys__NR_PDSCH_DMRS_TypeA_Position_Type__ToString(NR_PDSCH_DMRS_TypeA_Position_Type v)
{
	switch(v) {
		case SQN_NR_MIB_dmrs_TypeA_Position_e_pos2: return "SQN_NR_MIB_dmrs_TypeA_Position_e_pos2";
		case SQN_NR_MIB_dmrs_TypeA_Position_e_pos3: return "SQN_NR_MIB_dmrs_TypeA_Position_e_pos3";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_PDSCH_DMRS_TypeA_Position_Type_DMRS_TypeA_Position_Optional(acpCtx_t _ctx, const struct NR_PDSCH_DMRS_TypeA_Position_Type_DMRS_TypeA_Position_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_PDSCH_DMRS_TypeA_Position_Type__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Value(acpCtx_t _ctx, const union SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Value* p, enum SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Sel d)
{
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_oneSlot) {
		adbgPrintLog(_ctx, "oneSlot := '");
		for (size_t i2 = 0; i2 < 14; i2++) {
			adbgPrintLog(_ctx, "%02X", p->oneSlot[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_twoSlots) {
		adbgPrintLog(_ctx, "twoSlots := '");
		for (size_t i2 = 0; i2 < 28; i2++) {
			adbgPrintLog(_ctx, "%02X", p->twoSlots[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock(acpCtx_t _ctx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock* p)
{
	_adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Value(acpCtx_t _ctx, const union SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Value* p, enum SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Sel d)
{
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n2) {
		adbgPrintLog(_ctx, "n2 := '");
		for (size_t i2 = 0; i2 < 2; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n2[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n4) {
		adbgPrintLog(_ctx, "n4 := '");
		for (size_t i2 = 0; i2 < 4; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n4[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n5) {
		adbgPrintLog(_ctx, "n5 := '");
		for (size_t i2 = 0; i2 < 5; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n5[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n8) {
		adbgPrintLog(_ctx, "n8 := '");
		for (size_t i2 = 0; i2 < 8; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n8[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n10) {
		adbgPrintLog(_ctx, "n10 := '");
		for (size_t i2 = 0; i2 < 10; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n10[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n20) {
		adbgPrintLog(_ctx, "n20 := '");
		for (size_t i2 = 0; i2 < 20; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n20[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n40) {
		adbgPrintLog(_ctx, "n40 := '");
		for (size_t i2 = 0; i2 < 40; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n40[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern(acpCtx_t _ctx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern* p)
{
	_adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_periodicityAndPattern_Optional(acpCtx_t _ctx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_periodicityAndPattern_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps(acpCtx_t _ctx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps* p)
{
	adbgPrintLog(_ctx, "resourceBlocks := '");
	for (size_t i2 = 0; i2 < 275; i2++) {
		adbgPrintLog(_ctx, "%02X", p->resourceBlocks[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "symbolsInResourceBlock := { ");
	_adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock(_ctx, &p->symbolsInResourceBlock);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicityAndPattern := ");
	if (p->periodicityAndPattern.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_periodicityAndPattern_Optional(_ctx, &p->periodicityAndPattern);
	if (p->periodicityAndPattern.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType_Value(acpCtx_t _ctx, const union SQN_NR_RateMatchPattern_patternType_Value* p, enum SQN_NR_RateMatchPattern_patternType_Sel d)
{
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps) {
		adbgPrintLog(_ctx, "bitmaps := { ");
		_adbgNrSys__SQN_NR_RateMatchPattern_patternType_bitmaps(_ctx, &p->bitmaps);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_controlResourceSet) {
		adbgPrintLog(_ctx, "controlResourceSet := %u", (unsigned int)p->controlResourceSet);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_patternType(acpCtx_t _ctx, const struct SQN_NR_RateMatchPattern_patternType* p)
{
	_adbgNrSys__SQN_NR_RateMatchPattern_patternType_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_RateMatchPattern_subcarrierSpacing_Optional(acpCtx_t _ctx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_RateMatchPattern_subcarrierSpacing_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_RateMatchPattern_dummy_e__ToString(SQN_NR_RateMatchPattern_dummy_e v)
{
	switch(v) {
		case SQN_NR_RateMatchPattern_dummy_e_dynamic: return "SQN_NR_RateMatchPattern_dummy_e_dynamic";
		case SQN_NR_RateMatchPattern_dummy_e_semiStatic: return "SQN_NR_RateMatchPattern_dummy_e_semiStatic";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ControlResourceSetId_r16_SQN_NR_RateMatchPattern_controlResourceSet_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ControlResourceSetId_r16_SQN_NR_RateMatchPattern_controlResourceSet_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RateMatchPattern(acpCtx_t _ctx, const struct SQN_NR_RateMatchPattern* p)
{
	adbgPrintLog(_ctx, "rateMatchPatternId := %u", (unsigned int)p->rateMatchPatternId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "patternType := { ");
	_adbgNrSys__SQN_NR_RateMatchPattern_patternType(_ctx, &p->patternType);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subcarrierSpacing := ");
	_adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_RateMatchPattern_subcarrierSpacing_Optional(_ctx, &p->subcarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy := %s (%d)", adbgNrSys__SQN_NR_RateMatchPattern_dummy_e__ToString(p->dummy), (int)p->dummy);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "controlResourceSet_r16 := ");
	_adbgNrSys__SQN_NR_ControlResourceSetId_r16_SQN_NR_RateMatchPattern_controlResourceSet_r16_Optional(_ctx, &p->controlResourceSet_r16);
}

static void _adbgNrSys__NR_ASN1_RateMatchPattern_Type_Value(acpCtx_t _ctx, const union NR_ASN1_RateMatchPattern_Type_Value* p, enum NR_ASN1_RateMatchPattern_Type_Sel d)
{
	if (d == NR_ASN1_RateMatchPattern_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_RateMatchPattern(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_RateMatchPattern_Type(acpCtx_t _ctx, const struct NR_ASN1_RateMatchPattern_Type* p)
{
	_adbgNrSys__NR_ASN1_RateMatchPattern_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_RateMatchPatternList_Type_PatternList_Optional(acpCtx_t _ctx, const struct NR_RateMatchPatternList_Type_PatternList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_ASN1_RateMatchPattern_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e__ToString(SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e v)
{
	switch(v) {
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n6: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n6";
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n15: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n15";
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n25: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n25";
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n50: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n50";
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n75: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n75";
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n100: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_n100";
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_spare2: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_spare2";
		case SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_spare1: return "SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e__ToString(SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e v)
{
	switch(v) {
		case SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n1: return "SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n1";
		case SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n2: return "SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n2";
		case SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n4: return "SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n4";
		case SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n8: return "SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n8";
		case SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n16: return "SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n16";
		case SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n32: return "SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n32";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Value(acpCtx_t _ctx, const union SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Value* p, enum SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Sel d)
{
	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_oneFrame) {
		adbgPrintLog(_ctx, "oneFrame := '");
		for (size_t i3 = 0; i3 < 6; i3++) {
			adbgPrintLog(_ctx, "%02X", p->oneFrame[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_fourFrames) {
		adbgPrintLog(_ctx, "fourFrames := '");
		for (size_t i3 = 0; i3 < 24; i3++) {
			adbgPrintLog(_ctx, "%02X", p->fourFrames[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1(acpCtx_t _ctx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1* p)
{
	_adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Value(acpCtx_t _ctx, const union SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Value* p, enum SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Sel d)
{
	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_oneFrame) {
		adbgPrintLog(_ctx, "oneFrame := '");
		for (size_t i3 = 0; i3 < 2; i3++) {
			adbgPrintLog(_ctx, "%02X", p->oneFrame[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_fourFrames) {
		adbgPrintLog(_ctx, "fourFrames := '");
		for (size_t i3 = 0; i3 < 8; i3++) {
			adbgPrintLog(_ctx, "%02X", p->fourFrames[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2(acpCtx_t _ctx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2* p)
{
	_adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_subframeAllocation2_Optional(acpCtx_t _ctx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_subframeAllocation2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig(acpCtx_t _ctx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig* p)
{
	adbgPrintLog(_ctx, "radioframeAllocationPeriod := %s (%d)", adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_radioframeAllocationPeriod_e__ToString(p->radioframeAllocationPeriod), (int)p->radioframeAllocationPeriod);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "radioframeAllocationOffset := %u", (unsigned int)p->radioframeAllocationOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subframeAllocation1 := { ");
	_adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1(_ctx, &p->subframeAllocation1);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subframeAllocation2 := ");
	if (p->subframeAllocation2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_subframeAllocation2_Optional(_ctx, &p->subframeAllocation2);
	if (p->subframeAllocation2.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfigList_SQN_NR_RateMatchPatternLTE_CRS_mbsfn_SubframeConfigList_Optional(acpCtx_t _ctx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfigList_SQN_NR_RateMatchPatternLTE_CRS_mbsfn_SubframeConfigList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfig(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e__ToString(SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e v)
{
	switch(v) {
		case SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e_n1: return "SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e_n1";
		case SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e_n2: return "SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e_n2";
		case SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e_n4: return "SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e_n4";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e__ToString(SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e v)
{
	switch(v) {
		case SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n0: return "SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n0";
		case SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n1: return "SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n1";
		case SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n2: return "SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n2";
		case SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n3: return "SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n3";
		case SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n4: return "SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n4";
		case SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n5: return "SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e_n5";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS(acpCtx_t _ctx, const struct SQN_NR_RateMatchPatternLTE_CRS* p)
{
	adbgPrintLog(_ctx, "carrierFreqDL := %u", (unsigned int)p->carrierFreqDL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierBandwidthDL := %s (%d)", adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS_carrierBandwidthDL_e__ToString(p->carrierBandwidthDL), (int)p->carrierBandwidthDL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mbsfn_SubframeConfigList := ");
	if (p->mbsfn_SubframeConfigList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_EUTRA_MBSFN_SubframeConfigList_SQN_NR_RateMatchPatternLTE_CRS_mbsfn_SubframeConfigList_Optional(_ctx, &p->mbsfn_SubframeConfigList);
	if (p->mbsfn_SubframeConfigList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofCRS_Ports := %s (%d)", adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS_nrofCRS_Ports_e__ToString(p->nrofCRS_Ports), (int)p->nrofCRS_Ports);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "v_Shift := %s (%d)", adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS_v_Shift_e__ToString(p->v_Shift), (int)p->v_Shift);
}

static void _adbgNrSys__NR_ASN1_RateMatchPatternLTE_CRS_Type_Value(acpCtx_t _ctx, const union NR_ASN1_RateMatchPatternLTE_CRS_Type_Value* p, enum NR_ASN1_RateMatchPatternLTE_CRS_Type_Sel d)
{
	if (d == NR_ASN1_RateMatchPatternLTE_CRS_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_RateMatchPatternLTE_CRS(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_RateMatchPatternLTE_CRS_Type(acpCtx_t _ctx, const struct NR_ASN1_RateMatchPatternLTE_CRS_Type* p)
{
	_adbgNrSys__NR_ASN1_RateMatchPatternLTE_CRS_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_RateMatchPatternLteCrsList_Type_PatternListLteCrs_Optional(acpCtx_t _ctx, const struct NR_RateMatchPatternLteCrsList_Type_PatternListLteCrs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_ASN1_RateMatchPatternLTE_CRS_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_CellLevelRateMatchPattern_Type(acpCtx_t _ctx, const struct NR_CellLevelRateMatchPattern_Type* p)
{
	adbgPrintLog(_ctx, "PatternList := ");
	if (p->PatternList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_RateMatchPatternList_Type_PatternList_Optional(_ctx, &p->PatternList);
	if (p->PatternList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PatternListLteCrs := ");
	if (p->PatternListLteCrs.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_RateMatchPatternLteCrsList_Type_PatternListLteCrs_Optional(_ctx, &p->PatternListLteCrs);
	if (p->PatternListLteCrs.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_CellLevelRateMatchPattern_Type_RateMatchPattern_Optional(acpCtx_t _ctx, const struct NR_CellLevelRateMatchPattern_Type_RateMatchPattern_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CellLevelRateMatchPattern_Type(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e__ToString(SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n2: return "SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n2";
		case SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n4: return "SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n4";
		case SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n6: return "SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n6";
		case SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n8: return "SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_CodeBlockGroupTransmission(acpCtx_t _ctx, const struct SQN_NR_PDSCH_CodeBlockGroupTransmission* p)
{
	adbgPrintLog(_ctx, "maxCodeBlockGroupsPerTransportBlock := %s (%d)", adbgNrSys__SQN_NR_PDSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e__ToString(p->maxCodeBlockGroupsPerTransportBlock), (int)p->maxCodeBlockGroupsPerTransportBlock);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "codeBlockGroupFlushIndicator := %s", (p->codeBlockGroupFlushIndicator ? "true" : "false"));
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Value* p, enum SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PDSCH_CodeBlockGroupTransmission(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_xOverhead_e__ToString(SQN_NR_PDSCH_ServingCellConfig_xOverhead_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOh6: return "SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOh6";
		case SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOh12: return "SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOh12";
		case SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOh18: return "SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOh18";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_xOverhead_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e__ToString(SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n2: return "SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n2";
		case SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n4: return "SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n4";
		case SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n6: return "SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n6";
		case SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n10: return "SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n10";
		case SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n12: return "SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n12";
		case SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n16: return "SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_n16";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_nrofHARQ_ProcessesForPDSCH_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_nrofHARQ_ProcessesForPDSCH_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_PDSCH_ServingCellConfig_pucch_Cell_Optional(acpCtx_t _ctx, const struct SQN_NR_ServCellIndex_SQN_NR_PDSCH_ServingCellConfig_pucch_Cell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PDSCH_ServingCellConfig_maxMIMO_Layers_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PDSCH_ServingCellConfig_maxMIMO_Layers_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Bool_SQN_NR_PDSCH_ServingCellConfig_processingType2Enabled_Optional(acpCtx_t _ctx, const struct bool_SQN_NR_PDSCH_ServingCellConfig_processingType2Enabled_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i1 = 0; i1 < p->setup.d; i1++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PDSCH_CodeBlockGroupTransmission(_ctx, &p->setup.v[i1]);
			adbgPrintLog(_ctx, " }");
			if (i1 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_SQN_NR_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_SQN_NR_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PDSCH_ServingCellConfig(acpCtx_t _ctx, const struct SQN_NR_PDSCH_ServingCellConfig* p)
{
	adbgPrintLog(_ctx, "codeBlockGroupTransmission := ");
	if (p->codeBlockGroupTransmission.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(_ctx, &p->codeBlockGroupTransmission);
	if (p->codeBlockGroupTransmission.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "xOverhead := ");
	_adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(_ctx, &p->xOverhead);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofHARQ_ProcessesForPDSCH := ");
	_adbgNrSys__SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_nrofHARQ_ProcessesForPDSCH_Optional(_ctx, &p->nrofHARQ_ProcessesForPDSCH);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_Cell := ");
	_adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_PDSCH_ServingCellConfig_pucch_Cell_Optional(_ctx, &p->pucch_Cell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxMIMO_Layers := ");
	_adbgNrSys__Uint8_t_SQN_NR_PDSCH_ServingCellConfig_maxMIMO_Layers_Optional(_ctx, &p->maxMIMO_Layers);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "processingType2Enabled := ");
	_adbgNrSys__Bool_SQN_NR_PDSCH_ServingCellConfig_processingType2Enabled_Optional(_ctx, &p->processingType2Enabled);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_CodeBlockGroupTransmissionList_r16 := ");
	if (p->pdsch_CodeBlockGroupTransmissionList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_SQN_NR_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Optional(_ctx, &p->pdsch_CodeBlockGroupTransmissionList_r16);
	if (p->pdsch_CodeBlockGroupTransmissionList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_PDSCH_ServingCellConfig_Type_Value(acpCtx_t _ctx, const union NR_ASN1_PDSCH_ServingCellConfig_Type_Value* p, enum NR_ASN1_PDSCH_ServingCellConfig_Type_Sel d)
{
	if (d == NR_ASN1_PDSCH_ServingCellConfig_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_PDSCH_ServingCellConfig(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_PDSCH_ServingCellConfig_Type(acpCtx_t _ctx, const struct NR_ASN1_PDSCH_ServingCellConfig_Type* p)
{
	_adbgNrSys__NR_ASN1_PDSCH_ServingCellConfig_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_PDSCH_ServingCellConfig_Type_ServingCellConfig_Optional(acpCtx_t _ctx, const struct NR_ASN1_PDSCH_ServingCellConfig_Type_ServingCellConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_PDSCH_ServingCellConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_PDSCH_CellLevelConfig_Type(acpCtx_t _ctx, const struct NR_PDSCH_CellLevelConfig_Type* p)
{
	adbgPrintLog(_ctx, "DMRS_TypeA_Position := ");
	_adbgNrSys__NR_PDSCH_DMRS_TypeA_Position_Type_DMRS_TypeA_Position_Optional(_ctx, &p->DMRS_TypeA_Position);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RateMatchPattern := ");
	if (p->RateMatchPattern.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_CellLevelRateMatchPattern_Type_RateMatchPattern_Optional(_ctx, &p->RateMatchPattern);
	if (p->RateMatchPattern.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ServingCellConfig := ");
	if (p->ServingCellConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_PDSCH_ServingCellConfig_Type_ServingCellConfig_Optional(_ctx, &p->ServingCellConfig);
	if (p->ServingCellConfig.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_PDSCH_CellLevelConfig_Type_PdschCellLevelConfig_Optional(acpCtx_t _ctx, const struct NR_PDSCH_CellLevelConfig_Type_PdschCellLevelConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_PDSCH_CellLevelConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_BWP_Id_ActiveBWP_Optional(acpCtx_t _ctx, const struct SQN_NR_BWP_Id_ActiveBWP_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_BWP_Id_NR_DownlinkBWP_Type_Id_Optional(acpCtx_t _ctx, const struct SQN_NR_BWP_Id_NR_DownlinkBWP_Type_Id_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_BWP_cyclicPrefix_e__ToString(SQN_NR_BWP_cyclicPrefix_e v)
{
	switch(v) {
		case SQN_NR_BWP_cyclicPrefix_e_extended: return "SQN_NR_BWP_cyclicPrefix_e_extended";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_BWP_cyclicPrefix_e_cyclicPrefix_Optional(acpCtx_t _ctx, const struct SQN_NR_BWP_cyclicPrefix_e_cyclicPrefix_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_BWP_cyclicPrefix_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_BWP(acpCtx_t _ctx, const struct SQN_NR_BWP* p)
{
	adbgPrintLog(_ctx, "locationAndBandwidth := %u", (unsigned int)p->locationAndBandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subcarrierSpacing := %s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->subcarrierSpacing), (int)p->subcarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cyclicPrefix := ");
	_adbgNrSys__SQN_NR_BWP_cyclicPrefix_e_cyclicPrefix_Optional(_ctx, &p->cyclicPrefix);
}

static void _adbgNrSys__NR_ASN1_BWP_Type_Value(acpCtx_t _ctx, const union NR_ASN1_BWP_Type_Value* p, enum NR_ASN1_BWP_Type_Sel d)
{
	if (d == NR_ASN1_BWP_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_BWP(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_BWP_Type(acpCtx_t _ctx, const struct NR_ASN1_BWP_Type* p)
{
	_adbgNrSys__NR_ASN1_BWP_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_BWP_Type_BWP_Optional(acpCtx_t _ctx, const struct NR_ASN1_BWP_Type_BWP_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_BWP_Type(_ctx, &p->v);
}

static const char* adbgNrSys__NR_SearchSpaceType_Type__ToString(NR_SearchSpaceType_Type v)
{
	switch(v) {
		case NR_SearchSpaceType_cssType0: return "NR_SearchSpaceType_cssType0";
		case NR_SearchSpaceType_cssType0A: return "NR_SearchSpaceType_cssType0A";
		case NR_SearchSpaceType_cssType1: return "NR_SearchSpaceType_cssType1";
		case NR_SearchSpaceType_cssType2: return "NR_SearchSpaceType_cssType2";
		case NR_SearchSpaceType_cssType3: return "NR_SearchSpaceType_cssType3";
		case NR_SearchSpaceType_ussDL: return "NR_SearchSpaceType_ussDL";
		case NR_SearchSpaceType_ussUL: return "NR_SearchSpaceType_ussUL";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_SearchSpaceTypeAndPriority_Type(acpCtx_t _ctx, const struct NR_SearchSpaceTypeAndPriority_Type* p)
{
	adbgPrintLog(_ctx, "Type := %s (%d)", adbgNrSys__NR_SearchSpaceType_Type__ToString(p->Type), (int)p->Type);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CandidatePriority := %u", (unsigned int)p->CandidatePriority);
}

static const char* adbgNrSys__NR_PDCCH_CCE_AggregationLevel_Type__ToString(NR_PDCCH_CCE_AggregationLevel_Type v)
{
	switch(v) {
		case NR_PDCCH_CCE_AggregationLevel_AggregationLevel1: return "NR_PDCCH_CCE_AggregationLevel_AggregationLevel1";
		case NR_PDCCH_CCE_AggregationLevel_AggregationLevel2: return "NR_PDCCH_CCE_AggregationLevel_AggregationLevel2";
		case NR_PDCCH_CCE_AggregationLevel_AggregationLevel4: return "NR_PDCCH_CCE_AggregationLevel_AggregationLevel4";
		case NR_PDCCH_CCE_AggregationLevel_AggregationLevel8: return "NR_PDCCH_CCE_AggregationLevel_AggregationLevel8";
		case NR_PDCCH_CCE_AggregationLevel_AggregationLevel16: return "NR_PDCCH_CCE_AggregationLevel_AggregationLevel16";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ControlResourceSetId_SQN_NR_SearchSpace_controlResourceSetId_Optional(acpCtx_t _ctx, const struct SQN_NR_ControlResourceSetId_SQN_NR_SearchSpace_controlResourceSetId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Value(acpCtx_t _ctx, const union SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Value* p, enum SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Sel d)
{
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl1) {
		adbgPrintLog(_ctx, "sl1 := %s", (p->sl1 ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl2) {
		adbgPrintLog(_ctx, "sl2 := %u", (unsigned int)p->sl2);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl4) {
		adbgPrintLog(_ctx, "sl4 := %u", (unsigned int)p->sl4);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl5) {
		adbgPrintLog(_ctx, "sl5 := %u", (unsigned int)p->sl5);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl8) {
		adbgPrintLog(_ctx, "sl8 := %u", (unsigned int)p->sl8);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl10) {
		adbgPrintLog(_ctx, "sl10 := %u", (unsigned int)p->sl10);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl16) {
		adbgPrintLog(_ctx, "sl16 := %u", (unsigned int)p->sl16);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl20) {
		adbgPrintLog(_ctx, "sl20 := %u", (unsigned int)p->sl20);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl40) {
		adbgPrintLog(_ctx, "sl40 := %u", (unsigned int)p->sl40);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl80) {
		adbgPrintLog(_ctx, "sl80 := %u", (unsigned int)p->sl80);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl160) {
		adbgPrintLog(_ctx, "sl160 := %u", (unsigned int)p->sl160);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl320) {
		adbgPrintLog(_ctx, "sl320 := %u", (unsigned int)p->sl320);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl640) {
		adbgPrintLog(_ctx, "sl640 := %u", (unsigned int)p->sl640);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl1280) {
		adbgPrintLog(_ctx, "sl1280 := %u", (unsigned int)p->sl1280);
		return;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl2560) {
		adbgPrintLog(_ctx, "sl2560 := %u", (unsigned int)p->sl2560);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset* p)
{
	_adbgNrSys__SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_monitoringSlotPeriodicityAndOffset_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_monitoringSlotPeriodicityAndOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset(_ctx, &p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_SearchSpace_duration_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_SearchSpace_duration_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__B14_SQN_NR_SearchSpace_monitoringSymbolsWithinSlot_Optional(acpCtx_t _ctx, const struct B14_SQN_NR_SearchSpace_monitoringSymbolsWithinSlot_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < 14; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e__ToString(SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n0: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n0";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n1: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n1";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n2: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n2";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n3: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n3";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n4: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n4";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n5: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n5";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n6: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n6";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n8: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e_n8";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e__ToString(SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n0: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n0";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n1: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n1";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n2: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n2";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n3: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n3";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n4: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n4";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n5: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n5";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n6: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n6";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n8: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e_n8";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e__ToString(SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n0: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n0";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n1: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n1";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n2: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n2";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n3: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n3";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n4: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n4";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n5: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n5";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n6: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n6";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n8: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e_n8";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e__ToString(SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n0: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n0";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n1: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n1";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n2: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n2";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n3: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n3";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n4: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n4";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n5: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n5";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n6: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n6";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n8: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e_n8";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e__ToString(SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n0: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n0";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n1: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n1";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n2: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n2";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n3: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n3";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n4: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n4";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n5: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n5";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n6: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n6";
		case SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n8: return "SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_nrofCandidates(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_nrofCandidates* p)
{
	adbgPrintLog(_ctx, "aggregationLevel1 := %s (%d)", adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel1_e__ToString(p->aggregationLevel1), (int)p->aggregationLevel1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel2 := %s (%d)", adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel2_e__ToString(p->aggregationLevel2), (int)p->aggregationLevel2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel4 := %s (%d)", adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel4_e__ToString(p->aggregationLevel4), (int)p->aggregationLevel4);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel8 := %s (%d)", adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel8_e__ToString(p->aggregationLevel8), (int)p->aggregationLevel8);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel16 := %s (%d)", adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_aggregationLevel16_e__ToString(p->aggregationLevel16), (int)p->aggregationLevel16);
}

static void _adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_nrofCandidates_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_nrofCandidates_nrofCandidates_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_nrofCandidates(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0_dci_Format0_0_AndFormat1_0_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0_dci_Format0_0_AndFormat1_0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e__ToString(SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_n1: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_n1";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_n2: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_aggregationLevel1_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_aggregationLevel1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e__ToString(SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_n1: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_n1";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_n2: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_aggregationLevel2_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_aggregationLevel2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e__ToString(SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_n1: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_n1";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_n2: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_aggregationLevel4_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_aggregationLevel4_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e__ToString(SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_n1: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_n1";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_n2: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_aggregationLevel8_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_aggregationLevel8_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e__ToString(SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_n1: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_n1";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_n2: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_aggregationLevel16_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_aggregationLevel16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFI(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFI* p)
{
	adbgPrintLog(_ctx, "aggregationLevel1 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_aggregationLevel1_Optional(_ctx, &p->aggregationLevel1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel2 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_aggregationLevel2_Optional(_ctx, &p->aggregationLevel2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel4 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_aggregationLevel4_Optional(_ctx, &p->aggregationLevel4);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel8 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_aggregationLevel8_Optional(_ctx, &p->aggregationLevel8);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aggregationLevel16 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_aggregationLevel16_Optional(_ctx, &p->aggregationLevel16);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0* p)
{
	adbgPrintLog(_ctx, "nrofCandidates_SFI := { ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFI(_ctx, &p->nrofCandidates_SFI);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0_dci_Format2_0_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0_dci_Format2_0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1_dci_Format2_1_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1_dci_Format2_1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2_dci_Format2_2_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2_dci_Format2_2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e__ToString(SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl1: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl1";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl2: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl2";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl4: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl4";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl5: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl5";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl8: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl8";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl10: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl10";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl16: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl16";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl20: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_sl20";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_dummy1_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_dummy1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy2_e__ToString(SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy2_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy2_e_n1: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy2_e_n1";
		case SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy2_e_n2: return "SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy2_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3* p)
{
	adbgPrintLog(_ctx, "dummy1 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_dummy1_Optional(_ctx, &p->dummy1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy2 := %s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy2_e__ToString(p->dummy2), (int)p->dummy2);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3_dci_Format2_3_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3_dci_Format2_3_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_common* p)
{
	adbgPrintLog(_ctx, "dci_Format0_0_AndFormat1_0 := ");
	if (p->dci_Format0_0_AndFormat1_0.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0_dci_Format0_0_AndFormat1_0_Optional(_ctx, &p->dci_Format0_0_AndFormat1_0);
	if (p->dci_Format0_0_AndFormat1_0.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dci_Format2_0 := ");
	if (p->dci_Format2_0.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0_dci_Format2_0_Optional(_ctx, &p->dci_Format2_0);
	if (p->dci_Format2_0.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dci_Format2_1 := ");
	if (p->dci_Format2_1.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1_dci_Format2_1_Optional(_ctx, &p->dci_Format2_1);
	if (p->dci_Format2_1.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dci_Format2_2 := ");
	if (p->dci_Format2_2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2_dci_Format2_2_Optional(_ctx, &p->dci_Format2_2);
	if (p->dci_Format2_2.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dci_Format2_3 := ");
	if (p->dci_Format2_3.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3_dci_Format2_3_Optional(_ctx, &p->dci_Format2_3);
	if (p->dci_Format2_3.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_e__ToString(SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_e_formats0_0_And_1_0: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_e_formats0_0_And_1_0";
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_e_formats0_1_And_1_1: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_e_formats0_1_And_1_1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e__ToString(SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_formats2_5: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_formats2_5";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_dci_Formats_MT_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_dci_Formats_MT_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e__ToString(SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats0_0_And_1_0: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats0_0_And_1_0";
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats0_1_And_1_1: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats0_1_And_1_1";
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats3_0: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats3_0";
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats3_1: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats3_1";
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats3_0_And_3_1: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_formats3_0_And_3_1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_dci_FormatsSL_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_dci_FormatsSL_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e__ToString(SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e v)
{
	switch(v) {
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_formats0_2_And_1_2: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_formats0_2_And_1_2";
		case SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_formats0_1_And_1_1And_0_2_And_1_2: return "SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_formats0_1_And_1_1And_0_2_And_1_2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_dci_FormatsExt_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_dci_FormatsExt_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific* p)
{
	adbgPrintLog(_ctx, "dci_Formats := %s (%d)", adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_e__ToString(p->dci_Formats), (int)p->dci_Formats);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dci_Formats_MT_r16 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_dci_Formats_MT_r16_Optional(_ctx, &p->dci_Formats_MT_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dci_FormatsSL_r16 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_dci_FormatsSL_r16_Optional(_ctx, &p->dci_FormatsSL_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dci_FormatsExt_r16 := ");
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_dci_FormatsExt_r16_Optional(_ctx, &p->dci_FormatsExt_r16);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_Value(acpCtx_t _ctx, const union SQN_NR_SearchSpace_searchSpaceType_Value* p, enum SQN_NR_SearchSpace_searchSpaceType_Sel d)
{
	if (d == SQN_NR_SearchSpace_searchSpaceType_common) {
		adbgPrintLog(_ctx, "common := { ");
		_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_common(_ctx, &p->common);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SearchSpace_searchSpaceType_ue_Specific) {
		adbgPrintLog(_ctx, "ue_Specific := { ");
		_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_ue_Specific(_ctx, &p->ue_Specific);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType* p)
{
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_searchSpaceType_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpace_searchSpaceType_searchSpaceType_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpace(acpCtx_t _ctx, const struct SQN_NR_SearchSpace* p)
{
	adbgPrintLog(_ctx, "searchSpaceId := %u", (unsigned int)p->searchSpaceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "controlResourceSetId := ");
	_adbgNrSys__SQN_NR_ControlResourceSetId_SQN_NR_SearchSpace_controlResourceSetId_Optional(_ctx, &p->controlResourceSetId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "monitoringSlotPeriodicityAndOffset := ");
	if (p->monitoringSlotPeriodicityAndOffset.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_monitoringSlotPeriodicityAndOffset_Optional(_ctx, &p->monitoringSlotPeriodicityAndOffset);
	if (p->monitoringSlotPeriodicityAndOffset.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "duration := ");
	_adbgNrSys__Uint16_t_SQN_NR_SearchSpace_duration_Optional(_ctx, &p->duration);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "monitoringSymbolsWithinSlot := ");
	_adbgNrSys__B14_SQN_NR_SearchSpace_monitoringSymbolsWithinSlot_Optional(_ctx, &p->monitoringSymbolsWithinSlot);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofCandidates := ");
	if (p->nrofCandidates.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_nrofCandidates_nrofCandidates_Optional(_ctx, &p->nrofCandidates);
	if (p->nrofCandidates.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "searchSpaceType := ");
	if (p->searchSpaceType.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SearchSpace_searchSpaceType_searchSpaceType_Optional(_ctx, &p->searchSpaceType);
	if (p->searchSpaceType.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_SearchSpace_Type_Value(acpCtx_t _ctx, const union NR_ASN1_SearchSpace_Type_Value* p, enum NR_ASN1_SearchSpace_Type_Sel d)
{
	if (d == NR_ASN1_SearchSpace_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_SearchSpace(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_SearchSpace_Type(acpCtx_t _ctx, const struct NR_ASN1_SearchSpace_Type* p)
{
	_adbgNrSys__NR_ASN1_SearchSpace_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_BWP_SearchSpaceConfig_Type(acpCtx_t _ctx, const struct NR_BWP_SearchSpaceConfig_Type* p)
{
	adbgPrintLog(_ctx, "TypeAndPriorityList := { ");
	for (size_t i3 = 0; i3 < p->TypeAndPriorityList.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__NR_SearchSpaceTypeAndPriority_Type(_ctx, &p->TypeAndPriorityList.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->TypeAndPriorityList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "AggregationLevel := %s (%d)", adbgNrSys__NR_PDCCH_CCE_AggregationLevel_Type__ToString(p->AggregationLevel), (int)p->AggregationLevel);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SearchSpaceConfigAtUE := { ");
	_adbgNrSys__NR_ASN1_SearchSpace_Type(_ctx, &p->SearchSpaceConfigAtUE);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__NR_BWP_SearchSpaceList_Type_SearchSpaceArray_Optional(acpCtx_t _ctx, const struct NR_BWP_SearchSpaceList_Type_SearchSpaceArray_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__NR_BWP_SearchSpaceConfig_Type(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e__ToString(SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e v)
{
	switch(v) {
		case SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e_n2: return "SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e_n2";
		case SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e_n3: return "SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e_n3";
		case SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e_n6: return "SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e_n6";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e__ToString(SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e v)
{
	switch(v) {
		case SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e_n2: return "SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e_n2";
		case SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e_n3: return "SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e_n3";
		case SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e_n6: return "SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e_n6";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint16_t_SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_shiftIndex_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_shiftIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved(acpCtx_t _ctx, const struct SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved* p)
{
	adbgPrintLog(_ctx, "reg_BundleSize := %s (%d)", adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_reg_BundleSize_e__ToString(p->reg_BundleSize), (int)p->reg_BundleSize);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interleaverSize := %s (%d)", adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_interleaverSize_e__ToString(p->interleaverSize), (int)p->interleaverSize);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "shiftIndex := ");
	_adbgNrSys__Uint16_t_SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_shiftIndex_Optional(_ctx, &p->shiftIndex);
}

static void _adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_Value(acpCtx_t _ctx, const union SQN_NR_ControlResourceSet_cce_REG_MappingType_Value* p, enum SQN_NR_ControlResourceSet_cce_REG_MappingType_Sel d)
{
	if (d == SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved) {
		adbgPrintLog(_ctx, "interleaved := { ");
		_adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved(_ctx, &p->interleaved);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_ControlResourceSet_cce_REG_MappingType_nonInterleaved) {
		adbgPrintLog(_ctx, "nonInterleaved := %s", (p->nonInterleaved ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType(acpCtx_t _ctx, const struct SQN_NR_ControlResourceSet_cce_REG_MappingType* p)
{
	_adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_ControlResourceSet_precoderGranularity_e__ToString(SQN_NR_ControlResourceSet_precoderGranularity_e v)
{
	switch(v) {
		case SQN_NR_ControlResourceSet_precoderGranularity_e_sameAsREG_bundle: return "SQN_NR_ControlResourceSet_precoderGranularity_e_sameAsREG_bundle";
		case SQN_NR_ControlResourceSet_precoderGranularity_e_allContiguousRBs: return "SQN_NR_ControlResourceSet_precoderGranularity_e_allContiguousRBs";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToAddList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToAddList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_ControlResourceSet_tci_PresentInDCI_e__ToString(SQN_NR_ControlResourceSet_tci_PresentInDCI_e v)
{
	switch(v) {
		case SQN_NR_ControlResourceSet_tci_PresentInDCI_e_enabled: return "SQN_NR_ControlResourceSet_tci_PresentInDCI_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ControlResourceSet_tci_PresentInDCI_e_tci_PresentInDCI_Optional(acpCtx_t _ctx, const struct SQN_NR_ControlResourceSet_tci_PresentInDCI_e_tci_PresentInDCI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ControlResourceSet_tci_PresentInDCI_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_ControlResourceSet_pdcch_DMRS_ScramblingID_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_ControlResourceSet_pdcch_DMRS_ScramblingID_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ControlResourceSet_rb_Offset_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ControlResourceSet_rb_Offset_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ControlResourceSet_tci_PresentDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ControlResourceSet_tci_PresentDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ControlResourceSet_coresetPoolIndex_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ControlResourceSet_coresetPoolIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ControlResourceSetId_v1610_SQN_NR_ControlResourceSet_controlResourceSetId_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_ControlResourceSetId_v1610_SQN_NR_ControlResourceSet_controlResourceSetId_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ControlResourceSet(acpCtx_t _ctx, const struct SQN_NR_ControlResourceSet* p)
{
	adbgPrintLog(_ctx, "controlResourceSetId := %u", (unsigned int)p->controlResourceSetId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyDomainResources := '");
	for (size_t i3 = 0; i3 < 45; i3++) {
		adbgPrintLog(_ctx, "%02X", p->frequencyDomainResources[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "duration := %u", (unsigned int)p->duration);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cce_REG_MappingType := { ");
	_adbgNrSys__SQN_NR_ControlResourceSet_cce_REG_MappingType(_ctx, &p->cce_REG_MappingType);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "precoderGranularity := %s (%d)", adbgNrSys__SQN_NR_ControlResourceSet_precoderGranularity_e__ToString(p->precoderGranularity), (int)p->precoderGranularity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tci_StatesPDCCH_ToAddList := ");
	_adbgNrSys__SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToAddList_DynamicOptional(_ctx, &p->tci_StatesPDCCH_ToAddList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tci_StatesPDCCH_ToReleaseList := ");
	_adbgNrSys__SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToReleaseList_DynamicOptional(_ctx, &p->tci_StatesPDCCH_ToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tci_PresentInDCI := ");
	_adbgNrSys__SQN_NR_ControlResourceSet_tci_PresentInDCI_e_tci_PresentInDCI_Optional(_ctx, &p->tci_PresentInDCI);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdcch_DMRS_ScramblingID := ");
	_adbgNrSys__Uint16_t_SQN_NR_ControlResourceSet_pdcch_DMRS_ScramblingID_Optional(_ctx, &p->pdcch_DMRS_ScramblingID);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rb_Offset_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ControlResourceSet_rb_Offset_r16_Optional(_ctx, &p->rb_Offset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tci_PresentDCI_1_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ControlResourceSet_tci_PresentDCI_1_2_r16_Optional(_ctx, &p->tci_PresentDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "coresetPoolIndex_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ControlResourceSet_coresetPoolIndex_r16_Optional(_ctx, &p->coresetPoolIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "controlResourceSetId_v1610 := ");
	_adbgNrSys__SQN_NR_ControlResourceSetId_v1610_SQN_NR_ControlResourceSet_controlResourceSetId_v1610_Optional(_ctx, &p->controlResourceSetId_v1610);
}

static void _adbgNrSys__NR_ASN1_ControlResourceSet_Type_Value(acpCtx_t _ctx, const union NR_ASN1_ControlResourceSet_Type_Value* p, enum NR_ASN1_ControlResourceSet_Type_Sel d)
{
	if (d == NR_ASN1_ControlResourceSet_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_ControlResourceSet(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_ControlResourceSet_Type(acpCtx_t _ctx, const struct NR_ASN1_ControlResourceSet_Type* p)
{
	_adbgNrSys__NR_ASN1_ControlResourceSet_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_BWP_CoresetList_Type_CoresetArray_Optional(acpCtx_t _ctx, const struct NR_BWP_CoresetList_Type_CoresetArray_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__NR_ASN1_ControlResourceSet_Type(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_PdcchToCell_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_PdcchToCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_PdcchToDmrs_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_PdcchToDmrs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_PDCCH_EPREs_Type(acpCtx_t _ctx, const struct NR_PDCCH_EPREs_Type* p)
{
	adbgPrintLog(_ctx, "PdcchToCell := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_PdcchToCell_Optional(_ctx, &p->PdcchToCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdcchToDmrs := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_PdcchToDmrs_Optional(_ctx, &p->PdcchToDmrs);
}

static void _adbgNrSys__NR_PDCCH_EPREs_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct NR_PDCCH_EPREs_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_PDCCH_EPREs_Type(_ctx, &p->v);
}

static void _adbgNrSys__Int32_t_NR_BWP_PDCCH_Configuration_Type_Coreset0_OffsetRBs_Optional(acpCtx_t _ctx, const struct int32_t_NR_BWP_PDCCH_Configuration_Type_Coreset0_OffsetRBs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_BWP_PDCCH_Configuration_Type(acpCtx_t _ctx, const struct NR_BWP_PDCCH_Configuration_Type* p)
{
	adbgPrintLog(_ctx, "SearchSpaceArray := ");
	if (p->SearchSpaceArray.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_BWP_SearchSpaceList_Type_SearchSpaceArray_Optional(_ctx, &p->SearchSpaceArray);
	if (p->SearchSpaceArray.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CoresetArray := ");
	if (p->CoresetArray.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_BWP_CoresetList_Type_CoresetArray_Optional(_ctx, &p->CoresetArray);
	if (p->CoresetArray.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_PDCCH_EPREs_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Coreset0_OffsetRBs := ");
	_adbgNrSys__Int32_t_NR_BWP_PDCCH_Configuration_Type_Coreset0_OffsetRBs_Optional(_ctx, &p->Coreset0_OffsetRBs);
}

static void _adbgNrSys__NR_BWP_PDCCH_Configuration_Type_Pdcch_Optional(acpCtx_t _ctx, const struct NR_BWP_PDCCH_Configuration_Type_Pdcch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_BWP_PDCCH_Configuration_Type(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_k0_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_k0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_mappingType_e__ToString(SQN_NR_PDSCH_TimeDomainResourceAllocation_mappingType_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_mappingType_e_typeA: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_mappingType_e_typeA";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_mappingType_e_typeB: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_mappingType_e_typeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation(acpCtx_t _ctx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocation* p)
{
	adbgPrintLog(_ctx, "k0 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_k0_Optional(_ctx, &p->k0);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mappingType := %s (%d)", adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_mappingType_e__ToString(p->mappingType), (int)p->mappingType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbolAndLength := %u", (unsigned int)p->startSymbolAndLength);
}

static void _adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocationList_SQN_NR_PDSCH_ConfigCommon_pdsch_TimeDomainAllocationList_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocationList_SQN_NR_PDSCH_ConfigCommon_pdsch_TimeDomainAllocationList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_PDSCH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "pdsch_TimeDomainAllocationList := ");
	if (p->pdsch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocationList_SQN_NR_PDSCH_ConfigCommon_pdsch_TimeDomainAllocationList_Optional(_ctx, &p->pdsch_TimeDomainAllocationList);
	if (p->pdsch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_PDSCH_ConfigCommon_Type_Value(acpCtx_t _ctx, const union NR_ASN1_PDSCH_ConfigCommon_Type_Value* p, enum NR_ASN1_PDSCH_ConfigCommon_Type_Sel d)
{
	if (d == NR_ASN1_PDSCH_ConfigCommon_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_PDSCH_ConfigCommon(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_PDSCH_ConfigCommon_Type(acpCtx_t _ctx, const struct NR_ASN1_PDSCH_ConfigCommon_Type* p)
{
	_adbgNrSys__NR_ASN1_PDSCH_ConfigCommon_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_PDSCH_ConfigCommon_Type_ConfigCommon_Optional(acpCtx_t _ctx, const struct NR_ASN1_PDSCH_ConfigCommon_Type_ConfigCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_PDSCH_ConfigCommon_Type(_ctx, &p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e__ToString(SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e v)
{
	switch(v) {
		case SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_type2: return "SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_type2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_dmrs_Type_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_dmrs_Type_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e__ToString(SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e v)
{
	switch(v) {
		case SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_pos0: return "SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_pos0";
		case SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_pos1: return "SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_pos1";
		case SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_pos3: return "SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_pos3";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_DownlinkConfig_maxLength_e__ToString(SQN_NR_DMRS_DownlinkConfig_maxLength_e v)
{
	switch(v) {
		case SQN_NR_DMRS_DownlinkConfig_maxLength_e_len2: return "SQN_NR_DMRS_DownlinkConfig_maxLength_e_len2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_DownlinkConfig_maxLength_e_maxLength_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_DownlinkConfig_maxLength_e_maxLength_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_DownlinkConfig_maxLength_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID0_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID1_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_PTRS_DownlinkConfig_frequencyDensity_ArrayOptional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PTRS_DownlinkConfig_frequencyDensity_ArrayOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_PTRS_DownlinkConfig_timeDensity_ArrayOptional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PTRS_DownlinkConfig_timeDensity_ArrayOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 3; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_PTRS_DownlinkConfig_epre_Ratio_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PTRS_DownlinkConfig_epre_Ratio_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e__ToString(SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e v)
{
	switch(v) {
		case SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_offset01: return "SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_offset01";
		case SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_offset10: return "SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_offset10";
		case SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_offset11: return "SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_offset11";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_resourceElementOffset_Optional(acpCtx_t _ctx, const struct SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_resourceElementOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e__ToString(SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e v)
{
	switch(v) {
		case SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_n1: return "SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_n1";
		case SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_n2: return "SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_maxNrofPorts_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_maxNrofPorts_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PTRS_DownlinkConfig(acpCtx_t _ctx, const struct SQN_NR_PTRS_DownlinkConfig* p)
{
	adbgPrintLog(_ctx, "frequencyDensity := ");
	_adbgNrSys__Uint16_t_SQN_NR_PTRS_DownlinkConfig_frequencyDensity_ArrayOptional(_ctx, &p->frequencyDensity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeDensity := ");
	_adbgNrSys__Uint8_t_SQN_NR_PTRS_DownlinkConfig_timeDensity_ArrayOptional(_ctx, &p->timeDensity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "epre_Ratio := ");
	_adbgNrSys__Uint8_t_SQN_NR_PTRS_DownlinkConfig_epre_Ratio_Optional(_ctx, &p->epre_Ratio);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceElementOffset := ");
	_adbgNrSys__SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_resourceElementOffset_Optional(_ctx, &p->resourceElementOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxNrofPorts_r16 := ");
	_adbgNrSys__SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_maxNrofPorts_r16_Optional(_ctx, &p->maxNrofPorts_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Value* p, enum SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Sel d)
{
	if (d == SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PTRS_DownlinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_SQN_NR_DMRS_DownlinkConfig_phaseTrackingRS_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_SQN_NR_DMRS_DownlinkConfig_phaseTrackingRS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e__ToString(SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e v)
{
	switch(v) {
		case SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_enabled: return "SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_dmrs_Downlink_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_dmrs_Downlink_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_DMRS_DownlinkConfig(acpCtx_t _ctx, const struct SQN_NR_DMRS_DownlinkConfig* p)
{
	adbgPrintLog(_ctx, "dmrs_Type := ");
	_adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_dmrs_Type_Optional(_ctx, &p->dmrs_Type);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_AdditionalPosition := ");
	_adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(_ctx, &p->dmrs_AdditionalPosition);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxLength := ");
	_adbgNrSys__SQN_NR_DMRS_DownlinkConfig_maxLength_e_maxLength_Optional(_ctx, &p->maxLength);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scramblingID0 := ");
	_adbgNrSys__Uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID0_Optional(_ctx, &p->scramblingID0);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scramblingID1 := ");
	_adbgNrSys__Uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID1_Optional(_ctx, &p->scramblingID1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "phaseTrackingRS := ");
	if (p->phaseTrackingRS.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_SQN_NR_DMRS_DownlinkConfig_phaseTrackingRS_Optional(_ctx, &p->phaseTrackingRS);
	if (p->phaseTrackingRS.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_Downlink_r16 := ");
	_adbgNrSys__SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_dmrs_Downlink_r16_Optional(_ctx, &p->dmrs_Downlink_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_DownlinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_DownlinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_QCL_Info_cell_Optional(acpCtx_t _ctx, const struct SQN_NR_ServCellIndex_SQN_NR_QCL_Info_cell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_BWP_Id_SQN_NR_QCL_Info_bwp_Id_Optional(acpCtx_t _ctx, const struct SQN_NR_BWP_Id_SQN_NR_QCL_Info_bwp_Id_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_QCL_Info_referenceSignal_Value(acpCtx_t _ctx, const union SQN_NR_QCL_Info_referenceSignal_Value* p, enum SQN_NR_QCL_Info_referenceSignal_Sel d)
{
	if (d == SQN_NR_QCL_Info_referenceSignal_csi_rs) {
		adbgPrintLog(_ctx, "csi_rs := %u", (unsigned int)p->csi_rs);
		return;
	}
	if (d == SQN_NR_QCL_Info_referenceSignal_ssb) {
		adbgPrintLog(_ctx, "ssb := %u", (unsigned int)p->ssb);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_QCL_Info_referenceSignal(acpCtx_t _ctx, const struct SQN_NR_QCL_Info_referenceSignal* p)
{
	_adbgNrSys__SQN_NR_QCL_Info_referenceSignal_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_QCL_Info_qcl_Type_e__ToString(SQN_NR_QCL_Info_qcl_Type_e v)
{
	switch(v) {
		case SQN_NR_QCL_Info_qcl_Type_e_typeA: return "SQN_NR_QCL_Info_qcl_Type_e_typeA";
		case SQN_NR_QCL_Info_qcl_Type_e_typeB: return "SQN_NR_QCL_Info_qcl_Type_e_typeB";
		case SQN_NR_QCL_Info_qcl_Type_e_typeC: return "SQN_NR_QCL_Info_qcl_Type_e_typeC";
		case SQN_NR_QCL_Info_qcl_Type_e_typeD: return "SQN_NR_QCL_Info_qcl_Type_e_typeD";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_QCL_Info(acpCtx_t _ctx, const struct SQN_NR_QCL_Info* p)
{
	adbgPrintLog(_ctx, "cell := ");
	_adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_QCL_Info_cell_Optional(_ctx, &p->cell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bwp_Id := ");
	_adbgNrSys__SQN_NR_BWP_Id_SQN_NR_QCL_Info_bwp_Id_Optional(_ctx, &p->bwp_Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal := { ");
	_adbgNrSys__SQN_NR_QCL_Info_referenceSignal(_ctx, &p->referenceSignal);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qcl_Type := %s (%d)", adbgNrSys__SQN_NR_QCL_Info_qcl_Type_e__ToString(p->qcl_Type), (int)p->qcl_Type);
}

static void _adbgNrSys__SQN_NR_QCL_Info_SQN_NR_TCI_State_qcl_Type2_Optional(acpCtx_t _ctx, const struct SQN_NR_QCL_Info_SQN_NR_TCI_State_qcl_Type2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_QCL_Info(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_TCI_State(acpCtx_t _ctx, const struct SQN_NR_TCI_State* p)
{
	adbgPrintLog(_ctx, "tci_StateId := %u", (unsigned int)p->tci_StateId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qcl_Type1 := { ");
	_adbgNrSys__SQN_NR_QCL_Info(_ctx, &p->qcl_Type1);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qcl_Type2 := ");
	if (p->qcl_Type2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_QCL_Info_SQN_NR_TCI_State_qcl_Type2_Optional(_ctx, &p->qcl_Type2);
	if (p->qcl_Type2.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_TCI_State_SQN_NR_PDSCH_Config_tci_StatesToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_TCI_State_SQN_NR_PDSCH_Config_tci_StatesToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_TCI_State(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_TCI_StateId_SQN_NR_PDSCH_Config_tci_StatesToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_TCI_StateId_SQN_NR_PDSCH_Config_tci_StatesToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e__ToString(SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_n2: return "SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_n2";
		case SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_n4: return "SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_n4";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_vrb_ToPRB_Interleaver_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_vrb_ToPRB_Interleaver_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocation_e__ToString(SQN_NR_PDSCH_Config_resourceAllocation_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_resourceAllocation_e_resourceAllocationType0: return "SQN_NR_PDSCH_Config_resourceAllocation_e_resourceAllocationType0";
		case SQN_NR_PDSCH_Config_resourceAllocation_e_resourceAllocationType1: return "SQN_NR_PDSCH_Config_resourceAllocation_e_resourceAllocationType1";
		case SQN_NR_PDSCH_Config_resourceAllocation_e_dynamicSwitch: return "SQN_NR_PDSCH_Config_resourceAllocation_e_dynamicSwitch";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e__ToString(SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_n2: return "SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_n2";
		case SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_n4: return "SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_n4";
		case SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_n8: return "SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_pdsch_AggregationFactor_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_pdsch_AggregationFactor_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RateMatchPattern_SQN_NR_PDSCH_Config_rateMatchPatternToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_RateMatchPattern_SQN_NR_PDSCH_Config_rateMatchPatternToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_RateMatchPattern(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_RateMatchPatternId_SQN_NR_PDSCH_Config_rateMatchPatternToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_RateMatchPatternId_SQN_NR_PDSCH_Config_rateMatchPatternToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_RateMatchPatternGroup_s_Value(acpCtx_t _ctx, const union SQN_NR_RateMatchPatternGroup_s_Value* p, enum SQN_NR_RateMatchPatternGroup_s_Sel d)
{
	if (d == SQN_NR_RateMatchPatternGroup_s_cellLevel) {
		adbgPrintLog(_ctx, "cellLevel := %u", (unsigned int)p->cellLevel);
		return;
	}
	if (d == SQN_NR_RateMatchPatternGroup_s_bwpLevel) {
		adbgPrintLog(_ctx, "bwpLevel := %u", (unsigned int)p->bwpLevel);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RateMatchPatternGroup_s(acpCtx_t _ctx, const struct SQN_NR_RateMatchPatternGroup_s* p)
{
	_adbgNrSys__SQN_NR_RateMatchPatternGroup_s_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1_Optional(acpCtx_t _ctx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_RateMatchPatternGroup_s(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2_Optional(acpCtx_t _ctx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_RateMatchPatternGroup_s(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_rbg_Size_e__ToString(SQN_NR_PDSCH_Config_rbg_Size_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_rbg_Size_e_config1: return "SQN_NR_PDSCH_Config_rbg_Size_e_config1";
		case SQN_NR_PDSCH_Config_rbg_Size_e_config2: return "SQN_NR_PDSCH_Config_rbg_Size_e_config2";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_mcs_Table_e__ToString(SQN_NR_PDSCH_Config_mcs_Table_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_mcs_Table_e_qam256: return "SQN_NR_PDSCH_Config_mcs_Table_e_qam256";
		case SQN_NR_PDSCH_Config_mcs_Table_e_qam64LowSE: return "SQN_NR_PDSCH_Config_mcs_Table_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_mcs_Table_e_mcs_Table_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_mcs_Table_e_mcs_Table_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_mcs_Table_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e__ToString(SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_n1: return "SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_n1";
		case SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_n2: return "SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_n2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_maxNrofCodeWordsScheduledByDCI_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_maxNrofCodeWordsScheduledByDCI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e__ToString(SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_n4: return "SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_n4";
		case SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_wideband";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_bundleSize_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_bundleSize_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling* p)
{
	adbgPrintLog(_ctx, "bundleSize := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_bundleSize_Optional(_ctx, &p->bundleSize);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e__ToString(SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_n4: return "SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_n4";
		case SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_wideband";
		case SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_n2_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_n2_wideband";
		case SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_n4_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_n4_wideband";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_bundleSizeSet1_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_bundleSizeSet1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e__ToString(SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_n4: return "SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_n4";
		case SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_wideband";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_bundleSizeSet2_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_bundleSizeSet2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling* p)
{
	adbgPrintLog(_ctx, "bundleSizeSet1 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_bundleSizeSet1_Optional(_ctx, &p->bundleSizeSet1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bundleSizeSet2 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_bundleSizeSet2_Optional(_ctx, &p->bundleSizeSet2);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_Value(acpCtx_t _ctx, const union SQN_NR_PDSCH_Config_prb_BundlingType_Value* p, enum SQN_NR_PDSCH_Config_prb_BundlingType_Sel d)
{
	if (d == SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling) {
		adbgPrintLog(_ctx, "staticBundling := { ");
		_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling(_ctx, &p->staticBundling);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling) {
		adbgPrintLog(_ctx, "dynamicBundling := { ");
		_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling(_ctx, &p->dynamicBundling);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingType* p)
{
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Value(acpCtx_t _ctx, const union SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Value* p, enum SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Sel d)
{
	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_row1) {
		adbgPrintLog(_ctx, "row1 := '");
		for (size_t i3 = 0; i3 < 4; i3++) {
			adbgPrintLog(_ctx, "%02X", p->row1[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_row2) {
		adbgPrintLog(_ctx, "row2 := '");
		for (size_t i3 = 0; i3 < 12; i3++) {
			adbgPrintLog(_ctx, "%02X", p->row2[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_row4) {
		adbgPrintLog(_ctx, "row4 := '");
		for (size_t i3 = 0; i3 < 3; i3++) {
			adbgPrintLog(_ctx, "%02X", p->row4[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_other) {
		adbgPrintLog(_ctx, "other := '");
		for (size_t i3 = 0; i3 < 6; i3++) {
			adbgPrintLog(_ctx, "%02X", p->other[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation(acpCtx_t _ctx, const struct SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation* p)
{
	_adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e__ToString(SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e v)
{
	switch(v) {
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p1: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p1";
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p2: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p2";
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p4: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p4";
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p8: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p8";
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p12: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p12";
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p16: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p16";
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p24: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p24";
		case SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p32: return "SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e_p32";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_CSI_RS_ResourceMapping_firstOFDMSymbolInTimeDomain2_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_CSI_RS_ResourceMapping_firstOFDMSymbolInTimeDomain2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e__ToString(SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e v)
{
	switch(v) {
		case SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_noCDM: return "SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_noCDM";
		case SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_fd_CDM2: return "SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_fd_CDM2";
		case SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_cdm4_FD2_TD2: return "SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_cdm4_FD2_TD2";
		case SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_cdm8_FD2_TD4: return "SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e_cdm8_FD2_TD4";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_density_dot5_e__ToString(SQN_NR_CSI_RS_ResourceMapping_density_dot5_e v)
{
	switch(v) {
		case SQN_NR_CSI_RS_ResourceMapping_density_dot5_e_evenPRBs: return "SQN_NR_CSI_RS_ResourceMapping_density_dot5_e_evenPRBs";
		case SQN_NR_CSI_RS_ResourceMapping_density_dot5_e_oddPRBs: return "SQN_NR_CSI_RS_ResourceMapping_density_dot5_e_oddPRBs";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_density_Value(acpCtx_t _ctx, const union SQN_NR_CSI_RS_ResourceMapping_density_Value* p, enum SQN_NR_CSI_RS_ResourceMapping_density_Sel d)
{
	if (d == SQN_NR_CSI_RS_ResourceMapping_density_dot5) {
		adbgPrintLog(_ctx, "dot5 := %s (%d)", adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_density_dot5_e__ToString(p->dot5), (int)p->dot5);
		return;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_density_one) {
		adbgPrintLog(_ctx, "one := %s", (p->one ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_density_three) {
		adbgPrintLog(_ctx, "three := %s", (p->three ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_density_spare) {
		adbgPrintLog(_ctx, "spare := %s", (p->spare ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_density(acpCtx_t _ctx, const struct SQN_NR_CSI_RS_ResourceMapping_density* p)
{
	_adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_density_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_CSI_FrequencyOccupation(acpCtx_t _ctx, const struct SQN_NR_CSI_FrequencyOccupation* p)
{
	adbgPrintLog(_ctx, "startingRB := %u", (unsigned int)p->startingRB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofRBs := %u", (unsigned int)p->nrofRBs);
}

static void _adbgNrSys__SQN_NR_CSI_RS_ResourceMapping(acpCtx_t _ctx, const struct SQN_NR_CSI_RS_ResourceMapping* p)
{
	adbgPrintLog(_ctx, "frequencyDomainAllocation := { ");
	_adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation(_ctx, &p->frequencyDomainAllocation);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofPorts := %s (%d)", adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_nrofPorts_e__ToString(p->nrofPorts), (int)p->nrofPorts);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "firstOFDMSymbolInTimeDomain := %u", (unsigned int)p->firstOFDMSymbolInTimeDomain);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "firstOFDMSymbolInTimeDomain2 := ");
	_adbgNrSys__Uint8_t_SQN_NR_CSI_RS_ResourceMapping_firstOFDMSymbolInTimeDomain2_Optional(_ctx, &p->firstOFDMSymbolInTimeDomain2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cdm_Type := %s (%d)", adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_cdm_Type_e__ToString(p->cdm_Type), (int)p->cdm_Type);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "density := { ");
	_adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_density(_ctx, &p->density);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqBand := { ");
	_adbgNrSys__SQN_NR_CSI_FrequencyOccupation(_ctx, &p->freqBand);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_CSI_ResourcePeriodicityAndOffset_Value(acpCtx_t _ctx, const union SQN_NR_CSI_ResourcePeriodicityAndOffset_Value* p, enum SQN_NR_CSI_ResourcePeriodicityAndOffset_Sel d)
{
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots4) {
		adbgPrintLog(_ctx, "slots4 := %u", (unsigned int)p->slots4);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots5) {
		adbgPrintLog(_ctx, "slots5 := %u", (unsigned int)p->slots5);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots8) {
		adbgPrintLog(_ctx, "slots8 := %u", (unsigned int)p->slots8);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots10) {
		adbgPrintLog(_ctx, "slots10 := %u", (unsigned int)p->slots10);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots16) {
		adbgPrintLog(_ctx, "slots16 := %u", (unsigned int)p->slots16);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots20) {
		adbgPrintLog(_ctx, "slots20 := %u", (unsigned int)p->slots20);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots32) {
		adbgPrintLog(_ctx, "slots32 := %u", (unsigned int)p->slots32);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots40) {
		adbgPrintLog(_ctx, "slots40 := %u", (unsigned int)p->slots40);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots64) {
		adbgPrintLog(_ctx, "slots64 := %u", (unsigned int)p->slots64);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots80) {
		adbgPrintLog(_ctx, "slots80 := %u", (unsigned int)p->slots80);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots160) {
		adbgPrintLog(_ctx, "slots160 := %u", (unsigned int)p->slots160);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots320) {
		adbgPrintLog(_ctx, "slots320 := %u", (unsigned int)p->slots320);
		return;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots640) {
		adbgPrintLog(_ctx, "slots640 := %u", (unsigned int)p->slots640);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_CSI_ResourcePeriodicityAndOffset(acpCtx_t _ctx, const struct SQN_NR_CSI_ResourcePeriodicityAndOffset* p)
{
	_adbgNrSys__SQN_NR_CSI_ResourcePeriodicityAndOffset_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_CSI_ResourcePeriodicityAndOffset_SQN_NR_ZP_CSI_RS_Resource_periodicityAndOffset_Optional(acpCtx_t _ctx, const struct SQN_NR_CSI_ResourcePeriodicityAndOffset_SQN_NR_ZP_CSI_RS_Resource_periodicityAndOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CSI_ResourcePeriodicityAndOffset(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_Resource(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_Resource* p)
{
	adbgPrintLog(_ctx, "zp_CSI_RS_ResourceId := %u", (unsigned int)p->zp_CSI_RS_ResourceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceMapping := { ");
	_adbgNrSys__SQN_NR_CSI_RS_ResourceMapping(_ctx, &p->resourceMapping);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicityAndOffset := ");
	if (p->periodicityAndOffset.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CSI_ResourcePeriodicityAndOffset_SQN_NR_ZP_CSI_RS_Resource_periodicityAndOffset_Optional(_ctx, &p->periodicityAndOffset);
	if (p->periodicityAndOffset.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_Resource_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_Resource_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_ZP_CSI_RS_Resource(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceId_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceId_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceSet* p)
{
	adbgPrintLog(_ctx, "zp_CSI_RS_ResourceSetId := %u", (unsigned int)p->zp_CSI_RS_ResourceSetId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zp_CSI_RS_ResourceIdList := '");
	for (size_t i3 = 0; i3 < p->zp_CSI_RS_ResourceIdList.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->zp_CSI_RS_ResourceIdList.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_setup) {
		adbgPrintLog(_ctx, "setup := %u", (unsigned int)p->setup);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_SQN_NR_PDSCH_Config_maxMIMO_Layers_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_SQN_NR_PDSCH_Config_maxMIMO_Layers_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_setup) {
		adbgPrintLog(_ctx, "setup := '");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "%02X", p->setup.v[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_SQN_NR_PDSCH_Config_minimumSchedulingOffsetK0_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_SQN_NR_PDSCH_Config_minimumSchedulingOffsetK0_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_enabled: return "SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_antennaPortsFieldPresenceDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_antennaPortsFieldPresenceDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_DownlinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_DownlinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_enabled: return "SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_dmrs_SequenceInitializationDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_dmrs_SequenceInitializationDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PDSCH_Config_harq_ProcessNumberSizeDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PDSCH_Config_harq_ProcessNumberSizeDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_qam256: return "SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_qam256";
		case SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_qam64LowSE: return "SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_mcs_TableDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_mcs_TableDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PDSCH_Config_numberOfBitsForRV_DCI_1_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PDSCH_Config_numberOfBitsForRV_DCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_k0_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_k0_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_mappingType_r16_e__ToString(SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_mappingType_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_mappingType_r16_e_typeA: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_mappingType_r16_e_typeA";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_mappingType_r16_e_typeB: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_mappingType_r16_e_typeB";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e__ToString(SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n2: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n2";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n3: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n3";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n4: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n4";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n5: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n5";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n6: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n6";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n7: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n7";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n8: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n8";
		case SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n16: return "SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_n16";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_repetitionNumber_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_repetitionNumber_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16(acpCtx_t _ctx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocation_r16* p)
{
	adbgPrintLog(_ctx, "k0_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_k0_r16_Optional(_ctx, &p->k0_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mappingType_r16 := %s (%d)", adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_mappingType_r16_e__ToString(p->mappingType_r16), (int)p->mappingType_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbolAndLength_r16 := %u", (unsigned int)p->startSymbolAndLength_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "repetitionNumber_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_repetitionNumber_r16_Optional(_ctx, &p->repetitionNumber_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e__ToString(SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_n4: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_n4";
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_wideband";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_bundleSize_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_bundleSize_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16* p)
{
	adbgPrintLog(_ctx, "bundleSize_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_bundleSize_r16_Optional(_ctx, &p->bundleSize_r16);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e__ToString(SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_n4: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_n4";
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_wideband";
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_n2_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_n2_wideband";
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_n4_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_n4_wideband";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_bundleSizeSet1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_bundleSizeSet1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e__ToString(SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_n4: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_n4";
		case SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_wideband: return "SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_wideband";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_bundleSizeSet2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_bundleSizeSet2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16* p)
{
	adbgPrintLog(_ctx, "bundleSizeSet1_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_bundleSizeSet1_r16_Optional(_ctx, &p->bundleSizeSet1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "bundleSizeSet2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_bundleSizeSet2_r16_Optional(_ctx, &p->bundleSizeSet2_r16);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Value* p, enum SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Sel d)
{
	if (d == SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16) {
		adbgPrintLog(_ctx, "staticBundling_r16 := { ");
		_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16(_ctx, &p->staticBundling_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16) {
		adbgPrintLog(_ctx, "dynamicBundling_r16 := { ");
		_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16(_ctx, &p->dynamicBundling_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16* p)
{
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_prb_BundlingTypeDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_prb_BundlingTypeDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_enabled: return "SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_priorityIndicatorDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_priorityIndicatorDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1DCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1DCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_RateMatchPatternGroup_s(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2DCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2DCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_RateMatchPatternGroup_s(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n2: return "SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n2";
		case SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n4: return "SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n4";
		case SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n8: return "SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n8";
		case SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n16: return "SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_n16";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_resourceAllocationType1GranularityDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_resourceAllocationType1GranularityDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_n2: return "SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_n2";
		case SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_n4: return "SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_n4";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_vrb_ToPRB_InterleaverDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_vrb_ToPRB_InterleaverDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_enabled: return "SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_referenceOfSLIVDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_referenceOfSLIVDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e__ToString(SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationType0: return "SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationType0";
		case SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationType1: return "SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationType1";
		case SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_dynamicSwitch: return "SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_dynamicSwitch";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e__ToString(SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e v)
{
	switch(v) {
		case SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_enabled: return "SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_priorityIndicatorDCI_1_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_priorityIndicatorDCI_1_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH2_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PDSCH_TimeDomainResourceAllocation_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e__ToString(SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e v)
{
	switch(v) {
		case SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e_fdmSchemeA: return "SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e_fdmSchemeA";
		case SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e_fdmSchemeB: return "SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e_fdmSchemeB";
		case SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e_tdmSchemeA: return "SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e_tdmSchemeA";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_FDM_TDM_r16_startingSymbolOffsetK_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_FDM_TDM_r16_startingSymbolOffsetK_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_FDM_TDM_r16(acpCtx_t _ctx, const struct SQN_NR_FDM_TDM_r16* p)
{
	adbgPrintLog(_ctx, "repetitionScheme_r16 := %s (%d)", adbgNrSys__SQN_NR_FDM_TDM_r16_repetitionScheme_r16_e__ToString(p->repetitionScheme_r16), (int)p->repetitionScheme_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingSymbolOffsetK_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_FDM_TDM_r16_startingSymbolOffsetK_r16_Optional(_ctx, &p->startingSymbolOffsetK_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Value* p, enum SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_FDM_TDM_r16(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_SlotBased_r16_tciMapping_r16_e__ToString(SQN_NR_SlotBased_r16_tciMapping_r16_e v)
{
	switch(v) {
		case SQN_NR_SlotBased_r16_tciMapping_r16_e_cyclicMapping: return "SQN_NR_SlotBased_r16_tciMapping_r16_e_cyclicMapping";
		case SQN_NR_SlotBased_r16_tciMapping_r16_e_sequenticalMapping: return "SQN_NR_SlotBased_r16_tciMapping_r16_e_sequenticalMapping";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SlotBased_r16(acpCtx_t _ctx, const struct SQN_NR_SlotBased_r16* p)
{
	adbgPrintLog(_ctx, "tciMapping_r16 := %s (%d)", adbgNrSys__SQN_NR_SlotBased_r16_tciMapping_r16_e__ToString(p->tciMapping_r16), (int)p->tciMapping_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sequenceOffsetforRV_r16 := %u", (unsigned int)p->sequenceOffsetforRV_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Value* p, enum SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_SlotBased_r16(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RepetitionSchemeConfig_r16_Value(acpCtx_t _ctx, const union SQN_NR_RepetitionSchemeConfig_r16_Value* p, enum SQN_NR_RepetitionSchemeConfig_r16_Sel d)
{
	if (d == SQN_NR_RepetitionSchemeConfig_r16_fdm_TDM_r16) {
		adbgPrintLog(_ctx, "fdm_TDM_r16 := { ");
		_adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16(_ctx, &p->fdm_TDM_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_RepetitionSchemeConfig_r16_slotBased_r16) {
		adbgPrintLog(_ctx, "slotBased_r16 := { ");
		_adbgNrSys__SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16(_ctx, &p->slotBased_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RepetitionSchemeConfig_r16(acpCtx_t _ctx, const struct SQN_NR_RepetitionSchemeConfig_r16* p)
{
	_adbgNrSys__SQN_NR_RepetitionSchemeConfig_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_RepetitionSchemeConfig_r16(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_SQN_NR_PDSCH_Config_repetitionSchemeConfig_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_SQN_NR_PDSCH_Config_repetitionSchemeConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PDSCH_Config(acpCtx_t _ctx, const struct SQN_NR_PDSCH_Config* p)
{
	adbgPrintLog(_ctx, "dataScramblingIdentityPDSCH := ");
	_adbgNrSys__Uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH_Optional(_ctx, &p->dataScramblingIdentityPDSCH);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_DownlinkForPDSCH_MappingTypeA := ");
	if (p->dmrs_DownlinkForPDSCH_MappingTypeA.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Optional(_ctx, &p->dmrs_DownlinkForPDSCH_MappingTypeA);
	if (p->dmrs_DownlinkForPDSCH_MappingTypeA.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_DownlinkForPDSCH_MappingTypeB := ");
	if (p->dmrs_DownlinkForPDSCH_MappingTypeB.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Optional(_ctx, &p->dmrs_DownlinkForPDSCH_MappingTypeB);
	if (p->dmrs_DownlinkForPDSCH_MappingTypeB.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tci_StatesToAddModList := ");
	if (p->tci_StatesToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_TCI_State_SQN_NR_PDSCH_Config_tci_StatesToAddModList_DynamicOptional(_ctx, &p->tci_StatesToAddModList);
	if (p->tci_StatesToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tci_StatesToReleaseList := ");
	_adbgNrSys__SQN_NR_TCI_StateId_SQN_NR_PDSCH_Config_tci_StatesToReleaseList_DynamicOptional(_ctx, &p->tci_StatesToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "vrb_ToPRB_Interleaver := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_vrb_ToPRB_Interleaver_Optional(_ctx, &p->vrb_ToPRB_Interleaver);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceAllocation := %s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocation_e__ToString(p->resourceAllocation), (int)p->resourceAllocation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_TimeDomainAllocationList := ");
	if (p->pdsch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_Optional(_ctx, &p->pdsch_TimeDomainAllocationList);
	if (p->pdsch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_AggregationFactor := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_pdsch_AggregationFactor_Optional(_ctx, &p->pdsch_AggregationFactor);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rateMatchPatternToAddModList := ");
	if (p->rateMatchPatternToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RateMatchPattern_SQN_NR_PDSCH_Config_rateMatchPatternToAddModList_DynamicOptional(_ctx, &p->rateMatchPatternToAddModList);
	if (p->rateMatchPatternToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rateMatchPatternToReleaseList := ");
	_adbgNrSys__SQN_NR_RateMatchPatternId_SQN_NR_PDSCH_Config_rateMatchPatternToReleaseList_DynamicOptional(_ctx, &p->rateMatchPatternToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rateMatchPatternGroup1 := ");
	if (p->rateMatchPatternGroup1.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1_Optional(_ctx, &p->rateMatchPatternGroup1);
	if (p->rateMatchPatternGroup1.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rateMatchPatternGroup2 := ");
	if (p->rateMatchPatternGroup2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2_Optional(_ctx, &p->rateMatchPatternGroup2);
	if (p->rateMatchPatternGroup2.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rbg_Size := %s (%d)", adbgNrSys__SQN_NR_PDSCH_Config_rbg_Size_e__ToString(p->rbg_Size), (int)p->rbg_Size);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_Table := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_mcs_Table_e_mcs_Table_Optional(_ctx, &p->mcs_Table);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxNrofCodeWordsScheduledByDCI := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_maxNrofCodeWordsScheduledByDCI_Optional(_ctx, &p->maxNrofCodeWordsScheduledByDCI);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prb_BundlingType := { ");
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingType(_ctx, &p->prb_BundlingType);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zp_CSI_RS_ResourceToAddModList := ");
	if (p->zp_CSI_RS_ResourceToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ZP_CSI_RS_Resource_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToAddModList_DynamicOptional(_ctx, &p->zp_CSI_RS_ResourceToAddModList);
	if (p->zp_CSI_RS_ResourceToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zp_CSI_RS_ResourceToReleaseList := ");
	_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceId_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToReleaseList_DynamicOptional(_ctx, &p->zp_CSI_RS_ResourceToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aperiodic_ZP_CSI_RS_ResourceSetsToAddModList := ");
	if (p->aperiodic_ZP_CSI_RS_ResourceSetsToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(_ctx, &p->aperiodic_ZP_CSI_RS_ResourceSetsToAddModList);
	if (p->aperiodic_ZP_CSI_RS_ResourceSetsToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList := ");
	_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(_ctx, &p->aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sp_ZP_CSI_RS_ResourceSetsToAddModList := ");
	if (p->sp_ZP_CSI_RS_ResourceSetsToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(_ctx, &p->sp_ZP_CSI_RS_ResourceSetsToAddModList);
	if (p->sp_ZP_CSI_RS_ResourceSetsToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sp_ZP_CSI_RS_ResourceSetsToReleaseList := ");
	_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(_ctx, &p->sp_ZP_CSI_RS_ResourceSetsToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_ZP_CSI_RS_ResourceSet := ");
	if (p->p_ZP_CSI_RS_ResourceSet.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Optional(_ctx, &p->p_ZP_CSI_RS_ResourceSet);
	if (p->p_ZP_CSI_RS_ResourceSet.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxMIMO_Layers_r16 := ");
	if (p->maxMIMO_Layers_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_SQN_NR_PDSCH_Config_maxMIMO_Layers_r16_Optional(_ctx, &p->maxMIMO_Layers_r16);
	if (p->maxMIMO_Layers_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "minimumSchedulingOffsetK0_r16 := ");
	if (p->minimumSchedulingOffsetK0_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_SQN_NR_PDSCH_Config_minimumSchedulingOffsetK0_r16_Optional(_ctx, &p->minimumSchedulingOffsetK0_r16);
	if (p->minimumSchedulingOffsetK0_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "antennaPortsFieldPresenceDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_antennaPortsFieldPresenceDCI_1_2_r16_Optional(_ctx, &p->antennaPortsFieldPresenceDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16 := ");
	if (p->aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_DynamicOptional(_ctx, &p->aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16);
	if (p->aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_DynamicOptional(_ctx, &p->aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16 := ");
	if (p->dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Optional(_ctx, &p->dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16);
	if (p->dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16 := ");
	if (p->dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Optional(_ctx, &p->dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16);
	if (p->dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_SequenceInitializationDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_dmrs_SequenceInitializationDCI_1_2_r16_Optional(_ctx, &p->dmrs_SequenceInitializationDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "harq_ProcessNumberSizeDCI_1_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PDSCH_Config_harq_ProcessNumberSizeDCI_1_2_r16_Optional(_ctx, &p->harq_ProcessNumberSizeDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_TableDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_mcs_TableDCI_1_2_r16_Optional(_ctx, &p->mcs_TableDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberOfBitsForRV_DCI_1_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PDSCH_Config_numberOfBitsForRV_DCI_1_2_r16_Optional(_ctx, &p->numberOfBitsForRV_DCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_TimeDomainAllocationListDCI_1_2_r16 := ");
	if (p->pdsch_TimeDomainAllocationListDCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Optional(_ctx, &p->pdsch_TimeDomainAllocationListDCI_1_2_r16);
	if (p->pdsch_TimeDomainAllocationListDCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prb_BundlingTypeDCI_1_2_r16 := ");
	if (p->prb_BundlingTypeDCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_prb_BundlingTypeDCI_1_2_r16_Optional(_ctx, &p->prb_BundlingTypeDCI_1_2_r16);
	if (p->prb_BundlingTypeDCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "priorityIndicatorDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_priorityIndicatorDCI_1_2_r16_Optional(_ctx, &p->priorityIndicatorDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rateMatchPatternGroup1DCI_1_2_r16 := ");
	if (p->rateMatchPatternGroup1DCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1DCI_1_2_r16_Optional(_ctx, &p->rateMatchPatternGroup1DCI_1_2_r16);
	if (p->rateMatchPatternGroup1DCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rateMatchPatternGroup2DCI_1_2_r16 := ");
	if (p->rateMatchPatternGroup2DCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2DCI_1_2_r16_Optional(_ctx, &p->rateMatchPatternGroup2DCI_1_2_r16);
	if (p->rateMatchPatternGroup2DCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceAllocationType1GranularityDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_resourceAllocationType1GranularityDCI_1_2_r16_Optional(_ctx, &p->resourceAllocationType1GranularityDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "vrb_ToPRB_InterleaverDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_vrb_ToPRB_InterleaverDCI_1_2_r16_Optional(_ctx, &p->vrb_ToPRB_InterleaverDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceOfSLIVDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_referenceOfSLIVDCI_1_2_r16_Optional(_ctx, &p->referenceOfSLIVDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceAllocationDCI_1_2_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationDCI_1_2_r16_Optional(_ctx, &p->resourceAllocationDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "priorityIndicatorDCI_1_1_r16 := ");
	_adbgNrSys__SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_priorityIndicatorDCI_1_1_r16_Optional(_ctx, &p->priorityIndicatorDCI_1_1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataScramblingIdentityPDSCH2_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH2_r16_Optional(_ctx, &p->dataScramblingIdentityPDSCH2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_TimeDomainAllocationList_r16 := ");
	if (p->pdsch_TimeDomainAllocationList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Optional(_ctx, &p->pdsch_TimeDomainAllocationList_r16);
	if (p->pdsch_TimeDomainAllocationList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "repetitionSchemeConfig_r16 := ");
	if (p->repetitionSchemeConfig_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_SQN_NR_PDSCH_Config_repetitionSchemeConfig_r16_Optional(_ctx, &p->repetitionSchemeConfig_r16);
	if (p->repetitionSchemeConfig_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_PDSCH_Config_Type_Value(acpCtx_t _ctx, const union NR_ASN1_PDSCH_Config_Type_Value* p, enum NR_ASN1_PDSCH_Config_Type_Sel d)
{
	if (d == NR_ASN1_PDSCH_Config_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_PDSCH_Config(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_PDSCH_Config_Type(acpCtx_t _ctx, const struct NR_ASN1_PDSCH_Config_Type* p)
{
	_adbgNrSys__NR_ASN1_PDSCH_Config_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_PDSCH_Config_Type_ConfigDedicated_Optional(acpCtx_t _ctx, const struct NR_ASN1_PDSCH_Config_Type_ConfigDedicated_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_PDSCH_Config_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_PdschToCell_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_PdschToCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_PdschToDmrs_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_PdschToDmrs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_EPRE_Ratio_Type_PdschToPtrs_Optional(acpCtx_t _ctx, const struct NR_EPRE_Ratio_Type_PdschToPtrs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_PDSCH_EPREs_Type(acpCtx_t _ctx, const struct NR_PDSCH_EPREs_Type* p)
{
	adbgPrintLog(_ctx, "PdschToCell := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_PdschToCell_Optional(_ctx, &p->PdschToCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdschToDmrs := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_PdschToDmrs_Optional(_ctx, &p->PdschToDmrs);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdschToPtrs := ");
	_adbgNrSys__NR_EPRE_Ratio_Type_PdschToPtrs_Optional(_ctx, &p->PdschToPtrs);
}

static void _adbgNrSys__NR_PDSCH_EPREs_Type_RelativeTxPower_Optional(acpCtx_t _ctx, const struct NR_PDSCH_EPREs_Type_RelativeTxPower_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_PDSCH_EPREs_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_BWP_PDSCH_Configuration_Type(acpCtx_t _ctx, const struct NR_BWP_PDSCH_Configuration_Type* p)
{
	adbgPrintLog(_ctx, "ConfigCommon := ");
	if (p->ConfigCommon.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_PDSCH_ConfigCommon_Type_ConfigCommon_Optional(_ctx, &p->ConfigCommon);
	if (p->ConfigCommon.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ConfigDedicated := ");
	if (p->ConfigDedicated.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_PDSCH_Config_Type_ConfigDedicated_Optional(_ctx, &p->ConfigDedicated);
	if (p->ConfigDedicated.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RelativeTxPower := ");
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_PDSCH_EPREs_Type_RelativeTxPower_Optional(_ctx, &p->RelativeTxPower);
	if (p->RelativeTxPower.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_BWP_PDSCH_Configuration_Type_Pdsch_Optional(acpCtx_t _ctx, const struct NR_BWP_PDSCH_Configuration_Type_Pdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_BWP_PDSCH_Configuration_Type(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SPS_Config_periodicity_e__ToString(SQN_NR_SPS_Config_periodicity_e v)
{
	switch(v) {
		case SQN_NR_SPS_Config_periodicity_e_ms10: return "SQN_NR_SPS_Config_periodicity_e_ms10";
		case SQN_NR_SPS_Config_periodicity_e_ms20: return "SQN_NR_SPS_Config_periodicity_e_ms20";
		case SQN_NR_SPS_Config_periodicity_e_ms32: return "SQN_NR_SPS_Config_periodicity_e_ms32";
		case SQN_NR_SPS_Config_periodicity_e_ms40: return "SQN_NR_SPS_Config_periodicity_e_ms40";
		case SQN_NR_SPS_Config_periodicity_e_ms64: return "SQN_NR_SPS_Config_periodicity_e_ms64";
		case SQN_NR_SPS_Config_periodicity_e_ms80: return "SQN_NR_SPS_Config_periodicity_e_ms80";
		case SQN_NR_SPS_Config_periodicity_e_ms128: return "SQN_NR_SPS_Config_periodicity_e_ms128";
		case SQN_NR_SPS_Config_periodicity_e_ms160: return "SQN_NR_SPS_Config_periodicity_e_ms160";
		case SQN_NR_SPS_Config_periodicity_e_ms320: return "SQN_NR_SPS_Config_periodicity_e_ms320";
		case SQN_NR_SPS_Config_periodicity_e_ms640: return "SQN_NR_SPS_Config_periodicity_e_ms640";
		case SQN_NR_SPS_Config_periodicity_e_spare6: return "SQN_NR_SPS_Config_periodicity_e_spare6";
		case SQN_NR_SPS_Config_periodicity_e_spare5: return "SQN_NR_SPS_Config_periodicity_e_spare5";
		case SQN_NR_SPS_Config_periodicity_e_spare4: return "SQN_NR_SPS_Config_periodicity_e_spare4";
		case SQN_NR_SPS_Config_periodicity_e_spare3: return "SQN_NR_SPS_Config_periodicity_e_spare3";
		case SQN_NR_SPS_Config_periodicity_e_spare2: return "SQN_NR_SPS_Config_periodicity_e_spare2";
		case SQN_NR_SPS_Config_periodicity_e_spare1: return "SQN_NR_SPS_Config_periodicity_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_SPS_Config_n1PUCCH_AN_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_SPS_Config_n1PUCCH_AN_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_SPS_Config_mcs_Table_e__ToString(SQN_NR_SPS_Config_mcs_Table_e v)
{
	switch(v) {
		case SQN_NR_SPS_Config_mcs_Table_e_qam64LowSE: return "SQN_NR_SPS_Config_mcs_Table_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SPS_Config_mcs_Table_e_mcs_Table_Optional(acpCtx_t _ctx, const struct SQN_NR_SPS_Config_mcs_Table_e_mcs_Table_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SPS_Config_mcs_Table_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SPS_ConfigIndex_r16_SQN_NR_SPS_Config_sps_ConfigIndex_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SPS_ConfigIndex_r16_SQN_NR_SPS_Config_sps_ConfigIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SPS_Config_harq_ProcID_Offset_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SPS_Config_harq_ProcID_Offset_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_SPS_Config_periodicityExt_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_SPS_Config_periodicityExt_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SPS_Config_harq_CodebookID_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SPS_Config_harq_CodebookID_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e__ToString(SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e v)
{
	switch(v) {
		case SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n1: return "SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n1";
		case SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n2: return "SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n2";
		case SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n4: return "SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n4";
		case SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n8: return "SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_pdsch_AggregationFactor_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_pdsch_AggregationFactor_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SPS_Config(acpCtx_t _ctx, const struct SQN_NR_SPS_Config* p)
{
	adbgPrintLog(_ctx, "periodicity := %s (%d)", adbgNrSys__SQN_NR_SPS_Config_periodicity_e__ToString(p->periodicity), (int)p->periodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofHARQ_Processes := %u", (unsigned int)p->nrofHARQ_Processes);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n1PUCCH_AN := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_SPS_Config_n1PUCCH_AN_Optional(_ctx, &p->n1PUCCH_AN);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_Table := ");
	_adbgNrSys__SQN_NR_SPS_Config_mcs_Table_e_mcs_Table_Optional(_ctx, &p->mcs_Table);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sps_ConfigIndex_r16 := ");
	_adbgNrSys__SQN_NR_SPS_ConfigIndex_r16_SQN_NR_SPS_Config_sps_ConfigIndex_r16_Optional(_ctx, &p->sps_ConfigIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "harq_ProcID_Offset_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_SPS_Config_harq_ProcID_Offset_r16_Optional(_ctx, &p->harq_ProcID_Offset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicityExt_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_SPS_Config_periodicityExt_r16_Optional(_ctx, &p->periodicityExt_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "harq_CodebookID_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_SPS_Config_harq_CodebookID_r16_Optional(_ctx, &p->harq_CodebookID_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdsch_AggregationFactor_r16 := ");
	_adbgNrSys__SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_pdsch_AggregationFactor_r16_Optional(_ctx, &p->pdsch_AggregationFactor_r16);
}

static void _adbgNrSys__NR_ASN1_SPS_Config_Type_Value(acpCtx_t _ctx, const union NR_ASN1_SPS_Config_Type_Value* p, enum NR_ASN1_SPS_Config_Type_Sel d)
{
	if (d == NR_ASN1_SPS_Config_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_SPS_Config(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_SPS_Config_Type(acpCtx_t _ctx, const struct NR_ASN1_SPS_Config_Type* p)
{
	_adbgNrSys__NR_ASN1_SPS_Config_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_SPS_Config_Type_Sps_Optional(acpCtx_t _ctx, const struct NR_ASN1_SPS_Config_Type_Sps_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_SPS_Config_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DownlinkBWP_Type(acpCtx_t _ctx, const struct NR_DownlinkBWP_Type* p)
{
	adbgPrintLog(_ctx, "Id := ");
	_adbgNrSys__SQN_NR_BWP_Id_NR_DownlinkBWP_Type_Id_Optional(_ctx, &p->Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BWP := ");
	if (p->BWP.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_BWP_Type_BWP_Optional(_ctx, &p->BWP);
	if (p->BWP.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pdcch := ");
	if (p->Pdcch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_BWP_PDCCH_Configuration_Type_Pdcch_Optional(_ctx, &p->Pdcch);
	if (p->Pdcch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Pdsch := ");
	if (p->Pdsch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_BWP_PDSCH_Configuration_Type_Pdsch_Optional(_ctx, &p->Pdsch);
	if (p->Pdsch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Sps := ");
	if (p->Sps.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_SPS_Config_Type_Sps_Optional(_ctx, &p->Sps);
	if (p->Sps.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_DownlinkBWP_List_Type_BwpArray_Optional(acpCtx_t _ctx, const struct NR_DownlinkBWP_List_Type_BwpArray_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_DownlinkBWP_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_DownlinkBWPs_Type(acpCtx_t _ctx, const struct NR_DownlinkBWPs_Type* p)
{
	adbgPrintLog(_ctx, "ActiveBWP := ");
	_adbgNrSys__SQN_NR_BWP_Id_ActiveBWP_Optional(_ctx, &p->ActiveBWP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BwpArray := ");
	if (p->BwpArray.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DownlinkBWP_List_Type_BwpArray_Optional(_ctx, &p->BwpArray);
	if (p->BwpArray.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_DownlinkBWPs_Type_BWPs_Optional(acpCtx_t _ctx, const struct NR_DownlinkBWPs_Type_BWPs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DownlinkBWPs_Type(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_ScramblingId_ScramblingId_Optional(acpCtx_t _ctx, const struct SQN_NR_ScramblingId_ScramblingId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_ResourceMapping_Optional(acpCtx_t _ctx, const struct SQN_NR_CSI_RS_ResourceMapping_ResourceMapping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CSI_RS_ResourceMapping(_ctx, &p->v);
}

static void _adbgNrSys__Int32_t_NR_NZP_CSI_RS_Config_Type_OffsetToFreqBand_Optional(acpCtx_t _ctx, const struct int32_t_NR_NZP_CSI_RS_Config_Type_OffsetToFreqBand_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_CSI_RS_Periodicity_Type_Value(acpCtx_t _ctx, const union NR_CSI_RS_Periodicity_Type_Value* p, enum NR_CSI_RS_Periodicity_Type_Sel d)
{
	if (d == NR_CSI_RS_Periodicity_Type_PeriodicityAndOffset) {
		adbgPrintLog(_ctx, "PeriodicityAndOffset := { ");
		_adbgNrSys__SQN_NR_CSI_ResourcePeriodicityAndOffset(_ctx, &p->PeriodicityAndOffset);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_CSI_RS_Periodicity_Type(acpCtx_t _ctx, const struct NR_CSI_RS_Periodicity_Type* p)
{
	_adbgNrSys__NR_CSI_RS_Periodicity_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_CSI_RS_Periodicity_Type_Periodicity_Optional(acpCtx_t _ctx, const struct NR_CSI_RS_Periodicity_Type_Periodicity_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CSI_RS_Periodicity_Type(_ctx, &p->v);
}

static void _adbgNrSys__Int32_t_NR_NZP_CSI_RS_Config_Type_Attenuation_Optional(acpCtx_t _ctx, const struct int32_t_NR_NZP_CSI_RS_Config_Type_Attenuation_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_NZP_CSI_RS_Config_Type(acpCtx_t _ctx, const struct NR_NZP_CSI_RS_Config_Type* p)
{
	adbgPrintLog(_ctx, "ScramblingId := ");
	_adbgNrSys__SQN_NR_ScramblingId_ScramblingId_Optional(_ctx, &p->ScramblingId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ResourceMapping := ");
	if (p->ResourceMapping.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CSI_RS_ResourceMapping_ResourceMapping_Optional(_ctx, &p->ResourceMapping);
	if (p->ResourceMapping.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "OffsetToFreqBand := ");
	_adbgNrSys__Int32_t_NR_NZP_CSI_RS_Config_Type_OffsetToFreqBand_Optional(_ctx, &p->OffsetToFreqBand);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Periodicity := ");
	if (p->Periodicity.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_CSI_RS_Periodicity_Type_Periodicity_Optional(_ctx, &p->Periodicity);
	if (p->Periodicity.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Attenuation := ");
	_adbgNrSys__Int32_t_NR_NZP_CSI_RS_Config_Type_Attenuation_Optional(_ctx, &p->Attenuation);
}

static void _adbgNrSys__NR_CSI_Config_Type_Value(acpCtx_t _ctx, const union NR_CSI_Config_Type_Value* p, enum NR_CSI_Config_Type_Sel d)
{
	if (d == NR_CSI_Config_Type_CSI_RS) {
		adbgPrintLog(_ctx, "CSI_RS := { ");
		for (size_t i1 = 0; i1 < p->CSI_RS.d; i1++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__NR_NZP_CSI_RS_Config_Type(_ctx, &p->CSI_RS.v[i1]);
			adbgPrintLog(_ctx, " }");
			if (i1 != p->CSI_RS.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_CSI_Config_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_CSI_Config_Type(acpCtx_t _ctx, const struct NR_CSI_Config_Type* p)
{
	_adbgNrSys__NR_CSI_Config_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_CSI_Config_Type_CsiConfig_Optional(acpCtx_t _ctx, const struct NR_CSI_Config_Type_CsiConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CSI_Config_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_CellConfigPhysicalLayerDownlink_Type(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayerDownlink_Type* p)
{
	adbgPrintLog(_ctx, "FrequencyInfoDL := ");
	if (p->FrequencyInfoDL.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_FrequencyInfoDL_Type_FrequencyInfoDL_Optional(_ctx, &p->FrequencyInfoDL);
	if (p->FrequencyInfoDL.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SSPbchBlock := ");
	if (p->SSPbchBlock.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SSB_Config_Type_SSPbchBlock_Optional(_ctx, &p->SSPbchBlock);
	if (p->SSPbchBlock.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdschCellLevelConfig := ");
	if (p->PdschCellLevelConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_PDSCH_CellLevelConfig_Type_PdschCellLevelConfig_Optional(_ctx, &p->PdschCellLevelConfig);
	if (p->PdschCellLevelConfig.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BWPs := ");
	if (p->BWPs.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DownlinkBWPs_Type_BWPs_Optional(_ctx, &p->BWPs);
	if (p->BWPs.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CsiConfig := ");
	if (p->CsiConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_CSI_Config_Type_CsiConfig_Optional(_ctx, &p->CsiConfig);
	if (p->CsiConfig.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_CellConfigPhysicalLayerDownlink_Type_Downlink_Optional(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayerDownlink_Type_Downlink_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CellConfigPhysicalLayerDownlink_Type(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SQN_NR_FrequencyInfoUL_frequencyBandList_Optional(acpCtx_t _ctx, const struct SQN_NR_MultiFrequencyBandListNR_SQN_NR_FrequencyInfoUL_frequencyBandList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_absoluteFrequencyPointA_Optional(acpCtx_t _ctx, const struct SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_absoluteFrequencyPointA_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_AdditionalSpectrumEmission_SQN_NR_FrequencyInfoUL_additionalSpectrumEmission_Optional(acpCtx_t _ctx, const struct SQN_NR_AdditionalSpectrumEmission_SQN_NR_FrequencyInfoUL_additionalSpectrumEmission_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_P_Max_SQN_NR_FrequencyInfoUL_p_Max_Optional(acpCtx_t _ctx, const struct SQN_NR_P_Max_SQN_NR_FrequencyInfoUL_p_Max_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static const char* adbgNrSys__SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e__ToString(SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e v)
{
	switch(v) {
		case SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_true: return "SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_true";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional(acpCtx_t _ctx, const struct SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_FrequencyInfoUL(acpCtx_t _ctx, const struct SQN_NR_FrequencyInfoUL* p)
{
	adbgPrintLog(_ctx, "frequencyBandList := ");
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SQN_NR_FrequencyInfoUL_frequencyBandList_Optional(_ctx, &p->frequencyBandList);
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "absoluteFrequencyPointA := ");
	_adbgNrSys__SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_absoluteFrequencyPointA_Optional(_ctx, &p->absoluteFrequencyPointA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scs_SpecificCarrierList := { ");
	for (size_t i1 = 0; i1 < p->scs_SpecificCarrierList.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SCS_SpecificCarrier(_ctx, &p->scs_SpecificCarrierList.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->scs_SpecificCarrierList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmission := ");
	_adbgNrSys__SQN_NR_AdditionalSpectrumEmission_SQN_NR_FrequencyInfoUL_additionalSpectrumEmission_Optional(_ctx, &p->additionalSpectrumEmission);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_Max := ");
	_adbgNrSys__SQN_NR_P_Max_SQN_NR_FrequencyInfoUL_p_Max_Optional(_ctx, &p->p_Max);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyShift7p5khz := ");
	_adbgNrSys__SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional(_ctx, &p->frequencyShift7p5khz);
}

static void _adbgNrSys__NR_ASN1_FrequencyInfoUL_Type_Value(acpCtx_t _ctx, const union NR_ASN1_FrequencyInfoUL_Type_Value* p, enum NR_ASN1_FrequencyInfoUL_Type_Sel d)
{
	if (d == NR_ASN1_FrequencyInfoUL_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_FrequencyInfoUL(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_FrequencyInfoUL_Type(acpCtx_t _ctx, const struct NR_ASN1_FrequencyInfoUL_Type* p)
{
	_adbgNrSys__NR_ASN1_FrequencyInfoUL_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_FrequencyInfoUL_Type_FrequencyInfoUL_Optional(acpCtx_t _ctx, const struct NR_ASN1_FrequencyInfoUL_Type_FrequencyInfoUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_FrequencyInfoUL_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_ActiveUplinkBWP_Id_Type_Value(acpCtx_t _ctx, const union NR_ActiveUplinkBWP_Id_Type_Value* p, enum NR_ActiveUplinkBWP_Id_Type_Sel d)
{
	if (d == NR_ActiveUplinkBWP_Id_Type_Explicit) {
		adbgPrintLog(_ctx, "Explicit := %u", (unsigned int)p->Explicit);
		return;
	}
	if (d == NR_ActiveUplinkBWP_Id_Type_SameIdAsDL) {
		adbgPrintLog(_ctx, "SameIdAsDL := %s", (p->SameIdAsDL ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ActiveUplinkBWP_Id_Type(acpCtx_t _ctx, const struct NR_ActiveUplinkBWP_Id_Type* p)
{
	_adbgNrSys__NR_ActiveUplinkBWP_Id_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ActiveUplinkBWP_Id_Type_ActiveBWP_Optional(acpCtx_t _ctx, const struct NR_ActiveUplinkBWP_Id_Type_ActiveBWP_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ActiveUplinkBWP_Id_Type(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_BWP_Id_NR_UplinkBWP_Type_Id_Optional(acpCtx_t _ctx, const struct SQN_NR_BWP_Id_NR_UplinkBWP_Type_Id_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGeneric_msg1_FDM_e__ToString(SQN_NR_RACH_ConfigGeneric_msg1_FDM_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_one: return "SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_one";
		case SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_two: return "SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_two";
		case SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_four: return "SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_four";
		case SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_eight: return "SQN_NR_RACH_ConfigGeneric_msg1_FDM_e_eight";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGeneric_preambleTransMax_e__ToString(SQN_NR_RACH_ConfigGeneric_preambleTransMax_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n3: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n3";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n4: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n4";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n5: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n5";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n6: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n6";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n7: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n7";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n8: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n8";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n10: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n10";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n20: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n20";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n50: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n50";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n100: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n100";
		case SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n200: return "SQN_NR_RACH_ConfigGeneric_preambleTransMax_e_n200";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGeneric_powerRampingStep_e__ToString(SQN_NR_RACH_ConfigGeneric_powerRampingStep_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB0: return "SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB0";
		case SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB2: return "SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB2";
		case SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB4: return "SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB4";
		case SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB6: return "SQN_NR_RACH_ConfigGeneric_powerRampingStep_e_dB6";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e__ToString(SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl1: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl1";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl2: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl2";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl4: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl4";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl8: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl8";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl10: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl10";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl20: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl20";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl40: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl40";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl80: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e_sl80";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e__ToString(SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf1: return "SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf1";
		case SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf2: return "SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf2";
		case SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf4: return "SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf4";
		case SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf8: return "SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf8";
		case SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf16: return "SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf16";
		case SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf32: return "SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf32";
		case SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf64: return "SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_scf64";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_prach_ConfigurationPeriodScaling_IAB_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_prach_ConfigurationPeriodScaling_IAB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationFrameOffset_IAB_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationFrameOffset_IAB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationSOffset_IAB_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationSOffset_IAB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e__ToString(SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_sl60: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_sl60";
		case SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_sl160: return "SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_sl160";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_ra_ResponseWindow_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_ra_ResponseWindow_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationIndex_v1610_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationIndex_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGeneric(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGeneric* p)
{
	adbgPrintLog(_ctx, "prach_ConfigurationIndex := %u", (unsigned int)p->prach_ConfigurationIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msg1_FDM := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGeneric_msg1_FDM_e__ToString(p->msg1_FDM), (int)p->msg1_FDM);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msg1_FrequencyStart := %u", (unsigned int)p->msg1_FrequencyStart);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "zeroCorrelationZoneConfig := %u", (unsigned int)p->zeroCorrelationZoneConfig);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "preambleReceivedTargetPower := %d", (int)p->preambleReceivedTargetPower);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "preambleTransMax := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGeneric_preambleTransMax_e__ToString(p->preambleTransMax), (int)p->preambleTransMax);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "powerRampingStep := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGeneric_powerRampingStep_e__ToString(p->powerRampingStep), (int)p->powerRampingStep);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ResponseWindow := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_e__ToString(p->ra_ResponseWindow), (int)p->ra_ResponseWindow);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ConfigurationPeriodScaling_IAB_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_prach_ConfigurationPeriodScaling_IAB_r16_Optional(_ctx, &p->prach_ConfigurationPeriodScaling_IAB_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ConfigurationFrameOffset_IAB_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationFrameOffset_IAB_r16_Optional(_ctx, &p->prach_ConfigurationFrameOffset_IAB_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ConfigurationSOffset_IAB_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationSOffset_IAB_r16_Optional(_ctx, &p->prach_ConfigurationSOffset_IAB_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ResponseWindow_v1610 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_ra_ResponseWindow_v1610_Optional(_ctx, &p->ra_ResponseWindow_v1610);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_ConfigurationIndex_v1610 := ");
	_adbgNrSys__Uint16_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationIndex_v1610_Optional(_ctx, &p->prach_ConfigurationIndex_v1610);
}

static void _adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommon_totalNumberOfRA_Preambles_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_RACH_ConfigCommon_totalNumberOfRA_Preambles_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e__ToString(SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n4: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n4";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n8: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n8";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n12: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n12";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n16: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n16";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n20: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n20";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n24: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n24";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n28: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n28";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n32: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n32";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n36: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n36";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n40: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n40";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n44: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n44";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n48: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n48";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n52: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n52";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n56: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n56";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n60: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n60";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n64: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e__ToString(SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n4: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n4";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n8: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n8";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n12: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n12";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n16: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n16";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n20: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n20";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n24: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n24";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n28: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n28";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n32: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n32";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n36: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n36";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n40: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n40";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n44: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n44";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n48: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n48";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n52: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n52";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n56: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n56";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n60: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n60";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n64: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e__ToString(SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n4: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n4";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n8: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n8";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n12: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n12";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n16: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n16";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n20: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n20";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n24: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n24";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n28: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n28";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n32: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n32";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n36: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n36";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n40: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n40";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n44: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n44";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n48: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n48";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n52: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n52";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n56: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n56";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n60: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n60";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n64: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e__ToString(SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n4: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n4";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n8: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n8";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n12: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n12";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n16: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n16";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n20: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n20";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n24: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n24";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n28: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n28";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n32: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n32";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n36: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n36";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n40: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n40";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n44: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n44";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n48: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n48";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n52: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n52";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n56: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n56";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n60: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n60";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n64: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e__ToString(SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n4: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n4";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n8: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n8";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n12: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n12";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n16: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n16";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n20: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n20";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n24: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n24";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n28: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n28";
		case SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n32: return "SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e_n32";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Value(acpCtx_t _ctx, const union SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Value* p, enum SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Sel d)
{
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth) {
		adbgPrintLog(_ctx, "oneEighth := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth_e__ToString(p->oneEighth), (int)p->oneEighth);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth) {
		adbgPrintLog(_ctx, "oneFourth := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth_e__ToString(p->oneFourth), (int)p->oneFourth);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf) {
		adbgPrintLog(_ctx, "oneHalf := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf_e__ToString(p->oneHalf), (int)p->oneHalf);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one) {
		adbgPrintLog(_ctx, "one := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one_e__ToString(p->one), (int)p->one);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two) {
		adbgPrintLog(_ctx, "two := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two_e__ToString(p->two), (int)p->two);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_four) {
		adbgPrintLog(_ctx, "four := %u", (unsigned int)p->four);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_eight) {
		adbgPrintLog(_ctx, "eight := %u", (unsigned int)p->eight);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_sixteen) {
		adbgPrintLog(_ctx, "sixteen := %u", (unsigned int)p->sixteen);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB* p)
{
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e__ToString(SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b56: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b56";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b144: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b144";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b208: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b208";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b256: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b256";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b282: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b282";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b480: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b480";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b640: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b640";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b800: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b800";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b1000: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b1000";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b72: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_b72";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare6: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare6";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare5: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare5";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare4: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare4";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare3: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare3";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare2: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare2";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare1: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e__ToString(SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_minusinfinity: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_minusinfinity";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB0: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB0";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB5: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB5";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB8: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB8";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB10: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB10";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB12: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB12";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB15: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB15";
		case SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB18: return "SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e_dB18";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_groupBconfigured* p)
{
	adbgPrintLog(_ctx, "ra_Msg3SizeGroupA := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured_ra_Msg3SizeGroupA_e__ToString(p->ra_Msg3SizeGroupA), (int)p->ra_Msg3SizeGroupA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "messagePowerOffsetGroupB := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured_messagePowerOffsetGroupB_e__ToString(p->messagePowerOffsetGroupB), (int)p->messagePowerOffsetGroupB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberOfRA_PreamblesGroupA := %u", (unsigned int)p->numberOfRA_PreamblesGroupA);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured_groupBconfigured_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_groupBconfigured_groupBconfigured_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e__ToString(SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf8: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf8";
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf16: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf16";
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf24: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf24";
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf32: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf32";
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf40: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf40";
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf48: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf48";
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf56: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf56";
		case SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf64: return "SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e_sf64";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_SUL_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_SUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Value(acpCtx_t _ctx, const union SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Value* p, enum SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Sel d)
{
	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_l839) {
		adbgPrintLog(_ctx, "l839 := %u", (unsigned int)p->l839);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_l139) {
		adbgPrintLog(_ctx, "l139 := %u", (unsigned int)p->l139);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex* p)
{
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommon_msg1_SubcarrierSpacing_Optional(acpCtx_t _ctx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommon_msg1_SubcarrierSpacing_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e__ToString(SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e_unrestrictedSet: return "SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e_unrestrictedSet";
		case SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e_restrictedSetTypeA: return "SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e_restrictedSetTypeA";
		case SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e_restrictedSetTypeB: return "SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e_restrictedSetTypeB";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e__ToString(SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_enabled: return "SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_msg3_transformPrecoder_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_msg3_transformPrecoder_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e__ToString(SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e v)
{
	switch(v) {
		case SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB0: return "SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB0";
		case SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB2: return "SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB2";
		case SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB4: return "SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB4";
		case SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB6: return "SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e_dB6";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RA_Prioritization_scalingFactorBI_e__ToString(SQN_NR_RA_Prioritization_scalingFactorBI_e v)
{
	switch(v) {
		case SQN_NR_RA_Prioritization_scalingFactorBI_e_zero: return "SQN_NR_RA_Prioritization_scalingFactorBI_e_zero";
		case SQN_NR_RA_Prioritization_scalingFactorBI_e_dot25: return "SQN_NR_RA_Prioritization_scalingFactorBI_e_dot25";
		case SQN_NR_RA_Prioritization_scalingFactorBI_e_dot5: return "SQN_NR_RA_Prioritization_scalingFactorBI_e_dot5";
		case SQN_NR_RA_Prioritization_scalingFactorBI_e_dot75: return "SQN_NR_RA_Prioritization_scalingFactorBI_e_dot75";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RA_Prioritization_scalingFactorBI_e_scalingFactorBI_Optional(acpCtx_t _ctx, const struct SQN_NR_RA_Prioritization_scalingFactorBI_e_scalingFactorBI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RA_Prioritization_scalingFactorBI_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RA_Prioritization(acpCtx_t _ctx, const struct SQN_NR_RA_Prioritization* p)
{
	adbgPrintLog(_ctx, "powerRampingStepHighPriority := %s (%d)", adbgNrSys__SQN_NR_RA_Prioritization_powerRampingStepHighPriority_e__ToString(p->powerRampingStepHighPriority), (int)p->powerRampingStepHighPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scalingFactorBI := ");
	_adbgNrSys__SQN_NR_RA_Prioritization_scalingFactorBI_e_scalingFactorBI_Optional(_ctx, &p->scalingFactorBI);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16* p)
{
	adbgPrintLog(_ctx, "ra_Prioritization_r16 := { ");
	_adbgNrSys__SQN_NR_RA_Prioritization(_ctx, &p->ra_Prioritization_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PrioritizationForAI_r16 := '");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->ra_PrioritizationForAI_r16[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16_ra_PrioritizationForAccessIdentity_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16_ra_PrioritizationForAccessIdentity_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Value(acpCtx_t _ctx, const union SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Value* p, enum SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Sel d)
{
	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_l571) {
		adbgPrintLog(_ctx, "l571 := %u", (unsigned int)p->l571);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_l1151) {
		adbgPrintLog(_ctx, "l1151 := %u", (unsigned int)p->l1151);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16* p)
{
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_prach_RootSequenceIndex_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_prach_RootSequenceIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "rach_ConfigGeneric := { ");
	_adbgNrSys__SQN_NR_RACH_ConfigGeneric(_ctx, &p->rach_ConfigGeneric);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "totalNumberOfRA_Preambles := ");
	_adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommon_totalNumberOfRA_Preambles_Optional(_ctx, &p->totalNumberOfRA_Preambles);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_perRACH_OccasionAndCB_PreamblesPerSSB := ");
	if (p->ssb_perRACH_OccasionAndCB_PreamblesPerSSB.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Optional(_ctx, &p->ssb_perRACH_OccasionAndCB_PreamblesPerSSB);
	if (p->ssb_perRACH_OccasionAndCB_PreamblesPerSSB.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "groupBconfigured := ");
	if (p->groupBconfigured.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_groupBconfigured_groupBconfigured_Optional(_ctx, &p->groupBconfigured);
	if (p->groupBconfigured.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ContentionResolutionTimer := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_ra_ContentionResolutionTimer_e__ToString(p->ra_ContentionResolutionTimer), (int)p->ra_ContentionResolutionTimer);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rsrp_ThresholdSSB := ");
	_adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_Optional(_ctx, &p->rsrp_ThresholdSSB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rsrp_ThresholdSSB_SUL := ");
	_adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_SUL_Optional(_ctx, &p->rsrp_ThresholdSSB_SUL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_RootSequenceIndex := { ");
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex(_ctx, &p->prach_RootSequenceIndex);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msg1_SubcarrierSpacing := ");
	_adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommon_msg1_SubcarrierSpacing_Optional(_ctx, &p->msg1_SubcarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "restrictedSetConfig := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommon_restrictedSetConfig_e__ToString(p->restrictedSetConfig), (int)p->restrictedSetConfig);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msg3_transformPrecoder := ");
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_msg3_transformPrecoder_Optional(_ctx, &p->msg3_transformPrecoder);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PrioritizationForAccessIdentity_r16 := ");
	if (p->ra_PrioritizationForAccessIdentity_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16_ra_PrioritizationForAccessIdentity_r16_Optional(_ctx, &p->ra_PrioritizationForAccessIdentity_r16);
	if (p->ra_PrioritizationForAccessIdentity_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "prach_RootSequenceIndex_r16 := ");
	if (p->prach_RootSequenceIndex_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_prach_RootSequenceIndex_r16_Optional(_ctx, &p->prach_RootSequenceIndex_r16);
	if (p->prach_RootSequenceIndex_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_RACH_ConfigCommon(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_SQN_NR_BWP_UplinkCommon_rach_ConfigCommon_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_SQN_NR_BWP_UplinkCommon_rach_ConfigCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e__ToString(SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_enabled: return "SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_groupHoppingEnabledTransformPrecoding_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_groupHoppingEnabledTransformPrecoding_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_k2_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_k2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation_mappingType_e__ToString(SQN_NR_PUSCH_TimeDomainResourceAllocation_mappingType_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_TimeDomainResourceAllocation_mappingType_e_typeA: return "SQN_NR_PUSCH_TimeDomainResourceAllocation_mappingType_e_typeA";
		case SQN_NR_PUSCH_TimeDomainResourceAllocation_mappingType_e_typeB: return "SQN_NR_PUSCH_TimeDomainResourceAllocation_mappingType_e_typeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation(acpCtx_t _ctx, const struct SQN_NR_PUSCH_TimeDomainResourceAllocation* p)
{
	adbgPrintLog(_ctx, "k2 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_k2_Optional(_ctx, &p->k2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mappingType := %s (%d)", adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation_mappingType_e__ToString(p->mappingType), (int)p->mappingType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbolAndLength := %u", (unsigned int)p->startSymbolAndLength);
}

static void _adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocationList_SQN_NR_PUSCH_ConfigCommon_pusch_TimeDomainAllocationList_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_TimeDomainResourceAllocationList_SQN_NR_PUSCH_ConfigCommon_pusch_TimeDomainAllocationList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__Int8_t_SQN_NR_PUSCH_ConfigCommon_msg3_DeltaPreamble_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_PUSCH_ConfigCommon_msg3_DeltaPreamble_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int16_t_SQN_NR_PUSCH_ConfigCommon_p0_NominalWithGrant_Optional(acpCtx_t _ctx, const struct int16_t_SQN_NR_PUSCH_ConfigCommon_p0_NominalWithGrant_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_PUSCH_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_PUSCH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "groupHoppingEnabledTransformPrecoding := ");
	_adbgNrSys__SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_groupHoppingEnabledTransformPrecoding_Optional(_ctx, &p->groupHoppingEnabledTransformPrecoding);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_TimeDomainAllocationList := ");
	if (p->pusch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocationList_SQN_NR_PUSCH_ConfigCommon_pusch_TimeDomainAllocationList_Optional(_ctx, &p->pusch_TimeDomainAllocationList);
	if (p->pusch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msg3_DeltaPreamble := ");
	_adbgNrSys__Int8_t_SQN_NR_PUSCH_ConfigCommon_msg3_DeltaPreamble_Optional(_ctx, &p->msg3_DeltaPreamble);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_NominalWithGrant := ");
	_adbgNrSys__Int16_t_SQN_NR_PUSCH_ConfigCommon_p0_NominalWithGrant_Optional(_ctx, &p->p0_NominalWithGrant);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUSCH_ConfigCommon(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pusch_ConfigCommon_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pusch_ConfigCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUCCH_ConfigCommon_pucch_ResourceCommon_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUCCH_ConfigCommon_pucch_ResourceCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e__ToString(SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e_neither: return "SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e_neither";
		case SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e_enable: return "SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e_enable";
		case SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e_disable: return "SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e_disable";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint16_t_SQN_NR_PUCCH_ConfigCommon_hoppingId_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PUCCH_ConfigCommon_hoppingId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Int16_t_SQN_NR_PUCCH_ConfigCommon_p0_nominal_Optional(acpCtx_t _ctx, const struct int16_t_SQN_NR_PUCCH_ConfigCommon_p0_nominal_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ConfigCommon* p)
{
	adbgPrintLog(_ctx, "pucch_ResourceCommon := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUCCH_ConfigCommon_pucch_ResourceCommon_Optional(_ctx, &p->pucch_ResourceCommon);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_GroupHopping := %s (%d)", adbgNrSys__SQN_NR_PUCCH_ConfigCommon_pucch_GroupHopping_e__ToString(p->pucch_GroupHopping), (int)p->pucch_GroupHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "hoppingId := ");
	_adbgNrSys__Uint16_t_SQN_NR_PUCCH_ConfigCommon_hoppingId_Optional(_ctx, &p->hoppingId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_nominal := ");
	_adbgNrSys__Int16_t_SQN_NR_PUCCH_ConfigCommon_p0_nominal_Optional(_ctx, &p->p0_nominal);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUCCH_ConfigCommon(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pucch_ConfigCommon_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pucch_ConfigCommon_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_RACH_ConfigCommon(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_SQN_NR_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_SQN_NR_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e__ToString(SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e v)
{
	switch(v) {
		case SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_enabled: return "SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PRACH_ConfigurationIndex_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PRACH_ConfigurationIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e__ToString(SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_one: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_one";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_two: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_two";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_four: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_four";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_eight: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_eight";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_msgA_RO_FDM_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_msgA_RO_FDM_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FrequencyStart_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FrequencyStart_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_ZeroCorrelationZoneConfig_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_ZeroCorrelationZoneConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e__ToString(SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB0: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB0";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB2: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB2";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB4: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB4";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB6: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_dB6";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_msgA_PreamblePowerRampingStep_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_msgA_PreamblePowerRampingStep_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Int16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreambleReceivedTargetPower_r16_Optional(acpCtx_t _ctx, const struct int16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreambleReceivedTargetPower_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e__ToString(SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl1: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl1";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl2: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl2";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl4: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl4";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl8: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl8";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl10: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl10";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl20: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl20";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl40: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl40";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl80: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl80";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl160: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl160";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl320: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_sl320";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_msgB_ResponseWindow_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_msgB_ResponseWindow_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e__ToString(SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n3: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n3";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n4: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n4";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n5: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n5";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n6: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n6";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n7: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n7";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n8: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n8";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n10: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n10";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n20: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n20";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n50: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n50";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n100: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n100";
		case SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n200: return "SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_n200";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_preambleTransMax_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_preambleTransMax_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16* p)
{
	adbgPrintLog(_ctx, "msgA_PRACH_ConfigurationIndex_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PRACH_ConfigurationIndex_r16_Optional(_ctx, &p->msgA_PRACH_ConfigurationIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_RO_FDM_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_msgA_RO_FDM_r16_Optional(_ctx, &p->msgA_RO_FDM_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_RO_FrequencyStart_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FrequencyStart_r16_Optional(_ctx, &p->msgA_RO_FrequencyStart_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_ZeroCorrelationZoneConfig_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_ZeroCorrelationZoneConfig_r16_Optional(_ctx, &p->msgA_ZeroCorrelationZoneConfig_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PreamblePowerRampingStep_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_msgA_PreamblePowerRampingStep_r16_Optional(_ctx, &p->msgA_PreamblePowerRampingStep_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PreambleReceivedTargetPower_r16 := ");
	_adbgNrSys__Int16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreambleReceivedTargetPower_r16_Optional(_ctx, &p->msgA_PreambleReceivedTargetPower_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgB_ResponseWindow_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_msgB_ResponseWindow_r16_Optional(_ctx, &p->msgB_ResponseWindow_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "preambleTransMax_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_preambleTransMax_r16_Optional(_ctx, &p->preambleTransMax_r16);
}

static void _adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TotalNumberOfRA_Preambles_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TotalNumberOfRA_Preambles_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n4: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n4";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n8: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n8";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n12: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n12";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n16: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n16";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n20: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n20";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n24: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n24";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n28: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n28";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n32: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n32";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n36: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n36";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n40: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n40";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n44: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n44";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n48: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n48";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n52: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n52";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n56: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n56";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n60: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n60";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n64: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n4: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n4";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n8: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n8";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n12: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n12";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n16: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n16";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n20: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n20";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n24: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n24";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n28: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n28";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n32: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n32";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n36: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n36";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n40: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n40";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n44: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n44";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n48: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n48";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n52: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n52";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n56: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n56";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n60: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n60";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n64: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n4: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n4";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n8: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n8";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n12: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n12";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n16: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n16";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n20: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n20";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n24: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n24";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n28: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n28";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n32: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n32";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n36: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n36";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n40: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n40";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n44: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n44";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n48: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n48";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n52: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n52";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n56: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n56";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n60: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n60";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n64: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n4: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n4";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n8: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n8";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n12: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n12";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n16: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n16";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n20: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n20";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n24: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n24";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n28: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n28";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n32: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n32";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n36: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n36";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n40: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n40";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n44: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n44";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n48: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n48";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n52: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n52";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n56: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n56";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n60: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n60";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n64: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e_n64";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n4: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n4";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n8: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n8";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n12: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n12";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n16: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n16";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n20: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n20";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n24: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n24";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n28: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n28";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n32: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e_n32";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Value(acpCtx_t _ctx, const union SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Value* p, enum SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Sel d)
{
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth) {
		adbgPrintLog(_ctx, "oneEighth := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth_e__ToString(p->oneEighth), (int)p->oneEighth);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth) {
		adbgPrintLog(_ctx, "oneFourth := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth_e__ToString(p->oneFourth), (int)p->oneFourth);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf) {
		adbgPrintLog(_ctx, "oneHalf := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf_e__ToString(p->oneHalf), (int)p->oneHalf);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one) {
		adbgPrintLog(_ctx, "one := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one_e__ToString(p->one), (int)p->one);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two) {
		adbgPrintLog(_ctx, "two := %s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two_e__ToString(p->two), (int)p->two);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_four) {
		adbgPrintLog(_ctx, "four := %u", (unsigned int)p->four);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_eight) {
		adbgPrintLog(_ctx, "eight := %u", (unsigned int)p->eight);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_sixteen) {
		adbgPrintLog(_ctx, "sixteen := %u", (unsigned int)p->sixteen);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16* p)
{
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_CB_PreamblesPerSSB_PerSharedRO_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_CB_PreamblesPerSSB_PerSharedRO_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_SharedRO_MaskIndex_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_SharedRO_MaskIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e__ToString(SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e v)
{
	switch(v) {
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b56: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b56";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b144: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b144";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b208: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b208";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b256: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b256";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b282: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b282";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b480: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b480";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b640: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b640";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b800: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b800";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b1000: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b1000";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b72: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_b72";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare6: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare6";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare5: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare5";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare4: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare4";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare3: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare3";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare2: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare2";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare1: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e__ToString(SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e v)
{
	switch(v) {
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_minusinfinity: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_minusinfinity";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB0: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB0";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB5: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB5";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB8: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB8";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB10: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB10";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB12: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB12";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB15: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB15";
		case SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB18: return "SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e_dB18";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16(acpCtx_t _ctx, const struct SQN_NR_GroupB_ConfiguredTwoStepRA_r16* p)
{
	adbgPrintLog(_ctx, "ra_MsgA_SizeGroupA := %s (%d)", adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16_ra_MsgA_SizeGroupA_e__ToString(p->ra_MsgA_SizeGroupA), (int)p->ra_MsgA_SizeGroupA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "messagePowerOffsetGroupB := %s (%d)", adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16_messagePowerOffsetGroupB_e__ToString(p->messagePowerOffsetGroupB), (int)p->messagePowerOffsetGroupB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberofRA_PreamblesGroupA := %u", (unsigned int)p->numberofRA_PreamblesGroupA);
}

static void _adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_groupB_ConfiguredTwoStepRA_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_GroupB_ConfiguredTwoStepRA_r16_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_groupB_ConfiguredTwoStepRA_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Value(acpCtx_t _ctx, const union SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Value* p, enum SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Sel d)
{
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l839) {
		adbgPrintLog(_ctx, "l839 := %u", (unsigned int)p->l839);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l139) {
		adbgPrintLog(_ctx, "l139 := %u", (unsigned int)p->l139);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l571) {
		adbgPrintLog(_ctx, "l571 := %u", (unsigned int)p->l571);
		return;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l1151) {
		adbgPrintLog(_ctx, "l1151 := %u", (unsigned int)p->l1151);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16* p)
{
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_msgA_PRACH_RootSequenceIndex_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_msgA_PRACH_RootSequenceIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n1: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n1";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n2: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n2";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n4: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n4";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n6: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n6";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n8: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n8";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n10: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n10";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n20: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n20";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n50: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n50";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n100: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n100";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n200: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_n200";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_Threshold_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_Threshold_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_ThresholdSSB_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_ThresholdSSB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SubcarrierSpacing_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SubcarrierSpacing_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_unrestrictedSet: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_unrestrictedSet";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_restrictedSetTypeA: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_restrictedSetTypeA";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_restrictedSetTypeB: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_restrictedSetTypeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_msgA_RestrictedSetConfig_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_msgA_RestrictedSetConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16* p)
{
	adbgPrintLog(_ctx, "ra_Prioritization_r16 := { ");
	_adbgNrSys__SQN_NR_RA_Prioritization(_ctx, &p->ra_Prioritization_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PrioritizationForAI_r16 := '");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->ra_PrioritizationForAI_r16[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e__ToString(SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e v)
{
	switch(v) {
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf8: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf8";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf16: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf16";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf24: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf24";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf32: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf32";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf40: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf40";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf48: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf48";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf56: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf56";
		case SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf64: return "SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_sf64";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_ra_ContentionResolutionTimer_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_ra_ContentionResolutionTimer_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16* p)
{
	adbgPrintLog(_ctx, "rach_ConfigGenericTwoStepRA_r16 := { ");
	_adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16(_ctx, &p->rach_ConfigGenericTwoStepRA_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_TotalNumberOfRA_Preambles_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TotalNumberOfRA_Preambles_r16_Optional(_ctx, &p->msgA_TotalNumberOfRA_Preambles_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16 := ");
	if (p->msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Optional(_ctx, &p->msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16);
	if (p->msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_CB_PreamblesPerSSB_PerSharedRO_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_CB_PreamblesPerSSB_PerSharedRO_r16_Optional(_ctx, &p->msgA_CB_PreamblesPerSSB_PerSharedRO_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_SSB_SharedRO_MaskIndex_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_SharedRO_MaskIndex_r16_Optional(_ctx, &p->msgA_SSB_SharedRO_MaskIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "groupB_ConfiguredTwoStepRA_r16 := ");
	if (p->groupB_ConfiguredTwoStepRA_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_GroupB_ConfiguredTwoStepRA_r16_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_groupB_ConfiguredTwoStepRA_r16_Optional(_ctx, &p->groupB_ConfiguredTwoStepRA_r16);
	if (p->groupB_ConfiguredTwoStepRA_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PRACH_RootSequenceIndex_r16 := ");
	if (p->msgA_PRACH_RootSequenceIndex_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_msgA_PRACH_RootSequenceIndex_r16_Optional(_ctx, &p->msgA_PRACH_RootSequenceIndex_r16);
	if (p->msgA_PRACH_RootSequenceIndex_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_TransMax_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(_ctx, &p->msgA_TransMax_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_RSRP_Threshold_r16 := ");
	_adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_Threshold_r16_Optional(_ctx, &p->msgA_RSRP_Threshold_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_RSRP_ThresholdSSB_r16 := ");
	_adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_ThresholdSSB_r16_Optional(_ctx, &p->msgA_RSRP_ThresholdSSB_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_SubcarrierSpacing_r16 := ");
	_adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SubcarrierSpacing_r16_Optional(_ctx, &p->msgA_SubcarrierSpacing_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_RestrictedSetConfig_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_msgA_RestrictedSetConfig_r16_Optional(_ctx, &p->msgA_RestrictedSetConfig_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PrioritizationForAccessIdentityTwoStep_r16 := ");
	if (p->ra_PrioritizationForAccessIdentityTwoStep_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_Optional(_ctx, &p->ra_PrioritizationForAccessIdentityTwoStep_r16);
	if (p->ra_PrioritizationForAccessIdentityTwoStep_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ContentionResolutionTimer_r16 := ");
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_ra_ContentionResolutionTimer_r16_Optional(_ctx, &p->ra_ContentionResolutionTimer_r16);
}

static const char* adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e__ToString(SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_one: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_one";
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_two: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_two";
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_three: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_three";
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_six: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e_six";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_PUSCH_TimeDomainAllocation_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_PUSCH_TimeDomainAllocation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_startSymbolAndLengthMsgA_PO_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_startSymbolAndLengthMsgA_PO_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e__ToString(SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_typeA: return "SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_typeA";
		case SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_typeB: return "SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_typeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_mappingTypeMsgA_PUSCH_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_mappingTypeMsgA_PUSCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_guardPeriodMsgA_PUSCH_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_guardPeriodMsgA_PUSCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e__ToString(SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_one: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_one";
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_two: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_two";
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_four: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_four";
		case SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_eight: return "SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e_eight";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e__ToString(SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_enabled: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_msgA_IntraSlotFrequencyHopping_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_msgA_IntraSlotFrequencyHopping_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__B2_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_HoppingBits_r16_Optional(acpCtx_t _ctx, const struct B2_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_HoppingBits_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e__ToString(SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_pos0: return "SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_pos0";
		case SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_pos1: return "SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_pos1";
		case SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_pos3: return "SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_pos3";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_msgA_DMRS_AdditionalPosition_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_msgA_DMRS_AdditionalPosition_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e__ToString(SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_len2: return "SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_len2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_msgA_MaxLength_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_msgA_MaxLength_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_DMRS_CDM_Group_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_DMRS_CDM_Group_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_NrofPorts_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_NrofPorts_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID0_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID0_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID1_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16(acpCtx_t _ctx, const struct SQN_NR_MsgA_DMRS_Config_r16* p)
{
	adbgPrintLog(_ctx, "msgA_DMRS_AdditionalPosition_r16 := ");
	_adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_msgA_DMRS_AdditionalPosition_r16_Optional(_ctx, &p->msgA_DMRS_AdditionalPosition_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_MaxLength_r16 := ");
	_adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_msgA_MaxLength_r16_Optional(_ctx, &p->msgA_MaxLength_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PUSCH_DMRS_CDM_Group_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_DMRS_CDM_Group_r16_Optional(_ctx, &p->msgA_PUSCH_DMRS_CDM_Group_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PUSCH_NrofPorts_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_NrofPorts_r16_Optional(_ctx, &p->msgA_PUSCH_NrofPorts_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_ScramblingID0_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID0_r16_Optional(_ctx, &p->msgA_ScramblingID0_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_ScramblingID1_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID1_r16_Optional(_ctx, &p->msgA_ScramblingID1_r16);
}

static const char* adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e__ToString(SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha0: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha0";
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha04: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha04";
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha05: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha05";
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha06: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha06";
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha07: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha07";
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha08: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha08";
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha09: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha09";
		case SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha1: return "SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_alpha1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_msgA_Alpha_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_msgA_Alpha_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_interlaceIndexFirstPO_MsgA_PUSCH_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_interlaceIndexFirstPO_MsgA_PUSCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_nrofInterlacesPerMsgA_PO_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_nrofInterlacesPerMsgA_PO_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Resource_r16* p)
{
	adbgPrintLog(_ctx, "msgA_MCS_r16 := %u", (unsigned int)p->msgA_MCS_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSlotsMsgA_PUSCH_r16 := %u", (unsigned int)p->nrofSlotsMsgA_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofMsgA_PO_PerSlot_r16 := %s (%d)", adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_PerSlot_r16_e__ToString(p->nrofMsgA_PO_PerSlot_r16), (int)p->nrofMsgA_PO_PerSlot_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PUSCH_TimeDomainOffset_r16 := %u", (unsigned int)p->msgA_PUSCH_TimeDomainOffset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PUSCH_TimeDomainAllocation_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_PUSCH_TimeDomainAllocation_r16_Optional(_ctx, &p->msgA_PUSCH_TimeDomainAllocation_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbolAndLengthMsgA_PO_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_startSymbolAndLengthMsgA_PO_r16_Optional(_ctx, &p->startSymbolAndLengthMsgA_PO_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mappingTypeMsgA_PUSCH_r16 := ");
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_mappingTypeMsgA_PUSCH_r16_Optional(_ctx, &p->mappingTypeMsgA_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "guardPeriodMsgA_PUSCH_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_guardPeriodMsgA_PUSCH_r16_Optional(_ctx, &p->guardPeriodMsgA_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "guardBandMsgA_PUSCH_r16 := %u", (unsigned int)p->guardBandMsgA_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyStartMsgA_PUSCH_r16 := %u", (unsigned int)p->frequencyStartMsgA_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofPRBs_PerMsgA_PO_r16 := %u", (unsigned int)p->nrofPRBs_PerMsgA_PO_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofMsgA_PO_FDM_r16 := %s (%d)", adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_nrofMsgA_PO_FDM_r16_e__ToString(p->nrofMsgA_PO_FDM_r16), (int)p->nrofMsgA_PO_FDM_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_IntraSlotFrequencyHopping_r16 := ");
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_msgA_IntraSlotFrequencyHopping_r16_Optional(_ctx, &p->msgA_IntraSlotFrequencyHopping_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_HoppingBits_r16 := ");
	_adbgNrSys__B2_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_HoppingBits_r16_Optional(_ctx, &p->msgA_HoppingBits_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_DMRS_Config_r16 := { ");
	_adbgNrSys__SQN_NR_MsgA_DMRS_Config_r16(_ctx, &p->msgA_DMRS_Config_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofDMRS_Sequences_r16 := %u", (unsigned int)p->nrofDMRS_Sequences_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_Alpha_r16 := ");
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_msgA_Alpha_r16_Optional(_ctx, &p->msgA_Alpha_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interlaceIndexFirstPO_MsgA_PUSCH_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_interlaceIndexFirstPO_MsgA_PUSCH_r16_Optional(_ctx, &p->interlaceIndexFirstPO_MsgA_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofInterlacesPerMsgA_PO_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_nrofInterlacesPerMsgA_PO_r16_Optional(_ctx, &p->nrofInterlacesPerMsgA_PO_r16);
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupA_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupA_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupB_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e__ToString(SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e v)
{
	switch(v) {
		case SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_enabled: return "SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_enabled";
		case SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_disabled: return "SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_disabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_msgA_TransformPrecoder_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_msgA_TransformPrecoder_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DataScramblingIndex_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DataScramblingIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DeltaPreamble_r16_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DeltaPreamble_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Config_r16* p)
{
	adbgPrintLog(_ctx, "msgA_PUSCH_ResourceGroupA_r16 := ");
	if (p->msgA_PUSCH_ResourceGroupA_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupA_r16_Optional(_ctx, &p->msgA_PUSCH_ResourceGroupA_r16);
	if (p->msgA_PUSCH_ResourceGroupA_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PUSCH_ResourceGroupB_r16 := ");
	if (p->msgA_PUSCH_ResourceGroupB_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupB_r16_Optional(_ctx, &p->msgA_PUSCH_ResourceGroupB_r16);
	if (p->msgA_PUSCH_ResourceGroupB_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_TransformPrecoder_r16 := ");
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_msgA_TransformPrecoder_r16_Optional(_ctx, &p->msgA_TransformPrecoder_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_DataScramblingIndex_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DataScramblingIndex_r16_Optional(_ctx, &p->msgA_DataScramblingIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_DeltaPreamble_r16 := ");
	_adbgNrSys__Int8_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DeltaPreamble_r16_Optional(_ctx, &p->msgA_DeltaPreamble_r16);
}

static void _adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16_SQN_NR_MsgA_ConfigCommon_r16_msgA_PUSCH_Config_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MsgA_PUSCH_Config_r16_SQN_NR_MsgA_ConfigCommon_r16_msgA_PUSCH_Config_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_MsgA_ConfigCommon_r16(acpCtx_t _ctx, const struct SQN_NR_MsgA_ConfigCommon_r16* p)
{
	adbgPrintLog(_ctx, "rach_ConfigCommonTwoStepRA_r16 := { ");
	_adbgNrSys__SQN_NR_RACH_ConfigCommonTwoStepRA_r16(_ctx, &p->rach_ConfigCommonTwoStepRA_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PUSCH_Config_r16 := ");
	if (p->msgA_PUSCH_Config_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Config_r16_SQN_NR_MsgA_ConfigCommon_r16_msgA_PUSCH_Config_r16_Optional(_ctx, &p->msgA_PUSCH_Config_r16);
	if (p->msgA_PUSCH_Config_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_MsgA_ConfigCommon_r16(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_SQN_NR_BWP_UplinkCommon_msgA_ConfigCommon_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_SQN_NR_BWP_UplinkCommon_msgA_ConfigCommon_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_BWP_UplinkCommon(acpCtx_t _ctx, const struct SQN_NR_BWP_UplinkCommon* p)
{
	adbgPrintLog(_ctx, "genericParameters := { ");
	_adbgNrSys__SQN_NR_BWP(_ctx, &p->genericParameters);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rach_ConfigCommon := ");
	if (p->rach_ConfigCommon.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_SQN_NR_BWP_UplinkCommon_rach_ConfigCommon_Optional(_ctx, &p->rach_ConfigCommon);
	if (p->rach_ConfigCommon.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_ConfigCommon := ");
	if (p->pusch_ConfigCommon.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pusch_ConfigCommon_Optional(_ctx, &p->pusch_ConfigCommon);
	if (p->pusch_ConfigCommon.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_ConfigCommon := ");
	if (p->pucch_ConfigCommon.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pucch_ConfigCommon_Optional(_ctx, &p->pucch_ConfigCommon);
	if (p->pucch_ConfigCommon.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rach_ConfigCommonIAB_r16 := ");
	if (p->rach_ConfigCommonIAB_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_SQN_NR_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Optional(_ctx, &p->rach_ConfigCommonIAB_r16);
	if (p->rach_ConfigCommonIAB_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "useInterlacePUCCH_PUSCH_r16 := ");
	_adbgNrSys__SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(_ctx, &p->useInterlacePUCCH_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_ConfigCommon_r16 := ");
	if (p->msgA_ConfigCommon_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_SQN_NR_BWP_UplinkCommon_msgA_ConfigCommon_r16_Optional(_ctx, &p->msgA_ConfigCommon_r16);
	if (p->msgA_ConfigCommon_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_BWP_UplinkCommon_Type_Value(acpCtx_t _ctx, const union NR_ASN1_BWP_UplinkCommon_Type_Value* p, enum NR_ASN1_BWP_UplinkCommon_Type_Sel d)
{
	if (d == NR_ASN1_BWP_UplinkCommon_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_BWP_UplinkCommon(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_BWP_UplinkCommon_Type(acpCtx_t _ctx, const struct NR_ASN1_BWP_UplinkCommon_Type* p)
{
	_adbgNrSys__NR_ASN1_BWP_UplinkCommon_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_BWP_UplinkCommon_Type_Common_Optional(acpCtx_t _ctx, const struct NR_ASN1_BWP_UplinkCommon_Type_Common_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_BWP_UplinkCommon_Type(_ctx, &p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_PUCCH_ResourceSet_maxPayloadSize_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PUCCH_ResourceSet_maxPayloadSize_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceSet(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceSet* p)
{
	adbgPrintLog(_ctx, "pucch_ResourceSetId := %u", (unsigned int)p->pucch_ResourceSetId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceList := '");
	for (size_t i3 = 0; i3 < p->resourceList.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->resourceList.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxPayloadSize := ");
	_adbgNrSys__Uint16_t_SQN_NR_PUCCH_ResourceSet_maxPayloadSize_Optional(_ctx, &p->maxPayloadSize);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceSet_SQN_NR_PUCCH_Config_resourceSetToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceSet_SQN_NR_PUCCH_Config_resourceSetToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_ResourceSet(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceSetId_SQN_NR_PUCCH_Config_resourceSetToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceSetId_SQN_NR_PUCCH_Config_resourceSetToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e__ToString(SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_enabled: return "SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_intraSlotFrequencyHopping_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_intraSlotFrequencyHopping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PRB_Id_SQN_NR_PUCCH_Resource_secondHopPRB_Optional(acpCtx_t _ctx, const struct SQN_NR_PRB_Id_SQN_NR_PUCCH_Resource_secondHopPRB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_format0(acpCtx_t _ctx, const struct SQN_NR_PUCCH_format0* p)
{
	adbgPrintLog(_ctx, "initialCyclicShift := %u", (unsigned int)p->initialCyclicShift);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSymbols := %u", (unsigned int)p->nrofSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingSymbolIndex := %u", (unsigned int)p->startingSymbolIndex);
}

static void _adbgNrSys__SQN_NR_PUCCH_format1(acpCtx_t _ctx, const struct SQN_NR_PUCCH_format1* p)
{
	adbgPrintLog(_ctx, "initialCyclicShift := %u", (unsigned int)p->initialCyclicShift);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSymbols := %u", (unsigned int)p->nrofSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingSymbolIndex := %u", (unsigned int)p->startingSymbolIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeDomainOCC := %u", (unsigned int)p->timeDomainOCC);
}

static void _adbgNrSys__SQN_NR_PUCCH_format2(acpCtx_t _ctx, const struct SQN_NR_PUCCH_format2* p)
{
	adbgPrintLog(_ctx, "nrofPRBs := %u", (unsigned int)p->nrofPRBs);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSymbols := %u", (unsigned int)p->nrofSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingSymbolIndex := %u", (unsigned int)p->startingSymbolIndex);
}

static void _adbgNrSys__SQN_NR_PUCCH_format3(acpCtx_t _ctx, const struct SQN_NR_PUCCH_format3* p)
{
	adbgPrintLog(_ctx, "nrofPRBs := %u", (unsigned int)p->nrofPRBs);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSymbols := %u", (unsigned int)p->nrofSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingSymbolIndex := %u", (unsigned int)p->startingSymbolIndex);
}

static const char* adbgNrSys__SQN_NR_PUCCH_format4_occ_Length_e__ToString(SQN_NR_PUCCH_format4_occ_Length_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_format4_occ_Length_e_n2: return "SQN_NR_PUCCH_format4_occ_Length_e_n2";
		case SQN_NR_PUCCH_format4_occ_Length_e_n4: return "SQN_NR_PUCCH_format4_occ_Length_e_n4";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_PUCCH_format4_occ_Index_e__ToString(SQN_NR_PUCCH_format4_occ_Index_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_format4_occ_Index_e_n0: return "SQN_NR_PUCCH_format4_occ_Index_e_n0";
		case SQN_NR_PUCCH_format4_occ_Index_e_n1: return "SQN_NR_PUCCH_format4_occ_Index_e_n1";
		case SQN_NR_PUCCH_format4_occ_Index_e_n2: return "SQN_NR_PUCCH_format4_occ_Index_e_n2";
		case SQN_NR_PUCCH_format4_occ_Index_e_n3: return "SQN_NR_PUCCH_format4_occ_Index_e_n3";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_format4(acpCtx_t _ctx, const struct SQN_NR_PUCCH_format4* p)
{
	adbgPrintLog(_ctx, "nrofSymbols := %u", (unsigned int)p->nrofSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "occ_Length := %s (%d)", adbgNrSys__SQN_NR_PUCCH_format4_occ_Length_e__ToString(p->occ_Length), (int)p->occ_Length);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "occ_Index := %s (%d)", adbgNrSys__SQN_NR_PUCCH_format4_occ_Index_e__ToString(p->occ_Index), (int)p->occ_Index);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingSymbolIndex := %u", (unsigned int)p->startingSymbolIndex);
}

static void _adbgNrSys__SQN_NR_PUCCH_Resource_format_Value(acpCtx_t _ctx, const union SQN_NR_PUCCH_Resource_format_Value* p, enum SQN_NR_PUCCH_Resource_format_Sel d)
{
	if (d == SQN_NR_PUCCH_Resource_format_format0) {
		adbgPrintLog(_ctx, "format0 := { ");
		_adbgNrSys__SQN_NR_PUCCH_format0(_ctx, &p->format0);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format1) {
		adbgPrintLog(_ctx, "format1 := { ");
		_adbgNrSys__SQN_NR_PUCCH_format1(_ctx, &p->format1);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format2) {
		adbgPrintLog(_ctx, "format2 := { ");
		_adbgNrSys__SQN_NR_PUCCH_format2(_ctx, &p->format2);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format3) {
		adbgPrintLog(_ctx, "format3 := { ");
		_adbgNrSys__SQN_NR_PUCCH_format3(_ctx, &p->format3);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format4) {
		adbgPrintLog(_ctx, "format4 := { ");
		_adbgNrSys__SQN_NR_PUCCH_format4(_ctx, &p->format4);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUCCH_Resource_format(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Resource_format* p)
{
	_adbgNrSys__SQN_NR_PUCCH_Resource_format_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUCCH_Resource(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Resource* p)
{
	adbgPrintLog(_ctx, "pucch_ResourceId := %u", (unsigned int)p->pucch_ResourceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingPRB := %u", (unsigned int)p->startingPRB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraSlotFrequencyHopping := ");
	_adbgNrSys__SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_intraSlotFrequencyHopping_Optional(_ctx, &p->intraSlotFrequencyHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "secondHopPRB := ");
	_adbgNrSys__SQN_NR_PRB_Id_SQN_NR_PUCCH_Resource_secondHopPRB_Optional(_ctx, &p->secondHopPRB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "format := { ");
	_adbgNrSys__SQN_NR_PUCCH_Resource_format(_ctx, &p->format);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_PUCCH_Resource_SQN_NR_PUCCH_Config_resourceToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Resource_SQN_NR_PUCCH_Config_resourceToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_Resource(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_resourceToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_resourceToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e__ToString(SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_enabled: return "SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_interslotFrequencyHopping_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_interslotFrequencyHopping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_FormatConfig_additionalDMRS_e__ToString(SQN_NR_PUCCH_FormatConfig_additionalDMRS_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_FormatConfig_additionalDMRS_e_true: return "SQN_NR_PUCCH_FormatConfig_additionalDMRS_e_true";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_FormatConfig_additionalDMRS_e_additionalDMRS_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_FormatConfig_additionalDMRS_e_additionalDMRS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_FormatConfig_additionalDMRS_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_MaxCodeRate_e__ToString(SQN_NR_PUCCH_MaxCodeRate_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_MaxCodeRate_e_zeroDot08: return "SQN_NR_PUCCH_MaxCodeRate_e_zeroDot08";
		case SQN_NR_PUCCH_MaxCodeRate_e_zeroDot15: return "SQN_NR_PUCCH_MaxCodeRate_e_zeroDot15";
		case SQN_NR_PUCCH_MaxCodeRate_e_zeroDot25: return "SQN_NR_PUCCH_MaxCodeRate_e_zeroDot25";
		case SQN_NR_PUCCH_MaxCodeRate_e_zeroDot35: return "SQN_NR_PUCCH_MaxCodeRate_e_zeroDot35";
		case SQN_NR_PUCCH_MaxCodeRate_e_zeroDot45: return "SQN_NR_PUCCH_MaxCodeRate_e_zeroDot45";
		case SQN_NR_PUCCH_MaxCodeRate_e_zeroDot60: return "SQN_NR_PUCCH_MaxCodeRate_e_zeroDot60";
		case SQN_NR_PUCCH_MaxCodeRate_e_zeroDot80: return "SQN_NR_PUCCH_MaxCodeRate_e_zeroDot80";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_MaxCodeRate_e_SQN_NR_PUCCH_FormatConfig_maxCodeRate_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_MaxCodeRate_e_SQN_NR_PUCCH_FormatConfig_maxCodeRate_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_MaxCodeRate_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_FormatConfig_nrofSlots_e__ToString(SQN_NR_PUCCH_FormatConfig_nrofSlots_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_FormatConfig_nrofSlots_e_n2: return "SQN_NR_PUCCH_FormatConfig_nrofSlots_e_n2";
		case SQN_NR_PUCCH_FormatConfig_nrofSlots_e_n4: return "SQN_NR_PUCCH_FormatConfig_nrofSlots_e_n4";
		case SQN_NR_PUCCH_FormatConfig_nrofSlots_e_n8: return "SQN_NR_PUCCH_FormatConfig_nrofSlots_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_FormatConfig_nrofSlots_e_nrofSlots_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_FormatConfig_nrofSlots_e_nrofSlots_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_FormatConfig_nrofSlots_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_FormatConfig_pi2BPSK_e__ToString(SQN_NR_PUCCH_FormatConfig_pi2BPSK_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_FormatConfig_pi2BPSK_e_enabled: return "SQN_NR_PUCCH_FormatConfig_pi2BPSK_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_FormatConfig_pi2BPSK_e_pi2BPSK_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_FormatConfig_pi2BPSK_e_pi2BPSK_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_FormatConfig_pi2BPSK_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e__ToString(SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_true: return "SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_true";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_simultaneousHARQ_ACK_CSI_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_simultaneousHARQ_ACK_CSI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_FormatConfig(acpCtx_t _ctx, const struct SQN_NR_PUCCH_FormatConfig* p)
{
	adbgPrintLog(_ctx, "interslotFrequencyHopping := ");
	_adbgNrSys__SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_interslotFrequencyHopping_Optional(_ctx, &p->interslotFrequencyHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalDMRS := ");
	_adbgNrSys__SQN_NR_PUCCH_FormatConfig_additionalDMRS_e_additionalDMRS_Optional(_ctx, &p->additionalDMRS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxCodeRate := ");
	_adbgNrSys__SQN_NR_PUCCH_MaxCodeRate_e_SQN_NR_PUCCH_FormatConfig_maxCodeRate_Optional(_ctx, &p->maxCodeRate);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSlots := ");
	_adbgNrSys__SQN_NR_PUCCH_FormatConfig_nrofSlots_e_nrofSlots_Optional(_ctx, &p->nrofSlots);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pi2BPSK := ");
	_adbgNrSys__SQN_NR_PUCCH_FormatConfig_pi2BPSK_e_pi2BPSK_Optional(_ctx, &p->pi2BPSK);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "simultaneousHARQ_ACK_CSI := ");
	_adbgNrSys__SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_simultaneousHARQ_ACK_CSI_Optional(_ctx, &p->simultaneousHARQ_ACK_CSI);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format1_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_format1_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format1_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format1_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format1_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUCCH_FormatConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format1(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format1* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format1_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format1_SQN_NR_PUCCH_Config_format1_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format1_SQN_NR_PUCCH_Config_format1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format1(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format2_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_format2_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format2_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format2_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format2_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUCCH_FormatConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format2(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format2* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format2_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format2_SQN_NR_PUCCH_Config_format2_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format2_SQN_NR_PUCCH_Config_format2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format2(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format3_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_format3_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format3_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format3_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format3_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUCCH_FormatConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format3(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format3* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format3_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format3_SQN_NR_PUCCH_Config_format3_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format3_SQN_NR_PUCCH_Config_format3_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format3(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format4_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_format4_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format4_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format4_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format4_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUCCH_FormatConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format4(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format4* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format4_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format4_SQN_NR_PUCCH_Config_format4_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_format4_SQN_NR_PUCCH_Config_format4_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format4(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Value(acpCtx_t _ctx, const union SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Value* p, enum SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Sel d)
{
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sym2) {
		adbgPrintLog(_ctx, "sym2 := %s", (p->sym2 ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sym6or7) {
		adbgPrintLog(_ctx, "sym6or7 := %s", (p->sym6or7 ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl1) {
		adbgPrintLog(_ctx, "sl1 := %s", (p->sl1 ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl2) {
		adbgPrintLog(_ctx, "sl2 := %u", (unsigned int)p->sl2);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl4) {
		adbgPrintLog(_ctx, "sl4 := %u", (unsigned int)p->sl4);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl5) {
		adbgPrintLog(_ctx, "sl5 := %u", (unsigned int)p->sl5);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl8) {
		adbgPrintLog(_ctx, "sl8 := %u", (unsigned int)p->sl8);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl10) {
		adbgPrintLog(_ctx, "sl10 := %u", (unsigned int)p->sl10);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl16) {
		adbgPrintLog(_ctx, "sl16 := %u", (unsigned int)p->sl16);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl20) {
		adbgPrintLog(_ctx, "sl20 := %u", (unsigned int)p->sl20);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl40) {
		adbgPrintLog(_ctx, "sl40 := %u", (unsigned int)p->sl40);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl80) {
		adbgPrintLog(_ctx, "sl80 := %u", (unsigned int)p->sl80);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl160) {
		adbgPrintLog(_ctx, "sl160 := %u", (unsigned int)p->sl160);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl320) {
		adbgPrintLog(_ctx, "sl320 := %u", (unsigned int)p->sl320);
		return;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl640) {
		adbgPrintLog(_ctx, "sl640 := %u", (unsigned int)p->sl640);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset* p)
{
	_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_periodicityAndOffset_Optional(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_periodicityAndOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_SchedulingRequestResourceConfig_resource_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_SchedulingRequestResourceConfig_resource_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceConfig* p)
{
	adbgPrintLog(_ctx, "schedulingRequestResourceId := %u", (unsigned int)p->schedulingRequestResourceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "schedulingRequestID := %u", (unsigned int)p->schedulingRequestID);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicityAndOffset := ");
	if (p->periodicityAndOffset.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_periodicityAndOffset_Optional(_ctx, &p->periodicityAndOffset);
	if (p->periodicityAndOffset.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resource := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_SchedulingRequestResourceConfig_resource_Optional(_ctx, &p->resource);
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceConfig_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceId_SQN_NR_PUCCH_Config_schedulingRequestResourceToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceId_SQN_NR_PUCCH_Config_schedulingRequestResourceToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_multi_CSI_PUCCH_ResourceList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_multi_CSI_PUCCH_ResourceList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DynamicOptional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_PUCCH_SpatialRelationInfo_servingCellId_Optional(acpCtx_t _ctx, const struct SQN_NR_ServCellIndex_SQN_NR_PUCCH_SpatialRelationInfo_servingCellId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_SRS(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SRS* p)
{
	adbgPrintLog(_ctx, "resource := %u", (unsigned int)p->resource);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uplinkBWP := %u", (unsigned int)p->uplinkBWP);
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Value(acpCtx_t _ctx, const union SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Value* p, enum SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Sel d)
{
	if (d == SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_ssb_Index) {
		adbgPrintLog(_ctx, "ssb_Index := %u", (unsigned int)p->ssb_Index);
		return;
	}
	if (d == SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_csi_RS_Index) {
		adbgPrintLog(_ctx, "csi_RS_Index := %u", (unsigned int)p->csi_RS_Index);
		return;
	}
	if (d == SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_srs) {
		adbgPrintLog(_ctx, "srs := { ");
		_adbgNrSys__SQN_NR_PUCCH_SRS(_ctx, &p->srs);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal* p)
{
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_closedLoopIndex_e__ToString(SQN_NR_PUCCH_SpatialRelationInfo_closedLoopIndex_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_SpatialRelationInfo_closedLoopIndex_e_i0: return "SQN_NR_PUCCH_SpatialRelationInfo_closedLoopIndex_e_i0";
		case SQN_NR_PUCCH_SpatialRelationInfo_closedLoopIndex_e_i1: return "SQN_NR_PUCCH_SpatialRelationInfo_closedLoopIndex_e_i1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfo* p)
{
	adbgPrintLog(_ctx, "pucch_SpatialRelationInfoId := %u", (unsigned int)p->pucch_SpatialRelationInfoId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "servingCellId := ");
	_adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_PUCCH_SpatialRelationInfo_servingCellId_Optional(_ctx, &p->servingCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal := { ");
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal(_ctx, &p->referenceSignal);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_PathlossReferenceRS_Id := %u", (unsigned int)p->pucch_PathlossReferenceRS_Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_PUCCH_Id := %u", (unsigned int)p->p0_PUCCH_Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "closedLoopIndex := %s (%d)", adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_closedLoopIndex_e__ToString(p->closedLoopIndex), (int)p->closedLoopIndex);
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f0_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f1_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f2_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f3_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f3_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f4_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f4_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_P0_PUCCH(acpCtx_t _ctx, const struct SQN_NR_P0_PUCCH* p)
{
	adbgPrintLog(_ctx, "p0_PUCCH_Id := %u", (unsigned int)p->p0_PUCCH_Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_PUCCH_Value := %d", (int)p->p0_PUCCH_Value);
}

static void _adbgNrSys__SQN_NR_P0_PUCCH_SQN_NR_PUCCH_PowerControl_p0_Set_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_P0_PUCCH_SQN_NR_PUCCH_PowerControl_p0_Set_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_P0_PUCCH(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Value(acpCtx_t _ctx, const union SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Value* p, enum SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Sel d)
{
	if (d == SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_ssb_Index) {
		adbgPrintLog(_ctx, "ssb_Index := %u", (unsigned int)p->ssb_Index);
		return;
	}
	if (d == SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_csi_RS_Index) {
		adbgPrintLog(_ctx, "csi_RS_Index := %u", (unsigned int)p->csi_RS_Index);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal* p)
{
	_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PathlossReferenceRS* p)
{
	adbgPrintLog(_ctx, "pucch_PathlossReferenceRS_Id := %u", (unsigned int)p->pucch_PathlossReferenceRS_Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal := { ");
	_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal(_ctx, &p->referenceSignal);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PathlossReferenceRS_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e__ToString(SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoStates: return "SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoStates";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoPUCCH_PC_AdjustmentStates_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoPUCCH_PC_AdjustmentStates_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(acpCtx_t _ctx, const union SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Value* p, enum SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Sel d)
{
	if (d == SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_ssb_Index_r16) {
		adbgPrintLog(_ctx, "ssb_Index_r16 := %u", (unsigned int)p->ssb_Index_r16);
		return;
	}
	if (d == SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_csi_RS_Index_r16) {
		adbgPrintLog(_ctx, "csi_RS_Index_r16 := %u", (unsigned int)p->csi_RS_Index_r16);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16* p)
{
	_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_r16(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PathlossReferenceRS_r16* p)
{
	adbgPrintLog(_ctx, "pucch_PathlossReferenceRS_Id_r16 := %u", (unsigned int)p->pucch_PathlossReferenceRS_Id_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal_r16 := { ");
	_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16(_ctx, &p->referenceSignal_r16);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Value* p, enum SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_PowerControl(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PowerControl* p)
{
	adbgPrintLog(_ctx, "deltaF_PUCCH_f0 := ");
	_adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f0_Optional(_ctx, &p->deltaF_PUCCH_f0);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_f1 := ");
	_adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f1_Optional(_ctx, &p->deltaF_PUCCH_f1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_f2 := ");
	_adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f2_Optional(_ctx, &p->deltaF_PUCCH_f2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_f3 := ");
	_adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f3_Optional(_ctx, &p->deltaF_PUCCH_f3);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaF_PUCCH_f4 := ");
	_adbgNrSys__Int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f4_Optional(_ctx, &p->deltaF_PUCCH_f4);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_Set := ");
	if (p->p0_Set.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_P0_PUCCH_SQN_NR_PUCCH_PowerControl_p0_Set_DynamicOptional(_ctx, &p->p0_Set);
	if (p->p0_Set.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRSs := ");
	if (p->pathlossReferenceRSs.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_DynamicOptional(_ctx, &p->pathlossReferenceRSs);
	if (p->pathlossReferenceRSs.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "twoPUCCH_PC_AdjustmentStates := ");
	_adbgNrSys__SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoPUCCH_PC_AdjustmentStates_Optional(_ctx, &p->twoPUCCH_PC_AdjustmentStates);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRSs_v1610 := ");
	if (p->pathlossReferenceRSs_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Optional(_ctx, &p->pathlossReferenceRSs_v1610);
	if (p->pathlossReferenceRSs_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_PUCCH_PowerControl_SQN_NR_PUCCH_Config_pucch_PowerControl_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PowerControl_SQN_NR_PUCCH_Config_pucch_PowerControl_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PUCCH_PowerControl(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Value(acpCtx_t _ctx, const union SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Value* p, enum SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Sel d)
{
	if (d == SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_scs15) {
		adbgPrintLog(_ctx, "scs15 := %u", (unsigned int)p->scs15);
		return;
	}
	if (d == SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_scs30) {
		adbgPrintLog(_ctx, "scs30 := %u", (unsigned int)p->scs30);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0* p)
{
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16* p)
{
	adbgPrintLog(_ctx, "rb_SetIndex := %u", (unsigned int)p->rb_SetIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interlace0 := { ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0(_ctx, &p->interlace0);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlaceAllocation_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlaceAllocation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e__ToString(SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_n2: return "SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_n2";
		case SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_n4: return "SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_n4";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_occ_Length_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_occ_Length_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e__ToString(SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n0: return "SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n0";
		case SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n1: return "SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n1";
		case SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n2: return "SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n2";
		case SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n3: return "SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_n3";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_occ_Index_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_occ_Index_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610* p)
{
	adbgPrintLog(_ctx, "occ_Length_v1610 := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_occ_Length_v1610_Optional(_ctx, &p->occ_Length_v1610);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "occ_Index_v1610 := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_occ_Index_v1610_Optional(_ctx, &p->occ_Index_v1610);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Value(acpCtx_t _ctx, const union SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Value* p, enum SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Sel d)
{
	if (d == SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_interlace1_v1610) {
		adbgPrintLog(_ctx, "interlace1_v1610 := %u", (unsigned int)p->interlace1_v1610);
		return;
	}
	if (d == SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610) {
		adbgPrintLog(_ctx, "occ_v1610 := { ");
		_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610(_ctx, &p->occ_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610* p)
{
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_formatExt_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_formatExt_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16* p)
{
	adbgPrintLog(_ctx, "interlaceAllocation_r16 := ");
	if (p->interlaceAllocation_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlaceAllocation_r16_Optional(_ctx, &p->interlaceAllocation_r16);
	if (p->interlaceAllocation_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "formatExt_v1610 := ");
	if (p->formatExt_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_formatExt_v1610_Optional(_ctx, &p->formatExt_v1610);
	if (p->formatExt_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_SQN_NR_PUCCH_Config_resourceToAddModListExt_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceExt_r16_SQN_NR_PUCCH_Config_resourceToAddModListExt_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_setup) {
		adbgPrintLog(_ctx, "setup := '");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "%02X", p->setup.v[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_setup) {
		adbgPrintLog(_ctx, "setup := '");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "%02X", p->setup.v[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_SQN_NR_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_SQN_NR_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16_e__ToString(SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16_e_n2: return "SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16_e_n2";
		case SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16_e_n7: return "SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16_e_n7";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16_e__ToString(SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16_e_n2: return "SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16_e_n2";
		case SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16_e_n6: return "SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16_e_n6";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Value(acpCtx_t _ctx, const union SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Value* p, enum SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Sel d)
{
	if (d == SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16) {
		adbgPrintLog(_ctx, "normalCP_r16 := %s (%d)", adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16_e__ToString(p->normalCP_r16), (int)p->normalCP_r16);
		return;
	}
	if (d == SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16) {
		adbgPrintLog(_ctx, "extendedCP_r16 := %s (%d)", adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16_e__ToString(p->extendedCP_r16), (int)p->extendedCP_r16);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16* p)
{
	_adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_subslotLengthForPUCCH_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_subslotLengthForPUCCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := '");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "%02X", p->setup.v[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUCCH_Config_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUCCH_Config_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e__ToString(SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e v)
{
	switch(v) {
		case SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_enabled: return "SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_dmrs_UplinkTransformPrecodingPUCCH_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_dmrs_UplinkTransformPrecodingPUCCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_SpatialRelationInfoId_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_SpatialRelationInfoId_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_PathlossReferenceRS_Id_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_PathlossReferenceRS_Id_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoExt_r16(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfoExt_r16* p)
{
	adbgPrintLog(_ctx, "pucch_SpatialRelationInfoId_v1610 := ");
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_SpatialRelationInfoId_v1610_Optional(_ctx, &p->pucch_SpatialRelationInfoId_v1610);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_PathlossReferenceRS_Id_v1610 := ");
	_adbgNrSys__SQN_NR_PUCCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_PathlossReferenceRS_Id_v1610_Optional(_ctx, &p->pucch_PathlossReferenceRS_Id_v1610);
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoExt_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModListExt_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfoExt_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModListExt_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoExt_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceGroup_r16(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceGroup_r16* p)
{
	adbgPrintLog(_ctx, "pucch_ResourceGroupId_r16 := %u", (unsigned int)p->pucch_ResourceGroupId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourcePerGroupList_r16 := '");
	for (size_t i3 = 0; i3 < p->resourcePerGroupList_r16.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->resourcePerGroupList_r16.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceGroup_r16_SQN_NR_PUCCH_Config_resourceGroupToAddModList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceGroup_r16_SQN_NR_PUCCH_Config_resourceGroupToAddModList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUCCH_ResourceGroup_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_ResourceGroupId_r16_SQN_NR_PUCCH_Config_resourceGroupToReleaseList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUCCH_ResourceGroupId_r16_SQN_NR_PUCCH_Config_resourceGroupToReleaseList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint16_t_SQN_NR_SPS_PUCCH_AN_r16_maxPayloadSize_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_SPS_PUCCH_AN_r16_maxPayloadSize_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SPS_PUCCH_AN_r16(acpCtx_t _ctx, const struct SQN_NR_SPS_PUCCH_AN_r16* p)
{
	adbgPrintLog(_ctx, "sps_PUCCH_AN_ResourceID_r16 := %u", (unsigned int)p->sps_PUCCH_AN_ResourceID_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxPayloadSize_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_SPS_PUCCH_AN_r16_maxPayloadSize_r16_Optional(_ctx, &p->maxPayloadSize_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_SPS_PUCCH_AN_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_SQN_NR_PUCCH_Config_sps_PUCCH_AN_List_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_SQN_NR_PUCCH_Config_sps_PUCCH_AN_List_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e__ToString(SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e v)
{
	switch(v) {
		case SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_p0: return "SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_p0";
		case SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_p1: return "SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_p1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceConfig_v1610* p)
{
	adbgPrintLog(_ctx, "phy_PriorityIndex_r16 := ");
	_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(_ctx, &p->phy_PriorityIndex_r16);
}

static void _adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_v1610_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SchedulingRequestResourceConfig_v1610_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_v1610_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUCCH_Config(acpCtx_t _ctx, const struct SQN_NR_PUCCH_Config* p)
{
	adbgPrintLog(_ctx, "resourceSetToAddModList := ");
	if (p->resourceSetToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_ResourceSet_SQN_NR_PUCCH_Config_resourceSetToAddModList_DynamicOptional(_ctx, &p->resourceSetToAddModList);
	if (p->resourceSetToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceSetToReleaseList := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceSetId_SQN_NR_PUCCH_Config_resourceSetToReleaseList_DynamicOptional(_ctx, &p->resourceSetToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceToAddModList := ");
	if (p->resourceToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_Resource_SQN_NR_PUCCH_Config_resourceToAddModList_DynamicOptional(_ctx, &p->resourceToAddModList);
	if (p->resourceToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceToReleaseList := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_resourceToReleaseList_DynamicOptional(_ctx, &p->resourceToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "format1 := ");
	if (p->format1.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format1_SQN_NR_PUCCH_Config_format1_Optional(_ctx, &p->format1);
	if (p->format1.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "format2 := ");
	if (p->format2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format2_SQN_NR_PUCCH_Config_format2_Optional(_ctx, &p->format2);
	if (p->format2.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "format3 := ");
	if (p->format3.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format3_SQN_NR_PUCCH_Config_format3_Optional(_ctx, &p->format3);
	if (p->format3.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "format4 := ");
	if (p->format4.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_format4_SQN_NR_PUCCH_Config_format4_Optional(_ctx, &p->format4);
	if (p->format4.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "schedulingRequestResourceToAddModList := ");
	if (p->schedulingRequestResourceToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_DynamicOptional(_ctx, &p->schedulingRequestResourceToAddModList);
	if (p->schedulingRequestResourceToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "schedulingRequestResourceToReleaseList := ");
	_adbgNrSys__SQN_NR_SchedulingRequestResourceId_SQN_NR_PUCCH_Config_schedulingRequestResourceToReleaseList_DynamicOptional(_ctx, &p->schedulingRequestResourceToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "multi_CSI_PUCCH_ResourceList := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_multi_CSI_PUCCH_ResourceList_DynamicOptional(_ctx, &p->multi_CSI_PUCCH_ResourceList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dl_DataToUL_ACK := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DynamicOptional(_ctx, &p->dl_DataToUL_ACK);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfoToAddModList := ");
	if (p->spatialRelationInfoToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList_DynamicOptional(_ctx, &p->spatialRelationInfoToAddModList);
	if (p->spatialRelationInfoToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfoToReleaseList := ");
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_DynamicOptional(_ctx, &p->spatialRelationInfoToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_PowerControl := ");
	if (p->pucch_PowerControl.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_PowerControl_SQN_NR_PUCCH_Config_pucch_PowerControl_Optional(_ctx, &p->pucch_PowerControl);
	if (p->pucch_PowerControl.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceToAddModListExt_r16 := ");
	if (p->resourceToAddModListExt_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_ResourceExt_r16_SQN_NR_PUCCH_Config_resourceToAddModListExt_r16_DynamicOptional(_ctx, &p->resourceToAddModListExt_r16);
	if (p->resourceToAddModListExt_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dl_DataToUL_ACK_r16 := ");
	if (p->dl_DataToUL_ACK_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_r16_Optional(_ctx, &p->dl_DataToUL_ACK_r16);
	if (p->dl_DataToUL_ACK_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ul_AccessConfigListDCI_1_1_r16 := ");
	if (p->ul_AccessConfigListDCI_1_1_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_SQN_NR_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Optional(_ctx, &p->ul_AccessConfigListDCI_1_1_r16);
	if (p->ul_AccessConfigListDCI_1_1_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subslotLengthForPUCCH_r16 := ");
	if (p->subslotLengthForPUCCH_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_subslotLengthForPUCCH_r16_Optional(_ctx, &p->subslotLengthForPUCCH_r16);
	if (p->subslotLengthForPUCCH_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dl_DataToUL_ACK_DCI_1_2_r16 := ");
	if (p->dl_DataToUL_ACK_DCI_1_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Optional(_ctx, &p->dl_DataToUL_ACK_DCI_1_2_r16);
	if (p->dl_DataToUL_ACK_DCI_1_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUCCH_Config_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16_Optional(_ctx, &p->numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_UplinkTransformPrecodingPUCCH_r16 := ");
	_adbgNrSys__SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_dmrs_UplinkTransformPrecodingPUCCH_r16_Optional(_ctx, &p->dmrs_UplinkTransformPrecodingPUCCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfoToAddModList2_r16 := ");
	if (p->spatialRelationInfoToAddModList2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList2_r16_DynamicOptional(_ctx, &p->spatialRelationInfoToAddModList2_r16);
	if (p->spatialRelationInfoToAddModList2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfoToReleaseList2_r16 := ");
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList2_r16_DynamicOptional(_ctx, &p->spatialRelationInfoToReleaseList2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfoToAddModListExt_r16 := ");
	if (p->spatialRelationInfoToAddModListExt_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoExt_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModListExt_r16_DynamicOptional(_ctx, &p->spatialRelationInfoToAddModListExt_r16);
	if (p->spatialRelationInfoToAddModListExt_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfoToReleaseList_r16 := ");
	_adbgNrSys__SQN_NR_PUCCH_SpatialRelationInfoId_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_r16_DynamicOptional(_ctx, &p->spatialRelationInfoToReleaseList_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceGroupToAddModList_r16 := ");
	if (p->resourceGroupToAddModList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUCCH_ResourceGroup_r16_SQN_NR_PUCCH_Config_resourceGroupToAddModList_r16_DynamicOptional(_ctx, &p->resourceGroupToAddModList_r16);
	if (p->resourceGroupToAddModList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceGroupToReleaseList_r16 := ");
	_adbgNrSys__SQN_NR_PUCCH_ResourceGroupId_r16_SQN_NR_PUCCH_Config_resourceGroupToReleaseList_r16_DynamicOptional(_ctx, &p->resourceGroupToReleaseList_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sps_PUCCH_AN_List_r16 := ");
	if (p->sps_PUCCH_AN_List_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_SQN_NR_PUCCH_Config_sps_PUCCH_AN_List_r16_Optional(_ctx, &p->sps_PUCCH_AN_List_r16);
	if (p->sps_PUCCH_AN_List_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "schedulingRequestResourceToAddModList_v1610 := ");
	if (p->schedulingRequestResourceToAddModList_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SchedulingRequestResourceConfig_v1610_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_v1610_DynamicOptional(_ctx, &p->schedulingRequestResourceToAddModList_v1610);
	if (p->schedulingRequestResourceToAddModList_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUCCH_Config(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_SQN_NR_BWP_UplinkDedicated_pucch_Config_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_SQN_NR_BWP_UplinkDedicated_pucch_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config(_ctx, &p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_PUSCH_Config_dataScramblingIdentityPUSCH_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PUSCH_Config_dataScramblingIdentityPUSCH_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_txConfig_e__ToString(SQN_NR_PUSCH_Config_txConfig_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_txConfig_e_codebook: return "SQN_NR_PUSCH_Config_txConfig_e_codebook";
		case SQN_NR_PUSCH_Config_txConfig_e_nonCodebook: return "SQN_NR_PUSCH_Config_txConfig_e_nonCodebook";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_txConfig_e_txConfig_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_txConfig_e_txConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_txConfig_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_Type_e__ToString(SQN_NR_DMRS_UplinkConfig_dmrs_Type_e v)
{
	switch(v) {
		case SQN_NR_DMRS_UplinkConfig_dmrs_Type_e_type2: return "SQN_NR_DMRS_UplinkConfig_dmrs_Type_e_type2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_Type_e_dmrs_Type_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_dmrs_Type_e_dmrs_Type_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_Type_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e__ToString(SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e v)
{
	switch(v) {
		case SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_pos0: return "SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_pos0";
		case SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_pos1: return "SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_pos1";
		case SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_pos3: return "SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_pos3";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_frequencyDensity_ArrayOptional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_frequencyDensity_ArrayOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_timeDensity_ArrayOptional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_timeDensity_ArrayOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 3; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_maxNrofPorts_e__ToString(SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_maxNrofPorts_e v)
{
	switch(v) {
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_maxNrofPorts_e_n1: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_maxNrofPorts_e_n1";
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_maxNrofPorts_e_n2: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_maxNrofPorts_e_n2";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e__ToString(SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e v)
{
	switch(v) {
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_offset01: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_offset01";
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_offset10: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_offset10";
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_offset11: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_offset11";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_resourceElementOffset_Optional(acpCtx_t _ctx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_resourceElementOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e__ToString(SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e v)
{
	switch(v) {
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p00: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p00";
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p01: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p01";
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p10: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p10";
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p11: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e_p11";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled(acpCtx_t _ctx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled* p)
{
	adbgPrintLog(_ctx, "frequencyDensity := ");
	_adbgNrSys__Uint16_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_frequencyDensity_ArrayOptional(_ctx, &p->frequencyDensity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeDensity := ");
	_adbgNrSys__Uint8_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_timeDensity_ArrayOptional(_ctx, &p->timeDensity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxNrofPorts := %s (%d)", adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_maxNrofPorts_e__ToString(p->maxNrofPorts), (int)p->maxNrofPorts);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceElementOffset := ");
	_adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_resourceElementOffset_Optional(_ctx, &p->resourceElementOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ptrs_Power := %s (%d)", adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_ptrs_Power_e__ToString(p->ptrs_Power), (int)p->ptrs_Power);
}

static void _adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_transformPrecoderDisabled_Optional(acpCtx_t _ctx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_transformPrecoderDisabled_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e__ToString(SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e v)
{
	switch(v) {
		case SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_d2: return "SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_d2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_timeDensityTransformPrecoding_Optional(acpCtx_t _ctx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_timeDensityTransformPrecoding_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled(acpCtx_t _ctx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled* p)
{
	adbgPrintLog(_ctx, "sampleDensity := '");
	for (size_t i2 = 0; i2 < 5; i2++) {
		adbgPrintLog(_ctx, "%02X", p->sampleDensity[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeDensityTransformPrecoding := ");
	_adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_timeDensityTransformPrecoding_Optional(_ctx, &p->timeDensityTransformPrecoding);
}

static void _adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_transformPrecoderEnabled_Optional(acpCtx_t _ctx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_transformPrecoderEnabled_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PTRS_UplinkConfig(acpCtx_t _ctx, const struct SQN_NR_PTRS_UplinkConfig* p)
{
	adbgPrintLog(_ctx, "transformPrecoderDisabled := ");
	if (p->transformPrecoderDisabled.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_transformPrecoderDisabled_Optional(_ctx, &p->transformPrecoderDisabled);
	if (p->transformPrecoderDisabled.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transformPrecoderEnabled := ");
	if (p->transformPrecoderEnabled.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_transformPrecoderEnabled_Optional(_ctx, &p->transformPrecoderEnabled);
	if (p->transformPrecoderEnabled.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Value* p, enum SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Sel d)
{
	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PTRS_UplinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_SQN_NR_DMRS_UplinkConfig_phaseTrackingRS_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_SQN_NR_DMRS_UplinkConfig_phaseTrackingRS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_UplinkConfig_maxLength_e__ToString(SQN_NR_DMRS_UplinkConfig_maxLength_e v)
{
	switch(v) {
		case SQN_NR_DMRS_UplinkConfig_maxLength_e_len2: return "SQN_NR_DMRS_UplinkConfig_maxLength_e_len2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_maxLength_e_maxLength_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_maxLength_e_maxLength_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_UplinkConfig_maxLength_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID0_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID1_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e__ToString(SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e v)
{
	switch(v) {
		case SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_enabled: return "SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_dmrs_Uplink_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_dmrs_Uplink_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled* p)
{
	adbgPrintLog(_ctx, "scramblingID0 := ");
	_adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID0_Optional(_ctx, &p->scramblingID0);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scramblingID1 := ");
	_adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID1_Optional(_ctx, &p->scramblingID1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_Uplink_r16 := ");
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_dmrs_Uplink_r16_Optional(_ctx, &p->dmrs_Uplink_r16);
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_transformPrecodingDisabled_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_transformPrecodingDisabled_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled(_ctx, &p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_nPUSCH_Identity_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_nPUSCH_Identity_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e__ToString(SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e v)
{
	switch(v) {
		case SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_disabled: return "SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_disabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_sequenceGroupHopping_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_sequenceGroupHopping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e__ToString(SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e v)
{
	switch(v) {
		case SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_enabled: return "SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_sequenceHopping_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_sequenceHopping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID0_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID1_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkTransformPrecoding_r16(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkTransformPrecoding_r16* p)
{
	adbgPrintLog(_ctx, "pi2BPSK_ScramblingID0 := ");
	_adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID0_Optional(_ctx, &p->pi2BPSK_ScramblingID0);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pi2BPSK_ScramblingID1 := ");
	_adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID1_Optional(_ctx, &p->pi2BPSK_ScramblingID1);
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Value* p, enum SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_UplinkTransformPrecoding_r16(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled* p)
{
	adbgPrintLog(_ctx, "nPUSCH_Identity := ");
	_adbgNrSys__Uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_nPUSCH_Identity_Optional(_ctx, &p->nPUSCH_Identity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sequenceGroupHopping := ");
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_sequenceGroupHopping_Optional(_ctx, &p->sequenceGroupHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sequenceHopping := ");
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_sequenceHopping_Optional(_ctx, &p->sequenceHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_UplinkTransformPrecoding_r16 := ");
	if (p->dmrs_UplinkTransformPrecoding_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Optional(_ctx, &p->dmrs_UplinkTransformPrecoding_r16);
	if (p->dmrs_UplinkTransformPrecoding_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_transformPrecodingEnabled_Optional(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_transformPrecodingEnabled_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_DMRS_UplinkConfig(acpCtx_t _ctx, const struct SQN_NR_DMRS_UplinkConfig* p)
{
	adbgPrintLog(_ctx, "dmrs_Type := ");
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_Type_e_dmrs_Type_Optional(_ctx, &p->dmrs_Type);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_AdditionalPosition := ");
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(_ctx, &p->dmrs_AdditionalPosition);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "phaseTrackingRS := ");
	if (p->phaseTrackingRS.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_SQN_NR_DMRS_UplinkConfig_phaseTrackingRS_Optional(_ctx, &p->phaseTrackingRS);
	if (p->phaseTrackingRS.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxLength := ");
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_maxLength_e_maxLength_Optional(_ctx, &p->maxLength);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transformPrecodingDisabled := ");
	if (p->transformPrecodingDisabled.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_transformPrecodingDisabled_Optional(_ctx, &p->transformPrecodingDisabled);
	if (p->transformPrecodingDisabled.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transformPrecodingEnabled := ");
	if (p->transformPrecodingEnabled.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_transformPrecodingEnabled_Optional(_ctx, &p->transformPrecodingEnabled);
	if (p->transformPrecodingEnabled.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_UplinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_UplinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e__ToString(SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_disabled: return "SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_disabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_tpc_Accumulation_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_tpc_Accumulation_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_Alpha_e__ToString(SQN_NR_Alpha_e v)
{
	switch(v) {
		case SQN_NR_Alpha_e_alpha0: return "SQN_NR_Alpha_e_alpha0";
		case SQN_NR_Alpha_e_alpha04: return "SQN_NR_Alpha_e_alpha04";
		case SQN_NR_Alpha_e_alpha05: return "SQN_NR_Alpha_e_alpha05";
		case SQN_NR_Alpha_e_alpha06: return "SQN_NR_Alpha_e_alpha06";
		case SQN_NR_Alpha_e_alpha07: return "SQN_NR_Alpha_e_alpha07";
		case SQN_NR_Alpha_e_alpha08: return "SQN_NR_Alpha_e_alpha08";
		case SQN_NR_Alpha_e_alpha09: return "SQN_NR_Alpha_e_alpha09";
		case SQN_NR_Alpha_e_alpha1: return "SQN_NR_Alpha_e_alpha1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_Alpha_e_SQN_NR_PUSCH_PowerControl_msg3_Alpha_Optional(acpCtx_t _ctx, const struct SQN_NR_Alpha_e_SQN_NR_PUSCH_PowerControl_msg3_Alpha_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_Alpha_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Int16_t_SQN_NR_PUSCH_PowerControl_p0_NominalWithoutGrant_Optional(acpCtx_t _ctx, const struct int16_t_SQN_NR_PUSCH_PowerControl_p0_NominalWithoutGrant_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_P0_PUSCH_AlphaSet_p0_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_P0_PUSCH_AlphaSet_p0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_Alpha_e_SQN_NR_P0_PUSCH_AlphaSet_alpha_Optional(acpCtx_t _ctx, const struct SQN_NR_Alpha_e_SQN_NR_P0_PUSCH_AlphaSet_alpha_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_Alpha_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_P0_PUSCH_AlphaSet(acpCtx_t _ctx, const struct SQN_NR_P0_PUSCH_AlphaSet* p)
{
	adbgPrintLog(_ctx, "p0_PUSCH_AlphaSetId := %u", (unsigned int)p->p0_PUSCH_AlphaSetId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0 := ");
	_adbgNrSys__Int8_t_SQN_NR_P0_PUSCH_AlphaSet_p0_Optional(_ctx, &p->p0);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "alpha := ");
	_adbgNrSys__SQN_NR_Alpha_e_SQN_NR_P0_PUSCH_AlphaSet_alpha_Optional(_ctx, &p->alpha);
}

static void _adbgNrSys__SQN_NR_P0_PUSCH_AlphaSet_SQN_NR_PUSCH_PowerControl_p0_AlphaSets_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_P0_PUSCH_AlphaSet_SQN_NR_PUSCH_PowerControl_p0_AlphaSets_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_P0_PUSCH_AlphaSet(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Value(acpCtx_t _ctx, const union SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Value* p, enum SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Sel d)
{
	if (d == SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_ssb_Index) {
		adbgPrintLog(_ctx, "ssb_Index := %u", (unsigned int)p->ssb_Index);
		return;
	}
	if (d == SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_csi_RS_Index) {
		adbgPrintLog(_ctx, "csi_RS_Index := %u", (unsigned int)p->csi_RS_Index);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal* p)
{
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS* p)
{
	adbgPrintLog(_ctx, "pusch_PathlossReferenceRS_Id := %u", (unsigned int)p->pusch_PathlossReferenceRS_Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal := { ");
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal(_ctx, &p->referenceSignal);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_Id_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS_Id_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e__ToString(SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoStates: return "SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoStates";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoPUSCH_PC_AdjustmentStates_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoPUSCH_PC_AdjustmentStates_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_PowerControl_deltaMCS_e__ToString(SQN_NR_PUSCH_PowerControl_deltaMCS_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_PowerControl_deltaMCS_e_enabled: return "SQN_NR_PUSCH_PowerControl_deltaMCS_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl_deltaMCS_e_deltaMCS_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl_deltaMCS_e_deltaMCS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_PowerControl_deltaMCS_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SRI_PUSCH_PowerControl_sri_PUSCH_ClosedLoopIndex_e__ToString(SQN_NR_SRI_PUSCH_PowerControl_sri_PUSCH_ClosedLoopIndex_e v)
{
	switch(v) {
		case SQN_NR_SRI_PUSCH_PowerControl_sri_PUSCH_ClosedLoopIndex_e_i0: return "SQN_NR_SRI_PUSCH_PowerControl_sri_PUSCH_ClosedLoopIndex_e_i0";
		case SQN_NR_SRI_PUSCH_PowerControl_sri_PUSCH_ClosedLoopIndex_e_i1: return "SQN_NR_SRI_PUSCH_PowerControl_sri_PUSCH_ClosedLoopIndex_e_i1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRI_PUSCH_PowerControl(acpCtx_t _ctx, const struct SQN_NR_SRI_PUSCH_PowerControl* p)
{
	adbgPrintLog(_ctx, "sri_PUSCH_PowerControlId := %u", (unsigned int)p->sri_PUSCH_PowerControlId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sri_PUSCH_PathlossReferenceRS_Id := %u", (unsigned int)p->sri_PUSCH_PathlossReferenceRS_Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sri_P0_PUSCH_AlphaSetId := %u", (unsigned int)p->sri_P0_PUSCH_AlphaSetId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sri_PUSCH_ClosedLoopIndex := %s (%d)", adbgNrSys__SQN_NR_SRI_PUSCH_PowerControl_sri_PUSCH_ClosedLoopIndex_e__ToString(p->sri_PUSCH_ClosedLoopIndex), (int)p->sri_PUSCH_ClosedLoopIndex);
}

static void _adbgNrSys__SQN_NR_SRI_PUSCH_PowerControl_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRI_PUSCH_PowerControl_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SRI_PUSCH_PowerControl(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SRI_PUSCH_PowerControlId_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRI_PUSCH_PowerControlId_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl* p)
{
	adbgPrintLog(_ctx, "tpc_Accumulation := ");
	_adbgNrSys__SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_tpc_Accumulation_Optional(_ctx, &p->tpc_Accumulation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msg3_Alpha := ");
	_adbgNrSys__SQN_NR_Alpha_e_SQN_NR_PUSCH_PowerControl_msg3_Alpha_Optional(_ctx, &p->msg3_Alpha);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_NominalWithoutGrant := ");
	_adbgNrSys__Int16_t_SQN_NR_PUSCH_PowerControl_p0_NominalWithoutGrant_Optional(_ctx, &p->p0_NominalWithoutGrant);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_AlphaSets := ");
	if (p->p0_AlphaSets.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_P0_PUSCH_AlphaSet_SQN_NR_PUSCH_PowerControl_p0_AlphaSets_DynamicOptional(_ctx, &p->p0_AlphaSets);
	if (p->p0_AlphaSets.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRSToAddModList := ");
	if (p->pathlossReferenceRSToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToAddModList_DynamicOptional(_ctx, &p->pathlossReferenceRSToAddModList);
	if (p->pathlossReferenceRSToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRSToReleaseList := ");
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_Id_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToReleaseList_DynamicOptional(_ctx, &p->pathlossReferenceRSToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "twoPUSCH_PC_AdjustmentStates := ");
	_adbgNrSys__SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoPUSCH_PC_AdjustmentStates_Optional(_ctx, &p->twoPUSCH_PC_AdjustmentStates);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deltaMCS := ");
	_adbgNrSys__SQN_NR_PUSCH_PowerControl_deltaMCS_e_deltaMCS_Optional(_ctx, &p->deltaMCS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sri_PUSCH_MappingToAddModList := ");
	if (p->sri_PUSCH_MappingToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRI_PUSCH_PowerControl_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToAddModList_DynamicOptional(_ctx, &p->sri_PUSCH_MappingToAddModList);
	if (p->sri_PUSCH_MappingToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sri_PUSCH_MappingToReleaseList := ");
	_adbgNrSys__SQN_NR_SRI_PUSCH_PowerControlId_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToReleaseList_DynamicOptional(_ctx, &p->sri_PUSCH_MappingToReleaseList);
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl_SQN_NR_PUSCH_Config_pusch_PowerControl_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl_SQN_NR_PUSCH_Config_pusch_PowerControl_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PUSCH_PowerControl(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_frequencyHopping_e__ToString(SQN_NR_PUSCH_Config_frequencyHopping_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_frequencyHopping_e_intraSlot: return "SQN_NR_PUSCH_Config_frequencyHopping_e_intraSlot";
		case SQN_NR_PUSCH_Config_frequencyHopping_e_interSlot: return "SQN_NR_PUSCH_Config_frequencyHopping_e_interSlot";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_frequencyHopping_e_frequencyHopping_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_frequencyHopping_e_frequencyHopping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_frequencyHopping_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_PUSCH_Config_frequencyHoppingOffsetLists_DynamicOptional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_PUSCH_Config_frequencyHoppingOffsetLists_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocation_e__ToString(SQN_NR_PUSCH_Config_resourceAllocation_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_resourceAllocation_e_resourceAllocationType0: return "SQN_NR_PUSCH_Config_resourceAllocation_e_resourceAllocationType0";
		case SQN_NR_PUSCH_Config_resourceAllocation_e_resourceAllocationType1: return "SQN_NR_PUSCH_Config_resourceAllocation_e_resourceAllocationType1";
		case SQN_NR_PUSCH_Config_resourceAllocation_e_dynamicSwitch: return "SQN_NR_PUSCH_Config_resourceAllocation_e_dynamicSwitch";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationList_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_pusch_AggregationFactor_e__ToString(SQN_NR_PUSCH_Config_pusch_AggregationFactor_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_n2: return "SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_n2";
		case SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_n4: return "SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_n4";
		case SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_n8: return "SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_pusch_AggregationFactor_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_pusch_AggregationFactor_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_pusch_AggregationFactor_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_mcs_Table_e__ToString(SQN_NR_PUSCH_Config_mcs_Table_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_mcs_Table_e_qam256: return "SQN_NR_PUSCH_Config_mcs_Table_e_qam256";
		case SQN_NR_PUSCH_Config_mcs_Table_e_qam64LowSE: return "SQN_NR_PUSCH_Config_mcs_Table_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_mcs_Table_e_mcs_Table_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_mcs_Table_e_mcs_Table_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_mcs_Table_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e__ToString(SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_qam256: return "SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_qam256";
		case SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_qam64LowSE: return "SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_transformPrecoder_e__ToString(SQN_NR_PUSCH_Config_transformPrecoder_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_transformPrecoder_e_enabled: return "SQN_NR_PUSCH_Config_transformPrecoder_e_enabled";
		case SQN_NR_PUSCH_Config_transformPrecoder_e_disabled: return "SQN_NR_PUSCH_Config_transformPrecoder_e_disabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_transformPrecoder_e_transformPrecoder_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_transformPrecoder_e_transformPrecoder_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_transformPrecoder_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_codebookSubset_e__ToString(SQN_NR_PUSCH_Config_codebookSubset_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_codebookSubset_e_fullyAndPartialAndNonCoherent: return "SQN_NR_PUSCH_Config_codebookSubset_e_fullyAndPartialAndNonCoherent";
		case SQN_NR_PUSCH_Config_codebookSubset_e_partialAndNonCoherent: return "SQN_NR_PUSCH_Config_codebookSubset_e_partialAndNonCoherent";
		case SQN_NR_PUSCH_Config_codebookSubset_e_nonCoherent: return "SQN_NR_PUSCH_Config_codebookSubset_e_nonCoherent";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_codebookSubset_e_codebookSubset_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_codebookSubset_e_codebookSubset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_codebookSubset_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_maxRank_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Config_maxRank_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_rbg_Size_e__ToString(SQN_NR_PUSCH_Config_rbg_Size_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_rbg_Size_e_config2: return "SQN_NR_PUSCH_Config_rbg_Size_e_config2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_rbg_Size_e_rbg_Size_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_rbg_Size_e_rbg_Size_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_rbg_Size_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index1_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index2_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index3_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index3_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index1_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index2_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index1_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index1_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index2_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_BetaOffsets(acpCtx_t _ctx, const struct SQN_NR_BetaOffsets* p)
{
	adbgPrintLog(_ctx, "betaOffsetACK_Index1 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index1_Optional(_ctx, &p->betaOffsetACK_Index1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "betaOffsetACK_Index2 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index2_Optional(_ctx, &p->betaOffsetACK_Index2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "betaOffsetACK_Index3 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index3_Optional(_ctx, &p->betaOffsetACK_Index3);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "betaOffsetCSI_Part1_Index1 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index1_Optional(_ctx, &p->betaOffsetCSI_Part1_Index1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "betaOffsetCSI_Part1_Index2 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index2_Optional(_ctx, &p->betaOffsetCSI_Part1_Index2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "betaOffsetCSI_Part2_Index1 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index1_Optional(_ctx, &p->betaOffsetCSI_Part2_Index1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "betaOffsetCSI_Part2_Index2 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index2_Optional(_ctx, &p->betaOffsetCSI_Part2_Index2);
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_betaOffsets_Value(acpCtx_t _ctx, const union SQN_NR_UCI_OnPUSCH_betaOffsets_Value* p, enum SQN_NR_UCI_OnPUSCH_betaOffsets_Sel d)
{
	if (d == SQN_NR_UCI_OnPUSCH_betaOffsets_dynamic) {
		adbgPrintLog(_ctx, "dynamic := { ");
		for (size_t i2 = 0; i2 < 4; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_BetaOffsets(_ctx, &p->dynamic[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != 4 - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_UCI_OnPUSCH_betaOffsets_semiStatic) {
		adbgPrintLog(_ctx, "semiStatic := { ");
		_adbgNrSys__SQN_NR_BetaOffsets(_ctx, &p->semiStatic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_betaOffsets(acpCtx_t _ctx, const struct SQN_NR_UCI_OnPUSCH_betaOffsets* p)
{
	_adbgNrSys__SQN_NR_UCI_OnPUSCH_betaOffsets_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_betaOffsets_betaOffsets_Optional(acpCtx_t _ctx, const struct SQN_NR_UCI_OnPUSCH_betaOffsets_betaOffsets_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_UCI_OnPUSCH_betaOffsets(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_UCI_OnPUSCH_scaling_e__ToString(SQN_NR_UCI_OnPUSCH_scaling_e v)
{
	switch(v) {
		case SQN_NR_UCI_OnPUSCH_scaling_e_f0p5: return "SQN_NR_UCI_OnPUSCH_scaling_e_f0p5";
		case SQN_NR_UCI_OnPUSCH_scaling_e_f0p65: return "SQN_NR_UCI_OnPUSCH_scaling_e_f0p65";
		case SQN_NR_UCI_OnPUSCH_scaling_e_f0p8: return "SQN_NR_UCI_OnPUSCH_scaling_e_f0p8";
		case SQN_NR_UCI_OnPUSCH_scaling_e_f1: return "SQN_NR_UCI_OnPUSCH_scaling_e_f1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH(acpCtx_t _ctx, const struct SQN_NR_UCI_OnPUSCH* p)
{
	adbgPrintLog(_ctx, "betaOffsets := ");
	if (p->betaOffsets.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_UCI_OnPUSCH_betaOffsets_betaOffsets_Optional(_ctx, &p->betaOffsets);
	if (p->betaOffsets.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scaling := %s (%d)", adbgNrSys__SQN_NR_UCI_OnPUSCH_scaling_e__ToString(p->scaling), (int)p->scaling);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_UCI_OnPUSCH(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_SQN_NR_PUSCH_Config_uci_OnPUSCH_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_SQN_NR_PUSCH_Config_uci_OnPUSCH_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_tp_pi2BPSK_e__ToString(SQN_NR_PUSCH_Config_tp_pi2BPSK_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_tp_pi2BPSK_e_enabled: return "SQN_NR_PUSCH_Config_tp_pi2BPSK_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_tp_pi2BPSK_e_tp_pi2BPSK_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_tp_pi2BPSK_e_tp_pi2BPSK_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_tp_pi2BPSK_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_setup) {
		adbgPrintLog(_ctx, "setup := '");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "%02X", p->setup.v[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_SQN_NR_PUSCH_Config_minimumSchedulingOffsetK2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_SQN_NR_PUSCH_Config_minimumSchedulingOffsetK2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_setup) {
		adbgPrintLog(_ctx, "setup := '");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "%02X", p->setup.v[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_SQN_NR_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_SQN_NR_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_harq_ProcessNumberSizeDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Config_harq_ProcessNumberSizeDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_enabled: return "SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_dmrs_SequenceInitializationDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_dmrs_SequenceInitializationDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_numberOfBitsForRV_DCI_0_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Config_numberOfBitsForRV_DCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_enabled: return "SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_antennaPortsFieldPresenceDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_antennaPortsFieldPresenceDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_UplinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_DMRS_UplinkConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA_e__ToString(SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA_e_intraSlot: return "SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA_e_intraSlot";
		case SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA_e_interSlot: return "SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA_e_interSlot";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB_e__ToString(SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB_e_interRepetition: return "SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB_e_interRepetition";
		case SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB_e_interSlot: return "SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB_e_interSlot";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Value* p, enum SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA) {
		adbgPrintLog(_ctx, "pusch_RepTypeA := %s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA_e__ToString(p->pusch_RepTypeA), (int)p->pusch_RepTypeA);
		return;
	}
	if (d == SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB) {
		adbgPrintLog(_ctx, "pusch_RepTypeB := %s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB_e__ToString(p->pusch_RepTypeB), (int)p->pusch_RepTypeB);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_frequencyHoppingDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_frequencyHoppingDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := '");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "%02X", p->setup.v[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_SQN_NR_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_SQN_NR_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_fullyAndPartialAndNonCoherent: return "SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_fullyAndPartialAndNonCoherent";
		case SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_partialAndNonCoherent: return "SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_partialAndNonCoherent";
		case SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_nonCoherent: return "SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_nonCoherent";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_codebookSubsetDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_codebookSubsetDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_enabled: return "SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_invalidSymbolPatternIndicatorDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_invalidSymbolPatternIndicatorDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_maxRankDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Config_maxRankDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_qam256: return "SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_qam256";
		case SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_qam64LowSE: return "SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_mcs_TableDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_mcs_TableDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_qam256: return "SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_qam256";
		case SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_qam64LowSE: return "SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_mcs_TableTransformPrecoderDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_mcs_TableTransformPrecoderDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_enabled: return "SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_priorityIndicatorDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_priorityIndicatorDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeA: return "SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeA";
		case SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeB: return "SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeIndicatorDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeIndicatorDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationType0: return "SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationType0";
		case SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationType1: return "SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationType1";
		case SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_dynamicSwitch: return "SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_dynamicSwitch";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e__ToString(SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n2: return "SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n2";
		case SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n4: return "SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n4";
		case SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n8: return "SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n8";
		case SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n16: return "SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_n16";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_resourceAllocationType1GranularityDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_resourceAllocationType1GranularityDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Value* p, enum SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_oneBit_r16) {
		adbgPrintLog(_ctx, "oneBit_r16 := { ");
		for (size_t i3 = 0; i3 < 2; i3++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_BetaOffsets(_ctx, &p->oneBit_r16[i3]);
			adbgPrintLog(_ctx, " }");
			if (i3 != 2 - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_twoBits_r16) {
		adbgPrintLog(_ctx, "twoBits_r16 := { ");
		for (size_t i3 = 0; i3 < 4; i3++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_BetaOffsets(_ctx, &p->twoBits_r16[i3]);
			adbgPrintLog(_ctx, " }");
			if (i3 != 4 - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Value* p, enum SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16) {
		adbgPrintLog(_ctx, "dynamicDCI_0_2_r16 := { ");
		_adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16(_ctx, &p->dynamicDCI_0_2_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_semiStaticDCI_0_2_r16) {
		adbgPrintLog(_ctx, "semiStaticDCI_0_2_r16 := { ");
		_adbgNrSys__SQN_NR_BetaOffsets(_ctx, &p->semiStaticDCI_0_2_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_betaOffsetsDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_betaOffsetsDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e__ToString(SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e v)
{
	switch(v) {
		case SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f0p5: return "SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f0p5";
		case SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f0p65: return "SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f0p65";
		case SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f0p8: return "SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f0p8";
		case SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f1: return "SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e_f1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16* p)
{
	adbgPrintLog(_ctx, "betaOffsetsDCI_0_2_r16 := ");
	if (p->betaOffsetsDCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_betaOffsetsDCI_0_2_r16_Optional(_ctx, &p->betaOffsetsDCI_0_2_r16);
	if (p->betaOffsetsDCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "scalingDCI_0_2_r16 := %s (%d)", adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_scalingDCI_0_2_r16_e__ToString(p->scalingDCI_0_2_r16), (int)p->scalingDCI_0_2_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_UCI_OnPUSCH_DCI_0_2_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_r16_k2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_r16_k2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e__ToString(SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_typeA: return "SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_typeA";
		case SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_typeB: return "SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_typeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_mappingType_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_mappingType_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbolAndLength_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbolAndLength_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbol_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbol_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Allocation_r16_length_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Allocation_r16_length_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e__ToString(SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n1: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n1";
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n2: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n2";
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n3: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n3";
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n4: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n4";
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n7: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n7";
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n8: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n8";
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n12: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n12";
		case SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n16: return "SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_n16";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_numberOfRepetitions_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_numberOfRepetitions_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PUSCH_Allocation_r16(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Allocation_r16* p)
{
	adbgPrintLog(_ctx, "mappingType_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_mappingType_r16_Optional(_ctx, &p->mappingType_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbolAndLength_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbolAndLength_r16_Optional(_ctx, &p->startSymbolAndLength_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startSymbol_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbol_r16_Optional(_ctx, &p->startSymbol_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "length_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Allocation_r16_length_r16_Optional(_ctx, &p->length_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberOfRepetitions_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_numberOfRepetitions_r16_Optional(_ctx, &p->numberOfRepetitions_r16);
}

static void _adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation_r16(acpCtx_t _ctx, const struct SQN_NR_PUSCH_TimeDomainResourceAllocation_r16* p)
{
	adbgPrintLog(_ctx, "k2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_r16_k2_r16_Optional(_ctx, &p->k2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "puschAllocationList_r16 := { ");
	for (size_t i3 = 0; i3 < p->puschAllocationList_r16.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUSCH_Allocation_r16(_ctx, &p->puschAllocationList_r16.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->puschAllocationList_r16.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e__ToString(SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_enabled: return "SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_invalidSymbolPatternIndicatorDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_invalidSymbolPatternIndicatorDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e__ToString(SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_enabled: return "SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_priorityIndicatorDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_priorityIndicatorDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e__ToString(SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeA: return "SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeA";
		case SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeB: return "SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeIndicatorDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeIndicatorDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e__ToString(SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_interRepetition: return "SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_interRepetition";
		case SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_interSlot: return "SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_interSlot";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_frequencyHoppingDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_frequencyHoppingDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_UCI_OnPUSCH(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_symbols_r16_Value(acpCtx_t _ctx, const union SQN_NR_InvalidSymbolPattern_r16_symbols_r16_Value* p, enum SQN_NR_InvalidSymbolPattern_r16_symbols_r16_Sel d)
{
	if (d == SQN_NR_InvalidSymbolPattern_r16_symbols_r16_oneSlot) {
		adbgPrintLog(_ctx, "oneSlot := '");
		for (size_t i2 = 0; i2 < 14; i2++) {
			adbgPrintLog(_ctx, "%02X", p->oneSlot[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_symbols_r16_twoSlots) {
		adbgPrintLog(_ctx, "twoSlots := '");
		for (size_t i2 = 0; i2 < 28; i2++) {
			adbgPrintLog(_ctx, "%02X", p->twoSlots[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_symbols_r16(acpCtx_t _ctx, const struct SQN_NR_InvalidSymbolPattern_r16_symbols_r16* p)
{
	_adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_symbols_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Value(acpCtx_t _ctx, const union SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Value* p, enum SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Sel d)
{
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n2) {
		adbgPrintLog(_ctx, "n2 := '");
		for (size_t i2 = 0; i2 < 2; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n2[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n4) {
		adbgPrintLog(_ctx, "n4 := '");
		for (size_t i2 = 0; i2 < 4; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n4[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n5) {
		adbgPrintLog(_ctx, "n5 := '");
		for (size_t i2 = 0; i2 < 5; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n5[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n8) {
		adbgPrintLog(_ctx, "n8 := '");
		for (size_t i2 = 0; i2 < 8; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n8[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n10) {
		adbgPrintLog(_ctx, "n10 := '");
		for (size_t i2 = 0; i2 < 10; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n10[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n20) {
		adbgPrintLog(_ctx, "n20 := '");
		for (size_t i2 = 0; i2 < 20; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n20[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n40) {
		adbgPrintLog(_ctx, "n40 := '");
		for (size_t i2 = 0; i2 < 40; i2++) {
			adbgPrintLog(_ctx, "%02X", p->n40[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16(acpCtx_t _ctx, const struct SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16* p)
{
	_adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_periodicityAndPattern_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_periodicityAndPattern_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_InvalidSymbolPattern_r16(acpCtx_t _ctx, const struct SQN_NR_InvalidSymbolPattern_r16* p)
{
	adbgPrintLog(_ctx, "symbols_r16 := { ");
	_adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_symbols_r16(_ctx, &p->symbols_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicityAndPattern_r16 := ");
	if (p->periodicityAndPattern_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_periodicityAndPattern_r16_Optional(_ctx, &p->periodicityAndPattern_r16);
	if (p->periodicityAndPattern_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_SQN_NR_PUSCH_Config_invalidSymbolPattern_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_InvalidSymbolPattern_r16_SQN_NR_PUSCH_Config_invalidSymbolPattern_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_InvalidSymbolPattern_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(acpCtx_t _ctx, const union SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Value* p, enum SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Sel d)
{
	if (d == SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_ssb_Index_r16) {
		adbgPrintLog(_ctx, "ssb_Index_r16 := %u", (unsigned int)p->ssb_Index_r16);
		return;
	}
	if (d == SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_csi_RS_Index_r16) {
		adbgPrintLog(_ctx, "csi_RS_Index_r16 := %u", (unsigned int)p->csi_RS_Index_r16);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16* p)
{
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS_r16* p)
{
	adbgPrintLog(_ctx, "pusch_PathlossReferenceRS_Id_r16 := %u", (unsigned int)p->pusch_PathlossReferenceRS_Id_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal_r16 := { ");
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16(_ctx, &p->referenceSignal_r16);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToAddModList2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS_r16_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToAddModList2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToReleaseList2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToReleaseList2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_P0_PUSCH_r16_SQN_NR_P0_PUSCH_Set_r16_p0_List_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_P0_PUSCH_r16_SQN_NR_P0_PUSCH_Set_r16_p0_List_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_P0_PUSCH_Set_r16(acpCtx_t _ctx, const struct SQN_NR_P0_PUSCH_Set_r16* p)
{
	adbgPrintLog(_ctx, "p0_PUSCH_SetId_r16 := %u", (unsigned int)p->p0_PUSCH_SetId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_List_r16 := ");
	_adbgNrSys__SQN_NR_P0_PUSCH_r16_SQN_NR_P0_PUSCH_Set_r16_p0_List_r16_DynamicOptional(_ctx, &p->p0_List_r16);
}

static void _adbgNrSys__SQN_NR_P0_PUSCH_Set_r16_SQN_NR_PUSCH_PowerControl_v1610_p0_PUSCH_SetList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_P0_PUSCH_Set_r16_SQN_NR_PUSCH_PowerControl_v1610_p0_PUSCH_SetList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_P0_PUSCH_Set_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_1_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_1_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet* p)
{
	adbgPrintLog(_ctx, "olpc_ParameterSetDCI_0_1_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_1_r16_Optional(_ctx, &p->olpc_ParameterSetDCI_0_1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "olpc_ParameterSetDCI_0_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_2_r16_Optional(_ctx, &p->olpc_ParameterSetDCI_0_2_r16);
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSet_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSet_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PUSCH_PowerControl_v1610(acpCtx_t _ctx, const struct SQN_NR_PUSCH_PowerControl_v1610* p)
{
	adbgPrintLog(_ctx, "pathlossReferenceRSToAddModList2_r16 := ");
	if (p->pathlossReferenceRSToAddModList2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_r16_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToAddModList2_r16_DynamicOptional(_ctx, &p->pathlossReferenceRSToAddModList2_r16);
	if (p->pathlossReferenceRSToAddModList2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRSToReleaseList2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToReleaseList2_r16_DynamicOptional(_ctx, &p->pathlossReferenceRSToReleaseList2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_PUSCH_SetList_r16 := ");
	if (p->p0_PUSCH_SetList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_P0_PUSCH_Set_r16_SQN_NR_PUSCH_PowerControl_v1610_p0_PUSCH_SetList_r16_DynamicOptional(_ctx, &p->p0_PUSCH_SetList_r16);
	if (p->p0_PUSCH_SetList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "olpc_ParameterSet := ");
	if (p->olpc_ParameterSet.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSet_Optional(_ctx, &p->olpc_ParameterSet);
	if (p->olpc_ParameterSet.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUSCH_PowerControl_v1610(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_SQN_NR_PUSCH_Config_pusch_PowerControl_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_SQN_NR_PUSCH_Config_pusch_PowerControl_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e__ToString(SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_fullpower: return "SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_fullpower";
		case SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_fullpowerMode1: return "SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_fullpowerMode1";
		case SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_fullpoweMode2: return "SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_fullpoweMode2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_ul_FullPowerTransmission_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_ul_FullPowerTransmission_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PUSCH_TimeDomainResourceAllocation_r16(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_numberOfInvalidSymbolsForDL_UL_Switching_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_Config_numberOfInvalidSymbolsForDL_UL_Switching_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_PUSCH_Config(acpCtx_t _ctx, const struct SQN_NR_PUSCH_Config* p)
{
	adbgPrintLog(_ctx, "dataScramblingIdentityPUSCH := ");
	_adbgNrSys__Uint16_t_SQN_NR_PUSCH_Config_dataScramblingIdentityPUSCH_Optional(_ctx, &p->dataScramblingIdentityPUSCH);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "txConfig := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_txConfig_e_txConfig_Optional(_ctx, &p->txConfig);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_UplinkForPUSCH_MappingTypeA := ");
	if (p->dmrs_UplinkForPUSCH_MappingTypeA.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Optional(_ctx, &p->dmrs_UplinkForPUSCH_MappingTypeA);
	if (p->dmrs_UplinkForPUSCH_MappingTypeA.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_UplinkForPUSCH_MappingTypeB := ");
	if (p->dmrs_UplinkForPUSCH_MappingTypeB.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Optional(_ctx, &p->dmrs_UplinkForPUSCH_MappingTypeB);
	if (p->dmrs_UplinkForPUSCH_MappingTypeB.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_PowerControl := ");
	if (p->pusch_PowerControl.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUSCH_PowerControl_SQN_NR_PUSCH_Config_pusch_PowerControl_Optional(_ctx, &p->pusch_PowerControl);
	if (p->pusch_PowerControl.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyHopping := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_frequencyHopping_e_frequencyHopping_Optional(_ctx, &p->frequencyHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyHoppingOffsetLists := ");
	_adbgNrSys__Uint16_t_SQN_NR_PUSCH_Config_frequencyHoppingOffsetLists_DynamicOptional(_ctx, &p->frequencyHoppingOffsetLists);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceAllocation := %s (%d)", adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocation_e__ToString(p->resourceAllocation), (int)p->resourceAllocation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_TimeDomainAllocationList := ");
	if (p->pusch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationList_Optional(_ctx, &p->pusch_TimeDomainAllocationList);
	if (p->pusch_TimeDomainAllocationList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_AggregationFactor := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_pusch_AggregationFactor_Optional(_ctx, &p->pusch_AggregationFactor);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_Table := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_mcs_Table_e_mcs_Table_Optional(_ctx, &p->mcs_Table);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_TableTransformPrecoder := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(_ctx, &p->mcs_TableTransformPrecoder);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transformPrecoder := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_transformPrecoder_e_transformPrecoder_Optional(_ctx, &p->transformPrecoder);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "codebookSubset := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_codebookSubset_e_codebookSubset_Optional(_ctx, &p->codebookSubset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxRank := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_maxRank_Optional(_ctx, &p->maxRank);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rbg_Size := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_rbg_Size_e_rbg_Size_Optional(_ctx, &p->rbg_Size);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uci_OnPUSCH := ");
	if (p->uci_OnPUSCH.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_SQN_NR_PUSCH_Config_uci_OnPUSCH_Optional(_ctx, &p->uci_OnPUSCH);
	if (p->uci_OnPUSCH.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tp_pi2BPSK := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_tp_pi2BPSK_e_tp_pi2BPSK_Optional(_ctx, &p->tp_pi2BPSK);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "minimumSchedulingOffsetK2_r16 := ");
	if (p->minimumSchedulingOffsetK2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_SQN_NR_PUSCH_Config_minimumSchedulingOffsetK2_r16_Optional(_ctx, &p->minimumSchedulingOffsetK2_r16);
	if (p->minimumSchedulingOffsetK2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ul_AccessConfigListDCI_0_1_r16 := ");
	if (p->ul_AccessConfigListDCI_0_1_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_SQN_NR_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Optional(_ctx, &p->ul_AccessConfigListDCI_0_1_r16);
	if (p->ul_AccessConfigListDCI_0_1_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "harq_ProcessNumberSizeDCI_0_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_harq_ProcessNumberSizeDCI_0_2_r16_Optional(_ctx, &p->harq_ProcessNumberSizeDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_SequenceInitializationDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_dmrs_SequenceInitializationDCI_0_2_r16_Optional(_ctx, &p->dmrs_SequenceInitializationDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberOfBitsForRV_DCI_0_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_numberOfBitsForRV_DCI_0_2_r16_Optional(_ctx, &p->numberOfBitsForRV_DCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "antennaPortsFieldPresenceDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_antennaPortsFieldPresenceDCI_0_2_r16_Optional(_ctx, &p->antennaPortsFieldPresenceDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16 := ");
	if (p->dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Optional(_ctx, &p->dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16);
	if (p->dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16 := ");
	if (p->dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Optional(_ctx, &p->dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16);
	if (p->dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyHoppingDCI_0_2_r16 := ");
	if (p->frequencyHoppingDCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_frequencyHoppingDCI_0_2_r16_Optional(_ctx, &p->frequencyHoppingDCI_0_2_r16);
	if (p->frequencyHoppingDCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyHoppingOffsetListsDCI_0_2_r16 := ");
	if (p->frequencyHoppingOffsetListsDCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_SQN_NR_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Optional(_ctx, &p->frequencyHoppingOffsetListsDCI_0_2_r16);
	if (p->frequencyHoppingOffsetListsDCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "codebookSubsetDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_codebookSubsetDCI_0_2_r16_Optional(_ctx, &p->codebookSubsetDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "invalidSymbolPatternIndicatorDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_invalidSymbolPatternIndicatorDCI_0_2_r16_Optional(_ctx, &p->invalidSymbolPatternIndicatorDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxRankDCI_0_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_maxRankDCI_0_2_r16_Optional(_ctx, &p->maxRankDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_TableDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_mcs_TableDCI_0_2_r16_Optional(_ctx, &p->mcs_TableDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_TableTransformPrecoderDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_mcs_TableTransformPrecoderDCI_0_2_r16_Optional(_ctx, &p->mcs_TableTransformPrecoderDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "priorityIndicatorDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_priorityIndicatorDCI_0_2_r16_Optional(_ctx, &p->priorityIndicatorDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_RepTypeIndicatorDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeIndicatorDCI_0_2_r16_Optional(_ctx, &p->pusch_RepTypeIndicatorDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceAllocationDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationDCI_0_2_r16_Optional(_ctx, &p->resourceAllocationDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceAllocationType1GranularityDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_resourceAllocationType1GranularityDCI_0_2_r16_Optional(_ctx, &p->resourceAllocationType1GranularityDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uci_OnPUSCH_ListDCI_0_2_r16 := ");
	if (p->uci_OnPUSCH_ListDCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Optional(_ctx, &p->uci_OnPUSCH_ListDCI_0_2_r16);
	if (p->uci_OnPUSCH_ListDCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_TimeDomainAllocationListDCI_0_2_r16 := ");
	if (p->pusch_TimeDomainAllocationListDCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Optional(_ctx, &p->pusch_TimeDomainAllocationListDCI_0_2_r16);
	if (p->pusch_TimeDomainAllocationListDCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_TimeDomainAllocationListDCI_0_1_r16 := ");
	if (p->pusch_TimeDomainAllocationListDCI_0_1_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Optional(_ctx, &p->pusch_TimeDomainAllocationListDCI_0_1_r16);
	if (p->pusch_TimeDomainAllocationListDCI_0_1_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "invalidSymbolPatternIndicatorDCI_0_1_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_invalidSymbolPatternIndicatorDCI_0_1_r16_Optional(_ctx, &p->invalidSymbolPatternIndicatorDCI_0_1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "priorityIndicatorDCI_0_1_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_priorityIndicatorDCI_0_1_r16_Optional(_ctx, &p->priorityIndicatorDCI_0_1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_RepTypeIndicatorDCI_0_1_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeIndicatorDCI_0_1_r16_Optional(_ctx, &p->pusch_RepTypeIndicatorDCI_0_1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyHoppingDCI_0_1_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_frequencyHoppingDCI_0_1_r16_Optional(_ctx, &p->frequencyHoppingDCI_0_1_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uci_OnPUSCH_ListDCI_0_1_r16 := ");
	if (p->uci_OnPUSCH_ListDCI_0_1_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Optional(_ctx, &p->uci_OnPUSCH_ListDCI_0_1_r16);
	if (p->uci_OnPUSCH_ListDCI_0_1_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "invalidSymbolPattern_r16 := ");
	if (p->invalidSymbolPattern_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InvalidSymbolPattern_r16_SQN_NR_PUSCH_Config_invalidSymbolPattern_r16_Optional(_ctx, &p->invalidSymbolPattern_r16);
	if (p->invalidSymbolPattern_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_PowerControl_v1610 := ");
	if (p->pusch_PowerControl_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_SQN_NR_PUSCH_Config_pusch_PowerControl_v1610_Optional(_ctx, &p->pusch_PowerControl_v1610);
	if (p->pusch_PowerControl_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ul_FullPowerTransmission_r16 := ");
	_adbgNrSys__SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_ul_FullPowerTransmission_r16_Optional(_ctx, &p->ul_FullPowerTransmission_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_TimeDomainAllocationListForMultiPUSCH_r16 := ");
	if (p->pusch_TimeDomainAllocationListForMultiPUSCH_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Optional(_ctx, &p->pusch_TimeDomainAllocationListForMultiPUSCH_r16);
	if (p->pusch_TimeDomainAllocationListForMultiPUSCH_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "numberOfInvalidSymbolsForDL_UL_Switching_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_Config_numberOfInvalidSymbolsForDL_UL_Switching_r16_Optional(_ctx, &p->numberOfInvalidSymbolsForDL_UL_Switching_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUSCH_Config(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_SQN_NR_BWP_UplinkDedicated_pusch_Config_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_SQN_NR_BWP_UplinkDedicated_pusch_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_frequencyHopping_e__ToString(SQN_NR_ConfiguredGrantConfig_frequencyHopping_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_intraSlot: return "SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_intraSlot";
		case SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_interSlot: return "SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_interSlot";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_frequencyHopping_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_frequencyHopping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_frequencyHopping_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_Table_e__ToString(SQN_NR_ConfiguredGrantConfig_mcs_Table_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_mcs_Table_e_qam256: return "SQN_NR_ConfiguredGrantConfig_mcs_Table_e_qam256";
		case SQN_NR_ConfiguredGrantConfig_mcs_Table_e_qam64LowSE: return "SQN_NR_ConfiguredGrantConfig_mcs_Table_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_Table_e_mcs_Table_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_mcs_Table_e_mcs_Table_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_Table_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e__ToString(SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_qam256: return "SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_qam256";
		case SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_qam64LowSE: return "SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_qam64LowSE";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_CG_UCI_OnPUSCH_Value(acpCtx_t _ctx, const union SQN_NR_CG_UCI_OnPUSCH_Value* p, enum SQN_NR_CG_UCI_OnPUSCH_Sel d)
{
	if (d == SQN_NR_CG_UCI_OnPUSCH_dynamic) {
		adbgPrintLog(_ctx, "dynamic := { ");
		for (size_t i2 = 0; i2 < p->dynamic.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_BetaOffsets(_ctx, &p->dynamic.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->dynamic.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_CG_UCI_OnPUSCH_semiStatic) {
		adbgPrintLog(_ctx, "semiStatic := { ");
		_adbgNrSys__SQN_NR_BetaOffsets(_ctx, &p->semiStatic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_CG_UCI_OnPUSCH(acpCtx_t _ctx, const struct SQN_NR_CG_UCI_OnPUSCH* p)
{
	_adbgNrSys__SQN_NR_CG_UCI_OnPUSCH_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Value* p, enum SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Sel d)
{
	if (d == SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_CG_UCI_OnPUSCH(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_SQN_NR_ConfiguredGrantConfig_uci_OnPUSCH_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_SQN_NR_ConfiguredGrantConfig_uci_OnPUSCH_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_resourceAllocation_e__ToString(SQN_NR_ConfiguredGrantConfig_resourceAllocation_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_resourceAllocation_e_resourceAllocationType0: return "SQN_NR_ConfiguredGrantConfig_resourceAllocation_e_resourceAllocationType0";
		case SQN_NR_ConfiguredGrantConfig_resourceAllocation_e_resourceAllocationType1: return "SQN_NR_ConfiguredGrantConfig_resourceAllocation_e_resourceAllocationType1";
		case SQN_NR_ConfiguredGrantConfig_resourceAllocation_e_dynamicSwitch: return "SQN_NR_ConfiguredGrantConfig_resourceAllocation_e_dynamicSwitch";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_rbg_Size_e__ToString(SQN_NR_ConfiguredGrantConfig_rbg_Size_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_rbg_Size_e_config2: return "SQN_NR_ConfiguredGrantConfig_rbg_Size_e_config2";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_rbg_Size_e_rbg_Size_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_rbg_Size_e_rbg_Size_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_rbg_Size_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_powerControlLoopToUse_e__ToString(SQN_NR_ConfiguredGrantConfig_powerControlLoopToUse_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_powerControlLoopToUse_e_n0: return "SQN_NR_ConfiguredGrantConfig_powerControlLoopToUse_e_n0";
		case SQN_NR_ConfiguredGrantConfig_powerControlLoopToUse_e_n1: return "SQN_NR_ConfiguredGrantConfig_powerControlLoopToUse_e_n1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_transformPrecoder_e__ToString(SQN_NR_ConfiguredGrantConfig_transformPrecoder_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_enabled: return "SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_enabled";
		case SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_disabled: return "SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_disabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_transformPrecoder_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_transformPrecoder_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_transformPrecoder_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_repK_e__ToString(SQN_NR_ConfiguredGrantConfig_repK_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_repK_e_n1: return "SQN_NR_ConfiguredGrantConfig_repK_e_n1";
		case SQN_NR_ConfiguredGrantConfig_repK_e_n2: return "SQN_NR_ConfiguredGrantConfig_repK_e_n2";
		case SQN_NR_ConfiguredGrantConfig_repK_e_n4: return "SQN_NR_ConfiguredGrantConfig_repK_e_n4";
		case SQN_NR_ConfiguredGrantConfig_repK_e_n8: return "SQN_NR_ConfiguredGrantConfig_repK_e_n8";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_repK_RV_e__ToString(SQN_NR_ConfiguredGrantConfig_repK_RV_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_repK_RV_e_s1_0231: return "SQN_NR_ConfiguredGrantConfig_repK_RV_e_s1_0231";
		case SQN_NR_ConfiguredGrantConfig_repK_RV_e_s2_0303: return "SQN_NR_ConfiguredGrantConfig_repK_RV_e_s2_0303";
		case SQN_NR_ConfiguredGrantConfig_repK_RV_e_s3_0000: return "SQN_NR_ConfiguredGrantConfig_repK_RV_e_s3_0000";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_repK_RV_e_repK_RV_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_repK_RV_e_repK_RV_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_repK_RV_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_periodicity_e__ToString(SQN_NR_ConfiguredGrantConfig_periodicity_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym7: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym7";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym4x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym4x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym5x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym5x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym8x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym8x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym10x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym10x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym16x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym16x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym20x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym20x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym32x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym32x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym40x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym40x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym64x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym64x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym80x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym80x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym128x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym128x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym160x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym160x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym256x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym256x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym320x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym320x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym512x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym512x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym640x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym640x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1024x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1024x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1280x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1280x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2560x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2560x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym5120x14: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym5120x14";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym6: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym6";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym4x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym4x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym5x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym5x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym8x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym8x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym10x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym10x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym16x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym16x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym20x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym20x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym32x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym32x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym40x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym40x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym64x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym64x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym80x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym80x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym128x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym128x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym160x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym160x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym256x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym256x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym320x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym320x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym512x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym512x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym640x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym640x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1280x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym1280x12";
		case SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2560x12: return "SQN_NR_ConfiguredGrantConfig_periodicity_e_sym2560x12";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_configuredGrantTimer_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_configuredGrantTimer_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_dmrs_SeqInitialization_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_dmrs_SeqInitialization_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_srs_ResourceIndicator_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_srs_ResourceIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingOffset_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e__ToString(SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeA: return "SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeA";
		case SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeB: return "SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeB";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeIndicator_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeIndicator_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e__ToString(SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_interRepetition: return "SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_interRepetition";
		case SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_interSlot: return "SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_interSlot";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_frequencyHoppingPUSCH_RepTypeB_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_frequencyHoppingPUSCH_RepTypeB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e__ToString(SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_sfn512: return "SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_sfn512";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_timeReferenceSFN_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_timeReferenceSFN_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant* p)
{
	adbgPrintLog(_ctx, "timeDomainOffset := %u", (unsigned int)p->timeDomainOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeDomainAllocation := %u", (unsigned int)p->timeDomainAllocation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyDomainAllocation := '");
	for (size_t i2 = 0; i2 < 18; i2++) {
		adbgPrintLog(_ctx, "%02X", p->frequencyDomainAllocation[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "antennaPort := %u", (unsigned int)p->antennaPort);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_SeqInitialization := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_dmrs_SeqInitialization_Optional(_ctx, &p->dmrs_SeqInitialization);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "precodingAndNumberOfLayers := %u", (unsigned int)p->precodingAndNumberOfLayers);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_ResourceIndicator := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_srs_ResourceIndicator_Optional(_ctx, &p->srs_ResourceIndicator);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcsAndTBS := %u", (unsigned int)p->mcsAndTBS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyHoppingOffset := ");
	_adbgNrSys__Uint16_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingOffset_Optional(_ctx, &p->frequencyHoppingOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceIndex := %u", (unsigned int)p->pathlossReferenceIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_RepTypeIndicator_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeIndicator_r16_Optional(_ctx, &p->pusch_RepTypeIndicator_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyHoppingPUSCH_RepTypeB_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_frequencyHoppingPUSCH_RepTypeB_r16_Optional(_ctx, &p->frequencyHoppingPUSCH_RepTypeB_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeReferenceSFN_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_timeReferenceSFN_r16_Optional(_ctx, &p->timeReferenceSFN_r16);
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_rrc_ConfiguredUplinkGrant_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_rrc_ConfiguredUplinkGrant_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_RetransmissionTimer_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_RetransmissionTimer_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e__ToString(SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym7: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym7";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym1x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym1x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym2x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym2x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym3x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym3x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym4x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym4x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym5x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym5x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym6x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym6x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym7x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym7x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym8x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym8x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym9x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym9x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym10x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym10x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym11x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym11x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym12x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym12x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym13x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym13x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym14x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym14x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym15x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym15x14";
		case SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym16x14: return "SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_sym16x14";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_cg_minDFI_Delay_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_cg_minDFI_Delay_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofPUSCH_InSlot_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofPUSCH_InSlot_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofSlots_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofSlots_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_InsideCOT_r16_DynamicOptional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_InsideCOT_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_OutsideCOT_r16_DynamicOptional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_OutsideCOT_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_InsideCOT_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_InsideCOT_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_OutsideCOT_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_OutsideCOT_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_CG_StartingOffsets_r16(acpCtx_t _ctx, const struct SQN_NR_CG_StartingOffsets_r16* p)
{
	adbgPrintLog(_ctx, "cg_StartingFullBW_InsideCOT_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_InsideCOT_r16_DynamicOptional(_ctx, &p->cg_StartingFullBW_InsideCOT_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_StartingFullBW_OutsideCOT_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_OutsideCOT_r16_DynamicOptional(_ctx, &p->cg_StartingFullBW_OutsideCOT_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_StartingPartialBW_InsideCOT_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_InsideCOT_r16_Optional(_ctx, &p->cg_StartingPartialBW_InsideCOT_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_StartingPartialBW_OutsideCOT_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_OutsideCOT_r16_Optional(_ctx, &p->cg_StartingPartialBW_OutsideCOT_r16);
}

static void _adbgNrSys__SQN_NR_CG_StartingOffsets_r16_SQN_NR_ConfiguredGrantConfig_cg_StartingOffsets_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_CG_StartingOffsets_r16_SQN_NR_ConfiguredGrantConfig_cg_StartingOffsets_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CG_StartingOffsets_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e__ToString(SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_enabled: return "SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_cg_UCI_Multiplexing_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_cg_UCI_Multiplexing_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingOffset_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingOffset_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_betaOffsetCG_UCI_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_betaOffsetCG_UCI_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16(acpCtx_t _ctx, const struct SQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16* p)
{
	adbgPrintLog(_ctx, "duration_r16 := %u", (unsigned int)p->duration_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "offset_r16 := %u", (unsigned int)p->offset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "channelAccessPriority_r16 := %u", (unsigned int)p->channelAccessPriority_r16);
}

static void _adbgNrSys__SQN_NR_CG_COT_Sharing_r16_Value(acpCtx_t _ctx, const union SQN_NR_CG_COT_Sharing_r16_Value* p, enum SQN_NR_CG_COT_Sharing_r16_Sel d)
{
	if (d == SQN_NR_CG_COT_Sharing_r16_noCOT_Sharing_r16) {
		adbgPrintLog(_ctx, "noCOT_Sharing_r16 := %s", (p->noCOT_Sharing_r16 ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16) {
		adbgPrintLog(_ctx, "cot_Sharing_r16 := { ");
		_adbgNrSys__SQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16(_ctx, &p->cot_Sharing_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_CG_COT_Sharing_r16(acpCtx_t _ctx, const struct SQN_NR_CG_COT_Sharing_r16* p)
{
	_adbgNrSys__SQN_NR_CG_COT_Sharing_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_CG_COT_Sharing_r16_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_CG_COT_Sharing_r16_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_CG_COT_Sharing_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfigIndex_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndex_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfigIndex_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfigIndexMAC_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndexMAC_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfigIndexMAC_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndexMAC_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_ConfiguredGrantConfig_periodicityExt_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_ConfiguredGrantConfig_periodicityExt_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e__ToString(SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_on: return "SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_on";
		case SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_off: return "SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_off";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_startingFromRV0_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_startingFromRV0_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e__ToString(SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_p0: return "SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_p0";
		case SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_p1: return "SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_p1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e__ToString(SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e v)
{
	switch(v) {
		case SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_enabled: return "SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_autonomousTx_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_autonomousTx_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfig(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfig* p)
{
	adbgPrintLog(_ctx, "frequencyHopping := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_frequencyHopping_Optional(_ctx, &p->frequencyHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_DMRS_Configuration := { ");
	_adbgNrSys__SQN_NR_DMRS_UplinkConfig(_ctx, &p->cg_DMRS_Configuration);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_Table := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_Table_e_mcs_Table_Optional(_ctx, &p->mcs_Table);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "mcs_TableTransformPrecoder := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(_ctx, &p->mcs_TableTransformPrecoder);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uci_OnPUSCH := ");
	if (p->uci_OnPUSCH.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_SQN_NR_ConfiguredGrantConfig_uci_OnPUSCH_Optional(_ctx, &p->uci_OnPUSCH);
	if (p->uci_OnPUSCH.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceAllocation := %s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_resourceAllocation_e__ToString(p->resourceAllocation), (int)p->resourceAllocation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rbg_Size := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_rbg_Size_e_rbg_Size_Optional(_ctx, &p->rbg_Size);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "powerControlLoopToUse := %s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_powerControlLoopToUse_e__ToString(p->powerControlLoopToUse), (int)p->powerControlLoopToUse);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_PUSCH_Alpha := %u", (unsigned int)p->p0_PUSCH_Alpha);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transformPrecoder := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_transformPrecoder_Optional(_ctx, &p->transformPrecoder);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofHARQ_Processes := %u", (unsigned int)p->nrofHARQ_Processes);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "repK := %s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_repK_e__ToString(p->repK), (int)p->repK);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "repK_RV := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_repK_RV_e_repK_RV_Optional(_ctx, &p->repK_RV);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicity := %s (%d)", adbgNrSys__SQN_NR_ConfiguredGrantConfig_periodicity_e__ToString(p->periodicity), (int)p->periodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "configuredGrantTimer := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_configuredGrantTimer_Optional(_ctx, &p->configuredGrantTimer);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rrc_ConfiguredUplinkGrant := ");
	if (p->rrc_ConfiguredUplinkGrant.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_rrc_ConfiguredUplinkGrant_Optional(_ctx, &p->rrc_ConfiguredUplinkGrant);
	if (p->rrc_ConfiguredUplinkGrant.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_RetransmissionTimer_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_RetransmissionTimer_r16_Optional(_ctx, &p->cg_RetransmissionTimer_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_minDFI_Delay_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_cg_minDFI_Delay_r16_Optional(_ctx, &p->cg_minDFI_Delay_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_nrofPUSCH_InSlot_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofPUSCH_InSlot_r16_Optional(_ctx, &p->cg_nrofPUSCH_InSlot_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_nrofSlots_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofSlots_r16_Optional(_ctx, &p->cg_nrofSlots_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_StartingOffsets_r16 := ");
	if (p->cg_StartingOffsets_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CG_StartingOffsets_r16_SQN_NR_ConfiguredGrantConfig_cg_StartingOffsets_r16_Optional(_ctx, &p->cg_StartingOffsets_r16);
	if (p->cg_StartingOffsets_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_UCI_Multiplexing := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_cg_UCI_Multiplexing_Optional(_ctx, &p->cg_UCI_Multiplexing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_COT_SharingOffset_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingOffset_r16_Optional(_ctx, &p->cg_COT_SharingOffset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "betaOffsetCG_UCI_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_betaOffsetCG_UCI_r16_Optional(_ctx, &p->betaOffsetCG_UCI_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cg_COT_SharingList_r16 := ");
	if (p->cg_COT_SharingList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CG_COT_Sharing_r16_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingList_r16_DynamicOptional(_ctx, &p->cg_COT_SharingList_r16);
	if (p->cg_COT_SharingList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "harq_ProcID_Offset_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset_r16_Optional(_ctx, &p->harq_ProcID_Offset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "harq_ProcID_Offset2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset2_r16_Optional(_ctx, &p->harq_ProcID_Offset2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "configuredGrantConfigIndex_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfigIndex_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndex_r16_Optional(_ctx, &p->configuredGrantConfigIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "configuredGrantConfigIndexMAC_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfigIndexMAC_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndexMAC_r16_Optional(_ctx, &p->configuredGrantConfigIndexMAC_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicityExt_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_ConfiguredGrantConfig_periodicityExt_r16_Optional(_ctx, &p->periodicityExt_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "startingFromRV0_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_startingFromRV0_r16_Optional(_ctx, &p->startingFromRV0_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "phy_PriorityIndex_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(_ctx, &p->phy_PriorityIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "autonomousTx_r16 := ");
	_adbgNrSys__SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_autonomousTx_r16_Optional(_ctx, &p->autonomousTx_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_ConfiguredGrantConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_SQN_NR_BWP_UplinkDedicated_configuredGrantConfig_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_SQN_NR_BWP_UplinkDedicated_configuredGrantConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SRS_ResourceId_SQN_NR_SRS_ResourceSet_srs_ResourceIdList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceId_SQN_NR_SRS_ResourceSet_srs_ResourceIdList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_csi_RS_Optional(acpCtx_t _ctx, const struct SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_csi_RS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_slotOffset_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_slotOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_aperiodicSRS_ResourceTriggerList_DynamicOptional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_aperiodicSRS_ResourceTriggerList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_aperiodic(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet_resourceType_aperiodic* p)
{
	adbgPrintLog(_ctx, "aperiodicSRS_ResourceTrigger := %u", (unsigned int)p->aperiodicSRS_ResourceTrigger);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "csi_RS := ");
	_adbgNrSys__SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_csi_RS_Optional(_ctx, &p->csi_RS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "slotOffset := ");
	_adbgNrSys__Uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_slotOffset_Optional(_ctx, &p->slotOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "aperiodicSRS_ResourceTriggerList := ");
	_adbgNrSys__Uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_aperiodicSRS_ResourceTriggerList_DynamicOptional(_ctx, &p->aperiodicSRS_ResourceTriggerList);
}

static void _adbgNrSys__SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_semi_persistent_associatedCSI_RS_Optional(acpCtx_t _ctx, const struct SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_semi_persistent_associatedCSI_RS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_semi_persistent(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet_resourceType_semi_persistent* p)
{
	adbgPrintLog(_ctx, "associatedCSI_RS := ");
	_adbgNrSys__SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_semi_persistent_associatedCSI_RS_Optional(_ctx, &p->associatedCSI_RS);
}

static void _adbgNrSys__SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_periodic_associatedCSI_RS_Optional(acpCtx_t _ctx, const struct SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_periodic_associatedCSI_RS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_periodic(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet_resourceType_periodic* p)
{
	adbgPrintLog(_ctx, "associatedCSI_RS := ");
	_adbgNrSys__SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_periodic_associatedCSI_RS_Optional(_ctx, &p->associatedCSI_RS);
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_Value(acpCtx_t _ctx, const union SQN_NR_SRS_ResourceSet_resourceType_Value* p, enum SQN_NR_SRS_ResourceSet_resourceType_Sel d)
{
	if (d == SQN_NR_SRS_ResourceSet_resourceType_aperiodic) {
		adbgPrintLog(_ctx, "aperiodic := { ");
		_adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_aperiodic(_ctx, &p->aperiodic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_ResourceSet_resourceType_semi_persistent) {
		adbgPrintLog(_ctx, "semi_persistent := { ");
		_adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_semi_persistent(_ctx, &p->semi_persistent);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_ResourceSet_resourceType_periodic) {
		adbgPrintLog(_ctx, "periodic := { ");
		_adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_periodic(_ctx, &p->periodic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet_resourceType* p)
{
	_adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_SRS_ResourceSet_usage_e__ToString(SQN_NR_SRS_ResourceSet_usage_e v)
{
	switch(v) {
		case SQN_NR_SRS_ResourceSet_usage_e_beamManagement: return "SQN_NR_SRS_ResourceSet_usage_e_beamManagement";
		case SQN_NR_SRS_ResourceSet_usage_e_codebook: return "SQN_NR_SRS_ResourceSet_usage_e_codebook";
		case SQN_NR_SRS_ResourceSet_usage_e_nonCodebook: return "SQN_NR_SRS_ResourceSet_usage_e_nonCodebook";
		case SQN_NR_SRS_ResourceSet_usage_e_antennaSwitching: return "SQN_NR_SRS_ResourceSet_usage_e_antennaSwitching";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_Alpha_e_SQN_NR_SRS_ResourceSet_alpha_Optional(acpCtx_t _ctx, const struct SQN_NR_Alpha_e_SQN_NR_SRS_ResourceSet_alpha_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_Alpha_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Int16_t_SQN_NR_SRS_ResourceSet_p0_Optional(acpCtx_t _ctx, const struct int16_t_SQN_NR_SRS_ResourceSet_p0_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_PathlossReferenceRS_Config_Value(acpCtx_t _ctx, const union SQN_NR_PathlossReferenceRS_Config_Value* p, enum SQN_NR_PathlossReferenceRS_Config_Sel d)
{
	if (d == SQN_NR_PathlossReferenceRS_Config_ssb_Index) {
		adbgPrintLog(_ctx, "ssb_Index := %u", (unsigned int)p->ssb_Index);
		return;
	}
	if (d == SQN_NR_PathlossReferenceRS_Config_csi_RS_Index) {
		adbgPrintLog(_ctx, "csi_RS_Index := %u", (unsigned int)p->csi_RS_Index);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PathlossReferenceRS_Config(acpCtx_t _ctx, const struct SQN_NR_PathlossReferenceRS_Config* p)
{
	_adbgNrSys__SQN_NR_PathlossReferenceRS_Config_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PathlossReferenceRS_Config_SQN_NR_SRS_ResourceSet_pathlossReferenceRS_Optional(acpCtx_t _ctx, const struct SQN_NR_PathlossReferenceRS_Config_SQN_NR_SRS_ResourceSet_pathlossReferenceRS_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_PathlossReferenceRS_Config(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e__ToString(SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e v)
{
	switch(v) {
		case SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_sameAsFci2: return "SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_sameAsFci2";
		case SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_separateClosedLoop: return "SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_separateClosedLoop";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_srs_PowerControlAdjustmentStates_Optional(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_srs_PowerControlAdjustmentStates_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PathlossReferenceRS_r16(acpCtx_t _ctx, const struct SQN_NR_PathlossReferenceRS_r16* p)
{
	adbgPrintLog(_ctx, "srs_PathlossReferenceRS_Id_r16 := %u", (unsigned int)p->srs_PathlossReferenceRS_Id_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRS_r16 := { ");
	_adbgNrSys__SQN_NR_PathlossReferenceRS_Config(_ctx, &p->pathlossReferenceRS_r16);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Value* p, enum SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i3 = 0; i3 < p->setup.d; i3++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PathlossReferenceRS_r16(_ctx, &p->setup.v[i3]);
			adbgPrintLog(_ctx, " }");
			if (i3 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_SQN_NR_SRS_ResourceSet_pathlossReferenceRSList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_SQN_NR_SRS_ResourceSet_pathlossReferenceRSList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet* p)
{
	adbgPrintLog(_ctx, "srs_ResourceSetId := %u", (unsigned int)p->srs_ResourceSetId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_ResourceIdList := ");
	_adbgNrSys__SQN_NR_SRS_ResourceId_SQN_NR_SRS_ResourceSet_srs_ResourceIdList_DynamicOptional(_ctx, &p->srs_ResourceIdList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceType := { ");
	_adbgNrSys__SQN_NR_SRS_ResourceSet_resourceType(_ctx, &p->resourceType);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "usage := %s (%d)", adbgNrSys__SQN_NR_SRS_ResourceSet_usage_e__ToString(p->usage), (int)p->usage);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "alpha := ");
	_adbgNrSys__SQN_NR_Alpha_e_SQN_NR_SRS_ResourceSet_alpha_Optional(_ctx, &p->alpha);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0 := ");
	_adbgNrSys__Int16_t_SQN_NR_SRS_ResourceSet_p0_Optional(_ctx, &p->p0);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRS := ");
	if (p->pathlossReferenceRS.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PathlossReferenceRS_Config_SQN_NR_SRS_ResourceSet_pathlossReferenceRS_Optional(_ctx, &p->pathlossReferenceRS);
	if (p->pathlossReferenceRS.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_PowerControlAdjustmentStates := ");
	_adbgNrSys__SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_srs_PowerControlAdjustmentStates_Optional(_ctx, &p->srs_PowerControlAdjustmentStates);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRSList_r16 := ");
	if (p->pathlossReferenceRSList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_SQN_NR_SRS_ResourceSet_pathlossReferenceRSList_r16_Optional(_ctx, &p->pathlossReferenceRSList_r16);
	if (p->pathlossReferenceRSList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SRS_ResourceSet(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SRS_ResourceId_SQN_NR_SRS_Config_srs_ResourceToReleaseList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceId_SQN_NR_SRS_Config_srs_ResourceToReleaseList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_SRS_Resource_nrofSRS_Ports_e__ToString(SQN_NR_SRS_Resource_nrofSRS_Ports_e v)
{
	switch(v) {
		case SQN_NR_SRS_Resource_nrofSRS_Ports_e_port1: return "SQN_NR_SRS_Resource_nrofSRS_Ports_e_port1";
		case SQN_NR_SRS_Resource_nrofSRS_Ports_e_ports2: return "SQN_NR_SRS_Resource_nrofSRS_Ports_e_ports2";
		case SQN_NR_SRS_Resource_nrofSRS_Ports_e_ports4: return "SQN_NR_SRS_Resource_nrofSRS_Ports_e_ports4";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SRS_Resource_ptrs_PortIndex_e__ToString(SQN_NR_SRS_Resource_ptrs_PortIndex_e v)
{
	switch(v) {
		case SQN_NR_SRS_Resource_ptrs_PortIndex_e_n0: return "SQN_NR_SRS_Resource_ptrs_PortIndex_e_n0";
		case SQN_NR_SRS_Resource_ptrs_PortIndex_e_n1: return "SQN_NR_SRS_Resource_ptrs_PortIndex_e_n1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRS_Resource_ptrs_PortIndex_e_ptrs_PortIndex_Optional(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_ptrs_PortIndex_e_ptrs_PortIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SRS_Resource_ptrs_PortIndex_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SRS_Resource_transmissionComb_n2(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_transmissionComb_n2* p)
{
	adbgPrintLog(_ctx, "combOffset_n2 := %u", (unsigned int)p->combOffset_n2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cyclicShift_n2 := %u", (unsigned int)p->cyclicShift_n2);
}

static void _adbgNrSys__SQN_NR_SRS_Resource_transmissionComb_n4(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_transmissionComb_n4* p)
{
	adbgPrintLog(_ctx, "combOffset_n4 := %u", (unsigned int)p->combOffset_n4);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cyclicShift_n4 := %u", (unsigned int)p->cyclicShift_n4);
}

static void _adbgNrSys__SQN_NR_SRS_Resource_transmissionComb_Value(acpCtx_t _ctx, const union SQN_NR_SRS_Resource_transmissionComb_Value* p, enum SQN_NR_SRS_Resource_transmissionComb_Sel d)
{
	if (d == SQN_NR_SRS_Resource_transmissionComb_n2) {
		adbgPrintLog(_ctx, "n2 := { ");
		_adbgNrSys__SQN_NR_SRS_Resource_transmissionComb_n2(_ctx, &p->n2);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_Resource_transmissionComb_n4) {
		adbgPrintLog(_ctx, "n4 := { ");
		_adbgNrSys__SQN_NR_SRS_Resource_transmissionComb_n4(_ctx, &p->n4);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_Resource_transmissionComb(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_transmissionComb* p)
{
	_adbgNrSys__SQN_NR_SRS_Resource_transmissionComb_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e__ToString(SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e v)
{
	switch(v) {
		case SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e_n1: return "SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e_n1";
		case SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e_n2: return "SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e_n2";
		case SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e_n4: return "SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e_n4";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e__ToString(SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e v)
{
	switch(v) {
		case SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e_n1: return "SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e_n1";
		case SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e_n2: return "SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e_n2";
		case SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e_n4: return "SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e_n4";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceMapping(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_resourceMapping* p)
{
	adbgPrintLog(_ctx, "startPosition := %u", (unsigned int)p->startPosition);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSymbols := %s (%d)", adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_nrofSymbols_e__ToString(p->nrofSymbols), (int)p->nrofSymbols);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "repetitionFactor := %s (%d)", adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_repetitionFactor_e__ToString(p->repetitionFactor), (int)p->repetitionFactor);
}

static void _adbgNrSys__SQN_NR_SRS_Resource_freqHopping(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_freqHopping* p)
{
	adbgPrintLog(_ctx, "c_SRS := %u", (unsigned int)p->c_SRS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "b_SRS := %u", (unsigned int)p->b_SRS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "b_hop := %u", (unsigned int)p->b_hop);
}

static const char* adbgNrSys__SQN_NR_SRS_Resource_groupOrSequenceHopping_e__ToString(SQN_NR_SRS_Resource_groupOrSequenceHopping_e v)
{
	switch(v) {
		case SQN_NR_SRS_Resource_groupOrSequenceHopping_e_neither: return "SQN_NR_SRS_Resource_groupOrSequenceHopping_e_neither";
		case SQN_NR_SRS_Resource_groupOrSequenceHopping_e_groupHopping: return "SQN_NR_SRS_Resource_groupOrSequenceHopping_e_groupHopping";
		case SQN_NR_SRS_Resource_groupOrSequenceHopping_e_sequenceHopping: return "SQN_NR_SRS_Resource_groupOrSequenceHopping_e_sequenceHopping";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceType_aperiodic(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_resourceType_aperiodic* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset_Value(acpCtx_t _ctx, const union SQN_NR_SRS_PeriodicityAndOffset_Value* p, enum SQN_NR_SRS_PeriodicityAndOffset_Sel d)
{
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl1) {
		adbgPrintLog(_ctx, "sl1 := %s", (p->sl1 ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl2) {
		adbgPrintLog(_ctx, "sl2 := %u", (unsigned int)p->sl2);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl4) {
		adbgPrintLog(_ctx, "sl4 := %u", (unsigned int)p->sl4);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl5) {
		adbgPrintLog(_ctx, "sl5 := %u", (unsigned int)p->sl5);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl8) {
		adbgPrintLog(_ctx, "sl8 := %u", (unsigned int)p->sl8);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl10) {
		adbgPrintLog(_ctx, "sl10 := %u", (unsigned int)p->sl10);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl16) {
		adbgPrintLog(_ctx, "sl16 := %u", (unsigned int)p->sl16);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl20) {
		adbgPrintLog(_ctx, "sl20 := %u", (unsigned int)p->sl20);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl32) {
		adbgPrintLog(_ctx, "sl32 := %u", (unsigned int)p->sl32);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl40) {
		adbgPrintLog(_ctx, "sl40 := %u", (unsigned int)p->sl40);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl64) {
		adbgPrintLog(_ctx, "sl64 := %u", (unsigned int)p->sl64);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl80) {
		adbgPrintLog(_ctx, "sl80 := %u", (unsigned int)p->sl80);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl160) {
		adbgPrintLog(_ctx, "sl160 := %u", (unsigned int)p->sl160);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl320) {
		adbgPrintLog(_ctx, "sl320 := %u", (unsigned int)p->sl320);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl640) {
		adbgPrintLog(_ctx, "sl640 := %u", (unsigned int)p->sl640);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl1280) {
		adbgPrintLog(_ctx, "sl1280 := %u", (unsigned int)p->sl1280);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl2560) {
		adbgPrintLog(_ctx, "sl2560 := %u", (unsigned int)p->sl2560);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset(acpCtx_t _ctx, const struct SQN_NR_SRS_PeriodicityAndOffset* p)
{
	_adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceType_semi_persistent(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_resourceType_semi_persistent* p)
{
	adbgPrintLog(_ctx, "periodicityAndOffset_sp := { ");
	_adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset(_ctx, &p->periodicityAndOffset_sp);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceType_periodic(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_resourceType_periodic* p)
{
	adbgPrintLog(_ctx, "periodicityAndOffset_p := { ");
	_adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset(_ctx, &p->periodicityAndOffset_p);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceType_Value(acpCtx_t _ctx, const union SQN_NR_SRS_Resource_resourceType_Value* p, enum SQN_NR_SRS_Resource_resourceType_Sel d)
{
	if (d == SQN_NR_SRS_Resource_resourceType_aperiodic) {
		adbgPrintLog(_ctx, "aperiodic := { ");
		_adbgNrSys__SQN_NR_SRS_Resource_resourceType_aperiodic(_ctx, &p->aperiodic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_Resource_resourceType_semi_persistent) {
		adbgPrintLog(_ctx, "semi_persistent := { ");
		_adbgNrSys__SQN_NR_SRS_Resource_resourceType_semi_persistent(_ctx, &p->semi_persistent);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_Resource_resourceType_periodic) {
		adbgPrintLog(_ctx, "periodic := { ");
		_adbgNrSys__SQN_NR_SRS_Resource_resourceType_periodic(_ctx, &p->periodic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceType(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_resourceType* p)
{
	_adbgNrSys__SQN_NR_SRS_Resource_resourceType_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfo_servingCellId_Optional(acpCtx_t _ctx, const struct SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfo_servingCellId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs* p)
{
	adbgPrintLog(_ctx, "resourceId := %u", (unsigned int)p->resourceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uplinkBWP := %u", (unsigned int)p->uplinkBWP);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_referenceSignal_Value(acpCtx_t _ctx, const union SQN_NR_SRS_SpatialRelationInfo_referenceSignal_Value* p, enum SQN_NR_SRS_SpatialRelationInfo_referenceSignal_Sel d)
{
	if (d == SQN_NR_SRS_SpatialRelationInfo_referenceSignal_ssb_Index) {
		adbgPrintLog(_ctx, "ssb_Index := %u", (unsigned int)p->ssb_Index);
		return;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfo_referenceSignal_csi_RS_Index) {
		adbgPrintLog(_ctx, "csi_RS_Index := %u", (unsigned int)p->csi_RS_Index);
		return;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs) {
		adbgPrintLog(_ctx, "srs := { ");
		_adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs(_ctx, &p->srs);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_referenceSignal(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfo_referenceSignal* p)
{
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_referenceSignal_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfo(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfo* p)
{
	adbgPrintLog(_ctx, "servingCellId := ");
	_adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfo_servingCellId_Optional(_ctx, &p->servingCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal := { ");
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_referenceSignal(_ctx, &p->referenceSignal);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_SQN_NR_SRS_Resource_spatialRelationInfo_Optional(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfo_SQN_NR_SRS_Resource_spatialRelationInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfo(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e__ToString(SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e v)
{
	switch(v) {
		case SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e_n1: return "SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e_n1";
		case SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e_n2: return "SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e_n2";
		case SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e_n4: return "SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e_n4";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e__ToString(SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e v)
{
	switch(v) {
		case SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e_n1: return "SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e_n1";
		case SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e_n2: return "SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e_n2";
		case SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e_n4: return "SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e_n4";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_resourceMapping_r16* p)
{
	adbgPrintLog(_ctx, "startPosition_r16 := %u", (unsigned int)p->startPosition_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSymbols_r16 := %s (%d)", adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16_nrofSymbols_r16_e__ToString(p->nrofSymbols_r16), (int)p->nrofSymbols_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "repetitionFactor_r16 := %s (%d)", adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16_repetitionFactor_r16_e__ToString(p->repetitionFactor_r16), (int)p->repetitionFactor_r16);
}

static void _adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16_resourceMapping_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_resourceMapping_r16_resourceMapping_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SRS_Resource(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource* p)
{
	adbgPrintLog(_ctx, "srs_ResourceId := %u", (unsigned int)p->srs_ResourceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSRS_Ports := %s (%d)", adbgNrSys__SQN_NR_SRS_Resource_nrofSRS_Ports_e__ToString(p->nrofSRS_Ports), (int)p->nrofSRS_Ports);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ptrs_PortIndex := ");
	_adbgNrSys__SQN_NR_SRS_Resource_ptrs_PortIndex_e_ptrs_PortIndex_Optional(_ctx, &p->ptrs_PortIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transmissionComb := { ");
	_adbgNrSys__SQN_NR_SRS_Resource_transmissionComb(_ctx, &p->transmissionComb);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceMapping := { ");
	_adbgNrSys__SQN_NR_SRS_Resource_resourceMapping(_ctx, &p->resourceMapping);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqDomainPosition := %u", (unsigned int)p->freqDomainPosition);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqDomainShift := %u", (unsigned int)p->freqDomainShift);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqHopping := { ");
	_adbgNrSys__SQN_NR_SRS_Resource_freqHopping(_ctx, &p->freqHopping);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "groupOrSequenceHopping := %s (%d)", adbgNrSys__SQN_NR_SRS_Resource_groupOrSequenceHopping_e__ToString(p->groupOrSequenceHopping), (int)p->groupOrSequenceHopping);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceType := { ");
	_adbgNrSys__SQN_NR_SRS_Resource_resourceType(_ctx, &p->resourceType);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sequenceId := %u", (unsigned int)p->sequenceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfo := ");
	if (p->spatialRelationInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfo_SQN_NR_SRS_Resource_spatialRelationInfo_Optional(_ctx, &p->spatialRelationInfo);
	if (p->spatialRelationInfo.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceMapping_r16 := ");
	if (p->resourceMapping_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_Resource_resourceMapping_r16_resourceMapping_r16_Optional(_ctx, &p->resourceMapping_r16);
	if (p->resourceMapping_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SRS_Resource_SQN_NR_SRS_Config_srs_ResourceToAddModList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_Resource_SQN_NR_SRS_Config_srs_ResourceToAddModList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SRS_Resource(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_SRS_Config_tpc_Accumulation_e__ToString(SQN_NR_SRS_Config_tpc_Accumulation_e v)
{
	switch(v) {
		case SQN_NR_SRS_Config_tpc_Accumulation_e_disabled: return "SQN_NR_SRS_Config_tpc_Accumulation_e_disabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRS_Config_tpc_Accumulation_e_tpc_Accumulation_Optional(acpCtx_t _ctx, const struct SQN_NR_SRS_Config_tpc_Accumulation_e_tpc_Accumulation_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SRS_Config_tpc_Accumulation_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_1_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_1_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModListDCI_0_2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModListDCI_0_2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SRS_ResourceSet(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseListDCI_0_2_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseListDCI_0_2_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSetId_r16_SQN_NR_SRS_Config_srs_PosResourceSetToReleaseList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSetId_r16_SQN_NR_SRS_Config_srs_PosResourceSetToReleaseList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_PosResourceSet_r16_srs_PosResourceIdList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_PosResourceSet_r16_srs_PosResourceIdList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16_aperiodicSRS_ResourceTriggerList_r16_DynamicOptional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16_aperiodicSRS_ResourceTriggerList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16* p)
{
	adbgPrintLog(_ctx, "aperiodicSRS_ResourceTriggerList_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16_aperiodicSRS_ResourceTriggerList_r16_DynamicOptional(_ctx, &p->aperiodicSRS_ResourceTriggerList_r16);
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Value* p, enum SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Sel d)
{
	if (d == SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16) {
		adbgPrintLog(_ctx, "aperiodic_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16(_ctx, &p->aperiodic_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16) {
		adbgPrintLog(_ctx, "semi_persistent_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16(_ctx, &p->semi_persistent_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16) {
		adbgPrintLog(_ctx, "periodic_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16(_ctx, &p->periodic_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_Alpha_e_SQN_NR_SRS_PosResourceSet_r16_alpha_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_Alpha_e_SQN_NR_SRS_PosResourceSet_r16_alpha_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_Alpha_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Int16_t_SQN_NR_SRS_PosResourceSet_r16_p0_r16_Optional(acpCtx_t _ctx, const struct int16_t_SQN_NR_SRS_PosResourceSet_r16_p0_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_SSB_Index_SQN_NR_SSB_InfoNcell_r16_ssb_IndexNcell_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_Index_SQN_NR_SSB_InfoNcell_r16_ssb_IndexNcell_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_SSB_Configuration_r16_halfFrameIndex_r16_e__ToString(SQN_NR_SSB_Configuration_r16_halfFrameIndex_r16_e v)
{
	switch(v) {
		case SQN_NR_SSB_Configuration_r16_halfFrameIndex_r16_e_zero: return "SQN_NR_SSB_Configuration_r16_halfFrameIndex_r16_e_zero";
		case SQN_NR_SSB_Configuration_r16_halfFrameIndex_r16_e_one: return "SQN_NR_SSB_Configuration_r16_halfFrameIndex_r16_e_one";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e__ToString(SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e v)
{
	switch(v) {
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms5: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms5";
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms10: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms10";
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms20: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms20";
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms40: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms40";
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms80: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms80";
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms160: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ms160";
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_spare2: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_spare2";
		case SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_spare1: return "SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ssb_Periodicity_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ssb_Periodicity_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_integerSubframeOffset_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_integerSubframeOffset_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16(acpCtx_t _ctx, const struct SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16* p)
{
	adbgPrintLog(_ctx, "sfn_Offset_r16 := %u", (unsigned int)p->sfn_Offset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "integerSubframeOffset_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_integerSubframeOffset_r16_Optional(_ctx, &p->integerSubframeOffset_r16);
}

static void _adbgNrSys__SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_sfn0_Offset_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_sfn0_Offset_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16(_ctx, &p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_SSB_Configuration_r16_ss_PBCH_BlockPower_r16_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_SSB_Configuration_r16_ss_PBCH_BlockPower_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_SSB_Configuration_r16(acpCtx_t _ctx, const struct SQN_NR_SSB_Configuration_r16* p)
{
	adbgPrintLog(_ctx, "ssb_Freq_r16 := %u", (unsigned int)p->ssb_Freq_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "halfFrameIndex_r16 := %s (%d)", adbgNrSys__SQN_NR_SSB_Configuration_r16_halfFrameIndex_r16_e__ToString(p->halfFrameIndex_r16), (int)p->halfFrameIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssbSubcarrierSpacing_r16 := %s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->ssbSubcarrierSpacing_r16), (int)p->ssbSubcarrierSpacing_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_Periodicity_r16 := ");
	_adbgNrSys__SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ssb_Periodicity_r16_Optional(_ctx, &p->ssb_Periodicity_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sfn0_Offset_r16 := ");
	if (p->sfn0_Offset_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_sfn0_Offset_r16_Optional(_ctx, &p->sfn0_Offset_r16);
	if (p->sfn0_Offset_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sfn_SSB_Offset_r16 := %u", (unsigned int)p->sfn_SSB_Offset_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ss_PBCH_BlockPower_r16 := ");
	_adbgNrSys__Int8_t_SQN_NR_SSB_Configuration_r16_ss_PBCH_BlockPower_r16_Optional(_ctx, &p->ss_PBCH_BlockPower_r16);
}

static void _adbgNrSys__SQN_NR_SSB_Configuration_r16_SQN_NR_SSB_InfoNcell_r16_ssb_Configuration_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_Configuration_r16_SQN_NR_SSB_InfoNcell_r16_ssb_Configuration_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_Configuration_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SSB_InfoNcell_r16(acpCtx_t _ctx, const struct SQN_NR_SSB_InfoNcell_r16* p)
{
	adbgPrintLog(_ctx, "physicalCellId_r16 := %u", (unsigned int)p->physicalCellId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_IndexNcell_r16 := ");
	_adbgNrSys__SQN_NR_SSB_Index_SQN_NR_SSB_InfoNcell_r16_ssb_IndexNcell_r16_Optional(_ctx, &p->ssb_IndexNcell_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_Configuration_r16 := ");
	if (p->ssb_Configuration_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_Configuration_r16_SQN_NR_SSB_InfoNcell_r16_ssb_Configuration_r16_Optional(_ctx, &p->ssb_Configuration_r16);
	if (p->ssb_Configuration_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__Uint8_t_SQN_NR_DL_PRS_Info_r16_dl_PRS_ResourceId_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_DL_PRS_Info_r16_dl_PRS_ResourceId_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_DL_PRS_Info_r16(acpCtx_t _ctx, const struct SQN_NR_DL_PRS_Info_r16* p)
{
	adbgPrintLog(_ctx, "dl_PRS_ID_r16 := %u", (unsigned int)p->dl_PRS_ID_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dl_PRS_ResourceSetId_r16 := %u", (unsigned int)p->dl_PRS_ResourceSetId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dl_PRS_ResourceId_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_DL_PRS_Info_r16_dl_PRS_ResourceId_r16_Optional(_ctx, &p->dl_PRS_ResourceId_r16);
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Value* p, enum SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Sel d)
{
	if (d == SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_ssb_IndexServing_r16) {
		adbgPrintLog(_ctx, "ssb_IndexServing_r16 := %u", (unsigned int)p->ssb_IndexServing_r16);
		return;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_ssb_Ncell_r16) {
		adbgPrintLog(_ctx, "ssb_Ncell_r16 := { ");
		_adbgNrSys__SQN_NR_SSB_InfoNcell_r16(_ctx, &p->ssb_Ncell_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_dl_PRS_r16) {
		adbgPrintLog(_ctx, "dl_PRS_r16 := { ");
		_adbgNrSys__SQN_NR_DL_PRS_Info_r16(_ctx, &p->dl_PRS_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_pathlossReferenceRS_Pos_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_pathlossReferenceRS_Pos_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16* p)
{
	adbgPrintLog(_ctx, "srs_PosResourceSetId_r16 := %u", (unsigned int)p->srs_PosResourceSetId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_PosResourceIdList_r16 := ");
	_adbgNrSys__SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_PosResourceSet_r16_srs_PosResourceIdList_r16_DynamicOptional(_ctx, &p->srs_PosResourceIdList_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceType_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_resourceType_r16(_ctx, &p->resourceType_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "alpha_r16 := ");
	_adbgNrSys__SQN_NR_Alpha_e_SQN_NR_SRS_PosResourceSet_r16_alpha_r16_Optional(_ctx, &p->alpha_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p0_r16 := ");
	_adbgNrSys__Int16_t_SQN_NR_SRS_PosResourceSet_r16_p0_r16_Optional(_ctx, &p->p0_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pathlossReferenceRS_Pos_r16 := ");
	if (p->pathlossReferenceRS_Pos_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_pathlossReferenceRS_Pos_r16_Optional(_ctx, &p->pathlossReferenceRS_Pos_r16);
	if (p->pathlossReferenceRS_Pos_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_SQN_NR_SRS_Config_srs_PosResourceSetToAddModList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceSet_r16_SQN_NR_SRS_Config_srs_PosResourceSetToAddModList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_Config_srs_PosResourceToReleaseList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_Config_srs_PosResourceToReleaseList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16* p)
{
	adbgPrintLog(_ctx, "combOffset_n2_r16 := %u", (unsigned int)p->combOffset_n2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cyclicShift_n2_r16 := %u", (unsigned int)p->cyclicShift_n2_r16);
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16* p)
{
	adbgPrintLog(_ctx, "combOffset_n4_16 := %u", (unsigned int)p->combOffset_n4_16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cyclicShift_n4_r16 := %u", (unsigned int)p->cyclicShift_n4_r16);
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16* p)
{
	adbgPrintLog(_ctx, "combOffset_n8_r16 := %u", (unsigned int)p->combOffset_n8_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cyclicShift_n8_r16 := %u", (unsigned int)p->cyclicShift_n8_r16);
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_PosResource_r16_transmissionComb_r16_Value* p, enum SQN_NR_SRS_PosResource_r16_transmissionComb_r16_Sel d)
{
	if (d == SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16) {
		adbgPrintLog(_ctx, "n2_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16(_ctx, &p->n2_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16) {
		adbgPrintLog(_ctx, "n4_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16(_ctx, &p->n4_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16) {
		adbgPrintLog(_ctx, "n8_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16(_ctx, &p->n8_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e__ToString(SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e v)
{
	switch(v) {
		case SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n1: return "SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n1";
		case SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n2: return "SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n2";
		case SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n4: return "SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n4";
		case SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n8: return "SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n8";
		case SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n12: return "SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e_n12";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceMapping_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_resourceMapping_r16* p)
{
	adbgPrintLog(_ctx, "startPosition_r16 := %u", (unsigned int)p->startPosition_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSymbols_r16 := %s (%d)", adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceMapping_r16_nrofSymbols_r16_e__ToString(p->nrofSymbols_r16), (int)p->nrofSymbols_r16);
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_freqHopping_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_freqHopping_r16* p)
{
	adbgPrintLog(_ctx, "c_SRS_r16 := %u", (unsigned int)p->c_SRS_r16);
}

static const char* adbgNrSys__SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e__ToString(SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e v)
{
	switch(v) {
		case SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e_neither: return "SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e_neither";
		case SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e_groupHopping: return "SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e_groupHopping";
		case SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e_sequenceHopping: return "SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e_sequenceHopping";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16_slotOffset_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16_slotOffset_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16* p)
{
	adbgPrintLog(_ctx, "slotOffset_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16_slotOffset_r16_Optional(_ctx, &p->slotOffset_r16);
}

static void _adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_PeriodicityAndOffset_r16_Value* p, enum SQN_NR_SRS_PeriodicityAndOffset_r16_Sel d)
{
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl1) {
		adbgPrintLog(_ctx, "sl1 := %s", (p->sl1 ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl2) {
		adbgPrintLog(_ctx, "sl2 := %u", (unsigned int)p->sl2);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl4) {
		adbgPrintLog(_ctx, "sl4 := %u", (unsigned int)p->sl4);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl5) {
		adbgPrintLog(_ctx, "sl5 := %u", (unsigned int)p->sl5);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl8) {
		adbgPrintLog(_ctx, "sl8 := %u", (unsigned int)p->sl8);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl10) {
		adbgPrintLog(_ctx, "sl10 := %u", (unsigned int)p->sl10);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl16) {
		adbgPrintLog(_ctx, "sl16 := %u", (unsigned int)p->sl16);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl20) {
		adbgPrintLog(_ctx, "sl20 := %u", (unsigned int)p->sl20);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl32) {
		adbgPrintLog(_ctx, "sl32 := %u", (unsigned int)p->sl32);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl40) {
		adbgPrintLog(_ctx, "sl40 := %u", (unsigned int)p->sl40);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl64) {
		adbgPrintLog(_ctx, "sl64 := %u", (unsigned int)p->sl64);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl80) {
		adbgPrintLog(_ctx, "sl80 := %u", (unsigned int)p->sl80);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl160) {
		adbgPrintLog(_ctx, "sl160 := %u", (unsigned int)p->sl160);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl320) {
		adbgPrintLog(_ctx, "sl320 := %u", (unsigned int)p->sl320);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl640) {
		adbgPrintLog(_ctx, "sl640 := %u", (unsigned int)p->sl640);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl1280) {
		adbgPrintLog(_ctx, "sl1280 := %u", (unsigned int)p->sl1280);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl2560) {
		adbgPrintLog(_ctx, "sl2560 := %u", (unsigned int)p->sl2560);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl5120) {
		adbgPrintLog(_ctx, "sl5120 := %u", (unsigned int)p->sl5120);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl10240) {
		adbgPrintLog(_ctx, "sl10240 := %u", (unsigned int)p->sl10240);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl40960) {
		adbgPrintLog(_ctx, "sl40960 := %u", (unsigned int)p->sl40960);
		return;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl81920) {
		adbgPrintLog(_ctx, "sl81920 := %u", (unsigned int)p->sl81920);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PeriodicityAndOffset_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16* p)
{
	adbgPrintLog(_ctx, "periodicityAndOffset_sp_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset_r16(_ctx, &p->periodicityAndOffset_sp_r16);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16* p)
{
	adbgPrintLog(_ctx, "periodicityAndOffset_p_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_PeriodicityAndOffset_r16(_ctx, &p->periodicityAndOffset_p_r16);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_PosResource_r16_resourceType_r16_Value* p, enum SQN_NR_SRS_PosResource_r16_resourceType_r16_Sel d)
{
	if (d == SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16) {
		adbgPrintLog(_ctx, "aperiodic_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16(_ctx, &p->aperiodic_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16) {
		adbgPrintLog(_ctx, "semi_persistent_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16(_ctx, &p->semi_persistent_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16) {
		adbgPrintLog(_ctx, "periodic_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16(_ctx, &p->periodic_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_servingCellId_Optional(acpCtx_t _ctx, const struct SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_servingCellId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Value* p, enum SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Sel d)
{
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_srs_ResourceId_r16) {
		adbgPrintLog(_ctx, "srs_ResourceId_r16 := %u", (unsigned int)p->srs_ResourceId_r16);
		return;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_srs_PosResourceId_r16) {
		adbgPrintLog(_ctx, "srs_PosResourceId_r16 := %u", (unsigned int)p->srs_PosResourceId_r16);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16* p)
{
	adbgPrintLog(_ctx, "resourceSelection_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16(_ctx, &p->resourceSelection_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uplinkBWP_r16 := %u", (unsigned int)p->uplinkBWP_r16);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Value* p, enum SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Sel d)
{
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_ssb_IndexServing_r16) {
		adbgPrintLog(_ctx, "ssb_IndexServing_r16 := %u", (unsigned int)p->ssb_IndexServing_r16);
		return;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_csi_RS_IndexServing_r16) {
		adbgPrintLog(_ctx, "csi_RS_IndexServing_r16 := %u", (unsigned int)p->csi_RS_IndexServing_r16);
		return;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16) {
		adbgPrintLog(_ctx, "srs_SpatialRelation_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16(_ctx, &p->srs_SpatialRelation_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16* p)
{
	adbgPrintLog(_ctx, "servingCellId := ");
	_adbgNrSys__SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_servingCellId_Optional(_ctx, &p->servingCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSignal_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16(_ctx, &p->referenceSignal_r16);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_Value(acpCtx_t _ctx, const union SQN_NR_SRS_SpatialRelationInfoPos_r16_Value* p, enum SQN_NR_SRS_SpatialRelationInfoPos_r16_Sel d)
{
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16) {
		adbgPrintLog(_ctx, "servingRS_r16 := { ");
		_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16(_ctx, &p->servingRS_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_ssb_Ncell_r16) {
		adbgPrintLog(_ctx, "ssb_Ncell_r16 := { ");
		_adbgNrSys__SQN_NR_SSB_InfoNcell_r16(_ctx, &p->ssb_Ncell_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_dl_PRS_r16) {
		adbgPrintLog(_ctx, "dl_PRS_r16 := { ");
		_adbgNrSys__SQN_NR_DL_PRS_Info_r16(_ctx, &p->dl_PRS_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16* p)
{
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_SQN_NR_SRS_PosResource_r16_spatialRelationInfoPos_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_SQN_NR_SRS_PosResource_r16_spatialRelationInfoPos_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16* p)
{
	adbgPrintLog(_ctx, "srs_PosResourceId_r16 := %u", (unsigned int)p->srs_PosResourceId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "transmissionComb_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_PosResource_r16_transmissionComb_r16(_ctx, &p->transmissionComb_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceMapping_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceMapping_r16(_ctx, &p->resourceMapping_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqDomainShift_r16 := %u", (unsigned int)p->freqDomainShift_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "freqHopping_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_PosResource_r16_freqHopping_r16(_ctx, &p->freqHopping_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "groupOrSequenceHopping_r16 := %s (%d)", adbgNrSys__SQN_NR_SRS_PosResource_r16_groupOrSequenceHopping_r16_e__ToString(p->groupOrSequenceHopping_r16), (int)p->groupOrSequenceHopping_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourceType_r16 := { ");
	_adbgNrSys__SQN_NR_SRS_PosResource_r16_resourceType_r16(_ctx, &p->resourceType_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sequenceId_r16 := %u", (unsigned int)p->sequenceId_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spatialRelationInfoPos_r16 := ");
	if (p->spatialRelationInfoPos_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_SpatialRelationInfoPos_r16_SQN_NR_SRS_PosResource_r16_spatialRelationInfoPos_r16_Optional(_ctx, &p->spatialRelationInfoPos_r16);
	if (p->spatialRelationInfoPos_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SRS_PosResource_r16_SQN_NR_SRS_Config_srs_PosResourceToAddModList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_SRS_PosResource_r16_SQN_NR_SRS_Config_srs_PosResourceToAddModList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SRS_PosResource_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SRS_Config(acpCtx_t _ctx, const struct SQN_NR_SRS_Config* p)
{
	adbgPrintLog(_ctx, "srs_ResourceSetToReleaseList := ");
	_adbgNrSys__SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseList_DynamicOptional(_ctx, &p->srs_ResourceSetToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_ResourceSetToAddModList := ");
	if (p->srs_ResourceSetToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModList_DynamicOptional(_ctx, &p->srs_ResourceSetToAddModList);
	if (p->srs_ResourceSetToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_ResourceToReleaseList := ");
	_adbgNrSys__SQN_NR_SRS_ResourceId_SQN_NR_SRS_Config_srs_ResourceToReleaseList_DynamicOptional(_ctx, &p->srs_ResourceToReleaseList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_ResourceToAddModList := ");
	if (p->srs_ResourceToAddModList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_Resource_SQN_NR_SRS_Config_srs_ResourceToAddModList_DynamicOptional(_ctx, &p->srs_ResourceToAddModList);
	if (p->srs_ResourceToAddModList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tpc_Accumulation := ");
	_adbgNrSys__SQN_NR_SRS_Config_tpc_Accumulation_e_tpc_Accumulation_Optional(_ctx, &p->tpc_Accumulation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_RequestDCI_1_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_1_2_r16_Optional(_ctx, &p->srs_RequestDCI_1_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_RequestDCI_0_2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_0_2_r16_Optional(_ctx, &p->srs_RequestDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_ResourceSetToAddModListDCI_0_2_r16 := ");
	if (p->srs_ResourceSetToAddModListDCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModListDCI_0_2_r16_DynamicOptional(_ctx, &p->srs_ResourceSetToAddModListDCI_0_2_r16);
	if (p->srs_ResourceSetToAddModListDCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_ResourceSetToReleaseListDCI_0_2_r16 := ");
	_adbgNrSys__SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseListDCI_0_2_r16_DynamicOptional(_ctx, &p->srs_ResourceSetToReleaseListDCI_0_2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_PosResourceSetToReleaseList_r16 := ");
	_adbgNrSys__SQN_NR_SRS_PosResourceSetId_r16_SQN_NR_SRS_Config_srs_PosResourceSetToReleaseList_r16_DynamicOptional(_ctx, &p->srs_PosResourceSetToReleaseList_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_PosResourceSetToAddModList_r16 := ");
	if (p->srs_PosResourceSetToAddModList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_PosResourceSet_r16_SQN_NR_SRS_Config_srs_PosResourceSetToAddModList_r16_DynamicOptional(_ctx, &p->srs_PosResourceSetToAddModList_r16);
	if (p->srs_PosResourceSetToAddModList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_PosResourceToReleaseList_r16 := ");
	_adbgNrSys__SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_Config_srs_PosResourceToReleaseList_r16_DynamicOptional(_ctx, &p->srs_PosResourceToReleaseList_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_PosResourceToAddModList_r16 := ");
	if (p->srs_PosResourceToAddModList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SRS_PosResource_r16_SQN_NR_SRS_Config_srs_PosResourceToAddModList_r16_DynamicOptional(_ctx, &p->srs_PosResourceToAddModList_r16);
	if (p->srs_PosResourceToAddModList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_SRS_Config(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_SQN_NR_BWP_UplinkDedicated_srs_Config_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_SQN_NR_BWP_UplinkDedicated_srs_Config_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BeamFailureRecoveryConfig_rootSequenceIndex_BFR_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BeamFailureRecoveryConfig_rootSequenceIndex_BFR_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigGeneric_SQN_NR_BeamFailureRecoveryConfig_rach_ConfigBFR_Optional(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigGeneric_SQN_NR_BeamFailureRecoveryConfig_rach_ConfigBFR_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RACH_ConfigGeneric(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_BeamFailureRecoveryConfig_rsrp_ThresholdSSB_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_Range_SQN_NR_BeamFailureRecoveryConfig_rsrp_ThresholdSSB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_BFR_SSB_Resource(acpCtx_t _ctx, const struct SQN_NR_BFR_SSB_Resource* p)
{
	adbgPrintLog(_ctx, "ssb := %u", (unsigned int)p->ssb);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PreambleIndex := %u", (unsigned int)p->ra_PreambleIndex);
}

static void _adbgNrSys__Uint16_t_SQN_NR_BFR_CSIRS_Resource_ra_OccasionList_DynamicOptional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_BFR_CSIRS_Resource_ra_OccasionList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Uint8_t_SQN_NR_BFR_CSIRS_Resource_ra_PreambleIndex_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BFR_CSIRS_Resource_ra_PreambleIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_BFR_CSIRS_Resource(acpCtx_t _ctx, const struct SQN_NR_BFR_CSIRS_Resource* p)
{
	adbgPrintLog(_ctx, "csi_RS := %u", (unsigned int)p->csi_RS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_OccasionList := ");
	_adbgNrSys__Uint16_t_SQN_NR_BFR_CSIRS_Resource_ra_OccasionList_DynamicOptional(_ctx, &p->ra_OccasionList);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PreambleIndex := ");
	_adbgNrSys__Uint8_t_SQN_NR_BFR_CSIRS_Resource_ra_PreambleIndex_Optional(_ctx, &p->ra_PreambleIndex);
}

static void _adbgNrSys__SQN_NR_PRACH_ResourceDedicatedBFR_Value(acpCtx_t _ctx, const union SQN_NR_PRACH_ResourceDedicatedBFR_Value* p, enum SQN_NR_PRACH_ResourceDedicatedBFR_Sel d)
{
	if (d == SQN_NR_PRACH_ResourceDedicatedBFR_ssb) {
		adbgPrintLog(_ctx, "ssb := { ");
		_adbgNrSys__SQN_NR_BFR_SSB_Resource(_ctx, &p->ssb);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PRACH_ResourceDedicatedBFR_csi_RS) {
		adbgPrintLog(_ctx, "csi_RS := { ");
		_adbgNrSys__SQN_NR_BFR_CSIRS_Resource(_ctx, &p->csi_RS);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_PRACH_ResourceDedicatedBFR(acpCtx_t _ctx, const struct SQN_NR_PRACH_ResourceDedicatedBFR* p)
{
	_adbgNrSys__SQN_NR_PRACH_ResourceDedicatedBFR_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_PRACH_ResourceDedicatedBFR_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSList_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PRACH_ResourceDedicatedBFR_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSList_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PRACH_ResourceDedicatedBFR(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e__ToString(SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e v)
{
	switch(v) {
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_oneEighth: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_oneEighth";
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_oneFourth: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_oneFourth";
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_oneHalf: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_oneHalf";
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_one: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_one";
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_two: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_two";
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_four: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_four";
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_eight: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_eight";
		case SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_sixteen: return "SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_sixteen";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(acpCtx_t _ctx, const struct SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BeamFailureRecoveryConfig_ra_ssb_OccasionMaskIndex_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BeamFailureRecoveryConfig_ra_ssb_OccasionMaskIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SearchSpaceId_SQN_NR_BeamFailureRecoveryConfig_recoverySearchSpaceId_Optional(acpCtx_t _ctx, const struct SQN_NR_SearchSpaceId_SQN_NR_BeamFailureRecoveryConfig_recoverySearchSpaceId_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_Prioritization_Optional(acpCtx_t _ctx, const struct SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_Prioritization_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RA_Prioritization(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e__ToString(SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e v)
{
	switch(v) {
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms10: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms10";
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms20: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms20";
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms40: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms40";
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms60: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms60";
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms80: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms80";
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms100: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms100";
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms150: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms150";
		case SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms200: return "SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_ms200";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_beamFailureRecoveryTimer_Optional(acpCtx_t _ctx, const struct SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_beamFailureRecoveryTimer_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_BeamFailureRecoveryConfig_msg1_SubcarrierSpacing_Optional(acpCtx_t _ctx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_BeamFailureRecoveryConfig_msg1_SubcarrierSpacing_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_PrioritizationTwoStep_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_PrioritizationTwoStep_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RA_Prioritization(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Value* p, enum SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Sel d)
{
	if (d == SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PRACH_ResourceDedicatedBFR(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_BeamFailureRecoveryConfig(acpCtx_t _ctx, const struct SQN_NR_BeamFailureRecoveryConfig* p)
{
	adbgPrintLog(_ctx, "rootSequenceIndex_BFR := ");
	_adbgNrSys__Uint8_t_SQN_NR_BeamFailureRecoveryConfig_rootSequenceIndex_BFR_Optional(_ctx, &p->rootSequenceIndex_BFR);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rach_ConfigBFR := ");
	if (p->rach_ConfigBFR.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RACH_ConfigGeneric_SQN_NR_BeamFailureRecoveryConfig_rach_ConfigBFR_Optional(_ctx, &p->rach_ConfigBFR);
	if (p->rach_ConfigBFR.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rsrp_ThresholdSSB := ");
	_adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_BeamFailureRecoveryConfig_rsrp_ThresholdSSB_Optional(_ctx, &p->rsrp_ThresholdSSB);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "candidateBeamRSList := ");
	if (p->candidateBeamRSList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_PRACH_ResourceDedicatedBFR_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSList_DynamicOptional(_ctx, &p->candidateBeamRSList);
	if (p->candidateBeamRSList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_perRACH_Occasion := ");
	_adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(_ctx, &p->ssb_perRACH_Occasion);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ssb_OccasionMaskIndex := ");
	_adbgNrSys__Uint8_t_SQN_NR_BeamFailureRecoveryConfig_ra_ssb_OccasionMaskIndex_Optional(_ctx, &p->ra_ssb_OccasionMaskIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "recoverySearchSpaceId := ");
	_adbgNrSys__SQN_NR_SearchSpaceId_SQN_NR_BeamFailureRecoveryConfig_recoverySearchSpaceId_Optional(_ctx, &p->recoverySearchSpaceId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_Prioritization := ");
	if (p->ra_Prioritization.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_Prioritization_Optional(_ctx, &p->ra_Prioritization);
	if (p->ra_Prioritization.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "beamFailureRecoveryTimer := ");
	_adbgNrSys__SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_beamFailureRecoveryTimer_Optional(_ctx, &p->beamFailureRecoveryTimer);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msg1_SubcarrierSpacing := ");
	_adbgNrSys__SQN_NR_SubcarrierSpacing_e_SQN_NR_BeamFailureRecoveryConfig_msg1_SubcarrierSpacing_Optional(_ctx, &p->msg1_SubcarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PrioritizationTwoStep_r16 := ");
	if (p->ra_PrioritizationTwoStep_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_PrioritizationTwoStep_r16_Optional(_ctx, &p->ra_PrioritizationTwoStep_r16);
	if (p->ra_PrioritizationTwoStep_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "candidateBeamRSListExt_v1610 := ");
	if (p->candidateBeamRSListExt_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Optional(_ctx, &p->candidateBeamRSListExt_v1610);
	if (p->candidateBeamRSListExt_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_BeamFailureRecoveryConfig(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_SQN_NR_BWP_UplinkDedicated_beamFailureRecoveryConfig_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_SQN_NR_BWP_UplinkDedicated_beamFailureRecoveryConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUCCH_Config(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_SQN_NR_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_SQN_NR_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC2_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC3_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC3_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e__ToString(SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e v)
{
	switch(v) {
		case SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_enabled: return "SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_enabled";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			adbgPrintLog(_ctx, "{ ");
			_adbgNrSys__SQN_NR_PUCCH_Config(_ctx, &p->setup.v[i2]);
			adbgPrintLog(_ctx, " }");
			if (i2 != p->setup.d - 1) { adbgPrintLog(_ctx, ", "); }
		}
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_SQN_NR_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_SQN_NR_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e__ToString(SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e v)
{
	switch(v) {
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n4: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n4";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n8: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n8";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n16: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n16";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n32: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n32";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n64: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n64";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n128: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e_n128";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e__ToString(SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e v)
{
	switch(v) {
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms10: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms10";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms20: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms20";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms40: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms40";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms80: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms80";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms160: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms160";
		case SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms320: return "SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e_ms320";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_LBT_FailureRecoveryConfig_r16(acpCtx_t _ctx, const struct SQN_NR_LBT_FailureRecoveryConfig_r16* p)
{
	adbgPrintLog(_ctx, "lbt_FailureInstanceMaxCount_r16 := %s (%d)", adbgNrSys__SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureInstanceMaxCount_r16_e__ToString(p->lbt_FailureInstanceMaxCount_r16), (int)p->lbt_FailureInstanceMaxCount_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lbt_FailureDetectionTimer_r16 := %s (%d)", adbgNrSys__SQN_NR_LBT_FailureRecoveryConfig_r16_lbt_FailureDetectionTimer_r16_e__ToString(p->lbt_FailureDetectionTimer_r16), (int)p->lbt_FailureDetectionTimer_r16);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_LBT_FailureRecoveryConfig_r16(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_SQN_NR_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_SQN_NR_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfigToAddModList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToAddModList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfigToAddModList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToAddModList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_ConfiguredGrantConfig(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfigToReleaseList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToReleaseList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfigToReleaseList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToReleaseList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_ConfiguredGrantConfigType2DeactivationStateList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigType2DeactivationStateList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ConfiguredGrantConfigType2DeactivationStateList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigType2DeactivationStateList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "'");
		for (size_t i3 = 0; i3 < p->v.v[i2].d; i3++) {
			adbgPrintLog(_ctx, "%02X", p->v.v[i2].v[i3]);
		}
		adbgPrintLog(_ctx, "'O");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_BWP_UplinkDedicated(acpCtx_t _ctx, const struct SQN_NR_BWP_UplinkDedicated* p)
{
	adbgPrintLog(_ctx, "pucch_Config := ");
	if (p->pucch_Config.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_SQN_NR_BWP_UplinkDedicated_pucch_Config_Optional(_ctx, &p->pucch_Config);
	if (p->pucch_Config.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pusch_Config := ");
	if (p->pusch_Config.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_SQN_NR_BWP_UplinkDedicated_pusch_Config_Optional(_ctx, &p->pusch_Config);
	if (p->pusch_Config.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "configuredGrantConfig := ");
	if (p->configuredGrantConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_SQN_NR_BWP_UplinkDedicated_configuredGrantConfig_Optional(_ctx, &p->configuredGrantConfig);
	if (p->configuredGrantConfig.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "srs_Config := ");
	if (p->srs_Config.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_SQN_NR_BWP_UplinkDedicated_srs_Config_Optional(_ctx, &p->srs_Config);
	if (p->srs_Config.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "beamFailureRecoveryConfig := ");
	if (p->beamFailureRecoveryConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_SQN_NR_BWP_UplinkDedicated_beamFailureRecoveryConfig_Optional(_ctx, &p->beamFailureRecoveryConfig);
	if (p->beamFailureRecoveryConfig.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_PUCCH_Config_r16 := ");
	if (p->sl_PUCCH_Config_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_SQN_NR_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Optional(_ctx, &p->sl_PUCCH_Config_r16);
	if (p->sl_PUCCH_Config_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cp_ExtensionC2_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC2_r16_Optional(_ctx, &p->cp_ExtensionC2_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cp_ExtensionC3_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC3_r16_Optional(_ctx, &p->cp_ExtensionC3_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "useInterlacePUCCH_PUSCH_r16 := ");
	_adbgNrSys__SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(_ctx, &p->useInterlacePUCCH_PUSCH_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pucch_ConfigurationList_r16 := ");
	if (p->pucch_ConfigurationList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_SQN_NR_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Optional(_ctx, &p->pucch_ConfigurationList_r16);
	if (p->pucch_ConfigurationList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lbt_FailureRecoveryConfig_r16 := ");
	if (p->lbt_FailureRecoveryConfig_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_SQN_NR_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Optional(_ctx, &p->lbt_FailureRecoveryConfig_r16);
	if (p->lbt_FailureRecoveryConfig_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "configuredGrantConfigToAddModList_r16 := ");
	if (p->configuredGrantConfigToAddModList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ConfiguredGrantConfigToAddModList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToAddModList_r16_Optional(_ctx, &p->configuredGrantConfigToAddModList_r16);
	if (p->configuredGrantConfigToAddModList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "configuredGrantConfigToReleaseList_r16 := ");
	if (p->configuredGrantConfigToReleaseList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ConfiguredGrantConfigToReleaseList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToReleaseList_r16_Optional(_ctx, &p->configuredGrantConfigToReleaseList_r16);
	if (p->configuredGrantConfigToReleaseList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "configuredGrantConfigType2DeactivationStateList_r16 := ");
	if (p->configuredGrantConfigType2DeactivationStateList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ConfiguredGrantConfigType2DeactivationStateList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigType2DeactivationStateList_r16_Optional(_ctx, &p->configuredGrantConfigType2DeactivationStateList_r16);
	if (p->configuredGrantConfigType2DeactivationStateList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_BWP_UplinkDedicated_Type_Value(acpCtx_t _ctx, const union NR_ASN1_BWP_UplinkDedicated_Type_Value* p, enum NR_ASN1_BWP_UplinkDedicated_Type_Sel d)
{
	if (d == NR_ASN1_BWP_UplinkDedicated_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_BWP_UplinkDedicated(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_BWP_UplinkDedicated_Type(acpCtx_t _ctx, const struct NR_ASN1_BWP_UplinkDedicated_Type* p)
{
	_adbgNrSys__NR_ASN1_BWP_UplinkDedicated_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_BWP_UplinkDedicated_Type_Dedicated_Optional(acpCtx_t _ctx, const struct NR_ASN1_BWP_UplinkDedicated_Type_Dedicated_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_BWP_UplinkDedicated_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_UplinkBWP_Type(acpCtx_t _ctx, const struct NR_UplinkBWP_Type* p)
{
	adbgPrintLog(_ctx, "Id := ");
	_adbgNrSys__SQN_NR_BWP_Id_NR_UplinkBWP_Type_Id_Optional(_ctx, &p->Id);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Common := ");
	if (p->Common.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_BWP_UplinkCommon_Type_Common_Optional(_ctx, &p->Common);
	if (p->Common.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Dedicated := ");
	if (p->Dedicated.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_BWP_UplinkDedicated_Type_Dedicated_Optional(_ctx, &p->Dedicated);
	if (p->Dedicated.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_UplinkBWP_List_Type_BwpArray_Optional(acpCtx_t _ctx, const struct NR_UplinkBWP_List_Type_BwpArray_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_UplinkBWP_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_UplinkBWPs_Type(acpCtx_t _ctx, const struct NR_UplinkBWPs_Type* p)
{
	adbgPrintLog(_ctx, "ActiveBWP := ");
	if (p->ActiveBWP.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ActiveUplinkBWP_Id_Type_ActiveBWP_Optional(_ctx, &p->ActiveBWP);
	if (p->ActiveBWP.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BwpArray := ");
	if (p->BwpArray.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_UplinkBWP_List_Type_BwpArray_Optional(_ctx, &p->BwpArray);
	if (p->BwpArray.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_UplinkBWPs_Type_BWPs_Optional(acpCtx_t _ctx, const struct NR_UplinkBWPs_Type_BWPs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_UplinkBWPs_Type(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e__ToString(SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e v)
{
	switch(v) {
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_oneEighth: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_oneEighth";
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_oneFourth: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_oneFourth";
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_oneHalf: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_oneHalf";
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_one: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_one";
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_two: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_two";
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_four: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_four";
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_eight: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_eight";
		case SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_sixteen: return "SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_sixteen";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(acpCtx_t _ctx, const struct SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_CFRA_occasions(acpCtx_t _ctx, const struct SQN_NR_CFRA_occasions* p)
{
	adbgPrintLog(_ctx, "rach_ConfigGeneric := { ");
	_adbgNrSys__SQN_NR_RACH_ConfigGeneric(_ctx, &p->rach_ConfigGeneric);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_perRACH_Occasion := ");
	_adbgNrSys__SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(_ctx, &p->ssb_perRACH_Occasion);
}

static void _adbgNrSys__SQN_NR_CFRA_occasions_occasions_Optional(acpCtx_t _ctx, const struct SQN_NR_CFRA_occasions_occasions_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CFRA_occasions(_ctx, &p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_CFRA_SSB_Resource_msgA_PUSCH_resource_Index_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_CFRA_SSB_Resource_msgA_PUSCH_resource_Index_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_CFRA_SSB_Resource(acpCtx_t _ctx, const struct SQN_NR_CFRA_SSB_Resource* p)
{
	adbgPrintLog(_ctx, "ssb := %u", (unsigned int)p->ssb);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PreambleIndex := %u", (unsigned int)p->ra_PreambleIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_PUSCH_resource_Index_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_CFRA_SSB_Resource_msgA_PUSCH_resource_Index_r16_Optional(_ctx, &p->msgA_PUSCH_resource_Index_r16);
}

static void _adbgNrSys__SQN_NR_CFRA_resources_ssb(acpCtx_t _ctx, const struct SQN_NR_CFRA_resources_ssb* p)
{
	adbgPrintLog(_ctx, "ssb_ResourceList := { ");
	for (size_t i1 = 0; i1 < p->ssb_ResourceList.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_CFRA_SSB_Resource(_ctx, &p->ssb_ResourceList.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->ssb_ResourceList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ssb_OccasionMaskIndex := %u", (unsigned int)p->ra_ssb_OccasionMaskIndex);
}

static void _adbgNrSys__SQN_NR_CFRA_CSIRS_Resource(acpCtx_t _ctx, const struct SQN_NR_CFRA_CSIRS_Resource* p)
{
	adbgPrintLog(_ctx, "csi_RS := %u", (unsigned int)p->csi_RS);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_OccasionList := '");
	for (size_t i2 = 0; i2 < p->ra_OccasionList.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->ra_OccasionList.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PreambleIndex := %u", (unsigned int)p->ra_PreambleIndex);
}

static void _adbgNrSys__SQN_NR_CFRA_resources_csirs(acpCtx_t _ctx, const struct SQN_NR_CFRA_resources_csirs* p)
{
	adbgPrintLog(_ctx, "csirs_ResourceList := { ");
	for (size_t i1 = 0; i1 < p->csirs_ResourceList.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_CFRA_CSIRS_Resource(_ctx, &p->csirs_ResourceList.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->csirs_ResourceList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rsrp_ThresholdCSI_RS := %u", (unsigned int)p->rsrp_ThresholdCSI_RS);
}

static void _adbgNrSys__SQN_NR_CFRA_resources_Value(acpCtx_t _ctx, const union SQN_NR_CFRA_resources_Value* p, enum SQN_NR_CFRA_resources_Sel d)
{
	if (d == SQN_NR_CFRA_resources_ssb) {
		adbgPrintLog(_ctx, "ssb := { ");
		_adbgNrSys__SQN_NR_CFRA_resources_ssb(_ctx, &p->ssb);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_CFRA_resources_csirs) {
		adbgPrintLog(_ctx, "csirs := { ");
		_adbgNrSys__SQN_NR_CFRA_resources_csirs(_ctx, &p->csirs);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_CFRA_resources(acpCtx_t _ctx, const struct SQN_NR_CFRA_resources* p)
{
	_adbgNrSys__SQN_NR_CFRA_resources_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__Uint8_t_SQN_NR_CFRA_totalNumberOfRA_Preambles_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_CFRA_totalNumberOfRA_Preambles_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_CFRA(acpCtx_t _ctx, const struct SQN_NR_CFRA* p)
{
	adbgPrintLog(_ctx, "occasions := ");
	if (p->occasions.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CFRA_occasions_occasions_Optional(_ctx, &p->occasions);
	if (p->occasions.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resources := { ");
	_adbgNrSys__SQN_NR_CFRA_resources(_ctx, &p->resources);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "totalNumberOfRA_Preambles := ");
	_adbgNrSys__Uint8_t_SQN_NR_CFRA_totalNumberOfRA_Preambles_Optional(_ctx, &p->totalNumberOfRA_Preambles);
}

static void _adbgNrSys__SQN_NR_CFRA_SQN_NR_RACH_ConfigDedicated_cfra_Optional(acpCtx_t _ctx, const struct SQN_NR_CFRA_SQN_NR_RACH_ConfigDedicated_cfra_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CFRA(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_Prioritization_Optional(acpCtx_t _ctx, const struct SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_Prioritization_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RA_Prioritization(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_PrioritizationTwoStep_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_PrioritizationTwoStep_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_RA_Prioritization(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e__ToString(SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e v)
{
	switch(v) {
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_oneEighth: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_oneEighth";
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_oneFourth: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_oneFourth";
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_oneHalf: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_oneHalf";
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_one: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_one";
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_two: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_two";
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_four: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_four";
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_eight: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_eight";
		case SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_sixteen: return "SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e_sixteen";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16(acpCtx_t _ctx, const struct SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16* p)
{
	adbgPrintLog(_ctx, "rach_ConfigGenericTwoStepRA_r16 := { ");
	_adbgNrSys__SQN_NR_RACH_ConfigGenericTwoStepRA_r16(_ctx, &p->rach_ConfigGenericTwoStepRA_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_PerRACH_OccasionTwoStepRA_r16 := %s (%d)", adbgNrSys__SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_ssb_PerRACH_OccasionTwoStepRA_r16_e__ToString(p->ssb_PerRACH_OccasionTwoStepRA_r16), (int)p->ssb_PerRACH_OccasionTwoStepRA_r16);
}

static void _adbgNrSys__SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_occasionsTwoStepRA_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_occasionsTwoStepRA_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e__ToString(SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e v)
{
	switch(v) {
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n1: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n1";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n2: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n2";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n4: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n4";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n6: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n6";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n8: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n8";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n10: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n10";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n20: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n20";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n50: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n50";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n100: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n100";
		case SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n200: return "SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_n200";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_CFRA_TwoStep_r16_resourcesTwoStep_r16(acpCtx_t _ctx, const struct SQN_NR_CFRA_TwoStep_r16_resourcesTwoStep_r16* p)
{
	adbgPrintLog(_ctx, "ssb_ResourceList := { ");
	for (size_t i1 = 0; i1 < p->ssb_ResourceList.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_CFRA_SSB_Resource(_ctx, &p->ssb_ResourceList.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->ssb_ResourceList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ssb_OccasionMaskIndex := %u", (unsigned int)p->ra_ssb_OccasionMaskIndex);
}

static void _adbgNrSys__SQN_NR_CFRA_TwoStep_r16(acpCtx_t _ctx, const struct SQN_NR_CFRA_TwoStep_r16* p)
{
	adbgPrintLog(_ctx, "occasionsTwoStepRA_r16 := ");
	if (p->occasionsTwoStepRA_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_occasionsTwoStepRA_r16_Optional(_ctx, &p->occasionsTwoStepRA_r16);
	if (p->occasionsTwoStepRA_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_CFRA_PUSCH_r16 := { ");
	_adbgNrSys__SQN_NR_MsgA_PUSCH_Resource_r16(_ctx, &p->msgA_CFRA_PUSCH_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "msgA_TransMax_r16 := ");
	_adbgNrSys__SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(_ctx, &p->msgA_TransMax_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "resourcesTwoStep_r16 := { ");
	_adbgNrSys__SQN_NR_CFRA_TwoStep_r16_resourcesTwoStep_r16(_ctx, &p->resourcesTwoStep_r16);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_CFRA_TwoStep_r16_SQN_NR_RACH_ConfigDedicated_cfra_TwoStep_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_CFRA_TwoStep_r16_SQN_NR_RACH_ConfigDedicated_cfra_TwoStep_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CFRA_TwoStep_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_RACH_ConfigDedicated(acpCtx_t _ctx, const struct SQN_NR_RACH_ConfigDedicated* p)
{
	adbgPrintLog(_ctx, "cfra := ");
	if (p->cfra.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CFRA_SQN_NR_RACH_ConfigDedicated_cfra_Optional(_ctx, &p->cfra);
	if (p->cfra.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_Prioritization := ");
	if (p->ra_Prioritization.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_Prioritization_Optional(_ctx, &p->ra_Prioritization);
	if (p->ra_Prioritization.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_PrioritizationTwoStep_r16 := ");
	if (p->ra_PrioritizationTwoStep_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_PrioritizationTwoStep_r16_Optional(_ctx, &p->ra_PrioritizationTwoStep_r16);
	if (p->ra_PrioritizationTwoStep_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cfra_TwoStep_r16 := ");
	if (p->cfra_TwoStep_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CFRA_TwoStep_r16_SQN_NR_RACH_ConfigDedicated_cfra_TwoStep_r16_Optional(_ctx, &p->cfra_TwoStep_r16);
	if (p->cfra_TwoStep_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_RACH_ConfigDedicated_Type_Value(acpCtx_t _ctx, const union NR_ASN1_RACH_ConfigDedicated_Type_Value* p, enum NR_ASN1_RACH_ConfigDedicated_Type_Sel d)
{
	if (d == NR_ASN1_RACH_ConfigDedicated_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_RACH_ConfigDedicated(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_RACH_ConfigDedicated_Type(acpCtx_t _ctx, const struct NR_ASN1_RACH_ConfigDedicated_Type* p)
{
	_adbgNrSys__NR_ASN1_RACH_ConfigDedicated_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_RACH_ConfigDedicated_Type_RACH_ConfigDedicated_Optional(acpCtx_t _ctx, const struct NR_ASN1_RACH_ConfigDedicated_Type_RACH_ConfigDedicated_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_RACH_ConfigDedicated_Type(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e__ToString(SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e v)
{
	switch(v) {
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_oneEighth: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_oneEighth";
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_oneFourth: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_oneFourth";
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_oneHalf: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_oneHalf";
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_one: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_one";
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_two: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_two";
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_four: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_four";
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_eight: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_eight";
		case SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_sixteen: return "SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e_sixteen";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SI_RequestConfig_rach_OccasionsSI(acpCtx_t _ctx, const struct SQN_NR_SI_RequestConfig_rach_OccasionsSI* p)
{
	adbgPrintLog(_ctx, "rach_ConfigSI := { ");
	_adbgNrSys__SQN_NR_RACH_ConfigGeneric(_ctx, &p->rach_ConfigSI);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_perRACH_Occasion := %s (%d)", adbgNrSys__SQN_NR_SI_RequestConfig_rach_OccasionsSI_ssb_perRACH_Occasion_e__ToString(p->ssb_perRACH_Occasion), (int)p->ssb_perRACH_Occasion);
}

static void _adbgNrSys__SQN_NR_SI_RequestConfig_rach_OccasionsSI_rach_OccasionsSI_Optional(acpCtx_t _ctx, const struct SQN_NR_SI_RequestConfig_rach_OccasionsSI_rach_OccasionsSI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SI_RequestConfig_rach_OccasionsSI(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SI_RequestConfig_si_RequestPeriod_e__ToString(SQN_NR_SI_RequestConfig_si_RequestPeriod_e v)
{
	switch(v) {
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_one: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_one";
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_two: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_two";
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_four: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_four";
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_six: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_six";
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_eight: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_eight";
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_ten: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_ten";
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_twelve: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_twelve";
		case SQN_NR_SI_RequestConfig_si_RequestPeriod_e_sixteen: return "SQN_NR_SI_RequestConfig_si_RequestPeriod_e_sixteen";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SI_RequestConfig_si_RequestPeriod_e_si_RequestPeriod_Optional(acpCtx_t _ctx, const struct SQN_NR_SI_RequestConfig_si_RequestPeriod_e_si_RequestPeriod_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SI_RequestConfig_si_RequestPeriod_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SI_RequestResources_ra_AssociationPeriodIndex_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SI_RequestResources_ra_AssociationPeriodIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SI_RequestResources_ra_ssb_OccasionMaskIndex_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SI_RequestResources_ra_ssb_OccasionMaskIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SI_RequestResources(acpCtx_t _ctx, const struct SQN_NR_SI_RequestResources* p)
{
	adbgPrintLog(_ctx, "ra_PreambleStartIndex := %u", (unsigned int)p->ra_PreambleStartIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_AssociationPeriodIndex := ");
	_adbgNrSys__Uint8_t_SQN_NR_SI_RequestResources_ra_AssociationPeriodIndex_Optional(_ctx, &p->ra_AssociationPeriodIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ra_ssb_OccasionMaskIndex := ");
	_adbgNrSys__Uint8_t_SQN_NR_SI_RequestResources_ra_ssb_OccasionMaskIndex_Optional(_ctx, &p->ra_ssb_OccasionMaskIndex);
}

static void _adbgNrSys__SQN_NR_SI_RequestConfig(acpCtx_t _ctx, const struct SQN_NR_SI_RequestConfig* p)
{
	adbgPrintLog(_ctx, "rach_OccasionsSI := ");
	if (p->rach_OccasionsSI.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SI_RequestConfig_rach_OccasionsSI_rach_OccasionsSI_Optional(_ctx, &p->rach_OccasionsSI);
	if (p->rach_OccasionsSI.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "si_RequestPeriod := ");
	_adbgNrSys__SQN_NR_SI_RequestConfig_si_RequestPeriod_e_si_RequestPeriod_Optional(_ctx, &p->si_RequestPeriod);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "si_RequestResources := { ");
	for (size_t i1 = 0; i1 < p->si_RequestResources.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SI_RequestResources(_ctx, &p->si_RequestResources.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->si_RequestResources.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__NR_ASN1_SI_RequestConfig_Type_Value(acpCtx_t _ctx, const union NR_ASN1_SI_RequestConfig_Type_Value* p, enum NR_ASN1_SI_RequestConfig_Type_Sel d)
{
	if (d == NR_ASN1_SI_RequestConfig_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_SI_RequestConfig(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_SI_RequestConfig_Type(acpCtx_t _ctx, const struct NR_ASN1_SI_RequestConfig_Type* p)
{
	_adbgNrSys__NR_ASN1_SI_RequestConfig_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_SI_RequestConfig_Type_SI_RequestConfig_Optional(acpCtx_t _ctx, const struct NR_ASN1_SI_RequestConfig_Type_SI_RequestConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_SI_RequestConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_UplinkConfig_Type(acpCtx_t _ctx, const struct NR_UplinkConfig_Type* p)
{
	adbgPrintLog(_ctx, "FrequencyInfoUL := ");
	if (p->FrequencyInfoUL.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_FrequencyInfoUL_Type_FrequencyInfoUL_Optional(_ctx, &p->FrequencyInfoUL);
	if (p->FrequencyInfoUL.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BWPs := ");
	if (p->BWPs.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_UplinkBWPs_Type_BWPs_Optional(_ctx, &p->BWPs);
	if (p->BWPs.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RACH_ConfigDedicated := ");
	if (p->RACH_ConfigDedicated.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_RACH_ConfigDedicated_Type_RACH_ConfigDedicated_Optional(_ctx, &p->RACH_ConfigDedicated);
	if (p->RACH_ConfigDedicated.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SI_RequestConfig := ");
	if (p->SI_RequestConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_SI_RequestConfig_Type_SI_RequestConfig_Optional(_ctx, &p->SI_RequestConfig);
	if (p->SI_RequestConfig.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_Uplink_Type_Value(acpCtx_t _ctx, const union NR_Uplink_Type_Value* p, enum NR_Uplink_Type_Sel d)
{
	if (d == NR_Uplink_Type_Config) {
		adbgPrintLog(_ctx, "Config := { ");
		_adbgNrSys__NR_UplinkConfig_Type(_ctx, &p->Config);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_Uplink_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_Uplink_Type(acpCtx_t _ctx, const struct NR_Uplink_Type* p)
{
	_adbgNrSys__NR_Uplink_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_Uplink_Type_Uplink_Optional(acpCtx_t _ctx, const struct NR_Uplink_Type_Uplink_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_Uplink_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_Uplink_Type_SupplementaryUplink_Optional(acpCtx_t _ctx, const struct NR_Uplink_Type_SupplementaryUplink_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_Uplink_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_SS_TimingAdvanceConfig_Type_Value(acpCtx_t _ctx, const union NR_SS_TimingAdvanceConfig_Type_Value* p, enum NR_SS_TimingAdvanceConfig_Type_Sel d)
{
	if (d == NR_SS_TimingAdvanceConfig_Type_InitialValue) {
		adbgPrintLog(_ctx, "InitialValue := %u", (unsigned int)p->InitialValue);
		return;
	}
	if (d == NR_SS_TimingAdvanceConfig_Type_Relative) {
		adbgPrintLog(_ctx, "Relative := %u", (unsigned int)p->Relative);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_SS_TimingAdvanceConfig_Type(acpCtx_t _ctx, const struct NR_SS_TimingAdvanceConfig_Type* p)
{
	_adbgNrSys__NR_SS_TimingAdvanceConfig_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_SS_TimingAdvanceConfig_Type_TimingAdvance_Optional(acpCtx_t _ctx, const struct NR_SS_TimingAdvanceConfig_Type_TimingAdvance_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SS_TimingAdvanceConfig_Type(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e__ToString(SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n2: return "SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n2";
		case SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n4: return "SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n4";
		case SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n6: return "SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n6";
		case SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n8: return "SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_CodeBlockGroupTransmission(acpCtx_t _ctx, const struct SQN_NR_PUSCH_CodeBlockGroupTransmission* p)
{
	adbgPrintLog(_ctx, "maxCodeBlockGroupsPerTransportBlock := %s (%d)", adbgNrSys__SQN_NR_PUSCH_CodeBlockGroupTransmission_maxCodeBlockGroupsPerTransportBlock_e__ToString(p->maxCodeBlockGroupsPerTransportBlock), (int)p->maxCodeBlockGroupsPerTransportBlock);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Value* p, enum SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_setup) {
		adbgPrintLog(_ctx, "setup := { ");
		_adbgNrSys__SQN_NR_PUSCH_CodeBlockGroupTransmission(_ctx, &p->setup);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_rateMatching_e__ToString(SQN_NR_PUSCH_ServingCellConfig_rateMatching_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_ServingCellConfig_rateMatching_e_limitedBufferRM: return "SQN_NR_PUSCH_ServingCellConfig_rateMatching_e_limitedBufferRM";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_rateMatching_e_rateMatching_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_ServingCellConfig_rateMatching_e_rateMatching_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_rateMatching_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_xOverhead_e__ToString(SQN_NR_PUSCH_ServingCellConfig_xOverhead_e v)
{
	switch(v) {
		case SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xoh6: return "SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xoh6";
		case SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xoh12: return "SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xoh12";
		case SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xoh18: return "SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xoh18";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(acpCtx_t _ctx, const struct SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_xOverhead_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_Layers_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_Layers_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Bool_SQN_NR_PUSCH_ServingCellConfig_processingType2Enabled_Optional(acpCtx_t _ctx, const struct bool_SQN_NR_PUSCH_ServingCellConfig_processingType2Enabled_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Value(acpCtx_t _ctx, const union SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Sel d)
{
	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_release) {
		adbgPrintLog(_ctx, "release := %s", (p->release ? "true" : "false"));
		return;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_setup) {
		adbgPrintLog(_ctx, "setup := %u", (unsigned int)p->setup);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16* p)
{
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PUSCH_ServingCellConfig(acpCtx_t _ctx, const struct SQN_NR_PUSCH_ServingCellConfig* p)
{
	adbgPrintLog(_ctx, "codeBlockGroupTransmission := ");
	if (p->codeBlockGroupTransmission.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(_ctx, &p->codeBlockGroupTransmission);
	if (p->codeBlockGroupTransmission.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rateMatching := ");
	_adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_rateMatching_e_rateMatching_Optional(_ctx, &p->rateMatching);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "xOverhead := ");
	_adbgNrSys__SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(_ctx, &p->xOverhead);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxMIMO_Layers := ");
	_adbgNrSys__Uint8_t_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_Layers_Optional(_ctx, &p->maxMIMO_Layers);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "processingType2Enabled := ");
	_adbgNrSys__Bool_SQN_NR_PUSCH_ServingCellConfig_processingType2Enabled_Optional(_ctx, &p->processingType2Enabled);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxMIMO_LayersDCI_0_2_r16 := ");
	if (p->maxMIMO_LayersDCI_0_2_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Optional(_ctx, &p->maxMIMO_LayersDCI_0_2_r16);
	if (p->maxMIMO_LayersDCI_0_2_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type_Value(acpCtx_t _ctx, const union NR_ASN1_PUSCH_ServingCellConfig_Type_Value* p, enum NR_ASN1_PUSCH_ServingCellConfig_Type_Sel d)
{
	if (d == NR_ASN1_PUSCH_ServingCellConfig_Type_R15) {
		adbgPrintLog(_ctx, "R15 := { ");
		_adbgNrSys__SQN_NR_PUSCH_ServingCellConfig(_ctx, &p->R15);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type(acpCtx_t _ctx, const struct NR_ASN1_PUSCH_ServingCellConfig_Type* p)
{
	_adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfig_Optional(acpCtx_t _ctx, const struct NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfigSUL_Optional(acpCtx_t _ctx, const struct NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfigSUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_CellConfigPhysicalLayerUplink_Type(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayerUplink_Type* p)
{
	adbgPrintLog(_ctx, "Uplink := ");
	if (p->Uplink.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_Uplink_Type_Uplink_Optional(_ctx, &p->Uplink);
	if (p->Uplink.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SupplementaryUplink := ");
	if (p->SupplementaryUplink.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_Uplink_Type_SupplementaryUplink_Optional(_ctx, &p->SupplementaryUplink);
	if (p->SupplementaryUplink.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TimingAdvance := ");
	if (p->TimingAdvance.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SS_TimingAdvanceConfig_Type_TimingAdvance_Optional(_ctx, &p->TimingAdvance);
	if (p->TimingAdvance.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PUSCH_ServingCellConfig := ");
	if (p->PUSCH_ServingCellConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfig_Optional(_ctx, &p->PUSCH_ServingCellConfig);
	if (p->PUSCH_ServingCellConfig.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PUSCH_ServingCellConfigSUL := ");
	if (p->PUSCH_ServingCellConfigSUL.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfigSUL_Optional(_ctx, &p->PUSCH_ServingCellConfigSUL);
	if (p->PUSCH_ServingCellConfigSUL.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_CellConfigPhysicalLayerUplink_Type_Uplink_Optional(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayerUplink_Type_Uplink_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CellConfigPhysicalLayerUplink_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_CellConfigPhysicalLayer_Type(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayer_Type* p)
{
	adbgPrintLog(_ctx, "Common := ");
	if (p->Common.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_CellConfigPhysicalLayerCommon_Type_Common_Optional(_ctx, &p->Common);
	if (p->Common.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Downlink := ");
	if (p->Downlink.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_CellConfigPhysicalLayerDownlink_Type_Downlink_Optional(_ctx, &p->Downlink);
	if (p->Downlink.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Uplink := ");
	if (p->Uplink.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_CellConfigPhysicalLayerUplink_Type_Uplink_Optional(_ctx, &p->Uplink);
	if (p->Uplink.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_CellConfigPhysicalLayer_Type_PhysicalLayer_Optional(acpCtx_t _ctx, const struct NR_CellConfigPhysicalLayer_Type_PhysicalLayer_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_CellConfigPhysicalLayer_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_BcchToPbchConfig_Type_Pbch_Optional(acpCtx_t _ctx, const struct NR_BcchToPbchConfig_Type_Pbch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static void _adbgNrSys__Null_Type_ActiveBWP_Optional(acpCtx_t _ctx, const struct Null_Type_ActiveBWP_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static void _adbgNrSys__Null_Type_InitialBWP_Optional(acpCtx_t _ctx, const struct Null_Type_InitialBWP_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s", (p->v ? "true" : "false"));
}

static void _adbgNrSys__NR_AssignedBWPs_Type(acpCtx_t _ctx, const struct NR_AssignedBWPs_Type* p)
{
	adbgPrintLog(_ctx, "ActiveBWP := ");
	_adbgNrSys__Null_Type_ActiveBWP_Optional(_ctx, &p->ActiveBWP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "InitialBWP := ");
	_adbgNrSys__Null_Type_InitialBWP_Optional(_ctx, &p->InitialBWP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DedicatedBWPs := '");
	for (size_t i1 = 0; i1 < p->DedicatedBWPs.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->DedicatedBWPs.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__NR_AssignedBWPs_Type_NR_SearchSpaceDlDciAssignment_Type_AssignedBWPs_Optional(acpCtx_t _ctx, const struct NR_AssignedBWPs_Type_NR_SearchSpaceDlDciAssignment_Type_AssignedBWPs_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_AssignedBWPs_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_SearchSpaceType_Type_NR_SearchSpaceDlDciAssignment_Type_SearchSpaceType_Optional(acpCtx_t _ctx, const struct NR_SearchSpaceType_Type_NR_SearchSpaceDlDciAssignment_Type_SearchSpaceType_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_SearchSpaceType_Type__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__NR_ResourceAllocationType_Type__ToString(NR_ResourceAllocationType_Type v)
{
	switch(v) {
		case NR_ResourceAllocation_Type0: return "NR_ResourceAllocation_Type0";
		case NR_ResourceAllocation_Type1: return "NR_ResourceAllocation_Type1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_ResourceAllocationType_Type_NR_DciFormat_1_X_ResourceAssignment_Type_ResourceAllocationType_Optional(acpCtx_t _ctx, const struct NR_ResourceAllocationType_Type_NR_DciFormat_1_X_ResourceAssignment_Type_ResourceAllocationType_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_ResourceAllocationType_Type__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__NR_FreqDomainSchedulCommonDL_Type(acpCtx_t _ctx, const struct NR_FreqDomainSchedulCommonDL_Type* p)
{
	adbgPrintLog(_ctx, "FirstRbIndex := %d", (int)p->FirstRbIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "MaxRbCnt := %d", (int)p->MaxRbCnt);
}

static void _adbgNrSys__NR_FreqDomainSchedulExplicit_Type(acpCtx_t _ctx, const struct NR_FreqDomainSchedulExplicit_Type* p)
{
	adbgPrintLog(_ctx, "FirstRbIndex := %d", (int)p->FirstRbIndex);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Nprb := %d", (int)p->Nprb);
}

static void _adbgNrSys__NR_FreqDomainResourceAssignmentDL_Type_Value(acpCtx_t _ctx, const union NR_FreqDomainResourceAssignmentDL_Type_Value* p, enum NR_FreqDomainResourceAssignmentDL_Type_Sel d)
{
	if (d == NR_FreqDomainResourceAssignmentDL_Type_Automatic) {
		adbgPrintLog(_ctx, "Automatic := { ");
		_adbgNrSys__NR_FreqDomainSchedulCommonDL_Type(_ctx, &p->Automatic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_FreqDomainResourceAssignmentDL_Type_Explicit) {
		adbgPrintLog(_ctx, "Explicit := { ");
		_adbgNrSys__NR_FreqDomainSchedulExplicit_Type(_ctx, &p->Explicit);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_FreqDomainResourceAssignmentDL_Type(acpCtx_t _ctx, const struct NR_FreqDomainResourceAssignmentDL_Type* p)
{
	_adbgNrSys__NR_FreqDomainResourceAssignmentDL_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_FreqDomainResourceAssignmentDL_Type_FreqDomain_Optional(acpCtx_t _ctx, const struct NR_FreqDomainResourceAssignmentDL_Type_FreqDomain_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_FreqDomainResourceAssignmentDL_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciCommon_TimeDomainResourceAssignment_Type_Value(acpCtx_t _ctx, const union NR_DciCommon_TimeDomainResourceAssignment_Type_Value* p, enum NR_DciCommon_TimeDomainResourceAssignment_Type_Sel d)
{
	if (d == NR_DciCommon_TimeDomainResourceAssignment_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciCommon_TimeDomainResourceAssignment_Type(acpCtx_t _ctx, const struct NR_DciCommon_TimeDomainResourceAssignment_Type* p)
{
	_adbgNrSys__NR_DciCommon_TimeDomainResourceAssignment_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_1_X_ResourceAssignment_Type_TimeDomain_Optional(acpCtx_t _ctx, const struct NR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_1_X_ResourceAssignment_Type_TimeDomain_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciCommon_TimeDomainResourceAssignment_Type(_ctx, &p->v);
}

static const char* adbgNrSys__NR_ModulationSchemePDSCH_Type__ToString(NR_ModulationSchemePDSCH_Type v)
{
	switch(v) {
		case NR_ModulationSchemePDSCH_qpsk: return "NR_ModulationSchemePDSCH_qpsk";
		case NR_ModulationSchemePDSCH_qam16: return "NR_ModulationSchemePDSCH_qam16";
		case NR_ModulationSchemePDSCH_qam64: return "NR_ModulationSchemePDSCH_qam64";
		case NR_ModulationSchemePDSCH_qam256: return "NR_ModulationSchemePDSCH_qam256";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_ModulationSchemePDSCH_Type_TransportBlock2_Optional(acpCtx_t _ctx, const struct NR_ModulationSchemePDSCH_Type_TransportBlock2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_ModulationSchemePDSCH_Type__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__NR_RedundancyVersionList_Type_RedundancyVersionList_Optional(acpCtx_t _ctx, const struct NR_RedundancyVersionList_Type_RedundancyVersionList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__NR_TransportBlockSchedulingDL_Automatic_Type(acpCtx_t _ctx, const struct NR_TransportBlockSchedulingDL_Automatic_Type* p)
{
	adbgPrintLog(_ctx, "TransportBlock1 := %s (%d)", adbgNrSys__NR_ModulationSchemePDSCH_Type__ToString(p->TransportBlock1), (int)p->TransportBlock1);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TransportBlock2 := ");
	_adbgNrSys__NR_ModulationSchemePDSCH_Type_TransportBlock2_Optional(_ctx, &p->TransportBlock2);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RedundancyVersionList := ");
	if (p->RedundancyVersionList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_RedundancyVersionList_Type_RedundancyVersionList_Optional(_ctx, &p->RedundancyVersionList);
	if (p->RedundancyVersionList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__RetransmissionTiming_Type_Value(acpCtx_t _ctx, const union RetransmissionTiming_Type_Value* p, enum RetransmissionTiming_Type_Sel d)
{
	if (d == RetransmissionTiming_Type_SlotOffset) {
		adbgPrintLog(_ctx, "SlotOffset := %d", (int)p->SlotOffset);
		return;
	}
	if (d == RetransmissionTiming_Type_SubframeOffset) {
		adbgPrintLog(_ctx, "SubframeOffset := %d", (int)p->SubframeOffset);
		return;
	}
	if (d == RetransmissionTiming_Type_AnyTime) {
		adbgPrintLog(_ctx, "AnyTime := %s", (p->AnyTime ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__RetransmissionTiming_Type(acpCtx_t _ctx, const struct RetransmissionTiming_Type* p)
{
	_adbgNrSys__RetransmissionTiming_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__TransmissionTimingOffset_Type_Value(acpCtx_t _ctx, const union TransmissionTimingOffset_Type_Value* p, enum TransmissionTimingOffset_Type_Sel d)
{
	if (d == TransmissionTimingOffset_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == TransmissionTimingOffset_Type_Retransmission) {
		adbgPrintLog(_ctx, "Retransmission := { ");
		_adbgNrSys__RetransmissionTiming_Type(_ctx, &p->Retransmission);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__TransmissionTimingOffset_Type(acpCtx_t _ctx, const struct TransmissionTimingOffset_Type* p)
{
	_adbgNrSys__TransmissionTimingOffset_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_TransportBlockSingleTransmission_Type(acpCtx_t _ctx, const struct NR_TransportBlockSingleTransmission_Type* p)
{
	adbgPrintLog(_ctx, "TimingOffset := { ");
	_adbgNrSys__TransmissionTimingOffset_Type(_ctx, &p->TimingOffset);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ImcsValue := %u", (unsigned int)p->ImcsValue);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RedundancyVersion := %u", (unsigned int)p->RedundancyVersion);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ToggleNDI := %s", (p->ToggleNDI ? "true" : "false"));
}

static void _adbgNrSys__NR_TransportBlockRetransmissionList_Type_TransportBlock2_Optional(acpCtx_t _ctx, const struct NR_TransportBlockRetransmissionList_Type_TransportBlock2_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_TransportBlockSingleTransmission_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_TransportBlockSchedulingDL_Explicit_Type(acpCtx_t _ctx, const struct NR_TransportBlockSchedulingDL_Explicit_Type* p)
{
	adbgPrintLog(_ctx, "TransportBlock1 := { ");
	for (size_t i1 = 0; i1 < p->TransportBlock1.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__NR_TransportBlockSingleTransmission_Type(_ctx, &p->TransportBlock1.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->TransportBlock1.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TransportBlock2 := ");
	if (p->TransportBlock2.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_TransportBlockRetransmissionList_Type_TransportBlock2_Optional(_ctx, &p->TransportBlock2);
	if (p->TransportBlock2.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_TransportBlockSchedulingDL_Type_Value(acpCtx_t _ctx, const union NR_TransportBlockSchedulingDL_Type_Value* p, enum NR_TransportBlockSchedulingDL_Type_Sel d)
{
	if (d == NR_TransportBlockSchedulingDL_Type_Automatic) {
		adbgPrintLog(_ctx, "Automatic := { ");
		_adbgNrSys__NR_TransportBlockSchedulingDL_Automatic_Type(_ctx, &p->Automatic);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_TransportBlockSchedulingDL_Type_Explicit) {
		adbgPrintLog(_ctx, "Explicit := { ");
		_adbgNrSys__NR_TransportBlockSchedulingDL_Explicit_Type(_ctx, &p->Explicit);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_TransportBlockSchedulingDL_Type(acpCtx_t _ctx, const struct NR_TransportBlockSchedulingDL_Type* p)
{
	_adbgNrSys__NR_TransportBlockSchedulingDL_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_TransportBlockSchedulingDL_Type_TransportBlockScheduling_Optional(acpCtx_t _ctx, const struct NR_TransportBlockSchedulingDL_Type_TransportBlockScheduling_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_TransportBlockSchedulingDL_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_HarqProcessConfig_Type_Value(acpCtx_t _ctx, const union NR_HarqProcessConfig_Type_Value* p, enum NR_HarqProcessConfig_Type_Sel d)
{
	if (d == NR_HarqProcessConfig_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_HarqProcessConfig_Type_Broadcast) {
		adbgPrintLog(_ctx, "Broadcast := %s", (p->Broadcast ? "true" : "false"));
		return;
	}
	if (d == NR_HarqProcessConfig_Type_AnyProcess) {
		adbgPrintLog(_ctx, "AnyProcess := %s", (p->AnyProcess ? "true" : "false"));
		return;
	}
	if (d == NR_HarqProcessConfig_Type_SpecificSubset) {
		adbgPrintLog(_ctx, "SpecificSubset := '");
		for (size_t i1 = 0; i1 < p->SpecificSubset.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->SpecificSubset.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_HarqProcessConfig_Type(acpCtx_t _ctx, const struct NR_HarqProcessConfig_Type* p)
{
	_adbgNrSys__NR_HarqProcessConfig_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_HarqProcessConfig_Type_NR_DciFormat_1_X_ResourceAssignment_Type_HarqProcessConfig_Optional(acpCtx_t _ctx, const struct NR_HarqProcessConfig_Type_NR_DciFormat_1_X_ResourceAssignment_Type_HarqProcessConfig_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_HarqProcessConfig_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_X_ResourceAssignment_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_X_ResourceAssignment_Type* p)
{
	adbgPrintLog(_ctx, "ResourceAllocationType := ");
	_adbgNrSys__NR_ResourceAllocationType_Type_NR_DciFormat_1_X_ResourceAssignment_Type_ResourceAllocationType_Optional(_ctx, &p->ResourceAllocationType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "FreqDomain := ");
	if (p->FreqDomain.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_FreqDomainResourceAssignmentDL_Type_FreqDomain_Optional(_ctx, &p->FreqDomain);
	if (p->FreqDomain.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TimeDomain := ");
	if (p->TimeDomain.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_1_X_ResourceAssignment_Type_TimeDomain_Optional(_ctx, &p->TimeDomain);
	if (p->TimeDomain.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TransportBlockScheduling := ");
	if (p->TransportBlockScheduling.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_TransportBlockSchedulingDL_Type_TransportBlockScheduling_Optional(_ctx, &p->TransportBlockScheduling);
	if (p->TransportBlockScheduling.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "HarqProcessConfig := ");
	if (p->HarqProcessConfig.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_HarqProcessConfig_Type_NR_DciFormat_1_X_ResourceAssignment_Type_HarqProcessConfig_Optional(_ctx, &p->HarqProcessConfig);
	if (p->HarqProcessConfig.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_DciFormat_1_X_ResourceAssignment_Type_ResoureAssignment_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_X_ResourceAssignment_Type_ResoureAssignment_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_X_ResourceAssignment_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciCommon_VrbPrbMapping_Type_Value(acpCtx_t _ctx, const union NR_DciCommon_VrbPrbMapping_Type_Value* p, enum NR_DciCommon_VrbPrbMapping_Type_Sel d)
{
	if (d == NR_DciCommon_VrbPrbMapping_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciCommon_VrbPrbMapping_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciCommon_VrbPrbMapping_Type(acpCtx_t _ctx, const struct NR_DciCommon_VrbPrbMapping_Type* p)
{
	_adbgNrSys__NR_DciCommon_VrbPrbMapping_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciCommon_VrbPrbMapping_Type_VrbPrbMapping_Optional(acpCtx_t _ctx, const struct NR_DciCommon_VrbPrbMapping_Type_VrbPrbMapping_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciCommon_VrbPrbMapping_Type(_ctx, &p->v);
}

static void _adbgNrSys__DAI_B2_Type_Value(acpCtx_t _ctx, const union DAI_B2_Type_Value* p, enum DAI_B2_Type_Sel d)
{
	if (d == DAI_B2_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < 2; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == DAI_B2_Type_Automatic) {
		adbgPrintLog(_ctx, "Automatic := %s", (p->Automatic ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__DAI_B2_Type(acpCtx_t _ctx, const struct DAI_B2_Type* p)
{
	_adbgNrSys__DAI_B2_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_0_DAI_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_0_DAI_Type_Value* p, enum NR_DciFormat_1_0_DAI_Type_Sel d)
{
	if (d == NR_DciFormat_1_0_DAI_Type_Index) {
		adbgPrintLog(_ctx, "Index := { ");
		_adbgNrSys__DAI_B2_Type(_ctx, &p->Index);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_0_DAI_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_0_DAI_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_0_DAI_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_0_DAI_Type_DAI_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_0_DAI_Type_DAI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_0_DAI_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciCommon_TpcCommand_Type_Value(acpCtx_t _ctx, const union NR_DciCommon_TpcCommand_Type_Value* p, enum NR_DciCommon_TpcCommand_Type_Sel d)
{
	if (d == NR_DciCommon_TpcCommand_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 2; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciCommon_TpcCommand_Type(acpCtx_t _ctx, const struct NR_DciCommon_TpcCommand_Type* p)
{
	_adbgNrSys__NR_DciCommon_TpcCommand_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_0_SpecificInfo_Type_TpcCommandPucch_Optional(acpCtx_t _ctx, const struct NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_0_SpecificInfo_Type_TpcCommandPucch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciCommon_TpcCommand_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_X_PucchResourceIndicator_Type_Value* p, enum NR_DciFormat_1_X_PucchResourceIndicator_Type_Sel d)
{
	if (d == NR_DciFormat_1_X_PucchResourceIndicator_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 3; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_X_PucchResourceIndicator_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PucchResourceIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PucchResourceIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value* p, enum NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Sel d)
{
	if (d == NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_X_PdschHarqTimingIndicator_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PdschHarqTimingIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_X_0_ChannelAccessCPext_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_X_0_ChannelAccessCPext_Type_Value* p, enum NR_DciFormat_X_0_ChannelAccessCPext_Type_Sel d)
{
	if (d == NR_DciFormat_X_0_ChannelAccessCPext_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_X_0_ChannelAccessCPext_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 2; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_X_0_ChannelAccessCPext_Type(acpCtx_t _ctx, const struct NR_DciFormat_X_0_ChannelAccessCPext_Type* p)
{
	_adbgNrSys__NR_DciFormat_X_0_ChannelAccessCPext_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_1_0_SpecificInfo_Type_ChannelAccessCPext_Optional(acpCtx_t _ctx, const struct NR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_1_0_SpecificInfo_Type_ChannelAccessCPext_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_X_0_ChannelAccessCPext_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_0_SpecificInfo_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_0_SpecificInfo_Type* p)
{
	adbgPrintLog(_ctx, "DAI := ");
	if (p->DAI.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_0_DAI_Type_DAI_Optional(_ctx, &p->DAI);
	if (p->DAI.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TpcCommandPucch := ");
	if (p->TpcCommandPucch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_0_SpecificInfo_Type_TpcCommandPucch_Optional(_ctx, &p->TpcCommandPucch);
	if (p->TpcCommandPucch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PucchResourceIndicator := ");
	if (p->PucchResourceIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PucchResourceIndicator_Optional(_ctx, &p->PucchResourceIndicator);
	if (p->PucchResourceIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdschHarqTimingIndicator := ");
	if (p->PdschHarqTimingIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(_ctx, &p->PdschHarqTimingIndicator);
	if (p->PdschHarqTimingIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ChannelAccessCPext := ");
	if (p->ChannelAccessCPext.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_1_0_SpecificInfo_Type_ChannelAccessCPext_Optional(_ctx, &p->ChannelAccessCPext);
	if (p->ChannelAccessCPext.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessageIndicator_Optional(acpCtx_t _ctx, const struct B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessageIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 2; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__B8_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessages_Optional(acpCtx_t _ctx, const struct B8_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessages_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 8; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_TbScaling_Optional(acpCtx_t _ctx, const struct B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_TbScaling_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 2; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type* p)
{
	adbgPrintLog(_ctx, "ShortMessageIndicator := ");
	_adbgNrSys__B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessageIndicator_Optional(_ctx, &p->ShortMessageIndicator);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ShortMessages := ");
	_adbgNrSys__B8_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessages_Optional(_ctx, &p->ShortMessages);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TbScaling := ");
	_adbgNrSys__B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_TbScaling_Optional(_ctx, &p->TbScaling);
}

static void _adbgNrSys__B1_Type_NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type_SystemInfoIndicator_Optional(acpCtx_t _ctx, const struct B1_Type_NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type_SystemInfoIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 1; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type* p)
{
	adbgPrintLog(_ctx, "SystemInfoIndicator := ");
	_adbgNrSys__B1_Type_NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type_SystemInfoIndicator_Optional(_ctx, &p->SystemInfoIndicator);
}

static void _adbgNrSys__B2_Type_NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type_TbScaling_Optional(acpCtx_t _ctx, const struct B2_Type_NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type_TbScaling_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < 2; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__NR_DciFormat_1_0_LSBsOfSFN_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_0_LSBsOfSFN_Type_Value* p, enum NR_DciFormat_1_0_LSBsOfSFN_Type_Sel d)
{
	if (d == NR_DciFormat_1_0_LSBsOfSFN_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_0_LSBsOfSFN_Type_Automatic) {
		adbgPrintLog(_ctx, "Automatic := %s", (p->Automatic ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_0_LSBsOfSFN_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_0_LSBsOfSFN_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_0_LSBsOfSFN_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_0_LSBsOfSFN_Type_LSBsOfSFN_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_0_LSBsOfSFN_Type_LSBsOfSFN_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_0_LSBsOfSFN_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type* p)
{
	adbgPrintLog(_ctx, "TbScaling := ");
	_adbgNrSys__B2_Type_NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type_TbScaling_Optional(_ctx, &p->TbScaling);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "LSBsOfSFN := ");
	if (p->LSBsOfSFN.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_0_LSBsOfSFN_Type_LSBsOfSFN_Optional(_ctx, &p->LSBsOfSFN);
	if (p->LSBsOfSFN.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_DciCommon_CarrierIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciCommon_CarrierIndicator_Type_Value* p, enum NR_DciCommon_CarrierIndicator_Type_Sel d)
{
	if (d == NR_DciCommon_CarrierIndicator_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciCommon_CarrierIndicator_Type_CellIndex) {
		adbgPrintLog(_ctx, "CellIndex := '");
		for (size_t i1 = 0; i1 < 3; i1++) {
			adbgPrintLog(_ctx, "%02X", p->CellIndex[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciCommon_CarrierIndicator_Type(acpCtx_t _ctx, const struct NR_DciCommon_CarrierIndicator_Type* p)
{
	_adbgNrSys__NR_DciCommon_CarrierIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciCommon_CarrierIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_CarrierIndicator_Optional(acpCtx_t _ctx, const struct NR_DciCommon_CarrierIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_CarrierIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciCommon_CarrierIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciCommon_BWPIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciCommon_BWPIndicator_Type_Value* p, enum NR_DciCommon_BWPIndicator_Type_Sel d)
{
	if (d == NR_DciCommon_BWPIndicator_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciCommon_BWPIndicator_Type(acpCtx_t _ctx, const struct NR_DciCommon_BWPIndicator_Type* p)
{
	_adbgNrSys__NR_DciCommon_BWPIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciCommon_BWPIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_BWPIndicator_Optional(acpCtx_t _ctx, const struct NR_DciCommon_BWPIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_BWPIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciCommon_BWPIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Value* p, enum NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Dynamic) {
		adbgPrintLog(_ctx, "Dynamic := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Dynamic[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_PrbBundlingSizeIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_PrbBundlingSizeIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_RateMatchingIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_RateMatchingIndicator_Type_Value* p, enum NR_DciFormat_1_1_RateMatchingIndicator_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_RateMatchingIndicator_Type_Bitmap) {
		adbgPrintLog(_ctx, "Bitmap := '");
		for (size_t i1 = 0; i1 < p->Bitmap.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Bitmap.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_RateMatchingIndicator_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_RateMatchingIndicator_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_RateMatchingIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_RateMatchingIndicator_Type_RateMatchingIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_RateMatchingIndicator_Type_RateMatchingIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_RateMatchingIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Value* p, enum NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_ZP_CSI_RS_Trigger_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_ZP_CSI_RS_Trigger_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type(_ctx, &p->v);
}

static void _adbgNrSys__DAI_B4_Type_Value(acpCtx_t _ctx, const union DAI_B4_Type_Value* p, enum DAI_B4_Type_Sel d)
{
	if (d == DAI_B4_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < 4; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == DAI_B4_Type_Automatic) {
		adbgPrintLog(_ctx, "Automatic := %s", (p->Automatic ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__DAI_B4_Type(acpCtx_t _ctx, const struct DAI_B4_Type* p)
{
	_adbgNrSys__DAI_B4_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__DAI_B6_Type_Value(acpCtx_t _ctx, const union DAI_B6_Type_Value* p, enum DAI_B6_Type_Sel d)
{
	if (d == DAI_B6_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < 6; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == DAI_B6_Type_Automatic) {
		adbgPrintLog(_ctx, "Automatic := %s", (p->Automatic ? "true" : "false"));
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__DAI_B6_Type(acpCtx_t _ctx, const struct DAI_B6_Type* p)
{
	_adbgNrSys__DAI_B6_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_DAI_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_DAI_Type_Value* p, enum NR_DciFormat_1_1_DAI_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_DAI_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_DAI_Type_TwoBits) {
		adbgPrintLog(_ctx, "TwoBits := { ");
		_adbgNrSys__DAI_B2_Type(_ctx, &p->TwoBits);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_DciFormat_1_1_DAI_Type_FourBits) {
		adbgPrintLog(_ctx, "FourBits := { ");
		_adbgNrSys__DAI_B4_Type(_ctx, &p->FourBits);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_DciFormat_1_1_DAI_Type_SixBits) {
		adbgPrintLog(_ctx, "SixBits := { ");
		_adbgNrSys__DAI_B6_Type(_ctx, &p->SixBits);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_DAI_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_DAI_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_DAI_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_DAI_Type_DAI_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_DAI_Type_DAI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_DAI_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_1_SpecificInfo_Type_TpcCommandPucch_Optional(acpCtx_t _ctx, const struct NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_1_SpecificInfo_Type_TpcCommandPucch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciCommon_TpcCommand_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PucchResourceIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PucchResourceIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PdschHarqTimingIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value* p, enum NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_OneShotHarqAckRequest_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_OneShotHarqAckRequest_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_OneShotHarqAckRequest_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_OneShotHarqAckRequest_Type_OneShotHarqAckRequest_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_OneShotHarqAckRequest_Type_OneShotHarqAckRequest_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_OneShotHarqAckRequest_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_PdschGroupIndex_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_PdschGroupIndex_Type_Value* p, enum NR_DciFormat_1_1_PdschGroupIndex_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_PdschGroupIndex_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_PdschGroupIndex_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_PdschGroupIndex_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_PdschGroupIndex_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_PdschGroupIndex_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_PdschGroupIndex_Type_PdschGroupIndex_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_PdschGroupIndex_Type_PdschGroupIndex_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_PdschGroupIndex_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_NewFeedbackIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_NewFeedbackIndicator_Type_Value* p, enum NR_DciFormat_1_1_NewFeedbackIndicator_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_NewFeedbackIndicator_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_NewFeedbackIndicator_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_NewFeedbackIndicator_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_NewFeedbackIndicator_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_NewFeedbackIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_NewFeedbackIndicator_Type_NewFeedbackIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_NewFeedbackIndicator_Type_NewFeedbackIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_NewFeedbackIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value* p, enum NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_NumberRequestedPdschGroup_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_NumberRequestedPdschGroup_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_NumberRequestedPdschGroup_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_NumberRequestedPdschGroup_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_NumberRequestedPdschGroup_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_AntennaPorts_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_AntennaPorts_Type_Value* p, enum NR_DciFormat_1_1_AntennaPorts_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_AntennaPorts_Type_Index) {
		adbgPrintLog(_ctx, "Index := '");
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Index.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_AntennaPorts_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_AntennaPorts_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_AntennaPorts_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_AntennaPorts_Type_AntennaPorts_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_AntennaPorts_Type_AntennaPorts_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_AntennaPorts_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_TCI_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_TCI_Type_Value* p, enum NR_DciFormat_1_1_TCI_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_TCI_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_TCI_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 3; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_TCI_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_TCI_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_TCI_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_TCI_Type_TCI_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_TCI_Type_TCI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_TCI_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_X_1_SrsRequest_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_X_1_SrsRequest_Type_Value* p, enum NR_DciFormat_X_1_SrsRequest_Type_Sel d)
{
	if (d == NR_DciFormat_X_1_SrsRequest_Type_SingleUL) {
		adbgPrintLog(_ctx, "SingleUL := '");
		for (size_t i1 = 0; i1 < 2; i1++) {
			adbgPrintLog(_ctx, "%02X", p->SingleUL[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == NR_DciFormat_X_1_SrsRequest_Type_UL_SUL) {
		adbgPrintLog(_ctx, "UL_SUL := '");
		for (size_t i1 = 0; i1 < 3; i1++) {
			adbgPrintLog(_ctx, "%02X", p->UL_SUL[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_X_1_SrsRequest_Type(acpCtx_t _ctx, const struct NR_DciFormat_X_1_SrsRequest_Type* p)
{
	_adbgNrSys__NR_DciFormat_X_1_SrsRequest_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_1_1_SpecificInfo_Type_SrsRequest_Optional(acpCtx_t _ctx, const struct NR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_1_1_SpecificInfo_Type_SrsRequest_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_X_1_SrsRequest_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_CBGTI_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_CBGTI_Type_Value* p, enum NR_DciFormat_1_1_CBGTI_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_CBGTI_Type_Bitmap) {
		adbgPrintLog(_ctx, "Bitmap := '");
		for (size_t i1 = 0; i1 < p->Bitmap.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Bitmap.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_CBGTI_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_CBGTI_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_CBGTI_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_CBGTI_Type_CBGTI_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_CBGTI_Type_CBGTI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_CBGTI_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_CBGFI_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_CBGFI_Type_Value* p, enum NR_DciFormat_1_1_CBGFI_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_CBGFI_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_CBGFI_Type_Flag) {
		adbgPrintLog(_ctx, "Flag := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Flag[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_CBGFI_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_CBGFI_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_CBGFI_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_CBGFI_Type_CBGFI_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_CBGFI_Type_CBGFI_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_CBGFI_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_X_1_DmrsSequenceInit_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_X_1_DmrsSequenceInit_Type_Value* p, enum NR_DciFormat_X_1_DmrsSequenceInit_Type_Sel d)
{
	if (d == NR_DciFormat_X_1_DmrsSequenceInit_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_X_1_DmrsSequenceInit_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_X_1_DmrsSequenceInit_Type(acpCtx_t _ctx, const struct NR_DciFormat_X_1_DmrsSequenceInit_Type* p)
{
	_adbgNrSys__NR_DciFormat_X_1_DmrsSequenceInit_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_1_1_SpecificInfo_Type_DmrsSequenceInit_Optional(acpCtx_t _ctx, const struct NR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_1_1_SpecificInfo_Type_DmrsSequenceInit_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_X_1_DmrsSequenceInit_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_X_1_PriorityIndicator_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_X_1_PriorityIndicator_Type_Value* p, enum NR_DciFormat_X_1_PriorityIndicator_Type_Sel d)
{
	if (d == NR_DciFormat_X_1_PriorityIndicator_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_X_1_PriorityIndicator_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_X_1_PriorityIndicator_Type(acpCtx_t _ctx, const struct NR_DciFormat_X_1_PriorityIndicator_Type* p)
{
	_adbgNrSys__NR_DciFormat_X_1_PriorityIndicator_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PriorityIndicator_Optional(acpCtx_t _ctx, const struct NR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PriorityIndicator_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_X_1_PriorityIndicator_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_ChannelAccessCPext_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_1_ChannelAccessCPext_Type_Value* p, enum NR_DciFormat_1_1_ChannelAccessCPext_Type_Sel d)
{
	if (d == NR_DciFormat_1_1_ChannelAccessCPext_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_1_1_ChannelAccessCPext_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_1_ChannelAccessCPext_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_ChannelAccessCPext_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_1_ChannelAccessCPext_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_1_ChannelAccessCPext_Type_ChannelAccessCPext_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_1_ChannelAccessCPext_Type_ChannelAccessCPext_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_1_ChannelAccessCPext_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value* p, enum NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Sel d)
{
	if (d == NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < 1; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type(acpCtx_t _ctx, const struct NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type* p)
{
	_adbgNrSys__NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_1_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional(acpCtx_t _ctx, const struct NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_1_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_X_1_SCellDormancyIndication_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_X_1_SCellDormancyIndication_Type_Value* p, enum NR_DciFormat_X_1_SCellDormancyIndication_Type_Sel d)
{
	if (d == NR_DciFormat_X_1_SCellDormancyIndication_Type_None) {
		adbgPrintLog(_ctx, "None := %s", (p->None ? "true" : "false"));
		return;
	}
	if (d == NR_DciFormat_X_1_SCellDormancyIndication_Type_Value) {
		adbgPrintLog(_ctx, "Value := '");
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			adbgPrintLog(_ctx, "%02X", p->Value.v[i1]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_X_1_SCellDormancyIndication_Type(acpCtx_t _ctx, const struct NR_DciFormat_X_1_SCellDormancyIndication_Type* p)
{
	_adbgNrSys__NR_DciFormat_X_1_SCellDormancyIndication_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_1_1_SpecificInfo_Type_SCellDormancyIndication_Optional(acpCtx_t _ctx, const struct NR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_1_1_SpecificInfo_Type_SCellDormancyIndication_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_X_1_SCellDormancyIndication_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciFormat_1_1_SpecificInfo_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_1_SpecificInfo_Type* p)
{
	adbgPrintLog(_ctx, "CarrierIndicator := ");
	if (p->CarrierIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciCommon_CarrierIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_CarrierIndicator_Optional(_ctx, &p->CarrierIndicator);
	if (p->CarrierIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "BWPIndicator := ");
	if (p->BWPIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciCommon_BWPIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_BWPIndicator_Optional(_ctx, &p->BWPIndicator);
	if (p->BWPIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PrbBundlingSizeIndicator := ");
	if (p->PrbBundlingSizeIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_PrbBundlingSizeIndicator_Optional(_ctx, &p->PrbBundlingSizeIndicator);
	if (p->PrbBundlingSizeIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "RateMatchingIndicator := ");
	if (p->RateMatchingIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_RateMatchingIndicator_Type_RateMatchingIndicator_Optional(_ctx, &p->RateMatchingIndicator);
	if (p->RateMatchingIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ZP_CSI_RS_Trigger := ");
	if (p->ZP_CSI_RS_Trigger.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_ZP_CSI_RS_Trigger_Optional(_ctx, &p->ZP_CSI_RS_Trigger);
	if (p->ZP_CSI_RS_Trigger.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DAI := ");
	if (p->DAI.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_DAI_Type_DAI_Optional(_ctx, &p->DAI);
	if (p->DAI.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TpcCommandPucch := ");
	if (p->TpcCommandPucch.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_1_SpecificInfo_Type_TpcCommandPucch_Optional(_ctx, &p->TpcCommandPucch);
	if (p->TpcCommandPucch.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PucchResourceIndicator := ");
	if (p->PucchResourceIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PucchResourceIndicator_Optional(_ctx, &p->PucchResourceIndicator);
	if (p->PucchResourceIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdschHarqTimingIndicator := ");
	if (p->PdschHarqTimingIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(_ctx, &p->PdschHarqTimingIndicator);
	if (p->PdschHarqTimingIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "OneShotHarqAckRequest := ");
	if (p->OneShotHarqAckRequest.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_OneShotHarqAckRequest_Type_OneShotHarqAckRequest_Optional(_ctx, &p->OneShotHarqAckRequest);
	if (p->OneShotHarqAckRequest.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PdschGroupIndex := ");
	if (p->PdschGroupIndex.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_PdschGroupIndex_Type_PdschGroupIndex_Optional(_ctx, &p->PdschGroupIndex);
	if (p->PdschGroupIndex.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "NewFeedbackIndicator := ");
	if (p->NewFeedbackIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_NewFeedbackIndicator_Type_NewFeedbackIndicator_Optional(_ctx, &p->NewFeedbackIndicator);
	if (p->NewFeedbackIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "NumberRequestedPdschGroup := ");
	if (p->NumberRequestedPdschGroup.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_NumberRequestedPdschGroup_Optional(_ctx, &p->NumberRequestedPdschGroup);
	if (p->NumberRequestedPdschGroup.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "AntennaPorts := ");
	if (p->AntennaPorts.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_AntennaPorts_Type_AntennaPorts_Optional(_ctx, &p->AntennaPorts);
	if (p->AntennaPorts.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "TCI := ");
	if (p->TCI.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_TCI_Type_TCI_Optional(_ctx, &p->TCI);
	if (p->TCI.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SrsRequest := ");
	if (p->SrsRequest.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_1_1_SpecificInfo_Type_SrsRequest_Optional(_ctx, &p->SrsRequest);
	if (p->SrsRequest.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CBGTI := ");
	if (p->CBGTI.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_CBGTI_Type_CBGTI_Optional(_ctx, &p->CBGTI);
	if (p->CBGTI.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "CBGFI := ");
	if (p->CBGFI.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_CBGFI_Type_CBGFI_Optional(_ctx, &p->CBGFI);
	if (p->CBGFI.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DmrsSequenceInit := ");
	if (p->DmrsSequenceInit.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_1_1_SpecificInfo_Type_DmrsSequenceInit_Optional(_ctx, &p->DmrsSequenceInit);
	if (p->DmrsSequenceInit.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "PriorityIndicator := ");
	if (p->PriorityIndicator.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PriorityIndicator_Optional(_ctx, &p->PriorityIndicator);
	if (p->PriorityIndicator.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ChannelAccessCPext := ");
	if (p->ChannelAccessCPext.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_1_ChannelAccessCPext_Type_ChannelAccessCPext_Optional(_ctx, &p->ChannelAccessCPext);
	if (p->ChannelAccessCPext.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "MinimumApplicableSchedulingOffset := ");
	if (p->MinimumApplicableSchedulingOffset.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_1_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional(_ctx, &p->MinimumApplicableSchedulingOffset);
	if (p->MinimumApplicableSchedulingOffset.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SCellDormancyIndication := ");
	if (p->SCellDormancyIndication.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_1_1_SpecificInfo_Type_SCellDormancyIndication_Optional(_ctx, &p->SCellDormancyIndication);
	if (p->SCellDormancyIndication.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_DciFormat_1_X_SpecificInfo_Type_Value(acpCtx_t _ctx, const union NR_DciFormat_1_X_SpecificInfo_Type_Value* p, enum NR_DciFormat_1_X_SpecificInfo_Type_Sel d)
{
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0) {
		adbgPrintLog(_ctx, "Format_1_0 := { ");
		_adbgNrSys__NR_DciFormat_1_0_SpecificInfo_Type(_ctx, &p->Format_1_0);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0_P_RNTI) {
		adbgPrintLog(_ctx, "Format_1_0_P_RNTI := { ");
		_adbgNrSys__NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type(_ctx, &p->Format_1_0_P_RNTI);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0_SI_RNTI) {
		adbgPrintLog(_ctx, "Format_1_0_SI_RNTI := { ");
		_adbgNrSys__NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type(_ctx, &p->Format_1_0_SI_RNTI);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0_RA_RNTI) {
		adbgPrintLog(_ctx, "Format_1_0_RA_RNTI := { ");
		_adbgNrSys__NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type(_ctx, &p->Format_1_0_RA_RNTI);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_1) {
		adbgPrintLog(_ctx, "Format_1_1 := { ");
		_adbgNrSys__NR_DciFormat_1_1_SpecificInfo_Type(_ctx, &p->Format_1_1);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__NR_DciFormat_1_X_SpecificInfo_Type(acpCtx_t _ctx, const struct NR_DciFormat_1_X_SpecificInfo_Type* p)
{
	_adbgNrSys__NR_DciFormat_1_X_SpecificInfo_Type_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__NR_DciFormat_1_X_SpecificInfo_Type_Format_Optional(acpCtx_t _ctx, const struct NR_DciFormat_1_X_SpecificInfo_Type_Format_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciFormat_1_X_SpecificInfo_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_DciDlInfo_Type(acpCtx_t _ctx, const struct NR_DciDlInfo_Type* p)
{
	adbgPrintLog(_ctx, "ResoureAssignment := ");
	if (p->ResoureAssignment.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_X_ResourceAssignment_Type_ResoureAssignment_Optional(_ctx, &p->ResoureAssignment);
	if (p->ResoureAssignment.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "VrbPrbMapping := ");
	if (p->VrbPrbMapping.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciCommon_VrbPrbMapping_Type_VrbPrbMapping_Optional(_ctx, &p->VrbPrbMapping);
	if (p->VrbPrbMapping.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Format := ");
	if (p->Format.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciFormat_1_X_SpecificInfo_Type_Format_Optional(_ctx, &p->Format);
	if (p->Format.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_DciDlInfo_Type_DciInfo_Optional(acpCtx_t _ctx, const struct NR_DciDlInfo_Type_DciInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_DciDlInfo_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_SearchSpaceDlDciAssignment_Type(acpCtx_t _ctx, const struct NR_SearchSpaceDlDciAssignment_Type* p)
{
	adbgPrintLog(_ctx, "AssignedBWPs := ");
	if (p->AssignedBWPs.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_AssignedBWPs_Type_NR_SearchSpaceDlDciAssignment_Type_AssignedBWPs_Optional(_ctx, &p->AssignedBWPs);
	if (p->AssignedBWPs.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SearchSpaceType := ");
	_adbgNrSys__NR_SearchSpaceType_Type_NR_SearchSpaceDlDciAssignment_Type_SearchSpaceType_Optional(_ctx, &p->SearchSpaceType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "DciInfo := ");
	if (p->DciInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_DciDlInfo_Type_DciInfo_Optional(_ctx, &p->DciInfo);
	if (p->DciInfo.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_SearchSpaceDlDciAssignment_Type_NR_Sib1Schedul_Type_SearchSpaceAndDci_Optional(acpCtx_t _ctx, const struct NR_SearchSpaceDlDciAssignment_Type_NR_Sib1Schedul_Type_SearchSpaceAndDci_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SearchSpaceDlDciAssignment_Type(_ctx, &p->v);
}

static void _adbgNrSys__Int32_t_NR_Sib1Schedul_Type_Periodicity_Optional(acpCtx_t _ctx, const struct int32_t_NR_Sib1Schedul_Type_Periodicity_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__IntegerList_Type_SlotOffsetList_Optional(acpCtx_t _ctx, const struct IntegerList_Type_SlotOffsetList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__NR_Sib1Schedul_Type(acpCtx_t _ctx, const struct NR_Sib1Schedul_Type* p)
{
	adbgPrintLog(_ctx, "SearchSpaceAndDci := ");
	if (p->SearchSpaceAndDci.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SearchSpaceDlDciAssignment_Type_NR_Sib1Schedul_Type_SearchSpaceAndDci_Optional(_ctx, &p->SearchSpaceAndDci);
	if (p->SearchSpaceAndDci.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Periodicity := ");
	_adbgNrSys__Int32_t_NR_Sib1Schedul_Type_Periodicity_Optional(_ctx, &p->Periodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SlotOffsetList := ");
	if (p->SlotOffsetList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__IntegerList_Type_SlotOffsetList_Optional(_ctx, &p->SlotOffsetList);
	if (p->SlotOffsetList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_Sib1Schedul_Type_Sib1Schedul_Optional(acpCtx_t _ctx, const struct NR_Sib1Schedul_Type_Sib1Schedul_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_Sib1Schedul_Type(_ctx, &p->v);
}

static const char* adbgNrSys__NR_SiWindowLength_Type__ToString(NR_SiWindowLength_Type v)
{
	switch(v) {
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s5: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s5";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s10: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s10";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s20: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s20";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s40: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s40";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s80: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s80";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s160: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s160";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s320: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s320";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s640: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s640";
		case SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s1280: return "SQN_NR_SI_SchedulingInfo_si_WindowLength_e_s1280";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_SiWindowLength_Type_WindowLength_Optional(acpCtx_t _ctx, const struct NR_SiWindowLength_Type_WindowLength_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_SiWindowLength_Type__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__NR_SiPeriodicity_Type__ToString(NR_SiPeriodicity_Type v)
{
	switch(v) {
		case SQN_NR_SchedulingInfo_si_Periodicity_e_rf8: return "SQN_NR_SchedulingInfo_si_Periodicity_e_rf8";
		case SQN_NR_SchedulingInfo_si_Periodicity_e_rf16: return "SQN_NR_SchedulingInfo_si_Periodicity_e_rf16";
		case SQN_NR_SchedulingInfo_si_Periodicity_e_rf32: return "SQN_NR_SchedulingInfo_si_Periodicity_e_rf32";
		case SQN_NR_SchedulingInfo_si_Periodicity_e_rf64: return "SQN_NR_SchedulingInfo_si_Periodicity_e_rf64";
		case SQN_NR_SchedulingInfo_si_Periodicity_e_rf128: return "SQN_NR_SchedulingInfo_si_Periodicity_e_rf128";
		case SQN_NR_SchedulingInfo_si_Periodicity_e_rf256: return "SQN_NR_SchedulingInfo_si_Periodicity_e_rf256";
		case SQN_NR_SchedulingInfo_si_Periodicity_e_rf512: return "SQN_NR_SchedulingInfo_si_Periodicity_e_rf512";
		default: return "Unknown";
	}
}

static void _adbgNrSys__NR_SiPeriodicity_Type_Periodicity_Optional(acpCtx_t _ctx, const struct NR_SiPeriodicity_Type_Periodicity_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__NR_SiPeriodicity_Type__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__NR_SearchSpaceDlDciAssignment_Type_NR_SingleSiSchedul_Type_SearchSpaceAndDci_Optional(acpCtx_t _ctx, const struct NR_SearchSpaceDlDciAssignment_Type_NR_SingleSiSchedul_Type_SearchSpaceAndDci_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_SearchSpaceDlDciAssignment_Type(_ctx, &p->v);
}

static void _adbgNrSys__Int32_t_NR_SingleSiSchedul_Type_SlotOffset_Optional(acpCtx_t _ctx, const struct int32_t_NR_SingleSiSchedul_Type_SlotOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__NR_SingleSiSchedul_Type(acpCtx_t _ctx, const struct NR_SingleSiSchedul_Type* p)
{
	adbgPrintLog(_ctx, "SearchSpaceAndDci := ");
	if (p->SearchSpaceAndDci.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SearchSpaceDlDciAssignment_Type_NR_SingleSiSchedul_Type_SearchSpaceAndDci_Optional(_ctx, &p->SearchSpaceAndDci);
	if (p->SearchSpaceAndDci.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SlotOffset := ");
	_adbgNrSys__Int32_t_NR_SingleSiSchedul_Type_SlotOffset_Optional(_ctx, &p->SlotOffset);
}

static void _adbgNrSys__NR_SingleSiSchedul_Type_Window_DynamicOptional(acpCtx_t _ctx, const struct NR_SingleSiSchedul_Type_Window_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__NR_SingleSiSchedul_Type(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_OtherSiSchedul_Type(acpCtx_t _ctx, const struct NR_OtherSiSchedul_Type* p)
{
	adbgPrintLog(_ctx, "Periodicity := ");
	_adbgNrSys__NR_SiPeriodicity_Type_Periodicity_Optional(_ctx, &p->Periodicity);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "Window := ");
	if (p->Window.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_SingleSiSchedul_Type_Window_DynamicOptional(_ctx, &p->Window);
	if (p->Window.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_OtherSiSchedulList_Type_SiList_Optional(acpCtx_t _ctx, const struct NR_OtherSiSchedulList_Type_SiList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_OtherSiSchedul_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_OtherSiSchedulList_Type_SegmentedSiList_Optional(acpCtx_t _ctx, const struct NR_OtherSiSchedulList_Type_SegmentedSiList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_adbgNrSys__NR_OtherSiSchedul_Type(_ctx, &p->v.v[i1]);
		if (i1 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__NR_AllOtherSiSchedul_Type(acpCtx_t _ctx, const struct NR_AllOtherSiSchedul_Type* p)
{
	adbgPrintLog(_ctx, "WindowLength := ");
	_adbgNrSys__NR_SiWindowLength_Type_WindowLength_Optional(_ctx, &p->WindowLength);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SiList := ");
	if (p->SiList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_OtherSiSchedulList_Type_SiList_Optional(_ctx, &p->SiList);
	if (p->SiList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SegmentedSiList := ");
	if (p->SegmentedSiList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_OtherSiSchedulList_Type_SegmentedSiList_Optional(_ctx, &p->SegmentedSiList);
	if (p->SegmentedSiList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_AllOtherSiSchedul_Type_SiSchedul_Optional(acpCtx_t _ctx, const struct NR_AllOtherSiSchedul_Type_SiSchedul_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_AllOtherSiSchedul_Type(_ctx, &p->v);
}

static void _adbgNrSys__NR_BcchToPdschConfig_Type(acpCtx_t _ctx, const struct NR_BcchToPdschConfig_Type* p)
{
	adbgPrintLog(_ctx, "Sib1Schedul := ");
	if (p->Sib1Schedul.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_Sib1Schedul_Type_Sib1Schedul_Optional(_ctx, &p->Sib1Schedul);
	if (p->Sib1Schedul.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "SiSchedul := ");
	if (p->SiSchedul.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__NR_AllOtherSiSchedul_Type_SiSchedul_Optional(_ctx, &p->SiSchedul);
	if (p->SiSchedul.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__NR_BcchToPdschConfig_Type_Pdsch_Optional(acpCtx_t _ctx, const struct NR_BcchToPdschConfig_Type_Pdsch_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__NR_BcchToPdschConfig_Type(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_MIB_subCarrierSpacingCommon_e__ToString(SQN_NR_MIB_subCarrierSpacingCommon_e v)
{
	switch(v) {
		case SQN_NR_MIB_subCarrierSpacingCommon_e_scs15or60: return "SQN_NR_MIB_subCarrierSpacingCommon_e_scs15or60";
		case SQN_NR_MIB_subCarrierSpacingCommon_e_scs30or120: return "SQN_NR_MIB_subCarrierSpacingCommon_e_scs30or120";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_MIB_dmrs_TypeA_Position_e__ToString(SQN_NR_MIB_dmrs_TypeA_Position_e v)
{
	switch(v) {
		case SQN_NR_MIB_dmrs_TypeA_Position_e_pos2: return "SQN_NR_MIB_dmrs_TypeA_Position_e_pos2";
		case SQN_NR_MIB_dmrs_TypeA_Position_e_pos3: return "SQN_NR_MIB_dmrs_TypeA_Position_e_pos3";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PDCCH_ConfigSIB1(acpCtx_t _ctx, const struct SQN_NR_PDCCH_ConfigSIB1* p)
{
	adbgPrintLog(_ctx, "controlResourceSetZero := %u", (unsigned int)p->controlResourceSetZero);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "searchSpaceZero := %u", (unsigned int)p->searchSpaceZero);
}

static const char* adbgNrSys__SQN_NR_MIB_cellBarred_e__ToString(SQN_NR_MIB_cellBarred_e v)
{
	switch(v) {
		case SQN_NR_MIB_cellBarred_e_barred: return "SQN_NR_MIB_cellBarred_e_barred";
		case SQN_NR_MIB_cellBarred_e_notBarred: return "SQN_NR_MIB_cellBarred_e_notBarred";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_MIB_intraFreqReselection_e__ToString(SQN_NR_MIB_intraFreqReselection_e v)
{
	switch(v) {
		case SQN_NR_MIB_intraFreqReselection_e_allowed: return "SQN_NR_MIB_intraFreqReselection_e_allowed";
		case SQN_NR_MIB_intraFreqReselection_e_notAllowed: return "SQN_NR_MIB_intraFreqReselection_e_notAllowed";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MIB(acpCtx_t _ctx, const struct SQN_NR_MIB* p)
{
	adbgPrintLog(_ctx, "systemFrameNumber := '");
	for (size_t i1 = 0; i1 < 6; i1++) {
		adbgPrintLog(_ctx, "%02X", p->systemFrameNumber[i1]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "subCarrierSpacingCommon := %s (%d)", adbgNrSys__SQN_NR_MIB_subCarrierSpacingCommon_e__ToString(p->subCarrierSpacingCommon), (int)p->subCarrierSpacingCommon);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_SubcarrierOffset := %u", (unsigned int)p->ssb_SubcarrierOffset);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dmrs_TypeA_Position := %s (%d)", adbgNrSys__SQN_NR_MIB_dmrs_TypeA_Position_e__ToString(p->dmrs_TypeA_Position), (int)p->dmrs_TypeA_Position);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "pdcch_ConfigSIB1 := { ");
	_adbgNrSys__SQN_NR_PDCCH_ConfigSIB1(_ctx, &p->pdcch_ConfigSIB1);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellBarred := %s (%d)", adbgNrSys__SQN_NR_MIB_cellBarred_e__ToString(p->cellBarred), (int)p->cellBarred);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqReselection := %s (%d)", adbgNrSys__SQN_NR_MIB_intraFreqReselection_e__ToString(p->intraFreqReselection), (int)p->intraFreqReselection);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "spare := '");
	for (size_t i1 = 0; i1 < 1; i1++) {
		adbgPrintLog(_ctx, "%02X", p->spare[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_BCCH_BCH_MessageType_messageClassExtension(acpCtx_t _ctx, const struct SQN_NR_BCCH_BCH_MessageType_messageClassExtension* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_BCCH_BCH_MessageType_Value(acpCtx_t _ctx, const union SQN_NR_BCCH_BCH_MessageType_Value* p, enum SQN_NR_BCCH_BCH_MessageType_Sel d)
{
	if (d == SQN_NR_BCCH_BCH_MessageType_mib) {
		adbgPrintLog(_ctx, "mib := { ");
		_adbgNrSys__SQN_NR_MIB(_ctx, &p->mib);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_BCCH_BCH_MessageType_messageClassExtension) {
		adbgPrintLog(_ctx, "messageClassExtension := { ");
		_adbgNrSys__SQN_NR_BCCH_BCH_MessageType_messageClassExtension(_ctx, &p->messageClassExtension);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_BCCH_BCH_MessageType(acpCtx_t _ctx, const struct SQN_NR_BCCH_BCH_MessageType* p)
{
	_adbgNrSys__SQN_NR_BCCH_BCH_MessageType_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_BCCH_BCH_Message(acpCtx_t _ctx, const struct SQN_NR_BCCH_BCH_Message* p)
{
	adbgPrintLog(_ctx, "message := { ");
	_adbgNrSys__SQN_NR_BCCH_BCH_MessageType(_ctx, &p->message);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_BCCH_BCH_Message_MIB_Optional(acpCtx_t _ctx, const struct SQN_NR_BCCH_BCH_Message_MIB_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_BCCH_BCH_Message(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_SIB2_cellReselectionInfoCommon_nrofSS_BlocksToAverage_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_SIB2_cellReselectionInfoCommon_nrofSS_BlocksToAverage_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_ThresholdNR_thresholdRSRP_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_Range_SQN_NR_ThresholdNR_thresholdRSRP_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RSRQ_Range_SQN_NR_ThresholdNR_thresholdRSRQ_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRQ_Range_SQN_NR_ThresholdNR_thresholdRSRQ_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SINR_Range_SQN_NR_ThresholdNR_thresholdSINR_Optional(acpCtx_t _ctx, const struct SQN_NR_SINR_Range_SQN_NR_ThresholdNR_thresholdSINR_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ThresholdNR(acpCtx_t _ctx, const struct SQN_NR_ThresholdNR* p)
{
	adbgPrintLog(_ctx, "thresholdRSRP := ");
	_adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_ThresholdNR_thresholdRSRP_Optional(_ctx, &p->thresholdRSRP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdRSRQ := ");
	_adbgNrSys__SQN_NR_RSRQ_Range_SQN_NR_ThresholdNR_thresholdRSRQ_Optional(_ctx, &p->thresholdRSRQ);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "thresholdSINR := ");
	_adbgNrSys__SQN_NR_SINR_Range_SQN_NR_ThresholdNR_thresholdSINR_Optional(_ctx, &p->thresholdSINR);
}

static void _adbgNrSys__SQN_NR_ThresholdNR_SQN_NR_SIB2_cellReselectionInfoCommon_absThreshSS_BlocksConsolidation_Optional(acpCtx_t _ctx, const struct SQN_NR_ThresholdNR_SQN_NR_SIB2_cellReselectionInfoCommon_absThreshSS_BlocksConsolidation_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_ThresholdNR(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_Q_OffsetRange_e__ToString(SQN_NR_Q_OffsetRange_e v)
{
	switch(v) {
		case SQN_NR_Q_OffsetRange_e_dB_24: return "SQN_NR_Q_OffsetRange_e_dB_24";
		case SQN_NR_Q_OffsetRange_e_dB_22: return "SQN_NR_Q_OffsetRange_e_dB_22";
		case SQN_NR_Q_OffsetRange_e_dB_20: return "SQN_NR_Q_OffsetRange_e_dB_20";
		case SQN_NR_Q_OffsetRange_e_dB_18: return "SQN_NR_Q_OffsetRange_e_dB_18";
		case SQN_NR_Q_OffsetRange_e_dB_16: return "SQN_NR_Q_OffsetRange_e_dB_16";
		case SQN_NR_Q_OffsetRange_e_dB_14: return "SQN_NR_Q_OffsetRange_e_dB_14";
		case SQN_NR_Q_OffsetRange_e_dB_12: return "SQN_NR_Q_OffsetRange_e_dB_12";
		case SQN_NR_Q_OffsetRange_e_dB_10: return "SQN_NR_Q_OffsetRange_e_dB_10";
		case SQN_NR_Q_OffsetRange_e_dB_8: return "SQN_NR_Q_OffsetRange_e_dB_8";
		case SQN_NR_Q_OffsetRange_e_dB_6: return "SQN_NR_Q_OffsetRange_e_dB_6";
		case SQN_NR_Q_OffsetRange_e_dB_5: return "SQN_NR_Q_OffsetRange_e_dB_5";
		case SQN_NR_Q_OffsetRange_e_dB_4: return "SQN_NR_Q_OffsetRange_e_dB_4";
		case SQN_NR_Q_OffsetRange_e_dB_3: return "SQN_NR_Q_OffsetRange_e_dB_3";
		case SQN_NR_Q_OffsetRange_e_dB_2: return "SQN_NR_Q_OffsetRange_e_dB_2";
		case SQN_NR_Q_OffsetRange_e_dB_1: return "SQN_NR_Q_OffsetRange_e_dB_1";
		case SQN_NR_Q_OffsetRange_e_dB0: return "SQN_NR_Q_OffsetRange_e_dB0";
		case SQN_NR_Q_OffsetRange_e_dB1: return "SQN_NR_Q_OffsetRange_e_dB1";
		case SQN_NR_Q_OffsetRange_e_dB2: return "SQN_NR_Q_OffsetRange_e_dB2";
		case SQN_NR_Q_OffsetRange_e_dB3: return "SQN_NR_Q_OffsetRange_e_dB3";
		case SQN_NR_Q_OffsetRange_e_dB4: return "SQN_NR_Q_OffsetRange_e_dB4";
		case SQN_NR_Q_OffsetRange_e_dB5: return "SQN_NR_Q_OffsetRange_e_dB5";
		case SQN_NR_Q_OffsetRange_e_dB6: return "SQN_NR_Q_OffsetRange_e_dB6";
		case SQN_NR_Q_OffsetRange_e_dB8: return "SQN_NR_Q_OffsetRange_e_dB8";
		case SQN_NR_Q_OffsetRange_e_dB10: return "SQN_NR_Q_OffsetRange_e_dB10";
		case SQN_NR_Q_OffsetRange_e_dB12: return "SQN_NR_Q_OffsetRange_e_dB12";
		case SQN_NR_Q_OffsetRange_e_dB14: return "SQN_NR_Q_OffsetRange_e_dB14";
		case SQN_NR_Q_OffsetRange_e_dB16: return "SQN_NR_Q_OffsetRange_e_dB16";
		case SQN_NR_Q_OffsetRange_e_dB18: return "SQN_NR_Q_OffsetRange_e_dB18";
		case SQN_NR_Q_OffsetRange_e_dB20: return "SQN_NR_Q_OffsetRange_e_dB20";
		case SQN_NR_Q_OffsetRange_e_dB22: return "SQN_NR_Q_OffsetRange_e_dB22";
		case SQN_NR_Q_OffsetRange_e_dB24: return "SQN_NR_Q_OffsetRange_e_dB24";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_Q_OffsetRange_e_SQN_NR_SIB2_cellReselectionInfoCommon_rangeToBestCell_Optional(acpCtx_t _ctx, const struct SQN_NR_Q_OffsetRange_e_SQN_NR_SIB2_cellReselectionInfoCommon_rangeToBestCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_Q_OffsetRange_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e__ToString(SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e v)
{
	switch(v) {
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB0: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB0";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB1: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB1";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB2: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB2";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB3: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB3";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB4: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB4";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB5: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB5";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB6: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB6";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB8: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB8";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB10: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB10";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB12: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB12";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB14: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB14";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB16: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB16";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB18: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB18";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB20: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB20";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB22: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB22";
		case SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB24: return "SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e_dB24";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_MobilityStateParameters_t_Evaluation_e__ToString(SQN_NR_MobilityStateParameters_t_Evaluation_e v)
{
	switch(v) {
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_s30: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_s30";
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_s60: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_s60";
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_s120: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_s120";
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_s180: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_s180";
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_s240: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_s240";
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_spare3: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_spare3";
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_spare2: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_spare2";
		case SQN_NR_MobilityStateParameters_t_Evaluation_e_spare1: return "SQN_NR_MobilityStateParameters_t_Evaluation_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_MobilityStateParameters_t_HystNormal_e__ToString(SQN_NR_MobilityStateParameters_t_HystNormal_e v)
{
	switch(v) {
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_s30: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_s30";
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_s60: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_s60";
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_s120: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_s120";
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_s180: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_s180";
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_s240: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_s240";
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_spare3: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_spare3";
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_spare2: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_spare2";
		case SQN_NR_MobilityStateParameters_t_HystNormal_e_spare1: return "SQN_NR_MobilityStateParameters_t_HystNormal_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_MobilityStateParameters(acpCtx_t _ctx, const struct SQN_NR_MobilityStateParameters* p)
{
	adbgPrintLog(_ctx, "t_Evaluation := %s (%d)", adbgNrSys__SQN_NR_MobilityStateParameters_t_Evaluation_e__ToString(p->t_Evaluation), (int)p->t_Evaluation);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_HystNormal := %s (%d)", adbgNrSys__SQN_NR_MobilityStateParameters_t_HystNormal_e__ToString(p->t_HystNormal), (int)p->t_HystNormal);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n_CellChangeMedium := %u", (unsigned int)p->n_CellChangeMedium);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "n_CellChangeHigh := %u", (unsigned int)p->n_CellChangeHigh);
}

static const char* adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e__ToString(SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e v)
{
	switch(v) {
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB_6: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB_6";
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB_4: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB_4";
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB_2: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB_2";
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB0: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e_dB0";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e__ToString(SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e v)
{
	switch(v) {
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB_6: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB_6";
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB_4: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB_4";
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB_2: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB_2";
		case SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB0: return "SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e_dB0";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(acpCtx_t _ctx, const struct SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF* p)
{
	adbgPrintLog(_ctx, "sf_Medium := %s (%d)", adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_Medium_e__ToString(p->sf_Medium), (int)p->sf_Medium);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sf_High := %s (%d)", adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSFsf_High_e__ToString(p->sf_High), (int)p->sf_High);
}

static void _adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars(acpCtx_t _ctx, const struct SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars* p)
{
	adbgPrintLog(_ctx, "mobilityStateParameters := { ");
	_adbgNrSys__SQN_NR_MobilityStateParameters(_ctx, &p->mobilityStateParameters);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_HystSF := { ");
	_adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(_ctx, &p->q_HystSF);
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(acpCtx_t _ctx, const struct SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon(acpCtx_t _ctx, const struct SQN_NR_SIB2_cellReselectionInfoCommon* p)
{
	adbgPrintLog(_ctx, "nrofSS_BlocksToAverage := ");
	_adbgNrSys__Uint8_t_SQN_NR_SIB2_cellReselectionInfoCommon_nrofSS_BlocksToAverage_Optional(_ctx, &p->nrofSS_BlocksToAverage);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "absThreshSS_BlocksConsolidation := ");
	if (p->absThreshSS_BlocksConsolidation.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ThresholdNR_SQN_NR_SIB2_cellReselectionInfoCommon_absThreshSS_BlocksConsolidation_Optional(_ctx, &p->absThreshSS_BlocksConsolidation);
	if (p->absThreshSS_BlocksConsolidation.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "rangeToBestCell := ");
	_adbgNrSys__SQN_NR_Q_OffsetRange_e_SQN_NR_SIB2_cellReselectionInfoCommon_rangeToBestCell_Optional(_ctx, &p->rangeToBestCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_Hyst := %s (%d)", adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_q_Hyst_e__ToString(p->q_Hyst), (int)p->q_Hyst);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "speedStateReselectionPars := ");
	if (p->speedStateReselectionPars.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(_ctx, &p->speedStateReselectionPars);
	if (p->speedStateReselectionPars.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_ReselectionThreshold_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchP_Optional(acpCtx_t _ctx, const struct SQN_NR_ReselectionThreshold_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchP_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchQ_Optional(acpCtx_t _ctx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchQ_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_threshServingLowQ_Optional(acpCtx_t _ctx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_threshServingLowQ_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_CellReselectionSubPriority_e__ToString(SQN_NR_CellReselectionSubPriority_e v)
{
	switch(v) {
		case SQN_NR_CellReselectionSubPriority_e_oDot2: return "SQN_NR_CellReselectionSubPriority_e_oDot2";
		case SQN_NR_CellReselectionSubPriority_e_oDot4: return "SQN_NR_CellReselectionSubPriority_e_oDot4";
		case SQN_NR_CellReselectionSubPriority_e_oDot6: return "SQN_NR_CellReselectionSubPriority_e_oDot6";
		case SQN_NR_CellReselectionSubPriority_e_oDot8: return "SQN_NR_CellReselectionSubPriority_e_oDot8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_CellReselectionSubPriority_e_SQN_NR_SIB2_cellReselectionServingFreqInfo_cellReselectionSubPriority_Optional(acpCtx_t _ctx, const struct SQN_NR_CellReselectionSubPriority_e_SQN_NR_SIB2_cellReselectionServingFreqInfo_cellReselectionSubPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_CellReselectionSubPriority_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SIB2_cellReselectionServingFreqInfo(acpCtx_t _ctx, const struct SQN_NR_SIB2_cellReselectionServingFreqInfo* p)
{
	adbgPrintLog(_ctx, "s_NonIntraSearchP := ");
	_adbgNrSys__SQN_NR_ReselectionThreshold_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchP_Optional(_ctx, &p->s_NonIntraSearchP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_NonIntraSearchQ := ");
	_adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchQ_Optional(_ctx, &p->s_NonIntraSearchQ);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshServingLowP := %u", (unsigned int)p->threshServingLowP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshServingLowQ := ");
	_adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_threshServingLowQ_Optional(_ctx, &p->threshServingLowQ);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := %u", (unsigned int)p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionSubPriority := ");
	_adbgNrSys__SQN_NR_CellReselectionSubPriority_e_SQN_NR_SIB2_cellReselectionServingFreqInfo_cellReselectionSubPriority_Optional(_ctx, &p->cellReselectionSubPriority);
}

static void _adbgNrSys__SQN_NR_Q_RxLevMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_RxLevMinSUL_Optional(acpCtx_t _ctx, const struct SQN_NR_Q_RxLevMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_RxLevMinSUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_Q_QualMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_QualMin_Optional(acpCtx_t _ctx, const struct SQN_NR_Q_QualMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_QualMin_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_intraFreqCellReselectionInfo_s_IntraSearchQ_Optional(acpCtx_t _ctx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_intraFreqCellReselectionInfo_s_IntraSearchQ_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_FreqBandIndicatorNR_SQN_NR_NR_MultiBandInfo_freqBandIndicatorNR_Optional(acpCtx_t _ctx, const struct SQN_NR_FreqBandIndicatorNR_SQN_NR_NR_MultiBandInfo_freqBandIndicatorNR_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_P_Max_SQN_NR_NR_NS_PmaxValue_additionalPmax_Optional(acpCtx_t _ctx, const struct SQN_NR_P_Max_SQN_NR_NR_NS_PmaxValue_additionalPmax_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_NR_NS_PmaxValue(acpCtx_t _ctx, const struct SQN_NR_NR_NS_PmaxValue* p)
{
	adbgPrintLog(_ctx, "additionalPmax := ");
	_adbgNrSys__SQN_NR_P_Max_SQN_NR_NR_NS_PmaxValue_additionalPmax_Optional(_ctx, &p->additionalPmax);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmission := %u", (unsigned int)p->additionalSpectrumEmission);
}

static void _adbgNrSys__SQN_NR_NR_NS_PmaxList_SQN_NR_NR_MultiBandInfo_nr_NS_PmaxList_Optional(acpCtx_t _ctx, const struct SQN_NR_NR_NS_PmaxList_SQN_NR_NR_MultiBandInfo_nr_NS_PmaxList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_NR_NS_PmaxValue(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_NR_MultiBandInfo(acpCtx_t _ctx, const struct SQN_NR_NR_MultiBandInfo* p)
{
	adbgPrintLog(_ctx, "freqBandIndicatorNR := ");
	_adbgNrSys__SQN_NR_FreqBandIndicatorNR_SQN_NR_NR_MultiBandInfo_freqBandIndicatorNR_Optional(_ctx, &p->freqBandIndicatorNR);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nr_NS_PmaxList := ");
	if (p->nr_NS_PmaxList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_NR_NS_PmaxList_SQN_NR_NR_MultiBandInfo_nr_NS_PmaxList_Optional(_ctx, &p->nr_NS_PmaxList);
	if (p->nr_NS_PmaxList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandList_Optional(acpCtx_t _ctx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_NR_MultiBandInfo(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandListSUL_Optional(acpCtx_t _ctx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandListSUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_NR_MultiBandInfo(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_P_Max_SQN_NR_SIB2_intraFreqCellReselectionInfo_p_Max_Optional(acpCtx_t _ctx, const struct SQN_NR_P_Max_SQN_NR_SIB2_intraFreqCellReselectionInfo_p_Max_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_SSB_MTC_periodicityAndOffset_Value(acpCtx_t _ctx, const union SQN_NR_SSB_MTC_periodicityAndOffset_Value* p, enum SQN_NR_SSB_MTC_periodicityAndOffset_Sel d)
{
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf5) {
		adbgPrintLog(_ctx, "sf5 := %u", (unsigned int)p->sf5);
		return;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf10) {
		adbgPrintLog(_ctx, "sf10 := %u", (unsigned int)p->sf10);
		return;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf20) {
		adbgPrintLog(_ctx, "sf20 := %u", (unsigned int)p->sf20);
		return;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf40) {
		adbgPrintLog(_ctx, "sf40 := %u", (unsigned int)p->sf40);
		return;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf80) {
		adbgPrintLog(_ctx, "sf80 := %u", (unsigned int)p->sf80);
		return;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf160) {
		adbgPrintLog(_ctx, "sf160 := %u", (unsigned int)p->sf160);
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SSB_MTC_periodicityAndOffset(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC_periodicityAndOffset* p)
{
	_adbgNrSys__SQN_NR_SSB_MTC_periodicityAndOffset_Value(_ctx, &p->v, p->d);
}

static const char* adbgNrSys__SQN_NR_SSB_MTC_duration_e__ToString(SQN_NR_SSB_MTC_duration_e v)
{
	switch(v) {
		case SQN_NR_SSB_MTC_duration_e_sf1: return "SQN_NR_SSB_MTC_duration_e_sf1";
		case SQN_NR_SSB_MTC_duration_e_sf2: return "SQN_NR_SSB_MTC_duration_e_sf2";
		case SQN_NR_SSB_MTC_duration_e_sf3: return "SQN_NR_SSB_MTC_duration_e_sf3";
		case SQN_NR_SSB_MTC_duration_e_sf4: return "SQN_NR_SSB_MTC_duration_e_sf4";
		case SQN_NR_SSB_MTC_duration_e_sf5: return "SQN_NR_SSB_MTC_duration_e_sf5";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SSB_MTC(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC* p)
{
	adbgPrintLog(_ctx, "periodicityAndOffset := { ");
	_adbgNrSys__SQN_NR_SSB_MTC_periodicityAndOffset(_ctx, &p->periodicityAndOffset);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "duration := %s (%d)", adbgNrSys__SQN_NR_SSB_MTC_duration_e__ToString(p->duration), (int)p->duration);
}

static void _adbgNrSys__SQN_NR_SSB_MTC_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_MTC(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SS_RSSI_Measurement(acpCtx_t _ctx, const struct SQN_NR_SS_RSSI_Measurement* p)
{
	adbgPrintLog(_ctx, "measurementSlots := '");
	for (size_t i2 = 0; i2 < p->measurementSlots.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->measurementSlots.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "endSymbol := %u", (unsigned int)p->endSymbol);
}

static void _adbgNrSys__SQN_NR_SS_RSSI_Measurement_SQN_NR_SIB2_intraFreqCellReselectionInfo_ss_RSSI_Measurement_Optional(acpCtx_t _ctx, const struct SQN_NR_SS_RSSI_Measurement_SQN_NR_SIB2_intraFreqCellReselectionInfo_ss_RSSI_Measurement_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SS_RSSI_Measurement(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SSB_ToMeasure_Value(acpCtx_t _ctx, const union SQN_NR_SSB_ToMeasure_Value* p, enum SQN_NR_SSB_ToMeasure_Sel d)
{
	if (d == SQN_NR_SSB_ToMeasure_shortBitmap) {
		adbgPrintLog(_ctx, "shortBitmap := '");
		for (size_t i2 = 0; i2 < 4; i2++) {
			adbgPrintLog(_ctx, "%02X", p->shortBitmap[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_SSB_ToMeasure_mediumBitmap) {
		adbgPrintLog(_ctx, "mediumBitmap := '");
		for (size_t i2 = 0; i2 < 8; i2++) {
			adbgPrintLog(_ctx, "%02X", p->mediumBitmap[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	if (d == SQN_NR_SSB_ToMeasure_longBitmap) {
		adbgPrintLog(_ctx, "longBitmap := '");
		for (size_t i2 = 0; i2 < 64; i2++) {
			adbgPrintLog(_ctx, "%02X", p->longBitmap[i2]);
		}
		adbgPrintLog(_ctx, "'O");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SSB_ToMeasure(acpCtx_t _ctx, const struct SQN_NR_SSB_ToMeasure* p)
{
	_adbgNrSys__SQN_NR_SSB_ToMeasure_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__SQN_NR_SSB_ToMeasure_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_ToMeasure_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_ToMeasure_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_ToMeasure_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_ToMeasure(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SpeedStateScaleFactors_sf_Medium_e__ToString(SQN_NR_SpeedStateScaleFactors_sf_Medium_e v)
{
	switch(v) {
		case SQN_NR_SpeedStateScaleFactors_sf_Medium_e_oDot25: return "SQN_NR_SpeedStateScaleFactors_sf_Medium_e_oDot25";
		case SQN_NR_SpeedStateScaleFactors_sf_Medium_e_oDot5: return "SQN_NR_SpeedStateScaleFactors_sf_Medium_e_oDot5";
		case SQN_NR_SpeedStateScaleFactors_sf_Medium_e_oDot75: return "SQN_NR_SpeedStateScaleFactors_sf_Medium_e_oDot75";
		case SQN_NR_SpeedStateScaleFactors_sf_Medium_e_lDot0: return "SQN_NR_SpeedStateScaleFactors_sf_Medium_e_lDot0";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SpeedStateScaleFactors_sf_High_e__ToString(SQN_NR_SpeedStateScaleFactors_sf_High_e v)
{
	switch(v) {
		case SQN_NR_SpeedStateScaleFactors_sf_High_e_oDot25: return "SQN_NR_SpeedStateScaleFactors_sf_High_e_oDot25";
		case SQN_NR_SpeedStateScaleFactors_sf_High_e_oDot5: return "SQN_NR_SpeedStateScaleFactors_sf_High_e_oDot5";
		case SQN_NR_SpeedStateScaleFactors_sf_High_e_oDot75: return "SQN_NR_SpeedStateScaleFactors_sf_High_e_oDot75";
		case SQN_NR_SpeedStateScaleFactors_sf_High_e_lDot0: return "SQN_NR_SpeedStateScaleFactors_sf_High_e_lDot0";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SpeedStateScaleFactors(acpCtx_t _ctx, const struct SQN_NR_SpeedStateScaleFactors* p)
{
	adbgPrintLog(_ctx, "sf_Medium := %s (%d)", adbgNrSys__SQN_NR_SpeedStateScaleFactors_sf_Medium_e__ToString(p->sf_Medium), (int)p->sf_Medium);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sf_High := %s (%d)", adbgNrSys__SQN_NR_SpeedStateScaleFactors_sf_High_e__ToString(p->sf_High), (int)p->sf_High);
}

static void _adbgNrSys__SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB2_intraFreqCellReselectionInfo_t_ReselectionNR_SF_Optional(acpCtx_t _ctx, const struct SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB2_intraFreqCellReselectionInfo_t_ReselectionNR_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_PhysCellId_SQN_NR_SSB_MTC2_LP_r16_pci_List_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_PhysCellId_SQN_NR_SSB_MTC2_LP_r16_pci_List_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_SSB_MTC2_LP_r16_periodicity_e__ToString(SQN_NR_SSB_MTC2_LP_r16_periodicity_e v)
{
	switch(v) {
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf10: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf10";
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf20: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf20";
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf40: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf40";
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf80: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf80";
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf160: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_sf160";
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_spare3: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_spare3";
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_spare2: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_spare2";
		case SQN_NR_SSB_MTC2_LP_r16_periodicity_e_spare1: return "SQN_NR_SSB_MTC2_LP_r16_periodicity_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SSB_MTC2_LP_r16(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC2_LP_r16* p)
{
	adbgPrintLog(_ctx, "pci_List := ");
	_adbgNrSys__SQN_NR_PhysCellId_SQN_NR_SSB_MTC2_LP_r16_pci_List_DynamicOptional(_ctx, &p->pci_List);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "periodicity := %s (%d)", adbgNrSys__SQN_NR_SSB_MTC2_LP_r16_periodicity_e__ToString(p->periodicity), (int)p->periodicity);
}

static void _adbgNrSys__SQN_NR_SSB_MTC2_LP_r16_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc2_LP_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC2_LP_r16_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc2_LP_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_MTC2_LP_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e__ToString(SQN_NR_SSB_PositionQCL_Relation_r16_e v)
{
	switch(v) {
		case SQN_NR_SSB_PositionQCL_Relation_r16_e_n1: return "SQN_NR_SSB_PositionQCL_Relation_r16_e_n1";
		case SQN_NR_SSB_PositionQCL_Relation_r16_e_n2: return "SQN_NR_SSB_PositionQCL_Relation_r16_e_n2";
		case SQN_NR_SSB_PositionQCL_Relation_r16_e_n4: return "SQN_NR_SSB_PositionQCL_Relation_r16_e_n4";
		case SQN_NR_SSB_PositionQCL_Relation_r16_e_n8: return "SQN_NR_SSB_PositionQCL_Relation_r16_e_n8";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_PositionQCL_Common_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_PositionQCL_Common_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SIB2_intraFreqCellReselectionInfo(acpCtx_t _ctx, const struct SQN_NR_SIB2_intraFreqCellReselectionInfo* p)
{
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinSUL := ");
	_adbgNrSys__SQN_NR_Q_RxLevMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_RxLevMinSUL_Optional(_ctx, &p->q_RxLevMinSUL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin := ");
	_adbgNrSys__SQN_NR_Q_QualMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_QualMin_Optional(_ctx, &p->q_QualMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_IntraSearchP := %u", (unsigned int)p->s_IntraSearchP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_IntraSearchQ := ");
	_adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_intraFreqCellReselectionInfo_s_IntraSearchQ_Optional(_ctx, &p->s_IntraSearchQ);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionNR := %u", (unsigned int)p->t_ReselectionNR);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyBandList := ");
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandList_Optional(_ctx, &p->frequencyBandList);
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyBandListSUL := ");
	if (p->frequencyBandListSUL.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandListSUL_Optional(_ctx, &p->frequencyBandListSUL);
	if (p->frequencyBandListSUL.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_Max := ");
	_adbgNrSys__SQN_NR_P_Max_SQN_NR_SIB2_intraFreqCellReselectionInfo_p_Max_Optional(_ctx, &p->p_Max);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "smtc := ");
	if (p->smtc.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_MTC_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc_Optional(_ctx, &p->smtc);
	if (p->smtc.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ss_RSSI_Measurement := ");
	if (p->ss_RSSI_Measurement.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SS_RSSI_Measurement_SQN_NR_SIB2_intraFreqCellReselectionInfo_ss_RSSI_Measurement_Optional(_ctx, &p->ss_RSSI_Measurement);
	if (p->ss_RSSI_Measurement.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_ToMeasure := ");
	if (p->ssb_ToMeasure.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_ToMeasure_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_ToMeasure_Optional(_ctx, &p->ssb_ToMeasure);
	if (p->ssb_ToMeasure.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deriveSSB_IndexFromCell := %s", (p->deriveSSB_IndexFromCell ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionNR_SF := ");
	if (p->t_ReselectionNR_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB2_intraFreqCellReselectionInfo_t_ReselectionNR_SF_Optional(_ctx, &p->t_ReselectionNR_SF);
	if (p->t_ReselectionNR_SF.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "smtc2_LP_r16 := ");
	if (p->smtc2_LP_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_MTC2_LP_r16_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc2_LP_r16_Optional(_ctx, &p->smtc2_LP_r16);
	if (p->smtc2_LP_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_PositionQCL_Common_r16 := ");
	_adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_PositionQCL_Common_r16_Optional(_ctx, &p->ssb_PositionQCL_Common_r16);
}

static const char* adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e__ToString(SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e v)
{
	switch(v) {
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB3: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB3";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB6: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB6";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB9: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB9";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB12: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB12";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB15: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_dB15";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_spare3: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_spare3";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_spare2: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_spare2";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_spare1: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e_spare1";
		default: return "Unknown";
	}
}

static const char* adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e__ToString(SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e v)
{
	switch(v) {
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s5: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s5";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s10: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s10";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s20: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s20";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s30: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s30";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s60: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s60";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s120: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s120";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s180: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s180";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s240: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s240";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s300: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_s300";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare7: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare7";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare6: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare6";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare5: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare5";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare4: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare4";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare3: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare3";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare2: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare2";
		case SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare1: return "SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16* p)
{
	adbgPrintLog(_ctx, "s_SearchDeltaP_r16 := %s (%d)", adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_s_SearchDeltaP_r16_e__ToString(p->s_SearchDeltaP_r16), (int)p->s_SearchDeltaP_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_SearchDeltaP_r16 := %s (%d)", adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_t_SearchDeltaP_r16_e__ToString(p->t_SearchDeltaP_r16), (int)p->t_SearchDeltaP_r16);
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_lowMobilityEvaluation_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_lowMobilityEvaluation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_s_SearchThresholdQ_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_s_SearchThresholdQ_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16* p)
{
	adbgPrintLog(_ctx, "s_SearchThresholdP_r16 := %u", (unsigned int)p->s_SearchThresholdP_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "s_SearchThresholdQ_r16 := ");
	_adbgNrSys__SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_s_SearchThresholdQ_r16_Optional(_ctx, &p->s_SearchThresholdQ_r16);
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_cellEdgeEvaluation_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_cellEdgeEvaluation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e__ToString(SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e v)
{
	switch(v) {
		case SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_true: return "SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_combineRelaxedMeasCondition_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_combineRelaxedMeasCondition_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e__ToString(p->v), (int)p->v);
}

static const char* adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e__ToString(SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e v)
{
	switch(v) {
		case SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_true: return "SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_highPriorityMeasRelax_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_highPriorityMeasRelax_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16* p)
{
	adbgPrintLog(_ctx, "lowMobilityEvaluation_r16 := ");
	if (p->lowMobilityEvaluation_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_lowMobilityEvaluation_r16_Optional(_ctx, &p->lowMobilityEvaluation_r16);
	if (p->lowMobilityEvaluation_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellEdgeEvaluation_r16 := ");
	if (p->cellEdgeEvaluation_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_cellEdgeEvaluation_r16_Optional(_ctx, &p->cellEdgeEvaluation_r16);
	if (p->cellEdgeEvaluation_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "combineRelaxedMeasCondition_r16 := ");
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_combineRelaxedMeasCondition_r16_Optional(_ctx, &p->combineRelaxedMeasCondition_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "highPriorityMeasRelax_r16 := ");
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_highPriorityMeasRelax_r16_Optional(_ctx, &p->highPriorityMeasRelax_r16);
}

static void _adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_relaxedMeasurement_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_relaxedMeasurement_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SIB2(acpCtx_t _ctx, const struct SQN_NR_SIB2* p)
{
	adbgPrintLog(_ctx, "cellReselectionInfoCommon := { ");
	_adbgNrSys__SQN_NR_SIB2_cellReselectionInfoCommon(_ctx, &p->cellReselectionInfoCommon);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionServingFreqInfo := { ");
	_adbgNrSys__SQN_NR_SIB2_cellReselectionServingFreqInfo(_ctx, &p->cellReselectionServingFreqInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqCellReselectionInfo := { ");
	_adbgNrSys__SQN_NR_SIB2_intraFreqCellReselectionInfo(_ctx, &p->intraFreqCellReselectionInfo);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "relaxedMeasurement_r16 := ");
	if (p->relaxedMeasurement_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SIB2_relaxedMeasurement_r16_relaxedMeasurement_r16_Optional(_ctx, &p->relaxedMeasurement_r16);
	if (p->relaxedMeasurement_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__Uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_QualMinOffsetCell_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_QualMinOffsetCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_IntraFreqNeighCellInfo(acpCtx_t _ctx, const struct SQN_NR_IntraFreqNeighCellInfo* p)
{
	adbgPrintLog(_ctx, "physCellId := %u", (unsigned int)p->physCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_OffsetCell := %s (%d)", adbgNrSys__SQN_NR_Q_OffsetRange_e__ToString(p->q_OffsetCell), (int)p->q_OffsetCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinOffsetCell := ");
	_adbgNrSys__Uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(_ctx, &p->q_RxLevMinOffsetCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinOffsetCellSUL := ");
	_adbgNrSys__Uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(_ctx, &p->q_RxLevMinOffsetCellSUL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinOffsetCell := ");
	_adbgNrSys__Uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_QualMinOffsetCell_Optional(_ctx, &p->q_QualMinOffsetCell);
}

static void _adbgNrSys__SQN_NR_IntraFreqNeighCellList_SQN_NR_SIB3_intraFreqNeighCellList_Optional(acpCtx_t _ctx, const struct SQN_NR_IntraFreqNeighCellList_SQN_NR_SIB3_intraFreqNeighCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_IntraFreqNeighCellInfo(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_PCI_Range_range_e__ToString(SQN_NR_PCI_Range_range_e v)
{
	switch(v) {
		case SQN_NR_PCI_Range_range_e_n4: return "SQN_NR_PCI_Range_range_e_n4";
		case SQN_NR_PCI_Range_range_e_n8: return "SQN_NR_PCI_Range_range_e_n8";
		case SQN_NR_PCI_Range_range_e_n12: return "SQN_NR_PCI_Range_range_e_n12";
		case SQN_NR_PCI_Range_range_e_n16: return "SQN_NR_PCI_Range_range_e_n16";
		case SQN_NR_PCI_Range_range_e_n24: return "SQN_NR_PCI_Range_range_e_n24";
		case SQN_NR_PCI_Range_range_e_n32: return "SQN_NR_PCI_Range_range_e_n32";
		case SQN_NR_PCI_Range_range_e_n48: return "SQN_NR_PCI_Range_range_e_n48";
		case SQN_NR_PCI_Range_range_e_n64: return "SQN_NR_PCI_Range_range_e_n64";
		case SQN_NR_PCI_Range_range_e_n84: return "SQN_NR_PCI_Range_range_e_n84";
		case SQN_NR_PCI_Range_range_e_n96: return "SQN_NR_PCI_Range_range_e_n96";
		case SQN_NR_PCI_Range_range_e_n128: return "SQN_NR_PCI_Range_range_e_n128";
		case SQN_NR_PCI_Range_range_e_n168: return "SQN_NR_PCI_Range_range_e_n168";
		case SQN_NR_PCI_Range_range_e_n252: return "SQN_NR_PCI_Range_range_e_n252";
		case SQN_NR_PCI_Range_range_e_n504: return "SQN_NR_PCI_Range_range_e_n504";
		case SQN_NR_PCI_Range_range_e_n1008: return "SQN_NR_PCI_Range_range_e_n1008";
		case SQN_NR_PCI_Range_range_e_spare1: return "SQN_NR_PCI_Range_range_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_PCI_Range_range_e_range_Optional(acpCtx_t _ctx, const struct SQN_NR_PCI_Range_range_e_range_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_PCI_Range_range_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_PCI_Range(acpCtx_t _ctx, const struct SQN_NR_PCI_Range* p)
{
	adbgPrintLog(_ctx, "start := %u", (unsigned int)p->start);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "range := ");
	_adbgNrSys__SQN_NR_PCI_Range_range_e_range_Optional(_ctx, &p->range);
}

static void _adbgNrSys__SQN_NR_IntraFreqBlackCellList_SQN_NR_SIB3_intraFreqBlackCellList_Optional(acpCtx_t _ctx, const struct SQN_NR_IntraFreqBlackCellList_SQN_NR_SIB3_intraFreqBlackCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_PCI_Range(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB3_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB3_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_IntraFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_IntraFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_IntraFreqNeighCellInfo_v1610(acpCtx_t _ctx, const struct SQN_NR_IntraFreqNeighCellInfo_v1610* p)
{
	adbgPrintLog(_ctx, "ssb_PositionQCL_r16 := ");
	_adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_IntraFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(_ctx, &p->ssb_PositionQCL_r16);
}

static void _adbgNrSys__SQN_NR_IntraFreqNeighCellList_v1610_SQN_NR_SIB3_intraFreqNeighCellList_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_IntraFreqNeighCellList_v1610_SQN_NR_SIB3_intraFreqNeighCellList_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_IntraFreqNeighCellInfo_v1610(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_IntraFreqWhiteCellList_r16_SQN_NR_SIB3_intraFreqWhiteCellList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_IntraFreqWhiteCellList_r16_SQN_NR_SIB3_intraFreqWhiteCellList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_PCI_Range(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_IntraFreqCAG_CellListPerPLMN_r16(acpCtx_t _ctx, const struct SQN_NR_IntraFreqCAG_CellListPerPLMN_r16* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityIndex_r16 := %u", (unsigned int)p->plmn_IdentityIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cag_CellList_r16 := { ");
	for (size_t i3 = 0; i3 < p->cag_CellList_r16.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PCI_Range(_ctx, &p->cag_CellList_r16.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->cag_CellList_r16.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_IntraFreqCAG_CellListPerPLMN_r16_SQN_NR_SIB3_intraFreqCAG_CellList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_IntraFreqCAG_CellListPerPLMN_r16_SQN_NR_SIB3_intraFreqCAG_CellList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_IntraFreqCAG_CellListPerPLMN_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SIB3(acpCtx_t _ctx, const struct SQN_NR_SIB3* p)
{
	adbgPrintLog(_ctx, "intraFreqNeighCellList := ");
	if (p->intraFreqNeighCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_IntraFreqNeighCellList_SQN_NR_SIB3_intraFreqNeighCellList_Optional(_ctx, &p->intraFreqNeighCellList);
	if (p->intraFreqNeighCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqBlackCellList := ");
	if (p->intraFreqBlackCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_IntraFreqBlackCellList_SQN_NR_SIB3_intraFreqBlackCellList_Optional(_ctx, &p->intraFreqBlackCellList);
	if (p->intraFreqBlackCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB3_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqNeighCellList_v1610 := ");
	if (p->intraFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_IntraFreqNeighCellList_v1610_SQN_NR_SIB3_intraFreqNeighCellList_v1610_Optional(_ctx, &p->intraFreqNeighCellList_v1610);
	if (p->intraFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqWhiteCellList_r16 := ");
	if (p->intraFreqWhiteCellList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_IntraFreqWhiteCellList_r16_SQN_NR_SIB3_intraFreqWhiteCellList_r16_Optional(_ctx, &p->intraFreqWhiteCellList_r16);
	if (p->intraFreqWhiteCellList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "intraFreqCAG_CellList_r16 := ");
	if (p->intraFreqCAG_CellList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_IntraFreqCAG_CellListPerPLMN_r16_SQN_NR_SIB3_intraFreqCAG_CellList_r16_DynamicOptional(_ctx, &p->intraFreqCAG_CellList_r16);
	if (p->intraFreqCAG_CellList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandList_Optional(acpCtx_t _ctx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_NR_MultiBandInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandListSUL_Optional(acpCtx_t _ctx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandListSUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_NR_MultiBandInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_InterFreqCarrierFreqInfo_nrofSS_BlocksToAverage_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_InterFreqCarrierFreqInfo_nrofSS_BlocksToAverage_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ThresholdNR_SQN_NR_InterFreqCarrierFreqInfo_absThreshSS_BlocksConsolidation_Optional(acpCtx_t _ctx, const struct SQN_NR_ThresholdNR_SQN_NR_InterFreqCarrierFreqInfo_absThreshSS_BlocksConsolidation_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_ThresholdNR(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SSB_MTC_SQN_NR_InterFreqCarrierFreqInfo_smtc_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC_SQN_NR_InterFreqCarrierFreqInfo_smtc_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_MTC(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SSB_ToMeasure_SQN_NR_InterFreqCarrierFreqInfo_ssb_ToMeasure_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_ToMeasure_SQN_NR_InterFreqCarrierFreqInfo_ssb_ToMeasure_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_ToMeasure(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SS_RSSI_Measurement_SQN_NR_InterFreqCarrierFreqInfo_ss_RSSI_Measurement_Optional(acpCtx_t _ctx, const struct SQN_NR_SS_RSSI_Measurement_SQN_NR_InterFreqCarrierFreqInfo_ss_RSSI_Measurement_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SS_RSSI_Measurement(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_Q_RxLevMin_SQN_NR_InterFreqCarrierFreqInfo_q_RxLevMinSUL_Optional(acpCtx_t _ctx, const struct SQN_NR_Q_RxLevMin_SQN_NR_InterFreqCarrierFreqInfo_q_RxLevMinSUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_Q_QualMin_SQN_NR_InterFreqCarrierFreqInfo_q_QualMin_Optional(acpCtx_t _ctx, const struct SQN_NR_Q_QualMin_SQN_NR_InterFreqCarrierFreqInfo_q_QualMin_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_P_Max_SQN_NR_InterFreqCarrierFreqInfo_p_Max_Optional(acpCtx_t _ctx, const struct SQN_NR_P_Max_SQN_NR_InterFreqCarrierFreqInfo_p_Max_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_SpeedStateScaleFactors_SQN_NR_InterFreqCarrierFreqInfo_t_ReselectionNR_SF_Optional(acpCtx_t _ctx, const struct SQN_NR_SpeedStateScaleFactors_SQN_NR_InterFreqCarrierFreqInfo_t_ReselectionNR_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo_threshX_Q(acpCtx_t _ctx, const struct SQN_NR_InterFreqCarrierFreqInfo_threshX_Q* p)
{
	adbgPrintLog(_ctx, "threshX_HighQ := %u", (unsigned int)p->threshX_HighQ);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowQ := %u", (unsigned int)p->threshX_LowQ);
}

static void _adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo_threshX_Q_threshX_Q_Optional(acpCtx_t _ctx, const struct SQN_NR_InterFreqCarrierFreqInfo_threshX_Q_threshX_Q_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo_threshX_Q(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_CellReselectionPriority_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(acpCtx_t _ctx, const struct SQN_NR_CellReselectionPriority_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_CellReselectionSubPriority_e_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionSubPriority_Optional(acpCtx_t _ctx, const struct SQN_NR_CellReselectionSubPriority_e_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionSubPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_CellReselectionSubPriority_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_Q_OffsetRange_e_SQN_NR_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(acpCtx_t _ctx, const struct SQN_NR_Q_OffsetRange_e_SQN_NR_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_Q_OffsetRange_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_InterFreqNeighCellInfo_q_QualMinOffsetCell_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_InterFreqNeighCellInfo_q_QualMinOffsetCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_InterFreqNeighCellInfo(acpCtx_t _ctx, const struct SQN_NR_InterFreqNeighCellInfo* p)
{
	adbgPrintLog(_ctx, "physCellId := %u", (unsigned int)p->physCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_OffsetCell := %s (%d)", adbgNrSys__SQN_NR_Q_OffsetRange_e__ToString(p->q_OffsetCell), (int)p->q_OffsetCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinOffsetCell := ");
	_adbgNrSys__Uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(_ctx, &p->q_RxLevMinOffsetCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinOffsetCellSUL := ");
	_adbgNrSys__Uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(_ctx, &p->q_RxLevMinOffsetCellSUL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinOffsetCell := ");
	_adbgNrSys__Uint8_t_SQN_NR_InterFreqNeighCellInfo_q_QualMinOffsetCell_Optional(_ctx, &p->q_QualMinOffsetCell);
}

static void _adbgNrSys__SQN_NR_InterFreqNeighCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(acpCtx_t _ctx, const struct SQN_NR_InterFreqNeighCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_InterFreqNeighCellInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_InterFreqBlackCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(acpCtx_t _ctx, const struct SQN_NR_InterFreqBlackCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_PCI_Range(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo(acpCtx_t _ctx, const struct SQN_NR_InterFreqCarrierFreqInfo* p)
{
	adbgPrintLog(_ctx, "dl_CarrierFreq := %u", (unsigned int)p->dl_CarrierFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyBandList := ");
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandList_Optional(_ctx, &p->frequencyBandList);
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyBandListSUL := ");
	if (p->frequencyBandListSUL.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandListSUL_Optional(_ctx, &p->frequencyBandListSUL);
	if (p->frequencyBandListSUL.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nrofSS_BlocksToAverage := ");
	_adbgNrSys__Uint8_t_SQN_NR_InterFreqCarrierFreqInfo_nrofSS_BlocksToAverage_Optional(_ctx, &p->nrofSS_BlocksToAverage);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "absThreshSS_BlocksConsolidation := ");
	if (p->absThreshSS_BlocksConsolidation.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ThresholdNR_SQN_NR_InterFreqCarrierFreqInfo_absThreshSS_BlocksConsolidation_Optional(_ctx, &p->absThreshSS_BlocksConsolidation);
	if (p->absThreshSS_BlocksConsolidation.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "smtc := ");
	if (p->smtc.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_MTC_SQN_NR_InterFreqCarrierFreqInfo_smtc_Optional(_ctx, &p->smtc);
	if (p->smtc.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssbSubcarrierSpacing := %s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->ssbSubcarrierSpacing), (int)p->ssbSubcarrierSpacing);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_ToMeasure := ");
	if (p->ssb_ToMeasure.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_ToMeasure_SQN_NR_InterFreqCarrierFreqInfo_ssb_ToMeasure_Optional(_ctx, &p->ssb_ToMeasure);
	if (p->ssb_ToMeasure.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deriveSSB_IndexFromCell := %s", (p->deriveSSB_IndexFromCell ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ss_RSSI_Measurement := ");
	if (p->ss_RSSI_Measurement.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SS_RSSI_Measurement_SQN_NR_InterFreqCarrierFreqInfo_ss_RSSI_Measurement_Optional(_ctx, &p->ss_RSSI_Measurement);
	if (p->ss_RSSI_Measurement.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinSUL := ");
	_adbgNrSys__SQN_NR_Q_RxLevMin_SQN_NR_InterFreqCarrierFreqInfo_q_RxLevMinSUL_Optional(_ctx, &p->q_RxLevMinSUL);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin := ");
	_adbgNrSys__SQN_NR_Q_QualMin_SQN_NR_InterFreqCarrierFreqInfo_q_QualMin_Optional(_ctx, &p->q_QualMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_Max := ");
	_adbgNrSys__SQN_NR_P_Max_SQN_NR_InterFreqCarrierFreqInfo_p_Max_Optional(_ctx, &p->p_Max);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionNR := %u", (unsigned int)p->t_ReselectionNR);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionNR_SF := ");
	if (p->t_ReselectionNR_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SpeedStateScaleFactors_SQN_NR_InterFreqCarrierFreqInfo_t_ReselectionNR_SF_Optional(_ctx, &p->t_ReselectionNR_SF);
	if (p->t_ReselectionNR_SF.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_HighP := %u", (unsigned int)p->threshX_HighP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowP := %u", (unsigned int)p->threshX_LowP);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Q := ");
	if (p->threshX_Q.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo_threshX_Q_threshX_Q_Optional(_ctx, &p->threshX_Q);
	if (p->threshX_Q.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := ");
	_adbgNrSys__SQN_NR_CellReselectionPriority_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(_ctx, &p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionSubPriority := ");
	_adbgNrSys__SQN_NR_CellReselectionSubPriority_e_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionSubPriority_Optional(_ctx, &p->cellReselectionSubPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_OffsetFreq := ");
	_adbgNrSys__SQN_NR_Q_OffsetRange_e_SQN_NR_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(_ctx, &p->q_OffsetFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqNeighCellList := ");
	if (p->interFreqNeighCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InterFreqNeighCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(_ctx, &p->interFreqNeighCellList);
	if (p->interFreqNeighCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqBlackCellList := ");
	if (p->interFreqBlackCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InterFreqBlackCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(_ctx, &p->interFreqBlackCellList);
	if (p->interFreqBlackCellList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB4_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB4_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_InterFreqNeighCellInfo_v1610(acpCtx_t _ctx, const struct SQN_NR_InterFreqNeighCellInfo_v1610* p)
{
	adbgPrintLog(_ctx, "ssb_PositionQCL_r16 := ");
	_adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(_ctx, &p->ssb_PositionQCL_r16);
}

static void _adbgNrSys__SQN_NR_InterFreqNeighCellList_v1610_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_InterFreqNeighCellList_v1610_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_InterFreqNeighCellInfo_v1610(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SSB_MTC2_LP_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_smtc2_LP_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC2_LP_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_smtc2_LP_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_MTC2_LP_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_InterFreqWhiteCellList_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqWhiteCellList_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_InterFreqWhiteCellList_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqWhiteCellList_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_PCI_Range(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqCarrierFreqInfo_v1610_ssb_PositionQCL_Common_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqCarrierFreqInfo_v1610_ssb_PositionQCL_Common_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_InterFreqCAG_CellListPerPLMN_r16(acpCtx_t _ctx, const struct SQN_NR_InterFreqCAG_CellListPerPLMN_r16* p)
{
	adbgPrintLog(_ctx, "plmn_IdentityIndex_r16 := %u", (unsigned int)p->plmn_IdentityIndex_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cag_CellList_r16 := { ");
	for (size_t i4 = 0; i4 < p->cag_CellList_r16.d; i4++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_PCI_Range(_ctx, &p->cag_CellList_r16.v[i4]);
		adbgPrintLog(_ctx, " }");
		if (i4 != p->cag_CellList_r16.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
}

static void _adbgNrSys__SQN_NR_InterFreqCAG_CellListPerPLMN_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqCAG_CellList_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_InterFreqCAG_CellListPerPLMN_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqCAG_CellList_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_InterFreqCAG_CellListPerPLMN_r16(_ctx, &p->v.v[i3]);
		adbgPrintLog(_ctx, " }");
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo_v1610(acpCtx_t _ctx, const struct SQN_NR_InterFreqCarrierFreqInfo_v1610* p)
{
	adbgPrintLog(_ctx, "interFreqNeighCellList_v1610 := ");
	if (p->interFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InterFreqNeighCellList_v1610_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(_ctx, &p->interFreqNeighCellList_v1610);
	if (p->interFreqNeighCellList_v1610.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "smtc2_LP_r16 := ");
	if (p->smtc2_LP_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_MTC2_LP_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_smtc2_LP_r16_Optional(_ctx, &p->smtc2_LP_r16);
	if (p->smtc2_LP_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqWhiteCellList_r16 := ");
	if (p->interFreqWhiteCellList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InterFreqWhiteCellList_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqWhiteCellList_r16_Optional(_ctx, &p->interFreqWhiteCellList_r16);
	if (p->interFreqWhiteCellList_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_PositionQCL_Common_r16 := ");
	_adbgNrSys__SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqCarrierFreqInfo_v1610_ssb_PositionQCL_Common_r16_Optional(_ctx, &p->ssb_PositionQCL_Common_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCAG_CellList_r16 := ");
	if (p->interFreqCAG_CellList_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InterFreqCAG_CellListPerPLMN_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqCAG_CellList_r16_DynamicOptional(_ctx, &p->interFreqCAG_CellList_r16);
	if (p->interFreqCAG_CellList_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_InterFreqCarrierFreqList_v1610_SQN_NR_SIB4_interFreqCarrierFreqList_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_InterFreqCarrierFreqList_v1610_SQN_NR_SIB4_interFreqCarrierFreqList_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo_v1610(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SIB4(acpCtx_t _ctx, const struct SQN_NR_SIB4* p)
{
	adbgPrintLog(_ctx, "interFreqCarrierFreqList := { ");
	for (size_t i2 = 0; i2 < p->interFreqCarrierFreqList.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_InterFreqCarrierFreqInfo(_ctx, &p->interFreqCarrierFreqList.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->interFreqCarrierFreqList.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB4_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "interFreqCarrierFreqList_v1610 := ");
	if (p->interFreqCarrierFreqList_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_InterFreqCarrierFreqList_v1610_SQN_NR_SIB4_interFreqCarrierFreqList_v1610_Optional(_ctx, &p->interFreqCarrierFreqList_v1610);
	if (p->interFreqCarrierFreqList_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__Int8_t_SQN_NR_EUTRA_NS_PmaxValue_additionalPmax_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_EUTRA_NS_PmaxValue_additionalPmax_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_EUTRA_NS_PmaxValue_additionalSpectrumEmission_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_EUTRA_NS_PmaxValue_additionalSpectrumEmission_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_EUTRA_NS_PmaxValue(acpCtx_t _ctx, const struct SQN_NR_EUTRA_NS_PmaxValue* p)
{
	adbgPrintLog(_ctx, "additionalPmax := ");
	_adbgNrSys__Int8_t_SQN_NR_EUTRA_NS_PmaxValue_additionalPmax_Optional(_ctx, &p->additionalPmax);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "additionalSpectrumEmission := ");
	_adbgNrSys__Uint16_t_SQN_NR_EUTRA_NS_PmaxValue_additionalSpectrumEmission_Optional(_ctx, &p->additionalSpectrumEmission);
}

static void _adbgNrSys__SQN_NR_EUTRA_NS_PmaxList_SQN_NR_EUTRA_MultiBandInfo_eutra_NS_PmaxList_Optional(acpCtx_t _ctx, const struct SQN_NR_EUTRA_NS_PmaxList_SQN_NR_EUTRA_MultiBandInfo_eutra_NS_PmaxList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_adbgNrSys__SQN_NR_EUTRA_NS_PmaxValue(_ctx, &p->v.v[i4]);
		if (i4 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_EUTRA_MultiBandInfo(acpCtx_t _ctx, const struct SQN_NR_EUTRA_MultiBandInfo* p)
{
	adbgPrintLog(_ctx, "eutra_FreqBandIndicator := %u", (unsigned int)p->eutra_FreqBandIndicator);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "eutra_NS_PmaxList := ");
	if (p->eutra_NS_PmaxList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_EUTRA_NS_PmaxList_SQN_NR_EUTRA_MultiBandInfo_eutra_NS_PmaxList_Optional(_ctx, &p->eutra_NS_PmaxList);
	if (p->eutra_NS_PmaxList.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_EUTRA_MultiBandInfoList_SQN_NR_CarrierFreqEUTRA_eutra_multiBandInfoList_Optional(acpCtx_t _ctx, const struct SQN_NR_EUTRA_MultiBandInfoList_SQN_NR_CarrierFreqEUTRA_eutra_multiBandInfoList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_EUTRA_MultiBandInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_EUTRA_Q_OffsetRange_e__ToString(SQN_NR_EUTRA_Q_OffsetRange_e v)
{
	switch(v) {
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_24: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_24";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_22: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_22";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_20: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_20";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_18: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_18";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_16: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_16";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_14: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_14";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_12: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_12";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_10: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_10";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_8: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_8";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_6: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_6";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_5: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_5";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_4: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_4";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_3: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_3";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_2: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_2";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB_1: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB_1";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB0: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB0";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB1: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB1";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB2: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB2";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB3: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB3";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB4: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB4";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB5: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB5";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB6: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB6";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB8: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB8";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB10: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB10";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB12: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB12";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB14: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB14";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB16: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB16";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB18: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB18";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB20: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB20";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB22: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB22";
		case SQN_NR_EUTRA_Q_OffsetRange_e_dB24: return "SQN_NR_EUTRA_Q_OffsetRange_e_dB24";
		default: return "Unknown";
	}
}

static void _adbgNrSys__Uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_RxLevMinOffsetCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_QualMinOffsetCell_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_QualMinOffsetCell_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_EUTRA_FreqNeighCellInfo(acpCtx_t _ctx, const struct SQN_NR_EUTRA_FreqNeighCellInfo* p)
{
	adbgPrintLog(_ctx, "physCellId := %u", (unsigned int)p->physCellId);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dummy := %s (%d)", adbgNrSys__SQN_NR_EUTRA_Q_OffsetRange_e__ToString(p->dummy), (int)p->dummy);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMinOffsetCell := ");
	_adbgNrSys__Uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(_ctx, &p->q_RxLevMinOffsetCell);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMinOffsetCell := ");
	_adbgNrSys__Uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_QualMinOffsetCell_Optional(_ctx, &p->q_QualMinOffsetCell);
}

static void _adbgNrSys__SQN_NR_EUTRA_FreqNeighCellList_SQN_NR_CarrierFreqEUTRA_eutra_FreqNeighCellList_Optional(acpCtx_t _ctx, const struct SQN_NR_EUTRA_FreqNeighCellList_SQN_NR_CarrierFreqEUTRA_eutra_FreqNeighCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_EUTRA_FreqNeighCellInfo(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_EUTRA_PhysCellIdRange_range_e__ToString(SQN_NR_EUTRA_PhysCellIdRange_range_e v)
{
	switch(v) {
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n4: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n4";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n8: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n8";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n12: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n12";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n16: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n16";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n24: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n24";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n32: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n32";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n48: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n48";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n64: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n64";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n84: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n84";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n96: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n96";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n128: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n128";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n168: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n168";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n252: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n252";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_n504: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_n504";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_spare2: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_spare2";
		case SQN_NR_EUTRA_PhysCellIdRange_range_e_spare1: return "SQN_NR_EUTRA_PhysCellIdRange_range_e_spare1";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_EUTRA_PhysCellIdRange_range_e_range_Optional(acpCtx_t _ctx, const struct SQN_NR_EUTRA_PhysCellIdRange_range_e_range_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_EUTRA_PhysCellIdRange_range_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_EUTRA_PhysCellIdRange(acpCtx_t _ctx, const struct SQN_NR_EUTRA_PhysCellIdRange* p)
{
	adbgPrintLog(_ctx, "start := %u", (unsigned int)p->start);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "range := ");
	_adbgNrSys__SQN_NR_EUTRA_PhysCellIdRange_range_e_range_Optional(_ctx, &p->range);
}

static void _adbgNrSys__SQN_NR_EUTRA_FreqBlackCellList_SQN_NR_CarrierFreqEUTRA_eutra_BlackCellList_Optional(acpCtx_t _ctx, const struct SQN_NR_EUTRA_FreqBlackCellList_SQN_NR_CarrierFreqEUTRA_eutra_BlackCellList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_EUTRA_PhysCellIdRange(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_EUTRA_AllowedMeasBandwidth_e__ToString(SQN_NR_EUTRA_AllowedMeasBandwidth_e v)
{
	switch(v) {
		case SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw6: return "SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw6";
		case SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw15: return "SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw15";
		case SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw25: return "SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw25";
		case SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw50: return "SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw50";
		case SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw75: return "SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw75";
		case SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw100: return "SQN_NR_EUTRA_AllowedMeasBandwidth_e_mbw100";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_CellReselectionPriority_SQN_NR_CarrierFreqEUTRA_cellReselectionPriority_Optional(acpCtx_t _ctx, const struct SQN_NR_CellReselectionPriority_SQN_NR_CarrierFreqEUTRA_cellReselectionPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_CellReselectionSubPriority_e_SQN_NR_CarrierFreqEUTRA_cellReselectionSubPriority_Optional(acpCtx_t _ctx, const struct SQN_NR_CellReselectionSubPriority_e_SQN_NR_CarrierFreqEUTRA_cellReselectionSubPriority_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_CellReselectionSubPriority_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_CarrierFreqEUTRA_threshX_Q(acpCtx_t _ctx, const struct SQN_NR_CarrierFreqEUTRA_threshX_Q* p)
{
	adbgPrintLog(_ctx, "threshX_HighQ := %u", (unsigned int)p->threshX_HighQ);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_LowQ := %u", (unsigned int)p->threshX_LowQ);
}

static void _adbgNrSys__SQN_NR_CarrierFreqEUTRA_threshX_Q_threshX_Q_Optional(acpCtx_t _ctx, const struct SQN_NR_CarrierFreqEUTRA_threshX_Q_threshX_Q_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_CarrierFreqEUTRA_threshX_Q(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_CarrierFreqEUTRA(acpCtx_t _ctx, const struct SQN_NR_CarrierFreqEUTRA* p)
{
	adbgPrintLog(_ctx, "carrierFreq := %u", (unsigned int)p->carrierFreq);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "eutra_multiBandInfoList := ");
	if (p->eutra_multiBandInfoList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_EUTRA_MultiBandInfoList_SQN_NR_CarrierFreqEUTRA_eutra_multiBandInfoList_Optional(_ctx, &p->eutra_multiBandInfoList);
	if (p->eutra_multiBandInfoList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "eutra_FreqNeighCellList := ");
	if (p->eutra_FreqNeighCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_EUTRA_FreqNeighCellList_SQN_NR_CarrierFreqEUTRA_eutra_FreqNeighCellList_Optional(_ctx, &p->eutra_FreqNeighCellList);
	if (p->eutra_FreqNeighCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "eutra_BlackCellList := ");
	if (p->eutra_BlackCellList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_EUTRA_FreqBlackCellList_SQN_NR_CarrierFreqEUTRA_eutra_BlackCellList_Optional(_ctx, &p->eutra_BlackCellList);
	if (p->eutra_BlackCellList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedMeasBandwidth := %s (%d)", adbgNrSys__SQN_NR_EUTRA_AllowedMeasBandwidth_e__ToString(p->allowedMeasBandwidth), (int)p->allowedMeasBandwidth);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "presenceAntennaPort1 := %s", (p->presenceAntennaPort1 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionPriority := ");
	_adbgNrSys__SQN_NR_CellReselectionPriority_SQN_NR_CarrierFreqEUTRA_cellReselectionPriority_Optional(_ctx, &p->cellReselectionPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "cellReselectionSubPriority := ");
	_adbgNrSys__SQN_NR_CellReselectionSubPriority_e_SQN_NR_CarrierFreqEUTRA_cellReselectionSubPriority_Optional(_ctx, &p->cellReselectionSubPriority);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_High := %u", (unsigned int)p->threshX_High);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Low := %u", (unsigned int)p->threshX_Low);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_RxLevMin := %d", (int)p->q_RxLevMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "q_QualMin := %d", (int)p->q_QualMin);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "p_MaxEUTRA := %d", (int)p->p_MaxEUTRA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "threshX_Q := ");
	if (p->threshX_Q.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CarrierFreqEUTRA_threshX_Q_threshX_Q_Optional(_ctx, &p->threshX_Q);
	if (p->threshX_Q.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_CarrierFreqListEUTRA_SQN_NR_SIB5_carrierFreqListEUTRA_Optional(acpCtx_t _ctx, const struct SQN_NR_CarrierFreqListEUTRA_SQN_NR_SIB5_carrierFreqListEUTRA_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_CarrierFreqEUTRA(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB5_t_ReselectionEUTRA_SF_Optional(acpCtx_t _ctx, const struct SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB5_t_ReselectionEUTRA_SF_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SpeedStateScaleFactors(_ctx, &p->v);
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB5_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB5_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static const char* adbgNrSys__SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e__ToString(SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e v)
{
	switch(v) {
		case SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_true: return "SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_true";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_highSpeedEUTRACarrier_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_highSpeedEUTRACarrier_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__SQN_NR_CarrierFreqEUTRA_v1610(acpCtx_t _ctx, const struct SQN_NR_CarrierFreqEUTRA_v1610* p)
{
	adbgPrintLog(_ctx, "highSpeedEUTRACarrier_r16 := ");
	_adbgNrSys__SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_highSpeedEUTRACarrier_r16_Optional(_ctx, &p->highSpeedEUTRACarrier_r16);
}

static void _adbgNrSys__SQN_NR_CarrierFreqListEUTRA_v1610_SQN_NR_SIB5_carrierFreqListEUTRA_v1610_Optional(acpCtx_t _ctx, const struct SQN_NR_CarrierFreqListEUTRA_v1610_SQN_NR_SIB5_carrierFreqListEUTRA_v1610_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_CarrierFreqEUTRA_v1610(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_SIB5(acpCtx_t _ctx, const struct SQN_NR_SIB5* p)
{
	adbgPrintLog(_ctx, "carrierFreqListEUTRA := ");
	if (p->carrierFreqListEUTRA.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CarrierFreqListEUTRA_SQN_NR_SIB5_carrierFreqListEUTRA_Optional(_ctx, &p->carrierFreqListEUTRA);
	if (p->carrierFreqListEUTRA.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA := %u", (unsigned int)p->t_ReselectionEUTRA);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "t_ReselectionEUTRA_SF := ");
	if (p->t_ReselectionEUTRA_SF.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB5_t_ReselectionEUTRA_SF_Optional(_ctx, &p->t_ReselectionEUTRA_SF);
	if (p->t_ReselectionEUTRA_SF.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB5_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "carrierFreqListEUTRA_v1610 := ");
	if (p->carrierFreqListEUTRA_v1610.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CarrierFreqListEUTRA_v1610_SQN_NR_SIB5_carrierFreqListEUTRA_v1610_Optional(_ctx, &p->carrierFreqListEUTRA_v1610);
	if (p->carrierFreqListEUTRA_v1610.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB6_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB6_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIB6(acpCtx_t _ctx, const struct SQN_NR_SIB6* p)
{
	adbgPrintLog(_ctx, "messageIdentifier := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->messageIdentifier[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "serialNumber := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->serialNumber[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningType := '");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->warningType[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB6_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgNrSys__SQN_NR_SIB7_warningMessageSegmentType_e__ToString(SQN_NR_SIB7_warningMessageSegmentType_e v)
{
	switch(v) {
		case SQN_NR_SIB7_warningMessageSegmentType_e_notLastSegment: return "SQN_NR_SIB7_warningMessageSegmentType_e_notLastSegment";
		case SQN_NR_SIB7_warningMessageSegmentType_e_lastSegment: return "SQN_NR_SIB7_warningMessageSegmentType_e_lastSegment";
		default: return "Unknown";
	}
}

static void _adbgNrSys__O1_SQN_NR_SIB7_dataCodingScheme_Optional(acpCtx_t _ctx, const struct O1_SQN_NR_SIB7_dataCodingScheme_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 1; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB7_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB7_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIB7(acpCtx_t _ctx, const struct SQN_NR_SIB7* p)
{
	adbgPrintLog(_ctx, "messageIdentifier := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->messageIdentifier[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "serialNumber := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->serialNumber[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentType := %s (%d)", adbgNrSys__SQN_NR_SIB7_warningMessageSegmentType_e__ToString(p->warningMessageSegmentType), (int)p->warningMessageSegmentType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentNumber := %u", (unsigned int)p->warningMessageSegmentNumber);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegment := '");
	for (size_t i2 = 0; i2 < p->warningMessageSegment.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->warningMessageSegment.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataCodingScheme := ");
	_adbgNrSys__O1_SQN_NR_SIB7_dataCodingScheme_Optional(_ctx, &p->dataCodingScheme);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB7_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgNrSys__SQN_NR_SIB8_warningMessageSegmentType_e__ToString(SQN_NR_SIB8_warningMessageSegmentType_e v)
{
	switch(v) {
		case SQN_NR_SIB8_warningMessageSegmentType_e_notLastSegment: return "SQN_NR_SIB8_warningMessageSegmentType_e_notLastSegment";
		case SQN_NR_SIB8_warningMessageSegmentType_e_lastSegment: return "SQN_NR_SIB8_warningMessageSegmentType_e_lastSegment";
		default: return "Unknown";
	}
}

static void _adbgNrSys__O1_SQN_NR_SIB8_dataCodingScheme_Optional(acpCtx_t _ctx, const struct O1_SQN_NR_SIB8_dataCodingScheme_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 1; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB8_warningAreaCoordinatesSegment_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB8_warningAreaCoordinatesSegment_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB8_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB8_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIB8(acpCtx_t _ctx, const struct SQN_NR_SIB8* p)
{
	adbgPrintLog(_ctx, "messageIdentifier := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->messageIdentifier[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "serialNumber := '");
	for (size_t i2 = 0; i2 < 16; i2++) {
		adbgPrintLog(_ctx, "%02X", p->serialNumber[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentType := %s (%d)", adbgNrSys__SQN_NR_SIB8_warningMessageSegmentType_e__ToString(p->warningMessageSegmentType), (int)p->warningMessageSegmentType);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegmentNumber := %u", (unsigned int)p->warningMessageSegmentNumber);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningMessageSegment := '");
	for (size_t i2 = 0; i2 < p->warningMessageSegment.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->warningMessageSegment.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dataCodingScheme := ");
	_adbgNrSys__O1_SQN_NR_SIB8_dataCodingScheme_Optional(_ctx, &p->dataCodingScheme);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "warningAreaCoordinatesSegment := ");
	if (p->warningAreaCoordinatesSegment.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB8_warningAreaCoordinatesSegment_Optional(_ctx, &p->warningAreaCoordinatesSegment);
	if (p->warningAreaCoordinatesSegment.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB8_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__B2_SQN_NR_SIB9_timeInfo_dayLightSavingTime_Optional(acpCtx_t _ctx, const struct B2_SQN_NR_SIB9_timeInfo_dayLightSavingTime_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < 2; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__Int16_t_SQN_NR_SIB9_timeInfo_leapSeconds_Optional(acpCtx_t _ctx, const struct int16_t_SQN_NR_SIB9_timeInfo_leapSeconds_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__Int8_t_SQN_NR_SIB9_timeInfo_localTimeOffset_Optional(acpCtx_t _ctx, const struct int8_t_SQN_NR_SIB9_timeInfo_localTimeOffset_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_SIB9_timeInfo(acpCtx_t _ctx, const struct SQN_NR_SIB9_timeInfo* p)
{
	adbgPrintLog(_ctx, "timeInfoUTC := %u", (unsigned int)p->timeInfoUTC);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "dayLightSavingTime := ");
	_adbgNrSys__B2_SQN_NR_SIB9_timeInfo_dayLightSavingTime_Optional(_ctx, &p->dayLightSavingTime);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "leapSeconds := ");
	_adbgNrSys__Int16_t_SQN_NR_SIB9_timeInfo_leapSeconds_Optional(_ctx, &p->leapSeconds);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "localTimeOffset := ");
	_adbgNrSys__Int8_t_SQN_NR_SIB9_timeInfo_localTimeOffset_Optional(_ctx, &p->localTimeOffset);
}

static void _adbgNrSys__SQN_NR_SIB9_timeInfo_timeInfo_Optional(acpCtx_t _ctx, const struct SQN_NR_SIB9_timeInfo_timeInfo_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SIB9_timeInfo(_ctx, &p->v);
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB9_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB9_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_ReferenceTime_r16(acpCtx_t _ctx, const struct SQN_NR_ReferenceTime_r16* p)
{
	adbgPrintLog(_ctx, "refDays_r16 := %u", (unsigned int)p->refDays_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "refSeconds_r16 := %u", (unsigned int)p->refSeconds_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "refMilliSeconds_r16 := %u", (unsigned int)p->refMilliSeconds_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "refTenNanoSeconds_r16 := %u", (unsigned int)p->refTenNanoSeconds_r16);
}

static void _adbgNrSys__Uint16_t_SQN_NR_ReferenceTimeInfo_r16_uncertainty_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_ReferenceTimeInfo_r16_uncertainty_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static const char* adbgNrSys__SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e__ToString(SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e v)
{
	switch(v) {
		case SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_localClock: return "SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_localClock";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_timeInfoType_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_timeInfoType_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%s (%d)", adbgNrSys__SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e__ToString(p->v), (int)p->v);
}

static void _adbgNrSys__Uint16_t_SQN_NR_ReferenceTimeInfo_r16_referenceSFN_r16_Optional(acpCtx_t _ctx, const struct uint16_t_SQN_NR_ReferenceTimeInfo_r16_referenceSFN_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ReferenceTimeInfo_r16(acpCtx_t _ctx, const struct SQN_NR_ReferenceTimeInfo_r16* p)
{
	adbgPrintLog(_ctx, "time_r16 := { ");
	_adbgNrSys__SQN_NR_ReferenceTime_r16(_ctx, &p->time_r16);
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "uncertainty_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_ReferenceTimeInfo_r16_uncertainty_r16_Optional(_ctx, &p->uncertainty_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "timeInfoType_r16 := ");
	_adbgNrSys__SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_timeInfoType_r16_Optional(_ctx, &p->timeInfoType_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceSFN_r16 := ");
	_adbgNrSys__Uint16_t_SQN_NR_ReferenceTimeInfo_r16_referenceSFN_r16_Optional(_ctx, &p->referenceSFN_r16);
}

static void _adbgNrSys__SQN_NR_ReferenceTimeInfo_r16_SQN_NR_SIB9_referenceTimeInfo_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ReferenceTimeInfo_r16_SQN_NR_SIB9_referenceTimeInfo_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_ReferenceTimeInfo_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SIB9(acpCtx_t _ctx, const struct SQN_NR_SIB9* p)
{
	adbgPrintLog(_ctx, "timeInfo := ");
	if (p->timeInfo.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SIB9_timeInfo_timeInfo_Optional(_ctx, &p->timeInfo);
	if (p->timeInfo.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB9_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "referenceTimeInfo_r16 := ");
	if (p->referenceTimeInfo_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ReferenceTimeInfo_r16_SQN_NR_SIB9_referenceTimeInfo_r16_Optional(_ctx, &p->referenceTimeInfo_r16);
	if (p->referenceTimeInfo_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_HRNN_r16_hrnn_r16_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_HRNN_r16_hrnn_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_HRNN_r16(acpCtx_t _ctx, const struct SQN_NR_HRNN_r16* p)
{
	adbgPrintLog(_ctx, "hrnn_r16 := ");
	if (p->hrnn_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_HRNN_r16_hrnn_r16_Optional(_ctx, &p->hrnn_r16);
	if (p->hrnn_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_HRNN_List_r16_SQN_NR_SIB10_r16_hrnn_List_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_HRNN_List_r16_SQN_NR_SIB10_r16_hrnn_List_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_adbgNrSys__SQN_NR_HRNN_r16(_ctx, &p->v.v[i2]);
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB10_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB10_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIB10_r16(acpCtx_t _ctx, const struct SQN_NR_SIB10_r16* p)
{
	adbgPrintLog(_ctx, "hrnn_List_r16 := ");
	if (p->hrnn_List_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_HRNN_List_r16_SQN_NR_SIB10_r16_hrnn_List_r16_Optional(_ctx, &p->hrnn_List_r16);
	if (p->hrnn_List_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB10_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SQN_NR_MeasIdleCarrierNR_r16_frequencyBandList_Optional(acpCtx_t _ctx, const struct SQN_NR_MultiFrequencyBandListNR_SQN_NR_MeasIdleCarrierNR_r16_frequencyBandList_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i3]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_CellListNR_r16_SQN_NR_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_CellListNR_r16_SQN_NR_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_PCI_Range(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e__ToString(SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e v)
{
	switch(v) {
		case SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e_rsrp: return "SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e_rsrp";
		case SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e_rsrq: return "SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e_rsrq";
		case SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e_both: return "SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e_both";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRP_Threshold_NR_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRP_Threshold_NR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RSRQ_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRQ_Threshold_NR_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRQ_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRQ_Threshold_NR_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16* p)
{
	adbgPrintLog(_ctx, "idleRSRP_Threshold_NR_r16 := ");
	_adbgNrSys__SQN_NR_RSRP_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRP_Threshold_NR_r16_Optional(_ctx, &p->idleRSRP_Threshold_NR_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "idleRSRQ_Threshold_NR_r16 := ");
	_adbgNrSys__SQN_NR_RSRQ_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRQ_Threshold_NR_r16_Optional(_ctx, &p->idleRSRQ_Threshold_NR_r16);
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_qualityThreshold_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_qualityThreshold_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16(_ctx, &p->v);
}

static void _adbgNrSys__Uint8_t_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_nrofSS_BlocksToAverage_r16_Optional(acpCtx_t _ctx, const struct uint8_t_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_nrofSS_BlocksToAverage_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_ThresholdNR_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_absThreshSS_BlocksConsolidation_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_ThresholdNR_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_absThreshSS_BlocksConsolidation_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_ThresholdNR(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SSB_MTC_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_smtc_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_MTC_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_smtc_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_MTC(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SSB_ToMeasure_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SSB_ToMeasure_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SSB_ToMeasure(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SS_RSSI_Measurement_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_SS_RSSI_Measurement_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SS_RSSI_Measurement(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16* p)
{
	adbgPrintLog(_ctx, "nrofSS_BlocksToAverage_r16 := ");
	_adbgNrSys__Uint8_t_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_nrofSS_BlocksToAverage_r16_Optional(_ctx, &p->nrofSS_BlocksToAverage_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "absThreshSS_BlocksConsolidation_r16 := ");
	if (p->absThreshSS_BlocksConsolidation_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_ThresholdNR_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_absThreshSS_BlocksConsolidation_r16_Optional(_ctx, &p->absThreshSS_BlocksConsolidation_r16);
	if (p->absThreshSS_BlocksConsolidation_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "smtc_r16 := ");
	if (p->smtc_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_MTC_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_smtc_r16_Optional(_ctx, &p->smtc_r16);
	if (p->smtc_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_ToMeasure_r16 := ");
	if (p->ssb_ToMeasure_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SSB_ToMeasure_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(_ctx, &p->ssb_ToMeasure_r16);
	if (p->ssb_ToMeasure_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "deriveSSB_IndexFromCell_r16 := %s", (p->deriveSSB_IndexFromCell_r16 ? "true" : "false"));
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ss_RSSI_Measurement_r16 := ");
	if (p->ss_RSSI_Measurement_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SS_RSSI_Measurement_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(_ctx, &p->ss_RSSI_Measurement_r16);
	if (p->ss_RSSI_Measurement_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(_ctx, &p->v);
}

static const char* adbgNrSys__SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e__ToString(SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e v)
{
	switch(v) {
		case SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e_rsrp: return "SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e_rsrp";
		case SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e_rsrq: return "SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e_rsrq";
		case SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e_both: return "SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e_both";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_BeamMeasConfigIdle_NR_r16(acpCtx_t _ctx, const struct SQN_NR_BeamMeasConfigIdle_NR_r16* p)
{
	adbgPrintLog(_ctx, "reportQuantityRS_Indexes_r16 := %s (%d)", adbgNrSys__SQN_NR_BeamMeasConfigIdle_NR_r16_reportQuantityRS_Indexes_r16_e__ToString(p->reportQuantityRS_Indexes_r16), (int)p->reportQuantityRS_Indexes_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "maxNrofRS_IndexesToReport_r16 := %u", (unsigned int)p->maxNrofRS_IndexesToReport_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "includeBeamMeasurements_r16 := %s", (p->includeBeamMeasurements_r16 ? "true" : "false"));
}

static void _adbgNrSys__SQN_NR_BeamMeasConfigIdle_NR_r16_SQN_NR_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_BeamMeasConfigIdle_NR_r16_SQN_NR_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_BeamMeasConfigIdle_NR_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierNR_r16* p)
{
	adbgPrintLog(_ctx, "carrierFreq_r16 := %u", (unsigned int)p->carrierFreq_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssbSubcarrierSpacing_r16 := %s (%d)", adbgNrSys__SQN_NR_SubcarrierSpacing_e__ToString(p->ssbSubcarrierSpacing_r16), (int)p->ssbSubcarrierSpacing_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "frequencyBandList := ");
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MultiFrequencyBandListNR_SQN_NR_MeasIdleCarrierNR_r16_frequencyBandList_Optional(_ctx, &p->frequencyBandList);
	if (p->frequencyBandList.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measCellListNR_r16 := ");
	if (p->measCellListNR_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CellListNR_r16_SQN_NR_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(_ctx, &p->measCellListNR_r16);
	if (p->measCellListNR_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reportQuantities_r16 := %s (%d)", adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_reportQuantities_r16_e__ToString(p->reportQuantities_r16), (int)p->reportQuantities_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qualityThreshold_r16 := ");
	if (p->qualityThreshold_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_qualityThreshold_r16_Optional(_ctx, &p->qualityThreshold_r16);
	if (p->qualityThreshold_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "ssb_MeasConfig_r16 := ");
	if (p->ssb_MeasConfig_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(_ctx, &p->ssb_MeasConfig_r16);
	if (p->ssb_MeasConfig_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "beamMeasConfigIdle_r16 := ");
	if (p->beamMeasConfigIdle_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_BeamMeasConfigIdle_NR_r16_SQN_NR_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(_ctx, &p->beamMeasConfigIdle_r16);
	if (p->beamMeasConfigIdle_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListNR_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierNR_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListNR_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_CellListEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_measCellListEUTRA_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_CellListEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_measCellListEUTRA_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_adbgNrSys__SQN_NR_EUTRA_PhysCellIdRange(_ctx, &p->v.v[i3]);
		if (i3 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static const char* adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e__ToString(SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e v)
{
	switch(v) {
		case SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e_rsrp: return "SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e_rsrp";
		case SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e_rsrq: return "SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e_rsrq";
		case SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e_both: return "SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e_both";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_RSRP_RangeEUTRA_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRP_Threshold_EUTRA_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRP_RangeEUTRA_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRP_Threshold_EUTRA_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%u", (unsigned int)p->v);
}

static void _adbgNrSys__SQN_NR_RSRQ_RangeEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRQ_Threshold_EUTRA_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_RSRQ_RangeEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRQ_Threshold_EUTRA_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "%d", (int)p->v);
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16* p)
{
	adbgPrintLog(_ctx, "idleRSRP_Threshold_EUTRA_r16 := ");
	_adbgNrSys__SQN_NR_RSRP_RangeEUTRA_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRP_Threshold_EUTRA_r16_Optional(_ctx, &p->idleRSRP_Threshold_EUTRA_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "idleRSRQ_Threshold_EUTRA_r16 := ");
	_adbgNrSys__SQN_NR_RSRQ_RangeEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRQ_Threshold_EUTRA_r16_Optional(_ctx, &p->idleRSRQ_Threshold_EUTRA_r16);
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_qualityThresholdEUTRA_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_qualityThresholdEUTRA_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16* p)
{
	adbgPrintLog(_ctx, "carrierFreqEUTRA_r16 := %u", (unsigned int)p->carrierFreqEUTRA_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "allowedMeasBandwidth_r16 := %s (%d)", adbgNrSys__SQN_NR_EUTRA_AllowedMeasBandwidth_e__ToString(p->allowedMeasBandwidth_r16), (int)p->allowedMeasBandwidth_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measCellListEUTRA_r16 := ");
	if (p->measCellListEUTRA_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_CellListEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_measCellListEUTRA_r16_Optional(_ctx, &p->measCellListEUTRA_r16);
	if (p->measCellListEUTRA_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "reportQuantitiesEUTRA_r16 := %s (%d)", adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_reportQuantitiesEUTRA_r16_e__ToString(p->reportQuantitiesEUTRA_r16), (int)p->reportQuantitiesEUTRA_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "qualityThresholdEUTRA_r16 := ");
	if (p->qualityThresholdEUTRA_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_qualityThresholdEUTRA_r16_Optional(_ctx, &p->qualityThresholdEUTRA_r16);
	if (p->qualityThresholdEUTRA_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListEUTRA_r16_DynamicOptional(acpCtx_t _ctx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListEUTRA_r16_DynamicOptional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16(_ctx, &p->v.v[i2]);
		adbgPrintLog(_ctx, " }");
		if (i2 != p->v.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
}

static void _adbgNrSys__SQN_NR_MeasIdleConfigSIB_r16(acpCtx_t _ctx, const struct SQN_NR_MeasIdleConfigSIB_r16* p)
{
	adbgPrintLog(_ctx, "measIdleCarrierListNR_r16 := ");
	if (p->measIdleCarrierListNR_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MeasIdleCarrierNR_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListNR_r16_DynamicOptional(_ctx, &p->measIdleCarrierListNR_r16);
	if (p->measIdleCarrierListNR_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "measIdleCarrierListEUTRA_r16 := ");
	if (p->measIdleCarrierListEUTRA_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MeasIdleCarrierEUTRA_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListEUTRA_r16_DynamicOptional(_ctx, &p->measIdleCarrierListEUTRA_r16);
	if (p->measIdleCarrierListEUTRA_r16.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_MeasIdleConfigSIB_r16_SQN_NR_SIB11_r16_measIdleConfigSIB_r16_Optional(acpCtx_t _ctx, const struct SQN_NR_MeasIdleConfigSIB_r16_SQN_NR_SIB11_r16_measIdleConfigSIB_r16_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_MeasIdleConfigSIB_r16(_ctx, &p->v);
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB11_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB11_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIB11_r16(acpCtx_t _ctx, const struct SQN_NR_SIB11_r16* p)
{
	adbgPrintLog(_ctx, "measIdleConfigSIB_r16 := ");
	if (p->measIdleConfigSIB_r16.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_MeasIdleConfigSIB_r16_SQN_NR_SIB11_r16_measIdleConfigSIB_r16_Optional(_ctx, &p->measIdleConfigSIB_r16);
	if (p->measIdleConfigSIB_r16.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB11_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static const char* adbgNrSys__SQN_NR_SIB12_r16_segmentType_r16_e__ToString(SQN_NR_SIB12_r16_segmentType_r16_e v)
{
	switch(v) {
		case SQN_NR_SIB12_r16_segmentType_r16_e_notLastSegment: return "SQN_NR_SIB12_r16_segmentType_r16_e_notLastSegment";
		case SQN_NR_SIB12_r16_segmentType_r16_e_lastSegment: return "SQN_NR_SIB12_r16_segmentType_r16_e_lastSegment";
		default: return "Unknown";
	}
}

static void _adbgNrSys__SQN_NR_SIB12_r16(acpCtx_t _ctx, const struct SQN_NR_SIB12_r16* p)
{
	adbgPrintLog(_ctx, "segmentNumber_r16 := %u", (unsigned int)p->segmentNumber_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "segmentType_r16 := %s (%d)", adbgNrSys__SQN_NR_SIB12_r16_segmentType_r16_e__ToString(p->segmentType_r16), (int)p->segmentType_r16);
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "segmentContainer_r16 := '");
	for (size_t i2 = 0; i2 < p->segmentContainer_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->segmentContainer_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB13_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB13_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIB13_r16(acpCtx_t _ctx, const struct SQN_NR_SIB13_r16* p)
{
	adbgPrintLog(_ctx, "sl_V2X_ConfigCommon_r16 := '");
	for (size_t i2 = 0; i2 < p->sl_V2X_ConfigCommon_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->sl_V2X_ConfigCommon_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "sl_Bandwidth_r16 := '");
	for (size_t i2 = 0; i2 < p->sl_Bandwidth_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->sl_Bandwidth_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "tdd_Config_r16 := '");
	for (size_t i2 = 0; i2 < p->tdd_Config_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->tdd_Config_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB13_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIB14_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIB14_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIB14_r16(acpCtx_t _ctx, const struct SQN_NR_SIB14_r16* p)
{
	adbgPrintLog(_ctx, "sl_V2X_ConfigCommonExt_r16 := '");
	for (size_t i2 = 0; i2 < p->sl_V2X_ConfigCommonExt_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->sl_V2X_ConfigCommonExt_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIB14_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Value(acpCtx_t _ctx, const union SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Value* p, enum SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Sel d)
{
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib2) {
		adbgPrintLog(_ctx, "sib2 := { ");
		_adbgNrSys__SQN_NR_SIB2(_ctx, &p->sib2);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib3) {
		adbgPrintLog(_ctx, "sib3 := { ");
		_adbgNrSys__SQN_NR_SIB3(_ctx, &p->sib3);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib4) {
		adbgPrintLog(_ctx, "sib4 := { ");
		_adbgNrSys__SQN_NR_SIB4(_ctx, &p->sib4);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib5) {
		adbgPrintLog(_ctx, "sib5 := { ");
		_adbgNrSys__SQN_NR_SIB5(_ctx, &p->sib5);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib6) {
		adbgPrintLog(_ctx, "sib6 := { ");
		_adbgNrSys__SQN_NR_SIB6(_ctx, &p->sib6);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib7) {
		adbgPrintLog(_ctx, "sib7 := { ");
		_adbgNrSys__SQN_NR_SIB7(_ctx, &p->sib7);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib8) {
		adbgPrintLog(_ctx, "sib8 := { ");
		_adbgNrSys__SQN_NR_SIB8(_ctx, &p->sib8);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib9) {
		adbgPrintLog(_ctx, "sib9 := { ");
		_adbgNrSys__SQN_NR_SIB9(_ctx, &p->sib9);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib10_v1610) {
		adbgPrintLog(_ctx, "sib10_v1610 := { ");
		_adbgNrSys__SQN_NR_SIB10_r16(_ctx, &p->sib10_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib11_v1610) {
		adbgPrintLog(_ctx, "sib11_v1610 := { ");
		_adbgNrSys__SQN_NR_SIB11_r16(_ctx, &p->sib11_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib12_v1610) {
		adbgPrintLog(_ctx, "sib12_v1610 := { ");
		_adbgNrSys__SQN_NR_SIB12_r16(_ctx, &p->sib12_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib13_v1610) {
		adbgPrintLog(_ctx, "sib13_v1610 := { ");
		_adbgNrSys__SQN_NR_SIB13_r16(_ctx, &p->sib13_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib14_v1610) {
		adbgPrintLog(_ctx, "sib14_v1610 := { ");
		_adbgNrSys__SQN_NR_SIB14_r16(_ctx, &p->sib14_v1610);
		adbgPrintLog(_ctx, " }");
		return;
	}
	adbgPrintLog(_ctx, "INVALID");
}

static void _adbgNrSys__SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s(acpCtx_t _ctx, const struct SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s* p)
{
	_adbgNrSys__SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Value(_ctx, &p->v, p->d);
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SystemInformation_IEs_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SystemInformation_IEs_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i1]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SystemInformation_IEs_nonCriticalExtension(acpCtx_t _ctx, const struct SQN_NR_SystemInformation_IEs_nonCriticalExtension* p)
{
	(void)_ctx;
	(void)p;
}

static void _adbgNrSys__SQN_NR_SystemInformation_IEs_nonCriticalExtension_nonCriticalExtension_Optional(acpCtx_t _ctx, const struct SQN_NR_SystemInformation_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	_adbgNrSys__SQN_NR_SystemInformation_IEs_nonCriticalExtension(_ctx, &p->v);
}

static void _adbgNrSys__SQN_NR_SystemInformation_IEs(acpCtx_t _ctx, const struct SQN_NR_SystemInformation_IEs* p)
{
	adbgPrintLog(_ctx, "sib_TypeAndInfo := { ");
	for (size_t i1 = 0; i1 < p->sib_TypeAndInfo.d; i1++) {
		adbgPrintLog(_ctx, "{ ");
		_adbgNrSys__SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s(_ctx, &p->sib_TypeAndInfo.v[i1]);
		adbgPrintLog(_ctx, " }");
		if (i1 != p->sib_TypeAndInfo.d - 1) { adbgPrintLog(_ctx, ", "); }
	}
	adbgPrintLog(_ctx, " }");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SystemInformation_IEs_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "nonCriticalExtension := ");
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__SQN_NR_SystemInformation_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_ctx, &p->nonCriticalExtension);
	if (p->nonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__OCTET_STRING_SQN_NR_SIBpos_r16_lateNonCriticalExtension_Optional(acpCtx_t _ctx, const struct OCTET_STRING_SQN_NR_SIBpos_r16_lateNonCriticalExtension_Optional* p)
{
	if (!p->d) { adbgPrintLog(_ctx, "omit"); return; }
	adbgPrintLog(_ctx, "'");
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->v.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
}

static void _adbgNrSys__SQN_NR_SIBpos_r16(acpCtx_t _ctx, const struct SQN_NR_SIBpos_r16* p)
{
	adbgPrintLog(_ctx, "assistanceDataSIB_Element_r16 := '");
	for (size_t i2 = 0; i2 < p->assistanceDataSIB_Element_r16.d; i2++) {
		adbgPrintLog(_ctx, "%02X", p->assistanceDataSIB_Element_r16.v[i2]);
	}
	adbgPrintLog(_ctx, "'O");
	adbgPrintLog(_ctx, ", ");
	adbgPrintLog(_ctx, "lateNonCriticalExtension := ");
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, "{ "); };
	_adbgNrSys__OCTET_STRING_SQN_NR_SIBpos_r16_lateNonCriticalExtension_Optional(_ctx, &p->lateNonCriticalExtension);
	if (p->lateNonCriticalExtension.d) { adbgPrintLog(_ctx, " }"); };
}

static void _adbgNrSys__SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_Value(acpCtx_t _ctx, const union SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_Value* p, enum SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_Sel d)
{
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_1_r16) {
		adbgPrintLog(_ctx, "posSib1_1_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_1_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_2_r16) {
		adbgPrintLog(_ctx, "posSib1_2_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_2_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_3_r16) {
		adbgPrintLog(_ctx, "posSib1_3_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_3_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_4_r16) {
		adbgPrintLog(_ctx, "posSib1_4_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_4_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_5_r16) {
		adbgPrintLog(_ctx, "posSib1_5_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_5_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_6_r16) {
		adbgPrintLog(_ctx, "posSib1_6_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_6_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_7_r16) {
		adbgPrintLog(_ctx, "posSib1_7_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_7_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_8_r16) {
		adbgPrintLog(_ctx, "posSib1_8_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib1_8_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_1_r16) {
		adbgPrintLog(_ctx, "posSib2_1_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_1_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_2_r16) {
		adbgPrintLog(_ctx, "posSib2_2_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_2_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_3_r16) {
		adbgPrintLog(_ctx, "posSib2_3_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_3_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_4_r16) {
		adbgPrintLog(_ctx, "posSib2_4_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_4_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_5_r16) {
		adbgPrintLog(_ctx, "posSib2_5_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_5_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_6_r16) {
		adbgPrintLog(_ctx, "posSib2_6_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_6_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_7_r16) {
		adbgPrintLog(_ctx, "posSib2_7_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_7_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_8_r16) {
		adbgPrintLog(_ctx, "posSib2_8_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_8_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_9_r16) {
		adbgPrintLog(_ctx, "posSib2_9_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_9_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_10_r16) {
		adbgPrintLog(_ctx, "posSib2_10_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_10_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_11_r16) {
		adbgPrintLog(_ctx, "posSib2_11_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_11_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_12_r16) {
		adbgPrintLog(_ctx, "posSib2_12_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_12_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_13_r16) {
		adbgPrintLog(_ctx, "posSib2_13_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_13_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_14_r16) {
		adbgPrintLog(_ctx, "posSib2_14_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_14_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_15_r16) {
		adbgPrintLog(_ctx, "posSib2_15_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_15_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_16_r16) {
		adbgPrintLog(_ctx, "posSib2_16_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_16_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_17_r16) {
		adbgPrintLog(_ctx, "posSib2_17_r16 := { ");
		_adbgNrSys__SQN_NR_SIBpos_r16(_ctx, &p->posSib2_17_r16);
		adbgPrintLog(_ctx, " }");
		return;
	}
	if (d == SQN_NR