/*
 * Copyright 2022 Sequans Communications.
 *
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.0  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

#include <string.h>
#include "serNrSys.h"
#include "serMem.h"
#include "serUtils.h"

void serNrSysProcessInitClt(unsigned char* _arena, size_t _aSize, struct NR_SYSTEM_CTRL_REQ** FromSS)
{
	serMem_t _mem = serMemInit(_arena, _aSize);

	*FromSS = (struct NR_SYSTEM_CTRL_REQ*)serMalloc(_mem, sizeof(struct NR_SYSTEM_CTRL_REQ));
	memset(*FromSS, 0, sizeof(struct NR_SYSTEM_CTRL_REQ));
}

static int _serNrSysEncNR_RadioBearerId_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_RadioBearerId_Type_Value* p, enum NR_RadioBearerId_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_RadioBearerId_Type_Srb) {
		HTON_8(&_buffer[*_lidx], p->Srb, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_RadioBearerId_Type_Drb) {
		HTON_8(&_buffer[*_lidx], p->Drb, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_RadioBearerId_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RadioBearerId_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_RadioBearerId_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncQosFlow_Identification_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct QosFlow_Identification_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->PDU_SessionId, _lidx);
	HTON_32(&_buffer[*_lidx], p->QFI, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RoutingInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_RoutingInfo_Type_Value* p, enum NR_RoutingInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_RoutingInfo_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_RoutingInfo_Type_RadioBearerId) {
		_serNrSysEncNR_RadioBearerId_Type(_buffer, _size, _lidx, &p->RadioBearerId);
		return SIDL_STATUS_OK;
	}
	if (d == NR_RoutingInfo_Type_QosFlow) {
		_serNrSysEncQosFlow_Identification_Type(_buffer, _size, _lidx, &p->QosFlow);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_RoutingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RoutingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_RoutingInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncRlcBearerRouting_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union RlcBearerRouting_Type_Value* p, enum RlcBearerRouting_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == RlcBearerRouting_Type_EUTRA) {
		{
			size_t _tmp = (size_t)p->EUTRA;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == RlcBearerRouting_Type_NR) {
		{
			size_t _tmp = (size_t)p->NR;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == RlcBearerRouting_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncRlcBearerRouting_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RlcBearerRouting_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncRlcBearerRouting_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSystemFrameNumberInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SystemFrameNumberInfo_Type_Value* p, enum SystemFrameNumberInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SystemFrameNumberInfo_Type_Number) {
		HTON_16(&_buffer[*_lidx], p->Number, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SystemFrameNumberInfo_Type_Any) {
		HTON_8(&_buffer[*_lidx], p->Any, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSystemFrameNumberInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SystemFrameNumberInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSystemFrameNumberInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSubFrameInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SubFrameInfo_Type_Value* p, enum SubFrameInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SubFrameInfo_Type_Number) {
		HTON_8(&_buffer[*_lidx], p->Number, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SubFrameInfo_Type_Any) {
		HTON_8(&_buffer[*_lidx], p->Any, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSubFrameInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SubFrameInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSubFrameInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncHyperSystemFrameNumberInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const HyperSystemFrameNumberInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSystemFrameNumberInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSlotOffset_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SlotOffset_Type_Value* p, enum SlotOffset_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SlotOffset_Type_Numerology0) {
		HTON_8(&_buffer[*_lidx], p->Numerology0, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology1) {
		HTON_8(&_buffer[*_lidx], p->Numerology1, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology2) {
		HTON_8(&_buffer[*_lidx], p->Numerology2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology3) {
		HTON_8(&_buffer[*_lidx], p->Numerology3, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology4) {
		HTON_8(&_buffer[*_lidx], p->Numerology4, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSlotOffset_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SlotOffset_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSlotOffset_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSlotTimingInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SlotTimingInfo_Type_Value* p, enum SlotTimingInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SlotTimingInfo_Type_SlotOffset) {
		_serNrSysEncSlotOffset_Type(_buffer, _size, _lidx, &p->SlotOffset);
		return SIDL_STATUS_OK;
	}
	if (d == SlotTimingInfo_Type_FirstSlot) {
		HTON_8(&_buffer[*_lidx], p->FirstSlot, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotTimingInfo_Type_Any) {
		HTON_8(&_buffer[*_lidx], p->Any, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSlotTimingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SlotTimingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSlotTimingInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSubFrameTiming_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SubFrameTiming_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSystemFrameNumberInfo_Type(_buffer, _size, _lidx, &p->SFN);
	_serNrSysEncSubFrameInfo_Type(_buffer, _size, _lidx, &p->Subframe);
	_serNrSysEncHyperSystemFrameNumberInfo_Type(_buffer, _size, _lidx, &p->HSFN);
	_serNrSysEncSlotTimingInfo_Type(_buffer, _size, _lidx, &p->Slot);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncTimingInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union TimingInfo_Type_Value* p, enum TimingInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == TimingInfo_Type_SubFrame) {
		_serNrSysEncSubFrameTiming_Type(_buffer, _size, _lidx, &p->SubFrame);
		return SIDL_STATUS_OK;
	}
	if (d == TimingInfo_Type_Now) {
		HTON_8(&_buffer[*_lidx], p->Now, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == TimingInfo_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncTimingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct TimingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncTimingInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncReqAspControlInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ReqAspControlInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->CnfFlag, _lidx);
	HTON_8(&_buffer[*_lidx], p->FollowOnFlag, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ReqAspCommonPart_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ReqAspCommonPart_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->CellId;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_RoutingInfo_Type(_buffer, _size, _lidx, &p->RoutingInfo);
	_serNrSysEncRlcBearerRouting_Type(_buffer, _size, _lidx, &p->RlcBearerRouting);
	_serNrSysEncTimingInfo_Type(_buffer, _size, _lidx, &p->TimingInfo);
	_serNrSysEncReqAspControlInfo_Type(_buffer, _size, _lidx, &p->ControlInfo);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SS_StaticCellResourceConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SS_StaticCellResourceConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->CellCapability;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->CarrierAggregation;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SS_StaticCellResourceConfig_Type_StaticResourceConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SS_StaticCellResourceConfig_Type_StaticResourceConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SS_StaticCellResourceConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncRNTI_Value_Type_C_RNTI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RNTI_Value_Type_C_RNTI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_TcOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_TcOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncCellTimingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CellTimingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_TcOffset_Optional(_buffer, _size, _lidx, &p->TcOffset);
	HTON_32(&_buffer[*_lidx], p->Tcell, _lidx);
	HTON_16(&_buffer[*_lidx], p->SfnOffset, _lidx);
	HTON_16(&_buffer[*_lidx], p->HsfnOffset, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncCellTimingInfo_Type_CellTimingInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CellTimingInfo_Type_CellTimingInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncCellTimingInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_Attenuation_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_Attenuation_Type_Value* p, enum NR_Attenuation_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_Attenuation_Type_Value) {
		HTON_8(&_buffer[*_lidx], p->Value, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_Attenuation_Type_Off) {
		HTON_8(&_buffer[*_lidx], p->Off, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_InitialAttenuation_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const NR_InitialAttenuation_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_Attenuation_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_InitialCellPower_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_InitialCellPower_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->MaxReferencePower, _lidx);
	_serNrSysEncNR_InitialAttenuation_Type(_buffer, _size, _lidx, &p->Attenuation);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_InitialCellPower_Type_InitialCellPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_InitialCellPower_Type_InitialCellPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_InitialCellPower_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncRNTI_Value_Type_C_RNTI_Optional(_buffer, _size, _lidx, &p->C_RNTI);
	_serNrSysEncCellTimingInfo_Type_CellTimingInfo_Optional(_buffer, _size, _lidx, &p->CellTimingInfo);
	_serNrSysEncNR_InitialCellPower_Type_InitialCellPower_Optional(_buffer, _size, _lidx, &p->InitialCellPower);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigCommon_Type_CellConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigCommon_Type_CellConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CellConfigCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PhysCellId_PhysicalCellId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PhysCellId_PhysicalCellId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_FDD_Info_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_FDD_Info_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_dl_UL_TransmissionPeriodicity_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_dl_UL_TransmissionPeriodicity_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_Pattern(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_Pattern* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->dl_UL_TransmissionPeriodicity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_16(&_buffer[*_lidx], p->nrofDownlinkSlots, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofDownlinkSymbols, _lidx);
	HTON_16(&_buffer[*_lidx], p->nrofUplinkSlots, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofUplinkSymbols, _lidx);
	_serNrSysEncSQN_NR_TDD_UL_DL_Pattern_dl_UL_TransmissionPeriodicity_v1530_e_dl_UL_TransmissionPeriodicity_v1530_Optional(_buffer, _size, _lidx, &p->dl_UL_TransmissionPeriodicity_v1530);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_Pattern_SQN_NR_TDD_UL_DL_ConfigCommon_pattern2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_Pattern_SQN_NR_TDD_UL_DL_ConfigCommon_pattern2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_TDD_UL_DL_Pattern(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->referenceSubcarrierSpacing;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_TDD_UL_DL_Pattern(_buffer, _size, _lidx, &p->pattern1);
	_serNrSysEncSQN_NR_TDD_UL_DL_Pattern_SQN_NR_TDD_UL_DL_ConfigCommon_pattern2_Optional(_buffer, _size, _lidx, &p->pattern2);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_TDD_UL_DL_ConfigCommon_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Value* p, enum NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_TDD_UL_DL_ConfigCommon_Type_R15) {
		_serNrSysEncSQN_NR_TDD_UL_DL_ConfigCommon(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_TDD_UL_DL_ConfigCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_TDD_UL_DL_ConfigCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_TDD_UL_DL_ConfigCommon_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_TDD_UL_DL_ConfigCommon_Type_Common_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_TDD_UL_DL_ConfigCommon_Type_Common_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_TDD_UL_DL_ConfigCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofDownlinkSymbols_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofDownlinkSymbols_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofUplinkSymbols_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofUplinkSymbols_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofDownlinkSymbols_Optional(_buffer, _size, _lidx, &p->nrofDownlinkSymbols);
	_serNrSysEncUint8_t_SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit__nrofUplinkSymbols_Optional(_buffer, _size, _lidx, &p->nrofUplinkSymbols);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig_symbols_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_TDD_UL_DL_SlotConfig_symbols_Value* p, enum SQN_NR_TDD_UL_DL_SlotConfig_symbols_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_TDD_UL_DL_SlotConfig_symbols_allDownlink) {
		HTON_8(&_buffer[*_lidx], p->allDownlink, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_TDD_UL_DL_SlotConfig_symbols_allUplink) {
		HTON_8(&_buffer[*_lidx], p->allUplink, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_) {
		_serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig_symbols_explicit_(_buffer, _size, _lidx, &p->explicit_);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig_symbols(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_SlotConfig_symbols* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig_symbols_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_SlotConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->slotIndex, _lidx);
	_serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig_symbols(_buffer, _size, _lidx, &p->symbols);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_TDD_UL_DL_SlotConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_TDD_UL_DL_SlotConfig_Type_Value* p, enum NR_ASN1_TDD_UL_DL_SlotConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_TDD_UL_DL_SlotConfig_Type_R15) {
		_serNrSysEncSQN_NR_TDD_UL_DL_SlotConfig(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_TDD_UL_DL_SlotConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_TDD_UL_DL_SlotConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_TDD_UL_DL_SlotConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TDD_UL_DL_SlotConfigList_Type_Dedicated_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TDD_UL_DL_SlotConfigList_Type_Dedicated_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_ASN1_TDD_UL_DL_SlotConfig_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TDD_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TDD_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_ASN1_TDD_UL_DL_ConfigCommon_Type_Common_Optional(_buffer, _size, _lidx, &p->Common);
	_serNrSysEncNR_TDD_UL_DL_SlotConfigList_Type_Dedicated_Optional(_buffer, _size, _lidx, &p->Dedicated);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TDD_Info_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_TDD_Info_Type_Value* p, enum NR_TDD_Info_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_TDD_Info_Type_Config) {
		_serNrSysEncNR_TDD_Config_Type(_buffer, _size, _lidx, &p->Config);
		return SIDL_STATUS_OK;
	}
	if (d == NR_TDD_Info_Type_FullFlexible) {
		HTON_8(&_buffer[*_lidx], p->FullFlexible, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_TDD_Info_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TDD_Info_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_TDD_Info_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DuplexMode_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DuplexMode_Type_Value* p, enum NR_DuplexMode_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DuplexMode_Type_FDD) {
		_serNrSysEncNR_FDD_Info_Type(_buffer, _size, _lidx, &p->FDD);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DuplexMode_Type_TDD) {
		_serNrSysEncNR_TDD_Info_Type(_buffer, _size, _lidx, &p->TDD);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DuplexMode_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DuplexMode_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DuplexMode_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DuplexMode_Type_DuplexMode_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DuplexMode_Type_DuplexMode_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DuplexMode_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayerCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayerCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PhysCellId_PhysicalCellId_Optional(_buffer, _size, _lidx, &p->PhysicalCellId);
	_serNrSysEncNR_DuplexMode_Type_DuplexMode_Optional(_buffer, _size, _lidx, &p->DuplexMode);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayerCommon_Type_Common_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayerCommon_Type_Common_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CellConfigPhysicalLayerCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoDL_absoluteFrequencySSB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoDL_absoluteFrequencySSB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_SCS_SpecificCarrier_txDirectCurrentLocation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_SCS_SpecificCarrier_txDirectCurrentLocation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SCS_SpecificCarrier(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SCS_SpecificCarrier* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->offsetToCarrier, _lidx);
	{
		size_t _tmp = (size_t)p->subcarrierSpacing;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_16(&_buffer[*_lidx], p->carrierBandwidth, _lidx);
	_serNrSysEncUint16_t_SQN_NR_SCS_SpecificCarrier_txDirectCurrentLocation_Optional(_buffer, _size, _lidx, &p->txDirectCurrentLocation);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FrequencyInfoDL(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FrequencyInfoDL* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoDL_absoluteFrequencySSB_Optional(_buffer, _size, _lidx, &p->absoluteFrequencySSB);
	HTON_32(&_buffer[*_lidx], p->frequencyBandList.d, _lidx);
	for (size_t i1 = 0; i1 < p->frequencyBandList.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->frequencyBandList.v[i1], _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->absoluteFrequencyPointA, _lidx);
	HTON_32(&_buffer[*_lidx], p->scs_SpecificCarrierList.d, _lidx);
	for (size_t i1 = 0; i1 < p->scs_SpecificCarrierList.d; i1++) {
		_serNrSysEncSQN_NR_SCS_SpecificCarrier(_buffer, _size, _lidx, &p->scs_SpecificCarrierList.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_FrequencyInfoDL_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_FrequencyInfoDL_Type_Value* p, enum NR_ASN1_FrequencyInfoDL_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_FrequencyInfoDL_Type_R15) {
		_serNrSysEncSQN_NR_FrequencyInfoDL(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_FrequencyInfoDL_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_FrequencyInfoDL_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_FrequencyInfoDL_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_FrequencyInfoDL_Type_FrequencyInfoDL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_FrequencyInfoDL_Type_FrequencyInfoDL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_FrequencyInfoDL_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SubcarrierSpacing_e_SubCarrierSpacing_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SubcarrierSpacing_e_SubCarrierSpacing_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_SSB_Config_Type_SubcarrierOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_SSB_Config_Type_SubcarrierOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_Periodicity_Type_Periodicity_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_Periodicity_Type_Periodicity_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_SSB_Config_Type_HalfFrameOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_SSB_Config_Type_HalfFrameOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SS_BlockPattern_Type_BlockPattern_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SS_BlockPattern_Type_BlockPattern_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Value* p, enum SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_shortBitmap) {
		for (size_t i1 = 0; i1 < 4; i1++) {
			HTON_8(&_buffer[*_lidx], p->shortBitmap[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_mediumBitmap) {
		for (size_t i1 = 0; i1 < 8; i1++) {
			HTON_8(&_buffer[*_lidx], p->mediumBitmap[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_longBitmap) {
		for (size_t i1 = 0; i1 < 64; i1++) {
			HTON_8(&_buffer[*_lidx], p->longBitmap[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_SSB_PositionsInBurst_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const NR_SSB_PositionsInBurst_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_ServingCellConfigCommon_ssb_PositionsInBurst_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_PositionsInBurst_Type_PositionsInBurst_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_PositionsInBurst_Type_PositionsInBurst_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SSB_PositionsInBurst_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_SSB_Beam_Type_SsbIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_SSB_Beam_Type_SsbIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_SSB_Beam_Type_Attenuation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_SSB_Beam_Type_Attenuation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_Beam_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_Beam_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncInt32_t_NR_SSB_Beam_Type_SsbIndex_Optional(_buffer, _size, _lidx, &p->SsbIndex);
	_serNrSysEncInt32_t_NR_SSB_Beam_Type_Attenuation_Optional(_buffer, _size, _lidx, &p->Attenuation);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_BeamArray_Type_BeamArray_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_BeamArray_Type_BeamArray_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_SSB_Beam_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_BurstConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_BurstConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_SS_BlockPattern_Type_BlockPattern_Optional(_buffer, _size, _lidx, &p->BlockPattern);
	_serNrSysEncNR_SSB_PositionsInBurst_Type_PositionsInBurst_Optional(_buffer, _size, _lidx, &p->PositionsInBurst);
	_serNrSysEncNR_SSB_BeamArray_Type_BeamArray_Optional(_buffer, _size, _lidx, &p->BeamArray);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_BurstConfig_Type_BurstConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_BurstConfig_Type_BurstConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SSB_BurstConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_PbchToDmrs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_PbchToDmrs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_PssToSss_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_PssToSss_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_SssToSsbBeam_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_SssToSsbBeam_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_DmrsToSss_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_DmrsToSss_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_EPREs_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_EPREs_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_EPRE_Ratio_Type_PbchToDmrs_Optional(_buffer, _size, _lidx, &p->PbchToDmrs);
	_serNrSysEncNR_EPRE_Ratio_Type_PssToSss_Optional(_buffer, _size, _lidx, &p->PssToSss);
	_serNrSysEncNR_EPRE_Ratio_Type_SssToSsbBeam_Optional(_buffer, _size, _lidx, &p->SssToSsbBeam);
	_serNrSysEncNR_EPRE_Ratio_Type_DmrsToSss_Optional(_buffer, _size, _lidx, &p->DmrsToSss);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_EPREs_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_EPREs_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SSB_EPREs_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SubcarrierSpacing_e_SubCarrierSpacing_Optional(_buffer, _size, _lidx, &p->SubCarrierSpacing);
	_serNrSysEncInt32_t_NR_SSB_Config_Type_SubcarrierOffset_Optional(_buffer, _size, _lidx, &p->SubcarrierOffset);
	_serNrSysEncNR_SSB_Periodicity_Type_Periodicity_Optional(_buffer, _size, _lidx, &p->Periodicity);
	_serNrSysEncInt32_t_NR_SSB_Config_Type_HalfFrameOffset_Optional(_buffer, _size, _lidx, &p->HalfFrameOffset);
	_serNrSysEncNR_SSB_BurstConfig_Type_BurstConfig_Optional(_buffer, _size, _lidx, &p->BurstConfig);
	_serNrSysEncNR_SSB_EPREs_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SSB_Config_Type_SSPbchBlock_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SSB_Config_Type_SSPbchBlock_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SSB_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PDSCH_DMRS_TypeA_Position_Type_DMRS_TypeA_Position_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PDSCH_DMRS_TypeA_Position_Type_DMRS_TypeA_Position_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Value* p, enum SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_oneSlot) {
		for (size_t i2 = 0; i2 < 14; i2++) {
			HTON_8(&_buffer[*_lidx], p->oneSlot[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_twoSlots) {
		for (size_t i2 = 0; i2 < 28; i2++) {
			HTON_8(&_buffer[*_lidx], p->twoSlots[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Value* p, enum SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n2) {
		for (size_t i2 = 0; i2 < 2; i2++) {
			HTON_8(&_buffer[*_lidx], p->n2[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n4) {
		for (size_t i2 = 0; i2 < 4; i2++) {
			HTON_8(&_buffer[*_lidx], p->n4[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n5) {
		for (size_t i2 = 0; i2 < 5; i2++) {
			HTON_8(&_buffer[*_lidx], p->n5[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n8) {
		for (size_t i2 = 0; i2 < 8; i2++) {
			HTON_8(&_buffer[*_lidx], p->n8[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n10) {
		for (size_t i2 = 0; i2 < 10; i2++) {
			HTON_8(&_buffer[*_lidx], p->n10[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n20) {
		for (size_t i2 = 0; i2 < 20; i2++) {
			HTON_8(&_buffer[*_lidx], p->n20[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_n40) {
		for (size_t i2 = 0; i2 < 40; i2++) {
			HTON_8(&_buffer[*_lidx], p->n40[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_periodicityAndPattern_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_periodicityAndPattern_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPattern_patternType_bitmaps* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 275; i2++) {
		HTON_8(&_buffer[*_lidx], p->resourceBlocks[i2], _lidx);
	}
	_serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_symbolsInResourceBlock(_buffer, _size, _lidx, &p->symbolsInResourceBlock);
	_serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps_periodicityAndPattern_periodicityAndPattern_Optional(_buffer, _size, _lidx, &p->periodicityAndPattern);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RateMatchPattern_patternType_Value* p, enum SQN_NR_RateMatchPattern_patternType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RateMatchPattern_patternType_bitmaps) {
		_serNrSysEncSQN_NR_RateMatchPattern_patternType_bitmaps(_buffer, _size, _lidx, &p->bitmaps);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPattern_patternType_controlResourceSet) {
		HTON_8(&_buffer[*_lidx], p->controlResourceSet, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_patternType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPattern_patternType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RateMatchPattern_patternType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_RateMatchPattern_subcarrierSpacing_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_RateMatchPattern_subcarrierSpacing_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSetId_r16_SQN_NR_RateMatchPattern_controlResourceSet_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSetId_r16_SQN_NR_RateMatchPattern_controlResourceSet_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPattern(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPattern* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->rateMatchPatternId, _lidx);
	_serNrSysEncSQN_NR_RateMatchPattern_patternType(_buffer, _size, _lidx, &p->patternType);
	_serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_RateMatchPattern_subcarrierSpacing_Optional(_buffer, _size, _lidx, &p->subcarrierSpacing);
	{
		size_t _tmp = (size_t)p->dummy;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_ControlResourceSetId_r16_SQN_NR_RateMatchPattern_controlResourceSet_r16_Optional(_buffer, _size, _lidx, &p->controlResourceSet_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_RateMatchPattern_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_RateMatchPattern_Type_Value* p, enum NR_ASN1_RateMatchPattern_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_RateMatchPattern_Type_R15) {
		_serNrSysEncSQN_NR_RateMatchPattern(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_RateMatchPattern_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_RateMatchPattern_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_RateMatchPattern_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RateMatchPatternList_Type_PatternList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RateMatchPatternList_Type_PatternList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_ASN1_RateMatchPattern_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Value* p, enum SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_oneFrame) {
		for (size_t i3 = 0; i3 < 6; i3++) {
			HTON_8(&_buffer[*_lidx], p->oneFrame[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_fourFrames) {
		for (size_t i3 = 0; i3 < 24; i3++) {
			HTON_8(&_buffer[*_lidx], p->fourFrames[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Value* p, enum SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_oneFrame) {
		for (size_t i3 = 0; i3 < 2; i3++) {
			HTON_8(&_buffer[*_lidx], p->oneFrame[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_fourFrames) {
		for (size_t i3 = 0; i3 < 8; i3++) {
			HTON_8(&_buffer[*_lidx], p->fourFrames[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_subframeAllocation2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_subframeAllocation2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->radioframeAllocationPeriod;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->radioframeAllocationOffset, _lidx);
	_serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation1(_buffer, _size, _lidx, &p->subframeAllocation1);
	_serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig_subframeAllocation2_subframeAllocation2_Optional(_buffer, _size, _lidx, &p->subframeAllocation2);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfigList_SQN_NR_RateMatchPatternLTE_CRS_mbsfn_SubframeConfigList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_MBSFN_SubframeConfigList_SQN_NR_RateMatchPatternLTE_CRS_mbsfn_SubframeConfigList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfig(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPatternLTE_CRS(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPatternLTE_CRS* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->carrierFreqDL, _lidx);
	{
		size_t _tmp = (size_t)p->carrierBandwidthDL;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_EUTRA_MBSFN_SubframeConfigList_SQN_NR_RateMatchPatternLTE_CRS_mbsfn_SubframeConfigList_Optional(_buffer, _size, _lidx, &p->mbsfn_SubframeConfigList);
	{
		size_t _tmp = (size_t)p->nrofCRS_Ports;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->v_Shift;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_RateMatchPatternLTE_CRS_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_RateMatchPatternLTE_CRS_Type_Value* p, enum NR_ASN1_RateMatchPatternLTE_CRS_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_RateMatchPatternLTE_CRS_Type_R15) {
		_serNrSysEncSQN_NR_RateMatchPatternLTE_CRS(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_RateMatchPatternLTE_CRS_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_RateMatchPatternLTE_CRS_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_RateMatchPatternLTE_CRS_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RateMatchPatternLteCrsList_Type_PatternListLteCrs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RateMatchPatternLteCrsList_Type_PatternListLteCrs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_ASN1_RateMatchPatternLTE_CRS_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellLevelRateMatchPattern_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellLevelRateMatchPattern_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_RateMatchPatternList_Type_PatternList_Optional(_buffer, _size, _lidx, &p->PatternList);
	_serNrSysEncNR_RateMatchPatternLteCrsList_Type_PatternListLteCrs_Optional(_buffer, _size, _lidx, &p->PatternListLteCrs);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellLevelRateMatchPattern_Type_RateMatchPattern_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellLevelRateMatchPattern_Type_RateMatchPattern_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CellLevelRateMatchPattern_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_CodeBlockGroupTransmission(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_CodeBlockGroupTransmission* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->maxCodeBlockGroupsPerTransportBlock;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->codeBlockGroupFlushIndicator, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Value* p, enum SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_setup) {
		_serNrSysEncSQN_NR_PDSCH_CodeBlockGroupTransmission(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_nrofHARQ_ProcessesForPDSCH_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_nrofHARQ_ProcessesForPDSCH_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServCellIndex_SQN_NR_PDSCH_ServingCellConfig_pucch_Cell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServCellIndex_SQN_NR_PDSCH_ServingCellConfig_pucch_Cell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PDSCH_ServingCellConfig_maxMIMO_Layers_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PDSCH_ServingCellConfig_maxMIMO_Layers_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncBool_SQN_NR_PDSCH_ServingCellConfig_processingType2Enabled_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_NR_PDSCH_ServingCellConfig_processingType2Enabled_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i1 = 0; i1 < p->setup.d; i1++) {
			_serNrSysEncSQN_NR_PDSCH_CodeBlockGroupTransmission(_buffer, _size, _lidx, &p->setup.v[i1]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_SQN_NR_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_SQN_NR_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_ServingCellConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_ServingCellConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PDSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(_buffer, _size, _lidx, &p->codeBlockGroupTransmission);
	_serNrSysEncSQN_NR_PDSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(_buffer, _size, _lidx, &p->xOverhead);
	_serNrSysEncSQN_NR_PDSCH_ServingCellConfig_nrofHARQ_ProcessesForPDSCH_e_nrofHARQ_ProcessesForPDSCH_Optional(_buffer, _size, _lidx, &p->nrofHARQ_ProcessesForPDSCH);
	_serNrSysEncSQN_NR_ServCellIndex_SQN_NR_PDSCH_ServingCellConfig_pucch_Cell_Optional(_buffer, _size, _lidx, &p->pucch_Cell);
	_serNrSysEncUint8_t_SQN_NR_PDSCH_ServingCellConfig_maxMIMO_Layers_Optional(_buffer, _size, _lidx, &p->maxMIMO_Layers);
	_serNrSysEncBool_SQN_NR_PDSCH_ServingCellConfig_processingType2Enabled_Optional(_buffer, _size, _lidx, &p->processingType2Enabled);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_SQN_NR_PDSCH_ServingCellConfig_pdsch_CodeBlockGroupTransmissionList_r16_Optional(_buffer, _size, _lidx, &p->pdsch_CodeBlockGroupTransmissionList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PDSCH_ServingCellConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_PDSCH_ServingCellConfig_Type_Value* p, enum NR_ASN1_PDSCH_ServingCellConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_PDSCH_ServingCellConfig_Type_R15) {
		_serNrSysEncSQN_NR_PDSCH_ServingCellConfig(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_PDSCH_ServingCellConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PDSCH_ServingCellConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_PDSCH_ServingCellConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PDSCH_ServingCellConfig_Type_ServingCellConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PDSCH_ServingCellConfig_Type_ServingCellConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_PDSCH_ServingCellConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PDSCH_CellLevelConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PDSCH_CellLevelConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_PDSCH_DMRS_TypeA_Position_Type_DMRS_TypeA_Position_Optional(_buffer, _size, _lidx, &p->DMRS_TypeA_Position);
	_serNrSysEncNR_CellLevelRateMatchPattern_Type_RateMatchPattern_Optional(_buffer, _size, _lidx, &p->RateMatchPattern);
	_serNrSysEncNR_ASN1_PDSCH_ServingCellConfig_Type_ServingCellConfig_Optional(_buffer, _size, _lidx, &p->ServingCellConfig);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PDSCH_CellLevelConfig_Type_PdschCellLevelConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PDSCH_CellLevelConfig_Type_PdschCellLevelConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_PDSCH_CellLevelConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_Id_ActiveBWP_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_Id_ActiveBWP_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_Id_NR_DownlinkBWP_Type_Id_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_Id_NR_DownlinkBWP_Type_Id_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_cyclicPrefix_e_cyclicPrefix_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_cyclicPrefix_e_cyclicPrefix_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->locationAndBandwidth, _lidx);
	{
		size_t _tmp = (size_t)p->subcarrierSpacing;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_BWP_cyclicPrefix_e_cyclicPrefix_Optional(_buffer, _size, _lidx, &p->cyclicPrefix);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_BWP_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_BWP_Type_Value* p, enum NR_ASN1_BWP_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_BWP_Type_R15) {
		_serNrSysEncSQN_NR_BWP(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_BWP_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_BWP_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_BWP_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_BWP_Type_BWP_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_BWP_Type_BWP_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_BWP_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceTypeAndPriority_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceTypeAndPriority_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->Type;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->CandidatePriority, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSetId_SQN_NR_SearchSpace_controlResourceSetId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSetId_SQN_NR_SearchSpace_controlResourceSetId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Value* p, enum SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl1) {
		HTON_8(&_buffer[*_lidx], p->sl1, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl2) {
		HTON_8(&_buffer[*_lidx], p->sl2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl4) {
		HTON_8(&_buffer[*_lidx], p->sl4, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl5) {
		HTON_8(&_buffer[*_lidx], p->sl5, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl8) {
		HTON_8(&_buffer[*_lidx], p->sl8, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl10) {
		HTON_8(&_buffer[*_lidx], p->sl10, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl16) {
		HTON_8(&_buffer[*_lidx], p->sl16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl20) {
		HTON_8(&_buffer[*_lidx], p->sl20, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl40) {
		HTON_8(&_buffer[*_lidx], p->sl40, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl80) {
		HTON_8(&_buffer[*_lidx], p->sl80, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl160) {
		HTON_8(&_buffer[*_lidx], p->sl160, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl320) {
		HTON_16(&_buffer[*_lidx], p->sl320, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl640) {
		HTON_16(&_buffer[*_lidx], p->sl640, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl1280) {
		HTON_16(&_buffer[*_lidx], p->sl1280, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_sl2560) {
		HTON_16(&_buffer[*_lidx], p->sl2560, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_monitoringSlotPeriodicityAndOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_monitoringSlotPeriodicityAndOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_SearchSpace_duration_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_SearchSpace_duration_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB14_SQN_NR_SearchSpace_monitoringSymbolsWithinSlot_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B14_SQN_NR_SearchSpace_monitoringSymbolsWithinSlot_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i3 = 0; i3 < 14; i3++) {
		HTON_8(&_buffer[*_lidx], p->v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_nrofCandidates(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_nrofCandidates* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->aggregationLevel1;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->aggregationLevel2;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->aggregationLevel4;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->aggregationLevel8;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->aggregationLevel16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_nrofCandidates_nrofCandidates_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_nrofCandidates_nrofCandidates_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_nrofCandidates(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0_dci_Format0_0_AndFormat1_0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0_dci_Format0_0_AndFormat1_0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_aggregationLevel1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_aggregationLevel1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_aggregationLevel2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_aggregationLevel2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_aggregationLevel4_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_aggregationLevel4_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_aggregationLevel8_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_aggregationLevel8_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_aggregationLevel16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_aggregationLevel16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFI(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFI* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel1_e_aggregationLevel1_Optional(_buffer, _size, _lidx, &p->aggregationLevel1);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel2_e_aggregationLevel2_Optional(_buffer, _size, _lidx, &p->aggregationLevel2);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel4_e_aggregationLevel4_Optional(_buffer, _size, _lidx, &p->aggregationLevel4);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel8_e_aggregationLevel8_Optional(_buffer, _size, _lidx, &p->aggregationLevel8);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFIaggregationLevel16_e_aggregationLevel16_Optional(_buffer, _size, _lidx, &p->aggregationLevel16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0nrofCandidates_SFI(_buffer, _size, _lidx, &p->nrofCandidates_SFI);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0_dci_Format2_0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0_dci_Format2_0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1_dci_Format2_1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1_dci_Format2_1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2_dci_Format2_2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2_dci_Format2_2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_dummy1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_dummy1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3dummy1_e_dummy1_Optional(_buffer, _size, _lidx, &p->dummy1);
	{
		size_t _tmp = (size_t)p->dummy2;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3_dci_Format2_3_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3_dci_Format2_3_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_common* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format0_0_AndFormat1_0_dci_Format0_0_AndFormat1_0_Optional(_buffer, _size, _lidx, &p->dci_Format0_0_AndFormat1_0);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_0_dci_Format2_0_Optional(_buffer, _size, _lidx, &p->dci_Format2_0);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_1_dci_Format2_1_Optional(_buffer, _size, _lidx, &p->dci_Format2_1);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_2_dci_Format2_2_Optional(_buffer, _size, _lidx, &p->dci_Format2_2);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common_dci_Format2_3_dci_Format2_3_Optional(_buffer, _size, _lidx, &p->dci_Format2_3);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_dci_Formats_MT_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_dci_Formats_MT_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_dci_FormatsSL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_dci_FormatsSL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_dci_FormatsExt_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_dci_FormatsExt_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_ue_Specific* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->dci_Formats;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_Formats_MT_r16_e_dci_Formats_MT_r16_Optional(_buffer, _size, _lidx, &p->dci_Formats_MT_r16);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsSL_r16_e_dci_FormatsSL_r16_Optional(_buffer, _size, _lidx, &p->dci_FormatsSL_r16);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific_dci_FormatsExt_r16_e_dci_FormatsExt_r16_Optional(_buffer, _size, _lidx, &p->dci_FormatsExt_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SearchSpace_searchSpaceType_Value* p, enum SQN_NR_SearchSpace_searchSpaceType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SearchSpace_searchSpaceType_common) {
		_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_common(_buffer, _size, _lidx, &p->common);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SearchSpace_searchSpaceType_ue_Specific) {
		_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_ue_Specific(_buffer, _size, _lidx, &p->ue_Specific);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_searchSpaceType_searchSpaceType_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_searchSpaceType_searchSpaceType_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->searchSpaceId, _lidx);
	_serNrSysEncSQN_NR_ControlResourceSetId_SQN_NR_SearchSpace_controlResourceSetId_Optional(_buffer, _size, _lidx, &p->controlResourceSetId);
	_serNrSysEncSQN_NR_SearchSpace_monitoringSlotPeriodicityAndOffset_monitoringSlotPeriodicityAndOffset_Optional(_buffer, _size, _lidx, &p->monitoringSlotPeriodicityAndOffset);
	_serNrSysEncUint16_t_SQN_NR_SearchSpace_duration_Optional(_buffer, _size, _lidx, &p->duration);
	_serNrSysEncB14_SQN_NR_SearchSpace_monitoringSymbolsWithinSlot_Optional(_buffer, _size, _lidx, &p->monitoringSymbolsWithinSlot);
	_serNrSysEncSQN_NR_SearchSpace_nrofCandidates_nrofCandidates_Optional(_buffer, _size, _lidx, &p->nrofCandidates);
	_serNrSysEncSQN_NR_SearchSpace_searchSpaceType_searchSpaceType_Optional(_buffer, _size, _lidx, &p->searchSpaceType);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_SearchSpace_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_SearchSpace_Type_Value* p, enum NR_ASN1_SearchSpace_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_SearchSpace_Type_R15) {
		_serNrSysEncSQN_NR_SearchSpace(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_SearchSpace_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_SearchSpace_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_SearchSpace_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BWP_SearchSpaceConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BWP_SearchSpaceConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->TypeAndPriorityList.d, _lidx);
	for (size_t i3 = 0; i3 < p->TypeAndPriorityList.d; i3++) {
		_serNrSysEncNR_SearchSpaceTypeAndPriority_Type(_buffer, _size, _lidx, &p->TypeAndPriorityList.v[i3]);
	}
	{
		size_t _tmp = (size_t)p->AggregationLevel;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_SearchSpace_Type(_buffer, _size, _lidx, &p->SearchSpaceConfigAtUE);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BWP_SearchSpaceList_Type_SearchSpaceArray_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BWP_SearchSpaceList_Type_SearchSpaceArray_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncNR_BWP_SearchSpaceConfig_Type(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_shiftIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_shiftIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->reg_BundleSize;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->interleaverSize;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint16_t_SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved_shiftIndex_Optional(_buffer, _size, _lidx, &p->shiftIndex);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSet_cce_REG_MappingType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_ControlResourceSet_cce_REG_MappingType_Value* p, enum SQN_NR_ControlResourceSet_cce_REG_MappingType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved) {
		_serNrSysEncSQN_NR_ControlResourceSet_cce_REG_MappingType_interleaved(_buffer, _size, _lidx, &p->interleaved);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_ControlResourceSet_cce_REG_MappingType_nonInterleaved) {
		HTON_8(&_buffer[*_lidx], p->nonInterleaved, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_ControlResourceSet_cce_REG_MappingType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSet_cce_REG_MappingType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_ControlResourceSet_cce_REG_MappingType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToAddList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToAddList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSet_tci_PresentInDCI_e_tci_PresentInDCI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSet_tci_PresentInDCI_e_tci_PresentInDCI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_ControlResourceSet_pdcch_DMRS_ScramblingID_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_ControlResourceSet_pdcch_DMRS_ScramblingID_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ControlResourceSet_rb_Offset_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ControlResourceSet_rb_Offset_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ControlResourceSet_tci_PresentDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ControlResourceSet_tci_PresentDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ControlResourceSet_coresetPoolIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ControlResourceSet_coresetPoolIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSetId_v1610_SQN_NR_ControlResourceSet_controlResourceSetId_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSetId_v1610_SQN_NR_ControlResourceSet_controlResourceSetId_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->controlResourceSetId, _lidx);
	for (size_t i3 = 0; i3 < 45; i3++) {
		HTON_8(&_buffer[*_lidx], p->frequencyDomainResources[i3], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->duration, _lidx);
	_serNrSysEncSQN_NR_ControlResourceSet_cce_REG_MappingType(_buffer, _size, _lidx, &p->cce_REG_MappingType);
	{
		size_t _tmp = (size_t)p->precoderGranularity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToAddList_DynamicOptional(_buffer, _size, _lidx, &p->tci_StatesPDCCH_ToAddList);
	_serNrSysEncSQN_NR_TCI_StateId_SQN_NR_ControlResourceSet_tci_StatesPDCCH_ToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->tci_StatesPDCCH_ToReleaseList);
	_serNrSysEncSQN_NR_ControlResourceSet_tci_PresentInDCI_e_tci_PresentInDCI_Optional(_buffer, _size, _lidx, &p->tci_PresentInDCI);
	_serNrSysEncUint16_t_SQN_NR_ControlResourceSet_pdcch_DMRS_ScramblingID_Optional(_buffer, _size, _lidx, &p->pdcch_DMRS_ScramblingID);
	_serNrSysEncUint8_t_SQN_NR_ControlResourceSet_rb_Offset_r16_Optional(_buffer, _size, _lidx, &p->rb_Offset_r16);
	_serNrSysEncUint8_t_SQN_NR_ControlResourceSet_tci_PresentDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->tci_PresentDCI_1_2_r16);
	_serNrSysEncUint8_t_SQN_NR_ControlResourceSet_coresetPoolIndex_r16_Optional(_buffer, _size, _lidx, &p->coresetPoolIndex_r16);
	_serNrSysEncSQN_NR_ControlResourceSetId_v1610_SQN_NR_ControlResourceSet_controlResourceSetId_v1610_Optional(_buffer, _size, _lidx, &p->controlResourceSetId_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_ControlResourceSet_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_ControlResourceSet_Type_Value* p, enum NR_ASN1_ControlResourceSet_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_ControlResourceSet_Type_R15) {
		_serNrSysEncSQN_NR_ControlResourceSet(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_ControlResourceSet_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_ControlResourceSet_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_ControlResourceSet_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BWP_CoresetList_Type_CoresetArray_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BWP_CoresetList_Type_CoresetArray_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncNR_ASN1_ControlResourceSet_Type(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_PdcchToCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_PdcchToCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_PdcchToDmrs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_PdcchToDmrs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PDCCH_EPREs_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PDCCH_EPREs_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_EPRE_Ratio_Type_PdcchToCell_Optional(_buffer, _size, _lidx, &p->PdcchToCell);
	_serNrSysEncNR_EPRE_Ratio_Type_PdcchToDmrs_Optional(_buffer, _size, _lidx, &p->PdcchToDmrs);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PDCCH_EPREs_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PDCCH_EPREs_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_PDCCH_EPREs_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_BWP_PDCCH_Configuration_Type_Coreset0_OffsetRBs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_BWP_PDCCH_Configuration_Type_Coreset0_OffsetRBs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BWP_PDCCH_Configuration_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BWP_PDCCH_Configuration_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_BWP_SearchSpaceList_Type_SearchSpaceArray_Optional(_buffer, _size, _lidx, &p->SearchSpaceArray);
	_serNrSysEncNR_BWP_CoresetList_Type_CoresetArray_Optional(_buffer, _size, _lidx, &p->CoresetArray);
	_serNrSysEncNR_PDCCH_EPREs_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);
	_serNrSysEncInt32_t_NR_BWP_PDCCH_Configuration_Type_Coreset0_OffsetRBs_Optional(_buffer, _size, _lidx, &p->Coreset0_OffsetRBs);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BWP_PDCCH_Configuration_Type_Pdcch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BWP_PDCCH_Configuration_Type_Pdcch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_BWP_PDCCH_Configuration_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_k0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_k0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocation* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_k0_Optional(_buffer, _size, _lidx, &p->k0);
	{
		size_t _tmp = (size_t)p->mappingType;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->startSymbolAndLength, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocationList_SQN_NR_PDSCH_ConfigCommon_pdsch_TimeDomainAllocationList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocationList_SQN_NR_PDSCH_ConfigCommon_pdsch_TimeDomainAllocationList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocationList_SQN_NR_PDSCH_ConfigCommon_pdsch_TimeDomainAllocationList_Optional(_buffer, _size, _lidx, &p->pdsch_TimeDomainAllocationList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PDSCH_ConfigCommon_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_PDSCH_ConfigCommon_Type_Value* p, enum NR_ASN1_PDSCH_ConfigCommon_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_PDSCH_ConfigCommon_Type_R15) {
		_serNrSysEncSQN_NR_PDSCH_ConfigCommon(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_PDSCH_ConfigCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PDSCH_ConfigCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_PDSCH_ConfigCommon_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PDSCH_ConfigCommon_Type_ConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PDSCH_ConfigCommon_Type_ConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_PDSCH_ConfigCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_dmrs_Type_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_dmrs_Type_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_DownlinkConfig_maxLength_e_maxLength_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_DownlinkConfig_maxLength_e_maxLength_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PTRS_DownlinkConfig_frequencyDensity_ArrayOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PTRS_DownlinkConfig_frequencyDensity_ArrayOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_16(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PTRS_DownlinkConfig_timeDensity_ArrayOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PTRS_DownlinkConfig_timeDensity_ArrayOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 3; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PTRS_DownlinkConfig_epre_Ratio_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PTRS_DownlinkConfig_epre_Ratio_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_resourceElementOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_resourceElementOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_maxNrofPorts_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_maxNrofPorts_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_DownlinkConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_DownlinkConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_PTRS_DownlinkConfig_frequencyDensity_ArrayOptional(_buffer, _size, _lidx, &p->frequencyDensity);
	_serNrSysEncUint8_t_SQN_NR_PTRS_DownlinkConfig_timeDensity_ArrayOptional(_buffer, _size, _lidx, &p->timeDensity);
	_serNrSysEncUint8_t_SQN_NR_PTRS_DownlinkConfig_epre_Ratio_Optional(_buffer, _size, _lidx, &p->epre_Ratio);
	_serNrSysEncSQN_NR_PTRS_DownlinkConfig_resourceElementOffset_e_resourceElementOffset_Optional(_buffer, _size, _lidx, &p->resourceElementOffset);
	_serNrSysEncSQN_NR_PTRS_DownlinkConfig_maxNrofPorts_r16_e_maxNrofPorts_r16_Optional(_buffer, _size, _lidx, &p->maxNrofPorts_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Value* p, enum SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_setup) {
		_serNrSysEncSQN_NR_PTRS_DownlinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_SQN_NR_DMRS_DownlinkConfig_phaseTrackingRS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_SQN_NR_DMRS_DownlinkConfig_phaseTrackingRS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_dmrs_Downlink_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_dmrs_Downlink_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_DownlinkConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_DownlinkConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_DMRS_DownlinkConfig_dmrs_Type_e_dmrs_Type_Optional(_buffer, _size, _lidx, &p->dmrs_Type);
	_serNrSysEncSQN_NR_DMRS_DownlinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(_buffer, _size, _lidx, &p->dmrs_AdditionalPosition);
	_serNrSysEncSQN_NR_DMRS_DownlinkConfig_maxLength_e_maxLength_Optional(_buffer, _size, _lidx, &p->maxLength);
	_serNrSysEncUint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID0_Optional(_buffer, _size, _lidx, &p->scramblingID0);
	_serNrSysEncUint16_t_SQN_NR_DMRS_DownlinkConfig_scramblingID1_Optional(_buffer, _size, _lidx, &p->scramblingID1);
	_serNrSysEncSQN_NR_SetupRelease_DMRS_DownlinkConfig_phaseTrackingRS_SQN_NR_DMRS_DownlinkConfig_phaseTrackingRS_Optional(_buffer, _size, _lidx, &p->phaseTrackingRS);
	_serNrSysEncSQN_NR_DMRS_DownlinkConfig_dmrs_Downlink_r16_e_dmrs_Downlink_r16_Optional(_buffer, _size, _lidx, &p->dmrs_Downlink_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_setup) {
		_serNrSysEncSQN_NR_DMRS_DownlinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_setup) {
		_serNrSysEncSQN_NR_DMRS_DownlinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServCellIndex_SQN_NR_QCL_Info_cell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServCellIndex_SQN_NR_QCL_Info_cell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_Id_SQN_NR_QCL_Info_bwp_Id_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_Id_SQN_NR_QCL_Info_bwp_Id_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_QCL_Info_referenceSignal_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_QCL_Info_referenceSignal_Value* p, enum SQN_NR_QCL_Info_referenceSignal_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_QCL_Info_referenceSignal_csi_rs) {
		HTON_8(&_buffer[*_lidx], p->csi_rs, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_QCL_Info_referenceSignal_ssb) {
		HTON_8(&_buffer[*_lidx], p->ssb, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_QCL_Info_referenceSignal(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_QCL_Info_referenceSignal* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_QCL_Info_referenceSignal_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_QCL_Info(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_QCL_Info* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ServCellIndex_SQN_NR_QCL_Info_cell_Optional(_buffer, _size, _lidx, &p->cell);
	_serNrSysEncSQN_NR_BWP_Id_SQN_NR_QCL_Info_bwp_Id_Optional(_buffer, _size, _lidx, &p->bwp_Id);
	_serNrSysEncSQN_NR_QCL_Info_referenceSignal(_buffer, _size, _lidx, &p->referenceSignal);
	{
		size_t _tmp = (size_t)p->qcl_Type;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_QCL_Info_SQN_NR_TCI_State_qcl_Type2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_QCL_Info_SQN_NR_TCI_State_qcl_Type2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_QCL_Info(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TCI_State(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TCI_State* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->tci_StateId, _lidx);
	_serNrSysEncSQN_NR_QCL_Info(_buffer, _size, _lidx, &p->qcl_Type1);
	_serNrSysEncSQN_NR_QCL_Info_SQN_NR_TCI_State_qcl_Type2_Optional(_buffer, _size, _lidx, &p->qcl_Type2);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TCI_State_SQN_NR_PDSCH_Config_tci_StatesToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TCI_State_SQN_NR_PDSCH_Config_tci_StatesToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_TCI_State(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TCI_StateId_SQN_NR_PDSCH_Config_tci_StatesToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TCI_StateId_SQN_NR_PDSCH_Config_tci_StatesToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_vrb_ToPRB_Interleaver_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_vrb_ToPRB_Interleaver_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_pdsch_AggregationFactor_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_pdsch_AggregationFactor_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPattern_SQN_NR_PDSCH_Config_rateMatchPatternToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPattern_SQN_NR_PDSCH_Config_rateMatchPatternToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_RateMatchPattern(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPatternId_SQN_NR_PDSCH_Config_rateMatchPatternToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPatternId_SQN_NR_PDSCH_Config_rateMatchPatternToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPatternGroup_s_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RateMatchPatternGroup_s_Value* p, enum SQN_NR_RateMatchPatternGroup_s_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RateMatchPatternGroup_s_cellLevel) {
		HTON_8(&_buffer[*_lidx], p->cellLevel, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RateMatchPatternGroup_s_bwpLevel) {
		HTON_8(&_buffer[*_lidx], p->bwpLevel, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RateMatchPatternGroup_s(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPatternGroup_s* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RateMatchPatternGroup_s_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_RateMatchPatternGroup_s(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_RateMatchPatternGroup_s(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_mcs_Table_e_mcs_Table_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_mcs_Table_e_mcs_Table_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_maxNrofCodeWordsScheduledByDCI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_maxNrofCodeWordsScheduledByDCI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_bundleSize_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_bundleSize_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_staticBundling(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_staticBundling_bundleSize_e_bundleSize_Optional(_buffer, _size, _lidx, &p->bundleSize);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_bundleSizeSet1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_bundleSizeSet1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_bundleSizeSet2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_bundleSizeSet2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet1_e_bundleSizeSet1_Optional(_buffer, _size, _lidx, &p->bundleSizeSet1);
	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling_bundleSizeSet2_e_bundleSizeSet2_Optional(_buffer, _size, _lidx, &p->bundleSizeSet2);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PDSCH_Config_prb_BundlingType_Value* p, enum SQN_NR_PDSCH_Config_prb_BundlingType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PDSCH_Config_prb_BundlingType_staticBundling) {
		_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_staticBundling(_buffer, _size, _lidx, &p->staticBundling);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling) {
		_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_dynamicBundling(_buffer, _size, _lidx, &p->dynamicBundling);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Value* p, enum SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_row1) {
		for (size_t i3 = 0; i3 < 4; i3++) {
			HTON_8(&_buffer[*_lidx], p->row1[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_row2) {
		for (size_t i3 = 0; i3 < 12; i3++) {
			HTON_8(&_buffer[*_lidx], p->row2[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_row4) {
		for (size_t i3 = 0; i3 < 3; i3++) {
			HTON_8(&_buffer[*_lidx], p->row4[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_other) {
		for (size_t i3 = 0; i3 < 6; i3++) {
			HTON_8(&_buffer[*_lidx], p->other[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_CSI_RS_ResourceMapping_firstOFDMSymbolInTimeDomain2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_CSI_RS_ResourceMapping_firstOFDMSymbolInTimeDomain2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CSI_RS_ResourceMapping_density_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_CSI_RS_ResourceMapping_density_Value* p, enum SQN_NR_CSI_RS_ResourceMapping_density_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_CSI_RS_ResourceMapping_density_dot5) {
		{
			size_t _tmp = (size_t)p->dot5;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_density_one) {
		HTON_8(&_buffer[*_lidx], p->one, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_density_three) {
		HTON_8(&_buffer[*_lidx], p->three, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_RS_ResourceMapping_density_spare) {
		HTON_8(&_buffer[*_lidx], p->spare, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_CSI_RS_ResourceMapping_density(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CSI_RS_ResourceMapping_density* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CSI_RS_ResourceMapping_density_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CSI_FrequencyOccupation(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CSI_FrequencyOccupation* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->startingRB, _lidx);
	HTON_16(&_buffer[*_lidx], p->nrofRBs, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CSI_RS_ResourceMapping(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CSI_RS_ResourceMapping* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_CSI_RS_ResourceMapping_frequencyDomainAllocation(_buffer, _size, _lidx, &p->frequencyDomainAllocation);
	{
		size_t _tmp = (size_t)p->nrofPorts;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->firstOFDMSymbolInTimeDomain, _lidx);
	_serNrSysEncUint8_t_SQN_NR_CSI_RS_ResourceMapping_firstOFDMSymbolInTimeDomain2_Optional(_buffer, _size, _lidx, &p->firstOFDMSymbolInTimeDomain2);
	{
		size_t _tmp = (size_t)p->cdm_Type;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CSI_RS_ResourceMapping_density(_buffer, _size, _lidx, &p->density);
	_serNrSysEncSQN_NR_CSI_FrequencyOccupation(_buffer, _size, _lidx, &p->freqBand);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CSI_ResourcePeriodicityAndOffset_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_CSI_ResourcePeriodicityAndOffset_Value* p, enum SQN_NR_CSI_ResourcePeriodicityAndOffset_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots4) {
		HTON_8(&_buffer[*_lidx], p->slots4, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots5) {
		HTON_8(&_buffer[*_lidx], p->slots5, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots8) {
		HTON_8(&_buffer[*_lidx], p->slots8, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots10) {
		HTON_8(&_buffer[*_lidx], p->slots10, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots16) {
		HTON_8(&_buffer[*_lidx], p->slots16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots20) {
		HTON_8(&_buffer[*_lidx], p->slots20, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots32) {
		HTON_8(&_buffer[*_lidx], p->slots32, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots40) {
		HTON_8(&_buffer[*_lidx], p->slots40, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots64) {
		HTON_8(&_buffer[*_lidx], p->slots64, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots80) {
		HTON_8(&_buffer[*_lidx], p->slots80, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots160) {
		HTON_8(&_buffer[*_lidx], p->slots160, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots320) {
		HTON_16(&_buffer[*_lidx], p->slots320, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CSI_ResourcePeriodicityAndOffset_slots640) {
		HTON_16(&_buffer[*_lidx], p->slots640, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_CSI_ResourcePeriodicityAndOffset(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CSI_ResourcePeriodicityAndOffset* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CSI_ResourcePeriodicityAndOffset_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CSI_ResourcePeriodicityAndOffset_SQN_NR_ZP_CSI_RS_Resource_periodicityAndOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CSI_ResourcePeriodicityAndOffset_SQN_NR_ZP_CSI_RS_Resource_periodicityAndOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CSI_ResourcePeriodicityAndOffset(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_Resource(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_Resource* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->zp_CSI_RS_ResourceId, _lidx);
	_serNrSysEncSQN_NR_CSI_RS_ResourceMapping(_buffer, _size, _lidx, &p->resourceMapping);
	_serNrSysEncSQN_NR_CSI_ResourcePeriodicityAndOffset_SQN_NR_ZP_CSI_RS_Resource_periodicityAndOffset_Optional(_buffer, _size, _lidx, &p->periodicityAndOffset);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_Resource_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_Resource_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_ZP_CSI_RS_Resource(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceId_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceId_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->zp_CSI_RS_ResourceSetId, _lidx);
	HTON_32(&_buffer[*_lidx], p->zp_CSI_RS_ResourceIdList.d, _lidx);
	for (size_t i3 = 0; i3 < p->zp_CSI_RS_ResourceIdList.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->zp_CSI_RS_ResourceIdList.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_setup) {
		_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_setup) {
		HTON_8(&_buffer[*_lidx], p->setup, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_SQN_NR_PDSCH_Config_maxMIMO_Layers_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_SQN_NR_PDSCH_Config_maxMIMO_Layers_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_SQN_NR_PDSCH_Config_minimumSchedulingOffsetK0_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_SQN_NR_PDSCH_Config_minimumSchedulingOffsetK0_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_antennaPortsFieldPresenceDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_antennaPortsFieldPresenceDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_setup) {
		_serNrSysEncSQN_NR_DMRS_DownlinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_setup) {
		_serNrSysEncSQN_NR_DMRS_DownlinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_dmrs_SequenceInitializationDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_dmrs_SequenceInitializationDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PDSCH_Config_harq_ProcessNumberSizeDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PDSCH_Config_harq_ProcessNumberSizeDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_mcs_TableDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_mcs_TableDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PDSCH_Config_numberOfBitsForRV_DCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PDSCH_Config_numberOfBitsForRV_DCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_k0_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_k0_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_repetitionNumber_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_repetitionNumber_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_TimeDomainResourceAllocation_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_PDSCH_TimeDomainResourceAllocation_r16_k0_r16_Optional(_buffer, _size, _lidx, &p->k0_r16);
	{
		size_t _tmp = (size_t)p->mappingType_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->startSymbolAndLength_r16, _lidx);
	_serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation_r16_repetitionNumber_r16_e_repetitionNumber_r16_Optional(_buffer, _size, _lidx, &p->repetitionNumber_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_bundleSize_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_bundleSize_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16_bundleSize_r16_e_bundleSize_r16_Optional(_buffer, _size, _lidx, &p->bundleSize_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_bundleSizeSet1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_bundleSizeSet1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_bundleSizeSet2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_bundleSizeSet2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet1_r16_e_bundleSizeSet1_r16_Optional(_buffer, _size, _lidx, &p->bundleSizeSet1_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16_bundleSizeSet2_r16_e_bundleSizeSet2_r16_Optional(_buffer, _size, _lidx, &p->bundleSizeSet2_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Value* p, enum SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16) {
		_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_staticBundling_r16(_buffer, _size, _lidx, &p->staticBundling_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16) {
		_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_dynamicBundling_r16(_buffer, _size, _lidx, &p->dynamicBundling_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_prb_BundlingTypeDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_prb_BundlingTypeDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_priorityIndicatorDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_priorityIndicatorDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1DCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1DCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_RateMatchPatternGroup_s(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2DCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2DCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_RateMatchPatternGroup_s(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_resourceAllocationType1GranularityDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_resourceAllocationType1GranularityDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_vrb_ToPRB_InterleaverDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_vrb_ToPRB_InterleaverDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_referenceOfSLIVDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_referenceOfSLIVDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_priorityIndicatorDCI_1_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_priorityIndicatorDCI_1_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PDSCH_TimeDomainResourceAllocation_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_FDM_TDM_r16_startingSymbolOffsetK_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_FDM_TDM_r16_startingSymbolOffsetK_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FDM_TDM_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FDM_TDM_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->repetitionScheme_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint8_t_SQN_NR_FDM_TDM_r16_startingSymbolOffsetK_r16_Optional(_buffer, _size, _lidx, &p->startingSymbolOffsetK_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Value* p, enum SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_setup) {
		_serNrSysEncSQN_NR_FDM_TDM_r16(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SlotBased_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SlotBased_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->tciMapping_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->sequenceOffsetforRV_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Value* p, enum SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_setup) {
		_serNrSysEncSQN_NR_SlotBased_r16(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RepetitionSchemeConfig_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RepetitionSchemeConfig_r16_Value* p, enum SQN_NR_RepetitionSchemeConfig_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RepetitionSchemeConfig_r16_fdm_TDM_r16) {
		_serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_fdm_TDM_r16(_buffer, _size, _lidx, &p->fdm_TDM_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RepetitionSchemeConfig_r16_slotBased_r16) {
		_serNrSysEncSQN_NR_SetupRelease_RepetitionSchemeConfig_r16_slotBased_r16(_buffer, _size, _lidx, &p->slotBased_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RepetitionSchemeConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RepetitionSchemeConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RepetitionSchemeConfig_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Value* p, enum SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_setup) {
		_serNrSysEncSQN_NR_RepetitionSchemeConfig_r16(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_SQN_NR_PDSCH_Config_repetitionSchemeConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_SQN_NR_PDSCH_Config_repetitionSchemeConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDSCH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDSCH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH_Optional(_buffer, _size, _lidx, &p->dataScramblingIdentityPDSCH);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_Optional(_buffer, _size, _lidx, &p->dmrs_DownlinkForPDSCH_MappingTypeA);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_Optional(_buffer, _size, _lidx, &p->dmrs_DownlinkForPDSCH_MappingTypeB);
	_serNrSysEncSQN_NR_TCI_State_SQN_NR_PDSCH_Config_tci_StatesToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->tci_StatesToAddModList);
	_serNrSysEncSQN_NR_TCI_StateId_SQN_NR_PDSCH_Config_tci_StatesToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->tci_StatesToReleaseList);
	_serNrSysEncSQN_NR_PDSCH_Config_vrb_ToPRB_Interleaver_e_vrb_ToPRB_Interleaver_Optional(_buffer, _size, _lidx, &p->vrb_ToPRB_Interleaver);
	{
		size_t _tmp = (size_t)p->resourceAllocation;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_Optional(_buffer, _size, _lidx, &p->pdsch_TimeDomainAllocationList);
	_serNrSysEncSQN_NR_PDSCH_Config_pdsch_AggregationFactor_e_pdsch_AggregationFactor_Optional(_buffer, _size, _lidx, &p->pdsch_AggregationFactor);
	_serNrSysEncSQN_NR_RateMatchPattern_SQN_NR_PDSCH_Config_rateMatchPatternToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->rateMatchPatternToAddModList);
	_serNrSysEncSQN_NR_RateMatchPatternId_SQN_NR_PDSCH_Config_rateMatchPatternToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->rateMatchPatternToReleaseList);
	_serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1_Optional(_buffer, _size, _lidx, &p->rateMatchPatternGroup1);
	_serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2_Optional(_buffer, _size, _lidx, &p->rateMatchPatternGroup2);
	{
		size_t _tmp = (size_t)p->rbg_Size;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PDSCH_Config_mcs_Table_e_mcs_Table_Optional(_buffer, _size, _lidx, &p->mcs_Table);
	_serNrSysEncSQN_NR_PDSCH_Config_maxNrofCodeWordsScheduledByDCI_e_maxNrofCodeWordsScheduledByDCI_Optional(_buffer, _size, _lidx, &p->maxNrofCodeWordsScheduledByDCI);
	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingType(_buffer, _size, _lidx, &p->prb_BundlingType);
	_serNrSysEncSQN_NR_ZP_CSI_RS_Resource_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->zp_CSI_RS_ResourceToAddModList);
	_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceId_SQN_NR_PDSCH_Config_zp_CSI_RS_ResourceToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->zp_CSI_RS_ResourceToReleaseList);
	_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->aperiodic_ZP_CSI_RS_ResourceSetsToAddModList);
	_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->aperiodic_ZP_CSI_RS_ResourceSetsToReleaseList);
	_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->sp_ZP_CSI_RS_ResourceSetsToAddModList);
	_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_sp_ZP_CSI_RS_ResourceSetsToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->sp_ZP_CSI_RS_ResourceSetsToReleaseList);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_p_ZP_CSI_RS_ResourceSet_Optional(_buffer, _size, _lidx, &p->p_ZP_CSI_RS_ResourceSet);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_maxMIMO_Layers_r16_SQN_NR_PDSCH_Config_maxMIMO_Layers_r16_Optional(_buffer, _size, _lidx, &p->maxMIMO_Layers_r16);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_minimumSchedulingOffsetK0_r16_SQN_NR_PDSCH_Config_minimumSchedulingOffsetK0_r16_Optional(_buffer, _size, _lidx, &p->minimumSchedulingOffsetK0_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_antennaPortsFieldPresenceDCI_1_2_r16_e_antennaPortsFieldPresenceDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->antennaPortsFieldPresenceDCI_1_2_r16);
	_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSet_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16_DynamicOptional(_buffer, _size, _lidx, &p->aperiodicZP_CSI_RS_ResourceSetsToAddModListDCI_1_2_r16);
	_serNrSysEncSQN_NR_ZP_CSI_RS_ResourceSetId_SQN_NR_PDSCH_Config_aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16_DynamicOptional(_buffer, _size, _lidx, &p->aperiodicZP_CSI_RS_ResourceSetsToReleaseListDCI_1_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->dmrs_DownlinkForPDSCH_MappingTypeA_DCI_1_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_SQN_NR_PDSCH_Config_dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->dmrs_DownlinkForPDSCH_MappingTypeB_DCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_dmrs_SequenceInitializationDCI_1_2_r16_e_dmrs_SequenceInitializationDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->dmrs_SequenceInitializationDCI_1_2_r16);
	_serNrSysEncUint8_t_SQN_NR_PDSCH_Config_harq_ProcessNumberSizeDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->harq_ProcessNumberSizeDCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_mcs_TableDCI_1_2_r16_e_mcs_TableDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->mcs_TableDCI_1_2_r16);
	_serNrSysEncUint8_t_SQN_NR_PDSCH_Config_numberOfBitsForRV_DCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->numberOfBitsForRV_DCI_1_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationListDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->pdsch_TimeDomainAllocationListDCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_prb_BundlingTypeDCI_1_2_r16_prb_BundlingTypeDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->prb_BundlingTypeDCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_priorityIndicatorDCI_1_2_r16_e_priorityIndicatorDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->priorityIndicatorDCI_1_2_r16);
	_serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup1DCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->rateMatchPatternGroup1DCI_1_2_r16);
	_serNrSysEncSQN_NR_RateMatchPatternGroup_SQN_NR_PDSCH_Config_rateMatchPatternGroup2DCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->rateMatchPatternGroup2DCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_resourceAllocationType1GranularityDCI_1_2_r16_e_resourceAllocationType1GranularityDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->resourceAllocationType1GranularityDCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_vrb_ToPRB_InterleaverDCI_1_2_r16_e_vrb_ToPRB_InterleaverDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->vrb_ToPRB_InterleaverDCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_referenceOfSLIVDCI_1_2_r16_e_referenceOfSLIVDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->referenceOfSLIVDCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_resourceAllocationDCI_1_2_r16_e_resourceAllocationDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->resourceAllocationDCI_1_2_r16);
	_serNrSysEncSQN_NR_PDSCH_Config_priorityIndicatorDCI_1_1_r16_e_priorityIndicatorDCI_1_1_r16_Optional(_buffer, _size, _lidx, &p->priorityIndicatorDCI_1_1_r16);
	_serNrSysEncUint16_t_SQN_NR_PDSCH_Config_dataScramblingIdentityPDSCH2_r16_Optional(_buffer, _size, _lidx, &p->dataScramblingIdentityPDSCH2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_SQN_NR_PDSCH_Config_pdsch_TimeDomainAllocationList_r16_Optional(_buffer, _size, _lidx, &p->pdsch_TimeDomainAllocationList_r16);
	_serNrSysEncSQN_NR_SetupRelease_PDSCH_Config_repetitionSchemeConfig_r16_SQN_NR_PDSCH_Config_repetitionSchemeConfig_r16_Optional(_buffer, _size, _lidx, &p->repetitionSchemeConfig_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PDSCH_Config_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_PDSCH_Config_Type_Value* p, enum NR_ASN1_PDSCH_Config_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_PDSCH_Config_Type_R15) {
		_serNrSysEncSQN_NR_PDSCH_Config(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_PDSCH_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PDSCH_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_PDSCH_Config_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PDSCH_Config_Type_ConfigDedicated_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PDSCH_Config_Type_ConfigDedicated_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_PDSCH_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_PdschToCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_PdschToCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_PdschToDmrs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_PdschToDmrs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_EPRE_Ratio_Type_PdschToPtrs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_EPRE_Ratio_Type_PdschToPtrs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PDSCH_EPREs_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PDSCH_EPREs_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_EPRE_Ratio_Type_PdschToCell_Optional(_buffer, _size, _lidx, &p->PdschToCell);
	_serNrSysEncNR_EPRE_Ratio_Type_PdschToDmrs_Optional(_buffer, _size, _lidx, &p->PdschToDmrs);
	_serNrSysEncNR_EPRE_Ratio_Type_PdschToPtrs_Optional(_buffer, _size, _lidx, &p->PdschToPtrs);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PDSCH_EPREs_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PDSCH_EPREs_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_PDSCH_EPREs_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BWP_PDSCH_Configuration_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BWP_PDSCH_Configuration_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_ASN1_PDSCH_ConfigCommon_Type_ConfigCommon_Optional(_buffer, _size, _lidx, &p->ConfigCommon);
	_serNrSysEncNR_ASN1_PDSCH_Config_Type_ConfigDedicated_Optional(_buffer, _size, _lidx, &p->ConfigDedicated);
	_serNrSysEncNR_PDSCH_EPREs_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BWP_PDSCH_Configuration_Type_Pdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BWP_PDSCH_Configuration_Type_Pdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_BWP_PDSCH_Configuration_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_SPS_Config_n1PUCCH_AN_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_SPS_Config_n1PUCCH_AN_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SPS_Config_mcs_Table_e_mcs_Table_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SPS_Config_mcs_Table_e_mcs_Table_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SPS_ConfigIndex_r16_SQN_NR_SPS_Config_sps_ConfigIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SPS_ConfigIndex_r16_SQN_NR_SPS_Config_sps_ConfigIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SPS_Config_harq_ProcID_Offset_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SPS_Config_harq_ProcID_Offset_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_SPS_Config_periodicityExt_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_SPS_Config_periodicityExt_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SPS_Config_harq_CodebookID_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SPS_Config_harq_CodebookID_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_pdsch_AggregationFactor_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_pdsch_AggregationFactor_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SPS_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SPS_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->periodicity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->nrofHARQ_Processes, _lidx);
	_serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_SPS_Config_n1PUCCH_AN_Optional(_buffer, _size, _lidx, &p->n1PUCCH_AN);
	_serNrSysEncSQN_NR_SPS_Config_mcs_Table_e_mcs_Table_Optional(_buffer, _size, _lidx, &p->mcs_Table);
	_serNrSysEncSQN_NR_SPS_ConfigIndex_r16_SQN_NR_SPS_Config_sps_ConfigIndex_r16_Optional(_buffer, _size, _lidx, &p->sps_ConfigIndex_r16);
	_serNrSysEncUint8_t_SQN_NR_SPS_Config_harq_ProcID_Offset_r16_Optional(_buffer, _size, _lidx, &p->harq_ProcID_Offset_r16);
	_serNrSysEncUint16_t_SQN_NR_SPS_Config_periodicityExt_r16_Optional(_buffer, _size, _lidx, &p->periodicityExt_r16);
	_serNrSysEncUint8_t_SQN_NR_SPS_Config_harq_CodebookID_r16_Optional(_buffer, _size, _lidx, &p->harq_CodebookID_r16);
	_serNrSysEncSQN_NR_SPS_Config_pdsch_AggregationFactor_r16_e_pdsch_AggregationFactor_r16_Optional(_buffer, _size, _lidx, &p->pdsch_AggregationFactor_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_SPS_Config_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_SPS_Config_Type_Value* p, enum NR_ASN1_SPS_Config_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_SPS_Config_Type_R15) {
		_serNrSysEncSQN_NR_SPS_Config(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_SPS_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_SPS_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_SPS_Config_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_SPS_Config_Type_Sps_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_SPS_Config_Type_Sps_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_SPS_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DownlinkBWP_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DownlinkBWP_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BWP_Id_NR_DownlinkBWP_Type_Id_Optional(_buffer, _size, _lidx, &p->Id);
	_serNrSysEncNR_ASN1_BWP_Type_BWP_Optional(_buffer, _size, _lidx, &p->BWP);
	_serNrSysEncNR_BWP_PDCCH_Configuration_Type_Pdcch_Optional(_buffer, _size, _lidx, &p->Pdcch);
	_serNrSysEncNR_BWP_PDSCH_Configuration_Type_Pdsch_Optional(_buffer, _size, _lidx, &p->Pdsch);
	_serNrSysEncNR_ASN1_SPS_Config_Type_Sps_Optional(_buffer, _size, _lidx, &p->Sps);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DownlinkBWP_List_Type_BwpArray_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DownlinkBWP_List_Type_BwpArray_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_DownlinkBWP_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DownlinkBWPs_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DownlinkBWPs_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BWP_Id_ActiveBWP_Optional(_buffer, _size, _lidx, &p->ActiveBWP);
	_serNrSysEncNR_DownlinkBWP_List_Type_BwpArray_Optional(_buffer, _size, _lidx, &p->BwpArray);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DownlinkBWPs_Type_BWPs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DownlinkBWPs_Type_BWPs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DownlinkBWPs_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ScramblingId_ScramblingId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ScramblingId_ScramblingId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CSI_RS_ResourceMapping_ResourceMapping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CSI_RS_ResourceMapping_ResourceMapping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CSI_RS_ResourceMapping(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_NZP_CSI_RS_Config_Type_OffsetToFreqBand_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_NZP_CSI_RS_Config_Type_OffsetToFreqBand_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CSI_RS_Periodicity_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_CSI_RS_Periodicity_Type_Value* p, enum NR_CSI_RS_Periodicity_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_CSI_RS_Periodicity_Type_PeriodicityAndOffset) {
		_serNrSysEncSQN_NR_CSI_ResourcePeriodicityAndOffset(_buffer, _size, _lidx, &p->PeriodicityAndOffset);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_CSI_RS_Periodicity_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CSI_RS_Periodicity_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_CSI_RS_Periodicity_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CSI_RS_Periodicity_Type_Periodicity_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CSI_RS_Periodicity_Type_Periodicity_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CSI_RS_Periodicity_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_NZP_CSI_RS_Config_Type_Attenuation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_NZP_CSI_RS_Config_Type_Attenuation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_NZP_CSI_RS_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_NZP_CSI_RS_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ScramblingId_ScramblingId_Optional(_buffer, _size, _lidx, &p->ScramblingId);
	_serNrSysEncSQN_NR_CSI_RS_ResourceMapping_ResourceMapping_Optional(_buffer, _size, _lidx, &p->ResourceMapping);
	_serNrSysEncInt32_t_NR_NZP_CSI_RS_Config_Type_OffsetToFreqBand_Optional(_buffer, _size, _lidx, &p->OffsetToFreqBand);
	_serNrSysEncNR_CSI_RS_Periodicity_Type_Periodicity_Optional(_buffer, _size, _lidx, &p->Periodicity);
	_serNrSysEncInt32_t_NR_NZP_CSI_RS_Config_Type_Attenuation_Optional(_buffer, _size, _lidx, &p->Attenuation);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CSI_Config_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_CSI_Config_Type_Value* p, enum NR_CSI_Config_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_CSI_Config_Type_CSI_RS) {
		HTON_32(&_buffer[*_lidx], p->CSI_RS.d, _lidx);
		for (size_t i1 = 0; i1 < p->CSI_RS.d; i1++) {
			_serNrSysEncNR_NZP_CSI_RS_Config_Type(_buffer, _size, _lidx, &p->CSI_RS.v[i1]);
		}
		return SIDL_STATUS_OK;
	}
	if (d == NR_CSI_Config_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_CSI_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CSI_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_CSI_Config_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CSI_Config_Type_CsiConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CSI_Config_Type_CsiConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CSI_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayerDownlink_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayerDownlink_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_ASN1_FrequencyInfoDL_Type_FrequencyInfoDL_Optional(_buffer, _size, _lidx, &p->FrequencyInfoDL);
	_serNrSysEncNR_SSB_Config_Type_SSPbchBlock_Optional(_buffer, _size, _lidx, &p->SSPbchBlock);
	_serNrSysEncNR_PDSCH_CellLevelConfig_Type_PdschCellLevelConfig_Optional(_buffer, _size, _lidx, &p->PdschCellLevelConfig);
	_serNrSysEncNR_DownlinkBWPs_Type_BWPs_Optional(_buffer, _size, _lidx, &p->BWPs);
	_serNrSysEncNR_CSI_Config_Type_CsiConfig_Optional(_buffer, _size, _lidx, &p->CsiConfig);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayerDownlink_Type_Downlink_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayerDownlink_Type_Downlink_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CellConfigPhysicalLayerDownlink_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MultiFrequencyBandListNR_SQN_NR_FrequencyInfoUL_frequencyBandList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MultiFrequencyBandListNR_SQN_NR_FrequencyInfoUL_frequencyBandList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_absoluteFrequencyPointA_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_absoluteFrequencyPointA_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_AdditionalSpectrumEmission_SQN_NR_FrequencyInfoUL_additionalSpectrumEmission_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_AdditionalSpectrumEmission_SQN_NR_FrequencyInfoUL_additionalSpectrumEmission_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P_Max_SQN_NR_FrequencyInfoUL_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P_Max_SQN_NR_FrequencyInfoUL_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FrequencyInfoUL(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FrequencyInfoUL* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MultiFrequencyBandListNR_SQN_NR_FrequencyInfoUL_frequencyBandList_Optional(_buffer, _size, _lidx, &p->frequencyBandList);
	_serNrSysEncSQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_absoluteFrequencyPointA_Optional(_buffer, _size, _lidx, &p->absoluteFrequencyPointA);
	HTON_32(&_buffer[*_lidx], p->scs_SpecificCarrierList.d, _lidx);
	for (size_t i1 = 0; i1 < p->scs_SpecificCarrierList.d; i1++) {
		_serNrSysEncSQN_NR_SCS_SpecificCarrier(_buffer, _size, _lidx, &p->scs_SpecificCarrierList.v[i1]);
	}
	_serNrSysEncSQN_NR_AdditionalSpectrumEmission_SQN_NR_FrequencyInfoUL_additionalSpectrumEmission_Optional(_buffer, _size, _lidx, &p->additionalSpectrumEmission);
	_serNrSysEncSQN_NR_P_Max_SQN_NR_FrequencyInfoUL_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	_serNrSysEncSQN_NR_FrequencyInfoUL_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional(_buffer, _size, _lidx, &p->frequencyShift7p5khz);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_FrequencyInfoUL_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_FrequencyInfoUL_Type_Value* p, enum NR_ASN1_FrequencyInfoUL_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_FrequencyInfoUL_Type_R15) {
		_serNrSysEncSQN_NR_FrequencyInfoUL(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_FrequencyInfoUL_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_FrequencyInfoUL_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_FrequencyInfoUL_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_FrequencyInfoUL_Type_FrequencyInfoUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_FrequencyInfoUL_Type_FrequencyInfoUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_FrequencyInfoUL_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ActiveUplinkBWP_Id_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ActiveUplinkBWP_Id_Type_Value* p, enum NR_ActiveUplinkBWP_Id_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ActiveUplinkBWP_Id_Type_Explicit) {
		HTON_8(&_buffer[*_lidx], p->Explicit, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_ActiveUplinkBWP_Id_Type_SameIdAsDL) {
		HTON_8(&_buffer[*_lidx], p->SameIdAsDL, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ActiveUplinkBWP_Id_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ActiveUplinkBWP_Id_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ActiveUplinkBWP_Id_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ActiveUplinkBWP_Id_Type_ActiveBWP_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ActiveUplinkBWP_Id_Type_ActiveBWP_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ActiveUplinkBWP_Id_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_Id_NR_UplinkBWP_Type_Id_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_Id_NR_UplinkBWP_Type_Id_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_prach_ConfigurationPeriodScaling_IAB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_prach_ConfigurationPeriodScaling_IAB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationFrameOffset_IAB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationFrameOffset_IAB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationSOffset_IAB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationSOffset_IAB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_ra_ResponseWindow_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_ra_ResponseWindow_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationIndex_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationIndex_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGeneric(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGeneric* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->prach_ConfigurationIndex, _lidx);
	{
		size_t _tmp = (size_t)p->msg1_FDM;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_16(&_buffer[*_lidx], p->msg1_FrequencyStart, _lidx);
	HTON_8(&_buffer[*_lidx], p->zeroCorrelationZoneConfig, _lidx);
	HTON_16(&_buffer[*_lidx], p->preambleReceivedTargetPower, _lidx);
	{
		size_t _tmp = (size_t)p->preambleTransMax;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->powerRampingStep;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->ra_ResponseWindow;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RACH_ConfigGeneric_prach_ConfigurationPeriodScaling_IAB_r16_e_prach_ConfigurationPeriodScaling_IAB_r16_Optional(_buffer, _size, _lidx, &p->prach_ConfigurationPeriodScaling_IAB_r16);
	_serNrSysEncUint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationFrameOffset_IAB_r16_Optional(_buffer, _size, _lidx, &p->prach_ConfigurationFrameOffset_IAB_r16);
	_serNrSysEncUint8_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationSOffset_IAB_r16_Optional(_buffer, _size, _lidx, &p->prach_ConfigurationSOffset_IAB_r16);
	_serNrSysEncSQN_NR_RACH_ConfigGeneric_ra_ResponseWindow_v1610_e_ra_ResponseWindow_v1610_Optional(_buffer, _size, _lidx, &p->ra_ResponseWindow_v1610);
	_serNrSysEncUint16_t_SQN_NR_RACH_ConfigGeneric_prach_ConfigurationIndex_v1610_Optional(_buffer, _size, _lidx, &p->prach_ConfigurationIndex_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommon_totalNumberOfRA_Preambles_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_RACH_ConfigCommon_totalNumberOfRA_Preambles_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Value* p, enum SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneEighth) {
		{
			size_t _tmp = (size_t)p->oneEighth;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneFourth) {
		{
			size_t _tmp = (size_t)p->oneFourth;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_oneHalf) {
		{
			size_t _tmp = (size_t)p->oneHalf;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_one) {
		{
			size_t _tmp = (size_t)p->one;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_two) {
		{
			size_t _tmp = (size_t)p->two;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_four) {
		HTON_8(&_buffer[*_lidx], p->four, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_eight) {
		HTON_8(&_buffer[*_lidx], p->eight, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_sixteen) {
		HTON_8(&_buffer[*_lidx], p->sixteen, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_groupBconfigured(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_groupBconfigured* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->ra_Msg3SizeGroupA;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->messagePowerOffsetGroupB;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->numberOfRA_PreamblesGroupA, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_groupBconfigured_groupBconfigured_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_groupBconfigured_groupBconfigured_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigCommon_groupBconfigured(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_SUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_SUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Value* p, enum SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_l839) {
		HTON_16(&_buffer[*_lidx], p->l839, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_l139) {
		HTON_8(&_buffer[*_lidx], p->l139, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommon_msg1_SubcarrierSpacing_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommon_msg1_SubcarrierSpacing_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_msg3_transformPrecoder_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_msg3_transformPrecoder_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RA_Prioritization_scalingFactorBI_e_scalingFactorBI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RA_Prioritization_scalingFactorBI_e_scalingFactorBI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RA_Prioritization(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RA_Prioritization* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->powerRampingStepHighPriority;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RA_Prioritization_scalingFactorBI_e_scalingFactorBI_Optional(_buffer, _size, _lidx, &p->scalingFactorBI);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RA_Prioritization(_buffer, _size, _lidx, &p->ra_Prioritization_r16);
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->ra_PrioritizationForAI_r16[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16_ra_PrioritizationForAccessIdentity_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16_ra_PrioritizationForAccessIdentity_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Value* p, enum SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_l571) {
		HTON_16(&_buffer[*_lidx], p->l571, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_l1151) {
		HTON_16(&_buffer[*_lidx], p->l1151, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_prach_RootSequenceIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_prach_RootSequenceIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RACH_ConfigGeneric(_buffer, _size, _lidx, &p->rach_ConfigGeneric);
	_serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommon_totalNumberOfRA_Preambles_Optional(_buffer, _size, _lidx, &p->totalNumberOfRA_Preambles);
	_serNrSysEncSQN_NR_RACH_ConfigCommon_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_ssb_perRACH_OccasionAndCB_PreamblesPerSSB_Optional(_buffer, _size, _lidx, &p->ssb_perRACH_OccasionAndCB_PreamblesPerSSB);
	_serNrSysEncSQN_NR_RACH_ConfigCommon_groupBconfigured_groupBconfigured_Optional(_buffer, _size, _lidx, &p->groupBconfigured);
	{
		size_t _tmp = (size_t)p->ra_ContentionResolutionTimer;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_Optional(_buffer, _size, _lidx, &p->rsrp_ThresholdSSB);
	_serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommon_rsrp_ThresholdSSB_SUL_Optional(_buffer, _size, _lidx, &p->rsrp_ThresholdSSB_SUL);
	_serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex(_buffer, _size, _lidx, &p->prach_RootSequenceIndex);
	_serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommon_msg1_SubcarrierSpacing_Optional(_buffer, _size, _lidx, &p->msg1_SubcarrierSpacing);
	{
		size_t _tmp = (size_t)p->restrictedSetConfig;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RACH_ConfigCommon_msg3_transformPrecoder_e_msg3_transformPrecoder_Optional(_buffer, _size, _lidx, &p->msg3_transformPrecoder);
	_serNrSysEncSQN_NR_RACH_ConfigCommon_ra_PrioritizationForAccessIdentity_r16_ra_PrioritizationForAccessIdentity_r16_Optional(_buffer, _size, _lidx, &p->ra_PrioritizationForAccessIdentity_r16);
	_serNrSysEncSQN_NR_RACH_ConfigCommon_prach_RootSequenceIndex_r16_prach_RootSequenceIndex_r16_Optional(_buffer, _size, _lidx, &p->prach_RootSequenceIndex_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_setup) {
		_serNrSysEncSQN_NR_RACH_ConfigCommon(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_SQN_NR_BWP_UplinkCommon_rach_ConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_SQN_NR_BWP_UplinkCommon_rach_ConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_groupHoppingEnabledTransformPrecoding_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_groupHoppingEnabledTransformPrecoding_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_k2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_k2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocation(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_TimeDomainResourceAllocation* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_k2_Optional(_buffer, _size, _lidx, &p->k2);
	{
		size_t _tmp = (size_t)p->mappingType;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->startSymbolAndLength, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocationList_SQN_NR_PUSCH_ConfigCommon_pusch_TimeDomainAllocationList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_TimeDomainResourceAllocationList_SQN_NR_PUSCH_ConfigCommon_pusch_TimeDomainAllocationList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocation(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_PUSCH_ConfigCommon_msg3_DeltaPreamble_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_PUSCH_ConfigCommon_msg3_DeltaPreamble_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt16_t_SQN_NR_PUSCH_ConfigCommon_p0_NominalWithGrant_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_NR_PUSCH_ConfigCommon_p0_NominalWithGrant_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUSCH_ConfigCommon_groupHoppingEnabledTransformPrecoding_e_groupHoppingEnabledTransformPrecoding_Optional(_buffer, _size, _lidx, &p->groupHoppingEnabledTransformPrecoding);
	_serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocationList_SQN_NR_PUSCH_ConfigCommon_pusch_TimeDomainAllocationList_Optional(_buffer, _size, _lidx, &p->pusch_TimeDomainAllocationList);
	_serNrSysEncInt8_t_SQN_NR_PUSCH_ConfigCommon_msg3_DeltaPreamble_Optional(_buffer, _size, _lidx, &p->msg3_DeltaPreamble);
	_serNrSysEncInt16_t_SQN_NR_PUSCH_ConfigCommon_p0_NominalWithGrant_Optional(_buffer, _size, _lidx, &p->p0_NominalWithGrant);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_setup) {
		_serNrSysEncSQN_NR_PUSCH_ConfigCommon(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pusch_ConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pusch_ConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUCCH_ConfigCommon_pucch_ResourceCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUCCH_ConfigCommon_pucch_ResourceCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PUCCH_ConfigCommon_hoppingId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PUCCH_ConfigCommon_hoppingId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt16_t_SQN_NR_PUCCH_ConfigCommon_p0_nominal_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_NR_PUCCH_ConfigCommon_p0_nominal_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_PUCCH_ConfigCommon_pucch_ResourceCommon_Optional(_buffer, _size, _lidx, &p->pucch_ResourceCommon);
	{
		size_t _tmp = (size_t)p->pucch_GroupHopping;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint16_t_SQN_NR_PUCCH_ConfigCommon_hoppingId_Optional(_buffer, _size, _lidx, &p->hoppingId);
	_serNrSysEncInt16_t_SQN_NR_PUCCH_ConfigCommon_p0_nominal_Optional(_buffer, _size, _lidx, &p->p0_nominal);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_setup) {
		_serNrSysEncSQN_NR_PUCCH_ConfigCommon(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pucch_ConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pucch_ConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_setup) {
		_serNrSysEncSQN_NR_RACH_ConfigCommon(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_SQN_NR_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_SQN_NR_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PRACH_ConfigurationIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PRACH_ConfigurationIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_msgA_RO_FDM_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_msgA_RO_FDM_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FrequencyStart_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FrequencyStart_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_ZeroCorrelationZoneConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_ZeroCorrelationZoneConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_msgA_PreamblePowerRampingStep_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_msgA_PreamblePowerRampingStep_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreambleReceivedTargetPower_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreambleReceivedTargetPower_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_msgB_ResponseWindow_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_msgB_ResponseWindow_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_preambleTransMax_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_preambleTransMax_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGenericTwoStepRA_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PRACH_ConfigurationIndex_r16_Optional(_buffer, _size, _lidx, &p->msgA_PRACH_ConfigurationIndex_r16);
	_serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FDM_r16_e_msgA_RO_FDM_r16_Optional(_buffer, _size, _lidx, &p->msgA_RO_FDM_r16);
	_serNrSysEncUint16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_RO_FrequencyStart_r16_Optional(_buffer, _size, _lidx, &p->msgA_RO_FrequencyStart_r16);
	_serNrSysEncUint8_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_ZeroCorrelationZoneConfig_r16_Optional(_buffer, _size, _lidx, &p->msgA_ZeroCorrelationZoneConfig_r16);
	_serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreamblePowerRampingStep_r16_e_msgA_PreamblePowerRampingStep_r16_Optional(_buffer, _size, _lidx, &p->msgA_PreamblePowerRampingStep_r16);
	_serNrSysEncInt16_t_SQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgA_PreambleReceivedTargetPower_r16_Optional(_buffer, _size, _lidx, &p->msgA_PreambleReceivedTargetPower_r16);
	_serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_msgB_ResponseWindow_r16_e_msgB_ResponseWindow_r16_Optional(_buffer, _size, _lidx, &p->msgB_ResponseWindow_r16);
	_serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16_preambleTransMax_r16_e_preambleTransMax_r16_Optional(_buffer, _size, _lidx, &p->preambleTransMax_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TotalNumberOfRA_Preambles_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TotalNumberOfRA_Preambles_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Value* p, enum SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneEighth) {
		{
			size_t _tmp = (size_t)p->oneEighth;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneFourth) {
		{
			size_t _tmp = (size_t)p->oneFourth;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_oneHalf) {
		{
			size_t _tmp = (size_t)p->oneHalf;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_one) {
		{
			size_t _tmp = (size_t)p->one;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_two) {
		{
			size_t _tmp = (size_t)p->two;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_four) {
		HTON_8(&_buffer[*_lidx], p->four, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_eight) {
		HTON_8(&_buffer[*_lidx], p->eight, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_sixteen) {
		HTON_8(&_buffer[*_lidx], p->sixteen, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_CB_PreamblesPerSSB_PerSharedRO_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_CB_PreamblesPerSSB_PerSharedRO_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_SharedRO_MaskIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_SharedRO_MaskIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_GroupB_ConfiguredTwoStepRA_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_GroupB_ConfiguredTwoStepRA_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->ra_MsgA_SizeGroupA;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->messagePowerOffsetGroupB;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->numberofRA_PreamblesGroupA, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_GroupB_ConfiguredTwoStepRA_r16_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_groupB_ConfiguredTwoStepRA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_GroupB_ConfiguredTwoStepRA_r16_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_groupB_ConfiguredTwoStepRA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_GroupB_ConfiguredTwoStepRA_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Value* p, enum SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l839) {
		HTON_16(&_buffer[*_lidx], p->l839, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l139) {
		HTON_8(&_buffer[*_lidx], p->l139, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l571) {
		HTON_16(&_buffer[*_lidx], p->l571, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_l1151) {
		HTON_16(&_buffer[*_lidx], p->l1151, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_msgA_PRACH_RootSequenceIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_msgA_PRACH_RootSequenceIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_Threshold_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_Threshold_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_ThresholdSSB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_ThresholdSSB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SubcarrierSpacing_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SubcarrierSpacing_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_msgA_RestrictedSetConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_msgA_RestrictedSetConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RA_Prioritization(_buffer, _size, _lidx, &p->ra_Prioritization_r16);
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->ra_PrioritizationForAI_r16[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_ra_ContentionResolutionTimer_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_ra_ContentionResolutionTimer_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigCommonTwoStepRA_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16(_buffer, _size, _lidx, &p->rach_ConfigGenericTwoStepRA_r16);
	_serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TotalNumberOfRA_Preambles_r16_Optional(_buffer, _size, _lidx, &p->msgA_TotalNumberOfRA_Preambles_r16);
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16_Optional(_buffer, _size, _lidx, &p->msgA_SSB_PerRACH_OccasionAndCB_PreamblesPerSSB_r16);
	_serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_CB_PreamblesPerSSB_PerSharedRO_r16_Optional(_buffer, _size, _lidx, &p->msgA_CB_PreamblesPerSSB_PerSharedRO_r16);
	_serNrSysEncUint8_t_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SSB_SharedRO_MaskIndex_r16_Optional(_buffer, _size, _lidx, &p->msgA_SSB_SharedRO_MaskIndex_r16);
	_serNrSysEncSQN_NR_GroupB_ConfiguredTwoStepRA_r16_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_groupB_ConfiguredTwoStepRA_r16_Optional(_buffer, _size, _lidx, &p->groupB_ConfiguredTwoStepRA_r16);
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_PRACH_RootSequenceIndex_r16_msgA_PRACH_RootSequenceIndex_r16_Optional(_buffer, _size, _lidx, &p->msgA_PRACH_RootSequenceIndex_r16);
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(_buffer, _size, _lidx, &p->msgA_TransMax_r16);
	_serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_Threshold_r16_Optional(_buffer, _size, _lidx, &p->msgA_RSRP_Threshold_r16);
	_serNrSysEncSQN_NR_RSRP_Range_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RSRP_ThresholdSSB_r16_Optional(_buffer, _size, _lidx, &p->msgA_RSRP_ThresholdSSB_r16);
	_serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_SubcarrierSpacing_r16_Optional(_buffer, _size, _lidx, &p->msgA_SubcarrierSpacing_r16);
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_msgA_RestrictedSetConfig_r16_e_msgA_RestrictedSetConfig_r16_Optional(_buffer, _size, _lidx, &p->msgA_RestrictedSetConfig_r16);
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_ra_PrioritizationForAccessIdentityTwoStep_r16_Optional(_buffer, _size, _lidx, &p->ra_PrioritizationForAccessIdentityTwoStep_r16);
	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16_ra_ContentionResolutionTimer_r16_e_ra_ContentionResolutionTimer_r16_Optional(_buffer, _size, _lidx, &p->ra_ContentionResolutionTimer_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_PUSCH_TimeDomainAllocation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_PUSCH_TimeDomainAllocation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_startSymbolAndLengthMsgA_PO_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_startSymbolAndLengthMsgA_PO_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_mappingTypeMsgA_PUSCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_mappingTypeMsgA_PUSCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_guardPeriodMsgA_PUSCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_guardPeriodMsgA_PUSCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_msgA_IntraSlotFrequencyHopping_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_msgA_IntraSlotFrequencyHopping_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB2_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_HoppingBits_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B2_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_HoppingBits_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_msgA_DMRS_AdditionalPosition_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_msgA_DMRS_AdditionalPosition_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_msgA_MaxLength_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_msgA_MaxLength_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_DMRS_CDM_Group_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_DMRS_CDM_Group_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_NrofPorts_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_NrofPorts_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID0_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID0_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_DMRS_Config_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_DMRS_Config_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MsgA_DMRS_Config_r16_msgA_DMRS_AdditionalPosition_r16_e_msgA_DMRS_AdditionalPosition_r16_Optional(_buffer, _size, _lidx, &p->msgA_DMRS_AdditionalPosition_r16);
	_serNrSysEncSQN_NR_MsgA_DMRS_Config_r16_msgA_MaxLength_r16_e_msgA_MaxLength_r16_Optional(_buffer, _size, _lidx, &p->msgA_MaxLength_r16);
	_serNrSysEncUint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_DMRS_CDM_Group_r16_Optional(_buffer, _size, _lidx, &p->msgA_PUSCH_DMRS_CDM_Group_r16);
	_serNrSysEncUint8_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_PUSCH_NrofPorts_r16_Optional(_buffer, _size, _lidx, &p->msgA_PUSCH_NrofPorts_r16);
	_serNrSysEncUint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID0_r16_Optional(_buffer, _size, _lidx, &p->msgA_ScramblingID0_r16);
	_serNrSysEncUint16_t_SQN_NR_MsgA_DMRS_Config_r16_msgA_ScramblingID1_r16_Optional(_buffer, _size, _lidx, &p->msgA_ScramblingID1_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_msgA_Alpha_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_msgA_Alpha_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_interlaceIndexFirstPO_MsgA_PUSCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_interlaceIndexFirstPO_MsgA_PUSCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_nrofInterlacesPerMsgA_PO_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_nrofInterlacesPerMsgA_PO_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Resource_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->msgA_MCS_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofSlotsMsgA_PUSCH_r16, _lidx);
	{
		size_t _tmp = (size_t)p->nrofMsgA_PO_PerSlot_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->msgA_PUSCH_TimeDomainOffset_r16, _lidx);
	_serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_PUSCH_TimeDomainAllocation_r16_Optional(_buffer, _size, _lidx, &p->msgA_PUSCH_TimeDomainAllocation_r16);
	_serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_startSymbolAndLengthMsgA_PO_r16_Optional(_buffer, _size, _lidx, &p->startSymbolAndLengthMsgA_PO_r16);
	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_mappingTypeMsgA_PUSCH_r16_e_mappingTypeMsgA_PUSCH_r16_Optional(_buffer, _size, _lidx, &p->mappingTypeMsgA_PUSCH_r16);
	_serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_guardPeriodMsgA_PUSCH_r16_Optional(_buffer, _size, _lidx, &p->guardPeriodMsgA_PUSCH_r16);
	HTON_8(&_buffer[*_lidx], p->guardBandMsgA_PUSCH_r16, _lidx);
	HTON_16(&_buffer[*_lidx], p->frequencyStartMsgA_PUSCH_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofPRBs_PerMsgA_PO_r16, _lidx);
	{
		size_t _tmp = (size_t)p->nrofMsgA_PO_FDM_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_msgA_IntraSlotFrequencyHopping_r16_e_msgA_IntraSlotFrequencyHopping_r16_Optional(_buffer, _size, _lidx, &p->msgA_IntraSlotFrequencyHopping_r16);
	_serNrSysEncB2_SQN_NR_MsgA_PUSCH_Resource_r16_msgA_HoppingBits_r16_Optional(_buffer, _size, _lidx, &p->msgA_HoppingBits_r16);
	_serNrSysEncSQN_NR_MsgA_DMRS_Config_r16(_buffer, _size, _lidx, &p->msgA_DMRS_Config_r16);
	HTON_8(&_buffer[*_lidx], p->nrofDMRS_Sequences_r16, _lidx);
	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_msgA_Alpha_r16_e_msgA_Alpha_r16_Optional(_buffer, _size, _lidx, &p->msgA_Alpha_r16);
	_serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_interlaceIndexFirstPO_MsgA_PUSCH_r16_Optional(_buffer, _size, _lidx, &p->interlaceIndexFirstPO_MsgA_PUSCH_r16);
	_serNrSysEncUint8_t_SQN_NR_MsgA_PUSCH_Resource_r16_nrofInterlacesPerMsgA_PO_r16_Optional(_buffer, _size, _lidx, &p->nrofInterlacesPerMsgA_PO_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_msgA_TransformPrecoder_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_msgA_TransformPrecoder_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DataScramblingIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DataScramblingIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DeltaPreamble_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DeltaPreamble_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Config_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Config_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupA_r16_Optional(_buffer, _size, _lidx, &p->msgA_PUSCH_ResourceGroupA_r16);
	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16_SQN_NR_MsgA_PUSCH_Config_r16_msgA_PUSCH_ResourceGroupB_r16_Optional(_buffer, _size, _lidx, &p->msgA_PUSCH_ResourceGroupB_r16);
	_serNrSysEncSQN_NR_MsgA_PUSCH_Config_r16_msgA_TransformPrecoder_r16_e_msgA_TransformPrecoder_r16_Optional(_buffer, _size, _lidx, &p->msgA_TransformPrecoder_r16);
	_serNrSysEncUint16_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DataScramblingIndex_r16_Optional(_buffer, _size, _lidx, &p->msgA_DataScramblingIndex_r16);
	_serNrSysEncInt8_t_SQN_NR_MsgA_PUSCH_Config_r16_msgA_DeltaPreamble_r16_Optional(_buffer, _size, _lidx, &p->msgA_DeltaPreamble_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_PUSCH_Config_r16_SQN_NR_MsgA_ConfigCommon_r16_msgA_PUSCH_Config_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_PUSCH_Config_r16_SQN_NR_MsgA_ConfigCommon_r16_msgA_PUSCH_Config_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_MsgA_PUSCH_Config_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MsgA_ConfigCommon_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MsgA_ConfigCommon_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RACH_ConfigCommonTwoStepRA_r16(_buffer, _size, _lidx, &p->rach_ConfigCommonTwoStepRA_r16);
	_serNrSysEncSQN_NR_MsgA_PUSCH_Config_r16_SQN_NR_MsgA_ConfigCommon_r16_msgA_PUSCH_Config_r16_Optional(_buffer, _size, _lidx, &p->msgA_PUSCH_Config_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_setup) {
		_serNrSysEncSQN_NR_MsgA_ConfigCommon_r16(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_SQN_NR_BWP_UplinkCommon_msgA_ConfigCommon_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_SQN_NR_BWP_UplinkCommon_msgA_ConfigCommon_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_UplinkCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_UplinkCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BWP(_buffer, _size, _lidx, &p->genericParameters);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommon_SQN_NR_BWP_UplinkCommon_rach_ConfigCommon_Optional(_buffer, _size, _lidx, &p->rach_ConfigCommon);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pusch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pusch_ConfigCommon_Optional(_buffer, _size, _lidx, &p->pusch_ConfigCommon);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_pucch_ConfigCommon_SQN_NR_BWP_UplinkCommon_pucch_ConfigCommon_Optional(_buffer, _size, _lidx, &p->pucch_ConfigCommon);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_SQN_NR_BWP_UplinkCommon_rach_ConfigCommonIAB_r16_Optional(_buffer, _size, _lidx, &p->rach_ConfigCommonIAB_r16);
	_serNrSysEncSQN_NR_BWP_UplinkCommon_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(_buffer, _size, _lidx, &p->useInterlacePUCCH_PUSCH_r16);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkCommon_msgA_ConfigCommon_r16_SQN_NR_BWP_UplinkCommon_msgA_ConfigCommon_r16_Optional(_buffer, _size, _lidx, &p->msgA_ConfigCommon_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_BWP_UplinkCommon_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_BWP_UplinkCommon_Type_Value* p, enum NR_ASN1_BWP_UplinkCommon_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_BWP_UplinkCommon_Type_R15) {
		_serNrSysEncSQN_NR_BWP_UplinkCommon(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_BWP_UplinkCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_BWP_UplinkCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_BWP_UplinkCommon_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_BWP_UplinkCommon_Type_Common_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_BWP_UplinkCommon_Type_Common_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_BWP_UplinkCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PUCCH_ResourceSet_maxPayloadSize_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PUCCH_ResourceSet_maxPayloadSize_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pucch_ResourceSetId, _lidx);
	HTON_32(&_buffer[*_lidx], p->resourceList.d, _lidx);
	for (size_t i3 = 0; i3 < p->resourceList.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->resourceList.v[i3], _lidx);
	}
	_serNrSysEncUint16_t_SQN_NR_PUCCH_ResourceSet_maxPayloadSize_Optional(_buffer, _size, _lidx, &p->maxPayloadSize);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceSet_SQN_NR_PUCCH_Config_resourceSetToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceSet_SQN_NR_PUCCH_Config_resourceSetToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_ResourceSet(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceSetId_SQN_NR_PUCCH_Config_resourceSetToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceSetId_SQN_NR_PUCCH_Config_resourceSetToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_intraSlotFrequencyHopping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_intraSlotFrequencyHopping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PRB_Id_SQN_NR_PUCCH_Resource_secondHopPRB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PRB_Id_SQN_NR_PUCCH_Resource_secondHopPRB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_format0(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_format0* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->initialCyclicShift, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofSymbols, _lidx);
	HTON_8(&_buffer[*_lidx], p->startingSymbolIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_format1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_format1* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->initialCyclicShift, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofSymbols, _lidx);
	HTON_8(&_buffer[*_lidx], p->startingSymbolIndex, _lidx);
	HTON_8(&_buffer[*_lidx], p->timeDomainOCC, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_format2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_format2* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->nrofPRBs, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofSymbols, _lidx);
	HTON_8(&_buffer[*_lidx], p->startingSymbolIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_format3(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_format3* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->nrofPRBs, _lidx);
	HTON_8(&_buffer[*_lidx], p->nrofSymbols, _lidx);
	HTON_8(&_buffer[*_lidx], p->startingSymbolIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_format4(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_format4* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->nrofSymbols, _lidx);
	{
		size_t _tmp = (size_t)p->occ_Length;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->occ_Index;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->startingSymbolIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Resource_format_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUCCH_Resource_format_Value* p, enum SQN_NR_PUCCH_Resource_format_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUCCH_Resource_format_format0) {
		_serNrSysEncSQN_NR_PUCCH_format0(_buffer, _size, _lidx, &p->format0);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format1) {
		_serNrSysEncSQN_NR_PUCCH_format1(_buffer, _size, _lidx, &p->format1);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format2) {
		_serNrSysEncSQN_NR_PUCCH_format2(_buffer, _size, _lidx, &p->format2);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format3) {
		_serNrSysEncSQN_NR_PUCCH_format3(_buffer, _size, _lidx, &p->format3);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_Resource_format_format4) {
		_serNrSysEncSQN_NR_PUCCH_format4(_buffer, _size, _lidx, &p->format4);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUCCH_Resource_format(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Resource_format* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUCCH_Resource_format_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Resource(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Resource* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pucch_ResourceId, _lidx);
	HTON_16(&_buffer[*_lidx], p->startingPRB, _lidx);
	_serNrSysEncSQN_NR_PUCCH_Resource_intraSlotFrequencyHopping_e_intraSlotFrequencyHopping_Optional(_buffer, _size, _lidx, &p->intraSlotFrequencyHopping);
	_serNrSysEncSQN_NR_PRB_Id_SQN_NR_PUCCH_Resource_secondHopPRB_Optional(_buffer, _size, _lidx, &p->secondHopPRB);
	_serNrSysEncSQN_NR_PUCCH_Resource_format(_buffer, _size, _lidx, &p->format);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Resource_SQN_NR_PUCCH_Config_resourceToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Resource_SQN_NR_PUCCH_Config_resourceToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_Resource(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_resourceToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_resourceToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_interslotFrequencyHopping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_interslotFrequencyHopping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_FormatConfig_additionalDMRS_e_additionalDMRS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_FormatConfig_additionalDMRS_e_additionalDMRS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_MaxCodeRate_e_SQN_NR_PUCCH_FormatConfig_maxCodeRate_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_MaxCodeRate_e_SQN_NR_PUCCH_FormatConfig_maxCodeRate_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_FormatConfig_nrofSlots_e_nrofSlots_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_FormatConfig_nrofSlots_e_nrofSlots_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_FormatConfig_pi2BPSK_e_pi2BPSK_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_FormatConfig_pi2BPSK_e_pi2BPSK_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_simultaneousHARQ_ACK_CSI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_simultaneousHARQ_ACK_CSI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_FormatConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_FormatConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUCCH_FormatConfig_interslotFrequencyHopping_e_interslotFrequencyHopping_Optional(_buffer, _size, _lidx, &p->interslotFrequencyHopping);
	_serNrSysEncSQN_NR_PUCCH_FormatConfig_additionalDMRS_e_additionalDMRS_Optional(_buffer, _size, _lidx, &p->additionalDMRS);
	_serNrSysEncSQN_NR_PUCCH_MaxCodeRate_e_SQN_NR_PUCCH_FormatConfig_maxCodeRate_Optional(_buffer, _size, _lidx, &p->maxCodeRate);
	_serNrSysEncSQN_NR_PUCCH_FormatConfig_nrofSlots_e_nrofSlots_Optional(_buffer, _size, _lidx, &p->nrofSlots);
	_serNrSysEncSQN_NR_PUCCH_FormatConfig_pi2BPSK_e_pi2BPSK_Optional(_buffer, _size, _lidx, &p->pi2BPSK);
	_serNrSysEncSQN_NR_PUCCH_FormatConfig_simultaneousHARQ_ACK_CSI_e_simultaneousHARQ_ACK_CSI_Optional(_buffer, _size, _lidx, &p->simultaneousHARQ_ACK_CSI);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format1_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_format1_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format1_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_format1_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format1_setup) {
		_serNrSysEncSQN_NR_PUCCH_FormatConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format1* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format1_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format1_SQN_NR_PUCCH_Config_format1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format1_SQN_NR_PUCCH_Config_format1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format1(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format2_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_format2_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format2_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_format2_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format2_setup) {
		_serNrSysEncSQN_NR_PUCCH_FormatConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format2* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format2_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format2_SQN_NR_PUCCH_Config_format2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format2_SQN_NR_PUCCH_Config_format2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format2(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format3_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_format3_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format3_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_format3_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format3_setup) {
		_serNrSysEncSQN_NR_PUCCH_FormatConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format3(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format3* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format3_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format3_SQN_NR_PUCCH_Config_format3_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format3_SQN_NR_PUCCH_Config_format3_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format3(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format4_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_format4_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_format4_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_format4_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_format4_setup) {
		_serNrSysEncSQN_NR_PUCCH_FormatConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format4(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format4* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format4_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format4_SQN_NR_PUCCH_Config_format4_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_format4_SQN_NR_PUCCH_Config_format4_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format4(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Value* p, enum SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sym2) {
		HTON_8(&_buffer[*_lidx], p->sym2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sym6or7) {
		HTON_8(&_buffer[*_lidx], p->sym6or7, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl1) {
		HTON_8(&_buffer[*_lidx], p->sl1, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl2) {
		HTON_8(&_buffer[*_lidx], p->sl2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl4) {
		HTON_8(&_buffer[*_lidx], p->sl4, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl5) {
		HTON_8(&_buffer[*_lidx], p->sl5, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl8) {
		HTON_8(&_buffer[*_lidx], p->sl8, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl10) {
		HTON_8(&_buffer[*_lidx], p->sl10, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl16) {
		HTON_8(&_buffer[*_lidx], p->sl16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl20) {
		HTON_8(&_buffer[*_lidx], p->sl20, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl40) {
		HTON_8(&_buffer[*_lidx], p->sl40, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl80) {
		HTON_8(&_buffer[*_lidx], p->sl80, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl160) {
		HTON_8(&_buffer[*_lidx], p->sl160, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl320) {
		HTON_16(&_buffer[*_lidx], p->sl320, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_sl640) {
		HTON_16(&_buffer[*_lidx], p->sl640, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_periodicityAndOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_periodicityAndOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_SchedulingRequestResourceConfig_resource_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_SchedulingRequestResourceConfig_resource_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->schedulingRequestResourceId, _lidx);
	HTON_8(&_buffer[*_lidx], p->schedulingRequestID, _lidx);
	_serNrSysEncSQN_NR_SchedulingRequestResourceConfig_periodicityAndOffset_periodicityAndOffset_Optional(_buffer, _size, _lidx, &p->periodicityAndOffset);
	_serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_SchedulingRequestResourceConfig_resource_Optional(_buffer, _size, _lidx, &p->resource);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceConfig_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SchedulingRequestResourceConfig(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceId_SQN_NR_PUCCH_Config_schedulingRequestResourceToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceId_SQN_NR_PUCCH_Config_schedulingRequestResourceToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_multi_CSI_PUCCH_ResourceList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_multi_CSI_PUCCH_ResourceList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServCellIndex_SQN_NR_PUCCH_SpatialRelationInfo_servingCellId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServCellIndex_SQN_NR_PUCCH_SpatialRelationInfo_servingCellId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SRS(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SRS* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->resource, _lidx);
	HTON_8(&_buffer[*_lidx], p->uplinkBWP, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Value* p, enum SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_ssb_Index) {
		HTON_8(&_buffer[*_lidx], p->ssb_Index, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_csi_RS_Index) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_Index, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_srs) {
		_serNrSysEncSQN_NR_PUCCH_SRS(_buffer, _size, _lidx, &p->srs);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_referenceSignal(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfo_referenceSignal* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_referenceSignal_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pucch_SpatialRelationInfoId, _lidx);
	_serNrSysEncSQN_NR_ServCellIndex_SQN_NR_PUCCH_SpatialRelationInfo_servingCellId_Optional(_buffer, _size, _lidx, &p->servingCellId);
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_referenceSignal(_buffer, _size, _lidx, &p->referenceSignal);
	HTON_8(&_buffer[*_lidx], p->pucch_PathlossReferenceRS_Id, _lidx);
	HTON_8(&_buffer[*_lidx], p->p0_PUCCH_Id, _lidx);
	{
		size_t _tmp = (size_t)p->closedLoopIndex;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f3_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f3_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f4_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f4_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P0_PUCCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P0_PUCCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->p0_PUCCH_Id, _lidx);
	HTON_8(&_buffer[*_lidx], p->p0_PUCCH_Value, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P0_PUCCH_SQN_NR_PUCCH_PowerControl_p0_Set_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P0_PUCCH_SQN_NR_PUCCH_PowerControl_p0_Set_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_P0_PUCCH(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Value* p, enum SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_ssb_Index) {
		HTON_8(&_buffer[*_lidx], p->ssb_Index, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_csi_RS_Index) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_Index, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_referenceSignal(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PathlossReferenceRS_referenceSignal* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_referenceSignal_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PathlossReferenceRS* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pucch_PathlossReferenceRS_Id, _lidx);
	_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_referenceSignal(_buffer, _size, _lidx, &p->referenceSignal);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PathlossReferenceRS_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoPUCCH_PC_AdjustmentStates_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoPUCCH_PC_AdjustmentStates_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Value* p, enum SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_ssb_Index_r16) {
		HTON_8(&_buffer[*_lidx], p->ssb_Index_r16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_csi_RS_Index_r16) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_Index_r16, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PathlossReferenceRS_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pucch_PathlossReferenceRS_Id_r16, _lidx);
	_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_r16_referenceSignal_r16(_buffer, _size, _lidx, &p->referenceSignal_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Value* p, enum SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PowerControl(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PowerControl* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f0_Optional(_buffer, _size, _lidx, &p->deltaF_PUCCH_f0);
	_serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f1_Optional(_buffer, _size, _lidx, &p->deltaF_PUCCH_f1);
	_serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f2_Optional(_buffer, _size, _lidx, &p->deltaF_PUCCH_f2);
	_serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f3_Optional(_buffer, _size, _lidx, &p->deltaF_PUCCH_f3);
	_serNrSysEncInt8_t_SQN_NR_PUCCH_PowerControl_deltaF_PUCCH_f4_Optional(_buffer, _size, _lidx, &p->deltaF_PUCCH_f4);
	_serNrSysEncSQN_NR_P0_PUCCH_SQN_NR_PUCCH_PowerControl_p0_Set_DynamicOptional(_buffer, _size, _lidx, &p->p0_Set);
	_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_DynamicOptional(_buffer, _size, _lidx, &p->pathlossReferenceRSs);
	_serNrSysEncSQN_NR_PUCCH_PowerControl_twoPUCCH_PC_AdjustmentStates_e_twoPUCCH_PC_AdjustmentStates_Optional(_buffer, _size, _lidx, &p->twoPUCCH_PC_AdjustmentStates);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_PowerControl_pathlossReferenceRSs_v1610_SQN_NR_PUCCH_PowerControl_pathlossReferenceRSs_v1610_Optional(_buffer, _size, _lidx, &p->pathlossReferenceRSs_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PowerControl_SQN_NR_PUCCH_Config_pucch_PowerControl_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PowerControl_SQN_NR_PUCCH_Config_pucch_PowerControl_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PUCCH_PowerControl(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Value* p, enum SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_scs15) {
		HTON_8(&_buffer[*_lidx], p->scs15, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_scs30) {
		HTON_8(&_buffer[*_lidx], p->scs30, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->rb_SetIndex, _lidx);
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlace0(_buffer, _size, _lidx, &p->interlace0);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlaceAllocation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlaceAllocation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_occ_Length_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_occ_Length_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_occ_Index_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_occ_Index_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Length_v1610_e_occ_Length_v1610_Optional(_buffer, _size, _lidx, &p->occ_Length_v1610);
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610_occ_Index_v1610_e_occ_Index_v1610_Optional(_buffer, _size, _lidx, &p->occ_Index_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Value* p, enum SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_interlace1_v1610) {
		HTON_8(&_buffer[*_lidx], p->interlace1_v1610, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610) {
		_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_occ_v1610(_buffer, _size, _lidx, &p->occ_v1610);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_formatExt_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_formatExt_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_interlaceAllocation_r16_interlaceAllocation_r16_Optional(_buffer, _size, _lidx, &p->interlaceAllocation_r16);
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_formatExt_v1610_formatExt_v1610_Optional(_buffer, _size, _lidx, &p->formatExt_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_SQN_NR_PUCCH_Config_resourceToAddModListExt_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceExt_r16_SQN_NR_PUCCH_Config_resourceToAddModListExt_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_SQN_NR_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_SQN_NR_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Value* p, enum SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_normalCP_r16) {
		{
			size_t _tmp = (size_t)p->normalCP_r16;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_extendedCP_r16) {
		{
			size_t _tmp = (size_t)p->extendedCP_r16;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_subslotLengthForPUCCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_subslotLengthForPUCCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUCCH_Config_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUCCH_Config_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_dmrs_UplinkTransformPrecodingPUCCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_dmrs_UplinkTransformPrecodingPUCCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_SpatialRelationInfoId_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_SpatialRelationInfoId_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_PathlossReferenceRS_Id_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_PathlossReferenceRS_Id_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoExt_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfoExt_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_SpatialRelationInfoId_v1610_Optional(_buffer, _size, _lidx, &p->pucch_SpatialRelationInfoId_v1610);
	_serNrSysEncSQN_NR_PUCCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUCCH_SpatialRelationInfoExt_r16_pucch_PathlossReferenceRS_Id_v1610_Optional(_buffer, _size, _lidx, &p->pucch_PathlossReferenceRS_Id_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoExt_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModListExt_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfoExt_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModListExt_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoExt_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_SpatialRelationInfoId_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceGroup_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceGroup_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pucch_ResourceGroupId_r16, _lidx);
	HTON_32(&_buffer[*_lidx], p->resourcePerGroupList_r16.d, _lidx);
	for (size_t i3 = 0; i3 < p->resourcePerGroupList_r16.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->resourcePerGroupList_r16.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceGroup_r16_SQN_NR_PUCCH_Config_resourceGroupToAddModList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceGroup_r16_SQN_NR_PUCCH_Config_resourceGroupToAddModList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUCCH_ResourceGroup_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_ResourceGroupId_r16_SQN_NR_PUCCH_Config_resourceGroupToReleaseList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_ResourceGroupId_r16_SQN_NR_PUCCH_Config_resourceGroupToReleaseList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_SPS_PUCCH_AN_r16_maxPayloadSize_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_SPS_PUCCH_AN_r16_maxPayloadSize_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SPS_PUCCH_AN_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SPS_PUCCH_AN_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->sps_PUCCH_AN_ResourceID_r16, _lidx);
	_serNrSysEncUint16_t_SQN_NR_SPS_PUCCH_AN_r16_maxPayloadSize_r16_Optional(_buffer, _size, _lidx, &p->maxPayloadSize_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Value* p, enum SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_SPS_PUCCH_AN_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_SQN_NR_PUCCH_Config_sps_PUCCH_AN_List_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_SQN_NR_PUCCH_Config_sps_PUCCH_AN_List_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceConfig_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SchedulingRequestResourceConfig_v1610_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(_buffer, _size, _lidx, &p->phy_PriorityIndex_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingRequestResourceConfig_v1610_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_v1610_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingRequestResourceConfig_v1610_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_v1610_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SchedulingRequestResourceConfig_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUCCH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUCCH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUCCH_ResourceSet_SQN_NR_PUCCH_Config_resourceSetToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->resourceSetToAddModList);
	_serNrSysEncSQN_NR_PUCCH_ResourceSetId_SQN_NR_PUCCH_Config_resourceSetToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->resourceSetToReleaseList);
	_serNrSysEncSQN_NR_PUCCH_Resource_SQN_NR_PUCCH_Config_resourceToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->resourceToAddModList);
	_serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_resourceToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->resourceToReleaseList);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format1_SQN_NR_PUCCH_Config_format1_Optional(_buffer, _size, _lidx, &p->format1);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format2_SQN_NR_PUCCH_Config_format2_Optional(_buffer, _size, _lidx, &p->format2);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format3_SQN_NR_PUCCH_Config_format3_Optional(_buffer, _size, _lidx, &p->format3);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_format4_SQN_NR_PUCCH_Config_format4_Optional(_buffer, _size, _lidx, &p->format4);
	_serNrSysEncSQN_NR_SchedulingRequestResourceConfig_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->schedulingRequestResourceToAddModList);
	_serNrSysEncSQN_NR_SchedulingRequestResourceId_SQN_NR_PUCCH_Config_schedulingRequestResourceToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->schedulingRequestResourceToReleaseList);
	_serNrSysEncSQN_NR_PUCCH_ResourceId_SQN_NR_PUCCH_Config_multi_CSI_PUCCH_ResourceList_DynamicOptional(_buffer, _size, _lidx, &p->multi_CSI_PUCCH_ResourceList);
	_serNrSysEncUint8_t_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DynamicOptional(_buffer, _size, _lidx, &p->dl_DataToUL_ACK);
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->spatialRelationInfoToAddModList);
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->spatialRelationInfoToReleaseList);
	_serNrSysEncSQN_NR_PUCCH_PowerControl_SQN_NR_PUCCH_Config_pucch_PowerControl_Optional(_buffer, _size, _lidx, &p->pucch_PowerControl);
	_serNrSysEncSQN_NR_PUCCH_ResourceExt_r16_SQN_NR_PUCCH_Config_resourceToAddModListExt_r16_DynamicOptional(_buffer, _size, _lidx, &p->resourceToAddModListExt_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_r16_Optional(_buffer, _size, _lidx, &p->dl_DataToUL_ACK_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_SQN_NR_PUCCH_Config_ul_AccessConfigListDCI_1_1_r16_Optional(_buffer, _size, _lidx, &p->ul_AccessConfigListDCI_1_1_r16);
	_serNrSysEncSQN_NR_PUCCH_Config_subslotLengthForPUCCH_r16_subslotLengthForPUCCH_r16_Optional(_buffer, _size, _lidx, &p->subslotLengthForPUCCH_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_SQN_NR_PUCCH_Config_dl_DataToUL_ACK_DCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->dl_DataToUL_ACK_DCI_1_2_r16);
	_serNrSysEncUint8_t_SQN_NR_PUCCH_Config_numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->numberOfBitsForPUCCH_ResourceIndicatorDCI_1_2_r16);
	_serNrSysEncSQN_NR_PUCCH_Config_dmrs_UplinkTransformPrecodingPUCCH_r16_e_dmrs_UplinkTransformPrecodingPUCCH_r16_Optional(_buffer, _size, _lidx, &p->dmrs_UplinkTransformPrecodingPUCCH_r16);
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfo_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModList2_r16_DynamicOptional(_buffer, _size, _lidx, &p->spatialRelationInfoToAddModList2_r16);
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList2_r16_DynamicOptional(_buffer, _size, _lidx, &p->spatialRelationInfoToReleaseList2_r16);
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoExt_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToAddModListExt_r16_DynamicOptional(_buffer, _size, _lidx, &p->spatialRelationInfoToAddModListExt_r16);
	_serNrSysEncSQN_NR_PUCCH_SpatialRelationInfoId_r16_SQN_NR_PUCCH_Config_spatialRelationInfoToReleaseList_r16_DynamicOptional(_buffer, _size, _lidx, &p->spatialRelationInfoToReleaseList_r16);
	_serNrSysEncSQN_NR_PUCCH_ResourceGroup_r16_SQN_NR_PUCCH_Config_resourceGroupToAddModList_r16_DynamicOptional(_buffer, _size, _lidx, &p->resourceGroupToAddModList_r16);
	_serNrSysEncSQN_NR_PUCCH_ResourceGroupId_r16_SQN_NR_PUCCH_Config_resourceGroupToReleaseList_r16_DynamicOptional(_buffer, _size, _lidx, &p->resourceGroupToReleaseList_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUCCH_Config_sps_PUCCH_AN_List_r16_SQN_NR_PUCCH_Config_sps_PUCCH_AN_List_r16_Optional(_buffer, _size, _lidx, &p->sps_PUCCH_AN_List_r16);
	_serNrSysEncSQN_NR_SchedulingRequestResourceConfig_v1610_SQN_NR_PUCCH_Config_schedulingRequestResourceToAddModList_v1610_DynamicOptional(_buffer, _size, _lidx, &p->schedulingRequestResourceToAddModList_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_setup) {
		_serNrSysEncSQN_NR_PUCCH_Config(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_SQN_NR_BWP_UplinkDedicated_pucch_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_SQN_NR_BWP_UplinkDedicated_pucch_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PUSCH_Config_dataScramblingIdentityPUSCH_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PUSCH_Config_dataScramblingIdentityPUSCH_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_txConfig_e_txConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_txConfig_e_txConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_dmrs_Type_e_dmrs_Type_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_dmrs_Type_e_dmrs_Type_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_frequencyDensity_ArrayOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_frequencyDensity_ArrayOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_16(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_timeDensity_ArrayOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_timeDensity_ArrayOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 3; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_resourceElementOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_resourceElementOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_frequencyDensity_ArrayOptional(_buffer, _size, _lidx, &p->frequencyDensity);
	_serNrSysEncUint8_t_SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_timeDensity_ArrayOptional(_buffer, _size, _lidx, &p->timeDensity);
	{
		size_t _tmp = (size_t)p->maxNrofPorts;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_resourceElementOffset_e_resourceElementOffset_Optional(_buffer, _size, _lidx, &p->resourceElementOffset);
	{
		size_t _tmp = (size_t)p->ptrs_Power;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_transformPrecoderDisabled_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_transformPrecoderDisabled_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_timeDensityTransformPrecoding_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_timeDensityTransformPrecoding_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 5; i2++) {
		HTON_16(&_buffer[*_lidx], p->sampleDensity[i2], _lidx);
	}
	_serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_timeDensityTransformPrecoding_e_timeDensityTransformPrecoding_Optional(_buffer, _size, _lidx, &p->timeDensityTransformPrecoding);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_transformPrecoderEnabled_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_transformPrecoderEnabled_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PTRS_UplinkConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PTRS_UplinkConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderDisabled_transformPrecoderDisabled_Optional(_buffer, _size, _lidx, &p->transformPrecoderDisabled);
	_serNrSysEncSQN_NR_PTRS_UplinkConfig_transformPrecoderEnabled_transformPrecoderEnabled_Optional(_buffer, _size, _lidx, &p->transformPrecoderEnabled);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Value* p, enum SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_setup) {
		_serNrSysEncSQN_NR_PTRS_UplinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_SQN_NR_DMRS_UplinkConfig_phaseTrackingRS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_SQN_NR_DMRS_UplinkConfig_phaseTrackingRS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_maxLength_e_maxLength_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_maxLength_e_maxLength_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_dmrs_Uplink_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_dmrs_Uplink_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID0_Optional(_buffer, _size, _lidx, &p->scramblingID0);
	_serNrSysEncUint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_scramblingID1_Optional(_buffer, _size, _lidx, &p->scramblingID1);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_dmrs_Uplink_r16_e_dmrs_Uplink_r16_Optional(_buffer, _size, _lidx, &p->dmrs_Uplink_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_transformPrecodingDisabled_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_transformPrecodingDisabled_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_nPUSCH_Identity_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_nPUSCH_Identity_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_sequenceGroupHopping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_sequenceGroupHopping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_sequenceHopping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_sequenceHopping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkTransformPrecoding_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkTransformPrecoding_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID0_Optional(_buffer, _size, _lidx, &p->pi2BPSK_ScramblingID0);
	_serNrSysEncUint16_t_SQN_NR_DMRS_UplinkTransformPrecoding_r16_pi2BPSK_ScramblingID1_Optional(_buffer, _size, _lidx, &p->pi2BPSK_ScramblingID1);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Value* p, enum SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_setup) {
		_serNrSysEncSQN_NR_DMRS_UplinkTransformPrecoding_r16(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_nPUSCH_Identity_Optional(_buffer, _size, _lidx, &p->nPUSCH_Identity);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceGroupHopping_e_sequenceGroupHopping_Optional(_buffer, _size, _lidx, &p->sequenceGroupHopping);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_sequenceHopping_e_sequenceHopping_Optional(_buffer, _size, _lidx, &p->sequenceHopping);
	_serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_dmrs_UplinkTransformPrecoding_r16_Optional(_buffer, _size, _lidx, &p->dmrs_UplinkTransformPrecoding_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_transformPrecodingEnabled_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_transformPrecodingEnabled_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DMRS_UplinkConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DMRS_UplinkConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_DMRS_UplinkConfig_dmrs_Type_e_dmrs_Type_Optional(_buffer, _size, _lidx, &p->dmrs_Type);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_dmrs_AdditionalPosition_e_dmrs_AdditionalPosition_Optional(_buffer, _size, _lidx, &p->dmrs_AdditionalPosition);
	_serNrSysEncSQN_NR_SetupRelease_DMRS_UplinkConfig_phaseTrackingRS_SQN_NR_DMRS_UplinkConfig_phaseTrackingRS_Optional(_buffer, _size, _lidx, &p->phaseTrackingRS);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_maxLength_e_maxLength_Optional(_buffer, _size, _lidx, &p->maxLength);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingDisabled_transformPrecodingDisabled_Optional(_buffer, _size, _lidx, &p->transformPrecodingDisabled);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig_transformPrecodingEnabled_transformPrecodingEnabled_Optional(_buffer, _size, _lidx, &p->transformPrecodingEnabled);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_setup) {
		_serNrSysEncSQN_NR_DMRS_UplinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_setup) {
		_serNrSysEncSQN_NR_DMRS_UplinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_tpc_Accumulation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_tpc_Accumulation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Alpha_e_SQN_NR_PUSCH_PowerControl_msg3_Alpha_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Alpha_e_SQN_NR_PUSCH_PowerControl_msg3_Alpha_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt16_t_SQN_NR_PUSCH_PowerControl_p0_NominalWithoutGrant_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_NR_PUSCH_PowerControl_p0_NominalWithoutGrant_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_P0_PUSCH_AlphaSet_p0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_P0_PUSCH_AlphaSet_p0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Alpha_e_SQN_NR_P0_PUSCH_AlphaSet_alpha_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Alpha_e_SQN_NR_P0_PUSCH_AlphaSet_alpha_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P0_PUSCH_AlphaSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P0_PUSCH_AlphaSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->p0_PUSCH_AlphaSetId, _lidx);
	_serNrSysEncInt8_t_SQN_NR_P0_PUSCH_AlphaSet_p0_Optional(_buffer, _size, _lidx, &p->p0);
	_serNrSysEncSQN_NR_Alpha_e_SQN_NR_P0_PUSCH_AlphaSet_alpha_Optional(_buffer, _size, _lidx, &p->alpha);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P0_PUSCH_AlphaSet_SQN_NR_PUSCH_PowerControl_p0_AlphaSets_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P0_PUSCH_AlphaSet_SQN_NR_PUSCH_PowerControl_p0_AlphaSets_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_P0_PUSCH_AlphaSet(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Value* p, enum SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_ssb_Index) {
		HTON_8(&_buffer[*_lidx], p->ssb_Index, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_csi_RS_Index) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_Index, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_referenceSignal(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS_referenceSignal* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_referenceSignal_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pusch_PathlossReferenceRS_Id, _lidx);
	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_referenceSignal(_buffer, _size, _lidx, &p->referenceSignal);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_Id_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS_Id_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoPUSCH_PC_AdjustmentStates_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoPUSCH_PC_AdjustmentStates_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl_deltaMCS_e_deltaMCS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl_deltaMCS_e_deltaMCS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRI_PUSCH_PowerControl(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRI_PUSCH_PowerControl* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->sri_PUSCH_PowerControlId, _lidx);
	HTON_8(&_buffer[*_lidx], p->sri_PUSCH_PathlossReferenceRS_Id, _lidx);
	HTON_8(&_buffer[*_lidx], p->sri_P0_PUSCH_AlphaSetId, _lidx);
	{
		size_t _tmp = (size_t)p->sri_PUSCH_ClosedLoopIndex;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRI_PUSCH_PowerControl_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRI_PUSCH_PowerControl_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SRI_PUSCH_PowerControl(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRI_PUSCH_PowerControlId_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRI_PUSCH_PowerControlId_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUSCH_PowerControl_tpc_Accumulation_e_tpc_Accumulation_Optional(_buffer, _size, _lidx, &p->tpc_Accumulation);
	_serNrSysEncSQN_NR_Alpha_e_SQN_NR_PUSCH_PowerControl_msg3_Alpha_Optional(_buffer, _size, _lidx, &p->msg3_Alpha);
	_serNrSysEncInt16_t_SQN_NR_PUSCH_PowerControl_p0_NominalWithoutGrant_Optional(_buffer, _size, _lidx, &p->p0_NominalWithoutGrant);
	_serNrSysEncSQN_NR_P0_PUSCH_AlphaSet_SQN_NR_PUSCH_PowerControl_p0_AlphaSets_DynamicOptional(_buffer, _size, _lidx, &p->p0_AlphaSets);
	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->pathlossReferenceRSToAddModList);
	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_Id_SQN_NR_PUSCH_PowerControl_pathlossReferenceRSToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->pathlossReferenceRSToReleaseList);
	_serNrSysEncSQN_NR_PUSCH_PowerControl_twoPUSCH_PC_AdjustmentStates_e_twoPUSCH_PC_AdjustmentStates_Optional(_buffer, _size, _lidx, &p->twoPUSCH_PC_AdjustmentStates);
	_serNrSysEncSQN_NR_PUSCH_PowerControl_deltaMCS_e_deltaMCS_Optional(_buffer, _size, _lidx, &p->deltaMCS);
	_serNrSysEncSQN_NR_SRI_PUSCH_PowerControl_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->sri_PUSCH_MappingToAddModList);
	_serNrSysEncSQN_NR_SRI_PUSCH_PowerControlId_SQN_NR_PUSCH_PowerControl_sri_PUSCH_MappingToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->sri_PUSCH_MappingToReleaseList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl_SQN_NR_PUSCH_Config_pusch_PowerControl_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl_SQN_NR_PUSCH_Config_pusch_PowerControl_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PUSCH_PowerControl(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_frequencyHopping_e_frequencyHopping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_frequencyHopping_e_frequencyHopping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_PUSCH_Config_frequencyHoppingOffsetLists_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_PUSCH_Config_frequencyHoppingOffsetLists_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocation(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_pusch_AggregationFactor_e_pusch_AggregationFactor_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_pusch_AggregationFactor_e_pusch_AggregationFactor_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_mcs_Table_e_mcs_Table_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_mcs_Table_e_mcs_Table_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_transformPrecoder_e_transformPrecoder_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_transformPrecoder_e_transformPrecoder_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_codebookSubset_e_codebookSubset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_codebookSubset_e_codebookSubset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Config_maxRank_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Config_maxRank_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_rbg_Size_e_rbg_Size_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_rbg_Size_e_rbg_Size_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index3_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index3_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BetaOffsets(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BetaOffsets* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index1_Optional(_buffer, _size, _lidx, &p->betaOffsetACK_Index1);
	_serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index2_Optional(_buffer, _size, _lidx, &p->betaOffsetACK_Index2);
	_serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetACK_Index3_Optional(_buffer, _size, _lidx, &p->betaOffsetACK_Index3);
	_serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index1_Optional(_buffer, _size, _lidx, &p->betaOffsetCSI_Part1_Index1);
	_serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part1_Index2_Optional(_buffer, _size, _lidx, &p->betaOffsetCSI_Part1_Index2);
	_serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index1_Optional(_buffer, _size, _lidx, &p->betaOffsetCSI_Part2_Index1);
	_serNrSysEncUint8_t_SQN_NR_BetaOffsets_betaOffsetCSI_Part2_Index2_Optional(_buffer, _size, _lidx, &p->betaOffsetCSI_Part2_Index2);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_betaOffsets_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_UCI_OnPUSCH_betaOffsets_Value* p, enum SQN_NR_UCI_OnPUSCH_betaOffsets_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_UCI_OnPUSCH_betaOffsets_dynamic) {
		for (size_t i2 = 0; i2 < 4; i2++) {
			_serNrSysEncSQN_NR_BetaOffsets(_buffer, _size, _lidx, &p->dynamic[i2]);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_UCI_OnPUSCH_betaOffsets_semiStatic) {
		_serNrSysEncSQN_NR_BetaOffsets(_buffer, _size, _lidx, &p->semiStatic);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_betaOffsets(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UCI_OnPUSCH_betaOffsets* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_UCI_OnPUSCH_betaOffsets_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_betaOffsets_betaOffsets_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UCI_OnPUSCH_betaOffsets_betaOffsets_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_UCI_OnPUSCH_betaOffsets(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UCI_OnPUSCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_UCI_OnPUSCH_betaOffsets_betaOffsets_Optional(_buffer, _size, _lidx, &p->betaOffsets);
	{
		size_t _tmp = (size_t)p->scaling;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_setup) {
		_serNrSysEncSQN_NR_UCI_OnPUSCH(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_SQN_NR_PUSCH_Config_uci_OnPUSCH_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_SQN_NR_PUSCH_Config_uci_OnPUSCH_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_tp_pi2BPSK_e_tp_pi2BPSK_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_tp_pi2BPSK_e_tp_pi2BPSK_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_SQN_NR_PUSCH_Config_minimumSchedulingOffsetK2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_SQN_NR_PUSCH_Config_minimumSchedulingOffsetK2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_SQN_NR_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_SQN_NR_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Config_harq_ProcessNumberSizeDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Config_harq_ProcessNumberSizeDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_dmrs_SequenceInitializationDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_dmrs_SequenceInitializationDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Config_numberOfBitsForRV_DCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Config_numberOfBitsForRV_DCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_antennaPortsFieldPresenceDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_antennaPortsFieldPresenceDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_setup) {
		_serNrSysEncSQN_NR_DMRS_UplinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_setup) {
		_serNrSysEncSQN_NR_DMRS_UplinkConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Value* p, enum SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeA) {
		{
			size_t _tmp = (size_t)p->pusch_RepTypeA;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_pusch_RepTypeB) {
		{
			size_t _tmp = (size_t)p->pusch_RepTypeB;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_frequencyHoppingDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_frequencyHoppingDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_16(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_SQN_NR_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_SQN_NR_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_codebookSubsetDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_codebookSubsetDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_invalidSymbolPatternIndicatorDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_invalidSymbolPatternIndicatorDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Config_maxRankDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Config_maxRankDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_mcs_TableDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_mcs_TableDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_mcs_TableTransformPrecoderDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_mcs_TableTransformPrecoderDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_priorityIndicatorDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_priorityIndicatorDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeIndicatorDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeIndicatorDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_resourceAllocationType1GranularityDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_resourceAllocationType1GranularityDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Value* p, enum SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_oneBit_r16) {
		for (size_t i3 = 0; i3 < 2; i3++) {
			_serNrSysEncSQN_NR_BetaOffsets(_buffer, _size, _lidx, &p->oneBit_r16[i3]);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_twoBits_r16) {
		for (size_t i3 = 0; i3 < 4; i3++) {
			_serNrSysEncSQN_NR_BetaOffsets(_buffer, _size, _lidx, &p->twoBits_r16[i3]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Value* p, enum SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16) {
		_serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_dynamicDCI_0_2_r16(_buffer, _size, _lidx, &p->dynamicDCI_0_2_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_semiStaticDCI_0_2_r16) {
		_serNrSysEncSQN_NR_BetaOffsets(_buffer, _size, _lidx, &p->semiStaticDCI_0_2_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_betaOffsetsDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_betaOffsetsDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UCI_OnPUSCH_DCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16_betaOffsetsDCI_0_2_r16_betaOffsetsDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->betaOffsetsDCI_0_2_r16);
	{
		size_t _tmp = (size_t)p->scalingDCI_0_2_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_UCI_OnPUSCH_DCI_0_2_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_r16_k2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_r16_k2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_mappingType_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_mappingType_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbolAndLength_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbolAndLength_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbol_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbol_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Allocation_r16_length_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Allocation_r16_length_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_numberOfRepetitions_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_numberOfRepetitions_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Allocation_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Allocation_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUSCH_Allocation_r16_mappingType_r16_e_mappingType_r16_Optional(_buffer, _size, _lidx, &p->mappingType_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbolAndLength_r16_Optional(_buffer, _size, _lidx, &p->startSymbolAndLength_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Allocation_r16_startSymbol_r16_Optional(_buffer, _size, _lidx, &p->startSymbol_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Allocation_r16_length_r16_Optional(_buffer, _size, _lidx, &p->length_r16);
	_serNrSysEncSQN_NR_PUSCH_Allocation_r16_numberOfRepetitions_r16_e_numberOfRepetitions_r16_Optional(_buffer, _size, _lidx, &p->numberOfRepetitions_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocation_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_TimeDomainResourceAllocation_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_PUSCH_TimeDomainResourceAllocation_r16_k2_r16_Optional(_buffer, _size, _lidx, &p->k2_r16);
	HTON_32(&_buffer[*_lidx], p->puschAllocationList_r16.d, _lidx);
	for (size_t i3 = 0; i3 < p->puschAllocationList_r16.d; i3++) {
		_serNrSysEncSQN_NR_PUSCH_Allocation_r16(_buffer, _size, _lidx, &p->puschAllocationList_r16.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocation_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocation_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_invalidSymbolPatternIndicatorDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_invalidSymbolPatternIndicatorDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_priorityIndicatorDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_priorityIndicatorDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeIndicatorDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeIndicatorDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_frequencyHoppingDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_frequencyHoppingDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_UCI_OnPUSCH(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InvalidSymbolPattern_r16_symbols_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_InvalidSymbolPattern_r16_symbols_r16_Value* p, enum SQN_NR_InvalidSymbolPattern_r16_symbols_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_InvalidSymbolPattern_r16_symbols_r16_oneSlot) {
		for (size_t i2 = 0; i2 < 14; i2++) {
			HTON_8(&_buffer[*_lidx], p->oneSlot[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_symbols_r16_twoSlots) {
		for (size_t i2 = 0; i2 < 28; i2++) {
			HTON_8(&_buffer[*_lidx], p->twoSlots[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_InvalidSymbolPattern_r16_symbols_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InvalidSymbolPattern_r16_symbols_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_InvalidSymbolPattern_r16_symbols_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Value* p, enum SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n2) {
		for (size_t i2 = 0; i2 < 2; i2++) {
			HTON_8(&_buffer[*_lidx], p->n2[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n4) {
		for (size_t i2 = 0; i2 < 4; i2++) {
			HTON_8(&_buffer[*_lidx], p->n4[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n5) {
		for (size_t i2 = 0; i2 < 5; i2++) {
			HTON_8(&_buffer[*_lidx], p->n5[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n8) {
		for (size_t i2 = 0; i2 < 8; i2++) {
			HTON_8(&_buffer[*_lidx], p->n8[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n10) {
		for (size_t i2 = 0; i2 < 10; i2++) {
			HTON_8(&_buffer[*_lidx], p->n10[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n20) {
		for (size_t i2 = 0; i2 < 20; i2++) {
			HTON_8(&_buffer[*_lidx], p->n20[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_n40) {
		for (size_t i2 = 0; i2 < 40; i2++) {
			HTON_8(&_buffer[*_lidx], p->n40[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_periodicityAndPattern_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_periodicityAndPattern_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InvalidSymbolPattern_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InvalidSymbolPattern_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_InvalidSymbolPattern_r16_symbols_r16(_buffer, _size, _lidx, &p->symbols_r16);
	_serNrSysEncSQN_NR_InvalidSymbolPattern_r16_periodicityAndPattern_r16_periodicityAndPattern_r16_Optional(_buffer, _size, _lidx, &p->periodicityAndPattern_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InvalidSymbolPattern_r16_SQN_NR_PUSCH_Config_invalidSymbolPattern_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InvalidSymbolPattern_r16_SQN_NR_PUSCH_Config_invalidSymbolPattern_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_InvalidSymbolPattern_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Value* p, enum SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_ssb_Index_r16) {
		HTON_8(&_buffer[*_lidx], p->ssb_Index_r16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_csi_RS_Index_r16) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_Index_r16, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->pusch_PathlossReferenceRS_Id_r16, _lidx);
	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16_referenceSignal_r16(_buffer, _size, _lidx, &p->referenceSignal_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToAddModList2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS_r16_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToAddModList2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToReleaseList2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToReleaseList2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P0_PUSCH_r16_SQN_NR_P0_PUSCH_Set_r16_p0_List_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P0_PUSCH_r16_SQN_NR_P0_PUSCH_Set_r16_p0_List_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P0_PUSCH_Set_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P0_PUSCH_Set_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->p0_PUSCH_SetId_r16, _lidx);
	_serNrSysEncSQN_NR_P0_PUSCH_r16_SQN_NR_P0_PUSCH_Set_r16_p0_List_r16_DynamicOptional(_buffer, _size, _lidx, &p->p0_List_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P0_PUSCH_Set_r16_SQN_NR_PUSCH_PowerControl_v1610_p0_PUSCH_SetList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P0_PUSCH_Set_r16_SQN_NR_PUSCH_PowerControl_v1610_p0_PUSCH_SetList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_P0_PUSCH_Set_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->olpc_ParameterSetDCI_0_1_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSetDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->olpc_ParameterSetDCI_0_2_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSet_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSet_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_PowerControl_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_PowerControl_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_r16_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToAddModList2_r16_DynamicOptional(_buffer, _size, _lidx, &p->pathlossReferenceRSToAddModList2_r16);
	_serNrSysEncSQN_NR_PUSCH_PathlossReferenceRS_Id_v1610_SQN_NR_PUSCH_PowerControl_v1610_pathlossReferenceRSToReleaseList2_r16_DynamicOptional(_buffer, _size, _lidx, &p->pathlossReferenceRSToReleaseList2_r16);
	_serNrSysEncSQN_NR_P0_PUSCH_Set_r16_SQN_NR_PUSCH_PowerControl_v1610_p0_PUSCH_SetList_r16_DynamicOptional(_buffer, _size, _lidx, &p->p0_PUSCH_SetList_r16);
	_serNrSysEncSQN_NR_PUSCH_PowerControl_v1610_olpc_ParameterSet_olpc_ParameterSet_Optional(_buffer, _size, _lidx, &p->olpc_ParameterSet);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_setup) {
		_serNrSysEncSQN_NR_PUSCH_PowerControl_v1610(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_SQN_NR_PUSCH_Config_pusch_PowerControl_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_SQN_NR_PUSCH_Config_pusch_PowerControl_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_ul_FullPowerTransmission_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_ul_FullPowerTransmission_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PUSCH_TimeDomainResourceAllocation_r16(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_Config_numberOfInvalidSymbolsForDL_UL_Switching_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_Config_numberOfInvalidSymbolsForDL_UL_Switching_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint16_t_SQN_NR_PUSCH_Config_dataScramblingIdentityPUSCH_Optional(_buffer, _size, _lidx, &p->dataScramblingIdentityPUSCH);
	_serNrSysEncSQN_NR_PUSCH_Config_txConfig_e_txConfig_Optional(_buffer, _size, _lidx, &p->txConfig);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_Optional(_buffer, _size, _lidx, &p->dmrs_UplinkForPUSCH_MappingTypeA);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_Optional(_buffer, _size, _lidx, &p->dmrs_UplinkForPUSCH_MappingTypeB);
	_serNrSysEncSQN_NR_PUSCH_PowerControl_SQN_NR_PUSCH_Config_pusch_PowerControl_Optional(_buffer, _size, _lidx, &p->pusch_PowerControl);
	_serNrSysEncSQN_NR_PUSCH_Config_frequencyHopping_e_frequencyHopping_Optional(_buffer, _size, _lidx, &p->frequencyHopping);
	_serNrSysEncUint16_t_SQN_NR_PUSCH_Config_frequencyHoppingOffsetLists_DynamicOptional(_buffer, _size, _lidx, &p->frequencyHoppingOffsetLists);
	{
		size_t _tmp = (size_t)p->resourceAllocation;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationList_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationList_Optional(_buffer, _size, _lidx, &p->pusch_TimeDomainAllocationList);
	_serNrSysEncSQN_NR_PUSCH_Config_pusch_AggregationFactor_e_pusch_AggregationFactor_Optional(_buffer, _size, _lidx, &p->pusch_AggregationFactor);
	_serNrSysEncSQN_NR_PUSCH_Config_mcs_Table_e_mcs_Table_Optional(_buffer, _size, _lidx, &p->mcs_Table);
	_serNrSysEncSQN_NR_PUSCH_Config_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(_buffer, _size, _lidx, &p->mcs_TableTransformPrecoder);
	_serNrSysEncSQN_NR_PUSCH_Config_transformPrecoder_e_transformPrecoder_Optional(_buffer, _size, _lidx, &p->transformPrecoder);
	_serNrSysEncSQN_NR_PUSCH_Config_codebookSubset_e_codebookSubset_Optional(_buffer, _size, _lidx, &p->codebookSubset);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Config_maxRank_Optional(_buffer, _size, _lidx, &p->maxRank);
	_serNrSysEncSQN_NR_PUSCH_Config_rbg_Size_e_rbg_Size_Optional(_buffer, _size, _lidx, &p->rbg_Size);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_SQN_NR_PUSCH_Config_uci_OnPUSCH_Optional(_buffer, _size, _lidx, &p->uci_OnPUSCH);
	_serNrSysEncSQN_NR_PUSCH_Config_tp_pi2BPSK_e_tp_pi2BPSK_Optional(_buffer, _size, _lidx, &p->tp_pi2BPSK);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_minimumSchedulingOffsetK2_r16_SQN_NR_PUSCH_Config_minimumSchedulingOffsetK2_r16_Optional(_buffer, _size, _lidx, &p->minimumSchedulingOffsetK2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_SQN_NR_PUSCH_Config_ul_AccessConfigListDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->ul_AccessConfigListDCI_0_1_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Config_harq_ProcessNumberSizeDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->harq_ProcessNumberSizeDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_dmrs_SequenceInitializationDCI_0_2_r16_e_dmrs_SequenceInitializationDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->dmrs_SequenceInitializationDCI_0_2_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Config_numberOfBitsForRV_DCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->numberOfBitsForRV_DCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_antennaPortsFieldPresenceDCI_0_2_r16_e_antennaPortsFieldPresenceDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->antennaPortsFieldPresenceDCI_0_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->dmrs_UplinkForPUSCH_MappingTypeA_DCI_0_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_SQN_NR_PUSCH_Config_dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->dmrs_UplinkForPUSCH_MappingTypeB_DCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_2_r16_frequencyHoppingDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->frequencyHoppingDCI_0_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_SQN_NR_PUSCH_Config_frequencyHoppingOffsetListsDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->frequencyHoppingOffsetListsDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_codebookSubsetDCI_0_2_r16_e_codebookSubsetDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->codebookSubsetDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_2_r16_e_invalidSymbolPatternIndicatorDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->invalidSymbolPatternIndicatorDCI_0_2_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Config_maxRankDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->maxRankDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_mcs_TableDCI_0_2_r16_e_mcs_TableDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->mcs_TableDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_mcs_TableTransformPrecoderDCI_0_2_r16_e_mcs_TableTransformPrecoderDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->mcs_TableTransformPrecoderDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_priorityIndicatorDCI_0_2_r16_e_priorityIndicatorDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->priorityIndicatorDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_2_r16_e_pusch_RepTypeIndicatorDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->pusch_RepTypeIndicatorDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_resourceAllocationDCI_0_2_r16_e_resourceAllocationDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->resourceAllocationDCI_0_2_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_resourceAllocationType1GranularityDCI_0_2_r16_e_resourceAllocationType1GranularityDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->resourceAllocationType1GranularityDCI_0_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->uci_OnPUSCH_ListDCI_0_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->pusch_TimeDomainAllocationListDCI_0_2_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->pusch_TimeDomainAllocationListDCI_0_1_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_invalidSymbolPatternIndicatorDCI_0_1_r16_e_invalidSymbolPatternIndicatorDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->invalidSymbolPatternIndicatorDCI_0_1_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_priorityIndicatorDCI_0_1_r16_e_priorityIndicatorDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->priorityIndicatorDCI_0_1_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_pusch_RepTypeIndicatorDCI_0_1_r16_e_pusch_RepTypeIndicatorDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->pusch_RepTypeIndicatorDCI_0_1_r16);
	_serNrSysEncSQN_NR_PUSCH_Config_frequencyHoppingDCI_0_1_r16_e_frequencyHoppingDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->frequencyHoppingDCI_0_1_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_SQN_NR_PUSCH_Config_uci_OnPUSCH_ListDCI_0_1_r16_Optional(_buffer, _size, _lidx, &p->uci_OnPUSCH_ListDCI_0_1_r16);
	_serNrSysEncSQN_NR_InvalidSymbolPattern_r16_SQN_NR_PUSCH_Config_invalidSymbolPattern_r16_Optional(_buffer, _size, _lidx, &p->invalidSymbolPattern_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_PowerControl_v1610_SQN_NR_PUSCH_Config_pusch_PowerControl_v1610_Optional(_buffer, _size, _lidx, &p->pusch_PowerControl_v1610);
	_serNrSysEncSQN_NR_PUSCH_Config_ul_FullPowerTransmission_r16_e_ul_FullPowerTransmission_r16_Optional(_buffer, _size, _lidx, &p->ul_FullPowerTransmission_r16);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_SQN_NR_PUSCH_Config_pusch_TimeDomainAllocationListForMultiPUSCH_r16_Optional(_buffer, _size, _lidx, &p->pusch_TimeDomainAllocationListForMultiPUSCH_r16);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_Config_numberOfInvalidSymbolsForDL_UL_Switching_r16_Optional(_buffer, _size, _lidx, &p->numberOfInvalidSymbolsForDL_UL_Switching_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_setup) {
		_serNrSysEncSQN_NR_PUSCH_Config(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_SQN_NR_BWP_UplinkDedicated_pusch_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_SQN_NR_BWP_UplinkDedicated_pusch_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_frequencyHopping_e_frequencyHopping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_frequencyHopping_e_frequencyHopping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_mcs_Table_e_mcs_Table_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_mcs_Table_e_mcs_Table_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CG_UCI_OnPUSCH_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_CG_UCI_OnPUSCH_Value* p, enum SQN_NR_CG_UCI_OnPUSCH_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_CG_UCI_OnPUSCH_dynamic) {
		HTON_32(&_buffer[*_lidx], p->dynamic.d, _lidx);
		for (size_t i2 = 0; i2 < p->dynamic.d; i2++) {
			_serNrSysEncSQN_NR_BetaOffsets(_buffer, _size, _lidx, &p->dynamic.v[i2]);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CG_UCI_OnPUSCH_semiStatic) {
		_serNrSysEncSQN_NR_BetaOffsets(_buffer, _size, _lidx, &p->semiStatic);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_CG_UCI_OnPUSCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CG_UCI_OnPUSCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CG_UCI_OnPUSCH_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Value* p, enum SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_setup) {
		_serNrSysEncSQN_NR_CG_UCI_OnPUSCH(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_SQN_NR_ConfiguredGrantConfig_uci_OnPUSCH_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_SQN_NR_ConfiguredGrantConfig_uci_OnPUSCH_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_rbg_Size_e_rbg_Size_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_rbg_Size_e_rbg_Size_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_transformPrecoder_e_transformPrecoder_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_transformPrecoder_e_transformPrecoder_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_repK_RV_e_repK_RV_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_repK_RV_e_repK_RV_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_configuredGrantTimer_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_configuredGrantTimer_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_dmrs_SeqInitialization_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_dmrs_SeqInitialization_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_srs_ResourceIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_srs_ResourceIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeIndicator_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeIndicator_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_frequencyHoppingPUSCH_RepTypeB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_frequencyHoppingPUSCH_RepTypeB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_timeReferenceSFN_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_timeReferenceSFN_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->timeDomainOffset, _lidx);
	HTON_8(&_buffer[*_lidx], p->timeDomainAllocation, _lidx);
	for (size_t i2 = 0; i2 < 18; i2++) {
		HTON_8(&_buffer[*_lidx], p->frequencyDomainAllocation[i2], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->antennaPort, _lidx);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_dmrs_SeqInitialization_Optional(_buffer, _size, _lidx, &p->dmrs_SeqInitialization);
	HTON_8(&_buffer[*_lidx], p->precodingAndNumberOfLayers, _lidx);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_srs_ResourceIndicator_Optional(_buffer, _size, _lidx, &p->srs_ResourceIndicator);
	HTON_8(&_buffer[*_lidx], p->mcsAndTBS, _lidx);
	_serNrSysEncUint16_t_SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingOffset_Optional(_buffer, _size, _lidx, &p->frequencyHoppingOffset);
	HTON_8(&_buffer[*_lidx], p->pathlossReferenceIndex, _lidx);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_pusch_RepTypeIndicator_r16_e_pusch_RepTypeIndicator_r16_Optional(_buffer, _size, _lidx, &p->pusch_RepTypeIndicator_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_frequencyHoppingPUSCH_RepTypeB_r16_e_frequencyHoppingPUSCH_RepTypeB_r16_Optional(_buffer, _size, _lidx, &p->frequencyHoppingPUSCH_RepTypeB_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_timeReferenceSFN_r16_e_timeReferenceSFN_r16_Optional(_buffer, _size, _lidx, &p->timeReferenceSFN_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_rrc_ConfiguredUplinkGrant_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_rrc_ConfiguredUplinkGrant_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_RetransmissionTimer_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_RetransmissionTimer_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_cg_minDFI_Delay_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_cg_minDFI_Delay_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofPUSCH_InSlot_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofPUSCH_InSlot_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofSlots_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofSlots_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_InsideCOT_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_InsideCOT_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_OutsideCOT_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_OutsideCOT_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_InsideCOT_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_InsideCOT_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_OutsideCOT_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_OutsideCOT_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CG_StartingOffsets_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CG_StartingOffsets_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_InsideCOT_r16_DynamicOptional(_buffer, _size, _lidx, &p->cg_StartingFullBW_InsideCOT_r16);
	_serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingFullBW_OutsideCOT_r16_DynamicOptional(_buffer, _size, _lidx, &p->cg_StartingFullBW_OutsideCOT_r16);
	_serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_InsideCOT_r16_Optional(_buffer, _size, _lidx, &p->cg_StartingPartialBW_InsideCOT_r16);
	_serNrSysEncUint8_t_SQN_NR_CG_StartingOffsets_r16_cg_StartingPartialBW_OutsideCOT_r16_Optional(_buffer, _size, _lidx, &p->cg_StartingPartialBW_OutsideCOT_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CG_StartingOffsets_r16_SQN_NR_ConfiguredGrantConfig_cg_StartingOffsets_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CG_StartingOffsets_r16_SQN_NR_ConfiguredGrantConfig_cg_StartingOffsets_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CG_StartingOffsets_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_cg_UCI_Multiplexing_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_cg_UCI_Multiplexing_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingOffset_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingOffset_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_betaOffsetCG_UCI_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_betaOffsetCG_UCI_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->duration_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->offset_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->channelAccessPriority_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CG_COT_Sharing_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_CG_COT_Sharing_r16_Value* p, enum SQN_NR_CG_COT_Sharing_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_CG_COT_Sharing_r16_noCOT_Sharing_r16) {
		HTON_8(&_buffer[*_lidx], p->noCOT_Sharing_r16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16) {
		_serNrSysEncSQN_NR_CG_COT_Sharing_r16_cot_Sharing_r16(_buffer, _size, _lidx, &p->cot_Sharing_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_CG_COT_Sharing_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CG_COT_Sharing_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CG_COT_Sharing_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CG_COT_Sharing_r16_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CG_COT_Sharing_r16_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_CG_COT_Sharing_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfigIndex_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfigIndex_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfigIndexMAC_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndexMAC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfigIndexMAC_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndexMAC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_ConfiguredGrantConfig_periodicityExt_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_ConfiguredGrantConfig_periodicityExt_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_startingFromRV0_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_startingFromRV0_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_autonomousTx_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_autonomousTx_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ConfiguredGrantConfig_frequencyHopping_e_frequencyHopping_Optional(_buffer, _size, _lidx, &p->frequencyHopping);
	_serNrSysEncSQN_NR_DMRS_UplinkConfig(_buffer, _size, _lidx, &p->cg_DMRS_Configuration);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_mcs_Table_e_mcs_Table_Optional(_buffer, _size, _lidx, &p->mcs_Table);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_mcs_TableTransformPrecoder_e_mcs_TableTransformPrecoder_Optional(_buffer, _size, _lidx, &p->mcs_TableTransformPrecoder);
	_serNrSysEncSQN_NR_SetupRelease_ConfiguredGrantConfig_uci_OnPUSCH_SQN_NR_ConfiguredGrantConfig_uci_OnPUSCH_Optional(_buffer, _size, _lidx, &p->uci_OnPUSCH);
	{
		size_t _tmp = (size_t)p->resourceAllocation;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_rbg_Size_e_rbg_Size_Optional(_buffer, _size, _lidx, &p->rbg_Size);
	{
		size_t _tmp = (size_t)p->powerControlLoopToUse;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->p0_PUSCH_Alpha, _lidx);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_transformPrecoder_e_transformPrecoder_Optional(_buffer, _size, _lidx, &p->transformPrecoder);
	HTON_8(&_buffer[*_lidx], p->nrofHARQ_Processes, _lidx);
	{
		size_t _tmp = (size_t)p->repK;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_repK_RV_e_repK_RV_Optional(_buffer, _size, _lidx, &p->repK_RV);
	{
		size_t _tmp = (size_t)p->periodicity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_configuredGrantTimer_Optional(_buffer, _size, _lidx, &p->configuredGrantTimer);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_rrc_ConfiguredUplinkGrant_rrc_ConfiguredUplinkGrant_Optional(_buffer, _size, _lidx, &p->rrc_ConfiguredUplinkGrant);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_RetransmissionTimer_r16_Optional(_buffer, _size, _lidx, &p->cg_RetransmissionTimer_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_cg_minDFI_Delay_r16_e_cg_minDFI_Delay_r16_Optional(_buffer, _size, _lidx, &p->cg_minDFI_Delay_r16);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofPUSCH_InSlot_r16_Optional(_buffer, _size, _lidx, &p->cg_nrofPUSCH_InSlot_r16);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_nrofSlots_r16_Optional(_buffer, _size, _lidx, &p->cg_nrofSlots_r16);
	_serNrSysEncSQN_NR_CG_StartingOffsets_r16_SQN_NR_ConfiguredGrantConfig_cg_StartingOffsets_r16_Optional(_buffer, _size, _lidx, &p->cg_StartingOffsets_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_cg_UCI_Multiplexing_e_cg_UCI_Multiplexing_Optional(_buffer, _size, _lidx, &p->cg_UCI_Multiplexing);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingOffset_r16_Optional(_buffer, _size, _lidx, &p->cg_COT_SharingOffset_r16);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_betaOffsetCG_UCI_r16_Optional(_buffer, _size, _lidx, &p->betaOffsetCG_UCI_r16);
	_serNrSysEncSQN_NR_CG_COT_Sharing_r16_SQN_NR_ConfiguredGrantConfig_cg_COT_SharingList_r16_DynamicOptional(_buffer, _size, _lidx, &p->cg_COT_SharingList_r16);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset_r16_Optional(_buffer, _size, _lidx, &p->harq_ProcID_Offset_r16);
	_serNrSysEncUint8_t_SQN_NR_ConfiguredGrantConfig_harq_ProcID_Offset2_r16_Optional(_buffer, _size, _lidx, &p->harq_ProcID_Offset2_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfigIndex_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndex_r16_Optional(_buffer, _size, _lidx, &p->configuredGrantConfigIndex_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfigIndexMAC_r16_SQN_NR_ConfiguredGrantConfig_configuredGrantConfigIndexMAC_r16_Optional(_buffer, _size, _lidx, &p->configuredGrantConfigIndexMAC_r16);
	_serNrSysEncUint16_t_SQN_NR_ConfiguredGrantConfig_periodicityExt_r16_Optional(_buffer, _size, _lidx, &p->periodicityExt_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_startingFromRV0_r16_e_startingFromRV0_r16_Optional(_buffer, _size, _lidx, &p->startingFromRV0_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_phy_PriorityIndex_r16_e_phy_PriorityIndex_r16_Optional(_buffer, _size, _lidx, &p->phy_PriorityIndex_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfig_autonomousTx_r16_e_autonomousTx_r16_Optional(_buffer, _size, _lidx, &p->autonomousTx_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_setup) {
		_serNrSysEncSQN_NR_ConfiguredGrantConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_SQN_NR_BWP_UplinkDedicated_configuredGrantConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_SQN_NR_BWP_UplinkDedicated_configuredGrantConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceId_SQN_NR_SRS_ResourceSet_srs_ResourceIdList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceId_SQN_NR_SRS_ResourceSet_srs_ResourceIdList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_csi_RS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_csi_RS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_slotOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_slotOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_aperiodicSRS_ResourceTriggerList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_aperiodicSRS_ResourceTriggerList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_aperiodic(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet_resourceType_aperiodic* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->aperiodicSRS_ResourceTrigger, _lidx);
	_serNrSysEncSQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_csi_RS_Optional(_buffer, _size, _lidx, &p->csi_RS);
	_serNrSysEncUint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_slotOffset_Optional(_buffer, _size, _lidx, &p->slotOffset);
	_serNrSysEncUint8_t_SQN_NR_SRS_ResourceSet_resourceType_aperiodic_aperiodicSRS_ResourceTriggerList_DynamicOptional(_buffer, _size, _lidx, &p->aperiodicSRS_ResourceTriggerList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_semi_persistent_associatedCSI_RS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_semi_persistent_associatedCSI_RS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_semi_persistent(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet_resourceType_semi_persistent* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_semi_persistent_associatedCSI_RS_Optional(_buffer, _size, _lidx, &p->associatedCSI_RS);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_periodic_associatedCSI_RS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_periodic_associatedCSI_RS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_periodic(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet_resourceType_periodic* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_NZP_CSI_RS_ResourceId_SQN_NR_SRS_ResourceSet_resourceType_periodic_associatedCSI_RS_Optional(_buffer, _size, _lidx, &p->associatedCSI_RS);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_ResourceSet_resourceType_Value* p, enum SQN_NR_SRS_ResourceSet_resourceType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_ResourceSet_resourceType_aperiodic) {
		_serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_aperiodic(_buffer, _size, _lidx, &p->aperiodic);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_ResourceSet_resourceType_semi_persistent) {
		_serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_semi_persistent(_buffer, _size, _lidx, &p->semi_persistent);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_ResourceSet_resourceType_periodic) {
		_serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_periodic(_buffer, _size, _lidx, &p->periodic);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_resourceType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet_resourceType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_ResourceSet_resourceType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Alpha_e_SQN_NR_SRS_ResourceSet_alpha_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Alpha_e_SQN_NR_SRS_ResourceSet_alpha_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt16_t_SQN_NR_SRS_ResourceSet_p0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_NR_SRS_ResourceSet_p0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PathlossReferenceRS_Config_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PathlossReferenceRS_Config_Value* p, enum SQN_NR_PathlossReferenceRS_Config_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PathlossReferenceRS_Config_ssb_Index) {
		HTON_8(&_buffer[*_lidx], p->ssb_Index, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PathlossReferenceRS_Config_csi_RS_Index) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_Index, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PathlossReferenceRS_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PathlossReferenceRS_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PathlossReferenceRS_Config_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PathlossReferenceRS_Config_SQN_NR_SRS_ResourceSet_pathlossReferenceRS_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PathlossReferenceRS_Config_SQN_NR_SRS_ResourceSet_pathlossReferenceRS_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PathlossReferenceRS_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_srs_PowerControlAdjustmentStates_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_srs_PowerControlAdjustmentStates_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PathlossReferenceRS_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PathlossReferenceRS_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->srs_PathlossReferenceRS_Id_r16, _lidx);
	_serNrSysEncSQN_NR_PathlossReferenceRS_Config(_buffer, _size, _lidx, &p->pathlossReferenceRS_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Value* p, enum SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i3 = 0; i3 < p->setup.d; i3++) {
			_serNrSysEncSQN_NR_PathlossReferenceRS_r16(_buffer, _size, _lidx, &p->setup.v[i3]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_SQN_NR_SRS_ResourceSet_pathlossReferenceRSList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_SQN_NR_SRS_ResourceSet_pathlossReferenceRSList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->srs_ResourceSetId, _lidx);
	_serNrSysEncSQN_NR_SRS_ResourceId_SQN_NR_SRS_ResourceSet_srs_ResourceIdList_DynamicOptional(_buffer, _size, _lidx, &p->srs_ResourceIdList);
	_serNrSysEncSQN_NR_SRS_ResourceSet_resourceType(_buffer, _size, _lidx, &p->resourceType);
	{
		size_t _tmp = (size_t)p->usage;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_Alpha_e_SQN_NR_SRS_ResourceSet_alpha_Optional(_buffer, _size, _lidx, &p->alpha);
	_serNrSysEncInt16_t_SQN_NR_SRS_ResourceSet_p0_Optional(_buffer, _size, _lidx, &p->p0);
	_serNrSysEncSQN_NR_PathlossReferenceRS_Config_SQN_NR_SRS_ResourceSet_pathlossReferenceRS_Optional(_buffer, _size, _lidx, &p->pathlossReferenceRS);
	_serNrSysEncSQN_NR_SRS_ResourceSet_srs_PowerControlAdjustmentStates_e_srs_PowerControlAdjustmentStates_Optional(_buffer, _size, _lidx, &p->srs_PowerControlAdjustmentStates);
	_serNrSysEncSQN_NR_SetupRelease_SRS_ResourceSet_pathlossReferenceRSList_r16_SQN_NR_SRS_ResourceSet_pathlossReferenceRSList_r16_Optional(_buffer, _size, _lidx, &p->pathlossReferenceRSList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SRS_ResourceSet(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceId_SQN_NR_SRS_Config_srs_ResourceToReleaseList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceId_SQN_NR_SRS_Config_srs_ResourceToReleaseList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_ptrs_PortIndex_e_ptrs_PortIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_ptrs_PortIndex_e_ptrs_PortIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_transmissionComb_n2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_transmissionComb_n2* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->combOffset_n2, _lidx);
	HTON_8(&_buffer[*_lidx], p->cyclicShift_n2, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_transmissionComb_n4(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_transmissionComb_n4* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->combOffset_n4, _lidx);
	HTON_8(&_buffer[*_lidx], p->cyclicShift_n4, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_transmissionComb_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_Resource_transmissionComb_Value* p, enum SQN_NR_SRS_Resource_transmissionComb_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_Resource_transmissionComb_n2) {
		_serNrSysEncSQN_NR_SRS_Resource_transmissionComb_n2(_buffer, _size, _lidx, &p->n2);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_Resource_transmissionComb_n4) {
		_serNrSysEncSQN_NR_SRS_Resource_transmissionComb_n4(_buffer, _size, _lidx, &p->n4);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_Resource_transmissionComb(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_transmissionComb* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_Resource_transmissionComb_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceMapping(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_resourceMapping* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->startPosition, _lidx);
	{
		size_t _tmp = (size_t)p->nrofSymbols;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->repetitionFactor;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_freqHopping(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_freqHopping* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->c_SRS, _lidx);
	HTON_8(&_buffer[*_lidx], p->b_SRS, _lidx);
	HTON_8(&_buffer[*_lidx], p->b_hop, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceType_aperiodic(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_resourceType_aperiodic* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PeriodicityAndOffset_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_PeriodicityAndOffset_Value* p, enum SQN_NR_SRS_PeriodicityAndOffset_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl1) {
		HTON_8(&_buffer[*_lidx], p->sl1, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl2) {
		HTON_8(&_buffer[*_lidx], p->sl2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl4) {
		HTON_8(&_buffer[*_lidx], p->sl4, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl5) {
		HTON_8(&_buffer[*_lidx], p->sl5, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl8) {
		HTON_8(&_buffer[*_lidx], p->sl8, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl10) {
		HTON_8(&_buffer[*_lidx], p->sl10, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl16) {
		HTON_8(&_buffer[*_lidx], p->sl16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl20) {
		HTON_8(&_buffer[*_lidx], p->sl20, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl32) {
		HTON_8(&_buffer[*_lidx], p->sl32, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl40) {
		HTON_8(&_buffer[*_lidx], p->sl40, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl64) {
		HTON_8(&_buffer[*_lidx], p->sl64, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl80) {
		HTON_8(&_buffer[*_lidx], p->sl80, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl160) {
		HTON_8(&_buffer[*_lidx], p->sl160, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl320) {
		HTON_16(&_buffer[*_lidx], p->sl320, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl640) {
		HTON_16(&_buffer[*_lidx], p->sl640, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl1280) {
		HTON_16(&_buffer[*_lidx], p->sl1280, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_sl2560) {
		HTON_16(&_buffer[*_lidx], p->sl2560, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_PeriodicityAndOffset(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PeriodicityAndOffset* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_PeriodicityAndOffset_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceType_semi_persistent(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_resourceType_semi_persistent* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SRS_PeriodicityAndOffset(_buffer, _size, _lidx, &p->periodicityAndOffset_sp);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceType_periodic(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_resourceType_periodic* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SRS_PeriodicityAndOffset(_buffer, _size, _lidx, &p->periodicityAndOffset_p);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_Resource_resourceType_Value* p, enum SQN_NR_SRS_Resource_resourceType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_Resource_resourceType_aperiodic) {
		_serNrSysEncSQN_NR_SRS_Resource_resourceType_aperiodic(_buffer, _size, _lidx, &p->aperiodic);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_Resource_resourceType_semi_persistent) {
		_serNrSysEncSQN_NR_SRS_Resource_resourceType_semi_persistent(_buffer, _size, _lidx, &p->semi_persistent);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_Resource_resourceType_periodic) {
		_serNrSysEncSQN_NR_SRS_Resource_resourceType_periodic(_buffer, _size, _lidx, &p->periodic);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_resourceType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_Resource_resourceType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfo_servingCellId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfo_servingCellId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->resourceId, _lidx);
	HTON_8(&_buffer[*_lidx], p->uplinkBWP, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfo_referenceSignal_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_SpatialRelationInfo_referenceSignal_Value* p, enum SQN_NR_SRS_SpatialRelationInfo_referenceSignal_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_SpatialRelationInfo_referenceSignal_ssb_Index) {
		HTON_8(&_buffer[*_lidx], p->ssb_Index, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfo_referenceSignal_csi_RS_Index) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_Index, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs) {
		_serNrSysEncSQN_NR_SRS_SpatialRelationInfo_referenceSignal_srs(_buffer, _size, _lidx, &p->srs);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfo_referenceSignal(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfo_referenceSignal* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfo_referenceSignal_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfo_servingCellId_Optional(_buffer, _size, _lidx, &p->servingCellId);
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfo_referenceSignal(_buffer, _size, _lidx, &p->referenceSignal);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfo_SQN_NR_SRS_Resource_spatialRelationInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfo_SQN_NR_SRS_Resource_spatialRelationInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceMapping_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_resourceMapping_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->startPosition_r16, _lidx);
	{
		size_t _tmp = (size_t)p->nrofSymbols_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->repetitionFactor_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_resourceMapping_r16_resourceMapping_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_resourceMapping_r16_resourceMapping_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SRS_Resource_resourceMapping_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->srs_ResourceId, _lidx);
	{
		size_t _tmp = (size_t)p->nrofSRS_Ports;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_Resource_ptrs_PortIndex_e_ptrs_PortIndex_Optional(_buffer, _size, _lidx, &p->ptrs_PortIndex);
	_serNrSysEncSQN_NR_SRS_Resource_transmissionComb(_buffer, _size, _lidx, &p->transmissionComb);
	_serNrSysEncSQN_NR_SRS_Resource_resourceMapping(_buffer, _size, _lidx, &p->resourceMapping);
	HTON_8(&_buffer[*_lidx], p->freqDomainPosition, _lidx);
	HTON_16(&_buffer[*_lidx], p->freqDomainShift, _lidx);
	_serNrSysEncSQN_NR_SRS_Resource_freqHopping(_buffer, _size, _lidx, &p->freqHopping);
	{
		size_t _tmp = (size_t)p->groupOrSequenceHopping;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_Resource_resourceType(_buffer, _size, _lidx, &p->resourceType);
	HTON_16(&_buffer[*_lidx], p->sequenceId, _lidx);
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfo_SQN_NR_SRS_Resource_spatialRelationInfo_Optional(_buffer, _size, _lidx, &p->spatialRelationInfo);
	_serNrSysEncSQN_NR_SRS_Resource_resourceMapping_r16_resourceMapping_r16_Optional(_buffer, _size, _lidx, &p->resourceMapping_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Resource_SQN_NR_SRS_Config_srs_ResourceToAddModList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Resource_SQN_NR_SRS_Config_srs_ResourceToAddModList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SRS_Resource(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Config_tpc_Accumulation_e_tpc_Accumulation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Config_tpc_Accumulation_e_tpc_Accumulation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SRS_Config_srs_RequestDCI_1_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_1_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SRS_Config_srs_RequestDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SRS_Config_srs_RequestDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModListDCI_0_2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModListDCI_0_2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SRS_ResourceSet(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseListDCI_0_2_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseListDCI_0_2_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSetId_r16_SQN_NR_SRS_Config_srs_PosResourceSetToReleaseList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSetId_r16_SQN_NR_SRS_Config_srs_PosResourceSetToReleaseList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_PosResourceSet_r16_srs_PosResourceIdList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_PosResourceSet_r16_srs_PosResourceIdList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16_aperiodicSRS_ResourceTriggerList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16_aperiodicSRS_ResourceTriggerList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16_aperiodicSRS_ResourceTriggerList_r16_DynamicOptional(_buffer, _size, _lidx, &p->aperiodicSRS_ResourceTriggerList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Value* p, enum SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16) {
		_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_aperiodic_r16(_buffer, _size, _lidx, &p->aperiodic_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16) {
		_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_semi_persistent_r16(_buffer, _size, _lidx, &p->semi_persistent_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16) {
		_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_periodic_r16(_buffer, _size, _lidx, &p->periodic_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16_resourceType_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Alpha_e_SQN_NR_SRS_PosResourceSet_r16_alpha_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Alpha_e_SQN_NR_SRS_PosResourceSet_r16_alpha_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt16_t_SQN_NR_SRS_PosResourceSet_r16_p0_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_NR_SRS_PosResourceSet_r16_p0_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_Index_SQN_NR_SSB_InfoNcell_r16_ssb_IndexNcell_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_Index_SQN_NR_SSB_InfoNcell_r16_ssb_IndexNcell_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ssb_Periodicity_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ssb_Periodicity_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_integerSubframeOffset_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_integerSubframeOffset_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_Configuration_r16_sfn0_Offset_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->sfn_Offset_r16, _lidx);
	_serNrSysEncUint8_t_SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_integerSubframeOffset_r16_Optional(_buffer, _size, _lidx, &p->integerSubframeOffset_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_sfn0_Offset_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_sfn0_Offset_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_Configuration_r16_sfn0_Offset_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_SSB_Configuration_r16_ss_PBCH_BlockPower_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_SSB_Configuration_r16_ss_PBCH_BlockPower_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_Configuration_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_Configuration_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->ssb_Freq_r16, _lidx);
	{
		size_t _tmp = (size_t)p->halfFrameIndex_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->ssbSubcarrierSpacing_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SSB_Configuration_r16_ssb_Periodicity_r16_e_ssb_Periodicity_r16_Optional(_buffer, _size, _lidx, &p->ssb_Periodicity_r16);
	_serNrSysEncSQN_NR_SSB_Configuration_r16_sfn0_Offset_r16_sfn0_Offset_r16_Optional(_buffer, _size, _lidx, &p->sfn0_Offset_r16);
	HTON_8(&_buffer[*_lidx], p->sfn_SSB_Offset_r16, _lidx);
	_serNrSysEncInt8_t_SQN_NR_SSB_Configuration_r16_ss_PBCH_BlockPower_r16_Optional(_buffer, _size, _lidx, &p->ss_PBCH_BlockPower_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_Configuration_r16_SQN_NR_SSB_InfoNcell_r16_ssb_Configuration_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_Configuration_r16_SQN_NR_SSB_InfoNcell_r16_ssb_Configuration_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_Configuration_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_InfoNcell_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_InfoNcell_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physicalCellId_r16, _lidx);
	_serNrSysEncSQN_NR_SSB_Index_SQN_NR_SSB_InfoNcell_r16_ssb_IndexNcell_r16_Optional(_buffer, _size, _lidx, &p->ssb_IndexNcell_r16);
	_serNrSysEncSQN_NR_SSB_Configuration_r16_SQN_NR_SSB_InfoNcell_r16_ssb_Configuration_r16_Optional(_buffer, _size, _lidx, &p->ssb_Configuration_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_DL_PRS_Info_r16_dl_PRS_ResourceId_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_DL_PRS_Info_r16_dl_PRS_ResourceId_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DL_PRS_Info_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DL_PRS_Info_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->dl_PRS_ID_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->dl_PRS_ResourceSetId_r16, _lidx);
	_serNrSysEncUint8_t_SQN_NR_DL_PRS_Info_r16_dl_PRS_ResourceId_r16_Optional(_buffer, _size, _lidx, &p->dl_PRS_ResourceId_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Value* p, enum SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_ssb_IndexServing_r16) {
		HTON_8(&_buffer[*_lidx], p->ssb_IndexServing_r16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_ssb_Ncell_r16) {
		_serNrSysEncSQN_NR_SSB_InfoNcell_r16(_buffer, _size, _lidx, &p->ssb_Ncell_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_dl_PRS_r16) {
		_serNrSysEncSQN_NR_DL_PRS_Info_r16(_buffer, _size, _lidx, &p->dl_PRS_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_pathlossReferenceRS_Pos_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_pathlossReferenceRS_Pos_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->srs_PosResourceSetId_r16, _lidx);
	_serNrSysEncSQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_PosResourceSet_r16_srs_PosResourceIdList_r16_DynamicOptional(_buffer, _size, _lidx, &p->srs_PosResourceIdList_r16);
	_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_resourceType_r16(_buffer, _size, _lidx, &p->resourceType_r16);
	_serNrSysEncSQN_NR_Alpha_e_SQN_NR_SRS_PosResourceSet_r16_alpha_r16_Optional(_buffer, _size, _lidx, &p->alpha_r16);
	_serNrSysEncInt16_t_SQN_NR_SRS_PosResourceSet_r16_p0_r16_Optional(_buffer, _size, _lidx, &p->p0_r16);
	_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_pathlossReferenceRS_Pos_r16_pathlossReferenceRS_Pos_r16_Optional(_buffer, _size, _lidx, &p->pathlossReferenceRS_Pos_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceSet_r16_SQN_NR_SRS_Config_srs_PosResourceSetToAddModList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceSet_r16_SQN_NR_SRS_Config_srs_PosResourceSetToAddModList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SRS_PosResourceSet_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_Config_srs_PosResourceToReleaseList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_Config_srs_PosResourceToReleaseList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->combOffset_n2_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->cyclicShift_n2_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->combOffset_n4_16, _lidx);
	HTON_8(&_buffer[*_lidx], p->cyclicShift_n4_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->combOffset_n8_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->cyclicShift_n8_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_PosResource_r16_transmissionComb_r16_Value* p, enum SQN_NR_SRS_PosResource_r16_transmissionComb_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16) {
		_serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_n2_r16(_buffer, _size, _lidx, &p->n2_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16) {
		_serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_n4_r16(_buffer, _size, _lidx, &p->n4_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16) {
		_serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_n8_r16(_buffer, _size, _lidx, &p->n8_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_transmissionComb_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_resourceMapping_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_resourceMapping_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->startPosition_r16, _lidx);
	{
		size_t _tmp = (size_t)p->nrofSymbols_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_freqHopping_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_freqHopping_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->c_SRS_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16_slotOffset_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16_slotOffset_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16_slotOffset_r16_Optional(_buffer, _size, _lidx, &p->slotOffset_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PeriodicityAndOffset_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_PeriodicityAndOffset_r16_Value* p, enum SQN_NR_SRS_PeriodicityAndOffset_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl1) {
		HTON_8(&_buffer[*_lidx], p->sl1, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl2) {
		HTON_8(&_buffer[*_lidx], p->sl2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl4) {
		HTON_8(&_buffer[*_lidx], p->sl4, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl5) {
		HTON_8(&_buffer[*_lidx], p->sl5, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl8) {
		HTON_8(&_buffer[*_lidx], p->sl8, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl10) {
		HTON_8(&_buffer[*_lidx], p->sl10, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl16) {
		HTON_8(&_buffer[*_lidx], p->sl16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl20) {
		HTON_8(&_buffer[*_lidx], p->sl20, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl32) {
		HTON_8(&_buffer[*_lidx], p->sl32, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl40) {
		HTON_8(&_buffer[*_lidx], p->sl40, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl64) {
		HTON_8(&_buffer[*_lidx], p->sl64, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl80) {
		HTON_8(&_buffer[*_lidx], p->sl80, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl160) {
		HTON_8(&_buffer[*_lidx], p->sl160, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl320) {
		HTON_16(&_buffer[*_lidx], p->sl320, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl640) {
		HTON_16(&_buffer[*_lidx], p->sl640, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl1280) {
		HTON_16(&_buffer[*_lidx], p->sl1280, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl2560) {
		HTON_16(&_buffer[*_lidx], p->sl2560, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl5120) {
		HTON_16(&_buffer[*_lidx], p->sl5120, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl10240) {
		HTON_16(&_buffer[*_lidx], p->sl10240, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl40960) {
		HTON_16(&_buffer[*_lidx], p->sl40960, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PeriodicityAndOffset_r16_sl81920) {
		HTON_32(&_buffer[*_lidx], p->sl81920, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_PeriodicityAndOffset_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PeriodicityAndOffset_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_PeriodicityAndOffset_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SRS_PeriodicityAndOffset_r16(_buffer, _size, _lidx, &p->periodicityAndOffset_sp_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SRS_PeriodicityAndOffset_r16(_buffer, _size, _lidx, &p->periodicityAndOffset_p_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_PosResource_r16_resourceType_r16_Value* p, enum SQN_NR_SRS_PosResource_r16_resourceType_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16) {
		_serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_aperiodic_r16(_buffer, _size, _lidx, &p->aperiodic_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16) {
		_serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_semi_persistent_r16(_buffer, _size, _lidx, &p->semi_persistent_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16) {
		_serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_periodic_r16(_buffer, _size, _lidx, &p->periodic_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_resourceType_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_servingCellId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_servingCellId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Value* p, enum SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_srs_ResourceId_r16) {
		HTON_8(&_buffer[*_lidx], p->srs_ResourceId_r16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_srs_PosResourceId_r16) {
		HTON_8(&_buffer[*_lidx], p->srs_PosResourceId_r16, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16resourceSelection_r16(_buffer, _size, _lidx, &p->resourceSelection_r16);
	HTON_8(&_buffer[*_lidx], p->uplinkBWP_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Value* p, enum SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_ssb_IndexServing_r16) {
		HTON_8(&_buffer[*_lidx], p->ssb_IndexServing_r16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_csi_RS_IndexServing_r16) {
		HTON_8(&_buffer[*_lidx], p->csi_RS_IndexServing_r16, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16) {
		_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_srs_SpatialRelation_r16(_buffer, _size, _lidx, &p->srs_SpatialRelation_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ServCellIndex_SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_servingCellId_Optional(_buffer, _size, _lidx, &p->servingCellId);
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16_referenceSignal_r16(_buffer, _size, _lidx, &p->referenceSignal_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SRS_SpatialRelationInfoPos_r16_Value* p, enum SQN_NR_SRS_SpatialRelationInfoPos_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16) {
		_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_servingRS_r16(_buffer, _size, _lidx, &p->servingRS_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_ssb_Ncell_r16) {
		_serNrSysEncSQN_NR_SSB_InfoNcell_r16(_buffer, _size, _lidx, &p->ssb_Ncell_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SRS_SpatialRelationInfoPos_r16_dl_PRS_r16) {
		_serNrSysEncSQN_NR_DL_PRS_Info_r16(_buffer, _size, _lidx, &p->dl_PRS_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_SQN_NR_SRS_PosResource_r16_spatialRelationInfoPos_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_SpatialRelationInfoPos_r16_SQN_NR_SRS_PosResource_r16_spatialRelationInfoPos_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->srs_PosResourceId_r16, _lidx);
	_serNrSysEncSQN_NR_SRS_PosResource_r16_transmissionComb_r16(_buffer, _size, _lidx, &p->transmissionComb_r16);
	_serNrSysEncSQN_NR_SRS_PosResource_r16_resourceMapping_r16(_buffer, _size, _lidx, &p->resourceMapping_r16);
	HTON_16(&_buffer[*_lidx], p->freqDomainShift_r16, _lidx);
	_serNrSysEncSQN_NR_SRS_PosResource_r16_freqHopping_r16(_buffer, _size, _lidx, &p->freqHopping_r16);
	{
		size_t _tmp = (size_t)p->groupOrSequenceHopping_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SRS_PosResource_r16_resourceType_r16(_buffer, _size, _lidx, &p->resourceType_r16);
	HTON_16(&_buffer[*_lidx], p->sequenceId_r16, _lidx);
	_serNrSysEncSQN_NR_SRS_SpatialRelationInfoPos_r16_SQN_NR_SRS_PosResource_r16_spatialRelationInfoPos_r16_Optional(_buffer, _size, _lidx, &p->spatialRelationInfoPos_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_PosResource_r16_SQN_NR_SRS_Config_srs_PosResourceToAddModList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_PosResource_r16_SQN_NR_SRS_Config_srs_PosResourceToAddModList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_SRS_PosResource_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SRS_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SRS_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->srs_ResourceSetToReleaseList);
	_serNrSysEncSQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->srs_ResourceSetToAddModList);
	_serNrSysEncSQN_NR_SRS_ResourceId_SQN_NR_SRS_Config_srs_ResourceToReleaseList_DynamicOptional(_buffer, _size, _lidx, &p->srs_ResourceToReleaseList);
	_serNrSysEncSQN_NR_SRS_Resource_SQN_NR_SRS_Config_srs_ResourceToAddModList_DynamicOptional(_buffer, _size, _lidx, &p->srs_ResourceToAddModList);
	_serNrSysEncSQN_NR_SRS_Config_tpc_Accumulation_e_tpc_Accumulation_Optional(_buffer, _size, _lidx, &p->tpc_Accumulation);
	_serNrSysEncUint8_t_SQN_NR_SRS_Config_srs_RequestDCI_1_2_r16_Optional(_buffer, _size, _lidx, &p->srs_RequestDCI_1_2_r16);
	_serNrSysEncUint8_t_SQN_NR_SRS_Config_srs_RequestDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->srs_RequestDCI_0_2_r16);
	_serNrSysEncSQN_NR_SRS_ResourceSet_SQN_NR_SRS_Config_srs_ResourceSetToAddModListDCI_0_2_r16_DynamicOptional(_buffer, _size, _lidx, &p->srs_ResourceSetToAddModListDCI_0_2_r16);
	_serNrSysEncSQN_NR_SRS_ResourceSetId_SQN_NR_SRS_Config_srs_ResourceSetToReleaseListDCI_0_2_r16_DynamicOptional(_buffer, _size, _lidx, &p->srs_ResourceSetToReleaseListDCI_0_2_r16);
	_serNrSysEncSQN_NR_SRS_PosResourceSetId_r16_SQN_NR_SRS_Config_srs_PosResourceSetToReleaseList_r16_DynamicOptional(_buffer, _size, _lidx, &p->srs_PosResourceSetToReleaseList_r16);
	_serNrSysEncSQN_NR_SRS_PosResourceSet_r16_SQN_NR_SRS_Config_srs_PosResourceSetToAddModList_r16_DynamicOptional(_buffer, _size, _lidx, &p->srs_PosResourceSetToAddModList_r16);
	_serNrSysEncSQN_NR_SRS_PosResourceId_r16_SQN_NR_SRS_Config_srs_PosResourceToReleaseList_r16_DynamicOptional(_buffer, _size, _lidx, &p->srs_PosResourceToReleaseList_r16);
	_serNrSysEncSQN_NR_SRS_PosResource_r16_SQN_NR_SRS_Config_srs_PosResourceToAddModList_r16_DynamicOptional(_buffer, _size, _lidx, &p->srs_PosResourceToAddModList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_setup) {
		_serNrSysEncSQN_NR_SRS_Config(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_SQN_NR_BWP_UplinkDedicated_srs_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_SQN_NR_BWP_UplinkDedicated_srs_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BeamFailureRecoveryConfig_rootSequenceIndex_BFR_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BeamFailureRecoveryConfig_rootSequenceIndex_BFR_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigGeneric_SQN_NR_BeamFailureRecoveryConfig_rach_ConfigBFR_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigGeneric_SQN_NR_BeamFailureRecoveryConfig_rach_ConfigBFR_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RACH_ConfigGeneric(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_Range_SQN_NR_BeamFailureRecoveryConfig_rsrp_ThresholdSSB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_Range_SQN_NR_BeamFailureRecoveryConfig_rsrp_ThresholdSSB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BFR_SSB_Resource(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BFR_SSB_Resource* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->ssb, _lidx);
	HTON_8(&_buffer[*_lidx], p->ra_PreambleIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_BFR_CSIRS_Resource_ra_OccasionList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_BFR_CSIRS_Resource_ra_OccasionList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BFR_CSIRS_Resource_ra_PreambleIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BFR_CSIRS_Resource_ra_PreambleIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BFR_CSIRS_Resource(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BFR_CSIRS_Resource* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->csi_RS, _lidx);
	_serNrSysEncUint16_t_SQN_NR_BFR_CSIRS_Resource_ra_OccasionList_DynamicOptional(_buffer, _size, _lidx, &p->ra_OccasionList);
	_serNrSysEncUint8_t_SQN_NR_BFR_CSIRS_Resource_ra_PreambleIndex_Optional(_buffer, _size, _lidx, &p->ra_PreambleIndex);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PRACH_ResourceDedicatedBFR_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PRACH_ResourceDedicatedBFR_Value* p, enum SQN_NR_PRACH_ResourceDedicatedBFR_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PRACH_ResourceDedicatedBFR_ssb) {
		_serNrSysEncSQN_NR_BFR_SSB_Resource(_buffer, _size, _lidx, &p->ssb);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PRACH_ResourceDedicatedBFR_csi_RS) {
		_serNrSysEncSQN_NR_BFR_CSIRS_Resource(_buffer, _size, _lidx, &p->csi_RS);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PRACH_ResourceDedicatedBFR(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PRACH_ResourceDedicatedBFR* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PRACH_ResourceDedicatedBFR_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PRACH_ResourceDedicatedBFR_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PRACH_ResourceDedicatedBFR_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PRACH_ResourceDedicatedBFR(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BeamFailureRecoveryConfig_ra_ssb_OccasionMaskIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BeamFailureRecoveryConfig_ra_ssb_OccasionMaskIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_BeamFailureRecoveryConfig_recoverySearchSpaceId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceId_SQN_NR_BeamFailureRecoveryConfig_recoverySearchSpaceId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_Prioritization_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_Prioritization_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RA_Prioritization(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_beamFailureRecoveryTimer_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_beamFailureRecoveryTimer_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_BeamFailureRecoveryConfig_msg1_SubcarrierSpacing_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SubcarrierSpacing_e_SQN_NR_BeamFailureRecoveryConfig_msg1_SubcarrierSpacing_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_PrioritizationTwoStep_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_PrioritizationTwoStep_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RA_Prioritization(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Value* p, enum SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PRACH_ResourceDedicatedBFR(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BeamFailureRecoveryConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BeamFailureRecoveryConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_BeamFailureRecoveryConfig_rootSequenceIndex_BFR_Optional(_buffer, _size, _lidx, &p->rootSequenceIndex_BFR);
	_serNrSysEncSQN_NR_RACH_ConfigGeneric_SQN_NR_BeamFailureRecoveryConfig_rach_ConfigBFR_Optional(_buffer, _size, _lidx, &p->rach_ConfigBFR);
	_serNrSysEncSQN_NR_RSRP_Range_SQN_NR_BeamFailureRecoveryConfig_rsrp_ThresholdSSB_Optional(_buffer, _size, _lidx, &p->rsrp_ThresholdSSB);
	_serNrSysEncSQN_NR_PRACH_ResourceDedicatedBFR_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSList_DynamicOptional(_buffer, _size, _lidx, &p->candidateBeamRSList);
	_serNrSysEncSQN_NR_BeamFailureRecoveryConfig_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(_buffer, _size, _lidx, &p->ssb_perRACH_Occasion);
	_serNrSysEncUint8_t_SQN_NR_BeamFailureRecoveryConfig_ra_ssb_OccasionMaskIndex_Optional(_buffer, _size, _lidx, &p->ra_ssb_OccasionMaskIndex);
	_serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_BeamFailureRecoveryConfig_recoverySearchSpaceId_Optional(_buffer, _size, _lidx, &p->recoverySearchSpaceId);
	_serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_Prioritization_Optional(_buffer, _size, _lidx, &p->ra_Prioritization);
	_serNrSysEncSQN_NR_BeamFailureRecoveryConfig_beamFailureRecoveryTimer_e_beamFailureRecoveryTimer_Optional(_buffer, _size, _lidx, &p->beamFailureRecoveryTimer);
	_serNrSysEncSQN_NR_SubcarrierSpacing_e_SQN_NR_BeamFailureRecoveryConfig_msg1_SubcarrierSpacing_Optional(_buffer, _size, _lidx, &p->msg1_SubcarrierSpacing);
	_serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_BeamFailureRecoveryConfig_ra_PrioritizationTwoStep_r16_Optional(_buffer, _size, _lidx, &p->ra_PrioritizationTwoStep_r16);
	_serNrSysEncSQN_NR_SetupRelease_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_SQN_NR_BeamFailureRecoveryConfig_candidateBeamRSListExt_v1610_Optional(_buffer, _size, _lidx, &p->candidateBeamRSListExt_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_setup) {
		_serNrSysEncSQN_NR_BeamFailureRecoveryConfig(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_SQN_NR_BWP_UplinkDedicated_beamFailureRecoveryConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_SQN_NR_BWP_UplinkDedicated_beamFailureRecoveryConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_setup) {
		_serNrSysEncSQN_NR_PUCCH_Config(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_SQN_NR_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_SQN_NR_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC3_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC3_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			_serNrSysEncSQN_NR_PUCCH_Config(_buffer, _size, _lidx, &p->setup.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_SQN_NR_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_SQN_NR_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_LBT_FailureRecoveryConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_LBT_FailureRecoveryConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->lbt_FailureInstanceMaxCount_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->lbt_FailureDetectionTimer_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Value* p, enum SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_setup) {
		_serNrSysEncSQN_NR_LBT_FailureRecoveryConfig_r16(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_SQN_NR_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_SQN_NR_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfigToAddModList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToAddModList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfigToAddModList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToAddModList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_ConfiguredGrantConfig(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfigToReleaseList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToReleaseList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfigToReleaseList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToReleaseList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConfiguredGrantConfigType2DeactivationStateList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigType2DeactivationStateList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConfiguredGrantConfigType2DeactivationStateList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigType2DeactivationStateList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i2].d, _lidx);
		for (size_t i3 = 0; i3 < p->v.v[i2].d; i3++) {
			HTON_8(&_buffer[*_lidx], p->v.v[i2].v[i3], _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_UplinkDedicated(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_UplinkDedicated* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_Config_SQN_NR_BWP_UplinkDedicated_pucch_Config_Optional(_buffer, _size, _lidx, &p->pucch_Config);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pusch_Config_SQN_NR_BWP_UplinkDedicated_pusch_Config_Optional(_buffer, _size, _lidx, &p->pusch_Config);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_configuredGrantConfig_SQN_NR_BWP_UplinkDedicated_configuredGrantConfig_Optional(_buffer, _size, _lidx, &p->configuredGrantConfig);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_srs_Config_SQN_NR_BWP_UplinkDedicated_srs_Config_Optional(_buffer, _size, _lidx, &p->srs_Config);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_beamFailureRecoveryConfig_SQN_NR_BWP_UplinkDedicated_beamFailureRecoveryConfig_Optional(_buffer, _size, _lidx, &p->beamFailureRecoveryConfig);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_sl_PUCCH_Config_r16_SQN_NR_BWP_UplinkDedicated_sl_PUCCH_Config_r16_Optional(_buffer, _size, _lidx, &p->sl_PUCCH_Config_r16);
	_serNrSysEncUint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC2_r16_Optional(_buffer, _size, _lidx, &p->cp_ExtensionC2_r16);
	_serNrSysEncUint8_t_SQN_NR_BWP_UplinkDedicated_cp_ExtensionC3_r16_Optional(_buffer, _size, _lidx, &p->cp_ExtensionC3_r16);
	_serNrSysEncSQN_NR_BWP_UplinkDedicated_useInterlacePUCCH_PUSCH_r16_e_useInterlacePUCCH_PUSCH_r16_Optional(_buffer, _size, _lidx, &p->useInterlacePUCCH_PUSCH_r16);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_pucch_ConfigurationList_r16_SQN_NR_BWP_UplinkDedicated_pucch_ConfigurationList_r16_Optional(_buffer, _size, _lidx, &p->pucch_ConfigurationList_r16);
	_serNrSysEncSQN_NR_SetupRelease_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_SQN_NR_BWP_UplinkDedicated_lbt_FailureRecoveryConfig_r16_Optional(_buffer, _size, _lidx, &p->lbt_FailureRecoveryConfig_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfigToAddModList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToAddModList_r16_Optional(_buffer, _size, _lidx, &p->configuredGrantConfigToAddModList_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfigToReleaseList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigToReleaseList_r16_Optional(_buffer, _size, _lidx, &p->configuredGrantConfigToReleaseList_r16);
	_serNrSysEncSQN_NR_ConfiguredGrantConfigType2DeactivationStateList_r16_SQN_NR_BWP_UplinkDedicated_configuredGrantConfigType2DeactivationStateList_r16_Optional(_buffer, _size, _lidx, &p->configuredGrantConfigType2DeactivationStateList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_BWP_UplinkDedicated_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_BWP_UplinkDedicated_Type_Value* p, enum NR_ASN1_BWP_UplinkDedicated_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_BWP_UplinkDedicated_Type_R15) {
		_serNrSysEncSQN_NR_BWP_UplinkDedicated(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_BWP_UplinkDedicated_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_BWP_UplinkDedicated_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_BWP_UplinkDedicated_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_BWP_UplinkDedicated_Type_Dedicated_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_BWP_UplinkDedicated_Type_Dedicated_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_BWP_UplinkDedicated_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_UplinkBWP_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_UplinkBWP_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BWP_Id_NR_UplinkBWP_Type_Id_Optional(_buffer, _size, _lidx, &p->Id);
	_serNrSysEncNR_ASN1_BWP_UplinkCommon_Type_Common_Optional(_buffer, _size, _lidx, &p->Common);
	_serNrSysEncNR_ASN1_BWP_UplinkDedicated_Type_Dedicated_Optional(_buffer, _size, _lidx, &p->Dedicated);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_UplinkBWP_List_Type_BwpArray_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_UplinkBWP_List_Type_BwpArray_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_UplinkBWP_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_UplinkBWPs_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_UplinkBWPs_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_ActiveUplinkBWP_Id_Type_ActiveBWP_Optional(_buffer, _size, _lidx, &p->ActiveBWP);
	_serNrSysEncNR_UplinkBWP_List_Type_BwpArray_Optional(_buffer, _size, _lidx, &p->BwpArray);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_UplinkBWPs_Type_BWPs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_UplinkBWPs_Type_BWPs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_UplinkBWPs_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_occasions(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_occasions* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RACH_ConfigGeneric(_buffer, _size, _lidx, &p->rach_ConfigGeneric);
	_serNrSysEncSQN_NR_CFRA_occasions_ssb_perRACH_Occasion_e_ssb_perRACH_Occasion_Optional(_buffer, _size, _lidx, &p->ssb_perRACH_Occasion);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_occasions_occasions_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_occasions_occasions_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CFRA_occasions(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_CFRA_SSB_Resource_msgA_PUSCH_resource_Index_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_CFRA_SSB_Resource_msgA_PUSCH_resource_Index_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_SSB_Resource(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_SSB_Resource* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->ssb, _lidx);
	HTON_8(&_buffer[*_lidx], p->ra_PreambleIndex, _lidx);
	_serNrSysEncUint16_t_SQN_NR_CFRA_SSB_Resource_msgA_PUSCH_resource_Index_r16_Optional(_buffer, _size, _lidx, &p->msgA_PUSCH_resource_Index_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_resources_ssb(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_resources_ssb* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->ssb_ResourceList.d, _lidx);
	for (size_t i1 = 0; i1 < p->ssb_ResourceList.d; i1++) {
		_serNrSysEncSQN_NR_CFRA_SSB_Resource(_buffer, _size, _lidx, &p->ssb_ResourceList.v[i1]);
	}
	HTON_8(&_buffer[*_lidx], p->ra_ssb_OccasionMaskIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_CSIRS_Resource(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_CSIRS_Resource* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->csi_RS, _lidx);
	HTON_32(&_buffer[*_lidx], p->ra_OccasionList.d, _lidx);
	for (size_t i2 = 0; i2 < p->ra_OccasionList.d; i2++) {
		HTON_16(&_buffer[*_lidx], p->ra_OccasionList.v[i2], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->ra_PreambleIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_resources_csirs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_resources_csirs* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->csirs_ResourceList.d, _lidx);
	for (size_t i1 = 0; i1 < p->csirs_ResourceList.d; i1++) {
		_serNrSysEncSQN_NR_CFRA_CSIRS_Resource(_buffer, _size, _lidx, &p->csirs_ResourceList.v[i1]);
	}
	HTON_8(&_buffer[*_lidx], p->rsrp_ThresholdCSI_RS, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_resources_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_CFRA_resources_Value* p, enum SQN_NR_CFRA_resources_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_CFRA_resources_ssb) {
		_serNrSysEncSQN_NR_CFRA_resources_ssb(_buffer, _size, _lidx, &p->ssb);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_CFRA_resources_csirs) {
		_serNrSysEncSQN_NR_CFRA_resources_csirs(_buffer, _size, _lidx, &p->csirs);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_CFRA_resources(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_resources* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CFRA_resources_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_CFRA_totalNumberOfRA_Preambles_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_CFRA_totalNumberOfRA_Preambles_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_CFRA_occasions_occasions_Optional(_buffer, _size, _lidx, &p->occasions);
	_serNrSysEncSQN_NR_CFRA_resources(_buffer, _size, _lidx, &p->resources);
	_serNrSysEncUint8_t_SQN_NR_CFRA_totalNumberOfRA_Preambles_Optional(_buffer, _size, _lidx, &p->totalNumberOfRA_Preambles);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_SQN_NR_RACH_ConfigDedicated_cfra_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_SQN_NR_RACH_ConfigDedicated_cfra_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CFRA(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_Prioritization_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_Prioritization_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RA_Prioritization(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_PrioritizationTwoStep_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_PrioritizationTwoStep_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_RA_Prioritization(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RACH_ConfigGenericTwoStepRA_r16(_buffer, _size, _lidx, &p->rach_ConfigGenericTwoStepRA_r16);
	{
		size_t _tmp = (size_t)p->ssb_PerRACH_OccasionTwoStepRA_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_occasionsTwoStepRA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_occasionsTwoStepRA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_TwoStep_r16_resourcesTwoStep_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_TwoStep_r16_resourcesTwoStep_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->ssb_ResourceList.d, _lidx);
	for (size_t i1 = 0; i1 < p->ssb_ResourceList.d; i1++) {
		_serNrSysEncSQN_NR_CFRA_SSB_Resource(_buffer, _size, _lidx, &p->ssb_ResourceList.v[i1]);
	}
	HTON_8(&_buffer[*_lidx], p->ra_ssb_OccasionMaskIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_TwoStep_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_TwoStep_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_CFRA_TwoStep_r16_occasionsTwoStepRA_r16_occasionsTwoStepRA_r16_Optional(_buffer, _size, _lidx, &p->occasionsTwoStepRA_r16);
	_serNrSysEncSQN_NR_MsgA_PUSCH_Resource_r16(_buffer, _size, _lidx, &p->msgA_CFRA_PUSCH_r16);
	_serNrSysEncSQN_NR_CFRA_TwoStep_r16_msgA_TransMax_r16_e_msgA_TransMax_r16_Optional(_buffer, _size, _lidx, &p->msgA_TransMax_r16);
	_serNrSysEncSQN_NR_CFRA_TwoStep_r16_resourcesTwoStep_r16(_buffer, _size, _lidx, &p->resourcesTwoStep_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CFRA_TwoStep_r16_SQN_NR_RACH_ConfigDedicated_cfra_TwoStep_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CFRA_TwoStep_r16_SQN_NR_RACH_ConfigDedicated_cfra_TwoStep_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CFRA_TwoStep_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RACH_ConfigDedicated(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RACH_ConfigDedicated* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_CFRA_SQN_NR_RACH_ConfigDedicated_cfra_Optional(_buffer, _size, _lidx, &p->cfra);
	_serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_Prioritization_Optional(_buffer, _size, _lidx, &p->ra_Prioritization);
	_serNrSysEncSQN_NR_RA_Prioritization_SQN_NR_RACH_ConfigDedicated_ra_PrioritizationTwoStep_r16_Optional(_buffer, _size, _lidx, &p->ra_PrioritizationTwoStep_r16);
	_serNrSysEncSQN_NR_CFRA_TwoStep_r16_SQN_NR_RACH_ConfigDedicated_cfra_TwoStep_r16_Optional(_buffer, _size, _lidx, &p->cfra_TwoStep_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_RACH_ConfigDedicated_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_RACH_ConfigDedicated_Type_Value* p, enum NR_ASN1_RACH_ConfigDedicated_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_RACH_ConfigDedicated_Type_R15) {
		_serNrSysEncSQN_NR_RACH_ConfigDedicated(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_RACH_ConfigDedicated_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_RACH_ConfigDedicated_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_RACH_ConfigDedicated_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_RACH_ConfigDedicated_Type_RACH_ConfigDedicated_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_RACH_ConfigDedicated_Type_RACH_ConfigDedicated_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_RACH_ConfigDedicated_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig_rach_OccasionsSI(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig_rach_OccasionsSI* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RACH_ConfigGeneric(_buffer, _size, _lidx, &p->rach_ConfigSI);
	{
		size_t _tmp = (size_t)p->ssb_perRACH_Occasion;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig_rach_OccasionsSI_rach_OccasionsSI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig_rach_OccasionsSI_rach_OccasionsSI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SI_RequestConfig_rach_OccasionsSI(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig_si_RequestPeriod_e_si_RequestPeriod_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig_si_RequestPeriod_e_si_RequestPeriod_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SI_RequestResources_ra_AssociationPeriodIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SI_RequestResources_ra_AssociationPeriodIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SI_RequestResources_ra_ssb_OccasionMaskIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SI_RequestResources_ra_ssb_OccasionMaskIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestResources(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestResources* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->ra_PreambleStartIndex, _lidx);
	_serNrSysEncUint8_t_SQN_NR_SI_RequestResources_ra_AssociationPeriodIndex_Optional(_buffer, _size, _lidx, &p->ra_AssociationPeriodIndex);
	_serNrSysEncUint8_t_SQN_NR_SI_RequestResources_ra_ssb_OccasionMaskIndex_Optional(_buffer, _size, _lidx, &p->ra_ssb_OccasionMaskIndex);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SI_RequestConfig_rach_OccasionsSI_rach_OccasionsSI_Optional(_buffer, _size, _lidx, &p->rach_OccasionsSI);
	_serNrSysEncSQN_NR_SI_RequestConfig_si_RequestPeriod_e_si_RequestPeriod_Optional(_buffer, _size, _lidx, &p->si_RequestPeriod);
	HTON_32(&_buffer[*_lidx], p->si_RequestResources.d, _lidx);
	for (size_t i1 = 0; i1 < p->si_RequestResources.d; i1++) {
		_serNrSysEncSQN_NR_SI_RequestResources(_buffer, _size, _lidx, &p->si_RequestResources.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_SI_RequestConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_SI_RequestConfig_Type_Value* p, enum NR_ASN1_SI_RequestConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_SI_RequestConfig_Type_R15) {
		_serNrSysEncSQN_NR_SI_RequestConfig(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_SI_RequestConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_SI_RequestConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_SI_RequestConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_SI_RequestConfig_Type_SI_RequestConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_SI_RequestConfig_Type_SI_RequestConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_SI_RequestConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_UplinkConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_UplinkConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_ASN1_FrequencyInfoUL_Type_FrequencyInfoUL_Optional(_buffer, _size, _lidx, &p->FrequencyInfoUL);
	_serNrSysEncNR_UplinkBWPs_Type_BWPs_Optional(_buffer, _size, _lidx, &p->BWPs);
	_serNrSysEncNR_ASN1_RACH_ConfigDedicated_Type_RACH_ConfigDedicated_Optional(_buffer, _size, _lidx, &p->RACH_ConfigDedicated);
	_serNrSysEncNR_ASN1_SI_RequestConfig_Type_SI_RequestConfig_Optional(_buffer, _size, _lidx, &p->SI_RequestConfig);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_Uplink_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_Uplink_Type_Value* p, enum NR_Uplink_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_Uplink_Type_Config) {
		_serNrSysEncNR_UplinkConfig_Type(_buffer, _size, _lidx, &p->Config);
		return SIDL_STATUS_OK;
	}
	if (d == NR_Uplink_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_Uplink_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_Uplink_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_Uplink_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_Uplink_Type_Uplink_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_Uplink_Type_Uplink_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_Uplink_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_Uplink_Type_SupplementaryUplink_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_Uplink_Type_SupplementaryUplink_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_Uplink_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SS_TimingAdvanceConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_SS_TimingAdvanceConfig_Type_Value* p, enum NR_SS_TimingAdvanceConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_SS_TimingAdvanceConfig_Type_InitialValue) {
		HTON_16(&_buffer[*_lidx], p->InitialValue, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_SS_TimingAdvanceConfig_Type_Relative) {
		HTON_8(&_buffer[*_lidx], p->Relative, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_SS_TimingAdvanceConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SS_TimingAdvanceConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_SS_TimingAdvanceConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SS_TimingAdvanceConfig_Type_TimingAdvance_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SS_TimingAdvanceConfig_Type_TimingAdvance_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SS_TimingAdvanceConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_CodeBlockGroupTransmission(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_CodeBlockGroupTransmission* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->maxCodeBlockGroupsPerTransportBlock;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Value* p, enum SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_setup) {
		_serNrSysEncSQN_NR_PUSCH_CodeBlockGroupTransmission(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_ServingCellConfig_rateMatching_e_rateMatching_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_ServingCellConfig_rateMatching_e_rateMatching_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_Layers_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_Layers_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncBool_SQN_NR_PUSCH_ServingCellConfig_processingType2Enabled_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_NR_PUSCH_ServingCellConfig_processingType2Enabled_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Value* p, enum SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_setup) {
		HTON_8(&_buffer[*_lidx], p->setup, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PUSCH_ServingCellConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PUSCH_ServingCellConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_codeBlockGroupTransmission_SQN_NR_PUSCH_ServingCellConfig_codeBlockGroupTransmission_Optional(_buffer, _size, _lidx, &p->codeBlockGroupTransmission);
	_serNrSysEncSQN_NR_PUSCH_ServingCellConfig_rateMatching_e_rateMatching_Optional(_buffer, _size, _lidx, &p->rateMatching);
	_serNrSysEncSQN_NR_PUSCH_ServingCellConfig_xOverhead_e_xOverhead_Optional(_buffer, _size, _lidx, &p->xOverhead);
	_serNrSysEncUint8_t_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_Layers_Optional(_buffer, _size, _lidx, &p->maxMIMO_Layers);
	_serNrSysEncBool_SQN_NR_PUSCH_ServingCellConfig_processingType2Enabled_Optional(_buffer, _size, _lidx, &p->processingType2Enabled);
	_serNrSysEncSQN_NR_SetupRelease_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_SQN_NR_PUSCH_ServingCellConfig_maxMIMO_LayersDCI_0_2_r16_Optional(_buffer, _size, _lidx, &p->maxMIMO_LayersDCI_0_2_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_ASN1_PUSCH_ServingCellConfig_Type_Value* p, enum NR_ASN1_PUSCH_ServingCellConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_ASN1_PUSCH_ServingCellConfig_Type_R15) {
		_serNrSysEncSQN_NR_PUSCH_ServingCellConfig(_buffer, _size, _lidx, &p->R15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PUSCH_ServingCellConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfigSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfigSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayerUplink_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayerUplink_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_Uplink_Type_Uplink_Optional(_buffer, _size, _lidx, &p->Uplink);
	_serNrSysEncNR_Uplink_Type_SupplementaryUplink_Optional(_buffer, _size, _lidx, &p->SupplementaryUplink);
	_serNrSysEncNR_SS_TimingAdvanceConfig_Type_TimingAdvance_Optional(_buffer, _size, _lidx, &p->TimingAdvance);
	_serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfig_Optional(_buffer, _size, _lidx, &p->PUSCH_ServingCellConfig);
	_serNrSysEncNR_ASN1_PUSCH_ServingCellConfig_Type_PUSCH_ServingCellConfigSUL_Optional(_buffer, _size, _lidx, &p->PUSCH_ServingCellConfigSUL);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayerUplink_Type_Uplink_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayerUplink_Type_Uplink_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CellConfigPhysicalLayerUplink_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayer_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayer_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_CellConfigPhysicalLayerCommon_Type_Common_Optional(_buffer, _size, _lidx, &p->Common);
	_serNrSysEncNR_CellConfigPhysicalLayerDownlink_Type_Downlink_Optional(_buffer, _size, _lidx, &p->Downlink);
	_serNrSysEncNR_CellConfigPhysicalLayerUplink_Type_Uplink_Optional(_buffer, _size, _lidx, &p->Uplink);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_CellConfigPhysicalLayer_Type_PhysicalLayer_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_CellConfigPhysicalLayer_Type_PhysicalLayer_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_CellConfigPhysicalLayer_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BcchToPbchConfig_Type_Pbch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BcchToPbchConfig_Type_Pbch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNull_Type_ActiveBWP_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Null_Type_ActiveBWP_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNull_Type_InitialBWP_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Null_Type_InitialBWP_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_AssignedBWPs_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_AssignedBWPs_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNull_Type_ActiveBWP_Optional(_buffer, _size, _lidx, &p->ActiveBWP);
	_serNrSysEncNull_Type_InitialBWP_Optional(_buffer, _size, _lidx, &p->InitialBWP);
	HTON_32(&_buffer[*_lidx], p->DedicatedBWPs.d, _lidx);
	for (size_t i1 = 0; i1 < p->DedicatedBWPs.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->DedicatedBWPs.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_AssignedBWPs_Type_NR_SearchSpaceDlDciAssignment_Type_AssignedBWPs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_AssignedBWPs_Type_NR_SearchSpaceDlDciAssignment_Type_AssignedBWPs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_AssignedBWPs_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceType_Type_NR_SearchSpaceDlDciAssignment_Type_SearchSpaceType_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceType_Type_NR_SearchSpaceDlDciAssignment_Type_SearchSpaceType_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ResourceAllocationType_Type_NR_DciFormat_1_X_ResourceAssignment_Type_ResourceAllocationType_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ResourceAllocationType_Type_NR_DciFormat_1_X_ResourceAssignment_Type_ResourceAllocationType_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_FreqDomainSchedulCommonDL_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_FreqDomainSchedulCommonDL_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->FirstRbIndex, _lidx);
	HTON_32(&_buffer[*_lidx], p->MaxRbCnt, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_FreqDomainSchedulExplicit_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_FreqDomainSchedulExplicit_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->FirstRbIndex, _lidx);
	HTON_32(&_buffer[*_lidx], p->Nprb, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_FreqDomainResourceAssignmentDL_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_FreqDomainResourceAssignmentDL_Type_Value* p, enum NR_FreqDomainResourceAssignmentDL_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_FreqDomainResourceAssignmentDL_Type_Automatic) {
		_serNrSysEncNR_FreqDomainSchedulCommonDL_Type(_buffer, _size, _lidx, &p->Automatic);
		return SIDL_STATUS_OK;
	}
	if (d == NR_FreqDomainResourceAssignmentDL_Type_Explicit) {
		_serNrSysEncNR_FreqDomainSchedulExplicit_Type(_buffer, _size, _lidx, &p->Explicit);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_FreqDomainResourceAssignmentDL_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_FreqDomainResourceAssignmentDL_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_FreqDomainResourceAssignmentDL_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_FreqDomainResourceAssignmentDL_Type_FreqDomain_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_FreqDomainResourceAssignmentDL_Type_FreqDomain_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_FreqDomainResourceAssignmentDL_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciCommon_TimeDomainResourceAssignment_Type_Value* p, enum NR_DciCommon_TimeDomainResourceAssignment_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciCommon_TimeDomainResourceAssignment_Type_Index) {
		HTON_32(&_buffer[*_lidx], p->Index.d, _lidx);
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_TimeDomainResourceAssignment_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_1_X_ResourceAssignment_Type_TimeDomain_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_1_X_ResourceAssignment_Type_TimeDomain_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ModulationSchemePDSCH_Type_TransportBlock2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ModulationSchemePDSCH_Type_TransportBlock2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RedundancyVersionList_Type_RedundancyVersionList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RedundancyVersionList_Type_RedundancyVersionList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TransportBlockSchedulingDL_Automatic_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TransportBlockSchedulingDL_Automatic_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->TransportBlock1;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_ModulationSchemePDSCH_Type_TransportBlock2_Optional(_buffer, _size, _lidx, &p->TransportBlock2);
	_serNrSysEncNR_RedundancyVersionList_Type_RedundancyVersionList_Optional(_buffer, _size, _lidx, &p->RedundancyVersionList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncRetransmissionTiming_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union RetransmissionTiming_Type_Value* p, enum RetransmissionTiming_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == RetransmissionTiming_Type_SlotOffset) {
		HTON_32(&_buffer[*_lidx], p->SlotOffset, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == RetransmissionTiming_Type_SubframeOffset) {
		HTON_32(&_buffer[*_lidx], p->SubframeOffset, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == RetransmissionTiming_Type_AnyTime) {
		HTON_8(&_buffer[*_lidx], p->AnyTime, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncRetransmissionTiming_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RetransmissionTiming_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncRetransmissionTiming_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncTransmissionTimingOffset_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union TransmissionTimingOffset_Type_Value* p, enum TransmissionTimingOffset_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == TransmissionTimingOffset_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == TransmissionTimingOffset_Type_Retransmission) {
		_serNrSysEncRetransmissionTiming_Type(_buffer, _size, _lidx, &p->Retransmission);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncTransmissionTimingOffset_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct TransmissionTimingOffset_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncTransmissionTimingOffset_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TransportBlockSingleTransmission_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TransportBlockSingleTransmission_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncTransmissionTimingOffset_Type(_buffer, _size, _lidx, &p->TimingOffset);
	HTON_8(&_buffer[*_lidx], p->ImcsValue, _lidx);
	HTON_8(&_buffer[*_lidx], p->RedundancyVersion, _lidx);
	HTON_8(&_buffer[*_lidx], p->ToggleNDI, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TransportBlockRetransmissionList_Type_TransportBlock2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TransportBlockRetransmissionList_Type_TransportBlock2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_TransportBlockSingleTransmission_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TransportBlockSchedulingDL_Explicit_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TransportBlockSchedulingDL_Explicit_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->TransportBlock1.d, _lidx);
	for (size_t i1 = 0; i1 < p->TransportBlock1.d; i1++) {
		_serNrSysEncNR_TransportBlockSingleTransmission_Type(_buffer, _size, _lidx, &p->TransportBlock1.v[i1]);
	}
	_serNrSysEncNR_TransportBlockRetransmissionList_Type_TransportBlock2_Optional(_buffer, _size, _lidx, &p->TransportBlock2);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TransportBlockSchedulingDL_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_TransportBlockSchedulingDL_Type_Value* p, enum NR_TransportBlockSchedulingDL_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_TransportBlockSchedulingDL_Type_Automatic) {
		_serNrSysEncNR_TransportBlockSchedulingDL_Automatic_Type(_buffer, _size, _lidx, &p->Automatic);
		return SIDL_STATUS_OK;
	}
	if (d == NR_TransportBlockSchedulingDL_Type_Explicit) {
		_serNrSysEncNR_TransportBlockSchedulingDL_Explicit_Type(_buffer, _size, _lidx, &p->Explicit);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_TransportBlockSchedulingDL_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TransportBlockSchedulingDL_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_TransportBlockSchedulingDL_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TransportBlockSchedulingDL_Type_TransportBlockScheduling_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TransportBlockSchedulingDL_Type_TransportBlockScheduling_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_TransportBlockSchedulingDL_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_HarqProcessConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_HarqProcessConfig_Type_Value* p, enum NR_HarqProcessConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_HarqProcessConfig_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_HarqProcessConfig_Type_Broadcast) {
		HTON_8(&_buffer[*_lidx], p->Broadcast, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_HarqProcessConfig_Type_AnyProcess) {
		HTON_8(&_buffer[*_lidx], p->AnyProcess, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_HarqProcessConfig_Type_SpecificSubset) {
		HTON_32(&_buffer[*_lidx], p->SpecificSubset.d, _lidx);
		for (size_t i1 = 0; i1 < p->SpecificSubset.d; i1++) {
			HTON_32(&_buffer[*_lidx], p->SpecificSubset.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_HarqProcessConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_HarqProcessConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_HarqProcessConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_HarqProcessConfig_Type_NR_DciFormat_1_X_ResourceAssignment_Type_HarqProcessConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_HarqProcessConfig_Type_NR_DciFormat_1_X_ResourceAssignment_Type_HarqProcessConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_HarqProcessConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_ResourceAssignment_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_ResourceAssignment_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_ResourceAllocationType_Type_NR_DciFormat_1_X_ResourceAssignment_Type_ResourceAllocationType_Optional(_buffer, _size, _lidx, &p->ResourceAllocationType);
	_serNrSysEncNR_FreqDomainResourceAssignmentDL_Type_FreqDomain_Optional(_buffer, _size, _lidx, &p->FreqDomain);
	_serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_1_X_ResourceAssignment_Type_TimeDomain_Optional(_buffer, _size, _lidx, &p->TimeDomain);
	_serNrSysEncNR_TransportBlockSchedulingDL_Type_TransportBlockScheduling_Optional(_buffer, _size, _lidx, &p->TransportBlockScheduling);
	_serNrSysEncNR_HarqProcessConfig_Type_NR_DciFormat_1_X_ResourceAssignment_Type_HarqProcessConfig_Optional(_buffer, _size, _lidx, &p->HarqProcessConfig);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_ResourceAssignment_Type_ResoureAssignment_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_ResourceAssignment_Type_ResoureAssignment_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_X_ResourceAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_VrbPrbMapping_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciCommon_VrbPrbMapping_Type_Value* p, enum NR_DciCommon_VrbPrbMapping_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciCommon_VrbPrbMapping_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciCommon_VrbPrbMapping_Type_Index) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciCommon_VrbPrbMapping_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_VrbPrbMapping_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciCommon_VrbPrbMapping_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_VrbPrbMapping_Type_VrbPrbMapping_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_VrbPrbMapping_Type_VrbPrbMapping_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_VrbPrbMapping_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncDAI_B2_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union DAI_B2_Type_Value* p, enum DAI_B2_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == DAI_B2_Type_Index) {
		for (size_t i1 = 0; i1 < 2; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == DAI_B2_Type_Automatic) {
		HTON_8(&_buffer[*_lidx], p->Automatic, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncDAI_B2_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DAI_B2_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncDAI_B2_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_DAI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_0_DAI_Type_Value* p, enum NR_DciFormat_1_0_DAI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_0_DAI_Type_Index) {
		_serNrSysEncDAI_B2_Type(_buffer, _size, _lidx, &p->Index);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_0_DAI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_DAI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_0_DAI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_DAI_Type_DAI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_DAI_Type_DAI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_0_DAI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_TpcCommand_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciCommon_TpcCommand_Type_Value* p, enum NR_DciCommon_TpcCommand_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciCommon_TpcCommand_Type_Value) {
		for (size_t i1 = 0; i1 < 2; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciCommon_TpcCommand_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_TpcCommand_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciCommon_TpcCommand_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_TpcCommand_Type_NR_DciFormat_1_0_SpecificInfo_Type_TpcCommandPucch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_0_SpecificInfo_Type_TpcCommandPucch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_TpcCommand_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_X_PucchResourceIndicator_Type_Value* p, enum NR_DciFormat_1_X_PucchResourceIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_X_PucchResourceIndicator_Type_Value) {
		for (size_t i1 = 0; i1 < 3; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_PucchResourceIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PucchResourceIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PucchResourceIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value* p, enum NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value) {
		HTON_32(&_buffer[*_lidx], p->Value.d, _lidx);
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_PdschHarqTimingIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PdschHarqTimingIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_X_0_ChannelAccessCPext_Type_Value* p, enum NR_DciFormat_X_0_ChannelAccessCPext_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_X_0_ChannelAccessCPext_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_X_0_ChannelAccessCPext_Type_Value) {
		for (size_t i1 = 0; i1 < 2; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_0_ChannelAccessCPext_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_1_0_SpecificInfo_Type_ChannelAccessCPext_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_1_0_SpecificInfo_Type_ChannelAccessCPext_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_DciFormat_1_0_DAI_Type_DAI_Optional(_buffer, _size, _lidx, &p->DAI);
	_serNrSysEncNR_DciCommon_TpcCommand_Type_NR_DciFormat_1_0_SpecificInfo_Type_TpcCommandPucch_Optional(_buffer, _size, _lidx, &p->TpcCommandPucch);
	_serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PucchResourceIndicator_Optional(_buffer, _size, _lidx, &p->PucchResourceIndicator);
	_serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_0_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(_buffer, _size, _lidx, &p->PdschHarqTimingIndicator);
	_serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_1_0_SpecificInfo_Type_ChannelAccessCPext_Optional(_buffer, _size, _lidx, &p->ChannelAccessCPext);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessageIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessageIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 2; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB8_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessages_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B8_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessages_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 8; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_TbScaling_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_TbScaling_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 2; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_P_RNTI_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncB2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessageIndicator_Optional(_buffer, _size, _lidx, &p->ShortMessageIndicator);
	_serNrSysEncB8_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_ShortMessages_Optional(_buffer, _size, _lidx, &p->ShortMessages);
	_serNrSysEncB2_Type_NR_DciFormat_1_0_P_RNTI_SpecificInfo_Type_TbScaling_Optional(_buffer, _size, _lidx, &p->TbScaling);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB1_Type_NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type_SystemInfoIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B1_Type_NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type_SystemInfoIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 1; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncB1_Type_NR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type_SystemInfoIndicator_Optional(_buffer, _size, _lidx, &p->SystemInfoIndicator);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB2_Type_NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type_TbScaling_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B2_Type_NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type_TbScaling_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 2; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_LSBsOfSFN_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_0_LSBsOfSFN_Type_Value* p, enum NR_DciFormat_1_0_LSBsOfSFN_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_0_LSBsOfSFN_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_0_LSBsOfSFN_Type_Automatic) {
		HTON_8(&_buffer[*_lidx], p->Automatic, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_0_LSBsOfSFN_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_LSBsOfSFN_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_0_LSBsOfSFN_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_LSBsOfSFN_Type_LSBsOfSFN_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_LSBsOfSFN_Type_LSBsOfSFN_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_0_LSBsOfSFN_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncB2_Type_NR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type_TbScaling_Optional(_buffer, _size, _lidx, &p->TbScaling);
	_serNrSysEncNR_DciFormat_1_0_LSBsOfSFN_Type_LSBsOfSFN_Optional(_buffer, _size, _lidx, &p->LSBsOfSFN);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_CarrierIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciCommon_CarrierIndicator_Type_Value* p, enum NR_DciCommon_CarrierIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciCommon_CarrierIndicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciCommon_CarrierIndicator_Type_CellIndex) {
		for (size_t i1 = 0; i1 < 3; i1++) {
			HTON_8(&_buffer[*_lidx], p->CellIndex[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciCommon_CarrierIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_CarrierIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciCommon_CarrierIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_CarrierIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_CarrierIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_CarrierIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_CarrierIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_CarrierIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_BWPIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciCommon_BWPIndicator_Type_Value* p, enum NR_DciCommon_BWPIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciCommon_BWPIndicator_Type_Index) {
		HTON_32(&_buffer[*_lidx], p->Index.d, _lidx);
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciCommon_BWPIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_BWPIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciCommon_BWPIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_BWPIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_BWPIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_BWPIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_BWPIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_BWPIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Value* p, enum NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Dynamic) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Dynamic[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_PrbBundlingSizeIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_PrbBundlingSizeIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_PrbBundlingSizeIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_PrbBundlingSizeIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_RateMatchingIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_RateMatchingIndicator_Type_Value* p, enum NR_DciFormat_1_1_RateMatchingIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_RateMatchingIndicator_Type_Bitmap) {
		HTON_32(&_buffer[*_lidx], p->Bitmap.d, _lidx);
		for (size_t i1 = 0; i1 < p->Bitmap.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Bitmap.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_RateMatchingIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_RateMatchingIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_RateMatchingIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_RateMatchingIndicator_Type_RateMatchingIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_RateMatchingIndicator_Type_RateMatchingIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_RateMatchingIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Value* p, enum NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Index) {
		HTON_32(&_buffer[*_lidx], p->Index.d, _lidx);
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_ZP_CSI_RS_Trigger_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_ZP_CSI_RS_Trigger_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncDAI_B4_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union DAI_B4_Type_Value* p, enum DAI_B4_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == DAI_B4_Type_Index) {
		for (size_t i1 = 0; i1 < 4; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == DAI_B4_Type_Automatic) {
		HTON_8(&_buffer[*_lidx], p->Automatic, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncDAI_B4_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DAI_B4_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncDAI_B4_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncDAI_B6_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union DAI_B6_Type_Value* p, enum DAI_B6_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == DAI_B6_Type_Index) {
		for (size_t i1 = 0; i1 < 6; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == DAI_B6_Type_Automatic) {
		HTON_8(&_buffer[*_lidx], p->Automatic, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncDAI_B6_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DAI_B6_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncDAI_B6_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_DAI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_DAI_Type_Value* p, enum NR_DciFormat_1_1_DAI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_DAI_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_DAI_Type_TwoBits) {
		_serNrSysEncDAI_B2_Type(_buffer, _size, _lidx, &p->TwoBits);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_DAI_Type_FourBits) {
		_serNrSysEncDAI_B4_Type(_buffer, _size, _lidx, &p->FourBits);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_DAI_Type_SixBits) {
		_serNrSysEncDAI_B6_Type(_buffer, _size, _lidx, &p->SixBits);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_DAI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_DAI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_DAI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_DAI_Type_DAI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_DAI_Type_DAI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_DAI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_TpcCommand_Type_NR_DciFormat_1_1_SpecificInfo_Type_TpcCommandPucch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_TpcCommand_Type_NR_DciFormat_1_1_SpecificInfo_Type_TpcCommandPucch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_TpcCommand_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PucchResourceIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PucchResourceIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PdschHarqTimingIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value* p, enum NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_OneShotHarqAckRequest_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_OneShotHarqAckRequest_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_OneShotHarqAckRequest_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_OneShotHarqAckRequest_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_OneShotHarqAckRequest_Type_OneShotHarqAckRequest_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_OneShotHarqAckRequest_Type_OneShotHarqAckRequest_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_OneShotHarqAckRequest_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_PdschGroupIndex_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_PdschGroupIndex_Type_Value* p, enum NR_DciFormat_1_1_PdschGroupIndex_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_PdschGroupIndex_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_PdschGroupIndex_Type_Value) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_PdschGroupIndex_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_PdschGroupIndex_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_PdschGroupIndex_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_PdschGroupIndex_Type_PdschGroupIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_PdschGroupIndex_Type_PdschGroupIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_PdschGroupIndex_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_NewFeedbackIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_NewFeedbackIndicator_Type_Value* p, enum NR_DciFormat_1_1_NewFeedbackIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_NewFeedbackIndicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_NewFeedbackIndicator_Type_Value) {
		HTON_32(&_buffer[*_lidx], p->Value.d, _lidx);
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_NewFeedbackIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_NewFeedbackIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_NewFeedbackIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_NewFeedbackIndicator_Type_NewFeedbackIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_NewFeedbackIndicator_Type_NewFeedbackIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_NewFeedbackIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value* p, enum NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_NumberRequestedPdschGroup_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_NumberRequestedPdschGroup_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_NumberRequestedPdschGroup_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_NumberRequestedPdschGroup_Type_NumberRequestedPdschGroup_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_NumberRequestedPdschGroup_Type_NumberRequestedPdschGroup_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_NumberRequestedPdschGroup_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_AntennaPorts_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_AntennaPorts_Type_Value* p, enum NR_DciFormat_1_1_AntennaPorts_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_AntennaPorts_Type_Index) {
		HTON_32(&_buffer[*_lidx], p->Index.d, _lidx);
		for (size_t i1 = 0; i1 < p->Index.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Index.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_AntennaPorts_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_AntennaPorts_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_AntennaPorts_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_AntennaPorts_Type_AntennaPorts_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_AntennaPorts_Type_AntennaPorts_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_AntennaPorts_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_TCI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_TCI_Type_Value* p, enum NR_DciFormat_1_1_TCI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_TCI_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_TCI_Type_Value) {
		for (size_t i1 = 0; i1 < 3; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_TCI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_TCI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_TCI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_TCI_Type_TCI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_TCI_Type_TCI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_TCI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_SrsRequest_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_X_1_SrsRequest_Type_Value* p, enum NR_DciFormat_X_1_SrsRequest_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_X_1_SrsRequest_Type_SingleUL) {
		for (size_t i1 = 0; i1 < 2; i1++) {
			HTON_8(&_buffer[*_lidx], p->SingleUL[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_X_1_SrsRequest_Type_UL_SUL) {
		for (size_t i1 = 0; i1 < 3; i1++) {
			HTON_8(&_buffer[*_lidx], p->UL_SUL[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_X_1_SrsRequest_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_SrsRequest_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_X_1_SrsRequest_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_1_1_SpecificInfo_Type_SrsRequest_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_1_1_SpecificInfo_Type_SrsRequest_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_SrsRequest_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_CBGTI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_CBGTI_Type_Value* p, enum NR_DciFormat_1_1_CBGTI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_CBGTI_Type_Bitmap) {
		HTON_32(&_buffer[*_lidx], p->Bitmap.d, _lidx);
		for (size_t i1 = 0; i1 < p->Bitmap.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Bitmap.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_CBGTI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_CBGTI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_CBGTI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_CBGTI_Type_CBGTI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_CBGTI_Type_CBGTI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_CBGTI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_CBGFI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_CBGFI_Type_Value* p, enum NR_DciFormat_1_1_CBGFI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_CBGFI_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_CBGFI_Type_Flag) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Flag[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_CBGFI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_CBGFI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_CBGFI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_CBGFI_Type_CBGFI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_CBGFI_Type_CBGFI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_CBGFI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_X_1_DmrsSequenceInit_Type_Value* p, enum NR_DciFormat_X_1_DmrsSequenceInit_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_X_1_DmrsSequenceInit_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_X_1_DmrsSequenceInit_Type_Value) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_DmrsSequenceInit_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_1_1_SpecificInfo_Type_DmrsSequenceInit_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_1_1_SpecificInfo_Type_DmrsSequenceInit_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_X_1_PriorityIndicator_Type_Value* p, enum NR_DciFormat_X_1_PriorityIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_X_1_PriorityIndicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_X_1_PriorityIndicator_Type_Value) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_PriorityIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PriorityIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PriorityIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_ChannelAccessCPext_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_1_ChannelAccessCPext_Type_Value* p, enum NR_DciFormat_1_1_ChannelAccessCPext_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_1_ChannelAccessCPext_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_1_ChannelAccessCPext_Type_Value) {
		HTON_32(&_buffer[*_lidx], p->Value.d, _lidx);
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_1_ChannelAccessCPext_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_ChannelAccessCPext_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_1_ChannelAccessCPext_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_ChannelAccessCPext_Type_ChannelAccessCPext_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_ChannelAccessCPext_Type_ChannelAccessCPext_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_1_ChannelAccessCPext_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value* p, enum NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value) {
		for (size_t i1 = 0; i1 < 1; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_1_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_1_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_X_1_SCellDormancyIndication_Type_Value* p, enum NR_DciFormat_X_1_SCellDormancyIndication_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_X_1_SCellDormancyIndication_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_X_1_SCellDormancyIndication_Type_Value) {
		HTON_32(&_buffer[*_lidx], p->Value.d, _lidx);
		for (size_t i1 = 0; i1 < p->Value.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->Value.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_SCellDormancyIndication_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_1_1_SpecificInfo_Type_SCellDormancyIndication_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_1_1_SpecificInfo_Type_SCellDormancyIndication_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_1_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_1_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_DciCommon_CarrierIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_CarrierIndicator_Optional(_buffer, _size, _lidx, &p->CarrierIndicator);
	_serNrSysEncNR_DciCommon_BWPIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_BWPIndicator_Optional(_buffer, _size, _lidx, &p->BWPIndicator);
	_serNrSysEncNR_DciFormat_1_1_PrbBundlingSizeIndicator_Type_PrbBundlingSizeIndicator_Optional(_buffer, _size, _lidx, &p->PrbBundlingSizeIndicator);
	_serNrSysEncNR_DciFormat_1_1_RateMatchingIndicator_Type_RateMatchingIndicator_Optional(_buffer, _size, _lidx, &p->RateMatchingIndicator);
	_serNrSysEncNR_DciFormat_1_1_ZP_CSI_RS_Trigger_Type_ZP_CSI_RS_Trigger_Optional(_buffer, _size, _lidx, &p->ZP_CSI_RS_Trigger);
	_serNrSysEncNR_DciFormat_1_1_DAI_Type_DAI_Optional(_buffer, _size, _lidx, &p->DAI);
	_serNrSysEncNR_DciCommon_TpcCommand_Type_NR_DciFormat_1_1_SpecificInfo_Type_TpcCommandPucch_Optional(_buffer, _size, _lidx, &p->TpcCommandPucch);
	_serNrSysEncNR_DciFormat_1_X_PucchResourceIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PucchResourceIndicator_Optional(_buffer, _size, _lidx, &p->PucchResourceIndicator);
	_serNrSysEncNR_DciFormat_1_X_PdschHarqTimingIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PdschHarqTimingIndicator_Optional(_buffer, _size, _lidx, &p->PdschHarqTimingIndicator);
	_serNrSysEncNR_DciFormat_1_1_OneShotHarqAckRequest_Type_OneShotHarqAckRequest_Optional(_buffer, _size, _lidx, &p->OneShotHarqAckRequest);
	_serNrSysEncNR_DciFormat_1_1_PdschGroupIndex_Type_PdschGroupIndex_Optional(_buffer, _size, _lidx, &p->PdschGroupIndex);
	_serNrSysEncNR_DciFormat_1_1_NewFeedbackIndicator_Type_NewFeedbackIndicator_Optional(_buffer, _size, _lidx, &p->NewFeedbackIndicator);
	_serNrSysEncNR_DciFormat_1_1_NumberRequestedPdschGroup_Type_NumberRequestedPdschGroup_Optional(_buffer, _size, _lidx, &p->NumberRequestedPdschGroup);
	_serNrSysEncNR_DciFormat_1_1_AntennaPorts_Type_AntennaPorts_Optional(_buffer, _size, _lidx, &p->AntennaPorts);
	_serNrSysEncNR_DciFormat_1_1_TCI_Type_TCI_Optional(_buffer, _size, _lidx, &p->TCI);
	_serNrSysEncNR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_1_1_SpecificInfo_Type_SrsRequest_Optional(_buffer, _size, _lidx, &p->SrsRequest);
	_serNrSysEncNR_DciFormat_1_1_CBGTI_Type_CBGTI_Optional(_buffer, _size, _lidx, &p->CBGTI);
	_serNrSysEncNR_DciFormat_1_1_CBGFI_Type_CBGFI_Optional(_buffer, _size, _lidx, &p->CBGFI);
	_serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_1_1_SpecificInfo_Type_DmrsSequenceInit_Optional(_buffer, _size, _lidx, &p->DmrsSequenceInit);
	_serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_1_1_SpecificInfo_Type_PriorityIndicator_Optional(_buffer, _size, _lidx, &p->PriorityIndicator);
	_serNrSysEncNR_DciFormat_1_1_ChannelAccessCPext_Type_ChannelAccessCPext_Optional(_buffer, _size, _lidx, &p->ChannelAccessCPext);
	_serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_1_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional(_buffer, _size, _lidx, &p->MinimumApplicableSchedulingOffset);
	_serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_1_1_SpecificInfo_Type_SCellDormancyIndication_Optional(_buffer, _size, _lidx, &p->SCellDormancyIndication);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_SpecificInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_1_X_SpecificInfo_Type_Value* p, enum NR_DciFormat_1_X_SpecificInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0) {
		_serNrSysEncNR_DciFormat_1_0_SpecificInfo_Type(_buffer, _size, _lidx, &p->Format_1_0);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0_P_RNTI) {
		_serNrSysEncNR_DciFormat_1_0_P_RNTI_SpecificInfo_Type(_buffer, _size, _lidx, &p->Format_1_0_P_RNTI);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0_SI_RNTI) {
		_serNrSysEncNR_DciFormat_1_0_SI_RNTI_SpecificInfo_Type(_buffer, _size, _lidx, &p->Format_1_0_SI_RNTI);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_0_RA_RNTI) {
		_serNrSysEncNR_DciFormat_1_0_RA_RNTI_SpecificInfo_Type(_buffer, _size, _lidx, &p->Format_1_0_RA_RNTI);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_1_X_SpecificInfo_Type_Format_1_1) {
		_serNrSysEncNR_DciFormat_1_1_SpecificInfo_Type(_buffer, _size, _lidx, &p->Format_1_1);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_1_X_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_1_X_SpecificInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_1_X_SpecificInfo_Type_Format_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_1_X_SpecificInfo_Type_Format_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_1_X_SpecificInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciDlInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciDlInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_DciFormat_1_X_ResourceAssignment_Type_ResoureAssignment_Optional(_buffer, _size, _lidx, &p->ResoureAssignment);
	_serNrSysEncNR_DciCommon_VrbPrbMapping_Type_VrbPrbMapping_Optional(_buffer, _size, _lidx, &p->VrbPrbMapping);
	_serNrSysEncNR_DciFormat_1_X_SpecificInfo_Type_Format_Optional(_buffer, _size, _lidx, &p->Format);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciDlInfo_Type_DciInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciDlInfo_Type_DciInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciDlInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceDlDciAssignment_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceDlDciAssignment_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_AssignedBWPs_Type_NR_SearchSpaceDlDciAssignment_Type_AssignedBWPs_Optional(_buffer, _size, _lidx, &p->AssignedBWPs);
	_serNrSysEncNR_SearchSpaceType_Type_NR_SearchSpaceDlDciAssignment_Type_SearchSpaceType_Optional(_buffer, _size, _lidx, &p->SearchSpaceType);
	_serNrSysEncNR_DciDlInfo_Type_DciInfo_Optional(_buffer, _size, _lidx, &p->DciInfo);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_Sib1Schedul_Type_SearchSpaceAndDci_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceDlDciAssignment_Type_NR_Sib1Schedul_Type_SearchSpaceAndDci_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_Sib1Schedul_Type_Periodicity_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_Sib1Schedul_Type_Periodicity_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncIntegerList_Type_SlotOffsetList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct IntegerList_Type_SlotOffsetList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_Sib1Schedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_Sib1Schedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_Sib1Schedul_Type_SearchSpaceAndDci_Optional(_buffer, _size, _lidx, &p->SearchSpaceAndDci);
	_serNrSysEncInt32_t_NR_Sib1Schedul_Type_Periodicity_Optional(_buffer, _size, _lidx, &p->Periodicity);
	_serNrSysEncIntegerList_Type_SlotOffsetList_Optional(_buffer, _size, _lidx, &p->SlotOffsetList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_Sib1Schedul_Type_Sib1Schedul_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_Sib1Schedul_Type_Sib1Schedul_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_Sib1Schedul_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SiWindowLength_Type_WindowLength_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SiWindowLength_Type_WindowLength_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SiPeriodicity_Type_Periodicity_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SiPeriodicity_Type_Periodicity_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_SingleSiSchedul_Type_SearchSpaceAndDci_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceDlDciAssignment_Type_NR_SingleSiSchedul_Type_SearchSpaceAndDci_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt32_t_NR_SingleSiSchedul_Type_SlotOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_NR_SingleSiSchedul_Type_SlotOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SingleSiSchedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SingleSiSchedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_SingleSiSchedul_Type_SearchSpaceAndDci_Optional(_buffer, _size, _lidx, &p->SearchSpaceAndDci);
	_serNrSysEncInt32_t_NR_SingleSiSchedul_Type_SlotOffset_Optional(_buffer, _size, _lidx, &p->SlotOffset);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SingleSiSchedul_Type_Window_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SingleSiSchedul_Type_Window_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncNR_SingleSiSchedul_Type(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_OtherSiSchedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_OtherSiSchedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_SiPeriodicity_Type_Periodicity_Optional(_buffer, _size, _lidx, &p->Periodicity);
	_serNrSysEncNR_SingleSiSchedul_Type_Window_DynamicOptional(_buffer, _size, _lidx, &p->Window);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_OtherSiSchedulList_Type_SiList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_OtherSiSchedulList_Type_SiList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_OtherSiSchedul_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_OtherSiSchedulList_Type_SegmentedSiList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_OtherSiSchedulList_Type_SegmentedSiList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncNR_OtherSiSchedul_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_AllOtherSiSchedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_AllOtherSiSchedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_SiWindowLength_Type_WindowLength_Optional(_buffer, _size, _lidx, &p->WindowLength);
	_serNrSysEncNR_OtherSiSchedulList_Type_SiList_Optional(_buffer, _size, _lidx, &p->SiList);
	_serNrSysEncNR_OtherSiSchedulList_Type_SegmentedSiList_Optional(_buffer, _size, _lidx, &p->SegmentedSiList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_AllOtherSiSchedul_Type_SiSchedul_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_AllOtherSiSchedul_Type_SiSchedul_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_AllOtherSiSchedul_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BcchToPdschConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BcchToPdschConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_Sib1Schedul_Type_Sib1Schedul_Optional(_buffer, _size, _lidx, &p->Sib1Schedul);
	_serNrSysEncNR_AllOtherSiSchedul_Type_SiSchedul_Optional(_buffer, _size, _lidx, &p->SiSchedul);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BcchToPdschConfig_Type_Pdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BcchToPdschConfig_Type_Pdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_BcchToPdschConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDCCH_ConfigSIB1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDCCH_ConfigSIB1* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->controlResourceSetZero, _lidx);
	HTON_8(&_buffer[*_lidx], p->searchSpaceZero, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i1 = 0; i1 < 6; i1++) {
		HTON_8(&_buffer[*_lidx], p->systemFrameNumber[i1], _lidx);
	}
	{
		size_t _tmp = (size_t)p->subCarrierSpacingCommon;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->ssb_SubcarrierOffset, _lidx);
	{
		size_t _tmp = (size_t)p->dmrs_TypeA_Position;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PDCCH_ConfigSIB1(_buffer, _size, _lidx, &p->pdcch_ConfigSIB1);
	{
		size_t _tmp = (size_t)p->cellBarred;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->intraFreqReselection;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	for (size_t i1 = 0; i1 < 1; i1++) {
		HTON_8(&_buffer[*_lidx], p->spare[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_BCH_MessageType_messageClassExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_BCH_MessageType_messageClassExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_BCH_MessageType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_BCCH_BCH_MessageType_Value* p, enum SQN_NR_BCCH_BCH_MessageType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_BCCH_BCH_MessageType_mib) {
		_serNrSysEncSQN_NR_MIB(_buffer, _size, _lidx, &p->mib);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_BCCH_BCH_MessageType_messageClassExtension) {
		_serNrSysEncSQN_NR_BCCH_BCH_MessageType_messageClassExtension(_buffer, _size, _lidx, &p->messageClassExtension);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_BCCH_BCH_MessageType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_BCH_MessageType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_BCCH_BCH_MessageType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_BCH_Message(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_BCH_Message* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BCCH_BCH_MessageType(_buffer, _size, _lidx, &p->message);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_BCH_Message_MIB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_BCH_Message_MIB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_BCCH_BCH_Message(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SIB2_cellReselectionInfoCommon_nrofSS_BlocksToAverage_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SIB2_cellReselectionInfoCommon_nrofSS_BlocksToAverage_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_Range_SQN_NR_ThresholdNR_thresholdRSRP_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_Range_SQN_NR_ThresholdNR_thresholdRSRP_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRQ_Range_SQN_NR_ThresholdNR_thresholdRSRQ_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRQ_Range_SQN_NR_ThresholdNR_thresholdRSRQ_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SINR_Range_SQN_NR_ThresholdNR_thresholdSINR_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SINR_Range_SQN_NR_ThresholdNR_thresholdSINR_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ThresholdNR(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ThresholdNR* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RSRP_Range_SQN_NR_ThresholdNR_thresholdRSRP_Optional(_buffer, _size, _lidx, &p->thresholdRSRP);
	_serNrSysEncSQN_NR_RSRQ_Range_SQN_NR_ThresholdNR_thresholdRSRQ_Optional(_buffer, _size, _lidx, &p->thresholdRSRQ);
	_serNrSysEncSQN_NR_SINR_Range_SQN_NR_ThresholdNR_thresholdSINR_Optional(_buffer, _size, _lidx, &p->thresholdSINR);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ThresholdNR_SQN_NR_SIB2_cellReselectionInfoCommon_absThreshSS_BlocksConsolidation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ThresholdNR_SQN_NR_SIB2_cellReselectionInfoCommon_absThreshSS_BlocksConsolidation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ThresholdNR(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_OffsetRange_e_SQN_NR_SIB2_cellReselectionInfoCommon_rangeToBestCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_OffsetRange_e_SQN_NR_SIB2_cellReselectionInfoCommon_rangeToBestCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MobilityStateParameters(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MobilityStateParameters* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->t_Evaluation;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t_HystNormal;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->n_CellChangeMedium, _lidx);
	HTON_8(&_buffer[*_lidx], p->n_CellChangeHigh, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sf_Medium;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->sf_High;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MobilityStateParameters(_buffer, _size, _lidx, &p->mobilityStateParameters);
	_serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(_buffer, _size, _lidx, &p->q_HystSF);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_cellReselectionInfoCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_SIB2_cellReselectionInfoCommon_nrofSS_BlocksToAverage_Optional(_buffer, _size, _lidx, &p->nrofSS_BlocksToAverage);
	_serNrSysEncSQN_NR_ThresholdNR_SQN_NR_SIB2_cellReselectionInfoCommon_absThreshSS_BlocksConsolidation_Optional(_buffer, _size, _lidx, &p->absThreshSS_BlocksConsolidation);
	_serNrSysEncSQN_NR_Q_OffsetRange_e_SQN_NR_SIB2_cellReselectionInfoCommon_rangeToBestCell_Optional(_buffer, _size, _lidx, &p->rangeToBestCell);
	{
		size_t _tmp = (size_t)p->q_Hyst;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(_buffer, _size, _lidx, &p->speedStateReselectionPars);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReselectionThreshold_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchP_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReselectionThreshold_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchP_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchQ_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchQ_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_threshServingLowQ_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_threshServingLowQ_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellReselectionSubPriority_e_SQN_NR_SIB2_cellReselectionServingFreqInfo_cellReselectionSubPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellReselectionSubPriority_e_SQN_NR_SIB2_cellReselectionServingFreqInfo_cellReselectionSubPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_cellReselectionServingFreqInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_cellReselectionServingFreqInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ReselectionThreshold_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchP_Optional(_buffer, _size, _lidx, &p->s_NonIntraSearchP);
	_serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_s_NonIntraSearchQ_Optional(_buffer, _size, _lidx, &p->s_NonIntraSearchQ);
	HTON_8(&_buffer[*_lidx], p->threshServingLowP, _lidx);
	_serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_cellReselectionServingFreqInfo_threshServingLowQ_Optional(_buffer, _size, _lidx, &p->threshServingLowQ);
	HTON_8(&_buffer[*_lidx], p->cellReselectionPriority, _lidx);
	_serNrSysEncSQN_NR_CellReselectionSubPriority_e_SQN_NR_SIB2_cellReselectionServingFreqInfo_cellReselectionSubPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionSubPriority);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_RxLevMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_RxLevMinSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_RxLevMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_RxLevMinSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_QualMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_QualMin_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_QualMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_QualMin_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_intraFreqCellReselectionInfo_s_IntraSearchQ_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_intraFreqCellReselectionInfo_s_IntraSearchQ_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FreqBandIndicatorNR_SQN_NR_NR_MultiBandInfo_freqBandIndicatorNR_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FreqBandIndicatorNR_SQN_NR_NR_MultiBandInfo_freqBandIndicatorNR_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P_Max_SQN_NR_NR_NS_PmaxValue_additionalPmax_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P_Max_SQN_NR_NR_NS_PmaxValue_additionalPmax_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NR_NS_PmaxValue(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NR_NS_PmaxValue* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_P_Max_SQN_NR_NR_NS_PmaxValue_additionalPmax_Optional(_buffer, _size, _lidx, &p->additionalPmax);
	HTON_8(&_buffer[*_lidx], p->additionalSpectrumEmission, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NR_NS_PmaxList_SQN_NR_NR_MultiBandInfo_nr_NS_PmaxList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NR_NS_PmaxList_SQN_NR_NR_MultiBandInfo_nr_NS_PmaxList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_NR_NS_PmaxValue(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NR_MultiBandInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NR_MultiBandInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_FreqBandIndicatorNR_SQN_NR_NR_MultiBandInfo_freqBandIndicatorNR_Optional(_buffer, _size, _lidx, &p->freqBandIndicatorNR);
	_serNrSysEncSQN_NR_NR_NS_PmaxList_SQN_NR_NR_MultiBandInfo_nr_NS_PmaxList_Optional(_buffer, _size, _lidx, &p->nr_NS_PmaxList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_NR_MultiBandInfo(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandListSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandListSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_NR_MultiBandInfo(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P_Max_SQN_NR_SIB2_intraFreqCellReselectionInfo_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P_Max_SQN_NR_SIB2_intraFreqCellReselectionInfo_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC_periodicityAndOffset_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SSB_MTC_periodicityAndOffset_Value* p, enum SQN_NR_SSB_MTC_periodicityAndOffset_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf5) {
		HTON_8(&_buffer[*_lidx], p->sf5, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf10) {
		HTON_8(&_buffer[*_lidx], p->sf10, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf20) {
		HTON_8(&_buffer[*_lidx], p->sf20, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf40) {
		HTON_8(&_buffer[*_lidx], p->sf40, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf80) {
		HTON_8(&_buffer[*_lidx], p->sf80, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SSB_MTC_periodicityAndOffset_sf160) {
		HTON_8(&_buffer[*_lidx], p->sf160, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SSB_MTC_periodicityAndOffset(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC_periodicityAndOffset* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SSB_MTC_periodicityAndOffset_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SSB_MTC_periodicityAndOffset(_buffer, _size, _lidx, &p->periodicityAndOffset);
	{
		size_t _tmp = (size_t)p->duration;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_MTC(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SS_RSSI_Measurement(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SS_RSSI_Measurement* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->measurementSlots.d, _lidx);
	for (size_t i2 = 0; i2 < p->measurementSlots.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->measurementSlots.v[i2], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->endSymbol, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SS_RSSI_Measurement_SQN_NR_SIB2_intraFreqCellReselectionInfo_ss_RSSI_Measurement_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SS_RSSI_Measurement_SQN_NR_SIB2_intraFreqCellReselectionInfo_ss_RSSI_Measurement_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SS_RSSI_Measurement(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_ToMeasure_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SSB_ToMeasure_Value* p, enum SQN_NR_SSB_ToMeasure_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SSB_ToMeasure_shortBitmap) {
		for (size_t i2 = 0; i2 < 4; i2++) {
			HTON_8(&_buffer[*_lidx], p->shortBitmap[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SSB_ToMeasure_mediumBitmap) {
		for (size_t i2 = 0; i2 < 8; i2++) {
			HTON_8(&_buffer[*_lidx], p->mediumBitmap[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SSB_ToMeasure_longBitmap) {
		for (size_t i2 = 0; i2 < 64; i2++) {
			HTON_8(&_buffer[*_lidx], p->longBitmap[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SSB_ToMeasure(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_ToMeasure* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SSB_ToMeasure_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_ToMeasure_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_ToMeasure_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_ToMeasure_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_ToMeasure_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_ToMeasure(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SpeedStateScaleFactors(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SpeedStateScaleFactors* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sf_Medium;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->sf_High;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SpeedStateScaleFactors_SQN_NR_SIB2_intraFreqCellReselectionInfo_t_ReselectionNR_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB2_intraFreqCellReselectionInfo_t_ReselectionNR_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PhysCellId_SQN_NR_SSB_MTC2_LP_r16_pci_List_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PhysCellId_SQN_NR_SSB_MTC2_LP_r16_pci_List_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC2_LP_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC2_LP_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PhysCellId_SQN_NR_SSB_MTC2_LP_r16_pci_List_DynamicOptional(_buffer, _size, _lidx, &p->pci_List);
	{
		size_t _tmp = (size_t)p->periodicity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC2_LP_r16_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc2_LP_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC2_LP_r16_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc2_LP_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_MTC2_LP_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_PositionQCL_Common_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_PositionQCL_Common_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_intraFreqCellReselectionInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_intraFreqCellReselectionInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	_serNrSysEncSQN_NR_Q_RxLevMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_RxLevMinSUL_Optional(_buffer, _size, _lidx, &p->q_RxLevMinSUL);
	_serNrSysEncSQN_NR_Q_QualMin_SQN_NR_SIB2_intraFreqCellReselectionInfo_q_QualMin_Optional(_buffer, _size, _lidx, &p->q_QualMin);
	HTON_8(&_buffer[*_lidx], p->s_IntraSearchP, _lidx);
	_serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_intraFreqCellReselectionInfo_s_IntraSearchQ_Optional(_buffer, _size, _lidx, &p->s_IntraSearchQ);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionNR, _lidx);
	_serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandList_Optional(_buffer, _size, _lidx, &p->frequencyBandList);
	_serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_SIB2_intraFreqCellReselectionInfo_frequencyBandListSUL_Optional(_buffer, _size, _lidx, &p->frequencyBandListSUL);
	_serNrSysEncSQN_NR_P_Max_SQN_NR_SIB2_intraFreqCellReselectionInfo_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	_serNrSysEncSQN_NR_SSB_MTC_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc_Optional(_buffer, _size, _lidx, &p->smtc);
	_serNrSysEncSQN_NR_SS_RSSI_Measurement_SQN_NR_SIB2_intraFreqCellReselectionInfo_ss_RSSI_Measurement_Optional(_buffer, _size, _lidx, &p->ss_RSSI_Measurement);
	_serNrSysEncSQN_NR_SSB_ToMeasure_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_ToMeasure_Optional(_buffer, _size, _lidx, &p->ssb_ToMeasure);
	HTON_8(&_buffer[*_lidx], p->deriveSSB_IndexFromCell, _lidx);
	_serNrSysEncSQN_NR_SpeedStateScaleFactors_SQN_NR_SIB2_intraFreqCellReselectionInfo_t_ReselectionNR_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionNR_SF);
	_serNrSysEncSQN_NR_SSB_MTC2_LP_r16_SQN_NR_SIB2_intraFreqCellReselectionInfo_smtc2_LP_r16_Optional(_buffer, _size, _lidx, &p->smtc2_LP_r16);
	_serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_SIB2_intraFreqCellReselectionInfo_ssb_PositionQCL_Common_r16_Optional(_buffer, _size, _lidx, &p->ssb_PositionQCL_Common_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->s_SearchDeltaP_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t_SearchDeltaP_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_lowMobilityEvaluation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_lowMobilityEvaluation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_s_SearchThresholdQ_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_s_SearchThresholdQ_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->s_SearchThresholdP_r16, _lidx);
	_serNrSysEncSQN_NR_ReselectionThresholdQ_SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_s_SearchThresholdQ_r16_Optional(_buffer, _size, _lidx, &p->s_SearchThresholdQ_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_cellEdgeEvaluation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_cellEdgeEvaluation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_combineRelaxedMeasCondition_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_combineRelaxedMeasCondition_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_highPriorityMeasRelax_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_highPriorityMeasRelax_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_lowMobilityEvaluation_r16_lowMobilityEvaluation_r16_Optional(_buffer, _size, _lidx, &p->lowMobilityEvaluation_r16);
	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_cellEdgeEvaluation_r16_cellEdgeEvaluation_r16_Optional(_buffer, _size, _lidx, &p->cellEdgeEvaluation_r16);
	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_combineRelaxedMeasCondition_r16_e_combineRelaxedMeasCondition_r16_Optional(_buffer, _size, _lidx, &p->combineRelaxedMeasCondition_r16);
	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_highPriorityMeasRelax_r16_e_highPriorityMeasRelax_r16_Optional(_buffer, _size, _lidx, &p->highPriorityMeasRelax_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_relaxedMeasurement_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2_relaxedMeasurement_r16_relaxedMeasurement_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB2* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SIB2_cellReselectionInfoCommon(_buffer, _size, _lidx, &p->cellReselectionInfoCommon);
	_serNrSysEncSQN_NR_SIB2_cellReselectionServingFreqInfo(_buffer, _size, _lidx, &p->cellReselectionServingFreqInfo);
	_serNrSysEncSQN_NR_SIB2_intraFreqCellReselectionInfo(_buffer, _size, _lidx, &p->intraFreqCellReselectionInfo);
	_serNrSysEncSQN_NR_SIB2_relaxedMeasurement_r16_relaxedMeasurement_r16_Optional(_buffer, _size, _lidx, &p->relaxedMeasurement_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_IntraFreqNeighCellInfo_q_QualMinOffsetCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_IntraFreqNeighCellInfo_q_QualMinOffsetCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqNeighCellInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqNeighCellInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physCellId, _lidx);
	{
		size_t _tmp = (size_t)p->q_OffsetCell;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffsetCell);
	_serNrSysEncUint8_t_SQN_NR_IntraFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffsetCellSUL);
	_serNrSysEncUint8_t_SQN_NR_IntraFreqNeighCellInfo_q_QualMinOffsetCell_Optional(_buffer, _size, _lidx, &p->q_QualMinOffsetCell);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqNeighCellList_SQN_NR_SIB3_intraFreqNeighCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqNeighCellList_SQN_NR_SIB3_intraFreqNeighCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_IntraFreqNeighCellInfo(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PCI_Range_range_e_range_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PCI_Range_range_e_range_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PCI_Range(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PCI_Range* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->start, _lidx);
	_serNrSysEncSQN_NR_PCI_Range_range_e_range_Optional(_buffer, _size, _lidx, &p->range);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqBlackCellList_SQN_NR_SIB3_intraFreqBlackCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqBlackCellList_SQN_NR_SIB3_intraFreqBlackCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PCI_Range(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB3_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB3_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_IntraFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_IntraFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqNeighCellInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqNeighCellInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_IntraFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(_buffer, _size, _lidx, &p->ssb_PositionQCL_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqNeighCellList_v1610_SQN_NR_SIB3_intraFreqNeighCellList_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqNeighCellList_v1610_SQN_NR_SIB3_intraFreqNeighCellList_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_IntraFreqNeighCellInfo_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqWhiteCellList_r16_SQN_NR_SIB3_intraFreqWhiteCellList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqWhiteCellList_r16_SQN_NR_SIB3_intraFreqWhiteCellList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_PCI_Range(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqCAG_CellListPerPLMN_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqCAG_CellListPerPLMN_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_IdentityIndex_r16, _lidx);
	HTON_32(&_buffer[*_lidx], p->cag_CellList_r16.d, _lidx);
	for (size_t i3 = 0; i3 < p->cag_CellList_r16.d; i3++) {
		_serNrSysEncSQN_NR_PCI_Range(_buffer, _size, _lidx, &p->cag_CellList_r16.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_IntraFreqCAG_CellListPerPLMN_r16_SQN_NR_SIB3_intraFreqCAG_CellList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_IntraFreqCAG_CellListPerPLMN_r16_SQN_NR_SIB3_intraFreqCAG_CellList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_IntraFreqCAG_CellListPerPLMN_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB3(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB3* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_IntraFreqNeighCellList_SQN_NR_SIB3_intraFreqNeighCellList_Optional(_buffer, _size, _lidx, &p->intraFreqNeighCellList);
	_serNrSysEncSQN_NR_IntraFreqBlackCellList_SQN_NR_SIB3_intraFreqBlackCellList_Optional(_buffer, _size, _lidx, &p->intraFreqBlackCellList);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB3_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serNrSysEncSQN_NR_IntraFreqNeighCellList_v1610_SQN_NR_SIB3_intraFreqNeighCellList_v1610_Optional(_buffer, _size, _lidx, &p->intraFreqNeighCellList_v1610);
	_serNrSysEncSQN_NR_IntraFreqWhiteCellList_r16_SQN_NR_SIB3_intraFreqWhiteCellList_r16_Optional(_buffer, _size, _lidx, &p->intraFreqWhiteCellList_r16);
	_serNrSysEncSQN_NR_IntraFreqCAG_CellListPerPLMN_r16_SQN_NR_SIB3_intraFreqCAG_CellList_r16_DynamicOptional(_buffer, _size, _lidx, &p->intraFreqCAG_CellList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_NR_MultiBandInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandListSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandListSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_NR_MultiBandInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_InterFreqCarrierFreqInfo_nrofSS_BlocksToAverage_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_InterFreqCarrierFreqInfo_nrofSS_BlocksToAverage_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ThresholdNR_SQN_NR_InterFreqCarrierFreqInfo_absThreshSS_BlocksConsolidation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ThresholdNR_SQN_NR_InterFreqCarrierFreqInfo_absThreshSS_BlocksConsolidation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ThresholdNR(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC_SQN_NR_InterFreqCarrierFreqInfo_smtc_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC_SQN_NR_InterFreqCarrierFreqInfo_smtc_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_MTC(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_ToMeasure_SQN_NR_InterFreqCarrierFreqInfo_ssb_ToMeasure_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_ToMeasure_SQN_NR_InterFreqCarrierFreqInfo_ssb_ToMeasure_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_ToMeasure(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SS_RSSI_Measurement_SQN_NR_InterFreqCarrierFreqInfo_ss_RSSI_Measurement_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SS_RSSI_Measurement_SQN_NR_InterFreqCarrierFreqInfo_ss_RSSI_Measurement_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SS_RSSI_Measurement(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_RxLevMin_SQN_NR_InterFreqCarrierFreqInfo_q_RxLevMinSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_RxLevMin_SQN_NR_InterFreqCarrierFreqInfo_q_RxLevMinSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_QualMin_SQN_NR_InterFreqCarrierFreqInfo_q_QualMin_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_QualMin_SQN_NR_InterFreqCarrierFreqInfo_q_QualMin_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P_Max_SQN_NR_InterFreqCarrierFreqInfo_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P_Max_SQN_NR_InterFreqCarrierFreqInfo_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SpeedStateScaleFactors_SQN_NR_InterFreqCarrierFreqInfo_t_ReselectionNR_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SpeedStateScaleFactors_SQN_NR_InterFreqCarrierFreqInfo_t_ReselectionNR_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqCarrierFreqInfo_threshX_Q(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqCarrierFreqInfo_threshX_Q* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshX_HighQ, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowQ, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqCarrierFreqInfo_threshX_Q_threshX_Q_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqCarrierFreqInfo_threshX_Q_threshX_Q_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_InterFreqCarrierFreqInfo_threshX_Q(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellReselectionPriority_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellReselectionPriority_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellReselectionSubPriority_e_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionSubPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellReselectionSubPriority_e_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionSubPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_OffsetRange_e_SQN_NR_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_OffsetRange_e_SQN_NR_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_InterFreqNeighCellInfo_q_QualMinOffsetCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_InterFreqNeighCellInfo_q_QualMinOffsetCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqNeighCellInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqNeighCellInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physCellId, _lidx);
	{
		size_t _tmp = (size_t)p->q_OffsetCell;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffsetCell);
	_serNrSysEncUint8_t_SQN_NR_InterFreqNeighCellInfo_q_RxLevMinOffsetCellSUL_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffsetCellSUL);
	_serNrSysEncUint8_t_SQN_NR_InterFreqNeighCellInfo_q_QualMinOffsetCell_Optional(_buffer, _size, _lidx, &p->q_QualMinOffsetCell);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqNeighCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqNeighCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_InterFreqNeighCellInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqBlackCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqBlackCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_PCI_Range(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqCarrierFreqInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqCarrierFreqInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->dl_CarrierFreq, _lidx);
	_serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandList_Optional(_buffer, _size, _lidx, &p->frequencyBandList);
	_serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_InterFreqCarrierFreqInfo_frequencyBandListSUL_Optional(_buffer, _size, _lidx, &p->frequencyBandListSUL);
	_serNrSysEncUint8_t_SQN_NR_InterFreqCarrierFreqInfo_nrofSS_BlocksToAverage_Optional(_buffer, _size, _lidx, &p->nrofSS_BlocksToAverage);
	_serNrSysEncSQN_NR_ThresholdNR_SQN_NR_InterFreqCarrierFreqInfo_absThreshSS_BlocksConsolidation_Optional(_buffer, _size, _lidx, &p->absThreshSS_BlocksConsolidation);
	_serNrSysEncSQN_NR_SSB_MTC_SQN_NR_InterFreqCarrierFreqInfo_smtc_Optional(_buffer, _size, _lidx, &p->smtc);
	{
		size_t _tmp = (size_t)p->ssbSubcarrierSpacing;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SSB_ToMeasure_SQN_NR_InterFreqCarrierFreqInfo_ssb_ToMeasure_Optional(_buffer, _size, _lidx, &p->ssb_ToMeasure);
	HTON_8(&_buffer[*_lidx], p->deriveSSB_IndexFromCell, _lidx);
	_serNrSysEncSQN_NR_SS_RSSI_Measurement_SQN_NR_InterFreqCarrierFreqInfo_ss_RSSI_Measurement_Optional(_buffer, _size, _lidx, &p->ss_RSSI_Measurement);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	_serNrSysEncSQN_NR_Q_RxLevMin_SQN_NR_InterFreqCarrierFreqInfo_q_RxLevMinSUL_Optional(_buffer, _size, _lidx, &p->q_RxLevMinSUL);
	_serNrSysEncSQN_NR_Q_QualMin_SQN_NR_InterFreqCarrierFreqInfo_q_QualMin_Optional(_buffer, _size, _lidx, &p->q_QualMin);
	_serNrSysEncSQN_NR_P_Max_SQN_NR_InterFreqCarrierFreqInfo_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionNR, _lidx);
	_serNrSysEncSQN_NR_SpeedStateScaleFactors_SQN_NR_InterFreqCarrierFreqInfo_t_ReselectionNR_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionNR_SF);
	HTON_8(&_buffer[*_lidx], p->threshX_HighP, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowP, _lidx);
	_serNrSysEncSQN_NR_InterFreqCarrierFreqInfo_threshX_Q_threshX_Q_Optional(_buffer, _size, _lidx, &p->threshX_Q);
	_serNrSysEncSQN_NR_CellReselectionPriority_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority);
	_serNrSysEncSQN_NR_CellReselectionSubPriority_e_SQN_NR_InterFreqCarrierFreqInfo_cellReselectionSubPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionSubPriority);
	_serNrSysEncSQN_NR_Q_OffsetRange_e_SQN_NR_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(_buffer, _size, _lidx, &p->q_OffsetFreq);
	_serNrSysEncSQN_NR_InterFreqNeighCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(_buffer, _size, _lidx, &p->interFreqNeighCellList);
	_serNrSysEncSQN_NR_InterFreqBlackCellList_SQN_NR_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(_buffer, _size, _lidx, &p->interFreqBlackCellList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB4_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB4_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqNeighCellInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqNeighCellInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqNeighCellInfo_v1610_ssb_PositionQCL_r16_Optional(_buffer, _size, _lidx, &p->ssb_PositionQCL_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqNeighCellList_v1610_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqNeighCellList_v1610_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_InterFreqNeighCellInfo_v1610(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC2_LP_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_smtc2_LP_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC2_LP_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_smtc2_LP_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_MTC2_LP_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqWhiteCellList_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqWhiteCellList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqWhiteCellList_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqWhiteCellList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_PCI_Range(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqCarrierFreqInfo_v1610_ssb_PositionQCL_Common_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqCarrierFreqInfo_v1610_ssb_PositionQCL_Common_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqCAG_CellListPerPLMN_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqCAG_CellListPerPLMN_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_IdentityIndex_r16, _lidx);
	HTON_32(&_buffer[*_lidx], p->cag_CellList_r16.d, _lidx);
	for (size_t i4 = 0; i4 < p->cag_CellList_r16.d; i4++) {
		_serNrSysEncSQN_NR_PCI_Range(_buffer, _size, _lidx, &p->cag_CellList_r16.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqCAG_CellListPerPLMN_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqCAG_CellList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqCAG_CellListPerPLMN_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqCAG_CellList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_InterFreqCAG_CellListPerPLMN_r16(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqCarrierFreqInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqCarrierFreqInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_InterFreqNeighCellList_v1610_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(_buffer, _size, _lidx, &p->interFreqNeighCellList_v1610);
	_serNrSysEncSQN_NR_SSB_MTC2_LP_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_smtc2_LP_r16_Optional(_buffer, _size, _lidx, &p->smtc2_LP_r16);
	_serNrSysEncSQN_NR_InterFreqWhiteCellList_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqWhiteCellList_r16_Optional(_buffer, _size, _lidx, &p->interFreqWhiteCellList_r16);
	_serNrSysEncSQN_NR_SSB_PositionQCL_Relation_r16_e_SQN_NR_InterFreqCarrierFreqInfo_v1610_ssb_PositionQCL_Common_r16_Optional(_buffer, _size, _lidx, &p->ssb_PositionQCL_Common_r16);
	_serNrSysEncSQN_NR_InterFreqCAG_CellListPerPLMN_r16_SQN_NR_InterFreqCarrierFreqInfo_v1610_interFreqCAG_CellList_r16_DynamicOptional(_buffer, _size, _lidx, &p->interFreqCAG_CellList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_InterFreqCarrierFreqList_v1610_SQN_NR_SIB4_interFreqCarrierFreqList_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_InterFreqCarrierFreqList_v1610_SQN_NR_SIB4_interFreqCarrierFreqList_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_InterFreqCarrierFreqInfo_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB4(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB4* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->interFreqCarrierFreqList.d, _lidx);
	for (size_t i2 = 0; i2 < p->interFreqCarrierFreqList.d; i2++) {
		_serNrSysEncSQN_NR_InterFreqCarrierFreqInfo(_buffer, _size, _lidx, &p->interFreqCarrierFreqList.v[i2]);
	}
	_serNrSysEncOCTET_STRING_SQN_NR_SIB4_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serNrSysEncSQN_NR_InterFreqCarrierFreqList_v1610_SQN_NR_SIB4_interFreqCarrierFreqList_v1610_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqList_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_EUTRA_NS_PmaxValue_additionalPmax_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_EUTRA_NS_PmaxValue_additionalPmax_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_EUTRA_NS_PmaxValue_additionalSpectrumEmission_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_EUTRA_NS_PmaxValue_additionalSpectrumEmission_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_NS_PmaxValue(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_NS_PmaxValue* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncInt8_t_SQN_NR_EUTRA_NS_PmaxValue_additionalPmax_Optional(_buffer, _size, _lidx, &p->additionalPmax);
	_serNrSysEncUint16_t_SQN_NR_EUTRA_NS_PmaxValue_additionalSpectrumEmission_Optional(_buffer, _size, _lidx, &p->additionalSpectrumEmission);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_NS_PmaxList_SQN_NR_EUTRA_MultiBandInfo_eutra_NS_PmaxList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_NS_PmaxList_SQN_NR_EUTRA_MultiBandInfo_eutra_NS_PmaxList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_serNrSysEncSQN_NR_EUTRA_NS_PmaxValue(_buffer, _size, _lidx, &p->v.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_MultiBandInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_MultiBandInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->eutra_FreqBandIndicator, _lidx);
	_serNrSysEncSQN_NR_EUTRA_NS_PmaxList_SQN_NR_EUTRA_MultiBandInfo_eutra_NS_PmaxList_Optional(_buffer, _size, _lidx, &p->eutra_NS_PmaxList);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_MultiBandInfoList_SQN_NR_CarrierFreqEUTRA_eutra_multiBandInfoList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_MultiBandInfoList_SQN_NR_CarrierFreqEUTRA_eutra_multiBandInfoList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_EUTRA_MultiBandInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_RxLevMinOffsetCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_QualMinOffsetCell_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_QualMinOffsetCell_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_FreqNeighCellInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_FreqNeighCellInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physCellId, _lidx);
	{
		size_t _tmp = (size_t)p->dummy;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_RxLevMinOffsetCell_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffsetCell);
	_serNrSysEncUint8_t_SQN_NR_EUTRA_FreqNeighCellInfo_q_QualMinOffsetCell_Optional(_buffer, _size, _lidx, &p->q_QualMinOffsetCell);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_FreqNeighCellList_SQN_NR_CarrierFreqEUTRA_eutra_FreqNeighCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_FreqNeighCellList_SQN_NR_CarrierFreqEUTRA_eutra_FreqNeighCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_EUTRA_FreqNeighCellInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_PhysCellIdRange_range_e_range_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_PhysCellIdRange_range_e_range_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_PhysCellIdRange(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_PhysCellIdRange* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->start, _lidx);
	_serNrSysEncSQN_NR_EUTRA_PhysCellIdRange_range_e_range_Optional(_buffer, _size, _lidx, &p->range);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_EUTRA_FreqBlackCellList_SQN_NR_CarrierFreqEUTRA_eutra_BlackCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_EUTRA_FreqBlackCellList_SQN_NR_CarrierFreqEUTRA_eutra_BlackCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_EUTRA_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellReselectionPriority_SQN_NR_CarrierFreqEUTRA_cellReselectionPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellReselectionPriority_SQN_NR_CarrierFreqEUTRA_cellReselectionPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellReselectionSubPriority_e_SQN_NR_CarrierFreqEUTRA_cellReselectionSubPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellReselectionSubPriority_e_SQN_NR_CarrierFreqEUTRA_cellReselectionSubPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CarrierFreqEUTRA_threshX_Q(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CarrierFreqEUTRA_threshX_Q* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshX_HighQ, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowQ, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CarrierFreqEUTRA_threshX_Q_threshX_Q_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CarrierFreqEUTRA_threshX_Q_threshX_Q_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_CarrierFreqEUTRA_threshX_Q(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CarrierFreqEUTRA(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CarrierFreqEUTRA* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreq, _lidx);
	_serNrSysEncSQN_NR_EUTRA_MultiBandInfoList_SQN_NR_CarrierFreqEUTRA_eutra_multiBandInfoList_Optional(_buffer, _size, _lidx, &p->eutra_multiBandInfoList);
	_serNrSysEncSQN_NR_EUTRA_FreqNeighCellList_SQN_NR_CarrierFreqEUTRA_eutra_FreqNeighCellList_Optional(_buffer, _size, _lidx, &p->eutra_FreqNeighCellList);
	_serNrSysEncSQN_NR_EUTRA_FreqBlackCellList_SQN_NR_CarrierFreqEUTRA_eutra_BlackCellList_Optional(_buffer, _size, _lidx, &p->eutra_BlackCellList);
	{
		size_t _tmp = (size_t)p->allowedMeasBandwidth;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->presenceAntennaPort1, _lidx);
	_serNrSysEncSQN_NR_CellReselectionPriority_SQN_NR_CarrierFreqEUTRA_cellReselectionPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority);
	_serNrSysEncSQN_NR_CellReselectionSubPriority_e_SQN_NR_CarrierFreqEUTRA_cellReselectionSubPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionSubPriority);
	HTON_8(&_buffer[*_lidx], p->threshX_High, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_QualMin, _lidx);
	HTON_8(&_buffer[*_lidx], p->p_MaxEUTRA, _lidx);
	_serNrSysEncSQN_NR_CarrierFreqEUTRA_threshX_Q_threshX_Q_Optional(_buffer, _size, _lidx, &p->threshX_Q);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CarrierFreqListEUTRA_SQN_NR_SIB5_carrierFreqListEUTRA_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CarrierFreqListEUTRA_SQN_NR_SIB5_carrierFreqListEUTRA_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_CarrierFreqEUTRA(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SpeedStateScaleFactors_SQN_NR_SIB5_t_ReselectionEUTRA_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SpeedStateScaleFactors_SQN_NR_SIB5_t_ReselectionEUTRA_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB5_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB5_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_highSpeedEUTRACarrier_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_highSpeedEUTRACarrier_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CarrierFreqEUTRA_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CarrierFreqEUTRA_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_CarrierFreqEUTRA_v1610_highSpeedEUTRACarrier_r16_e_highSpeedEUTRACarrier_r16_Optional(_buffer, _size, _lidx, &p->highSpeedEUTRACarrier_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CarrierFreqListEUTRA_v1610_SQN_NR_SIB5_carrierFreqListEUTRA_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CarrierFreqListEUTRA_v1610_SQN_NR_SIB5_carrierFreqListEUTRA_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_CarrierFreqEUTRA_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB5(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB5* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_CarrierFreqListEUTRA_SQN_NR_SIB5_carrierFreqListEUTRA_Optional(_buffer, _size, _lidx, &p->carrierFreqListEUTRA);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionEUTRA, _lidx);
	_serNrSysEncSQN_NR_SpeedStateScaleFactors_SQN_NR_SIB5_t_ReselectionEUTRA_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionEUTRA_SF);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB5_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serNrSysEncSQN_NR_CarrierFreqListEUTRA_v1610_SQN_NR_SIB5_carrierFreqListEUTRA_v1610_Optional(_buffer, _size, _lidx, &p->carrierFreqListEUTRA_v1610);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB6_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB6_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB6(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB6* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->messageIdentifier[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->serialNumber[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->warningType[i2], _lidx);
	}
	_serNrSysEncOCTET_STRING_SQN_NR_SIB6_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncO1_SQN_NR_SIB7_dataCodingScheme_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O1_SQN_NR_SIB7_dataCodingScheme_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 1; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB7_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB7_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB7(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB7* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->messageIdentifier[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->serialNumber[i2], _lidx);
	}
	{
		size_t _tmp = (size_t)p->warningMessageSegmentType;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->warningMessageSegmentNumber, _lidx);
	HTON_32(&_buffer[*_lidx], p->warningMessageSegment.d, _lidx);
	for (size_t i2 = 0; i2 < p->warningMessageSegment.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->warningMessageSegment.v[i2], _lidx);
	}
	_serNrSysEncO1_SQN_NR_SIB7_dataCodingScheme_Optional(_buffer, _size, _lidx, &p->dataCodingScheme);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB7_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncO1_SQN_NR_SIB8_dataCodingScheme_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O1_SQN_NR_SIB8_dataCodingScheme_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 1; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB8_warningAreaCoordinatesSegment_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB8_warningAreaCoordinatesSegment_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB8_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB8_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB8(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB8* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->messageIdentifier[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->serialNumber[i2], _lidx);
	}
	{
		size_t _tmp = (size_t)p->warningMessageSegmentType;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->warningMessageSegmentNumber, _lidx);
	HTON_32(&_buffer[*_lidx], p->warningMessageSegment.d, _lidx);
	for (size_t i2 = 0; i2 < p->warningMessageSegment.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->warningMessageSegment.v[i2], _lidx);
	}
	_serNrSysEncO1_SQN_NR_SIB8_dataCodingScheme_Optional(_buffer, _size, _lidx, &p->dataCodingScheme);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB8_warningAreaCoordinatesSegment_Optional(_buffer, _size, _lidx, &p->warningAreaCoordinatesSegment);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB8_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB2_SQN_NR_SIB9_timeInfo_dayLightSavingTime_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B2_SQN_NR_SIB9_timeInfo_dayLightSavingTime_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt16_t_SQN_NR_SIB9_timeInfo_leapSeconds_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_NR_SIB9_timeInfo_leapSeconds_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncInt8_t_SQN_NR_SIB9_timeInfo_localTimeOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_NR_SIB9_timeInfo_localTimeOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB9_timeInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB9_timeInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->timeInfoUTC, _lidx);
	_serNrSysEncB2_SQN_NR_SIB9_timeInfo_dayLightSavingTime_Optional(_buffer, _size, _lidx, &p->dayLightSavingTime);
	_serNrSysEncInt16_t_SQN_NR_SIB9_timeInfo_leapSeconds_Optional(_buffer, _size, _lidx, &p->leapSeconds);
	_serNrSysEncInt8_t_SQN_NR_SIB9_timeInfo_localTimeOffset_Optional(_buffer, _size, _lidx, &p->localTimeOffset);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB9_timeInfo_timeInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB9_timeInfo_timeInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB9_timeInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB9_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB9_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReferenceTime_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReferenceTime_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->refDays_r16, _lidx);
	HTON_32(&_buffer[*_lidx], p->refSeconds_r16, _lidx);
	HTON_16(&_buffer[*_lidx], p->refMilliSeconds_r16, _lidx);
	HTON_32(&_buffer[*_lidx], p->refTenNanoSeconds_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_ReferenceTimeInfo_r16_uncertainty_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_ReferenceTimeInfo_r16_uncertainty_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_timeInfoType_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_timeInfoType_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint16_t_SQN_NR_ReferenceTimeInfo_r16_referenceSFN_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_NR_ReferenceTimeInfo_r16_referenceSFN_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReferenceTimeInfo_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReferenceTimeInfo_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ReferenceTime_r16(_buffer, _size, _lidx, &p->time_r16);
	_serNrSysEncUint16_t_SQN_NR_ReferenceTimeInfo_r16_uncertainty_r16_Optional(_buffer, _size, _lidx, &p->uncertainty_r16);
	_serNrSysEncSQN_NR_ReferenceTimeInfo_r16_timeInfoType_r16_e_timeInfoType_r16_Optional(_buffer, _size, _lidx, &p->timeInfoType_r16);
	_serNrSysEncUint16_t_SQN_NR_ReferenceTimeInfo_r16_referenceSFN_r16_Optional(_buffer, _size, _lidx, &p->referenceSFN_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ReferenceTimeInfo_r16_SQN_NR_SIB9_referenceTimeInfo_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ReferenceTimeInfo_r16_SQN_NR_SIB9_referenceTimeInfo_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ReferenceTimeInfo_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB9* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SIB9_timeInfo_timeInfo_Optional(_buffer, _size, _lidx, &p->timeInfo);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB9_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serNrSysEncSQN_NR_ReferenceTimeInfo_r16_SQN_NR_SIB9_referenceTimeInfo_r16_Optional(_buffer, _size, _lidx, &p->referenceTimeInfo_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_HRNN_r16_hrnn_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_HRNN_r16_hrnn_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_HRNN_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_HRNN_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncOCTET_STRING_SQN_NR_HRNN_r16_hrnn_r16_Optional(_buffer, _size, _lidx, &p->hrnn_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_HRNN_List_r16_SQN_NR_SIB10_r16_hrnn_List_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_HRNN_List_r16_SQN_NR_SIB10_r16_hrnn_List_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_HRNN_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB10_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB10_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB10_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB10_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_HRNN_List_r16_SQN_NR_SIB10_r16_hrnn_List_r16_Optional(_buffer, _size, _lidx, &p->hrnn_List_r16);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB10_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MultiFrequencyBandListNR_SQN_NR_MeasIdleCarrierNR_r16_frequencyBandList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MultiFrequencyBandListNR_SQN_NR_MeasIdleCarrierNR_r16_frequencyBandList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellListNR_r16_SQN_NR_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellListNR_r16_SQN_NR_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_PCI_Range(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRP_Threshold_NR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRP_Threshold_NR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRQ_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRQ_Threshold_NR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRQ_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRQ_Threshold_NR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RSRP_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRP_Threshold_NR_r16_Optional(_buffer, _size, _lidx, &p->idleRSRP_Threshold_NR_r16);
	_serNrSysEncSQN_NR_RSRQ_Range_SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_idleRSRQ_Threshold_NR_r16_Optional(_buffer, _size, _lidx, &p->idleRSRQ_Threshold_NR_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_qualityThreshold_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_qualityThreshold_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_nrofSS_BlocksToAverage_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_nrofSS_BlocksToAverage_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ThresholdNR_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_absThreshSS_BlocksConsolidation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ThresholdNR_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_absThreshSS_BlocksConsolidation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ThresholdNR(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_MTC_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_smtc_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_MTC_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_smtc_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_MTC(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SSB_ToMeasure_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SSB_ToMeasure_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SSB_ToMeasure(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SS_RSSI_Measurement_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SS_RSSI_Measurement_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SS_RSSI_Measurement(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncUint8_t_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_nrofSS_BlocksToAverage_r16_Optional(_buffer, _size, _lidx, &p->nrofSS_BlocksToAverage_r16);
	_serNrSysEncSQN_NR_ThresholdNR_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_absThreshSS_BlocksConsolidation_r16_Optional(_buffer, _size, _lidx, &p->absThreshSS_BlocksConsolidation_r16);
	_serNrSysEncSQN_NR_SSB_MTC_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_smtc_r16_Optional(_buffer, _size, _lidx, &p->smtc_r16);
	_serNrSysEncSQN_NR_SSB_ToMeasure_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(_buffer, _size, _lidx, &p->ssb_ToMeasure_r16);
	HTON_8(&_buffer[*_lidx], p->deriveSSB_IndexFromCell_r16, _lidx);
	_serNrSysEncSQN_NR_SS_RSSI_Measurement_SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(_buffer, _size, _lidx, &p->ss_RSSI_Measurement_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BeamMeasConfigIdle_NR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BeamMeasConfigIdle_NR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->reportQuantityRS_Indexes_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->maxNrofRS_IndexesToReport_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->includeBeamMeasurements_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BeamMeasConfigIdle_NR_r16_SQN_NR_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BeamMeasConfigIdle_NR_r16_SQN_NR_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_BeamMeasConfigIdle_NR_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierNR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierNR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreq_r16, _lidx);
	{
		size_t _tmp = (size_t)p->ssbSubcarrierSpacing_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_MultiFrequencyBandListNR_SQN_NR_MeasIdleCarrierNR_r16_frequencyBandList_Optional(_buffer, _size, _lidx, &p->frequencyBandList);
	_serNrSysEncSQN_NR_CellListNR_r16_SQN_NR_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(_buffer, _size, _lidx, &p->measCellListNR_r16);
	{
		size_t _tmp = (size_t)p->reportQuantities_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_qualityThreshold_r16_qualityThreshold_r16_Optional(_buffer, _size, _lidx, &p->qualityThreshold_r16);
	_serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(_buffer, _size, _lidx, &p->ssb_MeasConfig_r16);
	_serNrSysEncSQN_NR_BeamMeasConfigIdle_NR_r16_SQN_NR_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(_buffer, _size, _lidx, &p->beamMeasConfigIdle_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListNR_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierNR_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListNR_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_MeasIdleCarrierNR_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellListEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_measCellListEUTRA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellListEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_measCellListEUTRA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serNrSysEncSQN_NR_EUTRA_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRP_RangeEUTRA_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRP_Threshold_EUTRA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRP_RangeEUTRA_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRP_Threshold_EUTRA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RSRQ_RangeEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRQ_Threshold_EUTRA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RSRQ_RangeEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRQ_Threshold_EUTRA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_RSRP_RangeEUTRA_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRP_Threshold_EUTRA_r16_Optional(_buffer, _size, _lidx, &p->idleRSRP_Threshold_EUTRA_r16);
	_serNrSysEncSQN_NR_RSRQ_RangeEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_idleRSRQ_Threshold_EUTRA_r16_Optional(_buffer, _size, _lidx, &p->idleRSRQ_Threshold_EUTRA_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_qualityThresholdEUTRA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_qualityThresholdEUTRA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreqEUTRA_r16, _lidx);
	{
		size_t _tmp = (size_t)p->allowedMeasBandwidth_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_CellListEUTRA_r16_SQN_NR_MeasIdleCarrierEUTRA_r16_measCellListEUTRA_r16_Optional(_buffer, _size, _lidx, &p->measCellListEUTRA_r16);
	{
		size_t _tmp = (size_t)p->reportQuantitiesEUTRA_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16_qualityThresholdEUTRA_r16_qualityThresholdEUTRA_r16_Optional(_buffer, _size, _lidx, &p->qualityThresholdEUTRA_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListEUTRA_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleCarrierEUTRA_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListEUTRA_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleConfigSIB_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleConfigSIB_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MeasIdleCarrierNR_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListNR_r16_DynamicOptional(_buffer, _size, _lidx, &p->measIdleCarrierListNR_r16);
	_serNrSysEncSQN_NR_MeasIdleCarrierEUTRA_r16_SQN_NR_MeasIdleConfigSIB_r16_measIdleCarrierListEUTRA_r16_DynamicOptional(_buffer, _size, _lidx, &p->measIdleCarrierListEUTRA_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MeasIdleConfigSIB_r16_SQN_NR_SIB11_r16_measIdleConfigSIB_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MeasIdleConfigSIB_r16_SQN_NR_SIB11_r16_measIdleConfigSIB_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_MeasIdleConfigSIB_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB11_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB11_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB11_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB11_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MeasIdleConfigSIB_r16_SQN_NR_SIB11_r16_measIdleConfigSIB_r16_Optional(_buffer, _size, _lidx, &p->measIdleConfigSIB_r16);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB11_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB12_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB12_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->segmentNumber_r16, _lidx);
	{
		size_t _tmp = (size_t)p->segmentType_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->segmentContainer_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->segmentContainer_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->segmentContainer_r16.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB13_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB13_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB13_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB13_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->sl_V2X_ConfigCommon_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->sl_V2X_ConfigCommon_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->sl_V2X_ConfigCommon_r16.v[i2], _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->sl_Bandwidth_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->sl_Bandwidth_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->sl_Bandwidth_r16.v[i2], _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->tdd_Config_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->tdd_Config_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->tdd_Config_r16.v[i2], _lidx);
	}
	_serNrSysEncOCTET_STRING_SQN_NR_SIB13_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB14_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB14_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB14_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB14_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->sl_V2X_ConfigCommonExt_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->sl_V2X_ConfigCommonExt_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->sl_V2X_ConfigCommonExt_r16.v[i2], _lidx);
	}
	_serNrSysEncOCTET_STRING_SQN_NR_SIB14_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Value* p, enum SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib2) {
		_serNrSysEncSQN_NR_SIB2(_buffer, _size, _lidx, &p->sib2);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib3) {
		_serNrSysEncSQN_NR_SIB3(_buffer, _size, _lidx, &p->sib3);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib4) {
		_serNrSysEncSQN_NR_SIB4(_buffer, _size, _lidx, &p->sib4);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib5) {
		_serNrSysEncSQN_NR_SIB5(_buffer, _size, _lidx, &p->sib5);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib6) {
		_serNrSysEncSQN_NR_SIB6(_buffer, _size, _lidx, &p->sib6);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib7) {
		_serNrSysEncSQN_NR_SIB7(_buffer, _size, _lidx, &p->sib7);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib8) {
		_serNrSysEncSQN_NR_SIB8(_buffer, _size, _lidx, &p->sib8);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib9) {
		_serNrSysEncSQN_NR_SIB9(_buffer, _size, _lidx, &p->sib9);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib10_v1610) {
		_serNrSysEncSQN_NR_SIB10_r16(_buffer, _size, _lidx, &p->sib10_v1610);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib11_v1610) {
		_serNrSysEncSQN_NR_SIB11_r16(_buffer, _size, _lidx, &p->sib11_v1610);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib12_v1610) {
		_serNrSysEncSQN_NR_SIB12_r16(_buffer, _size, _lidx, &p->sib12_v1610);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib13_v1610) {
		_serNrSysEncSQN_NR_SIB13_r16(_buffer, _size, _lidx, &p->sib13_v1610);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_sib14_v1610) {
		_serNrSysEncSQN_NR_SIB14_r16(_buffer, _size, _lidx, &p->sib14_v1610);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SystemInformation_IEs_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SystemInformation_IEs_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation_IEs_nonCriticalExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation_IEs_nonCriticalExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation_IEs_nonCriticalExtension_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SystemInformation_IEs_nonCriticalExtension(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->sib_TypeAndInfo.d, _lidx);
	for (size_t i1 = 0; i1 < p->sib_TypeAndInfo.d; i1++) {
		_serNrSysEncSQN_NR_SystemInformation_IEs_sib_TypeAndInfo_s(_buffer, _size, _lidx, &p->sib_TypeAndInfo.v[i1]);
	}
	_serNrSysEncOCTET_STRING_SQN_NR_SystemInformation_IEs_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serNrSysEncSQN_NR_SystemInformation_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIBpos_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIBpos_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIBpos_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIBpos_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->assistanceDataSIB_Element_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->assistanceDataSIB_Element_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->assistanceDataSIB_Element_r16.v[i2], _lidx);
	}
	_serNrSysEncOCTET_STRING_SQN_NR_SIBpos_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_Value* p, enum SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_1_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_1_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_2_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_2_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_3_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_3_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_4_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_4_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_5_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_5_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_6_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_6_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_7_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_7_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib1_8_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib1_8_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_1_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_1_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_2_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_2_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_3_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_3_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_4_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_4_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_5_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_5_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_6_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_6_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_7_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_7_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_8_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_8_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_9_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_9_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_10_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_10_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_11_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_11_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_12_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_12_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_13_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_13_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_14_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_14_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_15_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_15_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_16_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_16_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_17_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_17_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_18_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_18_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_19_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_19_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_20_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_20_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_21_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_21_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_22_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_22_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib2_23_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib2_23_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib3_1_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib3_1_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib4_1_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib4_1_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib5_1_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib5_1_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib6_1_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib6_1_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib6_2_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib6_2_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_posSib6_3_r16) {
		_serNrSysEncSQN_NR_SIBpos_r16(_buffer, _size, _lidx, &p->posSib6_3_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_PosSystemInformation_r16_IEs_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_PosSystemInformation_r16_IEs_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_nonCriticalExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSystemInformation_r16_IEs_nonCriticalExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_nonCriticalExtension_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSystemInformation_r16_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_nonCriticalExtension(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSystemInformation_r16_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSystemInformation_r16_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->posSIB_TypeAndInfo_r16.d, _lidx);
	for (size_t i1 = 0; i1 < p->posSIB_TypeAndInfo_r16.d; i1++) {
		_serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_posSIB_TypeAndInfo_r16_s(_buffer, _size, _lidx, &p->posSIB_TypeAndInfo_r16.v[i1]);
	}
	_serNrSysEncOCTET_STRING_SQN_NR_PosSystemInformation_r16_IEs_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serNrSysEncSQN_NR_PosSystemInformation_r16_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_criticalExtensionsFuture(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_criticalExtensionsFuture* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_Value* p, enum SQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_posSystemInformation_r16) {
		_serNrSysEncSQN_NR_PosSystemInformation_r16_IEs(_buffer, _size, _lidx, &p->posSystemInformation_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_criticalExtensionsFuture) {
		_serNrSysEncSQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_criticalExtensionsFuture(_buffer, _size, _lidx, &p->criticalExtensionsFuture);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation_criticalExtensions_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SystemInformation_criticalExtensions_Value* p, enum SQN_NR_SystemInformation_criticalExtensions_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SystemInformation_criticalExtensions_systemInformation) {
		_serNrSysEncSQN_NR_SystemInformation_IEs(_buffer, _size, _lidx, &p->systemInformation);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16) {
		_serNrSysEncSQN_NR_SystemInformation_criticalExtensions_criticalExtensionsFuture_r16(_buffer, _size, _lidx, &p->criticalExtensionsFuture_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SystemInformation_criticalExtensions(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation_criticalExtensions* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SystemInformation_criticalExtensions_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SystemInformation(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SystemInformation* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SystemInformation_criticalExtensions(_buffer, _size, _lidx, &p->criticalExtensions);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SIB1_cellSelectionInfo_q_RxLevMinOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SIB1_cellSelectionInfo_q_RxLevMinOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_RxLevMin_SQN_NR_SIB1_cellSelectionInfo_q_RxLevMinSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_RxLevMin_SQN_NR_SIB1_cellSelectionInfo_q_RxLevMinSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_Q_QualMin_SQN_NR_SIB1_cellSelectionInfo_q_QualMin_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_Q_QualMin_SQN_NR_SIB1_cellSelectionInfo_q_QualMin_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SIB1_cellSelectionInfo_q_QualMinOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SIB1_cellSelectionInfo_q_QualMinOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_cellSelectionInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_cellSelectionInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	_serNrSysEncUint8_t_SQN_NR_SIB1_cellSelectionInfo_q_RxLevMinOffset_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffset);
	_serNrSysEncSQN_NR_Q_RxLevMin_SQN_NR_SIB1_cellSelectionInfo_q_RxLevMinSUL_Optional(_buffer, _size, _lidx, &p->q_RxLevMinSUL);
	_serNrSysEncSQN_NR_Q_QualMin_SQN_NR_SIB1_cellSelectionInfo_q_QualMin_Optional(_buffer, _size, _lidx, &p->q_QualMin);
	_serNrSysEncUint8_t_SQN_NR_SIB1_cellSelectionInfo_q_QualMinOffset_Optional(_buffer, _size, _lidx, &p->q_QualMinOffset);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_cellSelectionInfo_cellSelectionInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_cellSelectionInfo_cellSelectionInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB1_cellSelectionInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MCC_SQN_NR_PLMN_Identity_mcc_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MCC_SQN_NR_PLMN_Identity_mcc_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i3 = 0; i3 < 3; i3++) {
		HTON_8(&_buffer[*_lidx], p->v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PLMN_Identity(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PLMN_Identity* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MCC_SQN_NR_PLMN_Identity_mcc_Optional(_buffer, _size, _lidx, &p->mcc);
	HTON_32(&_buffer[*_lidx], p->mnc.d, _lidx);
	for (size_t i3 = 0; i3 < p->mnc.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->mnc.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TrackingAreaCode_SQN_NR_PLMN_IdentityInfo_trackingAreaCode_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TrackingAreaCode_SQN_NR_PLMN_IdentityInfo_trackingAreaCode_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 24; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RAN_AreaCode_SQN_NR_PLMN_IdentityInfo_ranac_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RAN_AreaCode_SQN_NR_PLMN_IdentityInfo_ranac_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PLMN_IdentityInfo_iab_Support_r16_e_iab_Support_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PLMN_IdentityInfo_iab_Support_r16_e_iab_Support_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PLMN_IdentityInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PLMN_IdentityInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->plmn_IdentityList.d, _lidx);
	for (size_t i2 = 0; i2 < p->plmn_IdentityList.d; i2++) {
		_serNrSysEncSQN_NR_PLMN_Identity(_buffer, _size, _lidx, &p->plmn_IdentityList.v[i2]);
	}
	_serNrSysEncSQN_NR_TrackingAreaCode_SQN_NR_PLMN_IdentityInfo_trackingAreaCode_Optional(_buffer, _size, _lidx, &p->trackingAreaCode);
	_serNrSysEncSQN_NR_RAN_AreaCode_SQN_NR_PLMN_IdentityInfo_ranac_Optional(_buffer, _size, _lidx, &p->ranac);
	for (size_t i2 = 0; i2 < 36; i2++) {
		HTON_8(&_buffer[*_lidx], p->cellIdentity[i2], _lidx);
	}
	{
		size_t _tmp = (size_t)p->cellReservedForOperatorUse;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PLMN_IdentityInfo_iab_Support_r16_e_iab_Support_r16_Optional(_buffer, _size, _lidx, &p->iab_Support_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellAccessRelatedInfo_cellReservedForOtherUse_e_cellReservedForOtherUse_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellAccessRelatedInfo_cellReservedForOtherUse_e_cellReservedForOtherUse_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellAccessRelatedInfo_cellReservedForFutureUse_r16_e_cellReservedForFutureUse_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellAccessRelatedInfo_cellReservedForFutureUse_r16_e_cellReservedForFutureUse_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CAG_IdentityInfo_r16_manualCAGselectionAllowed_r16_e_manualCAGselectionAllowed_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CAG_IdentityInfo_r16_manualCAGselectionAllowed_r16_e_manualCAGselectionAllowed_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CAG_IdentityInfo_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CAG_IdentityInfo_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i4 = 0; i4 < 32; i4++) {
		HTON_8(&_buffer[*_lidx], p->cag_Identity_r16[i4], _lidx);
	}
	_serNrSysEncSQN_NR_CAG_IdentityInfo_r16_manualCAGselectionAllowed_r16_e_manualCAGselectionAllowed_r16_Optional(_buffer, _size, _lidx, &p->manualCAGselectionAllowed_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NPN_Identity_r16_pni_npn_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NPN_Identity_r16_pni_npn_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PLMN_Identity(_buffer, _size, _lidx, &p->plmn_Identity_r16);
	HTON_32(&_buffer[*_lidx], p->cag_IdentityList_r16.d, _lidx);
	for (size_t i3 = 0; i3 < p->cag_IdentityList_r16.d; i3++) {
		_serNrSysEncSQN_NR_CAG_IdentityInfo_r16(_buffer, _size, _lidx, &p->cag_IdentityList_r16.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NPN_Identity_r16_snpn_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NPN_Identity_r16_snpn_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PLMN_Identity(_buffer, _size, _lidx, &p->plmn_Identity);
	HTON_32(&_buffer[*_lidx], p->nid_List_r16.d, _lidx);
	for (size_t i3 = 0; i3 < p->nid_List_r16.d; i3++) {
		for (size_t i4 = 0; i4 < 44; i4++) {
			HTON_8(&_buffer[*_lidx], p->nid_List_r16.v[i3][i4], _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NPN_Identity_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_NPN_Identity_r16_Value* p, enum SQN_NR_NPN_Identity_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_NPN_Identity_r16_pni_npn_r16) {
		_serNrSysEncSQN_NR_NPN_Identity_r16_pni_npn_r16(_buffer, _size, _lidx, &p->pni_npn_r16);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_NPN_Identity_r16_snpn_r16) {
		_serNrSysEncSQN_NR_NPN_Identity_r16_snpn_r16(_buffer, _size, _lidx, &p->snpn_r16);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_NPN_Identity_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NPN_Identity_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_NPN_Identity_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_RAN_AreaCode_SQN_NR_NPN_IdentityInfo_r16_ranac_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_RAN_AreaCode_SQN_NR_NPN_IdentityInfo_r16_ranac_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NPN_IdentityInfo_r16_iab_Support_r16_e_iab_Support_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NPN_IdentityInfo_r16_iab_Support_r16_e_iab_Support_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NPN_IdentityInfo_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NPN_IdentityInfo_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->npn_IdentityList_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->npn_IdentityList_r16.d; i2++) {
		_serNrSysEncSQN_NR_NPN_Identity_r16(_buffer, _size, _lidx, &p->npn_IdentityList_r16.v[i2]);
	}
	for (size_t i2 = 0; i2 < 24; i2++) {
		HTON_8(&_buffer[*_lidx], p->trackingAreaCode_r16[i2], _lidx);
	}
	_serNrSysEncSQN_NR_RAN_AreaCode_SQN_NR_NPN_IdentityInfo_r16_ranac_r16_Optional(_buffer, _size, _lidx, &p->ranac_r16);
	for (size_t i2 = 0; i2 < 36; i2++) {
		HTON_8(&_buffer[*_lidx], p->cellIdentity_r16[i2], _lidx);
	}
	{
		size_t _tmp = (size_t)p->cellReservedForOperatorUse_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_NPN_IdentityInfo_r16_iab_Support_r16_e_iab_Support_r16_Optional(_buffer, _size, _lidx, &p->iab_Support_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_NPN_IdentityInfoList_r16_SQN_NR_CellAccessRelatedInfo_npn_IdentityInfoList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_NPN_IdentityInfoList_r16_SQN_NR_CellAccessRelatedInfo_npn_IdentityInfoList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncSQN_NR_NPN_IdentityInfo_r16(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_CellAccessRelatedInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_CellAccessRelatedInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->plmn_IdentityList.d, _lidx);
	for (size_t i1 = 0; i1 < p->plmn_IdentityList.d; i1++) {
		_serNrSysEncSQN_NR_PLMN_IdentityInfo(_buffer, _size, _lidx, &p->plmn_IdentityList.v[i1]);
	}
	_serNrSysEncSQN_NR_CellAccessRelatedInfo_cellReservedForOtherUse_e_cellReservedForOtherUse_Optional(_buffer, _size, _lidx, &p->cellReservedForOtherUse);
	_serNrSysEncSQN_NR_CellAccessRelatedInfo_cellReservedForFutureUse_r16_e_cellReservedForFutureUse_r16_Optional(_buffer, _size, _lidx, &p->cellReservedForFutureUse_r16);
	_serNrSysEncSQN_NR_NPN_IdentityInfoList_r16_SQN_NR_CellAccessRelatedInfo_npn_IdentityInfoList_r16_Optional(_buffer, _size, _lidx, &p->npn_IdentityInfoList_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_ConnEstFailureControl_connEstFailOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_ConnEstFailureControl_connEstFailOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConnEstFailureControl(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConnEstFailureControl* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->connEstFailCount;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->connEstFailOffsetValidity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint8_t_SQN_NR_ConnEstFailureControl_connEstFailOffset_Optional(_buffer, _size, _lidx, &p->connEstFailOffset);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ConnEstFailureControl_SQN_NR_SIB1_connEstFailureControl_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ConnEstFailureControl_SQN_NR_SIB1_connEstFailureControl_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ConnEstFailureControl(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SIB_TypeInfo_valueTag_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SIB_TypeInfo_valueTag_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB_TypeInfo_areaScope_e_areaScope_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB_TypeInfo_areaScope_e_areaScope_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB_TypeInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB_TypeInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->type;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncUint8_t_SQN_NR_SIB_TypeInfo_valueTag_Optional(_buffer, _size, _lidx, &p->valueTag);
	_serNrSysEncSQN_NR_SIB_TypeInfo_areaScope_e_areaScope_Optional(_buffer, _size, _lidx, &p->areaScope);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SchedulingInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SchedulingInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->si_BroadcastStatus;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->si_Periodicity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->sib_MappingInfo.d, _lidx);
	for (size_t i2 = 0; i2 < p->sib_MappingInfo.d; i2++) {
		_serNrSysEncSQN_NR_SIB_TypeInfo(_buffer, _size, _lidx, &p->sib_MappingInfo.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_SI_SchedulingInfo_si_RequestConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig_SQN_NR_SI_SchedulingInfo_si_RequestConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SI_RequestConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_SI_SchedulingInfo_si_RequestConfigSUL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig_SQN_NR_SI_SchedulingInfo_si_RequestConfigSUL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SI_RequestConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB24_SQN_NR_SI_SchedulingInfo_systemInformationAreaID_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B24_SQN_NR_SI_SchedulingInfo_systemInformationAreaID_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 24; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_SchedulingInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_SchedulingInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->schedulingInfoList.d, _lidx);
	for (size_t i1 = 0; i1 < p->schedulingInfoList.d; i1++) {
		_serNrSysEncSQN_NR_SchedulingInfo(_buffer, _size, _lidx, &p->schedulingInfoList.v[i1]);
	}
	{
		size_t _tmp = (size_t)p->si_WindowLength;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_SI_SchedulingInfo_si_RequestConfig_Optional(_buffer, _size, _lidx, &p->si_RequestConfig);
	_serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_SI_SchedulingInfo_si_RequestConfigSUL_Optional(_buffer, _size, _lidx, &p->si_RequestConfigSUL);
	_serNrSysEncB24_SQN_NR_SI_SchedulingInfo_systemInformationAreaID_Optional(_buffer, _size, _lidx, &p->systemInformationAreaID);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_SchedulingInfo_SQN_NR_SIB1_si_SchedulingInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_SchedulingInfo_SQN_NR_SIB1_si_SchedulingInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SI_SchedulingInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FrequencyInfoDL_SIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FrequencyInfoDL_SIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->frequencyBandList.d, _lidx);
	for (size_t i1 = 0; i1 < p->frequencyBandList.d; i1++) {
		_serNrSysEncSQN_NR_NR_MultiBandInfo(_buffer, _size, _lidx, &p->frequencyBandList.v[i1]);
	}
	HTON_16(&_buffer[*_lidx], p->offsetToPointA, _lidx);
	HTON_32(&_buffer[*_lidx], p->scs_SpecificCarrierList.d, _lidx);
	for (size_t i1 = 0; i1 < p->scs_SpecificCarrierList.d; i1++) {
		_serNrSysEncSQN_NR_SCS_SpecificCarrier(_buffer, _size, _lidx, &p->scs_SpecificCarrierList.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSetZero_SQN_NR_PDCCH_ConfigCommon_controlResourceSetZero_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSetZero_SQN_NR_PDCCH_ConfigCommon_controlResourceSetZero_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSet_SQN_NR_PDCCH_ConfigCommon_commonControlResourceSet_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSet_SQN_NR_PDCCH_ConfigCommon_commonControlResourceSet_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ControlResourceSet(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceZero_SQN_NR_PDCCH_ConfigCommon_searchSpaceZero_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceZero_SQN_NR_PDCCH_ConfigCommon_searchSpaceZero_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpace_SQN_NR_PDCCH_ConfigCommon_commonSearchSpaceList_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpace_SQN_NR_PDCCH_ConfigCommon_commonSearchSpaceList_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncSQN_NR_SearchSpace(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_searchSpaceSIB1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_searchSpaceSIB1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_searchSpaceOtherSystemInformation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_searchSpaceOtherSystemInformation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_pagingSearchSpace_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_pagingSearchSpace_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_ra_SearchSpace_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_ra_SearchSpace_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_Value* p, enum SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS15KHZoneT) {
		HTON_32(&_buffer[*_lidx], p->sCS15KHZoneT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS15KHZoneT.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->sCS15KHZoneT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS30KHZoneT_SCS15KHZhalfT) {
		HTON_32(&_buffer[*_lidx], p->sCS30KHZoneT_SCS15KHZhalfT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS30KHZoneT_SCS15KHZhalfT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS30KHZoneT_SCS15KHZhalfT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT) {
		HTON_32(&_buffer[*_lidx], p->sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZoneEighthT_SCS60KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZoneEighthT_SCS60KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZoneEighthT_SCS60KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_firstPDCCH_MonitoringOccasionOfPO_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_firstPDCCH_MonitoringOccasionOfPO_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ControlResourceSetId_r16_SQN_NR_SearchSpaceExt_r16_controlResourceSetId_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ControlResourceSetId_r16_SQN_NR_SearchSpaceExt_r16_controlResourceSetId_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel1_r16_e_aggregationLevel1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel1_r16_e_aggregationLevel1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel2_r16_e_aggregationLevel2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel2_r16_e_aggregationLevel2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel4_r16_e_aggregationLevel4_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel4_r16_e_aggregationLevel4_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel8_r16_e_aggregationLevel8_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel8_r16_e_aggregationLevel8_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel16_r16_e_aggregationLevel16_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel16_r16_e_aggregationLevel16_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel1_r16_e_aggregationLevel1_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel1_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel2_r16_e_aggregationLevel2_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel2_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel4_r16_e_aggregationLevel4_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel4_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel8_r16_e_aggregationLevel8_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel8_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16aggregationLevel16_r16_e_aggregationLevel16_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel16_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16nrofCandidates_CI_r16(_buffer, _size, _lidx, &p->nrofCandidates_CI_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16_dci_Format2_4_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16_dci_Format2_4_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel1_r16_e_aggregationLevel1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel1_r16_e_aggregationLevel1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel2_r16_e_aggregationLevel2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel2_r16_e_aggregationLevel2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel4_r16_e_aggregationLevel4_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel4_r16_e_aggregationLevel4_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel8_r16_e_aggregationLevel8_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel8_r16_e_aggregationLevel8_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel16_r16_e_aggregationLevel16_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel16_r16_e_aggregationLevel16_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel1_r16_e_aggregationLevel1_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel1_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel2_r16_e_aggregationLevel2_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel2_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel4_r16_e_aggregationLevel4_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel4_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel8_r16_e_aggregationLevel8_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel8_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16aggregationLevel16_r16_e_aggregationLevel16_r16_Optional(_buffer, _size, _lidx, &p->aggregationLevel16_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16nrofCandidates_IAB_r16(_buffer, _size, _lidx, &p->nrofCandidates_IAB_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16_dci_Format2_5_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16_dci_Format2_5_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_6_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_6_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_6_r16_dci_Format2_6_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_6_r16_dci_Format2_6_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_6_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_4_r16_dci_Format2_4_r16_Optional(_buffer, _size, _lidx, &p->dci_Format2_4_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_5_r16_dci_Format2_5_r16_Optional(_buffer, _size, _lidx, &p->dci_Format2_5_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16_dci_Format2_6_r16_dci_Format2_6_r16_Optional(_buffer, _size, _lidx, &p->dci_Format2_6_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_common_r16(_buffer, _size, _lidx, &p->common_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_searchSpaceType_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_searchSpaceType_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_SearchSpaceExt_r16_searchSpaceGroupIdList_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_SearchSpaceExt_r16_searchSpaceGroupIdList_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB5_SQN_NR_SearchSpaceExt_r16_freqMonitorLocations_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B5_SQN_NR_SearchSpaceExt_r16_freqMonitorLocations_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 5; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ControlResourceSetId_r16_SQN_NR_SearchSpaceExt_r16_controlResourceSetId_r16_Optional(_buffer, _size, _lidx, &p->controlResourceSetId_r16);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_searchSpaceType_r16_searchSpaceType_r16_Optional(_buffer, _size, _lidx, &p->searchSpaceType_r16);
	_serNrSysEncUint8_t_SQN_NR_SearchSpaceExt_r16_searchSpaceGroupIdList_r16_DynamicOptional(_buffer, _size, _lidx, &p->searchSpaceGroupIdList_r16);
	_serNrSysEncB5_SQN_NR_SearchSpaceExt_r16_freqMonitorLocations_r16_Optional(_buffer, _size, _lidx, &p->freqMonitorLocations_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SearchSpaceExt_r16_SQN_NR_PDCCH_ConfigCommon_commonSearchSpaceListExt_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SearchSpaceExt_r16_SQN_NR_PDCCH_ConfigCommon_commonSearchSpaceListExt_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncSQN_NR_SearchSpaceExt_r16(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PDCCH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PDCCH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_ControlResourceSetZero_SQN_NR_PDCCH_ConfigCommon_controlResourceSetZero_Optional(_buffer, _size, _lidx, &p->controlResourceSetZero);
	_serNrSysEncSQN_NR_ControlResourceSet_SQN_NR_PDCCH_ConfigCommon_commonControlResourceSet_Optional(_buffer, _size, _lidx, &p->commonControlResourceSet);
	_serNrSysEncSQN_NR_SearchSpaceZero_SQN_NR_PDCCH_ConfigCommon_searchSpaceZero_Optional(_buffer, _size, _lidx, &p->searchSpaceZero);
	_serNrSysEncSQN_NR_SearchSpace_SQN_NR_PDCCH_ConfigCommon_commonSearchSpaceList_DynamicOptional(_buffer, _size, _lidx, &p->commonSearchSpaceList);
	_serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_searchSpaceSIB1_Optional(_buffer, _size, _lidx, &p->searchSpaceSIB1);
	_serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_searchSpaceOtherSystemInformation_Optional(_buffer, _size, _lidx, &p->searchSpaceOtherSystemInformation);
	_serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_pagingSearchSpace_Optional(_buffer, _size, _lidx, &p->pagingSearchSpace);
	_serNrSysEncSQN_NR_SearchSpaceId_SQN_NR_PDCCH_ConfigCommon_ra_SearchSpace_Optional(_buffer, _size, _lidx, &p->ra_SearchSpace);
	_serNrSysEncSQN_NR_PDCCH_ConfigCommon_firstPDCCH_MonitoringOccasionOfPO_firstPDCCH_MonitoringOccasionOfPO_Optional(_buffer, _size, _lidx, &p->firstPDCCH_MonitoringOccasionOfPO);
	_serNrSysEncSQN_NR_SearchSpaceExt_r16_SQN_NR_PDCCH_ConfigCommon_commonSearchSpaceListExt_r16_DynamicOptional(_buffer, _size, _lidx, &p->commonSearchSpaceListExt_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_setup) {
		_serNrSysEncSQN_NR_PDCCH_ConfigCommon(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_SQN_NR_BWP_DownlinkCommon_pdcch_ConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_SQN_NR_BWP_DownlinkCommon_pdcch_ConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_Value* p, enum SQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_setup) {
		_serNrSysEncSQN_NR_PDSCH_ConfigCommon(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_SQN_NR_BWP_DownlinkCommon_pdsch_ConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_SQN_NR_BWP_DownlinkCommon_pdsch_ConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BWP_DownlinkCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BWP_DownlinkCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BWP(_buffer, _size, _lidx, &p->genericParameters);
	_serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdcch_ConfigCommon_SQN_NR_BWP_DownlinkCommon_pdcch_ConfigCommon_Optional(_buffer, _size, _lidx, &p->pdcch_ConfigCommon);
	_serNrSysEncSQN_NR_SetupRelease_BWP_DownlinkCommon_pdsch_ConfigCommon_SQN_NR_BWP_DownlinkCommon_pdsch_ConfigCommon_Optional(_buffer, _size, _lidx, &p->pdsch_ConfigCommon);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->modificationPeriodCoeff;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PCCH_Config_nAndPagingFrameOffset_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PCCH_Config_nAndPagingFrameOffset_Value* p, enum SQN_NR_PCCH_Config_nAndPagingFrameOffset_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PCCH_Config_nAndPagingFrameOffset_oneT) {
		HTON_8(&_buffer[*_lidx], p->oneT, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_nAndPagingFrameOffset_halfT) {
		HTON_8(&_buffer[*_lidx], p->halfT, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_nAndPagingFrameOffset_quarterT) {
		HTON_8(&_buffer[*_lidx], p->quarterT, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_nAndPagingFrameOffset_oneEighthT) {
		HTON_8(&_buffer[*_lidx], p->oneEighthT, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_nAndPagingFrameOffset_oneSixteenthT) {
		HTON_8(&_buffer[*_lidx], p->oneSixteenthT, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PCCH_Config_nAndPagingFrameOffset(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PCCH_Config_nAndPagingFrameOffset* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PCCH_Config_nAndPagingFrameOffset_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_Value* p, enum SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS15KHZoneT) {
		HTON_32(&_buffer[*_lidx], p->sCS15KHZoneT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS15KHZoneT.d; i1++) {
			HTON_8(&_buffer[*_lidx], p->sCS15KHZoneT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS30KHZoneT_SCS15KHZhalfT) {
		HTON_32(&_buffer[*_lidx], p->sCS30KHZoneT_SCS15KHZhalfT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS30KHZoneT_SCS15KHZhalfT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS30KHZoneT_SCS15KHZhalfT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT) {
		HTON_32(&_buffer[*_lidx], p->sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS60KHZoneT_SCS30KHZhalfT_SCS15KHZquarterT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZoneT_SCS60KHZhalfT_SCS30KHZquarterT_SCS15KHZoneEighthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZhalfT_SCS60KHZquarterT_SCS30KHZoneEighthT_SCS15KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZquarterT_SCS60KHZoneEighthT_SCS30KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZoneEighthT_SCS60KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZoneEighthT_SCS60KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZoneEighthT_SCS60KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZoneEighthT_SCS60KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_sCS120KHZoneSixteenthT) {
		HTON_32(&_buffer[*_lidx], p->sCS120KHZoneSixteenthT.d, _lidx);
		for (size_t i1 = 0; i1 < p->sCS120KHZoneSixteenthT.d; i1++) {
			HTON_16(&_buffer[*_lidx], p->sCS120KHZoneSixteenthT.v[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_firstPDCCH_MonitoringOccasionOfPO_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_firstPDCCH_MonitoringOccasionOfPO_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncUint8_t_SQN_NR_PCCH_Config_nrofPDCCH_MonitoringOccasionPerSSB_InPO_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_NR_PCCH_Config_nrofPDCCH_MonitoringOccasionPerSSB_InPO_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PCCH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PCCH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->defaultPagingCycle;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PCCH_Config_nAndPagingFrameOffset(_buffer, _size, _lidx, &p->nAndPagingFrameOffset);
	{
		size_t _tmp = (size_t)p->ns;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PCCH_Config_firstPDCCH_MonitoringOccasionOfPO_firstPDCCH_MonitoringOccasionOfPO_Optional(_buffer, _size, _lidx, &p->firstPDCCH_MonitoringOccasionOfPO);
	_serNrSysEncUint8_t_SQN_NR_PCCH_Config_nrofPDCCH_MonitoringOccasionPerSSB_InPO_r16_Optional(_buffer, _size, _lidx, &p->nrofPDCCH_MonitoringOccasionPerSSB_InPO_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_DownlinkConfigCommonSIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_DownlinkConfigCommonSIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_FrequencyInfoDL_SIB(_buffer, _size, _lidx, &p->frequencyInfoDL);
	_serNrSysEncSQN_NR_BWP_DownlinkCommon(_buffer, _size, _lidx, &p->initialDownlinkBWP);
	_serNrSysEncSQN_NR_BCCH_Config(_buffer, _size, _lidx, &p->bcch_Config);
	_serNrSysEncSQN_NR_PCCH_Config(_buffer, _size, _lidx, &p->pcch_Config);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_FrequencyInfoUL_SIB_frequencyBandList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_FrequencyInfoUL_SIB_frequencyBandList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncSQN_NR_NR_MultiBandInfo(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_SIB_absoluteFrequencyPointA_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_SIB_absoluteFrequencyPointA_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_P_Max_SQN_NR_FrequencyInfoUL_SIB_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_P_Max_SQN_NR_FrequencyInfoUL_SIB_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FrequencyInfoUL_SIB_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FrequencyInfoUL_SIB_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_FrequencyInfoUL_SIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_FrequencyInfoUL_SIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_MultiFrequencyBandListNR_SIB_SQN_NR_FrequencyInfoUL_SIB_frequencyBandList_Optional(_buffer, _size, _lidx, &p->frequencyBandList);
	_serNrSysEncSQN_NR_ARFCN_ValueNR_SQN_NR_FrequencyInfoUL_SIB_absoluteFrequencyPointA_Optional(_buffer, _size, _lidx, &p->absoluteFrequencyPointA);
	HTON_32(&_buffer[*_lidx], p->scs_SpecificCarrierList.d, _lidx);
	for (size_t i1 = 0; i1 < p->scs_SpecificCarrierList.d; i1++) {
		_serNrSysEncSQN_NR_SCS_SpecificCarrier(_buffer, _size, _lidx, &p->scs_SpecificCarrierList.v[i1]);
	}
	_serNrSysEncSQN_NR_P_Max_SQN_NR_FrequencyInfoUL_SIB_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	_serNrSysEncSQN_NR_FrequencyInfoUL_SIB_frequencyShift7p5khz_e_frequencyShift7p5khz_Optional(_buffer, _size, _lidx, &p->frequencyShift7p5khz);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UplinkConfigCommonSIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UplinkConfigCommonSIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_FrequencyInfoUL_SIB(_buffer, _size, _lidx, &p->frequencyInfoUL);
	_serNrSysEncSQN_NR_BWP_UplinkCommon(_buffer, _size, _lidx, &p->initialUplinkBWP);
	{
		size_t _tmp = (size_t)p->timeAlignmentTimerCommon;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UplinkConfigCommonSIB_SQN_NR_ServingCellConfigCommonSIB_uplinkConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UplinkConfigCommonSIB_SQN_NR_ServingCellConfigCommonSIB_uplinkConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_UplinkConfigCommonSIB(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UplinkConfigCommonSIB_SQN_NR_ServingCellConfigCommonSIB_supplementaryUplink_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UplinkConfigCommonSIB_SQN_NR_ServingCellConfigCommonSIB_supplementaryUplink_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_UplinkConfigCommonSIB(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB_n_TimingAdvanceOffset_e_n_TimingAdvanceOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServingCellConfigCommonSIB_n_TimingAdvanceOffset_e_n_TimingAdvanceOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncB8_SQN_NR_ServingCellConfigCommonSIB_ssb_PositionsInBurst_groupPresence_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B8_SQN_NR_ServingCellConfigCommonSIB_ssb_PositionsInBurst_groupPresence_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 8; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB_ssb_PositionsInBurst(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServingCellConfigCommonSIB_ssb_PositionsInBurst* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i1 = 0; i1 < 8; i1++) {
		HTON_8(&_buffer[*_lidx], p->inOneGroup[i1], _lidx);
	}
	_serNrSysEncB8_SQN_NR_ServingCellConfigCommonSIB_ssb_PositionsInBurst_groupPresence_Optional(_buffer, _size, _lidx, &p->groupPresence);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_TDD_UL_DL_ConfigCommon_SQN_NR_ServingCellConfigCommonSIB_tdd_UL_DL_ConfigurationCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_TDD_UL_DL_ConfigCommon_SQN_NR_ServingCellConfigCommonSIB_tdd_UL_DL_ConfigurationCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_TDD_UL_DL_ConfigCommon(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SemiStaticChannelAccessConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SemiStaticChannelAccessConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->period;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_Value* p, enum SQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_dynamic) {
		HTON_8(&_buffer[*_lidx], p->dynamic, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_semiStatic) {
		_serNrSysEncSQN_NR_SemiStaticChannelAccessConfig(_buffer, _size, _lidx, &p->semiStatic);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_channelAccessMode_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_channelAccessMode_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB_discoveryBurstWindowLength_r16_e_discoveryBurstWindowLength_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServingCellConfigCommonSIB_discoveryBurstWindowLength_r16_e_discoveryBurstWindowLength_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_HighSpeedConfig_r16_highSpeedMeasFlag_r16_e_highSpeedMeasFlag_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_HighSpeedConfig_r16_highSpeedMeasFlag_r16_e_highSpeedMeasFlag_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_HighSpeedConfig_r16_highSpeedDemodFlag_r16_e_highSpeedDemodFlag_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_HighSpeedConfig_r16_highSpeedDemodFlag_r16_e_highSpeedDemodFlag_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_HighSpeedConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_HighSpeedConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_HighSpeedConfig_r16_highSpeedMeasFlag_r16_e_highSpeedMeasFlag_r16_Optional(_buffer, _size, _lidx, &p->highSpeedMeasFlag_r16);
	_serNrSysEncSQN_NR_HighSpeedConfig_r16_highSpeedDemodFlag_r16_e_highSpeedDemodFlag_r16_Optional(_buffer, _size, _lidx, &p->highSpeedDemodFlag_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_HighSpeedConfig_r16_SQN_NR_ServingCellConfigCommonSIB_highSpeedConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_HighSpeedConfig_r16_SQN_NR_ServingCellConfigCommonSIB_highSpeedConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_HighSpeedConfig_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServingCellConfigCommonSIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_DownlinkConfigCommonSIB(_buffer, _size, _lidx, &p->downlinkConfigCommon);
	_serNrSysEncSQN_NR_UplinkConfigCommonSIB_SQN_NR_ServingCellConfigCommonSIB_uplinkConfigCommon_Optional(_buffer, _size, _lidx, &p->uplinkConfigCommon);
	_serNrSysEncSQN_NR_UplinkConfigCommonSIB_SQN_NR_ServingCellConfigCommonSIB_supplementaryUplink_Optional(_buffer, _size, _lidx, &p->supplementaryUplink);
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB_n_TimingAdvanceOffset_e_n_TimingAdvanceOffset_Optional(_buffer, _size, _lidx, &p->n_TimingAdvanceOffset);
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB_ssb_PositionsInBurst(_buffer, _size, _lidx, &p->ssb_PositionsInBurst);
	{
		size_t _tmp = (size_t)p->ssb_PeriodicityServingCell;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_TDD_UL_DL_ConfigCommon_SQN_NR_ServingCellConfigCommonSIB_tdd_UL_DL_ConfigurationCommon_Optional(_buffer, _size, _lidx, &p->tdd_UL_DL_ConfigurationCommon);
	HTON_8(&_buffer[*_lidx], p->ss_PBCH_BlockPower, _lidx);
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB_channelAccessMode_r16_channelAccessMode_r16_Optional(_buffer, _size, _lidx, &p->channelAccessMode_r16);
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB_discoveryBurstWindowLength_r16_e_discoveryBurstWindowLength_r16_Optional(_buffer, _size, _lidx, &p->discoveryBurstWindowLength_r16);
	_serNrSysEncSQN_NR_HighSpeedConfig_r16_SQN_NR_ServingCellConfigCommonSIB_highSpeedConfig_r16_Optional(_buffer, _size, _lidx, &p->highSpeedConfig_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_ServingCellConfigCommonSIB_SQN_NR_SIB1_servingCellConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_ServingCellConfigCommonSIB_SQN_NR_SIB1_servingCellConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_ims_EmergencySupport_e_ims_EmergencySupport_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_ims_EmergencySupport_e_ims_EmergencySupport_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_eCallOverIMS_Support_e_eCallOverIMS_Support_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_eCallOverIMS_Support_e_eCallOverIMS_Support_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UE_TimersAndConstants(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UE_TimersAndConstants* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->t300;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t301;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t310;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->n310;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t311;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->n311;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t319;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UE_TimersAndConstants_SQN_NR_SIB1_ue_TimersAndConstants_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UE_TimersAndConstants_SQN_NR_SIB1_ue_TimersAndConstants_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_UE_TimersAndConstants(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UAC_BarringPerCat(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UAC_BarringPerCat* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->accessCategory, _lidx);
	HTON_8(&_buffer[*_lidx], p->uac_barringInfoSetIndex, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UAC_BarringPerCatList_SQN_NR_SIB1_uac_BarringInfo_uac_BarringForCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UAC_BarringPerCatList_SQN_NR_SIB1_uac_BarringInfo_uac_BarringForCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncSQN_NR_UAC_BarringPerCat(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_Value* p, enum SQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_uac_ImplicitACBarringList) {
		for (size_t i2 = 0; i2 < 63; i2++) {
			HTON_8(&_buffer[*_lidx], p->uac_ImplicitACBarringList[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_uac_ExplicitACBarringList) {
		HTON_32(&_buffer[*_lidx], p->uac_ExplicitACBarringList.d, _lidx);
		for (size_t i2 = 0; i2 < p->uac_ExplicitACBarringList.d; i2++) {
			_serNrSysEncSQN_NR_UAC_BarringPerCat(_buffer, _size, _lidx, &p->uac_ExplicitACBarringList.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_uac_ACBarringListType_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_uac_ACBarringListType_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UAC_BarringPerPLMN(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UAC_BarringPerPLMN* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_IdentityIndex, _lidx);
	_serNrSysEncSQN_NR_UAC_BarringPerPLMN_uac_ACBarringListType_uac_ACBarringListType_Optional(_buffer, _size, _lidx, &p->uac_ACBarringListType);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UAC_BarringPerPLMN_List_SQN_NR_SIB1_uac_BarringInfo_uac_BarringPerPLMN_List_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UAC_BarringPerPLMN_List_SQN_NR_SIB1_uac_BarringInfo_uac_BarringPerPLMN_List_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncSQN_NR_UAC_BarringPerPLMN(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_UAC_BarringInfoSet(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_UAC_BarringInfoSet* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->uac_BarringFactor;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->uac_BarringTime;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	for (size_t i2 = 0; i2 < 7; i2++) {
		HTON_8(&_buffer[*_lidx], p->uac_BarringForAccessIdentity[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_Value* p, enum SQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_plmnCommon) {
		{
			size_t _tmp = (size_t)p->plmnCommon;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_individualPLMNList) {
		HTON_32(&_buffer[*_lidx], p->individualPLMNList.d, _lidx);
		for (size_t i1 = 0; i1 < p->individualPLMNList.d; i1++) {
			{
				size_t _tmp = (size_t)p->individualPLMNList.v[i1];
				HTON_32(&_buffer[*_lidx], _tmp, _lidx);
			}
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_uac_AccessCategory1_SelectionAssistanceInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_uac_AccessCategory1_SelectionAssistanceInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_uac_BarringInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_uac_BarringInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_UAC_BarringPerCatList_SQN_NR_SIB1_uac_BarringInfo_uac_BarringForCommon_Optional(_buffer, _size, _lidx, &p->uac_BarringForCommon);
	_serNrSysEncSQN_NR_UAC_BarringPerPLMN_List_SQN_NR_SIB1_uac_BarringInfo_uac_BarringPerPLMN_List_Optional(_buffer, _size, _lidx, &p->uac_BarringPerPLMN_List);
	HTON_32(&_buffer[*_lidx], p->uac_BarringInfoSetList.d, _lidx);
	for (size_t i1 = 0; i1 < p->uac_BarringInfoSetList.d; i1++) {
		_serNrSysEncSQN_NR_UAC_BarringInfoSet(_buffer, _size, _lidx, &p->uac_BarringInfoSetList.v[i1]);
	}
	_serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_AccessCategory1_SelectionAssistanceInfo_uac_AccessCategory1_SelectionAssistanceInfo_Optional(_buffer, _size, _lidx, &p->uac_AccessCategory1_SelectionAssistanceInfo);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_BarringInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_uac_BarringInfo_uac_BarringInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB1_uac_BarringInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_useFullResumeID_e_useFullResumeID_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_useFullResumeID_e_useFullResumeID_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncOCTET_STRING_SQN_NR_SIB1_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_NR_SIB1_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_v1610_IEs_idleModeMeasurementsEUTRA_r16_e_idleModeMeasurementsEUTRA_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_v1610_IEs_idleModeMeasurementsEUTRA_r16_e_idleModeMeasurementsEUTRA_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_v1610_IEs_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_v1610_IEs_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSchedulingInfo_r16_offsetToSI_Used_r16_e_offsetToSI_Used_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSchedulingInfo_r16_offsetToSI_Used_r16_e_offsetToSI_Used_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSIB_Type_r16_encrypted_r16_e_encrypted_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSIB_Type_r16_encrypted_r16_e_encrypted_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_GNSS_ID_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_GNSS_ID_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->gnss_id_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_GNSS_ID_r16_SQN_NR_PosSIB_Type_r16_gnss_id_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_GNSS_ID_r16_SQN_NR_PosSIB_Type_r16_gnss_id_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_GNSS_ID_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SBAS_ID_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SBAS_ID_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sbas_id_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SBAS_ID_r16_SQN_NR_PosSIB_Type_r16_sbas_id_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SBAS_ID_r16_SQN_NR_PosSIB_Type_r16_sbas_id_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SBAS_ID_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSIB_Type_r16_areaScope_r16_e_areaScope_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSIB_Type_r16_areaScope_r16_e_areaScope_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSIB_Type_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSIB_Type_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PosSIB_Type_r16_encrypted_r16_e_encrypted_r16_Optional(_buffer, _size, _lidx, &p->encrypted_r16);
	_serNrSysEncSQN_NR_GNSS_ID_r16_SQN_NR_PosSIB_Type_r16_gnss_id_r16_Optional(_buffer, _size, _lidx, &p->gnss_id_r16);
	_serNrSysEncSQN_NR_SBAS_ID_r16_SQN_NR_PosSIB_Type_r16_sbas_id_r16_Optional(_buffer, _size, _lidx, &p->sbas_id_r16);
	{
		size_t _tmp = (size_t)p->posSibType_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_PosSIB_Type_r16_areaScope_r16_e_areaScope_r16_Optional(_buffer, _size, _lidx, &p->areaScope_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSchedulingInfo_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSchedulingInfo_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_PosSchedulingInfo_r16_offsetToSI_Used_r16_e_offsetToSI_Used_r16_Optional(_buffer, _size, _lidx, &p->offsetToSI_Used_r16);
	{
		size_t _tmp = (size_t)p->posSI_Periodicity_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->posSI_BroadcastStatus_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->posSIB_MappingInfo_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->posSIB_MappingInfo_r16.d; i2++) {
		_serNrSysEncSQN_NR_PosSIB_Type_r16(_buffer, _size, _lidx, &p->posSIB_MappingInfo_r16.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_PosSI_SchedulingInfo_r16_posSI_RequestConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig_SQN_NR_PosSI_SchedulingInfo_r16_posSI_RequestConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SI_RequestConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_PosSI_SchedulingInfo_r16_posSI_RequestConfigSUL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SI_RequestConfig_SQN_NR_PosSI_SchedulingInfo_r16_posSI_RequestConfigSUL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SI_RequestConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSI_SchedulingInfo_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSI_SchedulingInfo_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->posSchedulingInfoList_r16.d, _lidx);
	for (size_t i1 = 0; i1 < p->posSchedulingInfoList_r16.d; i1++) {
		_serNrSysEncSQN_NR_PosSchedulingInfo_r16(_buffer, _size, _lidx, &p->posSchedulingInfoList_r16.v[i1]);
	}
	_serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_PosSI_SchedulingInfo_r16_posSI_RequestConfig_r16_Optional(_buffer, _size, _lidx, &p->posSI_RequestConfig_r16);
	_serNrSysEncSQN_NR_SI_RequestConfig_SQN_NR_PosSI_SchedulingInfo_r16_posSI_RequestConfigSUL_r16_Optional(_buffer, _size, _lidx, &p->posSI_RequestConfigSUL_r16);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_PosSI_SchedulingInfo_r16_SQN_NR_SIB1_v1610_IEs_posSI_SchedulingInfo_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_PosSI_SchedulingInfo_r16_SQN_NR_SIB1_v1610_IEs_posSI_SchedulingInfo_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_PosSI_SchedulingInfo_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_v1610_IEs_nonCriticalExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_v1610_IEs_nonCriticalExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB1_v1610_IEs_nonCriticalExtension(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_v1610_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_v1610_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SIB1_v1610_IEs_idleModeMeasurementsEUTRA_r16_e_idleModeMeasurementsEUTRA_r16_Optional(_buffer, _size, _lidx, &p->idleModeMeasurementsEUTRA_r16);
	_serNrSysEncSQN_NR_SIB1_v1610_IEs_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional(_buffer, _size, _lidx, &p->idleModeMeasurementsNR_r16);
	_serNrSysEncSQN_NR_PosSI_SchedulingInfo_r16_SQN_NR_SIB1_v1610_IEs_posSI_SchedulingInfo_r16_Optional(_buffer, _size, _lidx, &p->posSI_SchedulingInfo_r16);
	_serNrSysEncSQN_NR_SIB1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1_v1610_IEs_SQN_NR_SIB1_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1_v1610_IEs_SQN_NR_SIB1_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_SIB1_v1610_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_SIB1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_SIB1* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_SIB1_cellSelectionInfo_cellSelectionInfo_Optional(_buffer, _size, _lidx, &p->cellSelectionInfo);
	_serNrSysEncSQN_NR_CellAccessRelatedInfo(_buffer, _size, _lidx, &p->cellAccessRelatedInfo);
	_serNrSysEncSQN_NR_ConnEstFailureControl_SQN_NR_SIB1_connEstFailureControl_Optional(_buffer, _size, _lidx, &p->connEstFailureControl);
	_serNrSysEncSQN_NR_SI_SchedulingInfo_SQN_NR_SIB1_si_SchedulingInfo_Optional(_buffer, _size, _lidx, &p->si_SchedulingInfo);
	_serNrSysEncSQN_NR_ServingCellConfigCommonSIB_SQN_NR_SIB1_servingCellConfigCommon_Optional(_buffer, _size, _lidx, &p->servingCellConfigCommon);
	_serNrSysEncSQN_NR_SIB1_ims_EmergencySupport_e_ims_EmergencySupport_Optional(_buffer, _size, _lidx, &p->ims_EmergencySupport);
	_serNrSysEncSQN_NR_SIB1_eCallOverIMS_Support_e_eCallOverIMS_Support_Optional(_buffer, _size, _lidx, &p->eCallOverIMS_Support);
	_serNrSysEncSQN_NR_UE_TimersAndConstants_SQN_NR_SIB1_ue_TimersAndConstants_Optional(_buffer, _size, _lidx, &p->ue_TimersAndConstants);
	_serNrSysEncSQN_NR_SIB1_uac_BarringInfo_uac_BarringInfo_Optional(_buffer, _size, _lidx, &p->uac_BarringInfo);
	_serNrSysEncSQN_NR_SIB1_useFullResumeID_e_useFullResumeID_Optional(_buffer, _size, _lidx, &p->useFullResumeID);
	_serNrSysEncOCTET_STRING_SQN_NR_SIB1_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serNrSysEncSQN_NR_SIB1_v1610_IEs_SQN_NR_SIB1_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_c1_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_BCCH_DL_SCH_MessageType_c1_Value* p, enum SQN_NR_BCCH_DL_SCH_MessageType_c1_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_BCCH_DL_SCH_MessageType_c1_systemInformation) {
		_serNrSysEncSQN_NR_SystemInformation(_buffer, _size, _lidx, &p->systemInformation);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_BCCH_DL_SCH_MessageType_c1_systemInformationBlockType1) {
		_serNrSysEncSQN_NR_SIB1(_buffer, _size, _lidx, &p->systemInformationBlockType1);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_c1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_DL_SCH_MessageType_c1* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_c1_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_messageClassExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_DL_SCH_MessageType_messageClassExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_NR_BCCH_DL_SCH_MessageType_Value* p, enum SQN_NR_BCCH_DL_SCH_MessageType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_NR_BCCH_DL_SCH_MessageType_c1) {
		_serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_c1(_buffer, _size, _lidx, &p->c1);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_NR_BCCH_DL_SCH_MessageType_messageClassExtension) {
		_serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_messageClassExtension(_buffer, _size, _lidx, &p->messageClassExtension);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_DL_SCH_MessageType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_DL_SCH_Message(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_DL_SCH_Message* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BCCH_DL_SCH_MessageType(_buffer, _size, _lidx, &p->message);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncSQN_NR_BCCH_DL_SCH_Message_SIB1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NR_BCCH_DL_SCH_Message_SIB1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncSQN_NR_BCCH_DL_SCH_Message(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SI_List_Type_SIs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SI_List_Type_SIs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serNrSysEncSQN_NR_BCCH_DL_SCH_Message(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SegmentedSI_List_Type_SegmentedSIs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SegmentedSI_List_Type_SegmentedSIs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i1].d, _lidx);
		for (size_t i2 = 0; i2 < p->v.v[i1].d; i2++) {
			_serNrSysEncSQN_NR_BCCH_DL_SCH_Message(_buffer, _size, _lidx, &p->v.v[i1].v[i2]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BcchInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BcchInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncSQN_NR_BCCH_BCH_Message_MIB_Optional(_buffer, _size, _lidx, &p->MIB);
	_serNrSysEncSQN_NR_BCCH_DL_SCH_Message_SIB1_Optional(_buffer, _size, _lidx, &p->SIB1);
	_serNrSysEncNR_SI_List_Type_SIs_Optional(_buffer, _size, _lidx, &p->SIs);
	_serNrSysEncNR_SegmentedSI_List_Type_SegmentedSIs_Optional(_buffer, _size, _lidx, &p->SegmentedSIs);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BcchInfo_Type_BcchInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BcchInfo_Type_BcchInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_BcchInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BcchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BcchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_BcchToPbchConfig_Type_Pbch_Optional(_buffer, _size, _lidx, &p->Pbch);
	_serNrSysEncNR_BcchToPdschConfig_Type_Pdsch_Optional(_buffer, _size, _lidx, &p->Pdsch);
	_serNrSysEncNR_BcchInfo_Type_BcchInfo_Optional(_buffer, _size, _lidx, &p->BcchInfo);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_BcchConfig_Type_BcchConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_BcchConfig_Type_BcchConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_BcchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_PcchConfig_Type_SearchSpaceAndDci_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceDlDciAssignment_Type_NR_PcchConfig_Type_SearchSpaceAndDci_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PcchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PcchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_PcchConfig_Type_SearchSpaceAndDci_Optional(_buffer, _size, _lidx, &p->SearchSpaceAndDci);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_PcchConfig_Type_PcchConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_PcchConfig_Type_PcchConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_PcchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_RandomAccessResponseConfig_Type_SearchSpaceAndDci_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceDlDciAssignment_Type_NR_RandomAccessResponseConfig_Type_SearchSpaceAndDci_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncRAR_RapIdCtrl_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union RAR_RapIdCtrl_Type_Value* p, enum RAR_RapIdCtrl_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == RAR_RapIdCtrl_Type_Automatic) {
		HTON_8(&_buffer[*_lidx], p->Automatic, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == RAR_RapIdCtrl_Type_Unmatched) {
		HTON_8(&_buffer[*_lidx], p->Unmatched, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncRAR_RapIdCtrl_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RAR_RapIdCtrl_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncRAR_RapIdCtrl_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_RapIdOnly_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_RapIdOnly_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncRAR_RapIdCtrl_Type(_buffer, _size, _lidx, &p->RapId);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_UplinkGrant_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_UplinkGrant_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i3 = 0; i3 < 1; i3++) {
		HTON_8(&_buffer[*_lidx], p->HoppingFlag[i3], _lidx);
	}
	for (size_t i3 = 0; i3 < 14; i3++) {
		HTON_8(&_buffer[*_lidx], p->Msg3FrequencyResourceAllocation[i3], _lidx);
	}
	for (size_t i3 = 0; i3 < 4; i3++) {
		HTON_8(&_buffer[*_lidx], p->Msg3TimeResourceAllocation[i3], _lidx);
	}
	for (size_t i3 = 0; i3 < 4; i3++) {
		HTON_8(&_buffer[*_lidx], p->MCS[i3], _lidx);
	}
	for (size_t i3 = 0; i3 < 3; i3++) {
		HTON_8(&_buffer[*_lidx], p->TPC_Command[i3], _lidx);
	}
	for (size_t i3 = 0; i3 < 1; i3++) {
		HTON_8(&_buffer[*_lidx], p->CQI_Req[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TempC_RNTI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_TempC_RNTI_Type_Value* p, enum NR_TempC_RNTI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_TempC_RNTI_Type_SameAsC_RNTI) {
		HTON_8(&_buffer[*_lidx], p->SameAsC_RNTI, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_TempC_RNTI_Type_Explicit) {
		HTON_16(&_buffer[*_lidx], p->Explicit, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_TempC_RNTI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TempC_RNTI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_TempC_RNTI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_Payload_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_Payload_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->TimingAdvance, _lidx);
	_serNrSysEncNR_RAR_UplinkGrant_Type(_buffer, _size, _lidx, &p->UplinkGrant);
	_serNrSysEncNR_TempC_RNTI_Type(_buffer, _size, _lidx, &p->TempC_RNTI);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_RapIdAndPayload_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_RapIdAndPayload_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncRAR_RapIdCtrl_Type(_buffer, _size, _lidx, &p->RapId);
	_serNrSysEncNR_RAR_Payload_Type(_buffer, _size, _lidx, &p->Payload);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_SubPdu_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_RAR_SubPdu_Type_Value* p, enum NR_RAR_SubPdu_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_RAR_SubPdu_Type_BackoffIndicator) {
		HTON_8(&_buffer[*_lidx], p->BackoffIndicator, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_RAR_SubPdu_Type_RapIdOnly) {
		_serNrSysEncNR_RAR_RapIdOnly_Type(_buffer, _size, _lidx, &p->RapIdOnly);
		return SIDL_STATUS_OK;
	}
	if (d == NR_RAR_SubPdu_Type_RapIdAndPayload) {
		_serNrSysEncNR_RAR_RapIdAndPayload_Type(_buffer, _size, _lidx, &p->RapIdAndPayload);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_RAR_SubPdu_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_SubPdu_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_RAR_SubPdu_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_SubPduList_Type_SubPduList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_SubPduList_Type_SubPduList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncNR_RAR_SubPdu_Type(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncBool_NR_RAR_MacPdu_Type_CrcError_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_NR_RAR_MacPdu_Type_CrcError_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_MacPdu_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_MacPdu_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_RAR_SubPduList_Type_SubPduList_Optional(_buffer, _size, _lidx, &p->SubPduList);
	_serNrSysEncBool_NR_RAR_MacPdu_Type_CrcError_Optional(_buffer, _size, _lidx, &p->CrcError);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RAR_MacPdu_Type_MacPdu_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RAR_MacPdu_Type_MacPdu_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_RAR_MacPdu_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RandomAccessResponseConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RandomAccessResponseConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_SearchSpaceDlDciAssignment_Type_NR_RandomAccessResponseConfig_Type_SearchSpaceAndDci_Optional(_buffer, _size, _lidx, &p->SearchSpaceAndDci);
	_serNrSysEncNR_RAR_MacPdu_Type_MacPdu_Optional(_buffer, _size, _lidx, &p->MacPdu);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_RandomAccessResponseConfig_Type_RandomAccessResponse_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_RandomAccessResponseConfig_Type_RandomAccessResponse_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_RandomAccessResponseConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_AssignedBWPs_Type_NR_SearchSpaceUlDciAssignment_Type_AssignedBWPs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_AssignedBWPs_Type_NR_SearchSpaceUlDciAssignment_Type_AssignedBWPs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_AssignedBWPs_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_SearchSpaceType_Type_NR_SearchSpaceUlDciAssignment_Type_SearchSpaceType_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_SearchSpaceType_Type_NR_SearchSpaceUlDciAssignment_Type_SearchSpaceType_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_ResourceAllocationType_Type_NR_DciFormat_0_X_ResourceAssignment_Type_ResourceAllocationType_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_ResourceAllocationType_Type_NR_DciFormat_0_X_ResourceAssignment_Type_ResourceAllocationType_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_FreqDomainSchedulExplicit_Type_FreqDomain_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_FreqDomainSchedulExplicit_Type_FreqDomain_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_FreqDomainSchedulExplicit_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_0_X_ResourceAssignment_Type_TimeDomain_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_0_X_ResourceAssignment_Type_TimeDomain_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_TransportBlockRetransmissionList_Type_TransportBlockScheduling_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_TransportBlockRetransmissionList_Type_TransportBlockScheduling_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serNrSysEncNR_TransportBlockSingleTransmission_Type(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_HarqProcessConfig_Type_NR_DciFormat_0_X_ResourceAssignment_Type_HarqProcessConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_HarqProcessConfig_Type_NR_DciFormat_0_X_ResourceAssignment_Type_HarqProcessConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_HarqProcessConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_X_ResourceAssignment_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_X_ResourceAssignment_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_ResourceAllocationType_Type_NR_DciFormat_0_X_ResourceAssignment_Type_ResourceAllocationType_Optional(_buffer, _size, _lidx, &p->ResourceAllocationType);
	_serNrSysEncNR_FreqDomainSchedulExplicit_Type_FreqDomain_Optional(_buffer, _size, _lidx, &p->FreqDomain);
	_serNrSysEncNR_DciCommon_TimeDomainResourceAssignment_Type_NR_DciFormat_0_X_ResourceAssignment_Type_TimeDomain_Optional(_buffer, _size, _lidx, &p->TimeDomain);
	_serNrSysEncNR_TransportBlockRetransmissionList_Type_TransportBlockScheduling_Optional(_buffer, _size, _lidx, &p->TransportBlockScheduling);
	_serNrSysEncNR_HarqProcessConfig_Type_NR_DciFormat_0_X_ResourceAssignment_Type_HarqProcessConfig_Optional(_buffer, _size, _lidx, &p->HarqProcessConfig);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_X_ResourceAssignment_Type_ResoureAssignment_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_X_ResourceAssignment_Type_ResoureAssignment_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_X_ResourceAssignment_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_X_PuschHoppingCtrl_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_X_PuschHoppingCtrl_Type_Value* p, enum NR_DciFormat_0_X_PuschHoppingCtrl_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_X_PuschHoppingCtrl_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_X_PuschHoppingCtrl_Type_Flag) {
		for (size_t i2 = 0; i2 < 1; i2++) {
			HTON_8(&_buffer[*_lidx], p->Flag[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_X_PuschHoppingCtrl_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_X_PuschHoppingCtrl_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_X_PuschHoppingCtrl_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_X_PuschHoppingCtrl_Type_PuschHoppingCtrl_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_X_PuschHoppingCtrl_Type_PuschHoppingCtrl_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_X_PuschHoppingCtrl_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_TpcCommand_Type_TpcCommandPusch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_TpcCommand_Type_TpcCommandPusch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_TpcCommand_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_UL_SUL_Indicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciCommon_UL_SUL_Indicator_Type_Value* p, enum NR_DciCommon_UL_SUL_Indicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciCommon_UL_SUL_Indicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciCommon_UL_SUL_Indicator_Type_Value) {
		for (size_t i2 = 0; i2 < 1; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciCommon_UL_SUL_Indicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_UL_SUL_Indicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciCommon_UL_SUL_Indicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_UL_SUL_Indicator_Type_UL_SUL_Indicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_UL_SUL_Indicator_Type_UL_SUL_Indicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_UL_SUL_Indicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_0_0_SpecificInfo_Type_ChannelAccessCPext_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_0_0_SpecificInfo_Type_ChannelAccessCPext_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_0_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_0_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_DciFormat_X_0_ChannelAccessCPext_Type_NR_DciFormat_0_0_SpecificInfo_Type_ChannelAccessCPext_Optional(_buffer, _size, _lidx, &p->ChannelAccessCPext);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_CarrierIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_CarrierIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_CarrierIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_CarrierIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_CarrierIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_DfiFlag_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_DfiFlag_Type_Value* p, enum NR_DciFormat_0_1_DfiFlag_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_DfiFlag_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_DfiFlag_Type_Flag) {
		for (size_t i2 = 0; i2 < 1; i2++) {
			HTON_8(&_buffer[*_lidx], p->Flag[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_DfiFlag_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_DfiFlag_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_DfiFlag_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_DfiFlag_Type_DfiFlag_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_DfiFlag_Type_DfiFlag_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_DfiFlag_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciCommon_BWPIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_BWPIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciCommon_BWPIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_BWPIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciCommon_BWPIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncDAI_B1_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union DAI_B1_Type_Value* p, enum DAI_B1_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == DAI_B1_Type_Index) {
		for (size_t i2 = 0; i2 < 1; i2++) {
			HTON_8(&_buffer[*_lidx], p->Index[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == DAI_B1_Type_Automatic) {
		HTON_8(&_buffer[*_lidx], p->Automatic, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncDAI_B1_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DAI_B1_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncDAI_B1_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_FirstDAI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_FirstDAI_Type_Value* p, enum NR_DciFormat_0_1_FirstDAI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_FirstDAI_Type_SemiStaticCodebook) {
		_serNrSysEncDAI_B1_Type(_buffer, _size, _lidx, &p->SemiStaticCodebook);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_FirstDAI_Type_DynamicCodebook) {
		_serNrSysEncDAI_B2_Type(_buffer, _size, _lidx, &p->DynamicCodebook);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_FirstDAI_Type_EnhancedDynamicCodebook) {
		_serNrSysEncDAI_B4_Type(_buffer, _size, _lidx, &p->EnhancedDynamicCodebook);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_FirstDAI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_FirstDAI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_FirstDAI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_FirstDAI_Type_FirstDAI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_FirstDAI_Type_FirstDAI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_FirstDAI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_SecondDAI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_SecondDAI_Type_Value* p, enum NR_DciFormat_0_1_SecondDAI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_SecondDAI_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_SecondDAI_Type_DynamicCodebook) {
		_serNrSysEncDAI_B2_Type(_buffer, _size, _lidx, &p->DynamicCodebook);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_SecondDAI_Type_EnhancedDynamicCodebook) {
		_serNrSysEncDAI_B4_Type(_buffer, _size, _lidx, &p->EnhancedDynamicCodebook);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_SecondDAI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_SecondDAI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_SecondDAI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_SecondDAI_Type_SecondDAI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_SecondDAI_Type_SecondDAI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_SecondDAI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_SrsResourceIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_SrsResourceIndicator_Type_Value* p, enum NR_DciFormat_0_1_SrsResourceIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_SrsResourceIndicator_Type_NonCodeBook) {
		HTON_32(&_buffer[*_lidx], p->NonCodeBook.d, _lidx);
		for (size_t i2 = 0; i2 < p->NonCodeBook.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->NonCodeBook.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_SrsResourceIndicator_Type_CodeBook) {
		HTON_32(&_buffer[*_lidx], p->CodeBook.d, _lidx);
		for (size_t i2 = 0; i2 < p->CodeBook.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->CodeBook.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_SrsResourceIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_SrsResourceIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_SrsResourceIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_SrsResourceIndicator_Type_SrsResourceIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_SrsResourceIndicator_Type_SrsResourceIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_SrsResourceIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_PrecodingInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_PrecodingInfo_Type_Value* p, enum NR_DciFormat_0_1_PrecodingInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_PrecodingInfo_Type_NonCodeBook) {
		HTON_8(&_buffer[*_lidx], p->NonCodeBook, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_PrecodingInfo_Type_CodeBook) {
		HTON_32(&_buffer[*_lidx], p->CodeBook.d, _lidx);
		for (size_t i2 = 0; i2 < p->CodeBook.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->CodeBook.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_PrecodingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_PrecodingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_PrecodingInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_PrecodingInfo_Type_PrecodingInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_PrecodingInfo_Type_PrecodingInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_PrecodingInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_AntennaPorts_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_AntennaPorts_Type_Value* p, enum NR_DciFormat_0_1_AntennaPorts_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_AntennaPorts_Type_Index) {
		HTON_32(&_buffer[*_lidx], p->Index.d, _lidx);
		for (size_t i2 = 0; i2 < p->Index.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->Index.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_AntennaPorts_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_AntennaPorts_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_AntennaPorts_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_AntennaPorts_Type_AntennaPorts_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_AntennaPorts_Type_AntennaPorts_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_AntennaPorts_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_0_1_SpecificInfo_Type_SrsRequest_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_0_1_SpecificInfo_Type_SrsRequest_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_SrsRequest_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_CsiRequest_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_CsiRequest_Type_Value* p, enum NR_DciFormat_0_1_CsiRequest_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_CsiRequest_Type_Index) {
		HTON_32(&_buffer[*_lidx], p->Index.d, _lidx);
		for (size_t i2 = 0; i2 < p->Index.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->Index.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_CsiRequest_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_CsiRequest_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_CsiRequest_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_CsiRequest_Type_CsiRequest_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_CsiRequest_Type_CsiRequest_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_CsiRequest_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_CBGTI_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_CBGTI_Type_Value* p, enum NR_DciFormat_0_1_CBGTI_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_CBGTI_Type_Index) {
		HTON_32(&_buffer[*_lidx], p->Index.d, _lidx);
		for (size_t i2 = 0; i2 < p->Index.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->Index.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_CBGTI_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_CBGTI_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_CBGTI_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_CBGTI_Type_CBGTI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_CBGTI_Type_CBGTI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_CBGTI_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_PtrsDmrsAssociation_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_PtrsDmrsAssociation_Type_Value* p, enum NR_DciFormat_0_1_PtrsDmrsAssociation_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_PtrsDmrsAssociation_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_PtrsDmrsAssociation_Type_Value) {
		for (size_t i2 = 0; i2 < 2; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_PtrsDmrsAssociation_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_PtrsDmrsAssociation_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_PtrsDmrsAssociation_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_PtrsDmrsAssociation_Type_PtrsDmrsAssociation_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_PtrsDmrsAssociation_Type_PtrsDmrsAssociation_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_PtrsDmrsAssociation_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_BetaOffsetIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_BetaOffsetIndicator_Type_Value* p, enum NR_DciFormat_0_1_BetaOffsetIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_BetaOffsetIndicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_BetaOffsetIndicator_Type_Value) {
		for (size_t i2 = 0; i2 < 2; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_BetaOffsetIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_BetaOffsetIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_BetaOffsetIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_BetaOffsetIndicator_Type_BetaOffsetIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_BetaOffsetIndicator_Type_BetaOffsetIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_BetaOffsetIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_0_1_SpecificInfo_Type_DmrsSequenceInit_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_0_1_SpecificInfo_Type_DmrsSequenceInit_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_UlschIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_UlschIndicator_Type_Value* p, enum NR_DciFormat_0_1_UlschIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_UlschIndicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_UlschIndicator_Type_Value) {
		for (size_t i2 = 0; i2 < 1; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_UlschIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_UlschIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_UlschIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_UlschIndicator_Type_UlschIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_UlschIndicator_Type_UlschIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_UlschIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_Value* p, enum NR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_Value) {
		HTON_32(&_buffer[*_lidx], p->Value.d, _lidx);
		for (size_t i2 = 0; i2 < p->Value.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_ChannelAccessCPextCAPC_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_ChannelAccessCPextCAPC_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_ChannelAccessCPextCAPC_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_ChannelAccessCPextCAPC_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_ChannelAccessCPextCAPC_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_OpenLoopPowerControl_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_OpenLoopPowerControl_Type_Value* p, enum NR_DciFormat_0_1_OpenLoopPowerControl_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_OpenLoopPowerControl_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_OpenLoopPowerControl_Type_Value) {
		HTON_32(&_buffer[*_lidx], p->Value.d, _lidx);
		for (size_t i2 = 0; i2 < p->Value.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_OpenLoopPowerControl_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_OpenLoopPowerControl_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_OpenLoopPowerControl_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_OpenLoopPowerControl_Type_OpenLoopPowerControl_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_OpenLoopPowerControl_Type_OpenLoopPowerControl_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_OpenLoopPowerControl_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_PriorityIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_PriorityIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_Value* p, enum NR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_Value) {
		for (size_t i2 = 0; i2 < 1; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_InvalidSymbolPatternIndicator_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_InvalidSymbolPatternIndicator_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_0_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_0_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_0_1_SpecificInfo_Type_SCellDormancyIndication_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_0_1_SpecificInfo_Type_SCellDormancyIndication_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_SidelinkAssignmentIndex_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_1_SidelinkAssignmentIndex_Type_Value* p, enum NR_DciFormat_0_1_SidelinkAssignmentIndex_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_1_SidelinkAssignmentIndex_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_1_SidelinkAssignmentIndex_Type_Value) {
		HTON_32(&_buffer[*_lidx], p->Value.d, _lidx);
		for (size_t i2 = 0; i2 < p->Value.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->Value.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_DciFormat_0_1_SidelinkAssignmentIndex_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_SidelinkAssignmentIndex_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serNrSysEncNR_DciFormat_0_1_SidelinkAssignmentIndex_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_SidelinkAssignmentIndex_Type_SidelinkAssignmentIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_SidelinkAssignmentIndex_Type_SidelinkAssignmentIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serNrSysEncNR_DciFormat_0_1_SidelinkAssignmentIndex_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_1_SpecificInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct NR_DciFormat_0_1_SpecificInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serNrSysEncNR_DciCommon_CarrierIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_CarrierIndicator_Optional(_buffer, _size, _lidx, &p->CarrierIndicator);
	_serNrSysEncNR_DciFormat_0_1_DfiFlag_Type_DfiFlag_Optional(_buffer, _size, _lidx, &p->DfiFlag);
	_serNrSysEncNR_DciCommon_BWPIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_BWPIndicator_Optional(_buffer, _size, _lidx, &p->BWPIndicator);
	_serNrSysEncNR_DciFormat_0_1_FirstDAI_Type_FirstDAI_Optional(_buffer, _size, _lidx, &p->FirstDAI);
	_serNrSysEncNR_DciFormat_0_1_SecondDAI_Type_SecondDAI_Optional(_buffer, _size, _lidx, &p->SecondDAI);
	_serNrSysEncNR_DciFormat_0_1_SrsResourceIndicator_Type_SrsResourceIndicator_Optional(_buffer, _size, _lidx, &p->SrsResourceIndicator);
	_serNrSysEncNR_DciFormat_0_1_PrecodingInfo_Type_PrecodingInfo_Optional(_buffer, _size, _lidx, &p->PrecodingInfo);
	_serNrSysEncNR_DciFormat_0_1_AntennaPorts_Type_AntennaPorts_Optional(_buffer, _size, _lidx, &p->AntennaPorts);
	_serNrSysEncNR_DciFormat_X_1_SrsRequest_Type_NR_DciFormat_0_1_SpecificInfo_Type_SrsRequest_Optional(_buffer, _size, _lidx, &p->SrsRequest);
	_serNrSysEncNR_DciFormat_0_1_CsiRequest_Type_CsiRequest_Optional(_buffer, _size, _lidx, &p->CsiRequest);
	_serNrSysEncNR_DciFormat_0_1_CBGTI_Type_CBGTI_Optional(_buffer, _size, _lidx, &p->CBGTI);
	_serNrSysEncNR_DciFormat_0_1_PtrsDmrsAssociation_Type_PtrsDmrsAssociation_Optional(_buffer, _size, _lidx, &p->PtrsDmrsAssociation);
	_serNrSysEncNR_DciFormat_0_1_BetaOffsetIndicator_Type_BetaOffsetIndicator_Optional(_buffer, _size, _lidx, &p->BetaOffsetIndicator);
	_serNrSysEncNR_DciFormat_X_1_DmrsSequenceInit_Type_NR_DciFormat_0_1_SpecificInfo_Type_DmrsSequenceInit_Optional(_buffer, _size, _lidx, &p->DmrsSequenceInit);
	_serNrSysEncNR_DciFormat_0_1_UlschIndicator_Type_UlschIndicator_Optional(_buffer, _size, _lidx, &p->UlschIndicator);
	_serNrSysEncNR_DciFormat_0_1_ChannelAccessCPextCAPC_Type_ChannelAccessCPextCAPC_Optional(_buffer, _size, _lidx, &p->ChannelAccessCPextCAPC);
	_serNrSysEncNR_DciFormat_0_1_OpenLoopPowerControl_Type_OpenLoopPowerControl_Optional(_buffer, _size, _lidx, &p->OpenLoopPowerControl);
	_serNrSysEncNR_DciFormat_X_1_PriorityIndicator_Type_NR_DciFormat_0_1_SpecificInfo_Type_PriorityIndicator_Optional(_buffer, _size, _lidx, &p->PriorityIndicator);
	_serNrSysEncNR_DciFormat_0_1_InvalidSymbolPatternIndicator_Type_InvalidSymbolPatternIndicator_Optional(_buffer, _size, _lidx, &p->InvalidSymbolPatternIndicator);
	_serNrSysEncNR_DciFormat_X_1_MinimumApplicableSchedulingOffset_Type_NR_DciFormat_0_1_SpecificInfo_Type_MinimumApplicableSchedulingOffset_Optional(_buffer, _size, _lidx, &p->MinimumApplicableSchedulingOffset);
	_serNrSysEncNR_DciFormat_X_1_SCellDormancyIndication_Type_NR_DciFormat_0_1_SpecificInfo_Type_SCellDormancyIndication_Optional(_buffer, _size, _lidx, &p->SCellDormancyIndication);
	_serNrSysEncNR_DciFormat_0_1_SidelinkAssignmentIndex_Type_SidelinkAssignmentIndex_Optional(_buffer, _size, _lidx, &p->SidelinkAssignmentIndex);

	return SIDL_STATUS_OK;
}

static int _serNrSysEncNR_DciFormat_0_X_SpecificInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union NR_DciFormat_0_X_SpecificInfo_Type_Value* p, enum NR_DciFormat_0_X_SpecificInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == NR_DciFormat_0_X_SpecificInfo_Type_Format_0_0) {
		_serNrSysEncNR_DciFormat_0_0_SpecificInfo_Type(_buffer, _size, _lidx, &p->Format_0_0);
		return SIDL_STATUS_OK;
	}
	if (d == NR_DciFormat_0_X_SpecificInfo_Type_Format_0_1) {
		_serNrSysEncNR_DciFormat_0_1_SpecificInfo_Type(_buffer, _size, _lidx, &p->Format_0_1);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serNrSysEncNR_Dc