/*
 * Copyright 2022 Sequans Communications.
 *
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.0  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

#include <string.h>
#include "serSys.h"
#include "serMem.h"
#include "serUtils.h"

void serSysProcessInitClt(unsigned char* _arena, size_t _aSize, struct SYSTEM_CTRL_REQ** FromSS)
{
	serMem_t _mem = serMemInit(_arena, _aSize);

	*FromSS = (struct SYSTEM_CTRL_REQ*)serMalloc(_mem, sizeof(struct SYSTEM_CTRL_REQ));
	memset(*FromSS, 0, sizeof(struct SYSTEM_CTRL_REQ));
}

static int _serSysEncPmchLogicalChannel_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PmchLogicalChannel_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->Pmch_InfoIndex, _lidx);
	HTON_8(&_buffer[*_lidx], p->LogicalChannelIdentity, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncMRB_Identity_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct MRB_Identity_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->Mbsfn_AreaId, _lidx);
	_serSysEncPmchLogicalChannel_Type(_buffer, _size, _lidx, &p->PmchLogicalChannel);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MCC_SQN_PLMN_Identity_mcc_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MCC_SQN_PLMN_Identity_mcc_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 3; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_Identity(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_Identity* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MCC_SQN_PLMN_Identity_mcc_Optional(_buffer, _size, _lidx, &p->mcc);
	HTON_32(&_buffer[*_lidx], p->mnc.d, _lidx);
	for (size_t i1 = 0; i1 < p->mnc.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->mnc.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TMGI_r9_plmn_Id_r9_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_TMGI_r9_plmn_Id_r9_Value* p, enum SQN_TMGI_r9_plmn_Id_r9_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_TMGI_r9_plmn_Id_r9_plmn_Index_r9) {
		HTON_8(&_buffer[*_lidx], p->plmn_Index_r9, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_TMGI_r9_plmn_Id_r9_explicitValue_r9) {
		_serSysEncSQN_PLMN_Identity(_buffer, _size, _lidx, &p->explicitValue_r9);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_TMGI_r9_plmn_Id_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TMGI_r9_plmn_Id_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_TMGI_r9_plmn_Id_r9_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TMGI_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TMGI_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TMGI_r9_plmn_Id_r9(_buffer, _size, _lidx, &p->plmn_Id_r9);
	for (size_t i1 = 0; i1 < 3; i1++) {
		HTON_8(&_buffer[*_lidx], p->serviceId_r9[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncO1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 1; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMSSessionInfo_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMSSessionInfo_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TMGI_r9(_buffer, _size, _lidx, &p->tmgi_r13);
	_serSysEncO1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional(_buffer, _size, _lidx, &p->sessionId_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSC_MRB_Identity_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SC_MRB_Identity_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MBMSSessionInfo_r13(_buffer, _size, _lidx, &p->MbmsSessionInfo);

	return SIDL_STATUS_OK;
}

static int _serSysEncRadioBearerId_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union RadioBearerId_Type_Value* p, enum RadioBearerId_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == RadioBearerId_Type_Srb) {
		HTON_8(&_buffer[*_lidx], p->Srb, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == RadioBearerId_Type_Drb) {
		HTON_8(&_buffer[*_lidx], p->Drb, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == RadioBearerId_Type_Mrb) {
		_serSysEncMRB_Identity_Type(_buffer, _size, _lidx, &p->Mrb);
		return SIDL_STATUS_OK;
	}
	if (d == RadioBearerId_Type_ScMrb) {
		_serSysEncSC_MRB_Identity_Type(_buffer, _size, _lidx, &p->ScMrb);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncRadioBearerId_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RadioBearerId_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncRadioBearerId_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncQosFlow_Identification_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct QosFlow_Identification_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->PDU_SessionId, _lidx);
	HTON_32(&_buffer[*_lidx], p->QFI, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncRoutingInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union RoutingInfo_Type_Value* p, enum RoutingInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == RoutingInfo_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == RoutingInfo_Type_RadioBearerId) {
		_serSysEncRadioBearerId_Type(_buffer, _size, _lidx, &p->RadioBearerId);
		return SIDL_STATUS_OK;
	}
	if (d == RoutingInfo_Type_QosFlow) {
		_serSysEncQosFlow_Identification_Type(_buffer, _size, _lidx, &p->QosFlow);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncRoutingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RoutingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncRoutingInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSystemFrameNumberInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SystemFrameNumberInfo_Type_Value* p, enum SystemFrameNumberInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SystemFrameNumberInfo_Type_Number) {
		HTON_16(&_buffer[*_lidx], p->Number, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SystemFrameNumberInfo_Type_Any) {
		HTON_8(&_buffer[*_lidx], p->Any, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSystemFrameNumberInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SystemFrameNumberInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSystemFrameNumberInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSubFrameInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SubFrameInfo_Type_Value* p, enum SubFrameInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SubFrameInfo_Type_Number) {
		HTON_8(&_buffer[*_lidx], p->Number, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SubFrameInfo_Type_Any) {
		HTON_8(&_buffer[*_lidx], p->Any, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSubFrameInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SubFrameInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSubFrameInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncHyperSystemFrameNumberInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const HyperSystemFrameNumberInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSystemFrameNumberInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSlotOffset_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SlotOffset_Type_Value* p, enum SlotOffset_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SlotOffset_Type_Numerology0) {
		HTON_8(&_buffer[*_lidx], p->Numerology0, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology1) {
		HTON_8(&_buffer[*_lidx], p->Numerology1, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology2) {
		HTON_8(&_buffer[*_lidx], p->Numerology2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology3) {
		HTON_8(&_buffer[*_lidx], p->Numerology3, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotOffset_Type_Numerology4) {
		HTON_8(&_buffer[*_lidx], p->Numerology4, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSlotOffset_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SlotOffset_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSlotOffset_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSlotTimingInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SlotTimingInfo_Type_Value* p, enum SlotTimingInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SlotTimingInfo_Type_SlotOffset) {
		_serSysEncSlotOffset_Type(_buffer, _size, _lidx, &p->SlotOffset);
		return SIDL_STATUS_OK;
	}
	if (d == SlotTimingInfo_Type_FirstSlot) {
		HTON_8(&_buffer[*_lidx], p->FirstSlot, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SlotTimingInfo_Type_Any) {
		HTON_8(&_buffer[*_lidx], p->Any, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSlotTimingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SlotTimingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSlotTimingInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSubFrameTiming_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SubFrameTiming_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSystemFrameNumberInfo_Type(_buffer, _size, _lidx, &p->SFN);
	_serSysEncSubFrameInfo_Type(_buffer, _size, _lidx, &p->Subframe);
	_serSysEncHyperSystemFrameNumberInfo_Type(_buffer, _size, _lidx, &p->HSFN);
	_serSysEncSlotTimingInfo_Type(_buffer, _size, _lidx, &p->Slot);

	return SIDL_STATUS_OK;
}

static int _serSysEncTimingInfo_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union TimingInfo_Type_Value* p, enum TimingInfo_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == TimingInfo_Type_SubFrame) {
		_serSysEncSubFrameTiming_Type(_buffer, _size, _lidx, &p->SubFrame);
		return SIDL_STATUS_OK;
	}
	if (d == TimingInfo_Type_Now) {
		HTON_8(&_buffer[*_lidx], p->Now, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == TimingInfo_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncTimingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct TimingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncTimingInfo_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncReqAspControlInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ReqAspControlInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->CnfFlag, _lidx);
	HTON_8(&_buffer[*_lidx], p->FollowOnFlag, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncRlcBearerRouting_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union RlcBearerRouting_Type_Value* p, enum RlcBearerRouting_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == RlcBearerRouting_Type_EUTRA) {
		{
			size_t _tmp = (size_t)p->EUTRA;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == RlcBearerRouting_Type_NR) {
		{
			size_t _tmp = (size_t)p->NR;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == RlcBearerRouting_Type_None) {
		HTON_8(&_buffer[*_lidx], p->None, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncRlcBearerRouting_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RlcBearerRouting_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncRlcBearerRouting_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncRlcBearerRouting_Type_ReqAspCommonPart_Type_RlcBearerRouting_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RlcBearerRouting_Type_ReqAspCommonPart_Type_RlcBearerRouting_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncRlcBearerRouting_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncReqAspCommonPart_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ReqAspCommonPart_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->CellId;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncRoutingInfo_Type(_buffer, _size, _lidx, &p->RoutingInfo);
	_serSysEncTimingInfo_Type(_buffer, _size, _lidx, &p->TimingInfo);
	_serSysEncReqAspControlInfo_Type(_buffer, _size, _lidx, &p->ControlInfo);
	_serSysEncRlcBearerRouting_Type_ReqAspCommonPart_Type_RlcBearerRouting_Optional(_buffer, _size, _lidx, &p->RlcBearerRouting);

	return SIDL_STATUS_OK;
}

static int _serSysEncCellConfigCapability_Type_ConfigCapability_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CellConfigCapability_Type_ConfigCapability_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->subframeAssignment;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->specialSubframePatterns;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1130(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1130* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->specialSubframePatterns_v1130;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1130_tdd_Config_v1130_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1130_tdd_Config_v1130_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config_v1130(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncTDD_Config_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct TDD_Config_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TDD_Config(_buffer, _size, _lidx, &p->R8);
	_serSysEncSQN_TDD_Config_v1130_tdd_Config_v1130_Optional(_buffer, _size, _lidx, &p->tdd_Config_v1130);

	return SIDL_STATUS_OK;
}

static int _serSysEncTDD_Config_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union TDD_Config_Type_Value* p, enum TDD_Config_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == TDD_Config_Type_R8andLater) {
		_serSysEncTDD_Config_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncTDD_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct TDD_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncTDD_Config_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncEUTRA_TDD_Info_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct EUTRA_TDD_Info_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncTDD_Config_Type(_buffer, _size, _lidx, &p->Configuration);

	return SIDL_STATUS_OK;
}

static int _serSysEncEUTRA_HalfDuplexFDD_Info_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct EUTRA_HalfDuplexFDD_Info_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serSysEncEUTRA_RAT_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union EUTRA_RAT_Type_Value* p, enum EUTRA_RAT_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == EUTRA_RAT_Type_FDD) {
		HTON_8(&_buffer[*_lidx], p->FDD, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == EUTRA_RAT_Type_TDD) {
		_serSysEncEUTRA_TDD_Info_Type(_buffer, _size, _lidx, &p->TDD);
		return SIDL_STATUS_OK;
	}
	if (d == EUTRA_RAT_Type_HalfDuplexFDD) {
		_serSysEncEUTRA_HalfDuplexFDD_Info_Type(_buffer, _size, _lidx, &p->HalfDuplexFDD);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncEUTRA_RAT_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct EUTRA_RAT_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncEUTRA_RAT_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellIdentity_eNB_CellId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellIdentity_eNB_CellId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 28; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_TcOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_TcOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncCellTimingInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CellTimingInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncUint8_t_TcOffset_Optional(_buffer, _size, _lidx, &p->TcOffset);
	HTON_32(&_buffer[*_lidx], p->Tcell, _lidx);
	HTON_16(&_buffer[*_lidx], p->SfnOffset, _lidx);
	HTON_16(&_buffer[*_lidx], p->HsfnOffset, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncCommonStaticCellInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CommonStaticCellInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncEUTRA_RAT_Type(_buffer, _size, _lidx, &p->RAT);
	HTON_16(&_buffer[*_lidx], p->PhysicalCellId, _lidx);
	_serSysEncSQN_CellIdentity_eNB_CellId_Optional(_buffer, _size, _lidx, &p->eNB_CellId);
	HTON_32(&_buffer[*_lidx], p->EutraBand, _lidx);
	_serSysEncCellTimingInfo_Type(_buffer, _size, _lidx, &p->CellTimingInfo);

	return SIDL_STATUS_OK;
}

static int _serSysEncDownlinkStaticCellInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DownlinkStaticCellInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->Earfcn, _lidx);
	{
		size_t _tmp = (size_t)p->Bandwidth;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->RBSize;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->CyclicPrefix;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUplinkStaticCellInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct UplinkStaticCellInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->Earfcn, _lidx);
	{
		size_t _tmp = (size_t)p->Bandwidth;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->CyclicPrefix;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUplinkStaticCellInfo_Type_Uplink_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct UplinkStaticCellInfo_Type_Uplink_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncUplinkStaticCellInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncStaticCellInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct StaticCellInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncCommonStaticCellInfo_Type(_buffer, _size, _lidx, &p->Common);
	_serSysEncDownlinkStaticCellInfo_Type(_buffer, _size, _lidx, &p->Downlink);
	_serSysEncUplinkStaticCellInfo_Type_Uplink_Optional(_buffer, _size, _lidx, &p->Uplink);

	return SIDL_STATUS_OK;
}

static int _serSysEncStaticCellInfo_Type_StaticCellInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct StaticCellInfo_Type_StaticCellInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncStaticCellInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AntennaInfoCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AntennaInfoCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->antennaPortsCount;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncAntennaInfoCommon_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union AntennaInfoCommon_Type_Value* p, enum AntennaInfoCommon_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == AntennaInfoCommon_Type_R8) {
		_serSysEncSQN_AntennaInfoCommon(_buffer, _size, _lidx, &p->R8);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncAntennaInfoCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct AntennaInfoCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncAntennaInfoCommon_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncAntennaPortInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct AntennaPortInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->PowerAttenuation, _lidx);
	HTON_8(&_buffer[*_lidx], p->PropagationDelay, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncAntennaPortConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union AntennaPortConfig_Type_Value* p, enum AntennaPortConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == AntennaPortConfig_Type_AddOrReconfigure) {
		_serSysEncAntennaPortInfo_Type(_buffer, _size, _lidx, &p->AddOrReconfigure);
		return SIDL_STATUS_OK;
	}
	if (d == AntennaPortConfig_Type_Release) {
		HTON_8(&_buffer[*_lidx], p->Release, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncAntennaPortConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct AntennaPortConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncAntennaPortConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncAntennaPort_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct AntennaPort_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->Id, _lidx);
	_serSysEncAntennaPortConfig_Type(_buffer, _size, _lidx, &p->Config);

	return SIDL_STATUS_OK;
}

static int _serSysEncDownlinkAntennaGroupConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DownlinkAntennaGroupConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncAntennaInfoCommon_Type(_buffer, _size, _lidx, &p->AntennaInfoCommon);
	HTON_32(&_buffer[*_lidx], p->AntennaPort.d, _lidx);
	for (size_t i1 = 0; i1 < p->AntennaPort.d; i1++) {
		_serSysEncAntennaPort_Type(_buffer, _size, _lidx, &p->AntennaPort.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncDownlinkAntennaGroupConfig_Type_AntennaGroup_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DownlinkAntennaGroupConfig_Type_AntennaGroup_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncDownlinkAntennaGroupConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratio_Type_RA_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratio_Type_RA_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratio_Type_RB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratio_Type_RB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncToRS_EPRE_Ratio_Type_RA_Optional(_buffer, _size, _lidx, &p->RA);
	_serSysEncToRS_EPRE_Ratio_Type_RB_Optional(_buffer, _size, _lidx, &p->RB);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_PbchConfig_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_PbchConfig_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPbchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PbchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncToRS_EPRE_Ratios_Type_PbchConfig_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncPbchConfig_Type_Pbch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PbchConfig_Type_Pbch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPbchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncCfiValue_Type_CfiValue_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CfiValue_Type_CfiValue_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_PcfichConfig_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_PcfichConfig_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPcfichConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PcfichConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncCfiValue_Type_CfiValue_Optional(_buffer, _size, _lidx, &p->CfiValue);
	_serSysEncToRS_EPRE_Ratios_Type_PcfichConfig_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncPcfichConfig_Type_Pcfich_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PcfichConfig_Type_Pcfich_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPcfichConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PHICH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PHICH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->phich_Duration;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->phich_Resource;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncPHICH_Config_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union PHICH_Config_Type_Value* p, enum PHICH_Config_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == PHICH_Config_Type_R8) {
		_serSysEncSQN_PHICH_Config(_buffer, _size, _lidx, &p->R8);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncPHICH_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PHICH_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncPHICH_Config_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncPHICH_Config_Type_PhichConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PHICH_Config_Type_PhichConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPHICH_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_PhichConfig_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_PhichConfig_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPhichConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PhichConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncPHICH_Config_Type_PhichConfig_Optional(_buffer, _size, _lidx, &p->PhichConfig);
	_serSysEncToRS_EPRE_Ratios_Type_PhichConfig_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncPhichConfig_Type_Phich_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PhichConfig_Type_Phich_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPhichConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_CommonSearchSpaceFormat_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_CommonSearchSpaceFormat_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_UeSpecificSearchSpaceFormat_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_UeSpecificSearchSpaceFormat_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncCCE_StartIndex_DL_UL_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CCE_StartIndex_DL_UL_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->CCE_StartIndex_DL, _lidx);
	HTON_32(&_buffer[*_lidx], p->CCE_StartIndex_UL, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdcchCandidate_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdcchCandidate_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->RNTI[i2], _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->CCE_StartIndexList.d, _lidx);
	for (size_t i2 = 0; i2 < p->CCE_StartIndexList.d; i2++) {
		_serSysEncCCE_StartIndex_DL_UL_Type(_buffer, _size, _lidx, &p->CCE_StartIndexList.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncPdcchCandidateList_Type_PdcchCandidateList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdcchCandidateList_Type_PdcchCandidateList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncPdcchCandidate_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_PdcchConfig_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_PdcchConfig_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdcchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdcchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncUint8_t_CommonSearchSpaceFormat_Optional(_buffer, _size, _lidx, &p->CommonSearchSpaceFormat);
	_serSysEncUint8_t_UeSpecificSearchSpaceFormat_Optional(_buffer, _size, _lidx, &p->UeSpecificSearchSpaceFormat);
	_serSysEncPdcchCandidateList_Type_PdcchCandidateList_Optional(_buffer, _size, _lidx, &p->PdcchCandidateList);
	_serSysEncToRS_EPRE_Ratios_Type_PdcchConfig_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdcchConfig_Type_Pdcch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdcchConfig_Type_Pdcch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPdcchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_RachResponse_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_RachResponse_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_BcchOnPdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_BcchOnPdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_PcchOnPdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_PcchOnPdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_CcchOnPdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_CcchOnPdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_DcchDtchOnPdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_DcchDtchOnPdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_OcngOnPdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_OcngOnPdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdschRelativeTxPower_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdschRelativeTxPower_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncToRS_EPRE_Ratios_Type_RachResponse_Optional(_buffer, _size, _lidx, &p->RachResponse);
	_serSysEncToRS_EPRE_Ratios_Type_BcchOnPdsch_Optional(_buffer, _size, _lidx, &p->BcchOnPdsch);
	_serSysEncToRS_EPRE_Ratios_Type_PcchOnPdsch_Optional(_buffer, _size, _lidx, &p->PcchOnPdsch);
	_serSysEncToRS_EPRE_Ratios_Type_CcchOnPdsch_Optional(_buffer, _size, _lidx, &p->CcchOnPdsch);
	_serSysEncToRS_EPRE_Ratios_Type_DcchDtchOnPdsch_Optional(_buffer, _size, _lidx, &p->DcchDtchOnPdsch);
	_serSysEncToRS_EPRE_Ratios_Type_OcngOnPdsch_Optional(_buffer, _size, _lidx, &p->OcngOnPdsch);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdschRelativeTxPower_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdschRelativeTxPower_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPdschRelativeTxPower_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDSCH_ConfigCommon_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDSCH_ConfigCommon_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional(_buffer, _size, _lidx, &p->pdsch_maxNumRepetitionCEmodeA_r13);
	_serSysEncSQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional(_buffer, _size, _lidx, &p->pdsch_maxNumRepetitionCEmodeB_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDSCH_ConfigCommon_v1310_PDSCH_ConfigCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDSCH_ConfigCommon_v1310_PDSCH_ConfigCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PDSCH_ConfigCommon_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdschConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdschConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncPdschRelativeTxPower_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);
	_serSysEncSQN_PDSCH_ConfigCommon_v1310_PDSCH_ConfigCommon_Optional(_buffer, _size, _lidx, &p->PDSCH_ConfigCommon);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdschConfig_Type_Pdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdschConfig_Type_Pdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPdschConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_PrimarySyncSignal_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_PrimarySyncSignal_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPrimarySyncSignal_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PrimarySyncSignal_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncToRS_EPRE_Ratios_Type_PrimarySyncSignal_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncPrimarySyncSignal_Type_Pss_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PrimarySyncSignal_Type_Pss_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPrimarySyncSignal_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_SecondarySyncSignal_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_SecondarySyncSignal_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSecondarySyncSignal_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SecondarySyncSignal_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncToRS_EPRE_Ratios_Type_SecondarySyncSignal_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncSecondarySyncSignal_Type_Sss_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SecondarySyncSignal_Type_Sss_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSecondarySyncSignal_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_r10_csi_RS_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->antennaPortsCount_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->resourceConfig_r10, _lidx);
	HTON_8(&_buffer[*_lidx], p->subframeConfig_r10, _lidx);
	HTON_8(&_buffer[*_lidx], p->p_C_r10, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_Config_r10_csi_RS_r10_Value* p, enum SQN_CSI_RS_Config_r10_csi_RS_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_Config_r10_csi_RS_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_Config_r10_csi_RS_r10_setup) {
		_serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_r10_csi_RS_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ZeroTxPowerCSI_RS_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ZeroTxPowerCSI_RS_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i1 = 0; i1 < 16; i1++) {
		HTON_8(&_buffer[*_lidx], p->zeroTxPowerResourceConfigList_r12[i1], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->zeroTxPowerSubframeConfig_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ZeroTxPowerCSI_RS_Conf_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_ZeroTxPowerCSI_RS_Conf_r12_Value* p, enum SQN_ZeroTxPowerCSI_RS_Conf_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_ZeroTxPowerCSI_RS_Conf_r12_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ZeroTxPowerCSI_RS_Conf_r12_setup) {
		_serSysEncSQN_ZeroTxPowerCSI_RS_r12(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_ZeroTxPowerCSI_RS_Conf_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ZeroTxPowerCSI_RS_Conf_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_ZeroTxPowerCSI_RS_Conf_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ZeroTxPowerCSI_RS_Conf_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional(_buffer, _size, _lidx, &p->csi_RS_r10);
	_serSysEncSQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional(_buffer, _size, _lidx, &p->zeroTxPowerCSI_RS_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_r10_CSI_RS_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_r10_CSI_RS_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_Config_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_SubframeConfig_subframeAllocation_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_MBSFN_SubframeConfig_subframeAllocation_Value* p, enum SQN_MBSFN_SubframeConfig_subframeAllocation_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_MBSFN_SubframeConfig_subframeAllocation_oneFrame) {
		for (size_t i3 = 0; i3 < 6; i3++) {
			HTON_8(&_buffer[*_lidx], p->oneFrame[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MBSFN_SubframeConfig_subframeAllocation_fourFrames) {
		for (size_t i3 = 0; i3 < 24; i3++) {
			HTON_8(&_buffer[*_lidx], p->fourFrames[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_MBSFN_SubframeConfig_subframeAllocation(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_SubframeConfig_subframeAllocation* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MBSFN_SubframeConfig_subframeAllocation_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_SubframeConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_SubframeConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->radioframeAllocationPeriod;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->radioframeAllocationOffset, _lidx);
	_serSysEncSQN_MBSFN_SubframeConfig_subframeAllocation(_buffer, _size, _lidx, &p->subframeAllocation);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->subframeConfigList.d, _lidx);
	for (size_t i2 = 0; i2 < p->subframeConfigList.d; i2++) {
		_serSysEncSQN_MBSFN_SubframeConfig(_buffer, _size, _lidx, &p->subframeConfigList.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value* p, enum SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup) {
		_serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->qcl_ScramblingIdentity_r11, _lidx);
	{
		size_t _tmp = (size_t)p->crs_PortsCount_r11;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional(_buffer, _size, _lidx, &p->mbsfn_SubframeConfigList_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value* p, enum SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_oneFrame_v1430) {
		for (size_t i3 = 0; i3 < 2; i3++) {
			HTON_8(&_buffer[*_lidx], p->oneFrame_v1430[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_fourFrames_v1430) {
		for (size_t i3 = 0; i3 < 8; i3++) {
			HTON_8(&_buffer[*_lidx], p->fourFrames_v1430[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_SubframeConfig_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_SubframeConfig_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430(_buffer, _size, _lidx, &p->subframeAllocation_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->subframeConfigList_v1430.d, _lidx);
	for (size_t i2 = 0; i2 < p->subframeConfigList_v1430.d; i2++) {
		_serSysEncSQN_MBSFN_SubframeConfig_v1430(_buffer, _size, _lidx, &p->subframeConfigList_v1430.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value* p, enum SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup) {
		_serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->csi_RS_ConfigNZPId_r11, _lidx);
	{
		size_t _tmp = (size_t)p->antennaPortsCount_r11;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->resourceConfig_r11, _lidx);
	HTON_8(&_buffer[*_lidx], p->subframeConfig_r11, _lidx);
	HTON_16(&_buffer[*_lidx], p->scramblingIdentity_r11, _lidx);
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional(_buffer, _size, _lidx, &p->qcl_CRS_Info_r11);
	_serSysEncSQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional(_buffer, _size, _lidx, &p->csi_RS_ConfigNZPId_v1310);
	_serSysEncSQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional(_buffer, _size, _lidx, &p->transmissionComb_r14);
	_serSysEncSQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional(_buffer, _size, _lidx, &p->frequencyDensity_r14);
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional(_buffer, _size, _lidx, &p->mbsfn_SubframeConfigList_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZPToAddModList_r11_CSI_RS_ConfigNZPToAddModList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZPToAddModList_r11_CSI_RS_ConfigNZPToAddModList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_CSI_RS_ConfigNZP_r11(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZPToReleaseList_r11_CSI_RS_ConfigNZPToReleaseModList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZPToReleaseList_r11_CSI_RS_ConfigNZPToReleaseModList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigZP_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigZP_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->csi_RS_ConfigZPId_r11, _lidx);
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->resourceConfigList_r11[i2], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->subframeConfig_r11, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigZPToAddModList_r11_CSI_RS_ConfigZPToAddModList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigZPToAddModList_r11_CSI_RS_ConfigZPToAddModList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_CSI_RS_ConfigZP_r11(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigZPToReleaseList_r11_CSI_RS_ConfigZPToReleaseModList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigZPToReleaseList_r11_CSI_RS_ConfigZPToReleaseModList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_CSI_RS_Config_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_CSI_RS_Config_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncCSI_RS_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CSI_RS_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSI_RS_Config_r10_CSI_RS_Config_Optional(_buffer, _size, _lidx, &p->CSI_RS_Config);
	_serSysEncSQN_CSI_RS_ConfigNZPToAddModList_r11_CSI_RS_ConfigNZPToAddModList_Optional(_buffer, _size, _lidx, &p->CSI_RS_ConfigNZPToAddModList);
	_serSysEncSQN_CSI_RS_ConfigNZPToReleaseList_r11_CSI_RS_ConfigNZPToReleaseModList_Optional(_buffer, _size, _lidx, &p->CSI_RS_ConfigNZPToReleaseModList);
	_serSysEncSQN_CSI_RS_ConfigZPToAddModList_r11_CSI_RS_ConfigZPToAddModList_Optional(_buffer, _size, _lidx, &p->CSI_RS_ConfigZPToAddModList);
	_serSysEncSQN_CSI_RS_ConfigZPToReleaseList_r11_CSI_RS_ConfigZPToReleaseModList_Optional(_buffer, _size, _lidx, &p->CSI_RS_ConfigZPToReleaseModList);
	_serSysEncToRS_EPRE_Ratios_Type_CSI_RS_Config_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncCSI_RS_Config_Type_CSI_RS_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CSI_RS_Config_Type_CSI_RS_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncCSI_RS_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_PmchConfig_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_PmchConfig_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPmchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PmchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncToRS_EPRE_Ratios_Type_PmchConfig_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);

	return SIDL_STATUS_OK;
}

static int _serSysEncPmchConfig_Type_Pmch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PmchConfig_Type_Pmch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPmchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncToRS_EPRE_Ratios_Type_EpdcchConfig_Type_RelativeTxPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct ToRS_EPRE_Ratios_Type_EpdcchConfig_Type_RelativeTxPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncToRS_EPRE_Ratios_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPdcchCandidateList_Type_ePdcchCandidateList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PdcchCandidateList_Type_ePdcchCandidateList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncPdcchCandidate_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value* p, enum SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig1_5_r10) {
		for (size_t i1 = 0; i1 < 20; i1++) {
			HTON_8(&_buffer[*_lidx], p->subframeConfig1_5_r10[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig0_r10) {
		for (size_t i1 = 0; i1 < 70; i1++) {
			HTON_8(&_buffer[*_lidx], p->subframeConfig0_r10[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig6_r10) {
		for (size_t i1 = 0; i1 < 60; i1++) {
			HTON_8(&_buffer[*_lidx], p->subframeConfig6_r10[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_MeasSubframePattern_r10_subframePatternTDD_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasSubframePattern_r10_subframePatternTDD_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasSubframePattern_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_MeasSubframePattern_r10_Value* p, enum SQN_MeasSubframePattern_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_MeasSubframePattern_r10_subframePatternFDD_r10) {
		for (size_t i1 = 0; i1 < 40; i1++) {
			HTON_8(&_buffer[*_lidx], p->subframePatternFDD_r10[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MeasSubframePattern_r10_subframePatternTDD_r10) {
		_serSysEncSQN_MeasSubframePattern_r10_subframePatternTDD_r10(_buffer, _size, _lidx, &p->subframePatternTDD_r10);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_MeasSubframePattern_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasSubframePattern_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MeasSubframePattern_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MeasSubframePattern_r10(_buffer, _size, _lidx, &p->subframePattern_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value* p, enum SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup) {
		_serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->numberPRB_Pairs_r11;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->resourceBlockAssignment_r11.d, _lidx);
	for (size_t i2 = 0; i2 < p->resourceBlockAssignment_r11.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->resourceBlockAssignment_r11.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value* p, enum SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_setup) {
		HTON_8(&_buffer[*_lidx], p->setup, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value* p, enum SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup) {
		{
			size_t _tmp = (size_t)p->setup;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value* p, enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13) {
		{
			size_t _tmp = (size_t)p->fdd_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13) {
		{
			size_t _tmp = (size_t)p->tdd_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->csi_NumRepetitionCE_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->mpdcch_pdsch_HoppingConfig_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13(_buffer, _size, _lidx, &p->mpdcch_StartSF_UESS_r13);
	{
		size_t _tmp = (size_t)p->mpdcch_NumRepetition_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->mpdcch_Narrowband_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value* p, enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup) {
		_serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfig_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfig_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->setConfigId_r11, _lidx);
	{
		size_t _tmp = (size_t)p->transmissionType_r11;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11(_buffer, _size, _lidx, &p->resourceBlockAssignment_r11);
	HTON_16(&_buffer[*_lidx], p->dmrs_ScramblingSequenceInt_r11, _lidx);
	HTON_16(&_buffer[*_lidx], p->pucch_ResourceStartOffset_r11, _lidx);
	_serSysEncSQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional(_buffer, _size, _lidx, &p->re_MappingQCL_ConfigId_r11);
	_serSysEncSQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional(_buffer, _size, _lidx, &p->csi_RS_ConfigZPId2_r12);
	_serSysEncSQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional(_buffer, _size, _lidx, &p->numberPRB_Pairs_v1310);
	_serSysEncSQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional(_buffer, _size, _lidx, &p->mpdcch_config_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_EPDCCH_SetConfig_r11(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_Config_r11_config_r11_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_Config_r11_config_r11_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional(_buffer, _size, _lidx, &p->subframePatternConfig_r11);
	_serSysEncUint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional(_buffer, _size, _lidx, &p->startSymbol_r11);
	_serSysEncSQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional(_buffer, _size, _lidx, &p->setConfigToReleaseList_r11);
	_serSysEncSQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional(_buffer, _size, _lidx, &p->setConfigToAddModList_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_Config_r11_config_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_EPDCCH_Config_r11_config_r11_Value* p, enum SQN_EPDCCH_Config_r11_config_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_EPDCCH_Config_r11_config_r11_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_EPDCCH_Config_r11_config_r11_setup) {
		_serSysEncSQN_EPDCCH_Config_r11_config_r11_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_EPDCCH_Config_r11_config_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_Config_r11_config_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_EPDCCH_Config_r11_config_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_Config_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_Config_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_EPDCCH_Config_r11_config_r11(_buffer, _size, _lidx, &p->config_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EPDCCH_Config_r11_EPDCCH_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EPDCCH_Config_r11_EPDCCH_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_EPDCCH_Config_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_dummy2_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_FreqHoppingParameters_r13_dummy2_Value* p, enum SQN_FreqHoppingParameters_r13_dummy2_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_FDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_TDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_dummy2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_dummy2* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_FreqHoppingParameters_r13_dummy2_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_FreqHoppingParameters_r13_dummy2(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_dummy3_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_FreqHoppingParameters_r13_dummy3_Value* p, enum SQN_FreqHoppingParameters_r13_dummy3_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_FDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_TDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_dummy3(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_dummy3* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_FreqHoppingParameters_r13_dummy3_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_FreqHoppingParameters_r13_dummy3(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value* p, enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_FDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_TDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value* p, enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_FDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_TDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional(_buffer, _size, _lidx, &p->dummy);
	_serSysEncSQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional(_buffer, _size, _lidx, &p->dummy2);
	_serSysEncSQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional(_buffer, _size, _lidx, &p->dummy3);
	_serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional(_buffer, _size, _lidx, &p->interval_ULHoppingConfigCommonModeA_r13);
	_serSysEncSQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional(_buffer, _size, _lidx, &p->interval_ULHoppingConfigCommonModeB_r13);
	_serSysEncUint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional(_buffer, _size, _lidx, &p->dummy4);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_mPDCCH_FreqHoppingParameters_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_mPDCCH_FreqHoppingParameters_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_FreqHoppingParameters_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncEpdcchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct EpdcchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncToRS_EPRE_Ratios_Type_EpdcchConfig_Type_RelativeTxPower_Optional(_buffer, _size, _lidx, &p->RelativeTxPower);
	_serSysEncPdcchCandidateList_Type_ePdcchCandidateList_Optional(_buffer, _size, _lidx, &p->ePdcchCandidateList);
	_serSysEncSQN_EPDCCH_Config_r11_EPDCCH_Config_Optional(_buffer, _size, _lidx, &p->EPDCCH_Config);
	_serSysEncSQN_FreqHoppingParameters_r13_mPDCCH_FreqHoppingParameters_r13_Optional(_buffer, _size, _lidx, &p->mPDCCH_FreqHoppingParameters_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncEpdcchConfig_Type_Epdcch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct EpdcchConfig_Type_Epdcch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncEpdcchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value* p, enum SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms40_r12) {
		HTON_8(&_buffer[*_lidx], p->ms40_r12, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms80_r12) {
		HTON_8(&_buffer[*_lidx], p->ms80_r12, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms160_r12) {
		HTON_8(&_buffer[*_lidx], p->ms160_r12, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncDMTC_PeriodOffset_r12_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const DMTC_PeriodOffset_r12_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncDMTC_PeriodOffset_r12_Type_DMTC_PeriodOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DMTC_PeriodOffset_r12_Type_DMTC_PeriodOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncDMTC_PeriodOffset_r12_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value* p, enum SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_durationFDD_r12) {
		HTON_8(&_buffer[*_lidx], p->durationFDD_r12, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_durationTDD_r12) {
		HTON_8(&_buffer[*_lidx], p->durationTDD_r12, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncDS_OccasionDuration_r12_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const DS_OccasionDuration_r12_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncDS_OccasionDuration_r12_Type_DS_OccasionDuration_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DS_OccasionDuration_r12_Type_DS_OccasionDuration_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncDS_OccasionDuration_r12_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncDS_RS_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DS_RS_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncDMTC_PeriodOffset_r12_Type_DMTC_PeriodOffset_Optional(_buffer, _size, _lidx, &p->DMTC_PeriodOffset);
	_serSysEncDS_OccasionDuration_r12_Type_DS_OccasionDuration_r12_Optional(_buffer, _size, _lidx, &p->DS_OccasionDuration_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncDS_RS_Config_Type_DS_RS_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DS_RS_Config_Type_DS_RS_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncDS_RS_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPhysicalLayerConfigDL_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PhysicalLayerConfigDL_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncDownlinkAntennaGroupConfig_Type_AntennaGroup_Optional(_buffer, _size, _lidx, &p->AntennaGroup);
	_serSysEncPbchConfig_Type_Pbch_Optional(_buffer, _size, _lidx, &p->Pbch);
	_serSysEncPcfichConfig_Type_Pcfich_Optional(_buffer, _size, _lidx, &p->Pcfich);
	_serSysEncPhichConfig_Type_Phich_Optional(_buffer, _size, _lidx, &p->Phich);
	_serSysEncPdcchConfig_Type_Pdcch_Optional(_buffer, _size, _lidx, &p->Pdcch);
	_serSysEncPdschConfig_Type_Pdsch_Optional(_buffer, _size, _lidx, &p->Pdsch);
	_serSysEncPrimarySyncSignal_Type_Pss_Optional(_buffer, _size, _lidx, &p->Pss);
	_serSysEncSecondarySyncSignal_Type_Sss_Optional(_buffer, _size, _lidx, &p->Sss);
	_serSysEncCSI_RS_Config_Type_CSI_RS_Config_Optional(_buffer, _size, _lidx, &p->CSI_RS_Config);
	_serSysEncPmchConfig_Type_Pmch_Optional(_buffer, _size, _lidx, &p->Pmch);
	_serSysEncEpdcchConfig_Type_Epdcch_Optional(_buffer, _size, _lidx, &p->Epdcch);
	_serSysEncDS_RS_Config_Type_DS_RS_Config_Optional(_buffer, _size, _lidx, &p->DS_RS_Config);

	return SIDL_STATUS_OK;
}

static int _serSysEncPhysicalLayerConfigDL_Type_PhysicalLayerConfigDL_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PhysicalLayerConfigDL_Type_PhysicalLayerConfigDL_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPhysicalLayerConfigDL_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncAttenuation_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union Attenuation_Type_Value* p, enum Attenuation_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == Attenuation_Type_Value) {
		HTON_8(&_buffer[*_lidx], p->Value, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == Attenuation_Type_Off) {
		HTON_8(&_buffer[*_lidx], p->Off, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncInitialAttenuation_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const InitialAttenuation_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncAttenuation_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncInitialCellPower_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct InitialCellPower_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->MaxReferencePower, _lidx);
	_serSysEncInitialAttenuation_Type(_buffer, _size, _lidx, &p->Attenuation);

	return SIDL_STATUS_OK;
}

static int _serSysEncInitialCellPower_Type_InitialCellPower_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct InitialCellPower_Type_InitialCellPower_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncInitialCellPower_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcchToPbchConfig_Type_Pbch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BcchToPbchConfig_Type_Pbch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncFreqDomainSchedulCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct FreqDomainSchedulCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->FirstRbIndex, _lidx);
	HTON_32(&_buffer[*_lidx], p->MaxRbCnt, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncRepetitionNumber_Type_DciDlInfoCommon_Type_RepetitionNumber_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct RepetitionNumber_Type_DciDlInfoCommon_Type_RepetitionNumber_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncDCISubframeRepetitionNumber_Type_DciDlInfoCommon_Type_DCISubframeRepetitionNumber_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DCISubframeRepetitionNumber_Type_DciDlInfoCommon_Type_DCISubframeRepetitionNumber_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncDciDlInfoCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DciDlInfoCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->Format;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->ResourceAllocType;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->Modulation_1stCW;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->Modulation_2ndCW;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncFreqDomainSchedulCommon_Type(_buffer, _size, _lidx, &p->FreqDomainSchedul);
	HTON_32(&_buffer[*_lidx], p->RedundancyVersionList.d, _lidx);
	for (size_t i1 = 0; i1 < p->RedundancyVersionList.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->RedundancyVersionList.v[i1], _lidx);
	}
	_serSysEncRepetitionNumber_Type_DciDlInfoCommon_Type_RepetitionNumber_Optional(_buffer, _size, _lidx, &p->RepetitionNumber);
	_serSysEncDCISubframeRepetitionNumber_Type_DciDlInfoCommon_Type_DCISubframeRepetitionNumber_Optional(_buffer, _size, _lidx, &p->DCISubframeRepetitionNumber);

	return SIDL_STATUS_OK;
}

static int _serSysEncDciDlInfoCommon_Type_Sib1Schedul_Type_DciInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DciDlInfoCommon_Type_Sib1Schedul_Type_DciInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncDciDlInfoCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSib1Schedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Sib1Schedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncDciDlInfoCommon_Type_Sib1Schedul_Type_DciInfo_Optional(_buffer, _size, _lidx, &p->DciInfo);

	return SIDL_STATUS_OK;
}

static int _serSysEncSib1Schedul_Type_Sib1Schedul_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Sib1Schedul_Type_Sib1Schedul_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSib1Schedul_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSiWindowLength_Type_WindowLength_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SiWindowLength_Type_WindowLength_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SI_Periodicity_r12_e_Periodicity_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SI_Periodicity_r12_e_Periodicity_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncDciDlInfoCommon_Type_SingleSiSchedul_Type_DciInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DciDlInfoCommon_Type_SingleSiSchedul_Type_DciInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncDciDlInfoCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncInt32_t_SubframeOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int32_t_SubframeOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSingleSiSchedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SingleSiSchedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncDciDlInfoCommon_Type_SingleSiSchedul_Type_DciInfo_Optional(_buffer, _size, _lidx, &p->DciInfo);
	_serSysEncInt32_t_SubframeOffset_Optional(_buffer, _size, _lidx, &p->SubframeOffset);

	return SIDL_STATUS_OK;
}

static int _serSysEncSingleSiSchedul_Type_Window_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SingleSiSchedul_Type_Window_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSingleSiSchedul_Type(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSiSchedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SiSchedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SI_Periodicity_r12_e_Periodicity_Optional(_buffer, _size, _lidx, &p->Periodicity);
	_serSysEncSingleSiSchedul_Type_Window_DynamicOptional(_buffer, _size, _lidx, &p->Window);

	return SIDL_STATUS_OK;
}

static int _serSysEncSiSchedulList_Type_SiList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SiSchedulList_Type_SiList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSiSchedul_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSiSchedulList_Type_SegmentedSiList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SiSchedulList_Type_SegmentedSiList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSiSchedul_Type(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncAllSiSchedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct AllSiSchedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSiWindowLength_Type_WindowLength_Optional(_buffer, _size, _lidx, &p->WindowLength);
	_serSysEncSiSchedulList_Type_SiList_Optional(_buffer, _size, _lidx, &p->SiList);
	_serSysEncSiSchedulList_Type_SegmentedSiList_Optional(_buffer, _size, _lidx, &p->SegmentedSiList);

	return SIDL_STATUS_OK;
}

static int _serSysEncAllSiSchedul_Type_SiSchedul_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct AllSiSchedul_Type_SiSchedul_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncAllSiSchedul_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcchToPdschConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BcchToPdschConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSib1Schedul_Type_Sib1Schedul_Optional(_buffer, _size, _lidx, &p->Sib1Schedul);
	_serSysEncAllSiSchedul_Type_SiSchedul_Optional(_buffer, _size, _lidx, &p->SiSchedul);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcchToPdschConfig_Type_Pdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BcchToPdschConfig_Type_Pdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBcchToPdschConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MasterInformationBlock(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MasterInformationBlock* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->dl_Bandwidth;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PHICH_Config(_buffer, _size, _lidx, &p->phich_Config);
	for (size_t i1 = 0; i1 < 8; i1++) {
		HTON_8(&_buffer[*_lidx], p->systemFrameNumber[i1], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->schedulingInfoSIB1_BR_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->systemInfoUnchanged_BR_r15, _lidx);
	for (size_t i1 = 0; i1 < 4; i1++) {
		HTON_8(&_buffer[*_lidx], p->spare[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_BCH_Message(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_BCH_Message* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MasterInformationBlock(_buffer, _size, _lidx, &p->message);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_BCH_Message_BcchInfo_Type_MIB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_BCH_Message_BcchInfo_Type_MIB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_BCCH_BCH_Message(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->ac_BarringFactor;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->ac_BarringTime;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	for (size_t i2 = 0; i2 < 5; i2++) {
		HTON_8(&_buffer[*_lidx], p->ac_BarringForSpecialAC[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_ac_BarringInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_ac_BarringInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->ac_BarringForEmergency, _lidx);
	_serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional(_buffer, _size, _lidx, &p->ac_BarringForMO_Signalling);
	_serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional(_buffer, _size, _lidx, &p->ac_BarringForMO_Data);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType2_ac_BarringInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sizeOfRA_PreamblesGroupA;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->messageSizeGroupA;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->messagePowerOffsetGroupB;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_preambleInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_preambleInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->numberOfRA_Preambles;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional(_buffer, _size, _lidx, &p->preamblesGroupAConfig);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PowerRampingParameters(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PowerRampingParameters* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->powerRampingStep;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->preambleInitialReceivedTargetPower;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_ra_SupervisionInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_ra_SupervisionInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->preambleTransMax;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->ra_ResponseWindowSize;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->mac_ContentionResolutionTimer;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->firstPreamble_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->lastPreamble_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->edt_LastPreamble_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->edt_SmallTBS_Enabled_r15, _lidx);
	{
		size_t _tmp = (size_t)p->edt_TBS_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional(_buffer, _size, _lidx, &p->mac_ContentionResolutionTimer_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_CE_LevelInfo_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_CE_LevelInfo_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13(_buffer, _size, _lidx, &p->preambleMappingInfo_r13);
	{
		size_t _tmp = (size_t)p->ra_ResponseWindowSize_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->mac_ContentionResolutionTimer_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->rar_HoppingConfig_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional(_buffer, _size, _lidx, &p->edt_Parameters_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_RACH_CE_LevelInfo_r13(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RACH_ConfigCommon_preambleInfo(_buffer, _size, _lidx, &p->preambleInfo);
	_serSysEncSQN_PowerRampingParameters(_buffer, _size, _lidx, &p->powerRampingParameters);
	_serSysEncSQN_RACH_ConfigCommon_ra_SupervisionInfo(_buffer, _size, _lidx, &p->ra_SupervisionInfo);
	HTON_8(&_buffer[*_lidx], p->maxHARQ_Msg3Tx, _lidx);
	_serSysEncSQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional(_buffer, _size, _lidx, &p->preambleTransMax_CE_r13);
	_serSysEncSQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional(_buffer, _size, _lidx, &p->rach_CE_LevelInfoList_r13);
	_serSysEncSQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional(_buffer, _size, _lidx, &p->edt_SmallTBS_Subset_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->modificationPeriodCoeff;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PCCH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PCCH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->defaultPagingCycle;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->nB;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->prach_ConfigIndex, _lidx);
	HTON_8(&_buffer[*_lidx], p->highSpeedFlag, _lidx);
	HTON_8(&_buffer[*_lidx], p->zeroCorrelationZoneConfig, _lidx);
	HTON_8(&_buffer[*_lidx], p->prach_FreqOffset, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigSIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigSIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->rootSequenceIndex, _lidx);
	_serSysEncSQN_PRACH_ConfigInfo(_buffer, _size, _lidx, &p->prach_ConfigInfo);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDSCH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDSCH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->referenceSignalPower, _lidx);
	HTON_8(&_buffer[*_lidx], p->p_b, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_pusch_ConfigBasic(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_pusch_ConfigBasic* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->n_SB, _lidx);
	{
		size_t _tmp = (size_t)p->hoppingMode;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->pusch_HoppingOffset, _lidx);
	HTON_8(&_buffer[*_lidx], p->enable64QAM, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UL_ReferenceSignalsPUSCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UL_ReferenceSignalsPUSCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->groupHoppingEnabled, _lidx);
	HTON_8(&_buffer[*_lidx], p->groupAssignmentPUSCH, _lidx);
	HTON_8(&_buffer[*_lidx], p->sequenceHoppingEnabled, _lidx);
	HTON_8(&_buffer[*_lidx], p->cyclicShift, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigCommon_pusch_ConfigBasic(_buffer, _size, _lidx, &p->pusch_ConfigBasic);
	_serSysEncSQN_UL_ReferenceSignalsPUSCH(_buffer, _size, _lidx, &p->ul_ReferenceSignalsPUSCH);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->deltaPUCCH_Shift;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->nRB_CQI, _lidx);
	HTON_8(&_buffer[*_lidx], p->nCS_AN, _lidx);
	HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigCommon_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigCommon_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->srs_BandwidthConfig;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->srs_SubframeConfig;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->ackNackSRS_SimultaneousTransmission, _lidx);
	_serSysEncSQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional(_buffer, _size, _lidx, &p->srs_MaxUpPts);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigCommon_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SoundingRS_UL_ConfigCommon_Value* p, enum SQN_SoundingRS_UL_ConfigCommon_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SoundingRS_UL_ConfigCommon_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SoundingRS_UL_ConfigCommon_setup) {
		_serSysEncSQN_SoundingRS_UL_ConfigCommon_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SoundingRS_UL_ConfigCommon_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_PUCCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_PUCCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->deltaF_PUCCH_Format1;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->deltaF_PUCCH_Format1b;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->deltaF_PUCCH_Format2;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->deltaF_PUCCH_Format2a;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->deltaF_PUCCH_Format2b;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UplinkPowerControlCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UplinkPowerControlCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->p0_NominalPUSCH, _lidx);
	{
		size_t _tmp = (size_t)p->alpha;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->p0_NominalPUCCH, _lidx);
	_serSysEncSQN_DeltaFList_PUCCH(_buffer, _size, _lidx, &p->deltaFList_PUCCH);
	HTON_8(&_buffer[*_lidx], p->deltaPreambleMsg3, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UplinkPowerControlCommon_v1020(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UplinkPowerControlCommon_v1020* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->deltaF_PUCCH_Format3_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->deltaF_PUCCH_Format1bCS_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_UplinkPowerControlCommon_v1020(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_v1250_txFailParams_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_v1250_txFailParams_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->connEstFailCount_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->connEstFailOffsetValidity_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncUint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional(_buffer, _size, _lidx, &p->connEstFailOffset_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_v1250(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_v1250* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RACH_ConfigCommon_v1250_txFailParams_r12(_buffer, _size, _lidx, &p->txFailParams_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RACH_ConfigCommon_v1250(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1270(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1270* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->enable64QAM_v1270;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigCommon_v1270(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_Config_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_Config_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->modificationPeriodCoeff_v1310;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_BCCH_Config_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PCCH_Config_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PCCH_Config_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->paging_narrowBands_r13, _lidx);
	{
		size_t _tmp = (size_t)p->mpdcch_NumRepetition_Paging_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional(_buffer, _size, _lidx, &p->nB_v1310);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PCCH_Config_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_FreqHoppingParameters_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PDSCH_ConfigCommon_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional(_buffer, _size, _lidx, &p->pusch_maxNumRepetitionCEmodeA_r13);
	_serSysEncSQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional(_buffer, _size, _lidx, &p->pusch_maxNumRepetitionCEmodeB_r13);
	_serSysEncUint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional(_buffer, _size, _lidx, &p->pusch_HoppingOffset_v1310);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigCommon_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value* p, enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13) {
		{
			size_t _tmp = (size_t)p->fdd_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13) {
		{
			size_t _tmp = (size_t)p->tdd_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ParametersCE_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ParametersCE_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->prach_ConfigIndex_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->prach_FreqOffset_r13, _lidx);
	_serSysEncSQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional(_buffer, _size, _lidx, &p->prach_StartingSubframe_r13);
	_serSysEncSQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional(_buffer, _size, _lidx, &p->maxNumPreambleAttemptCE_r13);
	{
		size_t _tmp = (size_t)p->numRepetitionPerPreambleAttempt_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->mpdcch_NarrowbandsToMonitor_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->mpdcch_NarrowbandsToMonitor_r13.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->mpdcch_NarrowbandsToMonitor_r13.v[i3], _lidx);
	}
	{
		size_t _tmp = (size_t)p->mpdcch_NumRepetition_RA_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->prach_HoppingConfig_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigSIB_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigSIB_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->rsrp_ThresholdsPrachInfoList_r13.d, _lidx);
	for (size_t i2 = 0; i2 < p->rsrp_ThresholdsPrachInfoList_r13.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->rsrp_ThresholdsPrachInfoList_r13.v[i2], _lidx);
	}
	_serSysEncSQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional(_buffer, _size, _lidx, &p->mpdcch_startSF_CSS_RA_r13);
	_serSysEncUint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional(_buffer, _size, _lidx, &p->prach_HoppingOffset_r13);
	HTON_32(&_buffer[*_lidx], p->prach_ParametersListCE_r13.d, _lidx);
	for (size_t i2 = 0; i2 < p->prach_ParametersListCE_r13.d; i2++) {
		_serSysEncSQN_PRACH_ParametersCE_r13(_buffer, _size, _lidx, &p->prach_ParametersListCE_r13.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_ConfigSIB_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional(_buffer, _size, _lidx, &p->n1PUCCH_AN_InfoList_r13);
	_serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional(_buffer, _size, _lidx, &p->pucch_NumRepetitionCE_Msg4_Level0_r13);
	_serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional(_buffer, _size, _lidx, &p->pucch_NumRepetitionCE_Msg4_Level1_r13);
	_serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional(_buffer, _size, _lidx, &p->pucch_NumRepetitionCE_Msg4_Level2_r13);
	_serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional(_buffer, _size, _lidx, &p->pucch_NumRepetitionCE_Msg4_Level3_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigCommon_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional(_buffer, _size, _lidx, &p->highSpeedEnhancedMeasFlag_r14);
	_serSysEncSQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional(_buffer, _size, _lidx, &p->highSpeedEnhancedDemodulationFlag_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_HighSpeedConfig_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->rootSequenceIndexHighSpeed_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->zeroCorrelationZoneConfigHighSpeed_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->prach_ConfigIndexHighSpeed_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->prach_FreqOffsetHighSpeed_r14, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_Config_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional(_buffer, _size, _lidx, &p->pucch_NumRepetitionCE_Msg4_Level3_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigCommon_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->prach_ConfigIndex_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->prach_FreqOffset_r15, _lidx);
	_serSysEncSQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional(_buffer, _size, _lidx, &p->prach_StartingSubframe_r15);
	HTON_32(&_buffer[*_lidx], p->mpdcch_NarrowbandsToMonitor_r15.d, _lidx);
	for (size_t i3 = 0; i3 < p->mpdcch_NarrowbandsToMonitor_r15.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->mpdcch_NarrowbandsToMonitor_r15.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EDT_PRACH_ParametersCE_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EDT_PRACH_ParametersCE_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional(_buffer, _size, _lidx, &p->edt_PRACH_ParametersCE_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigSIB_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigSIB_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->edt_PRACH_ParametersListCE_r15.d, _lidx);
	for (size_t i2 = 0; i2 < p->edt_PRACH_ParametersListCE_r15.d; i2++) {
		_serSysEncSQN_EDT_PRACH_ParametersCE_r15(_buffer, _size, _lidx, &p->edt_PRACH_ParametersListCE_r15.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_ConfigSIB_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSS_Config_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSS_Config_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->duration_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->freqLocation_r15, _lidx);
	{
		size_t _tmp = (size_t)p->periodicity_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->powerBoost_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->timeOffset_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RSS_Config_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->maxDurationFactor_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional(_buffer, _size, _lidx, &p->numPOs_r15);
	{
		size_t _tmp = (size_t)p->freqLocation_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->timeOffsetDRX_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->timeOffset_eDRX_Short_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional(_buffer, _size, _lidx, &p->timeOffset_eDRX_Long_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WUS_Config_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->highSpeedMeasGapCE_ModeA_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_HighSpeedConfig_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional(_buffer, _size, _lidx, &p->deltaF_slotSPUCCH_Format1_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional(_buffer, _size, _lidx, &p->deltaF_slotSPUCCH_Format1a_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional(_buffer, _size, _lidx, &p->deltaF_slotSPUCCH_Format1b_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional(_buffer, _size, _lidx, &p->deltaF_slotSPUCCH_Format3_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional(_buffer, _size, _lidx, &p->deltaF_slotSPUCCH_RM_Format4_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional(_buffer, _size, _lidx, &p->deltaF_slotSPUCCH_TBCC_Format4_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional(_buffer, _size, _lidx, &p->deltaF_subslotSPUCCH_Format1and1a_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional(_buffer, _size, _lidx, &p->deltaF_subslotSPUCCH_Format1b_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional(_buffer, _size, _lidx, &p->deltaF_subslotSPUCCH_RM_Format4_r15);
	_serSysEncSQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional(_buffer, _size, _lidx, &p->deltaF_subslotSPUCCH_TBCC_Format4_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_DeltaFList_SPUCCH_r15_Value* p, enum SQN_DeltaFList_SPUCCH_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_DeltaFList_SPUCCH_r15_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_DeltaFList_SPUCCH_r15_setup) {
		_serSysEncSQN_DeltaFList_SPUCCH_r15_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_DeltaFList_SPUCCH_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_DeltaFList_SPUCCH_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_DeltaFList_SPUCCH_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UplinkPowerControlCommon_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UplinkPowerControlCommon_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_DeltaFList_SPUCCH_r15(_buffer, _size, _lidx, &p->deltaFList_SPUCCH_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_UplinkPowerControlCommon_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_v1560(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_v1560* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->powerBoost_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WUS_Config_v1560(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->numDRX_CyclesRelaxed_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WUS_Config_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional(_buffer, _size, _lidx, &p->highSpeedEnhMeasFlag2_r16);
	_serSysEncSQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional(_buffer, _size, _lidx, &p->highSpeedEnhDemodFlag2_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_HighSpeedConfig_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CRS_ChEstMPDCCH_ConfigCommon_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->powerRatio_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CRS_ChEstMPDCCH_ConfigCommon_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_TimeParameters_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_TimeParameters_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->maxDurationFactor_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional(_buffer, _size, _lidx, &p->numPOs_r16);
	{
		size_t _tmp = (size_t)p->timeOffsetDRX_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->timeOffset_eDRX_Short_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional(_buffer, _size, _lidx, &p->timeOffset_eDRX_Long_r16);
	_serSysEncSQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional(_buffer, _size, _lidx, &p->numDRX_CyclesRelaxed_r16);
	_serSysEncSQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional(_buffer, _size, _lidx, &p->powerBoost_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_GWUS_TimeParameters_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value* p, enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS) {
		{
			size_t _tmp = (size_t)p->resourceLocationWithWUS;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS) {
		{
			size_t _tmp = (size_t)p->resourceLocationWithoutWUS;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		{
			size_t _tmp = (size_t)p->v.v[i2];
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_ResourceConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_ResourceConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16(_buffer, _size, _lidx, &p->resourceMappingPattern_r16);
	_serSysEncSQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional(_buffer, _size, _lidx, &p->numGroupsList_r16);
	_serSysEncSQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional(_buffer, _size, _lidx, &p->groupsForServiceList_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_GWUS_ResourceConfig_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_GWUS_ResourceConfig_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		{
			size_t _tmp = (size_t)p->v.v[i2];
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_Config_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_Config_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional(_buffer, _size, _lidx, &p->groupAlternation_r16);
	_serSysEncSQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional(_buffer, _size, _lidx, &p->commonSequence_r16);
	_serSysEncSQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional(_buffer, _size, _lidx, &p->timeParameters_r16);
	_serSysEncSQN_GWUS_ResourceConfig_r16(_buffer, _size, _lidx, &p->resourceConfigDRX_r16);
	_serSysEncSQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional(_buffer, _size, _lidx, &p->resourceConfig_eDRX_Short_r16);
	_serSysEncSQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional(_buffer, _size, _lidx, &p->resourceConfig_eDRX_Long_r16);
	_serSysEncSQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional(_buffer, _size, _lidx, &p->probThreshList_r16);
	_serSysEncSQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional(_buffer, _size, _lidx, &p->groupNarrowBandList_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_GWUS_Config_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UplinkPowerControlCommon_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UplinkPowerControlCommon_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->alphaSRS_Add_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->p0_NominalSRS_Add_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_UplinkPowerControlCommon_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncB2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RadioResourceConfigCommonSIB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RadioResourceConfigCommonSIB* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RACH_ConfigCommon(_buffer, _size, _lidx, &p->rach_ConfigCommon);
	_serSysEncSQN_BCCH_Config(_buffer, _size, _lidx, &p->bcch_Config);
	_serSysEncSQN_PCCH_Config(_buffer, _size, _lidx, &p->pcch_Config);
	_serSysEncSQN_PRACH_ConfigSIB(_buffer, _size, _lidx, &p->prach_Config);
	_serSysEncSQN_PDSCH_ConfigCommon(_buffer, _size, _lidx, &p->pdsch_ConfigCommon);
	_serSysEncSQN_PUSCH_ConfigCommon(_buffer, _size, _lidx, &p->pusch_ConfigCommon);
	_serSysEncSQN_PUCCH_ConfigCommon(_buffer, _size, _lidx, &p->pucch_ConfigCommon);
	_serSysEncSQN_SoundingRS_UL_ConfigCommon(_buffer, _size, _lidx, &p->soundingRS_UL_ConfigCommon);
	_serSysEncSQN_UplinkPowerControlCommon(_buffer, _size, _lidx, &p->uplinkPowerControlCommon);
	{
		size_t _tmp = (size_t)p->ul_CyclicPrefixLength;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional(_buffer, _size, _lidx, &p->uplinkPowerControlCommon_v1020);
	_serSysEncSQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional(_buffer, _size, _lidx, &p->rach_ConfigCommon_v1250);
	_serSysEncSQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional(_buffer, _size, _lidx, &p->pusch_ConfigCommon_v1270);
	_serSysEncSQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional(_buffer, _size, _lidx, &p->bcch_Config_v1310);
	_serSysEncSQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional(_buffer, _size, _lidx, &p->pcch_Config_v1310);
	_serSysEncSQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional(_buffer, _size, _lidx, &p->freqHoppingParameters_r13);
	_serSysEncSQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional(_buffer, _size, _lidx, &p->pdsch_ConfigCommon_v1310);
	_serSysEncSQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional(_buffer, _size, _lidx, &p->pusch_ConfigCommon_v1310);
	_serSysEncSQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional(_buffer, _size, _lidx, &p->prach_ConfigCommon_v1310);
	_serSysEncSQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional(_buffer, _size, _lidx, &p->pucch_ConfigCommon_v1310);
	_serSysEncSQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional(_buffer, _size, _lidx, &p->highSpeedConfig_r14);
	_serSysEncSQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional(_buffer, _size, _lidx, &p->prach_Config_v1430);
	_serSysEncSQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional(_buffer, _size, _lidx, &p->pucch_ConfigCommon_v1430);
	_serSysEncSQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional(_buffer, _size, _lidx, &p->prach_Config_v1530);
	_serSysEncSQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional(_buffer, _size, _lidx, &p->ce_RSS_Config_r15);
	_serSysEncSQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional(_buffer, _size, _lidx, &p->wus_Config_r15);
	_serSysEncSQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional(_buffer, _size, _lidx, &p->highSpeedConfig_v1530);
	_serSysEncSQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional(_buffer, _size, _lidx, &p->uplinkPowerControlCommon_v1540);
	_serSysEncSQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional(_buffer, _size, _lidx, &p->wus_Config_v1560);
	_serSysEncSQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional(_buffer, _size, _lidx, &p->wus_Config_v1610);
	_serSysEncSQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional(_buffer, _size, _lidx, &p->highSpeedConfig_v1610);
	_serSysEncSQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional(_buffer, _size, _lidx, &p->crs_ChEstMPDCCH_ConfigCommon_r16);
	_serSysEncSQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional(_buffer, _size, _lidx, &p->gwus_Config_r16);
	_serSysEncSQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional(_buffer, _size, _lidx, &p->uplinkPowerControlCommon_v1610);
	_serSysEncSQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional(_buffer, _size, _lidx, &p->rss_MeasConfig_r16);
	_serSysEncSQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional(_buffer, _size, _lidx, &p->rss_MeasNonNCL_r16);
	_serSysEncB2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional(_buffer, _size, _lidx, &p->puncturedSubcarriersDL_r16);
	_serSysEncBool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional(_buffer, _size, _lidx, &p->highSpeedInterRAT_NR_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UE_TimersAndConstants(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UE_TimersAndConstants* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->t300;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t301;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t310;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->n310;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t311;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->n311;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional(_buffer, _size, _lidx, &p->t300_v1310);
	_serSysEncSQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional(_buffer, _size, _lidx, &p->t301_v1310);
	_serSysEncSQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional(_buffer, _size, _lidx, &p->t310_v1330);
	_serSysEncSQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional(_buffer, _size, _lidx, &p->t300_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_freqInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_freqInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional(_buffer, _size, _lidx, &p->ul_CarrierFreq);
	_serSysEncSQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(_buffer, _size, _lidx, &p->ul_Bandwidth);
	HTON_8(&_buffer[*_lidx], p->additionalSpectrumEmission, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_MBSFN_SubframeConfig(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->ac_BarringForEmergency_r12, _lidx);
	_serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringForMO_Signalling_r12);
	_serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringForMO_Data_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringPerPLMN_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringPerPLMN_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_IdentityIndex_r12, _lidx);
	_serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringInfo_r12);
	_serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringSkipForMMTELVoice_r12);
	_serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringSkipForMMTELVideo_r12);
	_serSysEncSQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringSkipForSMS_r12);
	_serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringForCSFB_r12);
	_serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional(_buffer, _size, _lidx, &p->ssac_BarringForMMTEL_Voice_r12);
	_serSysEncSQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional(_buffer, _size, _lidx, &p->ssac_BarringForMMTEL_Video_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_AC_BarringPerPLMN_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->ac_BarringFactor_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->ac_BarringTime_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BarringPerACDC_Category_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BarringPerACDC_Category_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->acdc_Category_r13, _lidx);
	_serSysEncSQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional(_buffer, _size, _lidx, &p->acdc_BarringConfig_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ACDC_BarringForCommon_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ACDC_BarringForCommon_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->acdc_HPLMNonly_r13, _lidx);
	HTON_32(&_buffer[*_lidx], p->barringPerACDC_CategoryList_r13.d, _lidx);
	for (size_t i2 = 0; i2 < p->barringPerACDC_CategoryList_r13.d; i2++) {
		_serSysEncSQN_BarringPerACDC_Category_r13(_buffer, _size, _lidx, &p->barringPerACDC_CategoryList_r13.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ACDC_BarringForCommon_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ACDC_BarringPerPLMN_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ACDC_BarringPerPLMN_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_IdentityIndex_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->acdc_OnlyForHPLMN_r13, _lidx);
	HTON_32(&_buffer[*_lidx], p->barringPerACDC_CategoryList_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->barringPerACDC_CategoryList_r13.d; i3++) {
		_serSysEncSQN_BarringPerACDC_Category_r13(_buffer, _size, _lidx, &p->barringPerACDC_CategoryList_r13.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_ACDC_BarringPerPLMN_r13(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UDT_Restricting_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UDT_Restricting_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional(_buffer, _size, _lidx, &p->udt_Restricting_r13);
	_serSysEncSQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional(_buffer, _size, _lidx, &p->udt_RestrictingTime_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_UDT_Restricting_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_UDT_Restricting_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UDT_RestrictingPerPLMN_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UDT_RestrictingPerPLMN_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_IdentityIndex_r13, _lidx);
	_serSysEncSQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional(_buffer, _size, _lidx, &p->udt_Restricting_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_UDT_RestrictingPerPLMN_r13(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CIOT_OptimisationPLMN_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CIOT_OptimisationPLMN_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional(_buffer, _size, _lidx, &p->up_CIoT_EPS_Optimisation_r13);
	_serSysEncSQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional(_buffer, _size, _lidx, &p->cp_CIoT_EPS_Optimisation_r13);
	_serSysEncSQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional(_buffer, _size, _lidx, &p->attachWithoutPDN_Connectivity_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CIOT_OptimisationPLMN_r13(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_MBSFN_SubframeConfig_v1430(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_Info_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_Info_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional(_buffer, _size, _lidx, &p->upperLayerIndication_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_PLMN_Info_r15(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType2(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType2* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional(_buffer, _size, _lidx, &p->ac_BarringInfo);
	_serSysEncSQN_RadioResourceConfigCommonSIB(_buffer, _size, _lidx, &p->radioResourceConfigCommon);
	_serSysEncSQN_UE_TimersAndConstants(_buffer, _size, _lidx, &p->ue_TimersAndConstants);
	_serSysEncSQN_SystemInformationBlockType2_freqInfo(_buffer, _size, _lidx, &p->freqInfo);
	_serSysEncSQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional(_buffer, _size, _lidx, &p->mbsfn_SubframeConfigList);
	{
		size_t _tmp = (size_t)p->timeAlignmentTimerCommon;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional(_buffer, _size, _lidx, &p->ssac_BarringForMMTEL_Voice_r9);
	_serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional(_buffer, _size, _lidx, &p->ssac_BarringForMMTEL_Video_r9);
	_serSysEncSQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional(_buffer, _size, _lidx, &p->ac_BarringForCSFB_r10);
	_serSysEncSQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringSkipForMMTELVoice_r12);
	_serSysEncSQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringSkipForMMTELVideo_r12);
	_serSysEncSQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringSkipForSMS_r12);
	_serSysEncSQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional(_buffer, _size, _lidx, &p->ac_BarringPerPLMN_List_r12);
	_serSysEncSQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional(_buffer, _size, _lidx, &p->voiceServiceCauseIndication_r12);
	_serSysEncSQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional(_buffer, _size, _lidx, &p->acdc_BarringForCommon_r13);
	_serSysEncSQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional(_buffer, _size, _lidx, &p->acdc_BarringPerPLMN_List_r13);
	_serSysEncSQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional(_buffer, _size, _lidx, &p->udt_RestrictingForCommon_r13);
	_serSysEncSQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional(_buffer, _size, _lidx, &p->udt_RestrictingPerPLMN_List_r13);
	_serSysEncSQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional(_buffer, _size, _lidx, &p->cIoT_EPS_OptimisationInfo_r13);
	_serSysEncSQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional(_buffer, _size, _lidx, &p->useFullResumeID_r13);
	_serSysEncSQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional(_buffer, _size, _lidx, &p->unicastFreqHoppingInd_r13);
	_serSysEncSQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional(_buffer, _size, _lidx, &p->mbsfn_SubframeConfigList_v1430);
	_serSysEncSQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional(_buffer, _size, _lidx, &p->videoServiceCauseIndication_r14);
	_serSysEncSQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional(_buffer, _size, _lidx, &p->plmn_InfoList_r15);
	_serSysEncSQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional(_buffer, _size, _lidx, &p->cp_EDT_r15);
	_serSysEncSQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional(_buffer, _size, _lidx, &p->up_EDT_r15);
	_serSysEncSQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional(_buffer, _size, _lidx, &p->idleModeMeasurements_r15);
	_serSysEncSQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional(_buffer, _size, _lidx, &p->reducedCP_LatencyEnabled_r15);
	_serSysEncSQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional(_buffer, _size, _lidx, &p->mbms_ROM_ServiceIndication_r15);
	_serSysEncSQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional(_buffer, _size, _lidx, &p->rlos_Enabled_r16);
	_serSysEncSQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional(_buffer, _size, _lidx, &p->earlySecurityReactivation_r16);
	_serSysEncSQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional(_buffer, _size, _lidx, &p->cp_EDT_5GC_r16);
	_serSysEncSQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional(_buffer, _size, _lidx, &p->up_EDT_5GC_r16);
	_serSysEncSQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional(_buffer, _size, _lidx, &p->cp_PUR_EPC_r16);
	_serSysEncSQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional(_buffer, _size, _lidx, &p->up_PUR_EPC_r16);
	_serSysEncSQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional(_buffer, _size, _lidx, &p->cp_PUR_5GC_r16);
	_serSysEncSQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional(_buffer, _size, _lidx, &p->up_PUR_5GC_r16);
	_serSysEncSQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional(_buffer, _size, _lidx, &p->mpdcch_CQI_Reporting_r16);
	_serSysEncSQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional(_buffer, _size, _lidx, &p->rai_ActivationEnh_r16);
	_serSysEncSQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional(_buffer, _size, _lidx, &p->idleModeMeasurementsNR_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MobilityStateParameters(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MobilityStateParameters* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->t_Evaluation;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->t_HystNormal;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->n_CellChangeMedium, _lidx);
	HTON_8(&_buffer[*_lidx], p->n_CellChangeHigh, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sf_Medium;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->sf_High;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MobilityStateParameters(_buffer, _size, _lidx, &p->mobilityStateParameters);
	_serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF(_buffer, _size, _lidx, &p->q_HystSF);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->q_Hyst;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional(_buffer, _size, _lidx, &p->speedStateReselectionPars);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_cellReselectionServingFreqInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional(_buffer, _size, _lidx, &p->s_NonIntraSearch);
	HTON_8(&_buffer[*_lidx], p->threshServingLow, _lidx);
	HTON_8(&_buffer[*_lidx], p->cellReselectionPriority, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sf_Medium;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->sf_High;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_intraFreqCellReselectionInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	_serSysEncSQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	_serSysEncSQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional(_buffer, _size, _lidx, &p->s_IntraSearch);
	_serSysEncSQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional(_buffer, _size, _lidx, &p->allowedMeasBandwidth);
	HTON_8(&_buffer[*_lidx], p->presenceAntennaPort1, _lidx);
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->neighCellConfig[i2], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->t_ReselectionEUTRA, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionEUTRA_SF);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_s_IntraSearch_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_s_IntraSearch_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->s_IntraSearchP_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->s_IntraSearchQ_r9, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType3_s_IntraSearch_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_s_NonIntraSearch_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->s_NonIntraSearchP_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->s_NonIntraSearchQ_r9, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType3_s_NonIntraSearch_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionServingFreqInfo_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionServingFreqInfo_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->cellReselectionSubPriority_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionServingFreqInfo_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionServingInfo_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionServingInfo_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->redistributionFactorServing_r13, _lidx);
	_serSysEncSQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional(_buffer, _size, _lidx, &p->redistributionFactorCell_r13);
	{
		size_t _tmp = (size_t)p->t360_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional(_buffer, _size, _lidx, &p->redistrOnPagingOnly_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RedistributionServingInfo_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMinCE_r13, _lidx);
	_serSysEncSQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional(_buffer, _size, _lidx, &p->q_QualMinRSRQ_CE_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMinCE1_r13, _lidx);
	_serSysEncSQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional(_buffer, _size, _lidx, &p->q_QualMinRSRQ_CE1_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE1_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_v1360(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_v1360* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->delta_RxLevMinCE1_v1360, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE1_v1360(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionInfoCommon_v1460(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionInfoCommon_v1460* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->s_SearchDeltaP_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionInfoCommon_v1460(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionInfoHSDN_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionInfoHSDN_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->cellEquivalentSize_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionInfoHSDN_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->powerClass14dBm_Offset_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionServingFreqInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionServingFreqInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional(_buffer, _size, _lidx, &p->altCellReselectionPriority_r16);
	_serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(_buffer, _size, _lidx, &p->altCellReselectionSubPriority_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionServingFreqInfo_v1610(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType3(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType3* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType3_cellReselectionInfoCommon(_buffer, _size, _lidx, &p->cellReselectionInfoCommon);
	_serSysEncSQN_SystemInformationBlockType3_cellReselectionServingFreqInfo(_buffer, _size, _lidx, &p->cellReselectionServingFreqInfo);
	_serSysEncSQN_SystemInformationBlockType3_intraFreqCellReselectionInfo(_buffer, _size, _lidx, &p->intraFreqCellReselectionInfo);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional(_buffer, _size, _lidx, &p->s_IntraSearch_v920);
	_serSysEncSQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional(_buffer, _size, _lidx, &p->s_NonIntraSearch_v920);
	_serSysEncSQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional(_buffer, _size, _lidx, &p->q_QualMin_r9);
	_serSysEncSQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional(_buffer, _size, _lidx, &p->threshServingLowQ_r9);
	_serSysEncSQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional(_buffer, _size, _lidx, &p->q_QualMinWB_r11);
	_serSysEncSQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional(_buffer, _size, _lidx, &p->q_QualMinRSRQ_OnAllSymbols_r12);
	_serSysEncSQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional(_buffer, _size, _lidx, &p->cellReselectionServingFreqInfo_v1310);
	_serSysEncSQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional(_buffer, _size, _lidx, &p->redistributionServingInfo_r13);
	_serSysEncSQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE_r13);
	_serSysEncSQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional(_buffer, _size, _lidx, &p->t_ReselectionEUTRA_CE_r13);
	_serSysEncSQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE1_r13);
	_serSysEncSQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE1_v1360);
	_serSysEncSQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional(_buffer, _size, _lidx, &p->cellReselectionInfoCommon_v1460);
	_serSysEncSQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional(_buffer, _size, _lidx, &p->cellReselectionInfoHSDN_r15);
	_serSysEncSQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE_v1530);
	_serSysEncSQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional(_buffer, _size, _lidx, &p->crs_IntfMitigNeighCellsCE_r15);
	_serSysEncSQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional(_buffer, _size, _lidx, &p->cellReselectionServingFreqInfo_v1610);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_IntraFreqNeighCellInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_IntraFreqNeighCellInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physCellId, _lidx);
	{
		size_t _tmp = (size_t)p->q_OffsetCell;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_IntraFreqNeighCellInfo(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PhysCellIdRange_range_e_range_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PhysCellIdRange_range_e_range_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PhysCellIdRange(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PhysCellIdRange* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->start, _lidx);
	_serSysEncSQN_PhysCellIdRange_range_e_range_Optional(_buffer, _size, _lidx, &p->range);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSS_ConfigCarrierInfo_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSS_ConfigCarrierInfo_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->narrowbandIndex_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->narrowbandIndex_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->narrowbandIndex_r16.v[i2], _lidx);
	}
	{
		size_t _tmp = (size_t)p->timeOffsetGranularity_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RSS_ConfigCarrierInfo_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_IntraFreqNeighCellInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_IntraFreqNeighCellInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->rss_MeasPowerBias_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_IntraFreqNeighCellInfo_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType4(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType4* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional(_buffer, _size, _lidx, &p->intraFreqNeighCellList);
	_serSysEncSQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional(_buffer, _size, _lidx, &p->intraFreqBlackCellList);
	_serSysEncSQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional(_buffer, _size, _lidx, &p->csg_PhysCellIdRange);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional(_buffer, _size, _lidx, &p->intraFreqNeighHSDN_CellList_r15);
	_serSysEncSQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional(_buffer, _size, _lidx, &p->rss_ConfigCarrierInfo_r16);
	_serSysEncSQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional(_buffer, _size, _lidx, &p->intraFreqNeighCellList_v1610);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqNeighCellInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqNeighCellInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physCellId, _lidx);
	{
		size_t _tmp = (size_t)p->q_OffsetCell;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_InterFreqNeighCellInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_threshX_Q_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshX_HighQ_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowQ_r9, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_InterFreqCarrierFreqInfo_threshX_Q_r9(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->dl_CarrierFreq, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	_serSysEncSQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionEUTRA, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionEUTRA_SF);
	HTON_8(&_buffer[*_lidx], p->threshX_High, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low, _lidx);
	{
		size_t _tmp = (size_t)p->allowedMeasBandwidth;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->presenceAntennaPort1, _lidx);
	_serSysEncSQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority);
	for (size_t i3 = 0; i3 < 2; i3++) {
		HTON_8(&_buffer[*_lidx], p->neighCellConfig[i3], _lidx);
	}
	_serSysEncSQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional(_buffer, _size, _lidx, &p->q_OffsetFreq);
	_serSysEncSQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional(_buffer, _size, _lidx, &p->interFreqNeighCellList);
	_serSysEncSQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional(_buffer, _size, _lidx, &p->interFreqBlackCellList);
	_serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional(_buffer, _size, _lidx, &p->q_QualMin_r9);
	_serSysEncSQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional(_buffer, _size, _lidx, &p->threshX_Q_r9);
	_serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional(_buffer, _size, _lidx, &p->q_QualMinWB_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v1250(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v1250* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_buffer, _size, _lidx, &p->reducedMeasPerformance_r12);
	_serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional(_buffer, _size, _lidx, &p->q_QualMinRSRQ_OnAllSymbols_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1250(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_InterFreqNeighCellInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshX_HighQ_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowQ_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->dl_CarrierFreq_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin_r12, _lidx);
	_serSysEncSQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional(_buffer, _size, _lidx, &p->p_Max_r12);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionEUTRA_r12, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional(_buffer, _size, _lidx, &p->t_ReselectionEUTRA_SF_r12);
	HTON_8(&_buffer[*_lidx], p->threshX_High_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low_r12, _lidx);
	{
		size_t _tmp = (size_t)p->allowedMeasBandwidth_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->presenceAntennaPort1_r12, _lidx);
	_serSysEncSQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority_r12);
	for (size_t i3 = 0; i3 < 2; i3++) {
		HTON_8(&_buffer[*_lidx], p->neighCellConfig_r12[i3], _lidx);
	}
	_serSysEncSQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional(_buffer, _size, _lidx, &p->q_OffsetFreq_r12);
	_serSysEncSQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional(_buffer, _size, _lidx, &p->interFreqNeighCellList_r12);
	_serSysEncSQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional(_buffer, _size, _lidx, &p->interFreqBlackCellList_r12);
	_serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional(_buffer, _size, _lidx, &p->q_QualMin_r12);
	_serSysEncSQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional(_buffer, _size, _lidx, &p->threshX_Q_r12);
	_serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional(_buffer, _size, _lidx, &p->q_QualMinWB_r12);
	_serSysEncSQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional(_buffer, _size, _lidx, &p->multiBandInfoList_r12);
	_serSysEncSQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_buffer, _size, _lidx, &p->reducedMeasPerformance_r12);
	_serSysEncSQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional(_buffer, _size, _lidx, &p->q_QualMinRSRQ_OnAllSymbols_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NS_PmaxValue_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NS_PmaxValue_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional(_buffer, _size, _lidx, &p->additionalPmax_r10);
	HTON_8(&_buffer[*_lidx], p->additionalSpectrumEmission, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_NS_PmaxValue_r10(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i3].d, _lidx);
		for (size_t i4 = 0; i4 < p->v.v[i3].d; i4++) {
			_serSysEncSQN_NS_PmaxValue_r10(_buffer, _size, _lidx, &p->v.v[i3].v[i4]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v10j0(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v10j0* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional(_buffer, _size, _lidx, &p->freqBandInfo_r10);
	_serSysEncSQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional(_buffer, _size, _lidx, &p->multiBandInfoList_v10j0);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v10j0(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionNeighCell_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionNeighCell_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physCellId_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->redistributionFactorCell_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_RedistributionNeighCell_r13(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionInterFreqInfo_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionInterFreqInfo_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional(_buffer, _size, _lidx, &p->redistributionFactorFreq_r13);
	_serSysEncSQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional(_buffer, _size, _lidx, &p->redistributionNeighCellList_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RedistributionInterFreqInfo_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional(_buffer, _size, _lidx, &p->cellReselectionSubPriority_r13);
	_serSysEncSQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional(_buffer, _size, _lidx, &p->redistributionInterFreqInfo_r13);
	_serSysEncSQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE_r13);
	_serSysEncSQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional(_buffer, _size, _lidx, &p->t_ReselectionEUTRA_CE_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1310(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1310(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE1_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v1350(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v1350* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE1_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1350(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1350(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE1_v1360(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v1360(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v1360* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE1_v1360);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1360(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->hsdn_Indication_r15, _lidx);
	_serSysEncSQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional(_buffer, _size, _lidx, &p->interFreqNeighHSDN_CellList_r15);
	_serSysEncSQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE_v1530);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1530(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1530(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PhysCellIdRange(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional(_buffer, _size, _lidx, &p->idleRSRP_Threshold_r15);
	_serSysEncSQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional(_buffer, _size, _lidx, &p->idleRSRQ_Threshold_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierEUTRA_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierEUTRA_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreq_r15, _lidx);
	{
		size_t _tmp = (size_t)p->allowedMeasBandwidth_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional(_buffer, _size, _lidx, &p->validityArea_r15);
	_serSysEncSQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional(_buffer, _size, _lidx, &p->measCellList_r15);
	{
		size_t _tmp = (size_t)p->reportQuantities;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional(_buffer, _size, _lidx, &p->qualityThreshold_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleConfigSIB_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleConfigSIB_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->measIdleCarrierListEUTRA_r15.d, _lidx);
	for (size_t i2 = 0; i2 < p->measIdleCarrierListEUTRA_r15.d; i2++) {
		_serSysEncSQN_MeasIdleCarrierEUTRA_r15(_buffer, _size, _lidx, &p->measIdleCarrierListEUTRA_r15.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MeasIdleConfigSIB_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_RSS_ConfigCarrierInfo_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqNeighCellInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqNeighCellInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->rss_MeasPowerBias_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_InterFreqNeighCellInfo_v1610(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional(_buffer, _size, _lidx, &p->altCellReselectionPriority_r16);
	_serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional(_buffer, _size, _lidx, &p->altCellReselectionSubPriority_r16);
	_serSysEncSQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional(_buffer, _size, _lidx, &p->rss_ConfigCarrierInfo_r16);
	_serSysEncSQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional(_buffer, _size, _lidx, &p->interFreqNeighCellList_v1610);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PhysCellIdRangeNR_r16_range_e_range_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PhysCellIdRangeNR_r16_range_e_range_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PhysCellIdRangeNR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PhysCellIdRangeNR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->start, _lidx);
	_serSysEncSQN_PhysCellIdRangeNR_r16_range_e_range_Optional(_buffer, _size, _lidx, &p->range);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PhysCellIdRangeNR_r16(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional(_buffer, _size, _lidx, &p->idleRSRP_ThresholdNR_r16);
	_serSysEncSQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional(_buffer, _size, _lidx, &p->idleRSRQ_ThresholdNR_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ThresholdListNR_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ThresholdListNR_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional(_buffer, _size, _lidx, &p->nr_RSRP_r15);
	_serSysEncSQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional(_buffer, _size, _lidx, &p->nr_RSRQ_r15);
	_serSysEncSQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional(_buffer, _size, _lidx, &p->nr_SINR_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ThresholdListNR_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value* p, enum SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf5_r15) {
		HTON_8(&_buffer[*_lidx], p->sf5_r15, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf10_r15) {
		HTON_8(&_buffer[*_lidx], p->sf10_r15, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf20_r15) {
		HTON_8(&_buffer[*_lidx], p->sf20_r15, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf40_r15) {
		HTON_8(&_buffer[*_lidx], p->sf40_r15, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf80_r15) {
		HTON_8(&_buffer[*_lidx], p->sf80_r15, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf160_r15) {
		HTON_8(&_buffer[*_lidx], p->sf160_r15, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_MTC_SSB_NR_r15_periodicityAndOffset_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MTC_SSB_NR_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MTC_SSB_NR_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MTC_SSB_NR_r15_periodicityAndOffset_r15(_buffer, _size, _lidx, &p->periodicityAndOffset_r15);
	{
		size_t _tmp = (size_t)p->ssb_Duration_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MTC_SSB_NR_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SSB_ToMeasure_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SSB_ToMeasure_r15_Value* p, enum SQN_SSB_ToMeasure_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SSB_ToMeasure_r15_shortBitmap_r15) {
		for (size_t i3 = 0; i3 < 4; i3++) {
			HTON_8(&_buffer[*_lidx], p->shortBitmap_r15[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SSB_ToMeasure_r15_mediumBitmap_r15) {
		for (size_t i3 = 0; i3 < 8; i3++) {
			HTON_8(&_buffer[*_lidx], p->mediumBitmap_r15[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SSB_ToMeasure_r15_longBitmap_r15) {
		for (size_t i3 = 0; i3 < 64; i3++) {
			HTON_8(&_buffer[*_lidx], p->longBitmap_r15[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SSB_ToMeasure_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SSB_ToMeasure_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SSB_ToMeasure_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SSB_ToMeasure_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SS_RSSI_Measurement_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SS_RSSI_Measurement_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->measurementSlots_r15.d, _lidx);
	for (size_t i3 = 0; i3 < p->measurementSlots_r15.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->measurementSlots_r15.v[i3], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->endSymbol_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SS_RSSI_Measurement_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional(_buffer, _size, _lidx, &p->maxRS_IndexCellQual_r16);
	_serSysEncSQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional(_buffer, _size, _lidx, &p->threshRS_Index_r16);
	_serSysEncSQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional(_buffer, _size, _lidx, &p->measTimingConfig_r16);
	_serSysEncSQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional(_buffer, _size, _lidx, &p->ssb_ToMeasure_r16);
	HTON_8(&_buffer[*_lidx], p->deriveSSB_IndexFromCell_r16, _lidx);
	_serSysEncSQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional(_buffer, _size, _lidx, &p->ss_RSSI_Measurement_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BeamMeasConfigIdleNR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BeamMeasConfigIdleNR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->reportQuantityRS_IndexNR_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->maxReportRS_Index_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->reportRS_IndexResultsNR_r16, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_BeamMeasConfigIdleNR_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleCarrierNR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleCarrierNR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreqNR_r16, _lidx);
	{
		size_t _tmp = (size_t)p->subcarrierSpacingSSB_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional(_buffer, _size, _lidx, &p->frequencyBandList);
	_serSysEncSQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional(_buffer, _size, _lidx, &p->measCellListNR_r16);
	{
		size_t _tmp = (size_t)p->reportQuantitiesNR_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional(_buffer, _size, _lidx, &p->qualityThresholdNR_r16);
	_serSysEncSQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional(_buffer, _size, _lidx, &p->ssb_MeasConfig_r16);
	_serSysEncSQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional(_buffer, _size, _lidx, &p->beamMeasConfigIdle_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleConfigSIB_NR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleConfigSIB_NR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->measIdleCarrierListNR_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->measIdleCarrierListNR_r16.d; i2++) {
		_serSysEncSQN_MeasIdleCarrierNR_r16(_buffer, _size, _lidx, &p->measIdleCarrierListNR_r16.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MeasIdleConfigSIB_NR_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType5(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType5* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->interFreqCarrierFreqList.d, _lidx);
	for (size_t i2 = 0; i2 < p->interFreqCarrierFreqList.d; i2++) {
		_serSysEncSQN_InterFreqCarrierFreqInfo(_buffer, _size, _lidx, &p->interFreqCarrierFreqList.v[i2]);
	}
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqList_v1250);
	_serSysEncSQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqListExt_r12);
	_serSysEncSQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqListExt_v1280);
	_serSysEncSQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqList_v1310);
	_serSysEncSQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqListExt_v1310);
	_serSysEncSQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqList_v1350);
	_serSysEncSQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqListExt_v1350);
	_serSysEncSQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqListExt_v1360);
	_serSysEncUint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional(_buffer, _size, _lidx, &p->scptm_FreqOffset_r14);
	_serSysEncSQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqList_v1530);
	_serSysEncSQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqListExt_v1530);
	_serSysEncSQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional(_buffer, _size, _lidx, &p->measIdleConfigSIB_r15);
	_serSysEncSQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqList_v1610);
	_serSysEncSQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional(_buffer, _size, _lidx, &p->interFreqCarrierFreqListExt_v1610);
	_serSysEncSQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional(_buffer, _size, _lidx, &p->measIdleConfigSIB_NR_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_FDD_threshX_Q_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshX_HighQ_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowQ_r9, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CarrierFreqUTRA_FDD_threshX_Q_r9(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_FDD(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_FDD* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->carrierFreq, _lidx);
	_serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority);
	HTON_8(&_buffer[*_lidx], p->threshX_High, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	HTON_8(&_buffer[*_lidx], p->p_MaxUTRA, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_QualMin, _lidx);
	_serSysEncSQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional(_buffer, _size, _lidx, &p->threshX_Q_r9);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqUTRA_FDD(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_TDD(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_TDD* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->carrierFreq, _lidx);
	_serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority);
	HTON_8(&_buffer[*_lidx], p->threshX_High, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	HTON_8(&_buffer[*_lidx], p->p_MaxUTRA, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqUTRA_TDD(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqInfoUTRA_v1250(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqInfoUTRA_v1250* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_buffer, _size, _lidx, &p->reducedMeasPerformance_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqInfoUTRA_v1250(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqInfoUTRA_v1250(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshX_HighQ_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowQ_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_FDD_Ext_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->carrierFreq_r12, _lidx);
	_serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority_r12);
	HTON_8(&_buffer[*_lidx], p->threshX_High_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->p_MaxUTRA_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_QualMin_r12, _lidx);
	_serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional(_buffer, _size, _lidx, &p->threshX_Q_r12);
	_serSysEncSQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional(_buffer, _size, _lidx, &p->multiBandInfoList_r12);
	_serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_buffer, _size, _lidx, &p->reducedMeasPerformance_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqUTRA_FDD_Ext_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqUTRA_TDD_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqUTRA_TDD_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->carrierFreq_r12, _lidx);
	_serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority_r12);
	HTON_8(&_buffer[*_lidx], p->threshX_High_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->p_MaxUTRA_r12, _lidx);
	_serSysEncSQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional(_buffer, _size, _lidx, &p->reducedMeasPerformance_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqUTRA_TDD_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType6(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType6* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional(_buffer, _size, _lidx, &p->carrierFreqListUTRA_FDD);
	_serSysEncSQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional(_buffer, _size, _lidx, &p->carrierFreqListUTRA_TDD);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionUTRA, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionUTRA_SF);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional(_buffer, _size, _lidx, &p->carrierFreqListUTRA_FDD_v1250);
	_serSysEncSQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional(_buffer, _size, _lidx, &p->carrierFreqListUTRA_TDD_v1250);
	_serSysEncSQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional(_buffer, _size, _lidx, &p->carrierFreqListUTRA_FDD_Ext_r12);
	_serSysEncSQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional(_buffer, _size, _lidx, &p->carrierFreqListUTRA_TDD_Ext_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->arfcn_Spacing, _lidx);
	HTON_8(&_buffer[*_lidx], p->numberOfFollowingARFCNs, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqsGERAN_followingARFCNs_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CarrierFreqsGERAN_followingARFCNs_Value* p, enum SQN_CarrierFreqsGERAN_followingARFCNs_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CarrierFreqsGERAN_followingARFCNs_explicitListOfARFCNs) {
		HTON_32(&_buffer[*_lidx], p->explicitListOfARFCNs.d, _lidx);
		for (size_t i3 = 0; i3 < p->explicitListOfARFCNs.d; i3++) {
			HTON_16(&_buffer[*_lidx], p->explicitListOfARFCNs.v[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs) {
		_serSysEncSQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs(_buffer, _size, _lidx, &p->equallySpacedARFCNs);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CarrierFreqsGERAN_followingARFCNs_variableBitMapOfARFCNs) {
		HTON_32(&_buffer[*_lidx], p->variableBitMapOfARFCNs.d, _lidx);
		for (size_t i3 = 0; i3 < p->variableBitMapOfARFCNs.d; i3++) {
			HTON_8(&_buffer[*_lidx], p->variableBitMapOfARFCNs.v[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CarrierFreqsGERAN_followingARFCNs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqsGERAN_followingARFCNs* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CarrierFreqsGERAN_followingARFCNs_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqsGERAN(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqsGERAN* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->startingARFCN, _lidx);
	{
		size_t _tmp = (size_t)p->bandIndicator;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CarrierFreqsGERAN_followingARFCNs(_buffer, _size, _lidx, &p->followingARFCNs);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqsInfoGERAN_commonInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqsInfoGERAN_commonInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority);
	for (size_t i3 = 0; i3 < 8; i3++) {
		HTON_8(&_buffer[*_lidx], p->ncc_Permitted[i3], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	_serSysEncUint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional(_buffer, _size, _lidx, &p->p_MaxGERAN);
	HTON_8(&_buffer[*_lidx], p->threshX_High, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqsInfoGERAN(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqsInfoGERAN* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CarrierFreqsGERAN(_buffer, _size, _lidx, &p->carrierFreqs);
	_serSysEncSQN_CarrierFreqsInfoGERAN_commonInfo(_buffer, _size, _lidx, &p->commonInfo);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqsInfoGERAN(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType7(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType7* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->t_ReselectionGERAN, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionGERAN_SF);
	_serSysEncSQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional(_buffer, _size, _lidx, &p->carrierFreqsInfoList);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value* p, enum SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_synchronousSystemTime) {
		for (size_t i2 = 0; i2 < 39; i2++) {
			HTON_8(&_buffer[*_lidx], p->synchronousSystemTime[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_asynchronousSystemTime) {
		for (size_t i2 = 0; i2 < 49; i2++) {
			HTON_8(&_buffer[*_lidx], p->asynchronousSystemTime[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemTimeInfoCDMA2000_cdma_SystemTime(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemTimeInfoCDMA2000_cdma_SystemTime* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemTimeInfoCDMA2000(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemTimeInfoCDMA2000* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->cdma_EUTRA_Synchronisation, _lidx);
	_serSysEncSQN_SystemTimeInfoCDMA2000_cdma_SystemTime(_buffer, _size, _lidx, &p->cdma_SystemTime);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemTimeInfoCDMA2000(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PreRegistrationInfoHRPD(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PreRegistrationInfoHRPD* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->preRegistrationAllowed, _lidx);
	_serSysEncSQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional(_buffer, _size, _lidx, &p->preRegistrationZoneId);
	_serSysEncSQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional(_buffer, _size, _lidx, &p->secondaryPreRegistrationZoneIdList);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BandClassInfoCDMA2000(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BandClassInfoCDMA2000* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->bandClass;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority);
	HTON_8(&_buffer[*_lidx], p->threshX_High, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NeighCellsPerBandclassCDMA2000(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NeighCellsPerBandclassCDMA2000* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->arfcn, _lidx);
	HTON_32(&_buffer[*_lidx], p->physCellIdList.d, _lidx);
	for (size_t i4 = 0; i4 < p->physCellIdList.d; i4++) {
		HTON_16(&_buffer[*_lidx], p->physCellIdList.v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NeighCellCDMA2000(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NeighCellCDMA2000* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->bandClass;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->neighCellsPerFreqList.d, _lidx);
	for (size_t i3 = 0; i3 < p->neighCellsPerFreqList.d; i3++) {
		_serSysEncSQN_NeighCellsPerBandclassCDMA2000(_buffer, _size, _lidx, &p->neighCellsPerFreqList.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->bandClassList.d, _lidx);
	for (size_t i2 = 0; i2 < p->bandClassList.d; i2++) {
		_serSysEncSQN_BandClassInfoCDMA2000(_buffer, _size, _lidx, &p->bandClassList.v[i2]);
	}
	HTON_32(&_buffer[*_lidx], p->neighCellList.d, _lidx);
	for (size_t i2 = 0; i2 < p->neighCellList.d; i2++) {
		_serSysEncSQN_NeighCellCDMA2000(_buffer, _size, _lidx, &p->neighCellList.v[i2]);
	}
	HTON_8(&_buffer[*_lidx], p->t_ReselectionCDMA2000, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionCDMA2000_SF);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionParametersCDMA2000(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType8_parametersHRPD(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType8_parametersHRPD* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PreRegistrationInfoHRPD(_buffer, _size, _lidx, &p->preRegistrationInfoHRPD);
	_serSysEncSQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional(_buffer, _size, _lidx, &p->cellReselectionParametersHRPD);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType8_parametersHRPD(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSFB_RegistrationParam1XRTT(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSFB_RegistrationParam1XRTT* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 15; i2++) {
		HTON_8(&_buffer[*_lidx], p->sid[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->nid[i2], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->multipleSID, _lidx);
	HTON_8(&_buffer[*_lidx], p->multipleNID, _lidx);
	HTON_8(&_buffer[*_lidx], p->homeReg, _lidx);
	HTON_8(&_buffer[*_lidx], p->foreignSIDReg, _lidx);
	HTON_8(&_buffer[*_lidx], p->foreignNIDReg, _lidx);
	HTON_8(&_buffer[*_lidx], p->parameterReg, _lidx);
	HTON_8(&_buffer[*_lidx], p->powerUpReg, _lidx);
	for (size_t i2 = 0; i2 < 7; i2++) {
		HTON_8(&_buffer[*_lidx], p->registrationPeriod[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 12; i2++) {
		HTON_8(&_buffer[*_lidx], p->registrationZone[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 3; i2++) {
		HTON_8(&_buffer[*_lidx], p->totalZone[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 3; i2++) {
		HTON_8(&_buffer[*_lidx], p->zoneTimer[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSFB_RegistrationParam1XRTT(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncB42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 42; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionParametersCDMA2000(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType8_parameters1XRTT(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType8_parameters1XRTT* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional(_buffer, _size, _lidx, &p->csfb_RegistrationParam1XRTT);
	_serSysEncB42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional(_buffer, _size, _lidx, &p->longCodeState1XRTT);
	_serSysEncSQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional(_buffer, _size, _lidx, &p->cellReselectionParameters1XRTT);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType8_parameters1XRTT(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NeighCellsPerBandclassCDMA2000_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NeighCellsPerBandclassCDMA2000_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->physCellIdList_v920.d, _lidx);
	for (size_t i4 = 0; i4 < p->physCellIdList_v920.d; i4++) {
		HTON_16(&_buffer[*_lidx], p->physCellIdList_v920.v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NeighCellCDMA2000_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NeighCellCDMA2000_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->neighCellsPerFreqList_v920.d, _lidx);
	for (size_t i3 = 0; i3 < p->neighCellsPerFreqList_v920.d; i3++) {
		_serSysEncSQN_NeighCellsPerBandclassCDMA2000_v920(_buffer, _size, _lidx, &p->neighCellsPerFreqList_v920.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->neighCellList_v920.d, _lidx);
	for (size_t i2 = 0; i2 < p->neighCellList_v920.d; i2++) {
		_serSysEncSQN_NeighCellCDMA2000_v920(_buffer, _size, _lidx, &p->neighCellList_v920.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionParametersCDMA2000_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionParametersCDMA2000_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSFB_RegistrationParam1XRTT_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSFB_RegistrationParam1XRTT_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->powerDownReg_r9;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSFB_RegistrationParam1XRTT_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig1XRTT_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig1XRTT_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->ac_Barring0to9_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_Barring10_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_Barring11_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_Barring12_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_Barring13_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_Barring14_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_Barring15_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_BarringMsg_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_BarringReg_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->ac_BarringEmg_r9, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig1XRTT_r9(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value* p, enum SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_explicitValue) {
		_serSysEncSQN_SystemTimeInfoCDMA2000(_buffer, _size, _lidx, &p->explicitValue);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_defaultValue) {
		HTON_8(&_buffer[*_lidx], p->defaultValue, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_systemTimeInfo_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ParametersCDMA2000_r11_systemTimeInfo_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NeighCellsPerBandclassCDMA2000_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NeighCellsPerBandclassCDMA2000_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->arfcn, _lidx);
	HTON_32(&_buffer[*_lidx], p->physCellIdList_r11.d, _lidx);
	for (size_t i5 = 0; i5 < p->physCellIdList_r11.d; i5++) {
		HTON_16(&_buffer[*_lidx], p->physCellIdList_r11.v[i5], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NeighCellCDMA2000_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NeighCellCDMA2000_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->bandClass;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->neighFreqInfoList_r11.d, _lidx);
	for (size_t i4 = 0; i4 < p->neighFreqInfoList_r11.d; i4++) {
		_serSysEncSQN_NeighCellsPerBandclassCDMA2000_r11(_buffer, _size, _lidx, &p->neighFreqInfoList_r11.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->bandClassList.d, _lidx);
	for (size_t i3 = 0; i3 < p->bandClassList.d; i3++) {
		_serSysEncSQN_BandClassInfoCDMA2000(_buffer, _size, _lidx, &p->bandClassList.v[i3]);
	}
	HTON_32(&_buffer[*_lidx], p->neighCellList_r11.d, _lidx);
	for (size_t i3 = 0; i3 < p->neighCellList_r11.d; i3++) {
		_serSysEncSQN_NeighCellCDMA2000_r11(_buffer, _size, _lidx, &p->neighCellList_r11.v[i3]);
	}
	HTON_8(&_buffer[*_lidx], p->t_ReselectionCDMA2000, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional(_buffer, _size, _lidx, &p->t_ReselectionCDMA2000_SF);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionParametersCDMA2000_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_parametersHRPD_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PreRegistrationInfoHRPD(_buffer, _size, _lidx, &p->preRegistrationInfoHRPD_r11);
	_serSysEncSQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional(_buffer, _size, _lidx, &p->cellReselectionParametersHRPD_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ParametersCDMA2000_r11_parametersHRPD_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSFB_RegistrationParam1XRTT(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSFB_RegistrationParam1XRTT_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncB42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i3 = 0; i3 < 42; i3++) {
		HTON_8(&_buffer[*_lidx], p->v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellReselectionParametersCDMA2000_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_AC_BarringConfig1XRTT_r9(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncBool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_parameters1XRTT_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional(_buffer, _size, _lidx, &p->csfb_RegistrationParam1XRTT_r11);
	_serSysEncSQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional(_buffer, _size, _lidx, &p->csfb_RegistrationParam1XRTT_Ext_r11);
	_serSysEncB42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional(_buffer, _size, _lidx, &p->longCodeState1XRTT_r11);
	_serSysEncSQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional(_buffer, _size, _lidx, &p->cellReselectionParameters1XRTT_r11);
	_serSysEncSQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional(_buffer, _size, _lidx, &p->ac_BarringConfig1XRTT_r11);
	_serSysEncBool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional(_buffer, _size, _lidx, &p->csfb_SupportForDualRxUEs_r11);
	_serSysEncSQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional(_buffer, _size, _lidx, &p->csfb_DualRxTxSupport_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ParametersCDMA2000_r11_parameters1XRTT_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ParametersCDMA2000_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ParametersCDMA2000_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional(_buffer, _size, _lidx, &p->systemTimeInfo_r11);
	HTON_8(&_buffer[*_lidx], p->searchWindowSize_r11, _lidx);
	_serSysEncSQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional(_buffer, _size, _lidx, &p->parametersHRPD_r11);
	_serSysEncSQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional(_buffer, _size, _lidx, &p->parameters1XRTT_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value* p, enum SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_explicitValue) {
		_serSysEncSQN_ParametersCDMA2000_r11(_buffer, _size, _lidx, &p->explicitValue);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_defaultValue) {
		HTON_8(&_buffer[*_lidx], p->defaultValue, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SIB8_PerPLMN_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SIB8_PerPLMN_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_Identity_r11, _lidx);
	_serSysEncSQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11(_buffer, _size, _lidx, &p->parametersCDMA2000_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SIB8_PerPLMN_r11(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType8(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType8* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional(_buffer, _size, _lidx, &p->systemTimeInfo);
	_serSysEncUint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional(_buffer, _size, _lidx, &p->searchWindowSize);
	_serSysEncSQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional(_buffer, _size, _lidx, &p->parametersHRPD);
	_serSysEncSQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional(_buffer, _size, _lidx, &p->parameters1XRTT);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncBool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional(_buffer, _size, _lidx, &p->csfb_SupportForDualRxUEs_r9);
	_serSysEncSQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional(_buffer, _size, _lidx, &p->cellReselectionParametersHRPD_v920);
	_serSysEncSQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional(_buffer, _size, _lidx, &p->cellReselectionParameters1XRTT_v920);
	_serSysEncSQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional(_buffer, _size, _lidx, &p->csfb_RegistrationParam1XRTT_v920);
	_serSysEncSQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional(_buffer, _size, _lidx, &p->ac_BarringConfig1XRTT_r9);
	_serSysEncSQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional(_buffer, _size, _lidx, &p->csfb_DualRxTxSupport_r10);
	_serSysEncSQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional(_buffer, _size, _lidx, &p->sib8_PerPLMN_List_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType9* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional(_buffer, _size, _lidx, &p->hnb_Name);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncO50_SQN_SystemInformationBlockType10_dummy_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O50_SQN_SystemInformationBlockType10_dummy_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 50; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType10* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->messageIdentifier[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->serialNumber[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->warningType[i2], _lidx);
	}
	_serSysEncO50_SQN_SystemInformationBlockType10_dummy_Optional(_buffer, _size, _lidx, &p->dummy);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncO1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 1; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType11* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->messageIdentifier[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->serialNumber[i2], _lidx);
	}
	{
		size_t _tmp = (size_t)p->warningMessageSegmentType;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->warningMessageSegmentNumber, _lidx);
	HTON_32(&_buffer[*_lidx], p->warningMessageSegment.d, _lidx);
	for (size_t i2 = 0; i2 < p->warningMessageSegment.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->warningMessageSegment.v[i2], _lidx);
	}
	_serSysEncO1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional(_buffer, _size, _lidx, &p->dataCodingScheme);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncO1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 1; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType12_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType12_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->messageIdentifier_r9[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->serialNumber_r9[i2], _lidx);
	}
	{
		size_t _tmp = (size_t)p->warningMessageSegmentType_r9;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->warningMessageSegmentNumber_r9, _lidx);
	HTON_32(&_buffer[*_lidx], p->warningMessageSegment_r9.d, _lidx);
	for (size_t i2 = 0; i2 < p->warningMessageSegment_r9.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->warningMessageSegment_r9.v[i2], _lidx);
	}
	_serSysEncO1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional(_buffer, _size, _lidx, &p->dataCodingScheme_r9);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional(_buffer, _size, _lidx, &p->warningAreaCoordinatesSegment_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->mcch_RepetitionPeriod_r9;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->mcch_Offset_r9, _lidx);
	{
		size_t _tmp = (size_t)p->mcch_ModificationPeriod_r9;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	for (size_t i3 = 0; i3 < 6; i3++) {
		HTON_8(&_buffer[*_lidx], p->sf_AllocInfo_r9[i3], _lidx);
	}
	{
		size_t _tmp = (size_t)p->signallingMCS_r9;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional(_buffer, _size, _lidx, &p->mcch_RepetitionPeriod_v1430);
	_serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional(_buffer, _size, _lidx, &p->mcch_ModificationPeriod_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->mbsfn_AreaId_r9, _lidx);
	{
		size_t _tmp = (size_t)p->non_MBSFNregionLength;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->notificationIndicator_r9, _lidx);
	_serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r9(_buffer, _size, _lidx, &p->mcch_Config_r9);
	_serSysEncSQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional(_buffer, _size, _lidx, &p->mcch_Config_r14);
	_serSysEncSQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional(_buffer, _size, _lidx, &p->subcarrierSpacingMBMS_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_NotificationConfig_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_NotificationConfig_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->notificationRepetitionCoeff_r9;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->notificationOffset_r9, _lidx);
	HTON_8(&_buffer[*_lidx], p->notificationSF_Index_r9, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_NotificationConfig_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_NotificationConfig_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->notificationSF_Index_v1430, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MBMS_NotificationConfig_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r16_mcch_Config_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r16_mcch_Config_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->mcch_RepetitionPeriod_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->mcch_ModificationPeriod_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->mcch_Offset_r16, _lidx);
	for (size_t i3 = 0; i3 < 10; i3++) {
		HTON_8(&_buffer[*_lidx], p->sf_AllocInfo_r16[i3], _lidx);
	}
	{
		size_t _tmp = (size_t)p->signallingMCS_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfo_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfo_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->mbsfn_AreaId_r16, _lidx);
	HTON_8(&_buffer[*_lidx], p->notificationIndicator_r16, _lidx);
	_serSysEncSQN_MBSFN_AreaInfo_r16_mcch_Config_r16(_buffer, _size, _lidx, &p->mcch_Config_r16);
	{
		size_t _tmp = (size_t)p->subcarrierSpacingMBMS_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional(_buffer, _size, _lidx, &p->timeSeparation_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_MBSFN_AreaInfo_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType13_r9(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType13_r9* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->mbsfn_AreaInfoList_r9.d, _lidx);
	for (size_t i2 = 0; i2 < p->mbsfn_AreaInfoList_r9.d; i2++) {
		_serSysEncSQN_MBSFN_AreaInfo_r9(_buffer, _size, _lidx, &p->mbsfn_AreaInfoList_r9.v[i2]);
	}
	_serSysEncSQN_MBMS_NotificationConfig_r9(_buffer, _size, _lidx, &p->notificationConfig_r9);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional(_buffer, _size, _lidx, &p->notificationConfig_v1430);
	_serSysEncSQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional(_buffer, _size, _lidx, &p->mbsfn_AreaInfoList_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EAB_Config_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EAB_Config_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->eab_Category_r11;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	for (size_t i2 = 0; i2 < 10; i2++) {
		HTON_8(&_buffer[*_lidx], p->eab_BarringBitmap_r11[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_EAB_Config_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_EAB_ConfigPLMN_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_EAB_ConfigPLMN_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional(_buffer, _size, _lidx, &p->eab_Config_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType14_r11_eab_Param_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformationBlockType14_r11_eab_Param_r11_Value* p, enum SQN_SystemInformationBlockType14_r11_eab_Param_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Common_r11) {
		_serSysEncSQN_EAB_Config_r11(_buffer, _size, _lidx, &p->eab_Common_r11);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_PerPLMN_List_r11) {
		HTON_32(&_buffer[*_lidx], p->eab_PerPLMN_List_r11.d, _lidx);
		for (size_t i2 = 0; i2 < p->eab_PerPLMN_List_r11.d; i2++) {
			_serSysEncSQN_EAB_ConfigPLMN_r11(_buffer, _size, _lidx, &p->eab_PerPLMN_List_r11.v[i2]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformationBlockType14_r11_eab_Param_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType14_r11_eab_Param_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType14_r11_eab_Param_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType14_r11_eab_Param_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType14_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType14_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional(_buffer, _size, _lidx, &p->eab_Param_r11);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional(_buffer, _size, _lidx, &p->eab_PerRSRP_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_SAI_InterFreq_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_SAI_InterFreq_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->dl_CarrierFreq_r11, _lidx);
	HTON_32(&_buffer[*_lidx], p->mbms_SAI_List_r11.d, _lidx);
	for (size_t i3 = 0; i3 < p->mbms_SAI_List_r11.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->mbms_SAI_List_r11.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_MBMS_SAI_InterFreq_r11(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_SAI_InterFreq_v1140(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_SAI_InterFreq_v1140* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional(_buffer, _size, _lidx, &p->multiBandInfoList_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_MBMS_SAI_InterFreq_v1140(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_CarrierType_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_CarrierType_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->carrierType_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncUint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional(_buffer, _size, _lidx, &p->frameOffset_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MBMS_CarrierType_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_MBMS_CarrierType_r14(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType15_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType15_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional(_buffer, _size, _lidx, &p->mbms_SAI_IntraFreq_r11);
	_serSysEncSQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional(_buffer, _size, _lidx, &p->mbms_SAI_InterFreqList_r11);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional(_buffer, _size, _lidx, &p->mbms_SAI_InterFreqList_v1140);
	_serSysEncSQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional(_buffer, _size, _lidx, &p->mbms_IntraFreqCarrierType_r14);
	_serSysEncSQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional(_buffer, _size, _lidx, &p->mbms_InterFreqCarrierTypeList_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncB2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 2; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncInt16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncInt8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType16_r11_timeInfo_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType16_r11_timeInfo_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->timeInfoUTC_r11, _lidx);
	_serSysEncB2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional(_buffer, _size, _lidx, &p->dayLightSavingTime_r11);
	_serSysEncInt16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional(_buffer, _size, _lidx, &p->leapSeconds_r11);
	_serSysEncInt8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional(_buffer, _size, _lidx, &p->localTimeOffset_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType16_r11_timeInfo_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ReferenceTime_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ReferenceTime_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->refDays_r15, _lidx);
	HTON_32(&_buffer[*_lidx], p->refSeconds_r15, _lidx);
	HTON_16(&_buffer[*_lidx], p->refMilliSeconds_r15, _lidx);
	HTON_16(&_buffer[*_lidx], p->refQuarterMicroSeconds_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TimeReferenceInfo_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TimeReferenceInfo_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_ReferenceTime_r15(_buffer, _size, _lidx, &p->time_r15);
	_serSysEncUint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional(_buffer, _size, _lidx, &p->uncertainty_r15);
	_serSysEncSQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional(_buffer, _size, _lidx, &p->timeInfoType_r15);
	_serSysEncUint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional(_buffer, _size, _lidx, &p->referenceSFN_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TimeReferenceInfo_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType16_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType16_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional(_buffer, _size, _lidx, &p->timeInfo_r11);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional(_buffer, _size, _lidx, &p->timeReferenceInfo_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->thresholdRSRP_Low_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->thresholdRSRP_High_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_Low_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_High_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_OnAllSymbolsWithWB_Low_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_OnAllSymbolsWithWB_High_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_OnAllSymbolsLow_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_OnAllSymbolsHigh_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_WB_Low_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->thresholdRSRQ_WB_High_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->thresholdChannelUtilizationLow_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->thresholdChannelUtilizationHigh_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->thresholdBackhaulDL_BandwidthLow_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->thresholdBackhaulDL_BandwidthHigh_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->thresholdBackhaulUL_BandwidthLow_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->thresholdBackhaulUL_BandwidthHigh_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->thresholdWLAN_RSSI_Low_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->thresholdWLAN_RSSI_High_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncB16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i3 = 0; i3 < 16; i3++) {
		HTON_8(&_buffer[*_lidx], p->v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional(_buffer, _size, _lidx, &p->thresholdRSRP_r12);
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional(_buffer, _size, _lidx, &p->thresholdRSRQ_r12);
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional(_buffer, _size, _lidx, &p->thresholdRSRQ_OnAllSymbolsWithWB_r12);
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional(_buffer, _size, _lidx, &p->thresholdRSRQ_OnAllSymbols_r12);
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional(_buffer, _size, _lidx, &p->thresholdRSRQ_WB_r12);
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional(_buffer, _size, _lidx, &p->thresholdChannelUtilization_r12);
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional(_buffer, _size, _lidx, &p->thresholdBackhaul_Bandwidth_r12);
	_serSysEncSQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional(_buffer, _size, _lidx, &p->thresholdWLAN_RSSI_r12);
	_serSysEncB16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional(_buffer, _size, _lidx, &p->offloadPreferenceIndicator_r12);
	_serSysEncSQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional(_buffer, _size, _lidx, &p->t_SteeringWLAN_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_WLAN_OffloadConfig_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncO6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i4 = 0; i4 < 6; i4++) {
		HTON_8(&_buffer[*_lidx], p->v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncO6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct O6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i4 = 0; i4 < 6; i4++) {
		HTON_8(&_buffer[*_lidx], p->v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_Identifiers_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_Identifiers_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncOCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional(_buffer, _size, _lidx, &p->ssid_r12);
	_serSysEncO6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional(_buffer, _size, _lidx, &p->bssid_r12);
	_serSysEncO6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional(_buffer, _size, _lidx, &p->hessid_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_WLAN_Identifiers_r12(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadInfoPerPLMN_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadInfoPerPLMN_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional(_buffer, _size, _lidx, &p->wlan_OffloadConfigCommon_r12);
	_serSysEncSQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional(_buffer, _size, _lidx, &p->wlan_Id_List_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_WLAN_OffloadInfoPerPLMN_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType17_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType17_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional(_buffer, _size, _lidx, &p->wlan_OffloadInfoPerPLMN_List_r12);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicator_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_OffsetIndicator_r12_Value* p, enum SQN_SL_OffsetIndicator_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_OffsetIndicator_r12_small_r12) {
		HTON_16(&_buffer[*_lidx], p->small_r12, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_OffsetIndicator_r12_large_r12) {
		HTON_16(&_buffer[*_lidx], p->large_r12, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_OffsetIndicator_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicator_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_OffsetIndicator_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SubframeBitmapSL_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SubframeBitmapSL_r12_Value* p, enum SQN_SubframeBitmapSL_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SubframeBitmapSL_r12_bs4_r12) {
		for (size_t i3 = 0; i3 < 4; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs4_r12[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs8_r12) {
		for (size_t i3 = 0; i3 < 8; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs8_r12[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs12_r12) {
		for (size_t i3 = 0; i3 < 12; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs12_r12[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs16_r12) {
		for (size_t i3 = 0; i3 < 16; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs16_r12[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs30_r12) {
		for (size_t i3 = 0; i3 < 30; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs30_r12[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs40_r12) {
		for (size_t i3 = 0; i3 < 40; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs40_r12[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r12_bs42_r12) {
		for (size_t i3 = 0; i3 < 42; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs42_r12[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SubframeBitmapSL_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SubframeBitmapSL_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SubframeBitmapSL_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TF_ResourceConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TF_ResourceConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->prb_Num_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->prb_Start_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->prb_End_r12, _lidx);
	_serSysEncSQN_SL_OffsetIndicator_r12(_buffer, _size, _lidx, &p->offsetIndicator_r12);
	_serSysEncSQN_SubframeBitmapSL_r12(_buffer, _size, _lidx, &p->subframeBitmap_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_HoppingConfigComm_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_HoppingConfigComm_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->hoppingParameter_r12, _lidx);
	{
		size_t _tmp = (size_t)p->numSubbands_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->rb_Offset_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_TF_ResourceConfig_r12(_buffer, _size, _lidx, &p->data_TF_ResourceConfig_r12);
	_serSysEncSQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional(_buffer, _size, _lidx, &p->trpt_Subset_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePool_r12_rxParametersNCell_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional(_buffer, _size, _lidx, &p->tdd_Config_r12);
	HTON_8(&_buffer[*_lidx], p->syncConfigIndex_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommResourcePool_r12_rxParametersNCell_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TxParameters_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TxParameters_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->alpha_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->p0_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePool_r12_txParameters_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePool_r12_txParameters_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_TxParameters_r12(_buffer, _size, _lidx, &p->sc_TxParameters_r12);
	_serSysEncSQN_SL_TxParameters_r12(_buffer, _size, _lidx, &p->dataTxParameters_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommResourcePool_r12_txParameters_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePool_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePool_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sc_CP_Len_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->sc_Period_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_TF_ResourceConfig_r12(_buffer, _size, _lidx, &p->sc_TF_ResourceConfig_r12);
	{
		size_t _tmp = (size_t)p->data_CP_Len_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_HoppingConfigComm_r12(_buffer, _size, _lidx, &p->dataHoppingConfig_r12);
	_serSysEncSQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(_buffer, _size, _lidx, &p->ue_SelectedResourceConfig_r12);
	_serSysEncSQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional(_buffer, _size, _lidx, &p->rxParametersNCell_r12);
	_serSysEncSQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional(_buffer, _size, _lidx, &p->txParameters_r12);
	_serSysEncSQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional(_buffer, _size, _lidx, &p->priorityList_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CommResourcePool_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CommResourcePool_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncB19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i3 = 0; i3 < 19; i3++) {
		HTON_8(&_buffer[*_lidx], p->v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12_txParameters_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12_txParameters_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_TxParameters_r12(_buffer, _size, _lidx, &p->syncTxParameters_r12);
	HTON_8(&_buffer[*_lidx], p->syncTxThreshIC_r12, _lidx);
	_serSysEncB19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional(_buffer, _size, _lidx, &p->syncInfoReserved_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_SyncConfig_r12_txParameters_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12_rxParamsNCell_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->physCellId_r12, _lidx);
	{
		size_t _tmp = (size_t)p->discSyncWindow_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_SyncConfig_r12_rxParamsNCell_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->syncCP_Len_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->syncOffsetIndicator_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->slssid_r12, _lidx);
	_serSysEncSQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional(_buffer, _size, _lidx, &p->txParameters_r12);
	_serSysEncSQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional(_buffer, _size, _lidx, &p->rxParamsNCell_r12);
	_serSysEncSQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(_buffer, _size, _lidx, &p->syncTxPeriodic_r13);
	_serSysEncSQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional(_buffer, _size, _lidx, &p->syncOffsetIndicator_v1430);
	_serSysEncSQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional(_buffer, _size, _lidx, &p->gnss_Sync_r14);
	_serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional(_buffer, _size, _lidx, &p->syncOffsetIndicator2_r14);
	_serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional(_buffer, _size, _lidx, &p->syncOffsetIndicator3_r14);
	_serSysEncSQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(_buffer, _size, _lidx, &p->slss_TxDisabled_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_SyncConfig_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType18_r12_commConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType18_r12_commConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->commRxPool_r12.d, _lidx);
	for (size_t i2 = 0; i2 < p->commRxPool_r12.d; i2++) {
		_serSysEncSQN_SL_CommResourcePool_r12(_buffer, _size, _lidx, &p->commRxPool_r12.v[i2]);
	}
	_serSysEncSQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional(_buffer, _size, _lidx, &p->commTxPoolNormalCommon_r12);
	_serSysEncSQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional(_buffer, _size, _lidx, &p->commTxPoolExceptional_r12);
	_serSysEncSQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional(_buffer, _size, _lidx, &p->commSyncConfig_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType18_r12_commConfig_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CommResourcePool_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType18_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType18_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional(_buffer, _size, _lidx, &p->commConfig_r12);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional(_buffer, _size, _lidx, &p->commTxPoolNormalCommonExt_r13);
	_serSysEncSQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional(_buffer, _size, _lidx, &p->commTxResourceUC_ReqAllowed_r13);
	_serSysEncSQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional(_buffer, _size, _lidx, &p->commTxAllowRelayCommon_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PoolSelectionConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PoolSelectionConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshLow_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshHigh_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value* p, enum SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_rsrpBased_r12) {
		_serSysEncSQN_SL_PoolSelectionConfig_r12(_buffer, _size, _lidx, &p->rsrpBased_r12);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_random_r12) {
		HTON_8(&_buffer[*_lidx], p->random_r12, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12(_buffer, _size, _lidx, &p->poolSelection_r12);
	{
		size_t _tmp = (size_t)p->txProbability_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_TxParameters_r12(_buffer, _size, _lidx, &p->txParametersGeneral_r12);
	_serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional(_buffer, _size, _lidx, &p->ue_SelectedResourceConfig_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_rxParameters_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_rxParameters_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional(_buffer, _size, _lidx, &p->tdd_Config_r12);
	HTON_8(&_buffer[*_lidx], p->syncConfigIndex_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscResourcePool_r12_rxParameters_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value* p, enum SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_DiscResourcePool_r12_discPeriod_v1310_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup) {
		{
			size_t _tmp = (size_t)p->setup;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_discPeriod_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscResourcePool_r12_discPeriod_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->physCellId_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->physCellId_r13.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->physCellId_r13.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value* p, enum SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup) {
		_serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config_v1130(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional(_buffer, _size, _lidx, &p->ul_CarrierFreq);
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional(_buffer, _size, _lidx, &p->ul_Bandwidth);
	HTON_8(&_buffer[*_lidx], p->additionalSpectrumEmission, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->physCellId_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->physCellId_r13.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->physCellId_r13.v[i3], _lidx);
	}
	_serSysEncSQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	_serSysEncSQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional(_buffer, _size, _lidx, &p->tdd_Config_r13);
	_serSysEncSQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional(_buffer, _size, _lidx, &p->tdd_Config_v1130);
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo(_buffer, _size, _lidx, &p->freqInfo);
	HTON_8(&_buffer[*_lidx], p->referenceSignalPower, _lidx);
	_serSysEncUint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional(_buffer, _size, _lidx, &p->syncConfigIndex_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value* p, enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup) {
		_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->additionalSpectrumEmission_v1370, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370(_buffer, _size, _lidx, &p->freqInfo_v1370);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value* p, enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup) {
		_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscResourcePool_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscResourcePool_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->cp_Len_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->discPeriod_r12;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->numRetx_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->numRepetition_r12, _lidx);
	_serSysEncSQN_SL_TF_ResourceConfig_r12(_buffer, _size, _lidx, &p->tf_ResourceConfig_r12);
	_serSysEncSQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional(_buffer, _size, _lidx, &p->txParameters_r12);
	_serSysEncSQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional(_buffer, _size, _lidx, &p->rxParameters_r12);
	_serSysEncSQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional(_buffer, _size, _lidx, &p->discPeriod_v1310);
	_serSysEncSQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional(_buffer, _size, _lidx, &p->rxParamsAddNeighFreq_r13);
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional(_buffer, _size, _lidx, &p->txParamsAddNeighFreq_r13);
	_serSysEncSQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional(_buffer, _size, _lidx, &p->txParamsAddNeighFreq_v1370);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_DiscResourcePool_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscTxPowerInfo_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscTxPowerInfo_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->discMaxTxPower_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 3; i2++) {
		_serSysEncSQN_SL_DiscTxPowerInfo_r12(_buffer, _size, _lidx, &p->v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_SyncConfig_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfig_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfig_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->discRxPool_r12.d, _lidx);
	for (size_t i2 = 0; i2 < p->discRxPool_r12.d; i2++) {
		_serSysEncSQN_SL_DiscResourcePool_r12(_buffer, _size, _lidx, &p->discRxPool_r12.v[i2]);
	}
	_serSysEncSQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional(_buffer, _size, _lidx, &p->discTxPoolCommon_r12);
	_serSysEncSQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional(_buffer, _size, _lidx, &p->discTxPowerInfo_r12);
	_serSysEncSQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional(_buffer, _size, _lidx, &p->discSyncConfig_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfig_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo2_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PLMN_IdentityInfo2_r12_Value* p, enum SQN_PLMN_IdentityInfo2_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PLMN_IdentityInfo2_r12_plmn_Index_r12) {
		HTON_8(&_buffer[*_lidx], p->plmn_Index_r12, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PLMN_IdentityInfo2_r12_plmnIdentity_r12) {
		_serSysEncSQN_PLMN_Identity(_buffer, _size, _lidx, &p->plmnIdentity_r12);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PLMN_IdentityInfo2_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo2_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PLMN_IdentityInfo2_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PLMN_IdentityInfo2_r12(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CarrierFreqInfo_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CarrierFreqInfo_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreq_r12, _lidx);
	_serSysEncSQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional(_buffer, _size, _lidx, &p->plmn_IdentityList_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CarrierFreqInfo_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_SL_DiscResourcePool_r12(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscTxResourcesInterFreq_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_DiscTxResourcesInterFreq_r13_Value* p, enum SQN_SL_DiscTxResourcesInterFreq_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_acquireSI_FromCarrier_r13) {
		HTON_8(&_buffer[*_lidx], p->acquireSI_FromCarrier_r13, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_discTxPoolCommon_r13) {
		HTON_32(&_buffer[*_lidx], p->discTxPoolCommon_r13.d, _lidx);
		for (size_t i3 = 0; i3 < p->discTxPoolCommon_r13.d; i3++) {
			_serSysEncSQN_SL_DiscResourcePool_r12(_buffer, _size, _lidx, &p->discTxPoolCommon_r13.v[i3]);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_requestDedicated_r13) {
		HTON_8(&_buffer[*_lidx], p->requestDedicated_r13, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_DiscTxResourcesInterFreq_r13_noTxOnCarrier_r13) {
		HTON_8(&_buffer[*_lidx], p->noTxOnCarrier_r13, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_DiscTxResourcesInterFreq_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscTxResourcesInterFreq_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_DiscTxResourcesInterFreq_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscTxResourcesInterFreq_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_ResourcesInterFreq_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_ResourcesInterFreq_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional(_buffer, _size, _lidx, &p->discRxResourcesInterFreq_r13);
	_serSysEncSQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional(_buffer, _size, _lidx, &p->discTxResourcesInterFreq_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_ResourcesInterFreq_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_ResourcesInterFreq_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i3 = 0; i3 < 3; i3++) {
		_serSysEncSQN_SL_DiscTxPowerInfo_r12(_buffer, _size, _lidx, &p->v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_asyncParameters_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->syncCP_Len_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->syncOffsetIndicator_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->slssid_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_SyncConfigNFreq_r13_asyncParameters_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncB19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i4 = 0; i4 < 19; i4++) {
		HTON_8(&_buffer[*_lidx], p->v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_txParameters_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_TxParameters_r12(_buffer, _size, _lidx, &p->syncTxParameters_r13);
	HTON_8(&_buffer[*_lidx], p->syncTxThreshIC_r13, _lidx);
	_serSysEncB19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional(_buffer, _size, _lidx, &p->syncInfoReserved_r13);
	_serSysEncSQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional(_buffer, _size, _lidx, &p->syncTxPeriodic_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_SyncConfigNFreq_r13_txParameters_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_rxParameters_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->discSyncWindow_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_SyncConfigNFreq_r13_rxParameters_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigNFreq_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigNFreq_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional(_buffer, _size, _lidx, &p->asyncParameters_r13);
	_serSysEncSQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional(_buffer, _size, _lidx, &p->txParameters_r13);
	_serSysEncSQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional(_buffer, _size, _lidx, &p->rxParameters_r13);
	_serSysEncSQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional(_buffer, _size, _lidx, &p->syncOffsetIndicator_v1430);
	_serSysEncSQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional(_buffer, _size, _lidx, &p->gnss_Sync_r14);
	_serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional(_buffer, _size, _lidx, &p->syncOffsetIndicator2_r14);
	_serSysEncSQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional(_buffer, _size, _lidx, &p->syncOffsetIndicator3_r14);
	_serSysEncSQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional(_buffer, _size, _lidx, &p->slss_TxDisabled_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_SL_SyncConfigNFreq_r13(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoNFreq_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoNFreq_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMin_r13, _lidx);
	_serSysEncUint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffset);
	{
		size_t _tmp = (size_t)p->q_Hyst_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->q_RxLevMinReselection_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionEUTRA_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoNFreq_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigOtherInterFreq_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigOtherInterFreq_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional(_buffer, _size, _lidx, &p->txPowerInfo_r13);
	_serSysEncSQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional(_buffer, _size, _lidx, &p->refCarrierCommon_r13);
	_serSysEncSQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional(_buffer, _size, _lidx, &p->discSyncConfig_r13);
	_serSysEncSQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional(_buffer, _size, _lidx, &p->discCellSelectionInfo_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_DiscConfigOtherInterFreq_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CarrierFreqInfo_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CarrierFreqInfo_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional(_buffer, _size, _lidx, &p->discResourcesNonPS_r13);
	_serSysEncSQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional(_buffer, _size, _lidx, &p->discResourcesPS_r13);
	_serSysEncSQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional(_buffer, _size, _lidx, &p->discConfigOther_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CarrierFreqInfo_v1310(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfig_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfig_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional(_buffer, _size, _lidx, &p->discInterFreqList_v1310);
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional(_buffer, _size, _lidx, &p->gapRequestsAllowedCommon);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfig_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigRelayUE_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigRelayUE_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional(_buffer, _size, _lidx, &p->threshHigh_r13);
	_serSysEncSQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional(_buffer, _size, _lidx, &p->threshLow_r13);
	_serSysEncSQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional(_buffer, _size, _lidx, &p->hystMax_r13);
	_serSysEncSQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional(_buffer, _size, _lidx, &p->hystMin_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ReselectionInfoRelay_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ReselectionInfoRelay_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMin_r13, _lidx);
	{
		size_t _tmp = (size_t)p->filterCoefficient_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional(_buffer, _size, _lidx, &p->minHyst_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscConfigRemoteUE_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscConfigRemoteUE_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional(_buffer, _size, _lidx, &p->threshHigh_r13);
	_serSysEncSQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional(_buffer, _size, _lidx, &p->hystMax_r13);
	_serSysEncSQN_ReselectionInfoRelay_r13(_buffer, _size, _lidx, &p->reselectionInfoIC_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfigRelay_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_DiscConfigRelayUE_r13(_buffer, _size, _lidx, &p->relayUE_Config_r13);
	_serSysEncSQN_SL_DiscConfigRemoteUE_r13(_buffer, _size, _lidx, &p->remoteUE_Config_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfigRelay_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_DiscResourcePool_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfigPS_13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfigPS_13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->discRxPoolPS_r13.d, _lidx);
	for (size_t i2 = 0; i2 < p->discRxPoolPS_r13.d; i2++) {
		_serSysEncSQN_SL_DiscResourcePool_r12(_buffer, _size, _lidx, &p->discRxPoolPS_r13.v[i2]);
	}
	_serSysEncSQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional(_buffer, _size, _lidx, &p->discTxPoolPS_Common_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfigPS_13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType19_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType19_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional(_buffer, _size, _lidx, &p->discConfig_r12);
	_serSysEncSQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional(_buffer, _size, _lidx, &p->discInterFreqList_r12);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional(_buffer, _size, _lidx, &p->discConfig_v1310);
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional(_buffer, _size, _lidx, &p->discConfigRelay_r13);
	_serSysEncSQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional(_buffer, _size, _lidx, &p->discConfigPS_13);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value* p, enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14) {
		{
			size_t _tmp = (size_t)p->fdd_r14;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14) {
		{
			size_t _tmp = (size_t)p->tdd_r14;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->dummy;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->dummy2;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->mpdcch_Narrowband_SC_MCCH_r14, _lidx);
	{
		size_t _tmp = (size_t)p->mpdcch_NumRepetition_SC_MCCH_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14(_buffer, _size, _lidx, &p->mpdcch_StartSF_SC_MCCH_r14);
	{
		size_t _tmp = (size_t)p->mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->sc_mcch_CarrierFreq_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->sc_mcch_Offset_BR_r14, _lidx);
	{
		size_t _tmp = (size_t)p->sc_mcch_RepetitionPeriod_BR_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->sc_mcch_ModificationPeriod_BR_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value* p, enum SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf10) {
		HTON_8(&_buffer[*_lidx], p->sf10, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf20) {
		HTON_8(&_buffer[*_lidx], p->sf20, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf32) {
		HTON_8(&_buffer[*_lidx], p->sf32, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf40) {
		HTON_8(&_buffer[*_lidx], p->sf40, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf64) {
		HTON_8(&_buffer[*_lidx], p->sf64, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf80) {
		HTON_8(&_buffer[*_lidx], p->sf80, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf128) {
		HTON_8(&_buffer[*_lidx], p->sf128, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf160) {
		HTON_8(&_buffer[*_lidx], p->sf160, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf256) {
		HTON_8(&_buffer[*_lidx], p->sf256, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf320) {
		HTON_16(&_buffer[*_lidx], p->sf320, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf512) {
		HTON_16(&_buffer[*_lidx], p->sf512, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf640) {
		HTON_16(&_buffer[*_lidx], p->sf640, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf1024) {
		HTON_16(&_buffer[*_lidx], p->sf1024, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf2048) {
		HTON_16(&_buffer[*_lidx], p->sf2048, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf4096) {
		HTON_16(&_buffer[*_lidx], p->sf4096, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf8192) {
		HTON_16(&_buffer[*_lidx], p->sf8192, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SC_MCCH_SchedulingInfo_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SC_MCCH_SchedulingInfo_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->onDurationTimerSCPTM_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->drx_InactivityTimerSCPTM_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14(_buffer, _size, _lidx, &p->schedulingPeriodStartOffsetSCPTM_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SC_MCCH_SchedulingInfo_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType20_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType20_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sc_mcch_RepetitionPeriod_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->sc_mcch_Offset_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->sc_mcch_FirstSubframe_r13, _lidx);
	_serSysEncUint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional(_buffer, _size, _lidx, &p->sc_mcch_duration_r13);
	{
		size_t _tmp = (size_t)p->sc_mcch_ModificationPeriod_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional(_buffer, _size, _lidx, &p->br_BCCH_Config_r14);
	_serSysEncSQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional(_buffer, _size, _lidx, &p->sc_mcch_SchedulingInfo_r14);
	_serSysEncSQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional(_buffer, _size, _lidx, &p->pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14);
	_serSysEncSQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional(_buffer, _size, _lidx, &p->pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14);
	_serSysEncSQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional(_buffer, _size, _lidx, &p->sc_mcch_RepetitionPeriod_v1470);
	_serSysEncSQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional(_buffer, _size, _lidx, &p->sc_mcch_ModificationPeriod_v1470);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_OffsetIndicator_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SubframeBitmapSL_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SubframeBitmapSL_r14_Value* p, enum SQN_SubframeBitmapSL_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SubframeBitmapSL_r14_bs10_r14) {
		for (size_t i3 = 0; i3 < 10; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs10_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs16_r14) {
		for (size_t i3 = 0; i3 < 16; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs16_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs20_r14) {
		for (size_t i3 = 0; i3 < 20; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs20_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs30_r14) {
		for (size_t i3 = 0; i3 < 30; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs30_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs40_r14) {
		for (size_t i3 = 0; i3 < 40; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs40_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs50_r14) {
		for (size_t i3 = 0; i3 < 50; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs50_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs60_r14) {
		for (size_t i3 = 0; i3 < 60; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs60_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SubframeBitmapSL_r14_bs100_r14) {
		for (size_t i3 = 0; i3 < 100; i3++) {
			HTON_8(&_buffer[*_lidx], p->bs100_r14[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SubframeBitmapSL_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SubframeBitmapSL_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SubframeBitmapSL_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional(_buffer, _size, _lidx, &p->tdd_Config_r14);
	HTON_8(&_buffer[*_lidx], p->syncConfigIndex_r14, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_TxParameters_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PPPP_TxConfigIndex_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PPPP_TxConfigIndex_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->priorityThreshold_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->defaultTxConfigIndex_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->cbr_ConfigIndex_r14, _lidx);
	HTON_32(&_buffer[*_lidx], p->tx_ConfigIndexList_r14.d, _lidx);
	for (size_t i4 = 0; i4 < p->tx_ConfigIndexList_r14.d; i4++) {
		HTON_8(&_buffer[*_lidx], p->tx_ConfigIndexList_r14.v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_SL_PPPP_TxConfigIndex_r14(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional(_buffer, _size, _lidx, &p->partialSensing_r14);
	_serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional(_buffer, _size, _lidx, &p->randomSelection_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncAllowed_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncAllowed_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional(_buffer, _size, _lidx, &p->gnss_Sync_r14);
	_serSysEncSQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional(_buffer, _size, _lidx, &p->enb_Sync_r14);
	_serSysEncSQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional(_buffer, _size, _lidx, &p->ue_Sync_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_SyncAllowed_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		{
			size_t _tmp = (size_t)p->v.v[i3];
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_MinT2Value_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_MinT2Value_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->priorityList_r15.d, _lidx);
	for (size_t i4 = 0; i4 < p->priorityList_r15.d; i4++) {
		HTON_8(&_buffer[*_lidx], p->priorityList_r15.v[i4], _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->minT2Value_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_SL_MinT2Value_r15(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MCS_PSSCH_Range_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MCS_PSSCH_Range_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->minMCS_PSSCH_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->maxMCS_PSSCH_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_serSysEncSQN_MCS_PSSCH_Range_r15(_buffer, _size, _lidx, &p->v.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PPPP_TxConfigIndex_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PPPP_TxConfigIndex_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional(_buffer, _size, _lidx, &p->mcs_PSSCH_RangeList_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_SL_PPPP_TxConfigIndex_v1530(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePoolV2X_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePoolV2X_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional(_buffer, _size, _lidx, &p->sl_OffsetIndicator_r14);
	_serSysEncSQN_SubframeBitmapSL_r14(_buffer, _size, _lidx, &p->sl_Subframe_r14);
	HTON_8(&_buffer[*_lidx], p->adjacencyPSCCH_PSSCH_r14, _lidx);
	{
		size_t _tmp = (size_t)p->sizeSubchannel_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->numSubchannel_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->startRB_Subchannel_r14, _lidx);
	_serSysEncUint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional(_buffer, _size, _lidx, &p->startRB_PSCCH_Pool_r14);
	_serSysEncSQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional(_buffer, _size, _lidx, &p->rxParametersNCell_r14);
	_serSysEncSQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional(_buffer, _size, _lidx, &p->dataTxParameters_r14);
	_serSysEncUint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional(_buffer, _size, _lidx, &p->zoneID_r14);
	_serSysEncUint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional(_buffer, _size, _lidx, &p->threshS_RSSI_CBR_r14);
	_serSysEncSQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional(_buffer, _size, _lidx, &p->poolReportId_r14);
	_serSysEncSQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional(_buffer, _size, _lidx, &p->cbr_pssch_TxConfigList_r14);
	_serSysEncSQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional(_buffer, _size, _lidx, &p->resourceSelectionConfigP2X_r14);
	_serSysEncSQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional(_buffer, _size, _lidx, &p->syncAllowed_r14);
	_serSysEncSQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional(_buffer, _size, _lidx, &p->restrictResourceReservationPeriod_r14);
	_serSysEncSQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional(_buffer, _size, _lidx, &p->sl_MinT2ValueList_r15);
	_serSysEncSQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional(_buffer, _size, _lidx, &p->cbr_pssch_TxConfigList_v1530);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_SyncConfig_r12(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PLMN_Identity(_buffer, _size, _lidx, &p->plmn_Identity);
	{
		size_t _tmp = (size_t)p->cellReservedForOperatorUse;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_PLMN_IdentityInfo(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_serSysEncSQN_SL_SyncConfigNFreq_r13(_buffer, _size, _lidx, &p->v.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v.v[i4]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommResourcePoolV2X_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TxPower_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_TxPower_r14_Value* p, enum SQN_SL_TxPower_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_TxPower_r14_minusinfinity_r14) {
		HTON_8(&_buffer[*_lidx], p->minusinfinity_r14, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_TxPower_r14_txPower_r14) {
		HTON_8(&_buffer[*_lidx], p->txPower_r14, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_TxPower_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TxPower_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_TxPower_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_TxPower_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PSSCH_TxParameters_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PSSCH_TxParameters_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->minMCS_PSSCH_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->maxMCS_PSSCH_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->minSubChannel_NumberPSSCH_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->maxSubchannel_NumberPSSCH_r14, _lidx);
	{
		size_t _tmp = (size_t)p->allowedRetxNumberPSSCH_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional(_buffer, _size, _lidx, &p->maxTxPower_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PSSCH_TxParameters_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PSSCH_TxParameters_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->minMCS_PSSCH_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->maxMCS_PSSCH_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_PSSCH_TxParameters_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_PSSCH_TxParameters_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PSSCH_TxConfig_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PSSCH_TxConfig_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional(_buffer, _size, _lidx, &p->typeTxSync_r14);
	{
		size_t _tmp = (size_t)p->thresUE_Speed_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_PSSCH_TxParameters_r14(_buffer, _size, _lidx, &p->parametersAboveThres_r14);
	_serSysEncSQN_SL_PSSCH_TxParameters_r14(_buffer, _size, _lidx, &p->parametersBelowThres_r14);
	_serSysEncSQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional(_buffer, _size, _lidx, &p->parametersAboveThres_v1530);
	_serSysEncSQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional(_buffer, _size, _lidx, &p->parametersBelowThres_v1530);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i4 = 0; i4 < p->v.d; i4++) {
		{
			size_t _tmp = (size_t)p->v.v[i4];
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->minNumCandidateSF_r14, _lidx);
	for (size_t i4 = 0; i4 < 10; i4++) {
		HTON_8(&_buffer[*_lidx], p->gapCandidateSensing_r14[i4], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolSensingConfig_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolSensingConfig_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->pssch_TxConfigList_r14.d, _lidx);
	for (size_t i4 = 0; i4 < p->pssch_TxConfigList_r14.d; i4++) {
		_serSysEncSQN_SL_PSSCH_TxConfig_r14(_buffer, _size, _lidx, &p->pssch_TxConfigList_r14.v[i4]);
	}
	for (size_t i4 = 0; i4 < 64; i4++) {
		HTON_8(&_buffer[*_lidx], p->thresPSSCH_RSRP_List_r14[i4], _lidx);
	}
	_serSysEncSQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional(_buffer, _size, _lidx, &p->restrictResourceReservationPeriod_r14);
	{
		size_t _tmp = (size_t)p->probResourceKeep_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional(_buffer, _size, _lidx, &p->p2x_SensingConfig_r14);
	_serSysEncSQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional(_buffer, _size, _lidx, &p->sl_ReselectAfter_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommTxPoolSensingConfig_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_ZoneConfig_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_ZoneConfig_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->zoneLength_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->zoneWidth_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->zoneIdLongiMod_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->zoneIdLatiMod_r14, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_ZoneConfig_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_InterFreqUE_Config_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_InterFreqUE_Config_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional(_buffer, _size, _lidx, &p->physCellIdList_r14);
	_serSysEncSQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional(_buffer, _size, _lidx, &p->typeTxSync_r14);
	_serSysEncSQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional(_buffer, _size, _lidx, &p->v2x_SyncConfig_r14);
	_serSysEncSQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional(_buffer, _size, _lidx, &p->v2x_CommRxPool_r14);
	_serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional(_buffer, _size, _lidx, &p->v2x_CommTxPoolNormal_r14);
	_serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional(_buffer, _size, _lidx, &p->p2x_CommTxPoolNormal_r14);
	_serSysEncSQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional(_buffer, _size, _lidx, &p->v2x_CommTxPoolExceptional_r14);
	_serSysEncSQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional(_buffer, _size, _lidx, &p->v2x_ResourceSelectionConfig_r14);
	_serSysEncSQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional(_buffer, _size, _lidx, &p->zoneConfig_r14);
	_serSysEncUint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional(_buffer, _size, _lidx, &p->offsetDFN_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_SL_V2X_InterFreqUE_Config_r14(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value* p, enum SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmission_r14) {
		HTON_8(&_buffer[*_lidx], p->additionalSpectrumEmission_r14, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmission_v1440) {
		HTON_16(&_buffer[*_lidx], p->additionalSpectrumEmission_v1440, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_FreqSelectionConfig_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_FreqSelectionConfig_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->priorityList_r15.d, _lidx);
	for (size_t i4 = 0; i4 < p->priorityList_r15.d; i4++) {
		HTON_8(&_buffer[*_lidx], p->priorityList_r15.v[i4], _lidx);
	}
	_serSysEncSQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional(_buffer, _size, _lidx, &p->threshCBR_FreqReselection_r15);
	_serSysEncSQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional(_buffer, _size, _lidx, &p->threshCBR_FreqKeeping_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_SL_V2X_FreqSelectionConfig_r15(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_InterFreqInfoV2X_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_InterFreqInfoV2X_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional(_buffer, _size, _lidx, &p->plmn_IdentityList_r14);
	HTON_32(&_buffer[*_lidx], p->v2x_CommCarrierFreq_r14, _lidx);
	_serSysEncSQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional(_buffer, _size, _lidx, &p->sl_MaxTxPower_r14);
	_serSysEncSQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional(_buffer, _size, _lidx, &p->sl_Bandwidth_r14);
	_serSysEncSQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional(_buffer, _size, _lidx, &p->v2x_SchedulingPool_r14);
	_serSysEncSQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional(_buffer, _size, _lidx, &p->v2x_UE_ConfigList_r14);
	_serSysEncSQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional(_buffer, _size, _lidx, &p->additionalSpectrumEmissionV2X_r14);
	_serSysEncSQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional(_buffer, _size, _lidx, &p->v2x_FreqSelectionConfigList_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_InterFreqInfoV2X_r14(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CommTxPoolSensingConfig_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_ZoneConfig_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_PSSCH_TxConfig_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_PSSCH_TxConfig_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->cr_Limit_r14, _lidx);
	_serSysEncSQN_SL_PSSCH_TxParameters_r14(_buffer, _size, _lidx, &p->tx_Parameters_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_CommonTxConfigList_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_CommonTxConfigList_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->cbr_RangeCommonConfigList_r14.d, _lidx);
	for (size_t i2 = 0; i2 < p->cbr_RangeCommonConfigList_r14.d; i2++) {
		HTON_32(&_buffer[*_lidx], p->cbr_RangeCommonConfigList_r14.v[i2].d, _lidx);
		for (size_t i3 = 0; i3 < p->cbr_RangeCommonConfigList_r14.v[i2].d; i3++) {
			HTON_8(&_buffer[*_lidx], p->cbr_RangeCommonConfigList_r14.v[i2].v[i3], _lidx);
		}
	}
	HTON_32(&_buffer[*_lidx], p->sl_CBR_PSSCH_TxConfigList_r14.d, _lidx);
	for (size_t i2 = 0; i2 < p->sl_CBR_PSSCH_TxConfigList_r14.d; i2++) {
		_serSysEncSQN_SL_CBR_PSSCH_TxConfig_r14(_buffer, _size, _lidx, &p->sl_CBR_PSSCH_TxConfigList_r14.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_CBR_CommonTxConfigList_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_ConfigCommon_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_ConfigCommon_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional(_buffer, _size, _lidx, &p->v2x_CommRxPool_r14);
	_serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional(_buffer, _size, _lidx, &p->v2x_CommTxPoolNormalCommon_r14);
	_serSysEncSQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional(_buffer, _size, _lidx, &p->p2x_CommTxPoolNormalCommon_r14);
	_serSysEncSQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional(_buffer, _size, _lidx, &p->v2x_CommTxPoolExceptional_r14);
	_serSysEncSQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional(_buffer, _size, _lidx, &p->v2x_SyncConfig_r14);
	_serSysEncSQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional(_buffer, _size, _lidx, &p->v2x_InterFreqInfoList_r14);
	_serSysEncSQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional(_buffer, _size, _lidx, &p->v2x_ResourceSelectionConfig_r14);
	_serSysEncSQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional(_buffer, _size, _lidx, &p->zoneConfig_r14);
	_serSysEncSQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional(_buffer, _size, _lidx, &p->typeTxSync_r14);
	_serSysEncSQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional(_buffer, _size, _lidx, &p->thresSL_TxPrioritization_r14);
	_serSysEncSQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional(_buffer, _size, _lidx, &p->anchorCarrierFreqList_r14);
	_serSysEncUint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional(_buffer, _size, _lidx, &p->offsetDFN_r14);
	_serSysEncSQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional(_buffer, _size, _lidx, &p->cbr_CommonTxConfigList_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_V2X_ConfigCommon_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType21_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType21_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional(_buffer, _size, _lidx, &p->sl_V2X_ConfigCommon_r14);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional(_buffer, _size, _lidx, &p->anchorCarrierFreqListNR_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MTC_SSB_NR_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SS_RSSI_Measurement_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqNR_r15_threshX_Q_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqNR_r15_threshX_Q_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshX_HighQ_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_LowQ_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CarrierFreqNR_r15_threshX_Q_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncInt8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NS_PmaxValueNR_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NS_PmaxValueNR_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional(_buffer, _size, _lidx, &p->additionalPmaxNR_r15);
	HTON_8(&_buffer[*_lidx], p->additionalSpectrumEmissionNR_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		_serSysEncSQN_NS_PmaxValueNR_r15(_buffer, _size, _lidx, &p->v.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncInt8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct int8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ThresholdListNR_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i3].d, _lidx);
		for (size_t i4 = 0; i4 < p->v.v[i3].d; i4++) {
			_serSysEncSQN_NS_PmaxValueNR_r15(_buffer, _size, _lidx, &p->v.v[i3].v[i4]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i3].d, _lidx);
		for (size_t i4 = 0; i4 < p->v.v[i3].d; i4++) {
			_serSysEncSQN_NS_PmaxValueNR_r15(_buffer, _size, _lidx, &p->v.v[i3].v[i4]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SSB_ToMeasure_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqNR_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqNR_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreq_r15, _lidx);
	_serSysEncSQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional(_buffer, _size, _lidx, &p->multiBandInfoList_r15);
	_serSysEncSQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional(_buffer, _size, _lidx, &p->multiBandInfoListSUL_r15);
	_serSysEncSQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional(_buffer, _size, _lidx, &p->measTimingConfig_r15);
	{
		size_t _tmp = (size_t)p->subcarrierSpacingSSB_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional(_buffer, _size, _lidx, &p->ss_RSSI_Measurement_r15);
	_serSysEncSQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional(_buffer, _size, _lidx, &p->cellReselectionPriority_r15);
	_serSysEncSQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional(_buffer, _size, _lidx, &p->cellReselectionSubPriority_r15);
	HTON_8(&_buffer[*_lidx], p->threshX_High_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->threshX_Low_r15, _lidx);
	_serSysEncSQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional(_buffer, _size, _lidx, &p->threshX_Q_r15);
	HTON_8(&_buffer[*_lidx], p->q_RxLevMin_r15, _lidx);
	_serSysEncInt8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional(_buffer, _size, _lidx, &p->q_RxLevMinSUL_r15);
	HTON_8(&_buffer[*_lidx], p->p_MaxNR_r15, _lidx);
	_serSysEncSQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional(_buffer, _size, _lidx, &p->ns_PmaxListNR_r15);
	_serSysEncInt8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional(_buffer, _size, _lidx, &p->q_QualMin_r15);
	HTON_8(&_buffer[*_lidx], p->deriveSSB_IndexFromCell_r15, _lidx);
	_serSysEncSQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional(_buffer, _size, _lidx, &p->maxRS_IndexCellQual_r15);
	_serSysEncSQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional(_buffer, _size, _lidx, &p->threshRS_Index_r15);
	_serSysEncSQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional(_buffer, _size, _lidx, &p->multiBandNsPmaxListNR_v1550);
	_serSysEncSQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional(_buffer, _size, _lidx, &p->multiBandNsPmaxListNR_SUL_v1550);
	_serSysEncSQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional(_buffer, _size, _lidx, &p->ssb_ToMeasure_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqNR_r15(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SpeedStateScaleFactors(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MTC_SSB2_LP_NR_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MTC_SSB2_LP_NR_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional(_buffer, _size, _lidx, &p->pci_List_r16);
	{
		size_t _tmp = (size_t)p->periodicity_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_MTC_SSB2_LP_NR_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqNR_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqNR_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional(_buffer, _size, _lidx, &p->smtc2_LP_r16);
	_serSysEncSQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional(_buffer, _size, _lidx, &p->ssb_PositionQCL_CommonNR_r16);
	_serSysEncSQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional(_buffer, _size, _lidx, &p->whiteCellListNR_r16);
	_serSysEncSQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional(_buffer, _size, _lidx, &p->highSpeedCarrierNR_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqNR_v1610(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType24_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType24_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional(_buffer, _size, _lidx, &p->carrierFreqListNR_r15);
	HTON_8(&_buffer[*_lidx], p->t_ReselectionNR_r15, _lidx);
	_serSysEncSQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional(_buffer, _size, _lidx, &p->t_ReselectionNR_SF_r15);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional(_buffer, _size, _lidx, &p->carrierFreqListNR_v1610);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UAC_BarringPerCat_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UAC_BarringPerCat_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->accessCategory_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->uac_barringInfoSetIndex_r15, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_UAC_BarringPerCat_r15(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value* p, enum SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_ImplicitAC_BarringList_r15) {
		for (size_t i3 = 0; i3 < 63; i3++) {
			HTON_8(&_buffer[*_lidx], p->uac_ImplicitAC_BarringList_r15[i3], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_ExplicitAC_BarringList_r15) {
		HTON_32(&_buffer[*_lidx], p->uac_ExplicitAC_BarringList_r15.d, _lidx);
		for (size_t i3 = 0; i3 < p->uac_ExplicitAC_BarringList_r15.d; i3++) {
			_serSysEncSQN_UAC_BarringPerCat_r15(_buffer, _size, _lidx, &p->uac_ExplicitAC_BarringList_r15.v[i3]);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UAC_BarringPerPLMN_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UAC_BarringPerPLMN_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->plmn_IdentityIndex_r15, _lidx);
	_serSysEncSQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional(_buffer, _size, _lidx, &p->uac_AC_BarringListType_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_UAC_BarringPerPLMN_r15(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_UAC_BarringInfoSet_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_UAC_BarringInfoSet_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->uac_BarringFactor_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->uac_BarringTime_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	for (size_t i3 = 0; i3 < 7; i3++) {
		HTON_8(&_buffer[*_lidx], p->uac_BarringForAccessIdentity_r15[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value* p, enum SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_plmnCommon_r15) {
		{
			size_t _tmp = (size_t)p->plmnCommon_r15;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_individualPLMNList_r15) {
		HTON_32(&_buffer[*_lidx], p->individualPLMNList_r15.d, _lidx);
		for (size_t i2 = 0; i2 < p->individualPLMNList_r15.d; i2++) {
			{
				size_t _tmp = (size_t)p->individualPLMNList_r15.v[i2];
				HTON_32(&_buffer[*_lidx], _tmp, _lidx);
			}
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType25_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType25_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional(_buffer, _size, _lidx, &p->uac_BarringForCommon_r15);
	_serSysEncSQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional(_buffer, _size, _lidx, &p->uac_BarringPerPLMN_List_r15);
	HTON_32(&_buffer[*_lidx], p->uac_BarringInfoSetList_r15.d, _lidx);
	for (size_t i2 = 0; i2 < p->uac_BarringInfoSetList_r15.d; i2++) {
		_serSysEncSQN_UAC_BarringInfoSet_r15(_buffer, _size, _lidx, &p->uac_BarringInfoSetList_r15.v[i2]);
	}
	_serSysEncSQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional(_buffer, _size, _lidx, &p->uac_AC1_SelectAssistInfo_r15);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional(_buffer, _size, _lidx, &p->ab_PerRSRP_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_InterFreqInfoV2X_r14(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PPPP_TxConfigIndex_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PPPP_TxConfigIndex_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->priorityThreshold_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->defaultTxConfigIndex_r15, _lidx);
	HTON_8(&_buffer[*_lidx], p->cbr_ConfigIndex_r15, _lidx);
	HTON_32(&_buffer[*_lidx], p->tx_ConfigIndexList_r15.d, _lidx);
	for (size_t i3 = 0; i3 < p->tx_ConfigIndexList_r15.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->tx_ConfigIndexList_r15.v[i3], _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->mcs_PSSCH_RangeList_r15.d, _lidx);
	for (size_t i3 = 0; i3 < p->mcs_PSSCH_RangeList_r15.d; i3++) {
		_serSysEncSQN_MCS_PSSCH_Range_r15(_buffer, _size, _lidx, &p->mcs_PSSCH_RangeList_r15.v[i3]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_PPPP_TxConfigIndex_r15(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i3 = 0; i3 < p->v.d; i3++) {
		for (size_t i4 = 0; i4 < 24; i4++) {
			HTON_8(&_buffer[*_lidx], p->v.v[i3][i4], _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_AllowedCarrierFreqList_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_AllowedCarrierFreqList_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->allowedCarrierFreqSet1.d, _lidx);
	for (size_t i3 = 0; i3 < p->allowedCarrierFreqSet1.d; i3++) {
		HTON_32(&_buffer[*_lidx], p->allowedCarrierFreqSet1.v[i3], _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->allowedCarrierFreqSet2.d, _lidx);
	for (size_t i3 = 0; i3 < p->allowedCarrierFreqSet2.d; i3++) {
		HTON_32(&_buffer[*_lidx], p->allowedCarrierFreqSet2.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_AllowedCarrierFreqList_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PPPR_Dest_CarrierFreq(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PPPR_Dest_CarrierFreq* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional(_buffer, _size, _lidx, &p->destinationInfoList_r15);
	_serSysEncSQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional(_buffer, _size, _lidx, &p->allowedCarrierFreqList_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_PPPR_Dest_CarrierFreq(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_PacketDuplicationConfig_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_PacketDuplicationConfig_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->threshSL_Reliability_r15, _lidx);
	_serSysEncSQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional(_buffer, _size, _lidx, &p->allowedCarrierFreqConfig_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SL_V2X_PacketDuplicationConfig_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_SL_V2X_FreqSelectionConfig_r15(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType26_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType26_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional(_buffer, _size, _lidx, &p->v2x_InterFreqInfoList_r15);
	_serSysEncSQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional(_buffer, _size, _lidx, &p->cbr_pssch_TxConfigList_r15);
	_serSysEncSQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional(_buffer, _size, _lidx, &p->v2x_PacketDuplicationConfig_r15);
	_serSysEncSQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional(_buffer, _size, _lidx, &p->syncFreqList_r15);
	_serSysEncSQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional(_buffer, _size, _lidx, &p->slss_TxMultiFreq_r15);
	_serSysEncSQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional(_buffer, _size, _lidx, &p->v2x_FreqSelectionConfigList_r15);
	_serSysEncUint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional(_buffer, _size, _lidx, &p->threshS_RSSI_CBR_r15);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncB10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i3 = 0; i3 < 10; i3++) {
		HTON_8(&_buffer[*_lidx], p->v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_Info_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_Info_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncB10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional(_buffer, _size, _lidx, &p->nr_BandList_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType26a_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType26a_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->plmn_InfoList_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->plmn_InfoList_r16.d; i2++) {
		_serSysEncSQN_PLMN_Info_r16(_buffer, _size, _lidx, &p->plmn_InfoList_r16.v[i2]);
	}
	HTON_32(&_buffer[*_lidx], p->bandListENDC_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->bandListENDC_r16.d; i2++) {
		HTON_16(&_buffer[*_lidx], p->bandListENDC_r16.v[i2], _lidx);
	}
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqNBIOT_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqNBIOT_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->carrierFreq_r16, _lidx);
	{
		size_t _tmp = (size_t)p->carrierFreqOffset_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CarrierFreqNBIOT_r16(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType27_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType27_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional(_buffer, _size, _lidx, &p->carrierFreqListNBIOT_r16);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType28_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType28_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->segmentNumber_r16, _lidx);
	{
		size_t _tmp = (size_t)p->segmentType_r16;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->segmentContainer_r16.d, _lidx);
	for (size_t i2 = 0; i2 < p->segmentContainer_r16.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->segmentContainer_r16.v[i2], _lidx);
	}
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PeriodicityStartPos_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PeriodicityStartPos_r16_Value* p, enum SQN_PeriodicityStartPos_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PeriodicityStartPos_r16_periodicity10ms) {
		HTON_8(&_buffer[*_lidx], p->periodicity10ms, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity20ms) {
		HTON_8(&_buffer[*_lidx], p->periodicity20ms, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity40ms) {
		HTON_8(&_buffer[*_lidx], p->periodicity40ms, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity80ms) {
		HTON_8(&_buffer[*_lidx], p->periodicity80ms, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PeriodicityStartPos_r16_periodicity160ms) {
		HTON_8(&_buffer[*_lidx], p->periodicity160ms, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PeriodicityStartPos_r16_spare3) {
		HTON_8(&_buffer[*_lidx], p->spare3, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PeriodicityStartPos_r16_spare2) {
		HTON_8(&_buffer[*_lidx], p->spare2, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PeriodicityStartPos_r16_spare1) {
		HTON_8(&_buffer[*_lidx], p->spare1, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PeriodicityStartPos_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PeriodicityStartPos_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PeriodicityStartPos_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value* p, enum SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap1dot4) {
		for (size_t i2 = 0; i2 < 6; i2++) {
			HTON_8(&_buffer[*_lidx], p->rbg_Bitmap1dot4[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap3) {
		for (size_t i2 = 0; i2 < 8; i2++) {
			HTON_8(&_buffer[*_lidx], p->rbg_Bitmap3[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap5) {
		for (size_t i2 = 0; i2 < 13; i2++) {
			HTON_8(&_buffer[*_lidx], p->rbg_Bitmap5[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap10) {
		for (size_t i2 = 0; i2 < 17; i2++) {
			HTON_8(&_buffer[*_lidx], p->rbg_Bitmap10[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap15) {
		for (size_t i2 = 0; i2 < 19; i2++) {
			HTON_8(&_buffer[*_lidx], p->rbg_Bitmap15[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap20) {
		for (size_t i2 = 0; i2 < 25; i2++) {
			HTON_8(&_buffer[*_lidx], p->rbg_Bitmap20[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value* p, enum SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_slotPattern10ms) {
		for (size_t i2 = 0; i2 < 20; i2++) {
			HTON_8(&_buffer[*_lidx], p->slotPattern10ms[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_slotPattern40ms) {
		for (size_t i2 = 0; i2 < 80; i2++) {
			HTON_8(&_buffer[*_lidx], p->slotPattern40ms[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_ResourceReservationConfigDL_r16_slotBitmap_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigDL_r16_slotBitmap_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncB7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 7; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncB7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 7; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigDL_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigDL_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PeriodicityStartPos_r16(_buffer, _size, _lidx, &p->periodicityStartPos_r16);
	_serSysEncSQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional(_buffer, _size, _lidx, &p->resourceReservationFreq_r16);
	_serSysEncSQN_ResourceReservationConfigDL_r16_slotBitmap_r16(_buffer, _size, _lidx, &p->slotBitmap_r16);
	_serSysEncB7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional(_buffer, _size, _lidx, &p->symbolBitmap1_r16);
	_serSysEncB7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional(_buffer, _size, _lidx, &p->symbolBitmap2_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ResourceReservationConfigDL_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value* p, enum SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotPattern10ms) {
		for (size_t i2 = 0; i2 < 20; i2++) {
			HTON_8(&_buffer[*_lidx], p->slotPattern10ms[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotPattern40ms) {
		for (size_t i2 = 0; i2 < 80; i2++) {
			HTON_8(&_buffer[*_lidx], p->slotPattern40ms[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_ResourceReservationConfigUL_r16_slotBitmap_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ResourceReservationConfigUL_r16_slotBitmap_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncB7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 7; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncB7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i2 = 0; i2 < 7; i2++) {
		HTON_8(&_buffer[*_lidx], p->v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigUL_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigUL_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PeriodicityStartPos_r16(_buffer, _size, _lidx, &p->periodicityStartPos_r16);
	_serSysEncSQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional(_buffer, _size, _lidx, &p->slotBitmap_r16);
	_serSysEncB7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional(_buffer, _size, _lidx, &p->symbolBitmap1_r16);
	_serSysEncB7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional(_buffer, _size, _lidx, &p->symbolBitmap2_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_ResourceReservationConfigUL_r16(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType29_r16(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType29_r16* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional(_buffer, _size, _lidx, &p->resourceReservationConfigCommonDL_r16);
	_serSysEncSQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional(_buffer, _size, _lidx, &p->resourceReservationConfigCommonUL_r16);
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value* p, enum SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib2) {
		_serSysEncSQN_SystemInformationBlockType2(_buffer, _size, _lidx, &p->sib2);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib3) {
		_serSysEncSQN_SystemInformationBlockType3(_buffer, _size, _lidx, &p->sib3);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib4) {
		_serSysEncSQN_SystemInformationBlockType4(_buffer, _size, _lidx, &p->sib4);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib5) {
		_serSysEncSQN_SystemInformationBlockType5(_buffer, _size, _lidx, &p->sib5);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib6) {
		_serSysEncSQN_SystemInformationBlockType6(_buffer, _size, _lidx, &p->sib6);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib7) {
		_serSysEncSQN_SystemInformationBlockType7(_buffer, _size, _lidx, &p->sib7);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib8) {
		_serSysEncSQN_SystemInformationBlockType8(_buffer, _size, _lidx, &p->sib8);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib9) {
		_serSysEncSQN_SystemInformationBlockType9(_buffer, _size, _lidx, &p->sib9);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib10) {
		_serSysEncSQN_SystemInformationBlockType10(_buffer, _size, _lidx, &p->sib10);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib11) {
		_serSysEncSQN_SystemInformationBlockType11(_buffer, _size, _lidx, &p->sib11);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib12_v920) {
		_serSysEncSQN_SystemInformationBlockType12_r9(_buffer, _size, _lidx, &p->sib12_v920);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib13_v920) {
		_serSysEncSQN_SystemInformationBlockType13_r9(_buffer, _size, _lidx, &p->sib13_v920);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib14_v1130) {
		_serSysEncSQN_SystemInformationBlockType14_r11(_buffer, _size, _lidx, &p->sib14_v1130);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib15_v1130) {
		_serSysEncSQN_SystemInformationBlockType15_r11(_buffer, _size, _lidx, &p->sib15_v1130);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib16_v1130) {
		_serSysEncSQN_SystemInformationBlockType16_r11(_buffer, _size, _lidx, &p->sib16_v1130);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib17_v1250) {
		_serSysEncSQN_SystemInformationBlockType17_r12(_buffer, _size, _lidx, &p->sib17_v1250);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib18_v1250) {
		_serSysEncSQN_SystemInformationBlockType18_r12(_buffer, _size, _lidx, &p->sib18_v1250);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib19_v1250) {
		_serSysEncSQN_SystemInformationBlockType19_r12(_buffer, _size, _lidx, &p->sib19_v1250);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib20_v1310) {
		_serSysEncSQN_SystemInformationBlockType20_r13(_buffer, _size, _lidx, &p->sib20_v1310);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib21_v1430) {
		_serSysEncSQN_SystemInformationBlockType21_r14(_buffer, _size, _lidx, &p->sib21_v1430);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib24_v1530) {
		_serSysEncSQN_SystemInformationBlockType24_r15(_buffer, _size, _lidx, &p->sib24_v1530);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib25_v1530) {
		_serSysEncSQN_SystemInformationBlockType25_r15(_buffer, _size, _lidx, &p->sib25_v1530);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib26_v1530) {
		_serSysEncSQN_SystemInformationBlockType26_r15(_buffer, _size, _lidx, &p->sib26_v1530);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib26a_v1610) {
		_serSysEncSQN_SystemInformationBlockType26a_r16(_buffer, _size, _lidx, &p->sib26a_v1610);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib27_v1610) {
		_serSysEncSQN_SystemInformationBlockType27_r16(_buffer, _size, _lidx, &p->sib27_v1610);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib28_v1610) {
		_serSysEncSQN_SystemInformationBlockType28_r16(_buffer, _size, _lidx, &p->sib28_v1610);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib29_v1610) {
		_serSysEncSQN_SystemInformationBlockType29_r16(_buffer, _size, _lidx, &p->sib29_v1610);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_v8a0_IEs_nonCriticalExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformation_v8a0_IEs_nonCriticalExtension(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_v8a0_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_v8a0_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncOCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformation_v8a0_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_r8_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_r8_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->sib_TypeAndInfo.d, _lidx);
	for (size_t i1 = 0; i1 < p->sib_TypeAndInfo.d; i1++) {
		_serSysEncSQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s(_buffer, _size, _lidx, &p->sib_TypeAndInfo.v[i1]);
	}
	_serSysEncSQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockPos_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockPos_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->assistanceDataSIB_Element_r15.d, _lidx);
	for (size_t i2 = 0; i2 < p->assistanceDataSIB_Element_r15.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->assistanceDataSIB_Element_r15.v[i2], _lidx);
	}
	_serSysEncOCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value* p, enum SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_1_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib1_1_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_2_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib1_2_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_3_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib1_3_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_4_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib1_4_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_5_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib1_5_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_6_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib1_6_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_7_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib1_7_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_1_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_1_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_2_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_2_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_3_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_3_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_4_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_4_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_5_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_5_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_6_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_6_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_7_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_7_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_8_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_8_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_9_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_9_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_10_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_10_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_11_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_11_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_12_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_12_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_13_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_13_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_14_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_14_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_15_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_15_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_16_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_16_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_17_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_17_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_18_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_18_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_19_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib2_19_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib3_1_r15) {
		_serSysEncSQN_SystemInformationBlockPos_r15(_buffer, _size, _lidx, &p->posSib3_1_r15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSystemInformation_r15_IEs_nonCriticalExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PosSystemInformation_r15_IEs_nonCriticalExtension(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSystemInformation_r15_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSystemInformation_r15_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->posSIB_TypeAndInfo_r15.d, _lidx);
	for (size_t i1 = 0; i1 < p->posSIB_TypeAndInfo_r15.d; i1++) {
		_serSysEncSQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s(_buffer, _size, _lidx, &p->posSIB_TypeAndInfo_r15.v[i1]);
	}
	_serSysEncOCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value* p, enum SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_posSystemInformation_r15) {
		_serSysEncSQN_PosSystemInformation_r15_IEs(_buffer, _size, _lidx, &p->posSystemInformation_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture) {
		_serSysEncSQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture(_buffer, _size, _lidx, &p->criticalExtensionsFuture);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation_criticalExtensions_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformation_criticalExtensions_Value* p, enum SQN_SystemInformation_criticalExtensions_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformation_criticalExtensions_systemInformation_r8) {
		_serSysEncSQN_SystemInformation_r8_IEs(_buffer, _size, _lidx, &p->systemInformation_r8);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15) {
		_serSysEncSQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15(_buffer, _size, _lidx, &p->criticalExtensionsFuture_r15);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformation_criticalExtensions(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation_criticalExtensions* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformation_criticalExtensions_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformation(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformation* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformation_criticalExtensions(_buffer, _size, _lidx, &p->criticalExtensions);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 27; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_cellAccessRelatedInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_cellAccessRelatedInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->plmn_IdentityList.d, _lidx);
	for (size_t i1 = 0; i1 < p->plmn_IdentityList.d; i1++) {
		_serSysEncSQN_PLMN_IdentityInfo(_buffer, _size, _lidx, &p->plmn_IdentityList.v[i1]);
	}
	for (size_t i1 = 0; i1 < 16; i1++) {
		HTON_8(&_buffer[*_lidx], p->trackingAreaCode[i1], _lidx);
	}
	for (size_t i1 = 0; i1 < 28; i1++) {
		HTON_8(&_buffer[*_lidx], p->cellIdentity[i1], _lidx);
	}
	{
		size_t _tmp = (size_t)p->cellBarred;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->intraFreqReselection;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->csg_Indication, _lidx);
	_serSysEncSQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional(_buffer, _size, _lidx, &p->csg_Identity);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_cellSelectionInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_cellSelectionInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_RxLevMin, _lidx);
	_serSysEncUint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional(_buffer, _size, _lidx, &p->q_RxLevMinOffset);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_Max_SQN_SystemInformationBlockType1_p_Max_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_Max_SQN_SystemInformationBlockType1_p_Max_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SchedulingInfo(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SchedulingInfo* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->si_Periodicity;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->sib_MappingInfo.d, _lidx);
	for (size_t i2 = 0; i2 < p->sib_MappingInfo.d; i2++) {
		{
			size_t _tmp = (size_t)p->sib_MappingInfo.v[i2];
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_SQN_SystemInformationBlockType1_tdd_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_SQN_SystemInformationBlockType1_tdd_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncOCTET_STRING_SQN_SystemInformationBlockType1_v890_IEs_lateNonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct OCTET_STRING_SQN_SystemInformationBlockType1_v890_IEs_lateNonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_ims_EmergencySupport_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_ims_EmergencySupport_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfo_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfo_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_QualMin_r9, _lidx);
	_serSysEncUint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional(_buffer, _size, _lidx, &p->q_QualMinOffset_r9);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfo_v920_SQN_SystemInformationBlockType1_v920_IEs_cellSelectionInfo_v920_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfo_v920_SQN_SystemInformationBlockType1_v920_IEs_cellSelectionInfo_v920_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfo_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1130_SQN_SystemInformationBlockType1_v1130_IEs_tdd_Config_v1130_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1130_SQN_SystemInformationBlockType1_v1130_IEs_tdd_Config_v1130_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config_v1130(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfo_v1130(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfo_v1130* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_QualMinWB_r11, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfo_v1130_SQN_SystemInformationBlockType1_v1130_IEs_cellSelectionInfo_v1130_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfo_v1130_SQN_SystemInformationBlockType1_v1130_IEs_cellSelectionInfo_v1130_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfo_v1130(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional(_buffer, _size, _lidx, &p->category0Allowed_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfo_v1250(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfo_v1250* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->q_QualMinRSRQ_OnAllSymbols_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfo_v1250_SQN_SystemInformationBlockType1_v1250_IEs_cellSelectionInfo_v1250_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfo_v1250_SQN_SystemInformationBlockType1_v1250_IEs_cellSelectionInfo_v1250_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfo_v1250(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_freqBandIndicatorPriority_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_freqBandIndicatorPriority_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncB10_SQN_SystemInformationBlockType1_v1310_IEs_hyperSFN_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B10_SQN_SystemInformationBlockType1_v1310_IEs_hyperSFN_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 10; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_eDRX_Allowed_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_eDRX_Allowed_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType1_v1310_IEs_cellSelectionInfoCE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType1_v1310_IEs_cellSelectionInfoCE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SchedulingInfo_BR_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SchedulingInfo_BR_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->si_Narrowband_r13, _lidx);
	{
		size_t _tmp = (size_t)p->si_TBS_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_SchedulingInfo_BR_r13(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value* p, enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_subframePattern10_r13) {
		for (size_t i1 = 0; i1 < 10; i1++) {
			HTON_8(&_buffer[*_lidx], p->subframePattern10_r13[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_subframePattern40_r13) {
		for (size_t i1 = 0; i1 < 40; i1++) {
			HTON_8(&_buffer[*_lidx], p->subframePattern40_r13[i1], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncB10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct B10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 10; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->si_WindowLength_BR_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->si_RepetitionPattern_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional(_buffer, _size, _lidx, &p->schedulingInfoList_BR_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional(_buffer, _size, _lidx, &p->fdd_DownlinkOrTddSubframeBitmapBR_r13);
	_serSysEncB10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional(_buffer, _size, _lidx, &p->fdd_UplinkSubframeBitmapBR_r13);
	HTON_8(&_buffer[*_lidx], p->startSymbolBR_r13, _lidx);
	{
		size_t _tmp = (size_t)p->si_HoppingConfigCommon_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional(_buffer, _size, _lidx, &p->si_ValidityTime_r13);
	_serSysEncSQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional(_buffer, _size, _lidx, &p->systemInfoValueTagList_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_bandwidthReducedAccessRelatedInfo_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_bandwidthReducedAccessRelatedInfo_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_mpdcch_pdsch_HoppingNB_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_mpdcch_pdsch_HoppingNB_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value* p, enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_FDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_TDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_DLHoppingConfigCommonModeA_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_DLHoppingConfigCommonModeA_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value* p, enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_FDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13) {
		{
			size_t _tmp = (size_t)p->interval_TDD_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_DLHoppingConfigCommonModeB_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_DLHoppingConfigCommonModeB_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingOffset_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingOffset_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_mpdcch_pdsch_HoppingNB_r13_Optional(_buffer, _size, _lidx, &p->mpdcch_pdsch_HoppingNB_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_DLHoppingConfigCommonModeA_r13_Optional(_buffer, _size, _lidx, &p->interval_DLHoppingConfigCommonModeA_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_DLHoppingConfigCommonModeB_r13_Optional(_buffer, _size, _lidx, &p->interval_DLHoppingConfigCommonModeB_r13);
	_serSysEncUint8_t_SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingOffset_r13_Optional(_buffer, _size, _lidx, &p->mpdcch_pdsch_HoppingOffset_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_freqHoppingParametersDL_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_freqHoppingParametersDL_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType1_v1350_IEs_cellSelectionInfoCE1_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType1_v1350_IEs_cellSelectionInfoCE1_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE1_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType1_v1360_IEs_cellSelectionInfoCE1_v1360_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType1_v1360_IEs_cellSelectionInfoCE1_v1360_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE1_v1360(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e_eCallOverIMS_Support_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e_eCallOverIMS_Support_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->specialSubframePatterns_v1430;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1430_SQN_SystemInformationBlockType1_v1430_IEs_tdd_Config_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1430_SQN_SystemInformationBlockType1_v1430_IEs_tdd_Config_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellAccessRelatedInfo_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellAccessRelatedInfo_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->plmn_IdentityList_r14.d, _lidx);
	for (size_t i2 = 0; i2 < p->plmn_IdentityList_r14.d; i2++) {
		_serSysEncSQN_PLMN_IdentityInfo(_buffer, _size, _lidx, &p->plmn_IdentityList_r14.v[i2]);
	}
	for (size_t i2 = 0; i2 < 16; i2++) {
		HTON_8(&_buffer[*_lidx], p->trackingAreaCode_r14[i2], _lidx);
	}
	for (size_t i2 = 0; i2 < 28; i2++) {
		HTON_8(&_buffer[*_lidx], p->cellIdentity_r14[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellAccessRelatedInfo_r14_SQN_SystemInformationBlockType1_v1430_IEs_cellAccessRelatedInfoList_r14_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellAccessRelatedInfo_r14_SQN_SystemInformationBlockType1_v1430_IEs_cellAccessRelatedInfoList_r14_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_CellAccessRelatedInfo_r14(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1450(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1450* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->specialSubframePatterns_v1450;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_Config_v1450_SQN_SystemInformationBlockType1_v1450_IEs_tdd_Config_v1450_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_Config_v1450_SQN_SystemInformationBlockType1_v1450_IEs_tdd_Config_v1450_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_Config_v1450(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e_hsdn_Cell_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e_hsdn_Cell_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType1_v1530_IEs_cellSelectionInfoCE_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType1_v1530_IEs_cellSelectionInfoCE_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CellSelectionInfoCE_v1530(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Value* p, enum SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigEnabled) {
		HTON_8(&_buffer[*_lidx], p->crs_IntfMitigEnabled, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs) {
		{
			size_t _tmp = (size_t)p->crs_IntfMitigNumPRBs;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigConfig_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigConfig_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo_v1530(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo_v1530* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->cellReservedForOperatorUse_CRS_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityList_v1530_SQN_SystemInformationBlockType1_v1530_IEs_plmn_IdentityList_v1530_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityList_v1530_SQN_SystemInformationBlockType1_v1530_IEs_plmn_IdentityList_v1530_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_PLMN_IdentityInfo_v1530(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSIB_Type_r15_encrypted_r15_e_encrypted_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSIB_Type_r15_encrypted_r15_e_encrypted_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GNSS_ID_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GNSS_ID_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->gnss_id_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_GNSS_ID_r15_SQN_PosSIB_Type_r15_gnss_id_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_GNSS_ID_r15_SQN_PosSIB_Type_r15_gnss_id_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_GNSS_ID_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SBAS_ID_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SBAS_ID_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->sbas_id_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SBAS_ID_r15_SQN_PosSIB_Type_r15_sbas_id_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SBAS_ID_r15_SQN_PosSIB_Type_r15_sbas_id_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SBAS_ID_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSIB_Type_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSIB_Type_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PosSIB_Type_r15_encrypted_r15_e_encrypted_r15_Optional(_buffer, _size, _lidx, &p->encrypted_r15);
	_serSysEncSQN_GNSS_ID_r15_SQN_PosSIB_Type_r15_gnss_id_r15_Optional(_buffer, _size, _lidx, &p->gnss_id_r15);
	_serSysEncSQN_SBAS_ID_r15_SQN_PosSIB_Type_r15_sbas_id_r15_Optional(_buffer, _size, _lidx, &p->sbas_id_r15);
	{
		size_t _tmp = (size_t)p->posSibType_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSchedulingInfo_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSchedulingInfo_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->posSI_Periodicity_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->posSIB_MappingInfo_r15.d, _lidx);
	for (size_t i2 = 0; i2 < p->posSIB_MappingInfo_r15.d; i2++) {
		_serSysEncSQN_PosSIB_Type_r15(_buffer, _size, _lidx, &p->posSIB_MappingInfo_r15.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PosSchedulingInfoList_r15_SQN_SystemInformationBlockType1_v1530_IEs_posSchedulingInfoList_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PosSchedulingInfoList_r15_SQN_SystemInformationBlockType1_v1530_IEs_posSchedulingInfoList_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_PosSchedulingInfo_r15(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Value* p, enum SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_plmn_Identity_r15) {
		_serSysEncSQN_PLMN_Identity(_buffer, _size, _lidx, &p->plmn_Identity_r15);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_plmn_Index_r15) {
		HTON_8(&_buffer[*_lidx], p->plmn_Index_r15, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15(_buffer, _size, _lidx, &p->plmn_Identity_5GC_r15);
	{
		size_t _tmp = (size_t)p->cellReservedForOperatorUse_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->cellReservedForOperatorUse_CRS_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RAN_AreaCode_r15_SQN_CellAccessRelatedInfo_5GC_r15_ran_AreaCode_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RAN_AreaCode_r15_SQN_CellAccessRelatedInfo_5GC_r15_ran_AreaCode_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellIdentity_5GC_r15_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CellIdentity_5GC_r15_Value* p, enum SQN_CellIdentity_5GC_r15_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CellIdentity_5GC_r15_cellIdentity_r15) {
		for (size_t i2 = 0; i2 < 28; i2++) {
			HTON_8(&_buffer[*_lidx], p->cellIdentity_r15[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CellIdentity_5GC_r15_cellId_Index_r15) {
		HTON_8(&_buffer[*_lidx], p->cellId_Index_r15, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CellIdentity_5GC_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellIdentity_5GC_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CellIdentity_5GC_r15_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CellAccessRelatedInfo_5GC_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CellAccessRelatedInfo_5GC_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->plmn_IdentityList_r15.d, _lidx);
	for (size_t i2 = 0; i2 < p->plmn_IdentityList_r15.d; i2++) {
		_serSysEncSQN_PLMN_IdentityInfo_r15(_buffer, _size, _lidx, &p->plmn_IdentityList_r15.v[i2]);
	}
	_serSysEncSQN_RAN_AreaCode_r15_SQN_CellAccessRelatedInfo_5GC_r15_ran_AreaCode_r15_Optional(_buffer, _size, _lidx, &p->ran_AreaCode_r15);
	for (size_t i2 = 0; i2 < 24; i2++) {
		HTON_8(&_buffer[*_lidx], p->trackingAreaCode_5GC_r15[i2], _lidx);
	}
	_serSysEncSQN_CellIdentity_5GC_r15(_buffer, _size, _lidx, &p->cellIdentity_5GC_r15);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->cellBarred_5GC_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->cellBarred_5GC_CRS_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->cellAccessRelatedInfoList_5GC_r15.d, _lidx);
	for (size_t i1 = 0; i1 < p->cellAccessRelatedInfoList_5GC_r15.d; i1++) {
		_serSysEncSQN_CellAccessRelatedInfo_5GC_r15(_buffer, _size, _lidx, &p->cellAccessRelatedInfoList_5GC_r15.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellAccessRelatedInfo_5GC_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellAccessRelatedInfo_5GC_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e_ims_EmergencySupport5GC_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e_ims_EmergencySupport5GC_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e_eCallOverIMS_Support5GC_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e_eCallOverIMS_Support5GC_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e_si_posOffset_r15_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e_si_posOffset_r15_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e_eDRX_Allowed_5GC_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e_eDRX_Allowed_5GC_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e_transmissionInControlChRegion_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e_transmissionInControlChRegion_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e_campingAllowedInCE_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e_campingAllowedInCE_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e_cp_CIoT_5GS_Optimisation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e_cp_CIoT_5GS_Optimisation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e_up_CIoT_5GS_Optimisation_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e_up_CIoT_5GS_Optimisation_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e_iab_Support_r16_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e_iab_Support_r16_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityInfo_v1610(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityInfo_v1610* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e_cp_CIoT_5GS_Optimisation_r16_Optional(_buffer, _size, _lidx, &p->cp_CIoT_5GS_Optimisation_r16);
	_serSysEncSQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e_up_CIoT_5GS_Optimisation_r16_Optional(_buffer, _size, _lidx, &p->up_CIoT_5GS_Optimisation_r16);
	_serSysEncSQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e_iab_Support_r16_Optional(_buffer, _size, _lidx, &p->iab_Support_r16);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PLMN_IdentityList_v1610_SQN_SystemInformationBlockType1_v1610_IEs_plmn_IdentityList_v1610_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PLMN_IdentityList_v1610_SQN_SystemInformationBlockType1_v1610_IEs_plmn_IdentityList_v1610_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_PLMN_IdentityInfo_v1610(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1610_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1610_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e_eDRX_Allowed_5GC_r16_Optional(_buffer, _size, _lidx, &p->eDRX_Allowed_5GC_r16);
	_serSysEncSQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e_transmissionInControlChRegion_r16_Optional(_buffer, _size, _lidx, &p->transmissionInControlChRegion_r16);
	_serSysEncSQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e_campingAllowedInCE_r16_Optional(_buffer, _size, _lidx, &p->campingAllowedInCE_r16);
	_serSysEncSQN_PLMN_IdentityList_v1610_SQN_SystemInformationBlockType1_v1610_IEs_plmn_IdentityList_v1610_Optional(_buffer, _size, _lidx, &p->plmn_IdentityList_v1610);
	_serSysEncSQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1610_IEs_SQN_SystemInformationBlockType1_v1540_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1610_IEs_SQN_SystemInformationBlockType1_v1540_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1610_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1540_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1540_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e_si_posOffset_r15_Optional(_buffer, _size, _lidx, &p->si_posOffset_r15);
	_serSysEncSQN_SystemInformationBlockType1_v1610_IEs_SQN_SystemInformationBlockType1_v1540_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1540_IEs_SQN_SystemInformationBlockType1_v1530_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1540_IEs_SQN_SystemInformationBlockType1_v1530_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1540_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e_hsdn_Cell_r15_Optional(_buffer, _size, _lidx, &p->hsdn_Cell_r15);
	_serSysEncSQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType1_v1530_IEs_cellSelectionInfoCE_v1530_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE_v1530);
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigConfig_r15_Optional(_buffer, _size, _lidx, &p->crs_IntfMitigConfig_r15);
	{
		size_t _tmp = (size_t)p->cellBarred_CRS_r15;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PLMN_IdentityList_v1530_SQN_SystemInformationBlockType1_v1530_IEs_plmn_IdentityList_v1530_Optional(_buffer, _size, _lidx, &p->plmn_IdentityList_v1530);
	_serSysEncSQN_PosSchedulingInfoList_r15_SQN_SystemInformationBlockType1_v1530_IEs_posSchedulingInfoList_r15_Optional(_buffer, _size, _lidx, &p->posSchedulingInfoList_r15);
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellAccessRelatedInfo_5GC_r15_Optional(_buffer, _size, _lidx, &p->cellAccessRelatedInfo_5GC_r15);
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e_ims_EmergencySupport5GC_r15_Optional(_buffer, _size, _lidx, &p->ims_EmergencySupport5GC_r15);
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e_eCallOverIMS_Support5GC_r15_Optional(_buffer, _size, _lidx, &p->eCallOverIMS_Support5GC_r15);
	_serSysEncSQN_SystemInformationBlockType1_v1540_IEs_SQN_SystemInformationBlockType1_v1530_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1530_IEs_SQN_SystemInformationBlockType1_v1450_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1530_IEs_SQN_SystemInformationBlockType1_v1450_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1450_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1450_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TDD_Config_v1450_SQN_SystemInformationBlockType1_v1450_IEs_tdd_Config_v1450_Optional(_buffer, _size, _lidx, &p->tdd_Config_v1450);
	_serSysEncSQN_SystemInformationBlockType1_v1530_IEs_SQN_SystemInformationBlockType1_v1450_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1450_IEs_SQN_SystemInformationBlockType1_v1430_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1450_IEs_SQN_SystemInformationBlockType1_v1430_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1450_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1430_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1430_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e_eCallOverIMS_Support_r14_Optional(_buffer, _size, _lidx, &p->eCallOverIMS_Support_r14);
	_serSysEncSQN_TDD_Config_v1430_SQN_SystemInformationBlockType1_v1430_IEs_tdd_Config_v1430_Optional(_buffer, _size, _lidx, &p->tdd_Config_v1430);
	_serSysEncSQN_CellAccessRelatedInfo_r14_SQN_SystemInformationBlockType1_v1430_IEs_cellAccessRelatedInfoList_r14_DynamicOptional(_buffer, _size, _lidx, &p->cellAccessRelatedInfoList_r14);
	_serSysEncSQN_SystemInformationBlockType1_v1450_IEs_SQN_SystemInformationBlockType1_v1430_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1430_IEs_SQN_SystemInformationBlockType1_v1360_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1430_IEs_SQN_SystemInformationBlockType1_v1360_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1430_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1360_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1360_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType1_v1360_IEs_cellSelectionInfoCE1_v1360_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE1_v1360);
	_serSysEncSQN_SystemInformationBlockType1_v1430_IEs_SQN_SystemInformationBlockType1_v1360_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1360_IEs_SQN_SystemInformationBlockType1_v1350_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1360_IEs_SQN_SystemInformationBlockType1_v1350_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1360_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1350_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1350_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType1_v1350_IEs_cellSelectionInfoCE1_r13_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE1_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1360_IEs_SQN_SystemInformationBlockType1_v1350_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1350_IEs_SQN_SystemInformationBlockType1_v1320_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1350_IEs_SQN_SystemInformationBlockType1_v1320_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1350_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_freqHoppingParametersDL_r13_Optional(_buffer, _size, _lidx, &p->freqHoppingParametersDL_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1350_IEs_SQN_SystemInformationBlockType1_v1320_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1320_IEs_SQN_SystemInformationBlockType1_v1310_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1320_IEs_SQN_SystemInformationBlockType1_v1310_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncB10_SQN_SystemInformationBlockType1_v1310_IEs_hyperSFN_r13_Optional(_buffer, _size, _lidx, &p->hyperSFN_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_eDRX_Allowed_r13_Optional(_buffer, _size, _lidx, &p->eDRX_Allowed_r13);
	_serSysEncSQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType1_v1310_IEs_cellSelectionInfoCE_r13_Optional(_buffer, _size, _lidx, &p->cellSelectionInfoCE_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_bandwidthReducedAccessRelatedInfo_r13_Optional(_buffer, _size, _lidx, &p->bandwidthReducedAccessRelatedInfo_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1320_IEs_SQN_SystemInformationBlockType1_v1310_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1310_IEs_SQN_SystemInformationBlockType1_v1250_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1310_IEs_SQN_SystemInformationBlockType1_v1250_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1250_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1250_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250(_buffer, _size, _lidx, &p->cellAccessRelatedInfo_v1250);
	_serSysEncSQN_CellSelectionInfo_v1250_SQN_SystemInformationBlockType1_v1250_IEs_cellSelectionInfo_v1250_Optional(_buffer, _size, _lidx, &p->cellSelectionInfo_v1250);
	_serSysEncSQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_freqBandIndicatorPriority_r12_Optional(_buffer, _size, _lidx, &p->freqBandIndicatorPriority_r12);
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_SQN_SystemInformationBlockType1_v1250_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1250_IEs_SQN_SystemInformationBlockType1_v1130_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1250_IEs_SQN_SystemInformationBlockType1_v1130_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1250_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1130_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1130_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TDD_Config_v1130_SQN_SystemInformationBlockType1_v1130_IEs_tdd_Config_v1130_Optional(_buffer, _size, _lidx, &p->tdd_Config_v1130);
	_serSysEncSQN_CellSelectionInfo_v1130_SQN_SystemInformationBlockType1_v1130_IEs_cellSelectionInfo_v1130_Optional(_buffer, _size, _lidx, &p->cellSelectionInfo_v1130);
	_serSysEncSQN_SystemInformationBlockType1_v1250_IEs_SQN_SystemInformationBlockType1_v1130_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v1130_IEs_SQN_SystemInformationBlockType1_v920_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v1130_IEs_SQN_SystemInformationBlockType1_v920_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v1130_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v920_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v920_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_ims_EmergencySupport_r9_Optional(_buffer, _size, _lidx, &p->ims_EmergencySupport_r9);
	_serSysEncSQN_CellSelectionInfo_v920_SQN_SystemInformationBlockType1_v920_IEs_cellSelectionInfo_v920_Optional(_buffer, _size, _lidx, &p->cellSelectionInfo_v920);
	_serSysEncSQN_SystemInformationBlockType1_v1130_IEs_SQN_SystemInformationBlockType1_v920_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v920_IEs_SQN_SystemInformationBlockType1_v890_IEs_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v920_IEs_SQN_SystemInformationBlockType1_v890_IEs_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v920_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v890_IEs(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v890_IEs* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncOCTET_STRING_SQN_SystemInformationBlockType1_v890_IEs_lateNonCriticalExtension_Optional(_buffer, _size, _lidx, &p->lateNonCriticalExtension);
	_serSysEncSQN_SystemInformationBlockType1_v920_IEs_SQN_SystemInformationBlockType1_v890_IEs_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1_v890_IEs_SQN_SystemInformationBlockType1_nonCriticalExtension_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1_v890_IEs_SQN_SystemInformationBlockType1_nonCriticalExtension_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SystemInformationBlockType1_v890_IEs(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SystemInformationBlockType1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SystemInformationBlockType1* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SystemInformationBlockType1_cellAccessRelatedInfo(_buffer, _size, _lidx, &p->cellAccessRelatedInfo);
	_serSysEncSQN_SystemInformationBlockType1_cellSelectionInfo(_buffer, _size, _lidx, &p->cellSelectionInfo);
	_serSysEncSQN_P_Max_SQN_SystemInformationBlockType1_p_Max_Optional(_buffer, _size, _lidx, &p->p_Max);
	HTON_8(&_buffer[*_lidx], p->freqBandIndicator, _lidx);
	HTON_32(&_buffer[*_lidx], p->schedulingInfoList.d, _lidx);
	for (size_t i1 = 0; i1 < p->schedulingInfoList.d; i1++) {
		_serSysEncSQN_SchedulingInfo(_buffer, _size, _lidx, &p->schedulingInfoList.v[i1]);
	}
	_serSysEncSQN_TDD_Config_SQN_SystemInformationBlockType1_tdd_Config_Optional(_buffer, _size, _lidx, &p->tdd_Config);
	{
		size_t _tmp = (size_t)p->si_WindowLength;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->systemInfoValueTag, _lidx);
	_serSysEncSQN_SystemInformationBlockType1_v890_IEs_SQN_SystemInformationBlockType1_nonCriticalExtension_Optional(_buffer, _size, _lidx, &p->nonCriticalExtension);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_c1_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_BCCH_DL_SCH_MessageType_c1_Value* p, enum SQN_BCCH_DL_SCH_MessageType_c1_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_BCCH_DL_SCH_MessageType_c1_systemInformation) {
		_serSysEncSQN_SystemInformation(_buffer, _size, _lidx, &p->systemInformation);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_BCCH_DL_SCH_MessageType_c1_systemInformationBlockType1) {
		_serSysEncSQN_SystemInformationBlockType1(_buffer, _size, _lidx, &p->systemInformationBlockType1);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_c1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_MessageType_c1* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_BCCH_DL_SCH_MessageType_c1_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_messageClassExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_MessageType_messageClassExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_BCCH_DL_SCH_MessageType_Value* p, enum SQN_BCCH_DL_SCH_MessageType_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_BCCH_DL_SCH_MessageType_c1) {
		_serSysEncSQN_BCCH_DL_SCH_MessageType_c1(_buffer, _size, _lidx, &p->c1);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_BCCH_DL_SCH_MessageType_messageClassExtension) {
		_serSysEncSQN_BCCH_DL_SCH_MessageType_messageClassExtension(_buffer, _size, _lidx, &p->messageClassExtension);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_MessageType* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_BCCH_DL_SCH_MessageType_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_Message(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_Message* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_BCCH_DL_SCH_MessageType(_buffer, _size, _lidx, &p->message);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_Message_BcchInfo_Type_SIB1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_Message_BcchInfo_Type_SIB1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_BCCH_DL_SCH_Message(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSI_List_Type_SIs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SI_List_Type_SIs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_BCCH_DL_SCH_Message(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSegmentedSI_List_Type_SegmentedSIs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SegmentedSI_List_Type_SegmentedSIs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i1].d, _lidx);
		for (size_t i2 = 0; i2 < p->v.v[i1].d; i2++) {
			_serSysEncSQN_BCCH_DL_SCH_Message(_buffer, _size, _lidx, &p->v.v[i1].v[i2]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBcchInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BcchInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_BCCH_BCH_Message_BcchInfo_Type_MIB_Optional(_buffer, _size, _lidx, &p->MIB);
	_serSysEncSQN_BCCH_DL_SCH_Message_BcchInfo_Type_SIB1_Optional(_buffer, _size, _lidx, &p->SIB1);
	_serSysEncSI_List_Type_SIs_Optional(_buffer, _size, _lidx, &p->SIs);
	_serSysEncSegmentedSI_List_Type_SegmentedSIs_Optional(_buffer, _size, _lidx, &p->SegmentedSIs);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcchInfo_Type_BcchInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BcchInfo_Type_BcchInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBcchInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncNull_Type_BcchConfig_Type_StopSib1Transmission_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Null_Type_BcchConfig_Type_StopSib1Transmission_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BcchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncBcchToPbchConfig_Type_Pbch_Optional(_buffer, _size, _lidx, &p->Pbch);
	_serSysEncBcchToPdschConfig_Type_Pdsch_Optional(_buffer, _size, _lidx, &p->Pdsch);
	_serSysEncBcchInfo_Type_BcchInfo_Optional(_buffer, _size, _lidx, &p->BcchInfo);
	_serSysEncNull_Type_BcchConfig_Type_StopSib1Transmission_Optional(_buffer, _size, _lidx, &p->StopSib1Transmission);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcchConfig_Type_BcchConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BcchConfig_Type_BcchConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBcchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncDciDlInfoCommon_Type_PcchConfig_Type_DciInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct DciDlInfoCommon_Type_PcchConfig_Type_DciInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncDciDlInfoCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PCCH_Config_v1310_PCCH_Config_v13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PCCH_Config_v1310_PCCH_Config_v13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PCCH_Config_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPcchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PcchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncDciDlInfoCommon_Type_PcchConfig_Type_DciInfo_Optional(_buffer, _size, _lidx, &p->DciInfo);
	_serSysEncSQN_PCCH_Config_v1310_PCCH_Config_v13_Optional(_buffer, _size, _lidx, &p->PCCH_Config_v13);

	return SIDL_STATUS_OK;
}

static int _serSysEncPcchConfig_Type_PcchConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PcchConfig_Type_PcchConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPcchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncCA_CellInitialConfig_Type_CA_CellInitialConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CA_CellInitialConfig_Type_CA_CellInitialConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRToPbchConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRToPbchConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->EnableMIB_Repetition, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRToPbchConfig_Type_Pbch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRToPbchConfig_Type_Pbch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBcch_BRToPbchConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSib1_BRSchedul_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Sib1_BRSchedul_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->SchedulingInfoSIB1_BR_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSib1_BRSchedul_Type_Sib1_BRSchedul_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Sib1_BRSchedul_Type_Sib1_BRSchedul_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSib1_BRSchedul_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncBandwidthReducedAccessRelatedInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const BandwidthReducedAccessRelatedInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->si_WindowLength_BR_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->si_RepetitionPattern_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional(_buffer, _size, _lidx, &p->schedulingInfoList_BR_r13);
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional(_buffer, _size, _lidx, &p->fdd_DownlinkOrTddSubframeBitmapBR_r13);
	_serSysEncB10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional(_buffer, _size, _lidx, &p->fdd_UplinkSubframeBitmapBR_r13);
	HTON_8(&_buffer[*_lidx], p->startSymbolBR_r13, _lidx);
	{
		size_t _tmp = (size_t)p->si_HoppingConfigCommon_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional(_buffer, _size, _lidx, &p->si_ValidityTime_r13);
	_serSysEncSQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional(_buffer, _size, _lidx, &p->systemInfoValueTagList_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncBandwidthReducedAccessRelatedInfo_Type_SiSchedul_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BandwidthReducedAccessRelatedInfo_Type_SiSchedul_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBandwidthReducedAccessRelatedInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSI_SubframeOffsetList_Type_SubframeOffsetList_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SI_SubframeOffsetList_Type_SubframeOffsetList_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRToPdschConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRToPdschConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSib1_BRSchedul_Type_Sib1_BRSchedul_Optional(_buffer, _size, _lidx, &p->Sib1_BRSchedul);
	_serSysEncBandwidthReducedAccessRelatedInfo_Type_SiSchedul_Optional(_buffer, _size, _lidx, &p->SiSchedul);
	_serSysEncSI_SubframeOffsetList_Type_SubframeOffsetList_Optional(_buffer, _size, _lidx, &p->SubframeOffsetList);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRToPdschConfig_Type_Pdsch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRToPdschConfig_Type_Pdsch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBcch_BRToPdschConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_BCH_Message_Bcch_BRInfo_Type_MIB_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_BCH_Message_Bcch_BRInfo_Type_MIB_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_BCCH_BCH_Message(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Value* p, enum SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_systemInformation_BR_r13) {
		_serSysEncSQN_SystemInformation(_buffer, _size, _lidx, &p->systemInformation_BR_r13);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_systemInformationBlockType1_BR_r13) {
		_serSysEncSQN_SystemInformationBlockType1(_buffer, _size, _lidx, &p->systemInformationBlockType1_BR_r13);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_c1(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_MessageType_BR_r13_c1* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_messageClassExtension(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_MessageType_BR_r13_messageClassExtension* p)
{
	(void)_size; // TODO: generate boundaries checking

	(void)_buffer;
	(void)_size;
	(void)_lidx;
	(void)p;

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_BCCH_DL_SCH_MessageType_BR_r13_Value* p, enum SQN_BCCH_DL_SCH_MessageType_BR_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_BCCH_DL_SCH_MessageType_BR_r13_c1) {
		_serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_c1(_buffer, _size, _lidx, &p->c1);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_BCCH_DL_SCH_MessageType_BR_r13_messageClassExtension) {
		_serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_messageClassExtension(_buffer, _size, _lidx, &p->messageClassExtension);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_MessageType_BR_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_Message_BR(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_Message_BR* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_BCCH_DL_SCH_MessageType_BR_r13(_buffer, _size, _lidx, &p->message);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_BCCH_DL_SCH_Message_BR_Bcch_BRInfo_Type_SIB1_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_BCCH_DL_SCH_Message_BR_Bcch_BRInfo_Type_SIB1_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_BCCH_DL_SCH_Message_BR(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncBR_SI_List_Type_SIs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BR_SI_List_Type_SIs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_BCCH_DL_SCH_Message_BR(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBR_SegmentedSI_List_Type_SegmentedSIs_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BR_SegmentedSI_List_Type_SegmentedSIs_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i1].d, _lidx);
		for (size_t i2 = 0; i2 < p->v.v[i1].d; i2++) {
			_serSysEncSQN_BCCH_DL_SCH_Message_BR(_buffer, _size, _lidx, &p->v.v[i1].v[i2]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRInfo_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRInfo_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_BCCH_BCH_Message_Bcch_BRInfo_Type_MIB_Optional(_buffer, _size, _lidx, &p->MIB);
	_serSysEncSQN_BCCH_DL_SCH_Message_BR_Bcch_BRInfo_Type_SIB1_Optional(_buffer, _size, _lidx, &p->SIB1);
	_serSysEncBR_SI_List_Type_SIs_Optional(_buffer, _size, _lidx, &p->SIs);
	_serSysEncBR_SegmentedSI_List_Type_SegmentedSIs_Optional(_buffer, _size, _lidx, &p->SegmentedSIs);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRInfo_Type_BcchInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRInfo_Type_BcchInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBcch_BRInfo_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncNull_Type_Bcch_BRConfig_Type_StopSib1Transmission_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Null_Type_Bcch_BRConfig_Type_StopSib1Transmission_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncBcch_BRToPbchConfig_Type_Pbch_Optional(_buffer, _size, _lidx, &p->Pbch);
	_serSysEncBcch_BRToPdschConfig_Type_Pdsch_Optional(_buffer, _size, _lidx, &p->Pdsch);
	_serSysEncBcch_BRInfo_Type_BcchInfo_Optional(_buffer, _size, _lidx, &p->BcchInfo);
	_serSysEncNull_Type_Bcch_BRConfig_Type_StopSib1Transmission_Optional(_buffer, _size, _lidx, &p->StopSib1Transmission);

	return SIDL_STATUS_OK;
}

static int _serSysEncBcch_BRConfig_Type_BRBcchConfig_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct Bcch_BRConfig_Type_BRBcchConfig_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBcch_BRConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->subframeStartPosition_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	for (size_t i1 = 0; i1 < 8; i1++) {
		HTON_8(&_buffer[*_lidx], p->laa_SCellSubframeConfig_r13[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_r13_LAA_SCellConfiguration_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_r13_LAA_SCellConfiguration_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_LAA_SCellConfiguration_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CrossCarrierSchedulingConfigLAA_UL_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CrossCarrierSchedulingConfigLAA_UL_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->schedulingCellId_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->cif_InSchedulingCell_r14, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CrossCarrierSchedulingConfigLAA_UL_r14(_buffer, _size, _lidx, &p->crossCarrierSchedulingConfigLAA_UL_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Value* p, enum SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup) {
		_serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_crossCarrierSchedulingConfig_UL_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_crossCarrierSchedulingConfig_UL_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LBT_Config_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_LBT_Config_r14_Value* p, enum SQN_LBT_Config_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_LBT_Config_r14_maxEnergyDetectionThreshold_r14) {
		HTON_8(&_buffer[*_lidx], p->maxEnergyDetectionThreshold_r14, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_LBT_Config_r14_energyDetectionThresholdOffset_r14) {
		HTON_8(&_buffer[*_lidx], p->energyDetectionThresholdOffset_r14, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_LBT_Config_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LBT_Config_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_LBT_Config_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LBT_Config_r14_SQN_LAA_SCellConfiguration_v1430_lbt_Config_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LBT_Config_r14_SQN_LAA_SCellConfiguration_v1430_lbt_Config_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_LBT_Config_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_maxNumberOfSchedSubframes_Format0B_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_maxNumberOfSchedSubframes_Format0B_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_maxNumberOfSchedSubframes_Format4B_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_maxNumberOfSchedSubframes_Format4B_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e_skipMonitoringDCI_Format0A_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e_skipMonitoringDCI_Format0A_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e_skipMonitoringDCI_Format4A_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e_skipMonitoringDCI_Format4A_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductions_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductions_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL1_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL2_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL3_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL4_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL5_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductions_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PDCCH_CandidateReductions_r13_Value* p, enum SQN_PDCCH_CandidateReductions_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PDCCH_CandidateReductions_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PDCCH_CandidateReductions_r13_setup) {
		_serSysEncSQN_PDCCH_CandidateReductions_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PDCCH_CandidateReductions_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductions_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PDCCH_CandidateReductions_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductions_r13_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0A_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductions_r13_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0A_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PDCCH_CandidateReductions_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL1_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL2_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL3_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL4_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pdcch_candidateReductionAL5_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PDCCH_CandidateReductionsLAA_UL_r14_Value* p, enum SQN_PDCCH_CandidateReductionsLAA_UL_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PDCCH_CandidateReductionsLAA_UL_r14_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PDCCH_CandidateReductionsLAA_UL_r14_setup) {
		_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductionsLAA_UL_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4A_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4A_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0B_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0B_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4B_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4B_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_ConfigLAA_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_ConfigLAA_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_maxNumberOfSchedSubframes_Format0B_r14_Optional(_buffer, _size, _lidx, &p->maxNumberOfSchedSubframes_Format0B_r14);
	_serSysEncSQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_maxNumberOfSchedSubframes_Format4B_r14_Optional(_buffer, _size, _lidx, &p->maxNumberOfSchedSubframes_Format4B_r14);
	_serSysEncSQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e_skipMonitoringDCI_Format0A_r14_Optional(_buffer, _size, _lidx, &p->skipMonitoringDCI_Format0A_r14);
	_serSysEncSQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e_skipMonitoringDCI_Format4A_r14_Optional(_buffer, _size, _lidx, &p->skipMonitoringDCI_Format4A_r14);
	_serSysEncSQN_PDCCH_CandidateReductions_r13_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0A_r14_Optional(_buffer, _size, _lidx, &p->pdcch_CandidateReductions_Format0A_r14);
	_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4A_r14_Optional(_buffer, _size, _lidx, &p->pdcch_CandidateReductions_Format4A_r14);
	_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0B_r14_Optional(_buffer, _size, _lidx, &p->pdcch_CandidateReductions_Format0B_r14);
	_serSysEncSQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4B_r14_Optional(_buffer, _size, _lidx, &p->pdcch_CandidateReductions_Format4B_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PDCCH_ConfigLAA_r14_SQN_LAA_SCellConfiguration_v1430_pdcch_ConfigLAA_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PDCCH_ConfigLAA_r14_SQN_LAA_SCellConfiguration_v1430_pdcch_ConfigLAA_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PDCCH_ConfigLAA_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e_absenceOfAnyOtherTechnology_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e_absenceOfAnyOtherTechnology_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup_srs_SubframeIndication_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup_srs_SubframeIndication_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncUint8_t_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup_srs_SubframeIndication_r14_Optional(_buffer, _size, _lidx, &p->srs_SubframeIndication_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Value* p, enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup) {
		_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_SQN_LAA_SCellConfiguration_v1430_soundingRS_UL_ConfigDedicatedAperiodic_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_SQN_LAA_SCellConfiguration_v1430_soundingRS_UL_ConfigDedicatedAperiodic_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_crossCarrierSchedulingConfig_UL_r14_Optional(_buffer, _size, _lidx, &p->crossCarrierSchedulingConfig_UL_r14);
	_serSysEncSQN_LBT_Config_r14_SQN_LAA_SCellConfiguration_v1430_lbt_Config_r14_Optional(_buffer, _size, _lidx, &p->lbt_Config_r14);
	_serSysEncSQN_PDCCH_ConfigLAA_r14_SQN_LAA_SCellConfiguration_v1430_pdcch_ConfigLAA_r14_Optional(_buffer, _size, _lidx, &p->pdcch_ConfigLAA_r14);
	_serSysEncSQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e_absenceOfAnyOtherTechnology_r14_Optional(_buffer, _size, _lidx, &p->absenceOfAnyOtherTechnology_r14);
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_SQN_LAA_SCellConfiguration_v1430_soundingRS_UL_ConfigDedicatedAperiodic_v1430_Optional(_buffer, _size, _lidx, &p->soundingRS_UL_ConfigDedicatedAperiodic_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_LAA_SCellConfiguration_v1430_LAA_SCellConfiguration_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_LAA_SCellConfiguration_v1430_LAA_SCellConfiguration_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_LAA_SCellConfiguration_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncBasicCellConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BasicCellConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncCellConfigCapability_Type_ConfigCapability_Optional(_buffer, _size, _lidx, &p->ConfigCapability);
	_serSysEncStaticCellInfo_Type_StaticCellInfo_Optional(_buffer, _size, _lidx, &p->StaticCellInfo);
	_serSysEncPhysicalLayerConfigDL_Type_PhysicalLayerConfigDL_Optional(_buffer, _size, _lidx, &p->PhysicalLayerConfigDL);
	_serSysEncInitialCellPower_Type_InitialCellPower_Optional(_buffer, _size, _lidx, &p->InitialCellPower);
	_serSysEncBcchConfig_Type_BcchConfig_Optional(_buffer, _size, _lidx, &p->BcchConfig);
	_serSysEncPcchConfig_Type_PcchConfig_Optional(_buffer, _size, _lidx, &p->PcchConfig);
	_serSysEncCA_CellInitialConfig_Type_CA_CellInitialConfig_Optional(_buffer, _size, _lidx, &p->CA_CellInitialConfig);
	_serSysEncBcch_BRConfig_Type_BRBcchConfig_Optional(_buffer, _size, _lidx, &p->BRBcchConfig);
	_serSysEncSQN_LAA_SCellConfiguration_r13_LAA_SCellConfiguration_Optional(_buffer, _size, _lidx, &p->LAA_SCellConfiguration);
	_serSysEncSQN_LAA_SCellConfiguration_v1430_LAA_SCellConfiguration_v1430_Optional(_buffer, _size, _lidx, &p->LAA_SCellConfiguration_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncBasicCellConfig_Type_Basic_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct BasicCellConfig_Type_Basic_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncBasicCellConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_C_RNTI_C_RNTI_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_C_RNTI_C_RNTI_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	for (size_t i1 = 0; i1 < 16; i1++) {
		HTON_8(&_buffer[*_lidx], p->v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ConfigInfo_SQN_PRACH_Config_prach_ConfigInfo_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ConfigInfo_SQN_PRACH_Config_prach_ConfigInfo_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_ConfigInfo(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->rootSequenceIndex, _lidx);
	_serSysEncSQN_PRACH_ConfigInfo_SQN_PRACH_Config_prach_ConfigInfo_Optional(_buffer, _size, _lidx, &p->prach_ConfigInfo);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_RSRP_ThresholdsPrachInfoList_r13_SQN_PRACH_Config_v1310_rsrp_ThresholdsPrachInfoList_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_RSRP_ThresholdsPrachInfoList_r13_SQN_PRACH_Config_v1310_rsrp_ThresholdsPrachInfoList_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Value* p, enum SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13) {
		{
			size_t _tmp = (size_t)p->fdd_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13) {
		{
			size_t _tmp = (size_t)p->tdd_r13;
			HTON_32(&_buffer[*_lidx], _tmp, _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PRACH_Config_v1310_prach_HoppingOffset_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PRACH_Config_v1310_prach_HoppingOffset_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_ParametersListCE_r13_SQN_PRACH_Config_v1310_prach_ParametersListCE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_ParametersListCE_r13_SQN_PRACH_Config_v1310_prach_ParametersListCE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_PRACH_ParametersCE_r13(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PRACH_Config_v1310_initial_CE_level_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PRACH_Config_v1310_initial_CE_level_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_RSRP_ThresholdsPrachInfoList_r13_SQN_PRACH_Config_v1310_rsrp_ThresholdsPrachInfoList_r13_Optional(_buffer, _size, _lidx, &p->rsrp_ThresholdsPrachInfoList_r13);
	_serSysEncSQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional(_buffer, _size, _lidx, &p->mpdcch_startSF_CSS_RA_r13);
	_serSysEncUint8_t_SQN_PRACH_Config_v1310_prach_HoppingOffset_r13_Optional(_buffer, _size, _lidx, &p->prach_HoppingOffset_r13);
	_serSysEncSQN_PRACH_ParametersListCE_r13_SQN_PRACH_Config_v1310_prach_ParametersListCE_r13_Optional(_buffer, _size, _lidx, &p->prach_ParametersListCE_r13);
	_serSysEncUint8_t_SQN_PRACH_Config_v1310_initial_CE_level_r13_Optional(_buffer, _size, _lidx, &p->initial_CE_level_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config_v1310_prach_Config_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config_v1310_prach_Config_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_Config_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PRACH_Config_v1430_prach_Config_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PRACH_Config_v1430_prach_Config_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PRACH_Config_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPRACH_Config_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PRACH_Config_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PRACH_Config(_buffer, _size, _lidx, &p->prach_Config);
	_serSysEncSQN_PRACH_Config_v1310_prach_Config_v1310_Optional(_buffer, _size, _lidx, &p->prach_Config_v1310);
	_serSysEncSQN_PRACH_Config_v1430_prach_Config_v1430_Optional(_buffer, _size, _lidx, &p->prach_Config_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncPRACH_Config_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union PRACH_Config_Type_Value* p, enum PRACH_Config_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == PRACH_Config_Type_R8andLater) {
		_serSysEncPRACH_Config_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncPRACH_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PRACH_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncPRACH_Config_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncPRACH_Config_Type_Prach_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PRACH_Config_Type_Prach_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPRACH_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_ConfigCommon_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigCommon_v1310_pucch_ConfigCommon_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigCommon_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_ConfigCommon_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_ConfigCommon_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigCommon(_buffer, _size, _lidx, &p->pucch_ConfigCommon);
	_serSysEncSQN_PUCCH_ConfigCommon_v1310_pucch_ConfigCommon_v1310_Optional(_buffer, _size, _lidx, &p->pucch_ConfigCommon_v1310);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_ConfigCommon_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union PUCCH_ConfigCommon_Type_Value* p, enum PUCCH_ConfigCommon_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == PUCCH_ConfigCommon_Type_R8andLater) {
		_serSysEncPUCCH_ConfigCommon_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncPUCCH_ConfigCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_ConfigCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncPUCCH_ConfigCommon_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_ConfigCommon_Type_Common_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_ConfigCommon_Type_Common_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPUCCH_ConfigCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_ackNackRepetition_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->repetitionFactor;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN_Rep, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_ackNackRepetition_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_ackNackRepetition_Value* p, enum SQN_PUCCH_ConfigDedicated_ackNackRepetition_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_ackNackRepetition_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_ackNackRepetition_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_ackNackRepetition(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_ackNackRepetition* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_ackNackRepetition_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e_tdd_AckNackFeedbackMode_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e_tdd_AckNackFeedbackMode_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_ackNackRepetition(_buffer, _size, _lidx, &p->ackNackRepetition);
	_serSysEncSQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e_tdd_AckNackFeedbackMode_Optional(_buffer, _size, _lidx, &p->tdd_AckNackFeedbackMode);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_PUCCH_Format3_Conf_r13_n3PUCCH_AN_List_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_PUCCH_Format3_Conf_r13_n3PUCCH_AN_List_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->n3PUCCH_AN_ListP1_r13.d, _lidx);
	for (size_t i1 = 0; i1 < p->n3PUCCH_AN_ListP1_r13.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->n3PUCCH_AN_ListP1_r13.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value* p, enum SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup) {
		_serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_Format3_Conf_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_Format3_Conf_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncUint16_t_SQN_PUCCH_Format3_Conf_r13_n3PUCCH_AN_List_r13_DynamicOptional(_buffer, _size, _lidx, &p->n3PUCCH_AN_List_r13);
	_serSysEncSQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional(_buffer, _size, _lidx, &p->twoAntennaPortActivatedPUCCH_Format3_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->n1PUCCH_AN_CS_List_r10.d, _lidx);
	for (size_t i1 = 0; i1 < p->n1PUCCH_AN_CS_List_r10.d; i1++) {
		HTON_32(&_buffer[*_lidx], p->n1PUCCH_AN_CS_List_r10.v[i1].d, _lidx);
		for (size_t i2 = 0; i2 < p->n1PUCCH_AN_CS_List_r10.v[i1].d; i2++) {
			HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN_CS_List_r10.v[i1].v[i2], _lidx);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Value* p, enum SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_r10_Optional(_buffer, _size, _lidx, &p->n1PUCCH_AN_CS_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Value* p, enum SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_format3_r10) {
		_serSysEncSQN_PUCCH_Format3_Conf_r13(_buffer, _size, _lidx, &p->format3_r10);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10) {
		_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10(_buffer, _size, _lidx, &p->channelSelection_r10);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_pucch_Format_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_pucch_Format_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e_twoAntennaPortActivatedPUCCH_Format1a1b_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e_twoAntennaPortActivatedPUCCH_Format1a1b_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e_simultaneousPUCCH_PUSCH_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e_simultaneousPUCCH_PUSCH_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_PUCCH_ConfigDedicated_v1020_n1PUCCH_AN_RepP1_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_PUCCH_ConfigDedicated_v1020_n1PUCCH_AN_RepP1_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_pucch_Format_r10_Optional(_buffer, _size, _lidx, &p->pucch_Format_r10);
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e_twoAntennaPortActivatedPUCCH_Format1a1b_r10_Optional(_buffer, _size, _lidx, &p->twoAntennaPortActivatedPUCCH_Format1a1b_r10);
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e_simultaneousPUCCH_PUSCH_r10_Optional(_buffer, _size, _lidx, &p->simultaneousPUCCH_PUSCH_r10);
	_serSysEncUint16_t_SQN_PUCCH_ConfigDedicated_v1020_n1PUCCH_AN_RepP1_r10_Optional(_buffer, _size, _lidx, &p->n1PUCCH_AN_RepP1_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_ConfigDedicated_v1020_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1020_pucch_ConfigDedicated_v1020_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->n1PUCCH_AN_CS_ListP1_r11.d, _lidx);
	for (size_t i1 = 0; i1 < p->n1PUCCH_AN_CS_ListP1_r11.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN_CS_ListP1_r11.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Value* p, enum SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_n1PUCCH_AN_CS_v1130_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_n1PUCCH_AN_CS_v1130_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->nPUCCH_Identity_r11, _lidx);
	HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN_r11, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Value* p, enum SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_nPUCCH_Param_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_nPUCCH_Param_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_n1PUCCH_AN_CS_v1130_Optional(_buffer, _size, _lidx, &p->n1PUCCH_AN_CS_v1130);
	_serSysEncSQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_nPUCCH_Param_r11_Optional(_buffer, _size, _lidx, &p->nPUCCH_Param_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1130_pucch_ConfigDedicated_v1130_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1130_pucch_ConfigDedicated_v1130_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_v1130(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->nkaPUCCH_AN_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Value* p, enum SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1250(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1250* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12(_buffer, _size, _lidx, &p->nkaPUCCH_Param_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_v1250_pucch_ConfigDedicated_v1250_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_v1250_pucch_ConfigDedicated_v1250_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_v1250(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_ConfigDedicated_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_ConfigDedicated_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated(_buffer, _size, _lidx, &p->pucch_ConfigDedicated);
	_serSysEncSQN_PUCCH_ConfigDedicated_v1020_pucch_ConfigDedicated_v1020_Optional(_buffer, _size, _lidx, &p->pucch_ConfigDedicated_v1020);
	_serSysEncSQN_PUCCH_ConfigDedicated_v1130_pucch_ConfigDedicated_v1130_Optional(_buffer, _size, _lidx, &p->pucch_ConfigDedicated_v1130);
	_serSysEncSQN_PUCCH_ConfigDedicated_v1250_pucch_ConfigDedicated_v1250_Optional(_buffer, _size, _lidx, &p->pucch_ConfigDedicated_v1250);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->repetitionFactor_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN_Rep_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e_tdd_AckNackFeedbackMode_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e_tdd_AckNackFeedbackMode_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_n3PUCCH_AN_List_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_n3PUCCH_AN_List_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->n3PUCCH_AN_ListP1_r13.d, _lidx);
	for (size_t i1 = 0; i1 < p->n3PUCCH_AN_ListP1_r13.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->n3PUCCH_AN_ListP1_r13.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncUint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_n3PUCCH_AN_List_r13_DynamicOptional(_buffer, _size, _lidx, &p->n3PUCCH_AN_List_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional(_buffer, _size, _lidx, &p->twoAntennaPortActivatedPUCCH_Format3_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->n1PUCCH_AN_CS_List_r13.d, _lidx);
	for (size_t i1 = 0; i1 < p->n1PUCCH_AN_CS_List_r13.d; i1++) {
		HTON_32(&_buffer[*_lidx], p->n1PUCCH_AN_CS_List_r13.v[i1].d, _lidx);
		for (size_t i2 = 0; i2 < p->n1PUCCH_AN_CS_List_r13.v[i1].d; i2++) {
			HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN_CS_List_r13.v[i1].v[i2], _lidx);
		}
	}
	HTON_32(&_buffer[*_lidx], p->dummy1.d, _lidx);
	for (size_t i1 = 0; i1 < p->dummy1.d; i1++) {
		HTON_16(&_buffer[*_lidx], p->dummy1.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_n1PUCCH_AN_CS_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_n1PUCCH_AN_CS_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_n1PUCCH_AN_CS_r13_Optional(_buffer, _size, _lidx, &p->n1PUCCH_AN_CS_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Format4_resource_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Format4_resource_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->startingPRB_format4_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->numberOfPRB_format4_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Format4_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13_format4_MultiCSI_resourceConfiguration_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Format4_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13_format4_MultiCSI_resourceConfiguration_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_Format4_resource_r13(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i1 = 0; i1 < 4; i1++) {
		_serSysEncSQN_Format4_resource_r13(_buffer, _size, _lidx, &p->format4_resourceConfiguration_r13[i1]);
	}
	_serSysEncSQN_Format4_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13_format4_MultiCSI_resourceConfiguration_r13_DynamicOptional(_buffer, _size, _lidx, &p->format4_MultiCSI_resourceConfiguration_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Format5_resource_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Format5_resource_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->startingPRB_format5_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->cdm_index_format5_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Format5_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13_format5_MultiCSI_resourceConfiguration_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Format5_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13_format5_MultiCSI_resourceConfiguration_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_Format5_resource_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i1 = 0; i1 < 4; i1++) {
		_serSysEncSQN_Format5_resource_r13(_buffer, _size, _lidx, &p->format5_resourceConfiguration_r13[i1]);
	}
	_serSysEncSQN_Format5_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13_format5_MultiCSI_resourceConfiguration_r13_Optional(_buffer, _size, _lidx, &p->format5_MultiCSI_resourceConfiguration_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13(_buffer, _size, _lidx, &p->format3_r13);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13(_buffer, _size, _lidx, &p->channelSelection_r13);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13(_buffer, _size, _lidx, &p->format4_r13);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13(_buffer, _size, _lidx, &p->format5_r13);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_pucch_Format_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_pucch_Format_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e_twoAntennaPortActivatedPUCCH_Format1a1b_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e_twoAntennaPortActivatedPUCCH_Format1a1b_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e_simultaneousPUCCH_PUSCH_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e_simultaneousPUCCH_PUSCH_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_PUCCH_ConfigDedicated_r13_n1PUCCH_AN_RepP1_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_n1PUCCH_AN_RepP1_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->nPUCCH_Identity_r13, _lidx);
	HTON_16(&_buffer[*_lidx], p->n1PUCCH_AN_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_nPUCCH_Param_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_nPUCCH_Param_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->nkaPUCCH_AN_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_nkaPUCCH_Param_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_nkaPUCCH_Param_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e_codebooksizeDetermination_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e_codebooksizeDetermination_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PUCCH_ConfigDedicated_r13_maximumPayloadCoderate_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PUCCH_ConfigDedicated_r13_maximumPayloadCoderate_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->pucch_NumRepetitionCE_format1_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pucch_NumRepetitionCE_format2_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->pucch_NumRepetitionCE_format1_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->pucch_NumRepetitionCE_format2_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA(_buffer, _size, _lidx, &p->modeA);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB(_buffer, _size, _lidx, &p->modeB);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Value* p, enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup) {
		_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_pucch_NumRepetitionCE_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_pucch_NumRepetitionCE_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUCCH_ConfigDedicated_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUCCH_ConfigDedicated_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13(_buffer, _size, _lidx, &p->ackNackRepetition_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e_tdd_AckNackFeedbackMode_r13_Optional(_buffer, _size, _lidx, &p->tdd_AckNackFeedbackMode_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_pucch_Format_r13_Optional(_buffer, _size, _lidx, &p->pucch_Format_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e_twoAntennaPortActivatedPUCCH_Format1a1b_r13_Optional(_buffer, _size, _lidx, &p->twoAntennaPortActivatedPUCCH_Format1a1b_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e_simultaneousPUCCH_PUSCH_r13_Optional(_buffer, _size, _lidx, &p->simultaneousPUCCH_PUSCH_r13);
	_serSysEncUint16_t_SQN_PUCCH_ConfigDedicated_r13_n1PUCCH_AN_RepP1_r13_Optional(_buffer, _size, _lidx, &p->n1PUCCH_AN_RepP1_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_nPUCCH_Param_r13_Optional(_buffer, _size, _lidx, &p->nPUCCH_Param_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_nkaPUCCH_Param_r13_Optional(_buffer, _size, _lidx, &p->nkaPUCCH_Param_r13);
	HTON_8(&_buffer[*_lidx], p->spatialBundlingPUCCH_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->spatialBundlingPUSCH_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->harq_TimingTDD_r13, _lidx);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e_codebooksizeDetermination_r13_Optional(_buffer, _size, _lidx, &p->codebooksizeDetermination_r13);
	_serSysEncUint8_t_SQN_PUCCH_ConfigDedicated_r13_maximumPayloadCoderate_r13_Optional(_buffer, _size, _lidx, &p->maximumPayloadCoderate_r13);
	_serSysEncSQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_pucch_NumRepetitionCE_r13_Optional(_buffer, _size, _lidx, &p->pucch_NumRepetitionCE_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_ConfigDedicated_R13andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_ConfigDedicated_R13andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUCCH_ConfigDedicated_r13(_buffer, _size, _lidx, &p->pucch_ConfigDedicated_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_ConfigDedicated_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union PUCCH_ConfigDedicated_Type_Value* p, enum PUCCH_ConfigDedicated_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == PUCCH_ConfigDedicated_Type_R8andLater) {
		_serSysEncPUCCH_ConfigDedicated_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}
	if (d == PUCCH_ConfigDedicated_Type_R13andLater) {
		_serSysEncPUCCH_ConfigDedicated_R13andLater_Type(_buffer, _size, _lidx, &p->R13andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncPUCCH_ConfigDedicated_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_ConfigDedicated_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncPUCCH_ConfigDedicated_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_ConfigDedicated_Type_Dedicated_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_ConfigDedicated_Type_Dedicated_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPUCCH_ConfigDedicated_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_Configuration_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_Configuration_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncPUCCH_ConfigCommon_Type_Common_Optional(_buffer, _size, _lidx, &p->Common);
	_serSysEncPUCCH_ConfigDedicated_Type_Dedicated_Optional(_buffer, _size, _lidx, &p->Dedicated);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUCCH_Configuration_Type_Pucch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUCCH_Configuration_Type_Pucch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPUCCH_Configuration_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1270_pusch_ConfigCommon_v1270_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1270_pusch_ConfigCommon_v1270_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigCommon_v1270(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigCommon_v1310_pusch_ConfigCommon_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigCommon_v1310_pusch_ConfigCommon_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigCommon_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_ConfigCommon_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_ConfigCommon_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigCommon(_buffer, _size, _lidx, &p->pusch_ConfigCommon);
	_serSysEncSQN_PUSCH_ConfigCommon_v1270_pusch_ConfigCommon_v1270_Optional(_buffer, _size, _lidx, &p->pusch_ConfigCommon_v1270);
	_serSysEncSQN_PUSCH_ConfigCommon_v1310_pusch_ConfigCommon_v1310_Optional(_buffer, _size, _lidx, &p->pusch_ConfigCommon_v1310);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_ConfigCommon_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union PUSCH_ConfigCommon_Type_Value* p, enum PUSCH_ConfigCommon_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == PUSCH_ConfigCommon_Type_R8andLater) {
		_serSysEncPUSCH_ConfigCommon_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncPUSCH_ConfigCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_ConfigCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncPUSCH_ConfigCommon_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_ConfigCommon_Type_Common_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_ConfigCommon_Type_Common_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPUSCH_ConfigCommon_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index_MC_r10, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index_MC_r10, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index_MC_r10, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10_betaOffsetMC_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10_betaOffsetMC_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e_groupHoppingDisabled_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e_groupHoppingDisabled_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e_dmrs_WithOCC_Activated_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e_dmrs_WithOCC_Activated_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1020(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1020* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10_betaOffsetMC_r10_Optional(_buffer, _size, _lidx, &p->betaOffsetMC_r10);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e_groupHoppingDisabled_r10_Optional(_buffer, _size, _lidx, &p->groupHoppingDisabled_r10);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e_dmrs_WithOCC_Activated_r10_Optional(_buffer, _size, _lidx, &p->dmrs_WithOCC_Activated_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1020_pusch_ConfigDedicated_v1020_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1020_pusch_ConfigDedicated_v1020_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_v1020(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->nPUSCH_Identity_r11, _lidx);
	HTON_16(&_buffer[*_lidx], p->nDMRS_CSH_Identity_r11, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Value* p, enum SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup) {
		_serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1130(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1130* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11(_buffer, _size, _lidx, &p->pusch_DMRS_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_ConfigDedicated_v1130_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1130_pusch_ConfigDedicated_v1130_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_v1130(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index_MC_SubframeSet2_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index_MC_SubframeSet2_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index_MC_SubframeSet2_r12, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index_SubframeSet2_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index_SubframeSet2_r12, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index_SubframeSet2_r12, _lidx);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional(_buffer, _size, _lidx, &p->betaOffsetMC_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Value* p, enum SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup) {
		_serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1250(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1250* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH(_buffer, _size, _lidx, &p->uciOnPUSCH);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1250_pusch_ConfigDedicated_v1250_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1250_pusch_ConfigDedicated_v1250_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_v1250(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_ConfigDedicated_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_ConfigDedicated_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigDedicated(_buffer, _size, _lidx, &p->pusch_ConfigDedicated);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1020_pusch_ConfigDedicated_v1020_Optional(_buffer, _size, _lidx, &p->pusch_ConfigDedicated_v1020);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1130_pusch_ConfigDedicated_v1130_Optional(_buffer, _size, _lidx, &p->pusch_ConfigDedicated_v1130);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1250_pusch_ConfigDedicated_v1250_Optional(_buffer, _size, _lidx, &p->pusch_ConfigDedicated_v1250);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffset2_ACK_Index_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffset2_ACK_Index_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffset2_ACK_Index_MC_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffset2_ACK_Index_MC_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index_MC_r13, _lidx);
	_serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffset2_ACK_Index_MC_r13_Optional(_buffer, _size, _lidx, &p->betaOffset2_ACK_Index_MC_r13);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index_MC_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index_MC_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffsetMC_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffsetMC_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e_groupHoppingDisabled_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e_groupHoppingDisabled_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e_dmrs_WithOCC_Activated_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e_dmrs_WithOCC_Activated_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->nPUSCH_Identity_r13, _lidx);
	HTON_16(&_buffer[*_lidx], p->nDMRS_CSH_Identity_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Value* p, enum SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup) {
		_serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_pusch_DMRS_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_pusch_DMRS_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffset2_ACK_Index_SubframeSet2_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffset2_ACK_Index_SubframeSet2_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffset2_ACK_Index_MC_SubframeSet2_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffset2_ACK_Index_MC_SubframeSet2_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index_MC_SubframeSet2_r13, _lidx);
	_serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffset2_ACK_Index_MC_SubframeSet2_r13_Optional(_buffer, _size, _lidx, &p->betaOffset2_ACK_Index_MC_SubframeSet2_r13);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index_MC_SubframeSet2_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index_MC_SubframeSet2_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index_SubframeSet2_r13, _lidx);
	_serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffset2_ACK_Index_SubframeSet2_r13_Optional(_buffer, _size, _lidx, &p->betaOffset2_ACK_Index_SubframeSet2_r13);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index_SubframeSet2_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index_SubframeSet2_r13, _lidx);
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional(_buffer, _size, _lidx, &p->betaOffsetMC_r12);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Value* p, enum SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup) {
		_serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_uciOnPUSCH_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_uciOnPUSCH_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e_pusch_HoppingConfig_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e_pusch_HoppingConfig_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->betaOffset_ACK_Index_r13, _lidx);
	_serSysEncUint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffset2_ACK_Index_r13_Optional(_buffer, _size, _lidx, &p->betaOffset2_ACK_Index_r13);
	HTON_8(&_buffer[*_lidx], p->betaOffset_RI_Index_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->betaOffset_CQI_Index_r13, _lidx);
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffsetMC_r13_Optional(_buffer, _size, _lidx, &p->betaOffsetMC_r13);
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e_groupHoppingDisabled_r13_Optional(_buffer, _size, _lidx, &p->groupHoppingDisabled_r13);
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e_dmrs_WithOCC_Activated_r13_Optional(_buffer, _size, _lidx, &p->dmrs_WithOCC_Activated_r13);
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_pusch_DMRS_r11_Optional(_buffer, _size, _lidx, &p->pusch_DMRS_r11);
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_uciOnPUSCH_Optional(_buffer, _size, _lidx, &p->uciOnPUSCH);
	_serSysEncSQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e_pusch_HoppingConfig_r13_Optional(_buffer, _size, _lidx, &p->pusch_HoppingConfig_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e_ce_PUSCH_NB_MaxTBS_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e_ce_PUSCH_NB_MaxTBS_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e_ce_PUSCH_MaxBandwidth_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e_ce_PUSCH_MaxBandwidth_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_symPUSCH_UpPTS_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_symPUSCH_UpPTS_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e_dmrs_LessUpPTS_Config_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e_dmrs_LessUpPTS_Config_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_PUSCH_UpPTS_r14_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_PUSCH_UpPTS_r14_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_symPUSCH_UpPTS_r14_Optional(_buffer, _size, _lidx, &p->symPUSCH_UpPTS_r14);
	_serSysEncSQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e_dmrs_LessUpPTS_Config_r14_Optional(_buffer, _size, _lidx, &p->dmrs_LessUpPTS_Config_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_PUSCH_UpPTS_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_TDD_PUSCH_UpPTS_r14_Value* p, enum SQN_TDD_PUSCH_UpPTS_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_TDD_PUSCH_UpPTS_r14_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_TDD_PUSCH_UpPTS_r14_setup) {
		_serSysEncSQN_TDD_PUSCH_UpPTS_r14_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_TDD_PUSCH_UpPTS_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_PUSCH_UpPTS_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_TDD_PUSCH_UpPTS_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_TDD_PUSCH_UpPTS_r14_SQN_PUSCH_ConfigDedicated_v1430_tdd_PUSCH_UpPTS_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_TDD_PUSCH_UpPTS_r14_SQN_PUSCH_ConfigDedicated_v1430_tdd_PUSCH_UpPTS_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_TDD_PUSCH_UpPTS_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Enable256QAM_r14_setup_tpc_SubframeSet_Configured_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Enable256QAM_r14_setup_tpc_SubframeSet_Configured_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->subframeSet1_DCI_Format0_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->subframeSet1_DCI_Format4_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->subframeSet2_DCI_Format0_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->subframeSet2_DCI_Format4_r14, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Enable256QAM_r14_setup_tpc_SubframeSet_NotConfigured_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Enable256QAM_r14_setup_tpc_SubframeSet_NotConfigured_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->dci_Format0_r14, _lidx);
	HTON_8(&_buffer[*_lidx], p->dci_Format4_r14, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Enable256QAM_r14_setup_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_Enable256QAM_r14_setup_Value* p, enum SQN_Enable256QAM_r14_setup_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_Enable256QAM_r14_setup_tpc_SubframeSet_Configured_r14) {
		_serSysEncSQN_Enable256QAM_r14_setup_tpc_SubframeSet_Configured_r14(_buffer, _size, _lidx, &p->tpc_SubframeSet_Configured_r14);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_Enable256QAM_r14_setup_tpc_SubframeSet_NotConfigured_r14) {
		_serSysEncSQN_Enable256QAM_r14_setup_tpc_SubframeSet_NotConfigured_r14(_buffer, _size, _lidx, &p->tpc_SubframeSet_NotConfigured_r14);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_Enable256QAM_r14_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Enable256QAM_r14_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_Enable256QAM_r14_setup_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Enable256QAM_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_Enable256QAM_r14_Value* p, enum SQN_Enable256QAM_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_Enable256QAM_r14_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_Enable256QAM_r14_setup) {
		_serSysEncSQN_Enable256QAM_r14_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_Enable256QAM_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Enable256QAM_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_Enable256QAM_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_Enable256QAM_r14_SQN_PUSCH_ConfigDedicated_v1430_enable256QAM_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_Enable256QAM_r14_SQN_PUSCH_ConfigDedicated_v1430_enable256QAM_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_Enable256QAM_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e_ce_PUSCH_NB_MaxTBS_r14_Optional(_buffer, _size, _lidx, &p->ce_PUSCH_NB_MaxTBS_r14);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e_ce_PUSCH_MaxBandwidth_r14_Optional(_buffer, _size, _lidx, &p->ce_PUSCH_MaxBandwidth_r14);
	_serSysEncSQN_TDD_PUSCH_UpPTS_r14_SQN_PUSCH_ConfigDedicated_v1430_tdd_PUSCH_UpPTS_r14_Optional(_buffer, _size, _lidx, &p->tdd_PUSCH_UpPTS_r14);
	HTON_8(&_buffer[*_lidx], p->ul_DMRS_IFDMA_r14, _lidx);
	_serSysEncSQN_Enable256QAM_r14_SQN_PUSCH_ConfigDedicated_v1430_enable256QAM_r14_Optional(_buffer, _size, _lidx, &p->enable256QAM_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_PUSCH_ConfigDedicated_v1430_pusch_ConfigDedicated_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_PUSCH_ConfigDedicated_v1430_pusch_ConfigDedicated_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_PUSCH_ConfigDedicated_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_ConfigDedicated_R13andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_ConfigDedicated_R13andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_PUSCH_ConfigDedicated_r13(_buffer, _size, _lidx, &p->pusch_ConfigDedicated_r13);
	_serSysEncSQN_PUSCH_ConfigDedicated_v1430_pusch_ConfigDedicated_v1430_Optional(_buffer, _size, _lidx, &p->pusch_ConfigDedicated_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_ConfigDedicated_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union PUSCH_ConfigDedicated_Type_Value* p, enum PUSCH_ConfigDedicated_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == PUSCH_ConfigDedicated_Type_R8andLater) {
		_serSysEncPUSCH_ConfigDedicated_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}
	if (d == PUSCH_ConfigDedicated_Type_R13andLater) {
		_serSysEncPUSCH_ConfigDedicated_R13andLater_Type(_buffer, _size, _lidx, &p->R13andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncPUSCH_ConfigDedicated_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_ConfigDedicated_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncPUSCH_ConfigDedicated_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_ConfigDedicated_Type_Dedicated_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_ConfigDedicated_Type_Dedicated_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPUSCH_ConfigDedicated_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_Configuration_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_Configuration_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncPUSCH_ConfigCommon_Type_Common_Optional(_buffer, _size, _lidx, &p->Common);
	_serSysEncPUSCH_ConfigDedicated_Type_Dedicated_Optional(_buffer, _size, _lidx, &p->Dedicated);

	return SIDL_STATUS_OK;
}

static int _serSysEncPUSCH_Configuration_Type_Pusch_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct PUSCH_Configuration_Type_Pusch_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncPUSCH_Configuration_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSS_TimingAdvanceConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SS_TimingAdvanceConfig_Type_Value* p, enum SS_TimingAdvanceConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SS_TimingAdvanceConfig_Type_InitialValue) {
		HTON_16(&_buffer[*_lidx], p->InitialValue, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SS_TimingAdvanceConfig_Type_Relative) {
		HTON_8(&_buffer[*_lidx], p->Relative, _lidx);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSS_TimingAdvanceConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SS_TimingAdvanceConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSS_TimingAdvanceConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSS_TimingAdvanceConfig_Type_TimingAdvance_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SS_TimingAdvanceConfig_Type_TimingAdvance_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSS_TimingAdvanceConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSoundingRS_UL_ConfigCommon_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SoundingRS_UL_ConfigCommon_Type_Value* p, enum SoundingRS_UL_ConfigCommon_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SoundingRS_UL_ConfigCommon_Type_R8) {
		_serSysEncSQN_SoundingRS_UL_ConfigCommon(_buffer, _size, _lidx, &p->R8);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSoundingRS_UL_ConfigCommon_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SoundingRS_UL_ConfigCommon_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSoundingRS_UL_ConfigCommon_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicated_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicated_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->srs_Bandwidth;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->srs_HoppingBandwidth;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->freqDomainPosition, _lidx);
	HTON_8(&_buffer[*_lidx], p->duration, _lidx);
	HTON_16(&_buffer[*_lidx], p->srs_ConfigIndex, _lidx);
	HTON_8(&_buffer[*_lidx], p->transmissionComb, _lidx);
	{
		size_t _tmp = (size_t)p->cyclicShift;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicated_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SoundingRS_UL_ConfigDedicated_Value* p, enum SQN_SoundingRS_UL_ConfigDedicated_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SoundingRS_UL_ConfigDedicated_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SoundingRS_UL_ConfigDedicated_setup) {
		_serSysEncSQN_SoundingRS_UL_ConfigDedicated_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicated(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicated* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SoundingRS_UL_ConfigDedicated_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicated_soundingRS_UL_ConfigDedicated_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicated_soundingRS_UL_ConfigDedicated_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SoundingRS_UL_ConfigDedicated(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicated_v1020(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicated_v1020* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->srs_AntennaPort_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicated_v1020_soundingRS_UL_ConfigDedicated_v1020_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicated_v1020_soundingRS_UL_ConfigDedicated_v1020_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SoundingRS_UL_ConfigDedicated_v1020(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SRS_ConfigAp_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SRS_ConfigAp_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->srs_AntennaPortAp_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->srs_BandwidthAp_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->freqDomainPositionAp_r10, _lidx);
	HTON_8(&_buffer[*_lidx], p->transmissionCombAp_r10, _lidx);
	{
		size_t _tmp = (size_t)p->cyclicShiftAp_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SRS_ConfigAp_r10_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ConfigApDCI_Format4_r10_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SRS_ConfigAp_r10_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ConfigApDCI_Format4_r10_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_SRS_ConfigAp_r10(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SRS_ConfigAp_r10(_buffer, _size, _lidx, &p->srs_ConfigApDCI_Format0_r10);
	_serSysEncSQN_SRS_ConfigAp_r10(_buffer, _size, _lidx, &p->srs_ConfigApDCI_Format1a2b2c_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Value* p, enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_setup) {
		_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_srs_ActivateAp_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_srs_ActivateAp_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->srs_ConfigIndexAp_r10, _lidx);
	_serSysEncSQN_SRS_ConfigAp_r10_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ConfigApDCI_Format4_r10_DynamicOptional(_buffer, _size, _lidx, &p->srs_ConfigApDCI_Format4_r10);
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_srs_ActivateAp_r10_Optional(_buffer, _size, _lidx, &p->srs_ActivateAp_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Value* p, enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup) {
		_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_soundingRS_UL_ConfigDedicatedAperiodic_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_soundingRS_UL_ConfigDedicatedAperiodic_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSoundingRS_UL_ConfigDedicated_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SoundingRS_UL_ConfigDedicated_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SoundingRS_UL_ConfigDedicated_soundingRS_UL_ConfigDedicated_Optional(_buffer, _size, _lidx, &p->soundingRS_UL_ConfigDedicated);
	_serSysEncSQN_SoundingRS_UL_ConfigDedicated_v1020_soundingRS_UL_ConfigDedicated_v1020_Optional(_buffer, _size, _lidx, &p->soundingRS_UL_ConfigDedicated_v1020);
	_serSysEncSQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_soundingRS_UL_ConfigDedicatedAperiodic_r10_Optional(_buffer, _size, _lidx, &p->soundingRS_UL_ConfigDedicatedAperiodic_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSoundingRS_UL_ConfigDedicated_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SoundingRS_UL_ConfigDedicated_Type_Value* p, enum SoundingRS_UL_ConfigDedicated_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SoundingRS_UL_ConfigDedicated_Type_R8andLater) {
		_serSysEncSoundingRS_UL_ConfigDedicated_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSoundingRS_UL_ConfigDedicated_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SoundingRS_UL_ConfigDedicated_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSoundingRS_UL_ConfigDedicated_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSRS_UL_Config_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SRS_UL_Config_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSoundingRS_UL_ConfigCommon_Type(_buffer, _size, _lidx, &p->Common);
	_serSysEncSoundingRS_UL_ConfigDedicated_Type(_buffer, _size, _lidx, &p->Dedicated);

	return SIDL_STATUS_OK;
}

static int _serSysEncSRS_UL_Config_Type_SRS_UL_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SRS_UL_Config_Type_SRS_UL_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSRS_UL_Config_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SchedulingRequestConfig_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SchedulingRequestConfig_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->sr_PUCCH_ResourceIndex, _lidx);
	HTON_8(&_buffer[*_lidx], p->sr_ConfigIndex, _lidx);
	{
		size_t _tmp = (size_t)p->dsr_TransMax;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SchedulingRequestConfig_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_SchedulingRequestConfig_Value* p, enum SQN_SchedulingRequestConfig_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_SchedulingRequestConfig_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_SchedulingRequestConfig_setup) {
		_serSysEncSQN_SchedulingRequestConfig_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_SchedulingRequestConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SchedulingRequestConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_SchedulingRequestConfig_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_SchedulingRequestConfig_v1020_sr_PUCCH_ResourceIndexP1_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_SchedulingRequestConfig_v1020_sr_PUCCH_ResourceIndexP1_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SchedulingRequestConfig_v1020(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SchedulingRequestConfig_v1020* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncUint16_t_SQN_SchedulingRequestConfig_v1020_sr_PUCCH_ResourceIndexP1_r10_Optional(_buffer, _size, _lidx, &p->sr_PUCCH_ResourceIndexP1_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_SchedulingRequestConfig_v1020_schedulingRequestConfig_v1020_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_SchedulingRequestConfig_v1020_schedulingRequestConfig_v1020_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_SchedulingRequestConfig_v1020(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSchedulingRequestConfig_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SchedulingRequestConfig_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_SchedulingRequestConfig(_buffer, _size, _lidx, &p->schedulingRequestConfig);
	_serSysEncSQN_SchedulingRequestConfig_v1020_schedulingRequestConfig_v1020_Optional(_buffer, _size, _lidx, &p->schedulingRequestConfig_v1020);

	return SIDL_STATUS_OK;
}

static int _serSysEncSchedulingRequestConfig_Type_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SchedulingRequestConfig_Type_Value* p, enum SchedulingRequestConfig_Type_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SchedulingRequestConfig_Type_R8andLater) {
		_serSysEncSchedulingRequestConfig_R8andLater_Type(_buffer, _size, _lidx, &p->R8andLater);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSchedulingRequestConfig_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SchedulingRequestConfig_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSchedulingRequestConfig_Type_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSchedulingRequestConfig_Type_SR_Config_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SchedulingRequestConfig_Type_SR_Config_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSchedulingRequestConfig_Type(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportModeAperiodic_e_SQN_CQI_ReportConfig_cqi_ReportModeAperiodic_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportModeAperiodic_e_SQN_CQI_ReportConfig_cqi_ReportModeAperiodic_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_subbandCQI(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_subbandCQI* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->k, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Value* p, enum SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_widebandCQI) {
		HTON_8(&_buffer[*_lidx], p->widebandCQI, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_subbandCQI) {
		_serSysEncSQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_subbandCQI(_buffer, _size, _lidx, &p->subbandCQI);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_CQI_ReportPeriodic_setup_ri_ConfigIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_CQI_ReportPeriodic_setup_ri_ConfigIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->cqi_PUCCH_ResourceIndex, _lidx);
	HTON_16(&_buffer[*_lidx], p->cqi_pmi_ConfigIndex, _lidx);
	_serSysEncSQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic(_buffer, _size, _lidx, &p->cqi_FormatIndicatorPeriodic);
	_serSysEncUint16_t_SQN_CQI_ReportPeriodic_setup_ri_ConfigIndex_Optional(_buffer, _size, _lidx, &p->ri_ConfigIndex);
	HTON_8(&_buffer[*_lidx], p->simultaneousAckNackAndCQI, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportPeriodic_Value* p, enum SQN_CQI_ReportPeriodic_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportPeriodic_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportPeriodic_setup) {
		_serSysEncSQN_CQI_ReportPeriodic_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportPeriodic(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportPeriodic_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_SQN_CQI_ReportConfig_cqi_ReportPeriodic_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_SQN_CQI_ReportConfig_cqi_ReportPeriodic_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportPeriodic(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CQI_ReportModeAperiodic_e_SQN_CQI_ReportConfig_cqi_ReportModeAperiodic_Optional(_buffer, _size, _lidx, &p->cqi_ReportModeAperiodic);
	HTON_8(&_buffer[*_lidx], p->nomPDSCH_RS_EPRE_Offset, _lidx);
	_serSysEncSQN_CQI_ReportPeriodic_SQN_CQI_ReportConfig_cqi_ReportPeriodic_Optional(_buffer, _size, _lidx, &p->cqi_ReportPeriodic);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_v920_cqi_Mask_r9_e_cqi_Mask_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e_cqi_Mask_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_v920(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_v920* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CQI_ReportConfig_v920_cqi_Mask_r9_e_cqi_Mask_r9_Optional(_buffer, _size, _lidx, &p->cqi_Mask_r9);
	_serSysEncSQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional(_buffer, _size, _lidx, &p->pmi_RI_Report_r9);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_v920_cqi_ReportConfig_v920_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_v920_cqi_ReportConfig_v920_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportConfig_v920(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncCQI_ReportConfig_R8andLater_Type(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct CQI_ReportConfig_R8andLater_Type* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CQI_ReportConfig(_buffer, _size, _lidx, &p->cqi_ReportConfig);
	_serSysEncSQN_CQI_ReportConfig_v920_cqi_ReportConfig_v920_Optional(_buffer, _size, _lidx, &p->cqi_ReportConfig_v920);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	for (size_t i1 = 0; i1 < 8; i1++) {
		HTON_8(&_buffer[*_lidx], p->trigger1_r10[i1], _lidx);
	}
	for (size_t i1 = 0; i1 < 8; i1++) {
		HTON_8(&_buffer[*_lidx], p->trigger2_r10[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10_aperiodicCSI_Trigger_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10_aperiodicCSI_Trigger_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodic_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodic_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->cqi_ReportModeAperiodic_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10_aperiodicCSI_Trigger_r10_Optional(_buffer, _size, _lidx, &p->aperiodicCSI_Trigger_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodic_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportAperiodic_r10_Value* p, enum SQN_CQI_ReportAperiodic_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportAperiodic_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportAperiodic_r10_setup) {
		_serSysEncSQN_CQI_ReportAperiodic_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportAperiodic_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodic_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportAperiodic_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportAperiodic_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportAperiodic_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportAperiodic_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_CQI_ReportPeriodic_r10_setup_cqi_PUCCH_ResourceIndexP1_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_cqi_PUCCH_ResourceIndexP1_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e_csi_ReportMode_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e_csi_ReportMode_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e_csi_ReportMode_r10_Optional(_buffer, _size, _lidx, &p->csi_ReportMode_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->k, _lidx);
	{
		size_t _tmp = (size_t)p->periodicityFactor_r10;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Value* p, enum SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10) {
		_serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10(_buffer, _size, _lidx, &p->widebandCQI_r10);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10) {
		_serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10(_buffer, _size, _lidx, &p->subbandCQI_r10);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_CQI_ReportPeriodic_r10_setup_ri_ConfigIndex_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_ri_ConfigIndex_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e_cqi_Mask_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e_cqi_Mask_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup_ri_ConfigIndex2_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup_ri_ConfigIndex2_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->cqi_pmi_ConfigIndex2_r10, _lidx);
	_serSysEncUint16_t_SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup_ri_ConfigIndex2_r10_Optional(_buffer, _size, _lidx, &p->ri_ConfigIndex2_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Value* p, enum SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup) {
		_serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_csi_ConfigIndex_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_csi_ConfigIndex_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->cqi_PUCCH_ResourceIndex_r10, _lidx);
	_serSysEncUint16_t_SQN_CQI_ReportPeriodic_r10_setup_cqi_PUCCH_ResourceIndexP1_r10_Optional(_buffer, _size, _lidx, &p->cqi_PUCCH_ResourceIndexP1_r10);
	HTON_16(&_buffer[*_lidx], p->cqi_pmi_ConfigIndex, _lidx);
	_serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10(_buffer, _size, _lidx, &p->cqi_FormatIndicatorPeriodic_r10);
	_serSysEncUint16_t_SQN_CQI_ReportPeriodic_r10_setup_ri_ConfigIndex_Optional(_buffer, _size, _lidx, &p->ri_ConfigIndex);
	HTON_8(&_buffer[*_lidx], p->simultaneousAckNackAndCQI, _lidx);
	_serSysEncSQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e_cqi_Mask_r9_Optional(_buffer, _size, _lidx, &p->cqi_Mask_r9);
	_serSysEncSQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_csi_ConfigIndex_r10_Optional(_buffer, _size, _lidx, &p->csi_ConfigIndex_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportPeriodic_r10_Value* p, enum SQN_CQI_ReportPeriodic_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportPeriodic_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportPeriodic_r10_setup) {
		_serSysEncSQN_CQI_ReportPeriodic_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportPeriodic_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportPeriodic_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportPeriodic_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportPeriodic_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_MeasSubframePattern_r10(_buffer, _size, _lidx, &p->csi_MeasSubframeSet1_r10);
	_serSysEncSQN_MeasSubframePattern_r10(_buffer, _size, _lidx, &p->csi_MeasSubframeSet2_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Value* p, enum SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup) {
		_serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_csi_SubframePatternConfig_r10_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_csi_SubframePatternConfig_r10_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportConfig_r10(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportConfig_r10* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CQI_ReportAperiodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportAperiodic_r10_Optional(_buffer, _size, _lidx, &p->cqi_ReportAperiodic_r10);
	HTON_8(&_buffer[*_lidx], p->nomPDSCH_RS_EPRE_Offset, _lidx);
	_serSysEncSQN_CQI_ReportPeriodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportPeriodic_r10_Optional(_buffer, _size, _lidx, &p->cqi_ReportPeriodic_r10);
	_serSysEncSQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional(_buffer, _size, _lidx, &p->pmi_RI_Report_r9);
	_serSysEncSQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_csi_SubframePatternConfig_r10_Optional(_buffer, _size, _lidx, &p->csi_SubframePatternConfig_r10);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e_simultaneousAckNackAndCQI_Format3_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e_simultaneousAckNackAndCQI_Format3_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExtToReleaseList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToReleaseList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExtToReleaseList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToReleaseList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e_csi_ReportMode_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e_csi_ReportMode_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e_csi_ReportMode_r11_Optional(_buffer, _size, _lidx, &p->csi_ReportMode_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->k, _lidx);
	{
		size_t _tmp = (size_t)p->periodicityFactor_r11;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Value* p, enum SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11) {
		_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11(_buffer, _size, _lidx, &p->widebandCQI_r11);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11) {
		_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11(_buffer, _size, _lidx, &p->subbandCQI_r11);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_CQI_ReportPeriodicProcExt_r11_ri_ConfigIndex_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_CQI_ReportPeriodicProcExt_r11_ri_ConfigIndex_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup_ri_ConfigIndex2_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup_ri_ConfigIndex2_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->cqi_pmi_ConfigIndex2_r11, _lidx);
	_serSysEncUint16_t_SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup_ri_ConfigIndex2_r11_Optional(_buffer, _size, _lidx, &p->ri_ConfigIndex2_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Value* p, enum SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup) {
		_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_csi_ConfigIndex_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_csi_ConfigIndex_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CRI_ConfigIndex_r13_SQN_CRI_ReportConfig_r13_setup_cri_ConfigIndex2_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CRI_ConfigIndex_r13_SQN_CRI_ReportConfig_r13_setup_cri_ConfigIndex2_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CRI_ReportConfig_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CRI_ReportConfig_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_16(&_buffer[*_lidx], p->cri_ConfigIndex_r13, _lidx);
	_serSysEncSQN_CRI_ConfigIndex_r13_SQN_CRI_ReportConfig_r13_setup_cri_ConfigIndex2_r13_Optional(_buffer, _size, _lidx, &p->cri_ConfigIndex2_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CRI_ReportConfig_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CRI_ReportConfig_r13_Value* p, enum SQN_CRI_ReportConfig_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CRI_ReportConfig_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CRI_ReportConfig_r13_setup) {
		_serSysEncSQN_CRI_ReportConfig_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CRI_ReportConfig_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CRI_ReportConfig_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CRI_ReportConfig_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CRI_ReportConfig_r13_SQN_CQI_ReportPeriodicProcExt_r11_cri_ReportConfig_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CRI_ReportConfig_r13_SQN_CQI_ReportPeriodicProcExt_r11_cri_ReportConfig_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CRI_ReportConfig_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e_periodicityFactorWB_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e_periodicityFactorWB_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExt_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExt_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->cqi_ReportPeriodicProcExtId_r11, _lidx);
	HTON_16(&_buffer[*_lidx], p->cqi_pmi_ConfigIndex_r11, _lidx);
	_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11(_buffer, _size, _lidx, &p->cqi_FormatIndicatorPeriodic_r11);
	_serSysEncUint16_t_SQN_CQI_ReportPeriodicProcExt_r11_ri_ConfigIndex_r11_Optional(_buffer, _size, _lidx, &p->ri_ConfigIndex_r11);
	_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_csi_ConfigIndex_r11_Optional(_buffer, _size, _lidx, &p->csi_ConfigIndex_r11);
	_serSysEncSQN_CRI_ReportConfig_r13_SQN_CQI_ReportPeriodicProcExt_r11_cri_ReportConfig_r13_Optional(_buffer, _size, _lidx, &p->cri_ReportConfig_r13);
	_serSysEncSQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e_periodicityFactorWB_r13_Optional(_buffer, _size, _lidx, &p->periodicityFactorWB_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodicProcExtToAddModList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToAddModList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodicProcExtToAddModList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToAddModList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_CQI_ReportPeriodicProcExt_r11(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportPeriodic_v1130(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportPeriodic_v1130* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e_simultaneousAckNackAndCQI_Format3_r11_Optional(_buffer, _size, _lidx, &p->simultaneousAckNackAndCQI_Format3_r11);
	_serSysEncSQN_CQI_ReportPeriodicProcExtToReleaseList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToReleaseList_r11_Optional(_buffer, _size, _lidx, &p->cqi_ReportPeriodicProcExtToReleaseList_r11);
	_serSysEncSQN_CQI_ReportPeriodicProcExtToAddModList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToAddModList_r11_Optional(_buffer, _size, _lidx, &p->cqi_ReportPeriodicProcExtToAddModList_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_IM_ConfigToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToReleaseList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_IM_ConfigToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToReleaseList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBool_SQN_CSI_IM_Config_r11_interferenceMeasRestriction_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_CSI_IM_Config_r11_interferenceMeasRestriction_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_IM_Config_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_IM_Config_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->csi_IM_ConfigId_r11, _lidx);
	HTON_8(&_buffer[*_lidx], p->resourceConfig_r11, _lidx);
	HTON_8(&_buffer[*_lidx], p->subframeConfig_r11, _lidx);
	_serSysEncBool_SQN_CSI_IM_Config_r11_interferenceMeasRestriction_r13_Optional(_buffer, _size, _lidx, &p->interferenceMeasRestriction_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_IM_ConfigToAddModList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToAddModList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_IM_ConfigToAddModList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToAddModList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		_serSysEncSQN_CSI_IM_Config_r11(_buffer, _size, _lidx, &p->v.v[i1]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_ProcessToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_ProcessToReleaseList_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_ProcessToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_ProcessToReleaseList_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i1 = 0; i1 < p->v.d; i1++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i1], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->p_C_r11, _lidx);
	HTON_32(&_buffer[*_lidx], p->codebookSubsetRestriction_r11.d, _lidx);
	for (size_t i3 = 0; i3 < p->codebookSubsetRestriction_r11.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->codebookSubsetRestriction_r11.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_ProcessId_r11_SQN_CQI_ReportBothProc_r11_ri_Ref_CSI_ProcessId_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_ProcessId_r11_SQN_CQI_ReportBothProc_r11_ri_Ref_CSI_ProcessId_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e_pmi_RI_Report_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e_pmi_RI_Report_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportBothProc_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportBothProc_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSI_ProcessId_r11_SQN_CQI_ReportBothProc_r11_ri_Ref_CSI_ProcessId_r11_Optional(_buffer, _size, _lidx, &p->ri_Ref_CSI_ProcessId_r11);
	_serSysEncSQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e_pmi_RI_Report_r11_Optional(_buffer, _size, _lidx, &p->pmi_RI_Report_r11);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportBothProc_r11_SQN_CSI_Process_r11_cqi_ReportBothProc_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportBothProc_r11_SQN_CSI_Process_r11_cqi_ReportBothProc_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportBothProc_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint8_t_SQN_CSI_Process_r11_cqi_ReportPeriodicProcId_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint8_t_SQN_CSI_Process_r11_cqi_ReportPeriodicProcId_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodicProc_r11(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodicProc_r11* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->cqi_ReportModeAperiodic_r11;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->trigger01_r11, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger10_r11, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger11_r11, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodicProc_r11_SQN_CSI_Process_r11_cqi_ReportAperiodicProc_r11_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodicProc_r11_SQN_CSI_Process_r11_cqi_ReportAperiodicProc_r11_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CQI_ReportAperiodicProc_r11(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e_alternativeCodebookEnabledFor4TXProc_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e_alternativeCodebookEnabledFor4TXProc_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Value* p, enum SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_setup) {
		HTON_32(&_buffer[*_lidx], p->setup.d, _lidx);
		for (size_t i2 = 0; i2 < p->setup.d; i2++) {
			HTON_8(&_buffer[*_lidx], p->setup.v[i2], _lidx);
		}
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_Process_r11_csi_IM_ConfigIdList_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_csi_IM_ConfigIdList_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_csi_IM_ConfigIdList_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_Process_r11_csi_IM_ConfigIdList_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Value* p, enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_setup) {
		_serSysEncSQN_CQI_ReportAperiodicProc_r11(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_cqi_ReportAperiodicProc2_r12_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_cqi_ReportAperiodicProc2_r12_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CQI_ReportAperiodicProc_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CQI_ReportAperiodicProc_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->trigger001_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger010_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger011_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger100_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger101_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger110_r13, _lidx);
	HTON_8(&_buffer[*_lidx], p->trigger111_r13, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Value* p, enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_setup) {
		_serSysEncSQN_CQI_ReportAperiodicProc_v1310(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_cqi_ReportAperiodicProc_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_cqi_ReportAperiodicProc_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Value* p, enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_setup) {
		_serSysEncSQN_CQI_ReportAperiodicProc_v1310(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_cqi_ReportAperiodicProc2_v1310_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_cqi_ReportAperiodicProc2_v1310_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_nonPrecoded_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_nonPrecoded_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->codebookSubsetRestriction1_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->codebookSubsetRestriction1_r13.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->codebookSubsetRestriction1_r13.v[i3], _lidx);
	}
	HTON_32(&_buffer[*_lidx], p->codebookSubsetRestriction2_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->codebookSubsetRestriction2_r13.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->codebookSubsetRestriction2_r13.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedK1a_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedK1a_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->codebookSubsetRestriction3_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->codebookSubsetRestriction3_r13.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->codebookSubsetRestriction3_r13.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedKN_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedKN_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->codebookSubsetRestriction_r13.d, _lidx);
	for (size_t i3 = 0; i3 < p->codebookSubsetRestriction_r13.d; i3++) {
		HTON_8(&_buffer[*_lidx], p->codebookSubsetRestriction_r13.v[i3], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Value* p, enum SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_nonPrecoded_r13) {
		_serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_nonPrecoded_r13(_buffer, _size, _lidx, &p->nonPrecoded_r13);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedK1a_r13) {
		_serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedK1a_r13(_buffer, _size, _lidx, &p->beamformedK1a_r13);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedKN_r13) {
		_serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedKN_r13(_buffer, _size, _lidx, &p->beamformedKN_r13);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->p_C_r13, _lidx);
	_serSysEncSQN_P_C_AndCBSR_r13_cbsr_Selection_r13(_buffer, _size, _lidx, &p->cbsr_Selection_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_p_C_AndCBSRList_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_p_C_AndCBSRList_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_P_C_AndCBSR_r13(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e_codebookOverSamplingRateConfig_O1_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e_codebookOverSamplingRateConfig_O1_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e_codebookOverSamplingRateConfig_O2_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e_codebookOverSamplingRateConfig_O2_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_IM_ConfigIdList_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_IM_ConfigIdList_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NZP_TransmissionComb_r14_SQN_NZP_ResourceConfig_r13_transmissionComb_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NZP_TransmissionComb_r14_SQN_NZP_ResourceConfig_r13_transmissionComb_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NZP_FrequencyDensity_r14_e_SQN_NZP_ResourceConfig_r13_frequencyDensity_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NZP_FrequencyDensity_r14_e_SQN_NZP_ResourceConfig_r13_frequencyDensity_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NZP_ResourceConfig_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NZP_ResourceConfig_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->resourceConfig_r13, _lidx);
	_serSysEncSQN_NZP_TransmissionComb_r14_SQN_NZP_ResourceConfig_r13_transmissionComb_r14_Optional(_buffer, _size, _lidx, &p->transmissionComb_r14);
	_serSysEncSQN_NZP_FrequencyDensity_r14_e_SQN_NZP_ResourceConfig_r13_frequencyDensity_r14_Optional(_buffer, _size, _lidx, &p->frequencyDensity_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e_cdmType_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e_cdmType_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->nzp_resourceConfigList_r13.d, _lidx);
	for (size_t i2 = 0; i2 < p->nzp_resourceConfigList_r13.d; i2++) {
		_serSysEncSQN_NZP_ResourceConfig_r13(_buffer, _size, _lidx, &p->nzp_resourceConfigList_r13.v[i2]);
	}
	_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e_cdmType_r13_Optional(_buffer, _size, _lidx, &p->cdmType_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigNZP_EMIMO_r13_Value* p, enum SQN_CSI_RS_ConfigNZP_EMIMO_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigNZP_EMIMO_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup) {
		_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_EMIMO_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_RS_ConfigNZP_EMIMO_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_RS_ConfigNZP_EMIMO_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNonPrecoded_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNonPrecoded_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_p_C_AndCBSRList_r13_Optional(_buffer, _size, _lidx, &p->p_C_AndCBSRList_r13);
	{
		size_t _tmp = (size_t)p->codebookConfigN1_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->codebookConfigN2_r13;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e_codebookOverSamplingRateConfig_O1_r13_Optional(_buffer, _size, _lidx, &p->codebookOverSamplingRateConfig_O1_r13);
	_serSysEncSQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e_codebookOverSamplingRateConfig_O2_r13_Optional(_buffer, _size, _lidx, &p->codebookOverSamplingRateConfig_O2_r13);
	HTON_8(&_buffer[*_lidx], p->codebookConfig_r13, _lidx);
	_serSysEncSQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_IM_ConfigIdList_r13_DynamicOptional(_buffer, _size, _lidx, &p->csi_IM_ConfigIdList_r13);
	_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_RS_ConfigNZP_EMIMO_r13_Optional(_buffer, _size, _lidx, &p->csi_RS_ConfigNZP_EMIMO_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_RS_ConfigNZPIdListExt_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_RS_ConfigNZPIdListExt_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_IM_ConfigIdList_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_IM_ConfigIdList_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r13_p_C_AndCBSR_PerResourceConfigList_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r13_p_C_AndCBSR_PerResourceConfigList_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i2].d, _lidx);
		for (size_t i3 = 0; i3 < p->v.v[i2].d; i3++) {
			_serSysEncSQN_P_C_AndCBSR_r13(_buffer, _size, _lidx, &p->v.v[i2].v[i3]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBool_SQN_CSI_RS_ConfigBeamformed_r13_ace_For4Tx_PerResourceConfigList_r13_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_CSI_RS_ConfigBeamformed_r13_ace_For4Tx_PerResourceConfigList_r13_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e_alternativeCodebookEnabledBeamformed_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e_alternativeCodebookEnabledBeamformed_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e_channelMeasRestriction_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e_channelMeasRestriction_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigBeamformed_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigBeamformed_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_RS_ConfigNZPIdListExt_r13_DynamicOptional(_buffer, _size, _lidx, &p->csi_RS_ConfigNZPIdListExt_r13);
	_serSysEncSQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_IM_ConfigIdList_r13_DynamicOptional(_buffer, _size, _lidx, &p->csi_IM_ConfigIdList_r13);
	_serSysEncSQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r13_p_C_AndCBSR_PerResourceConfigList_r13_DynamicOptional(_buffer, _size, _lidx, &p->p_C_AndCBSR_PerResourceConfigList_r13);
	_serSysEncBool_SQN_CSI_RS_ConfigBeamformed_r13_ace_For4Tx_PerResourceConfigList_r13_DynamicOptional(_buffer, _size, _lidx, &p->ace_For4Tx_PerResourceConfigList_r13);
	_serSysEncSQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e_alternativeCodebookEnabledBeamformed_r13_Optional(_buffer, _size, _lidx, &p->alternativeCodebookEnabledBeamformed_r13);
	_serSysEncSQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e_channelMeasRestriction_r13_Optional(_buffer, _size, _lidx, &p->channelMeasRestriction_r13);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_r13_setup_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigEMIMO_r13_setup_Value* p, enum SQN_CSI_RS_ConfigEMIMO_r13_setup_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigEMIMO_r13_setup_nonPrecoded_r13) {
		_serSysEncSQN_CSI_RS_ConfigNonPrecoded_r13(_buffer, _size, _lidx, &p->nonPrecoded_r13);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigEMIMO_r13_setup_beamformed_r13) {
		_serSysEncSQN_CSI_RS_ConfigBeamformed_r13(_buffer, _size, _lidx, &p->beamformed_r13);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_r13_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO_r13_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigEMIMO_r13_setup_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_r13_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigEMIMO_r13_Value* p, enum SQN_CSI_RS_ConfigEMIMO_r13_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigEMIMO_r13_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigEMIMO_r13_setup) {
		_serSysEncSQN_CSI_RS_ConfigEMIMO_r13_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_r13(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO_r13* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigEMIMO_r13_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_r13_SQN_CSI_Process_r11_eMIMO_Type_r13_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO_r13_SQN_CSI_Process_r11_eMIMO_Type_r13_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigEMIMO_r13(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e_cdmType_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e_cdmType_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_32(&_buffer[*_lidx], p->nzp_resourceConfigListExt_r14.d, _lidx);
	for (size_t i2 = 0; i2 < p->nzp_resourceConfigListExt_r14.d; i2++) {
		_serSysEncSQN_NZP_ResourceConfig_r13(_buffer, _size, _lidx, &p->nzp_resourceConfigListExt_r14.v[i2]);
	}
	_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e_cdmType_v1430_Optional(_buffer, _size, _lidx, &p->cdmType_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_v1430_SQN_CSI_RS_ConfigNonPrecoded_v1430_csi_RS_ConfigNZP_EMIMO_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_SQN_CSI_RS_ConfigNonPrecoded_v1430_csi_RS_ConfigNZP_EMIMO_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NZP_TransmissionComb_r14_SQN_CSI_RS_Config_NZP_v1430_transmissionComb_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_Config_NZP_v1430_transmissionComb_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_8(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_Config_NZP_v1430_frequencyDensity_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_Config_NZP_v1430_frequencyDensity_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_NZP_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_NZP_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_NZP_TransmissionComb_r14_SQN_CSI_RS_Config_NZP_v1430_transmissionComb_r14_Optional(_buffer, _size, _lidx, &p->transmissionComb_r14);
	_serSysEncSQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_Config_NZP_v1430_frequencyDensity_r14_Optional(_buffer, _size, _lidx, &p->frequencyDensity_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNonPrecoded_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNonPrecoded_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSI_RS_ConfigNZP_EMIMO_v1430_SQN_CSI_RS_ConfigNonPrecoded_v1430_csi_RS_ConfigNZP_EMIMO_v1430_Optional(_buffer, _size, _lidx, &p->csi_RS_ConfigNZP_EMIMO_v1430);
	{
		size_t _tmp = (size_t)p->codebookConfigN1_v1430;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	{
		size_t _tmp = (size_t)p->codebookConfigN2_v1430;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_Config_NZP_v1430(_buffer, _size, _lidx, &p->nzp_ResourceConfigTM9_Original_v1430);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_ConfigNZP_ApList_r14_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_ConfigNZP_ApList_r14_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CSI_RS_ConfigNZP_r11(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_v1430_nzp_ResourceConfigOriginal_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_v1430_nzp_ResourceConfigOriginal_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_Config_NZP_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_Activation_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_Activation_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->csi_RS_NZP_mode_r14;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	HTON_8(&_buffer[*_lidx], p->activatedResources_r14, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_NZP_Activation_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_NZP_Activation_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigNZP_Activation_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigBeamformed_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigBeamformed_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_ConfigNZP_ApList_r14_DynamicOptional(_buffer, _size, _lidx, &p->csi_RS_ConfigNZP_ApList_r14);
	_serSysEncSQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_v1430_nzp_ResourceConfigOriginal_v1430_Optional(_buffer, _size, _lidx, &p->nzp_ResourceConfigOriginal_v1430);
	_serSysEncSQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_NZP_Activation_r14_Optional(_buffer, _size, _lidx, &p->csi_RS_NZP_Activation_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_v1430_setup_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigEMIMO_v1430_setup_Value* p, enum SQN_CSI_RS_ConfigEMIMO_v1430_setup_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigEMIMO_v1430_setup_nonPrecoded_v1430) {
		_serSysEncSQN_CSI_RS_ConfigNonPrecoded_v1430(_buffer, _size, _lidx, &p->nonPrecoded_v1430);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigEMIMO_v1430_setup_beamformed_v1430) {
		_serSysEncSQN_CSI_RS_ConfigBeamformed_v1430(_buffer, _size, _lidx, &p->beamformed_v1430);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_v1430_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO_v1430_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigEMIMO_v1430_setup_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_v1430_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigEMIMO_v1430_Value* p, enum SQN_CSI_RS_ConfigEMIMO_v1430_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigEMIMO_v1430_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigEMIMO_v1430_setup) {
		_serSysEncSQN_CSI_RS_ConfigEMIMO_v1430_setup(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_v1430(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO_v1430* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigEMIMO_v1430_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_v1430_SQN_CSI_Process_r11_dummy_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO_v1430_SQN_CSI_Process_r11_dummy_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigEMIMO_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncUint16_t_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_periodicityOffsetIndex_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct uint16_t_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_periodicityOffsetIndex_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_16(&_buffer[*_lidx], p->v, _lidx);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZPIdListExt_r14_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZPIdListExt_r14_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_IM_ConfigIdList_r14_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_IM_ConfigIdList_r14_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r14_p_C_AndCBSR_PerResourceConfigList_r14_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r14_p_C_AndCBSR_PerResourceConfigList_r14_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_32(&_buffer[*_lidx], p->v.v[i2].d, _lidx);
		for (size_t i3 = 0; i3 < p->v.v[i2].d; i3++) {
			_serSysEncSQN_P_C_AndCBSR_r13(_buffer, _size, _lidx, &p->v.v[i2].v[i3]);
		}
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncBool_SQN_CSI_RS_ConfigBeamformed_r14_ace_For4Tx_PerResourceConfigList_r14_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct bool_SQN_CSI_RS_ConfigBeamformed_r14_ace_For4Tx_PerResourceConfigList_r14_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		HTON_8(&_buffer[*_lidx], p->v.v[i2], _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e_alternativeCodebookEnabledBeamformed_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e_alternativeCodebookEnabledBeamformed_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e_channelMeasRestriction_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e_channelMeasRestriction_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	{
		size_t _tmp = (size_t)p->v;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZP_ApList_r14_DynamicOptional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZP_ApList_r14_DynamicOptional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	HTON_32(&_buffer[*_lidx], p->v.d, _lidx);
	for (size_t i2 = 0; i2 < p->v.d; i2++) {
		_serSysEncSQN_CSI_RS_ConfigNZP_r11(_buffer, _size, _lidx, &p->v.v[i2]);
	}

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_r14_nzp_ResourceConfigOriginal_v1430_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_r14_nzp_ResourceConfigOriginal_v1430_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_Config_NZP_v1430(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_NZP_Activation_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_NZP_Activation_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigNZP_Activation_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigBeamformed_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigBeamformed_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncSQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZPIdListExt_r14_DynamicOptional(_buffer, _size, _lidx, &p->csi_RS_ConfigNZPIdListExt_r14);
	_serSysEncSQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_IM_ConfigIdList_r14_DynamicOptional(_buffer, _size, _lidx, &p->csi_IM_ConfigIdList_r14);
	_serSysEncSQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r14_p_C_AndCBSR_PerResourceConfigList_r14_DynamicOptional(_buffer, _size, _lidx, &p->p_C_AndCBSR_PerResourceConfigList_r14);
	_serSysEncBool_SQN_CSI_RS_ConfigBeamformed_r14_ace_For4Tx_PerResourceConfigList_r14_DynamicOptional(_buffer, _size, _lidx, &p->ace_For4Tx_PerResourceConfigList_r14);
	_serSysEncSQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e_alternativeCodebookEnabledBeamformed_r14_Optional(_buffer, _size, _lidx, &p->alternativeCodebookEnabledBeamformed_r14);
	_serSysEncSQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e_channelMeasRestriction_r14_Optional(_buffer, _size, _lidx, &p->channelMeasRestriction_r14);
	_serSysEncSQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZP_ApList_r14_DynamicOptional(_buffer, _size, _lidx, &p->csi_RS_ConfigNZP_ApList_r14);
	_serSysEncSQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_r14_nzp_ResourceConfigOriginal_v1430_Optional(_buffer, _size, _lidx, &p->nzp_ResourceConfigOriginal_v1430);
	_serSysEncSQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_NZP_Activation_r14_Optional(_buffer, _size, _lidx, &p->csi_RS_NZP_Activation_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO2_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigEMIMO2_r14_Value* p, enum SQN_CSI_RS_ConfigEMIMO2_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigEMIMO2_r14_release) {
		HTON_8(&_buffer[*_lidx], p->release, _lidx);
		return SIDL_STATUS_OK;
	}
	if (d == SQN_CSI_RS_ConfigEMIMO2_r14_setup) {
		_serSysEncSQN_CSI_RS_ConfigBeamformed_r14(_buffer, _size, _lidx, &p->setup);
		return SIDL_STATUS_OK;
	}

	return SIDL_STATUS_ERROR;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO2_r14(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO2_r14* p)
{
	(void)_size; // TODO: generate boundaries checking

	{
		size_t _tmp = (size_t)p->d;
		HTON_32(&_buffer[*_lidx], _tmp, _lidx);
	}
	_serSysEncSQN_CSI_RS_ConfigEMIMO2_r14_Value(_buffer, _size, _lidx, &p->v, p->d);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO2_r14_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_eMIMO_Type2_r14_Optional(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO2_r14_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_eMIMO_Type2_r14_Optional* p)
{
	(void)_size; // TODO: generate boundaries checking

	HTON_8(&_buffer[*_lidx], p->d, _lidx);
	if (!p->d) return SIDL_STATUS_OK;
	_serSysEncSQN_CSI_RS_ConfigEMIMO2_r14(_buffer, _size, _lidx, &p->v);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup(unsigned char* _buffer, size_t _size, size_t* _lidx, const struct SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup* p)
{
	(void)_size; // TODO: generate boundaries checking

	_serSysEncUint16_t_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_periodicityOffsetIndex_r14_Optional(_buffer, _size, _lidx, &p->periodicityOffsetIndex_r14);
	_serSysEncSQN_CSI_RS_ConfigEMIMO2_r14_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_eMIMO_Type2_r14_Optional(_buffer, _size, _lidx, &p->eMIMO_Type2_r14);

	return SIDL_STATUS_OK;
}

static int _serSysEncSQN_CSI_RS_ConfigEMIMO_Hybrid_r14_Value(unsigned char* _buffer, size_t _size, size_t* _lidx, const union SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_Value* p, enum SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_Sel d)
{
	(void)_size; // TODO: generate boundaries checking

	if (d == SQN_CSI_RS_ConfigEMIM