/*
 * Copyright 2022 Sequans Communications.
 *
 * Licensed to the OpenAirInterface (OAI) Software Alliance under one or more
 * contributor license agreements.  See the NOTICE file distributed with
 * this work for additional information regarding copyright ownership.
 * The OpenAirInterface Software Alliance licenses this file to You under
 * the OAI Public License, Version 1.0  (the "License"); you may not use this file
 * except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *      http://www.openairinterface.org/?page_id=698
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 * For more information about the OpenAirInterface (OAI) Software Alliance:
 *      contact@openairinterface.org
 */

#pragma once

#include "SidlCompiler.h"
#include "SidlASN1Base.h"
#include "SidlBase.h"

SIDL_BEGIN_C_INTERFACE

typedef BIT_STRING_ELEMENT B2[2];

typedef BIT_STRING_ELEMENT B3[3];

typedef BIT_STRING_ELEMENT B4[4];

typedef BIT_STRING_ELEMENT B5[5];

typedef BIT_STRING_ELEMENT B6[6];

typedef BIT_STRING_ELEMENT B7[7];

typedef BIT_STRING_ELEMENT B8[8];

typedef BIT_STRING_ELEMENT B10[10];

typedef BIT_STRING_ELEMENT B12[12];

typedef BIT_STRING_ELEMENT B13[13];

typedef BIT_STRING_ELEMENT B15[15];

typedef BIT_STRING_ELEMENT B16[16];

typedef BIT_STRING_ELEMENT B17[17];

typedef BIT_STRING_ELEMENT B19[19];

typedef BIT_STRING_ELEMENT B20[20];

typedef BIT_STRING_ELEMENT B24[24];

typedef BIT_STRING_ELEMENT B25[25];

typedef BIT_STRING_ELEMENT B27[27];

typedef BIT_STRING_ELEMENT B28[28];

typedef BIT_STRING_ELEMENT B30[30];

typedef BIT_STRING_ELEMENT B32[32];

typedef BIT_STRING_ELEMENT B39[39];

typedef BIT_STRING_ELEMENT B40[40];

typedef BIT_STRING_ELEMENT B42[42];

typedef BIT_STRING_ELEMENT B48[48];

typedef BIT_STRING_ELEMENT B49[49];

typedef BIT_STRING_ELEMENT B50[50];

typedef BIT_STRING_ELEMENT B60[60];

typedef BIT_STRING_ELEMENT B64[64];

typedef BIT_STRING_ELEMENT B70[70];

typedef BIT_STRING_ELEMENT B80[80];

typedef BIT_STRING_ELEMENT B100[100];

typedef OCTET_STRING_ELEMENT O1[1];

typedef OCTET_STRING_ELEMENT O2[2];

typedef OCTET_STRING_ELEMENT O3[3];

typedef OCTET_STRING_ELEMENT O6[6];

typedef OCTET_STRING_ELEMENT O50[50];

enum SQN_AntennaInfoCommon_antennaPortsCount_e {
	SQN_AntennaInfoCommon_antennaPortsCount_e_an1 = 0,
	SQN_AntennaInfoCommon_antennaPortsCount_e_an2 = 1,
	SQN_AntennaInfoCommon_antennaPortsCount_e_an4 = 2,
	SQN_AntennaInfoCommon_antennaPortsCount_e_spare1 = 3,
};

typedef enum SQN_AntennaInfoCommon_antennaPortsCount_e SQN_AntennaInfoCommon_antennaPortsCount_e;

struct SQN_AntennaInfoCommon {
	SQN_AntennaInfoCommon_antennaPortsCount_e antennaPortsCount;
};

enum SQN_AntennaInfoDedicated_transmissionMode_e {
	SQN_AntennaInfoDedicated_transmissionMode_e_tm1 = 0,
	SQN_AntennaInfoDedicated_transmissionMode_e_tm2 = 1,
	SQN_AntennaInfoDedicated_transmissionMode_e_tm3 = 2,
	SQN_AntennaInfoDedicated_transmissionMode_e_tm4 = 3,
	SQN_AntennaInfoDedicated_transmissionMode_e_tm5 = 4,
	SQN_AntennaInfoDedicated_transmissionMode_e_tm6 = 5,
	SQN_AntennaInfoDedicated_transmissionMode_e_tm7 = 6,
	SQN_AntennaInfoDedicated_transmissionMode_e_tm8_v920 = 7,
};

typedef enum SQN_AntennaInfoDedicated_transmissionMode_e SQN_AntennaInfoDedicated_transmissionMode_e;

enum SQN_AntennaInfoDedicated_codebookSubsetRestriction_Sel {
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_UNBOUND_VALUE = 0,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n2TxAntenna_tm3 = 1,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n4TxAntenna_tm3 = 2,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n2TxAntenna_tm4 = 3,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n4TxAntenna_tm4 = 4,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n2TxAntenna_tm5 = 5,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n4TxAntenna_tm5 = 6,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n2TxAntenna_tm6 = 7,
	SQN_AntennaInfoDedicated_codebookSubsetRestriction_n4TxAntenna_tm6 = 8,
};

union SQN_AntennaInfoDedicated_codebookSubsetRestriction_Value {
	B2 n2TxAntenna_tm3;
	B4 n4TxAntenna_tm3;
	B6 n2TxAntenna_tm4;
	B64 n4TxAntenna_tm4;
	B4 n2TxAntenna_tm5;
	B16 n4TxAntenna_tm5;
	B4 n2TxAntenna_tm6;
	B16 n4TxAntenna_tm6;
};

struct SQN_AntennaInfoDedicated_codebookSubsetRestriction {
	enum SQN_AntennaInfoDedicated_codebookSubsetRestriction_Sel d;
	union SQN_AntennaInfoDedicated_codebookSubsetRestriction_Value v;
};

enum SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_setup_e {
	SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_setup_e_closedLoop = 0,
	SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_setup_e_openLoop = 1,
};

typedef enum SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_setup_e SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_setup_e;

enum SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_Sel {
	SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_UNBOUND_VALUE = 0,
	SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_release = 1,
	SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_setup = 2,
};

union SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_Value {
	Null release;
	SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_setup_e setup;
};

struct SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection {
	enum SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_Sel d;
	union SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection_Value v;
};

struct SQN_AntennaInfoDedicated_codebookSubsetRestriction_codebookSubsetRestriction_Optional {
	bool d;
	struct SQN_AntennaInfoDedicated_codebookSubsetRestriction v;
};

struct SQN_AntennaInfoDedicated {
	SQN_AntennaInfoDedicated_transmissionMode_e transmissionMode;
	struct SQN_AntennaInfoDedicated_codebookSubsetRestriction_codebookSubsetRestriction_Optional codebookSubsetRestriction;
	struct SQN_AntennaInfoDedicated_ue_TransmitAntennaSelection ue_TransmitAntennaSelection;
};

enum SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e {
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm1 = 0,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm2 = 1,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm3 = 2,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm4 = 3,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm5 = 4,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm6 = 5,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm7 = 6,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm8_v920 = 7,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm9_v1020 = 8,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_tm10_v1130 = 9,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_spare6 = 10,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_spare5 = 11,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_spare4 = 12,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_spare3 = 13,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_spare2 = 14,
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e_spare1 = 15,
};

typedef enum SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e;

enum SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup_e {
	SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup_e_closedLoop = 0,
	SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup_e_openLoop = 1,
};

typedef enum SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup_e SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup_e;

enum SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_Sel {
	SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_UNBOUND_VALUE = 0,
	SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_release = 1,
	SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup = 2,
};

union SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_Value {
	Null release;
	SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_setup_e setup;
};

struct SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection {
	enum SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_Sel d;
	union SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection_Value v;
};

struct BIT_STRING_SQN_AntennaInfoDedicated_r10_codebookSubsetRestriction_r10_Optional {
	bool d;
	BIT_STRING v;
};

struct SQN_AntennaInfoDedicated_r10 {
	SQN_AntennaInfoDedicated_r10_transmissionMode_r10_e transmissionMode_r10;
	struct BIT_STRING_SQN_AntennaInfoDedicated_r10_codebookSubsetRestriction_r10_Optional codebookSubsetRestriction_r10;
	struct SQN_AntennaInfoDedicated_r10_ue_TransmitAntennaSelection ue_TransmitAntennaSelection;
};

enum SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e {
	SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e_twoLayers = 0,
	SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e_fourLayers = 1,
	SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e_eightLayers = 2,
};

typedef enum SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e;

struct SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e_maxLayersMIMO_r10_Optional {
	bool d;
	SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e v;
};

struct SQN_AntennaInfoDedicated_v10i0 {
	struct SQN_AntennaInfoDedicated_v10i0_maxLayersMIMO_r10_e_maxLayersMIMO_r10_Optional maxLayersMIMO_r10;
};

struct SQN_AntennaInfoDedicated_v1250 {
	bool alternativeCodebookEnabledFor4TX_r12;
};

enum SQN_AntennaInfoDedicated_v1430_ce_UE_TxAntennaSelection_config_r14_e {
	SQN_AntennaInfoDedicated_v1430_ce_UE_TxAntennaSelection_config_r14_e_on = 0,
};

typedef enum SQN_AntennaInfoDedicated_v1430_ce_UE_TxAntennaSelection_config_r14_e SQN_AntennaInfoDedicated_v1430_ce_UE_TxAntennaSelection_config_r14_e;

struct SQN_AntennaInfoDedicated_v1430_ce_UE_TxAntennaSelection_config_r14_e_ce_UE_TxAntennaSelection_config_r14_Optional {
	bool d;
	SQN_AntennaInfoDedicated_v1430_ce_UE_TxAntennaSelection_config_r14_e v;
};

struct SQN_AntennaInfoDedicated_v1430 {
	struct SQN_AntennaInfoDedicated_v1430_ce_UE_TxAntennaSelection_config_r14_e_ce_UE_TxAntennaSelection_config_r14_Optional ce_UE_TxAntennaSelection_config_r14;
};

enum SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_Sel {
	SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_UNBOUND_VALUE = 0,
	SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_n2TxAntenna_tm8_r9 = 1,
	SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_n4TxAntenna_tm8_r9 = 2,
};

union SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_Value {
	B6 n2TxAntenna_tm8_r9;
	B32 n4TxAntenna_tm8_r9;
};

struct SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920 {
	enum SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_Sel d;
	union SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_Value v;
};

struct SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_codebookSubsetRestriction_v920_Optional {
	bool d;
	struct SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920 v;
};

struct SQN_AntennaInfoDedicated_v920 {
	struct SQN_AntennaInfoDedicated_v920_codebookSubsetRestriction_v920_codebookSubsetRestriction_v920_Optional codebookSubsetRestriction_v920;
};

enum SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e {
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_tm1 = 0,
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_tm2 = 1,
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_spare6 = 2,
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_spare5 = 3,
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_spare4 = 4,
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_spare3 = 5,
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_spare2 = 6,
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_spare1 = 7,
};

typedef enum SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e;

enum SQN_AntennaInfoUL_r10_fourAntennaPortActivated_r10_e {
	SQN_AntennaInfoUL_r10_fourAntennaPortActivated_r10_e_setup = 0,
};

typedef enum SQN_AntennaInfoUL_r10_fourAntennaPortActivated_r10_e SQN_AntennaInfoUL_r10_fourAntennaPortActivated_r10_e;

struct SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_transmissionModeUL_r10_Optional {
	bool d;
	SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e v;
};

struct SQN_AntennaInfoUL_r10_fourAntennaPortActivated_r10_e_fourAntennaPortActivated_r10_Optional {
	bool d;
	SQN_AntennaInfoUL_r10_fourAntennaPortActivated_r10_e v;
};

struct SQN_AntennaInfoUL_r10 {
	struct SQN_AntennaInfoUL_r10_transmissionModeUL_r10_e_transmissionModeUL_r10_Optional transmissionModeUL_r10;
	struct SQN_AntennaInfoUL_r10_fourAntennaPortActivated_r10_e_fourAntennaPortActivated_r10_Optional fourAntennaPortActivated_r10;
};

enum SQN_MasterInformationBlock_dl_Bandwidth_e {
	SQN_MasterInformationBlock_dl_Bandwidth_e_n6 = 0,
	SQN_MasterInformationBlock_dl_Bandwidth_e_n15 = 1,
	SQN_MasterInformationBlock_dl_Bandwidth_e_n25 = 2,
	SQN_MasterInformationBlock_dl_Bandwidth_e_n50 = 3,
	SQN_MasterInformationBlock_dl_Bandwidth_e_n75 = 4,
	SQN_MasterInformationBlock_dl_Bandwidth_e_n100 = 5,
};

typedef enum SQN_MasterInformationBlock_dl_Bandwidth_e SQN_MasterInformationBlock_dl_Bandwidth_e;

enum SQN_PHICH_Config_phich_Duration_e {
	SQN_PHICH_Config_phich_Duration_e_normal = 0,
	SQN_PHICH_Config_phich_Duration_e_extended = 1,
};

typedef enum SQN_PHICH_Config_phich_Duration_e SQN_PHICH_Config_phich_Duration_e;

enum SQN_PHICH_Config_phich_Resource_e {
	SQN_PHICH_Config_phich_Resource_e_oneSixth = 0,
	SQN_PHICH_Config_phich_Resource_e_half = 1,
	SQN_PHICH_Config_phich_Resource_e_one = 2,
	SQN_PHICH_Config_phich_Resource_e_two = 3,
};

typedef enum SQN_PHICH_Config_phich_Resource_e SQN_PHICH_Config_phich_Resource_e;

struct SQN_PHICH_Config {
	SQN_PHICH_Config_phich_Duration_e phich_Duration;
	SQN_PHICH_Config_phich_Resource_e phich_Resource;
};

struct SQN_MasterInformationBlock {
	SQN_MasterInformationBlock_dl_Bandwidth_e dl_Bandwidth;
	struct SQN_PHICH_Config phich_Config;
	B8 systemFrameNumber;
	uint8_t schedulingInfoSIB1_BR_r13;
	bool systemInfoUnchanged_BR_r15;
	B4 spare;
};

struct SQN_BCCH_BCH_Message {
	struct SQN_MasterInformationBlock message;
};

enum SQN_AC_BarringConfig_ac_BarringFactor_e {
	SQN_AC_BarringConfig_ac_BarringFactor_e_p00 = 0,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p05 = 1,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p10 = 2,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p15 = 3,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p20 = 4,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p25 = 5,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p30 = 6,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p40 = 7,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p50 = 8,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p60 = 9,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p70 = 10,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p75 = 11,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p80 = 12,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p85 = 13,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p90 = 14,
	SQN_AC_BarringConfig_ac_BarringFactor_e_p95 = 15,
};

typedef enum SQN_AC_BarringConfig_ac_BarringFactor_e SQN_AC_BarringConfig_ac_BarringFactor_e;

enum SQN_AC_BarringConfig_ac_BarringTime_e {
	SQN_AC_BarringConfig_ac_BarringTime_e_s4 = 0,
	SQN_AC_BarringConfig_ac_BarringTime_e_s8 = 1,
	SQN_AC_BarringConfig_ac_BarringTime_e_s16 = 2,
	SQN_AC_BarringConfig_ac_BarringTime_e_s32 = 3,
	SQN_AC_BarringConfig_ac_BarringTime_e_s64 = 4,
	SQN_AC_BarringConfig_ac_BarringTime_e_s128 = 5,
	SQN_AC_BarringConfig_ac_BarringTime_e_s256 = 6,
	SQN_AC_BarringConfig_ac_BarringTime_e_s512 = 7,
};

typedef enum SQN_AC_BarringConfig_ac_BarringTime_e SQN_AC_BarringConfig_ac_BarringTime_e;

struct SQN_AC_BarringConfig {
	SQN_AC_BarringConfig_ac_BarringFactor_e ac_BarringFactor;
	SQN_AC_BarringConfig_ac_BarringTime_e ac_BarringTime;
	B5 ac_BarringForSpecialAC;
};

struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_SystemInformationBlockType2_ac_BarringInfo {
	bool ac_BarringForEmergency;
	struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Signalling_Optional ac_BarringForMO_Signalling;
	struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringForMO_Data_Optional ac_BarringForMO_Data;
};

enum SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e {
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n4 = 0,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n8 = 1,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n12 = 2,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n16 = 3,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n20 = 4,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n24 = 5,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n28 = 6,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n32 = 7,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n36 = 8,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n40 = 9,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n44 = 10,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n48 = 11,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n52 = 12,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n56 = 13,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n60 = 14,
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e_n64 = 15,
};

typedef enum SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e;

enum SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e {
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n4 = 0,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n8 = 1,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n12 = 2,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n16 = 3,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n20 = 4,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n24 = 5,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n28 = 6,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n32 = 7,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n36 = 8,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n40 = 9,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n44 = 10,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n48 = 11,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n52 = 12,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n56 = 13,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e_n60 = 14,
};

typedef enum SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e;

enum SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e {
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b56 = 0,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b144 = 1,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b208 = 2,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e_b256 = 3,
};

typedef enum SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e;

enum SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e {
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_minusinfinity = 0,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB0 = 1,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB5 = 2,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB8 = 3,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB10 = 4,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB12 = 5,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB15 = 6,
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e_dB18 = 7,
};

typedef enum SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e;

struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig {
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_sizeOfRA_PreamblesGroupA_e sizeOfRA_PreamblesGroupA;
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messageSizeGroupA_e messageSizeGroupA;
	SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_messagePowerOffsetGroupB_e messagePowerOffsetGroupB;
};

struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional {
	bool d;
	struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig v;
};

struct SQN_RACH_ConfigCommon_preambleInfo {
	SQN_RACH_ConfigCommon_preambleInfo_numberOfRA_Preambles_e numberOfRA_Preambles;
	struct SQN_RACH_ConfigCommon_preambleInfo_preamblesGroupAConfig_preamblesGroupAConfig_Optional preamblesGroupAConfig;
};

enum SQN_PowerRampingParameters_powerRampingStep_e {
	SQN_PowerRampingParameters_powerRampingStep_e_dB0 = 0,
	SQN_PowerRampingParameters_powerRampingStep_e_dB2 = 1,
	SQN_PowerRampingParameters_powerRampingStep_e_dB4 = 2,
	SQN_PowerRampingParameters_powerRampingStep_e_dB6 = 3,
};

typedef enum SQN_PowerRampingParameters_powerRampingStep_e SQN_PowerRampingParameters_powerRampingStep_e;

enum SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e {
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_120 = 0,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_118 = 1,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_116 = 2,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_114 = 3,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_112 = 4,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_110 = 5,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_108 = 6,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_106 = 7,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_104 = 8,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_102 = 9,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_100 = 10,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_98 = 11,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_96 = 12,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_94 = 13,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_92 = 14,
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e_dBm_90 = 15,
};

typedef enum SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e;

struct SQN_PowerRampingParameters {
	SQN_PowerRampingParameters_powerRampingStep_e powerRampingStep;
	SQN_PowerRampingParameters_preambleInitialReceivedTargetPower_e preambleInitialReceivedTargetPower;
};

enum SQN_PreambleTransMax_e {
	SQN_PreambleTransMax_e_n3 = 0,
	SQN_PreambleTransMax_e_n4 = 1,
	SQN_PreambleTransMax_e_n5 = 2,
	SQN_PreambleTransMax_e_n6 = 3,
	SQN_PreambleTransMax_e_n7 = 4,
	SQN_PreambleTransMax_e_n8 = 5,
	SQN_PreambleTransMax_e_n10 = 6,
	SQN_PreambleTransMax_e_n20 = 7,
	SQN_PreambleTransMax_e_n50 = 8,
	SQN_PreambleTransMax_e_n100 = 9,
	SQN_PreambleTransMax_e_n200 = 10,
};

typedef enum SQN_PreambleTransMax_e SQN_PreambleTransMax_e;

enum SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e {
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf2 = 0,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf3 = 1,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf4 = 2,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf5 = 3,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf6 = 4,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf7 = 5,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf8 = 6,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e_sf10 = 7,
};

typedef enum SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e;

enum SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e {
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf8 = 0,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf16 = 1,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf24 = 2,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf32 = 3,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf40 = 4,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf48 = 5,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf56 = 6,
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e_sf64 = 7,
};

typedef enum SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e;

struct SQN_RACH_ConfigCommon_ra_SupervisionInfo {
	SQN_PreambleTransMax_e preambleTransMax;
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_ra_ResponseWindowSize_e ra_ResponseWindowSize;
	SQN_RACH_ConfigCommon_ra_SupervisionInfo_mac_ContentionResolutionTimer_e mac_ContentionResolutionTimer;
};

struct SQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13 {
	uint8_t firstPreamble_r13;
	uint8_t lastPreamble_r13;
};

enum SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e {
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf20 = 0,
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf50 = 1,
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf80 = 2,
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf120 = 3,
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf180 = 4,
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf240 = 5,
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf320 = 6,
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e_sf400 = 7,
};

typedef enum SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e;

enum SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e {
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf80 = 0,
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf100 = 1,
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf120 = 2,
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf160 = 3,
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf200 = 4,
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf240 = 5,
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf480 = 6,
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e_sf960 = 7,
};

typedef enum SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e;

enum SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e {
	SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e_on = 0,
	SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e_off = 1,
};

typedef enum SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e;

enum SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e {
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b328 = 0,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b408 = 1,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b504 = 2,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b600 = 3,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b712 = 4,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b808 = 5,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b936 = 6,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e_b1000or456 = 7,
};

typedef enum SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e;

enum SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e {
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf240 = 0,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf480 = 1,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf960 = 2,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf1920 = 3,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf3840 = 4,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf5760 = 5,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf7680 = 6,
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_sf10240 = 7,
};

typedef enum SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e;

struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional {
	bool d;
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e v;
};

struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15 {
	uint8_t edt_LastPreamble_r15;
	bool edt_SmallTBS_Enabled_r15;
	SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_TBS_r15_e edt_TBS_r15;
	struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_mac_ContentionResolutionTimer_r15_e_mac_ContentionResolutionTimer_r15_Optional mac_ContentionResolutionTimer_r15;
};

struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional {
	bool d;
	struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15 v;
};

struct SQN_RACH_CE_LevelInfo_r13 {
	struct SQN_RACH_CE_LevelInfo_r13_preambleMappingInfo_r13 preambleMappingInfo_r13;
	SQN_RACH_CE_LevelInfo_r13_ra_ResponseWindowSize_r13_e ra_ResponseWindowSize_r13;
	SQN_RACH_CE_LevelInfo_r13_mac_ContentionResolutionTimer_r13_e mac_ContentionResolutionTimer_r13;
	SQN_RACH_CE_LevelInfo_r13_rar_HoppingConfig_r13_e rar_HoppingConfig_r13;
	struct SQN_RACH_CE_LevelInfo_r13_edt_Parameters_r15_edt_Parameters_r15_Optional edt_Parameters_r15;
};

struct SQN_RACH_CE_LevelInfo_r13_SQN_RACH_CE_LevelInfoList_r13_Dynamic {
	size_t d;
	struct SQN_RACH_CE_LevelInfo_r13* v;
};

typedef struct SQN_RACH_CE_LevelInfo_r13_SQN_RACH_CE_LevelInfoList_r13_Dynamic SQN_RACH_CE_LevelInfoList_r13;

enum SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e {
	SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_true = 0,
};

typedef enum SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e;

struct SQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional {
	bool d;
	SQN_PreambleTransMax_e v;
};

struct SQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional {
	bool d;
	SQN_RACH_CE_LevelInfoList_r13 v;
};

struct SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional {
	bool d;
	SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e v;
};

struct SQN_RACH_ConfigCommon {
	struct SQN_RACH_ConfigCommon_preambleInfo preambleInfo;
	struct SQN_PowerRampingParameters powerRampingParameters;
	struct SQN_RACH_ConfigCommon_ra_SupervisionInfo ra_SupervisionInfo;
	uint8_t maxHARQ_Msg3Tx;
	struct SQN_PreambleTransMax_e_SQN_RACH_ConfigCommon_preambleTransMax_CE_r13_Optional preambleTransMax_CE_r13;
	struct SQN_RACH_CE_LevelInfoList_r13_SQN_RACH_ConfigCommon_rach_CE_LevelInfoList_r13_Optional rach_CE_LevelInfoList_r13;
	struct SQN_RACH_ConfigCommon_edt_SmallTBS_Subset_r15_e_edt_SmallTBS_Subset_r15_Optional edt_SmallTBS_Subset_r15;
};

enum SQN_BCCH_Config_modificationPeriodCoeff_e {
	SQN_BCCH_Config_modificationPeriodCoeff_e_n2 = 0,
	SQN_BCCH_Config_modificationPeriodCoeff_e_n4 = 1,
	SQN_BCCH_Config_modificationPeriodCoeff_e_n8 = 2,
	SQN_BCCH_Config_modificationPeriodCoeff_e_n16 = 3,
};

typedef enum SQN_BCCH_Config_modificationPeriodCoeff_e SQN_BCCH_Config_modificationPeriodCoeff_e;

struct SQN_BCCH_Config {
	SQN_BCCH_Config_modificationPeriodCoeff_e modificationPeriodCoeff;
};

enum SQN_PCCH_Config_defaultPagingCycle_e {
	SQN_PCCH_Config_defaultPagingCycle_e_rf32 = 0,
	SQN_PCCH_Config_defaultPagingCycle_e_rf64 = 1,
	SQN_PCCH_Config_defaultPagingCycle_e_rf128 = 2,
	SQN_PCCH_Config_defaultPagingCycle_e_rf256 = 3,
};

typedef enum SQN_PCCH_Config_defaultPagingCycle_e SQN_PCCH_Config_defaultPagingCycle_e;

enum SQN_PCCH_Config_nB_e {
	SQN_PCCH_Config_nB_e_fourT = 0,
	SQN_PCCH_Config_nB_e_twoT = 1,
	SQN_PCCH_Config_nB_e_oneT = 2,
	SQN_PCCH_Config_nB_e_halfT = 3,
	SQN_PCCH_Config_nB_e_quarterT = 4,
	SQN_PCCH_Config_nB_e_oneEighthT = 5,
	SQN_PCCH_Config_nB_e_oneSixteenthT = 6,
	SQN_PCCH_Config_nB_e_oneThirtySecondT = 7,
};

typedef enum SQN_PCCH_Config_nB_e SQN_PCCH_Config_nB_e;

struct SQN_PCCH_Config {
	SQN_PCCH_Config_defaultPagingCycle_e defaultPagingCycle;
	SQN_PCCH_Config_nB_e nB;
};

struct SQN_PRACH_ConfigInfo {
	uint8_t prach_ConfigIndex;
	bool highSpeedFlag;
	uint8_t zeroCorrelationZoneConfig;
	uint8_t prach_FreqOffset;
};

struct SQN_PRACH_ConfigSIB {
	uint16_t rootSequenceIndex;
	struct SQN_PRACH_ConfigInfo prach_ConfigInfo;
};

struct SQN_PDSCH_ConfigCommon {
	int8_t referenceSignalPower;
	uint8_t p_b;
};

enum SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e {
	SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e_interSubFrame = 0,
	SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e_intraAndInterSubFrame = 1,
};

typedef enum SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e;

struct SQN_PUSCH_ConfigCommon_pusch_ConfigBasic {
	uint8_t n_SB;
	SQN_PUSCH_ConfigCommon_pusch_ConfigBasic_hoppingMode_e hoppingMode;
	uint8_t pusch_HoppingOffset;
	bool enable64QAM;
};

struct SQN_UL_ReferenceSignalsPUSCH {
	bool groupHoppingEnabled;
	uint8_t groupAssignmentPUSCH;
	bool sequenceHoppingEnabled;
	uint8_t cyclicShift;
};

struct SQN_PUSCH_ConfigCommon {
	struct SQN_PUSCH_ConfigCommon_pusch_ConfigBasic pusch_ConfigBasic;
	struct SQN_UL_ReferenceSignalsPUSCH ul_ReferenceSignalsPUSCH;
};

enum SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e {
	SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds1 = 0,
	SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds2 = 1,
	SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e_ds3 = 2,
};

typedef enum SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e;

struct SQN_PUCCH_ConfigCommon {
	SQN_PUCCH_ConfigCommon_deltaPUCCH_Shift_e deltaPUCCH_Shift;
	uint8_t nRB_CQI;
	uint8_t nCS_AN;
	uint16_t n1PUCCH_AN;
};

enum SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e {
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw0 = 0,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw1 = 1,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw2 = 2,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw3 = 3,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw4 = 4,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw5 = 5,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw6 = 6,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e_bw7 = 7,
};

typedef enum SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e;

enum SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e {
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc0 = 0,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc1 = 1,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc2 = 2,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc3 = 3,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc4 = 4,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc5 = 5,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc6 = 6,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc7 = 7,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc8 = 8,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc9 = 9,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc10 = 10,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc11 = 11,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc12 = 12,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc13 = 13,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc14 = 14,
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e_sc15 = 15,
};

typedef enum SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e;

enum SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e {
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_true = 0,
};

typedef enum SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e;

struct SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional {
	bool d;
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e v;
};

struct SQN_SoundingRS_UL_ConfigCommon_setup {
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_BandwidthConfig_e srs_BandwidthConfig;
	SQN_SoundingRS_UL_ConfigCommon_setup_srs_SubframeConfig_e srs_SubframeConfig;
	bool ackNackSRS_SimultaneousTransmission;
	struct SQN_SoundingRS_UL_ConfigCommon_setup_srs_MaxUpPts_e_srs_MaxUpPts_Optional srs_MaxUpPts;
};

enum SQN_SoundingRS_UL_ConfigCommon_Sel {
	SQN_SoundingRS_UL_ConfigCommon_UNBOUND_VALUE = 0,
	SQN_SoundingRS_UL_ConfigCommon_release = 1,
	SQN_SoundingRS_UL_ConfigCommon_setup = 2,
};

union SQN_SoundingRS_UL_ConfigCommon_Value {
	Null release;
	struct SQN_SoundingRS_UL_ConfigCommon_setup setup;
};

struct SQN_SoundingRS_UL_ConfigCommon {
	enum SQN_SoundingRS_UL_ConfigCommon_Sel d;
	union SQN_SoundingRS_UL_ConfigCommon_Value v;
};

enum SQN_Alpha_r12_e {
	SQN_Alpha_r12_e_al0 = 0,
	SQN_Alpha_r12_e_al04 = 1,
	SQN_Alpha_r12_e_al05 = 2,
	SQN_Alpha_r12_e_al06 = 3,
	SQN_Alpha_r12_e_al07 = 4,
	SQN_Alpha_r12_e_al08 = 5,
	SQN_Alpha_r12_e_al09 = 6,
	SQN_Alpha_r12_e_al1 = 7,
};

typedef enum SQN_Alpha_r12_e SQN_Alpha_r12_e;

enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e {
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF_2 = 0,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF0 = 1,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e_deltaF2 = 2,
};

typedef enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e;

enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e {
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF1 = 0,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF3 = 1,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e_deltaF5 = 2,
};

typedef enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e;

enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e {
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF_2 = 0,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF0 = 1,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF1 = 2,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e_deltaF2 = 3,
};

typedef enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e;

enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e {
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF_2 = 0,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF0 = 1,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e_deltaF2 = 2,
};

typedef enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e;

enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e {
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF_2 = 0,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF0 = 1,
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e_deltaF2 = 2,
};

typedef enum SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e;

struct SQN_DeltaFList_PUCCH {
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1_e deltaF_PUCCH_Format1;
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format1b_e deltaF_PUCCH_Format1b;
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2_e deltaF_PUCCH_Format2;
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2a_e deltaF_PUCCH_Format2a;
	SQN_DeltaFList_PUCCH_deltaF_PUCCH_Format2b_e deltaF_PUCCH_Format2b;
};

struct SQN_UplinkPowerControlCommon {
	int8_t p0_NominalPUSCH;
	SQN_Alpha_r12_e alpha;
	int8_t p0_NominalPUCCH;
	struct SQN_DeltaFList_PUCCH deltaFList_PUCCH;
	int8_t deltaPreambleMsg3;
};

enum SQN_UL_CyclicPrefixLength_e {
	SQN_UL_CyclicPrefixLength_e_len1 = 0,
	SQN_UL_CyclicPrefixLength_e_len2 = 1,
};

typedef enum SQN_UL_CyclicPrefixLength_e SQN_UL_CyclicPrefixLength_e;

enum SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e {
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF_1 = 0,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF0 = 1,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF1 = 2,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF2 = 3,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF3 = 4,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF4 = 5,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF5 = 6,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e_deltaF6 = 7,
};

typedef enum SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e;

enum SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e {
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_deltaF1 = 0,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_deltaF2 = 1,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_spare2 = 2,
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e_spare1 = 3,
};

typedef enum SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e;

struct SQN_UplinkPowerControlCommon_v1020 {
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format3_r10_e deltaF_PUCCH_Format3_r10;
	SQN_UplinkPowerControlCommon_v1020_deltaF_PUCCH_Format1bCS_r10_e deltaF_PUCCH_Format1bCS_r10;
};

enum SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e {
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n1 = 0,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n2 = 1,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n3 = 2,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e_n4 = 3,
};

typedef enum SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e;

enum SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e {
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s30 = 0,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s60 = 1,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s120 = 2,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s240 = 3,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s300 = 4,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s420 = 5,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s600 = 6,
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e_s900 = 7,
};

typedef enum SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e;

struct uint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional {
	bool d;
	uint8_t v;
};

struct SQN_RACH_ConfigCommon_v1250_txFailParams_r12 {
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailCount_r12_e connEstFailCount_r12;
	SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffsetValidity_r12_e connEstFailOffsetValidity_r12;
	struct uint8_t_SQN_RACH_ConfigCommon_v1250_txFailParams_r12_connEstFailOffset_r12_Optional connEstFailOffset_r12;
};

struct SQN_RACH_ConfigCommon_v1250 {
	struct SQN_RACH_ConfigCommon_v1250_txFailParams_r12 txFailParams_r12;
};

enum SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e {
	SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e_true = 0,
};

typedef enum SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e;

struct SQN_PUSCH_ConfigCommon_v1270 {
	SQN_PUSCH_ConfigCommon_v1270_enable64QAM_v1270_e enable64QAM_v1270;
};

enum SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e {
	SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e_n64 = 0,
};

typedef enum SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e;

struct SQN_BCCH_Config_v1310 {
	SQN_BCCH_Config_v1310_modificationPeriodCoeff_v1310_e modificationPeriodCoeff_v1310;
};

enum SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e {
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r1 = 0,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r2 = 1,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r4 = 2,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r8 = 3,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r16 = 4,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r32 = 5,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r64 = 6,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r128 = 7,
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e_r256 = 8,
};

typedef enum SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e;

enum SQN_PCCH_Config_v1310_nB_v1310_e {
	SQN_PCCH_Config_v1310_nB_v1310_e_one64thT = 0,
	SQN_PCCH_Config_v1310_nB_v1310_e_one128thT = 1,
	SQN_PCCH_Config_v1310_nB_v1310_e_one256thT = 2,
};

typedef enum SQN_PCCH_Config_v1310_nB_v1310_e SQN_PCCH_Config_v1310_nB_v1310_e;

struct SQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional {
	bool d;
	SQN_PCCH_Config_v1310_nB_v1310_e v;
};

struct SQN_PCCH_Config_v1310 {
	uint8_t paging_narrowBands_r13;
	SQN_PCCH_Config_v1310_mpdcch_NumRepetition_Paging_r13_e mpdcch_NumRepetition_Paging_r13;
	struct SQN_PCCH_Config_v1310_nB_v1310_e_nB_v1310_Optional nB_v1310;
};

enum SQN_FreqHoppingParameters_r13_dummy_e {
	SQN_FreqHoppingParameters_r13_dummy_e_nb2 = 0,
	SQN_FreqHoppingParameters_r13_dummy_e_nb4 = 1,
};

typedef enum SQN_FreqHoppingParameters_r13_dummy_e SQN_FreqHoppingParameters_r13_dummy_e;

enum SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e {
	SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int1 = 0,
	SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int2 = 1,
	SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int4 = 2,
	SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e_int8 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e;

enum SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e {
	SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int1 = 0,
	SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int5 = 1,
	SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int10 = 2,
	SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e_int20 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e;

enum SQN_FreqHoppingParameters_r13_dummy2_Sel {
	SQN_FreqHoppingParameters_r13_dummy2_UNBOUND_VALUE = 0,
	SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13 = 1,
	SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13 = 2,
};

union SQN_FreqHoppingParameters_r13_dummy2_Value {
	SQN_FreqHoppingParameters_r13_dummy2_interval_FDD_r13_e interval_FDD_r13;
	SQN_FreqHoppingParameters_r13_dummy2_interval_TDD_r13_e interval_TDD_r13;
};

struct SQN_FreqHoppingParameters_r13_dummy2 {
	enum SQN_FreqHoppingParameters_r13_dummy2_Sel d;
	union SQN_FreqHoppingParameters_r13_dummy2_Value v;
};

enum SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e {
	SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int2 = 0,
	SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int4 = 1,
	SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int8 = 2,
	SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e_int16 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e;

enum SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e {
	SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int5 = 0,
	SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int10 = 1,
	SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int20 = 2,
	SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e_int40 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e;

enum SQN_FreqHoppingParameters_r13_dummy3_Sel {
	SQN_FreqHoppingParameters_r13_dummy3_UNBOUND_VALUE = 0,
	SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13 = 1,
	SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13 = 2,
};

union SQN_FreqHoppingParameters_r13_dummy3_Value {
	SQN_FreqHoppingParameters_r13_dummy3_interval_FDD_r13_e interval_FDD_r13;
	SQN_FreqHoppingParameters_r13_dummy3_interval_TDD_r13_e interval_TDD_r13;
};

struct SQN_FreqHoppingParameters_r13_dummy3 {
	enum SQN_FreqHoppingParameters_r13_dummy3_Sel d;
	union SQN_FreqHoppingParameters_r13_dummy3_Value v;
};

enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int1 = 0,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int2 = 1,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int4 = 2,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int8 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e;

enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int1 = 0,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int5 = 1,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int10 = 2,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int20 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e;

enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Sel {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_UNBOUND_VALUE = 0,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13 = 1,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13 = 2,
};

union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_FDD_r13_e interval_FDD_r13;
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_TDD_r13_e interval_TDD_r13;
};

struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13 {
	enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Sel d;
	union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_Value v;
};

enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int2 = 0,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int4 = 1,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int8 = 2,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int16 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e;

enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int5 = 0,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int10 = 1,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int20 = 2,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int40 = 3,
};

typedef enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e;

enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Sel {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_UNBOUND_VALUE = 0,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13 = 1,
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13 = 2,
};

union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value {
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_FDD_r13_e interval_FDD_r13;
	SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_TDD_r13_e interval_TDD_r13;
};

struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13 {
	enum SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Sel d;
	union SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_Value v;
};

struct SQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional {
	bool d;
	SQN_FreqHoppingParameters_r13_dummy_e v;
};

struct SQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional {
	bool d;
	struct SQN_FreqHoppingParameters_r13_dummy2 v;
};

struct SQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional {
	bool d;
	struct SQN_FreqHoppingParameters_r13_dummy3 v;
};

struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional {
	bool d;
	struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13 v;
};

struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional {
	bool d;
	struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13 v;
};

struct uint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional {
	bool d;
	uint8_t v;
};

struct SQN_FreqHoppingParameters_r13 {
	struct SQN_FreqHoppingParameters_r13_dummy_e_dummy_Optional dummy;
	struct SQN_FreqHoppingParameters_r13_dummy2_dummy2_Optional dummy2;
	struct SQN_FreqHoppingParameters_r13_dummy3_dummy3_Optional dummy3;
	struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeA_r13_interval_ULHoppingConfigCommonModeA_r13_Optional interval_ULHoppingConfigCommonModeA_r13;
	struct SQN_FreqHoppingParameters_r13_interval_ULHoppingConfigCommonModeB_r13_interval_ULHoppingConfigCommonModeB_r13_Optional interval_ULHoppingConfigCommonModeB_r13;
	struct uint8_t_SQN_FreqHoppingParameters_r13_dummy4_Optional dummy4;
};

enum SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e {
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_r16 = 0,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_r32 = 1,
};

typedef enum SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e;

enum SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e {
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r192 = 0,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r256 = 1,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r384 = 2,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r512 = 3,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r768 = 4,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r1024 = 5,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r1536 = 6,
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_r2048 = 7,
};

typedef enum SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e;

struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional {
	bool d;
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e v;
};

struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional {
	bool d;
	SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e v;
};

struct SQN_PDSCH_ConfigCommon_v1310 {
	struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeA_r13_e_pdsch_maxNumRepetitionCEmodeA_r13_Optional pdsch_maxNumRepetitionCEmodeA_r13;
	struct SQN_PDSCH_ConfigCommon_v1310_pdsch_maxNumRepetitionCEmodeB_r13_e_pdsch_maxNumRepetitionCEmodeB_r13_Optional pdsch_maxNumRepetitionCEmodeB_r13;
};

enum SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e {
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r8 = 0,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r16 = 1,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_r32 = 2,
};

typedef enum SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e;

enum SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e {
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r192 = 0,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r256 = 1,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r384 = 2,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r512 = 3,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r768 = 4,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r1024 = 5,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r1536 = 6,
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_r2048 = 7,
};

typedef enum SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e;

struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional {
	bool d;
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e v;
};

struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional {
	bool d;
	SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e v;
};

struct uint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PUSCH_ConfigCommon_v1310 {
	struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeA_r13_e_pusch_maxNumRepetitionCEmodeA_r13_Optional pusch_maxNumRepetitionCEmodeA_r13;
	struct SQN_PUSCH_ConfigCommon_v1310_pusch_maxNumRepetitionCEmodeB_r13_e_pusch_maxNumRepetitionCEmodeB_r13_Optional pusch_maxNumRepetitionCEmodeB_r13;
	struct uint8_t_SQN_PUSCH_ConfigCommon_v1310_pusch_HoppingOffset_v1310_Optional pusch_HoppingOffset_v1310;
};

typedef uint8_t SQN_RSRP_Range;

struct SQN_RSRP_Range_SQN_RSRP_ThresholdsPrachInfoList_r13_Dynamic {
	size_t d;
	SQN_RSRP_Range* v;
};

typedef struct SQN_RSRP_Range_SQN_RSRP_ThresholdsPrachInfoList_r13_Dynamic SQN_RSRP_ThresholdsPrachInfoList_r13;

enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e {
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1 = 0,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1dot5 = 1,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2 = 2,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2dot5 = 3,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v4 = 4,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v5 = 5,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v8 = 6,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v10 = 7,
};

typedef enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e;

enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e {
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v1 = 0,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v2 = 1,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v4 = 2,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v5 = 3,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v8 = 4,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v10 = 5,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v20 = 6,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_spare = 7,
};

typedef enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e;

enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Sel {
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_UNBOUND_VALUE = 0,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13 = 1,
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13 = 2,
};

union SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value {
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e fdd_r13;
	SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e tdd_r13;
};

struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13 {
	enum SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Sel d;
	union SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_Value v;
};

enum SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e {
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf2 = 0,
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf4 = 1,
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf8 = 2,
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf16 = 3,
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf32 = 4,
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf64 = 5,
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf128 = 6,
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_sf256 = 7,
};

typedef enum SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e;

enum SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e {
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n3 = 0,
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n4 = 1,
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n5 = 2,
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n6 = 3,
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n7 = 4,
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n8 = 5,
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_n10 = 6,
};

typedef enum SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e;

enum SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e {
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n1 = 0,
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n2 = 1,
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n4 = 2,
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n8 = 3,
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n16 = 4,
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n32 = 5,
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n64 = 6,
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e_n128 = 7,
};

typedef enum SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e;

enum SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e {
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r1 = 0,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r2 = 1,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r4 = 2,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r8 = 3,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r16 = 4,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r32 = 5,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r64 = 6,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r128 = 7,
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e_r256 = 8,
};

typedef enum SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e;

enum SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e {
	SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e_on = 0,
	SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e_off = 1,
};

typedef enum SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e;

struct SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional {
	bool d;
	SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e v;
};

struct SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional {
	bool d;
	SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e v;
};

struct uint8_t_SQN_PRACH_ParametersCE_r13_mpdcch_NarrowbandsToMonitor_r13_Dynamic {
	size_t d;
	uint8_t* v;
};

struct SQN_PRACH_ParametersCE_r13 {
	uint8_t prach_ConfigIndex_r13;
	uint8_t prach_FreqOffset_r13;
	struct SQN_PRACH_ParametersCE_r13_prach_StartingSubframe_r13_e_prach_StartingSubframe_r13_Optional prach_StartingSubframe_r13;
	struct SQN_PRACH_ParametersCE_r13_maxNumPreambleAttemptCE_r13_e_maxNumPreambleAttemptCE_r13_Optional maxNumPreambleAttemptCE_r13;
	SQN_PRACH_ParametersCE_r13_numRepetitionPerPreambleAttempt_r13_e numRepetitionPerPreambleAttempt_r13;
	struct uint8_t_SQN_PRACH_ParametersCE_r13_mpdcch_NarrowbandsToMonitor_r13_Dynamic mpdcch_NarrowbandsToMonitor_r13;
	SQN_PRACH_ParametersCE_r13_mpdcch_NumRepetition_RA_r13_e mpdcch_NumRepetition_RA_r13;
	SQN_PRACH_ParametersCE_r13_prach_HoppingConfig_r13_e prach_HoppingConfig_r13;
};

struct SQN_PRACH_ParametersCE_r13_SQN_PRACH_ParametersListCE_r13_Dynamic {
	size_t d;
	struct SQN_PRACH_ParametersCE_r13* v;
};

typedef struct SQN_PRACH_ParametersCE_r13_SQN_PRACH_ParametersListCE_r13_Dynamic SQN_PRACH_ParametersListCE_r13;

struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional {
	bool d;
	struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13 v;
};

struct uint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PRACH_ConfigSIB_v1310 {
	SQN_RSRP_ThresholdsPrachInfoList_r13 rsrp_ThresholdsPrachInfoList_r13;
	struct SQN_PRACH_ConfigSIB_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional mpdcch_startSF_CSS_RA_r13;
	struct uint8_t_SQN_PRACH_ConfigSIB_v1310_prach_HoppingOffset_r13_Optional prach_HoppingOffset_r13;
	SQN_PRACH_ParametersListCE_r13 prach_ParametersListCE_r13;
};

struct uint16_t_SQN_N1PUCCH_AN_InfoList_r13_Dynamic {
	size_t d;
	uint16_t* v;
};

typedef struct uint16_t_SQN_N1PUCCH_AN_InfoList_r13_Dynamic SQN_N1PUCCH_AN_InfoList_r13;

enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e {
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n1 = 0,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n2 = 1,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n4 = 2,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_n8 = 3,
};

typedef enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e;

enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e {
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n1 = 0,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n2 = 1,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n4 = 2,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_n8 = 3,
};

typedef enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e;

enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e {
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n4 = 0,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n8 = 1,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n16 = 2,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_n32 = 3,
};

typedef enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e;

enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e {
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n4 = 0,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n8 = 1,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n16 = 2,
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_n32 = 3,
};

typedef enum SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e;

struct SQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional {
	bool d;
	SQN_N1PUCCH_AN_InfoList_r13 v;
};

struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e v;
};

struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e v;
};

struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e v;
};

struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e v;
};

struct SQN_PUCCH_ConfigCommon_v1310 {
	struct SQN_N1PUCCH_AN_InfoList_r13_SQN_PUCCH_ConfigCommon_v1310_n1PUCCH_AN_InfoList_r13_Optional n1PUCCH_AN_InfoList_r13;
	struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level0_r13_e_pucch_NumRepetitionCE_Msg4_Level0_r13_Optional pucch_NumRepetitionCE_Msg4_Level0_r13;
	struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level1_r13_e_pucch_NumRepetitionCE_Msg4_Level1_r13_Optional pucch_NumRepetitionCE_Msg4_Level1_r13;
	struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level2_r13_e_pucch_NumRepetitionCE_Msg4_Level2_r13_Optional pucch_NumRepetitionCE_Msg4_Level2_r13;
	struct SQN_PUCCH_ConfigCommon_v1310_pucch_NumRepetitionCE_Msg4_Level3_r13_e_pucch_NumRepetitionCE_Msg4_Level3_r13_Optional pucch_NumRepetitionCE_Msg4_Level3_r13;
};

enum SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e {
	SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_true = 0,
};

typedef enum SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e;

enum SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e {
	SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_true = 0,
};

typedef enum SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e;

struct SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional {
	bool d;
	SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e v;
};

struct SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional {
	bool d;
	SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e v;
};

struct SQN_HighSpeedConfig_r14 {
	struct SQN_HighSpeedConfig_r14_highSpeedEnhancedMeasFlag_r14_e_highSpeedEnhancedMeasFlag_r14_Optional highSpeedEnhancedMeasFlag_r14;
	struct SQN_HighSpeedConfig_r14_highSpeedEnhancedDemodulationFlag_r14_e_highSpeedEnhancedDemodulationFlag_r14_Optional highSpeedEnhancedDemodulationFlag_r14;
};

struct SQN_PRACH_Config_v1430 {
	uint16_t rootSequenceIndexHighSpeed_r14;
	uint8_t zeroCorrelationZoneConfigHighSpeed_r14;
	uint8_t prach_ConfigIndexHighSpeed_r14;
	uint8_t prach_FreqOffsetHighSpeed_r14;
};

enum SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e {
	SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_n64 = 0,
	SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_n128 = 1,
};

typedef enum SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e;

struct SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional {
	bool d;
	SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e v;
};

struct SQN_PUCCH_ConfigCommon_v1430 {
	struct SQN_PUCCH_ConfigCommon_v1430_pucch_NumRepetitionCE_Msg4_Level3_r14_e_pucch_NumRepetitionCE_Msg4_Level3_r14_Optional pucch_NumRepetitionCE_Msg4_Level3_r14;
};

enum SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e {
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf2 = 0,
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf4 = 1,
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf8 = 2,
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf16 = 3,
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf32 = 4,
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf64 = 5,
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf128 = 6,
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_sf256 = 7,
};

typedef enum SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e;

struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional {
	bool d;
	SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e v;
};

struct uint8_t_SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_mpdcch_NarrowbandsToMonitor_r15_Dynamic {
	size_t d;
	uint8_t* v;
};

struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15 {
	uint8_t prach_ConfigIndex_r15;
	uint8_t prach_FreqOffset_r15;
	struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_prach_StartingSubframe_r15_e_prach_StartingSubframe_r15_Optional prach_StartingSubframe_r15;
	struct uint8_t_SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_mpdcch_NarrowbandsToMonitor_r15_Dynamic mpdcch_NarrowbandsToMonitor_r15;
};

struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional {
	bool d;
	struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15 v;
};

struct SQN_EDT_PRACH_ParametersCE_r15 {
	struct SQN_EDT_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_edt_PRACH_ParametersCE_r15_Optional edt_PRACH_ParametersCE_r15;
};

struct SQN_EDT_PRACH_ParametersCE_r15_SQN_PRACH_ConfigSIB_v1530_edt_PRACH_ParametersListCE_r15_Dynamic {
	size_t d;
	struct SQN_EDT_PRACH_ParametersCE_r15* v;
};

struct SQN_PRACH_ConfigSIB_v1530 {
	struct SQN_EDT_PRACH_ParametersCE_r15_SQN_PRACH_ConfigSIB_v1530_edt_PRACH_ParametersListCE_r15_Dynamic edt_PRACH_ParametersListCE_r15;
};

enum SQN_RSS_Config_r15_duration_r15_e {
	SQN_RSS_Config_r15_duration_r15_e_sf8 = 0,
	SQN_RSS_Config_r15_duration_r15_e_sf16 = 1,
	SQN_RSS_Config_r15_duration_r15_e_sf32 = 2,
	SQN_RSS_Config_r15_duration_r15_e_sf40 = 3,
};

typedef enum SQN_RSS_Config_r15_duration_r15_e SQN_RSS_Config_r15_duration_r15_e;

enum SQN_RSS_Config_r15_periodicity_r15_e {
	SQN_RSS_Config_r15_periodicity_r15_e_ms160 = 0,
	SQN_RSS_Config_r15_periodicity_r15_e_ms320 = 1,
	SQN_RSS_Config_r15_periodicity_r15_e_ms640 = 2,
	SQN_RSS_Config_r15_periodicity_r15_e_ms1280 = 3,
};

typedef enum SQN_RSS_Config_r15_periodicity_r15_e SQN_RSS_Config_r15_periodicity_r15_e;

enum SQN_RSS_Config_r15_powerBoost_r15_e {
	SQN_RSS_Config_r15_powerBoost_r15_e_dB0 = 0,
	SQN_RSS_Config_r15_powerBoost_r15_e_dB3 = 1,
	SQN_RSS_Config_r15_powerBoost_r15_e_dB4dot8 = 2,
	SQN_RSS_Config_r15_powerBoost_r15_e_dB6 = 3,
};

typedef enum SQN_RSS_Config_r15_powerBoost_r15_e SQN_RSS_Config_r15_powerBoost_r15_e;

struct SQN_RSS_Config_r15 {
	SQN_RSS_Config_r15_duration_r15_e duration_r15;
	uint8_t freqLocation_r15;
	SQN_RSS_Config_r15_periodicity_r15_e periodicity_r15;
	SQN_RSS_Config_r15_powerBoost_r15_e powerBoost_r15;
	uint8_t timeOffset_r15;
};

enum SQN_WUS_Config_r15_maxDurationFactor_r15_e {
	SQN_WUS_Config_r15_maxDurationFactor_r15_e_one32th = 0,
	SQN_WUS_Config_r15_maxDurationFactor_r15_e_one16th = 1,
	SQN_WUS_Config_r15_maxDurationFactor_r15_e_one8th = 2,
	SQN_WUS_Config_r15_maxDurationFactor_r15_e_one4th = 3,
};

typedef enum SQN_WUS_Config_r15_maxDurationFactor_r15_e SQN_WUS_Config_r15_maxDurationFactor_r15_e;

enum SQN_WUS_Config_r15_numPOs_r15_e {
	SQN_WUS_Config_r15_numPOs_r15_e_n1 = 0,
	SQN_WUS_Config_r15_numPOs_r15_e_n2 = 1,
	SQN_WUS_Config_r15_numPOs_r15_e_n4 = 2,
	SQN_WUS_Config_r15_numPOs_r15_e_spare1 = 3,
};

typedef enum SQN_WUS_Config_r15_numPOs_r15_e SQN_WUS_Config_r15_numPOs_r15_e;

enum SQN_WUS_Config_r15_freqLocation_r15_e {
	SQN_WUS_Config_r15_freqLocation_r15_e_n0 = 0,
	SQN_WUS_Config_r15_freqLocation_r15_e_n2 = 1,
	SQN_WUS_Config_r15_freqLocation_r15_e_n4 = 2,
	SQN_WUS_Config_r15_freqLocation_r15_e_spare1 = 3,
};

typedef enum SQN_WUS_Config_r15_freqLocation_r15_e SQN_WUS_Config_r15_freqLocation_r15_e;

enum SQN_WUS_Config_r15_timeOffsetDRX_r15_e {
	SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms40 = 0,
	SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms80 = 1,
	SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms160 = 2,
	SQN_WUS_Config_r15_timeOffsetDRX_r15_e_ms240 = 3,
};

typedef enum SQN_WUS_Config_r15_timeOffsetDRX_r15_e SQN_WUS_Config_r15_timeOffsetDRX_r15_e;

enum SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e {
	SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms40 = 0,
	SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms80 = 1,
	SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms160 = 2,
	SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e_ms240 = 3,
};

typedef enum SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e;

enum SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e {
	SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_ms1000 = 0,
	SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_ms2000 = 1,
};

typedef enum SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e;

struct SQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional {
	bool d;
	SQN_WUS_Config_r15_numPOs_r15_e v;
};

struct SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional {
	bool d;
	SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e v;
};

struct SQN_WUS_Config_r15 {
	SQN_WUS_Config_r15_maxDurationFactor_r15_e maxDurationFactor_r15;
	struct SQN_WUS_Config_r15_numPOs_r15_e_numPOs_r15_Optional numPOs_r15;
	SQN_WUS_Config_r15_freqLocation_r15_e freqLocation_r15;
	SQN_WUS_Config_r15_timeOffsetDRX_r15_e timeOffsetDRX_r15;
	SQN_WUS_Config_r15_timeOffset_eDRX_Short_r15_e timeOffset_eDRX_Short_r15;
	struct SQN_WUS_Config_r15_timeOffset_eDRX_Long_r15_e_timeOffset_eDRX_Long_r15_Optional timeOffset_eDRX_Long_r15;
};

enum SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e {
	SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e_true = 0,
};

typedef enum SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e;

struct SQN_HighSpeedConfig_v1530 {
	SQN_HighSpeedConfig_v1530_highSpeedMeasGapCE_ModeA_r15_e highSpeedMeasGapCE_ModeA_r15;
};

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_1 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF0 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF1 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF2 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF3 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF4 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF5 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF6 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF1 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF2 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF3 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF4 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF5 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF6 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF7 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF8 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF3 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF4 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF5 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF6 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF7 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF8 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF9 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF10 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF4 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF5 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF6 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF7 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF8 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF9 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF10 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF11 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF13 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF14 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF15 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF16 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF17 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF18 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF19 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF20 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF10 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF11 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF12 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF13 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF14 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF15 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF16 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF17 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF5 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF6 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF7 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF8 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF9 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF10 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF11 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF12 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF6 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF7 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF8 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF9 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF10 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF11 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF12 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF13 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF15 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF16 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF17 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF18 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF19 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF20 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF21 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF22 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e;

enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e {
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF10 = 0,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF11 = 1,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF12 = 2,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF13 = 3,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF14 = 4,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF15 = 5,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF16 = 6,
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF17 = 7,
};

typedef enum SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e;

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional {
	bool d;
	SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e v;
};

struct SQN_DeltaFList_SPUCCH_r15_setup {
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1_r15_e_deltaF_slotSPUCCH_Format1_r15_Optional deltaF_slotSPUCCH_Format1_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1a_r15_e_deltaF_slotSPUCCH_Format1a_r15_Optional deltaF_slotSPUCCH_Format1a_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format1b_r15_e_deltaF_slotSPUCCH_Format1b_r15_Optional deltaF_slotSPUCCH_Format1b_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_Format3_r15_e_deltaF_slotSPUCCH_Format3_r15_Optional deltaF_slotSPUCCH_Format3_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_RM_Format4_r15_e_deltaF_slotSPUCCH_RM_Format4_r15_Optional deltaF_slotSPUCCH_RM_Format4_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_slotSPUCCH_TBCC_Format4_r15_e_deltaF_slotSPUCCH_TBCC_Format4_r15_Optional deltaF_slotSPUCCH_TBCC_Format4_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1and1a_r15_e_deltaF_subslotSPUCCH_Format1and1a_r15_Optional deltaF_subslotSPUCCH_Format1and1a_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_Format1b_r15_e_deltaF_subslotSPUCCH_Format1b_r15_Optional deltaF_subslotSPUCCH_Format1b_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_RM_Format4_r15_e_deltaF_subslotSPUCCH_RM_Format4_r15_Optional deltaF_subslotSPUCCH_RM_Format4_r15;
	struct SQN_DeltaFList_SPUCCH_r15_setup_deltaF_subslotSPUCCH_TBCC_Format4_r15_e_deltaF_subslotSPUCCH_TBCC_Format4_r15_Optional deltaF_subslotSPUCCH_TBCC_Format4_r15;
};

enum SQN_DeltaFList_SPUCCH_r15_Sel {
	SQN_DeltaFList_SPUCCH_r15_UNBOUND_VALUE = 0,
	SQN_DeltaFList_SPUCCH_r15_release = 1,
	SQN_DeltaFList_SPUCCH_r15_setup = 2,
};

union SQN_DeltaFList_SPUCCH_r15_Value {
	Null release;
	struct SQN_DeltaFList_SPUCCH_r15_setup setup;
};

struct SQN_DeltaFList_SPUCCH_r15 {
	enum SQN_DeltaFList_SPUCCH_r15_Sel d;
	union SQN_DeltaFList_SPUCCH_r15_Value v;
};

struct SQN_UplinkPowerControlCommon_v1530 {
	struct SQN_DeltaFList_SPUCCH_r15 deltaFList_SPUCCH_r15;
};

enum SQN_WUS_Config_v1560_powerBoost_r15_e {
	SQN_WUS_Config_v1560_powerBoost_r15_e_dB0 = 0,
	SQN_WUS_Config_v1560_powerBoost_r15_e_dB1dot8 = 1,
	SQN_WUS_Config_v1560_powerBoost_r15_e_dB3 = 2,
	SQN_WUS_Config_v1560_powerBoost_r15_e_dB4dot8 = 3,
};

typedef enum SQN_WUS_Config_v1560_powerBoost_r15_e SQN_WUS_Config_v1560_powerBoost_r15_e;

struct SQN_WUS_Config_v1560 {
	SQN_WUS_Config_v1560_powerBoost_r15_e powerBoost_r15;
};

enum SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e {
	SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n1 = 0,
	SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n2 = 1,
	SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n4 = 2,
	SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e_n8 = 3,
};

typedef enum SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e;

struct SQN_WUS_Config_v1610 {
	SQN_WUS_Config_v1610_numDRX_CyclesRelaxed_r16_e numDRX_CyclesRelaxed_r16;
};

enum SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e {
	SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_true = 0,
};

typedef enum SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e;

enum SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e {
	SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_true = 0,
};

typedef enum SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e;

struct SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional {
	bool d;
	SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e v;
};

struct SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional {
	bool d;
	SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e v;
};

struct SQN_HighSpeedConfig_v1610 {
	struct SQN_HighSpeedConfig_v1610_highSpeedEnhMeasFlag2_r16_e_highSpeedEnhMeasFlag2_r16_Optional highSpeedEnhMeasFlag2_r16;
	struct SQN_HighSpeedConfig_v1610_highSpeedEnhDemodFlag2_r16_e_highSpeedEnhDemodFlag2_r16_Optional highSpeedEnhDemodFlag2_r16;
};

enum SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e {
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_4dot77 = 0,
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_3 = 1,
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB_1dot77 = 2,
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB0 = 3,
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB1 = 4,
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB2 = 5,
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB3 = 6,
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e_dB4dot77 = 7,
};

typedef enum SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e;

struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16 {
	SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_powerRatio_r16_e powerRatio_r16;
};

enum SQN_GWUS_Config_r16_groupAlternation_r16_e {
	SQN_GWUS_Config_r16_groupAlternation_r16_e_true = 0,
};

typedef enum SQN_GWUS_Config_r16_groupAlternation_r16_e SQN_GWUS_Config_r16_groupAlternation_r16_e;

enum SQN_GWUS_Config_r16_commonSequence_r16_e {
	SQN_GWUS_Config_r16_commonSequence_r16_e_g0 = 0,
	SQN_GWUS_Config_r16_commonSequence_r16_e_g126 = 1,
};

typedef enum SQN_GWUS_Config_r16_commonSequence_r16_e SQN_GWUS_Config_r16_commonSequence_r16_e;

enum SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e {
	SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one32th = 0,
	SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one16th = 1,
	SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one8th = 2,
	SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e_one4th = 3,
};

typedef enum SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e;

enum SQN_GWUS_TimeParameters_r16_numPOs_r16_e {
	SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n1 = 0,
	SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n2 = 1,
	SQN_GWUS_TimeParameters_r16_numPOs_r16_e_n4 = 2,
	SQN_GWUS_TimeParameters_r16_numPOs_r16_e_spare1 = 3,
};

typedef enum SQN_GWUS_TimeParameters_r16_numPOs_r16_e SQN_GWUS_TimeParameters_r16_numPOs_r16_e;

enum SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e {
	SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms40 = 0,
	SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms80 = 1,
	SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms160 = 2,
	SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e_ms240 = 3,
};

typedef enum SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e;

enum SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e {
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms40 = 0,
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms80 = 1,
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms160 = 2,
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e_ms240 = 3,
};

typedef enum SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e;

enum SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e {
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_ms1000 = 0,
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_ms2000 = 1,
};

typedef enum SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e;

enum SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e {
	SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n1 = 0,
	SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n2 = 1,
	SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n4 = 2,
	SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_n8 = 3,
};

typedef enum SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e;

enum SQN_GWUS_TimeParameters_r16_powerBoost_r16_e {
	SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB0 = 0,
	SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB1dot8 = 1,
	SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB3 = 2,
	SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_dB4dot8 = 3,
};

typedef enum SQN_GWUS_TimeParameters_r16_powerBoost_r16_e SQN_GWUS_TimeParameters_r16_powerBoost_r16_e;

struct SQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional {
	bool d;
	SQN_GWUS_TimeParameters_r16_numPOs_r16_e v;
};

struct SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional {
	bool d;
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e v;
};

struct SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional {
	bool d;
	SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e v;
};

struct SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional {
	bool d;
	SQN_GWUS_TimeParameters_r16_powerBoost_r16_e v;
};

struct SQN_GWUS_TimeParameters_r16 {
	SQN_GWUS_TimeParameters_r16_maxDurationFactor_r16_e maxDurationFactor_r16;
	struct SQN_GWUS_TimeParameters_r16_numPOs_r16_e_numPOs_r16_Optional numPOs_r16;
	SQN_GWUS_TimeParameters_r16_timeOffsetDRX_r16_e timeOffsetDRX_r16;
	SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Short_r16_e timeOffset_eDRX_Short_r16;
	struct SQN_GWUS_TimeParameters_r16_timeOffset_eDRX_Long_r16_e_timeOffset_eDRX_Long_r16_Optional timeOffset_eDRX_Long_r16;
	struct SQN_GWUS_TimeParameters_r16_numDRX_CyclesRelaxed_r16_e_numDRX_CyclesRelaxed_r16_Optional numDRX_CyclesRelaxed_r16;
	struct SQN_GWUS_TimeParameters_r16_powerBoost_r16_e_powerBoost_r16_Optional powerBoost_r16;
};

enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e {
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_primary = 0,
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_secondary = 1,
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e_primary3FDM = 2,
};

typedef enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e;

enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e {
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e_n0 = 0,
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e_n2 = 1,
};

typedef enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e;

enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Sel {
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_UNBOUND_VALUE = 0,
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS = 1,
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS = 2,
};

union SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value {
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithWUS_e resourceLocationWithWUS;
	SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_resourceLocationWithoutWUS_e resourceLocationWithoutWUS;
};

struct SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16 {
	enum SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Sel d;
	union SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16_Value v;
};

enum SQN_GWUS_NumGroups_r16_e {
	SQN_GWUS_NumGroups_r16_e_n1 = 0,
	SQN_GWUS_NumGroups_r16_e_n2 = 1,
	SQN_GWUS_NumGroups_r16_e_n4 = 2,
	SQN_GWUS_NumGroups_r16_e_n8 = 3,
};

typedef enum SQN_GWUS_NumGroups_r16_e SQN_GWUS_NumGroups_r16_e;

struct SQN_GWUS_NumGroups_r16_e_SQN_GWUS_NumGroupsList_r16_Dynamic {
	size_t d;
	SQN_GWUS_NumGroups_r16_e* v;
};

typedef struct SQN_GWUS_NumGroups_r16_e_SQN_GWUS_NumGroupsList_r16_Dynamic SQN_GWUS_NumGroupsList_r16;

struct uint8_t_SQN_GWUS_GroupsForServiceList_r16_Dynamic {
	size_t d;
	uint8_t* v;
};

typedef struct uint8_t_SQN_GWUS_GroupsForServiceList_r16_Dynamic SQN_GWUS_GroupsForServiceList_r16;

struct SQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional {
	bool d;
	SQN_GWUS_NumGroupsList_r16 v;
};

struct SQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional {
	bool d;
	SQN_GWUS_GroupsForServiceList_r16 v;
};

struct SQN_GWUS_ResourceConfig_r16 {
	struct SQN_GWUS_ResourceConfig_r16_resourceMappingPattern_r16 resourceMappingPattern_r16;
	struct SQN_GWUS_NumGroupsList_r16_SQN_GWUS_ResourceConfig_r16_numGroupsList_r16_Optional numGroupsList_r16;
	struct SQN_GWUS_GroupsForServiceList_r16_SQN_GWUS_ResourceConfig_r16_groupsForServiceList_r16_Optional groupsForServiceList_r16;
};

enum SQN_GWUS_PagingProbThresh_r16_e {
	SQN_GWUS_PagingProbThresh_r16_e_p20 = 0,
	SQN_GWUS_PagingProbThresh_r16_e_p30 = 1,
	SQN_GWUS_PagingProbThresh_r16_e_p40 = 2,
	SQN_GWUS_PagingProbThresh_r16_e_p50 = 3,
	SQN_GWUS_PagingProbThresh_r16_e_p60 = 4,
	SQN_GWUS_PagingProbThresh_r16_e_p70 = 5,
	SQN_GWUS_PagingProbThresh_r16_e_p80 = 6,
	SQN_GWUS_PagingProbThresh_r16_e_p90 = 7,
};

typedef enum SQN_GWUS_PagingProbThresh_r16_e SQN_GWUS_PagingProbThresh_r16_e;

struct SQN_GWUS_PagingProbThresh_r16_e_SQN_GWUS_ProbThreshList_r16_Dynamic {
	size_t d;
	SQN_GWUS_PagingProbThresh_r16_e* v;
};

typedef struct SQN_GWUS_PagingProbThresh_r16_e_SQN_GWUS_ProbThreshList_r16_Dynamic SQN_GWUS_ProbThreshList_r16;

struct bool_SQN_GWUS_GroupNarrowBandList_r16_Dynamic {
	size_t d;
	bool* v;
};

typedef struct bool_SQN_GWUS_GroupNarrowBandList_r16_Dynamic SQN_GWUS_GroupNarrowBandList_r16;

struct SQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional {
	bool d;
	SQN_GWUS_Config_r16_groupAlternation_r16_e v;
};

struct SQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional {
	bool d;
	SQN_GWUS_Config_r16_commonSequence_r16_e v;
};

struct SQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional {
	bool d;
	struct SQN_GWUS_TimeParameters_r16 v;
};

struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional {
	bool d;
	struct SQN_GWUS_ResourceConfig_r16 v;
};

struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional {
	bool d;
	struct SQN_GWUS_ResourceConfig_r16 v;
};

struct SQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional {
	bool d;
	SQN_GWUS_ProbThreshList_r16 v;
};

struct SQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional {
	bool d;
	SQN_GWUS_GroupNarrowBandList_r16 v;
};

struct SQN_GWUS_Config_r16 {
	struct SQN_GWUS_Config_r16_groupAlternation_r16_e_groupAlternation_r16_Optional groupAlternation_r16;
	struct SQN_GWUS_Config_r16_commonSequence_r16_e_commonSequence_r16_Optional commonSequence_r16;
	struct SQN_GWUS_TimeParameters_r16_SQN_GWUS_Config_r16_timeParameters_r16_Optional timeParameters_r16;
	struct SQN_GWUS_ResourceConfig_r16 resourceConfigDRX_r16;
	struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Short_r16_Optional resourceConfig_eDRX_Short_r16;
	struct SQN_GWUS_ResourceConfig_r16_SQN_GWUS_Config_r16_resourceConfig_eDRX_Long_r16_Optional resourceConfig_eDRX_Long_r16;
	struct SQN_GWUS_ProbThreshList_r16_SQN_GWUS_Config_r16_probThreshList_r16_Optional probThreshList_r16;
	struct SQN_GWUS_GroupNarrowBandList_r16_SQN_GWUS_Config_r16_groupNarrowBandList_r16_Optional groupNarrowBandList_r16;
};

struct SQN_UplinkPowerControlCommon_v1610 {
	SQN_Alpha_r12_e alphaSRS_Add_r16;
	int8_t p0_NominalSRS_Add_r16;
};

enum SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e {
	SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_enabled = 0,
};

typedef enum SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e;

enum SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e {
	SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_enabled = 0,
};

typedef enum SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e;

struct SQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional {
	bool d;
	struct SQN_UplinkPowerControlCommon_v1020 v;
};

struct SQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional {
	bool d;
	struct SQN_RACH_ConfigCommon_v1250 v;
};

struct SQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional {
	bool d;
	struct SQN_PUSCH_ConfigCommon_v1270 v;
};

struct SQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional {
	bool d;
	struct SQN_BCCH_Config_v1310 v;
};

struct SQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional {
	bool d;
	struct SQN_PCCH_Config_v1310 v;
};

struct SQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional {
	bool d;
	struct SQN_FreqHoppingParameters_r13 v;
};

struct SQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional {
	bool d;
	struct SQN_PDSCH_ConfigCommon_v1310 v;
};

struct SQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional {
	bool d;
	struct SQN_PUSCH_ConfigCommon_v1310 v;
};

struct SQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional {
	bool d;
	struct SQN_PRACH_ConfigSIB_v1310 v;
};

struct SQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional {
	bool d;
	struct SQN_PUCCH_ConfigCommon_v1310 v;
};

struct SQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional {
	bool d;
	struct SQN_HighSpeedConfig_r14 v;
};

struct SQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional {
	bool d;
	struct SQN_PRACH_Config_v1430 v;
};

struct SQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional {
	bool d;
	struct SQN_PUCCH_ConfigCommon_v1430 v;
};

struct SQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional {
	bool d;
	struct SQN_PRACH_ConfigSIB_v1530 v;
};

struct SQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional {
	bool d;
	struct SQN_RSS_Config_r15 v;
};

struct SQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional {
	bool d;
	struct SQN_WUS_Config_r15 v;
};

struct SQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional {
	bool d;
	struct SQN_HighSpeedConfig_v1530 v;
};

struct SQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional {
	bool d;
	struct SQN_UplinkPowerControlCommon_v1530 v;
};

struct SQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional {
	bool d;
	struct SQN_WUS_Config_v1560 v;
};

struct SQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional {
	bool d;
	struct SQN_WUS_Config_v1610 v;
};

struct SQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional {
	bool d;
	struct SQN_HighSpeedConfig_v1610 v;
};

struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional {
	bool d;
	struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16 v;
};

struct SQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional {
	bool d;
	struct SQN_GWUS_Config_r16 v;
};

struct SQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional {
	bool d;
	struct SQN_UplinkPowerControlCommon_v1610 v;
};

struct SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional {
	bool d;
	SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e v;
};

struct SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional {
	bool d;
	SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e v;
};

struct B2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional {
	bool d;
	B2 v;
};

struct bool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional {
	bool d;
	bool v;
};

struct SQN_RadioResourceConfigCommonSIB {
	struct SQN_RACH_ConfigCommon rach_ConfigCommon;
	struct SQN_BCCH_Config bcch_Config;
	struct SQN_PCCH_Config pcch_Config;
	struct SQN_PRACH_ConfigSIB prach_Config;
	struct SQN_PDSCH_ConfigCommon pdsch_ConfigCommon;
	struct SQN_PUSCH_ConfigCommon pusch_ConfigCommon;
	struct SQN_PUCCH_ConfigCommon pucch_ConfigCommon;
	struct SQN_SoundingRS_UL_ConfigCommon soundingRS_UL_ConfigCommon;
	struct SQN_UplinkPowerControlCommon uplinkPowerControlCommon;
	SQN_UL_CyclicPrefixLength_e ul_CyclicPrefixLength;
	struct SQN_UplinkPowerControlCommon_v1020_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1020_Optional uplinkPowerControlCommon_v1020;
	struct SQN_RACH_ConfigCommon_v1250_SQN_RadioResourceConfigCommonSIB_rach_ConfigCommon_v1250_Optional rach_ConfigCommon_v1250;
	struct SQN_PUSCH_ConfigCommon_v1270_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1270_Optional pusch_ConfigCommon_v1270;
	struct SQN_BCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_bcch_Config_v1310_Optional bcch_Config_v1310;
	struct SQN_PCCH_Config_v1310_SQN_RadioResourceConfigCommonSIB_pcch_Config_v1310_Optional pcch_Config_v1310;
	struct SQN_FreqHoppingParameters_r13_SQN_RadioResourceConfigCommonSIB_freqHoppingParameters_r13_Optional freqHoppingParameters_r13;
	struct SQN_PDSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pdsch_ConfigCommon_v1310_Optional pdsch_ConfigCommon_v1310;
	struct SQN_PUSCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pusch_ConfigCommon_v1310_Optional pusch_ConfigCommon_v1310;
	struct SQN_PRACH_ConfigSIB_v1310_SQN_RadioResourceConfigCommonSIB_prach_ConfigCommon_v1310_Optional prach_ConfigCommon_v1310;
	struct SQN_PUCCH_ConfigCommon_v1310_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1310_Optional pucch_ConfigCommon_v1310;
	struct SQN_HighSpeedConfig_r14_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_r14_Optional highSpeedConfig_r14;
	struct SQN_PRACH_Config_v1430_SQN_RadioResourceConfigCommonSIB_prach_Config_v1430_Optional prach_Config_v1430;
	struct SQN_PUCCH_ConfigCommon_v1430_SQN_RadioResourceConfigCommonSIB_pucch_ConfigCommon_v1430_Optional pucch_ConfigCommon_v1430;
	struct SQN_PRACH_ConfigSIB_v1530_SQN_RadioResourceConfigCommonSIB_prach_Config_v1530_Optional prach_Config_v1530;
	struct SQN_RSS_Config_r15_SQN_RadioResourceConfigCommonSIB_ce_RSS_Config_r15_Optional ce_RSS_Config_r15;
	struct SQN_WUS_Config_r15_SQN_RadioResourceConfigCommonSIB_wus_Config_r15_Optional wus_Config_r15;
	struct SQN_HighSpeedConfig_v1530_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1530_Optional highSpeedConfig_v1530;
	struct SQN_UplinkPowerControlCommon_v1530_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1540_Optional uplinkPowerControlCommon_v1540;
	struct SQN_WUS_Config_v1560_SQN_RadioResourceConfigCommonSIB_wus_Config_v1560_Optional wus_Config_v1560;
	struct SQN_WUS_Config_v1610_SQN_RadioResourceConfigCommonSIB_wus_Config_v1610_Optional wus_Config_v1610;
	struct SQN_HighSpeedConfig_v1610_SQN_RadioResourceConfigCommonSIB_highSpeedConfig_v1610_Optional highSpeedConfig_v1610;
	struct SQN_CRS_ChEstMPDCCH_ConfigCommon_r16_SQN_RadioResourceConfigCommonSIB_crs_ChEstMPDCCH_ConfigCommon_r16_Optional crs_ChEstMPDCCH_ConfigCommon_r16;
	struct SQN_GWUS_Config_r16_SQN_RadioResourceConfigCommonSIB_gwus_Config_r16_Optional gwus_Config_r16;
	struct SQN_UplinkPowerControlCommon_v1610_SQN_RadioResourceConfigCommonSIB_uplinkPowerControlCommon_v1610_Optional uplinkPowerControlCommon_v1610;
	struct SQN_RadioResourceConfigCommonSIB_rss_MeasConfig_r16_e_rss_MeasConfig_r16_Optional rss_MeasConfig_r16;
	struct SQN_RadioResourceConfigCommonSIB_rss_MeasNonNCL_r16_e_rss_MeasNonNCL_r16_Optional rss_MeasNonNCL_r16;
	struct B2_SQN_RadioResourceConfigCommonSIB_puncturedSubcarriersDL_r16_Optional puncturedSubcarriersDL_r16;
	struct bool_SQN_RadioResourceConfigCommonSIB_highSpeedInterRAT_NR_r16_Optional highSpeedInterRAT_NR_r16;
};

enum SQN_UE_TimersAndConstants_t300_e {
	SQN_UE_TimersAndConstants_t300_e_ms100 = 0,
	SQN_UE_TimersAndConstants_t300_e_ms200 = 1,
	SQN_UE_TimersAndConstants_t300_e_ms300 = 2,
	SQN_UE_TimersAndConstants_t300_e_ms400 = 3,
	SQN_UE_TimersAndConstants_t300_e_ms600 = 4,
	SQN_UE_TimersAndConstants_t300_e_ms1000 = 5,
	SQN_UE_TimersAndConstants_t300_e_ms1500 = 6,
	SQN_UE_TimersAndConstants_t300_e_ms2000 = 7,
};

typedef enum SQN_UE_TimersAndConstants_t300_e SQN_UE_TimersAndConstants_t300_e;

enum SQN_UE_TimersAndConstants_t301_e {
	SQN_UE_TimersAndConstants_t301_e_ms100 = 0,
	SQN_UE_TimersAndConstants_t301_e_ms200 = 1,
	SQN_UE_TimersAndConstants_t301_e_ms300 = 2,
	SQN_UE_TimersAndConstants_t301_e_ms400 = 3,
	SQN_UE_TimersAndConstants_t301_e_ms600 = 4,
	SQN_UE_TimersAndConstants_t301_e_ms1000 = 5,
	SQN_UE_TimersAndConstants_t301_e_ms1500 = 6,
	SQN_UE_TimersAndConstants_t301_e_ms2000 = 7,
};

typedef enum SQN_UE_TimersAndConstants_t301_e SQN_UE_TimersAndConstants_t301_e;

enum SQN_UE_TimersAndConstants_t310_e {
	SQN_UE_TimersAndConstants_t310_e_ms0 = 0,
	SQN_UE_TimersAndConstants_t310_e_ms50 = 1,
	SQN_UE_TimersAndConstants_t310_e_ms100 = 2,
	SQN_UE_TimersAndConstants_t310_e_ms200 = 3,
	SQN_UE_TimersAndConstants_t310_e_ms500 = 4,
	SQN_UE_TimersAndConstants_t310_e_ms1000 = 5,
	SQN_UE_TimersAndConstants_t310_e_ms2000 = 6,
};

typedef enum SQN_UE_TimersAndConstants_t310_e SQN_UE_TimersAndConstants_t310_e;

enum SQN_UE_TimersAndConstants_n310_e {
	SQN_UE_TimersAndConstants_n310_e_n1 = 0,
	SQN_UE_TimersAndConstants_n310_e_n2 = 1,
	SQN_UE_TimersAndConstants_n310_e_n3 = 2,
	SQN_UE_TimersAndConstants_n310_e_n4 = 3,
	SQN_UE_TimersAndConstants_n310_e_n6 = 4,
	SQN_UE_TimersAndConstants_n310_e_n8 = 5,
	SQN_UE_TimersAndConstants_n310_e_n10 = 6,
	SQN_UE_TimersAndConstants_n310_e_n20 = 7,
};

typedef enum SQN_UE_TimersAndConstants_n310_e SQN_UE_TimersAndConstants_n310_e;

enum SQN_UE_TimersAndConstants_t311_e {
	SQN_UE_TimersAndConstants_t311_e_ms1000 = 0,
	SQN_UE_TimersAndConstants_t311_e_ms3000 = 1,
	SQN_UE_TimersAndConstants_t311_e_ms5000 = 2,
	SQN_UE_TimersAndConstants_t311_e_ms10000 = 3,
	SQN_UE_TimersAndConstants_t311_e_ms15000 = 4,
	SQN_UE_TimersAndConstants_t311_e_ms20000 = 5,
	SQN_UE_TimersAndConstants_t311_e_ms30000 = 6,
};

typedef enum SQN_UE_TimersAndConstants_t311_e SQN_UE_TimersAndConstants_t311_e;

enum SQN_UE_TimersAndConstants_n311_e {
	SQN_UE_TimersAndConstants_n311_e_n1 = 0,
	SQN_UE_TimersAndConstants_n311_e_n2 = 1,
	SQN_UE_TimersAndConstants_n311_e_n3 = 2,
	SQN_UE_TimersAndConstants_n311_e_n4 = 3,
	SQN_UE_TimersAndConstants_n311_e_n5 = 4,
	SQN_UE_TimersAndConstants_n311_e_n6 = 5,
	SQN_UE_TimersAndConstants_n311_e_n8 = 6,
	SQN_UE_TimersAndConstants_n311_e_n10 = 7,
};

typedef enum SQN_UE_TimersAndConstants_n311_e SQN_UE_TimersAndConstants_n311_e;

enum SQN_UE_TimersAndConstants_t300_v1310_e {
	SQN_UE_TimersAndConstants_t300_v1310_e_ms2500 = 0,
	SQN_UE_TimersAndConstants_t300_v1310_e_ms3000 = 1,
	SQN_UE_TimersAndConstants_t300_v1310_e_ms3500 = 2,
	SQN_UE_TimersAndConstants_t300_v1310_e_ms4000 = 3,
	SQN_UE_TimersAndConstants_t300_v1310_e_ms5000 = 4,
	SQN_UE_TimersAndConstants_t300_v1310_e_ms6000 = 5,
	SQN_UE_TimersAndConstants_t300_v1310_e_ms8000 = 6,
	SQN_UE_TimersAndConstants_t300_v1310_e_ms10000 = 7,
};

typedef enum SQN_UE_TimersAndConstants_t300_v1310_e SQN_UE_TimersAndConstants_t300_v1310_e;

enum SQN_UE_TimersAndConstants_t301_v1310_e {
	SQN_UE_TimersAndConstants_t301_v1310_e_ms2500 = 0,
	SQN_UE_TimersAndConstants_t301_v1310_e_ms3000 = 1,
	SQN_UE_TimersAndConstants_t301_v1310_e_ms3500 = 2,
	SQN_UE_TimersAndConstants_t301_v1310_e_ms4000 = 3,
	SQN_UE_TimersAndConstants_t301_v1310_e_ms5000 = 4,
	SQN_UE_TimersAndConstants_t301_v1310_e_ms6000 = 5,
	SQN_UE_TimersAndConstants_t301_v1310_e_ms8000 = 6,
	SQN_UE_TimersAndConstants_t301_v1310_e_ms10000 = 7,
};

typedef enum SQN_UE_TimersAndConstants_t301_v1310_e SQN_UE_TimersAndConstants_t301_v1310_e;

enum SQN_UE_TimersAndConstants_t310_v1330_e {
	SQN_UE_TimersAndConstants_t310_v1330_e_ms4000 = 0,
	SQN_UE_TimersAndConstants_t310_v1330_e_ms6000 = 1,
};

typedef enum SQN_UE_TimersAndConstants_t310_v1330_e SQN_UE_TimersAndConstants_t310_v1330_e;

enum SQN_UE_TimersAndConstants_t300_r15_e {
	SQN_UE_TimersAndConstants_t300_r15_e_ms4000 = 0,
	SQN_UE_TimersAndConstants_t300_r15_e_ms6000 = 1,
	SQN_UE_TimersAndConstants_t300_r15_e_ms8000 = 2,
	SQN_UE_TimersAndConstants_t300_r15_e_ms10000 = 3,
	SQN_UE_TimersAndConstants_t300_r15_e_ms15000 = 4,
	SQN_UE_TimersAndConstants_t300_r15_e_ms25000 = 5,
	SQN_UE_TimersAndConstants_t300_r15_e_ms40000 = 6,
	SQN_UE_TimersAndConstants_t300_r15_e_ms60000 = 7,
};

typedef enum SQN_UE_TimersAndConstants_t300_r15_e SQN_UE_TimersAndConstants_t300_r15_e;

struct SQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional {
	bool d;
	SQN_UE_TimersAndConstants_t300_v1310_e v;
};

struct SQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional {
	bool d;
	SQN_UE_TimersAndConstants_t301_v1310_e v;
};

struct SQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional {
	bool d;
	SQN_UE_TimersAndConstants_t310_v1330_e v;
};

struct SQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional {
	bool d;
	SQN_UE_TimersAndConstants_t300_r15_e v;
};

struct SQN_UE_TimersAndConstants {
	SQN_UE_TimersAndConstants_t300_e t300;
	SQN_UE_TimersAndConstants_t301_e t301;
	SQN_UE_TimersAndConstants_t310_e t310;
	SQN_UE_TimersAndConstants_n310_e n310;
	SQN_UE_TimersAndConstants_t311_e t311;
	SQN_UE_TimersAndConstants_n311_e n311;
	struct SQN_UE_TimersAndConstants_t300_v1310_e_t300_v1310_Optional t300_v1310;
	struct SQN_UE_TimersAndConstants_t301_v1310_e_t301_v1310_Optional t301_v1310;
	struct SQN_UE_TimersAndConstants_t310_v1330_e_t310_v1330_Optional t310_v1330;
	struct SQN_UE_TimersAndConstants_t300_r15_e_t300_r15_Optional t300_r15;
};

typedef uint16_t SQN_ARFCN_ValueEUTRA;

enum SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e {
	SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n6 = 0,
	SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n15 = 1,
	SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n25 = 2,
	SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n50 = 3,
	SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n75 = 4,
	SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_n100 = 5,
};

typedef enum SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e;

typedef uint8_t SQN_AdditionalSpectrumEmission;

struct SQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional {
	bool d;
	SQN_ARFCN_ValueEUTRA v;
};

struct SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional {
	bool d;
	SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e v;
};

struct SQN_SystemInformationBlockType2_freqInfo {
	struct SQN_ARFCN_ValueEUTRA_SQN_SystemInformationBlockType2_freqInfo_ul_CarrierFreq_Optional ul_CarrierFreq;
	struct SQN_SystemInformationBlockType2_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional ul_Bandwidth;
	SQN_AdditionalSpectrumEmission additionalSpectrumEmission;
};

enum SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e {
	SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n1 = 0,
	SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n2 = 1,
	SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n4 = 2,
	SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n8 = 3,
	SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n16 = 4,
	SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e_n32 = 5,
};

typedef enum SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e;

enum SQN_MBSFN_SubframeConfig_subframeAllocation_Sel {
	SQN_MBSFN_SubframeConfig_subframeAllocation_UNBOUND_VALUE = 0,
	SQN_MBSFN_SubframeConfig_subframeAllocation_oneFrame = 1,
	SQN_MBSFN_SubframeConfig_subframeAllocation_fourFrames = 2,
};

union SQN_MBSFN_SubframeConfig_subframeAllocation_Value {
	B6 oneFrame;
	B24 fourFrames;
};

struct SQN_MBSFN_SubframeConfig_subframeAllocation {
	enum SQN_MBSFN_SubframeConfig_subframeAllocation_Sel d;
	union SQN_MBSFN_SubframeConfig_subframeAllocation_Value v;
};

struct SQN_MBSFN_SubframeConfig {
	SQN_MBSFN_SubframeConfig_radioframeAllocationPeriod_e radioframeAllocationPeriod;
	uint8_t radioframeAllocationOffset;
	struct SQN_MBSFN_SubframeConfig_subframeAllocation subframeAllocation;
};

struct SQN_MBSFN_SubframeConfig_SQN_MBSFN_SubframeConfigList_Dynamic {
	size_t d;
	struct SQN_MBSFN_SubframeConfig* v;
};

typedef struct SQN_MBSFN_SubframeConfig_SQN_MBSFN_SubframeConfigList_Dynamic SQN_MBSFN_SubframeConfigList;

enum SQN_TimeAlignmentTimer_e {
	SQN_TimeAlignmentTimer_e_sf500 = 0,
	SQN_TimeAlignmentTimer_e_sf750 = 1,
	SQN_TimeAlignmentTimer_e_sf1280 = 2,
	SQN_TimeAlignmentTimer_e_sf1920 = 3,
	SQN_TimeAlignmentTimer_e_sf2560 = 4,
	SQN_TimeAlignmentTimer_e_sf5120 = 5,
	SQN_TimeAlignmentTimer_e_sf10240 = 6,
	SQN_TimeAlignmentTimer_e_infinity = 7,
};

typedef enum SQN_TimeAlignmentTimer_e SQN_TimeAlignmentTimer_e;

enum SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e {
	SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e;

enum SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e {
	SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e;

enum SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e {
	SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e;

struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12 {
	bool ac_BarringForEmergency_r12;
	struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Signalling_r12_Optional ac_BarringForMO_Signalling_r12;
	struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringForMO_Data_r12_Optional ac_BarringForMO_Data_r12;
};

enum SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e {
	SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_true = 0,
};

typedef enum SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e;

enum SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e {
	SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_true = 0,
};

typedef enum SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e;

enum SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e {
	SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_true = 0,
};

typedef enum SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e;

struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional {
	bool d;
	struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12 v;
};

struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional {
	bool d;
	SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e v;
};

struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional {
	bool d;
	SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e v;
};

struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional {
	bool d;
	SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e v;
};

struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringPerPLMN_r12 {
	uint8_t plmn_IdentityIndex_r12;
	struct SQN_AC_BarringPerPLMN_r12_ac_BarringInfo_r12_ac_BarringInfo_r12_Optional ac_BarringInfo_r12;
	struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional ac_BarringSkipForMMTELVoice_r12;
	struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional ac_BarringSkipForMMTELVideo_r12;
	struct SQN_AC_BarringPerPLMN_r12_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional ac_BarringSkipForSMS_r12;
	struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ac_BarringForCSFB_r12_Optional ac_BarringForCSFB_r12;
	struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Voice_r12_Optional ssac_BarringForMMTEL_Voice_r12;
	struct SQN_AC_BarringConfig_SQN_AC_BarringPerPLMN_r12_ssac_BarringForMMTEL_Video_r12_Optional ssac_BarringForMMTEL_Video_r12;
};

struct SQN_AC_BarringPerPLMN_r12_SQN_AC_BarringPerPLMN_List_r12_Dynamic {
	size_t d;
	struct SQN_AC_BarringPerPLMN_r12* v;
};

typedef struct SQN_AC_BarringPerPLMN_r12_SQN_AC_BarringPerPLMN_List_r12_Dynamic SQN_AC_BarringPerPLMN_List_r12;

enum SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e {
	SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e;

enum SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e {
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p00 = 0,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p05 = 1,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p10 = 2,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p15 = 3,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p20 = 4,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p25 = 5,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p30 = 6,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p40 = 7,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p50 = 8,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p60 = 9,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p70 = 10,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p75 = 11,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p80 = 12,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p85 = 13,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p90 = 14,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e_p95 = 15,
};

typedef enum SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e;

enum SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e {
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s4 = 0,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s8 = 1,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s16 = 2,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s32 = 3,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s64 = 4,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s128 = 5,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s256 = 6,
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e_s512 = 7,
};

typedef enum SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e;

struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13 {
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringFactor_r13_e ac_BarringFactor_r13;
	SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_ac_BarringTime_r13_e ac_BarringTime_r13;
};

struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional {
	bool d;
	struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13 v;
};

struct SQN_BarringPerACDC_Category_r13 {
	uint8_t acdc_Category_r13;
	struct SQN_BarringPerACDC_Category_r13_acdc_BarringConfig_r13_acdc_BarringConfig_r13_Optional acdc_BarringConfig_r13;
};

struct SQN_BarringPerACDC_Category_r13_SQN_BarringPerACDC_CategoryList_r13_Dynamic {
	size_t d;
	struct SQN_BarringPerACDC_Category_r13* v;
};

typedef struct SQN_BarringPerACDC_Category_r13_SQN_BarringPerACDC_CategoryList_r13_Dynamic SQN_BarringPerACDC_CategoryList_r13;

struct SQN_ACDC_BarringForCommon_r13 {
	bool acdc_HPLMNonly_r13;
	SQN_BarringPerACDC_CategoryList_r13 barringPerACDC_CategoryList_r13;
};

struct SQN_ACDC_BarringPerPLMN_r13 {
	uint8_t plmn_IdentityIndex_r13;
	bool acdc_OnlyForHPLMN_r13;
	SQN_BarringPerACDC_CategoryList_r13 barringPerACDC_CategoryList_r13;
};

struct SQN_ACDC_BarringPerPLMN_r13_SQN_ACDC_BarringPerPLMN_List_r13_Dynamic {
	size_t d;
	struct SQN_ACDC_BarringPerPLMN_r13* v;
};

typedef struct SQN_ACDC_BarringPerPLMN_r13_SQN_ACDC_BarringPerPLMN_List_r13_Dynamic SQN_ACDC_BarringPerPLMN_List_r13;

enum SQN_UDT_Restricting_r13_udt_Restricting_r13_e {
	SQN_UDT_Restricting_r13_udt_Restricting_r13_e_true = 0,
};

typedef enum SQN_UDT_Restricting_r13_udt_Restricting_r13_e SQN_UDT_Restricting_r13_udt_Restricting_r13_e;

enum SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e {
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s4 = 0,
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s8 = 1,
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s16 = 2,
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s32 = 3,
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s64 = 4,
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s128 = 5,
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s256 = 6,
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_s512 = 7,
};

typedef enum SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e;

struct SQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional {
	bool d;
	SQN_UDT_Restricting_r13_udt_Restricting_r13_e v;
};

struct SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional {
	bool d;
	SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e v;
};

struct SQN_UDT_Restricting_r13 {
	struct SQN_UDT_Restricting_r13_udt_Restricting_r13_e_udt_Restricting_r13_Optional udt_Restricting_r13;
	struct SQN_UDT_Restricting_r13_udt_RestrictingTime_r13_e_udt_RestrictingTime_r13_Optional udt_RestrictingTime_r13;
};

struct SQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional {
	bool d;
	struct SQN_UDT_Restricting_r13 v;
};

struct SQN_UDT_RestrictingPerPLMN_r13 {
	uint8_t plmn_IdentityIndex_r13;
	struct SQN_UDT_Restricting_r13_SQN_UDT_RestrictingPerPLMN_r13_udt_Restricting_r13_Optional udt_Restricting_r13;
};

struct SQN_UDT_RestrictingPerPLMN_r13_SQN_UDT_RestrictingPerPLMN_List_r13_Dynamic {
	size_t d;
	struct SQN_UDT_RestrictingPerPLMN_r13* v;
};

typedef struct SQN_UDT_RestrictingPerPLMN_r13_SQN_UDT_RestrictingPerPLMN_List_r13_Dynamic SQN_UDT_RestrictingPerPLMN_List_r13;

enum SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e {
	SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_true = 0,
};

typedef enum SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e;

enum SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e {
	SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_true = 0,
};

typedef enum SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e;

enum SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e {
	SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_true = 0,
};

typedef enum SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e;

struct SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional {
	bool d;
	SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e v;
};

struct SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional {
	bool d;
	SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e v;
};

struct SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional {
	bool d;
	SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e v;
};

struct SQN_CIOT_OptimisationPLMN_r13 {
	struct SQN_CIOT_OptimisationPLMN_r13_up_CIoT_EPS_Optimisation_r13_e_up_CIoT_EPS_Optimisation_r13_Optional up_CIoT_EPS_Optimisation_r13;
	struct SQN_CIOT_OptimisationPLMN_r13_cp_CIoT_EPS_Optimisation_r13_e_cp_CIoT_EPS_Optimisation_r13_Optional cp_CIoT_EPS_Optimisation_r13;
	struct SQN_CIOT_OptimisationPLMN_r13_attachWithoutPDN_Connectivity_r13_e_attachWithoutPDN_Connectivity_r13_Optional attachWithoutPDN_Connectivity_r13;
};

struct SQN_CIOT_OptimisationPLMN_r13_SQN_CIOT_EPS_OptimisationInfo_r13_Dynamic {
	size_t d;
	struct SQN_CIOT_OptimisationPLMN_r13* v;
};

typedef struct SQN_CIOT_OptimisationPLMN_r13_SQN_CIOT_EPS_OptimisationInfo_r13_Dynamic SQN_CIOT_EPS_OptimisationInfo_r13;

enum SQN_SystemInformationBlockType2_useFullResumeID_r13_e {
	SQN_SystemInformationBlockType2_useFullResumeID_r13_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_useFullResumeID_r13_e SQN_SystemInformationBlockType2_useFullResumeID_r13_e;

enum SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e {
	SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e;

enum SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Sel {
	SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_UNBOUND_VALUE = 0,
	SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_oneFrame_v1430 = 1,
	SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_fourFrames_v1430 = 2,
};

union SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value {
	B2 oneFrame_v1430;
	B8 fourFrames_v1430;
};

struct SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430 {
	enum SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Sel d;
	union SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430_Value v;
};

struct SQN_MBSFN_SubframeConfig_v1430 {
	struct SQN_MBSFN_SubframeConfig_v1430_subframeAllocation_v1430 subframeAllocation_v1430;
};

struct SQN_MBSFN_SubframeConfig_v1430_SQN_MBSFN_SubframeConfigList_v1430_Dynamic {
	size_t d;
	struct SQN_MBSFN_SubframeConfig_v1430* v;
};

typedef struct SQN_MBSFN_SubframeConfig_v1430_SQN_MBSFN_SubframeConfigList_v1430_Dynamic SQN_MBSFN_SubframeConfigList_v1430;

enum SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e {
	SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e;

enum SQN_PLMN_Info_r15_upperLayerIndication_r15_e {
	SQN_PLMN_Info_r15_upperLayerIndication_r15_e_true = 0,
};

typedef enum SQN_PLMN_Info_r15_upperLayerIndication_r15_e SQN_PLMN_Info_r15_upperLayerIndication_r15_e;

struct SQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional {
	bool d;
	SQN_PLMN_Info_r15_upperLayerIndication_r15_e v;
};

struct SQN_PLMN_Info_r15 {
	struct SQN_PLMN_Info_r15_upperLayerIndication_r15_e_upperLayerIndication_r15_Optional upperLayerIndication_r15;
};

struct SQN_PLMN_Info_r15_SQN_PLMN_InfoList_r15_Dynamic {
	size_t d;
	struct SQN_PLMN_Info_r15* v;
};

typedef struct SQN_PLMN_Info_r15_SQN_PLMN_InfoList_r15_Dynamic SQN_PLMN_InfoList_r15;

enum SQN_SystemInformationBlockType2_cp_EDT_r15_e {
	SQN_SystemInformationBlockType2_cp_EDT_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_cp_EDT_r15_e SQN_SystemInformationBlockType2_cp_EDT_r15_e;

enum SQN_SystemInformationBlockType2_up_EDT_r15_e {
	SQN_SystemInformationBlockType2_up_EDT_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_up_EDT_r15_e SQN_SystemInformationBlockType2_up_EDT_r15_e;

enum SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e {
	SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e;

enum SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e {
	SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e;

enum SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e {
	SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e;

enum SQN_SystemInformationBlockType2_rlos_Enabled_r16_e {
	SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_rlos_Enabled_r16_e SQN_SystemInformationBlockType2_rlos_Enabled_r16_e;

enum SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e {
	SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e;

enum SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e {
	SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e;

enum SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e {
	SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e;

enum SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e {
	SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e;

enum SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e {
	SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e;

enum SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e {
	SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e;

enum SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e {
	SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e;

enum SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e {
	SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_fourBits = 0,
	SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_both = 1,
};

typedef enum SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e;

enum SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e {
	SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e;

enum SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e {
	SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e;

struct SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional {
	bool d;
	struct SQN_SystemInformationBlockType2_ac_BarringInfo v;
};

struct SQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional {
	bool d;
	SQN_MBSFN_SubframeConfigList v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional {
	bool d;
	struct SQN_AC_BarringConfig v;
};

struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional {
	bool d;
	SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e v;
};

struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional {
	bool d;
	SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e v;
};

struct SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional {
	bool d;
	SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e v;
};

struct SQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional {
	bool d;
	SQN_AC_BarringPerPLMN_List_r12 v;
};

struct SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional {
	bool d;
	SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e v;
};

struct SQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional {
	bool d;
	struct SQN_ACDC_BarringForCommon_r13 v;
};

struct SQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional {
	bool d;
	SQN_ACDC_BarringPerPLMN_List_r13 v;
};

struct SQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional {
	bool d;
	struct SQN_UDT_Restricting_r13 v;
};

struct SQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional {
	bool d;
	SQN_UDT_RestrictingPerPLMN_List_r13 v;
};

struct SQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional {
	bool d;
	SQN_CIOT_EPS_OptimisationInfo_r13 v;
};

struct SQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional {
	bool d;
	SQN_SystemInformationBlockType2_useFullResumeID_r13_e v;
};

struct SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional {
	bool d;
	SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e v;
};

struct SQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional {
	bool d;
	SQN_MBSFN_SubframeConfigList_v1430 v;
};

struct SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional {
	bool d;
	SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e v;
};

struct SQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional {
	bool d;
	SQN_PLMN_InfoList_r15 v;
};

struct SQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType2_cp_EDT_r15_e v;
};

struct SQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType2_up_EDT_r15_e v;
};

struct SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e v;
};

struct SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e v;
};

struct SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e v;
};

struct SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_rlos_Enabled_r16_e v;
};

struct SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e v;
};

struct SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e v;
};

struct SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e v;
};

struct SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e v;
};

struct SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e v;
};

struct SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e v;
};

struct SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e v;
};

struct SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e v;
};

struct SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e v;
};

struct SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e v;
};

struct SQN_SystemInformationBlockType2 {
	struct SQN_SystemInformationBlockType2_ac_BarringInfo_ac_BarringInfo_Optional ac_BarringInfo;
	struct SQN_RadioResourceConfigCommonSIB radioResourceConfigCommon;
	struct SQN_UE_TimersAndConstants ue_TimersAndConstants;
	struct SQN_SystemInformationBlockType2_freqInfo freqInfo;
	struct SQN_MBSFN_SubframeConfigList_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_Optional mbsfn_SubframeConfigList;
	SQN_TimeAlignmentTimer_e timeAlignmentTimerCommon;
	struct OCTET_STRING_SQN_SystemInformationBlockType2_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Voice_r9_Optional ssac_BarringForMMTEL_Voice_r9;
	struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ssac_BarringForMMTEL_Video_r9_Optional ssac_BarringForMMTEL_Video_r9;
	struct SQN_AC_BarringConfig_SQN_SystemInformationBlockType2_ac_BarringForCSFB_r10_Optional ac_BarringForCSFB_r10;
	struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVoice_r12_e_ac_BarringSkipForMMTELVoice_r12_Optional ac_BarringSkipForMMTELVoice_r12;
	struct SQN_SystemInformationBlockType2_ac_BarringSkipForMMTELVideo_r12_e_ac_BarringSkipForMMTELVideo_r12_Optional ac_BarringSkipForMMTELVideo_r12;
	struct SQN_SystemInformationBlockType2_ac_BarringSkipForSMS_r12_e_ac_BarringSkipForSMS_r12_Optional ac_BarringSkipForSMS_r12;
	struct SQN_AC_BarringPerPLMN_List_r12_SQN_SystemInformationBlockType2_ac_BarringPerPLMN_List_r12_Optional ac_BarringPerPLMN_List_r12;
	struct SQN_SystemInformationBlockType2_voiceServiceCauseIndication_r12_e_voiceServiceCauseIndication_r12_Optional voiceServiceCauseIndication_r12;
	struct SQN_ACDC_BarringForCommon_r13_SQN_SystemInformationBlockType2_acdc_BarringForCommon_r13_Optional acdc_BarringForCommon_r13;
	struct SQN_ACDC_BarringPerPLMN_List_r13_SQN_SystemInformationBlockType2_acdc_BarringPerPLMN_List_r13_Optional acdc_BarringPerPLMN_List_r13;
	struct SQN_UDT_Restricting_r13_SQN_SystemInformationBlockType2_udt_RestrictingForCommon_r13_Optional udt_RestrictingForCommon_r13;
	struct SQN_UDT_RestrictingPerPLMN_List_r13_SQN_SystemInformationBlockType2_udt_RestrictingPerPLMN_List_r13_Optional udt_RestrictingPerPLMN_List_r13;
	struct SQN_CIOT_EPS_OptimisationInfo_r13_SQN_SystemInformationBlockType2_cIoT_EPS_OptimisationInfo_r13_Optional cIoT_EPS_OptimisationInfo_r13;
	struct SQN_SystemInformationBlockType2_useFullResumeID_r13_e_useFullResumeID_r13_Optional useFullResumeID_r13;
	struct SQN_SystemInformationBlockType2_unicastFreqHoppingInd_r13_e_unicastFreqHoppingInd_r13_Optional unicastFreqHoppingInd_r13;
	struct SQN_MBSFN_SubframeConfigList_v1430_SQN_SystemInformationBlockType2_mbsfn_SubframeConfigList_v1430_Optional mbsfn_SubframeConfigList_v1430;
	struct SQN_SystemInformationBlockType2_videoServiceCauseIndication_r14_e_videoServiceCauseIndication_r14_Optional videoServiceCauseIndication_r14;
	struct SQN_PLMN_InfoList_r15_SQN_SystemInformationBlockType2_plmn_InfoList_r15_Optional plmn_InfoList_r15;
	struct SQN_SystemInformationBlockType2_cp_EDT_r15_e_cp_EDT_r15_Optional cp_EDT_r15;
	struct SQN_SystemInformationBlockType2_up_EDT_r15_e_up_EDT_r15_Optional up_EDT_r15;
	struct SQN_SystemInformationBlockType2_idleModeMeasurements_r15_e_idleModeMeasurements_r15_Optional idleModeMeasurements_r15;
	struct SQN_SystemInformationBlockType2_reducedCP_LatencyEnabled_r15_e_reducedCP_LatencyEnabled_r15_Optional reducedCP_LatencyEnabled_r15;
	struct SQN_SystemInformationBlockType2_mbms_ROM_ServiceIndication_r15_e_mbms_ROM_ServiceIndication_r15_Optional mbms_ROM_ServiceIndication_r15;
	struct SQN_SystemInformationBlockType2_rlos_Enabled_r16_e_rlos_Enabled_r16_Optional rlos_Enabled_r16;
	struct SQN_SystemInformationBlockType2_earlySecurityReactivation_r16_e_earlySecurityReactivation_r16_Optional earlySecurityReactivation_r16;
	struct SQN_SystemInformationBlockType2_cp_EDT_5GC_r16_e_cp_EDT_5GC_r16_Optional cp_EDT_5GC_r16;
	struct SQN_SystemInformationBlockType2_up_EDT_5GC_r16_e_up_EDT_5GC_r16_Optional up_EDT_5GC_r16;
	struct SQN_SystemInformationBlockType2_cp_PUR_EPC_r16_e_cp_PUR_EPC_r16_Optional cp_PUR_EPC_r16;
	struct SQN_SystemInformationBlockType2_up_PUR_EPC_r16_e_up_PUR_EPC_r16_Optional up_PUR_EPC_r16;
	struct SQN_SystemInformationBlockType2_cp_PUR_5GC_r16_e_cp_PUR_5GC_r16_Optional cp_PUR_5GC_r16;
	struct SQN_SystemInformationBlockType2_up_PUR_5GC_r16_e_up_PUR_5GC_r16_Optional up_PUR_5GC_r16;
	struct SQN_SystemInformationBlockType2_mpdcch_CQI_Reporting_r16_e_mpdcch_CQI_Reporting_r16_Optional mpdcch_CQI_Reporting_r16;
	struct SQN_SystemInformationBlockType2_rai_ActivationEnh_r16_e_rai_ActivationEnh_r16_Optional rai_ActivationEnh_r16;
	struct SQN_SystemInformationBlockType2_idleModeMeasurementsNR_r16_e_idleModeMeasurementsNR_r16_Optional idleModeMeasurementsNR_r16;
};

enum SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e {
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB0 = 0,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB1 = 1,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB2 = 2,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB3 = 3,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB4 = 4,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB5 = 5,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB6 = 6,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB8 = 7,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB10 = 8,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB12 = 9,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB14 = 10,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB16 = 11,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB18 = 12,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB20 = 13,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB22 = 14,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e_dB24 = 15,
};

typedef enum SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e;

enum SQN_MobilityStateParameters_t_Evaluation_e {
	SQN_MobilityStateParameters_t_Evaluation_e_s30 = 0,
	SQN_MobilityStateParameters_t_Evaluation_e_s60 = 1,
	SQN_MobilityStateParameters_t_Evaluation_e_s120 = 2,
	SQN_MobilityStateParameters_t_Evaluation_e_s180 = 3,
	SQN_MobilityStateParameters_t_Evaluation_e_s240 = 4,
	SQN_MobilityStateParameters_t_Evaluation_e_spare3 = 5,
	SQN_MobilityStateParameters_t_Evaluation_e_spare2 = 6,
	SQN_MobilityStateParameters_t_Evaluation_e_spare1 = 7,
};

typedef enum SQN_MobilityStateParameters_t_Evaluation_e SQN_MobilityStateParameters_t_Evaluation_e;

enum SQN_MobilityStateParameters_t_HystNormal_e {
	SQN_MobilityStateParameters_t_HystNormal_e_s30 = 0,
	SQN_MobilityStateParameters_t_HystNormal_e_s60 = 1,
	SQN_MobilityStateParameters_t_HystNormal_e_s120 = 2,
	SQN_MobilityStateParameters_t_HystNormal_e_s180 = 3,
	SQN_MobilityStateParameters_t_HystNormal_e_s240 = 4,
	SQN_MobilityStateParameters_t_HystNormal_e_spare3 = 5,
	SQN_MobilityStateParameters_t_HystNormal_e_spare2 = 6,
	SQN_MobilityStateParameters_t_HystNormal_e_spare1 = 7,
};

typedef enum SQN_MobilityStateParameters_t_HystNormal_e SQN_MobilityStateParameters_t_HystNormal_e;

struct SQN_MobilityStateParameters {
	SQN_MobilityStateParameters_t_Evaluation_e t_Evaluation;
	SQN_MobilityStateParameters_t_HystNormal_e t_HystNormal;
	uint8_t n_CellChangeMedium;
	uint8_t n_CellChangeHigh;
};

enum SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e {
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_6 = 0,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_4 = 1,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB_2 = 2,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e_dB0 = 3,
};

typedef enum SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e;

enum SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e {
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_6 = 0,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_4 = 1,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB_2 = 2,
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e_dB0 = 3,
};

typedef enum SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e;

struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF {
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_Medium_e sf_Medium;
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF_sf_High_e sf_High;
};

struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars {
	struct SQN_MobilityStateParameters mobilityStateParameters;
	struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_q_HystSF q_HystSF;
};

struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional {
	bool d;
	struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars v;
};

struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon {
	SQN_SystemInformationBlockType3_cellReselectionInfoCommon_q_Hyst_e q_Hyst;
	struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon_speedStateReselectionPars_speedStateReselectionPars_Optional speedStateReselectionPars;
};

typedef uint8_t SQN_ReselectionThreshold;

typedef uint8_t SQN_CellReselectionPriority;

struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional {
	bool d;
	SQN_ReselectionThreshold v;
};

struct SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo {
	struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_s_NonIntraSearch_Optional s_NonIntraSearch;
	SQN_ReselectionThreshold threshServingLow;
	SQN_CellReselectionPriority cellReselectionPriority;
};

typedef int8_t SQN_Q_RxLevMin;

typedef int8_t SQN_P_Max;

enum SQN_AllowedMeasBandwidth_e {
	SQN_AllowedMeasBandwidth_e_mbw6 = 0,
	SQN_AllowedMeasBandwidth_e_mbw15 = 1,
	SQN_AllowedMeasBandwidth_e_mbw25 = 2,
	SQN_AllowedMeasBandwidth_e_mbw50 = 3,
	SQN_AllowedMeasBandwidth_e_mbw75 = 4,
	SQN_AllowedMeasBandwidth_e_mbw100 = 5,
};

typedef enum SQN_AllowedMeasBandwidth_e SQN_AllowedMeasBandwidth_e;

typedef bool SQN_PresenceAntennaPort1;

typedef B2 SQN_NeighCellConfig;

typedef uint8_t SQN_T_Reselection;

enum SQN_SpeedStateScaleFactors_sf_Medium_e {
	SQN_SpeedStateScaleFactors_sf_Medium_e_oDot25 = 0,
	SQN_SpeedStateScaleFactors_sf_Medium_e_oDot5 = 1,
	SQN_SpeedStateScaleFactors_sf_Medium_e_oDot75 = 2,
	SQN_SpeedStateScaleFactors_sf_Medium_e_lDot0 = 3,
};

typedef enum SQN_SpeedStateScaleFactors_sf_Medium_e SQN_SpeedStateScaleFactors_sf_Medium_e;

enum SQN_SpeedStateScaleFactors_sf_High_e {
	SQN_SpeedStateScaleFactors_sf_High_e_oDot25 = 0,
	SQN_SpeedStateScaleFactors_sf_High_e_oDot5 = 1,
	SQN_SpeedStateScaleFactors_sf_High_e_oDot75 = 2,
	SQN_SpeedStateScaleFactors_sf_High_e_lDot0 = 3,
};

typedef enum SQN_SpeedStateScaleFactors_sf_High_e SQN_SpeedStateScaleFactors_sf_High_e;

struct SQN_SpeedStateScaleFactors {
	SQN_SpeedStateScaleFactors_sf_Medium_e sf_Medium;
	SQN_SpeedStateScaleFactors_sf_High_e sf_High;
};

struct SQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional {
	bool d;
	SQN_P_Max v;
};

struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional {
	bool d;
	SQN_ReselectionThreshold v;
};

struct SQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional {
	bool d;
	SQN_AllowedMeasBandwidth_e v;
};

struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo {
	SQN_Q_RxLevMin q_RxLevMin;
	struct SQN_P_Max_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_p_Max_Optional p_Max;
	struct SQN_ReselectionThreshold_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_s_IntraSearch_Optional s_IntraSearch;
	struct SQN_AllowedMeasBandwidth_e_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_allowedMeasBandwidth_Optional allowedMeasBandwidth;
	SQN_PresenceAntennaPort1 presenceAntennaPort1;
	SQN_NeighCellConfig neighCellConfig;
	SQN_T_Reselection t_ReselectionEUTRA;
	struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo_t_ReselectionEUTRA_SF_Optional t_ReselectionEUTRA_SF;
};

typedef uint8_t SQN_ReselectionThresholdQ_r9;

struct SQN_SystemInformationBlockType3_s_IntraSearch_v920 {
	SQN_ReselectionThreshold s_IntraSearchP_r9;
	SQN_ReselectionThresholdQ_r9 s_IntraSearchQ_r9;
};

struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920 {
	SQN_ReselectionThreshold s_NonIntraSearchP_r9;
	SQN_ReselectionThresholdQ_r9 s_NonIntraSearchQ_r9;
};

typedef int8_t SQN_Q_QualMin_r9;

enum SQN_CellReselectionSubPriority_r13_e {
	SQN_CellReselectionSubPriority_r13_e_oDot2 = 0,
	SQN_CellReselectionSubPriority_r13_e_oDot4 = 1,
	SQN_CellReselectionSubPriority_r13_e_oDot6 = 2,
	SQN_CellReselectionSubPriority_r13_e_oDot8 = 3,
};

typedef enum SQN_CellReselectionSubPriority_r13_e SQN_CellReselectionSubPriority_r13_e;

struct SQN_CellReselectionServingFreqInfo_v1310 {
	SQN_CellReselectionSubPriority_r13_e cellReselectionSubPriority_r13;
};

enum SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e {
	SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_true = 0,
};

typedef enum SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e;

enum SQN_RedistributionServingInfo_r13_t360_r13_e {
	SQN_RedistributionServingInfo_r13_t360_r13_e_min4 = 0,
	SQN_RedistributionServingInfo_r13_t360_r13_e_min8 = 1,
	SQN_RedistributionServingInfo_r13_t360_r13_e_min16 = 2,
	SQN_RedistributionServingInfo_r13_t360_r13_e_min32 = 3,
	SQN_RedistributionServingInfo_r13_t360_r13_e_infinity = 4,
	SQN_RedistributionServingInfo_r13_t360_r13_e_spare3 = 5,
	SQN_RedistributionServingInfo_r13_t360_r13_e_spare2 = 6,
	SQN_RedistributionServingInfo_r13_t360_r13_e_spare1 = 7,
};

typedef enum SQN_RedistributionServingInfo_r13_t360_r13_e SQN_RedistributionServingInfo_r13_t360_r13_e;

enum SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e {
	SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_true = 0,
};

typedef enum SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e;

struct SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional {
	bool d;
	SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e v;
};

struct SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional {
	bool d;
	SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e v;
};

struct SQN_RedistributionServingInfo_r13 {
	uint8_t redistributionFactorServing_r13;
	struct SQN_RedistributionServingInfo_r13_redistributionFactorCell_r13_e_redistributionFactorCell_r13_Optional redistributionFactorCell_r13;
	SQN_RedistributionServingInfo_r13_t360_r13_e t360_r13;
	struct SQN_RedistributionServingInfo_r13_redistrOnPagingOnly_r13_e_redistrOnPagingOnly_r13_Optional redistrOnPagingOnly_r13;
};

struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_CellSelectionInfoCE_r13 {
	SQN_Q_RxLevMin q_RxLevMinCE_r13;
	struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE_r13_q_QualMinRSRQ_CE_r13_Optional q_QualMinRSRQ_CE_r13;
};

typedef uint8_t SQN_T_ReselectionEUTRA_CE_r13;

struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_CellSelectionInfoCE1_r13 {
	SQN_Q_RxLevMin q_RxLevMinCE1_r13;
	struct SQN_Q_QualMin_r9_SQN_CellSelectionInfoCE1_r13_q_QualMinRSRQ_CE1_r13_Optional q_QualMinRSRQ_CE1_r13;
};

struct SQN_CellSelectionInfoCE1_v1360 {
	int8_t delta_RxLevMinCE1_v1360;
};

enum SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e {
	SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB6 = 0,
	SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB9 = 1,
	SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB12 = 2,
	SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e_dB15 = 3,
};

typedef enum SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e;

struct SQN_CellReselectionInfoCommon_v1460 {
	SQN_CellReselectionInfoCommon_v1460_s_SearchDeltaP_r14_e s_SearchDeltaP_r14;
};

struct SQN_CellReselectionInfoHSDN_r15 {
	uint8_t cellEquivalentSize_r15;
};

enum SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e {
	SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB_6 = 0,
	SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB_3 = 1,
	SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB3 = 2,
	SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB6 = 3,
	SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB9 = 4,
	SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e_dB12 = 5,
};

typedef enum SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e;

struct SQN_CellSelectionInfoCE_v1530 {
	SQN_CellSelectionInfoCE_v1530_powerClass14dBm_Offset_r15_e powerClass14dBm_Offset_r15;
};

enum SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e {
	SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_enabled = 0,
};

typedef enum SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e;

struct SQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional {
	bool d;
	SQN_CellReselectionSubPriority_r13_e v;
};

struct SQN_CellReselectionServingFreqInfo_v1610 {
	struct SQN_CellReselectionPriority_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionPriority_r16_Optional altCellReselectionPriority_r16;
	struct SQN_CellReselectionSubPriority_r13_e_SQN_CellReselectionServingFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional altCellReselectionSubPriority_r16;
};

struct OCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional {
	bool d;
	struct SQN_SystemInformationBlockType3_s_IntraSearch_v920 v;
};

struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional {
	bool d;
	struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920 v;
};

struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional {
	bool d;
	SQN_ReselectionThresholdQ_r9 v;
};

struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional {
	bool d;
	struct SQN_CellReselectionServingFreqInfo_v1310 v;
};

struct SQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional {
	bool d;
	struct SQN_RedistributionServingInfo_r13 v;
};

struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE_r13 v;
};

struct SQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional {
	bool d;
	SQN_T_ReselectionEUTRA_CE_r13 v;
};

struct SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE1_r13 v;
};

struct SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE1_v1360 v;
};

struct SQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional {
	bool d;
	struct SQN_CellReselectionInfoCommon_v1460 v;
};

struct SQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional {
	bool d;
	struct SQN_CellReselectionInfoHSDN_r15 v;
};

struct SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE_v1530 v;
};

struct SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e v;
};

struct SQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional {
	bool d;
	struct SQN_CellReselectionServingFreqInfo_v1610 v;
};

struct SQN_SystemInformationBlockType3 {
	struct SQN_SystemInformationBlockType3_cellReselectionInfoCommon cellReselectionInfoCommon;
	struct SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo cellReselectionServingFreqInfo;
	struct SQN_SystemInformationBlockType3_intraFreqCellReselectionInfo intraFreqCellReselectionInfo;
	struct OCTET_STRING_SQN_SystemInformationBlockType3_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SystemInformationBlockType3_s_IntraSearch_v920_s_IntraSearch_v920_Optional s_IntraSearch_v920;
	struct SQN_SystemInformationBlockType3_s_NonIntraSearch_v920_s_NonIntraSearch_v920_Optional s_NonIntraSearch_v920;
	struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMin_r9_Optional q_QualMin_r9;
	struct SQN_ReselectionThresholdQ_r9_SQN_SystemInformationBlockType3_threshServingLowQ_r9_Optional threshServingLowQ_r9;
	struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinWB_r11_Optional q_QualMinWB_r11;
	struct SQN_Q_QualMin_r9_SQN_SystemInformationBlockType3_q_QualMinRSRQ_OnAllSymbols_r12_Optional q_QualMinRSRQ_OnAllSymbols_r12;
	struct SQN_CellReselectionServingFreqInfo_v1310_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1310_Optional cellReselectionServingFreqInfo_v1310;
	struct SQN_RedistributionServingInfo_r13_SQN_SystemInformationBlockType3_redistributionServingInfo_r13_Optional redistributionServingInfo_r13;
	struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE_r13_Optional cellSelectionInfoCE_r13;
	struct SQN_T_ReselectionEUTRA_CE_r13_SQN_SystemInformationBlockType3_t_ReselectionEUTRA_CE_r13_Optional t_ReselectionEUTRA_CE_r13;
	struct SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_r13_Optional cellSelectionInfoCE1_r13;
	struct SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType3_cellSelectionInfoCE1_v1360_Optional cellSelectionInfoCE1_v1360;
	struct SQN_CellReselectionInfoCommon_v1460_SQN_SystemInformationBlockType3_cellReselectionInfoCommon_v1460_Optional cellReselectionInfoCommon_v1460;
	struct SQN_CellReselectionInfoHSDN_r15_SQN_SystemInformationBlockType3_cellReselectionInfoHSDN_r15_Optional cellReselectionInfoHSDN_r15;
	struct SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType3_cellSelectionInfoCE_v1530_Optional cellSelectionInfoCE_v1530;
	struct SQN_SystemInformationBlockType3_crs_IntfMitigNeighCellsCE_r15_e_crs_IntfMitigNeighCellsCE_r15_Optional crs_IntfMitigNeighCellsCE_r15;
	struct SQN_CellReselectionServingFreqInfo_v1610_SQN_SystemInformationBlockType3_cellReselectionServingFreqInfo_v1610_Optional cellReselectionServingFreqInfo_v1610;
};

typedef uint16_t SQN_PhysCellId;

enum SQN_Q_OffsetRange_e {
	SQN_Q_OffsetRange_e_dB_24 = 0,
	SQN_Q_OffsetRange_e_dB_22 = 1,
	SQN_Q_OffsetRange_e_dB_20 = 2,
	SQN_Q_OffsetRange_e_dB_18 = 3,
	SQN_Q_OffsetRange_e_dB_16 = 4,
	SQN_Q_OffsetRange_e_dB_14 = 5,
	SQN_Q_OffsetRange_e_dB_12 = 6,
	SQN_Q_OffsetRange_e_dB_10 = 7,
	SQN_Q_OffsetRange_e_dB_8 = 8,
	SQN_Q_OffsetRange_e_dB_6 = 9,
	SQN_Q_OffsetRange_e_dB_5 = 10,
	SQN_Q_OffsetRange_e_dB_4 = 11,
	SQN_Q_OffsetRange_e_dB_3 = 12,
	SQN_Q_OffsetRange_e_dB_2 = 13,
	SQN_Q_OffsetRange_e_dB_1 = 14,
	SQN_Q_OffsetRange_e_dB0 = 15,
	SQN_Q_OffsetRange_e_dB1 = 16,
	SQN_Q_OffsetRange_e_dB2 = 17,
	SQN_Q_OffsetRange_e_dB3 = 18,
	SQN_Q_OffsetRange_e_dB4 = 19,
	SQN_Q_OffsetRange_e_dB5 = 20,
	SQN_Q_OffsetRange_e_dB6 = 21,
	SQN_Q_OffsetRange_e_dB8 = 22,
	SQN_Q_OffsetRange_e_dB10 = 23,
	SQN_Q_OffsetRange_e_dB12 = 24,
	SQN_Q_OffsetRange_e_dB14 = 25,
	SQN_Q_OffsetRange_e_dB16 = 26,
	SQN_Q_OffsetRange_e_dB18 = 27,
	SQN_Q_OffsetRange_e_dB20 = 28,
	SQN_Q_OffsetRange_e_dB22 = 29,
	SQN_Q_OffsetRange_e_dB24 = 30,
};

typedef enum SQN_Q_OffsetRange_e SQN_Q_OffsetRange_e;

struct SQN_IntraFreqNeighCellInfo {
	SQN_PhysCellId physCellId;
	SQN_Q_OffsetRange_e q_OffsetCell;
};

struct SQN_IntraFreqNeighCellInfo_SQN_IntraFreqNeighCellList_Dynamic {
	size_t d;
	struct SQN_IntraFreqNeighCellInfo* v;
};

typedef struct SQN_IntraFreqNeighCellInfo_SQN_IntraFreqNeighCellList_Dynamic SQN_IntraFreqNeighCellList;

enum SQN_PhysCellIdRange_range_e {
	SQN_PhysCellIdRange_range_e_n4 = 0,
	SQN_PhysCellIdRange_range_e_n8 = 1,
	SQN_PhysCellIdRange_range_e_n12 = 2,
	SQN_PhysCellIdRange_range_e_n16 = 3,
	SQN_PhysCellIdRange_range_e_n24 = 4,
	SQN_PhysCellIdRange_range_e_n32 = 5,
	SQN_PhysCellIdRange_range_e_n48 = 6,
	SQN_PhysCellIdRange_range_e_n64 = 7,
	SQN_PhysCellIdRange_range_e_n84 = 8,
	SQN_PhysCellIdRange_range_e_n96 = 9,
	SQN_PhysCellIdRange_range_e_n128 = 10,
	SQN_PhysCellIdRange_range_e_n168 = 11,
	SQN_PhysCellIdRange_range_e_n252 = 12,
	SQN_PhysCellIdRange_range_e_n504 = 13,
	SQN_PhysCellIdRange_range_e_spare2 = 14,
	SQN_PhysCellIdRange_range_e_spare1 = 15,
};

typedef enum SQN_PhysCellIdRange_range_e SQN_PhysCellIdRange_range_e;

struct SQN_PhysCellIdRange_range_e_range_Optional {
	bool d;
	SQN_PhysCellIdRange_range_e v;
};

struct SQN_PhysCellIdRange {
	SQN_PhysCellId start;
	struct SQN_PhysCellIdRange_range_e_range_Optional range;
};

struct SQN_PhysCellIdRange_SQN_IntraFreqBlackCellList_Dynamic {
	size_t d;
	struct SQN_PhysCellIdRange* v;
};

typedef struct SQN_PhysCellIdRange_SQN_IntraFreqBlackCellList_Dynamic SQN_IntraFreqBlackCellList;

struct SQN_PhysCellIdRange_SQN_IntraFreqNeighHSDN_CellList_r15_Dynamic {
	size_t d;
	struct SQN_PhysCellIdRange* v;
};

typedef struct SQN_PhysCellIdRange_SQN_IntraFreqNeighHSDN_CellList_r15_Dynamic SQN_IntraFreqNeighHSDN_CellList_r15;

enum SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e {
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g1 = 0,
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g2 = 1,
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g4 = 2,
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g8 = 3,
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g16 = 4,
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g32 = 5,
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g64 = 6,
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e_g128 = 7,
};

typedef enum SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e;

struct SQN_RSS_ConfigCarrierInfo_r16 {
	BIT_STRING narrowbandIndex_r16;
	SQN_RSS_ConfigCarrierInfo_r16_timeOffsetGranularity_r16_e timeOffsetGranularity_r16;
};

enum SQN_RSS_MeasPowerBias_r16_e {
	SQN_RSS_MeasPowerBias_r16_e_dB_6 = 0,
	SQN_RSS_MeasPowerBias_r16_e_dB_3 = 1,
	SQN_RSS_MeasPowerBias_r16_e_dB0 = 2,
	SQN_RSS_MeasPowerBias_r16_e_dB3 = 3,
	SQN_RSS_MeasPowerBias_r16_e_dB6 = 4,
	SQN_RSS_MeasPowerBias_r16_e_dB9 = 5,
	SQN_RSS_MeasPowerBias_r16_e_dB12 = 6,
	SQN_RSS_MeasPowerBias_r16_e_rssNotUsed = 7,
};

typedef enum SQN_RSS_MeasPowerBias_r16_e SQN_RSS_MeasPowerBias_r16_e;

struct SQN_IntraFreqNeighCellInfo_v1610 {
	SQN_RSS_MeasPowerBias_r16_e rss_MeasPowerBias_r16;
};

struct SQN_IntraFreqNeighCellInfo_v1610_SQN_IntraFreqNeighCellList_v1610_Dynamic {
	size_t d;
	struct SQN_IntraFreqNeighCellInfo_v1610* v;
};

typedef struct SQN_IntraFreqNeighCellInfo_v1610_SQN_IntraFreqNeighCellList_v1610_Dynamic SQN_IntraFreqNeighCellList_v1610;

struct SQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional {
	bool d;
	SQN_IntraFreqNeighCellList v;
};

struct SQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional {
	bool d;
	SQN_IntraFreqBlackCellList v;
};

struct SQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional {
	bool d;
	struct SQN_PhysCellIdRange v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional {
	bool d;
	SQN_IntraFreqNeighHSDN_CellList_r15 v;
};

struct SQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional {
	bool d;
	struct SQN_RSS_ConfigCarrierInfo_r16 v;
};

struct SQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional {
	bool d;
	SQN_IntraFreqNeighCellList_v1610 v;
};

struct SQN_SystemInformationBlockType4 {
	struct SQN_IntraFreqNeighCellList_SQN_SystemInformationBlockType4_intraFreqNeighCellList_Optional intraFreqNeighCellList;
	struct SQN_IntraFreqBlackCellList_SQN_SystemInformationBlockType4_intraFreqBlackCellList_Optional intraFreqBlackCellList;
	struct SQN_PhysCellIdRange_SQN_SystemInformationBlockType4_csg_PhysCellIdRange_Optional csg_PhysCellIdRange;
	struct OCTET_STRING_SQN_SystemInformationBlockType4_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_IntraFreqNeighHSDN_CellList_r15_SQN_SystemInformationBlockType4_intraFreqNeighHSDN_CellList_r15_Optional intraFreqNeighHSDN_CellList_r15;
	struct SQN_RSS_ConfigCarrierInfo_r16_SQN_SystemInformationBlockType4_rss_ConfigCarrierInfo_r16_Optional rss_ConfigCarrierInfo_r16;
	struct SQN_IntraFreqNeighCellList_v1610_SQN_SystemInformationBlockType4_intraFreqNeighCellList_v1610_Optional intraFreqNeighCellList_v1610;
};

struct SQN_InterFreqNeighCellInfo {
	SQN_PhysCellId physCellId;
	SQN_Q_OffsetRange_e q_OffsetCell;
};

struct SQN_InterFreqNeighCellInfo_SQN_InterFreqNeighCellList_Dynamic {
	size_t d;
	struct SQN_InterFreqNeighCellInfo* v;
};

typedef struct SQN_InterFreqNeighCellInfo_SQN_InterFreqNeighCellList_Dynamic SQN_InterFreqNeighCellList;

struct SQN_PhysCellIdRange_SQN_InterFreqBlackCellList_Dynamic {
	size_t d;
	struct SQN_PhysCellIdRange* v;
};

typedef struct SQN_PhysCellIdRange_SQN_InterFreqBlackCellList_Dynamic SQN_InterFreqBlackCellList;

struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9 {
	SQN_ReselectionThresholdQ_r9 threshX_HighQ_r9;
	SQN_ReselectionThresholdQ_r9 threshX_LowQ_r9;
};

struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional {
	bool d;
	SQN_P_Max v;
};

struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional {
	bool d;
	SQN_Q_OffsetRange_e v;
};

struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional {
	bool d;
	SQN_InterFreqNeighCellList v;
};

struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional {
	bool d;
	SQN_InterFreqBlackCellList v;
};

struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional {
	bool d;
	struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9 v;
};

struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_InterFreqCarrierFreqInfo {
	SQN_ARFCN_ValueEUTRA dl_CarrierFreq;
	SQN_Q_RxLevMin q_RxLevMin;
	struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_p_Max_Optional p_Max;
	SQN_T_Reselection t_ReselectionEUTRA;
	struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_t_ReselectionEUTRA_SF_Optional t_ReselectionEUTRA_SF;
	SQN_ReselectionThreshold threshX_High;
	SQN_ReselectionThreshold threshX_Low;
	SQN_AllowedMeasBandwidth_e allowedMeasBandwidth;
	SQN_PresenceAntennaPort1 presenceAntennaPort1;
	struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_cellReselectionPriority_Optional cellReselectionPriority;
	SQN_NeighCellConfig neighCellConfig;
	struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_q_OffsetFreq_Optional q_OffsetFreq;
	struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_interFreqNeighCellList_Optional interFreqNeighCellList;
	struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_interFreqBlackCellList_Optional interFreqBlackCellList;
	struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMin_r9_Optional q_QualMin_r9;
	struct SQN_InterFreqCarrierFreqInfo_threshX_Q_r9_threshX_Q_r9_Optional threshX_Q_r9;
	struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_q_QualMinWB_r11_Optional q_QualMinWB_r11;
};

struct SQN_InterFreqCarrierFreqInfo_SQN_InterFreqCarrierFreqList_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_SQN_InterFreqCarrierFreqList_Dynamic SQN_InterFreqCarrierFreqList;

enum SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e {
	SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_true = 0,
};

typedef enum SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e;

struct SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional {
	bool d;
	SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e v;
};

struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_InterFreqCarrierFreqInfo_v1250 {
	struct SQN_InterFreqCarrierFreqInfo_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional reducedMeasPerformance_r12;
	struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_v1250_q_QualMinRSRQ_OnAllSymbols_r12_Optional q_QualMinRSRQ_OnAllSymbols_r12;
};

struct SQN_InterFreqCarrierFreqInfo_v1250_SQN_InterFreqCarrierFreqList_v1250_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1250* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1250_SQN_InterFreqCarrierFreqList_v1250_Dynamic SQN_InterFreqCarrierFreqList_v1250;

typedef uint32_t SQN_ARFCN_ValueEUTRA_r9;

struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12 {
	SQN_ReselectionThresholdQ_r9 threshX_HighQ_r12;
	SQN_ReselectionThresholdQ_r9 threshX_LowQ_r12;
};

typedef uint16_t SQN_FreqBandIndicator_r11;

struct SQN_FreqBandIndicator_r11_SQN_MultiBandInfoList_r11_Dynamic {
	size_t d;
	SQN_FreqBandIndicator_r11* v;
};

typedef struct SQN_FreqBandIndicator_r11_SQN_MultiBandInfoList_r11_Dynamic SQN_MultiBandInfoList_r11;

enum SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e {
	SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_true = 0,
};

typedef enum SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e;

struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional {
	bool d;
	SQN_P_Max v;
};

struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional {
	bool d;
	SQN_Q_OffsetRange_e v;
};

struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional {
	bool d;
	SQN_InterFreqNeighCellList v;
};

struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional {
	bool d;
	SQN_InterFreqBlackCellList v;
};

struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional {
	bool d;
	struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12 v;
};

struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional {
	bool d;
	SQN_MultiBandInfoList_r11 v;
};

struct SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional {
	bool d;
	SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e v;
};

struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional {
	bool d;
	SQN_Q_QualMin_r9 v;
};

struct SQN_InterFreqCarrierFreqInfo_r12 {
	SQN_ARFCN_ValueEUTRA_r9 dl_CarrierFreq_r12;
	SQN_Q_RxLevMin q_RxLevMin_r12;
	struct SQN_P_Max_SQN_InterFreqCarrierFreqInfo_r12_p_Max_r12_Optional p_Max_r12;
	SQN_T_Reselection t_ReselectionEUTRA_r12;
	struct SQN_SpeedStateScaleFactors_SQN_InterFreqCarrierFreqInfo_r12_t_ReselectionEUTRA_SF_r12_Optional t_ReselectionEUTRA_SF_r12;
	SQN_ReselectionThreshold threshX_High_r12;
	SQN_ReselectionThreshold threshX_Low_r12;
	SQN_AllowedMeasBandwidth_e allowedMeasBandwidth_r12;
	SQN_PresenceAntennaPort1 presenceAntennaPort1_r12;
	struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_r12_cellReselectionPriority_r12_Optional cellReselectionPriority_r12;
	SQN_NeighCellConfig neighCellConfig_r12;
	struct SQN_Q_OffsetRange_e_SQN_InterFreqCarrierFreqInfo_r12_q_OffsetFreq_r12_Optional q_OffsetFreq_r12;
	struct SQN_InterFreqNeighCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqNeighCellList_r12_Optional interFreqNeighCellList_r12;
	struct SQN_InterFreqBlackCellList_SQN_InterFreqCarrierFreqInfo_r12_interFreqBlackCellList_r12_Optional interFreqBlackCellList_r12;
	struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMin_r12_Optional q_QualMin_r12;
	struct SQN_InterFreqCarrierFreqInfo_r12_threshX_Q_r12_threshX_Q_r12_Optional threshX_Q_r12;
	struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinWB_r12_Optional q_QualMinWB_r12;
	struct SQN_MultiBandInfoList_r11_SQN_InterFreqCarrierFreqInfo_r12_multiBandInfoList_r12_Optional multiBandInfoList_r12;
	struct SQN_InterFreqCarrierFreqInfo_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional reducedMeasPerformance_r12;
	struct SQN_Q_QualMin_r9_SQN_InterFreqCarrierFreqInfo_r12_q_QualMinRSRQ_OnAllSymbols_r12_Optional q_QualMinRSRQ_OnAllSymbols_r12;
};

struct SQN_InterFreqCarrierFreqInfo_r12_SQN_InterFreqCarrierFreqListExt_r12_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_r12* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_r12_SQN_InterFreqCarrierFreqListExt_r12_Dynamic SQN_InterFreqCarrierFreqListExt_r12;

struct SQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional {
	bool d;
	SQN_P_Max v;
};

struct SQN_NS_PmaxValue_r10 {
	struct SQN_P_Max_SQN_NS_PmaxValue_r10_additionalPmax_r10_Optional additionalPmax_r10;
	SQN_AdditionalSpectrumEmission additionalSpectrumEmission;
};

struct SQN_NS_PmaxValue_r10_SQN_NS_PmaxList_r10_Dynamic {
	size_t d;
	struct SQN_NS_PmaxValue_r10* v;
};

typedef struct SQN_NS_PmaxValue_r10_SQN_NS_PmaxList_r10_Dynamic SQN_NS_PmaxList_r10;

struct SQN_NS_PmaxList_r10_SQN_MultiBandInfoList_v10j0_Dynamic {
	size_t d;
	SQN_NS_PmaxList_r10* v;
};

typedef struct SQN_NS_PmaxList_r10_SQN_MultiBandInfoList_v10j0_Dynamic SQN_MultiBandInfoList_v10j0;

struct SQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional {
	bool d;
	SQN_NS_PmaxList_r10 v;
};

struct SQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional {
	bool d;
	SQN_MultiBandInfoList_v10j0 v;
};

struct SQN_InterFreqCarrierFreqInfo_v10j0 {
	struct SQN_NS_PmaxList_r10_SQN_InterFreqCarrierFreqInfo_v10j0_freqBandInfo_r10_Optional freqBandInfo_r10;
	struct SQN_MultiBandInfoList_v10j0_SQN_InterFreqCarrierFreqInfo_v10j0_multiBandInfoList_v10j0_Optional multiBandInfoList_v10j0;
};

struct SQN_InterFreqCarrierFreqInfo_v10j0_SQN_InterFreqCarrierFreqListExt_v1280_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v10j0* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v10j0_SQN_InterFreqCarrierFreqListExt_v1280_Dynamic SQN_InterFreqCarrierFreqListExt_v1280;

typedef uint8_t SQN_RedistributionFactor_r13;

struct SQN_RedistributionNeighCell_r13 {
	SQN_PhysCellId physCellId_r13;
	SQN_RedistributionFactor_r13 redistributionFactorCell_r13;
};

struct SQN_RedistributionNeighCell_r13_SQN_RedistributionNeighCellList_r13_Dynamic {
	size_t d;
	struct SQN_RedistributionNeighCell_r13* v;
};

typedef struct SQN_RedistributionNeighCell_r13_SQN_RedistributionNeighCellList_r13_Dynamic SQN_RedistributionNeighCellList_r13;

struct SQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional {
	bool d;
	SQN_RedistributionFactor_r13 v;
};

struct SQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional {
	bool d;
	SQN_RedistributionNeighCellList_r13 v;
};

struct SQN_RedistributionInterFreqInfo_r13 {
	struct SQN_RedistributionFactor_r13_SQN_RedistributionInterFreqInfo_r13_redistributionFactorFreq_r13_Optional redistributionFactorFreq_r13;
	struct SQN_RedistributionNeighCellList_r13_SQN_RedistributionInterFreqInfo_r13_redistributionNeighCellList_r13_Optional redistributionNeighCellList_r13;
};

struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional {
	bool d;
	SQN_CellReselectionSubPriority_r13_e v;
};

struct SQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional {
	bool d;
	struct SQN_RedistributionInterFreqInfo_r13 v;
};

struct SQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE_r13 v;
};

struct SQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional {
	bool d;
	SQN_T_ReselectionEUTRA_CE_r13 v;
};

struct SQN_InterFreqCarrierFreqInfo_v1310 {
	struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1310_cellReselectionSubPriority_r13_Optional cellReselectionSubPriority_r13;
	struct SQN_RedistributionInterFreqInfo_r13_SQN_InterFreqCarrierFreqInfo_v1310_redistributionInterFreqInfo_r13_Optional redistributionInterFreqInfo_r13;
	struct SQN_CellSelectionInfoCE_r13_SQN_InterFreqCarrierFreqInfo_v1310_cellSelectionInfoCE_r13_Optional cellSelectionInfoCE_r13;
	struct SQN_T_ReselectionEUTRA_CE_r13_SQN_InterFreqCarrierFreqInfo_v1310_t_ReselectionEUTRA_CE_r13_Optional t_ReselectionEUTRA_CE_r13;
};

struct SQN_InterFreqCarrierFreqInfo_v1310_SQN_InterFreqCarrierFreqList_v1310_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1310* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1310_SQN_InterFreqCarrierFreqList_v1310_Dynamic SQN_InterFreqCarrierFreqList_v1310;

struct SQN_InterFreqCarrierFreqInfo_v1310_SQN_InterFreqCarrierFreqListExt_v1310_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1310* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1310_SQN_InterFreqCarrierFreqListExt_v1310_Dynamic SQN_InterFreqCarrierFreqListExt_v1310;

struct SQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE1_r13 v;
};

struct SQN_InterFreqCarrierFreqInfo_v1350 {
	struct SQN_CellSelectionInfoCE1_r13_SQN_InterFreqCarrierFreqInfo_v1350_cellSelectionInfoCE1_r13_Optional cellSelectionInfoCE1_r13;
};

struct SQN_InterFreqCarrierFreqInfo_v1350_SQN_InterFreqCarrierFreqList_v1350_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1350* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1350_SQN_InterFreqCarrierFreqList_v1350_Dynamic SQN_InterFreqCarrierFreqList_v1350;

struct SQN_InterFreqCarrierFreqInfo_v1350_SQN_InterFreqCarrierFreqListExt_v1350_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1350* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1350_SQN_InterFreqCarrierFreqListExt_v1350_Dynamic SQN_InterFreqCarrierFreqListExt_v1350;

struct SQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE1_v1360 v;
};

struct SQN_InterFreqCarrierFreqInfo_v1360 {
	struct SQN_CellSelectionInfoCE1_v1360_SQN_InterFreqCarrierFreqInfo_v1360_cellSelectionInfoCE1_v1360_Optional cellSelectionInfoCE1_v1360;
};

struct SQN_InterFreqCarrierFreqInfo_v1360_SQN_InterFreqCarrierFreqListExt_v1360_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1360* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1360_SQN_InterFreqCarrierFreqListExt_v1360_Dynamic SQN_InterFreqCarrierFreqListExt_v1360;

struct SQN_PhysCellIdRange_SQN_InterFreqNeighHSDN_CellList_r15_Dynamic {
	size_t d;
	struct SQN_PhysCellIdRange* v;
};

typedef struct SQN_PhysCellIdRange_SQN_InterFreqNeighHSDN_CellList_r15_Dynamic SQN_InterFreqNeighHSDN_CellList_r15;

struct SQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional {
	bool d;
	SQN_InterFreqNeighHSDN_CellList_r15 v;
};

struct SQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE_v1530 v;
};

struct SQN_InterFreqCarrierFreqInfo_v1530 {
	bool hsdn_Indication_r15;
	struct SQN_InterFreqNeighHSDN_CellList_r15_SQN_InterFreqCarrierFreqInfo_v1530_interFreqNeighHSDN_CellList_r15_Optional interFreqNeighHSDN_CellList_r15;
	struct SQN_CellSelectionInfoCE_v1530_SQN_InterFreqCarrierFreqInfo_v1530_cellSelectionInfoCE_v1530_Optional cellSelectionInfoCE_v1530;
};

struct SQN_InterFreqCarrierFreqInfo_v1530_SQN_InterFreqCarrierFreqList_v1530_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1530* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1530_SQN_InterFreqCarrierFreqList_v1530_Dynamic SQN_InterFreqCarrierFreqList_v1530;

struct SQN_InterFreqCarrierFreqInfo_v1530_SQN_InterFreqCarrierFreqListExt_v1530_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1530* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1530_SQN_InterFreqCarrierFreqListExt_v1530_Dynamic SQN_InterFreqCarrierFreqListExt_v1530;

struct SQN_PhysCellIdRange_SQN_CellList_r15_Dynamic {
	size_t d;
	struct SQN_PhysCellIdRange* v;
};

typedef struct SQN_PhysCellIdRange_SQN_CellList_r15_Dynamic SQN_CellList_r15;

enum SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e {
	SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_rsrp = 0,
	SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_rsrq = 1,
	SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e_both = 2,
};

typedef enum SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e;

typedef int8_t SQN_RSRQ_Range_r13;

struct SQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional {
	bool d;
	SQN_RSRP_Range v;
};

struct SQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional {
	bool d;
	SQN_RSRQ_Range_r13 v;
};

struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15 {
	struct SQN_RSRP_Range_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRP_Threshold_r15_Optional idleRSRP_Threshold_r15;
	struct SQN_RSRQ_Range_r13_SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_idleRSRQ_Threshold_r15_Optional idleRSRQ_Threshold_r15;
};

struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional {
	bool d;
	SQN_CellList_r15 v;
};

struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional {
	bool d;
	SQN_CellList_r15 v;
};

struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional {
	bool d;
	struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15 v;
};

struct SQN_MeasIdleCarrierEUTRA_r15 {
	SQN_ARFCN_ValueEUTRA_r9 carrierFreq_r15;
	SQN_AllowedMeasBandwidth_e allowedMeasBandwidth_r15;
	struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_validityArea_r15_Optional validityArea_r15;
	struct SQN_CellList_r15_SQN_MeasIdleCarrierEUTRA_r15_measCellList_r15_Optional measCellList_r15;
	SQN_MeasIdleCarrierEUTRA_r15_reportQuantities_e reportQuantities;
	struct SQN_MeasIdleCarrierEUTRA_r15_qualityThreshold_r15_qualityThreshold_r15_Optional qualityThreshold_r15;
};

struct SQN_MeasIdleCarrierEUTRA_r15_SQN_EUTRA_CarrierList_r15_Dynamic {
	size_t d;
	struct SQN_MeasIdleCarrierEUTRA_r15* v;
};

typedef struct SQN_MeasIdleCarrierEUTRA_r15_SQN_EUTRA_CarrierList_r15_Dynamic SQN_EUTRA_CarrierList_r15;

struct SQN_MeasIdleConfigSIB_r15 {
	SQN_EUTRA_CarrierList_r15 measIdleCarrierListEUTRA_r15;
};

struct SQN_InterFreqNeighCellInfo_v1610 {
	SQN_RSS_MeasPowerBias_r16_e rss_MeasPowerBias_r16;
};

struct SQN_InterFreqNeighCellInfo_v1610_SQN_InterFreqNeighCellList_v1610_Dynamic {
	size_t d;
	struct SQN_InterFreqNeighCellInfo_v1610* v;
};

typedef struct SQN_InterFreqNeighCellInfo_v1610_SQN_InterFreqNeighCellList_v1610_Dynamic SQN_InterFreqNeighCellList_v1610;

struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional {
	bool d;
	SQN_CellReselectionSubPriority_r13_e v;
};

struct SQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional {
	bool d;
	struct SQN_RSS_ConfigCarrierInfo_r16 v;
};

struct SQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional {
	bool d;
	SQN_InterFreqNeighCellList_v1610 v;
};

struct SQN_InterFreqCarrierFreqInfo_v1610 {
	struct SQN_CellReselectionPriority_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionPriority_r16_Optional altCellReselectionPriority_r16;
	struct SQN_CellReselectionSubPriority_r13_e_SQN_InterFreqCarrierFreqInfo_v1610_altCellReselectionSubPriority_r16_Optional altCellReselectionSubPriority_r16;
	struct SQN_RSS_ConfigCarrierInfo_r16_SQN_InterFreqCarrierFreqInfo_v1610_rss_ConfigCarrierInfo_r16_Optional rss_ConfigCarrierInfo_r16;
	struct SQN_InterFreqNeighCellList_v1610_SQN_InterFreqCarrierFreqInfo_v1610_interFreqNeighCellList_v1610_Optional interFreqNeighCellList_v1610;
};

struct SQN_InterFreqCarrierFreqInfo_v1610_SQN_InterFreqCarrierFreqList_v1610_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1610* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1610_SQN_InterFreqCarrierFreqList_v1610_Dynamic SQN_InterFreqCarrierFreqList_v1610;

struct SQN_InterFreqCarrierFreqInfo_v1610_SQN_InterFreqCarrierFreqListExt_v1610_Dynamic {
	size_t d;
	struct SQN_InterFreqCarrierFreqInfo_v1610* v;
};

typedef struct SQN_InterFreqCarrierFreqInfo_v1610_SQN_InterFreqCarrierFreqListExt_v1610_Dynamic SQN_InterFreqCarrierFreqListExt_v1610;

typedef uint32_t SQN_ARFCN_ValueNR_r15;

enum SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e {
	SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz15 = 0,
	SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz30 = 1,
	SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz120 = 2,
	SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e_kHz240 = 3,
};

typedef enum SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e;

typedef uint16_t SQN_FreqBandIndicatorNR_r15;

struct SQN_FreqBandIndicatorNR_r15_SQN_MultiFrequencyBandListNR_r15_Dynamic {
	size_t d;
	SQN_FreqBandIndicatorNR_r15* v;
};

typedef struct SQN_FreqBandIndicatorNR_r15_SQN_MultiFrequencyBandListNR_r15_Dynamic SQN_MultiFrequencyBandListNR_r15;

typedef uint16_t SQN_PhysCellIdNR_r15;

enum SQN_PhysCellIdRangeNR_r16_range_e {
	SQN_PhysCellIdRangeNR_r16_range_e_n4 = 0,
	SQN_PhysCellIdRangeNR_r16_range_e_n8 = 1,
	SQN_PhysCellIdRangeNR_r16_range_e_n12 = 2,
	SQN_PhysCellIdRangeNR_r16_range_e_n16 = 3,
	SQN_PhysCellIdRangeNR_r16_range_e_n24 = 4,
	SQN_PhysCellIdRangeNR_r16_range_e_n32 = 5,
	SQN_PhysCellIdRangeNR_r16_range_e_n48 = 6,
	SQN_PhysCellIdRangeNR_r16_range_e_n64 = 7,
	SQN_PhysCellIdRangeNR_r16_range_e_n84 = 8,
	SQN_PhysCellIdRangeNR_r16_range_e_n96 = 9,
	SQN_PhysCellIdRangeNR_r16_range_e_n128 = 10,
	SQN_PhysCellIdRangeNR_r16_range_e_n168 = 11,
	SQN_PhysCellIdRangeNR_r16_range_e_n252 = 12,
	SQN_PhysCellIdRangeNR_r16_range_e_n504 = 13,
	SQN_PhysCellIdRangeNR_r16_range_e_n1008 = 14,
	SQN_PhysCellIdRangeNR_r16_range_e_spare1 = 15,
};

typedef enum SQN_PhysCellIdRangeNR_r16_range_e SQN_PhysCellIdRangeNR_r16_range_e;

struct SQN_PhysCellIdRangeNR_r16_range_e_range_Optional {
	bool d;
	SQN_PhysCellIdRangeNR_r16_range_e v;
};

struct SQN_PhysCellIdRangeNR_r16 {
	SQN_PhysCellIdNR_r15 start;
	struct SQN_PhysCellIdRangeNR_r16_range_e_range_Optional range;
};

struct SQN_PhysCellIdRangeNR_r16_SQN_CellListNR_r16_Dynamic {
	size_t d;
	struct SQN_PhysCellIdRangeNR_r16* v;
};

typedef struct SQN_PhysCellIdRangeNR_r16_SQN_CellListNR_r16_Dynamic SQN_CellListNR_r16;

enum SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e {
	SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_rsrp = 0,
	SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_rsrq = 1,
	SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e_both = 2,
};

typedef enum SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e;

typedef uint8_t SQN_RSRP_RangeNR_r15;

typedef uint8_t SQN_RSRQ_RangeNR_r15;

struct SQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional {
	bool d;
	SQN_RSRP_RangeNR_r15 v;
};

struct SQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional {
	bool d;
	SQN_RSRQ_RangeNR_r15 v;
};

struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16 {
	struct SQN_RSRP_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRP_ThresholdNR_r16_Optional idleRSRP_ThresholdNR_r16;
	struct SQN_RSRQ_RangeNR_r15_SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_idleRSRQ_ThresholdNR_r16_Optional idleRSRQ_ThresholdNR_r16;
};

typedef uint8_t SQN_MaxRS_IndexCellQualNR_r15;

typedef uint8_t SQN_RS_SINR_RangeNR_r15;

struct SQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional {
	bool d;
	SQN_RSRP_RangeNR_r15 v;
};

struct SQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional {
	bool d;
	SQN_RSRQ_RangeNR_r15 v;
};

struct SQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional {
	bool d;
	SQN_RS_SINR_RangeNR_r15 v;
};

struct SQN_ThresholdListNR_r15 {
	struct SQN_RSRP_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRP_r15_Optional nr_RSRP_r15;
	struct SQN_RSRQ_RangeNR_r15_SQN_ThresholdListNR_r15_nr_RSRQ_r15_Optional nr_RSRQ_r15;
	struct SQN_RS_SINR_RangeNR_r15_SQN_ThresholdListNR_r15_nr_SINR_r15_Optional nr_SINR_r15;
};

enum SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Sel {
	SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_UNBOUND_VALUE = 0,
	SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf5_r15 = 1,
	SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf10_r15 = 2,
	SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf20_r15 = 3,
	SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf40_r15 = 4,
	SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf80_r15 = 5,
	SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_sf160_r15 = 6,
};

union SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value {
	uint8_t sf5_r15;
	uint8_t sf10_r15;
	uint8_t sf20_r15;
	uint8_t sf40_r15;
	uint8_t sf80_r15;
	uint8_t sf160_r15;
};

struct SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15 {
	enum SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Sel d;
	union SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15_Value v;
};

enum SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e {
	SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf1 = 0,
	SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf2 = 1,
	SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf3 = 2,
	SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf4 = 3,
	SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e_sf5 = 4,
};

typedef enum SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e;

struct SQN_MTC_SSB_NR_r15 {
	struct SQN_MTC_SSB_NR_r15_periodicityAndOffset_r15 periodicityAndOffset_r15;
	SQN_MTC_SSB_NR_r15_ssb_Duration_r15_e ssb_Duration_r15;
};

enum SQN_SSB_ToMeasure_r15_Sel {
	SQN_SSB_ToMeasure_r15_UNBOUND_VALUE = 0,
	SQN_SSB_ToMeasure_r15_shortBitmap_r15 = 1,
	SQN_SSB_ToMeasure_r15_mediumBitmap_r15 = 2,
	SQN_SSB_ToMeasure_r15_longBitmap_r15 = 3,
};

union SQN_SSB_ToMeasure_r15_Value {
	B4 shortBitmap_r15;
	B8 mediumBitmap_r15;
	B64 longBitmap_r15;
};

struct SQN_SSB_ToMeasure_r15 {
	enum SQN_SSB_ToMeasure_r15_Sel d;
	union SQN_SSB_ToMeasure_r15_Value v;
};

struct SQN_SS_RSSI_Measurement_r15 {
	BIT_STRING measurementSlots_r15;
	uint8_t endSymbol_r15;
};

struct SQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional {
	bool d;
	SQN_MaxRS_IndexCellQualNR_r15 v;
};

struct SQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional {
	bool d;
	struct SQN_ThresholdListNR_r15 v;
};

struct SQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional {
	bool d;
	struct SQN_MTC_SSB_NR_r15 v;
};

struct SQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional {
	bool d;
	struct SQN_SSB_ToMeasure_r15 v;
};

struct SQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional {
	bool d;
	struct SQN_SS_RSSI_Measurement_r15 v;
};

struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16 {
	struct SQN_MaxRS_IndexCellQualNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_maxRS_IndexCellQual_r16_Optional maxRS_IndexCellQual_r16;
	struct SQN_ThresholdListNR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_threshRS_Index_r16_Optional threshRS_Index_r16;
	struct SQN_MTC_SSB_NR_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_measTimingConfig_r16_Optional measTimingConfig_r16;
	struct SQN_SSB_ToMeasure_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_ToMeasure_r16_Optional ssb_ToMeasure_r16;
	bool deriveSSB_IndexFromCell_r16;
	struct SQN_SS_RSSI_Measurement_r15_SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ss_RSSI_Measurement_r16_Optional ss_RSSI_Measurement_r16;
};

enum SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e {
	SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_rsrp = 0,
	SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_rsrq = 1,
	SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e_both = 2,
};

typedef enum SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e;

struct SQN_BeamMeasConfigIdleNR_r16 {
	SQN_BeamMeasConfigIdleNR_r16_reportQuantityRS_IndexNR_r16_e reportQuantityRS_IndexNR_r16;
	uint8_t maxReportRS_Index_r16;
	bool reportRS_IndexResultsNR_r16;
};

struct SQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional {
	bool d;
	SQN_MultiFrequencyBandListNR_r15 v;
};

struct SQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional {
	bool d;
	SQN_CellListNR_r16 v;
};

struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional {
	bool d;
	struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16 v;
};

struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional {
	bool d;
	struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16 v;
};

struct SQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional {
	bool d;
	struct SQN_BeamMeasConfigIdleNR_r16 v;
};

struct SQN_MeasIdleCarrierNR_r16 {
	SQN_ARFCN_ValueNR_r15 carrierFreqNR_r16;
	SQN_MeasIdleCarrierNR_r16_subcarrierSpacingSSB_r16_e subcarrierSpacingSSB_r16;
	struct SQN_MultiFrequencyBandListNR_r15_SQN_MeasIdleCarrierNR_r16_frequencyBandList_Optional frequencyBandList;
	struct SQN_CellListNR_r16_SQN_MeasIdleCarrierNR_r16_measCellListNR_r16_Optional measCellListNR_r16;
	SQN_MeasIdleCarrierNR_r16_reportQuantitiesNR_r16_e reportQuantitiesNR_r16;
	struct SQN_MeasIdleCarrierNR_r16_qualityThresholdNR_r16_qualityThresholdNR_r16_Optional qualityThresholdNR_r16;
	struct SQN_MeasIdleCarrierNR_r16_ssb_MeasConfig_r16_ssb_MeasConfig_r16_Optional ssb_MeasConfig_r16;
	struct SQN_BeamMeasConfigIdleNR_r16_SQN_MeasIdleCarrierNR_r16_beamMeasConfigIdle_r16_Optional beamMeasConfigIdle_r16;
};

struct SQN_MeasIdleCarrierNR_r16_SQN_NR_CarrierList_r16_Dynamic {
	size_t d;
	struct SQN_MeasIdleCarrierNR_r16* v;
};

typedef struct SQN_MeasIdleCarrierNR_r16_SQN_NR_CarrierList_r16_Dynamic SQN_NR_CarrierList_r16;

struct SQN_MeasIdleConfigSIB_NR_r16 {
	SQN_NR_CarrierList_r16 measIdleCarrierListNR_r16;
};

struct OCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional {
	bool d;
	SQN_InterFreqCarrierFreqList_v1250 v;
};

struct SQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional {
	bool d;
	SQN_InterFreqCarrierFreqListExt_r12 v;
};

struct SQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional {
	bool d;
	SQN_InterFreqCarrierFreqListExt_v1280 v;
};

struct SQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional {
	bool d;
	SQN_InterFreqCarrierFreqList_v1310 v;
};

struct SQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional {
	bool d;
	SQN_InterFreqCarrierFreqListExt_v1310 v;
};

struct SQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional {
	bool d;
	SQN_InterFreqCarrierFreqList_v1350 v;
};

struct SQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional {
	bool d;
	SQN_InterFreqCarrierFreqListExt_v1350 v;
};

struct SQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional {
	bool d;
	SQN_InterFreqCarrierFreqListExt_v1360 v;
};

struct uint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional {
	bool d;
	uint8_t v;
};

struct SQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional {
	bool d;
	SQN_InterFreqCarrierFreqList_v1530 v;
};

struct SQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional {
	bool d;
	SQN_InterFreqCarrierFreqListExt_v1530 v;
};

struct SQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional {
	bool d;
	struct SQN_MeasIdleConfigSIB_r15 v;
};

struct SQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional {
	bool d;
	SQN_InterFreqCarrierFreqList_v1610 v;
};

struct SQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional {
	bool d;
	SQN_InterFreqCarrierFreqListExt_v1610 v;
};

struct SQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional {
	bool d;
	struct SQN_MeasIdleConfigSIB_NR_r16 v;
};

struct SQN_SystemInformationBlockType5 {
	SQN_InterFreqCarrierFreqList interFreqCarrierFreqList;
	struct OCTET_STRING_SQN_SystemInformationBlockType5_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_InterFreqCarrierFreqList_v1250_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1250_Optional interFreqCarrierFreqList_v1250;
	struct SQN_InterFreqCarrierFreqListExt_r12_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_r12_Optional interFreqCarrierFreqListExt_r12;
	struct SQN_InterFreqCarrierFreqListExt_v1280_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1280_Optional interFreqCarrierFreqListExt_v1280;
	struct SQN_InterFreqCarrierFreqList_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1310_Optional interFreqCarrierFreqList_v1310;
	struct SQN_InterFreqCarrierFreqListExt_v1310_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1310_Optional interFreqCarrierFreqListExt_v1310;
	struct SQN_InterFreqCarrierFreqList_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1350_Optional interFreqCarrierFreqList_v1350;
	struct SQN_InterFreqCarrierFreqListExt_v1350_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1350_Optional interFreqCarrierFreqListExt_v1350;
	struct SQN_InterFreqCarrierFreqListExt_v1360_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1360_Optional interFreqCarrierFreqListExt_v1360;
	struct uint8_t_SQN_SystemInformationBlockType5_scptm_FreqOffset_r14_Optional scptm_FreqOffset_r14;
	struct SQN_InterFreqCarrierFreqList_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1530_Optional interFreqCarrierFreqList_v1530;
	struct SQN_InterFreqCarrierFreqListExt_v1530_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1530_Optional interFreqCarrierFreqListExt_v1530;
	struct SQN_MeasIdleConfigSIB_r15_SQN_SystemInformationBlockType5_measIdleConfigSIB_r15_Optional measIdleConfigSIB_r15;
	struct SQN_InterFreqCarrierFreqList_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqList_v1610_Optional interFreqCarrierFreqList_v1610;
	struct SQN_InterFreqCarrierFreqListExt_v1610_SQN_SystemInformationBlockType5_interFreqCarrierFreqListExt_v1610_Optional interFreqCarrierFreqListExt_v1610;
	struct SQN_MeasIdleConfigSIB_NR_r16_SQN_SystemInformationBlockType5_measIdleConfigSIB_NR_r16_Optional measIdleConfigSIB_NR_r16;
};

typedef uint16_t SQN_ARFCN_ValueUTRA;

struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9 {
	SQN_ReselectionThresholdQ_r9 threshX_HighQ_r9;
	SQN_ReselectionThresholdQ_r9 threshX_LowQ_r9;
};

struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional {
	bool d;
	struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9 v;
};

struct SQN_CarrierFreqUTRA_FDD {
	SQN_ARFCN_ValueUTRA carrierFreq;
	struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_cellReselectionPriority_Optional cellReselectionPriority;
	SQN_ReselectionThreshold threshX_High;
	SQN_ReselectionThreshold threshX_Low;
	int8_t q_RxLevMin;
	int8_t p_MaxUTRA;
	int8_t q_QualMin;
	struct SQN_CarrierFreqUTRA_FDD_threshX_Q_r9_threshX_Q_r9_Optional threshX_Q_r9;
};

struct SQN_CarrierFreqUTRA_FDD_SQN_CarrierFreqListUTRA_FDD_Dynamic {
	size_t d;
	struct SQN_CarrierFreqUTRA_FDD* v;
};

typedef struct SQN_CarrierFreqUTRA_FDD_SQN_CarrierFreqListUTRA_FDD_Dynamic SQN_CarrierFreqListUTRA_FDD;

struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_CarrierFreqUTRA_TDD {
	SQN_ARFCN_ValueUTRA carrierFreq;
	struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_cellReselectionPriority_Optional cellReselectionPriority;
	SQN_ReselectionThreshold threshX_High;
	SQN_ReselectionThreshold threshX_Low;
	int8_t q_RxLevMin;
	int8_t p_MaxUTRA;
};

struct SQN_CarrierFreqUTRA_TDD_SQN_CarrierFreqListUTRA_TDD_Dynamic {
	size_t d;
	struct SQN_CarrierFreqUTRA_TDD* v;
};

typedef struct SQN_CarrierFreqUTRA_TDD_SQN_CarrierFreqListUTRA_TDD_Dynamic SQN_CarrierFreqListUTRA_TDD;

enum SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e {
	SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_true = 0,
};

typedef enum SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e;

struct SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional {
	bool d;
	SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e v;
};

struct SQN_CarrierFreqInfoUTRA_v1250 {
	struct SQN_CarrierFreqInfoUTRA_v1250_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional reducedMeasPerformance_r12;
};

struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12 {
	SQN_ReselectionThresholdQ_r9 threshX_HighQ_r12;
	SQN_ReselectionThresholdQ_r9 threshX_LowQ_r12;
};

typedef uint8_t SQN_FreqBandIndicator_UTRA_FDD;

enum SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e {
	SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_true = 0,
};

typedef enum SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e;

struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional {
	bool d;
	struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12 v;
};

struct SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_Dynamic {
	size_t d;
	SQN_FreqBandIndicator_UTRA_FDD* v;
};

struct SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional {
	bool d;
	struct SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_Dynamic v;
};

struct SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional {
	bool d;
	SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e v;
};

struct SQN_CarrierFreqUTRA_FDD_Ext_r12 {
	SQN_ARFCN_ValueUTRA carrierFreq_r12;
	struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_FDD_Ext_r12_cellReselectionPriority_r12_Optional cellReselectionPriority_r12;
	SQN_ReselectionThreshold threshX_High_r12;
	SQN_ReselectionThreshold threshX_Low_r12;
	int8_t q_RxLevMin_r12;
	int8_t p_MaxUTRA_r12;
	int8_t q_QualMin_r12;
	struct SQN_CarrierFreqUTRA_FDD_Ext_r12_threshX_Q_r12_threshX_Q_r12_Optional threshX_Q_r12;
	struct SQN_FreqBandIndicator_UTRA_FDD_SQN_CarrierFreqUTRA_FDD_Ext_r12_multiBandInfoList_r12_DynamicOptional multiBandInfoList_r12;
	struct SQN_CarrierFreqUTRA_FDD_Ext_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional reducedMeasPerformance_r12;
};

struct SQN_CarrierFreqUTRA_FDD_Ext_r12_SQN_CarrierFreqListUTRA_FDD_Ext_r12_Dynamic {
	size_t d;
	struct SQN_CarrierFreqUTRA_FDD_Ext_r12* v;
};

typedef struct SQN_CarrierFreqUTRA_FDD_Ext_r12_SQN_CarrierFreqListUTRA_FDD_Ext_r12_Dynamic SQN_CarrierFreqListUTRA_FDD_Ext_r12;

enum SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e {
	SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_true = 0,
};

typedef enum SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e;

struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional {
	bool d;
	SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e v;
};

struct SQN_CarrierFreqUTRA_TDD_r12 {
	SQN_ARFCN_ValueUTRA carrierFreq_r12;
	struct SQN_CellReselectionPriority_SQN_CarrierFreqUTRA_TDD_r12_cellReselectionPriority_r12_Optional cellReselectionPriority_r12;
	SQN_ReselectionThreshold threshX_High_r12;
	SQN_ReselectionThreshold threshX_Low_r12;
	int8_t q_RxLevMin_r12;
	int8_t p_MaxUTRA_r12;
	struct SQN_CarrierFreqUTRA_TDD_r12_reducedMeasPerformance_r12_e_reducedMeasPerformance_r12_Optional reducedMeasPerformance_r12;
};

struct SQN_CarrierFreqUTRA_TDD_r12_SQN_CarrierFreqListUTRA_TDD_Ext_r12_Dynamic {
	size_t d;
	struct SQN_CarrierFreqUTRA_TDD_r12* v;
};

typedef struct SQN_CarrierFreqUTRA_TDD_r12_SQN_CarrierFreqListUTRA_TDD_Ext_r12_Dynamic SQN_CarrierFreqListUTRA_TDD_Ext_r12;

struct SQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional {
	bool d;
	SQN_CarrierFreqListUTRA_FDD v;
};

struct SQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional {
	bool d;
	SQN_CarrierFreqListUTRA_TDD v;
};

struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType6_SQN_CarrierFreqInfoUTRA_v1250_carrierFreqListUTRA_FDD_v1250_Dynamic {
	size_t d;
	struct SQN_CarrierFreqInfoUTRA_v1250* v;
};

struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional {
	bool d;
	struct SQN_SystemInformationBlockType6_SQN_CarrierFreqInfoUTRA_v1250_carrierFreqListUTRA_FDD_v1250_Dynamic v;
};

struct SQN_SystemInformationBlockType6_SQN_CarrierFreqInfoUTRA_v1250_carrierFreqListUTRA_TDD_v1250_Dynamic {
	size_t d;
	struct SQN_CarrierFreqInfoUTRA_v1250* v;
};

struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional {
	bool d;
	struct SQN_SystemInformationBlockType6_SQN_CarrierFreqInfoUTRA_v1250_carrierFreqListUTRA_TDD_v1250_Dynamic v;
};

struct SQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional {
	bool d;
	SQN_CarrierFreqListUTRA_FDD_Ext_r12 v;
};

struct SQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional {
	bool d;
	SQN_CarrierFreqListUTRA_TDD_Ext_r12 v;
};

struct SQN_SystemInformationBlockType6 {
	struct SQN_CarrierFreqListUTRA_FDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Optional carrierFreqListUTRA_FDD;
	struct SQN_CarrierFreqListUTRA_TDD_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Optional carrierFreqListUTRA_TDD;
	SQN_T_Reselection t_ReselectionUTRA;
	struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType6_t_ReselectionUTRA_SF_Optional t_ReselectionUTRA_SF;
	struct OCTET_STRING_SQN_SystemInformationBlockType6_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_v1250_DynamicOptional carrierFreqListUTRA_FDD_v1250;
	struct SQN_CarrierFreqInfoUTRA_v1250_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_v1250_DynamicOptional carrierFreqListUTRA_TDD_v1250;
	struct SQN_CarrierFreqListUTRA_FDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_FDD_Ext_r12_Optional carrierFreqListUTRA_FDD_Ext_r12;
	struct SQN_CarrierFreqListUTRA_TDD_Ext_r12_SQN_SystemInformationBlockType6_carrierFreqListUTRA_TDD_Ext_r12_Optional carrierFreqListUTRA_TDD_Ext_r12;
};

typedef uint16_t SQN_ARFCN_ValueGERAN;

enum SQN_BandIndicatorGERAN_e {
	SQN_BandIndicatorGERAN_e_dcs1800 = 0,
	SQN_BandIndicatorGERAN_e_pcs1900 = 1,
};

typedef enum SQN_BandIndicatorGERAN_e SQN_BandIndicatorGERAN_e;

struct SQN_ARFCN_ValueGERAN_SQN_ExplicitListOfARFCNs_Dynamic {
	size_t d;
	SQN_ARFCN_ValueGERAN* v;
};

typedef struct SQN_ARFCN_ValueGERAN_SQN_ExplicitListOfARFCNs_Dynamic SQN_ExplicitListOfARFCNs;

struct SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs {
	uint8_t arfcn_Spacing;
	uint8_t numberOfFollowingARFCNs;
};

enum SQN_CarrierFreqsGERAN_followingARFCNs_Sel {
	SQN_CarrierFreqsGERAN_followingARFCNs_UNBOUND_VALUE = 0,
	SQN_CarrierFreqsGERAN_followingARFCNs_explicitListOfARFCNs = 1,
	SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs = 2,
	SQN_CarrierFreqsGERAN_followingARFCNs_variableBitMapOfARFCNs = 3,
};

union SQN_CarrierFreqsGERAN_followingARFCNs_Value {
	SQN_ExplicitListOfARFCNs explicitListOfARFCNs;
	struct SQN_CarrierFreqsGERAN_followingARFCNs_equallySpacedARFCNs equallySpacedARFCNs;
	OCTET_STRING variableBitMapOfARFCNs;
};

struct SQN_CarrierFreqsGERAN_followingARFCNs {
	enum SQN_CarrierFreqsGERAN_followingARFCNs_Sel d;
	union SQN_CarrierFreqsGERAN_followingARFCNs_Value v;
};

struct SQN_CarrierFreqsGERAN {
	SQN_ARFCN_ValueGERAN startingARFCN;
	SQN_BandIndicatorGERAN_e bandIndicator;
	struct SQN_CarrierFreqsGERAN_followingARFCNs followingARFCNs;
};

struct SQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct uint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional {
	bool d;
	uint8_t v;
};

struct SQN_CarrierFreqsInfoGERAN_commonInfo {
	struct SQN_CellReselectionPriority_SQN_CarrierFreqsInfoGERAN_commonInfo_cellReselectionPriority_Optional cellReselectionPriority;
	B8 ncc_Permitted;
	uint8_t q_RxLevMin;
	struct uint8_t_SQN_CarrierFreqsInfoGERAN_commonInfo_p_MaxGERAN_Optional p_MaxGERAN;
	SQN_ReselectionThreshold threshX_High;
	SQN_ReselectionThreshold threshX_Low;
};

struct SQN_CarrierFreqsInfoGERAN {
	struct SQN_CarrierFreqsGERAN carrierFreqs;
	struct SQN_CarrierFreqsInfoGERAN_commonInfo commonInfo;
};

struct SQN_CarrierFreqsInfoGERAN_SQN_CarrierFreqsInfoListGERAN_Dynamic {
	size_t d;
	struct SQN_CarrierFreqsInfoGERAN* v;
};

typedef struct SQN_CarrierFreqsInfoGERAN_SQN_CarrierFreqsInfoListGERAN_Dynamic SQN_CarrierFreqsInfoListGERAN;

struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct SQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional {
	bool d;
	SQN_CarrierFreqsInfoListGERAN v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType7 {
	SQN_T_Reselection t_ReselectionGERAN;
	struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType7_t_ReselectionGERAN_SF_Optional t_ReselectionGERAN_SF;
	struct SQN_CarrierFreqsInfoListGERAN_SQN_SystemInformationBlockType7_carrierFreqsInfoList_Optional carrierFreqsInfoList;
	struct OCTET_STRING_SQN_SystemInformationBlockType7_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Sel {
	SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_UNBOUND_VALUE = 0,
	SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_synchronousSystemTime = 1,
	SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_asynchronousSystemTime = 2,
};

union SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value {
	B39 synchronousSystemTime;
	B49 asynchronousSystemTime;
};

struct SQN_SystemTimeInfoCDMA2000_cdma_SystemTime {
	enum SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Sel d;
	union SQN_SystemTimeInfoCDMA2000_cdma_SystemTime_Value v;
};

struct SQN_SystemTimeInfoCDMA2000 {
	bool cdma_EUTRA_Synchronisation;
	struct SQN_SystemTimeInfoCDMA2000_cdma_SystemTime cdma_SystemTime;
};

typedef uint8_t SQN_PreRegistrationZoneIdHRPD;

struct SQN_PreRegistrationZoneIdHRPD_SQN_SecondaryPreRegistrationZoneIdListHRPD_Dynamic {
	size_t d;
	SQN_PreRegistrationZoneIdHRPD* v;
};

typedef struct SQN_PreRegistrationZoneIdHRPD_SQN_SecondaryPreRegistrationZoneIdListHRPD_Dynamic SQN_SecondaryPreRegistrationZoneIdListHRPD;

struct SQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional {
	bool d;
	SQN_PreRegistrationZoneIdHRPD v;
};

struct SQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional {
	bool d;
	SQN_SecondaryPreRegistrationZoneIdListHRPD v;
};

struct SQN_PreRegistrationInfoHRPD {
	bool preRegistrationAllowed;
	struct SQN_PreRegistrationZoneIdHRPD_SQN_PreRegistrationInfoHRPD_preRegistrationZoneId_Optional preRegistrationZoneId;
	struct SQN_SecondaryPreRegistrationZoneIdListHRPD_SQN_PreRegistrationInfoHRPD_secondaryPreRegistrationZoneIdList_Optional secondaryPreRegistrationZoneIdList;
};

enum SQN_BandclassCDMA2000_e {
	SQN_BandclassCDMA2000_e_bc0 = 0,
	SQN_BandclassCDMA2000_e_bc1 = 1,
	SQN_BandclassCDMA2000_e_bc2 = 2,
	SQN_BandclassCDMA2000_e_bc3 = 3,
	SQN_BandclassCDMA2000_e_bc4 = 4,
	SQN_BandclassCDMA2000_e_bc5 = 5,
	SQN_BandclassCDMA2000_e_bc6 = 6,
	SQN_BandclassCDMA2000_e_bc7 = 7,
	SQN_BandclassCDMA2000_e_bc8 = 8,
	SQN_BandclassCDMA2000_e_bc9 = 9,
	SQN_BandclassCDMA2000_e_bc10 = 10,
	SQN_BandclassCDMA2000_e_bc11 = 11,
	SQN_BandclassCDMA2000_e_bc12 = 12,
	SQN_BandclassCDMA2000_e_bc13 = 13,
	SQN_BandclassCDMA2000_e_bc14 = 14,
	SQN_BandclassCDMA2000_e_bc15 = 15,
	SQN_BandclassCDMA2000_e_bc16 = 16,
	SQN_BandclassCDMA2000_e_bc17 = 17,
	SQN_BandclassCDMA2000_e_bc18_v9a0 = 18,
	SQN_BandclassCDMA2000_e_bc19_v9a0 = 19,
	SQN_BandclassCDMA2000_e_bc20_v9a0 = 20,
	SQN_BandclassCDMA2000_e_bc21_v9a0 = 21,
	SQN_BandclassCDMA2000_e_spare10 = 22,
	SQN_BandclassCDMA2000_e_spare9 = 23,
	SQN_BandclassCDMA2000_e_spare8 = 24,
	SQN_BandclassCDMA2000_e_spare7 = 25,
	SQN_BandclassCDMA2000_e_spare6 = 26,
	SQN_BandclassCDMA2000_e_spare5 = 27,
	SQN_BandclassCDMA2000_e_spare4 = 28,
	SQN_BandclassCDMA2000_e_spare3 = 29,
	SQN_BandclassCDMA2000_e_spare2 = 30,
	SQN_BandclassCDMA2000_e_spare1 = 31,
};

typedef enum SQN_BandclassCDMA2000_e SQN_BandclassCDMA2000_e;

struct SQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_BandClassInfoCDMA2000 {
	SQN_BandclassCDMA2000_e bandClass;
	struct SQN_CellReselectionPriority_SQN_BandClassInfoCDMA2000_cellReselectionPriority_Optional cellReselectionPriority;
	uint8_t threshX_High;
	uint8_t threshX_Low;
};

struct SQN_BandClassInfoCDMA2000_SQN_BandClassListCDMA2000_Dynamic {
	size_t d;
	struct SQN_BandClassInfoCDMA2000* v;
};

typedef struct SQN_BandClassInfoCDMA2000_SQN_BandClassListCDMA2000_Dynamic SQN_BandClassListCDMA2000;

typedef uint16_t SQN_ARFCN_ValueCDMA2000;

typedef uint16_t SQN_PhysCellIdCDMA2000;

struct SQN_PhysCellIdCDMA2000_SQN_PhysCellIdListCDMA2000_Dynamic {
	size_t d;
	SQN_PhysCellIdCDMA2000* v;
};

typedef struct SQN_PhysCellIdCDMA2000_SQN_PhysCellIdListCDMA2000_Dynamic SQN_PhysCellIdListCDMA2000;

struct SQN_NeighCellsPerBandclassCDMA2000 {
	SQN_ARFCN_ValueCDMA2000 arfcn;
	SQN_PhysCellIdListCDMA2000 physCellIdList;
};

struct SQN_NeighCellsPerBandclassCDMA2000_SQN_NeighCellsPerBandclassListCDMA2000_Dynamic {
	size_t d;
	struct SQN_NeighCellsPerBandclassCDMA2000* v;
};

typedef struct SQN_NeighCellsPerBandclassCDMA2000_SQN_NeighCellsPerBandclassListCDMA2000_Dynamic SQN_NeighCellsPerBandclassListCDMA2000;

struct SQN_NeighCellCDMA2000 {
	SQN_BandclassCDMA2000_e bandClass;
	SQN_NeighCellsPerBandclassListCDMA2000 neighCellsPerFreqList;
};

struct SQN_NeighCellCDMA2000_SQN_NeighCellListCDMA2000_Dynamic {
	size_t d;
	struct SQN_NeighCellCDMA2000* v;
};

typedef struct SQN_NeighCellCDMA2000_SQN_NeighCellListCDMA2000_Dynamic SQN_NeighCellListCDMA2000;

struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct SQN_CellReselectionParametersCDMA2000 {
	SQN_BandClassListCDMA2000 bandClassList;
	SQN_NeighCellListCDMA2000 neighCellList;
	SQN_T_Reselection t_ReselectionCDMA2000;
	struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_t_ReselectionCDMA2000_SF_Optional t_ReselectionCDMA2000_SF;
};

struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional {
	bool d;
	struct SQN_CellReselectionParametersCDMA2000 v;
};

struct SQN_SystemInformationBlockType8_parametersHRPD {
	struct SQN_PreRegistrationInfoHRPD preRegistrationInfoHRPD;
	struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parametersHRPD_cellReselectionParametersHRPD_Optional cellReselectionParametersHRPD;
};

struct SQN_CSFB_RegistrationParam1XRTT {
	B15 sid;
	B16 nid;
	bool multipleSID;
	bool multipleNID;
	bool homeReg;
	bool foreignSIDReg;
	bool foreignNIDReg;
	bool parameterReg;
	bool powerUpReg;
	B7 registrationPeriod;
	B12 registrationZone;
	B3 totalZone;
	B3 zoneTimer;
};

struct SQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional {
	bool d;
	struct SQN_CSFB_RegistrationParam1XRTT v;
};

struct B42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional {
	bool d;
	B42 v;
};

struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional {
	bool d;
	struct SQN_CellReselectionParametersCDMA2000 v;
};

struct SQN_SystemInformationBlockType8_parameters1XRTT {
	struct SQN_CSFB_RegistrationParam1XRTT_SQN_SystemInformationBlockType8_parameters1XRTT_csfb_RegistrationParam1XRTT_Optional csfb_RegistrationParam1XRTT;
	struct B42_SQN_SystemInformationBlockType8_parameters1XRTT_longCodeState1XRTT_Optional longCodeState1XRTT;
	struct SQN_CellReselectionParametersCDMA2000_SQN_SystemInformationBlockType8_parameters1XRTT_cellReselectionParameters1XRTT_Optional cellReselectionParameters1XRTT;
};

struct SQN_PhysCellIdCDMA2000_SQN_PhysCellIdListCDMA2000_v920_Dynamic {
	size_t d;
	SQN_PhysCellIdCDMA2000* v;
};

typedef struct SQN_PhysCellIdCDMA2000_SQN_PhysCellIdListCDMA2000_v920_Dynamic SQN_PhysCellIdListCDMA2000_v920;

struct SQN_NeighCellsPerBandclassCDMA2000_v920 {
	SQN_PhysCellIdListCDMA2000_v920 physCellIdList_v920;
};

struct SQN_NeighCellsPerBandclassCDMA2000_v920_SQN_NeighCellsPerBandclassListCDMA2000_v920_Dynamic {
	size_t d;
	struct SQN_NeighCellsPerBandclassCDMA2000_v920* v;
};

typedef struct SQN_NeighCellsPerBandclassCDMA2000_v920_SQN_NeighCellsPerBandclassListCDMA2000_v920_Dynamic SQN_NeighCellsPerBandclassListCDMA2000_v920;

struct SQN_NeighCellCDMA2000_v920 {
	SQN_NeighCellsPerBandclassListCDMA2000_v920 neighCellsPerFreqList_v920;
};

struct SQN_NeighCellCDMA2000_v920_SQN_NeighCellListCDMA2000_v920_Dynamic {
	size_t d;
	struct SQN_NeighCellCDMA2000_v920* v;
};

typedef struct SQN_NeighCellCDMA2000_v920_SQN_NeighCellListCDMA2000_v920_Dynamic SQN_NeighCellListCDMA2000_v920;

struct SQN_CellReselectionParametersCDMA2000_v920 {
	SQN_NeighCellListCDMA2000_v920 neighCellList_v920;
};

enum SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e {
	SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e_true = 0,
};

typedef enum SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e;

struct SQN_CSFB_RegistrationParam1XRTT_v920 {
	SQN_CSFB_RegistrationParam1XRTT_v920_powerDownReg_r9_e powerDownReg_r9;
};

struct SQN_AC_BarringConfig1XRTT_r9 {
	uint8_t ac_Barring0to9_r9;
	uint8_t ac_Barring10_r9;
	uint8_t ac_Barring11_r9;
	uint8_t ac_Barring12_r9;
	uint8_t ac_Barring13_r9;
	uint8_t ac_Barring14_r9;
	uint8_t ac_Barring15_r9;
	uint8_t ac_BarringMsg_r9;
	uint8_t ac_BarringReg_r9;
	uint8_t ac_BarringEmg_r9;
};

enum SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e {
	SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e;

enum SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Sel {
	SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_UNBOUND_VALUE = 0,
	SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_explicitValue = 1,
	SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_defaultValue = 2,
};

union SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value {
	struct SQN_SystemTimeInfoCDMA2000 explicitValue;
	Null defaultValue;
};

struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11 {
	enum SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Sel d;
	union SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_Value v;
};

struct SQN_PhysCellIdCDMA2000_physCellIdList_r11_Dynamic {
	size_t d;
	SQN_PhysCellIdCDMA2000* v;
};

struct SQN_NeighCellsPerBandclassCDMA2000_r11 {
	SQN_ARFCN_ValueCDMA2000 arfcn;
	struct SQN_PhysCellIdCDMA2000_physCellIdList_r11_Dynamic physCellIdList_r11;
};

struct SQN_NeighCellsPerBandclassCDMA2000_r11_SQN_NeighCellCDMA2000_r11_neighFreqInfoList_r11_Dynamic {
	size_t d;
	struct SQN_NeighCellsPerBandclassCDMA2000_r11* v;
};

struct SQN_NeighCellCDMA2000_r11 {
	SQN_BandclassCDMA2000_e bandClass;
	struct SQN_NeighCellsPerBandclassCDMA2000_r11_SQN_NeighCellCDMA2000_r11_neighFreqInfoList_r11_Dynamic neighFreqInfoList_r11;
};

struct SQN_NeighCellCDMA2000_r11_SQN_CellReselectionParametersCDMA2000_r11_neighCellList_r11_Dynamic {
	size_t d;
	struct SQN_NeighCellCDMA2000_r11* v;
};

struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct SQN_CellReselectionParametersCDMA2000_r11 {
	SQN_BandClassListCDMA2000 bandClassList;
	struct SQN_NeighCellCDMA2000_r11_SQN_CellReselectionParametersCDMA2000_r11_neighCellList_r11_Dynamic neighCellList_r11;
	SQN_T_Reselection t_ReselectionCDMA2000;
	struct SQN_SpeedStateScaleFactors_SQN_CellReselectionParametersCDMA2000_r11_t_ReselectionCDMA2000_SF_Optional t_ReselectionCDMA2000_SF;
};

struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional {
	bool d;
	struct SQN_CellReselectionParametersCDMA2000_r11 v;
};

struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11 {
	struct SQN_PreRegistrationInfoHRPD preRegistrationInfoHRPD_r11;
	struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parametersHRPD_r11_cellReselectionParametersHRPD_r11_Optional cellReselectionParametersHRPD_r11;
};

enum SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e {
	SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_true = 0,
};

typedef enum SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e;

struct SQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional {
	bool d;
	struct SQN_CSFB_RegistrationParam1XRTT v;
};

struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional {
	bool d;
	struct SQN_CSFB_RegistrationParam1XRTT_v920 v;
};

struct B42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional {
	bool d;
	B42 v;
};

struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional {
	bool d;
	struct SQN_CellReselectionParametersCDMA2000_r11 v;
};

struct SQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional {
	bool d;
	struct SQN_AC_BarringConfig1XRTT_r9 v;
};

struct bool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional {
	bool d;
	bool v;
};

struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional {
	bool d;
	SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e v;
};

struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11 {
	struct SQN_CSFB_RegistrationParam1XRTT_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_r11_Optional csfb_RegistrationParam1XRTT_r11;
	struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_RegistrationParam1XRTT_Ext_r11_Optional csfb_RegistrationParam1XRTT_Ext_r11;
	struct B42_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_longCodeState1XRTT_r11_Optional longCodeState1XRTT_r11;
	struct SQN_CellReselectionParametersCDMA2000_r11_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_cellReselectionParameters1XRTT_r11_Optional cellReselectionParameters1XRTT_r11;
	struct SQN_AC_BarringConfig1XRTT_r9_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_ac_BarringConfig1XRTT_r11_Optional ac_BarringConfig1XRTT_r11;
	struct bool_SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_SupportForDualRxUEs_r11_Optional csfb_SupportForDualRxUEs_r11;
	struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_csfb_DualRxTxSupport_r11_e_csfb_DualRxTxSupport_r11_Optional csfb_DualRxTxSupport_r11;
};

struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional {
	bool d;
	struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11 v;
};

struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional {
	bool d;
	struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11 v;
};

struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional {
	bool d;
	struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11 v;
};

struct SQN_ParametersCDMA2000_r11 {
	struct SQN_ParametersCDMA2000_r11_systemTimeInfo_r11_systemTimeInfo_r11_Optional systemTimeInfo_r11;
	uint8_t searchWindowSize_r11;
	struct SQN_ParametersCDMA2000_r11_parametersHRPD_r11_parametersHRPD_r11_Optional parametersHRPD_r11;
	struct SQN_ParametersCDMA2000_r11_parameters1XRTT_r11_parameters1XRTT_r11_Optional parameters1XRTT_r11;
};

enum SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Sel {
	SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_UNBOUND_VALUE = 0,
	SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_explicitValue = 1,
	SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_defaultValue = 2,
};

union SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value {
	struct SQN_ParametersCDMA2000_r11 explicitValue;
	Null defaultValue;
};

struct SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11 {
	enum SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Sel d;
	union SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11_Value v;
};

struct SQN_SIB8_PerPLMN_r11 {
	uint8_t plmn_Identity_r11;
	struct SQN_SIB8_PerPLMN_r11_parametersCDMA2000_r11 parametersCDMA2000_r11;
};

struct SQN_SIB8_PerPLMN_r11_SQN_SIB8_PerPLMN_List_r11_Dynamic {
	size_t d;
	struct SQN_SIB8_PerPLMN_r11* v;
};

typedef struct SQN_SIB8_PerPLMN_r11_SQN_SIB8_PerPLMN_List_r11_Dynamic SQN_SIB8_PerPLMN_List_r11;

struct SQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional {
	bool d;
	struct SQN_SystemTimeInfoCDMA2000 v;
};

struct uint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional {
	bool d;
	uint8_t v;
};

struct SQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional {
	bool d;
	struct SQN_SystemInformationBlockType8_parametersHRPD v;
};

struct SQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional {
	bool d;
	struct SQN_SystemInformationBlockType8_parameters1XRTT v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct bool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional {
	bool d;
	bool v;
};

struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional {
	bool d;
	struct SQN_CellReselectionParametersCDMA2000_v920 v;
};

struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional {
	bool d;
	struct SQN_CellReselectionParametersCDMA2000_v920 v;
};

struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional {
	bool d;
	struct SQN_CSFB_RegistrationParam1XRTT_v920 v;
};

struct SQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional {
	bool d;
	struct SQN_AC_BarringConfig1XRTT_r9 v;
};

struct SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional {
	bool d;
	SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e v;
};

struct SQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional {
	bool d;
	SQN_SIB8_PerPLMN_List_r11 v;
};

struct SQN_SystemInformationBlockType8 {
	struct SQN_SystemTimeInfoCDMA2000_SQN_SystemInformationBlockType8_systemTimeInfo_Optional systemTimeInfo;
	struct uint8_t_SQN_SystemInformationBlockType8_searchWindowSize_Optional searchWindowSize;
	struct SQN_SystemInformationBlockType8_parametersHRPD_parametersHRPD_Optional parametersHRPD;
	struct SQN_SystemInformationBlockType8_parameters1XRTT_parameters1XRTT_Optional parameters1XRTT;
	struct OCTET_STRING_SQN_SystemInformationBlockType8_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct bool_SQN_SystemInformationBlockType8_csfb_SupportForDualRxUEs_r9_Optional csfb_SupportForDualRxUEs_r9;
	struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParametersHRPD_v920_Optional cellReselectionParametersHRPD_v920;
	struct SQN_CellReselectionParametersCDMA2000_v920_SQN_SystemInformationBlockType8_cellReselectionParameters1XRTT_v920_Optional cellReselectionParameters1XRTT_v920;
	struct SQN_CSFB_RegistrationParam1XRTT_v920_SQN_SystemInformationBlockType8_csfb_RegistrationParam1XRTT_v920_Optional csfb_RegistrationParam1XRTT_v920;
	struct SQN_AC_BarringConfig1XRTT_r9_SQN_SystemInformationBlockType8_ac_BarringConfig1XRTT_r9_Optional ac_BarringConfig1XRTT_r9;
	struct SQN_SystemInformationBlockType8_csfb_DualRxTxSupport_r10_e_csfb_DualRxTxSupport_r10_Optional csfb_DualRxTxSupport_r10;
	struct SQN_SIB8_PerPLMN_List_r11_SQN_SystemInformationBlockType8_sib8_PerPLMN_List_r11_Optional sib8_PerPLMN_List_r11;
};

struct OCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional {
	bool d;
	OCTET_STRING v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType9 {
	struct OCTET_STRING_SQN_SystemInformationBlockType9_hnb_Name_Optional hnb_Name;
	struct OCTET_STRING_SQN_SystemInformationBlockType9_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

struct O50_SQN_SystemInformationBlockType10_dummy_Optional {
	bool d;
	O50 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType10 {
	B16 messageIdentifier;
	B16 serialNumber;
	O2 warningType;
	struct O50_SQN_SystemInformationBlockType10_dummy_Optional dummy;
	struct OCTET_STRING_SQN_SystemInformationBlockType10_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_SystemInformationBlockType11_warningMessageSegmentType_e {
	SQN_SystemInformationBlockType11_warningMessageSegmentType_e_notLastSegment = 0,
	SQN_SystemInformationBlockType11_warningMessageSegmentType_e_lastSegment = 1,
};

typedef enum SQN_SystemInformationBlockType11_warningMessageSegmentType_e SQN_SystemInformationBlockType11_warningMessageSegmentType_e;

struct O1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional {
	bool d;
	O1 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType11 {
	B16 messageIdentifier;
	B16 serialNumber;
	SQN_SystemInformationBlockType11_warningMessageSegmentType_e warningMessageSegmentType;
	uint8_t warningMessageSegmentNumber;
	OCTET_STRING warningMessageSegment;
	struct O1_SQN_SystemInformationBlockType11_dataCodingScheme_Optional dataCodingScheme;
	struct OCTET_STRING_SQN_SystemInformationBlockType11_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e {
	SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e_notLastSegment = 0,
	SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e_lastSegment = 1,
};

typedef enum SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e;

struct O1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional {
	bool d;
	O1 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType12_r9 {
	B16 messageIdentifier_r9;
	B16 serialNumber_r9;
	SQN_SystemInformationBlockType12_r9_warningMessageSegmentType_r9_e warningMessageSegmentType_r9;
	uint8_t warningMessageSegmentNumber_r9;
	OCTET_STRING warningMessageSegment_r9;
	struct O1_SQN_SystemInformationBlockType12_r9_dataCodingScheme_r9_Optional dataCodingScheme_r9;
	struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct OCTET_STRING_SQN_SystemInformationBlockType12_r9_warningAreaCoordinatesSegment_r15_Optional warningAreaCoordinatesSegment_r15;
};

typedef uint8_t SQN_MBSFN_AreaId_r12;

enum SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e {
	SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e_s1 = 0,
	SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e_s2 = 1,
};

typedef enum SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e;

enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e {
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf32 = 0,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf64 = 1,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf128 = 2,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e_rf256 = 3,
};

typedef enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e;

enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e {
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e_rf512 = 0,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e_rf1024 = 1,
};

typedef enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e;

enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e {
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n2 = 0,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n7 = 1,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n13 = 2,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e_n19 = 3,
};

typedef enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e;

struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r9 {
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_RepetitionPeriod_r9_e mcch_RepetitionPeriod_r9;
	uint8_t mcch_Offset_r9;
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_mcch_ModificationPeriod_r9_e mcch_ModificationPeriod_r9;
	B6 sf_AllocInfo_r9;
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r9_signallingMCS_r9_e signallingMCS_r9;
};

enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e {
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf1 = 0,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf2 = 1,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf4 = 2,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf8 = 3,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_rf16 = 4,
};

typedef enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e;

enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e {
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf1 = 0,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf2 = 1,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf4 = 2,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf8 = 3,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf16 = 4,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf32 = 5,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf64 = 6,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf128 = 7,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_rf256 = 8,
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_spare7 = 9,
};

typedef enum SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e;

struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional {
	bool d;
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e v;
};

struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional {
	bool d;
	SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e v;
};

struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14 {
	struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_RepetitionPeriod_v1430_e_mcch_RepetitionPeriod_v1430_Optional mcch_RepetitionPeriod_v1430;
	struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_ModificationPeriod_v1430_e_mcch_ModificationPeriod_v1430_Optional mcch_ModificationPeriod_v1430;
};

enum SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e {
	SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_kHz7dot5 = 0,
	SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_kHz1dot25 = 1,
};

typedef enum SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e;

struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional {
	bool d;
	struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14 v;
};

struct SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional {
	bool d;
	SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e v;
};

struct SQN_MBSFN_AreaInfo_r9 {
	SQN_MBSFN_AreaId_r12 mbsfn_AreaId_r9;
	SQN_MBSFN_AreaInfo_r9_non_MBSFNregionLength_e non_MBSFNregionLength;
	uint8_t notificationIndicator_r9;
	struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r9 mcch_Config_r9;
	struct SQN_MBSFN_AreaInfo_r9_mcch_Config_r14_mcch_Config_r14_Optional mcch_Config_r14;
	struct SQN_MBSFN_AreaInfo_r9_subcarrierSpacingMBMS_r14_e_subcarrierSpacingMBMS_r14_Optional subcarrierSpacingMBMS_r14;
};

struct SQN_MBSFN_AreaInfo_r9_SQN_MBSFN_AreaInfoList_r9_Dynamic {
	size_t d;
	struct SQN_MBSFN_AreaInfo_r9* v;
};

typedef struct SQN_MBSFN_AreaInfo_r9_SQN_MBSFN_AreaInfoList_r9_Dynamic SQN_MBSFN_AreaInfoList_r9;

enum SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e {
	SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e_n2 = 0,
	SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e_n4 = 1,
};

typedef enum SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e;

struct SQN_MBMS_NotificationConfig_r9 {
	SQN_MBMS_NotificationConfig_r9_notificationRepetitionCoeff_r9_e notificationRepetitionCoeff_r9;
	uint8_t notificationOffset_r9;
	uint8_t notificationSF_Index_r9;
};

struct SQN_MBMS_NotificationConfig_v1430 {
	uint8_t notificationSF_Index_v1430;
};

enum SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e {
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf1 = 0,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf2 = 1,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf4 = 2,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf8 = 3,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf16 = 4,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf32 = 5,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf64 = 6,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf128 = 7,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_rf256 = 8,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare7 = 9,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare6 = 10,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare5 = 11,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare4 = 12,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare3 = 13,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare2 = 14,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e_spare1 = 15,
};

typedef enum SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e;

enum SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e {
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf1 = 0,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf2 = 1,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf4 = 2,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf8 = 3,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf16 = 4,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf32 = 5,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf64 = 6,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf128 = 7,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf256 = 8,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf512 = 9,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_rf1024 = 10,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare5 = 11,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare4 = 12,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare3 = 13,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare2 = 14,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e_spare1 = 15,
};

typedef enum SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e;

enum SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e {
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n2 = 0,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n7 = 1,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n13 = 2,
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e_n19 = 3,
};

typedef enum SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e;

struct SQN_MBSFN_AreaInfo_r16_mcch_Config_r16 {
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_RepetitionPeriod_r16_e mcch_RepetitionPeriod_r16;
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_mcch_ModificationPeriod_r16_e mcch_ModificationPeriod_r16;
	uint8_t mcch_Offset_r16;
	B10 sf_AllocInfo_r16;
	SQN_MBSFN_AreaInfo_r16_mcch_Config_r16_signallingMCS_r16_e signallingMCS_r16;
};

enum SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e {
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz7dot5 = 0,
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz2dot5 = 1,
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz1dot25 = 2,
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_kHz0dot37 = 3,
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare4 = 4,
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare3 = 5,
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare2 = 6,
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e_spare1 = 7,
};

typedef enum SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e;

enum SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e {
	SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_sl2 = 0,
	SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_sl4 = 1,
};

typedef enum SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e;

struct SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional {
	bool d;
	SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e v;
};

struct SQN_MBSFN_AreaInfo_r16 {
	SQN_MBSFN_AreaId_r12 mbsfn_AreaId_r16;
	uint8_t notificationIndicator_r16;
	struct SQN_MBSFN_AreaInfo_r16_mcch_Config_r16 mcch_Config_r16;
	SQN_MBSFN_AreaInfo_r16_subcarrierSpacingMBMS_r16_e subcarrierSpacingMBMS_r16;
	struct SQN_MBSFN_AreaInfo_r16_timeSeparation_r16_e_timeSeparation_r16_Optional timeSeparation_r16;
};

struct SQN_MBSFN_AreaInfo_r16_SQN_MBSFN_AreaInfoList_r16_Dynamic {
	size_t d;
	struct SQN_MBSFN_AreaInfo_r16* v;
};

typedef struct SQN_MBSFN_AreaInfo_r16_SQN_MBSFN_AreaInfoList_r16_Dynamic SQN_MBSFN_AreaInfoList_r16;

struct OCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional {
	bool d;
	struct SQN_MBMS_NotificationConfig_v1430 v;
};

struct SQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional {
	bool d;
	SQN_MBSFN_AreaInfoList_r16 v;
};

struct SQN_SystemInformationBlockType13_r9 {
	SQN_MBSFN_AreaInfoList_r9 mbsfn_AreaInfoList_r9;
	struct SQN_MBMS_NotificationConfig_r9 notificationConfig_r9;
	struct OCTET_STRING_SQN_SystemInformationBlockType13_r9_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_MBMS_NotificationConfig_v1430_SQN_SystemInformationBlockType13_r9_notificationConfig_v1430_Optional notificationConfig_v1430;
	struct SQN_MBSFN_AreaInfoList_r16_SQN_SystemInformationBlockType13_r9_mbsfn_AreaInfoList_r16_Optional mbsfn_AreaInfoList_r16;
};

enum SQN_EAB_Config_r11_eab_Category_r11_e {
	SQN_EAB_Config_r11_eab_Category_r11_e_a = 0,
	SQN_EAB_Config_r11_eab_Category_r11_e_b = 1,
	SQN_EAB_Config_r11_eab_Category_r11_e_c = 2,
};

typedef enum SQN_EAB_Config_r11_eab_Category_r11_e SQN_EAB_Config_r11_eab_Category_r11_e;

struct SQN_EAB_Config_r11 {
	SQN_EAB_Config_r11_eab_Category_r11_e eab_Category_r11;
	B10 eab_BarringBitmap_r11;
};

struct SQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional {
	bool d;
	struct SQN_EAB_Config_r11 v;
};

struct SQN_EAB_ConfigPLMN_r11 {
	struct SQN_EAB_Config_r11_SQN_EAB_ConfigPLMN_r11_eab_Config_r11_Optional eab_Config_r11;
};

enum SQN_SystemInformationBlockType14_r11_eab_Param_r11_Sel {
	SQN_SystemInformationBlockType14_r11_eab_Param_r11_UNBOUND_VALUE = 0,
	SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Common_r11 = 1,
	SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_PerPLMN_List_r11 = 2,
};

struct SQN_EAB_ConfigPLMN_r11_SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_PerPLMN_List_r11_Dynamic {
	size_t d;
	struct SQN_EAB_ConfigPLMN_r11* v;
};

union SQN_SystemInformationBlockType14_r11_eab_Param_r11_Value {
	struct SQN_EAB_Config_r11 eab_Common_r11;
	struct SQN_EAB_ConfigPLMN_r11_SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_PerPLMN_List_r11_Dynamic eab_PerPLMN_List_r11;
};

struct SQN_SystemInformationBlockType14_r11_eab_Param_r11 {
	enum SQN_SystemInformationBlockType14_r11_eab_Param_r11_Sel d;
	union SQN_SystemInformationBlockType14_r11_eab_Param_r11_Value v;
};

enum SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e {
	SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh0 = 0,
	SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh1 = 1,
	SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh2 = 2,
	SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_thresh3 = 3,
};

typedef enum SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e;

struct SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional {
	bool d;
	struct SQN_SystemInformationBlockType14_r11_eab_Param_r11 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e v;
};

struct SQN_SystemInformationBlockType14_r11 {
	struct SQN_SystemInformationBlockType14_r11_eab_Param_r11_eab_Param_r11_Optional eab_Param_r11;
	struct OCTET_STRING_SQN_SystemInformationBlockType14_r11_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SystemInformationBlockType14_r11_eab_PerRSRP_r15_e_eab_PerRSRP_r15_Optional eab_PerRSRP_r15;
};

typedef uint16_t SQN_MBMS_SAI_r11;

struct SQN_MBMS_SAI_r11_SQN_MBMS_SAI_List_r11_Dynamic {
	size_t d;
	SQN_MBMS_SAI_r11* v;
};

typedef struct SQN_MBMS_SAI_r11_SQN_MBMS_SAI_List_r11_Dynamic SQN_MBMS_SAI_List_r11;

struct SQN_MBMS_SAI_InterFreq_r11 {
	SQN_ARFCN_ValueEUTRA_r9 dl_CarrierFreq_r11;
	SQN_MBMS_SAI_List_r11 mbms_SAI_List_r11;
};

struct SQN_MBMS_SAI_InterFreq_r11_SQN_MBMS_SAI_InterFreqList_r11_Dynamic {
	size_t d;
	struct SQN_MBMS_SAI_InterFreq_r11* v;
};

typedef struct SQN_MBMS_SAI_InterFreq_r11_SQN_MBMS_SAI_InterFreqList_r11_Dynamic SQN_MBMS_SAI_InterFreqList_r11;

struct SQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional {
	bool d;
	SQN_MultiBandInfoList_r11 v;
};

struct SQN_MBMS_SAI_InterFreq_v1140 {
	struct SQN_MultiBandInfoList_r11_SQN_MBMS_SAI_InterFreq_v1140_multiBandInfoList_r11_Optional multiBandInfoList_r11;
};

struct SQN_MBMS_SAI_InterFreq_v1140_SQN_MBMS_SAI_InterFreqList_v1140_Dynamic {
	size_t d;
	struct SQN_MBMS_SAI_InterFreq_v1140* v;
};

typedef struct SQN_MBMS_SAI_InterFreq_v1140_SQN_MBMS_SAI_InterFreqList_v1140_Dynamic SQN_MBMS_SAI_InterFreqList_v1140;

enum SQN_MBMS_CarrierType_r14_carrierType_r14_e {
	SQN_MBMS_CarrierType_r14_carrierType_r14_e_mbms = 0,
	SQN_MBMS_CarrierType_r14_carrierType_r14_e_fembmsMixed = 1,
	SQN_MBMS_CarrierType_r14_carrierType_r14_e_fembmsDedicated = 2,
};

typedef enum SQN_MBMS_CarrierType_r14_carrierType_r14_e SQN_MBMS_CarrierType_r14_carrierType_r14_e;

struct uint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional {
	bool d;
	uint8_t v;
};

struct SQN_MBMS_CarrierType_r14 {
	SQN_MBMS_CarrierType_r14_carrierType_r14_e carrierType_r14;
	struct uint8_t_SQN_MBMS_CarrierType_r14_frameOffset_r14_Optional frameOffset_r14;
};

struct SQN_MBMS_CarrierType_r14_SQN_MBMS_InterFreqCarrierTypeList_r14_Dynamic {
	size_t d;
	struct SQN_MBMS_CarrierType_r14* v;
};

typedef struct SQN_MBMS_CarrierType_r14_SQN_MBMS_InterFreqCarrierTypeList_r14_Dynamic SQN_MBMS_InterFreqCarrierTypeList_r14;

struct SQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional {
	bool d;
	SQN_MBMS_SAI_List_r11 v;
};

struct SQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional {
	bool d;
	SQN_MBMS_SAI_InterFreqList_r11 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional {
	bool d;
	SQN_MBMS_SAI_InterFreqList_v1140 v;
};

struct SQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional {
	bool d;
	struct SQN_MBMS_CarrierType_r14 v;
};

struct SQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional {
	bool d;
	SQN_MBMS_InterFreqCarrierTypeList_r14 v;
};

struct SQN_SystemInformationBlockType15_r11 {
	struct SQN_MBMS_SAI_List_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_IntraFreq_r11_Optional mbms_SAI_IntraFreq_r11;
	struct SQN_MBMS_SAI_InterFreqList_r11_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_r11_Optional mbms_SAI_InterFreqList_r11;
	struct OCTET_STRING_SQN_SystemInformationBlockType15_r11_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_MBMS_SAI_InterFreqList_v1140_SQN_SystemInformationBlockType15_r11_mbms_SAI_InterFreqList_v1140_Optional mbms_SAI_InterFreqList_v1140;
	struct SQN_MBMS_CarrierType_r14_SQN_SystemInformationBlockType15_r11_mbms_IntraFreqCarrierType_r14_Optional mbms_IntraFreqCarrierType_r14;
	struct SQN_MBMS_InterFreqCarrierTypeList_r14_SQN_SystemInformationBlockType15_r11_mbms_InterFreqCarrierTypeList_r14_Optional mbms_InterFreqCarrierTypeList_r14;
};

struct B2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional {
	bool d;
	B2 v;
};

struct int16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional {
	bool d;
	int16_t v;
};

struct int8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional {
	bool d;
	int8_t v;
};

struct SQN_SystemInformationBlockType16_r11_timeInfo_r11 {
	uint64_t timeInfoUTC_r11;
	struct B2_SQN_SystemInformationBlockType16_r11_timeInfo_r11_dayLightSavingTime_r11_Optional dayLightSavingTime_r11;
	struct int16_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_leapSeconds_r11_Optional leapSeconds_r11;
	struct int8_t_SQN_SystemInformationBlockType16_r11_timeInfo_r11_localTimeOffset_r11_Optional localTimeOffset_r11;
};

struct SQN_ReferenceTime_r15 {
	uint32_t refDays_r15;
	uint32_t refSeconds_r15;
	uint16_t refMilliSeconds_r15;
	uint16_t refQuarterMicroSeconds_r15;
};

enum SQN_TimeReferenceInfo_r15_timeInfoType_r15_e {
	SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_localClock = 0,
};

typedef enum SQN_TimeReferenceInfo_r15_timeInfoType_r15_e SQN_TimeReferenceInfo_r15_timeInfoType_r15_e;

struct uint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional {
	bool d;
	uint8_t v;
};

struct SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional {
	bool d;
	SQN_TimeReferenceInfo_r15_timeInfoType_r15_e v;
};

struct uint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional {
	bool d;
	uint16_t v;
};

struct SQN_TimeReferenceInfo_r15 {
	struct SQN_ReferenceTime_r15 time_r15;
	struct uint8_t_SQN_TimeReferenceInfo_r15_uncertainty_r15_Optional uncertainty_r15;
	struct SQN_TimeReferenceInfo_r15_timeInfoType_r15_e_timeInfoType_r15_Optional timeInfoType_r15;
	struct uint16_t_SQN_TimeReferenceInfo_r15_referenceSFN_r15_Optional referenceSFN_r15;
};

struct SQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional {
	bool d;
	struct SQN_SystemInformationBlockType16_r11_timeInfo_r11 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional {
	bool d;
	struct SQN_TimeReferenceInfo_r15 v;
};

struct SQN_SystemInformationBlockType16_r11 {
	struct SQN_SystemInformationBlockType16_r11_timeInfo_r11_timeInfo_r11_Optional timeInfo_r11;
	struct OCTET_STRING_SQN_SystemInformationBlockType16_r11_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_TimeReferenceInfo_r15_SQN_SystemInformationBlockType16_r11_timeReferenceInfo_r15_Optional timeReferenceInfo_r15;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12 {
	SQN_RSRP_Range thresholdRSRP_Low_r12;
	SQN_RSRP_Range thresholdRSRP_High_r12;
};

typedef uint8_t SQN_RSRQ_Range;

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12 {
	SQN_RSRQ_Range thresholdRSRQ_Low_r12;
	SQN_RSRQ_Range thresholdRSRQ_High_r12;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12 {
	SQN_RSRQ_Range thresholdRSRQ_OnAllSymbolsWithWB_Low_r12;
	SQN_RSRQ_Range thresholdRSRQ_OnAllSymbolsWithWB_High_r12;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12 {
	SQN_RSRQ_Range thresholdRSRQ_OnAllSymbolsLow_r12;
	SQN_RSRQ_Range thresholdRSRQ_OnAllSymbolsHigh_r12;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12 {
	SQN_RSRQ_Range thresholdRSRQ_WB_Low_r12;
	SQN_RSRQ_Range thresholdRSRQ_WB_High_r12;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12 {
	uint8_t thresholdChannelUtilizationLow_r12;
	uint8_t thresholdChannelUtilizationHigh_r12;
};

enum SQN_WLAN_backhaulRate_r12_e {
	SQN_WLAN_backhaulRate_r12_e_r0 = 0,
	SQN_WLAN_backhaulRate_r12_e_r4 = 1,
	SQN_WLAN_backhaulRate_r12_e_r8 = 2,
	SQN_WLAN_backhaulRate_r12_e_r16 = 3,
	SQN_WLAN_backhaulRate_r12_e_r32 = 4,
	SQN_WLAN_backhaulRate_r12_e_r64 = 5,
	SQN_WLAN_backhaulRate_r12_e_r128 = 6,
	SQN_WLAN_backhaulRate_r12_e_r256 = 7,
	SQN_WLAN_backhaulRate_r12_e_r512 = 8,
	SQN_WLAN_backhaulRate_r12_e_r1024 = 9,
	SQN_WLAN_backhaulRate_r12_e_r2048 = 10,
	SQN_WLAN_backhaulRate_r12_e_r4096 = 11,
	SQN_WLAN_backhaulRate_r12_e_r8192 = 12,
	SQN_WLAN_backhaulRate_r12_e_r16384 = 13,
	SQN_WLAN_backhaulRate_r12_e_r32768 = 14,
	SQN_WLAN_backhaulRate_r12_e_r65536 = 15,
	SQN_WLAN_backhaulRate_r12_e_r131072 = 16,
	SQN_WLAN_backhaulRate_r12_e_r262144 = 17,
	SQN_WLAN_backhaulRate_r12_e_r524288 = 18,
	SQN_WLAN_backhaulRate_r12_e_r1048576 = 19,
	SQN_WLAN_backhaulRate_r12_e_r2097152 = 20,
	SQN_WLAN_backhaulRate_r12_e_r4194304 = 21,
	SQN_WLAN_backhaulRate_r12_e_r8388608 = 22,
	SQN_WLAN_backhaulRate_r12_e_r16777216 = 23,
	SQN_WLAN_backhaulRate_r12_e_r33554432 = 24,
	SQN_WLAN_backhaulRate_r12_e_r67108864 = 25,
	SQN_WLAN_backhaulRate_r12_e_r134217728 = 26,
	SQN_WLAN_backhaulRate_r12_e_r268435456 = 27,
	SQN_WLAN_backhaulRate_r12_e_r536870912 = 28,
	SQN_WLAN_backhaulRate_r12_e_r1073741824 = 29,
	SQN_WLAN_backhaulRate_r12_e_r2147483648 = 30,
	SQN_WLAN_backhaulRate_r12_e_r4294967296 = 31,
};

typedef enum SQN_WLAN_backhaulRate_r12_e SQN_WLAN_backhaulRate_r12_e;

struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12 {
	SQN_WLAN_backhaulRate_r12_e thresholdBackhaulDL_BandwidthLow_r12;
	SQN_WLAN_backhaulRate_r12_e thresholdBackhaulDL_BandwidthHigh_r12;
	SQN_WLAN_backhaulRate_r12_e thresholdBackhaulUL_BandwidthLow_r12;
	SQN_WLAN_backhaulRate_r12_e thresholdBackhaulUL_BandwidthHigh_r12;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12 {
	uint8_t thresholdWLAN_RSSI_Low_r12;
	uint8_t thresholdWLAN_RSSI_High_r12;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12 v;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12 v;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12 v;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12 v;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12 v;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12 v;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12 v;
};

struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12 v;
};

struct B16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional {
	bool d;
	B16 v;
};

struct SQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional {
	bool d;
	SQN_T_Reselection v;
};

struct SQN_WLAN_OffloadConfig_r12 {
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRP_r12_thresholdRSRP_r12_Optional thresholdRSRP_r12;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_r12_thresholdRSRQ_r12_Optional thresholdRSRQ_r12;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_thresholdRSRQ_OnAllSymbolsWithWB_r12_Optional thresholdRSRQ_OnAllSymbolsWithWB_r12;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_OnAllSymbols_r12_thresholdRSRQ_OnAllSymbols_r12_Optional thresholdRSRQ_OnAllSymbols_r12;
	struct SQN_WLAN_OffloadConfig_r12_thresholdRSRQ_WB_r12_thresholdRSRQ_WB_r12_Optional thresholdRSRQ_WB_r12;
	struct SQN_WLAN_OffloadConfig_r12_thresholdChannelUtilization_r12_thresholdChannelUtilization_r12_Optional thresholdChannelUtilization_r12;
	struct SQN_WLAN_OffloadConfig_r12_thresholdBackhaul_Bandwidth_r12_thresholdBackhaul_Bandwidth_r12_Optional thresholdBackhaul_Bandwidth_r12;
	struct SQN_WLAN_OffloadConfig_r12_thresholdWLAN_RSSI_r12_thresholdWLAN_RSSI_r12_Optional thresholdWLAN_RSSI_r12;
	struct B16_SQN_WLAN_OffloadConfig_r12_offloadPreferenceIndicator_r12_Optional offloadPreferenceIndicator_r12;
	struct SQN_T_Reselection_SQN_WLAN_OffloadConfig_r12_t_SteeringWLAN_r12_Optional t_SteeringWLAN_r12;
};

struct OCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional {
	bool d;
	OCTET_STRING v;
};

struct O6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional {
	bool d;
	O6 v;
};

struct O6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional {
	bool d;
	O6 v;
};

struct SQN_WLAN_Identifiers_r12 {
	struct OCTET_STRING_SQN_WLAN_Identifiers_r12_ssid_r12_Optional ssid_r12;
	struct O6_SQN_WLAN_Identifiers_r12_bssid_r12_Optional bssid_r12;
	struct O6_SQN_WLAN_Identifiers_r12_hessid_r12_Optional hessid_r12;
};

struct SQN_WLAN_Identifiers_r12_SQN_WLAN_Id_List_r12_Dynamic {
	size_t d;
	struct SQN_WLAN_Identifiers_r12* v;
};

typedef struct SQN_WLAN_Identifiers_r12_SQN_WLAN_Id_List_r12_Dynamic SQN_WLAN_Id_List_r12;

struct SQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional {
	bool d;
	struct SQN_WLAN_OffloadConfig_r12 v;
};

struct SQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional {
	bool d;
	SQN_WLAN_Id_List_r12 v;
};

struct SQN_WLAN_OffloadInfoPerPLMN_r12 {
	struct SQN_WLAN_OffloadConfig_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadConfigCommon_r12_Optional wlan_OffloadConfigCommon_r12;
	struct SQN_WLAN_Id_List_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_Id_List_r12_Optional wlan_Id_List_r12;
};

struct SQN_SystemInformationBlockType17_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadInfoPerPLMN_List_r12_Dynamic {
	size_t d;
	struct SQN_WLAN_OffloadInfoPerPLMN_r12* v;
};

struct SQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional {
	bool d;
	struct SQN_SystemInformationBlockType17_r12_SQN_WLAN_OffloadInfoPerPLMN_r12_wlan_OffloadInfoPerPLMN_List_r12_Dynamic v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType17_r12 {
	struct SQN_WLAN_OffloadInfoPerPLMN_r12_SQN_SystemInformationBlockType17_r12_wlan_OffloadInfoPerPLMN_List_r12_DynamicOptional wlan_OffloadInfoPerPLMN_List_r12;
	struct OCTET_STRING_SQN_SystemInformationBlockType17_r12_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_SL_CP_Len_r12_e {
	SQN_SL_CP_Len_r12_e_normal = 0,
	SQN_SL_CP_Len_r12_e_extended = 1,
};

typedef enum SQN_SL_CP_Len_r12_e SQN_SL_CP_Len_r12_e;

enum SQN_SL_PeriodComm_r12_e {
	SQN_SL_PeriodComm_r12_e_sf40 = 0,
	SQN_SL_PeriodComm_r12_e_sf60 = 1,
	SQN_SL_PeriodComm_r12_e_sf70 = 2,
	SQN_SL_PeriodComm_r12_e_sf80 = 3,
	SQN_SL_PeriodComm_r12_e_sf120 = 4,
	SQN_SL_PeriodComm_r12_e_sf140 = 5,
	SQN_SL_PeriodComm_r12_e_sf160 = 6,
	SQN_SL_PeriodComm_r12_e_sf240 = 7,
	SQN_SL_PeriodComm_r12_e_sf280 = 8,
	SQN_SL_PeriodComm_r12_e_sf320 = 9,
	SQN_SL_PeriodComm_r12_e_spare6 = 10,
	SQN_SL_PeriodComm_r12_e_spare5 = 11,
	SQN_SL_PeriodComm_r12_e_spare4 = 12,
	SQN_SL_PeriodComm_r12_e_spare3 = 13,
	SQN_SL_PeriodComm_r12_e_spare2 = 14,
	SQN_SL_PeriodComm_r12_e_spare = 15,
};

typedef enum SQN_SL_PeriodComm_r12_e SQN_SL_PeriodComm_r12_e;

enum SQN_SL_OffsetIndicator_r12_Sel {
	SQN_SL_OffsetIndicator_r12_UNBOUND_VALUE = 0,
	SQN_SL_OffsetIndicator_r12_small_r12 = 1,
	SQN_SL_OffsetIndicator_r12_large_r12 = 2,
};

union SQN_SL_OffsetIndicator_r12_Value {
	uint16_t small_r12;
	uint16_t large_r12;
};

struct SQN_SL_OffsetIndicator_r12 {
	enum SQN_SL_OffsetIndicator_r12_Sel d;
	union SQN_SL_OffsetIndicator_r12_Value v;
};

enum SQN_SubframeBitmapSL_r12_Sel {
	SQN_SubframeBitmapSL_r12_UNBOUND_VALUE = 0,
	SQN_SubframeBitmapSL_r12_bs4_r12 = 1,
	SQN_SubframeBitmapSL_r12_bs8_r12 = 2,
	SQN_SubframeBitmapSL_r12_bs12_r12 = 3,
	SQN_SubframeBitmapSL_r12_bs16_r12 = 4,
	SQN_SubframeBitmapSL_r12_bs30_r12 = 5,
	SQN_SubframeBitmapSL_r12_bs40_r12 = 6,
	SQN_SubframeBitmapSL_r12_bs42_r12 = 7,
};

union SQN_SubframeBitmapSL_r12_Value {
	B4 bs4_r12;
	B8 bs8_r12;
	B12 bs12_r12;
	B16 bs16_r12;
	B30 bs30_r12;
	B40 bs40_r12;
	B42 bs42_r12;
};

struct SQN_SubframeBitmapSL_r12 {
	enum SQN_SubframeBitmapSL_r12_Sel d;
	union SQN_SubframeBitmapSL_r12_Value v;
};

struct SQN_SL_TF_ResourceConfig_r12 {
	uint8_t prb_Num_r12;
	uint8_t prb_Start_r12;
	uint8_t prb_End_r12;
	struct SQN_SL_OffsetIndicator_r12 offsetIndicator_r12;
	struct SQN_SubframeBitmapSL_r12 subframeBitmap_r12;
};

enum SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e {
	SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns1 = 0,
	SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns2 = 1,
	SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e_ns4 = 2,
};

typedef enum SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e;

struct SQN_SL_HoppingConfigComm_r12 {
	uint16_t hoppingParameter_r12;
	SQN_SL_HoppingConfigComm_r12_numSubbands_r12_e numSubbands_r12;
	uint8_t rb_Offset_r12;
};

typedef BIT_STRING SQN_SL_TRPT_Subset_r12;

struct SQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional {
	bool d;
	SQN_SL_TRPT_Subset_r12 v;
};

struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12 {
	struct SQN_SL_TF_ResourceConfig_r12 data_TF_ResourceConfig_r12;
	struct SQN_SL_TRPT_Subset_r12_SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_trpt_Subset_r12_Optional trpt_Subset_r12;
};

enum SQN_TDD_Config_subframeAssignment_e {
	SQN_TDD_Config_subframeAssignment_e_sa0 = 0,
	SQN_TDD_Config_subframeAssignment_e_sa1 = 1,
	SQN_TDD_Config_subframeAssignment_e_sa2 = 2,
	SQN_TDD_Config_subframeAssignment_e_sa3 = 3,
	SQN_TDD_Config_subframeAssignment_e_sa4 = 4,
	SQN_TDD_Config_subframeAssignment_e_sa5 = 5,
	SQN_TDD_Config_subframeAssignment_e_sa6 = 6,
};

typedef enum SQN_TDD_Config_subframeAssignment_e SQN_TDD_Config_subframeAssignment_e;

enum SQN_TDD_Config_specialSubframePatterns_e {
	SQN_TDD_Config_specialSubframePatterns_e_ssp0 = 0,
	SQN_TDD_Config_specialSubframePatterns_e_ssp1 = 1,
	SQN_TDD_Config_specialSubframePatterns_e_ssp2 = 2,
	SQN_TDD_Config_specialSubframePatterns_e_ssp3 = 3,
	SQN_TDD_Config_specialSubframePatterns_e_ssp4 = 4,
	SQN_TDD_Config_specialSubframePatterns_e_ssp5 = 5,
	SQN_TDD_Config_specialSubframePatterns_e_ssp6 = 6,
	SQN_TDD_Config_specialSubframePatterns_e_ssp7 = 7,
	SQN_TDD_Config_specialSubframePatterns_e_ssp8 = 8,
};

typedef enum SQN_TDD_Config_specialSubframePatterns_e SQN_TDD_Config_specialSubframePatterns_e;

struct SQN_TDD_Config {
	SQN_TDD_Config_subframeAssignment_e subframeAssignment;
	SQN_TDD_Config_specialSubframePatterns_e specialSubframePatterns;
};

struct SQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional {
	bool d;
	struct SQN_TDD_Config v;
};

struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12 {
	struct SQN_TDD_Config_SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_tdd_Config_r12_Optional tdd_Config_r12;
	uint8_t syncConfigIndex_r12;
};

typedef int8_t SQN_P0_SL_r12;

struct SQN_SL_TxParameters_r12 {
	SQN_Alpha_r12_e alpha_r12;
	SQN_P0_SL_r12 p0_r12;
};

struct SQN_SL_CommResourcePool_r12_txParameters_r12 {
	struct SQN_SL_TxParameters_r12 sc_TxParameters_r12;
	struct SQN_SL_TxParameters_r12 dataTxParameters_r12;
};

typedef uint8_t SQN_SL_Priority_r13;

struct SQN_SL_Priority_r13_SQN_SL_PriorityList_r13_Dynamic {
	size_t d;
	SQN_SL_Priority_r13* v;
};

typedef struct SQN_SL_Priority_r13_SQN_SL_PriorityList_r13_Dynamic SQN_SL_PriorityList_r13;

struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional {
	bool d;
	struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12 v;
};

struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional {
	bool d;
	struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12 v;
};

struct SQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional {
	bool d;
	struct SQN_SL_CommResourcePool_r12_txParameters_r12 v;
};

struct SQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional {
	bool d;
	SQN_SL_PriorityList_r13 v;
};

struct SQN_SL_CommResourcePool_r12 {
	SQN_SL_CP_Len_r12_e sc_CP_Len_r12;
	SQN_SL_PeriodComm_r12_e sc_Period_r12;
	struct SQN_SL_TF_ResourceConfig_r12 sc_TF_ResourceConfig_r12;
	SQN_SL_CP_Len_r12_e data_CP_Len_r12;
	struct SQN_SL_HoppingConfigComm_r12 dataHoppingConfig_r12;
	struct SQN_SL_CommResourcePool_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional ue_SelectedResourceConfig_r12;
	struct SQN_SL_CommResourcePool_r12_rxParametersNCell_r12_rxParametersNCell_r12_Optional rxParametersNCell_r12;
	struct SQN_SL_CommResourcePool_r12_txParameters_r12_txParameters_r12_Optional txParameters_r12;
	struct SQN_SL_PriorityList_r13_SQN_SL_CommResourcePool_r12_priorityList_r13_Optional priorityList_r13;
};

struct SQN_SL_CommResourcePool_r12_SQN_SL_CommRxPoolList_r12_Dynamic {
	size_t d;
	struct SQN_SL_CommResourcePool_r12* v;
};

typedef struct SQN_SL_CommResourcePool_r12_SQN_SL_CommRxPoolList_r12_Dynamic SQN_SL_CommRxPoolList_r12;

struct SQN_SL_CommResourcePool_r12_SQN_SL_CommTxPoolList_r12_Dynamic {
	size_t d;
	struct SQN_SL_CommResourcePool_r12* v;
};

typedef struct SQN_SL_CommResourcePool_r12_SQN_SL_CommTxPoolList_r12_Dynamic SQN_SL_CommTxPoolList_r12;

typedef uint8_t SQN_SL_OffsetIndicatorSync_r12;

typedef uint8_t SQN_SLSSID_r12;

typedef uint8_t SQN_RSRP_RangeSL_r12;

struct B19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional {
	bool d;
	B19 v;
};

struct SQN_SL_SyncConfig_r12_txParameters_r12 {
	struct SQN_SL_TxParameters_r12 syncTxParameters_r12;
	SQN_RSRP_RangeSL_r12 syncTxThreshIC_r12;
	struct B19_SQN_SL_SyncConfig_r12_txParameters_r12_syncInfoReserved_r12_Optional syncInfoReserved_r12;
};

enum SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e {
	SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e_w1 = 0,
	SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e_w2 = 1,
};

typedef enum SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e;

struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12 {
	SQN_PhysCellId physCellId_r12;
	SQN_SL_SyncConfig_r12_rxParamsNCell_r12_discSyncWindow_r12_e discSyncWindow_r12;
};

enum SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e {
	SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_true = 0,
};

typedef enum SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e;

typedef uint8_t SQN_SL_OffsetIndicatorSync_v1430;

enum SQN_SL_SyncConfig_r12_gnss_Sync_r14_e {
	SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_true = 0,
};

typedef enum SQN_SL_SyncConfig_r12_gnss_Sync_r14_e SQN_SL_SyncConfig_r12_gnss_Sync_r14_e;

typedef uint8_t SQN_SL_OffsetIndicatorSync_r14;

enum SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e {
	SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_true = 0,
};

typedef enum SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e;

struct SQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional {
	bool d;
	struct SQN_SL_SyncConfig_r12_txParameters_r12 v;
};

struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional {
	bool d;
	struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12 v;
};

struct SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional {
	bool d;
	SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e v;
};

struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional {
	bool d;
	SQN_SL_OffsetIndicatorSync_v1430 v;
};

struct SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional {
	bool d;
	SQN_SL_SyncConfig_r12_gnss_Sync_r14_e v;
};

struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional {
	bool d;
	SQN_SL_OffsetIndicatorSync_r14 v;
};

struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional {
	bool d;
	SQN_SL_OffsetIndicatorSync_r14 v;
};

struct SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional {
	bool d;
	SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e v;
};

struct SQN_SL_SyncConfig_r12 {
	SQN_SL_CP_Len_r12_e syncCP_Len_r12;
	SQN_SL_OffsetIndicatorSync_r12 syncOffsetIndicator_r12;
	SQN_SLSSID_r12 slssid_r12;
	struct SQN_SL_SyncConfig_r12_txParameters_r12_txParameters_r12_Optional txParameters_r12;
	struct SQN_SL_SyncConfig_r12_rxParamsNCell_r12_rxParamsNCell_r12_Optional rxParamsNCell_r12;
	struct SQN_SL_SyncConfig_r12_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional syncTxPeriodic_r13;
	struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfig_r12_syncOffsetIndicator_v1430_Optional syncOffsetIndicator_v1430;
	struct SQN_SL_SyncConfig_r12_gnss_Sync_r14_e_gnss_Sync_r14_Optional gnss_Sync_r14;
	struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator2_r14_Optional syncOffsetIndicator2_r14;
	struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfig_r12_syncOffsetIndicator3_r14_Optional syncOffsetIndicator3_r14;
	struct SQN_SL_SyncConfig_r12_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional slss_TxDisabled_r15;
};

struct SQN_SL_SyncConfig_r12_SQN_SL_SyncConfigList_r12_Dynamic {
	size_t d;
	struct SQN_SL_SyncConfig_r12* v;
};

typedef struct SQN_SL_SyncConfig_r12_SQN_SL_SyncConfigList_r12_Dynamic SQN_SL_SyncConfigList_r12;

struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional {
	bool d;
	SQN_SL_CommTxPoolList_r12 v;
};

struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional {
	bool d;
	SQN_SL_CommTxPoolList_r12 v;
};

struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional {
	bool d;
	SQN_SL_SyncConfigList_r12 v;
};

struct SQN_SystemInformationBlockType18_r12_commConfig_r12 {
	SQN_SL_CommRxPoolList_r12 commRxPool_r12;
	struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolNormalCommon_r12_Optional commTxPoolNormalCommon_r12;
	struct SQN_SL_CommTxPoolList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commTxPoolExceptional_r12_Optional commTxPoolExceptional_r12;
	struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType18_r12_commConfig_r12_commSyncConfig_r12_Optional commSyncConfig_r12;
};

struct SQN_SL_CommResourcePool_r12_SQN_SL_CommTxPoolListExt_r13_Dynamic {
	size_t d;
	struct SQN_SL_CommResourcePool_r12* v;
};

typedef struct SQN_SL_CommResourcePool_r12_SQN_SL_CommTxPoolListExt_r13_Dynamic SQN_SL_CommTxPoolListExt_r13;

enum SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e {
	SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e;

enum SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e {
	SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e;

struct SQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional {
	bool d;
	struct SQN_SystemInformationBlockType18_r12_commConfig_r12 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional {
	bool d;
	SQN_SL_CommTxPoolListExt_r13 v;
};

struct SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional {
	bool d;
	SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e v;
};

struct SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional {
	bool d;
	SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e v;
};

struct SQN_SystemInformationBlockType18_r12 {
	struct SQN_SystemInformationBlockType18_r12_commConfig_r12_commConfig_r12_Optional commConfig_r12;
	struct OCTET_STRING_SQN_SystemInformationBlockType18_r12_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SL_CommTxPoolListExt_r13_SQN_SystemInformationBlockType18_r12_commTxPoolNormalCommonExt_r13_Optional commTxPoolNormalCommonExt_r13;
	struct SQN_SystemInformationBlockType18_r12_commTxResourceUC_ReqAllowed_r13_e_commTxResourceUC_ReqAllowed_r13_Optional commTxResourceUC_ReqAllowed_r13;
	struct SQN_SystemInformationBlockType18_r12_commTxAllowRelayCommon_r13_e_commTxAllowRelayCommon_r13_Optional commTxAllowRelayCommon_r13;
};

enum SQN_SL_DiscResourcePool_r12_discPeriod_r12_e {
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf32 = 0,
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf64 = 1,
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf128 = 2,
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf256 = 3,
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf512 = 4,
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf1024 = 5,
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_rf16_v1310 = 6,
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e_spare = 7,
};

typedef enum SQN_SL_DiscResourcePool_r12_discPeriod_r12_e SQN_SL_DiscResourcePool_r12_discPeriod_r12_e;

typedef uint8_t SQN_RSRP_RangeSL2_r12;

struct SQN_SL_PoolSelectionConfig_r12 {
	SQN_RSRP_RangeSL2_r12 threshLow_r12;
	SQN_RSRP_RangeSL2_r12 threshHigh_r12;
};

enum SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Sel {
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_UNBOUND_VALUE = 0,
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_rsrpBased_r12 = 1,
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_random_r12 = 2,
};

union SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value {
	struct SQN_SL_PoolSelectionConfig_r12 rsrpBased_r12;
	Null random_r12;
};

struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12 {
	enum SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Sel d;
	union SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12_Value v;
};

enum SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e {
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p25 = 0,
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p50 = 1,
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p75 = 2,
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e_p100 = 3,
};

typedef enum SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e;

struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12 {
	struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_poolSelection_r12 poolSelection_r12;
	SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_txProbability_r12_e txProbability_r12;
};

struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional {
	bool d;
	struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12 v;
};

struct SQN_SL_DiscResourcePool_r12_txParameters_r12 {
	struct SQN_SL_TxParameters_r12 txParametersGeneral_r12;
	struct SQN_SL_DiscResourcePool_r12_txParameters_r12_ue_SelectedResourceConfig_r12_ue_SelectedResourceConfig_r12_Optional ue_SelectedResourceConfig_r12;
};

struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional {
	bool d;
	struct SQN_TDD_Config v;
};

struct SQN_SL_DiscResourcePool_r12_rxParameters_r12 {
	struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_rxParameters_r12_tdd_Config_r12_Optional tdd_Config_r12;
	uint8_t syncConfigIndex_r12;
};

enum SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e {
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf4 = 0,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf6 = 1,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf7 = 2,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf8 = 3,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf12 = 4,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf14 = 5,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf24 = 6,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e_rf28 = 7,
};

typedef enum SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e;

enum SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Sel {
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_UNBOUND_VALUE = 0,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_release = 1,
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup = 2,
};

union SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value {
	Null release;
	SQN_SL_DiscResourcePool_r12_discPeriod_v1310_setup_e setup;
};

struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310 {
	enum SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Sel d;
	union SQN_SL_DiscResourcePool_r12_discPeriod_v1310_Value v;
};

struct SQN_PhysCellId_SQN_PhysCellIdList_r13_Dynamic {
	size_t d;
	SQN_PhysCellId* v;
};

typedef struct SQN_PhysCellId_SQN_PhysCellIdList_r13_Dynamic SQN_PhysCellIdList_r13;

struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup {
	SQN_PhysCellIdList_r13 physCellId_r13;
};

enum SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Sel {
	SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_UNBOUND_VALUE = 0,
	SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_release = 1,
	SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup = 2,
};

union SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value {
	Null release;
	struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_setup setup;
};

struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13 {
	enum SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Sel d;
	union SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_Value v;
};

enum SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e {
	SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e_ssp7 = 0,
	SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e_ssp9 = 1,
};

typedef enum SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e;

struct SQN_TDD_Config_v1130 {
	SQN_TDD_Config_v1130_specialSubframePatterns_v1130_e specialSubframePatterns_v1130;
};

enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e {
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n6 = 0,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n15 = 1,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n25 = 2,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n50 = 3,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n75 = 4,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_n100 = 5,
};

typedef enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e;

struct SQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional {
	bool d;
	SQN_ARFCN_ValueEUTRA v;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional {
	bool d;
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e v;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo {
	struct SQN_ARFCN_ValueEUTRA_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_CarrierFreq_Optional ul_CarrierFreq;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo_ul_Bandwidth_e_ul_Bandwidth_Optional ul_Bandwidth;
	SQN_AdditionalSpectrumEmission additionalSpectrumEmission;
};

struct SQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional {
	bool d;
	SQN_P_Max v;
};

struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional {
	bool d;
	struct SQN_TDD_Config v;
};

struct SQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional {
	bool d;
	struct SQN_TDD_Config_v1130 v;
};

struct uint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup {
	SQN_PhysCellIdList_r13 physCellId_r13;
	struct SQN_P_Max_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_p_Max_Optional p_Max;
	struct SQN_TDD_Config_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_r13_Optional tdd_Config_r13;
	struct SQN_TDD_Config_v1130_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_tdd_Config_v1130_Optional tdd_Config_v1130;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_freqInfo freqInfo;
	int8_t referenceSignalPower;
	struct uint8_t_SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup_syncConfigIndex_r13_Optional syncConfigIndex_r13;
};

enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Sel {
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_UNBOUND_VALUE = 0,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_release = 1,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup = 2,
};

union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value {
	Null release;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_setup setup;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13 {
	enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Sel d;
	union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_Value v;
};

typedef uint16_t SQN_AdditionalSpectrumEmission_v10l0;

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370 {
	SQN_AdditionalSpectrumEmission_v10l0 additionalSpectrumEmission_v1370;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup {
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup_freqInfo_v1370 freqInfo_v1370;
};

enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Sel {
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_UNBOUND_VALUE = 0,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_release = 1,
	SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup = 2,
};

union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value {
	Null release;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_setup setup;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370 {
	enum SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Sel d;
	union SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_Value v;
};

struct SQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional {
	bool d;
	struct SQN_SL_DiscResourcePool_r12_txParameters_r12 v;
};

struct SQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional {
	bool d;
	struct SQN_SL_DiscResourcePool_r12_rxParameters_r12 v;
};

struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional {
	bool d;
	struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310 v;
};

struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional {
	bool d;
	struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13 v;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional {
	bool d;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13 v;
};

struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional {
	bool d;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370 v;
};

struct SQN_SL_DiscResourcePool_r12 {
	SQN_SL_CP_Len_r12_e cp_Len_r12;
	SQN_SL_DiscResourcePool_r12_discPeriod_r12_e discPeriod_r12;
	uint8_t numRetx_r12;
	uint8_t numRepetition_r12;
	struct SQN_SL_TF_ResourceConfig_r12 tf_ResourceConfig_r12;
	struct SQN_SL_DiscResourcePool_r12_txParameters_r12_txParameters_r12_Optional txParameters_r12;
	struct SQN_SL_DiscResourcePool_r12_rxParameters_r12_rxParameters_r12_Optional rxParameters_r12;
	struct SQN_SL_DiscResourcePool_r12_discPeriod_v1310_discPeriod_v1310_Optional discPeriod_v1310;
	struct SQN_SL_DiscResourcePool_r12_rxParamsAddNeighFreq_r13_rxParamsAddNeighFreq_r13_Optional rxParamsAddNeighFreq_r13;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_r13_txParamsAddNeighFreq_r13_Optional txParamsAddNeighFreq_r13;
	struct SQN_SL_DiscResourcePool_r12_txParamsAddNeighFreq_v1370_txParamsAddNeighFreq_v1370_Optional txParamsAddNeighFreq_v1370;
};

struct SQN_SL_DiscResourcePool_r12_SQN_SL_DiscRxPoolList_r12_Dynamic {
	size_t d;
	struct SQN_SL_DiscResourcePool_r12* v;
};

typedef struct SQN_SL_DiscResourcePool_r12_SQN_SL_DiscRxPoolList_r12_Dynamic SQN_SL_DiscRxPoolList_r12;

struct SQN_SL_DiscResourcePool_r12_SQN_SL_DiscTxPoolList_r12_Dynamic {
	size_t d;
	struct SQN_SL_DiscResourcePool_r12* v;
};

typedef struct SQN_SL_DiscResourcePool_r12_SQN_SL_DiscTxPoolList_r12_Dynamic SQN_SL_DiscTxPoolList_r12;

struct SQN_SL_DiscTxPowerInfo_r12 {
	SQN_P_Max discMaxTxPower_r12;
};

typedef struct SQN_SL_DiscTxPowerInfo_r12 SQN_SL_DiscTxPowerInfoList_r12[3];

struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional {
	bool d;
	SQN_SL_DiscTxPoolList_r12 v;
};

struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional {
	bool d;
	SQN_SL_DiscTxPowerInfoList_r12 v;
};

struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional {
	bool d;
	SQN_SL_SyncConfigList_r12 v;
};

struct SQN_SystemInformationBlockType19_r12_discConfig_r12 {
	SQN_SL_DiscRxPoolList_r12 discRxPool_r12;
	struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPoolCommon_r12_Optional discTxPoolCommon_r12;
	struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discTxPowerInfo_r12_Optional discTxPowerInfo_r12;
	struct SQN_SL_SyncConfigList_r12_SQN_SystemInformationBlockType19_r12_discConfig_r12_discSyncConfig_r12_Optional discSyncConfig_r12;
};

typedef uint8_t SQN_MCC_MNC_Digit;

typedef SQN_MCC_MNC_Digit SQN_MCC[3];

struct SQN_MCC_MNC_Digit_SQN_MNC_Dynamic {
	size_t d;
	SQN_MCC_MNC_Digit* v;
};

typedef struct SQN_MCC_MNC_Digit_SQN_MNC_Dynamic SQN_MNC;

struct SQN_MCC_SQN_PLMN_Identity_mcc_Optional {
	bool d;
	SQN_MCC v;
};

struct SQN_PLMN_Identity {
	struct SQN_MCC_SQN_PLMN_Identity_mcc_Optional mcc;
	SQN_MNC mnc;
};

enum SQN_PLMN_IdentityInfo2_r12_Sel {
	SQN_PLMN_IdentityInfo2_r12_UNBOUND_VALUE = 0,
	SQN_PLMN_IdentityInfo2_r12_plmn_Index_r12 = 1,
	SQN_PLMN_IdentityInfo2_r12_plmnIdentity_r12 = 2,
};

union SQN_PLMN_IdentityInfo2_r12_Value {
	uint8_t plmn_Index_r12;
	struct SQN_PLMN_Identity plmnIdentity_r12;
};

struct SQN_PLMN_IdentityInfo2_r12 {
	enum SQN_PLMN_IdentityInfo2_r12_Sel d;
	union SQN_PLMN_IdentityInfo2_r12_Value v;
};

struct SQN_PLMN_IdentityInfo2_r12_SQN_PLMN_IdentityList4_r12_Dynamic {
	size_t d;
	struct SQN_PLMN_IdentityInfo2_r12* v;
};

typedef struct SQN_PLMN_IdentityInfo2_r12_SQN_PLMN_IdentityList4_r12_Dynamic SQN_PLMN_IdentityList4_r12;

struct SQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional {
	bool d;
	SQN_PLMN_IdentityList4_r12 v;
};

struct SQN_SL_CarrierFreqInfo_r12 {
	SQN_ARFCN_ValueEUTRA_r9 carrierFreq_r12;
	struct SQN_PLMN_IdentityList4_r12_SQN_SL_CarrierFreqInfo_r12_plmn_IdentityList_r12_Optional plmn_IdentityList_r12;
};

struct SQN_SL_CarrierFreqInfo_r12_SQN_SL_CarrierFreqInfoList_r12_Dynamic {
	size_t d;
	struct SQN_SL_CarrierFreqInfo_r12* v;
};

typedef struct SQN_SL_CarrierFreqInfo_r12_SQN_SL_CarrierFreqInfoList_r12_Dynamic SQN_SL_CarrierFreqInfoList_r12;

enum SQN_SL_DiscTxResourcesInterFreq_r13_Sel {
	SQN_SL_DiscTxResourcesInterFreq_r13_UNBOUND_VALUE = 0,
	SQN_SL_DiscTxResourcesInterFreq_r13_acquireSI_FromCarrier_r13 = 1,
	SQN_SL_DiscTxResourcesInterFreq_r13_discTxPoolCommon_r13 = 2,
	SQN_SL_DiscTxResourcesInterFreq_r13_requestDedicated_r13 = 3,
	SQN_SL_DiscTxResourcesInterFreq_r13_noTxOnCarrier_r13 = 4,
};

union SQN_SL_DiscTxResourcesInterFreq_r13_Value {
	Null acquireSI_FromCarrier_r13;
	SQN_SL_DiscTxPoolList_r12 discTxPoolCommon_r13;
	Null requestDedicated_r13;
	Null noTxOnCarrier_r13;
};

struct SQN_SL_DiscTxResourcesInterFreq_r13 {
	enum SQN_SL_DiscTxResourcesInterFreq_r13_Sel d;
	union SQN_SL_DiscTxResourcesInterFreq_r13_Value v;
};

struct SQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional {
	bool d;
	SQN_SL_DiscRxPoolList_r12 v;
};

struct SQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional {
	bool d;
	struct SQN_SL_DiscTxResourcesInterFreq_r13 v;
};

struct SQN_SL_ResourcesInterFreq_r13 {
	struct SQN_SL_DiscRxPoolList_r12_SQN_SL_ResourcesInterFreq_r13_discRxResourcesInterFreq_r13_Optional discRxResourcesInterFreq_r13;
	struct SQN_SL_DiscTxResourcesInterFreq_r13_SQN_SL_ResourcesInterFreq_r13_discTxResourcesInterFreq_r13_Optional discTxResourcesInterFreq_r13;
};

enum SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e {
	SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_pCell = 0,
};

typedef enum SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e;

struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13 {
	SQN_SL_CP_Len_r12_e syncCP_Len_r13;
	SQN_SL_OffsetIndicatorSync_r12 syncOffsetIndicator_r13;
	SQN_SLSSID_r12 slssid_r13;
};

enum SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e {
	SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_true = 0,
};

typedef enum SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e;

struct B19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional {
	bool d;
	B19 v;
};

struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional {
	bool d;
	SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e v;
};

struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13 {
	struct SQN_SL_TxParameters_r12 syncTxParameters_r13;
	SQN_RSRP_RangeSL_r12 syncTxThreshIC_r13;
	struct B19_SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncInfoReserved_r13_Optional syncInfoReserved_r13;
	struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_syncTxPeriodic_r13_e_syncTxPeriodic_r13_Optional syncTxPeriodic_r13;
};

enum SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e {
	SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e_w1 = 0,
	SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e_w2 = 1,
};

typedef enum SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e;

struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13 {
	SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_discSyncWindow_r13_e discSyncWindow_r13;
};

enum SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e {
	SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_true = 0,
};

typedef enum SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e;

enum SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e {
	SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_true = 0,
};

typedef enum SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e;

struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional {
	bool d;
	struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13 v;
};

struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional {
	bool d;
	struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13 v;
};

struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional {
	bool d;
	struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13 v;
};

struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional {
	bool d;
	SQN_SL_OffsetIndicatorSync_v1430 v;
};

struct SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional {
	bool d;
	SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e v;
};

struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional {
	bool d;
	SQN_SL_OffsetIndicatorSync_r14 v;
};

struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional {
	bool d;
	SQN_SL_OffsetIndicatorSync_r14 v;
};

struct SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional {
	bool d;
	SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e v;
};

struct SQN_SL_SyncConfigNFreq_r13 {
	struct SQN_SL_SyncConfigNFreq_r13_asyncParameters_r13_asyncParameters_r13_Optional asyncParameters_r13;
	struct SQN_SL_SyncConfigNFreq_r13_txParameters_r13_txParameters_r13_Optional txParameters_r13;
	struct SQN_SL_SyncConfigNFreq_r13_rxParameters_r13_rxParameters_r13_Optional rxParameters_r13;
	struct SQN_SL_OffsetIndicatorSync_v1430_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator_v1430_Optional syncOffsetIndicator_v1430;
	struct SQN_SL_SyncConfigNFreq_r13_gnss_Sync_r14_e_gnss_Sync_r14_Optional gnss_Sync_r14;
	struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator2_r14_Optional syncOffsetIndicator2_r14;
	struct SQN_SL_OffsetIndicatorSync_r14_SQN_SL_SyncConfigNFreq_r13_syncOffsetIndicator3_r14_Optional syncOffsetIndicator3_r14;
	struct SQN_SL_SyncConfigNFreq_r13_slss_TxDisabled_r15_e_slss_TxDisabled_r15_Optional slss_TxDisabled_r15;
};

struct SQN_SL_SyncConfigNFreq_r13_SQN_SL_SyncConfigListNFreq_r13_Dynamic {
	size_t d;
	struct SQN_SL_SyncConfigNFreq_r13* v;
};

typedef struct SQN_SL_SyncConfigNFreq_r13_SQN_SL_SyncConfigListNFreq_r13_Dynamic SQN_SL_SyncConfigListNFreq_r13;

enum SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e {
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB0 = 0,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB1 = 1,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB2 = 2,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB3 = 3,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB4 = 4,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB5 = 5,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB6 = 6,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB8 = 7,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB10 = 8,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB12 = 9,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB14 = 10,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB16 = 11,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB18 = 12,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB20 = 13,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB22 = 14,
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e_dB24 = 15,
};

typedef enum SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e;

struct uint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional {
	bool d;
	uint8_t v;
};

struct SQN_CellSelectionInfoNFreq_r13 {
	SQN_Q_RxLevMin q_RxLevMin_r13;
	struct uint8_t_SQN_CellSelectionInfoNFreq_r13_q_RxLevMinOffset_Optional q_RxLevMinOffset;
	SQN_CellSelectionInfoNFreq_r13_q_Hyst_r13_e q_Hyst_r13;
	SQN_Q_RxLevMin q_RxLevMinReselection_r13;
	SQN_T_Reselection t_ReselectionEUTRA_r13;
};

struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional {
	bool d;
	SQN_SL_DiscTxPowerInfoList_r12 v;
};

struct SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional {
	bool d;
	SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e v;
};

struct SQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional {
	bool d;
	SQN_SL_SyncConfigListNFreq_r13 v;
};

struct SQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional {
	bool d;
	struct SQN_CellSelectionInfoNFreq_r13 v;
};

struct SQN_SL_DiscConfigOtherInterFreq_r13 {
	struct SQN_SL_DiscTxPowerInfoList_r12_SQN_SL_DiscConfigOtherInterFreq_r13_txPowerInfo_r13_Optional txPowerInfo_r13;
	struct SQN_SL_DiscConfigOtherInterFreq_r13_refCarrierCommon_r13_e_refCarrierCommon_r13_Optional refCarrierCommon_r13;
	struct SQN_SL_SyncConfigListNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discSyncConfig_r13_Optional discSyncConfig_r13;
	struct SQN_CellSelectionInfoNFreq_r13_SQN_SL_DiscConfigOtherInterFreq_r13_discCellSelectionInfo_r13_Optional discCellSelectionInfo_r13;
};

struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional {
	bool d;
	struct SQN_SL_ResourcesInterFreq_r13 v;
};

struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional {
	bool d;
	struct SQN_SL_ResourcesInterFreq_r13 v;
};

struct SQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional {
	bool d;
	struct SQN_SL_DiscConfigOtherInterFreq_r13 v;
};

struct SQN_SL_CarrierFreqInfo_v1310 {
	struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesNonPS_r13_Optional discResourcesNonPS_r13;
	struct SQN_SL_ResourcesInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discResourcesPS_r13_Optional discResourcesPS_r13;
	struct SQN_SL_DiscConfigOtherInterFreq_r13_SQN_SL_CarrierFreqInfo_v1310_discConfigOther_r13_Optional discConfigOther_r13;
};

struct SQN_SL_CarrierFreqInfo_v1310_SQN_SL_CarrierFreqInfoList_v1310_Dynamic {
	size_t d;
	struct SQN_SL_CarrierFreqInfo_v1310* v;
};

typedef struct SQN_SL_CarrierFreqInfo_v1310_SQN_SL_CarrierFreqInfoList_v1310_Dynamic SQN_SL_CarrierFreqInfoList_v1310;

enum SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e {
	SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e;

struct SQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional {
	bool d;
	SQN_SL_CarrierFreqInfoList_v1310 v;
};

struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional {
	bool d;
	SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e v;
};

struct SQN_SystemInformationBlockType19_r12_discConfig_v1310 {
	struct SQN_SL_CarrierFreqInfoList_v1310_SQN_SystemInformationBlockType19_r12_discConfig_v1310_discInterFreqList_v1310_Optional discInterFreqList_v1310;
	struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_gapRequestsAllowedCommon_e_gapRequestsAllowedCommon_Optional gapRequestsAllowedCommon;
};

typedef uint8_t SQN_RSRP_RangeSL4_r13;

enum SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e {
	SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB0 = 0,
	SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB3 = 1,
	SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB6 = 2,
	SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB9 = 3,
	SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dB12 = 4,
	SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_dBinf = 5,
};

typedef enum SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e;

enum SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e {
	SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB0 = 0,
	SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB3 = 1,
	SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB6 = 2,
	SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB9 = 3,
	SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_dB12 = 4,
};

typedef enum SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e;

struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional {
	bool d;
	SQN_RSRP_RangeSL4_r13 v;
};

struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional {
	bool d;
	SQN_RSRP_RangeSL4_r13 v;
};

struct SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional {
	bool d;
	SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e v;
};

struct SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional {
	bool d;
	SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e v;
};

struct SQN_SL_DiscConfigRelayUE_r13 {
	struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshHigh_r13_Optional threshHigh_r13;
	struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRelayUE_r13_threshLow_r13_Optional threshLow_r13;
	struct SQN_SL_DiscConfigRelayUE_r13_hystMax_r13_e_hystMax_r13_Optional hystMax_r13;
	struct SQN_SL_DiscConfigRelayUE_r13_hystMin_r13_e_hystMin_r13_Optional hystMin_r13;
};

enum SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e {
	SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB0 = 0,
	SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB3 = 1,
	SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB6 = 2,
	SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB9 = 3,
	SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_dB12 = 4,
};

typedef enum SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e;

enum SQN_FilterCoefficient_e {
	SQN_FilterCoefficient_e_fc0 = 0,
	SQN_FilterCoefficient_e_fc1 = 1,
	SQN_FilterCoefficient_e_fc2 = 2,
	SQN_FilterCoefficient_e_fc3 = 3,
	SQN_FilterCoefficient_e_fc4 = 4,
	SQN_FilterCoefficient_e_fc5 = 5,
	SQN_FilterCoefficient_e_fc6 = 6,
	SQN_FilterCoefficient_e_fc7 = 7,
	SQN_FilterCoefficient_e_fc8 = 8,
	SQN_FilterCoefficient_e_fc9 = 9,
	SQN_FilterCoefficient_e_fc11 = 10,
	SQN_FilterCoefficient_e_fc13 = 11,
	SQN_FilterCoefficient_e_fc15 = 12,
	SQN_FilterCoefficient_e_fc17 = 13,
	SQN_FilterCoefficient_e_fc19 = 14,
	SQN_FilterCoefficient_e_spare1 = 15,
};

typedef enum SQN_FilterCoefficient_e SQN_FilterCoefficient_e;

enum SQN_ReselectionInfoRelay_r13_minHyst_r13_e {
	SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB0 = 0,
	SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB3 = 1,
	SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB6 = 2,
	SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB9 = 3,
	SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dB12 = 4,
	SQN_ReselectionInfoRelay_r13_minHyst_r13_e_dBinf = 5,
};

typedef enum SQN_ReselectionInfoRelay_r13_minHyst_r13_e SQN_ReselectionInfoRelay_r13_minHyst_r13_e;

struct SQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional {
	bool d;
	SQN_ReselectionInfoRelay_r13_minHyst_r13_e v;
};

struct SQN_ReselectionInfoRelay_r13 {
	SQN_Q_RxLevMin q_RxLevMin_r13;
	SQN_FilterCoefficient_e filterCoefficient_r13;
	struct SQN_ReselectionInfoRelay_r13_minHyst_r13_e_minHyst_r13_Optional minHyst_r13;
};

struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional {
	bool d;
	SQN_RSRP_RangeSL4_r13 v;
};

struct SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional {
	bool d;
	SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e v;
};

struct SQN_SL_DiscConfigRemoteUE_r13 {
	struct SQN_RSRP_RangeSL4_r13_SQN_SL_DiscConfigRemoteUE_r13_threshHigh_r13_Optional threshHigh_r13;
	struct SQN_SL_DiscConfigRemoteUE_r13_hystMax_r13_e_hystMax_r13_Optional hystMax_r13;
	struct SQN_ReselectionInfoRelay_r13 reselectionInfoIC_r13;
};

struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13 {
	struct SQN_SL_DiscConfigRelayUE_r13 relayUE_Config_r13;
	struct SQN_SL_DiscConfigRemoteUE_r13 remoteUE_Config_r13;
};

struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional {
	bool d;
	SQN_SL_DiscTxPoolList_r12 v;
};

struct SQN_SystemInformationBlockType19_r12_discConfigPS_13 {
	SQN_SL_DiscRxPoolList_r12 discRxPoolPS_r13;
	struct SQN_SL_DiscTxPoolList_r12_SQN_SystemInformationBlockType19_r12_discConfigPS_13_discTxPoolPS_Common_r13_Optional discTxPoolPS_Common_r13;
};

struct SQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional {
	bool d;
	struct SQN_SystemInformationBlockType19_r12_discConfig_r12 v;
};

struct SQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional {
	bool d;
	SQN_SL_CarrierFreqInfoList_r12 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional {
	bool d;
	struct SQN_SystemInformationBlockType19_r12_discConfig_v1310 v;
};

struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional {
	bool d;
	struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13 v;
};

struct SQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional {
	bool d;
	struct SQN_SystemInformationBlockType19_r12_discConfigPS_13 v;
};

struct SQN_SystemInformationBlockType19_r12 {
	struct SQN_SystemInformationBlockType19_r12_discConfig_r12_discConfig_r12_Optional discConfig_r12;
	struct SQN_SL_CarrierFreqInfoList_r12_SQN_SystemInformationBlockType19_r12_discInterFreqList_r12_Optional discInterFreqList_r12;
	struct OCTET_STRING_SQN_SystemInformationBlockType19_r12_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SystemInformationBlockType19_r12_discConfig_v1310_discConfig_v1310_Optional discConfig_v1310;
	struct SQN_SystemInformationBlockType19_r12_discConfigRelay_r13_discConfigRelay_r13_Optional discConfigRelay_r13;
	struct SQN_SystemInformationBlockType19_r12_discConfigPS_13_discConfigPS_13_Optional discConfigPS_13;
};

enum SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e {
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf2 = 0,
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf4 = 1,
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf8 = 2,
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf16 = 3,
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf32 = 4,
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf64 = 5,
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf128 = 6,
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e_rf256 = 7,
};

typedef enum SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e;

enum SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e {
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf2 = 0,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf4 = 1,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf8 = 2,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf16 = 3,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf32 = 4,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf64 = 5,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf128 = 6,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf256 = 7,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf512 = 8,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf1024 = 9,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_r2048 = 10,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf4096 = 11,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf8192 = 12,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf16384 = 13,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf32768 = 14,
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e_rf65536 = 15,
};

typedef enum SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e_rf1 = 0,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e_rf1 = 0,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r1 = 0,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r2 = 1,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r4 = 2,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r8 = 3,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r16 = 4,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r32 = 5,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r64 = 6,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r128 = 7,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e_r256 = 8,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v1 = 0,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v1dot5 = 1,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v2 = 2,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v2dot5 = 3,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v4 = 4,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v5 = 5,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v8 = 6,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e_v10 = 7,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v1 = 0,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v2 = 1,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v4 = 2,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v5 = 3,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v8 = 4,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v10 = 5,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e_v20 = 6,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Sel {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_UNBOUND_VALUE = 0,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14 = 1,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14 = 2,
};

union SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_fdd_r14_e fdd_r14;
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_tdd_r14_e tdd_r14;
};

struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14 {
	enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Sel d;
	union SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14_Value v;
};

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_off = 0,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_ce_ModeA = 1,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e_ce_ModeB = 2,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf32 = 0,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf128 = 1,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf512 = 2,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf1024 = 3,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf2048 = 4,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf4096 = 5,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf8192 = 6,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e_rf16384 = 7,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e;

enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf32 = 0,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf128 = 1,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf256 = 2,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf512 = 3,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf1024 = 4,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf2048 = 5,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf4096 = 6,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf8192 = 7,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf16384 = 8,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf32768 = 9,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf65536 = 10,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf131072 = 11,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf262144 = 12,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf524288 = 13,
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e_rf1048576 = 14,
};

typedef enum SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e;

struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14 {
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy_e dummy;
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_dummy2_e dummy2;
	uint8_t mpdcch_Narrowband_SC_MCCH_r14;
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_NumRepetition_SC_MCCH_r14_e mpdcch_NumRepetition_SC_MCCH_r14;
	struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_StartSF_SC_MCCH_r14 mpdcch_StartSF_SC_MCCH_r14;
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14_e mpdcch_PDSCH_HoppingConfig_SC_MCCH_r14;
	SQN_ARFCN_ValueEUTRA_r9 sc_mcch_CarrierFreq_r14;
	uint8_t sc_mcch_Offset_BR_r14;
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_RepetitionPeriod_BR_r14_e sc_mcch_RepetitionPeriod_BR_r14;
	SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_sc_mcch_ModificationPeriod_BR_r14_e sc_mcch_ModificationPeriod_BR_r14;
};

enum SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e {
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf10 = 0,
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf20 = 1,
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf100 = 2,
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf300 = 3,
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf500 = 4,
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1000 = 5,
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1200 = 6,
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e_psf1600 = 7,
};

typedef enum SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e;

enum SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e {
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf0 = 0,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf1 = 1,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf2 = 2,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf4 = 3,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf8 = 4,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf16 = 5,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf32 = 6,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf64 = 7,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf128 = 8,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf256 = 9,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_ps512 = 10,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf1024 = 11,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf2048 = 12,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf4096 = 13,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf8192 = 14,
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e_psf16384 = 15,
};

typedef enum SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e;

enum SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Sel {
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_UNBOUND_VALUE = 0,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf10 = 1,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf20 = 2,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf32 = 3,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf40 = 4,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf64 = 5,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf80 = 6,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf128 = 7,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf160 = 8,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf256 = 9,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf320 = 10,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf512 = 11,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf640 = 12,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf1024 = 13,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf2048 = 14,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf4096 = 15,
	SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_sf8192 = 16,
};

union SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value {
	uint8_t sf10;
	uint8_t sf20;
	uint8_t sf32;
	uint8_t sf40;
	uint8_t sf64;
	uint8_t sf80;
	uint8_t sf128;
	uint8_t sf160;
	uint8_t sf256;
	uint16_t sf320;
	uint16_t sf512;
	uint16_t sf640;
	uint16_t sf1024;
	uint16_t sf2048;
	uint16_t sf4096;
	uint16_t sf8192;
};

struct SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14 {
	enum SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Sel d;
	union SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14_Value v;
};

struct SQN_SC_MCCH_SchedulingInfo_r14 {
	SQN_SC_MCCH_SchedulingInfo_r14_onDurationTimerSCPTM_r14_e onDurationTimerSCPTM_r14;
	SQN_SC_MCCH_SchedulingInfo_r14_drx_InactivityTimerSCPTM_r14_e drx_InactivityTimerSCPTM_r14;
	struct SQN_SC_MCCH_SchedulingInfo_r14_schedulingPeriodStartOffsetSCPTM_r14 schedulingPeriodStartOffsetSCPTM_r14;
};

enum SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e {
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_r16 = 0,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_r32 = 1,
};

typedef enum SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e;

enum SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e {
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r192 = 0,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r256 = 1,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r384 = 2,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r512 = 3,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r768 = 4,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r1024 = 5,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r1536 = 6,
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_r2048 = 7,
};

typedef enum SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e;

enum SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e {
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_rf1 = 0,
};

typedef enum SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e;

enum SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e {
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_rf1 = 0,
};

typedef enum SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e;

struct uint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional {
	bool d;
	uint8_t v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional {
	bool d;
	struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14 v;
};

struct SQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional {
	bool d;
	struct SQN_SC_MCCH_SchedulingInfo_r14 v;
};

struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional {
	bool d;
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e v;
};

struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional {
	bool d;
	SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e v;
};

struct SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional {
	bool d;
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e v;
};

struct SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional {
	bool d;
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e v;
};

struct SQN_SystemInformationBlockType20_r13 {
	SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_r13_e sc_mcch_RepetitionPeriod_r13;
	uint8_t sc_mcch_Offset_r13;
	uint8_t sc_mcch_FirstSubframe_r13;
	struct uint8_t_SQN_SystemInformationBlockType20_r13_sc_mcch_duration_r13_Optional sc_mcch_duration_r13;
	SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_r13_e sc_mcch_ModificationPeriod_r13;
	struct OCTET_STRING_SQN_SystemInformationBlockType20_r13_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SystemInformationBlockType20_r13_br_BCCH_Config_r14_br_BCCH_Config_r14_Optional br_BCCH_Config_r14;
	struct SQN_SC_MCCH_SchedulingInfo_r14_SQN_SystemInformationBlockType20_r13_sc_mcch_SchedulingInfo_r14_Optional sc_mcch_SchedulingInfo_r14;
	struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14_Optional pdsch_maxNumRepetitionCEmodeA_SC_MTCH_r14;
	struct SQN_SystemInformationBlockType20_r13_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_e_pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14_Optional pdsch_maxNumRepetitionCEmodeB_SC_MTCH_r14;
	struct SQN_SystemInformationBlockType20_r13_sc_mcch_RepetitionPeriod_v1470_e_sc_mcch_RepetitionPeriod_v1470_Optional sc_mcch_RepetitionPeriod_v1470;
	struct SQN_SystemInformationBlockType20_r13_sc_mcch_ModificationPeriod_v1470_e_sc_mcch_ModificationPeriod_v1470_Optional sc_mcch_ModificationPeriod_v1470;
};

enum SQN_SubframeBitmapSL_r14_Sel {
	SQN_SubframeBitmapSL_r14_UNBOUND_VALUE = 0,
	SQN_SubframeBitmapSL_r14_bs10_r14 = 1,
	SQN_SubframeBitmapSL_r14_bs16_r14 = 2,
	SQN_SubframeBitmapSL_r14_bs20_r14 = 3,
	SQN_SubframeBitmapSL_r14_bs30_r14 = 4,
	SQN_SubframeBitmapSL_r14_bs40_r14 = 5,
	SQN_SubframeBitmapSL_r14_bs50_r14 = 6,
	SQN_SubframeBitmapSL_r14_bs60_r14 = 7,
	SQN_SubframeBitmapSL_r14_bs100_r14 = 8,
};

union SQN_SubframeBitmapSL_r14_Value {
	B10 bs10_r14;
	B16 bs16_r14;
	B20 bs20_r14;
	B30 bs30_r14;
	B40 bs40_r14;
	B50 bs50_r14;
	B60 bs60_r14;
	B100 bs100_r14;
};

struct SQN_SubframeBitmapSL_r14 {
	enum SQN_SubframeBitmapSL_r14_Sel d;
	union SQN_SubframeBitmapSL_r14_Value v;
};

enum SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e {
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n4 = 0,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n5 = 1,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n6 = 2,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n8 = 3,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n9 = 4,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n10 = 5,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n12 = 6,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n15 = 7,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n16 = 8,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n18 = 9,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n20 = 10,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n25 = 11,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n30 = 12,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n48 = 13,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n50 = 14,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n72 = 15,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n75 = 16,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n96 = 17,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_n100 = 18,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare13 = 19,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare12 = 20,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare11 = 21,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare10 = 22,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare9 = 23,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare8 = 24,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare7 = 25,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare6 = 26,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare5 = 27,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare4 = 28,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare3 = 29,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare2 = 30,
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e_spare1 = 31,
};

typedef enum SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e;

enum SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e {
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n1 = 0,
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n3 = 1,
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n5 = 2,
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n8 = 3,
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n10 = 4,
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n15 = 5,
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_n20 = 6,
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e_spare1 = 7,
};

typedef enum SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e;

struct SQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional {
	bool d;
	struct SQN_TDD_Config v;
};

struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14 {
	struct SQN_TDD_Config_SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_tdd_Config_r14_Optional tdd_Config_r14;
	uint8_t syncConfigIndex_r14;
};

typedef uint8_t SQN_SL_V2X_TxPoolReportIdentity_r14;

typedef uint8_t SQN_Tx_ConfigIndex_r14;

struct SQN_Tx_ConfigIndex_r14_tx_ConfigIndexList_r14_Dynamic {
	size_t d;
	SQN_Tx_ConfigIndex_r14* v;
};

struct SQN_SL_PPPP_TxConfigIndex_r14 {
	SQN_SL_Priority_r13 priorityThreshold_r14;
	uint8_t defaultTxConfigIndex_r14;
	uint8_t cbr_ConfigIndex_r14;
	struct SQN_Tx_ConfigIndex_r14_tx_ConfigIndexList_r14_Dynamic tx_ConfigIndexList_r14;
};

struct SQN_SL_PPPP_TxConfigIndex_r14_SQN_SL_CBR_PPPP_TxConfigList_r14_Dynamic {
	size_t d;
	struct SQN_SL_PPPP_TxConfigIndex_r14* v;
};

typedef struct SQN_SL_PPPP_TxConfigIndex_r14_SQN_SL_CBR_PPPP_TxConfigList_r14_Dynamic SQN_SL_CBR_PPPP_TxConfigList_r14;

enum SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e {
	SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_true = 0,
};

typedef enum SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e;

enum SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e {
	SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_true = 0,
};

typedef enum SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e;

struct SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional {
	bool d;
	SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e v;
};

struct SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional {
	bool d;
	SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e v;
};

struct SQN_SL_P2X_ResourceSelectionConfig_r14 {
	struct SQN_SL_P2X_ResourceSelectionConfig_r14_partialSensing_r14_e_partialSensing_r14_Optional partialSensing_r14;
	struct SQN_SL_P2X_ResourceSelectionConfig_r14_randomSelection_r14_e_randomSelection_r14_Optional randomSelection_r14;
};

enum SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e {
	SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_true = 0,
};

typedef enum SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e;

enum SQN_SL_SyncAllowed_r14_enb_Sync_r14_e {
	SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_true = 0,
};

typedef enum SQN_SL_SyncAllowed_r14_enb_Sync_r14_e SQN_SL_SyncAllowed_r14_enb_Sync_r14_e;

enum SQN_SL_SyncAllowed_r14_ue_Sync_r14_e {
	SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_true = 0,
};

typedef enum SQN_SL_SyncAllowed_r14_ue_Sync_r14_e SQN_SL_SyncAllowed_r14_ue_Sync_r14_e;

struct SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional {
	bool d;
	SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e v;
};

struct SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional {
	bool d;
	SQN_SL_SyncAllowed_r14_enb_Sync_r14_e v;
};

struct SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional {
	bool d;
	SQN_SL_SyncAllowed_r14_ue_Sync_r14_e v;
};

struct SQN_SL_SyncAllowed_r14 {
	struct SQN_SL_SyncAllowed_r14_gnss_Sync_r14_e_gnss_Sync_r14_Optional gnss_Sync_r14;
	struct SQN_SL_SyncAllowed_r14_enb_Sync_r14_e_enb_Sync_r14_Optional enb_Sync_r14;
	struct SQN_SL_SyncAllowed_r14_ue_Sync_r14_e_ue_Sync_r14_Optional ue_Sync_r14;
};

enum SQN_SL_RestrictResourceReservationPeriod_r14_e {
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v0dot2 = 0,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v0dot5 = 1,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v1 = 2,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v2 = 3,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v3 = 4,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v4 = 5,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v5 = 6,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v6 = 7,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v7 = 8,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v8 = 9,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v9 = 10,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_v10 = 11,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_spare4 = 12,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_spare3 = 13,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_spare2 = 14,
	SQN_SL_RestrictResourceReservationPeriod_r14_e_spare1 = 15,
};

typedef enum SQN_SL_RestrictResourceReservationPeriod_r14_e SQN_SL_RestrictResourceReservationPeriod_r14_e;

struct SQN_SL_RestrictResourceReservationPeriod_r14_e_SQN_SL_RestrictResourceReservationPeriodList_r14_Dynamic {
	size_t d;
	SQN_SL_RestrictResourceReservationPeriod_r14_e* v;
};

typedef struct SQN_SL_RestrictResourceReservationPeriod_r14_e_SQN_SL_RestrictResourceReservationPeriodList_r14_Dynamic SQN_SL_RestrictResourceReservationPeriodList_r14;

struct SQN_SL_MinT2Value_r15 {
	SQN_SL_PriorityList_r13 priorityList_r15;
	uint8_t minT2Value_r15;
};

struct SQN_SL_MinT2Value_r15_SQN_SL_MinT2ValueList_r15_Dynamic {
	size_t d;
	struct SQN_SL_MinT2Value_r15* v;
};

typedef struct SQN_SL_MinT2Value_r15_SQN_SL_MinT2ValueList_r15_Dynamic SQN_SL_MinT2ValueList_r15;

struct SQN_MCS_PSSCH_Range_r15 {
	uint8_t minMCS_PSSCH_r15;
	uint8_t maxMCS_PSSCH_r15;
};

struct SQN_SL_PPPP_TxConfigIndex_v1530_SQN_MCS_PSSCH_Range_r15_mcs_PSSCH_RangeList_r15_Dynamic {
	size_t d;
	struct SQN_MCS_PSSCH_Range_r15* v;
};

struct SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional {
	bool d;
	struct SQN_SL_PPPP_TxConfigIndex_v1530_SQN_MCS_PSSCH_Range_r15_mcs_PSSCH_RangeList_r15_Dynamic v;
};

struct SQN_SL_PPPP_TxConfigIndex_v1530 {
	struct SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_v1530_mcs_PSSCH_RangeList_r15_DynamicOptional mcs_PSSCH_RangeList_r15;
};

struct SQN_SL_PPPP_TxConfigIndex_v1530_SQN_SL_CBR_PPPP_TxConfigList_v1530_Dynamic {
	size_t d;
	struct SQN_SL_PPPP_TxConfigIndex_v1530* v;
};

typedef struct SQN_SL_PPPP_TxConfigIndex_v1530_SQN_SL_CBR_PPPP_TxConfigList_v1530_Dynamic SQN_SL_CBR_PPPP_TxConfigList_v1530;

struct SQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional {
	bool d;
	struct SQN_SL_OffsetIndicator_r12 v;
};

struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional {
	bool d;
	uint8_t v;
};

struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional {
	bool d;
	struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14 v;
};

struct SQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional {
	bool d;
	struct SQN_SL_TxParameters_r12 v;
};

struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional {
	bool d;
	uint8_t v;
};

struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional {
	bool d;
	uint8_t v;
};

struct SQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional {
	bool d;
	SQN_SL_V2X_TxPoolReportIdentity_r14 v;
};

struct SQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional {
	bool d;
	SQN_SL_CBR_PPPP_TxConfigList_r14 v;
};

struct SQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional {
	bool d;
	struct SQN_SL_P2X_ResourceSelectionConfig_r14 v;
};

struct SQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional {
	bool d;
	struct SQN_SL_SyncAllowed_r14 v;
};

struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional {
	bool d;
	SQN_SL_RestrictResourceReservationPeriodList_r14 v;
};

struct SQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional {
	bool d;
	SQN_SL_MinT2ValueList_r15 v;
};

struct SQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional {
	bool d;
	SQN_SL_CBR_PPPP_TxConfigList_v1530 v;
};

struct SQN_SL_CommResourcePoolV2X_r14 {
	struct SQN_SL_OffsetIndicator_r12_SQN_SL_CommResourcePoolV2X_r14_sl_OffsetIndicator_r14_Optional sl_OffsetIndicator_r14;
	struct SQN_SubframeBitmapSL_r14 sl_Subframe_r14;
	bool adjacencyPSCCH_PSSCH_r14;
	SQN_SL_CommResourcePoolV2X_r14_sizeSubchannel_r14_e sizeSubchannel_r14;
	SQN_SL_CommResourcePoolV2X_r14_numSubchannel_r14_e numSubchannel_r14;
	uint8_t startRB_Subchannel_r14;
	struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_startRB_PSCCH_Pool_r14_Optional startRB_PSCCH_Pool_r14;
	struct SQN_SL_CommResourcePoolV2X_r14_rxParametersNCell_r14_rxParametersNCell_r14_Optional rxParametersNCell_r14;
	struct SQN_SL_TxParameters_r12_SQN_SL_CommResourcePoolV2X_r14_dataTxParameters_r14_Optional dataTxParameters_r14;
	struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_zoneID_r14_Optional zoneID_r14;
	struct uint8_t_SQN_SL_CommResourcePoolV2X_r14_threshS_RSSI_CBR_r14_Optional threshS_RSSI_CBR_r14;
	struct SQN_SL_V2X_TxPoolReportIdentity_r14_SQN_SL_CommResourcePoolV2X_r14_poolReportId_r14_Optional poolReportId_r14;
	struct SQN_SL_CBR_PPPP_TxConfigList_r14_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_r14_Optional cbr_pssch_TxConfigList_r14;
	struct SQN_SL_P2X_ResourceSelectionConfig_r14_SQN_SL_CommResourcePoolV2X_r14_resourceSelectionConfigP2X_r14_Optional resourceSelectionConfigP2X_r14;
	struct SQN_SL_SyncAllowed_r14_SQN_SL_CommResourcePoolV2X_r14_syncAllowed_r14_Optional syncAllowed_r14;
	struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommResourcePoolV2X_r14_restrictResourceReservationPeriod_r14_Optional restrictResourceReservationPeriod_r14;
	struct SQN_SL_MinT2ValueList_r15_SQN_SL_CommResourcePoolV2X_r14_sl_MinT2ValueList_r15_Optional sl_MinT2ValueList_r15;
	struct SQN_SL_CBR_PPPP_TxConfigList_v1530_SQN_SL_CommResourcePoolV2X_r14_cbr_pssch_TxConfigList_v1530_Optional cbr_pssch_TxConfigList_v1530;
};

struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_CommRxPoolListV2X_r14_Dynamic {
	size_t d;
	struct SQN_SL_CommResourcePoolV2X_r14* v;
};

typedef struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_CommRxPoolListV2X_r14_Dynamic SQN_SL_CommRxPoolListV2X_r14;

struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_CommTxPoolListV2X_r14_Dynamic {
	size_t d;
	struct SQN_SL_CommResourcePoolV2X_r14* v;
};

typedef struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_CommTxPoolListV2X_r14_Dynamic SQN_SL_CommTxPoolListV2X_r14;

struct SQN_SL_SyncConfig_r12_SQN_SL_SyncConfigListV2X_r14_Dynamic {
	size_t d;
	struct SQN_SL_SyncConfig_r12* v;
};

typedef struct SQN_SL_SyncConfig_r12_SQN_SL_SyncConfigListV2X_r14_Dynamic SQN_SL_SyncConfigListV2X_r14;

enum SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e {
	SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e_reserved = 0,
	SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e_notReserved = 1,
};

typedef enum SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e;

struct SQN_PLMN_IdentityInfo {
	struct SQN_PLMN_Identity plmn_Identity;
	SQN_PLMN_IdentityInfo_cellReservedForOperatorUse_e cellReservedForOperatorUse;
};

struct SQN_PLMN_IdentityInfo_SQN_PLMN_IdentityList_Dynamic {
	size_t d;
	struct SQN_PLMN_IdentityInfo* v;
};

typedef struct SQN_PLMN_IdentityInfo_SQN_PLMN_IdentityList_Dynamic SQN_PLMN_IdentityList;

enum SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e {
	SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n6 = 0,
	SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n15 = 1,
	SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n25 = 2,
	SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n50 = 3,
	SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n75 = 4,
	SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_n100 = 5,
};

typedef enum SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e;

enum SQN_SL_TypeTxSync_r14_e {
	SQN_SL_TypeTxSync_r14_e_gnss = 0,
	SQN_SL_TypeTxSync_r14_e_enb = 1,
	SQN_SL_TypeTxSync_r14_e_ue = 2,
};

typedef enum SQN_SL_TypeTxSync_r14_e SQN_SL_TypeTxSync_r14_e;

struct SQN_SL_SyncConfigNFreq_r13_SQN_SL_SyncConfigListNFreqV2X_r14_Dynamic {
	size_t d;
	struct SQN_SL_SyncConfigNFreq_r13* v;
};

typedef struct SQN_SL_SyncConfigNFreq_r13_SQN_SL_SyncConfigListNFreqV2X_r14_Dynamic SQN_SL_SyncConfigListNFreqV2X_r14;

enum SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e {
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph60 = 0,
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph80 = 1,
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph100 = 2,
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph120 = 3,
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph140 = 4,
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph160 = 5,
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph180 = 6,
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e_kmph200 = 7,
};

typedef enum SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e;

enum SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e {
	SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_n0 = 0,
	SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_n1 = 1,
	SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_both = 2,
	SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e_spare1 = 3,
};

typedef enum SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e;

enum SQN_SL_TxPower_r14_Sel {
	SQN_SL_TxPower_r14_UNBOUND_VALUE = 0,
	SQN_SL_TxPower_r14_minusinfinity_r14 = 1,
	SQN_SL_TxPower_r14_txPower_r14 = 2,
};

union SQN_SL_TxPower_r14_Value {
	Null minusinfinity_r14;
	int8_t txPower_r14;
};

struct SQN_SL_TxPower_r14 {
	enum SQN_SL_TxPower_r14_Sel d;
	union SQN_SL_TxPower_r14_Value v;
};

struct SQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional {
	bool d;
	struct SQN_SL_TxPower_r14 v;
};

struct SQN_SL_PSSCH_TxParameters_r14 {
	uint8_t minMCS_PSSCH_r14;
	uint8_t maxMCS_PSSCH_r14;
	uint8_t minSubChannel_NumberPSSCH_r14;
	uint8_t maxSubchannel_NumberPSSCH_r14;
	SQN_SL_PSSCH_TxParameters_r14_allowedRetxNumberPSSCH_r14_e allowedRetxNumberPSSCH_r14;
	struct SQN_SL_TxPower_r14_SQN_SL_PSSCH_TxParameters_r14_maxTxPower_r14_Optional maxTxPower_r14;
};

struct SQN_SL_PSSCH_TxParameters_v1530 {
	uint8_t minMCS_PSSCH_r15;
	uint8_t maxMCS_PSSCH_r15;
};

struct SQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional {
	bool d;
	SQN_SL_TypeTxSync_r14_e v;
};

struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional {
	bool d;
	struct SQN_SL_PSSCH_TxParameters_v1530 v;
};

struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional {
	bool d;
	struct SQN_SL_PSSCH_TxParameters_v1530 v;
};

struct SQN_SL_PSSCH_TxConfig_r14 {
	struct SQN_SL_TypeTxSync_r14_e_SQN_SL_PSSCH_TxConfig_r14_typeTxSync_r14_Optional typeTxSync_r14;
	SQN_SL_PSSCH_TxConfig_r14_thresUE_Speed_r14_e thresUE_Speed_r14;
	struct SQN_SL_PSSCH_TxParameters_r14 parametersAboveThres_r14;
	struct SQN_SL_PSSCH_TxParameters_r14 parametersBelowThres_r14;
	struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersAboveThres_v1530_Optional parametersAboveThres_v1530;
	struct SQN_SL_PSSCH_TxParameters_v1530_SQN_SL_PSSCH_TxConfig_r14_parametersBelowThres_v1530_Optional parametersBelowThres_v1530;
};

struct SQN_SL_PSSCH_TxConfig_r14_SQN_SL_PSSCH_TxConfigList_r14_Dynamic {
	size_t d;
	struct SQN_SL_PSSCH_TxConfig_r14* v;
};

typedef struct SQN_SL_PSSCH_TxConfig_r14_SQN_SL_PSSCH_TxConfigList_r14_Dynamic SQN_SL_PSSCH_TxConfigList_r14;

typedef uint8_t SQN_SL_ThresPSSCH_RSRP_r14;

typedef SQN_SL_ThresPSSCH_RSRP_r14 SQN_SL_ThresPSSCH_RSRP_List_r14[64];

enum SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e {
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0 = 0,
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot2 = 1,
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot4 = 2,
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot6 = 3,
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_v0dot8 = 4,
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare3 = 5,
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare2 = 6,
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e_spare1 = 7,
};

typedef enum SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e;

struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14 {
	uint8_t minNumCandidateSF_r14;
	B10 gapCandidateSensing_r14;
};

enum SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e {
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n1 = 0,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n2 = 1,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n3 = 2,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n4 = 3,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n5 = 4,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n6 = 5,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n7 = 6,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n8 = 7,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_n9 = 8,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare7 = 9,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare6 = 10,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare5 = 11,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare4 = 12,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare3 = 13,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare2 = 14,
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_spare1 = 15,
};

typedef enum SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e;

struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional {
	bool d;
	SQN_SL_RestrictResourceReservationPeriodList_r14 v;
};

struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional {
	bool d;
	struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14 v;
};

struct SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional {
	bool d;
	SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e v;
};

struct SQN_SL_CommTxPoolSensingConfig_r14 {
	SQN_SL_PSSCH_TxConfigList_r14 pssch_TxConfigList_r14;
	SQN_SL_ThresPSSCH_RSRP_List_r14 thresPSSCH_RSRP_List_r14;
	struct SQN_SL_RestrictResourceReservationPeriodList_r14_SQN_SL_CommTxPoolSensingConfig_r14_restrictResourceReservationPeriod_r14_Optional restrictResourceReservationPeriod_r14;
	SQN_SL_CommTxPoolSensingConfig_r14_probResourceKeep_r14_e probResourceKeep_r14;
	struct SQN_SL_CommTxPoolSensingConfig_r14_p2x_SensingConfig_r14_p2x_SensingConfig_r14_Optional p2x_SensingConfig_r14;
	struct SQN_SL_CommTxPoolSensingConfig_r14_sl_ReselectAfter_r14_e_sl_ReselectAfter_r14_Optional sl_ReselectAfter_r14;
};

enum SQN_SL_ZoneConfig_r14_zoneLength_r14_e {
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m5 = 0,
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m10 = 1,
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m20 = 2,
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m50 = 3,
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m100 = 4,
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m200 = 5,
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_m500 = 6,
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e_spare1 = 7,
};

typedef enum SQN_SL_ZoneConfig_r14_zoneLength_r14_e SQN_SL_ZoneConfig_r14_zoneLength_r14_e;

enum SQN_SL_ZoneConfig_r14_zoneWidth_r14_e {
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m5 = 0,
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m10 = 1,
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m20 = 2,
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m50 = 3,
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m100 = 4,
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m200 = 5,
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_m500 = 6,
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e_spare1 = 7,
};

typedef enum SQN_SL_ZoneConfig_r14_zoneWidth_r14_e SQN_SL_ZoneConfig_r14_zoneWidth_r14_e;

struct SQN_SL_ZoneConfig_r14 {
	SQN_SL_ZoneConfig_r14_zoneLength_r14_e zoneLength_r14;
	SQN_SL_ZoneConfig_r14_zoneWidth_r14_e zoneWidth_r14;
	uint8_t zoneIdLongiMod_r14;
	uint8_t zoneIdLatiMod_r14;
};

struct SQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional {
	bool d;
	SQN_PhysCellIdList_r13 v;
};

struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional {
	bool d;
	SQN_SL_TypeTxSync_r14_e v;
};

struct SQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional {
	bool d;
	SQN_SL_SyncConfigListNFreqV2X_r14 v;
};

struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional {
	bool d;
	SQN_SL_CommRxPoolListV2X_r14 v;
};

struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional {
	bool d;
	SQN_SL_CommTxPoolListV2X_r14 v;
};

struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional {
	bool d;
	SQN_SL_CommTxPoolListV2X_r14 v;
};

struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional {
	bool d;
	struct SQN_SL_CommResourcePoolV2X_r14 v;
};

struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional {
	bool d;
	struct SQN_SL_CommTxPoolSensingConfig_r14 v;
};

struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional {
	bool d;
	struct SQN_SL_ZoneConfig_r14 v;
};

struct uint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional {
	bool d;
	uint16_t v;
};

struct SQN_SL_V2X_InterFreqUE_Config_r14 {
	struct SQN_PhysCellIdList_r13_SQN_SL_V2X_InterFreqUE_Config_r14_physCellIdList_r14_Optional physCellIdList_r14;
	struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_InterFreqUE_Config_r14_typeTxSync_r14_Optional typeTxSync_r14;
	struct SQN_SL_SyncConfigListNFreqV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_SyncConfig_r14_Optional v2x_SyncConfig_r14;
	struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommRxPool_r14_Optional v2x_CommRxPool_r14;
	struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolNormal_r14_Optional v2x_CommTxPoolNormal_r14;
	struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_p2x_CommTxPoolNormal_r14_Optional p2x_CommTxPoolNormal_r14;
	struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_CommTxPoolExceptional_r14_Optional v2x_CommTxPoolExceptional_r14;
	struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_v2x_ResourceSelectionConfig_r14_Optional v2x_ResourceSelectionConfig_r14;
	struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_InterFreqUE_Config_r14_zoneConfig_r14_Optional zoneConfig_r14;
	struct uint16_t_SQN_SL_V2X_InterFreqUE_Config_r14_offsetDFN_r14_Optional offsetDFN_r14;
};

struct SQN_SL_V2X_InterFreqUE_Config_r14_SQN_SL_V2X_UE_ConfigList_r14_Dynamic {
	size_t d;
	struct SQN_SL_V2X_InterFreqUE_Config_r14* v;
};

typedef struct SQN_SL_V2X_InterFreqUE_Config_r14_SQN_SL_V2X_UE_ConfigList_r14_Dynamic SQN_SL_V2X_UE_ConfigList_r14;

enum SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Sel {
	SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_UNBOUND_VALUE = 0,
	SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmission_r14 = 1,
	SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmission_v1440 = 2,
};

union SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value {
	SQN_AdditionalSpectrumEmission additionalSpectrumEmission_r14;
	SQN_AdditionalSpectrumEmission_v10l0 additionalSpectrumEmission_v1440;
};

struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14 {
	enum SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Sel d;
	union SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_Value v;
};

typedef uint8_t SQN_SL_CBR_r14;

struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional {
	bool d;
	SQN_SL_CBR_r14 v;
};

struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional {
	bool d;
	SQN_SL_CBR_r14 v;
};

struct SQN_SL_V2X_FreqSelectionConfig_r15 {
	SQN_SL_PriorityList_r13 priorityList_r15;
	struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqReselection_r15_Optional threshCBR_FreqReselection_r15;
	struct SQN_SL_CBR_r14_SQN_SL_V2X_FreqSelectionConfig_r15_threshCBR_FreqKeeping_r15_Optional threshCBR_FreqKeeping_r15;
};

struct SQN_SL_V2X_FreqSelectionConfig_r15_SQN_SL_V2X_FreqSelectionConfigList_r15_Dynamic {
	size_t d;
	struct SQN_SL_V2X_FreqSelectionConfig_r15* v;
};

typedef struct SQN_SL_V2X_FreqSelectionConfig_r15_SQN_SL_V2X_FreqSelectionConfigList_r15_Dynamic SQN_SL_V2X_FreqSelectionConfigList_r15;

struct SQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional {
	bool d;
	SQN_PLMN_IdentityList v;
};

struct SQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional {
	bool d;
	SQN_P_Max v;
};

struct SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional {
	bool d;
	SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e v;
};

struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional {
	bool d;
	struct SQN_SL_CommResourcePoolV2X_r14 v;
};

struct SQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional {
	bool d;
	SQN_SL_V2X_UE_ConfigList_r14 v;
};

struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional {
	bool d;
	struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14 v;
};

struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional {
	bool d;
	SQN_SL_V2X_FreqSelectionConfigList_r15 v;
};

struct SQN_SL_InterFreqInfoV2X_r14 {
	struct SQN_PLMN_IdentityList_SQN_SL_InterFreqInfoV2X_r14_plmn_IdentityList_r14_Optional plmn_IdentityList_r14;
	SQN_ARFCN_ValueEUTRA_r9 v2x_CommCarrierFreq_r14;
	struct SQN_P_Max_SQN_SL_InterFreqInfoV2X_r14_sl_MaxTxPower_r14_Optional sl_MaxTxPower_r14;
	struct SQN_SL_InterFreqInfoV2X_r14_sl_Bandwidth_r14_e_sl_Bandwidth_r14_Optional sl_Bandwidth_r14;
	struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_SchedulingPool_r14_Optional v2x_SchedulingPool_r14;
	struct SQN_SL_V2X_UE_ConfigList_r14_SQN_SL_InterFreqInfoV2X_r14_v2x_UE_ConfigList_r14_Optional v2x_UE_ConfigList_r14;
	struct SQN_SL_InterFreqInfoV2X_r14_additionalSpectrumEmissionV2X_r14_additionalSpectrumEmissionV2X_r14_Optional additionalSpectrumEmissionV2X_r14;
	struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SL_InterFreqInfoV2X_r14_v2x_FreqSelectionConfigList_r15_Optional v2x_FreqSelectionConfigList_r15;
};

struct SQN_SL_InterFreqInfoV2X_r14_SQN_SL_InterFreqInfoListV2X_r14_Dynamic {
	size_t d;
	struct SQN_SL_InterFreqInfoV2X_r14* v;
};

typedef struct SQN_SL_InterFreqInfoV2X_r14_SQN_SL_InterFreqInfoListV2X_r14_Dynamic SQN_SL_InterFreqInfoListV2X_r14;

struct SQN_ARFCN_ValueEUTRA_r9_SQN_SL_AnchorCarrierFreqList_V2X_r14_Dynamic {
	size_t d;
	SQN_ARFCN_ValueEUTRA_r9* v;
};

typedef struct SQN_ARFCN_ValueEUTRA_r9_SQN_SL_AnchorCarrierFreqList_V2X_r14_Dynamic SQN_SL_AnchorCarrierFreqList_V2X_r14;

struct SQN_SL_CBR_r14_SQN_SL_CBR_Levels_Config_r14_Dynamic {
	size_t d;
	SQN_SL_CBR_r14* v;
};

typedef struct SQN_SL_CBR_r14_SQN_SL_CBR_Levels_Config_r14_Dynamic SQN_SL_CBR_Levels_Config_r14;

struct SQN_SL_CBR_PSSCH_TxConfig_r14 {
	uint16_t cr_Limit_r14;
	struct SQN_SL_PSSCH_TxParameters_r14 tx_Parameters_r14;
};

struct SQN_SL_CBR_Levels_Config_r14_cbr_RangeCommonConfigList_r14_Dynamic {
	size_t d;
	SQN_SL_CBR_Levels_Config_r14* v;
};

struct SQN_SL_CBR_PSSCH_TxConfig_r14_SQN_SL_CBR_CommonTxConfigList_r14_sl_CBR_PSSCH_TxConfigList_r14_Dynamic {
	size_t d;
	struct SQN_SL_CBR_PSSCH_TxConfig_r14* v;
};

struct SQN_SL_CBR_CommonTxConfigList_r14 {
	struct SQN_SL_CBR_Levels_Config_r14_cbr_RangeCommonConfigList_r14_Dynamic cbr_RangeCommonConfigList_r14;
	struct SQN_SL_CBR_PSSCH_TxConfig_r14_SQN_SL_CBR_CommonTxConfigList_r14_sl_CBR_PSSCH_TxConfigList_r14_Dynamic sl_CBR_PSSCH_TxConfigList_r14;
};

struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional {
	bool d;
	SQN_SL_CommRxPoolListV2X_r14 v;
};

struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional {
	bool d;
	SQN_SL_CommTxPoolListV2X_r14 v;
};

struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional {
	bool d;
	SQN_SL_CommTxPoolListV2X_r14 v;
};

struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional {
	bool d;
	struct SQN_SL_CommResourcePoolV2X_r14 v;
};

struct SQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional {
	bool d;
	SQN_SL_SyncConfigListV2X_r14 v;
};

struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional {
	bool d;
	SQN_SL_InterFreqInfoListV2X_r14 v;
};

struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional {
	bool d;
	struct SQN_SL_CommTxPoolSensingConfig_r14 v;
};

struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional {
	bool d;
	struct SQN_SL_ZoneConfig_r14 v;
};

struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional {
	bool d;
	SQN_SL_TypeTxSync_r14_e v;
};

struct SQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional {
	bool d;
	SQN_SL_Priority_r13 v;
};

struct SQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional {
	bool d;
	SQN_SL_AnchorCarrierFreqList_V2X_r14 v;
};

struct uint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional {
	bool d;
	uint16_t v;
};

struct SQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional {
	bool d;
	struct SQN_SL_CBR_CommonTxConfigList_r14 v;
};

struct SQN_SL_V2X_ConfigCommon_r14 {
	struct SQN_SL_CommRxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommRxPool_r14_Optional v2x_CommRxPool_r14;
	struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolNormalCommon_r14_Optional v2x_CommTxPoolNormalCommon_r14;
	struct SQN_SL_CommTxPoolListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_p2x_CommTxPoolNormalCommon_r14_Optional p2x_CommTxPoolNormalCommon_r14;
	struct SQN_SL_CommResourcePoolV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_CommTxPoolExceptional_r14_Optional v2x_CommTxPoolExceptional_r14;
	struct SQN_SL_SyncConfigListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_SyncConfig_r14_Optional v2x_SyncConfig_r14;
	struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_InterFreqInfoList_r14_Optional v2x_InterFreqInfoList_r14;
	struct SQN_SL_CommTxPoolSensingConfig_r14_SQN_SL_V2X_ConfigCommon_r14_v2x_ResourceSelectionConfig_r14_Optional v2x_ResourceSelectionConfig_r14;
	struct SQN_SL_ZoneConfig_r14_SQN_SL_V2X_ConfigCommon_r14_zoneConfig_r14_Optional zoneConfig_r14;
	struct SQN_SL_TypeTxSync_r14_e_SQN_SL_V2X_ConfigCommon_r14_typeTxSync_r14_Optional typeTxSync_r14;
	struct SQN_SL_Priority_r13_SQN_SL_V2X_ConfigCommon_r14_thresSL_TxPrioritization_r14_Optional thresSL_TxPrioritization_r14;
	struct SQN_SL_AnchorCarrierFreqList_V2X_r14_SQN_SL_V2X_ConfigCommon_r14_anchorCarrierFreqList_r14_Optional anchorCarrierFreqList_r14;
	struct uint16_t_SQN_SL_V2X_ConfigCommon_r14_offsetDFN_r14_Optional offsetDFN_r14;
	struct SQN_SL_CBR_CommonTxConfigList_r14_SQN_SL_V2X_ConfigCommon_r14_cbr_CommonTxConfigList_r14_Optional cbr_CommonTxConfigList_r14;
};

struct SQN_ARFCN_ValueNR_r15_SQN_SL_NR_AnchorCarrierFreqList_r16_Dynamic {
	size_t d;
	SQN_ARFCN_ValueNR_r15* v;
};

typedef struct SQN_ARFCN_ValueNR_r15_SQN_SL_NR_AnchorCarrierFreqList_r16_Dynamic SQN_SL_NR_AnchorCarrierFreqList_r16;

struct SQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional {
	bool d;
	struct SQN_SL_V2X_ConfigCommon_r14 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional {
	bool d;
	SQN_SL_NR_AnchorCarrierFreqList_r16 v;
};

struct SQN_SystemInformationBlockType21_r14 {
	struct SQN_SL_V2X_ConfigCommon_r14_SQN_SystemInformationBlockType21_r14_sl_V2X_ConfigCommon_r14_Optional sl_V2X_ConfigCommon_r14;
	struct OCTET_STRING_SQN_SystemInformationBlockType21_r14_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SL_NR_AnchorCarrierFreqList_r16_SQN_SystemInformationBlockType21_r14_anchorCarrierFreqListNR_r16_Optional anchorCarrierFreqListNR_r16;
};

enum SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e {
	SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz15 = 0,
	SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz30 = 1,
	SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz120 = 2,
	SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e_kHz240 = 3,
};

typedef enum SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e;

struct SQN_CarrierFreqNR_r15_threshX_Q_r15 {
	SQN_ReselectionThresholdQ_r9 threshX_HighQ_r15;
	SQN_ReselectionThresholdQ_r9 threshX_LowQ_r15;
};

typedef int8_t SQN_P_MaxNR_r15;

typedef uint8_t SQN_AdditionalSpectrumEmissionNR_r15;

struct SQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional {
	bool d;
	SQN_P_MaxNR_r15 v;
};

struct SQN_NS_PmaxValueNR_r15 {
	struct SQN_P_MaxNR_r15_SQN_NS_PmaxValueNR_r15_additionalPmaxNR_r15_Optional additionalPmaxNR_r15;
	SQN_AdditionalSpectrumEmissionNR_r15 additionalSpectrumEmissionNR_r15;
};

struct SQN_NS_PmaxValueNR_r15_SQN_NS_PmaxListNR_r15_Dynamic {
	size_t d;
	struct SQN_NS_PmaxValueNR_r15* v;
};

typedef struct SQN_NS_PmaxValueNR_r15_SQN_NS_PmaxListNR_r15_Dynamic SQN_NS_PmaxListNR_r15;

struct SQN_NS_PmaxListNR_r15_SQN_MultiBandNsPmaxListNR_1_v1550_Dynamic {
	size_t d;
	SQN_NS_PmaxListNR_r15* v;
};

typedef struct SQN_NS_PmaxListNR_r15_SQN_MultiBandNsPmaxListNR_1_v1550_Dynamic SQN_MultiBandNsPmaxListNR_1_v1550;

struct SQN_NS_PmaxListNR_r15_SQN_MultiBandNsPmaxListNR_v1550_Dynamic {
	size_t d;
	SQN_NS_PmaxListNR_r15* v;
};

typedef struct SQN_NS_PmaxListNR_r15_SQN_MultiBandNsPmaxListNR_v1550_Dynamic SQN_MultiBandNsPmaxListNR_v1550;

struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional {
	bool d;
	SQN_MultiFrequencyBandListNR_r15 v;
};

struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional {
	bool d;
	SQN_MultiFrequencyBandListNR_r15 v;
};

struct SQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional {
	bool d;
	struct SQN_MTC_SSB_NR_r15 v;
};

struct SQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional {
	bool d;
	struct SQN_SS_RSSI_Measurement_r15 v;
};

struct SQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional {
	bool d;
	SQN_CellReselectionPriority v;
};

struct SQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional {
	bool d;
	SQN_CellReselectionSubPriority_r13_e v;
};

struct SQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional {
	bool d;
	struct SQN_CarrierFreqNR_r15_threshX_Q_r15 v;
};

struct int8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional {
	bool d;
	int8_t v;
};

struct SQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional {
	bool d;
	SQN_NS_PmaxListNR_r15 v;
};

struct int8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional {
	bool d;
	int8_t v;
};

struct SQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional {
	bool d;
	SQN_MaxRS_IndexCellQualNR_r15 v;
};

struct SQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional {
	bool d;
	struct SQN_ThresholdListNR_r15 v;
};

struct SQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional {
	bool d;
	SQN_MultiBandNsPmaxListNR_1_v1550 v;
};

struct SQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional {
	bool d;
	SQN_MultiBandNsPmaxListNR_v1550 v;
};

struct SQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional {
	bool d;
	struct SQN_SSB_ToMeasure_r15 v;
};

struct SQN_CarrierFreqNR_r15 {
	SQN_ARFCN_ValueNR_r15 carrierFreq_r15;
	struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoList_r15_Optional multiBandInfoList_r15;
	struct SQN_MultiFrequencyBandListNR_r15_SQN_CarrierFreqNR_r15_multiBandInfoListSUL_r15_Optional multiBandInfoListSUL_r15;
	struct SQN_MTC_SSB_NR_r15_SQN_CarrierFreqNR_r15_measTimingConfig_r15_Optional measTimingConfig_r15;
	SQN_CarrierFreqNR_r15_subcarrierSpacingSSB_r15_e subcarrierSpacingSSB_r15;
	struct SQN_SS_RSSI_Measurement_r15_SQN_CarrierFreqNR_r15_ss_RSSI_Measurement_r15_Optional ss_RSSI_Measurement_r15;
	struct SQN_CellReselectionPriority_SQN_CarrierFreqNR_r15_cellReselectionPriority_r15_Optional cellReselectionPriority_r15;
	struct SQN_CellReselectionSubPriority_r13_e_SQN_CarrierFreqNR_r15_cellReselectionSubPriority_r15_Optional cellReselectionSubPriority_r15;
	SQN_ReselectionThreshold threshX_High_r15;
	SQN_ReselectionThreshold threshX_Low_r15;
	struct SQN_CarrierFreqNR_r15_threshX_Q_r15_threshX_Q_r15_Optional threshX_Q_r15;
	int8_t q_RxLevMin_r15;
	struct int8_t_SQN_CarrierFreqNR_r15_q_RxLevMinSUL_r15_Optional q_RxLevMinSUL_r15;
	SQN_P_MaxNR_r15 p_MaxNR_r15;
	struct SQN_NS_PmaxListNR_r15_SQN_CarrierFreqNR_r15_ns_PmaxListNR_r15_Optional ns_PmaxListNR_r15;
	struct int8_t_SQN_CarrierFreqNR_r15_q_QualMin_r15_Optional q_QualMin_r15;
	bool deriveSSB_IndexFromCell_r15;
	struct SQN_MaxRS_IndexCellQualNR_r15_SQN_CarrierFreqNR_r15_maxRS_IndexCellQual_r15_Optional maxRS_IndexCellQual_r15;
	struct SQN_ThresholdListNR_r15_SQN_CarrierFreqNR_r15_threshRS_Index_r15_Optional threshRS_Index_r15;
	struct SQN_MultiBandNsPmaxListNR_1_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_v1550_Optional multiBandNsPmaxListNR_v1550;
	struct SQN_MultiBandNsPmaxListNR_v1550_SQN_CarrierFreqNR_r15_multiBandNsPmaxListNR_SUL_v1550_Optional multiBandNsPmaxListNR_SUL_v1550;
	struct SQN_SSB_ToMeasure_r15_SQN_CarrierFreqNR_r15_ssb_ToMeasure_r15_Optional ssb_ToMeasure_r15;
};

struct SQN_CarrierFreqNR_r15_SQN_CarrierFreqListNR_r15_Dynamic {
	size_t d;
	struct SQN_CarrierFreqNR_r15* v;
};

typedef struct SQN_CarrierFreqNR_r15_SQN_CarrierFreqListNR_r15_Dynamic SQN_CarrierFreqListNR_r15;

enum SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e {
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf10 = 0,
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf20 = 1,
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf40 = 2,
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf80 = 3,
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_sf160 = 4,
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare3 = 5,
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare2 = 6,
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e_spare1 = 7,
};

typedef enum SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e;

struct SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_Dynamic {
	size_t d;
	SQN_PhysCellIdNR_r15* v;
};

struct SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional {
	bool d;
	struct SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_Dynamic v;
};

struct SQN_MTC_SSB2_LP_NR_r16 {
	struct SQN_PhysCellIdNR_r15_SQN_MTC_SSB2_LP_NR_r16_pci_List_r16_DynamicOptional pci_List_r16;
	SQN_MTC_SSB2_LP_NR_r16_periodicity_r16_e periodicity_r16;
};

enum SQN_SSB_PositionQCL_RelationNR_r16_e {
	SQN_SSB_PositionQCL_RelationNR_r16_e_n1 = 0,
	SQN_SSB_PositionQCL_RelationNR_r16_e_n2 = 1,
	SQN_SSB_PositionQCL_RelationNR_r16_e_n4 = 2,
	SQN_SSB_PositionQCL_RelationNR_r16_e_n8 = 3,
};

typedef enum SQN_SSB_PositionQCL_RelationNR_r16_e SQN_SSB_PositionQCL_RelationNR_r16_e;

struct SQN_PhysCellIdNR_r15_SQN_WhiteCellListNR_r16_Dynamic {
	size_t d;
	SQN_PhysCellIdNR_r15* v;
};

typedef struct SQN_PhysCellIdNR_r15_SQN_WhiteCellListNR_r16_Dynamic SQN_WhiteCellListNR_r16;

enum SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e {
	SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_true = 0,
};

typedef enum SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e;

struct SQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional {
	bool d;
	struct SQN_MTC_SSB2_LP_NR_r16 v;
};

struct SQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional {
	bool d;
	SQN_SSB_PositionQCL_RelationNR_r16_e v;
};

struct SQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional {
	bool d;
	SQN_WhiteCellListNR_r16 v;
};

struct SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional {
	bool d;
	SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e v;
};

struct SQN_CarrierFreqNR_v1610 {
	struct SQN_MTC_SSB2_LP_NR_r16_SQN_CarrierFreqNR_v1610_smtc2_LP_r16_Optional smtc2_LP_r16;
	struct SQN_SSB_PositionQCL_RelationNR_r16_e_SQN_CarrierFreqNR_v1610_ssb_PositionQCL_CommonNR_r16_Optional ssb_PositionQCL_CommonNR_r16;
	struct SQN_WhiteCellListNR_r16_SQN_CarrierFreqNR_v1610_whiteCellListNR_r16_Optional whiteCellListNR_r16;
	struct SQN_CarrierFreqNR_v1610_highSpeedCarrierNR_r16_e_highSpeedCarrierNR_r16_Optional highSpeedCarrierNR_r16;
};

struct SQN_CarrierFreqNR_v1610_SQN_CarrierFreqListNR_v1610_Dynamic {
	size_t d;
	struct SQN_CarrierFreqNR_v1610* v;
};

typedef struct SQN_CarrierFreqNR_v1610_SQN_CarrierFreqListNR_v1610_Dynamic SQN_CarrierFreqListNR_v1610;

struct SQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional {
	bool d;
	SQN_CarrierFreqListNR_r15 v;
};

struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional {
	bool d;
	struct SQN_SpeedStateScaleFactors v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional {
	bool d;
	SQN_CarrierFreqListNR_v1610 v;
};

struct SQN_SystemInformationBlockType24_r15 {
	struct SQN_CarrierFreqListNR_r15_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_r15_Optional carrierFreqListNR_r15;
	SQN_T_Reselection t_ReselectionNR_r15;
	struct SQN_SpeedStateScaleFactors_SQN_SystemInformationBlockType24_r15_t_ReselectionNR_SF_r15_Optional t_ReselectionNR_SF_r15;
	struct OCTET_STRING_SQN_SystemInformationBlockType24_r15_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_CarrierFreqListNR_v1610_SQN_SystemInformationBlockType24_r15_carrierFreqListNR_v1610_Optional carrierFreqListNR_v1610;
};

typedef uint8_t SQN_UAC_BarringInfoSetIndex_r15;

struct SQN_UAC_BarringPerCat_r15 {
	uint8_t accessCategory_r15;
	SQN_UAC_BarringInfoSetIndex_r15 uac_barringInfoSetIndex_r15;
};

struct SQN_UAC_BarringPerCat_r15_SQN_UAC_BarringPerCatList_r15_Dynamic {
	size_t d;
	struct SQN_UAC_BarringPerCat_r15* v;
};

typedef struct SQN_UAC_BarringPerCat_r15_SQN_UAC_BarringPerCatList_r15_Dynamic SQN_UAC_BarringPerCatList_r15;

enum SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Sel {
	SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_UNBOUND_VALUE = 0,
	SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_ImplicitAC_BarringList_r15 = 1,
	SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_ExplicitAC_BarringList_r15 = 2,
};

union SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value {
	SQN_UAC_BarringInfoSetIndex_r15 uac_ImplicitAC_BarringList_r15[63];
	SQN_UAC_BarringPerCatList_r15 uac_ExplicitAC_BarringList_r15;
};

struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15 {
	enum SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Sel d;
	union SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_Value v;
};

struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional {
	bool d;
	struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15 v;
};

struct SQN_UAC_BarringPerPLMN_r15 {
	uint8_t plmn_IdentityIndex_r15;
	struct SQN_UAC_BarringPerPLMN_r15_uac_AC_BarringListType_r15_uac_AC_BarringListType_r15_Optional uac_AC_BarringListType_r15;
};

struct SQN_UAC_BarringPerPLMN_r15_SQN_UAC_BarringPerPLMN_List_r15_Dynamic {
	size_t d;
	struct SQN_UAC_BarringPerPLMN_r15* v;
};

typedef struct SQN_UAC_BarringPerPLMN_r15_SQN_UAC_BarringPerPLMN_List_r15_Dynamic SQN_UAC_BarringPerPLMN_List_r15;

enum SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e {
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p00 = 0,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p05 = 1,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p10 = 2,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p15 = 3,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p20 = 4,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p25 = 5,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p30 = 6,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p40 = 7,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p50 = 8,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p60 = 9,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p70 = 10,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p75 = 11,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p80 = 12,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p85 = 13,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p90 = 14,
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e_p95 = 15,
};

typedef enum SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e;

enum SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e {
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s4 = 0,
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s8 = 1,
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s16 = 2,
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s32 = 3,
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s64 = 4,
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s128 = 5,
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s256 = 6,
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e_s512 = 7,
};

typedef enum SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e;

struct SQN_UAC_BarringInfoSet_r15 {
	SQN_UAC_BarringInfoSet_r15_uac_BarringFactor_r15_e uac_BarringFactor_r15;
	SQN_UAC_BarringInfoSet_r15_uac_BarringTime_r15_e uac_BarringTime_r15;
	B7 uac_BarringForAccessIdentity_r15;
};

struct SQN_UAC_BarringInfoSet_r15_SQN_UAC_BarringInfoSetList_r15_Dynamic {
	size_t d;
	struct SQN_UAC_BarringInfoSet_r15* v;
};

typedef struct SQN_UAC_BarringInfoSet_r15_SQN_UAC_BarringInfoSetList_r15_Dynamic SQN_UAC_BarringInfoSetList_r15;

enum SQN_UAC_AC1_SelectAssistInfo_r15_e {
	SQN_UAC_AC1_SelectAssistInfo_r15_e_a = 0,
	SQN_UAC_AC1_SelectAssistInfo_r15_e_b = 1,
	SQN_UAC_AC1_SelectAssistInfo_r15_e_c = 2,
};

typedef enum SQN_UAC_AC1_SelectAssistInfo_r15_e SQN_UAC_AC1_SelectAssistInfo_r15_e;

enum SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Sel {
	SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_UNBOUND_VALUE = 0,
	SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_plmnCommon_r15 = 1,
	SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_individualPLMNList_r15 = 2,
};

struct SQN_UAC_AC1_SelectAssistInfo_r15_e_individualPLMNList_r15_Dynamic {
	size_t d;
	SQN_UAC_AC1_SelectAssistInfo_r15_e* v;
};

union SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value {
	SQN_UAC_AC1_SelectAssistInfo_r15_e plmnCommon_r15;
	struct SQN_UAC_AC1_SelectAssistInfo_r15_e_individualPLMNList_r15_Dynamic individualPLMNList_r15;
};

struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15 {
	enum SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Sel d;
	union SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_Value v;
};

enum SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e {
	SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh0 = 0,
	SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh1 = 1,
	SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh2 = 2,
	SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_thresh3 = 3,
};

typedef enum SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e;

struct SQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional {
	bool d;
	SQN_UAC_BarringPerCatList_r15 v;
};

struct SQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional {
	bool d;
	SQN_UAC_BarringPerPLMN_List_r15 v;
};

struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional {
	bool d;
	struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e v;
};

struct SQN_SystemInformationBlockType25_r15 {
	struct SQN_UAC_BarringPerCatList_r15_SQN_SystemInformationBlockType25_r15_uac_BarringForCommon_r15_Optional uac_BarringForCommon_r15;
	struct SQN_UAC_BarringPerPLMN_List_r15_SQN_SystemInformationBlockType25_r15_uac_BarringPerPLMN_List_r15_Optional uac_BarringPerPLMN_List_r15;
	SQN_UAC_BarringInfoSetList_r15 uac_BarringInfoSetList_r15;
	struct SQN_SystemInformationBlockType25_r15_uac_AC1_SelectAssistInfo_r15_uac_AC1_SelectAssistInfo_r15_Optional uac_AC1_SelectAssistInfo_r15;
	struct OCTET_STRING_SQN_SystemInformationBlockType25_r15_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SystemInformationBlockType25_r15_ab_PerRSRP_r16_e_ab_PerRSRP_r16_Optional ab_PerRSRP_r16;
};

struct SQN_Tx_ConfigIndex_r14_tx_ConfigIndexList_r15_Dynamic {
	size_t d;
	SQN_Tx_ConfigIndex_r14* v;
};

struct SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_r15_mcs_PSSCH_RangeList_r15_Dynamic {
	size_t d;
	struct SQN_MCS_PSSCH_Range_r15* v;
};

struct SQN_SL_PPPP_TxConfigIndex_r15 {
	SQN_SL_Priority_r13 priorityThreshold_r15;
	uint8_t defaultTxConfigIndex_r15;
	uint8_t cbr_ConfigIndex_r15;
	struct SQN_Tx_ConfigIndex_r14_tx_ConfigIndexList_r15_Dynamic tx_ConfigIndexList_r15;
	struct SQN_MCS_PSSCH_Range_r15_SQN_SL_PPPP_TxConfigIndex_r15_mcs_PSSCH_RangeList_r15_Dynamic mcs_PSSCH_RangeList_r15;
};

struct SQN_SL_PPPP_TxConfigIndex_r15_SQN_SL_CBR_PPPP_TxConfigList_r15_Dynamic {
	size_t d;
	struct SQN_SL_PPPP_TxConfigIndex_r15* v;
};

typedef struct SQN_SL_PPPP_TxConfigIndex_r15_SQN_SL_CBR_PPPP_TxConfigList_r15_Dynamic SQN_SL_CBR_PPPP_TxConfigList_r15;

typedef uint8_t SQN_SL_Reliability_r15;

typedef B24 SQN_SL_DestinationIdentity_r12;

struct SQN_SL_DestinationIdentity_r12_SQN_SL_DestinationInfoList_r12_Dynamic {
	size_t d;
	SQN_SL_DestinationIdentity_r12* v;
};

typedef struct SQN_SL_DestinationIdentity_r12_SQN_SL_DestinationInfoList_r12_Dynamic SQN_SL_DestinationInfoList_r12;

struct SQN_ARFCN_ValueEUTRA_r9_allowedCarrierFreqSet1_Dynamic {
	size_t d;
	SQN_ARFCN_ValueEUTRA_r9* v;
};

struct SQN_ARFCN_ValueEUTRA_r9_allowedCarrierFreqSet2_Dynamic {
	size_t d;
	SQN_ARFCN_ValueEUTRA_r9* v;
};

struct SQN_SL_AllowedCarrierFreqList_r15 {
	struct SQN_ARFCN_ValueEUTRA_r9_allowedCarrierFreqSet1_Dynamic allowedCarrierFreqSet1;
	struct SQN_ARFCN_ValueEUTRA_r9_allowedCarrierFreqSet2_Dynamic allowedCarrierFreqSet2;
};

struct SQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional {
	bool d;
	SQN_SL_DestinationInfoList_r12 v;
};

struct SQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional {
	bool d;
	struct SQN_SL_AllowedCarrierFreqList_r15 v;
};

struct SQN_SL_PPPR_Dest_CarrierFreq {
	struct SQN_SL_DestinationInfoList_r12_SQN_SL_PPPR_Dest_CarrierFreq_destinationInfoList_r15_Optional destinationInfoList_r15;
	struct SQN_SL_AllowedCarrierFreqList_r15_SQN_SL_PPPR_Dest_CarrierFreq_allowedCarrierFreqList_r15_Optional allowedCarrierFreqList_r15;
};

struct SQN_SL_PPPR_Dest_CarrierFreq_SQN_SL_PPPR_Dest_CarrierFreqList_r15_Dynamic {
	size_t d;
	struct SQN_SL_PPPR_Dest_CarrierFreq* v;
};

typedef struct SQN_SL_PPPR_Dest_CarrierFreq_SQN_SL_PPPR_Dest_CarrierFreqList_r15_Dynamic SQN_SL_PPPR_Dest_CarrierFreqList_r15;

struct SQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional {
	bool d;
	SQN_SL_PPPR_Dest_CarrierFreqList_r15 v;
};

struct SQN_SL_V2X_PacketDuplicationConfig_r15 {
	SQN_SL_Reliability_r15 threshSL_Reliability_r15;
	struct SQN_SL_PPPR_Dest_CarrierFreqList_r15_SQN_SL_V2X_PacketDuplicationConfig_r15_allowedCarrierFreqConfig_r15_Optional allowedCarrierFreqConfig_r15;
};

struct SQN_ARFCN_ValueEUTRA_r9_SQN_SL_V2X_SyncFreqList_r15_Dynamic {
	size_t d;
	SQN_ARFCN_ValueEUTRA_r9* v;
};

typedef struct SQN_ARFCN_ValueEUTRA_r9_SQN_SL_V2X_SyncFreqList_r15_Dynamic SQN_SL_V2X_SyncFreqList_r15;

enum SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e {
	SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e;

struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional {
	bool d;
	SQN_SL_InterFreqInfoListV2X_r14 v;
};

struct SQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional {
	bool d;
	SQN_SL_CBR_PPPP_TxConfigList_r15 v;
};

struct SQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional {
	bool d;
	struct SQN_SL_V2X_PacketDuplicationConfig_r15 v;
};

struct SQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional {
	bool d;
	SQN_SL_V2X_SyncFreqList_r15 v;
};

struct SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e v;
};

struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional {
	bool d;
	SQN_SL_V2X_FreqSelectionConfigList_r15 v;
};

struct uint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional {
	bool d;
	uint8_t v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType26_r15 {
	struct SQN_SL_InterFreqInfoListV2X_r14_SQN_SystemInformationBlockType26_r15_v2x_InterFreqInfoList_r15_Optional v2x_InterFreqInfoList_r15;
	struct SQN_SL_CBR_PPPP_TxConfigList_r15_SQN_SystemInformationBlockType26_r15_cbr_pssch_TxConfigList_r15_Optional cbr_pssch_TxConfigList_r15;
	struct SQN_SL_V2X_PacketDuplicationConfig_r15_SQN_SystemInformationBlockType26_r15_v2x_PacketDuplicationConfig_r15_Optional v2x_PacketDuplicationConfig_r15;
	struct SQN_SL_V2X_SyncFreqList_r15_SQN_SystemInformationBlockType26_r15_syncFreqList_r15_Optional syncFreqList_r15;
	struct SQN_SystemInformationBlockType26_r15_slss_TxMultiFreq_r15_e_slss_TxMultiFreq_r15_Optional slss_TxMultiFreq_r15;
	struct SQN_SL_V2X_FreqSelectionConfigList_r15_SQN_SystemInformationBlockType26_r15_v2x_FreqSelectionConfigList_r15_Optional v2x_FreqSelectionConfigList_r15;
	struct uint8_t_SQN_SystemInformationBlockType26_r15_threshS_RSSI_CBR_r15_Optional threshS_RSSI_CBR_r15;
	struct OCTET_STRING_SQN_SystemInformationBlockType26_r15_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

struct B10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional {
	bool d;
	B10 v;
};

struct SQN_PLMN_Info_r16 {
	struct B10_SQN_PLMN_Info_r16_nr_BandList_r16_Optional nr_BandList_r16;
};

struct SQN_PLMN_Info_r16_SQN_PLMN_InfoList_r16_Dynamic {
	size_t d;
	struct SQN_PLMN_Info_r16* v;
};

typedef struct SQN_PLMN_Info_r16_SQN_PLMN_InfoList_r16_Dynamic SQN_PLMN_InfoList_r16;

struct SQN_FreqBandIndicatorNR_r15_SQN_BandListENDC_r16_Dynamic {
	size_t d;
	SQN_FreqBandIndicatorNR_r15* v;
};

typedef struct SQN_FreqBandIndicatorNR_r15_SQN_BandListENDC_r16_Dynamic SQN_BandListENDC_r16;

struct OCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType26a_r16 {
	SQN_PLMN_InfoList_r16 plmn_InfoList_r16;
	SQN_BandListENDC_r16 bandListENDC_r16;
	struct OCTET_STRING_SQN_SystemInformationBlockType26a_r16_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e {
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_10 = 0,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_9 = 1,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_8dot5 = 2,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_8 = 3,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_7 = 4,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_6 = 5,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_5 = 6,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_4dot5 = 7,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_4 = 8,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_3 = 9,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_2 = 10,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_1 = 11,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v_0dot5 = 12,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v0 = 13,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v1 = 14,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v2 = 15,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v3 = 16,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v3dot5 = 17,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v4 = 18,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v5 = 19,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v6 = 20,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v7 = 21,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v7dot5 = 22,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v8 = 23,
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e_v9 = 24,
};

typedef enum SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e;

struct SQN_CarrierFreqNBIOT_r16 {
	SQN_ARFCN_ValueEUTRA_r9 carrierFreq_r16;
	SQN_CarrierFreqNBIOT_r16_carrierFreqOffset_r16_e carrierFreqOffset_r16;
};

struct SQN_CarrierFreqNBIOT_r16_SQN_CarrierFreqListNBIOT_r16_Dynamic {
	size_t d;
	struct SQN_CarrierFreqNBIOT_r16* v;
};

typedef struct SQN_CarrierFreqNBIOT_r16_SQN_CarrierFreqListNBIOT_r16_Dynamic SQN_CarrierFreqListNBIOT_r16;

struct SQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional {
	bool d;
	SQN_CarrierFreqListNBIOT_r16 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType27_r16 {
	struct SQN_CarrierFreqListNBIOT_r16_SQN_SystemInformationBlockType27_r16_carrierFreqListNBIOT_r16_Optional carrierFreqListNBIOT_r16;
	struct OCTET_STRING_SQN_SystemInformationBlockType27_r16_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_SystemInformationBlockType28_r16_segmentType_r16_e {
	SQN_SystemInformationBlockType28_r16_segmentType_r16_e_notLastSegment = 0,
	SQN_SystemInformationBlockType28_r16_segmentType_r16_e_lastSegment = 1,
};

typedef enum SQN_SystemInformationBlockType28_r16_segmentType_r16_e SQN_SystemInformationBlockType28_r16_segmentType_r16_e;

struct OCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType28_r16 {
	uint8_t segmentNumber_r16;
	SQN_SystemInformationBlockType28_r16_segmentType_r16_e segmentType_r16;
	OCTET_STRING segmentContainer_r16;
	struct OCTET_STRING_SQN_SystemInformationBlockType28_r16_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_PeriodicityStartPos_r16_Sel {
	SQN_PeriodicityStartPos_r16_UNBOUND_VALUE = 0,
	SQN_PeriodicityStartPos_r16_periodicity10ms = 1,
	SQN_PeriodicityStartPos_r16_periodicity20ms = 2,
	SQN_PeriodicityStartPos_r16_periodicity40ms = 3,
	SQN_PeriodicityStartPos_r16_periodicity80ms = 4,
	SQN_PeriodicityStartPos_r16_periodicity160ms = 5,
	SQN_PeriodicityStartPos_r16_spare3 = 6,
	SQN_PeriodicityStartPos_r16_spare2 = 7,
	SQN_PeriodicityStartPos_r16_spare1 = 8,
};

union SQN_PeriodicityStartPos_r16_Value {
	Null periodicity10ms;
	uint8_t periodicity20ms;
	uint8_t periodicity40ms;
	uint8_t periodicity80ms;
	uint8_t periodicity160ms;
	Null spare3;
	Null spare2;
	Null spare1;
};

struct SQN_PeriodicityStartPos_r16 {
	enum SQN_PeriodicityStartPos_r16_Sel d;
	union SQN_PeriodicityStartPos_r16_Value v;
};

enum SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Sel {
	SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_UNBOUND_VALUE = 0,
	SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap1dot4 = 1,
	SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap3 = 2,
	SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap5 = 3,
	SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap10 = 4,
	SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap15 = 5,
	SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_rbg_Bitmap20 = 6,
};

union SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value {
	B6 rbg_Bitmap1dot4;
	B8 rbg_Bitmap3;
	B13 rbg_Bitmap5;
	B17 rbg_Bitmap10;
	B19 rbg_Bitmap15;
	B25 rbg_Bitmap20;
};

struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16 {
	enum SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Sel d;
	union SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_Value v;
};

enum SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Sel {
	SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_UNBOUND_VALUE = 0,
	SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_slotPattern10ms = 1,
	SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_slotPattern40ms = 2,
};

union SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value {
	B20 slotPattern10ms;
	B80 slotPattern40ms;
};

struct SQN_ResourceReservationConfigDL_r16_slotBitmap_r16 {
	enum SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Sel d;
	union SQN_ResourceReservationConfigDL_r16_slotBitmap_r16_Value v;
};

struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional {
	bool d;
	struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16 v;
};

struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional {
	bool d;
	B7 v;
};

struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional {
	bool d;
	B7 v;
};

struct SQN_ResourceReservationConfigDL_r16 {
	struct SQN_PeriodicityStartPos_r16 periodicityStartPos_r16;
	struct SQN_ResourceReservationConfigDL_r16_resourceReservationFreq_r16_resourceReservationFreq_r16_Optional resourceReservationFreq_r16;
	struct SQN_ResourceReservationConfigDL_r16_slotBitmap_r16 slotBitmap_r16;
	struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap1_r16_Optional symbolBitmap1_r16;
	struct B7_SQN_ResourceReservationConfigDL_r16_symbolBitmap2_r16_Optional symbolBitmap2_r16;
};

enum SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Sel {
	SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_UNBOUND_VALUE = 0,
	SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotPattern10ms = 1,
	SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotPattern40ms = 2,
};

union SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value {
	B20 slotPattern10ms;
	B80 slotPattern40ms;
};

struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16 {
	enum SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Sel d;
	union SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_Value v;
};

struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional {
	bool d;
	struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16 v;
};

struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional {
	bool d;
	B7 v;
};

struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional {
	bool d;
	B7 v;
};

struct SQN_ResourceReservationConfigUL_r16 {
	struct SQN_PeriodicityStartPos_r16 periodicityStartPos_r16;
	struct SQN_ResourceReservationConfigUL_r16_slotBitmap_r16_slotBitmap_r16_Optional slotBitmap_r16;
	struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap1_r16_Optional symbolBitmap1_r16;
	struct B7_SQN_ResourceReservationConfigUL_r16_symbolBitmap2_r16_Optional symbolBitmap2_r16;
};

struct SQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional {
	bool d;
	struct SQN_ResourceReservationConfigDL_r16 v;
};

struct SQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional {
	bool d;
	struct SQN_ResourceReservationConfigUL_r16 v;
};

struct OCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType29_r16 {
	struct SQN_ResourceReservationConfigDL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonDL_r16_Optional resourceReservationConfigCommonDL_r16;
	struct SQN_ResourceReservationConfigUL_r16_SQN_SystemInformationBlockType29_r16_resourceReservationConfigCommonUL_r16_Optional resourceReservationConfigCommonUL_r16;
	struct OCTET_STRING_SQN_SystemInformationBlockType29_r16_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Sel {
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_UNBOUND_VALUE = 0,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib2 = 1,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib3 = 2,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib4 = 3,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib5 = 4,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib6 = 5,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib7 = 6,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib8 = 7,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib9 = 8,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib10 = 9,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib11 = 10,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib12_v920 = 11,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib13_v920 = 12,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib14_v1130 = 13,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib15_v1130 = 14,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib16_v1130 = 15,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib17_v1250 = 16,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib18_v1250 = 17,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib19_v1250 = 18,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib20_v1310 = 19,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib21_v1430 = 20,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib24_v1530 = 21,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib25_v1530 = 22,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib26_v1530 = 23,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib26a_v1610 = 24,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib27_v1610 = 25,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib28_v1610 = 26,
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_sib29_v1610 = 27,
};

union SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value {
	struct SQN_SystemInformationBlockType2 sib2;
	struct SQN_SystemInformationBlockType3 sib3;
	struct SQN_SystemInformationBlockType4 sib4;
	struct SQN_SystemInformationBlockType5 sib5;
	struct SQN_SystemInformationBlockType6 sib6;
	struct SQN_SystemInformationBlockType7 sib7;
	struct SQN_SystemInformationBlockType8 sib8;
	struct SQN_SystemInformationBlockType9 sib9;
	struct SQN_SystemInformationBlockType10 sib10;
	struct SQN_SystemInformationBlockType11 sib11;
	struct SQN_SystemInformationBlockType12_r9 sib12_v920;
	struct SQN_SystemInformationBlockType13_r9 sib13_v920;
	struct SQN_SystemInformationBlockType14_r11 sib14_v1130;
	struct SQN_SystemInformationBlockType15_r11 sib15_v1130;
	struct SQN_SystemInformationBlockType16_r11 sib16_v1130;
	struct SQN_SystemInformationBlockType17_r12 sib17_v1250;
	struct SQN_SystemInformationBlockType18_r12 sib18_v1250;
	struct SQN_SystemInformationBlockType19_r12 sib19_v1250;
	struct SQN_SystemInformationBlockType20_r13 sib20_v1310;
	struct SQN_SystemInformationBlockType21_r14 sib21_v1430;
	struct SQN_SystemInformationBlockType24_r15 sib24_v1530;
	struct SQN_SystemInformationBlockType25_r15 sib25_v1530;
	struct SQN_SystemInformationBlockType26_r15 sib26_v1530;
	struct SQN_SystemInformationBlockType26a_r16 sib26a_v1610;
	struct SQN_SystemInformationBlockType27_r16 sib27_v1610;
	struct SQN_SystemInformationBlockType28_r16 sib28_v1610;
	struct SQN_SystemInformationBlockType29_r16 sib29_v1610;
};

struct SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s {
	enum SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Sel d;
	union SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_Value v;
};

struct SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_Dynamic {
	size_t d;
	struct SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s* v;
};

typedef struct SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_s_SQN_SystemInformation_r8_IEs_sib_TypeAndInfo_Dynamic SQN_SystemInformation_r8_IEs_sib_TypeAndInfo;

struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension {
};

struct OCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension v;
};

struct SQN_SystemInformation_v8a0_IEs {
	struct OCTET_STRING_SQN_SystemInformation_v8a0_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SystemInformation_v8a0_IEs_nonCriticalExtension_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformation_v8a0_IEs v;
};

struct SQN_SystemInformation_r8_IEs {
	SQN_SystemInformation_r8_IEs_sib_TypeAndInfo sib_TypeAndInfo;
	struct SQN_SystemInformation_v8a0_IEs_SQN_SystemInformation_r8_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct OCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockPos_r15 {
	OCTET_STRING assistanceDataSIB_Element_r15;
	struct OCTET_STRING_SQN_SystemInformationBlockPos_r15_lateNonCriticalExtension_Optional lateNonCriticalExtension;
};

enum SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Sel {
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_UNBOUND_VALUE = 0,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_1_r15 = 1,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_2_r15 = 2,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_3_r15 = 3,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_4_r15 = 4,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_5_r15 = 5,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_6_r15 = 6,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib1_7_r15 = 7,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_1_r15 = 8,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_2_r15 = 9,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_3_r15 = 10,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_4_r15 = 11,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_5_r15 = 12,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_6_r15 = 13,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_7_r15 = 14,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_8_r15 = 15,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_9_r15 = 16,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_10_r15 = 17,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_11_r15 = 18,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_12_r15 = 19,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_13_r15 = 20,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_14_r15 = 21,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_15_r15 = 22,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_16_r15 = 23,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_17_r15 = 24,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_18_r15 = 25,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib2_19_r15 = 26,
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_posSib3_1_r15 = 27,
};

union SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value {
	struct SQN_SystemInformationBlockPos_r15 posSib1_1_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib1_2_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib1_3_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib1_4_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib1_5_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib1_6_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib1_7_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_1_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_2_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_3_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_4_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_5_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_6_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_7_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_8_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_9_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_10_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_11_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_12_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_13_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_14_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_15_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_16_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_17_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_18_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib2_19_r15;
	struct SQN_SystemInformationBlockPos_r15 posSib3_1_r15;
};

struct SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s {
	enum SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Sel d;
	union SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_Value v;
};

struct SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_Dynamic {
	size_t d;
	struct SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s* v;
};

typedef struct SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_s_SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15_Dynamic SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15;

struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension {
};

struct OCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional {
	bool d;
	struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension v;
};

struct SQN_PosSystemInformation_r15_IEs {
	SQN_PosSystemInformation_r15_IEs_posSIB_TypeAndInfo_r15 posSIB_TypeAndInfo_r15;
	struct OCTET_STRING_SQN_PosSystemInformation_r15_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_PosSystemInformation_r15_IEs_nonCriticalExtension_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture {
};

enum SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Sel {
	SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_UNBOUND_VALUE = 0,
	SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_posSystemInformation_r15 = 1,
	SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture = 2,
};

union SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value {
	struct SQN_PosSystemInformation_r15_IEs posSystemInformation_r15;
	struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_criticalExtensionsFuture criticalExtensionsFuture;
};

struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15 {
	enum SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Sel d;
	union SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15_Value v;
};

enum SQN_SystemInformation_criticalExtensions_Sel {
	SQN_SystemInformation_criticalExtensions_UNBOUND_VALUE = 0,
	SQN_SystemInformation_criticalExtensions_systemInformation_r8 = 1,
	SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15 = 2,
};

union SQN_SystemInformation_criticalExtensions_Value {
	struct SQN_SystemInformation_r8_IEs systemInformation_r8;
	struct SQN_SystemInformation_criticalExtensions_criticalExtensionsFuture_r15 criticalExtensionsFuture_r15;
};

struct SQN_SystemInformation_criticalExtensions {
	enum SQN_SystemInformation_criticalExtensions_Sel d;
	union SQN_SystemInformation_criticalExtensions_Value v;
};

struct SQN_SystemInformation {
	struct SQN_SystemInformation_criticalExtensions criticalExtensions;
};

typedef B16 SQN_TrackingAreaCode;

typedef B28 SQN_CellIdentity;

enum SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e {
	SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e_barred = 0,
	SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e_notBarred = 1,
};

typedef enum SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e;

enum SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e {
	SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e_allowed = 0,
	SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e_notAllowed = 1,
};

typedef enum SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e;

typedef B27 SQN_CSG_Identity;

struct SQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional {
	bool d;
	SQN_CSG_Identity v;
};

struct SQN_SystemInformationBlockType1_cellAccessRelatedInfo {
	SQN_PLMN_IdentityList plmn_IdentityList;
	SQN_TrackingAreaCode trackingAreaCode;
	SQN_CellIdentity cellIdentity;
	SQN_SystemInformationBlockType1_cellAccessRelatedInfo_cellBarred_e cellBarred;
	SQN_SystemInformationBlockType1_cellAccessRelatedInfo_intraFreqReselection_e intraFreqReselection;
	bool csg_Indication;
	struct SQN_CSG_Identity_SQN_SystemInformationBlockType1_cellAccessRelatedInfo_csg_Identity_Optional csg_Identity;
};

struct uint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional {
	bool d;
	uint8_t v;
};

struct SQN_SystemInformationBlockType1_cellSelectionInfo {
	SQN_Q_RxLevMin q_RxLevMin;
	struct uint8_t_SQN_SystemInformationBlockType1_cellSelectionInfo_q_RxLevMinOffset_Optional q_RxLevMinOffset;
};

typedef uint8_t SQN_FreqBandIndicator;

enum SQN_SI_Periodicity_r12_e {
	SQN_SI_Periodicity_r12_e_rf8 = 0,
	SQN_SI_Periodicity_r12_e_rf16 = 1,
	SQN_SI_Periodicity_r12_e_rf32 = 2,
	SQN_SI_Periodicity_r12_e_rf64 = 3,
	SQN_SI_Periodicity_r12_e_rf128 = 4,
	SQN_SI_Periodicity_r12_e_rf256 = 5,
	SQN_SI_Periodicity_r12_e_rf512 = 6,
};

typedef enum SQN_SI_Periodicity_r12_e SQN_SI_Periodicity_r12_e;

enum SQN_SIB_Type_e {
	SQN_SIB_Type_e_sibType3 = 0,
	SQN_SIB_Type_e_sibType4 = 1,
	SQN_SIB_Type_e_sibType5 = 2,
	SQN_SIB_Type_e_sibType6 = 3,
	SQN_SIB_Type_e_sibType7 = 4,
	SQN_SIB_Type_e_sibType8 = 5,
	SQN_SIB_Type_e_sibType9 = 6,
	SQN_SIB_Type_e_sibType10 = 7,
	SQN_SIB_Type_e_sibType11 = 8,
	SQN_SIB_Type_e_sibType12_v920 = 9,
	SQN_SIB_Type_e_sibType13_v920 = 10,
	SQN_SIB_Type_e_sibType14_v1130 = 11,
	SQN_SIB_Type_e_sibType15_v1130 = 12,
	SQN_SIB_Type_e_sibType16_v1130 = 13,
	SQN_SIB_Type_e_sibType17_v1250 = 14,
	SQN_SIB_Type_e_sibType18_v1250 = 15,
	SQN_SIB_Type_e_sibType19_v1250 = 16,
	SQN_SIB_Type_e_sibType20_v1310 = 17,
	SQN_SIB_Type_e_sibType21_v1430 = 18,
	SQN_SIB_Type_e_sibType24_v1530 = 19,
	SQN_SIB_Type_e_sibType25_v1530 = 20,
	SQN_SIB_Type_e_sibType26_v1530 = 21,
	SQN_SIB_Type_e_sibType26a_v1610 = 22,
	SQN_SIB_Type_e_sibType27_v1610 = 23,
	SQN_SIB_Type_e_sibType28_v1610 = 24,
	SQN_SIB_Type_e_sibType29_v1610 = 25,
};

typedef enum SQN_SIB_Type_e SQN_SIB_Type_e;

struct SQN_SIB_Type_e_SQN_SIB_MappingInfo_Dynamic {
	size_t d;
	SQN_SIB_Type_e* v;
};

typedef struct SQN_SIB_Type_e_SQN_SIB_MappingInfo_Dynamic SQN_SIB_MappingInfo;

struct SQN_SchedulingInfo {
	SQN_SI_Periodicity_r12_e si_Periodicity;
	SQN_SIB_MappingInfo sib_MappingInfo;
};

struct SQN_SchedulingInfo_SQN_SchedulingInfoList_Dynamic {
	size_t d;
	struct SQN_SchedulingInfo* v;
};

typedef struct SQN_SchedulingInfo_SQN_SchedulingInfoList_Dynamic SQN_SchedulingInfoList;

enum SQN_SystemInformationBlockType1_si_WindowLength_e {
	SQN_SystemInformationBlockType1_si_WindowLength_e_ms1 = 0,
	SQN_SystemInformationBlockType1_si_WindowLength_e_ms2 = 1,
	SQN_SystemInformationBlockType1_si_WindowLength_e_ms5 = 2,
	SQN_SystemInformationBlockType1_si_WindowLength_e_ms10 = 3,
	SQN_SystemInformationBlockType1_si_WindowLength_e_ms15 = 4,
	SQN_SystemInformationBlockType1_si_WindowLength_e_ms20 = 5,
	SQN_SystemInformationBlockType1_si_WindowLength_e_ms40 = 6,
};

typedef enum SQN_SystemInformationBlockType1_si_WindowLength_e SQN_SystemInformationBlockType1_si_WindowLength_e;

enum SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e {
	SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e;

struct uint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional {
	bool d;
	uint8_t v;
};

struct SQN_CellSelectionInfo_v920 {
	SQN_Q_QualMin_r9 q_QualMin_r9;
	struct uint8_t_SQN_CellSelectionInfo_v920_q_QualMinOffset_r9_Optional q_QualMinOffset_r9;
};

struct SQN_CellSelectionInfo_v1130 {
	SQN_Q_QualMin_r9 q_QualMinWB_r11;
};

enum SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e {
	SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e;

struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e v;
};

struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250 {
	struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250_category0Allowed_r12_e_category0Allowed_r12_Optional category0Allowed_r12;
};

struct SQN_CellSelectionInfo_v1250 {
	SQN_Q_QualMin_r9 q_QualMinRSRQ_OnAllSymbols_r12;
};

enum SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e {
	SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e;

enum SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e {
	SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e;

enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e {
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms20 = 0,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms40 = 1,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms60 = 2,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms80 = 3,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms120 = 4,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms160 = 5,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_ms200 = 6,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e_spare = 7,
};

typedef enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e;

enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e {
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_everyRF = 0,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every2ndRF = 1,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every4thRF = 2,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e_every8thRF = 3,
};

typedef enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e;

enum SQN_SchedulingInfo_BR_r13_si_TBS_r13_e {
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b152 = 0,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b208 = 1,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b256 = 2,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b328 = 3,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b408 = 4,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b504 = 5,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b600 = 6,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b712 = 7,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b808 = 8,
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e_b936 = 9,
};

typedef enum SQN_SchedulingInfo_BR_r13_si_TBS_r13_e SQN_SchedulingInfo_BR_r13_si_TBS_r13_e;

struct SQN_SchedulingInfo_BR_r13 {
	uint8_t si_Narrowband_r13;
	SQN_SchedulingInfo_BR_r13_si_TBS_r13_e si_TBS_r13;
};

struct SQN_SchedulingInfo_BR_r13_SQN_SchedulingInfoList_BR_r13_Dynamic {
	size_t d;
	struct SQN_SchedulingInfo_BR_r13* v;
};

typedef struct SQN_SchedulingInfo_BR_r13_SQN_SchedulingInfoList_BR_r13_Dynamic SQN_SchedulingInfoList_BR_r13;

enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Sel {
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_UNBOUND_VALUE = 0,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_subframePattern10_r13 = 1,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_subframePattern40_r13 = 2,
};

union SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value {
	B10 subframePattern10_r13;
	B40 subframePattern40_r13;
};

struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13 {
	enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Sel d;
	union SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Value v;
};

enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e {
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e_on = 0,
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e_off = 1,
};

typedef enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e;

enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e {
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e;

typedef uint8_t SQN_SystemInfoValueTagSI_r13;

struct SQN_SystemInfoValueTagSI_r13_SQN_SystemInfoValueTagList_r13_Dynamic {
	size_t d;
	SQN_SystemInfoValueTagSI_r13* v;
};

typedef struct SQN_SystemInfoValueTagSI_r13_SQN_SystemInfoValueTagList_r13_Dynamic SQN_SystemInfoValueTagList_r13;

struct SQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional {
	bool d;
	SQN_SchedulingInfoList_BR_r13 v;
};

struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13 v;
};

struct B10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional {
	bool d;
	B10 v;
};

struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e v;
};

struct SQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional {
	bool d;
	SQN_SystemInfoValueTagList_r13 v;
};

struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13 {
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_WindowLength_BR_r13_e si_WindowLength_BR_r13;
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_RepetitionPattern_r13_e si_RepetitionPattern_r13;
	struct SQN_SchedulingInfoList_BR_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_schedulingInfoList_BR_r13_Optional schedulingInfoList_BR_r13;
	struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_fdd_DownlinkOrTddSubframeBitmapBR_r13_Optional fdd_DownlinkOrTddSubframeBitmapBR_r13;
	struct B10_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_fdd_UplinkSubframeBitmapBR_r13_Optional fdd_UplinkSubframeBitmapBR_r13;
	uint8_t startSymbolBR_r13;
	SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_HoppingConfigCommon_r13_e si_HoppingConfigCommon_r13;
	struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_si_ValidityTime_r13_e_si_ValidityTime_r13_Optional si_ValidityTime_r13;
	struct SQN_SystemInfoValueTagList_r13_SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_systemInfoValueTagList_r13_Optional systemInfoValueTagList_r13;
};

enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_nb2 = 0,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_nb4 = 1,
};

typedef enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e;

enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int1 = 0,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int2 = 1,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int4 = 2,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e_int8 = 3,
};

typedef enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e;

enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int1 = 0,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int5 = 1,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int10 = 2,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e_int20 = 3,
};

typedef enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e;

enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Sel {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_UNBOUND_VALUE = 0,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13 = 1,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13 = 2,
};

union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_FDD_r13_e interval_FDD_r13;
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_TDD_r13_e interval_TDD_r13;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13 {
	enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Sel d;
	union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_Value v;
};

enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int2 = 0,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int4 = 1,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int8 = 2,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e_int16 = 3,
};

typedef enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e;

enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int5 = 0,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int10 = 1,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int20 = 2,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e_int40 = 3,
};

typedef enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e;

enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Sel {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_UNBOUND_VALUE = 0,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13 = 1,
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13 = 2,
};

union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value {
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_FDD_r13_e interval_FDD_r13;
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_TDD_r13_e interval_TDD_r13;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13 {
	enum SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Sel d;
	union SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_Value v;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_mpdcch_pdsch_HoppingNB_r13_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e v;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_DLHoppingConfigCommonModeA_r13_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13 v;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_DLHoppingConfigCommonModeB_r13_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13 v;
};

struct uint8_t_SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingOffset_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13 {
	struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingNB_r13_e_mpdcch_pdsch_HoppingNB_r13_Optional mpdcch_pdsch_HoppingNB_r13;
	struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeA_r13_interval_DLHoppingConfigCommonModeA_r13_Optional interval_DLHoppingConfigCommonModeA_r13;
	struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_interval_DLHoppingConfigCommonModeB_r13_interval_DLHoppingConfigCommonModeB_r13_Optional interval_DLHoppingConfigCommonModeB_r13;
	struct uint8_t_SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_mpdcch_pdsch_HoppingOffset_r13_Optional mpdcch_pdsch_HoppingOffset_r13;
};

enum SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e {
	SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e;

enum SQN_TDD_Config_v1430_specialSubframePatterns_v1430_e {
	SQN_TDD_Config_v1430_specialSubframePatterns_v1430_e_ssp10 = 0,
};

typedef enum SQN_TDD_Config_v1430_specialSubframePatterns_v1430_e SQN_TDD_Config_v1430_specialSubframePatterns_v1430_e;

struct SQN_TDD_Config_v1430 {
	SQN_TDD_Config_v1430_specialSubframePatterns_v1430_e specialSubframePatterns_v1430;
};

struct SQN_CellAccessRelatedInfo_r14 {
	SQN_PLMN_IdentityList plmn_IdentityList_r14;
	SQN_TrackingAreaCode trackingAreaCode_r14;
	SQN_CellIdentity cellIdentity_r14;
};

enum SQN_TDD_Config_v1450_specialSubframePatterns_v1450_e {
	SQN_TDD_Config_v1450_specialSubframePatterns_v1450_e_ssp10_CRS_LessDwPTS = 0,
};

typedef enum SQN_TDD_Config_v1450_specialSubframePatterns_v1450_e SQN_TDD_Config_v1450_specialSubframePatterns_v1450_e;

struct SQN_TDD_Config_v1450 {
	SQN_TDD_Config_v1450_specialSubframePatterns_v1450_e specialSubframePatterns_v1450;
};

enum SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e {
	SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e;

enum SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs_e {
	SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs_e_n6 = 0,
	SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs_e_n24 = 1,
};

typedef enum SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs_e SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs_e;

enum SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Sel {
	SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_UNBOUND_VALUE = 0,
	SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigEnabled = 1,
	SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs = 2,
};

union SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Value {
	Null crs_IntfMitigEnabled;
	SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigNumPRBs_e crs_IntfMitigNumPRBs;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15 {
	enum SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Sel d;
	union SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_Value v;
};

enum SQN_SystemInformationBlockType1_v1530_IEs_cellBarred_CRS_r15_e {
	SQN_SystemInformationBlockType1_v1530_IEs_cellBarred_CRS_r15_e_barred = 0,
	SQN_SystemInformationBlockType1_v1530_IEs_cellBarred_CRS_r15_e_notBarred = 1,
};

typedef enum SQN_SystemInformationBlockType1_v1530_IEs_cellBarred_CRS_r15_e SQN_SystemInformationBlockType1_v1530_IEs_cellBarred_CRS_r15_e;

enum SQN_PLMN_IdentityInfo_v1530_cellReservedForOperatorUse_CRS_r15_e {
	SQN_PLMN_IdentityInfo_v1530_cellReservedForOperatorUse_CRS_r15_e_reserved = 0,
	SQN_PLMN_IdentityInfo_v1530_cellReservedForOperatorUse_CRS_r15_e_notReserved = 1,
};

typedef enum SQN_PLMN_IdentityInfo_v1530_cellReservedForOperatorUse_CRS_r15_e SQN_PLMN_IdentityInfo_v1530_cellReservedForOperatorUse_CRS_r15_e;

struct SQN_PLMN_IdentityInfo_v1530 {
	SQN_PLMN_IdentityInfo_v1530_cellReservedForOperatorUse_CRS_r15_e cellReservedForOperatorUse_CRS_r15;
};

struct SQN_PLMN_IdentityInfo_v1530_SQN_PLMN_IdentityList_v1530_Dynamic {
	size_t d;
	struct SQN_PLMN_IdentityInfo_v1530* v;
};

typedef struct SQN_PLMN_IdentityInfo_v1530_SQN_PLMN_IdentityList_v1530_Dynamic SQN_PLMN_IdentityList_v1530;

enum SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e {
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e_rf8 = 0,
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e_rf16 = 1,
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e_rf32 = 2,
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e_rf64 = 3,
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e_rf128 = 4,
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e_rf256 = 5,
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e_rf512 = 6,
};

typedef enum SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e;

enum SQN_PosSIB_Type_r15_encrypted_r15_e {
	SQN_PosSIB_Type_r15_encrypted_r15_e_true = 0,
};

typedef enum SQN_PosSIB_Type_r15_encrypted_r15_e SQN_PosSIB_Type_r15_encrypted_r15_e;

enum SQN_GNSS_ID_r15_gnss_id_r15_e {
	SQN_GNSS_ID_r15_gnss_id_r15_e_gps = 0,
	SQN_GNSS_ID_r15_gnss_id_r15_e_sbas = 1,
	SQN_GNSS_ID_r15_gnss_id_r15_e_qzss = 2,
	SQN_GNSS_ID_r15_gnss_id_r15_e_galileo = 3,
	SQN_GNSS_ID_r15_gnss_id_r15_e_glonass = 4,
	SQN_GNSS_ID_r15_gnss_id_r15_e_bds = 5,
	SQN_GNSS_ID_r15_gnss_id_r15_e_navic_v1610 = 6,
};

typedef enum SQN_GNSS_ID_r15_gnss_id_r15_e SQN_GNSS_ID_r15_gnss_id_r15_e;

struct SQN_GNSS_ID_r15 {
	SQN_GNSS_ID_r15_gnss_id_r15_e gnss_id_r15;
};

enum SQN_SBAS_ID_r15_sbas_id_r15_e {
	SQN_SBAS_ID_r15_sbas_id_r15_e_waas = 0,
	SQN_SBAS_ID_r15_sbas_id_r15_e_egnos = 1,
	SQN_SBAS_ID_r15_sbas_id_r15_e_msas = 2,
	SQN_SBAS_ID_r15_sbas_id_r15_e_gagan = 3,
};

typedef enum SQN_SBAS_ID_r15_sbas_id_r15_e SQN_SBAS_ID_r15_sbas_id_r15_e;

struct SQN_SBAS_ID_r15 {
	SQN_SBAS_ID_r15_sbas_id_r15_e sbas_id_r15;
};

enum SQN_PosSIB_Type_r15_posSibType_r15_e {
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_1 = 0,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_2 = 1,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_3 = 2,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_4 = 3,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_5 = 4,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_6 = 5,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_7 = 6,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_1 = 7,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_2 = 8,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_3 = 9,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_4 = 10,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_5 = 11,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_6 = 12,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_7 = 13,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_8 = 14,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_9 = 15,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_10 = 16,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_11 = 17,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_12 = 18,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_13 = 19,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_14 = 20,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_15 = 21,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_16 = 22,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_17 = 23,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_18 = 24,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_19 = 25,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType3_1 = 26,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType1_8_v1610 = 27,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_20_v1610 = 28,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_21_v1610 = 29,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_22_v1610 = 30,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_23_v1610 = 31,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_24_v1610 = 32,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType2_25_v1610 = 33,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType4_1_v1610 = 34,
	SQN_PosSIB_Type_r15_posSibType_r15_e_posSibType5_1_v1610 = 35,
};

typedef enum SQN_PosSIB_Type_r15_posSibType_r15_e SQN_PosSIB_Type_r15_posSibType_r15_e;

struct SQN_PosSIB_Type_r15_encrypted_r15_e_encrypted_r15_Optional {
	bool d;
	SQN_PosSIB_Type_r15_encrypted_r15_e v;
};

struct SQN_GNSS_ID_r15_SQN_PosSIB_Type_r15_gnss_id_r15_Optional {
	bool d;
	struct SQN_GNSS_ID_r15 v;
};

struct SQN_SBAS_ID_r15_SQN_PosSIB_Type_r15_sbas_id_r15_Optional {
	bool d;
	struct SQN_SBAS_ID_r15 v;
};

struct SQN_PosSIB_Type_r15 {
	struct SQN_PosSIB_Type_r15_encrypted_r15_e_encrypted_r15_Optional encrypted_r15;
	struct SQN_GNSS_ID_r15_SQN_PosSIB_Type_r15_gnss_id_r15_Optional gnss_id_r15;
	struct SQN_SBAS_ID_r15_SQN_PosSIB_Type_r15_sbas_id_r15_Optional sbas_id_r15;
	SQN_PosSIB_Type_r15_posSibType_r15_e posSibType_r15;
};

struct SQN_PosSIB_Type_r15_SQN_PosSIB_MappingInfo_r15_Dynamic {
	size_t d;
	struct SQN_PosSIB_Type_r15* v;
};

typedef struct SQN_PosSIB_Type_r15_SQN_PosSIB_MappingInfo_r15_Dynamic SQN_PosSIB_MappingInfo_r15;

struct SQN_PosSchedulingInfo_r15 {
	SQN_PosSchedulingInfo_r15_posSI_Periodicity_r15_e posSI_Periodicity_r15;
	SQN_PosSIB_MappingInfo_r15 posSIB_MappingInfo_r15;
};

struct SQN_PosSchedulingInfo_r15_SQN_PosSchedulingInfoList_r15_Dynamic {
	size_t d;
	struct SQN_PosSchedulingInfo_r15* v;
};

typedef struct SQN_PosSchedulingInfo_r15_SQN_PosSchedulingInfoList_r15_Dynamic SQN_PosSchedulingInfoList_r15;

enum SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_r15_e {
	SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_r15_e_barred = 0,
	SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_r15_e_notBarred = 1,
};

typedef enum SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_r15_e SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_r15_e;

enum SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_CRS_r15_e {
	SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_CRS_r15_e_barred = 0,
	SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_CRS_r15_e_notBarred = 1,
};

typedef enum SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_CRS_r15_e SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_CRS_r15_e;

enum SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Sel {
	SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_UNBOUND_VALUE = 0,
	SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_plmn_Identity_r15 = 1,
	SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_plmn_Index_r15 = 2,
};

union SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Value {
	struct SQN_PLMN_Identity plmn_Identity_r15;
	uint8_t plmn_Index_r15;
};

struct SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15 {
	enum SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Sel d;
	union SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15_Value v;
};

enum SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_r15_e {
	SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_r15_e_reserved = 0,
	SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_r15_e_notReserved = 1,
};

typedef enum SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_r15_e SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_r15_e;

enum SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_CRS_r15_e {
	SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_CRS_r15_e_reserved = 0,
	SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_CRS_r15_e_notReserved = 1,
};

typedef enum SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_CRS_r15_e SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_CRS_r15_e;

struct SQN_PLMN_IdentityInfo_r15 {
	struct SQN_PLMN_IdentityInfo_r15_plmn_Identity_5GC_r15 plmn_Identity_5GC_r15;
	SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_r15_e cellReservedForOperatorUse_r15;
	SQN_PLMN_IdentityInfo_r15_cellReservedForOperatorUse_CRS_r15_e cellReservedForOperatorUse_CRS_r15;
};

struct SQN_PLMN_IdentityInfo_r15_SQN_PLMN_IdentityList_r15_Dynamic {
	size_t d;
	struct SQN_PLMN_IdentityInfo_r15* v;
};

typedef struct SQN_PLMN_IdentityInfo_r15_SQN_PLMN_IdentityList_r15_Dynamic SQN_PLMN_IdentityList_r15;

typedef uint8_t SQN_RAN_AreaCode_r15;

typedef B24 SQN_TrackingAreaCode_5GC_r15;

enum SQN_CellIdentity_5GC_r15_Sel {
	SQN_CellIdentity_5GC_r15_UNBOUND_VALUE = 0,
	SQN_CellIdentity_5GC_r15_cellIdentity_r15 = 1,
	SQN_CellIdentity_5GC_r15_cellId_Index_r15 = 2,
};

union SQN_CellIdentity_5GC_r15_Value {
	SQN_CellIdentity cellIdentity_r15;
	uint8_t cellId_Index_r15;
};

struct SQN_CellIdentity_5GC_r15 {
	enum SQN_CellIdentity_5GC_r15_Sel d;
	union SQN_CellIdentity_5GC_r15_Value v;
};

struct SQN_RAN_AreaCode_r15_SQN_CellAccessRelatedInfo_5GC_r15_ran_AreaCode_r15_Optional {
	bool d;
	SQN_RAN_AreaCode_r15 v;
};

struct SQN_CellAccessRelatedInfo_5GC_r15 {
	SQN_PLMN_IdentityList_r15 plmn_IdentityList_r15;
	struct SQN_RAN_AreaCode_r15_SQN_CellAccessRelatedInfo_5GC_r15_ran_AreaCode_r15_Optional ran_AreaCode_r15;
	SQN_TrackingAreaCode_5GC_r15 trackingAreaCode_5GC_r15;
	struct SQN_CellIdentity_5GC_r15 cellIdentity_5GC_r15;
};

struct SQN_CellAccessRelatedInfo_5GC_r15_SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellAccessRelatedInfoList_5GC_r15_Dynamic {
	size_t d;
	struct SQN_CellAccessRelatedInfo_5GC_r15* v;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15 {
	SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_r15_e cellBarred_5GC_r15;
	SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellBarred_5GC_CRS_r15_e cellBarred_5GC_CRS_r15;
	struct SQN_CellAccessRelatedInfo_5GC_r15_SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellAccessRelatedInfoList_5GC_r15_Dynamic cellAccessRelatedInfoList_5GC_r15;
};

enum SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e {
	SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e;

enum SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e {
	SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e;

enum SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e {
	SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e;

enum SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e {
	SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e;

enum SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e {
	SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e;

enum SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e {
	SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e_true = 0,
};

typedef enum SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e;

enum SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e {
	SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e_true = 0,
};

typedef enum SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e;

enum SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e {
	SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e_true = 0,
};

typedef enum SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e;

enum SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e {
	SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e_true = 0,
};

typedef enum SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e;

struct SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e_cp_CIoT_5GS_Optimisation_r16_Optional {
	bool d;
	SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e v;
};

struct SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e_up_CIoT_5GS_Optimisation_r16_Optional {
	bool d;
	SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e v;
};

struct SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e_iab_Support_r16_Optional {
	bool d;
	SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e v;
};

struct SQN_PLMN_IdentityInfo_v1610 {
	struct SQN_PLMN_IdentityInfo_v1610_cp_CIoT_5GS_Optimisation_r16_e_cp_CIoT_5GS_Optimisation_r16_Optional cp_CIoT_5GS_Optimisation_r16;
	struct SQN_PLMN_IdentityInfo_v1610_up_CIoT_5GS_Optimisation_r16_e_up_CIoT_5GS_Optimisation_r16_Optional up_CIoT_5GS_Optimisation_r16;
	struct SQN_PLMN_IdentityInfo_v1610_iab_Support_r16_e_iab_Support_r16_Optional iab_Support_r16;
};

struct SQN_PLMN_IdentityInfo_v1610_SQN_PLMN_IdentityList_v1610_Dynamic {
	size_t d;
	struct SQN_PLMN_IdentityInfo_v1610* v;
};

typedef struct SQN_PLMN_IdentityInfo_v1610_SQN_PLMN_IdentityList_v1610_Dynamic SQN_PLMN_IdentityList_v1610;

struct SQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension {
};

struct SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e_eDRX_Allowed_5GC_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e v;
};

struct SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e_transmissionInControlChRegion_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e v;
};

struct SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e_campingAllowedInCE_r16_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e v;
};

struct SQN_PLMN_IdentityList_v1610_SQN_SystemInformationBlockType1_v1610_IEs_plmn_IdentityList_v1610_Optional {
	bool d;
	SQN_PLMN_IdentityList_v1610 v;
};

struct SQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension v;
};

struct SQN_SystemInformationBlockType1_v1610_IEs {
	struct SQN_SystemInformationBlockType1_v1610_IEs_eDRX_Allowed_5GC_r16_e_eDRX_Allowed_5GC_r16_Optional eDRX_Allowed_5GC_r16;
	struct SQN_SystemInformationBlockType1_v1610_IEs_transmissionInControlChRegion_r16_e_transmissionInControlChRegion_r16_Optional transmissionInControlChRegion_r16;
	struct SQN_SystemInformationBlockType1_v1610_IEs_campingAllowedInCE_r16_e_campingAllowedInCE_r16_Optional campingAllowedInCE_r16;
	struct SQN_PLMN_IdentityList_v1610_SQN_SystemInformationBlockType1_v1610_IEs_plmn_IdentityList_v1610_Optional plmn_IdentityList_v1610;
	struct SQN_SystemInformationBlockType1_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e_si_posOffset_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e v;
};

struct SQN_SystemInformationBlockType1_v1610_IEs_SQN_SystemInformationBlockType1_v1540_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1610_IEs v;
};

struct SQN_SystemInformationBlockType1_v1540_IEs {
	struct SQN_SystemInformationBlockType1_v1540_IEs_si_posOffset_r15_e_si_posOffset_r15_Optional si_posOffset_r15;
	struct SQN_SystemInformationBlockType1_v1610_IEs_SQN_SystemInformationBlockType1_v1540_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e_hsdn_Cell_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e v;
};

struct SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType1_v1530_IEs_cellSelectionInfoCE_v1530_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE_v1530 v;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigConfig_r15_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15 v;
};

struct SQN_PLMN_IdentityList_v1530_SQN_SystemInformationBlockType1_v1530_IEs_plmn_IdentityList_v1530_Optional {
	bool d;
	SQN_PLMN_IdentityList_v1530 v;
};

struct SQN_PosSchedulingInfoList_r15_SQN_SystemInformationBlockType1_v1530_IEs_posSchedulingInfoList_r15_Optional {
	bool d;
	SQN_PosSchedulingInfoList_r15 v;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellAccessRelatedInfo_5GC_r15_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15 v;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e_ims_EmergencySupport5GC_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e v;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e_eCallOverIMS_Support5GC_r15_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e v;
};

struct SQN_SystemInformationBlockType1_v1540_IEs_SQN_SystemInformationBlockType1_v1530_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1540_IEs v;
};

struct SQN_SystemInformationBlockType1_v1530_IEs {
	struct SQN_SystemInformationBlockType1_v1530_IEs_hsdn_Cell_r15_e_hsdn_Cell_r15_Optional hsdn_Cell_r15;
	struct SQN_CellSelectionInfoCE_v1530_SQN_SystemInformationBlockType1_v1530_IEs_cellSelectionInfoCE_v1530_Optional cellSelectionInfoCE_v1530;
	struct SQN_SystemInformationBlockType1_v1530_IEs_crs_IntfMitigConfig_r15_crs_IntfMitigConfig_r15_Optional crs_IntfMitigConfig_r15;
	SQN_SystemInformationBlockType1_v1530_IEs_cellBarred_CRS_r15_e cellBarred_CRS_r15;
	struct SQN_PLMN_IdentityList_v1530_SQN_SystemInformationBlockType1_v1530_IEs_plmn_IdentityList_v1530_Optional plmn_IdentityList_v1530;
	struct SQN_PosSchedulingInfoList_r15_SQN_SystemInformationBlockType1_v1530_IEs_posSchedulingInfoList_r15_Optional posSchedulingInfoList_r15;
	struct SQN_SystemInformationBlockType1_v1530_IEs_cellAccessRelatedInfo_5GC_r15_cellAccessRelatedInfo_5GC_r15_Optional cellAccessRelatedInfo_5GC_r15;
	struct SQN_SystemInformationBlockType1_v1530_IEs_ims_EmergencySupport5GC_r15_e_ims_EmergencySupport5GC_r15_Optional ims_EmergencySupport5GC_r15;
	struct SQN_SystemInformationBlockType1_v1530_IEs_eCallOverIMS_Support5GC_r15_e_eCallOverIMS_Support5GC_r15_Optional eCallOverIMS_Support5GC_r15;
	struct SQN_SystemInformationBlockType1_v1540_IEs_SQN_SystemInformationBlockType1_v1530_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_TDD_Config_v1450_SQN_SystemInformationBlockType1_v1450_IEs_tdd_Config_v1450_Optional {
	bool d;
	struct SQN_TDD_Config_v1450 v;
};

struct SQN_SystemInformationBlockType1_v1530_IEs_SQN_SystemInformationBlockType1_v1450_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1530_IEs v;
};

struct SQN_SystemInformationBlockType1_v1450_IEs {
	struct SQN_TDD_Config_v1450_SQN_SystemInformationBlockType1_v1450_IEs_tdd_Config_v1450_Optional tdd_Config_v1450;
	struct SQN_SystemInformationBlockType1_v1530_IEs_SQN_SystemInformationBlockType1_v1450_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e_eCallOverIMS_Support_r14_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e v;
};

struct SQN_TDD_Config_v1430_SQN_SystemInformationBlockType1_v1430_IEs_tdd_Config_v1430_Optional {
	bool d;
	struct SQN_TDD_Config_v1430 v;
};

struct SQN_SystemInformationBlockType1_v1430_IEs_SQN_CellAccessRelatedInfo_r14_cellAccessRelatedInfoList_r14_Dynamic {
	size_t d;
	struct SQN_CellAccessRelatedInfo_r14* v;
};

struct SQN_CellAccessRelatedInfo_r14_SQN_SystemInformationBlockType1_v1430_IEs_cellAccessRelatedInfoList_r14_DynamicOptional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1430_IEs_SQN_CellAccessRelatedInfo_r14_cellAccessRelatedInfoList_r14_Dynamic v;
};

struct SQN_SystemInformationBlockType1_v1450_IEs_SQN_SystemInformationBlockType1_v1430_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1450_IEs v;
};

struct SQN_SystemInformationBlockType1_v1430_IEs {
	struct SQN_SystemInformationBlockType1_v1430_IEs_eCallOverIMS_Support_r14_e_eCallOverIMS_Support_r14_Optional eCallOverIMS_Support_r14;
	struct SQN_TDD_Config_v1430_SQN_SystemInformationBlockType1_v1430_IEs_tdd_Config_v1430_Optional tdd_Config_v1430;
	struct SQN_CellAccessRelatedInfo_r14_SQN_SystemInformationBlockType1_v1430_IEs_cellAccessRelatedInfoList_r14_DynamicOptional cellAccessRelatedInfoList_r14;
	struct SQN_SystemInformationBlockType1_v1450_IEs_SQN_SystemInformationBlockType1_v1430_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType1_v1360_IEs_cellSelectionInfoCE1_v1360_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE1_v1360 v;
};

struct SQN_SystemInformationBlockType1_v1430_IEs_SQN_SystemInformationBlockType1_v1360_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1430_IEs v;
};

struct SQN_SystemInformationBlockType1_v1360_IEs {
	struct SQN_CellSelectionInfoCE1_v1360_SQN_SystemInformationBlockType1_v1360_IEs_cellSelectionInfoCE1_v1360_Optional cellSelectionInfoCE1_v1360;
	struct SQN_SystemInformationBlockType1_v1430_IEs_SQN_SystemInformationBlockType1_v1360_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType1_v1350_IEs_cellSelectionInfoCE1_r13_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE1_r13 v;
};

struct SQN_SystemInformationBlockType1_v1360_IEs_SQN_SystemInformationBlockType1_v1350_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1360_IEs v;
};

struct SQN_SystemInformationBlockType1_v1350_IEs {
	struct SQN_CellSelectionInfoCE1_r13_SQN_SystemInformationBlockType1_v1350_IEs_cellSelectionInfoCE1_r13_Optional cellSelectionInfoCE1_r13;
	struct SQN_SystemInformationBlockType1_v1360_IEs_SQN_SystemInformationBlockType1_v1350_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_freqHoppingParametersDL_r13_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13 v;
};

struct SQN_SystemInformationBlockType1_v1350_IEs_SQN_SystemInformationBlockType1_v1320_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1350_IEs v;
};

struct SQN_SystemInformationBlockType1_v1320_IEs {
	struct SQN_SystemInformationBlockType1_v1320_IEs_freqHoppingParametersDL_r13_freqHoppingParametersDL_r13_Optional freqHoppingParametersDL_r13;
	struct SQN_SystemInformationBlockType1_v1350_IEs_SQN_SystemInformationBlockType1_v1320_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct B10_SQN_SystemInformationBlockType1_v1310_IEs_hyperSFN_r13_Optional {
	bool d;
	B10 v;
};

struct SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_eDRX_Allowed_r13_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e v;
};

struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType1_v1310_IEs_cellSelectionInfoCE_r13_Optional {
	bool d;
	struct SQN_CellSelectionInfoCE_r13 v;
};

struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_bandwidthReducedAccessRelatedInfo_r13_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13 v;
};

struct SQN_SystemInformationBlockType1_v1320_IEs_SQN_SystemInformationBlockType1_v1310_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1320_IEs v;
};

struct SQN_SystemInformationBlockType1_v1310_IEs {
	struct B10_SQN_SystemInformationBlockType1_v1310_IEs_hyperSFN_r13_Optional hyperSFN_r13;
	struct SQN_SystemInformationBlockType1_v1310_IEs_eDRX_Allowed_r13_e_eDRX_Allowed_r13_Optional eDRX_Allowed_r13;
	struct SQN_CellSelectionInfoCE_r13_SQN_SystemInformationBlockType1_v1310_IEs_cellSelectionInfoCE_r13_Optional cellSelectionInfoCE_r13;
	struct SQN_SystemInformationBlockType1_v1310_IEs_bandwidthReducedAccessRelatedInfo_r13_bandwidthReducedAccessRelatedInfo_r13_Optional bandwidthReducedAccessRelatedInfo_r13;
	struct SQN_SystemInformationBlockType1_v1320_IEs_SQN_SystemInformationBlockType1_v1310_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_CellSelectionInfo_v1250_SQN_SystemInformationBlockType1_v1250_IEs_cellSelectionInfo_v1250_Optional {
	bool d;
	struct SQN_CellSelectionInfo_v1250 v;
};

struct SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_freqBandIndicatorPriority_r12_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e v;
};

struct SQN_SystemInformationBlockType1_v1310_IEs_SQN_SystemInformationBlockType1_v1250_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1310_IEs v;
};

struct SQN_SystemInformationBlockType1_v1250_IEs {
	struct SQN_SystemInformationBlockType1_v1250_IEs_cellAccessRelatedInfo_v1250 cellAccessRelatedInfo_v1250;
	struct SQN_CellSelectionInfo_v1250_SQN_SystemInformationBlockType1_v1250_IEs_cellSelectionInfo_v1250_Optional cellSelectionInfo_v1250;
	struct SQN_SystemInformationBlockType1_v1250_IEs_freqBandIndicatorPriority_r12_e_freqBandIndicatorPriority_r12_Optional freqBandIndicatorPriority_r12;
	struct SQN_SystemInformationBlockType1_v1310_IEs_SQN_SystemInformationBlockType1_v1250_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_TDD_Config_v1130_SQN_SystemInformationBlockType1_v1130_IEs_tdd_Config_v1130_Optional {
	bool d;
	struct SQN_TDD_Config_v1130 v;
};

struct SQN_CellSelectionInfo_v1130_SQN_SystemInformationBlockType1_v1130_IEs_cellSelectionInfo_v1130_Optional {
	bool d;
	struct SQN_CellSelectionInfo_v1130 v;
};

struct SQN_SystemInformationBlockType1_v1250_IEs_SQN_SystemInformationBlockType1_v1130_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1250_IEs v;
};

struct SQN_SystemInformationBlockType1_v1130_IEs {
	struct SQN_TDD_Config_v1130_SQN_SystemInformationBlockType1_v1130_IEs_tdd_Config_v1130_Optional tdd_Config_v1130;
	struct SQN_CellSelectionInfo_v1130_SQN_SystemInformationBlockType1_v1130_IEs_cellSelectionInfo_v1130_Optional cellSelectionInfo_v1130;
	struct SQN_SystemInformationBlockType1_v1250_IEs_SQN_SystemInformationBlockType1_v1130_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_ims_EmergencySupport_r9_Optional {
	bool d;
	SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e v;
};

struct SQN_CellSelectionInfo_v920_SQN_SystemInformationBlockType1_v920_IEs_cellSelectionInfo_v920_Optional {
	bool d;
	struct SQN_CellSelectionInfo_v920 v;
};

struct SQN_SystemInformationBlockType1_v1130_IEs_SQN_SystemInformationBlockType1_v920_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v1130_IEs v;
};

struct SQN_SystemInformationBlockType1_v920_IEs {
	struct SQN_SystemInformationBlockType1_v920_IEs_ims_EmergencySupport_r9_e_ims_EmergencySupport_r9_Optional ims_EmergencySupport_r9;
	struct SQN_CellSelectionInfo_v920_SQN_SystemInformationBlockType1_v920_IEs_cellSelectionInfo_v920_Optional cellSelectionInfo_v920;
	struct SQN_SystemInformationBlockType1_v1130_IEs_SQN_SystemInformationBlockType1_v920_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct OCTET_STRING_SQN_SystemInformationBlockType1_v890_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_SystemInformationBlockType1_v920_IEs_SQN_SystemInformationBlockType1_v890_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v920_IEs v;
};

struct SQN_SystemInformationBlockType1_v890_IEs {
	struct OCTET_STRING_SQN_SystemInformationBlockType1_v890_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_SystemInformationBlockType1_v920_IEs_SQN_SystemInformationBlockType1_v890_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_P_Max_SQN_SystemInformationBlockType1_p_Max_Optional {
	bool d;
	SQN_P_Max v;
};

struct SQN_TDD_Config_SQN_SystemInformationBlockType1_tdd_Config_Optional {
	bool d;
	struct SQN_TDD_Config v;
};

struct SQN_SystemInformationBlockType1_v890_IEs_SQN_SystemInformationBlockType1_nonCriticalExtension_Optional {
	bool d;
	struct SQN_SystemInformationBlockType1_v890_IEs v;
};

struct SQN_SystemInformationBlockType1 {
	struct SQN_SystemInformationBlockType1_cellAccessRelatedInfo cellAccessRelatedInfo;
	struct SQN_SystemInformationBlockType1_cellSelectionInfo cellSelectionInfo;
	struct SQN_P_Max_SQN_SystemInformationBlockType1_p_Max_Optional p_Max;
	SQN_FreqBandIndicator freqBandIndicator;
	SQN_SchedulingInfoList schedulingInfoList;
	struct SQN_TDD_Config_SQN_SystemInformationBlockType1_tdd_Config_Optional tdd_Config;
	SQN_SystemInformationBlockType1_si_WindowLength_e si_WindowLength;
	uint8_t systemInfoValueTag;
	struct SQN_SystemInformationBlockType1_v890_IEs_SQN_SystemInformationBlockType1_nonCriticalExtension_Optional nonCriticalExtension;
};

enum SQN_BCCH_DL_SCH_MessageType_c1_Sel {
	SQN_BCCH_DL_SCH_MessageType_c1_UNBOUND_VALUE = 0,
	SQN_BCCH_DL_SCH_MessageType_c1_systemInformation = 1,
	SQN_BCCH_DL_SCH_MessageType_c1_systemInformationBlockType1 = 2,
};

union SQN_BCCH_DL_SCH_MessageType_c1_Value {
	struct SQN_SystemInformation systemInformation;
	struct SQN_SystemInformationBlockType1 systemInformationBlockType1;
};

struct SQN_BCCH_DL_SCH_MessageType_c1 {
	enum SQN_BCCH_DL_SCH_MessageType_c1_Sel d;
	union SQN_BCCH_DL_SCH_MessageType_c1_Value v;
};

struct SQN_BCCH_DL_SCH_MessageType_messageClassExtension {
};

enum SQN_BCCH_DL_SCH_MessageType_Sel {
	SQN_BCCH_DL_SCH_MessageType_UNBOUND_VALUE = 0,
	SQN_BCCH_DL_SCH_MessageType_c1 = 1,
	SQN_BCCH_DL_SCH_MessageType_messageClassExtension = 2,
};

union SQN_BCCH_DL_SCH_MessageType_Value {
	struct SQN_BCCH_DL_SCH_MessageType_c1 c1;
	struct SQN_BCCH_DL_SCH_MessageType_messageClassExtension messageClassExtension;
};

struct SQN_BCCH_DL_SCH_MessageType {
	enum SQN_BCCH_DL_SCH_MessageType_Sel d;
	union SQN_BCCH_DL_SCH_MessageType_Value v;
};

struct SQN_BCCH_DL_SCH_Message {
	struct SQN_BCCH_DL_SCH_MessageType message;
};

enum SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Sel {
	SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_UNBOUND_VALUE = 0,
	SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_systemInformation_BR_r13 = 1,
	SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_systemInformationBlockType1_BR_r13 = 2,
};

union SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Value {
	struct SQN_SystemInformation systemInformation_BR_r13;
	struct SQN_SystemInformationBlockType1 systemInformationBlockType1_BR_r13;
};

struct SQN_BCCH_DL_SCH_MessageType_BR_r13_c1 {
	enum SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Sel d;
	union SQN_BCCH_DL_SCH_MessageType_BR_r13_c1_Value v;
};

struct SQN_BCCH_DL_SCH_MessageType_BR_r13_messageClassExtension {
};

enum SQN_BCCH_DL_SCH_MessageType_BR_r13_Sel {
	SQN_BCCH_DL_SCH_MessageType_BR_r13_UNBOUND_VALUE = 0,
	SQN_BCCH_DL_SCH_MessageType_BR_r13_c1 = 1,
	SQN_BCCH_DL_SCH_MessageType_BR_r13_messageClassExtension = 2,
};

union SQN_BCCH_DL_SCH_MessageType_BR_r13_Value {
	struct SQN_BCCH_DL_SCH_MessageType_BR_r13_c1 c1;
	struct SQN_BCCH_DL_SCH_MessageType_BR_r13_messageClassExtension messageClassExtension;
};

struct SQN_BCCH_DL_SCH_MessageType_BR_r13 {
	enum SQN_BCCH_DL_SCH_MessageType_BR_r13_Sel d;
	union SQN_BCCH_DL_SCH_MessageType_BR_r13_Value v;
};

struct SQN_BCCH_DL_SCH_Message_BR {
	struct SQN_BCCH_DL_SCH_MessageType_BR_r13 message;
};

typedef B16 SQN_C_RNTI;

enum SQN_CQI_ReportModeAperiodic_e {
	SQN_CQI_ReportModeAperiodic_e_rm12 = 0,
	SQN_CQI_ReportModeAperiodic_e_rm20 = 1,
	SQN_CQI_ReportModeAperiodic_e_rm22 = 2,
	SQN_CQI_ReportModeAperiodic_e_rm30 = 3,
	SQN_CQI_ReportModeAperiodic_e_rm31 = 4,
	SQN_CQI_ReportModeAperiodic_e_rm32_v1250 = 5,
	SQN_CQI_ReportModeAperiodic_e_rm10_v1310 = 6,
	SQN_CQI_ReportModeAperiodic_e_rm11_v1310 = 7,
};

typedef enum SQN_CQI_ReportModeAperiodic_e SQN_CQI_ReportModeAperiodic_e;

struct SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_subbandCQI {
	uint8_t k;
};

enum SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Sel {
	SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_UNBOUND_VALUE = 0,
	SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_widebandCQI = 1,
	SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_subbandCQI = 2,
};

union SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Value {
	Null widebandCQI;
	struct SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_subbandCQI subbandCQI;
};

struct SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic {
	enum SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Sel d;
	union SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic_Value v;
};

struct uint16_t_SQN_CQI_ReportPeriodic_setup_ri_ConfigIndex_Optional {
	bool d;
	uint16_t v;
};

struct SQN_CQI_ReportPeriodic_setup {
	uint16_t cqi_PUCCH_ResourceIndex;
	uint16_t cqi_pmi_ConfigIndex;
	struct SQN_CQI_ReportPeriodic_setup_cqi_FormatIndicatorPeriodic cqi_FormatIndicatorPeriodic;
	struct uint16_t_SQN_CQI_ReportPeriodic_setup_ri_ConfigIndex_Optional ri_ConfigIndex;
	bool simultaneousAckNackAndCQI;
};

enum SQN_CQI_ReportPeriodic_Sel {
	SQN_CQI_ReportPeriodic_UNBOUND_VALUE = 0,
	SQN_CQI_ReportPeriodic_release = 1,
	SQN_CQI_ReportPeriodic_setup = 2,
};

union SQN_CQI_ReportPeriodic_Value {
	Null release;
	struct SQN_CQI_ReportPeriodic_setup setup;
};

struct SQN_CQI_ReportPeriodic {
	enum SQN_CQI_ReportPeriodic_Sel d;
	union SQN_CQI_ReportPeriodic_Value v;
};

struct SQN_CQI_ReportModeAperiodic_e_SQN_CQI_ReportConfig_cqi_ReportModeAperiodic_Optional {
	bool d;
	SQN_CQI_ReportModeAperiodic_e v;
};

struct SQN_CQI_ReportPeriodic_SQN_CQI_ReportConfig_cqi_ReportPeriodic_Optional {
	bool d;
	struct SQN_CQI_ReportPeriodic v;
};

struct SQN_CQI_ReportConfig {
	struct SQN_CQI_ReportModeAperiodic_e_SQN_CQI_ReportConfig_cqi_ReportModeAperiodic_Optional cqi_ReportModeAperiodic;
	int8_t nomPDSCH_RS_EPRE_Offset;
	struct SQN_CQI_ReportPeriodic_SQN_CQI_ReportConfig_cqi_ReportPeriodic_Optional cqi_ReportPeriodic;
};

struct SQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10 {
	B8 trigger1_r10;
	B8 trigger2_r10;
};

struct SQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10_aperiodicCSI_Trigger_r10_Optional {
	bool d;
	struct SQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10 v;
};

struct SQN_CQI_ReportAperiodic_r10_setup {
	SQN_CQI_ReportModeAperiodic_e cqi_ReportModeAperiodic_r10;
	struct SQN_CQI_ReportAperiodic_r10_setup_aperiodicCSI_Trigger_r10_aperiodicCSI_Trigger_r10_Optional aperiodicCSI_Trigger_r10;
};

enum SQN_CQI_ReportAperiodic_r10_Sel {
	SQN_CQI_ReportAperiodic_r10_UNBOUND_VALUE = 0,
	SQN_CQI_ReportAperiodic_r10_release = 1,
	SQN_CQI_ReportAperiodic_r10_setup = 2,
};

union SQN_CQI_ReportAperiodic_r10_Value {
	Null release;
	struct SQN_CQI_ReportAperiodic_r10_setup setup;
};

struct SQN_CQI_ReportAperiodic_r10 {
	enum SQN_CQI_ReportAperiodic_r10_Sel d;
	union SQN_CQI_ReportAperiodic_r10_Value v;
};

enum SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e {
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e_submode1 = 0,
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e_submode2 = 1,
};

typedef enum SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e;

struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e_csi_ReportMode_r10_Optional {
	bool d;
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e v;
};

struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10 {
	struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10_csi_ReportMode_r10_e_csi_ReportMode_r10_Optional csi_ReportMode_r10;
};

enum SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10_periodicityFactor_r10_e {
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10_periodicityFactor_r10_e_n2 = 0,
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10_periodicityFactor_r10_e_n4 = 1,
};

typedef enum SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10_periodicityFactor_r10_e SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10_periodicityFactor_r10_e;

struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10 {
	uint8_t k;
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10_periodicityFactor_r10_e periodicityFactor_r10;
};

enum SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Sel {
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_UNBOUND_VALUE = 0,
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10 = 1,
	SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10 = 2,
};

union SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Value {
	struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_widebandCQI_r10 widebandCQI_r10;
	struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_subbandCQI_r10 subbandCQI_r10;
};

struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10 {
	enum SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Sel d;
	union SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10_Value v;
};

enum SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e {
	SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e_setup = 0,
};

typedef enum SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e;

struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup_ri_ConfigIndex2_r10_Optional {
	bool d;
	uint16_t v;
};

struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup {
	uint16_t cqi_pmi_ConfigIndex2_r10;
	struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup_ri_ConfigIndex2_r10_Optional ri_ConfigIndex2_r10;
};

enum SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Sel {
	SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_UNBOUND_VALUE = 0,
	SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_release = 1,
	SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup = 2,
};

union SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Value {
	Null release;
	struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_setup setup;
};

struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10 {
	enum SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Sel d;
	union SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_Value v;
};

struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_cqi_PUCCH_ResourceIndexP1_r10_Optional {
	bool d;
	uint16_t v;
};

struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_ri_ConfigIndex_Optional {
	bool d;
	uint16_t v;
};

struct SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e_cqi_Mask_r9_Optional {
	bool d;
	SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e v;
};

struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_csi_ConfigIndex_r10_Optional {
	bool d;
	struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10 v;
};

struct SQN_CQI_ReportPeriodic_r10_setup {
	uint16_t cqi_PUCCH_ResourceIndex_r10;
	struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_cqi_PUCCH_ResourceIndexP1_r10_Optional cqi_PUCCH_ResourceIndexP1_r10;
	uint16_t cqi_pmi_ConfigIndex;
	struct SQN_CQI_ReportPeriodic_r10_setup_cqi_FormatIndicatorPeriodic_r10 cqi_FormatIndicatorPeriodic_r10;
	struct uint16_t_SQN_CQI_ReportPeriodic_r10_setup_ri_ConfigIndex_Optional ri_ConfigIndex;
	bool simultaneousAckNackAndCQI;
	struct SQN_CQI_ReportPeriodic_r10_setup_cqi_Mask_r9_e_cqi_Mask_r9_Optional cqi_Mask_r9;
	struct SQN_CQI_ReportPeriodic_r10_setup_csi_ConfigIndex_r10_csi_ConfigIndex_r10_Optional csi_ConfigIndex_r10;
};

enum SQN_CQI_ReportPeriodic_r10_Sel {
	SQN_CQI_ReportPeriodic_r10_UNBOUND_VALUE = 0,
	SQN_CQI_ReportPeriodic_r10_release = 1,
	SQN_CQI_ReportPeriodic_r10_setup = 2,
};

union SQN_CQI_ReportPeriodic_r10_Value {
	Null release;
	struct SQN_CQI_ReportPeriodic_r10_setup setup;
};

struct SQN_CQI_ReportPeriodic_r10 {
	enum SQN_CQI_ReportPeriodic_r10_Sel d;
	union SQN_CQI_ReportPeriodic_r10_Value v;
};

enum SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e {
	SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e_setup = 0,
};

typedef enum SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e;

enum SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Sel {
	SQN_MeasSubframePattern_r10_subframePatternTDD_r10_UNBOUND_VALUE = 0,
	SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig1_5_r10 = 1,
	SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig0_r10 = 2,
	SQN_MeasSubframePattern_r10_subframePatternTDD_r10_subframeConfig6_r10 = 3,
};

union SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value {
	B20 subframeConfig1_5_r10;
	B70 subframeConfig0_r10;
	B60 subframeConfig6_r10;
};

struct SQN_MeasSubframePattern_r10_subframePatternTDD_r10 {
	enum SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Sel d;
	union SQN_MeasSubframePattern_r10_subframePatternTDD_r10_Value v;
};

enum SQN_MeasSubframePattern_r10_Sel {
	SQN_MeasSubframePattern_r10_UNBOUND_VALUE = 0,
	SQN_MeasSubframePattern_r10_subframePatternFDD_r10 = 1,
	SQN_MeasSubframePattern_r10_subframePatternTDD_r10 = 2,
};

union SQN_MeasSubframePattern_r10_Value {
	B40 subframePatternFDD_r10;
	struct SQN_MeasSubframePattern_r10_subframePatternTDD_r10 subframePatternTDD_r10;
};

struct SQN_MeasSubframePattern_r10 {
	enum SQN_MeasSubframePattern_r10_Sel d;
	union SQN_MeasSubframePattern_r10_Value v;
};

struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup {
	struct SQN_MeasSubframePattern_r10 csi_MeasSubframeSet1_r10;
	struct SQN_MeasSubframePattern_r10 csi_MeasSubframeSet2_r10;
};

enum SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Sel {
	SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_UNBOUND_VALUE = 0,
	SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_release = 1,
	SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup = 2,
};

union SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Value {
	Null release;
	struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_setup setup;
};

struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10 {
	enum SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Sel d;
	union SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_Value v;
};

struct SQN_CQI_ReportAperiodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportAperiodic_r10_Optional {
	bool d;
	struct SQN_CQI_ReportAperiodic_r10 v;
};

struct SQN_CQI_ReportPeriodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportPeriodic_r10_Optional {
	bool d;
	struct SQN_CQI_ReportPeriodic_r10 v;
};

struct SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional {
	bool d;
	SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e v;
};

struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_csi_SubframePatternConfig_r10_Optional {
	bool d;
	struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10 v;
};

struct SQN_CQI_ReportConfig_r10 {
	struct SQN_CQI_ReportAperiodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportAperiodic_r10_Optional cqi_ReportAperiodic_r10;
	int8_t nomPDSCH_RS_EPRE_Offset;
	struct SQN_CQI_ReportPeriodic_r10_SQN_CQI_ReportConfig_r10_cqi_ReportPeriodic_r10_Optional cqi_ReportPeriodic_r10;
	struct SQN_CQI_ReportConfig_r10_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional pmi_RI_Report_r9;
	struct SQN_CQI_ReportConfig_r10_csi_SubframePatternConfig_r10_csi_SubframePatternConfig_r10_Optional csi_SubframePatternConfig_r10;
};

enum SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e {
	SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e_setup = 0,
};

typedef enum SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e;

typedef uint8_t SQN_CQI_ReportPeriodicProcExtId_r11;

struct SQN_CQI_ReportPeriodicProcExtId_r11_SQN_CQI_ReportPeriodicProcExtToReleaseList_r11_Dynamic {
	size_t d;
	SQN_CQI_ReportPeriodicProcExtId_r11* v;
};

typedef struct SQN_CQI_ReportPeriodicProcExtId_r11_SQN_CQI_ReportPeriodicProcExtToReleaseList_r11_Dynamic SQN_CQI_ReportPeriodicProcExtToReleaseList_r11;

enum SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e {
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e_submode1 = 0,
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e_submode2 = 1,
};

typedef enum SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e;

struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e_csi_ReportMode_r11_Optional {
	bool d;
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e v;
};

struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11 {
	struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11_csi_ReportMode_r11_e_csi_ReportMode_r11_Optional csi_ReportMode_r11;
};

enum SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11_periodicityFactor_r11_e {
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11_periodicityFactor_r11_e_n2 = 0,
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11_periodicityFactor_r11_e_n4 = 1,
};

typedef enum SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11_periodicityFactor_r11_e SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11_periodicityFactor_r11_e;

struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11 {
	uint8_t k;
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11_periodicityFactor_r11_e periodicityFactor_r11;
};

enum SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Sel {
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_UNBOUND_VALUE = 0,
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11 = 1,
	SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11 = 2,
};

union SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Value {
	struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_widebandCQI_r11 widebandCQI_r11;
	struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_subbandCQI_r11 subbandCQI_r11;
};

struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11 {
	enum SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Sel d;
	union SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11_Value v;
};

struct uint16_t_SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup_ri_ConfigIndex2_r11_Optional {
	bool d;
	uint16_t v;
};

struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup {
	uint16_t cqi_pmi_ConfigIndex2_r11;
	struct uint16_t_SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup_ri_ConfigIndex2_r11_Optional ri_ConfigIndex2_r11;
};

enum SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Sel {
	SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_UNBOUND_VALUE = 0,
	SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_release = 1,
	SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup = 2,
};

union SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Value {
	Null release;
	struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_setup setup;
};

struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11 {
	enum SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Sel d;
	union SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_Value v;
};

typedef uint16_t SQN_CRI_ConfigIndex_r13;

struct SQN_CRI_ConfigIndex_r13_SQN_CRI_ReportConfig_r13_setup_cri_ConfigIndex2_r13_Optional {
	bool d;
	SQN_CRI_ConfigIndex_r13 v;
};

struct SQN_CRI_ReportConfig_r13_setup {
	SQN_CRI_ConfigIndex_r13 cri_ConfigIndex_r13;
	struct SQN_CRI_ConfigIndex_r13_SQN_CRI_ReportConfig_r13_setup_cri_ConfigIndex2_r13_Optional cri_ConfigIndex2_r13;
};

enum SQN_CRI_ReportConfig_r13_Sel {
	SQN_CRI_ReportConfig_r13_UNBOUND_VALUE = 0,
	SQN_CRI_ReportConfig_r13_release = 1,
	SQN_CRI_ReportConfig_r13_setup = 2,
};

union SQN_CRI_ReportConfig_r13_Value {
	Null release;
	struct SQN_CRI_ReportConfig_r13_setup setup;
};

struct SQN_CRI_ReportConfig_r13 {
	enum SQN_CRI_ReportConfig_r13_Sel d;
	union SQN_CRI_ReportConfig_r13_Value v;
};

enum SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e {
	SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e_n2 = 0,
	SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e_n4 = 1,
};

typedef enum SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e;

struct uint16_t_SQN_CQI_ReportPeriodicProcExt_r11_ri_ConfigIndex_r11_Optional {
	bool d;
	uint16_t v;
};

struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_csi_ConfigIndex_r11_Optional {
	bool d;
	struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11 v;
};

struct SQN_CRI_ReportConfig_r13_SQN_CQI_ReportPeriodicProcExt_r11_cri_ReportConfig_r13_Optional {
	bool d;
	struct SQN_CRI_ReportConfig_r13 v;
};

struct SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e_periodicityFactorWB_r13_Optional {
	bool d;
	SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e v;
};

struct SQN_CQI_ReportPeriodicProcExt_r11 {
	SQN_CQI_ReportPeriodicProcExtId_r11 cqi_ReportPeriodicProcExtId_r11;
	uint16_t cqi_pmi_ConfigIndex_r11;
	struct SQN_CQI_ReportPeriodicProcExt_r11_cqi_FormatIndicatorPeriodic_r11 cqi_FormatIndicatorPeriodic_r11;
	struct uint16_t_SQN_CQI_ReportPeriodicProcExt_r11_ri_ConfigIndex_r11_Optional ri_ConfigIndex_r11;
	struct SQN_CQI_ReportPeriodicProcExt_r11_csi_ConfigIndex_r11_csi_ConfigIndex_r11_Optional csi_ConfigIndex_r11;
	struct SQN_CRI_ReportConfig_r13_SQN_CQI_ReportPeriodicProcExt_r11_cri_ReportConfig_r13_Optional cri_ReportConfig_r13;
	struct SQN_CQI_ReportPeriodicProcExt_r11_periodicityFactorWB_r13_e_periodicityFactorWB_r13_Optional periodicityFactorWB_r13;
};

struct SQN_CQI_ReportPeriodicProcExt_r11_SQN_CQI_ReportPeriodicProcExtToAddModList_r11_Dynamic {
	size_t d;
	struct SQN_CQI_ReportPeriodicProcExt_r11* v;
};

typedef struct SQN_CQI_ReportPeriodicProcExt_r11_SQN_CQI_ReportPeriodicProcExtToAddModList_r11_Dynamic SQN_CQI_ReportPeriodicProcExtToAddModList_r11;

struct SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e_simultaneousAckNackAndCQI_Format3_r11_Optional {
	bool d;
	SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e v;
};

struct SQN_CQI_ReportPeriodicProcExtToReleaseList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToReleaseList_r11_Optional {
	bool d;
	SQN_CQI_ReportPeriodicProcExtToReleaseList_r11 v;
};

struct SQN_CQI_ReportPeriodicProcExtToAddModList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToAddModList_r11_Optional {
	bool d;
	SQN_CQI_ReportPeriodicProcExtToAddModList_r11 v;
};

struct SQN_CQI_ReportPeriodic_v1130 {
	struct SQN_CQI_ReportPeriodic_v1130_simultaneousAckNackAndCQI_Format3_r11_e_simultaneousAckNackAndCQI_Format3_r11_Optional simultaneousAckNackAndCQI_Format3_r11;
	struct SQN_CQI_ReportPeriodicProcExtToReleaseList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToReleaseList_r11_Optional cqi_ReportPeriodicProcExtToReleaseList_r11;
	struct SQN_CQI_ReportPeriodicProcExtToAddModList_r11_SQN_CQI_ReportPeriodic_v1130_cqi_ReportPeriodicProcExtToAddModList_r11_Optional cqi_ReportPeriodicProcExtToAddModList_r11;
};

typedef uint8_t SQN_CSI_IM_ConfigId_r11;

struct SQN_CSI_IM_ConfigId_r11_SQN_CSI_IM_ConfigToReleaseList_r11_Dynamic {
	size_t d;
	SQN_CSI_IM_ConfigId_r11* v;
};

typedef struct SQN_CSI_IM_ConfigId_r11_SQN_CSI_IM_ConfigToReleaseList_r11_Dynamic SQN_CSI_IM_ConfigToReleaseList_r11;

struct bool_SQN_CSI_IM_Config_r11_interferenceMeasRestriction_r13_Optional {
	bool d;
	bool v;
};

struct SQN_CSI_IM_Config_r11 {
	SQN_CSI_IM_ConfigId_r11 csi_IM_ConfigId_r11;
	uint8_t resourceConfig_r11;
	uint8_t subframeConfig_r11;
	struct bool_SQN_CSI_IM_Config_r11_interferenceMeasRestriction_r13_Optional interferenceMeasRestriction_r13;
};

struct SQN_CSI_IM_Config_r11_SQN_CSI_IM_ConfigToAddModList_r11_Dynamic {
	size_t d;
	struct SQN_CSI_IM_Config_r11* v;
};

typedef struct SQN_CSI_IM_Config_r11_SQN_CSI_IM_ConfigToAddModList_r11_Dynamic SQN_CSI_IM_ConfigToAddModList_r11;

typedef uint8_t SQN_CSI_ProcessId_r11;

struct SQN_CSI_ProcessId_r11_SQN_CSI_ProcessToReleaseList_r11_Dynamic {
	size_t d;
	SQN_CSI_ProcessId_r11* v;
};

typedef struct SQN_CSI_ProcessId_r11_SQN_CSI_ProcessToReleaseList_r11_Dynamic SQN_CSI_ProcessToReleaseList_r11;

typedef uint8_t SQN_CSI_RS_ConfigNZPId_r11;

struct SQN_P_C_AndCBSR_r11 {
	int8_t p_C_r11;
	BIT_STRING codebookSubsetRestriction_r11;
};

struct SQN_P_C_AndCBSR_r11_SQN_P_C_AndCBSR_Pair_r13a_Dynamic {
	size_t d;
	struct SQN_P_C_AndCBSR_r11* v;
};

typedef struct SQN_P_C_AndCBSR_r11_SQN_P_C_AndCBSR_Pair_r13a_Dynamic SQN_P_C_AndCBSR_Pair_r13a;

enum SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e {
	SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e_setup = 0,
};

typedef enum SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e;

struct SQN_CSI_ProcessId_r11_SQN_CQI_ReportBothProc_r11_ri_Ref_CSI_ProcessId_r11_Optional {
	bool d;
	SQN_CSI_ProcessId_r11 v;
};

struct SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e_pmi_RI_Report_r11_Optional {
	bool d;
	SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e v;
};

struct SQN_CQI_ReportBothProc_r11 {
	struct SQN_CSI_ProcessId_r11_SQN_CQI_ReportBothProc_r11_ri_Ref_CSI_ProcessId_r11_Optional ri_Ref_CSI_ProcessId_r11;
	struct SQN_CQI_ReportBothProc_r11_pmi_RI_Report_r11_e_pmi_RI_Report_r11_Optional pmi_RI_Report_r11;
};

struct SQN_CQI_ReportAperiodicProc_r11 {
	SQN_CQI_ReportModeAperiodic_e cqi_ReportModeAperiodic_r11;
	bool trigger01_r11;
	bool trigger10_r11;
	bool trigger11_r11;
};

enum SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e {
	SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e_true = 0,
};

typedef enum SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e;

typedef uint8_t SQN_CSI_IM_ConfigId_r12;

enum SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Sel {
	SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_UNBOUND_VALUE = 0,
	SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_release = 1,
	SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_setup = 2,
};

struct SQN_CSI_IM_ConfigId_r12_setup_Dynamic {
	size_t d;
	SQN_CSI_IM_ConfigId_r12* v;
};

union SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Value {
	Null release;
	struct SQN_CSI_IM_ConfigId_r12_setup_Dynamic setup;
};

struct SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12 {
	enum SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Sel d;
	union SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_Value v;
};

enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Sel {
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_UNBOUND_VALUE = 0,
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_release = 1,
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_setup = 2,
};

union SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Value {
	Null release;
	struct SQN_CQI_ReportAperiodicProc_r11 setup;
};

struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12 {
	enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Sel d;
	union SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_Value v;
};

struct SQN_CQI_ReportAperiodicProc_v1310 {
	bool trigger001_r13;
	bool trigger010_r13;
	bool trigger011_r13;
	bool trigger100_r13;
	bool trigger101_r13;
	bool trigger110_r13;
	bool trigger111_r13;
};

enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Sel {
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_UNBOUND_VALUE = 0,
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_release = 1,
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_setup = 2,
};

union SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Value {
	Null release;
	struct SQN_CQI_ReportAperiodicProc_v1310 setup;
};

struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310 {
	enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Sel d;
	union SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_Value v;
};

enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Sel {
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_UNBOUND_VALUE = 0,
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_release = 1,
	SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_setup = 2,
};

union SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Value {
	Null release;
	struct SQN_CQI_ReportAperiodicProc_v1310 setup;
};

struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310 {
	enum SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Sel d;
	union SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_Value v;
};

struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_nonPrecoded_r13 {
	BIT_STRING codebookSubsetRestriction1_r13;
	BIT_STRING codebookSubsetRestriction2_r13;
};

struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedK1a_r13 {
	BIT_STRING codebookSubsetRestriction3_r13;
};

struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedKN_r13 {
	BIT_STRING codebookSubsetRestriction_r13;
};

enum SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Sel {
	SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_UNBOUND_VALUE = 0,
	SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_nonPrecoded_r13 = 1,
	SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedK1a_r13 = 2,
	SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedKN_r13 = 3,
};

union SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Value {
	struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_nonPrecoded_r13 nonPrecoded_r13;
	struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedK1a_r13 beamformedK1a_r13;
	struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_beamformedKN_r13 beamformedKN_r13;
};

struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13 {
	enum SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Sel d;
	union SQN_P_C_AndCBSR_r13_cbsr_Selection_r13_Value v;
};

struct SQN_P_C_AndCBSR_r13 {
	int8_t p_C_r13;
	struct SQN_P_C_AndCBSR_r13_cbsr_Selection_r13 cbsr_Selection_r13;
};

struct SQN_P_C_AndCBSR_r13_SQN_P_C_AndCBSR_Pair_r13_Dynamic {
	size_t d;
	struct SQN_P_C_AndCBSR_r13* v;
};

typedef struct SQN_P_C_AndCBSR_r13_SQN_P_C_AndCBSR_Pair_r13_Dynamic SQN_P_C_AndCBSR_Pair_r13;

enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e {
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e_n1 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e_n2 = 1,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e_n3 = 2,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e_n4 = 3,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e_n8 = 4,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e;

enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e {
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e_n1 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e_n2 = 1,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e_n3 = 2,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e_n4 = 3,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e_n8 = 4,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e;

enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e {
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e_n4 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e_n8 = 1,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e;

enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e {
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e_n4 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e_n8 = 1,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e;

typedef uint8_t SQN_CSI_IM_ConfigId_r13;

typedef uint8_t SQN_ResourceConfig_r13;

typedef uint8_t SQN_NZP_TransmissionComb_r14;

enum SQN_NZP_FrequencyDensity_r14_e {
	SQN_NZP_FrequencyDensity_r14_e_d1 = 0,
	SQN_NZP_FrequencyDensity_r14_e_d2 = 1,
	SQN_NZP_FrequencyDensity_r14_e_d3 = 2,
};

typedef enum SQN_NZP_FrequencyDensity_r14_e SQN_NZP_FrequencyDensity_r14_e;

struct SQN_NZP_TransmissionComb_r14_SQN_NZP_ResourceConfig_r13_transmissionComb_r14_Optional {
	bool d;
	SQN_NZP_TransmissionComb_r14 v;
};

struct SQN_NZP_FrequencyDensity_r14_e_SQN_NZP_ResourceConfig_r13_frequencyDensity_r14_Optional {
	bool d;
	SQN_NZP_FrequencyDensity_r14_e v;
};

struct SQN_NZP_ResourceConfig_r13 {
	SQN_ResourceConfig_r13 resourceConfig_r13;
	struct SQN_NZP_TransmissionComb_r14_SQN_NZP_ResourceConfig_r13_transmissionComb_r14_Optional transmissionComb_r14;
	struct SQN_NZP_FrequencyDensity_r14_e_SQN_NZP_ResourceConfig_r13_frequencyDensity_r14_Optional frequencyDensity_r14;
};

enum SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e {
	SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e_cdm2 = 0,
	SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e_cdm4 = 1,
};

typedef enum SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e;

struct SQN_NZP_ResourceConfig_r13_SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_nzp_resourceConfigList_r13_Dynamic {
	size_t d;
	struct SQN_NZP_ResourceConfig_r13* v;
};

struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e_cdmType_r13_Optional {
	bool d;
	SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e v;
};

struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup {
	struct SQN_NZP_ResourceConfig_r13_SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_nzp_resourceConfigList_r13_Dynamic nzp_resourceConfigList_r13;
	struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup_cdmType_r13_e_cdmType_r13_Optional cdmType_r13;
};

enum SQN_CSI_RS_ConfigNZP_EMIMO_r13_Sel {
	SQN_CSI_RS_ConfigNZP_EMIMO_r13_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigNZP_EMIMO_r13_release = 1,
	SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup = 2,
};

union SQN_CSI_RS_ConfigNZP_EMIMO_r13_Value {
	Null release;
	struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_setup setup;
};

struct SQN_CSI_RS_ConfigNZP_EMIMO_r13 {
	enum SQN_CSI_RS_ConfigNZP_EMIMO_r13_Sel d;
	union SQN_CSI_RS_ConfigNZP_EMIMO_r13_Value v;
};

struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_p_C_AndCBSRList_r13_Optional {
	bool d;
	SQN_P_C_AndCBSR_Pair_r13 v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e_codebookOverSamplingRateConfig_O1_r13_Optional {
	bool d;
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e_codebookOverSamplingRateConfig_O2_r13_Optional {
	bool d;
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e v;
};

struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_IM_ConfigIdList_r13_Dynamic {
	size_t d;
	SQN_CSI_IM_ConfigId_r13* v;
};

struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_IM_ConfigIdList_r13_DynamicOptional {
	bool d;
	struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_IM_ConfigIdList_r13_Dynamic v;
};

struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_RS_ConfigNZP_EMIMO_r13_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_EMIMO_r13 v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_r13 {
	struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_p_C_AndCBSRList_r13_Optional p_C_AndCBSRList_r13;
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN1_r13_e codebookConfigN1_r13;
	SQN_CSI_RS_ConfigNonPrecoded_r13_codebookConfigN2_r13_e codebookConfigN2_r13;
	struct SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O1_r13_e_codebookOverSamplingRateConfig_O1_r13_Optional codebookOverSamplingRateConfig_O1_r13;
	struct SQN_CSI_RS_ConfigNonPrecoded_r13_codebookOverSamplingRateConfig_O2_r13_e_codebookOverSamplingRateConfig_O2_r13_Optional codebookOverSamplingRateConfig_O2_r13;
	uint8_t codebookConfig_r13;
	struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_IM_ConfigIdList_r13_DynamicOptional csi_IM_ConfigIdList_r13;
	struct SQN_CSI_RS_ConfigNZP_EMIMO_r13_SQN_CSI_RS_ConfigNonPrecoded_r13_csi_RS_ConfigNZP_EMIMO_r13_Optional csi_RS_ConfigNZP_EMIMO_r13;
};

typedef uint8_t SQN_CSI_RS_ConfigNZPId_r13;

enum SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e {
	SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e_true = 0,
};

typedef enum SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e;

enum SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e {
	SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e_on = 0,
};

typedef enum SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e;

struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_RS_ConfigNZPIdListExt_r13_Dynamic {
	size_t d;
	SQN_CSI_RS_ConfigNZPId_r13* v;
};

struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_RS_ConfigNZPIdListExt_r13_DynamicOptional {
	bool d;
	struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_RS_ConfigNZPIdListExt_r13_Dynamic v;
};

struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_IM_ConfigIdList_r13_Dynamic {
	size_t d;
	SQN_CSI_IM_ConfigId_r13* v;
};

struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_IM_ConfigIdList_r13_DynamicOptional {
	bool d;
	struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_IM_ConfigIdList_r13_Dynamic v;
};

struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r13_p_C_AndCBSR_PerResourceConfigList_r13_Dynamic {
	size_t d;
	SQN_P_C_AndCBSR_Pair_r13* v;
};

struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r13_p_C_AndCBSR_PerResourceConfigList_r13_DynamicOptional {
	bool d;
	struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r13_p_C_AndCBSR_PerResourceConfigList_r13_Dynamic v;
};

struct bool_SQN_CSI_RS_ConfigBeamformed_r13_ace_For4Tx_PerResourceConfigList_r13_Dynamic {
	size_t d;
	bool* v;
};

struct bool_SQN_CSI_RS_ConfigBeamformed_r13_ace_For4Tx_PerResourceConfigList_r13_DynamicOptional {
	bool d;
	struct bool_SQN_CSI_RS_ConfigBeamformed_r13_ace_For4Tx_PerResourceConfigList_r13_Dynamic v;
};

struct SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e_alternativeCodebookEnabledBeamformed_r13_Optional {
	bool d;
	SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e v;
};

struct SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e_channelMeasRestriction_r13_Optional {
	bool d;
	SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e v;
};

struct SQN_CSI_RS_ConfigBeamformed_r13 {
	struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_RS_ConfigNZPIdListExt_r13_DynamicOptional csi_RS_ConfigNZPIdListExt_r13;
	struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r13_csi_IM_ConfigIdList_r13_DynamicOptional csi_IM_ConfigIdList_r13;
	struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r13_p_C_AndCBSR_PerResourceConfigList_r13_DynamicOptional p_C_AndCBSR_PerResourceConfigList_r13;
	struct bool_SQN_CSI_RS_ConfigBeamformed_r13_ace_For4Tx_PerResourceConfigList_r13_DynamicOptional ace_For4Tx_PerResourceConfigList_r13;
	struct SQN_CSI_RS_ConfigBeamformed_r13_alternativeCodebookEnabledBeamformed_r13_e_alternativeCodebookEnabledBeamformed_r13_Optional alternativeCodebookEnabledBeamformed_r13;
	struct SQN_CSI_RS_ConfigBeamformed_r13_channelMeasRestriction_r13_e_channelMeasRestriction_r13_Optional channelMeasRestriction_r13;
};

enum SQN_CSI_RS_ConfigEMIMO_r13_setup_Sel {
	SQN_CSI_RS_ConfigEMIMO_r13_setup_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_r13_setup_nonPrecoded_r13 = 1,
	SQN_CSI_RS_ConfigEMIMO_r13_setup_beamformed_r13 = 2,
};

union SQN_CSI_RS_ConfigEMIMO_r13_setup_Value {
	struct SQN_CSI_RS_ConfigNonPrecoded_r13 nonPrecoded_r13;
	struct SQN_CSI_RS_ConfigBeamformed_r13 beamformed_r13;
};

struct SQN_CSI_RS_ConfigEMIMO_r13_setup {
	enum SQN_CSI_RS_ConfigEMIMO_r13_setup_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_r13_setup_Value v;
};

enum SQN_CSI_RS_ConfigEMIMO_r13_Sel {
	SQN_CSI_RS_ConfigEMIMO_r13_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_r13_release = 1,
	SQN_CSI_RS_ConfigEMIMO_r13_setup = 2,
};

union SQN_CSI_RS_ConfigEMIMO_r13_Value {
	Null release;
	struct SQN_CSI_RS_ConfigEMIMO_r13_setup setup;
};

struct SQN_CSI_RS_ConfigEMIMO_r13 {
	enum SQN_CSI_RS_ConfigEMIMO_r13_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_r13_Value v;
};

enum SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e {
	SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e_cdm8 = 0,
};

typedef enum SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e;

struct SQN_NZP_ResourceConfig_r13_SQN_CSI_RS_ConfigNZP_EMIMO_v1430_nzp_resourceConfigListExt_r14_Dynamic {
	size_t d;
	struct SQN_NZP_ResourceConfig_r13* v;
};

struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e_cdmType_v1430_Optional {
	bool d;
	SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e v;
};

struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430 {
	struct SQN_NZP_ResourceConfig_r13_SQN_CSI_RS_ConfigNZP_EMIMO_v1430_nzp_resourceConfigListExt_r14_Dynamic nzp_resourceConfigListExt_r14;
	struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_cdmType_v1430_e_cdmType_v1430_Optional cdmType_v1430;
};

enum SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e {
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e_n5 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e_n6 = 1,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e_n7 = 2,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e_n10 = 3,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e_n12 = 4,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e_n14 = 5,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e_n16 = 6,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e;

enum SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN2_v1430_e {
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN2_v1430_e_n5 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN2_v1430_e_n6 = 1,
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN2_v1430_e_n7 = 2,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN2_v1430_e SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN2_v1430_e;

struct SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_Config_NZP_v1430_transmissionComb_r14_Optional {
	bool d;
	SQN_NZP_TransmissionComb_r14 v;
};

struct SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_Config_NZP_v1430_frequencyDensity_r14_Optional {
	bool d;
	SQN_NZP_FrequencyDensity_r14_e v;
};

struct SQN_CSI_RS_Config_NZP_v1430 {
	struct SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_Config_NZP_v1430_transmissionComb_r14_Optional transmissionComb_r14;
	struct SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_Config_NZP_v1430_frequencyDensity_r14_Optional frequencyDensity_r14;
};

struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_SQN_CSI_RS_ConfigNonPrecoded_v1430_csi_RS_ConfigNZP_EMIMO_v1430_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430 v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_v1430 {
	struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_SQN_CSI_RS_ConfigNonPrecoded_v1430_csi_RS_ConfigNZP_EMIMO_v1430_Optional csi_RS_ConfigNZP_EMIMO_v1430;
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN1_v1430_e codebookConfigN1_v1430;
	SQN_CSI_RS_ConfigNonPrecoded_v1430_codebookConfigN2_v1430_e codebookConfigN2_v1430;
	struct SQN_CSI_RS_Config_NZP_v1430 nzp_ResourceConfigTM9_Original_v1430;
};

enum SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e {
	SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an1 = 0,
	SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an2 = 1,
	SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an4 = 2,
	SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e_an8 = 3,
};

typedef enum SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e;

enum SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e {
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n1 = 0,
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n2 = 1,
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_n4 = 2,
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e_spare1 = 3,
};

typedef enum SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e;

struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup {
	SQN_MBSFN_SubframeConfigList subframeConfigList;
};

enum SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Sel {
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_release = 1,
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup = 2,
};

union SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value {
	Null release;
	struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_setup setup;
};

struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11 {
	enum SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Sel d;
	union SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_Value v;
};

struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11 v;
};

struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11 {
	uint16_t qcl_ScramblingIdentity_r11;
	SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_crs_PortsCount_r11_e crs_PortsCount_r11;
	struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_mbsfn_SubframeConfigList_r11_mbsfn_SubframeConfigList_r11_Optional mbsfn_SubframeConfigList_r11;
};

typedef uint8_t SQN_CSI_RS_ConfigNZPId_v1310;

struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup {
	SQN_MBSFN_SubframeConfigList_v1430 subframeConfigList_v1430;
};

enum SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Sel {
	SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_release = 1,
	SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup = 2,
};

union SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value {
	Null release;
	struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_setup setup;
};

struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430 {
	enum SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Sel d;
	union SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_Value v;
};

struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11 v;
};

struct SQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional {
	bool d;
	SQN_CSI_RS_ConfigNZPId_v1310 v;
};

struct SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional {
	bool d;
	SQN_NZP_TransmissionComb_r14 v;
};

struct SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional {
	bool d;
	SQN_NZP_FrequencyDensity_r14_e v;
};

struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430 v;
};

struct SQN_CSI_RS_ConfigNZP_r11 {
	SQN_CSI_RS_ConfigNZPId_r11 csi_RS_ConfigNZPId_r11;
	SQN_CSI_RS_ConfigNZP_r11_antennaPortsCount_r11_e antennaPortsCount_r11;
	uint8_t resourceConfig_r11;
	uint8_t subframeConfig_r11;
	uint16_t scramblingIdentity_r11;
	struct SQN_CSI_RS_ConfigNZP_r11_qcl_CRS_Info_r11_qcl_CRS_Info_r11_Optional qcl_CRS_Info_r11;
	struct SQN_CSI_RS_ConfigNZPId_v1310_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZPId_v1310_Optional csi_RS_ConfigNZPId_v1310;
	struct SQN_NZP_TransmissionComb_r14_SQN_CSI_RS_ConfigNZP_r11_transmissionComb_r14_Optional transmissionComb_r14;
	struct SQN_NZP_FrequencyDensity_r14_e_SQN_CSI_RS_ConfigNZP_r11_frequencyDensity_r14_Optional frequencyDensity_r14;
	struct SQN_CSI_RS_ConfigNZP_r11_mbsfn_SubframeConfigList_v1430_mbsfn_SubframeConfigList_v1430_Optional mbsfn_SubframeConfigList_v1430;
};

enum SQN_CSI_RS_ConfigNZP_Activation_r14_csi_RS_NZP_mode_r14_e {
	SQN_CSI_RS_ConfigNZP_Activation_r14_csi_RS_NZP_mode_r14_e_semiPersistent = 0,
	SQN_CSI_RS_ConfigNZP_Activation_r14_csi_RS_NZP_mode_r14_e_aperiodic = 1,
};

typedef enum SQN_CSI_RS_ConfigNZP_Activation_r14_csi_RS_NZP_mode_r14_e SQN_CSI_RS_ConfigNZP_Activation_r14_csi_RS_NZP_mode_r14_e;

struct SQN_CSI_RS_ConfigNZP_Activation_r14 {
	SQN_CSI_RS_ConfigNZP_Activation_r14_csi_RS_NZP_mode_r14_e csi_RS_NZP_mode_r14;
	uint8_t activatedResources_r14;
};

struct SQN_CSI_RS_ConfigBeamformed_v1430_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZP_ApList_r14_Dynamic {
	size_t d;
	struct SQN_CSI_RS_ConfigNZP_r11* v;
};

struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_ConfigNZP_ApList_r14_DynamicOptional {
	bool d;
	struct SQN_CSI_RS_ConfigBeamformed_v1430_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZP_ApList_r14_Dynamic v;
};

struct SQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_v1430_nzp_ResourceConfigOriginal_v1430_Optional {
	bool d;
	struct SQN_CSI_RS_Config_NZP_v1430 v;
};

struct SQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_NZP_Activation_r14_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_Activation_r14 v;
};

struct SQN_CSI_RS_ConfigBeamformed_v1430 {
	struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_ConfigNZP_ApList_r14_DynamicOptional csi_RS_ConfigNZP_ApList_r14;
	struct SQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_v1430_nzp_ResourceConfigOriginal_v1430_Optional nzp_ResourceConfigOriginal_v1430;
	struct SQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_v1430_csi_RS_NZP_Activation_r14_Optional csi_RS_NZP_Activation_r14;
};

enum SQN_CSI_RS_ConfigEMIMO_v1430_setup_Sel {
	SQN_CSI_RS_ConfigEMIMO_v1430_setup_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_v1430_setup_nonPrecoded_v1430 = 1,
	SQN_CSI_RS_ConfigEMIMO_v1430_setup_beamformed_v1430 = 2,
};

union SQN_CSI_RS_ConfigEMIMO_v1430_setup_Value {
	struct SQN_CSI_RS_ConfigNonPrecoded_v1430 nonPrecoded_v1430;
	struct SQN_CSI_RS_ConfigBeamformed_v1430 beamformed_v1430;
};

struct SQN_CSI_RS_ConfigEMIMO_v1430_setup {
	enum SQN_CSI_RS_ConfigEMIMO_v1430_setup_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_v1430_setup_Value v;
};

enum SQN_CSI_RS_ConfigEMIMO_v1430_Sel {
	SQN_CSI_RS_ConfigEMIMO_v1430_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_v1430_release = 1,
	SQN_CSI_RS_ConfigEMIMO_v1430_setup = 2,
};

union SQN_CSI_RS_ConfigEMIMO_v1430_Value {
	Null release;
	struct SQN_CSI_RS_ConfigEMIMO_v1430_setup setup;
};

struct SQN_CSI_RS_ConfigEMIMO_v1430 {
	enum SQN_CSI_RS_ConfigEMIMO_v1430_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_v1430_Value v;
};

enum SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e {
	SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e_true = 0,
};

typedef enum SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e;

enum SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e {
	SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e_on = 0,
};

typedef enum SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e;

struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZPIdListExt_r14_Dynamic {
	size_t d;
	SQN_CSI_RS_ConfigNZPId_r13* v;
};

struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZPIdListExt_r14_DynamicOptional {
	bool d;
	struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZPIdListExt_r14_Dynamic v;
};

struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_IM_ConfigIdList_r14_Dynamic {
	size_t d;
	SQN_CSI_IM_ConfigId_r13* v;
};

struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_IM_ConfigIdList_r14_DynamicOptional {
	bool d;
	struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_IM_ConfigIdList_r14_Dynamic v;
};

struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r14_p_C_AndCBSR_PerResourceConfigList_r14_Dynamic {
	size_t d;
	SQN_P_C_AndCBSR_Pair_r13* v;
};

struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r14_p_C_AndCBSR_PerResourceConfigList_r14_DynamicOptional {
	bool d;
	struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r14_p_C_AndCBSR_PerResourceConfigList_r14_Dynamic v;
};

struct bool_SQN_CSI_RS_ConfigBeamformed_r14_ace_For4Tx_PerResourceConfigList_r14_Dynamic {
	size_t d;
	bool* v;
};

struct bool_SQN_CSI_RS_ConfigBeamformed_r14_ace_For4Tx_PerResourceConfigList_r14_DynamicOptional {
	bool d;
	struct bool_SQN_CSI_RS_ConfigBeamformed_r14_ace_For4Tx_PerResourceConfigList_r14_Dynamic v;
};

struct SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e_alternativeCodebookEnabledBeamformed_r14_Optional {
	bool d;
	SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e v;
};

struct SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e_channelMeasRestriction_r14_Optional {
	bool d;
	SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e v;
};

struct SQN_CSI_RS_ConfigBeamformed_r14_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZP_ApList_r14_Dynamic {
	size_t d;
	struct SQN_CSI_RS_ConfigNZP_r11* v;
};

struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZP_ApList_r14_DynamicOptional {
	bool d;
	struct SQN_CSI_RS_ConfigBeamformed_r14_SQN_CSI_RS_ConfigNZP_r11_csi_RS_ConfigNZP_ApList_r14_Dynamic v;
};

struct SQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_r14_nzp_ResourceConfigOriginal_v1430_Optional {
	bool d;
	struct SQN_CSI_RS_Config_NZP_v1430 v;
};

struct SQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_NZP_Activation_r14_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_Activation_r14 v;
};

struct SQN_CSI_RS_ConfigBeamformed_r14 {
	struct SQN_CSI_RS_ConfigNZPId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZPIdListExt_r14_DynamicOptional csi_RS_ConfigNZPIdListExt_r14;
	struct SQN_CSI_IM_ConfigId_r13_SQN_CSI_RS_ConfigBeamformed_r14_csi_IM_ConfigIdList_r14_DynamicOptional csi_IM_ConfigIdList_r14;
	struct SQN_P_C_AndCBSR_Pair_r13_SQN_CSI_RS_ConfigBeamformed_r14_p_C_AndCBSR_PerResourceConfigList_r14_DynamicOptional p_C_AndCBSR_PerResourceConfigList_r14;
	struct bool_SQN_CSI_RS_ConfigBeamformed_r14_ace_For4Tx_PerResourceConfigList_r14_DynamicOptional ace_For4Tx_PerResourceConfigList_r14;
	struct SQN_CSI_RS_ConfigBeamformed_r14_alternativeCodebookEnabledBeamformed_r14_e_alternativeCodebookEnabledBeamformed_r14_Optional alternativeCodebookEnabledBeamformed_r14;
	struct SQN_CSI_RS_ConfigBeamformed_r14_channelMeasRestriction_r14_e_channelMeasRestriction_r14_Optional channelMeasRestriction_r14;
	struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_ConfigNZP_ApList_r14_DynamicOptional csi_RS_ConfigNZP_ApList_r14;
	struct SQN_CSI_RS_Config_NZP_v1430_SQN_CSI_RS_ConfigBeamformed_r14_nzp_ResourceConfigOriginal_v1430_Optional nzp_ResourceConfigOriginal_v1430;
	struct SQN_CSI_RS_ConfigNZP_Activation_r14_SQN_CSI_RS_ConfigBeamformed_r14_csi_RS_NZP_Activation_r14_Optional csi_RS_NZP_Activation_r14;
};

enum SQN_CSI_RS_ConfigEMIMO2_r14_Sel {
	SQN_CSI_RS_ConfigEMIMO2_r14_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO2_r14_release = 1,
	SQN_CSI_RS_ConfigEMIMO2_r14_setup = 2,
};

union SQN_CSI_RS_ConfigEMIMO2_r14_Value {
	Null release;
	struct SQN_CSI_RS_ConfigBeamformed_r14 setup;
};

struct SQN_CSI_RS_ConfigEMIMO2_r14 {
	enum SQN_CSI_RS_ConfigEMIMO2_r14_Sel d;
	union SQN_CSI_RS_ConfigEMIMO2_r14_Value v;
};

struct uint16_t_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_periodicityOffsetIndex_r14_Optional {
	bool d;
	uint16_t v;
};

struct SQN_CSI_RS_ConfigEMIMO2_r14_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_eMIMO_Type2_r14_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigEMIMO2_r14 v;
};

struct SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup {
	struct uint16_t_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_periodicityOffsetIndex_r14_Optional periodicityOffsetIndex_r14;
	struct SQN_CSI_RS_ConfigEMIMO2_r14_SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup_eMIMO_Type2_r14_Optional eMIMO_Type2_r14;
};

enum SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_Sel {
	SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_release = 1,
	SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup = 2,
};

union SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_Value {
	Null release;
	struct SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_setup setup;
};

struct SQN_CSI_RS_ConfigEMIMO_Hybrid_r14 {
	enum SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_Value v;
};

enum SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e {
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_n5 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_n6 = 1,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_n7 = 2,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_n10 = 3,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_n12 = 4,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_n14 = 5,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_n16 = 6,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e;

enum SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e {
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e_n5 = 0,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e_n6 = 1,
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e_n7 = 2,
};

typedef enum SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e;

struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_SQN_CSI_RS_ConfigNonPrecoded_v1480_csi_RS_ConfigNZP_EMIMO_v1480_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430 v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_codebookConfigN1_v1480_Optional {
	bool d;
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e_codebookConfigN2_r1480_Optional {
	bool d;
	SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_v1480 {
	struct SQN_CSI_RS_ConfigNZP_EMIMO_v1430_SQN_CSI_RS_ConfigNonPrecoded_v1480_csi_RS_ConfigNZP_EMIMO_v1480_Optional csi_RS_ConfigNZP_EMIMO_v1480;
	struct SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN1_v1480_e_codebookConfigN1_v1480_Optional codebookConfigN1_v1480;
	struct SQN_CSI_RS_ConfigNonPrecoded_v1480_codebookConfigN2_r1480_e_codebookConfigN2_r1480_Optional codebookConfigN2_r1480;
	struct SQN_CSI_RS_Config_NZP_v1430 nzp_ResourceConfigTM9_Original_v1480;
};

enum SQN_CSI_RS_ConfigEMIMO_v1480_setup_Sel {
	SQN_CSI_RS_ConfigEMIMO_v1480_setup_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_v1480_setup_nonPrecoded_v1480 = 1,
	SQN_CSI_RS_ConfigEMIMO_v1480_setup_beamformed_v1480 = 2,
};

union SQN_CSI_RS_ConfigEMIMO_v1480_setup_Value {
	struct SQN_CSI_RS_ConfigNonPrecoded_v1480 nonPrecoded_v1480;
	struct SQN_CSI_RS_ConfigBeamformed_v1430 beamformed_v1480;
};

struct SQN_CSI_RS_ConfigEMIMO_v1480_setup {
	enum SQN_CSI_RS_ConfigEMIMO_v1480_setup_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_v1480_setup_Value v;
};

enum SQN_CSI_RS_ConfigEMIMO_v1480_Sel {
	SQN_CSI_RS_ConfigEMIMO_v1480_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_v1480_release = 1,
	SQN_CSI_RS_ConfigEMIMO_v1480_setup = 2,
};

union SQN_CSI_RS_ConfigEMIMO_v1480_Value {
	Null release;
	struct SQN_CSI_RS_ConfigEMIMO_v1480_setup setup;
};

struct SQN_CSI_RS_ConfigEMIMO_v1480 {
	enum SQN_CSI_RS_ConfigEMIMO_v1480_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_v1480_Value v;
};

struct SQN_P_C_AndCBSR_r15 {
	int8_t p_C_r15;
	BIT_STRING codebookSubsetRestriction4_r15;
};

struct SQN_P_C_AndCBSR_r15_SQN_P_C_AndCBSR_Pair_r15_Dynamic {
	size_t d;
	struct SQN_P_C_AndCBSR_r15* v;
};

typedef struct SQN_P_C_AndCBSR_r15_SQN_P_C_AndCBSR_Pair_r15_Dynamic SQN_P_C_AndCBSR_Pair_r15;

struct SQN_P_C_AndCBSR_Pair_r15_SQN_CSI_RS_ConfigNonPrecoded_v1530_p_C_AndCBSRList_r15_Optional {
	bool d;
	SQN_P_C_AndCBSR_Pair_r15 v;
};

struct SQN_CSI_RS_ConfigNonPrecoded_v1530 {
	struct SQN_P_C_AndCBSR_Pair_r15_SQN_CSI_RS_ConfigNonPrecoded_v1530_p_C_AndCBSRList_r15_Optional p_C_AndCBSRList_r15;
};

enum SQN_CSI_RS_ConfigEMIMO_v1530_setup_Sel {
	SQN_CSI_RS_ConfigEMIMO_v1530_setup_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_v1530_setup_nonPrecoded_v1530 = 1,
};

union SQN_CSI_RS_ConfigEMIMO_v1530_setup_Value {
	struct SQN_CSI_RS_ConfigNonPrecoded_v1530 nonPrecoded_v1530;
};

struct SQN_CSI_RS_ConfigEMIMO_v1530_setup {
	enum SQN_CSI_RS_ConfigEMIMO_v1530_setup_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_v1530_setup_Value v;
};

enum SQN_CSI_RS_ConfigEMIMO_v1530_Sel {
	SQN_CSI_RS_ConfigEMIMO_v1530_UNBOUND_VALUE = 0,
	SQN_CSI_RS_ConfigEMIMO_v1530_release = 1,
	SQN_CSI_RS_ConfigEMIMO_v1530_setup = 2,
};

union SQN_CSI_RS_ConfigEMIMO_v1530_Value {
	Null release;
	struct SQN_CSI_RS_ConfigEMIMO_v1530_setup setup;
};

struct SQN_CSI_RS_ConfigEMIMO_v1530 {
	enum SQN_CSI_RS_ConfigEMIMO_v1530_Sel d;
	union SQN_CSI_RS_ConfigEMIMO_v1530_Value v;
};

struct SQN_CQI_ReportBothProc_r11_SQN_CSI_Process_r11_cqi_ReportBothProc_r11_Optional {
	bool d;
	struct SQN_CQI_ReportBothProc_r11 v;
};

struct uint8_t_SQN_CSI_Process_r11_cqi_ReportPeriodicProcId_r11_Optional {
	bool d;
	uint8_t v;
};

struct SQN_CQI_ReportAperiodicProc_r11_SQN_CSI_Process_r11_cqi_ReportAperiodicProc_r11_Optional {
	bool d;
	struct SQN_CQI_ReportAperiodicProc_r11 v;
};

struct SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e_alternativeCodebookEnabledFor4TXProc_r12_Optional {
	bool d;
	SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e v;
};

struct SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_csi_IM_ConfigIdList_r12_Optional {
	bool d;
	struct SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12 v;
};

struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_cqi_ReportAperiodicProc2_r12_Optional {
	bool d;
	struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12 v;
};

struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_cqi_ReportAperiodicProc_v1310_Optional {
	bool d;
	struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310 v;
};

struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_cqi_ReportAperiodicProc2_v1310_Optional {
	bool d;
	struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310 v;
};

struct SQN_CSI_RS_ConfigEMIMO_r13_SQN_CSI_Process_r11_eMIMO_Type_r13_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigEMIMO_r13 v;
};

struct SQN_CSI_RS_ConfigEMIMO_v1430_SQN_CSI_Process_r11_dummy_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigEMIMO_v1430 v;
};

struct SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_SQN_CSI_Process_r11_eMIMO_Hybrid_r14_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigEMIMO_Hybrid_r14 v;
};

struct bool_SQN_CSI_Process_r11_advancedCodebookEnabled_r14_Optional {
	bool d;
	bool v;
};

struct SQN_CSI_RS_ConfigEMIMO_v1480_SQN_CSI_Process_r11_eMIMO_Type_v1480_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigEMIMO_v1480 v;
};

struct bool_SQN_CSI_Process_r11_feCOMP_CSI_Enabled_v1530_Optional {
	bool d;
	bool v;
};

struct SQN_CSI_RS_ConfigEMIMO_v1530_SQN_CSI_Process_r11_eMIMO_Type_v1530_Optional {
	bool d;
	struct SQN_CSI_RS_ConfigEMIMO_v1530 v;
};

struct SQN_CSI_Process_r11 {
	SQN_CSI_ProcessId_r11 csi_ProcessId_r11;
	SQN_CSI_RS_ConfigNZPId_r11 csi_RS_ConfigNZPId_r11;
	SQN_CSI_IM_ConfigId_r11 csi_IM_ConfigId_r11;
	SQN_P_C_AndCBSR_Pair_r13a p_C_AndCBSRList_r11;
	struct SQN_CQI_ReportBothProc_r11_SQN_CSI_Process_r11_cqi_ReportBothProc_r11_Optional cqi_ReportBothProc_r11;
	struct uint8_t_SQN_CSI_Process_r11_cqi_ReportPeriodicProcId_r11_Optional cqi_ReportPeriodicProcId_r11;
	struct SQN_CQI_ReportAperiodicProc_r11_SQN_CSI_Process_r11_cqi_ReportAperiodicProc_r11_Optional cqi_ReportAperiodicProc_r11;
	struct SQN_CSI_Process_r11_alternativeCodebookEnabledFor4TXProc_r12_e_alternativeCodebookEnabledFor4TXProc_r12_Optional alternativeCodebookEnabledFor4TXProc_r12;
	struct SQN_CSI_Process_r11_csi_IM_ConfigIdList_r12_csi_IM_ConfigIdList_r12_Optional csi_IM_ConfigIdList_r12;
	struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_r12_cqi_ReportAperiodicProc2_r12_Optional cqi_ReportAperiodicProc2_r12;
	struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc_v1310_cqi_ReportAperiodicProc_v1310_Optional cqi_ReportAperiodicProc_v1310;
	struct SQN_CSI_Process_r11_cqi_ReportAperiodicProc2_v1310_cqi_ReportAperiodicProc2_v1310_Optional cqi_ReportAperiodicProc2_v1310;
	struct SQN_CSI_RS_ConfigEMIMO_r13_SQN_CSI_Process_r11_eMIMO_Type_r13_Optional eMIMO_Type_r13;
	struct SQN_CSI_RS_ConfigEMIMO_v1430_SQN_CSI_Process_r11_dummy_Optional dummy;
	struct SQN_CSI_RS_ConfigEMIMO_Hybrid_r14_SQN_CSI_Process_r11_eMIMO_Hybrid_r14_Optional eMIMO_Hybrid_r14;
	struct bool_SQN_CSI_Process_r11_advancedCodebookEnabled_r14_Optional advancedCodebookEnabled_r14;
	struct SQN_CSI_RS_ConfigEMIMO_v1480_SQN_CSI_Process_r11_eMIMO_Type_v1480_Optional eMIMO_Type_v1480;
	struct bool_SQN_CSI_Process_r11_feCOMP_CSI_Enabled_v1530_Optional feCOMP_CSI_Enabled_v1530;
	struct SQN_CSI_RS_ConfigEMIMO_v1530_SQN_CSI_Process_r11_eMIMO_Type_v1530_Optional eMIMO_Type_v1530;
};

struct SQN_CSI_Process_r11_SQN_CSI_ProcessToAddModList_r11_Dynamic {
	size_t d;
	struct SQN_CSI_Process_r11* v;
};

typedef struct SQN_CSI_Process_r11_SQN_CSI_ProcessToAddModList_r11_Dynamic SQN_CSI_ProcessToAddModList_r11;

struct SQN_CSI_IM_ConfigToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToReleaseList_r11_Optional {
	bool d;
	SQN_CSI_IM_ConfigToReleaseList_r11 v;
};

struct SQN_CSI_IM_ConfigToAddModList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToAddModList_r11_Optional {
	bool d;
	SQN_CSI_IM_ConfigToAddModList_r11 v;
};

struct SQN_CSI_ProcessToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_ProcessToReleaseList_r11_Optional {
	bool d;
	SQN_CSI_ProcessToReleaseList_r11 v;
};

struct SQN_CSI_ProcessToAddModList_r11_SQN_CQI_ReportBoth_r11_csi_ProcessToAddModList_r11_Optional {
	bool d;
	SQN_CSI_ProcessToAddModList_r11 v;
};

struct SQN_CQI_ReportBoth_r11 {
	struct SQN_CSI_IM_ConfigToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToReleaseList_r11_Optional csi_IM_ConfigToReleaseList_r11;
	struct SQN_CSI_IM_ConfigToAddModList_r11_SQN_CQI_ReportBoth_r11_csi_IM_ConfigToAddModList_r11_Optional csi_IM_ConfigToAddModList_r11;
	struct SQN_CSI_ProcessToReleaseList_r11_SQN_CQI_ReportBoth_r11_csi_ProcessToReleaseList_r11_Optional csi_ProcessToReleaseList_r11;
	struct SQN_CSI_ProcessToAddModList_r11_SQN_CQI_ReportBoth_r11_csi_ProcessToAddModList_r11_Optional csi_ProcessToAddModList_r11;
};

struct SQN_CQI_ReportConfig_v1130 {
	struct SQN_CQI_ReportPeriodic_v1130 cqi_ReportPeriodic_v1130;
	struct SQN_CQI_ReportBoth_r11 cqi_ReportBoth_r11;
};

struct SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_setup {
	B10 csi_MeasSubframeSets_r12;
};

enum SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_Sel {
	SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_UNBOUND_VALUE = 0,
	SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_release = 1,
	SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_setup = 2,
};

union SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_Value {
	Null release;
	struct SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_setup setup;
};

struct SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12 {
	enum SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_Sel d;
	union SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_Value v;
};

typedef uint8_t SQN_CSI_IM_ConfigId_v1250;

typedef uint8_t SQN_CSI_IM_ConfigId_v1310;

struct bool_SQN_CSI_IM_ConfigExt_r12_interferenceMeasRestriction_r13_Optional {
	bool d;
	bool v;
};

struct SQN_CSI_IM_ConfigId_v1310_SQN_CSI_IM_ConfigExt_r12_csi_IM_ConfigId_v1310_Optional {
	bool d;
	SQN_CSI_IM_ConfigId_v1310 v;
};

struct SQN_CSI_IM_ConfigExt_r12 {
	SQN_CSI_IM_ConfigId_v1250 csi_IM_ConfigId_v1250;
	uint8_t resourceConfig_r12;
	uint8_t subframeConfig_r12;
	struct bool_SQN_CSI_IM_ConfigExt_r12_interferenceMeasRestriction_r13_Optional interferenceMeasRestriction_r13;
	struct SQN_CSI_IM_ConfigId_v1310_SQN_CSI_IM_ConfigExt_r12_csi_IM_ConfigId_v1310_Optional csi_IM_ConfigId_v1310;
};

struct SQN_CSI_IM_ConfigId_v1250_SQN_CQI_ReportBoth_v1250_csi_IM_ConfigToReleaseListExt_r12_Optional {
	bool d;
	SQN_CSI_IM_ConfigId_v1250 v;
};

struct SQN_CSI_IM_ConfigExt_r12_SQN_CQI_ReportBoth_v1250_csi_IM_ConfigToAddModListExt_r12_Optional {
	bool d;
	struct SQN_CSI_IM_ConfigExt_r12 v;
};

struct SQN_CQI_ReportBoth_v1250 {
	struct SQN_CSI_IM_ConfigId_v1250_SQN_CQI_ReportBoth_v1250_csi_IM_ConfigToReleaseListExt_r12_Optional csi_IM_ConfigToReleaseListExt_r12;
	struct SQN_CSI_IM_ConfigExt_r12_SQN_CQI_ReportBoth_v1250_csi_IM_ConfigToAddModListExt_r12_Optional csi_IM_ConfigToAddModListExt_r12;
};

enum SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250_trigger_SubframeSetIndicator_r12_e {
	SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250_trigger_SubframeSetIndicator_r12_e_s1 = 0,
	SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250_trigger_SubframeSetIndicator_r12_e_s2 = 1,
};

typedef enum SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250_trigger_SubframeSetIndicator_r12_e SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250_trigger_SubframeSetIndicator_r12_e;

struct SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250 {
	SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250_trigger_SubframeSetIndicator_r12_e trigger_SubframeSetIndicator_r12;
	B8 trigger1_SubframeSetIndicator_r12;
	B8 trigger2_SubframeSetIndicator_r12;
};

struct SQN_CQI_ReportAperiodic_v1250_setup {
	struct SQN_CQI_ReportAperiodic_v1250_setup_aperiodicCSI_Trigger_v1250 aperiodicCSI_Trigger_v1250;
};

enum SQN_CQI_ReportAperiodic_v1250_Sel {
	SQN_CQI_ReportAperiodic_v1250_UNBOUND_VALUE = 0,
	SQN_CQI_ReportAperiodic_v1250_release = 1,
	SQN_CQI_ReportAperiodic_v1250_setup = 2,
};

union SQN_CQI_ReportAperiodic_v1250_Value {
	Null release;
	struct SQN_CQI_ReportAperiodic_v1250_setup setup;
};

struct SQN_CQI_ReportAperiodic_v1250 {
	enum SQN_CQI_ReportAperiodic_v1250_Sel d;
	union SQN_CQI_ReportAperiodic_v1250_Value v;
};

enum SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e {
	SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e_allSubframes = 0,
	SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e_csi_SubframeSet1 = 1,
	SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e_csi_SubframeSet2 = 2,
	SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e_spare1 = 3,
};

typedef enum SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e;

struct SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_csi_SubframePatternConfig_r12_Optional {
	bool d;
	struct SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12 v;
};

struct SQN_CQI_ReportBoth_v1250_SQN_CQI_ReportConfig_v1250_cqi_ReportBoth_v1250_Optional {
	bool d;
	struct SQN_CQI_ReportBoth_v1250 v;
};

struct SQN_CQI_ReportAperiodic_v1250_SQN_CQI_ReportConfig_v1250_cqi_ReportAperiodic_v1250_Optional {
	bool d;
	struct SQN_CQI_ReportAperiodic_v1250 v;
};

struct SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e_altCQI_Table_r12_Optional {
	bool d;
	SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e v;
};

struct SQN_CQI_ReportConfig_v1250 {
	struct SQN_CQI_ReportConfig_v1250_csi_SubframePatternConfig_r12_csi_SubframePatternConfig_r12_Optional csi_SubframePatternConfig_r12;
	struct SQN_CQI_ReportBoth_v1250_SQN_CQI_ReportConfig_v1250_cqi_ReportBoth_v1250_Optional cqi_ReportBoth_v1250;
	struct SQN_CQI_ReportAperiodic_v1250_SQN_CQI_ReportConfig_v1250_cqi_ReportAperiodic_v1250_Optional cqi_ReportAperiodic_v1250;
	struct SQN_CQI_ReportConfig_v1250_altCQI_Table_r12_e_altCQI_Table_r12_Optional altCQI_Table_r12;
};

enum SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e {
	SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e_setup = 0,
};

typedef enum SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e;

enum SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e {
	SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e_setup = 0,
};

typedef enum SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e;

struct SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e_cqi_Mask_r9_Optional {
	bool d;
	SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e v;
};

struct SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional {
	bool d;
	SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e v;
};

struct SQN_CQI_ReportConfig_v920 {
	struct SQN_CQI_ReportConfig_v920_cqi_Mask_r9_e_cqi_Mask_r9_Optional cqi_Mask_r9;
	struct SQN_CQI_ReportConfig_v920_pmi_RI_Report_r9_e_pmi_RI_Report_r9_Optional pmi_RI_Report_r9;
};

enum SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e {
	SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an1 = 0,
	SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an2 = 1,
	SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an4 = 2,
	SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e_an8 = 3,
};

typedef enum SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e;

struct SQN_CSI_RS_Config_r10_csi_RS_r10_setup {
	SQN_CSI_RS_Config_r10_csi_RS_r10_setup_antennaPortsCount_r10_e antennaPortsCount_r10;
	uint8_t resourceConfig_r10;
	uint8_t subframeConfig_r10;
	int8_t p_C_r10;
};

enum SQN_CSI_RS_Config_r10_csi_RS_r10_Sel {
	SQN_CSI_RS_Config_r10_csi_RS_r10_UNBOUND_VALUE = 0,
	SQN_CSI_RS_Config_r10_csi_RS_r10_release = 1,
	SQN_CSI_RS_Config_r10_csi_RS_r10_setup = 2,
};

union SQN_CSI_RS_Config_r10_csi_RS_r10_Value {
	Null release;
	struct SQN_CSI_RS_Config_r10_csi_RS_r10_setup setup;
};

struct SQN_CSI_RS_Config_r10_csi_RS_r10 {
	enum SQN_CSI_RS_Config_r10_csi_RS_r10_Sel d;
	union SQN_CSI_RS_Config_r10_csi_RS_r10_Value v;
};

struct SQN_ZeroTxPowerCSI_RS_r12 {
	B16 zeroTxPowerResourceConfigList_r12;
	uint8_t zeroTxPowerSubframeConfig_r12;
};

enum SQN_ZeroTxPowerCSI_RS_Conf_r12_Sel {
	SQN_ZeroTxPowerCSI_RS_Conf_r12_UNBOUND_VALUE = 0,
	SQN_ZeroTxPowerCSI_RS_Conf_r12_release = 1,
	SQN_ZeroTxPowerCSI_RS_Conf_r12_setup = 2,
};

union SQN_ZeroTxPowerCSI_RS_Conf_r12_Value {
	Null release;
	struct SQN_ZeroTxPowerCSI_RS_r12 setup;
};

struct SQN_ZeroTxPowerCSI_RS_Conf_r12 {
	enum SQN_ZeroTxPowerCSI_RS_Conf_r12_Sel d;
	union SQN_ZeroTxPowerCSI_RS_Conf_r12_Value v;
};

struct SQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional {
	bool d;
	struct SQN_CSI_RS_Config_r10_csi_RS_r10 v;
};

struct SQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional {
	bool d;
	struct SQN_ZeroTxPowerCSI_RS_Conf_r12 v;
};

struct SQN_CSI_RS_Config_r10 {
	struct SQN_CSI_RS_Config_r10_csi_RS_r10_csi_RS_r10_Optional csi_RS_r10;
	struct SQN_ZeroTxPowerCSI_RS_Conf_r12_SQN_CSI_RS_Config_r10_zeroTxPowerCSI_RS_r10_Optional zeroTxPowerCSI_RS_r10;
};

struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigNZPToAddModList_r11_Dynamic {
	size_t d;
	struct SQN_CSI_RS_ConfigNZP_r11* v;
};

typedef struct SQN_CSI_RS_ConfigNZP_r11_SQN_CSI_RS_ConfigNZPToAddModList_r11_Dynamic SQN_CSI_RS_ConfigNZPToAddModList_r11;

struct SQN_CSI_RS_ConfigNZPId_r11_SQN_CSI_RS_ConfigNZPToReleaseList_r11_Dynamic {
	size_t d;
	SQN_CSI_RS_ConfigNZPId_r11* v;
};

typedef struct SQN_CSI_RS_ConfigNZPId_r11_SQN_CSI_RS_ConfigNZPToReleaseList_r11_Dynamic SQN_CSI_RS_ConfigNZPToReleaseList_r11;

typedef uint8_t SQN_CSI_RS_ConfigZPId_r11;

struct SQN_CSI_RS_ConfigZP_r11 {
	SQN_CSI_RS_ConfigZPId_r11 csi_RS_ConfigZPId_r11;
	B16 resourceConfigList_r11;
	uint8_t subframeConfig_r11;
};

struct SQN_CSI_RS_ConfigZP_r11_SQN_CSI_RS_ConfigZPToAddModList_r11_Dynamic {
	size_t d;
	struct SQN_CSI_RS_ConfigZP_r11* v;
};

typedef struct SQN_CSI_RS_ConfigZP_r11_SQN_CSI_RS_ConfigZPToAddModList_r11_Dynamic SQN_CSI_RS_ConfigZPToAddModList_r11;

struct SQN_CSI_RS_ConfigZPId_r11_SQN_CSI_RS_ConfigZPToReleaseList_r11_Dynamic {
	size_t d;
	SQN_CSI_RS_ConfigZPId_r11* v;
};

typedef struct SQN_CSI_RS_ConfigZPId_r11_SQN_CSI_RS_ConfigZPToReleaseList_r11_Dynamic SQN_CSI_RS_ConfigZPToReleaseList_r11;

enum SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e {
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n6 = 0,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n15 = 1,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n25 = 2,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n50 = 3,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n75 = 4,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_n100 = 5,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare10 = 6,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare9 = 7,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare8 = 8,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare7 = 9,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare6 = 10,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare5 = 11,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare4 = 12,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare3 = 13,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare2 = 14,
	SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e_spare1 = 15,
};

typedef enum SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e SQN_CarrierBandwidthEUTRA_dl_Bandwidth_e;

enum SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e {
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n6 = 0,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n15 = 1,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n25 = 2,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n50 = 3,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n75 = 4,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_n100 = 5,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare10 = 6,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare9 = 7,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare8 = 8,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare7 = 9,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare6 = 10,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare5 = 11,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare4 = 12,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare3 = 13,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare2 = 14,
	SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e_spare1 = 15,
};

typedef enum SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e SQN_CarrierBandwidthEUTRA_ul_Bandwidth_e;

enum SQN_CipheringAlgorithm_r12_e {
	SQN_CipheringAlgorithm_r12_e_eea0 = 0,
	SQN_CipheringAlgorithm_r12_e_eea1 = 1,
	SQN_CipheringAlgorithm_r12_e_eea2 = 2,
	SQN_CipheringAlgorithm_r12_e_eea3_v1130 = 3,
	SQN_CipheringAlgorithm_r12_e_spare4 = 4,
	SQN_CipheringAlgorithm_r12_e_spare3 = 5,
	SQN_CipheringAlgorithm_r12_e_spare2 = 6,
	SQN_CipheringAlgorithm_r12_e_spare1 = 7,
};

typedef enum SQN_CipheringAlgorithm_r12_e SQN_CipheringAlgorithm_r12_e;

struct SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_own_r10 {
	bool cif_Presence_r10;
};

typedef uint8_t SQN_ServCellIndex_r10;

struct SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_other_r10 {
	SQN_ServCellIndex_r10 schedulingCellId_r10;
	uint8_t pdsch_Start_r10;
};

enum SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_Sel {
	SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_UNBOUND_VALUE = 0,
	SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_own_r10 = 1,
	SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_other_r10 = 2,
};

union SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_Value {
	struct SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_own_r10 own_r10;
	struct SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_other_r10 other_r10;
};

struct SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10 {
	enum SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_Sel d;
	union SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10_Value v;
};

struct SQN_CrossCarrierSchedulingConfig_r10 {
	struct SQN_CrossCarrierSchedulingConfig_r10_schedulingCellInfo_r10 schedulingCellInfo_r10;
};

struct SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_own_r13 {
	bool cif_Presence_r13;
};

typedef uint8_t SQN_ServCellIndex_r13;

struct SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_other_r13 {
	SQN_ServCellIndex_r13 schedulingCellId_r13;
	uint8_t pdsch_Start_r13;
	uint8_t cif_InSchedulingCell_r13;
};

enum SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_Sel {
	SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_UNBOUND_VALUE = 0,
	SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_own_r13 = 1,
	SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_other_r13 = 2,
};

union SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_Value {
	struct SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_own_r13 own_r13;
	struct SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_other_r13 other_r13;
};

struct SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13 {
	enum SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_Sel d;
	union SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13_Value v;
};

struct SQN_CrossCarrierSchedulingConfig_r13 {
	struct SQN_CrossCarrierSchedulingConfig_r13_schedulingCellInfo_r13 schedulingCellInfo_r13;
};

enum SQN_T_Reordering_e {
	SQN_T_Reordering_e_ms0 = 0,
	SQN_T_Reordering_e_ms5 = 1,
	SQN_T_Reordering_e_ms10 = 2,
	SQN_T_Reordering_e_ms15 = 3,
	SQN_T_Reordering_e_ms20 = 4,
	SQN_T_Reordering_e_ms25 = 5,
	SQN_T_Reordering_e_ms30 = 6,
	SQN_T_Reordering_e_ms35 = 7,
	SQN_T_Reordering_e_ms40 = 8,
	SQN_T_Reordering_e_ms45 = 9,
	SQN_T_Reordering_e_ms50 = 10,
	SQN_T_Reordering_e_ms55 = 11,
	SQN_T_Reordering_e_ms60 = 12,
	SQN_T_Reordering_e_ms65 = 13,
	SQN_T_Reordering_e_ms70 = 14,
	SQN_T_Reordering_e_ms75 = 15,
	SQN_T_Reordering_e_ms80 = 16,
	SQN_T_Reordering_e_ms85 = 17,
	SQN_T_Reordering_e_ms90 = 18,
	SQN_T_Reordering_e_ms95 = 19,
	SQN_T_Reordering_e_ms100 = 20,
	SQN_T_Reordering_e_ms110 = 21,
	SQN_T_Reordering_e_ms120 = 22,
	SQN_T_Reordering_e_ms130 = 23,
	SQN_T_Reordering_e_ms140 = 24,
	SQN_T_Reordering_e_ms150 = 25,
	SQN_T_Reordering_e_ms160 = 26,
	SQN_T_Reordering_e_ms170 = 27,
	SQN_T_Reordering_e_ms180 = 28,
	SQN_T_Reordering_e_ms190 = 29,
	SQN_T_Reordering_e_ms200 = 30,
	SQN_T_Reordering_e_ms1600_v1310 = 31,
};

typedef enum SQN_T_Reordering_e SQN_T_Reordering_e;

enum SQN_T_StatusProhibit_e {
	SQN_T_StatusProhibit_e_ms0 = 0,
	SQN_T_StatusProhibit_e_ms5 = 1,
	SQN_T_StatusProhibit_e_ms10 = 2,
	SQN_T_StatusProhibit_e_ms15 = 3,
	SQN_T_StatusProhibit_e_ms20 = 4,
	SQN_T_StatusProhibit_e_ms25 = 5,
	SQN_T_StatusProhibit_e_ms30 = 6,
	SQN_T_StatusProhibit_e_ms35 = 7,
	SQN_T_StatusProhibit_e_ms40 = 8,
	SQN_T_StatusProhibit_e_ms45 = 9,
	SQN_T_StatusProhibit_e_ms50 = 10,
	SQN_T_StatusProhibit_e_ms55 = 11,
	SQN_T_StatusProhibit_e_ms60 = 12,
	SQN_T_StatusProhibit_e_ms65 = 13,
	SQN_T_StatusProhibit_e_ms70 = 14,
	SQN_T_StatusProhibit_e_ms75 = 15,
	SQN_T_StatusProhibit_e_ms80 = 16,
	SQN_T_StatusProhibit_e_ms85 = 17,
	SQN_T_StatusProhibit_e_ms90 = 18,
	SQN_T_StatusProhibit_e_ms95 = 19,
	SQN_T_StatusProhibit_e_ms100 = 20,
	SQN_T_StatusProhibit_e_ms105 = 21,
	SQN_T_StatusProhibit_e_ms110 = 22,
	SQN_T_StatusProhibit_e_ms115 = 23,
	SQN_T_StatusProhibit_e_ms120 = 24,
	SQN_T_StatusProhibit_e_ms125 = 25,
	SQN_T_StatusProhibit_e_ms130 = 26,
	SQN_T_StatusProhibit_e_ms135 = 27,
	SQN_T_StatusProhibit_e_ms140 = 28,
	SQN_T_StatusProhibit_e_ms145 = 29,
	SQN_T_StatusProhibit_e_ms150 = 30,
	SQN_T_StatusProhibit_e_ms155 = 31,
	SQN_T_StatusProhibit_e_ms160 = 32,
	SQN_T_StatusProhibit_e_ms165 = 33,
	SQN_T_StatusProhibit_e_ms170 = 34,
	SQN_T_StatusProhibit_e_ms175 = 35,
	SQN_T_StatusProhibit_e_ms180 = 36,
	SQN_T_StatusProhibit_e_ms185 = 37,
	SQN_T_StatusProhibit_e_ms190 = 38,
	SQN_T_StatusProhibit_e_ms195 = 39,
	SQN_T_StatusProhibit_e_ms200 = 40,
	SQN_T_StatusProhibit_e_ms205 = 41,
	SQN_T_StatusProhibit_e_ms210 = 42,
	SQN_T_StatusProhibit_e_ms215 = 43,
	SQN_T_StatusProhibit_e_ms220 = 44,
	SQN_T_StatusProhibit_e_ms225 = 45,
	SQN_T_StatusProhibit_e_ms230 = 46,
	SQN_T_StatusProhibit_e_ms235 = 47,
	SQN_T_StatusProhibit_e_ms240 = 48,
	SQN_T_StatusProhibit_e_ms245 = 49,
	SQN_T_StatusProhibit_e_ms250 = 50,
	SQN_T_StatusProhibit_e_ms300 = 51,
	SQN_T_StatusProhibit_e_ms350 = 52,
	SQN_T_StatusProhibit_e_ms400 = 53,
	SQN_T_StatusProhibit_e_ms450 = 54,
	SQN_T_StatusProhibit_e_ms500 = 55,
	SQN_T_StatusProhibit_e_ms800_v1310 = 56,
	SQN_T_StatusProhibit_e_ms1000_v1310 = 57,
	SQN_T_StatusProhibit_e_ms1200_v1310 = 58,
	SQN_T_StatusProhibit_e_ms1600_v1310 = 59,
	SQN_T_StatusProhibit_e_ms2000_v1310 = 60,
	SQN_T_StatusProhibit_e_ms2400_v1310 = 61,
	SQN_T_StatusProhibit_e_spare2 = 62,
	SQN_T_StatusProhibit_e_spare1 = 63,
};

typedef enum SQN_T_StatusProhibit_e SQN_T_StatusProhibit_e;

struct SQN_DL_AM_RLC {
	SQN_T_Reordering_e t_Reordering;
	SQN_T_StatusProhibit_e t_StatusProhibit;
};

enum SQN_SN_FieldLength_e {
	SQN_SN_FieldLength_e_size5 = 0,
	SQN_SN_FieldLength_e_size10 = 1,
};

typedef enum SQN_SN_FieldLength_e SQN_SN_FieldLength_e;

struct SQN_DL_UM_RLC {
	SQN_SN_FieldLength_e sn_FieldLength;
	SQN_T_Reordering_e t_Reordering;
};

enum SQN_DRX_Config_setup_onDurationTimer_e {
	SQN_DRX_Config_setup_onDurationTimer_e_psf1 = 0,
	SQN_DRX_Config_setup_onDurationTimer_e_psf2 = 1,
	SQN_DRX_Config_setup_onDurationTimer_e_psf3 = 2,
	SQN_DRX_Config_setup_onDurationTimer_e_psf4 = 3,
	SQN_DRX_Config_setup_onDurationTimer_e_psf5 = 4,
	SQN_DRX_Config_setup_onDurationTimer_e_psf6 = 5,
	SQN_DRX_Config_setup_onDurationTimer_e_psf8 = 6,
	SQN_DRX_Config_setup_onDurationTimer_e_psf10 = 7,
	SQN_DRX_Config_setup_onDurationTimer_e_psf20 = 8,
	SQN_DRX_Config_setup_onDurationTimer_e_psf30 = 9,
	SQN_DRX_Config_setup_onDurationTimer_e_psf40 = 10,
	SQN_DRX_Config_setup_onDurationTimer_e_psf50 = 11,
	SQN_DRX_Config_setup_onDurationTimer_e_psf60 = 12,
	SQN_DRX_Config_setup_onDurationTimer_e_psf80 = 13,
	SQN_DRX_Config_setup_onDurationTimer_e_psf100 = 14,
	SQN_DRX_Config_setup_onDurationTimer_e_psf200 = 15,
};

typedef enum SQN_DRX_Config_setup_onDurationTimer_e SQN_DRX_Config_setup_onDurationTimer_e;

enum SQN_DRX_Config_setup_drx_InactivityTimer_e {
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf1 = 0,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf2 = 1,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf3 = 2,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf4 = 3,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf5 = 4,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf6 = 5,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf8 = 6,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf10 = 7,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf20 = 8,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf30 = 9,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf40 = 10,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf50 = 11,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf60 = 12,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf80 = 13,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf100 = 14,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf200 = 15,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf300 = 16,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf500 = 17,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf750 = 18,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf1280 = 19,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf1920 = 20,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf2560 = 21,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_psf0_v1020 = 22,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare9 = 23,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare8 = 24,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare7 = 25,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare6 = 26,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare5 = 27,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare4 = 28,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare3 = 29,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare2 = 30,
	SQN_DRX_Config_setup_drx_InactivityTimer_e_spare1 = 31,
};

typedef enum SQN_DRX_Config_setup_drx_InactivityTimer_e SQN_DRX_Config_setup_drx_InactivityTimer_e;

enum SQN_DRX_Config_setup_drx_RetransmissionTimer_e {
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf1 = 0,
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf2 = 1,
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf4 = 2,
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf6 = 3,
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf8 = 4,
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf16 = 5,
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf24 = 6,
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e_psf33 = 7,
};

typedef enum SQN_DRX_Config_setup_drx_RetransmissionTimer_e SQN_DRX_Config_setup_drx_RetransmissionTimer_e;

enum SQN_DRX_Config_setup_longDRX_CycleStartOffset_Sel {
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_UNBOUND_VALUE = 0,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf10 = 1,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf20 = 2,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf32 = 3,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf40 = 4,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf64 = 5,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf80 = 6,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf128 = 7,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf160 = 8,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf256 = 9,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf320 = 10,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf512 = 11,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf640 = 12,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf1024 = 13,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf1280 = 14,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf2048 = 15,
	SQN_DRX_Config_setup_longDRX_CycleStartOffset_sf2560 = 16,
};

union SQN_DRX_Config_setup_longDRX_CycleStartOffset_Value {
	uint8_t sf10;
	uint8_t sf20;
	uint8_t sf32;
	uint8_t sf40;
	uint8_t sf64;
	uint8_t sf80;
	uint8_t sf128;
	uint8_t sf160;
	uint8_t sf256;
	uint16_t sf320;
	uint16_t sf512;
	uint16_t sf640;
	uint16_t sf1024;
	uint16_t sf1280;
	uint16_t sf2048;
	uint16_t sf2560;
};

struct SQN_DRX_Config_setup_longDRX_CycleStartOffset {
	enum SQN_DRX_Config_setup_longDRX_CycleStartOffset_Sel d;
	union SQN_DRX_Config_setup_longDRX_CycleStartOffset_Value v;
};

enum SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e {
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf2 = 0,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf5 = 1,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf8 = 2,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf10 = 3,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf16 = 4,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf20 = 5,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf32 = 6,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf40 = 7,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf64 = 8,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf80 = 9,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf128 = 10,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf160 = 11,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf256 = 12,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf320 = 13,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf512 = 14,
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e_sf640 = 15,
};

typedef enum SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e;

struct SQN_DRX_Config_setup_shortDRX {
	SQN_DRX_Config_setup_shortDRX_shortDRX_Cycle_e shortDRX_Cycle;
	uint8_t drxShortCycleTimer;
};

struct SQN_DRX_Config_setup_shortDRX_shortDRX_Optional {
	bool d;
	struct SQN_DRX_Config_setup_shortDRX v;
};

struct SQN_DRX_Config_setup {
	SQN_DRX_Config_setup_onDurationTimer_e onDurationTimer;
	SQN_DRX_Config_setup_drx_InactivityTimer_e drx_InactivityTimer;
	SQN_DRX_Config_setup_drx_RetransmissionTimer_e drx_RetransmissionTimer;
	struct SQN_DRX_Config_setup_longDRX_CycleStartOffset longDRX_CycleStartOffset;
	struct SQN_DRX_Config_setup_shortDRX_shortDRX_Optional shortDRX;
};

enum SQN_DRX_Config_Sel {
	SQN_DRX_Config_UNBOUND_VALUE = 0,
	SQN_DRX_Config_release = 1,
	SQN_DRX_Config_setup = 2,
};

union SQN_DRX_Config_Value {
	Null release;
	struct SQN_DRX_Config_setup setup;
};

struct SQN_DRX_Config {
	enum SQN_DRX_Config_Sel d;
	union SQN_DRX_Config_Value v;
};

enum SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e {
	SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e_sf10 = 0,
	SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e_sf20 = 1,
	SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e_sf40 = 2,
	SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e_sf80 = 3,
};

typedef enum SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e;

struct SQN_EIMTA_MainConfig_r12_setup {
	SQN_C_RNTI eimta_RNTI_r12;
	SQN_EIMTA_MainConfig_r12_setup_eimta_CommandPeriodicity_r12_e eimta_CommandPeriodicity_r12;
	B10 eimta_CommandSubframeSet_r12;
};

enum SQN_EIMTA_MainConfig_r12_Sel {
	SQN_EIMTA_MainConfig_r12_UNBOUND_VALUE = 0,
	SQN_EIMTA_MainConfig_r12_release = 1,
	SQN_EIMTA_MainConfig_r12_setup = 2,
};

union SQN_EIMTA_MainConfig_r12_Value {
	Null release;
	struct SQN_EIMTA_MainConfig_r12_setup setup;
};

struct SQN_EIMTA_MainConfig_r12 {
	enum SQN_EIMTA_MainConfig_r12_Sel d;
	union SQN_EIMTA_MainConfig_r12_Value v;
};

enum SQN_EIMTA_MainConfigServCell_r12_setup_eimta_HARQ_ReferenceConfig_r12_e {
	SQN_EIMTA_MainConfigServCell_r12_setup_eimta_HARQ_ReferenceConfig_r12_e_sa2 = 0,
	SQN_EIMTA_MainConfigServCell_r12_setup_eimta_HARQ_ReferenceConfig_r12_e_sa4 = 1,
	SQN_EIMTA_MainConfigServCell_r12_setup_eimta_HARQ_ReferenceConfig_r12_e_sa5 = 2,
};

typedef enum SQN_EIMTA_MainConfigServCell_r12_setup_eimta_HARQ_ReferenceConfig_r12_e SQN_EIMTA_MainConfigServCell_r12_setup_eimta_HARQ_ReferenceConfig_r12_e;

struct SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_setup {
	SQN_MBSFN_SubframeConfigList subframeConfigList_r12;
};

enum SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_Sel {
	SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_UNBOUND_VALUE = 0,
	SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_release = 1,
	SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_setup = 2,
};

union SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_Value {
	Null release;
	struct SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_setup setup;
};

struct SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250 {
	enum SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_Sel d;
	union SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250_Value v;
};

struct SQN_EIMTA_MainConfigServCell_r12_setup {
	uint8_t eimta_UL_DL_ConfigIndex_r12;
	SQN_EIMTA_MainConfigServCell_r12_setup_eimta_HARQ_ReferenceConfig_r12_e eimta_HARQ_ReferenceConfig_r12;
	struct SQN_EIMTA_MainConfigServCell_r12_setup_mbsfn_SubframeConfigList_v1250 mbsfn_SubframeConfigList_v1250;
};

enum SQN_EIMTA_MainConfigServCell_r12_Sel {
	SQN_EIMTA_MainConfigServCell_r12_UNBOUND_VALUE = 0,
	SQN_EIMTA_MainConfigServCell_r12_release = 1,
	SQN_EIMTA_MainConfigServCell_r12_setup = 2,
};

union SQN_EIMTA_MainConfigServCell_r12_Value {
	Null release;
	struct SQN_EIMTA_MainConfigServCell_r12_setup setup;
};

struct SQN_EIMTA_MainConfigServCell_r12 {
	enum SQN_EIMTA_MainConfigServCell_r12_Sel d;
	union SQN_EIMTA_MainConfigServCell_r12_Value v;
};

struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup {
	struct SQN_MeasSubframePattern_r10 subframePattern_r11;
};

enum SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Sel {
	SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_UNBOUND_VALUE = 0,
	SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_release = 1,
	SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup = 2,
};

union SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value {
	Null release;
	struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_setup setup;
};

struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11 {
	enum SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Sel d;
	union SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_Value v;
};

typedef uint8_t SQN_EPDCCH_SetConfigId_r11;

struct SQN_EPDCCH_SetConfigId_r11_SQN_EPDCCH_SetConfigToReleaseList_r11_Dynamic {
	size_t d;
	SQN_EPDCCH_SetConfigId_r11* v;
};

typedef struct SQN_EPDCCH_SetConfigId_r11_SQN_EPDCCH_SetConfigToReleaseList_r11_Dynamic SQN_EPDCCH_SetConfigToReleaseList_r11;

enum SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e {
	SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e_localised = 0,
	SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e_distributed = 1,
};

typedef enum SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e;

enum SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e {
	SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n2 = 0,
	SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n4 = 1,
	SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e_n8 = 2,
};

typedef enum SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e;

struct SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11 {
	SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11_numberPRB_Pairs_r11_e numberPRB_Pairs_r11;
	BIT_STRING resourceBlockAssignment_r11;
};

typedef uint8_t SQN_PDSCH_RE_MappingQCL_ConfigId_r11;

enum SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Sel {
	SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_UNBOUND_VALUE = 0,
	SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_release = 1,
	SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_setup = 2,
};

union SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value {
	Null release;
	SQN_CSI_RS_ConfigZPId_r11 setup;
};

struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12 {
	enum SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Sel d;
	union SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_Value v;
};

enum SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e {
	SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e_n6 = 0,
};

typedef enum SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e;

enum SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Sel {
	SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_UNBOUND_VALUE = 0,
	SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_release = 1,
	SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup = 2,
};

union SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value {
	Null release;
	SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_setup_e setup;
};

struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310 {
	enum SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Sel d;
	union SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_Value v;
};

enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf1 = 0,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf2 = 1,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf4 = 2,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf8 = 3,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf16 = 4,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e_sf32 = 5,
};

typedef enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e;

enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e_on = 0,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e_off = 1,
};

typedef enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e;

enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v1 = 0,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v1dot5 = 1,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v2 = 2,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v2dot5 = 3,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v4 = 4,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v5 = 5,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v8 = 6,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e_v10 = 7,
};

typedef enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e;

enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v1 = 0,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v2 = 1,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v4 = 2,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v5 = 3,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v8 = 4,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v10 = 5,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_v20 = 6,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e_spare1 = 7,
};

typedef enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e;

enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Sel {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_UNBOUND_VALUE = 0,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13 = 1,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13 = 2,
};

union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_fdd_r13_e fdd_r13;
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_tdd_r13_e tdd_r13;
};

struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13 {
	enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Sel d;
	union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13_Value v;
};

enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r1 = 0,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r2 = 1,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r4 = 2,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r8 = 3,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r16 = 4,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r32 = 5,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r64 = 6,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r128 = 7,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e_r256 = 8,
};

typedef enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e;

struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_csi_NumRepetitionCE_r13_e csi_NumRepetitionCE_r13;
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_pdsch_HoppingConfig_r13_e mpdcch_pdsch_HoppingConfig_r13;
	struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_StartSF_UESS_r13 mpdcch_StartSF_UESS_r13;
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup_mpdcch_NumRepetition_r13_e mpdcch_NumRepetition_r13;
	uint8_t mpdcch_Narrowband_r13;
};

enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Sel {
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_UNBOUND_VALUE = 0,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_release = 1,
	SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup = 2,
};

union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value {
	Null release;
	struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_setup setup;
};

struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13 {
	enum SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Sel d;
	union SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_Value v;
};

struct SQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional {
	bool d;
	SQN_PDSCH_RE_MappingQCL_ConfigId_r11 v;
};

struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional {
	bool d;
	struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12 v;
};

struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional {
	bool d;
	struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310 v;
};

struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional {
	bool d;
	struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13 v;
};

struct SQN_EPDCCH_SetConfig_r11 {
	SQN_EPDCCH_SetConfigId_r11 setConfigId_r11;
	SQN_EPDCCH_SetConfig_r11_transmissionType_r11_e transmissionType_r11;
	struct SQN_EPDCCH_SetConfig_r11_resourceBlockAssignment_r11 resourceBlockAssignment_r11;
	uint16_t dmrs_ScramblingSequenceInt_r11;
	uint16_t pucch_ResourceStartOffset_r11;
	struct SQN_PDSCH_RE_MappingQCL_ConfigId_r11_SQN_EPDCCH_SetConfig_r11_re_MappingQCL_ConfigId_r11_Optional re_MappingQCL_ConfigId_r11;
	struct SQN_EPDCCH_SetConfig_r11_csi_RS_ConfigZPId2_r12_csi_RS_ConfigZPId2_r12_Optional csi_RS_ConfigZPId2_r12;
	struct SQN_EPDCCH_SetConfig_r11_numberPRB_Pairs_v1310_numberPRB_Pairs_v1310_Optional numberPRB_Pairs_v1310;
	struct SQN_EPDCCH_SetConfig_r11_mpdcch_config_r13_mpdcch_config_r13_Optional mpdcch_config_r13;
};

struct SQN_EPDCCH_SetConfig_r11_SQN_EPDCCH_SetConfigToAddModList_r11_Dynamic {
	size_t d;
	struct SQN_EPDCCH_SetConfig_r11* v;
};

typedef struct SQN_EPDCCH_SetConfig_r11_SQN_EPDCCH_SetConfigToAddModList_r11_Dynamic SQN_EPDCCH_SetConfigToAddModList_r11;

struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional {
	bool d;
	struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11 v;
};

struct uint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional {
	bool d;
	uint8_t v;
};

struct SQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional {
	bool d;
	SQN_EPDCCH_SetConfigToReleaseList_r11 v;
};

struct SQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional {
	bool d;
	SQN_EPDCCH_SetConfigToAddModList_r11 v;
};

struct SQN_EPDCCH_Config_r11_config_r11_setup {
	struct SQN_EPDCCH_Config_r11_config_r11_setup_subframePatternConfig_r11_subframePatternConfig_r11_Optional subframePatternConfig_r11;
	struct uint8_t_SQN_EPDCCH_Config_r11_config_r11_setup_startSymbol_r11_Optional startSymbol_r11;
	struct SQN_EPDCCH_SetConfigToReleaseList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToReleaseList_r11_Optional setConfigToReleaseList_r11;
	struct SQN_EPDCCH_SetConfigToAddModList_r11_SQN_EPDCCH_Config_r11_config_r11_setup_setConfigToAddModList_r11_Optional setConfigToAddModList_r11;
};

enum SQN_EPDCCH_Config_r11_config_r11_Sel {
	SQN_EPDCCH_Config_r11_config_r11_UNBOUND_VALUE = 0,
	SQN_EPDCCH_Config_r11_config_r11_release = 1,
	SQN_EPDCCH_Config_r11_config_r11_setup = 2,
};

union SQN_EPDCCH_Config_r11_config_r11_Value {
	Null release;
	struct SQN_EPDCCH_Config_r11_config_r11_setup setup;
};

struct SQN_EPDCCH_Config_r11_config_r11 {
	enum SQN_EPDCCH_Config_r11_config_r11_Sel d;
	union SQN_EPDCCH_Config_r11_config_r11_Value v;
};

struct SQN_EPDCCH_Config_r11 {
	struct SQN_EPDCCH_Config_r11_config_r11 config_r11;
};

enum SQN_LAA_SCellConfiguration_r13_subframeStartPosition_r13_e {
	SQN_LAA_SCellConfiguration_r13_subframeStartPosition_r13_e_s0 = 0,
	SQN_LAA_SCellConfiguration_r13_subframeStartPosition_r13_e_s07 = 1,
};

typedef enum SQN_LAA_SCellConfiguration_r13_subframeStartPosition_r13_e SQN_LAA_SCellConfiguration_r13_subframeStartPosition_r13_e;

struct SQN_LAA_SCellConfiguration_r13 {
	SQN_LAA_SCellConfiguration_r13_subframeStartPosition_r13_e subframeStartPosition_r13;
	B8 laa_SCellSubframeConfig_r13;
};

struct SQN_CrossCarrierSchedulingConfigLAA_UL_r14 {
	SQN_ServCellIndex_r13 schedulingCellId_r14;
	uint8_t cif_InSchedulingCell_r14;
};

struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup {
	struct SQN_CrossCarrierSchedulingConfigLAA_UL_r14 crossCarrierSchedulingConfigLAA_UL_r14;
};

enum SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Sel {
	SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_UNBOUND_VALUE = 0,
	SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_release = 1,
	SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup = 2,
};

union SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Value {
	Null release;
	struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_setup setup;
};

struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14 {
	enum SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Sel d;
	union SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_Value v;
};

enum SQN_LBT_Config_r14_Sel {
	SQN_LBT_Config_r14_UNBOUND_VALUE = 0,
	SQN_LBT_Config_r14_maxEnergyDetectionThreshold_r14 = 1,
	SQN_LBT_Config_r14_energyDetectionThresholdOffset_r14 = 2,
};

union SQN_LBT_Config_r14_Value {
	int8_t maxEnergyDetectionThreshold_r14;
	int8_t energyDetectionThresholdOffset_r14;
};

struct SQN_LBT_Config_r14 {
	enum SQN_LBT_Config_r14_Sel d;
	union SQN_LBT_Config_r14_Value v;
};

enum SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e {
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_sf2 = 0,
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_sf3 = 1,
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_sf4 = 2,
};

typedef enum SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e;

enum SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e {
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_sf2 = 0,
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_sf3 = 1,
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_sf4 = 2,
};

typedef enum SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e;

enum SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e {
	SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e_true = 0,
};

typedef enum SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e;

enum SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e {
	SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e_true = 0,
};

typedef enum SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e;

enum SQN_PDCCH_CandidateReductionValue_r13_e {
	SQN_PDCCH_CandidateReductionValue_r13_e_n0 = 0,
	SQN_PDCCH_CandidateReductionValue_r13_e_n33 = 1,
	SQN_PDCCH_CandidateReductionValue_r13_e_n66 = 2,
	SQN_PDCCH_CandidateReductionValue_r13_e_n100 = 3,
};

typedef enum SQN_PDCCH_CandidateReductionValue_r13_e SQN_PDCCH_CandidateReductionValue_r13_e;

struct SQN_PDCCH_CandidateReductions_r13_setup {
	SQN_PDCCH_CandidateReductionValue_r13_e pdcch_candidateReductionAL1_r13;
	SQN_PDCCH_CandidateReductionValue_r13_e pdcch_candidateReductionAL2_r13;
	SQN_PDCCH_CandidateReductionValue_r13_e pdcch_candidateReductionAL3_r13;
	SQN_PDCCH_CandidateReductionValue_r13_e pdcch_candidateReductionAL4_r13;
	SQN_PDCCH_CandidateReductionValue_r13_e pdcch_candidateReductionAL5_r13;
};

enum SQN_PDCCH_CandidateReductions_r13_Sel {
	SQN_PDCCH_CandidateReductions_r13_UNBOUND_VALUE = 0,
	SQN_PDCCH_CandidateReductions_r13_release = 1,
	SQN_PDCCH_CandidateReductions_r13_setup = 2,
};

union SQN_PDCCH_CandidateReductions_r13_Value {
	Null release;
	struct SQN_PDCCH_CandidateReductions_r13_setup setup;
};

struct SQN_PDCCH_CandidateReductions_r13 {
	enum SQN_PDCCH_CandidateReductions_r13_Sel d;
	union SQN_PDCCH_CandidateReductions_r13_Value v;
};

enum SQN_PDCCH_CandidateReductionValue_r14_e {
	SQN_PDCCH_CandidateReductionValue_r14_e_n0 = 0,
	SQN_PDCCH_CandidateReductionValue_r14_e_n50 = 1,
	SQN_PDCCH_CandidateReductionValue_r14_e_n100 = 2,
	SQN_PDCCH_CandidateReductionValue_r14_e_n150 = 3,
};

typedef enum SQN_PDCCH_CandidateReductionValue_r14_e SQN_PDCCH_CandidateReductionValue_r14_e;

struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_setup {
	SQN_PDCCH_CandidateReductionValue_r13_e pdcch_candidateReductionAL1_r14;
	SQN_PDCCH_CandidateReductionValue_r13_e pdcch_candidateReductionAL2_r14;
	SQN_PDCCH_CandidateReductionValue_r14_e pdcch_candidateReductionAL3_r14;
	SQN_PDCCH_CandidateReductionValue_r14_e pdcch_candidateReductionAL4_r14;
	SQN_PDCCH_CandidateReductionValue_r14_e pdcch_candidateReductionAL5_r14;
};

enum SQN_PDCCH_CandidateReductionsLAA_UL_r14_Sel {
	SQN_PDCCH_CandidateReductionsLAA_UL_r14_UNBOUND_VALUE = 0,
	SQN_PDCCH_CandidateReductionsLAA_UL_r14_release = 1,
	SQN_PDCCH_CandidateReductionsLAA_UL_r14_setup = 2,
};

union SQN_PDCCH_CandidateReductionsLAA_UL_r14_Value {
	Null release;
	struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_setup setup;
};

struct SQN_PDCCH_CandidateReductionsLAA_UL_r14 {
	enum SQN_PDCCH_CandidateReductionsLAA_UL_r14_Sel d;
	union SQN_PDCCH_CandidateReductionsLAA_UL_r14_Value v;
};

struct SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_maxNumberOfSchedSubframes_Format0B_r14_Optional {
	bool d;
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e v;
};

struct SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_maxNumberOfSchedSubframes_Format4B_r14_Optional {
	bool d;
	SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e v;
};

struct SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e_skipMonitoringDCI_Format0A_r14_Optional {
	bool d;
	SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e v;
};

struct SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e_skipMonitoringDCI_Format4A_r14_Optional {
	bool d;
	SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e v;
};

struct SQN_PDCCH_CandidateReductions_r13_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0A_r14_Optional {
	bool d;
	struct SQN_PDCCH_CandidateReductions_r13 v;
};

struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4A_r14_Optional {
	bool d;
	struct SQN_PDCCH_CandidateReductionsLAA_UL_r14 v;
};

struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0B_r14_Optional {
	bool d;
	struct SQN_PDCCH_CandidateReductionsLAA_UL_r14 v;
};

struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4B_r14_Optional {
	bool d;
	struct SQN_PDCCH_CandidateReductionsLAA_UL_r14 v;
};

struct SQN_PDCCH_ConfigLAA_r14 {
	struct SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format0B_r14_e_maxNumberOfSchedSubframes_Format0B_r14_Optional maxNumberOfSchedSubframes_Format0B_r14;
	struct SQN_PDCCH_ConfigLAA_r14_maxNumberOfSchedSubframes_Format4B_r14_e_maxNumberOfSchedSubframes_Format4B_r14_Optional maxNumberOfSchedSubframes_Format4B_r14;
	struct SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format0A_r14_e_skipMonitoringDCI_Format0A_r14_Optional skipMonitoringDCI_Format0A_r14;
	struct SQN_PDCCH_ConfigLAA_r14_skipMonitoringDCI_Format4A_r14_e_skipMonitoringDCI_Format4A_r14_Optional skipMonitoringDCI_Format4A_r14;
	struct SQN_PDCCH_CandidateReductions_r13_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0A_r14_Optional pdcch_CandidateReductions_Format0A_r14;
	struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4A_r14_Optional pdcch_CandidateReductions_Format4A_r14;
	struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format0B_r14_Optional pdcch_CandidateReductions_Format0B_r14;
	struct SQN_PDCCH_CandidateReductionsLAA_UL_r14_SQN_PDCCH_ConfigLAA_r14_pdcch_CandidateReductions_Format4B_r14_Optional pdcch_CandidateReductions_Format4B_r14;
};

enum SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e {
	SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e_true = 0,
};

typedef enum SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e;

struct uint8_t_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup_srs_SubframeIndication_r14_Optional {
	bool d;
	uint8_t v;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup {
	struct uint8_t_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup_srs_SubframeIndication_r14_Optional srs_SubframeIndication_r14;
};

enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Sel {
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_UNBOUND_VALUE = 0,
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_release = 1,
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup = 2,
};

union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Value {
	Null release;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_setup setup;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430 {
	enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Sel d;
	union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_Value v;
};

struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_crossCarrierSchedulingConfig_UL_r14_Optional {
	bool d;
	struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14 v;
};

struct SQN_LBT_Config_r14_SQN_LAA_SCellConfiguration_v1430_lbt_Config_r14_Optional {
	bool d;
	struct SQN_LBT_Config_r14 v;
};

struct SQN_PDCCH_ConfigLAA_r14_SQN_LAA_SCellConfiguration_v1430_pdcch_ConfigLAA_r14_Optional {
	bool d;
	struct SQN_PDCCH_ConfigLAA_r14 v;
};

struct SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e_absenceOfAnyOtherTechnology_r14_Optional {
	bool d;
	SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e v;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_SQN_LAA_SCellConfiguration_v1430_soundingRS_UL_ConfigDedicatedAperiodic_v1430_Optional {
	bool d;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430 v;
};

struct SQN_LAA_SCellConfiguration_v1430 {
	struct SQN_LAA_SCellConfiguration_v1430_crossCarrierSchedulingConfig_UL_r14_crossCarrierSchedulingConfig_UL_r14_Optional crossCarrierSchedulingConfig_UL_r14;
	struct SQN_LBT_Config_r14_SQN_LAA_SCellConfiguration_v1430_lbt_Config_r14_Optional lbt_Config_r14;
	struct SQN_PDCCH_ConfigLAA_r14_SQN_LAA_SCellConfiguration_v1430_pdcch_ConfigLAA_r14_Optional pdcch_ConfigLAA_r14;
	struct SQN_LAA_SCellConfiguration_v1430_absenceOfAnyOtherTechnology_r14_e_absenceOfAnyOtherTechnology_r14_Optional absenceOfAnyOtherTechnology_r14;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_v1430_SQN_LAA_SCellConfiguration_v1430_soundingRS_UL_ConfigDedicatedAperiodic_v1430_Optional soundingRS_UL_ConfigDedicatedAperiodic_v1430;
};

enum SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e {
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps0 = 0,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps8 = 1,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps16 = 2,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps32 = 3,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps64 = 4,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps128 = 5,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps256 = 6,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_infinity = 7,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps512_v1020 = 8,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps1024_v1020 = 9,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_kBps2048_v1020 = 10,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_spare5 = 11,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_spare4 = 12,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_spare3 = 13,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_spare2 = 14,
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e_spare1 = 15,
};

typedef enum SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e;

enum SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e {
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_ms50 = 0,
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_ms100 = 1,
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_ms150 = 2,
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_ms300 = 3,
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_ms500 = 4,
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_ms1000 = 5,
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_spare2 = 6,
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e_spare1 = 7,
};

typedef enum SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e;

struct uint8_t_SQN_LogicalChannelConfig_ul_SpecificParameters_logicalChannelGroup_Optional {
	bool d;
	uint8_t v;
};

struct SQN_LogicalChannelConfig_ul_SpecificParameters {
	uint8_t priority;
	SQN_LogicalChannelConfig_ul_SpecificParameters_prioritisedBitRate_e prioritisedBitRate;
	SQN_LogicalChannelConfig_ul_SpecificParameters_bucketSizeDuration_e bucketSizeDuration;
	struct uint8_t_SQN_LogicalChannelConfig_ul_SpecificParameters_logicalChannelGroup_Optional logicalChannelGroup;
};

enum SQN_LogicalChannelConfig_logicalChannelSR_Mask_r9_e {
	SQN_LogicalChannelConfig_logicalChannelSR_Mask_r9_e_setup = 0,
};

typedef enum SQN_LogicalChannelConfig_logicalChannelSR_Mask_r9_e SQN_LogicalChannelConfig_logicalChannelSR_Mask_r9_e;

enum SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e {
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s0 = 0,
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s0dot4 = 1,
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s0dot8 = 2,
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s1dot6 = 3,
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s3 = 4,
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s6 = 5,
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s12 = 6,
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_s30 = 7,
};

typedef enum SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e;

struct SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_setup {
	bool shortTTI_r15;
	bool subframeTTI_r15;
};

enum SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_Sel {
	SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_UNBOUND_VALUE = 0,
	SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_release = 1,
	SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_setup = 2,
};

union SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_Value {
	Null release;
	struct SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_setup setup;
};

struct SQN_LogicalChannelConfig_allowedTTI_Lengths_r15 {
	enum SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_Sel d;
	union SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_Value v;
};

enum SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_setup_e {
	SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_setup_e_spucch = 0,
	SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_setup_e_pucch = 1,
};

typedef enum SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_setup_e SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_setup_e;

enum SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_Sel {
	SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_UNBOUND_VALUE = 0,
	SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_release = 1,
	SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_setup = 2,
};

union SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_Value {
	Null release;
	SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_setup_e setup;
};

struct SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15 {
	enum SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_Sel d;
	union SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_Value v;
};

enum SQN_LogicalChannelConfig_channelAccessPriority_r15_Sel {
	SQN_LogicalChannelConfig_channelAccessPriority_r15_UNBOUND_VALUE = 0,
	SQN_LogicalChannelConfig_channelAccessPriority_r15_release = 1,
	SQN_LogicalChannelConfig_channelAccessPriority_r15_setup = 2,
};

union SQN_LogicalChannelConfig_channelAccessPriority_r15_Value {
	Null release;
	uint8_t setup;
};

struct SQN_LogicalChannelConfig_channelAccessPriority_r15 {
	enum SQN_LogicalChannelConfig_channelAccessPriority_r15_Sel d;
	union SQN_LogicalChannelConfig_channelAccessPriority_r15_Value v;
};

enum SQN_LogicalChannelConfig_bitRateMultiplier_r16_e {
	SQN_LogicalChannelConfig_bitRateMultiplier_r16_e_x40 = 0,
	SQN_LogicalChannelConfig_bitRateMultiplier_r16_e_x70 = 1,
	SQN_LogicalChannelConfig_bitRateMultiplier_r16_e_x100 = 2,
	SQN_LogicalChannelConfig_bitRateMultiplier_r16_e_x200 = 3,
};

typedef enum SQN_LogicalChannelConfig_bitRateMultiplier_r16_e SQN_LogicalChannelConfig_bitRateMultiplier_r16_e;

struct SQN_LogicalChannelConfig_ul_SpecificParameters_ul_SpecificParameters_Optional {
	bool d;
	struct SQN_LogicalChannelConfig_ul_SpecificParameters v;
};

struct SQN_LogicalChannelConfig_logicalChannelSR_Mask_r9_e_logicalChannelSR_Mask_r9_Optional {
	bool d;
	SQN_LogicalChannelConfig_logicalChannelSR_Mask_r9_e v;
};

struct bool_SQN_LogicalChannelConfig_logicalChannelSR_Prohibit_r12_Optional {
	bool d;
	bool v;
};

struct bool_SQN_LogicalChannelConfig_laa_UL_Allowed_r14_Optional {
	bool d;
	bool v;
};

struct SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_bitRateQueryProhibitTimer_r14_Optional {
	bool d;
	SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e v;
};

struct SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_allowedTTI_Lengths_r15_Optional {
	bool d;
	struct SQN_LogicalChannelConfig_allowedTTI_Lengths_r15 v;
};

struct SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_logicalChannelSR_Restriction_r15_Optional {
	bool d;
	struct SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15 v;
};

struct SQN_LogicalChannelConfig_channelAccessPriority_r15_channelAccessPriority_r15_Optional {
	bool d;
	struct SQN_LogicalChannelConfig_channelAccessPriority_r15 v;
};

struct B32_SQN_LogicalChannelConfig_lch_CellRestriction_r15_Optional {
	bool d;
	B32 v;
};

struct SQN_LogicalChannelConfig_bitRateMultiplier_r16_e_bitRateMultiplier_r16_Optional {
	bool d;
	SQN_LogicalChannelConfig_bitRateMultiplier_r16_e v;
};

struct SQN_LogicalChannelConfig {
	struct SQN_LogicalChannelConfig_ul_SpecificParameters_ul_SpecificParameters_Optional ul_SpecificParameters;
	struct SQN_LogicalChannelConfig_logicalChannelSR_Mask_r9_e_logicalChannelSR_Mask_r9_Optional logicalChannelSR_Mask_r9;
	struct bool_SQN_LogicalChannelConfig_logicalChannelSR_Prohibit_r12_Optional logicalChannelSR_Prohibit_r12;
	struct bool_SQN_LogicalChannelConfig_laa_UL_Allowed_r14_Optional laa_UL_Allowed_r14;
	struct SQN_LogicalChannelConfig_bitRateQueryProhibitTimer_r14_e_bitRateQueryProhibitTimer_r14_Optional bitRateQueryProhibitTimer_r14;
	struct SQN_LogicalChannelConfig_allowedTTI_Lengths_r15_allowedTTI_Lengths_r15_Optional allowedTTI_Lengths_r15;
	struct SQN_LogicalChannelConfig_logicalChannelSR_Restriction_r15_logicalChannelSR_Restriction_r15_Optional logicalChannelSR_Restriction_r15;
	struct SQN_LogicalChannelConfig_channelAccessPriority_r15_channelAccessPriority_r15_Optional channelAccessPriority_r15;
	struct B32_SQN_LogicalChannelConfig_lch_CellRestriction_r15_Optional lch_CellRestriction_r15;
	struct SQN_LogicalChannelConfig_bitRateMultiplier_r16_e_bitRateMultiplier_r16_Optional bitRateMultiplier_r16;
};

enum SQN_DRX_Config_r13_onDurationTimer_v1310_e {
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf300 = 0,
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf400 = 1,
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf500 = 2,
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf600 = 3,
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf800 = 4,
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf1000 = 5,
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf1200 = 6,
	SQN_DRX_Config_r13_onDurationTimer_v1310_e_psf1600 = 7,
};

typedef enum SQN_DRX_Config_r13_onDurationTimer_v1310_e SQN_DRX_Config_r13_onDurationTimer_v1310_e;

enum SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e {
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf40 = 0,
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf64 = 1,
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf80 = 2,
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf96 = 3,
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf112 = 4,
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf128 = 5,
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf160 = 6,
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_psf320 = 7,
};

typedef enum SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e;

enum SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e {
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf0 = 0,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf1 = 1,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf2 = 2,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf4 = 3,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf6 = 4,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf8 = 5,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf16 = 6,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf24 = 7,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf33 = 8,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf40 = 9,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf64 = 10,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf80 = 11,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf96 = 12,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf112 = 13,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf128 = 14,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf160 = 15,
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_psf320 = 16,
};

typedef enum SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e;

struct SQN_DRX_Config_r13_onDurationTimer_v1310_e_onDurationTimer_v1310_Optional {
	bool d;
	SQN_DRX_Config_r13_onDurationTimer_v1310_e v;
};

struct SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_drx_RetransmissionTimer_v1310_Optional {
	bool d;
	SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e v;
};

struct SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_drx_ULRetransmissionTimer_r13_Optional {
	bool d;
	SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e v;
};

struct SQN_DRX_Config_r13 {
	struct SQN_DRX_Config_r13_onDurationTimer_v1310_e_onDurationTimer_v1310_Optional onDurationTimer_v1310;
	struct SQN_DRX_Config_r13_drx_RetransmissionTimer_v1310_e_drx_RetransmissionTimer_v1310_Optional drx_RetransmissionTimer_v1310;
	struct SQN_DRX_Config_r13_drx_ULRetransmissionTimer_r13_e_drx_ULRetransmissionTimer_r13_Optional drx_ULRetransmissionTimer_r13;
};

enum SQN_MAC_MainConfig_drx_Config_r13_Sel {
	SQN_MAC_MainConfig_drx_Config_r13_UNBOUND_VALUE = 0,
	SQN_MAC_MainConfig_drx_Config_r13_release = 1,
	SQN_MAC_MainConfig_drx_Config_r13_setup = 2,
};

union SQN_MAC_MainConfig_drx_Config_r13_Value {
	Null release;
	struct SQN_DRX_Config_r13 setup;
};

struct SQN_MAC_MainConfig_drx_Config_r13 {
	enum SQN_MAC_MainConfig_drx_Config_r13_Sel d;
	union SQN_MAC_MainConfig_drx_Config_r13_Value v;
};

typedef bool SQN_MAC_MainConfig_e_HARQ_Pattern_r12;

enum SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup_Sel {
	SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup_UNBOUND_VALUE = 0,
	SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup_sf5120 = 1,
	SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup_sf10240 = 2,
};

union SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup_Value {
	uint8_t sf5120;
	uint8_t sf10240;
};

struct SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup {
	enum SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup_Sel d;
	union SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup_Value v;
};

enum SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_Sel {
	SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_UNBOUND_VALUE = 0,
	SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_release = 1,
	SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup = 2,
};

union SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_Value {
	Null release;
	struct SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_setup setup;
};

struct SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13 {
	enum SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_Sel d;
	union SQN_MAC_MainConfig_eDRX_Config_CycleStartOffset_r13_Value v;
};

enum SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e {
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_rf2 = 0,
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_rf4 = 1,
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_rf8 = 2,
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_rf16 = 3,
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_rf32 = 4,
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_rf64 = 5,
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_rf128 = 6,
	SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e_spare = 7,
};

typedef enum SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e SQN_MAC_MainConfig_mac_MainConfig_v1020_sCellDeactivationTimer_r10_e;

typedef bool SQN_MAC_MainConfig_ul_SCH_Config_ttiBundling;

typedef uint8_t SQN_MBMS_SessionInfo_r9_logicalChannelIdentity_r9;

enum SQN_TMGI_r9_plmn_Id_r9_Sel {
	SQN_TMGI_r9_plmn_Id_r9_UNBOUND_VALUE = 0,
	SQN_TMGI_r9_plmn_Id_r9_plmn_Index_r9 = 1,
	SQN_TMGI_r9_plmn_Id_r9_explicitValue_r9 = 2,
};

union SQN_TMGI_r9_plmn_Id_r9_Value {
	uint8_t plmn_Index_r9;
	struct SQN_PLMN_Identity explicitValue_r9;
};

struct SQN_TMGI_r9_plmn_Id_r9 {
	enum SQN_TMGI_r9_plmn_Id_r9_Sel d;
	union SQN_TMGI_r9_plmn_Id_r9_Value v;
};

struct SQN_TMGI_r9 {
	struct SQN_TMGI_r9_plmn_Id_r9 plmn_Id_r9;
	O3 serviceId_r9;
};

struct O1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional {
	bool d;
	O1 v;
};

struct SQN_MBMSSessionInfo_r13 {
	struct SQN_TMGI_r9 tmgi_r13;
	struct O1_SQN_MBMSSessionInfo_r13_sessionId_r13_Optional sessionId_r13;
};

typedef uint8_t SQN_MasterInformationBlock_schedulingInfoSIB1_BR_r13;

enum SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Sel {
	SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_UNBOUND_VALUE = 0,
	SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms40_r12 = 1,
	SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms80_r12 = 2,
	SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_ms160_r12 = 3,
};

union SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value {
	uint8_t ms40_r12;
	uint8_t ms80_r12;
	uint8_t ms160_r12;
};

struct SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12 {
	enum SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Sel d;
	union SQN_MeasDS_Config_r12_setup_dmtc_PeriodOffset_r12_Value v;
};

enum SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Sel {
	SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_UNBOUND_VALUE = 0,
	SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_durationFDD_r12 = 1,
	SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_durationTDD_r12 = 2,
};

union SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value {
	uint8_t durationFDD_r12;
	uint8_t durationTDD_r12;
};

struct SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12 {
	enum SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Sel d;
	union SQN_MeasDS_Config_r12_setup_ds_OccasionDuration_r12_Value v;
};

enum SQN_MeasGapConfig_setup_gapOffset_Sel {
	SQN_MeasGapConfig_setup_gapOffset_UNBOUND_VALUE = 0,
	SQN_MeasGapConfig_setup_gapOffset_gp0 = 1,
	SQN_MeasGapConfig_setup_gapOffset_gp1 = 2,
	SQN_MeasGapConfig_setup_gapOffset_gp2_r14 = 3,
	SQN_MeasGapConfig_setup_gapOffset_gp3_r14 = 4,
	SQN_MeasGapConfig_setup_gapOffset_gp_ncsg0_r14 = 5,
	SQN_MeasGapConfig_setup_gapOffset_gp_ncsg1_r14 = 6,
	SQN_MeasGapConfig_setup_gapOffset_gp_ncsg2_r14 = 7,
	SQN_MeasGapConfig_setup_gapOffset_gp_ncsg3_r14 = 8,
	SQN_MeasGapConfig_setup_gapOffset_gp_nonUniform1_r14 = 9,
	SQN_MeasGapConfig_setup_gapOffset_gp_nonUniform2_r14 = 10,
	SQN_MeasGapConfig_setup_gapOffset_gp_nonUniform3_r14 = 11,
	SQN_MeasGapConfig_setup_gapOffset_gp_nonUniform4_r14 = 12,
	SQN_MeasGapConfig_setup_gapOffset_gp4_r15 = 13,
	SQN_MeasGapConfig_setup_gapOffset_gp5_r15 = 14,
	SQN_MeasGapConfig_setup_gapOffset_gp6_r15 = 15,
	SQN_MeasGapConfig_setup_gapOffset_gp7_r15 = 16,
	SQN_MeasGapConfig_setup_gapOffset_gp8_r15 = 17,
	SQN_MeasGapConfig_setup_gapOffset_gp9_r15 = 18,
	SQN_MeasGapConfig_setup_gapOffset_gp10_r15 = 19,
	SQN_MeasGapConfig_setup_gapOffset_gp11_r15 = 20,
};

union SQN_MeasGapConfig_setup_gapOffset_Value {
	uint8_t gp0;
	uint8_t gp1;
	uint8_t gp2_r14;
	uint8_t gp3_r14;
	uint8_t gp_ncsg0_r14;
	uint8_t gp_ncsg1_r14;
	uint8_t gp_ncsg2_r14;
	uint8_t gp_ncsg3_r14;
	uint16_t gp_nonUniform1_r14;
	uint16_t gp_nonUniform2_r14;
	uint16_t gp_nonUniform3_r14;
	uint16_t gp_nonUniform4_r14;
	uint8_t gp4_r15;
	uint8_t gp5_r15;
	uint8_t gp6_r15;
	uint8_t gp7_r15;
	uint8_t gp8_r15;
	uint8_t gp9_r15;
	uint8_t gp10_r15;
	uint8_t gp11_r15;
};

struct SQN_MeasGapConfig_setup_gapOffset {
	enum SQN_MeasGapConfig_setup_gapOffset_Sel d;
	union SQN_MeasGapConfig_setup_gapOffset_Value v;
};

struct SQN_MeasGapConfig_setup {
	struct SQN_MeasGapConfig_setup_gapOffset gapOffset;
};

enum SQN_MeasGapConfig_Sel {
	SQN_MeasGapConfig_UNBOUND_VALUE = 0,
	SQN_MeasGapConfig_release = 1,
	SQN_MeasGapConfig_setup = 2,
};

union SQN_MeasGapConfig_Value {
	Null release;
	struct SQN_MeasGapConfig_setup setup;
};

struct SQN_MeasGapConfig {
	enum SQN_MeasGapConfig_Sel d;
	union SQN_MeasGapConfig_Value v;
};

enum SQN_MeasSubframePatternPCell_r10_Sel {
	SQN_MeasSubframePatternPCell_r10_UNBOUND_VALUE = 0,
	SQN_MeasSubframePatternPCell_r10_release = 1,
	SQN_MeasSubframePatternPCell_r10_setup = 2,
};

union SQN_MeasSubframePatternPCell_r10_Value {
	Null release;
	struct SQN_MeasSubframePattern_r10 setup;
};

struct SQN_MeasSubframePatternPCell_r10 {
	enum SQN_MeasSubframePatternPCell_r10_Sel d;
	union SQN_MeasSubframePatternPCell_r10_Value v;
};

typedef B8 SQN_MMEC;

struct SQN_S_TMSI {
	SQN_MMEC mmec;
	B32 m_TMSI;
};

typedef uint8_t SQN_IMSI_Digit;

struct SQN_IMSI_Digit_SQN_IMSI_Dynamic {
	size_t d;
	SQN_IMSI_Digit* v;
};

typedef struct SQN_IMSI_Digit_SQN_IMSI_Dynamic SQN_IMSI;

typedef B48 SQN_NG_5G_S_TMSI_r15;

typedef B40 SQN_I_RNTI_r15;

enum SQN_PagingUE_Identity_Sel {
	SQN_PagingUE_Identity_UNBOUND_VALUE = 0,
	SQN_PagingUE_Identity_s_TMSI = 1,
	SQN_PagingUE_Identity_imsi = 2,
	SQN_PagingUE_Identity_ng_5G_S_TMSI_r15 = 3,
	SQN_PagingUE_Identity_fullI_RNTI_r15 = 4,
};

union SQN_PagingUE_Identity_Value {
	struct SQN_S_TMSI s_TMSI;
	SQN_IMSI imsi;
	SQN_NG_5G_S_TMSI_r15 ng_5G_S_TMSI_r15;
	SQN_I_RNTI_r15 fullI_RNTI_r15;
};

struct SQN_PagingUE_Identity {
	enum SQN_PagingUE_Identity_Sel d;
	union SQN_PagingUE_Identity_Value v;
};

enum SQN_PagingRecord_cn_Domain_e {
	SQN_PagingRecord_cn_Domain_e_ps = 0,
	SQN_PagingRecord_cn_Domain_e_cs = 1,
};

typedef enum SQN_PagingRecord_cn_Domain_e SQN_PagingRecord_cn_Domain_e;

struct SQN_PagingRecord {
	struct SQN_PagingUE_Identity ue_Identity;
	SQN_PagingRecord_cn_Domain_e cn_Domain;
};

struct SQN_PagingRecord_SQN_PagingRecordList_Dynamic {
	size_t d;
	struct SQN_PagingRecord* v;
};

typedef struct SQN_PagingRecord_SQN_PagingRecordList_Dynamic SQN_PagingRecordList;

enum SQN_Paging_systemInfoModification_e {
	SQN_Paging_systemInfoModification_e_true = 0,
};

typedef enum SQN_Paging_systemInfoModification_e SQN_Paging_systemInfoModification_e;

enum SQN_Paging_etws_Indication_e {
	SQN_Paging_etws_Indication_e_true = 0,
};

typedef enum SQN_Paging_etws_Indication_e SQN_Paging_etws_Indication_e;

enum SQN_Paging_v920_IEs_cmas_Indication_r9_e {
	SQN_Paging_v920_IEs_cmas_Indication_r9_e_true = 0,
};

typedef enum SQN_Paging_v920_IEs_cmas_Indication_r9_e SQN_Paging_v920_IEs_cmas_Indication_r9_e;

enum SQN_Paging_v1130_IEs_eab_ParamModification_r11_e {
	SQN_Paging_v1130_IEs_eab_ParamModification_r11_e_true = 0,
};

typedef enum SQN_Paging_v1130_IEs_eab_ParamModification_r11_e SQN_Paging_v1130_IEs_eab_ParamModification_r11_e;

enum SQN_Paging_v1310_IEs_redistributionIndication_r13_e {
	SQN_Paging_v1310_IEs_redistributionIndication_r13_e_true = 0,
};

typedef enum SQN_Paging_v1310_IEs_redistributionIndication_r13_e SQN_Paging_v1310_IEs_redistributionIndication_r13_e;

enum SQN_Paging_v1310_IEs_systemInfoModification_eDRX_r13_e {
	SQN_Paging_v1310_IEs_systemInfoModification_eDRX_r13_e_true = 0,
};

typedef enum SQN_Paging_v1310_IEs_systemInfoModification_eDRX_r13_e SQN_Paging_v1310_IEs_systemInfoModification_eDRX_r13_e;

enum SQN_Paging_v1530_IEs_accessType_e {
	SQN_Paging_v1530_IEs_accessType_e_non3GPP = 0,
};

typedef enum SQN_Paging_v1530_IEs_accessType_e SQN_Paging_v1530_IEs_accessType_e;

enum SQN_PagingRecord_v1610_accessType_r16_e {
	SQN_PagingRecord_v1610_accessType_r16_e_non3GPP = 0,
};

typedef enum SQN_PagingRecord_v1610_accessType_r16_e SQN_PagingRecord_v1610_accessType_r16_e;

enum SQN_PagingRecord_v1610_mt_EDT_r16_e {
	SQN_PagingRecord_v1610_mt_EDT_r16_e_true = 0,
};

typedef enum SQN_PagingRecord_v1610_mt_EDT_r16_e SQN_PagingRecord_v1610_mt_EDT_r16_e;

struct SQN_PagingRecord_v1610_accessType_r16_e_accessType_r16_Optional {
	bool d;
	SQN_PagingRecord_v1610_accessType_r16_e v;
};

struct SQN_PagingRecord_v1610_mt_EDT_r16_e_mt_EDT_r16_Optional {
	bool d;
	SQN_PagingRecord_v1610_mt_EDT_r16_e v;
};

struct SQN_PagingRecord_v1610 {
	struct SQN_PagingRecord_v1610_accessType_r16_e_accessType_r16_Optional accessType_r16;
	struct SQN_PagingRecord_v1610_mt_EDT_r16_e_mt_EDT_r16_Optional mt_EDT_r16;
};

struct SQN_PagingRecord_v1610_SQN_PagingRecordList_v1610_Dynamic {
	size_t d;
	struct SQN_PagingRecord_v1610* v;
};

typedef struct SQN_PagingRecord_v1610_SQN_PagingRecordList_v1610_Dynamic SQN_PagingRecordList_v1610;

enum SQN_Paging_v1610_IEs_uac_ParamModification_r16_e {
	SQN_Paging_v1610_IEs_uac_ParamModification_r16_e_true = 0,
};

typedef enum SQN_Paging_v1610_IEs_uac_ParamModification_r16_e SQN_Paging_v1610_IEs_uac_ParamModification_r16_e;

struct SQN_Paging_v1610_IEs_nonCriticalExtension {
};

struct SQN_PagingRecordList_v1610_SQN_Paging_v1610_IEs_pagingRecordList_v1610_Optional {
	bool d;
	SQN_PagingRecordList_v1610 v;
};

struct SQN_Paging_v1610_IEs_uac_ParamModification_r16_e_uac_ParamModification_r16_Optional {
	bool d;
	SQN_Paging_v1610_IEs_uac_ParamModification_r16_e v;
};

struct SQN_Paging_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional {
	bool d;
	struct SQN_Paging_v1610_IEs_nonCriticalExtension v;
};

struct SQN_Paging_v1610_IEs {
	struct SQN_PagingRecordList_v1610_SQN_Paging_v1610_IEs_pagingRecordList_v1610_Optional pagingRecordList_v1610;
	struct SQN_Paging_v1610_IEs_uac_ParamModification_r16_e_uac_ParamModification_r16_Optional uac_ParamModification_r16;
	struct SQN_Paging_v1610_IEs_nonCriticalExtension_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_Paging_v1530_IEs_accessType_e_accessType_Optional {
	bool d;
	SQN_Paging_v1530_IEs_accessType_e v;
};

struct SQN_Paging_v1610_IEs_SQN_Paging_v1530_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_Paging_v1610_IEs v;
};

struct SQN_Paging_v1530_IEs {
	struct SQN_Paging_v1530_IEs_accessType_e_accessType_Optional accessType;
	struct SQN_Paging_v1610_IEs_SQN_Paging_v1530_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_Paging_v1310_IEs_redistributionIndication_r13_e_redistributionIndication_r13_Optional {
	bool d;
	SQN_Paging_v1310_IEs_redistributionIndication_r13_e v;
};

struct SQN_Paging_v1310_IEs_systemInfoModification_eDRX_r13_e_systemInfoModification_eDRX_r13_Optional {
	bool d;
	SQN_Paging_v1310_IEs_systemInfoModification_eDRX_r13_e v;
};

struct SQN_Paging_v1530_IEs_SQN_Paging_v1310_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_Paging_v1530_IEs v;
};

struct SQN_Paging_v1310_IEs {
	struct SQN_Paging_v1310_IEs_redistributionIndication_r13_e_redistributionIndication_r13_Optional redistributionIndication_r13;
	struct SQN_Paging_v1310_IEs_systemInfoModification_eDRX_r13_e_systemInfoModification_eDRX_r13_Optional systemInfoModification_eDRX_r13;
	struct SQN_Paging_v1530_IEs_SQN_Paging_v1310_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_Paging_v1130_IEs_eab_ParamModification_r11_e_eab_ParamModification_r11_Optional {
	bool d;
	SQN_Paging_v1130_IEs_eab_ParamModification_r11_e v;
};

struct SQN_Paging_v1310_IEs_SQN_Paging_v1130_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_Paging_v1310_IEs v;
};

struct SQN_Paging_v1130_IEs {
	struct SQN_Paging_v1130_IEs_eab_ParamModification_r11_e_eab_ParamModification_r11_Optional eab_ParamModification_r11;
	struct SQN_Paging_v1310_IEs_SQN_Paging_v1130_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_Paging_v920_IEs_cmas_Indication_r9_e_cmas_Indication_r9_Optional {
	bool d;
	SQN_Paging_v920_IEs_cmas_Indication_r9_e v;
};

struct SQN_Paging_v1130_IEs_SQN_Paging_v920_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_Paging_v1130_IEs v;
};

struct SQN_Paging_v920_IEs {
	struct SQN_Paging_v920_IEs_cmas_Indication_r9_e_cmas_Indication_r9_Optional cmas_Indication_r9;
	struct SQN_Paging_v1130_IEs_SQN_Paging_v920_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct OCTET_STRING_SQN_Paging_v890_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_Paging_v920_IEs_SQN_Paging_v890_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_Paging_v920_IEs v;
};

struct SQN_Paging_v890_IEs {
	struct OCTET_STRING_SQN_Paging_v890_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_Paging_v920_IEs_SQN_Paging_v890_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_PagingRecordList_SQN_Paging_pagingRecordList_Optional {
	bool d;
	SQN_PagingRecordList v;
};

struct SQN_Paging_systemInfoModification_e_systemInfoModification_Optional {
	bool d;
	SQN_Paging_systemInfoModification_e v;
};

struct SQN_Paging_etws_Indication_e_etws_Indication_Optional {
	bool d;
	SQN_Paging_etws_Indication_e v;
};

struct SQN_Paging_v890_IEs_SQN_Paging_nonCriticalExtension_Optional {
	bool d;
	struct SQN_Paging_v890_IEs v;
};

struct SQN_Paging {
	struct SQN_PagingRecordList_SQN_Paging_pagingRecordList_Optional pagingRecordList;
	struct SQN_Paging_systemInfoModification_e_systemInfoModification_Optional systemInfoModification;
	struct SQN_Paging_etws_Indication_e_etws_Indication_Optional etws_Indication;
	struct SQN_Paging_v890_IEs_SQN_Paging_nonCriticalExtension_Optional nonCriticalExtension;
};

enum SQN_PCCH_MessageType_c1_Sel {
	SQN_PCCH_MessageType_c1_UNBOUND_VALUE = 0,
	SQN_PCCH_MessageType_c1_paging = 1,
};

union SQN_PCCH_MessageType_c1_Value {
	struct SQN_Paging paging;
};

struct SQN_PCCH_MessageType_c1 {
	enum SQN_PCCH_MessageType_c1_Sel d;
	union SQN_PCCH_MessageType_c1_Value v;
};

struct SQN_PCCH_MessageType_messageClassExtension {
};

enum SQN_PCCH_MessageType_Sel {
	SQN_PCCH_MessageType_UNBOUND_VALUE = 0,
	SQN_PCCH_MessageType_c1 = 1,
	SQN_PCCH_MessageType_messageClassExtension = 2,
};

union SQN_PCCH_MessageType_Value {
	struct SQN_PCCH_MessageType_c1 c1;
	struct SQN_PCCH_MessageType_messageClassExtension messageClassExtension;
};

struct SQN_PCCH_MessageType {
	enum SQN_PCCH_MessageType_Sel d;
	union SQN_PCCH_MessageType_Value v;
};

struct SQN_PCCH_Message {
	struct SQN_PCCH_MessageType message;
};

enum SQN_PDCP_Config_discardTimer_e {
	SQN_PDCP_Config_discardTimer_e_ms50 = 0,
	SQN_PDCP_Config_discardTimer_e_ms100 = 1,
	SQN_PDCP_Config_discardTimer_e_ms150 = 2,
	SQN_PDCP_Config_discardTimer_e_ms300 = 3,
	SQN_PDCP_Config_discardTimer_e_ms500 = 4,
	SQN_PDCP_Config_discardTimer_e_ms750 = 5,
	SQN_PDCP_Config_discardTimer_e_ms1500 = 6,
	SQN_PDCP_Config_discardTimer_e_infinity = 7,
};

typedef enum SQN_PDCP_Config_discardTimer_e SQN_PDCP_Config_discardTimer_e;

struct SQN_PDCP_Config_rlc_AM {
	bool statusReportRequired;
};

enum SQN_PDCP_Config_rlc_UM_pdcp_SN_Size_e {
	SQN_PDCP_Config_rlc_UM_pdcp_SN_Size_e_len7bits = 0,
	SQN_PDCP_Config_rlc_UM_pdcp_SN_Size_e_len12bits = 1,
};

typedef enum SQN_PDCP_Config_rlc_UM_pdcp_SN_Size_e SQN_PDCP_Config_rlc_UM_pdcp_SN_Size_e;

struct SQN_PDCP_Config_rlc_UM {
	SQN_PDCP_Config_rlc_UM_pdcp_SN_Size_e pdcp_SN_Size;
};

struct SQN_PDCP_Config_headerCompression_rohc_profiles {
	bool profile0x0001;
	bool profile0x0002;
	bool profile0x0003;
	bool profile0x0004;
	bool profile0x0006;
	bool profile0x0101;
	bool profile0x0102;
	bool profile0x0103;
	bool profile0x0104;
};

struct uint16_t_SQN_PDCP_Config_headerCompression_rohc_maxCID_Optional {
	bool d;
	uint16_t v;
};

struct SQN_PDCP_Config_headerCompression_rohc {
	struct uint16_t_SQN_PDCP_Config_headerCompression_rohc_maxCID_Optional maxCID;
	struct SQN_PDCP_Config_headerCompression_rohc_profiles profiles;
};

enum SQN_PDCP_Config_headerCompression_Sel {
	SQN_PDCP_Config_headerCompression_UNBOUND_VALUE = 0,
	SQN_PDCP_Config_headerCompression_notUsed = 1,
	SQN_PDCP_Config_headerCompression_rohc = 2,
};

union SQN_PDCP_Config_headerCompression_Value {
	Null notUsed;
	struct SQN_PDCP_Config_headerCompression_rohc rohc;
};

struct SQN_PDCP_Config_headerCompression {
	enum SQN_PDCP_Config_headerCompression_Sel d;
	union SQN_PDCP_Config_headerCompression_Value v;
};

enum SQN_PDCP_Config_rn_IntegrityProtection_r10_e {
	SQN_PDCP_Config_rn_IntegrityProtection_r10_e_enabled = 0,
};

typedef enum SQN_PDCP_Config_rn_IntegrityProtection_r10_e SQN_PDCP_Config_rn_IntegrityProtection_r10_e;

enum SQN_PDCP_Config_pdcp_SN_Size_v1130_e {
	SQN_PDCP_Config_pdcp_SN_Size_v1130_e_len15bits = 0,
};

typedef enum SQN_PDCP_Config_pdcp_SN_Size_v1130_e SQN_PDCP_Config_pdcp_SN_Size_v1130_e;

enum SQN_PDCP_Config_t_Reordering_r12_e {
	SQN_PDCP_Config_t_Reordering_r12_e_ms0 = 0,
	SQN_PDCP_Config_t_Reordering_r12_e_ms20 = 1,
	SQN_PDCP_Config_t_Reordering_r12_e_ms40 = 2,
	SQN_PDCP_Config_t_Reordering_r12_e_ms60 = 3,
	SQN_PDCP_Config_t_Reordering_r12_e_ms80 = 4,
	SQN_PDCP_Config_t_Reordering_r12_e_ms100 = 5,
	SQN_PDCP_Config_t_Reordering_r12_e_ms120 = 6,
	SQN_PDCP_Config_t_Reordering_r12_e_ms140 = 7,
	SQN_PDCP_Config_t_Reordering_r12_e_ms160 = 8,
	SQN_PDCP_Config_t_Reordering_r12_e_ms180 = 9,
	SQN_PDCP_Config_t_Reordering_r12_e_ms200 = 10,
	SQN_PDCP_Config_t_Reordering_r12_e_ms220 = 11,
	SQN_PDCP_Config_t_Reordering_r12_e_ms240 = 12,
	SQN_PDCP_Config_t_Reordering_r12_e_ms260 = 13,
	SQN_PDCP_Config_t_Reordering_r12_e_ms280 = 14,
	SQN_PDCP_Config_t_Reordering_r12_e_ms300 = 15,
	SQN_PDCP_Config_t_Reordering_r12_e_ms500 = 16,
	SQN_PDCP_Config_t_Reordering_r12_e_ms750 = 17,
	SQN_PDCP_Config_t_Reordering_r12_e_spare14 = 18,
	SQN_PDCP_Config_t_Reordering_r12_e_spare13 = 19,
	SQN_PDCP_Config_t_Reordering_r12_e_spare12 = 20,
	SQN_PDCP_Config_t_Reordering_r12_e_spare11 = 21,
	SQN_PDCP_Config_t_Reordering_r12_e_spare10 = 22,
	SQN_PDCP_Config_t_Reordering_r12_e_spare9 = 23,
	SQN_PDCP_Config_t_Reordering_r12_e_spare8 = 24,
	SQN_PDCP_Config_t_Reordering_r12_e_spare7 = 25,
	SQN_PDCP_Config_t_Reordering_r12_e_spare6 = 26,
	SQN_PDCP_Config_t_Reordering_r12_e_spare5 = 27,
	SQN_PDCP_Config_t_Reordering_r12_e_spare4 = 28,
	SQN_PDCP_Config_t_Reordering_r12_e_spare3 = 29,
	SQN_PDCP_Config_t_Reordering_r12_e_spare2 = 30,
	SQN_PDCP_Config_t_Reordering_r12_e_spare1 = 31,
};

typedef enum SQN_PDCP_Config_t_Reordering_r12_e SQN_PDCP_Config_t_Reordering_r12_e;

enum SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e {
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b0 = 0,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b100 = 1,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b200 = 2,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b400 = 3,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b800 = 4,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b1600 = 5,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b3200 = 6,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b6400 = 7,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b12800 = 8,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b25600 = 9,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b51200 = 10,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b102400 = 11,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b204800 = 12,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b409600 = 13,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_b819200 = 14,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e_spare1 = 15,
};

typedef enum SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e;

enum SQN_PDCP_Config_ul_DataSplitThreshold_r13_Sel {
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_UNBOUND_VALUE = 0,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_release = 1,
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup = 2,
};

union SQN_PDCP_Config_ul_DataSplitThreshold_r13_Value {
	Null release;
	SQN_PDCP_Config_ul_DataSplitThreshold_r13_setup_e setup;
};

struct SQN_PDCP_Config_ul_DataSplitThreshold_r13 {
	enum SQN_PDCP_Config_ul_DataSplitThreshold_r13_Sel d;
	union SQN_PDCP_Config_ul_DataSplitThreshold_r13_Value v;
};

enum SQN_PDCP_Config_pdcp_SN_Size_v1310_e {
	SQN_PDCP_Config_pdcp_SN_Size_v1310_e_len18bits = 0,
};

typedef enum SQN_PDCP_Config_pdcp_SN_Size_v1310_e SQN_PDCP_Config_pdcp_SN_Size_v1310_e;

enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e {
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e_type1 = 0,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e_type2 = 1,
};

typedef enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e;

enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e {
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms5 = 0,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms10 = 1,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms20 = 2,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms30 = 3,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms40 = 4,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms50 = 5,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms60 = 6,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms70 = 7,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms80 = 8,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms90 = 9,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms100 = 10,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms150 = 11,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms200 = 12,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms300 = 13,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms500 = 14,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms1000 = 15,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms2000 = 16,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms5000 = 17,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms10000 = 18,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms20000 = 19,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_ms50000 = 20,
};

typedef enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e;

enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e {
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms5 = 0,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms10 = 1,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms20 = 2,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms30 = 3,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms40 = 4,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms50 = 5,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms60 = 6,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms70 = 7,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms80 = 8,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms90 = 9,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms100 = 10,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms150 = 11,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms200 = 12,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms300 = 13,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms500 = 14,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms1000 = 15,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms2000 = 16,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms5000 = 17,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms10000 = 18,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms20000 = 19,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_ms50000 = 20,
};

typedef enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e;

enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e {
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms1 = 0,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms2 = 1,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms5 = 2,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms10 = 3,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms25 = 4,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms50 = 5,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms100 = 6,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms250 = 7,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms500 = 8,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms2500 = 9,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms5000 = 10,
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_ms25000 = 11,
};

typedef enum SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e;

struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e_statusPDU_TypeForPolling_r13_Optional {
	bool d;
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e v;
};

struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_statusPDU_Periodicity_Type1_r13_Optional {
	bool d;
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e v;
};

struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_statusPDU_Periodicity_Type2_r13_Optional {
	bool d;
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e v;
};

struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_statusPDU_Periodicity_Offset_r13_Optional {
	bool d;
	SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e v;
};

struct SQN_PDCP_Config_statusFeedback_r13_setup {
	struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_TypeForPolling_r13_e_statusPDU_TypeForPolling_r13_Optional statusPDU_TypeForPolling_r13;
	struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type1_r13_e_statusPDU_Periodicity_Type1_r13_Optional statusPDU_Periodicity_Type1_r13;
	struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Type2_r13_e_statusPDU_Periodicity_Type2_r13_Optional statusPDU_Periodicity_Type2_r13;
	struct SQN_PDCP_Config_statusFeedback_r13_setup_statusPDU_Periodicity_Offset_r13_e_statusPDU_Periodicity_Offset_r13_Optional statusPDU_Periodicity_Offset_r13;
};

enum SQN_PDCP_Config_statusFeedback_r13_Sel {
	SQN_PDCP_Config_statusFeedback_r13_UNBOUND_VALUE = 0,
	SQN_PDCP_Config_statusFeedback_r13_release = 1,
	SQN_PDCP_Config_statusFeedback_r13_setup = 2,
};

union SQN_PDCP_Config_statusFeedback_r13_Value {
	Null release;
	struct SQN_PDCP_Config_statusFeedback_r13_setup setup;
};

struct SQN_PDCP_Config_statusFeedback_r13 {
	enum SQN_PDCP_Config_statusFeedback_r13_Sel d;
	union SQN_PDCP_Config_statusFeedback_r13_Value v;
};

enum SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e {
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b0 = 0,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b100 = 1,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b200 = 2,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b400 = 3,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b800 = 4,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b1600 = 5,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b3200 = 6,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b6400 = 7,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b12800 = 8,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b25600 = 9,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b51200 = 10,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b102400 = 11,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b204800 = 12,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b409600 = 13,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_b819200 = 14,
};

typedef enum SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e;

struct SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_ul_LWA_DataSplitThreshold_r14_Optional {
	bool d;
	SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e v;
};

struct SQN_PDCP_Config_ul_LWA_Config_r14_setup {
	bool ul_LWA_DRB_ViaWLAN_r14;
	struct SQN_PDCP_Config_ul_LWA_Config_r14_setup_ul_LWA_DataSplitThreshold_r14_e_ul_LWA_DataSplitThreshold_r14_Optional ul_LWA_DataSplitThreshold_r14;
};

enum SQN_PDCP_Config_ul_LWA_Config_r14_Sel {
	SQN_PDCP_Config_ul_LWA_Config_r14_UNBOUND_VALUE = 0,
	SQN_PDCP_Config_ul_LWA_Config_r14_release = 1,
	SQN_PDCP_Config_ul_LWA_Config_r14_setup = 2,
};

union SQN_PDCP_Config_ul_LWA_Config_r14_Value {
	Null release;
	struct SQN_PDCP_Config_ul_LWA_Config_r14_setup setup;
};

struct SQN_PDCP_Config_ul_LWA_Config_r14 {
	enum SQN_PDCP_Config_ul_LWA_Config_r14_Sel d;
	union SQN_PDCP_Config_ul_LWA_Config_r14_Value v;
};

struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_rohc_r14_profiles_r14 {
	bool profile0x0006_r14;
};

struct uint16_t_SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_rohc_r14_maxCID_r14_Optional {
	bool d;
	uint16_t v;
};

struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_rohc_r14 {
	struct uint16_t_SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_rohc_r14_maxCID_r14_Optional maxCID_r14;
	struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_rohc_r14_profiles_r14 profiles_r14;
};

enum SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_Sel {
	SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_UNBOUND_VALUE = 0,
	SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_notUsed_r14 = 1,
	SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_rohc_r14 = 2,
};

union SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_Value {
	Null notUsed_r14;
	struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_rohc_r14 rohc_r14;
};

struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14 {
	enum SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_Sel d;
	union SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_Value v;
};

enum SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e {
	SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e_kbyte2 = 0,
	SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e_kbyte4 = 1,
	SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e_kbyte8 = 2,
	SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e_spare1 = 3,
};

typedef enum SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e;

enum SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e {
	SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e_sip_SDP = 0,
	SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e_operator = 1,
};

typedef enum SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e;

struct SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e_dictionary_r15_Optional {
	bool d;
	SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e v;
};

struct SQN_PDCP_Config_uplinkDataCompression_r15 {
	SQN_PDCP_Config_uplinkDataCompression_r15_bufferSize_r15_e bufferSize_r15;
	struct SQN_PDCP_Config_uplinkDataCompression_r15_dictionary_r15_e_dictionary_r15_Optional dictionary_r15;
};

enum SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup_pdcp_Duplication_r15_e {
	SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup_pdcp_Duplication_r15_e_configured = 0,
	SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup_pdcp_Duplication_r15_e_activated = 1,
};

typedef enum SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup_pdcp_Duplication_r15_e SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup_pdcp_Duplication_r15_e;

struct SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup {
	SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup_pdcp_Duplication_r15_e pdcp_Duplication_r15;
};

enum SQN_PDCP_Config_pdcp_DuplicationConfig_r15_Sel {
	SQN_PDCP_Config_pdcp_DuplicationConfig_r15_UNBOUND_VALUE = 0,
	SQN_PDCP_Config_pdcp_DuplicationConfig_r15_release = 1,
	SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup = 2,
};

union SQN_PDCP_Config_pdcp_DuplicationConfig_r15_Value {
	Null release;
	struct SQN_PDCP_Config_pdcp_DuplicationConfig_r15_setup setup;
};

struct SQN_PDCP_Config_pdcp_DuplicationConfig_r15 {
	enum SQN_PDCP_Config_pdcp_DuplicationConfig_r15_Sel d;
	union SQN_PDCP_Config_pdcp_DuplicationConfig_r15_Value v;
};

enum SQN_EthernetHeaderCompression_r16_ehc_Common_r16_ehc_CID_Length_r16_e {
	SQN_EthernetHeaderCompression_r16_ehc_Common_r16_ehc_CID_Length_r16_e_bits7 = 0,
	SQN_EthernetHeaderCompression_r16_ehc_Common_r16_ehc_CID_Length_r16_e_bits15 = 1,
};

typedef enum SQN_EthernetHeaderCompression_r16_ehc_Common_r16_ehc_CID_Length_r16_e SQN_EthernetHeaderCompression_r16_ehc_Common_r16_ehc_CID_Length_r16_e;

struct SQN_EthernetHeaderCompression_r16_ehc_Common_r16 {
	SQN_EthernetHeaderCompression_r16_ehc_Common_r16_ehc_CID_Length_r16_e ehc_CID_Length_r16;
};

enum SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_drb_ContinueEHC_DL_r16_e {
	SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_drb_ContinueEHC_DL_r16_e_true = 0,
};

typedef enum SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_drb_ContinueEHC_DL_r16_e SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_drb_ContinueEHC_DL_r16_e;

struct SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_drb_ContinueEHC_DL_r16_e_drb_ContinueEHC_DL_r16_Optional {
	bool d;
	SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_drb_ContinueEHC_DL_r16_e v;
};

struct SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16 {
	struct SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_drb_ContinueEHC_DL_r16_e_drb_ContinueEHC_DL_r16_Optional drb_ContinueEHC_DL_r16;
};

enum SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_drb_ContinueEHC_UL_r16_e {
	SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_drb_ContinueEHC_UL_r16_e_true = 0,
};

typedef enum SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_drb_ContinueEHC_UL_r16_e SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_drb_ContinueEHC_UL_r16_e;

struct SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_drb_ContinueEHC_UL_r16_e_drb_ContinueEHC_UL_r16_Optional {
	bool d;
	SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_drb_ContinueEHC_UL_r16_e v;
};

struct SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16 {
	uint16_t maxCID_EHC_UL_r16;
	struct SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_drb_ContinueEHC_UL_r16_e_drb_ContinueEHC_UL_r16_Optional drb_ContinueEHC_UL_r16;
};

struct SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_ehc_Downlink_r16_Optional {
	bool d;
	struct SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16 v;
};

struct SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_ehc_Uplink_r16_Optional {
	bool d;
	struct SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16 v;
};

struct SQN_EthernetHeaderCompression_r16 {
	struct SQN_EthernetHeaderCompression_r16_ehc_Common_r16 ehc_Common_r16;
	struct SQN_EthernetHeaderCompression_r16_ehc_Downlink_r16_ehc_Downlink_r16_Optional ehc_Downlink_r16;
	struct SQN_EthernetHeaderCompression_r16_ehc_Uplink_r16_ehc_Uplink_r16_Optional ehc_Uplink_r16;
};

enum SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_Sel {
	SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_UNBOUND_VALUE = 0,
	SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_release = 1,
	SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_setup = 2,
};

union SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_Value {
	Null release;
	struct SQN_EthernetHeaderCompression_r16 setup;
};

struct SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16 {
	enum SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_Sel d;
	union SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_Value v;
};

struct SQN_PDCP_Config_discardTimer_e_discardTimer_Optional {
	bool d;
	SQN_PDCP_Config_discardTimer_e v;
};

struct SQN_PDCP_Config_rlc_AM_rlc_AM_Optional {
	bool d;
	struct SQN_PDCP_Config_rlc_AM v;
};

struct SQN_PDCP_Config_rlc_UM_rlc_UM_Optional {
	bool d;
	struct SQN_PDCP_Config_rlc_UM v;
};

struct SQN_PDCP_Config_rn_IntegrityProtection_r10_e_rn_IntegrityProtection_r10_Optional {
	bool d;
	SQN_PDCP_Config_rn_IntegrityProtection_r10_e v;
};

struct SQN_PDCP_Config_pdcp_SN_Size_v1130_e_pdcp_SN_Size_v1130_Optional {
	bool d;
	SQN_PDCP_Config_pdcp_SN_Size_v1130_e v;
};

struct bool_SQN_PDCP_Config_ul_DataSplitDRB_ViaSCG_r12_Optional {
	bool d;
	bool v;
};

struct SQN_PDCP_Config_t_Reordering_r12_e_t_Reordering_r12_Optional {
	bool d;
	SQN_PDCP_Config_t_Reordering_r12_e v;
};

struct SQN_PDCP_Config_ul_DataSplitThreshold_r13_ul_DataSplitThreshold_r13_Optional {
	bool d;
	struct SQN_PDCP_Config_ul_DataSplitThreshold_r13 v;
};

struct SQN_PDCP_Config_pdcp_SN_Size_v1310_e_pdcp_SN_Size_v1310_Optional {
	bool d;
	SQN_PDCP_Config_pdcp_SN_Size_v1310_e v;
};

struct SQN_PDCP_Config_statusFeedback_r13_statusFeedback_r13_Optional {
	bool d;
	struct SQN_PDCP_Config_statusFeedback_r13 v;
};

struct SQN_PDCP_Config_ul_LWA_Config_r14_ul_LWA_Config_r14_Optional {
	bool d;
	struct SQN_PDCP_Config_ul_LWA_Config_r14 v;
};

struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_uplinkOnlyHeaderCompression_r14_Optional {
	bool d;
	struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14 v;
};

struct SQN_PDCP_Config_uplinkDataCompression_r15_uplinkDataCompression_r15_Optional {
	bool d;
	struct SQN_PDCP_Config_uplinkDataCompression_r15 v;
};

struct SQN_PDCP_Config_pdcp_DuplicationConfig_r15_pdcp_DuplicationConfig_r15_Optional {
	bool d;
	struct SQN_PDCP_Config_pdcp_DuplicationConfig_r15 v;
};

struct SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_SQN_PDCP_Config_ethernetHeaderCompression_r16_Optional {
	bool d;
	struct SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16 v;
};

struct SQN_PDCP_Config {
	struct SQN_PDCP_Config_discardTimer_e_discardTimer_Optional discardTimer;
	struct SQN_PDCP_Config_rlc_AM_rlc_AM_Optional rlc_AM;
	struct SQN_PDCP_Config_rlc_UM_rlc_UM_Optional rlc_UM;
	struct SQN_PDCP_Config_headerCompression headerCompression;
	struct SQN_PDCP_Config_rn_IntegrityProtection_r10_e_rn_IntegrityProtection_r10_Optional rn_IntegrityProtection_r10;
	struct SQN_PDCP_Config_pdcp_SN_Size_v1130_e_pdcp_SN_Size_v1130_Optional pdcp_SN_Size_v1130;
	struct bool_SQN_PDCP_Config_ul_DataSplitDRB_ViaSCG_r12_Optional ul_DataSplitDRB_ViaSCG_r12;
	struct SQN_PDCP_Config_t_Reordering_r12_e_t_Reordering_r12_Optional t_Reordering_r12;
	struct SQN_PDCP_Config_ul_DataSplitThreshold_r13_ul_DataSplitThreshold_r13_Optional ul_DataSplitThreshold_r13;
	struct SQN_PDCP_Config_pdcp_SN_Size_v1310_e_pdcp_SN_Size_v1310_Optional pdcp_SN_Size_v1310;
	struct SQN_PDCP_Config_statusFeedback_r13_statusFeedback_r13_Optional statusFeedback_r13;
	struct SQN_PDCP_Config_ul_LWA_Config_r14_ul_LWA_Config_r14_Optional ul_LWA_Config_r14;
	struct SQN_PDCP_Config_uplinkOnlyHeaderCompression_r14_uplinkOnlyHeaderCompression_r14_Optional uplinkOnlyHeaderCompression_r14;
	struct SQN_PDCP_Config_uplinkDataCompression_r15_uplinkDataCompression_r15_Optional uplinkDataCompression_r15;
	struct SQN_PDCP_Config_pdcp_DuplicationConfig_r15_pdcp_DuplicationConfig_r15_Optional pdcp_DuplicationConfig_r15;
	struct SQN_SetupRelease_PDCP_Config_ethernetHeaderCompression_r16_SQN_PDCP_Config_ethernetHeaderCompression_r16_Optional ethernetHeaderCompression_r16;
};

struct SQN_PRACH_ConfigInfo_SQN_PRACH_Config_prach_ConfigInfo_Optional {
	bool d;
	struct SQN_PRACH_ConfigInfo v;
};

struct SQN_PRACH_Config {
	uint16_t rootSequenceIndex;
	struct SQN_PRACH_ConfigInfo_SQN_PRACH_Config_prach_ConfigInfo_Optional prach_ConfigInfo;
};

enum SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e {
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1 = 0,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v1dot5 = 1,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2 = 2,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v2dot5 = 3,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v4 = 4,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v5 = 5,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v8 = 6,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e_v10 = 7,
};

typedef enum SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e;

enum SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e {
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v1 = 0,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v2 = 1,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v4 = 2,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v5 = 3,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v8 = 4,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v10 = 5,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_v20 = 6,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e_spare = 7,
};

typedef enum SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e;

enum SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Sel {
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_UNBOUND_VALUE = 0,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13 = 1,
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13 = 2,
};

union SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Value {
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_fdd_r13_e fdd_r13;
	SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_tdd_r13_e tdd_r13;
};

struct SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13 {
	enum SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Sel d;
	union SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_Value v;
};

struct SQN_RSRP_ThresholdsPrachInfoList_r13_SQN_PRACH_Config_v1310_rsrp_ThresholdsPrachInfoList_r13_Optional {
	bool d;
	SQN_RSRP_ThresholdsPrachInfoList_r13 v;
};

struct SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional {
	bool d;
	struct SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13 v;
};

struct uint8_t_SQN_PRACH_Config_v1310_prach_HoppingOffset_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PRACH_ParametersListCE_r13_SQN_PRACH_Config_v1310_prach_ParametersListCE_r13_Optional {
	bool d;
	SQN_PRACH_ParametersListCE_r13 v;
};

struct uint8_t_SQN_PRACH_Config_v1310_initial_CE_level_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PRACH_Config_v1310 {
	struct SQN_RSRP_ThresholdsPrachInfoList_r13_SQN_PRACH_Config_v1310_rsrp_ThresholdsPrachInfoList_r13_Optional rsrp_ThresholdsPrachInfoList_r13;
	struct SQN_PRACH_Config_v1310_mpdcch_startSF_CSS_RA_r13_mpdcch_startSF_CSS_RA_r13_Optional mpdcch_startSF_CSS_RA_r13;
	struct uint8_t_SQN_PRACH_Config_v1310_prach_HoppingOffset_r13_Optional prach_HoppingOffset_r13;
	struct SQN_PRACH_ParametersListCE_r13_SQN_PRACH_Config_v1310_prach_ParametersListCE_r13_Optional prach_ParametersListCE_r13;
	struct uint8_t_SQN_PRACH_Config_v1310_initial_CE_level_r13_Optional initial_CE_level_r13;
};

enum SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e {
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e_n2 = 0,
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e_n4 = 1,
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e_n6 = 2,
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e_spare1 = 3,
};

typedef enum SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e;

struct SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup {
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup_repetitionFactor_e repetitionFactor;
	uint16_t n1PUCCH_AN_Rep;
};

enum SQN_PUCCH_ConfigDedicated_ackNackRepetition_Sel {
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_release = 1,
	SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_ackNackRepetition_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_ackNackRepetition_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_ackNackRepetition {
	enum SQN_PUCCH_ConfigDedicated_ackNackRepetition_Sel d;
	union SQN_PUCCH_ConfigDedicated_ackNackRepetition_Value v;
};

enum SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e {
	SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e_bundling = 0,
	SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e_multiplexing = 1,
};

typedef enum SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e;

struct SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e_tdd_AckNackFeedbackMode_Optional {
	bool d;
	SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e v;
};

struct SQN_PUCCH_ConfigDedicated {
	struct SQN_PUCCH_ConfigDedicated_ackNackRepetition ackNackRepetition;
	struct SQN_PUCCH_ConfigDedicated_tdd_AckNackFeedbackMode_e_tdd_AckNackFeedbackMode_Optional tdd_AckNackFeedbackMode;
};

enum SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e_n2 = 0,
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e_n4 = 1,
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e_n6 = 2,
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e_spare1 = 3,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e;

struct SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup {
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup_repetitionFactor_r13_e repetitionFactor_r13;
	uint16_t n1PUCCH_AN_Rep_r13;
};

enum SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Sel {
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_release = 1,
	SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13 {
	enum SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13_Value v;
};

enum SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e_bundling = 0,
	SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e_multiplexing = 1,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e;

struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup_n3PUCCH_AN_ListP1_r13_Dynamic {
	size_t d;
	uint16_t* v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup {
	struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup_n3PUCCH_AN_ListP1_r13_Dynamic n3PUCCH_AN_ListP1_r13;
};

enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Sel {
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_release = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13 {
	enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value v;
};

struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_n3PUCCH_AN_List_r13_Dynamic {
	size_t d;
	uint16_t* v;
};

struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_n3PUCCH_AN_List_r13_DynamicOptional {
	bool d;
	struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_n3PUCCH_AN_List_r13_Dynamic v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13 v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13 {
	struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_n3PUCCH_AN_List_r13_DynamicOptional n3PUCCH_AN_List_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional twoAntennaPortActivatedPUCCH_Format3_r13;
};

struct uint16_t_SQN_N1PUCCH_AN_CS_r10_Dynamic {
	size_t d;
	uint16_t* v;
};

typedef struct uint16_t_SQN_N1PUCCH_AN_CS_r10_Dynamic SQN_N1PUCCH_AN_CS_r10;

struct SQN_N1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_List_r13_Dynamic {
	size_t d;
	SQN_N1PUCCH_AN_CS_r10* v;
};

struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup_dummy1_Dynamic {
	size_t d;
	uint16_t* v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup {
	struct SQN_N1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_List_r13_Dynamic n1PUCCH_AN_CS_List_r13;
	struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup_dummy1_Dynamic dummy1;
};

enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Sel {
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_release = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13 {
	enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_Value v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_n1PUCCH_AN_CS_r13_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13 v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13 {
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13_n1PUCCH_AN_CS_r13_n1PUCCH_AN_CS_r13_Optional n1PUCCH_AN_CS_r13;
};

struct SQN_Format4_resource_r13 {
	uint8_t startingPRB_format4_r13;
	uint8_t numberOfPRB_format4_r13;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13_SQN_Format4_resource_r13_format4_MultiCSI_resourceConfiguration_r13_Dynamic {
	size_t d;
	struct SQN_Format4_resource_r13* v;
};

struct SQN_Format4_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13_format4_MultiCSI_resourceConfiguration_r13_DynamicOptional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13_SQN_Format4_resource_r13_format4_MultiCSI_resourceConfiguration_r13_Dynamic v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13 {
	struct SQN_Format4_resource_r13 format4_resourceConfiguration_r13[4];
	struct SQN_Format4_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13_format4_MultiCSI_resourceConfiguration_r13_DynamicOptional format4_MultiCSI_resourceConfiguration_r13;
};

struct SQN_Format5_resource_r13 {
	uint8_t startingPRB_format5_r13;
	uint8_t cdm_index_format5_r13;
};

struct SQN_Format5_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13_format5_MultiCSI_resourceConfiguration_r13_Optional {
	bool d;
	struct SQN_Format5_resource_r13 v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13 {
	struct SQN_Format5_resource_r13 format5_resourceConfiguration_r13[4];
	struct SQN_Format5_resource_r13_SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13_format5_MultiCSI_resourceConfiguration_r13_Optional format5_MultiCSI_resourceConfiguration_r13;
};

enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Sel {
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13 = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13 = 2,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13 = 3,
	SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13 = 4,
};

union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Value {
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format3_r13 format3_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_channelSelection_r13 channelSelection_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format4_r13 format4_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_format5_r13 format5_r13;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13 {
	enum SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_Value v;
};

enum SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e_true = 0,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e;

enum SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e_true = 0,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e;

struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup {
	uint16_t nPUCCH_Identity_r13;
	uint16_t n1PUCCH_AN_r13;
};

enum SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Sel {
	SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_release = 1,
	SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13 {
	enum SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_Value v;
};

struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup {
	uint16_t nkaPUCCH_AN_r13;
};

enum SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Sel {
	SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_release = 1,
	SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13 {
	enum SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_Value v;
};

enum SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e_dai = 0,
	SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e_cc = 1,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e;

enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e_r1 = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e_r2 = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e_r4 = 2,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e_r8 = 3,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e;

enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e_r1 = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e_r2 = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e_r4 = 2,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e_r8 = 3,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e;

struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format1_r13_e pucch_NumRepetitionCE_format1_r13;
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA_pucch_NumRepetitionCE_format2_r13_e pucch_NumRepetitionCE_format2_r13;
};

enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e_r4 = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e_r8 = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e_r16 = 2,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e_r32 = 3,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e;

enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e_r4 = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e_r8 = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e_r16 = 2,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e_r32 = 3,
};

typedef enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e;

struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format1_r13_e pucch_NumRepetitionCE_format1_r13;
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB_pucch_NumRepetitionCE_format2_r13_e pucch_NumRepetitionCE_format2_r13;
};

enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Sel {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB = 2,
};

union SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Value {
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeA modeA;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_modeB modeB;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup {
	enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup_Value v;
};

enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Sel {
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_release = 1,
	SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13 {
	enum SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Sel d;
	union SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_Value v;
};

struct SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e_tdd_AckNackFeedbackMode_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_pucch_Format_r13_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13 v;
};

struct SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e_twoAntennaPortActivatedPUCCH_Format1a1b_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e v;
};

struct SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e_simultaneousPUCCH_PUSCH_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e v;
};

struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_n1PUCCH_AN_RepP1_r13_Optional {
	bool d;
	uint16_t v;
};

struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_nPUCCH_Param_r13_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13 v;
};

struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_nkaPUCCH_Param_r13_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13 v;
};

struct SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e_codebooksizeDetermination_r13_Optional {
	bool d;
	SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e v;
};

struct uint8_t_SQN_PUCCH_ConfigDedicated_r13_maximumPayloadCoderate_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_pucch_NumRepetitionCE_r13_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13 v;
};

struct SQN_PUCCH_ConfigDedicated_r13 {
	struct SQN_PUCCH_ConfigDedicated_r13_ackNackRepetition_r13 ackNackRepetition_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_tdd_AckNackFeedbackMode_r13_e_tdd_AckNackFeedbackMode_r13_Optional tdd_AckNackFeedbackMode_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_Format_r13_pucch_Format_r13_Optional pucch_Format_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_twoAntennaPortActivatedPUCCH_Format1a1b_r13_e_twoAntennaPortActivatedPUCCH_Format1a1b_r13_Optional twoAntennaPortActivatedPUCCH_Format1a1b_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_simultaneousPUCCH_PUSCH_r13_e_simultaneousPUCCH_PUSCH_r13_Optional simultaneousPUCCH_PUSCH_r13;
	struct uint16_t_SQN_PUCCH_ConfigDedicated_r13_n1PUCCH_AN_RepP1_r13_Optional n1PUCCH_AN_RepP1_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_nPUCCH_Param_r13_nPUCCH_Param_r13_Optional nPUCCH_Param_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_nkaPUCCH_Param_r13_nkaPUCCH_Param_r13_Optional nkaPUCCH_Param_r13;
	bool spatialBundlingPUCCH_r13;
	bool spatialBundlingPUSCH_r13;
	bool harq_TimingTDD_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_codebooksizeDetermination_r13_e_codebooksizeDetermination_r13_Optional codebooksizeDetermination_r13;
	struct uint8_t_SQN_PUCCH_ConfigDedicated_r13_maximumPayloadCoderate_r13_Optional maximumPayloadCoderate_r13;
	struct SQN_PUCCH_ConfigDedicated_r13_pucch_NumRepetitionCE_r13_pucch_NumRepetitionCE_r13_Optional pucch_NumRepetitionCE_r13;
};

struct uint16_t_SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup_n3PUCCH_AN_ListP1_r13_Dynamic {
	size_t d;
	uint16_t* v;
};

struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup {
	struct uint16_t_SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup_n3PUCCH_AN_ListP1_r13_Dynamic n3PUCCH_AN_ListP1_r13;
};

enum SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Sel {
	SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_UNBOUND_VALUE = 0,
	SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_release = 1,
	SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup = 2,
};

union SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value {
	Null release;
	struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_setup setup;
};

struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13 {
	enum SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Sel d;
	union SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Value v;
};

struct uint16_t_SQN_PUCCH_Format3_Conf_r13_n3PUCCH_AN_List_r13_Dynamic {
	size_t d;
	uint16_t* v;
};

struct uint16_t_SQN_PUCCH_Format3_Conf_r13_n3PUCCH_AN_List_r13_DynamicOptional {
	bool d;
	struct uint16_t_SQN_PUCCH_Format3_Conf_r13_n3PUCCH_AN_List_r13_Dynamic v;
};

struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional {
	bool d;
	struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13 v;
};

struct SQN_PUCCH_Format3_Conf_r13 {
	struct uint16_t_SQN_PUCCH_Format3_Conf_r13_n3PUCCH_AN_List_r13_DynamicOptional n3PUCCH_AN_List_r13;
	struct SQN_PUCCH_Format3_Conf_r13_twoAntennaPortActivatedPUCCH_Format3_r13_twoAntennaPortActivatedPUCCH_Format3_r13_Optional twoAntennaPortActivatedPUCCH_Format3_r13;
};

struct SQN_N1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_List_r10_Dynamic {
	size_t d;
	SQN_N1PUCCH_AN_CS_r10* v;
};

struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup {
	struct SQN_N1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_List_r10_Dynamic n1PUCCH_AN_CS_List_r10;
};

enum SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Sel {
	SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_release = 1,
	SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10 {
	enum SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Sel d;
	union SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_Value v;
};

struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_r10_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10 v;
};

struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10 {
	struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10_n1PUCCH_AN_CS_r10_n1PUCCH_AN_CS_r10_Optional n1PUCCH_AN_CS_r10;
};

enum SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Sel {
	SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_format3_r10 = 1,
	SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10 = 2,
};

union SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Value {
	struct SQN_PUCCH_Format3_Conf_r13 format3_r10;
	struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_channelSelection_r10 channelSelection_r10;
};

struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10 {
	enum SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Sel d;
	union SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_Value v;
};

enum SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e {
	SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e_true = 0,
};

typedef enum SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e;

enum SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e {
	SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e_true = 0,
};

typedef enum SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e;

struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_pucch_Format_r10_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10 v;
};

struct SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e_twoAntennaPortActivatedPUCCH_Format1a1b_r10_Optional {
	bool d;
	SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e v;
};

struct SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e_simultaneousPUCCH_PUSCH_r10_Optional {
	bool d;
	SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e v;
};

struct uint16_t_SQN_PUCCH_ConfigDedicated_v1020_n1PUCCH_AN_RepP1_r10_Optional {
	bool d;
	uint16_t v;
};

struct SQN_PUCCH_ConfigDedicated_v1020 {
	struct SQN_PUCCH_ConfigDedicated_v1020_pucch_Format_r10_pucch_Format_r10_Optional pucch_Format_r10;
	struct SQN_PUCCH_ConfigDedicated_v1020_twoAntennaPortActivatedPUCCH_Format1a1b_r10_e_twoAntennaPortActivatedPUCCH_Format1a1b_r10_Optional twoAntennaPortActivatedPUCCH_Format1a1b_r10;
	struct SQN_PUCCH_ConfigDedicated_v1020_simultaneousPUCCH_PUSCH_r10_e_simultaneousPUCCH_PUSCH_r10_Optional simultaneousPUCCH_PUSCH_r10;
	struct uint16_t_SQN_PUCCH_ConfigDedicated_v1020_n1PUCCH_AN_RepP1_r10_Optional n1PUCCH_AN_RepP1_r10;
};

struct uint16_t_SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup_n1PUCCH_AN_CS_ListP1_r11_Dynamic {
	size_t d;
	uint16_t* v;
};

struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup {
	struct uint16_t_SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup_n1PUCCH_AN_CS_ListP1_r11_Dynamic n1PUCCH_AN_CS_ListP1_r11;
};

enum SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Sel {
	SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_release = 1,
	SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130 {
	enum SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Sel d;
	union SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_Value v;
};

struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup {
	uint16_t nPUCCH_Identity_r11;
	uint16_t n1PUCCH_AN_r11;
};

enum SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Sel {
	SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_release = 1,
	SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11 {
	enum SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Sel d;
	union SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_Value v;
};

struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_n1PUCCH_AN_CS_v1130_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130 v;
};

struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_nPUCCH_Param_r11_Optional {
	bool d;
	struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11 v;
};

struct SQN_PUCCH_ConfigDedicated_v1130 {
	struct SQN_PUCCH_ConfigDedicated_v1130_n1PUCCH_AN_CS_v1130_n1PUCCH_AN_CS_v1130_Optional n1PUCCH_AN_CS_v1130;
	struct SQN_PUCCH_ConfigDedicated_v1130_nPUCCH_Param_r11_nPUCCH_Param_r11_Optional nPUCCH_Param_r11;
};

struct SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup {
	uint16_t nkaPUCCH_AN_r12;
};

enum SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Sel {
	SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_UNBOUND_VALUE = 0,
	SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_release = 1,
	SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup = 2,
};

union SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Value {
	Null release;
	struct SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_setup setup;
};

struct SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12 {
	enum SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Sel d;
	union SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12_Value v;
};

struct SQN_PUCCH_ConfigDedicated_v1250 {
	struct SQN_PUCCH_ConfigDedicated_v1250_nkaPUCCH_Param_r12 nkaPUCCH_Param_r12;
};

struct SQN_PUSCH_ConfigDedicated {
	uint8_t betaOffset_ACK_Index;
	uint8_t betaOffset_RI_Index;
	uint8_t betaOffset_CQI_Index;
};

struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffset2_ACK_Index_MC_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13 {
	uint8_t betaOffset_ACK_Index_MC_r13;
	struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffset2_ACK_Index_MC_r13_Optional betaOffset2_ACK_Index_MC_r13;
	uint8_t betaOffset_RI_Index_MC_r13;
	uint8_t betaOffset_CQI_Index_MC_r13;
};

enum SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e {
	SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e_true = 0,
};

typedef enum SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e;

enum SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e {
	SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e_true = 0,
};

typedef enum SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e;

struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup {
	uint16_t nPUSCH_Identity_r13;
	uint16_t nDMRS_CSH_Identity_r13;
};

enum SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Sel {
	SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_UNBOUND_VALUE = 0,
	SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_release = 1,
	SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup = 2,
};

union SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Value {
	Null release;
	struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_setup setup;
};

struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11 {
	enum SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Sel d;
	union SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_Value v;
};

struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffset2_ACK_Index_MC_SubframeSet2_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12 {
	uint8_t betaOffset_ACK_Index_MC_SubframeSet2_r13;
	struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffset2_ACK_Index_MC_SubframeSet2_r13_Optional betaOffset2_ACK_Index_MC_SubframeSet2_r13;
	uint8_t betaOffset_RI_Index_MC_SubframeSet2_r13;
	uint8_t betaOffset_CQI_Index_MC_SubframeSet2_r13;
};

struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffset2_ACK_Index_SubframeSet2_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional {
	bool d;
	struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12 v;
};

struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup {
	uint8_t betaOffset_ACK_Index_SubframeSet2_r13;
	struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffset2_ACK_Index_SubframeSet2_r13_Optional betaOffset2_ACK_Index_SubframeSet2_r13;
	uint8_t betaOffset_RI_Index_SubframeSet2_r13;
	uint8_t betaOffset_CQI_Index_SubframeSet2_r13;
	struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional betaOffsetMC_r12;
};

enum SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Sel {
	SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_UNBOUND_VALUE = 0,
	SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_release = 1,
	SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup = 2,
};

union SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Value {
	Null release;
	struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_setup setup;
};

struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH {
	enum SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Sel d;
	union SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_Value v;
};

enum SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e {
	SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e_on = 0,
};

typedef enum SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e;

struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffset2_ACK_Index_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffsetMC_r13_Optional {
	bool d;
	struct SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13 v;
};

struct SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e_groupHoppingDisabled_r13_Optional {
	bool d;
	SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e v;
};

struct SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e_dmrs_WithOCC_Activated_r13_Optional {
	bool d;
	SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e v;
};

struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_pusch_DMRS_r11_Optional {
	bool d;
	struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11 v;
};

struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_uciOnPUSCH_Optional {
	bool d;
	struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH v;
};

struct SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e_pusch_HoppingConfig_r13_Optional {
	bool d;
	SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e v;
};

struct SQN_PUSCH_ConfigDedicated_r13 {
	uint8_t betaOffset_ACK_Index_r13;
	struct uint8_t_SQN_PUSCH_ConfigDedicated_r13_betaOffset2_ACK_Index_r13_Optional betaOffset2_ACK_Index_r13;
	uint8_t betaOffset_RI_Index_r13;
	uint8_t betaOffset_CQI_Index_r13;
	struct SQN_PUSCH_ConfigDedicated_r13_betaOffsetMC_r13_betaOffsetMC_r13_Optional betaOffsetMC_r13;
	struct SQN_PUSCH_ConfigDedicated_r13_groupHoppingDisabled_r13_e_groupHoppingDisabled_r13_Optional groupHoppingDisabled_r13;
	struct SQN_PUSCH_ConfigDedicated_r13_dmrs_WithOCC_Activated_r13_e_dmrs_WithOCC_Activated_r13_Optional dmrs_WithOCC_Activated_r13;
	struct SQN_PUSCH_ConfigDedicated_r13_pusch_DMRS_r11_pusch_DMRS_r11_Optional pusch_DMRS_r11;
	struct SQN_PUSCH_ConfigDedicated_r13_uciOnPUSCH_uciOnPUSCH_Optional uciOnPUSCH;
	struct SQN_PUSCH_ConfigDedicated_r13_pusch_HoppingConfig_r13_e_pusch_HoppingConfig_r13_Optional pusch_HoppingConfig_r13;
};

struct SQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10 {
	uint8_t betaOffset_ACK_Index_MC_r10;
	uint8_t betaOffset_RI_Index_MC_r10;
	uint8_t betaOffset_CQI_Index_MC_r10;
};

enum SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e {
	SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e_true = 0,
};

typedef enum SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e;

enum SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e {
	SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e_true = 0,
};

typedef enum SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e;

struct SQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10_betaOffsetMC_r10_Optional {
	bool d;
	struct SQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10 v;
};

struct SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e_groupHoppingDisabled_r10_Optional {
	bool d;
	SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e v;
};

struct SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e_dmrs_WithOCC_Activated_r10_Optional {
	bool d;
	SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e v;
};

struct SQN_PUSCH_ConfigDedicated_v1020 {
	struct SQN_PUSCH_ConfigDedicated_v1020_betaOffsetMC_r10_betaOffsetMC_r10_Optional betaOffsetMC_r10;
	struct SQN_PUSCH_ConfigDedicated_v1020_groupHoppingDisabled_r10_e_groupHoppingDisabled_r10_Optional groupHoppingDisabled_r10;
	struct SQN_PUSCH_ConfigDedicated_v1020_dmrs_WithOCC_Activated_r10_e_dmrs_WithOCC_Activated_r10_Optional dmrs_WithOCC_Activated_r10;
};

struct SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup {
	uint16_t nPUSCH_Identity_r11;
	uint16_t nDMRS_CSH_Identity_r11;
};

enum SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Sel {
	SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_UNBOUND_VALUE = 0,
	SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_release = 1,
	SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup = 2,
};

union SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Value {
	Null release;
	struct SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_setup setup;
};

struct SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11 {
	enum SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Sel d;
	union SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11_Value v;
};

struct SQN_PUSCH_ConfigDedicated_v1130 {
	struct SQN_PUSCH_ConfigDedicated_v1130_pusch_DMRS_r11 pusch_DMRS_r11;
};

struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12 {
	uint8_t betaOffset_ACK_Index_MC_SubframeSet2_r12;
	uint8_t betaOffset_RI_Index_MC_SubframeSet2_r12;
	uint8_t betaOffset_CQI_Index_MC_SubframeSet2_r12;
};

struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional {
	bool d;
	struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12 v;
};

struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup {
	uint8_t betaOffset_ACK_Index_SubframeSet2_r12;
	uint8_t betaOffset_RI_Index_SubframeSet2_r12;
	uint8_t betaOffset_CQI_Index_SubframeSet2_r12;
	struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup_betaOffsetMC_r12_betaOffsetMC_r12_Optional betaOffsetMC_r12;
};

enum SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Sel {
	SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_UNBOUND_VALUE = 0,
	SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_release = 1,
	SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup = 2,
};

union SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Value {
	Null release;
	struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_setup setup;
};

struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH {
	enum SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Sel d;
	union SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH_Value v;
};

struct SQN_PUSCH_ConfigDedicated_v1250 {
	struct SQN_PUSCH_ConfigDedicated_v1250_uciOnPUSCH uciOnPUSCH;
};

enum SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e {
	SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e_on = 0,
};

typedef enum SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e;

enum SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e {
	SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e_bw5 = 0,
};

typedef enum SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e;

enum SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e {
	SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_sym1 = 0,
	SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_sym2 = 1,
	SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_sym3 = 2,
	SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_sym4 = 3,
	SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_sym5 = 4,
	SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_sym6 = 5,
};

typedef enum SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e;

enum SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e {
	SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e_true = 0,
};

typedef enum SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e;

struct SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_symPUSCH_UpPTS_r14_Optional {
	bool d;
	SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e v;
};

struct SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e_dmrs_LessUpPTS_Config_r14_Optional {
	bool d;
	SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e v;
};

struct SQN_TDD_PUSCH_UpPTS_r14_setup {
	struct SQN_TDD_PUSCH_UpPTS_r14_setup_symPUSCH_UpPTS_r14_e_symPUSCH_UpPTS_r14_Optional symPUSCH_UpPTS_r14;
	struct SQN_TDD_PUSCH_UpPTS_r14_setup_dmrs_LessUpPTS_Config_r14_e_dmrs_LessUpPTS_Config_r14_Optional dmrs_LessUpPTS_Config_r14;
};

enum SQN_TDD_PUSCH_UpPTS_r14_Sel {
	SQN_TDD_PUSCH_UpPTS_r14_UNBOUND_VALUE = 0,
	SQN_TDD_PUSCH_UpPTS_r14_release = 1,
	SQN_TDD_PUSCH_UpPTS_r14_setup = 2,
};

union SQN_TDD_PUSCH_UpPTS_r14_Value {
	Null release;
	struct SQN_TDD_PUSCH_UpPTS_r14_setup setup;
};

struct SQN_TDD_PUSCH_UpPTS_r14 {
	enum SQN_TDD_PUSCH_UpPTS_r14_Sel d;
	union SQN_TDD_PUSCH_UpPTS_r14_Value v;
};

struct SQN_Enable256QAM_r14_setup_tpc_SubframeSet_Configured_r14 {
	bool subframeSet1_DCI_Format0_r14;
	bool subframeSet1_DCI_Format4_r14;
	bool subframeSet2_DCI_Format0_r14;
	bool subframeSet2_DCI_Format4_r14;
};

struct SQN_Enable256QAM_r14_setup_tpc_SubframeSet_NotConfigured_r14 {
	bool dci_Format0_r14;
	bool dci_Format4_r14;
};

enum SQN_Enable256QAM_r14_setup_Sel {
	SQN_Enable256QAM_r14_setup_UNBOUND_VALUE = 0,
	SQN_Enable256QAM_r14_setup_tpc_SubframeSet_Configured_r14 = 1,
	SQN_Enable256QAM_r14_setup_tpc_SubframeSet_NotConfigured_r14 = 2,
};

union SQN_Enable256QAM_r14_setup_Value {
	struct SQN_Enable256QAM_r14_setup_tpc_SubframeSet_Configured_r14 tpc_SubframeSet_Configured_r14;
	struct SQN_Enable256QAM_r14_setup_tpc_SubframeSet_NotConfigured_r14 tpc_SubframeSet_NotConfigured_r14;
};

struct SQN_Enable256QAM_r14_setup {
	enum SQN_Enable256QAM_r14_setup_Sel d;
	union SQN_Enable256QAM_r14_setup_Value v;
};

enum SQN_Enable256QAM_r14_Sel {
	SQN_Enable256QAM_r14_UNBOUND_VALUE = 0,
	SQN_Enable256QAM_r14_release = 1,
	SQN_Enable256QAM_r14_setup = 2,
};

union SQN_Enable256QAM_r14_Value {
	Null release;
	struct SQN_Enable256QAM_r14_setup setup;
};

struct SQN_Enable256QAM_r14 {
	enum SQN_Enable256QAM_r14_Sel d;
	union SQN_Enable256QAM_r14_Value v;
};

struct SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e_ce_PUSCH_NB_MaxTBS_r14_Optional {
	bool d;
	SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e v;
};

struct SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e_ce_PUSCH_MaxBandwidth_r14_Optional {
	bool d;
	SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e v;
};

struct SQN_TDD_PUSCH_UpPTS_r14_SQN_PUSCH_ConfigDedicated_v1430_tdd_PUSCH_UpPTS_r14_Optional {
	bool d;
	struct SQN_TDD_PUSCH_UpPTS_r14 v;
};

struct SQN_Enable256QAM_r14_SQN_PUSCH_ConfigDedicated_v1430_enable256QAM_r14_Optional {
	bool d;
	struct SQN_Enable256QAM_r14 v;
};

struct SQN_PUSCH_ConfigDedicated_v1430 {
	struct SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_NB_MaxTBS_r14_e_ce_PUSCH_NB_MaxTBS_r14_Optional ce_PUSCH_NB_MaxTBS_r14;
	struct SQN_PUSCH_ConfigDedicated_v1430_ce_PUSCH_MaxBandwidth_r14_e_ce_PUSCH_MaxBandwidth_r14_Optional ce_PUSCH_MaxBandwidth_r14;
	struct SQN_TDD_PUSCH_UpPTS_r14_SQN_PUSCH_ConfigDedicated_v1430_tdd_PUSCH_UpPTS_r14_Optional tdd_PUSCH_UpPTS_r14;
	bool ul_DMRS_IFDMA_r14;
	struct SQN_Enable256QAM_r14_SQN_PUSCH_ConfigDedicated_v1430_enable256QAM_r14_Optional enable256QAM_r14;
};

enum SQN_PhysicalConfigDedicated_ce_Mode_r13_setup_e {
	SQN_PhysicalConfigDedicated_ce_Mode_r13_setup_e_ce_ModeA = 0,
	SQN_PhysicalConfigDedicated_ce_Mode_r13_setup_e_ce_ModeB = 1,
};

typedef enum SQN_PhysicalConfigDedicated_ce_Mode_r13_setup_e SQN_PhysicalConfigDedicated_ce_Mode_r13_setup_e;

enum SQN_PhysicalConfigDedicated_ce_Mode_r13_Sel {
	SQN_PhysicalConfigDedicated_ce_Mode_r13_UNBOUND_VALUE = 0,
	SQN_PhysicalConfigDedicated_ce_Mode_r13_release = 1,
	SQN_PhysicalConfigDedicated_ce_Mode_r13_setup = 2,
};

union SQN_PhysicalConfigDedicated_ce_Mode_r13_Value {
	Null release;
	SQN_PhysicalConfigDedicated_ce_Mode_r13_setup_e setup;
};

struct SQN_PhysicalConfigDedicated_ce_Mode_r13 {
	enum SQN_PhysicalConfigDedicated_ce_Mode_r13_Sel d;
	union SQN_PhysicalConfigDedicated_ce_Mode_r13_Value v;
};

struct SQN_RACH_ConfigDedicated {
	uint8_t ra_PreambleIndex;
	uint8_t ra_PRACH_MaskIndex;
};

struct SQN_RLC_Config_v1250 {
	bool ul_extended_RLC_LI_Field_r12;
	bool dl_extended_RLC_LI_Field_r12;
};

typedef uint8_t SQN_SCellIndex_r10;

typedef uint8_t SQN_STAG_Id_r11;

enum SQN_SchedulingRequestConfig_setup_dsr_TransMax_e {
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_n4 = 0,
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_n8 = 1,
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_n16 = 2,
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_n32 = 3,
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_n64 = 4,
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_spare3 = 5,
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_spare2 = 6,
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e_spare1 = 7,
};

typedef enum SQN_SchedulingRequestConfig_setup_dsr_TransMax_e SQN_SchedulingRequestConfig_setup_dsr_TransMax_e;

struct SQN_SchedulingRequestConfig_setup {
	uint16_t sr_PUCCH_ResourceIndex;
	uint8_t sr_ConfigIndex;
	SQN_SchedulingRequestConfig_setup_dsr_TransMax_e dsr_TransMax;
};

enum SQN_SchedulingRequestConfig_Sel {
	SQN_SchedulingRequestConfig_UNBOUND_VALUE = 0,
	SQN_SchedulingRequestConfig_release = 1,
	SQN_SchedulingRequestConfig_setup = 2,
};

union SQN_SchedulingRequestConfig_Value {
	Null release;
	struct SQN_SchedulingRequestConfig_setup setup;
};

struct SQN_SchedulingRequestConfig {
	enum SQN_SchedulingRequestConfig_Sel d;
	union SQN_SchedulingRequestConfig_Value v;
};

struct uint16_t_SQN_SchedulingRequestConfig_v1020_sr_PUCCH_ResourceIndexP1_r10_Optional {
	bool d;
	uint16_t v;
};

struct SQN_SchedulingRequestConfig_v1020 {
	struct uint16_t_SQN_SchedulingRequestConfig_v1020_sr_PUCCH_ResourceIndexP1_r10_Optional sr_PUCCH_ResourceIndexP1_r10;
};

enum SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e {
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e_bw0 = 0,
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e_bw1 = 1,
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e_bw2 = 2,
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e_bw3 = 3,
};

typedef enum SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e;

enum SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e {
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e_hbw0 = 0,
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e_hbw1 = 1,
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e_hbw2 = 2,
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e_hbw3 = 3,
};

typedef enum SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e;

enum SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e {
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs0 = 0,
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs1 = 1,
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs2 = 2,
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs3 = 3,
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs4 = 4,
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs5 = 5,
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs6 = 6,
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e_cs7 = 7,
};

typedef enum SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e;

struct SQN_SoundingRS_UL_ConfigDedicated_setup {
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_Bandwidth_e srs_Bandwidth;
	SQN_SoundingRS_UL_ConfigDedicated_setup_srs_HoppingBandwidth_e srs_HoppingBandwidth;
	uint8_t freqDomainPosition;
	bool duration;
	uint16_t srs_ConfigIndex;
	uint8_t transmissionComb;
	SQN_SoundingRS_UL_ConfigDedicated_setup_cyclicShift_e cyclicShift;
};

enum SQN_SoundingRS_UL_ConfigDedicated_Sel {
	SQN_SoundingRS_UL_ConfigDedicated_UNBOUND_VALUE = 0,
	SQN_SoundingRS_UL_ConfigDedicated_release = 1,
	SQN_SoundingRS_UL_ConfigDedicated_setup = 2,
};

union SQN_SoundingRS_UL_ConfigDedicated_Value {
	Null release;
	struct SQN_SoundingRS_UL_ConfigDedicated_setup setup;
};

struct SQN_SoundingRS_UL_ConfigDedicated {
	enum SQN_SoundingRS_UL_ConfigDedicated_Sel d;
	union SQN_SoundingRS_UL_ConfigDedicated_Value v;
};

enum SQN_SRS_AntennaPort_e {
	SQN_SRS_AntennaPort_e_an1 = 0,
	SQN_SRS_AntennaPort_e_an2 = 1,
	SQN_SRS_AntennaPort_e_an4 = 2,
	SQN_SRS_AntennaPort_e_spare1 = 3,
};

typedef enum SQN_SRS_AntennaPort_e SQN_SRS_AntennaPort_e;

struct SQN_SoundingRS_UL_ConfigDedicated_v1020 {
	SQN_SRS_AntennaPort_e srs_AntennaPort_r10;
};

enum SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e {
	SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e_bw0 = 0,
	SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e_bw1 = 1,
	SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e_bw2 = 2,
	SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e_bw3 = 3,
};

typedef enum SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e;

enum SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e {
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs0 = 0,
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs1 = 1,
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs2 = 2,
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs3 = 3,
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs4 = 4,
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs5 = 5,
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs6 = 6,
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e_cs7 = 7,
};

typedef enum SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e;

struct SQN_SRS_ConfigAp_r10 {
	SQN_SRS_AntennaPort_e srs_AntennaPortAp_r10;
	SQN_SRS_ConfigAp_r10_srs_BandwidthAp_r10_e srs_BandwidthAp_r10;
	uint8_t freqDomainPositionAp_r10;
	uint8_t transmissionCombAp_r10;
	SQN_SRS_ConfigAp_r10_cyclicShiftAp_r10_e cyclicShiftAp_r10;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_setup {
	struct SQN_SRS_ConfigAp_r10 srs_ConfigApDCI_Format0_r10;
	struct SQN_SRS_ConfigAp_r10 srs_ConfigApDCI_Format1a2b2c_r10;
};

enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Sel {
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_UNBOUND_VALUE = 0,
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_release = 1,
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_setup = 2,
};

union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Value {
	Null release;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_setup setup;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10 {
	enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Sel d;
	union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_Value v;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_SQN_SRS_ConfigAp_r10_srs_ConfigApDCI_Format4_r10_Dynamic {
	size_t d;
	struct SQN_SRS_ConfigAp_r10* v;
};

struct SQN_SRS_ConfigAp_r10_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ConfigApDCI_Format4_r10_DynamicOptional {
	bool d;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_SQN_SRS_ConfigAp_r10_srs_ConfigApDCI_Format4_r10_Dynamic v;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_srs_ActivateAp_r10_Optional {
	bool d;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10 v;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup {
	uint8_t srs_ConfigIndexAp_r10;
	struct SQN_SRS_ConfigAp_r10_SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ConfigApDCI_Format4_r10_DynamicOptional srs_ConfigApDCI_Format4_r10;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup_srs_ActivateAp_r10_srs_ActivateAp_r10_Optional srs_ActivateAp_r10;
};

enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Sel {
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_UNBOUND_VALUE = 0,
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_release = 1,
	SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup = 2,
};

union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Value {
	Null release;
	struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_setup setup;
};

struct SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10 {
	enum SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Sel d;
	union SQN_SoundingRS_UL_ConfigDedicatedAperiodic_r10_Value v;
};

typedef uint8_t SQN_UE_EUTRA_Capability_v1020_IEs_ue_Category_v1020;

typedef uint8_t SQN_UE_EUTRA_Capability_v1170_IEs_ue_Category_v1170;

typedef uint8_t SQN_UE_EUTRA_Capability_v11a0_IEs_ue_Category_v11a0;

typedef uint8_t SQN_UE_EUTRA_Capability_v1250_IEs_ue_CategoryDL_r12;

typedef uint8_t SQN_UE_EUTRA_Capability_v1260_IEs_ue_CategoryDL_v1260;

enum SQN_UE_EUTRA_Capability_v1310_IEs_ue_CategoryDL_v1310_e {
	SQN_UE_EUTRA_Capability_v1310_IEs_ue_CategoryDL_v1310_e_n17 = 0,
	SQN_UE_EUTRA_Capability_v1310_IEs_ue_CategoryDL_v1310_e_m1 = 1,
};

typedef enum SQN_UE_EUTRA_Capability_v1310_IEs_ue_CategoryDL_v1310_e SQN_UE_EUTRA_Capability_v1310_IEs_ue_CategoryDL_v1310_e;

typedef uint8_t SQN_UE_EUTRA_Capability_v1330_IEs_ue_CategoryDL_v1330;

enum SQN_UE_EUTRA_Capability_v1350_IEs_ue_CategoryDL_v1350_e {
	SQN_UE_EUTRA_Capability_v1350_IEs_ue_CategoryDL_v1350_e_oneBis = 0,
};

typedef enum SQN_UE_EUTRA_Capability_v1350_IEs_ue_CategoryDL_v1350_e SQN_UE_EUTRA_Capability_v1350_IEs_ue_CategoryDL_v1350_e;

typedef uint8_t SQN_UE_EUTRA_Capability_v1450_IEs_ue_CategoryDL_v1450;

typedef uint8_t SQN_UE_EUTRA_Capability_v1460_IEs_ue_CategoryDL_v1460;

struct SQN_PhyLayerParameters {
	bool ue_TxAntennaSelectionSupported;
	bool ue_SpecificRefSigsSupported;
};

enum SQN_SupportedBandGERAN_e {
	SQN_SupportedBandGERAN_e_gsm450 = 0,
	SQN_SupportedBandGERAN_e_gsm480 = 1,
	SQN_SupportedBandGERAN_e_gsm710 = 2,
	SQN_SupportedBandGERAN_e_gsm750 = 3,
	SQN_SupportedBandGERAN_e_gsm810 = 4,
	SQN_SupportedBandGERAN_e_gsm850 = 5,
	SQN_SupportedBandGERAN_e_gsm900P = 6,
	SQN_SupportedBandGERAN_e_gsm900E = 7,
	SQN_SupportedBandGERAN_e_gsm900R = 8,
	SQN_SupportedBandGERAN_e_gsm1800 = 9,
	SQN_SupportedBandGERAN_e_gsm1900 = 10,
	SQN_SupportedBandGERAN_e_spare5 = 11,
	SQN_SupportedBandGERAN_e_spare4 = 12,
	SQN_SupportedBandGERAN_e_spare3 = 13,
	SQN_SupportedBandGERAN_e_spare2 = 14,
	SQN_SupportedBandGERAN_e_spare1 = 15,
};

typedef enum SQN_SupportedBandGERAN_e SQN_SupportedBandGERAN_e;

struct SQN_SupportedBandGERAN_e_SQN_SupportedBandListGERAN_Dynamic {
	size_t d;
	SQN_SupportedBandGERAN_e* v;
};

typedef struct SQN_SupportedBandGERAN_e_SQN_SupportedBandListGERAN_Dynamic SQN_SupportedBandListGERAN;

struct SQN_IRAT_ParametersGERAN {
	SQN_SupportedBandListGERAN supportedBandListGERAN;
	bool interRAT_PS_HO_ToGERAN;
};

enum SQN_IRAT_ParametersUTRA_v920_e_RedirectionUTRA_r9_e {
	SQN_IRAT_ParametersUTRA_v920_e_RedirectionUTRA_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v920_e_RedirectionUTRA_r9_e SQN_IRAT_ParametersUTRA_v920_e_RedirectionUTRA_r9_e;

struct SQN_IRAT_ParametersUTRA_v920 {
	SQN_IRAT_ParametersUTRA_v920_e_RedirectionUTRA_r9_e e_RedirectionUTRA_r9;
};

enum SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_1XRTT_r9_e {
	SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_1XRTT_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_1XRTT_r9_e SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_1XRTT_r9_e;

enum SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_ConcPS_Mob1XRTT_r9_e {
	SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_ConcPS_Mob1XRTT_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_ConcPS_Mob1XRTT_r9_e SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_ConcPS_Mob1XRTT_r9_e;

struct SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_ConcPS_Mob1XRTT_r9_e_e_CSFB_ConcPS_Mob1XRTT_r9_Optional {
	bool d;
	SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_ConcPS_Mob1XRTT_r9_e v;
};

struct SQN_IRAT_ParametersCDMA2000_1XRTT_v920 {
	SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_1XRTT_r9_e e_CSFB_1XRTT_r9;
	struct SQN_IRAT_ParametersCDMA2000_1XRTT_v920_e_CSFB_ConcPS_Mob1XRTT_r9_e_e_CSFB_ConcPS_Mob1XRTT_r9_Optional e_CSFB_ConcPS_Mob1XRTT_r9;
};

enum SQN_NeighCellSI_AcquisitionParameters_r9_intraFreqSI_AcquisitionForHO_r9_e {
	SQN_NeighCellSI_AcquisitionParameters_r9_intraFreqSI_AcquisitionForHO_r9_e_supported = 0,
};

typedef enum SQN_NeighCellSI_AcquisitionParameters_r9_intraFreqSI_AcquisitionForHO_r9_e SQN_NeighCellSI_AcquisitionParameters_r9_intraFreqSI_AcquisitionForHO_r9_e;

enum SQN_NeighCellSI_AcquisitionParameters_r9_interFreqSI_AcquisitionForHO_r9_e {
	SQN_NeighCellSI_AcquisitionParameters_r9_interFreqSI_AcquisitionForHO_r9_e_supported = 0,
};

typedef enum SQN_NeighCellSI_AcquisitionParameters_r9_interFreqSI_AcquisitionForHO_r9_e SQN_NeighCellSI_AcquisitionParameters_r9_interFreqSI_AcquisitionForHO_r9_e;

enum SQN_NeighCellSI_AcquisitionParameters_r9_utran_SI_AcquisitionForHO_r9_e {
	SQN_NeighCellSI_AcquisitionParameters_r9_utran_SI_AcquisitionForHO_r9_e_supported = 0,
};

typedef enum SQN_NeighCellSI_AcquisitionParameters_r9_utran_SI_AcquisitionForHO_r9_e SQN_NeighCellSI_AcquisitionParameters_r9_utran_SI_AcquisitionForHO_r9_e;

struct SQN_NeighCellSI_AcquisitionParameters_r9_intraFreqSI_AcquisitionForHO_r9_e_intraFreqSI_AcquisitionForHO_r9_Optional {
	bool d;
	SQN_NeighCellSI_AcquisitionParameters_r9_intraFreqSI_AcquisitionForHO_r9_e v;
};

struct SQN_NeighCellSI_AcquisitionParameters_r9_interFreqSI_AcquisitionForHO_r9_e_interFreqSI_AcquisitionForHO_r9_Optional {
	bool d;
	SQN_NeighCellSI_AcquisitionParameters_r9_interFreqSI_AcquisitionForHO_r9_e v;
};

struct SQN_NeighCellSI_AcquisitionParameters_r9_utran_SI_AcquisitionForHO_r9_e_utran_SI_AcquisitionForHO_r9_Optional {
	bool d;
	SQN_NeighCellSI_AcquisitionParameters_r9_utran_SI_AcquisitionForHO_r9_e v;
};

struct SQN_NeighCellSI_AcquisitionParameters_r9 {
	struct SQN_NeighCellSI_AcquisitionParameters_r9_intraFreqSI_AcquisitionForHO_r9_e_intraFreqSI_AcquisitionForHO_r9_Optional intraFreqSI_AcquisitionForHO_r9;
	struct SQN_NeighCellSI_AcquisitionParameters_r9_interFreqSI_AcquisitionForHO_r9_e_interFreqSI_AcquisitionForHO_r9_Optional interFreqSI_AcquisitionForHO_r9;
	struct SQN_NeighCellSI_AcquisitionParameters_r9_utran_SI_AcquisitionForHO_r9_e_utran_SI_AcquisitionForHO_r9_Optional utran_SI_AcquisitionForHO_r9;
};

struct SQN_PhyLayerParameters_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_phyLayerParameters_r9_Optional {
	bool d;
	struct SQN_PhyLayerParameters v;
};

struct B32_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_featureGroupIndicators_r9_Optional {
	bool d;
	B32 v;
};

struct B32_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_featureGroupIndRel9Add_r9_Optional {
	bool d;
	B32 v;
};

struct SQN_IRAT_ParametersGERAN_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_interRAT_ParametersGERAN_r9_Optional {
	bool d;
	struct SQN_IRAT_ParametersGERAN v;
};

struct SQN_IRAT_ParametersUTRA_v920_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_interRAT_ParametersUTRA_r9_Optional {
	bool d;
	struct SQN_IRAT_ParametersUTRA_v920 v;
};

struct SQN_IRAT_ParametersCDMA2000_1XRTT_v920_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_interRAT_ParametersCDMA2000_r9_Optional {
	bool d;
	struct SQN_IRAT_ParametersCDMA2000_1XRTT_v920 v;
};

struct SQN_NeighCellSI_AcquisitionParameters_r9_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_neighCellSI_AcquisitionParameters_r9_Optional {
	bool d;
	struct SQN_NeighCellSI_AcquisitionParameters_r9 v;
};

struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9 {
	struct SQN_PhyLayerParameters_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_phyLayerParameters_r9_Optional phyLayerParameters_r9;
	struct B32_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_featureGroupIndicators_r9_Optional featureGroupIndicators_r9;
	struct B32_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_featureGroupIndRel9Add_r9_Optional featureGroupIndRel9Add_r9;
	struct SQN_IRAT_ParametersGERAN_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_interRAT_ParametersGERAN_r9_Optional interRAT_ParametersGERAN_r9;
	struct SQN_IRAT_ParametersUTRA_v920_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_interRAT_ParametersUTRA_r9_Optional interRAT_ParametersUTRA_r9;
	struct SQN_IRAT_ParametersCDMA2000_1XRTT_v920_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_interRAT_ParametersCDMA2000_r9_Optional interRAT_ParametersCDMA2000_r9;
	struct SQN_NeighCellSI_AcquisitionParameters_r9_SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_neighCellSI_AcquisitionParameters_r9_Optional neighCellSI_AcquisitionParameters_r9;
};

enum SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_FDD_r9_e {
	SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_FDD_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_FDD_r9_e SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_FDD_r9_e;

enum SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_TDD128_r9_e {
	SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_TDD128_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_TDD128_r9_e SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_TDD128_r9_e;

enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_e {
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_e SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_e;

enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToGERAN_r9_e {
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToGERAN_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToGERAN_r9_e SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToGERAN_r9_e;

enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_e {
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_e SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_e;

enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToGERAN_r9_e {
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToGERAN_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToGERAN_r9_e SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToGERAN_r9_e;

struct SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_FDD_r9_e_voiceOverPS_HS_UTRA_FDD_r9_Optional {
	bool d;
	SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_FDD_r9_e v;
};

struct SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_TDD128_r9_e_voiceOverPS_HS_UTRA_TDD128_r9_Optional {
	bool d;
	SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_TDD128_r9_e v;
};

struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_e_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_Optional {
	bool d;
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_e v;
};

struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToGERAN_r9_e_srvcc_FromUTRA_FDD_ToGERAN_r9_Optional {
	bool d;
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToGERAN_r9_e v;
};

struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_e_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_Optional {
	bool d;
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_e v;
};

struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToGERAN_r9_e_srvcc_FromUTRA_TDD128_ToGERAN_r9_Optional {
	bool d;
	SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToGERAN_r9_e v;
};

struct SQN_IRAT_ParametersUTRA_v9c0 {
	struct SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_FDD_r9_e_voiceOverPS_HS_UTRA_FDD_r9_Optional voiceOverPS_HS_UTRA_FDD_r9;
	struct SQN_IRAT_ParametersUTRA_v9c0_voiceOverPS_HS_UTRA_TDD128_r9_e_voiceOverPS_HS_UTRA_TDD128_r9_Optional voiceOverPS_HS_UTRA_TDD128_r9;
	struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_e_srvcc_FromUTRA_FDD_ToUTRA_FDD_r9_Optional srvcc_FromUTRA_FDD_ToUTRA_FDD_r9;
	struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_FDD_ToGERAN_r9_e_srvcc_FromUTRA_FDD_ToGERAN_r9_Optional srvcc_FromUTRA_FDD_ToGERAN_r9;
	struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_e_srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9_Optional srvcc_FromUTRA_TDD128_ToUTRA_TDD128_r9;
	struct SQN_IRAT_ParametersUTRA_v9c0_srvcc_FromUTRA_TDD128_ToGERAN_r9_e_srvcc_FromUTRA_TDD128_ToGERAN_r9_Optional srvcc_FromUTRA_TDD128_ToGERAN_r9;
};

enum SQN_PhyLayerParameters_v9d0_tm5_FDD_r9_e {
	SQN_PhyLayerParameters_v9d0_tm5_FDD_r9_e_supported = 0,
};

typedef enum SQN_PhyLayerParameters_v9d0_tm5_FDD_r9_e SQN_PhyLayerParameters_v9d0_tm5_FDD_r9_e;

enum SQN_PhyLayerParameters_v9d0_tm5_TDD_r9_e {
	SQN_PhyLayerParameters_v9d0_tm5_TDD_r9_e_supported = 0,
};

typedef enum SQN_PhyLayerParameters_v9d0_tm5_TDD_r9_e SQN_PhyLayerParameters_v9d0_tm5_TDD_r9_e;

struct SQN_PhyLayerParameters_v9d0_tm5_FDD_r9_e_tm5_FDD_r9_Optional {
	bool d;
	SQN_PhyLayerParameters_v9d0_tm5_FDD_r9_e v;
};

struct SQN_PhyLayerParameters_v9d0_tm5_TDD_r9_e_tm5_TDD_r9_Optional {
	bool d;
	SQN_PhyLayerParameters_v9d0_tm5_TDD_r9_e v;
};

struct SQN_PhyLayerParameters_v9d0 {
	struct SQN_PhyLayerParameters_v9d0_tm5_FDD_r9_e_tm5_FDD_r9_Optional tm5_FDD_r9;
	struct SQN_PhyLayerParameters_v9d0_tm5_TDD_r9_e_tm5_TDD_r9_Optional tm5_TDD_r9;
};

typedef uint16_t SQN_FreqBandIndicator_v9e0;

struct SQN_FreqBandIndicator_v9e0_SQN_SupportedBandEUTRA_v9e0_bandEUTRA_v9e0_Optional {
	bool d;
	SQN_FreqBandIndicator_v9e0 v;
};

struct SQN_SupportedBandEUTRA_v9e0 {
	struct SQN_FreqBandIndicator_v9e0_SQN_SupportedBandEUTRA_v9e0_bandEUTRA_v9e0_Optional bandEUTRA_v9e0;
};

struct SQN_SupportedBandEUTRA_v9e0_SQN_SupportedBandListEUTRA_v9e0_Dynamic {
	size_t d;
	struct SQN_SupportedBandEUTRA_v9e0* v;
};

typedef struct SQN_SupportedBandEUTRA_v9e0_SQN_SupportedBandListEUTRA_v9e0_Dynamic SQN_SupportedBandListEUTRA_v9e0;

struct SQN_SupportedBandListEUTRA_v9e0_SQN_RF_Parameters_v9e0_supportedBandListEUTRA_v9e0_Optional {
	bool d;
	SQN_SupportedBandListEUTRA_v9e0 v;
};

struct SQN_RF_Parameters_v9e0 {
	struct SQN_SupportedBandListEUTRA_v9e0_SQN_RF_Parameters_v9e0_supportedBandListEUTRA_v9e0_Optional supportedBandListEUTRA_v9e0;
};

enum SQN_IRAT_ParametersUTRA_v9h0_mfbi_UTRA_r9_e {
	SQN_IRAT_ParametersUTRA_v9h0_mfbi_UTRA_r9_e_supported = 0,
};

typedef enum SQN_IRAT_ParametersUTRA_v9h0_mfbi_UTRA_r9_e SQN_IRAT_ParametersUTRA_v9h0_mfbi_UTRA_r9_e;

struct SQN_IRAT_ParametersUTRA_v9h0 {
	SQN_IRAT_ParametersUTRA_v9h0_mfbi_UTRA_r9_e mfbi_UTRA_r9;
};

enum SQN_OTDOA_PositioningCapabilities_r10_otdoa_UE_Assisted_r10_e {
	SQN_OTDOA_PositioningCapabilities_r10_otdoa_UE_Assisted_r10_e_supported = 0,
};

typedef enum SQN_OTDOA_PositioningCapabilities_r10_otdoa_UE_Assisted_r10_e SQN_OTDOA_PositioningCapabilities_r10_otdoa_UE_Assisted_r10_e;

enum SQN_OTDOA_PositioningCapabilities_r10_interFreqRSTD_Measurement_r10_e {
	SQN_OTDOA_PositioningCapabilities_r10_interFreqRSTD_Measurement_r10_e_supported = 0,
};

typedef enum SQN_OTDOA_PositioningCapabilities_r10_interFreqRSTD_Measurement_r10_e SQN_OTDOA_PositioningCapabilities_r10_interFreqRSTD_Measurement_r10_e;

struct SQN_OTDOA_PositioningCapabilities_r10_interFreqRSTD_Measurement_r10_e_interFreqRSTD_Measurement_r10_Optional {
	bool d;
	SQN_OTDOA_PositioningCapabilities_r10_interFreqRSTD_Measurement_r10_e v;
};

struct SQN_OTDOA_PositioningCapabilities_r10 {
	SQN_OTDOA_PositioningCapabilities_r10_otdoa_UE_Assisted_r10_e otdoa_UE_Assisted_r10;
	struct SQN_OTDOA_PositioningCapabilities_r10_interFreqRSTD_Measurement_r10_e_interFreqRSTD_Measurement_r10_Optional interFreqRSTD_Measurement_r10;
};

struct B32_SQN_RF_Parameters_v10f0_modifiedMPR_Behavior_r10_Optional {
	bool d;
	B32 v;
};

struct SQN_RF_Parameters_v10f0 {
	struct B32_SQN_RF_Parameters_v10f0_modifiedMPR_Behavior_r10_Optional modifiedMPR_Behavior_r10;
};

enum SQN_CA_MIMO_ParametersDL_v10i0_fourLayerTM3_TM4_r10_e {
	SQN_CA_MIMO_ParametersDL_v10i0_fourLayerTM3_TM4_r10_e_supported = 0,
};

typedef enum SQN_CA_MIMO_ParametersDL_v10i0_fourLayerTM3_TM4_r10_e SQN_CA_MIMO_ParametersDL_v10i0_fourLayerTM3_TM4_r10_e;

struct SQN_CA_MIMO_ParametersDL_v10i0_fourLayerTM3_TM4_r10_e_fourLayerTM3_TM4_r10_Optional {
	bool d;
	SQN_CA_MIMO_ParametersDL_v10i0_fourLayerTM3_TM4_r10_e v;
};

struct SQN_CA_MIMO_ParametersDL_v10i0 {
	struct SQN_CA_MIMO_ParametersDL_v10i0_fourLayerTM3_TM4_r10_e_fourLayerTM3_TM4_r10_Optional fourLayerTM3_TM4_r10;
};

struct SQN_CA_MIMO_ParametersDL_v10i0_SQN_BandParameters_v10i0_bandParametersDL_v10i0_Dynamic {
	size_t d;
	struct SQN_CA_MIMO_ParametersDL_v10i0* v;
};

struct SQN_BandParameters_v10i0 {
	struct SQN_CA_MIMO_ParametersDL_v10i0_SQN_BandParameters_v10i0_bandParametersDL_v10i0_Dynamic bandParametersDL_v10i0;
};

struct SQN_BandCombinationParameters_v10i0_SQN_BandParameters_v10i0_bandParameterList_v10i0_Dynamic {
	size_t d;
	struct SQN_BandParameters_v10i0* v;
};

struct SQN_BandParameters_v10i0_SQN_BandCombinationParameters_v10i0_bandParameterList_v10i0_DynamicOptional {
	bool d;
	struct SQN_BandCombinationParameters_v10i0_SQN_BandParameters_v10i0_bandParameterList_v10i0_Dynamic v;
};

struct SQN_BandCombinationParameters_v10i0 {
	struct SQN_BandParameters_v10i0_SQN_BandCombinationParameters_v10i0_bandParameterList_v10i0_DynamicOptional bandParameterList_v10i0;
};

struct SQN_BandCombinationParameters_v10i0_SQN_SupportedBandCombination_v10i0_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v10i0* v;
};

typedef struct SQN_BandCombinationParameters_v10i0_SQN_SupportedBandCombination_v10i0_Dynamic SQN_SupportedBandCombination_v10i0;

struct SQN_SupportedBandCombination_v10i0_SQN_RF_Parameters_v10i0_supportedBandCombination_v10i0_Optional {
	bool d;
	SQN_SupportedBandCombination_v10i0 v;
};

struct SQN_RF_Parameters_v10i0 {
	struct SQN_SupportedBandCombination_v10i0_SQN_RF_Parameters_v10i0_supportedBandCombination_v10i0_Optional supportedBandCombination_v10i0;
};

struct SQN_BandCombinationParameters_v10i0_SQN_SupportedBandCombinationAdd_v11d0_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v10i0* v;
};

typedef struct SQN_BandCombinationParameters_v10i0_SQN_SupportedBandCombinationAdd_v11d0_Dynamic SQN_SupportedBandCombinationAdd_v11d0;

struct SQN_SupportedBandCombinationAdd_v11d0_SQN_RF_Parameters_v11d0_supportedBandCombinationAdd_v11d0_Optional {
	bool d;
	SQN_SupportedBandCombinationAdd_v11d0 v;
};

struct SQN_RF_Parameters_v11d0 {
	struct SQN_SupportedBandCombinationAdd_v11d0_SQN_RF_Parameters_v11d0_supportedBandCombinationAdd_v11d0_Optional supportedBandCombinationAdd_v11d0;
};

enum SQN_Other_Parameters_v11d0_inDeviceCoexInd_UL_CA_r11_e {
	SQN_Other_Parameters_v11d0_inDeviceCoexInd_UL_CA_r11_e_supported = 0,
};

typedef enum SQN_Other_Parameters_v11d0_inDeviceCoexInd_UL_CA_r11_e SQN_Other_Parameters_v11d0_inDeviceCoexInd_UL_CA_r11_e;

struct SQN_Other_Parameters_v11d0_inDeviceCoexInd_UL_CA_r11_e_inDeviceCoexInd_UL_CA_r11_Optional {
	bool d;
	SQN_Other_Parameters_v11d0_inDeviceCoexInd_UL_CA_r11_e v;
};

struct SQN_Other_Parameters_v11d0 {
	struct SQN_Other_Parameters_v11d0_inDeviceCoexInd_UL_CA_r11_e_inDeviceCoexInd_UL_CA_r11_Optional inDeviceCoexInd_UL_CA_r11;
};

enum SQN_RF_Parameters_v12b0_maxLayersMIMO_Indication_r12_e {
	SQN_RF_Parameters_v12b0_maxLayersMIMO_Indication_r12_e_supported = 0,
};

typedef enum SQN_RF_Parameters_v12b0_maxLayersMIMO_Indication_r12_e SQN_RF_Parameters_v12b0_maxLayersMIMO_Indication_r12_e;

struct SQN_RF_Parameters_v12b0_maxLayersMIMO_Indication_r12_e_maxLayersMIMO_Indication_r12_Optional {
	bool d;
	SQN_RF_Parameters_v12b0_maxLayersMIMO_Indication_r12_e v;
};

struct SQN_RF_Parameters_v12b0 {
	struct SQN_RF_Parameters_v12b0_maxLayersMIMO_Indication_r12_e_maxLayersMIMO_Indication_r12_Optional maxLayersMIMO_Indication_r12;
};

enum SQN_CE_Parameters_v1370_tm9_CE_ModeA_r13_e {
	SQN_CE_Parameters_v1370_tm9_CE_ModeA_r13_e_supported = 0,
};

typedef enum SQN_CE_Parameters_v1370_tm9_CE_ModeA_r13_e SQN_CE_Parameters_v1370_tm9_CE_ModeA_r13_e;

enum SQN_CE_Parameters_v1370_tm9_CE_ModeB_r13_e {
	SQN_CE_Parameters_v1370_tm9_CE_ModeB_r13_e_supported = 0,
};

typedef enum SQN_CE_Parameters_v1370_tm9_CE_ModeB_r13_e SQN_CE_Parameters_v1370_tm9_CE_ModeB_r13_e;

struct SQN_CE_Parameters_v1370_tm9_CE_ModeA_r13_e_tm9_CE_ModeA_r13_Optional {
	bool d;
	SQN_CE_Parameters_v1370_tm9_CE_ModeA_r13_e v;
};

struct SQN_CE_Parameters_v1370_tm9_CE_ModeB_r13_e_tm9_CE_ModeB_r13_Optional {
	bool d;
	SQN_CE_Parameters_v1370_tm9_CE_ModeB_r13_e v;
};

struct SQN_CE_Parameters_v1370 {
	struct SQN_CE_Parameters_v1370_tm9_CE_ModeA_r13_e_tm9_CE_ModeA_r13_Optional tm9_CE_ModeA_r13;
	struct SQN_CE_Parameters_v1370_tm9_CE_ModeB_r13_e_tm9_CE_ModeB_r13_Optional tm9_CE_ModeB_r13;
};

struct SQN_CE_Parameters_v1370_SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370_ce_Parameters_v1370_Optional {
	bool d;
	struct SQN_CE_Parameters_v1370 v;
};

struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370 {
	struct SQN_CE_Parameters_v1370_SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370_ce_Parameters_v1370_Optional ce_Parameters_v1370;
};

struct uint8_t_SQN_BandParameters_v1380_txAntennaSwitchDL_r13_Optional {
	bool d;
	uint8_t v;
};

struct uint8_t_SQN_BandParameters_v1380_txAntennaSwitchUL_r13_Optional {
	bool d;
	uint8_t v;
};

struct SQN_BandParameters_v1380 {
	struct uint8_t_SQN_BandParameters_v1380_txAntennaSwitchDL_r13_Optional txAntennaSwitchDL_r13;
	struct uint8_t_SQN_BandParameters_v1380_txAntennaSwitchUL_r13_Optional txAntennaSwitchUL_r13;
};

struct SQN_BandCombinationParameters_v1380_SQN_BandParameters_v1380_bandParameterList_v1380_Dynamic {
	size_t d;
	struct SQN_BandParameters_v1380* v;
};

struct SQN_BandParameters_v1380_SQN_BandCombinationParameters_v1380_bandParameterList_v1380_DynamicOptional {
	bool d;
	struct SQN_BandCombinationParameters_v1380_SQN_BandParameters_v1380_bandParameterList_v1380_Dynamic v;
};

struct SQN_BandCombinationParameters_v1380 {
	struct SQN_BandParameters_v1380_SQN_BandCombinationParameters_v1380_bandParameterList_v1380_DynamicOptional bandParameterList_v1380;
};

struct SQN_BandCombinationParameters_v1380_SQN_SupportedBandCombination_v1380_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1380* v;
};

typedef struct SQN_BandCombinationParameters_v1380_SQN_SupportedBandCombination_v1380_Dynamic SQN_SupportedBandCombination_v1380;

struct SQN_BandCombinationParameters_v1380_SQN_SupportedBandCombinationAdd_v1380_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1380* v;
};

typedef struct SQN_BandCombinationParameters_v1380_SQN_SupportedBandCombinationAdd_v1380_Dynamic SQN_SupportedBandCombinationAdd_v1380;

struct SQN_BandCombinationParameters_v1380_SQN_SupportedBandCombinationReduced_v1380_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1380* v;
};

typedef struct SQN_BandCombinationParameters_v1380_SQN_SupportedBandCombinationReduced_v1380_Dynamic SQN_SupportedBandCombinationReduced_v1380;

struct SQN_SupportedBandCombination_v1380_SQN_RF_Parameters_v1380_supportedBandCombination_v1380_Optional {
	bool d;
	SQN_SupportedBandCombination_v1380 v;
};

struct SQN_SupportedBandCombinationAdd_v1380_SQN_RF_Parameters_v1380_supportedBandCombinationAdd_v1380_Optional {
	bool d;
	SQN_SupportedBandCombinationAdd_v1380 v;
};

struct SQN_SupportedBandCombinationReduced_v1380_SQN_RF_Parameters_v1380_supportedBandCombinationReduced_v1380_Optional {
	bool d;
	SQN_SupportedBandCombinationReduced_v1380 v;
};

struct SQN_RF_Parameters_v1380 {
	struct SQN_SupportedBandCombination_v1380_SQN_RF_Parameters_v1380_supportedBandCombination_v1380_Optional supportedBandCombination_v1380;
	struct SQN_SupportedBandCombinationAdd_v1380_SQN_RF_Parameters_v1380_supportedBandCombinationAdd_v1380_Optional supportedBandCombinationAdd_v1380;
	struct SQN_SupportedBandCombinationReduced_v1380_SQN_RF_Parameters_v1380_supportedBandCombinationReduced_v1380_Optional supportedBandCombinationReduced_v1380;
};

enum SQN_CE_Parameters_v1380_tm6_CE_ModeA_r13_e {
	SQN_CE_Parameters_v1380_tm6_CE_ModeA_r13_e_supported = 0,
};

typedef enum SQN_CE_Parameters_v1380_tm6_CE_ModeA_r13_e SQN_CE_Parameters_v1380_tm6_CE_ModeA_r13_e;

struct SQN_CE_Parameters_v1380_tm6_CE_ModeA_r13_e_tm6_CE_ModeA_r13_Optional {
	bool d;
	SQN_CE_Parameters_v1380_tm6_CE_ModeA_r13_e v;
};

struct SQN_CE_Parameters_v1380 {
	struct SQN_CE_Parameters_v1380_tm6_CE_ModeA_r13_e_tm6_CE_ModeA_r13_Optional tm6_CE_ModeA_r13;
};

struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1380 {
	struct SQN_CE_Parameters_v1380 ce_Parameters_v1380;
};

enum SQN_BandCombinationParameters_v1390_ue_CA_PowerClass_N_r13_e {
	SQN_BandCombinationParameters_v1390_ue_CA_PowerClass_N_r13_e_class2 = 0,
};

typedef enum SQN_BandCombinationParameters_v1390_ue_CA_PowerClass_N_r13_e SQN_BandCombinationParameters_v1390_ue_CA_PowerClass_N_r13_e;

struct SQN_BandCombinationParameters_v1390_ue_CA_PowerClass_N_r13_e_ue_CA_PowerClass_N_r13_Optional {
	bool d;
	SQN_BandCombinationParameters_v1390_ue_CA_PowerClass_N_r13_e v;
};

struct SQN_BandCombinationParameters_v1390 {
	struct SQN_BandCombinationParameters_v1390_ue_CA_PowerClass_N_r13_e_ue_CA_PowerClass_N_r13_Optional ue_CA_PowerClass_N_r13;
};

struct SQN_BandCombinationParameters_v1390_SQN_SupportedBandCombination_v1390_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1390* v;
};

typedef struct SQN_BandCombinationParameters_v1390_SQN_SupportedBandCombination_v1390_Dynamic SQN_SupportedBandCombination_v1390;

struct SQN_BandCombinationParameters_v1390_SQN_SupportedBandCombinationAdd_v1390_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1390* v;
};

typedef struct SQN_BandCombinationParameters_v1390_SQN_SupportedBandCombinationAdd_v1390_Dynamic SQN_SupportedBandCombinationAdd_v1390;

struct SQN_BandCombinationParameters_v1390_SQN_SupportedBandCombinationReduced_v1390_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1390* v;
};

typedef struct SQN_BandCombinationParameters_v1390_SQN_SupportedBandCombinationReduced_v1390_Dynamic SQN_SupportedBandCombinationReduced_v1390;

struct SQN_SupportedBandCombination_v1390_SQN_RF_Parameters_v1390_supportedBandCombination_v1390_Optional {
	bool d;
	SQN_SupportedBandCombination_v1390 v;
};

struct SQN_SupportedBandCombinationAdd_v1390_SQN_RF_Parameters_v1390_supportedBandCombinationAdd_v1390_Optional {
	bool d;
	SQN_SupportedBandCombinationAdd_v1390 v;
};

struct SQN_SupportedBandCombinationReduced_v1390_SQN_RF_Parameters_v1390_supportedBandCombinationReduced_v1390_Optional {
	bool d;
	SQN_SupportedBandCombinationReduced_v1390 v;
};

struct SQN_RF_Parameters_v1390 {
	struct SQN_SupportedBandCombination_v1390_SQN_RF_Parameters_v1390_supportedBandCombination_v1390_Optional supportedBandCombination_v1390;
	struct SQN_SupportedBandCombinationAdd_v1390_SQN_RF_Parameters_v1390_supportedBandCombinationAdd_v1390_Optional supportedBandCombinationAdd_v1390;
	struct SQN_SupportedBandCombinationReduced_v1390_SQN_RF_Parameters_v1390_supportedBandCombinationReduced_v1390_Optional supportedBandCombinationReduced_v1390;
};

enum SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14_Sel {
	SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14_UNBOUND_VALUE = 0,
	SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14_implicitValue = 1,
	SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14_explicitValue = 2,
};

union SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14_Value {
	Null implicitValue;
	uint8_t explicitValue;
};

struct SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14 {
	enum SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14_Sel d;
	union SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14_Value v;
};

enum SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e {
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e_n3 = 0,
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e_n6 = 1,
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e_n9 = 2,
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e_n12 = 3,
};

typedef enum SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e;

enum SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e {
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e_n1 = 0,
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e_n2 = 1,
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e_n3 = 2,
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e_n4 = 3,
};

typedef enum SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e;

struct SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e_mbms_ScalingFactor1dot25_r14_Optional {
	bool d;
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e v;
};

struct SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e_mbms_ScalingFactor7dot5_r14_Optional {
	bool d;
	SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e v;
};

struct SQN_MBMS_Parameters_v1470 {
	struct SQN_MBMS_Parameters_v1470_mbms_MaxBW_r14 mbms_MaxBW_r14;
	struct SQN_MBMS_Parameters_v1470_mbms_ScalingFactor1dot25_r14_e_mbms_ScalingFactor1dot25_r14_Optional mbms_ScalingFactor1dot25_r14;
	struct SQN_MBMS_Parameters_v1470_mbms_ScalingFactor7dot5_r14_e_mbms_ScalingFactor7dot5_r14_Optional mbms_ScalingFactor7dot5_r14;
};

enum SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e {
	SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n8 = 0,
	SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n12 = 1,
	SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n16 = 2,
	SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n20 = 3,
	SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n24 = 4,
	SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n28 = 5,
};

typedef enum SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e;

struct SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_csi_ReportingAdvancedMaxPorts_r14_Optional {
	bool d;
	SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e v;
};

struct SQN_MIMO_UE_ParametersPerTM_v1470 {
	struct SQN_MIMO_UE_ParametersPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_csi_ReportingAdvancedMaxPorts_r14_Optional csi_ReportingAdvancedMaxPorts_r14;
};

struct SQN_MIMO_UE_Parameters_v1470 {
	struct SQN_MIMO_UE_ParametersPerTM_v1470 parametersTM9_v1470;
	struct SQN_MIMO_UE_ParametersPerTM_v1470 parametersTM10_v1470;
};

enum SQN_PhyLayerParameters_v1470_srs_UpPTS_6sym_r14_e {
	SQN_PhyLayerParameters_v1470_srs_UpPTS_6sym_r14_e_supported = 0,
};

typedef enum SQN_PhyLayerParameters_v1470_srs_UpPTS_6sym_r14_e SQN_PhyLayerParameters_v1470_srs_UpPTS_6sym_r14_e;

struct SQN_MIMO_UE_Parameters_v1470_SQN_PhyLayerParameters_v1470_mimo_UE_Parameters_v1470_Optional {
	bool d;
	struct SQN_MIMO_UE_Parameters_v1470 v;
};

struct SQN_PhyLayerParameters_v1470_srs_UpPTS_6sym_r14_e_srs_UpPTS_6sym_r14_Optional {
	bool d;
	SQN_PhyLayerParameters_v1470_srs_UpPTS_6sym_r14_e v;
};

struct SQN_PhyLayerParameters_v1470 {
	struct SQN_MIMO_UE_Parameters_v1470_SQN_PhyLayerParameters_v1470_mimo_UE_Parameters_v1470_Optional mimo_UE_Parameters_v1470;
	struct SQN_PhyLayerParameters_v1470_srs_UpPTS_6sym_r14_e_srs_UpPTS_6sym_r14_Optional srs_UpPTS_6sym_r14;
};

enum SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e {
	SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n8 = 0,
	SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n12 = 1,
	SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n16 = 2,
	SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n20 = 3,
	SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n24 = 4,
	SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_n28 = 5,
};

typedef enum SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e;

struct SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_csi_ReportingAdvancedMaxPorts_r14_Optional {
	bool d;
	SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e v;
};

struct SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470 {
	struct SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470_csi_ReportingAdvancedMaxPorts_r14_e_csi_ReportingAdvancedMaxPorts_r14_Optional csi_ReportingAdvancedMaxPorts_r14;
};

struct SQN_MIMO_CA_ParametersPerBoBC_v1470 {
	struct SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470 parametersTM9_v1470;
	struct SQN_MIMO_CA_ParametersPerBoBCPerTM_v1470 parametersTM10_v1470;
};

struct SQN_MIMO_CA_ParametersPerBoBC_v1470_SQN_BandParameters_v1470_bandParametersDL_v1470_Optional {
	bool d;
	struct SQN_MIMO_CA_ParametersPerBoBC_v1470 v;
};

struct SQN_BandParameters_v1470 {
	struct SQN_MIMO_CA_ParametersPerBoBC_v1470_SQN_BandParameters_v1470_bandParametersDL_v1470_Optional bandParametersDL_v1470;
};

struct SQN_BandCombinationParameters_v1470_SQN_BandParameters_v1470_bandParameterList_v1470_Dynamic {
	size_t d;
	struct SQN_BandParameters_v1470* v;
};

struct SQN_BandParameters_v1470_SQN_BandCombinationParameters_v1470_bandParameterList_v1470_DynamicOptional {
	bool d;
	struct SQN_BandCombinationParameters_v1470_SQN_BandParameters_v1470_bandParameterList_v1470_Dynamic v;
};

struct uint8_t_SQN_BandCombinationParameters_v1470_srs_MaxSimultaneousCCs_r14_Optional {
	bool d;
	uint8_t v;
};

struct SQN_BandCombinationParameters_v1470 {
	struct SQN_BandParameters_v1470_SQN_BandCombinationParameters_v1470_bandParameterList_v1470_DynamicOptional bandParameterList_v1470;
	struct uint8_t_SQN_BandCombinationParameters_v1470_srs_MaxSimultaneousCCs_r14_Optional srs_MaxSimultaneousCCs_r14;
};

struct SQN_BandCombinationParameters_v1470_SQN_SupportedBandCombination_v1470_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1470* v;
};

typedef struct SQN_BandCombinationParameters_v1470_SQN_SupportedBandCombination_v1470_Dynamic SQN_SupportedBandCombination_v1470;

struct SQN_BandCombinationParameters_v1470_SQN_SupportedBandCombinationAdd_v1470_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1470* v;
};

typedef struct SQN_BandCombinationParameters_v1470_SQN_SupportedBandCombinationAdd_v1470_Dynamic SQN_SupportedBandCombinationAdd_v1470;

struct SQN_BandCombinationParameters_v1470_SQN_SupportedBandCombinationReduced_v1470_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v1470* v;
};

typedef struct SQN_BandCombinationParameters_v1470_SQN_SupportedBandCombinationReduced_v1470_Dynamic SQN_SupportedBandCombinationReduced_v1470;

struct SQN_SupportedBandCombination_v1470_SQN_RF_Parameters_v1470_supportedBandCombination_v1470_Optional {
	bool d;
	SQN_SupportedBandCombination_v1470 v;
};

struct SQN_SupportedBandCombinationAdd_v1470_SQN_RF_Parameters_v1470_supportedBandCombinationAdd_v1470_Optional {
	bool d;
	SQN_SupportedBandCombinationAdd_v1470 v;
};

struct SQN_SupportedBandCombinationReduced_v1470_SQN_RF_Parameters_v1470_supportedBandCombinationReduced_v1470_Optional {
	bool d;
	SQN_SupportedBandCombinationReduced_v1470 v;
};

struct SQN_RF_Parameters_v1470 {
	struct SQN_SupportedBandCombination_v1470_SQN_RF_Parameters_v1470_supportedBandCombination_v1470_Optional supportedBandCombination_v1470;
	struct SQN_SupportedBandCombinationAdd_v1470_SQN_RF_Parameters_v1470_supportedBandCombinationAdd_v1470_Optional supportedBandCombinationAdd_v1470;
	struct SQN_SupportedBandCombinationReduced_v1470_SQN_RF_Parameters_v1470_supportedBandCombinationReduced_v1470_Optional supportedBandCombinationReduced_v1470;
};

enum SQN_PhyLayerParameters_v14a0_ssp10_TDD_Only_r14_e {
	SQN_PhyLayerParameters_v14a0_ssp10_TDD_Only_r14_e_supported = 0,
};

typedef enum SQN_PhyLayerParameters_v14a0_ssp10_TDD_Only_r14_e SQN_PhyLayerParameters_v14a0_ssp10_TDD_Only_r14_e;

struct SQN_PhyLayerParameters_v14a0_ssp10_TDD_Only_r14_e_ssp10_TDD_Only_r14_Optional {
	bool d;
	SQN_PhyLayerParameters_v14a0_ssp10_TDD_Only_r14_e v;
};

struct SQN_PhyLayerParameters_v14a0 {
	struct SQN_PhyLayerParameters_v14a0_ssp10_TDD_Only_r14_e_ssp10_TDD_Only_r14_Optional ssp10_TDD_Only_r14;
};

enum SQN_SRS_CapabilityPerBandPair_v14b0_srs_FlexibleTiming_r14_e {
	SQN_SRS_CapabilityPerBandPair_v14b0_srs_FlexibleTiming_r14_e_supported = 0,
};

typedef enum SQN_SRS_CapabilityPerBandPair_v14b0_srs_FlexibleTiming_r14_e SQN_SRS_CapabilityPerBandPair_v14b0_srs_FlexibleTiming_r14_e;

enum SQN_SRS_CapabilityPerBandPair_v14b0_srs_HARQ_ReferenceConfig_r14_e {
	SQN_SRS_CapabilityPerBandPair_v14b0_srs_HARQ_ReferenceConfig_r14_e_supported = 0,
};

typedef enum SQN_SRS_CapabilityPerBandPair_v14b0_srs_HARQ_ReferenceConfig_r14_e SQN_SRS_CapabilityPerBandPair_v14b0_srs_HARQ_ReferenceConfig_r14_e;

struct SQN_SRS_CapabilityPerBandPair_v14b0_srs_FlexibleTiming_r14_e_srs_FlexibleTiming_r14_Optional {
	bool d;
	SQN_SRS_CapabilityPerBandPair_v14b0_srs_FlexibleTiming_r14_e v;
};

struct SQN_SRS_CapabilityPerBandPair_v14b0_srs_HARQ_ReferenceConfig_r14_e_srs_HARQ_ReferenceConfig_r14_Optional {
	bool d;
	SQN_SRS_CapabilityPerBandPair_v14b0_srs_HARQ_ReferenceConfig_r14_e v;
};

struct SQN_SRS_CapabilityPerBandPair_v14b0 {
	struct SQN_SRS_CapabilityPerBandPair_v14b0_srs_FlexibleTiming_r14_e_srs_FlexibleTiming_r14_Optional srs_FlexibleTiming_r14;
	struct SQN_SRS_CapabilityPerBandPair_v14b0_srs_HARQ_ReferenceConfig_r14_e_srs_HARQ_ReferenceConfig_r14_Optional srs_HARQ_ReferenceConfig_r14;
};

struct SQN_BandParameters_v14b0_SQN_SRS_CapabilityPerBandPair_v14b0_srs_CapabilityPerBandPairList_v14b0_Dynamic {
	size_t d;
	struct SQN_SRS_CapabilityPerBandPair_v14b0* v;
};

struct SQN_SRS_CapabilityPerBandPair_v14b0_SQN_BandParameters_v14b0_srs_CapabilityPerBandPairList_v14b0_DynamicOptional {
	bool d;
	struct SQN_BandParameters_v14b0_SQN_SRS_CapabilityPerBandPair_v14b0_srs_CapabilityPerBandPairList_v14b0_Dynamic v;
};

struct SQN_BandParameters_v14b0 {
	struct SQN_SRS_CapabilityPerBandPair_v14b0_SQN_BandParameters_v14b0_srs_CapabilityPerBandPairList_v14b0_DynamicOptional srs_CapabilityPerBandPairList_v14b0;
};

struct SQN_BandCombinationParameters_v14b0_SQN_BandParameters_v14b0_bandParameterList_v14b0_Dynamic {
	size_t d;
	struct SQN_BandParameters_v14b0* v;
};

struct SQN_BandParameters_v14b0_SQN_BandCombinationParameters_v14b0_bandParameterList_v14b0_DynamicOptional {
	bool d;
	struct SQN_BandCombinationParameters_v14b0_SQN_BandParameters_v14b0_bandParameterList_v14b0_Dynamic v;
};

struct SQN_BandCombinationParameters_v14b0 {
	struct SQN_BandParameters_v14b0_SQN_BandCombinationParameters_v14b0_bandParameterList_v14b0_DynamicOptional bandParameterList_v14b0;
};

struct SQN_BandCombinationParameters_v14b0_SQN_SupportedBandCombination_v14b0_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v14b0* v;
};

typedef struct SQN_BandCombinationParameters_v14b0_SQN_SupportedBandCombination_v14b0_Dynamic SQN_SupportedBandCombination_v14b0;

struct SQN_BandCombinationParameters_v14b0_SQN_SupportedBandCombinationAdd_v14b0_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v14b0* v;
};

typedef struct SQN_BandCombinationParameters_v14b0_SQN_SupportedBandCombinationAdd_v14b0_Dynamic SQN_SupportedBandCombinationAdd_v14b0;

struct SQN_BandCombinationParameters_v14b0_SQN_SupportedBandCombinationReduced_v14b0_Dynamic {
	size_t d;
	struct SQN_BandCombinationParameters_v14b0* v;
};

typedef struct SQN_BandCombinationParameters_v14b0_SQN_SupportedBandCombinationReduced_v14b0_Dynamic SQN_SupportedBandCombinationReduced_v14b0;

struct SQN_SupportedBandCombination_v14b0_SQN_RF_Parameters_v14b0_supportedBandCombination_v14b0_Optional {
	bool d;
	SQN_SupportedBandCombination_v14b0 v;
};

struct SQN_SupportedBandCombinationAdd_v14b0_SQN_RF_Parameters_v14b0_supportedBandCombinationAdd_v14b0_Optional {
	bool d;
	SQN_SupportedBandCombinationAdd_v14b0 v;
};

struct SQN_SupportedBandCombinationReduced_v14b0_SQN_RF_Parameters_v14b0_supportedBandCombinationReduced_v14b0_Optional {
	bool d;
	SQN_SupportedBandCombinationReduced_v14b0 v;
};

struct SQN_RF_Parameters_v14b0 {
	struct SQN_SupportedBandCombination_v14b0_SQN_RF_Parameters_v14b0_supportedBandCombination_v14b0_Optional supportedBandCombination_v14b0;
	struct SQN_SupportedBandCombinationAdd_v14b0_SQN_RF_Parameters_v14b0_supportedBandCombinationAdd_v14b0_Optional supportedBandCombinationAdd_v14b0;
	struct SQN_SupportedBandCombinationReduced_v14b0_SQN_RF_Parameters_v14b0_supportedBandCombinationReduced_v14b0_Optional supportedBandCombinationReduced_v14b0;
};

struct SQN_UE_EUTRA_Capability_v14b0_IEs_nonCriticalExtension {
};

struct SQN_RF_Parameters_v14b0_SQN_UE_EUTRA_Capability_v14b0_IEs_rf_Parameters_v14b0_Optional {
	bool d;
	struct SQN_RF_Parameters_v14b0 v;
};

struct SQN_UE_EUTRA_Capability_v14b0_IEs_nonCriticalExtension_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v14b0_IEs_nonCriticalExtension v;
};

struct SQN_UE_EUTRA_Capability_v14b0_IEs {
	struct SQN_RF_Parameters_v14b0_SQN_UE_EUTRA_Capability_v14b0_IEs_rf_Parameters_v14b0_Optional rf_Parameters_v14b0;
	struct SQN_UE_EUTRA_Capability_v14b0_IEs_nonCriticalExtension_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_UE_EUTRA_Capability_v14b0_IEs_SQN_UE_EUTRA_Capability_v14a0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v14b0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v14a0_IEs {
	struct SQN_PhyLayerParameters_v14a0 phyLayerParameters_v14a0;
	struct SQN_UE_EUTRA_Capability_v14b0_IEs_SQN_UE_EUTRA_Capability_v14a0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_MBMS_Parameters_v1470_SQN_UE_EUTRA_Capability_v1470_IEs_mbms_Parameters_v1470_Optional {
	bool d;
	struct SQN_MBMS_Parameters_v1470 v;
};

struct SQN_PhyLayerParameters_v1470_SQN_UE_EUTRA_Capability_v1470_IEs_phyLayerParameters_v1470_Optional {
	bool d;
	struct SQN_PhyLayerParameters_v1470 v;
};

struct SQN_RF_Parameters_v1470_SQN_UE_EUTRA_Capability_v1470_IEs_rf_Parameters_v1470_Optional {
	bool d;
	struct SQN_RF_Parameters_v1470 v;
};

struct SQN_UE_EUTRA_Capability_v14a0_IEs_SQN_UE_EUTRA_Capability_v1470_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v14a0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v1470_IEs {
	struct SQN_MBMS_Parameters_v1470_SQN_UE_EUTRA_Capability_v1470_IEs_mbms_Parameters_v1470_Optional mbms_Parameters_v1470;
	struct SQN_PhyLayerParameters_v1470_SQN_UE_EUTRA_Capability_v1470_IEs_phyLayerParameters_v1470_Optional phyLayerParameters_v1470;
	struct SQN_RF_Parameters_v1470_SQN_UE_EUTRA_Capability_v1470_IEs_rf_Parameters_v1470_Optional rf_Parameters_v1470;
	struct SQN_UE_EUTRA_Capability_v14a0_IEs_SQN_UE_EUTRA_Capability_v1470_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct OCTET_STRING_SQN_UE_EUTRA_Capability_v13e0a_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_UE_EUTRA_Capability_v1470_IEs_SQN_UE_EUTRA_Capability_v13e0a_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v1470_IEs v;
};

struct SQN_UE_EUTRA_Capability_v13e0a_IEs {
	struct OCTET_STRING_SQN_UE_EUTRA_Capability_v13e0a_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_UE_EUTRA_Capability_v1470_IEs_SQN_UE_EUTRA_Capability_v13e0a_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_RF_Parameters_v1390_SQN_UE_EUTRA_Capability_v1390_IEs_rf_Parameters_v1390_Optional {
	bool d;
	struct SQN_RF_Parameters_v1390 v;
};

struct SQN_UE_EUTRA_Capability_v13e0a_IEs_SQN_UE_EUTRA_Capability_v1390_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v13e0a_IEs v;
};

struct SQN_UE_EUTRA_Capability_v1390_IEs {
	struct SQN_RF_Parameters_v1390_SQN_UE_EUTRA_Capability_v1390_IEs_rf_Parameters_v1390_Optional rf_Parameters_v1390;
	struct SQN_UE_EUTRA_Capability_v13e0a_IEs_SQN_UE_EUTRA_Capability_v1390_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_RF_Parameters_v1380_SQN_UE_EUTRA_Capability_v1380_IEs_rf_Parameters_v1380_Optional {
	bool d;
	struct SQN_RF_Parameters_v1380 v;
};

struct SQN_UE_EUTRA_Capability_v1390_IEs_SQN_UE_EUTRA_Capability_v1380_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v1390_IEs v;
};

struct SQN_UE_EUTRA_Capability_v1380_IEs {
	struct SQN_RF_Parameters_v1380_SQN_UE_EUTRA_Capability_v1380_IEs_rf_Parameters_v1380_Optional rf_Parameters_v1380;
	struct SQN_CE_Parameters_v1380 ce_Parameters_v1380;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1380 fdd_Add_UE_EUTRA_Capabilities_v1380;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1380 tdd_Add_UE_EUTRA_Capabilities_v1380;
	struct SQN_UE_EUTRA_Capability_v1390_IEs_SQN_UE_EUTRA_Capability_v1380_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_CE_Parameters_v1370_SQN_UE_EUTRA_Capability_v1370_IEs_ce_Parameters_v1370_Optional {
	bool d;
	struct SQN_CE_Parameters_v1370 v;
};

struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370_SQN_UE_EUTRA_Capability_v1370_IEs_fdd_Add_UE_EUTRA_Capabilities_v1370_Optional {
	bool d;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370 v;
};

struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370_SQN_UE_EUTRA_Capability_v1370_IEs_tdd_Add_UE_EUTRA_Capabilities_v1370_Optional {
	bool d;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370 v;
};

struct SQN_UE_EUTRA_Capability_v1380_IEs_SQN_UE_EUTRA_Capability_v1370_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v1380_IEs v;
};

struct SQN_UE_EUTRA_Capability_v1370_IEs {
	struct SQN_CE_Parameters_v1370_SQN_UE_EUTRA_Capability_v1370_IEs_ce_Parameters_v1370_Optional ce_Parameters_v1370;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370_SQN_UE_EUTRA_Capability_v1370_IEs_fdd_Add_UE_EUTRA_Capabilities_v1370_Optional fdd_Add_UE_EUTRA_Capabilities_v1370;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_v1370_SQN_UE_EUTRA_Capability_v1370_IEs_tdd_Add_UE_EUTRA_Capabilities_v1370_Optional tdd_Add_UE_EUTRA_Capabilities_v1370;
	struct SQN_UE_EUTRA_Capability_v1380_IEs_SQN_UE_EUTRA_Capability_v1370_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct OCTET_STRING_SQN_UE_EUTRA_Capability_v12x0_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_UE_EUTRA_Capability_v1370_IEs_SQN_UE_EUTRA_Capability_v12x0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v1370_IEs v;
};

struct SQN_UE_EUTRA_Capability_v12x0_IEs {
	struct OCTET_STRING_SQN_UE_EUTRA_Capability_v12x0_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_UE_EUTRA_Capability_v1370_IEs_SQN_UE_EUTRA_Capability_v12x0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_RF_Parameters_v12b0_SQN_UE_EUTRA_Capability_v12b0_IEs_rf_Parameters_v12b0_Optional {
	bool d;
	struct SQN_RF_Parameters_v12b0 v;
};

struct SQN_UE_EUTRA_Capability_v12x0_IEs_SQN_UE_EUTRA_Capability_v12b0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v12x0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v12b0_IEs {
	struct SQN_RF_Parameters_v12b0_SQN_UE_EUTRA_Capability_v12b0_IEs_rf_Parameters_v12b0_Optional rf_Parameters_v12b0;
	struct SQN_UE_EUTRA_Capability_v12x0_IEs_SQN_UE_EUTRA_Capability_v12b0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct OCTET_STRING_SQN_UE_EUTRA_Capability_v11x0_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_UE_EUTRA_Capability_v12b0_IEs_SQN_UE_EUTRA_Capability_v11x0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v12b0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v11x0_IEs {
	struct OCTET_STRING_SQN_UE_EUTRA_Capability_v11x0_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_UE_EUTRA_Capability_v12b0_IEs_SQN_UE_EUTRA_Capability_v11x0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_RF_Parameters_v11d0_SQN_UE_EUTRA_Capability_v11d0_IEs_rf_Parameters_v11d0_Optional {
	bool d;
	struct SQN_RF_Parameters_v11d0 v;
};

struct SQN_Other_Parameters_v11d0_SQN_UE_EUTRA_Capability_v11d0_IEs_otherParameters_v11d0_Optional {
	bool d;
	struct SQN_Other_Parameters_v11d0 v;
};

struct SQN_UE_EUTRA_Capability_v11x0_IEs_SQN_UE_EUTRA_Capability_v11d0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v11x0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v11d0_IEs {
	struct SQN_RF_Parameters_v11d0_SQN_UE_EUTRA_Capability_v11d0_IEs_rf_Parameters_v11d0_Optional rf_Parameters_v11d0;
	struct SQN_Other_Parameters_v11d0_SQN_UE_EUTRA_Capability_v11d0_IEs_otherParameters_v11d0_Optional otherParameters_v11d0;
	struct SQN_UE_EUTRA_Capability_v11x0_IEs_SQN_UE_EUTRA_Capability_v11d0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_RF_Parameters_v10i0_SQN_UE_EUTRA_Capability_v10i0_IEs_rf_Parameters_v10i0_Optional {
	bool d;
	struct SQN_RF_Parameters_v10i0 v;
};

struct OCTET_STRING_SQN_UE_EUTRA_Capability_v10i0_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_UE_EUTRA_Capability_v11d0_IEs_SQN_UE_EUTRA_Capability_v10i0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v11d0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v10i0_IEs {
	struct SQN_RF_Parameters_v10i0_SQN_UE_EUTRA_Capability_v10i0_IEs_rf_Parameters_v10i0_Optional rf_Parameters_v10i0;
	struct OCTET_STRING_SQN_UE_EUTRA_Capability_v10i0_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_UE_EUTRA_Capability_v11d0_IEs_SQN_UE_EUTRA_Capability_v10i0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_RF_Parameters_v10f0_SQN_UE_EUTRA_Capability_v10f0_IEs_rf_Parameters_v10f0_Optional {
	bool d;
	struct SQN_RF_Parameters_v10f0 v;
};

struct SQN_UE_EUTRA_Capability_v10i0_IEs_SQN_UE_EUTRA_Capability_v10f0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v10i0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v10f0_IEs {
	struct SQN_RF_Parameters_v10f0_SQN_UE_EUTRA_Capability_v10f0_IEs_rf_Parameters_v10f0_Optional rf_Parameters_v10f0;
	struct SQN_UE_EUTRA_Capability_v10i0_IEs_SQN_UE_EUTRA_Capability_v10f0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_OTDOA_PositioningCapabilities_r10_SQN_UE_EUTRA_Capability_v10c0_IEs_otdoa_PositioningCapabilities_r10_Optional {
	bool d;
	struct SQN_OTDOA_PositioningCapabilities_r10 v;
};

struct SQN_UE_EUTRA_Capability_v10f0_IEs_SQN_UE_EUTRA_Capability_v10c0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v10f0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v10c0_IEs {
	struct SQN_OTDOA_PositioningCapabilities_r10_SQN_UE_EUTRA_Capability_v10c0_IEs_otdoa_PositioningCapabilities_r10_Optional otdoa_PositioningCapabilities_r10;
	struct SQN_UE_EUTRA_Capability_v10f0_IEs_SQN_UE_EUTRA_Capability_v10c0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_IRAT_ParametersUTRA_v9h0_SQN_UE_EUTRA_Capability_v9h0_IEs_interRAT_ParametersUTRA_v9h0_Optional {
	bool d;
	struct SQN_IRAT_ParametersUTRA_v9h0 v;
};

struct OCTET_STRING_SQN_UE_EUTRA_Capability_v9h0_IEs_lateNonCriticalExtension_Optional {
	bool d;
	OCTET_STRING v;
};

struct SQN_UE_EUTRA_Capability_v10c0_IEs_SQN_UE_EUTRA_Capability_v9h0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v10c0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v9h0_IEs {
	struct SQN_IRAT_ParametersUTRA_v9h0_SQN_UE_EUTRA_Capability_v9h0_IEs_interRAT_ParametersUTRA_v9h0_Optional interRAT_ParametersUTRA_v9h0;
	struct OCTET_STRING_SQN_UE_EUTRA_Capability_v9h0_IEs_lateNonCriticalExtension_Optional lateNonCriticalExtension;
	struct SQN_UE_EUTRA_Capability_v10c0_IEs_SQN_UE_EUTRA_Capability_v9h0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_RF_Parameters_v9e0_SQN_UE_EUTRA_Capability_v9e0_IEs_rf_Parameters_v9e0_Optional {
	bool d;
	struct SQN_RF_Parameters_v9e0 v;
};

struct SQN_UE_EUTRA_Capability_v9h0_IEs_SQN_UE_EUTRA_Capability_v9e0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v9h0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v9e0_IEs {
	struct SQN_RF_Parameters_v9e0_SQN_UE_EUTRA_Capability_v9e0_IEs_rf_Parameters_v9e0_Optional rf_Parameters_v9e0;
	struct SQN_UE_EUTRA_Capability_v9h0_IEs_SQN_UE_EUTRA_Capability_v9e0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_PhyLayerParameters_v9d0_SQN_UE_EUTRA_Capability_v9d0_IEs_phyLayerParameters_v9d0_Optional {
	bool d;
	struct SQN_PhyLayerParameters_v9d0 v;
};

struct SQN_UE_EUTRA_Capability_v9e0_IEs_SQN_UE_EUTRA_Capability_v9d0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v9e0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v9d0_IEs {
	struct SQN_PhyLayerParameters_v9d0_SQN_UE_EUTRA_Capability_v9d0_IEs_phyLayerParameters_v9d0_Optional phyLayerParameters_v9d0;
	struct SQN_UE_EUTRA_Capability_v9e0_IEs_SQN_UE_EUTRA_Capability_v9d0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct SQN_IRAT_ParametersUTRA_v9c0_SQN_UE_EUTRA_Capability_v9c0_IEs_interRAT_ParametersUTRA_v9c0_Optional {
	bool d;
	struct SQN_IRAT_ParametersUTRA_v9c0 v;
};

struct SQN_UE_EUTRA_Capability_v9d0_IEs_SQN_UE_EUTRA_Capability_v9c0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v9d0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v9c0_IEs {
	struct SQN_IRAT_ParametersUTRA_v9c0_SQN_UE_EUTRA_Capability_v9c0_IEs_interRAT_ParametersUTRA_v9c0_Optional interRAT_ParametersUTRA_v9c0;
	struct SQN_UE_EUTRA_Capability_v9d0_IEs_SQN_UE_EUTRA_Capability_v9c0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

struct B32_SQN_UE_EUTRA_Capability_v9a0_IEs_featureGroupIndRel9Add_r9_Optional {
	bool d;
	B32 v;
};

struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_SQN_UE_EUTRA_Capability_v9a0_IEs_fdd_Add_UE_EUTRA_Capabilities_r9_Optional {
	bool d;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9 v;
};

struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_SQN_UE_EUTRA_Capability_v9a0_IEs_tdd_Add_UE_EUTRA_Capabilities_r9_Optional {
	bool d;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9 v;
};

struct SQN_UE_EUTRA_Capability_v9c0_IEs_SQN_UE_EUTRA_Capability_v9a0_IEs_nonCriticalExtension_Optional {
	bool d;
	struct SQN_UE_EUTRA_Capability_v9c0_IEs v;
};

struct SQN_UE_EUTRA_Capability_v9a0_IEs {
	struct B32_SQN_UE_EUTRA_Capability_v9a0_IEs_featureGroupIndRel9Add_r9_Optional featureGroupIndRel9Add_r9;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_SQN_UE_EUTRA_Capability_v9a0_IEs_fdd_Add_UE_EUTRA_Capabilities_r9_Optional fdd_Add_UE_EUTRA_Capabilities_r9;
	struct SQN_UE_EUTRA_CapabilityAddXDD_Mode_r9_SQN_UE_EUTRA_Capability_v9a0_IEs_tdd_Add_UE_EUTRA_Capabilities_r9_Optional tdd_Add_UE_EUTRA_Capabilities_r9;
	struct SQN_UE_EUTRA_Capability_v9c0_IEs_SQN_UE_EUTRA_Capability_v9a0_IEs_nonCriticalExtension_Optional nonCriticalExtension;
};

typedef uint8_t SQN_UE_EUTRA_Capability_ue_Category;

typedef uint8_t SQN_UE_RadioPagingInfo_r12_ue_Category_v1250;

enum SQN_T_PollRetransmit_e {
	SQN_T_PollRetransmit_e_ms5 = 0,
	SQN_T_PollRetransmit_e_ms10 = 1,
	SQN_T_PollRetransmit_e_ms15 = 2,
	SQN_T_PollRetransmit_e_ms20 = 3,
	SQN_T_PollRetransmit_e_ms25 = 4,
	SQN_T_PollRetransmit_e_ms30 = 5,
	SQN_T_PollRetransmit_e_ms35 = 6,
	SQN_T_PollRetransmit_e_ms40 = 7,
	SQN_T_PollRetransmit_e_ms45 = 8,
	SQN_T_PollRetransmit_e_ms50 = 9,
	SQN_T_PollRetransmit_e_ms55 = 10,
	SQN_T_PollRetransmit_e_ms60 = 11,
	SQN_T_PollRetransmit_e_ms65 = 12,
	SQN_T_PollRetransmit_e_ms70 = 13,
	SQN_T_PollRetransmit_e_ms75 = 14,
	SQN_T_PollRetransmit_e_ms80 = 15,
	SQN_T_PollRetransmit_e_ms85 = 16,
	SQN_T_PollRetransmit_e_ms90 = 17,
	SQN_T_PollRetransmit_e_ms95 = 18,
	SQN_T_PollRetransmit_e_ms100 = 19,
	SQN_T_PollRetransmit_e_ms105 = 20,
	SQN_T_PollRetransmit_e_ms110 = 21,
	SQN_T_PollRetransmit_e_ms115 = 22,
	SQN_T_PollRetransmit_e_ms120 = 23,
	SQN_T_PollRetransmit_e_ms125 = 24,
	SQN_T_PollRetransmit_e_ms130 = 25,
	SQN_T_PollRetransmit_e_ms135 = 26,
	SQN_T_PollRetransmit_e_ms140 = 27,
	SQN_T_PollRetransmit_e_ms145 = 28,
	SQN_T_PollRetransmit_e_ms150 = 29,
	SQN_T_PollRetransmit_e_ms155 = 30,
	SQN_T_PollRetransmit_e_ms160 = 31,
	SQN_T_PollRetransmit_e_ms165 = 32,
	SQN_T_PollRetransmit_e_ms170 = 33,
	SQN_T_PollRetransmit_e_ms175 = 34,
	SQN_T_PollRetransmit_e_ms180 = 35,
	SQN_T_PollRetransmit_e_ms185 = 36,
	SQN_T_PollRetransmit_e_ms190 = 37,
	SQN_T_PollRetransmit_e_ms195 = 38,
	SQN_T_PollRetransmit_e_ms200 = 39,
	SQN_T_PollRetransmit_e_ms205 = 40,
	SQN_T_PollRetransmit_e_ms210 = 41,
	SQN_T_PollRetransmit_e_ms215 = 42,
	SQN_T_PollRetransmit_e_ms220 = 43,
	SQN_T_PollRetransmit_e_ms225 = 44,
	SQN_T_PollRetransmit_e_ms230 = 45,
	SQN_T_PollRetransmit_e_ms235 = 46,
	SQN_T_PollRetransmit_e_ms240 = 47,
	SQN_T_PollRetransmit_e_ms245 = 48,
	SQN_T_PollRetransmit_e_ms250 = 49,
	SQN_T_PollRetransmit_e_ms300 = 50,
	SQN_T_PollRetransmit_e_ms350 = 51,
	SQN_T_PollRetransmit_e_ms400 = 52,
	SQN_T_PollRetransmit_e_ms450 = 53,
	SQN_T_PollRetransmit_e_ms500 = 54,
	SQN_T_PollRetransmit_e_ms800_v1310 = 55,
	SQN_T_PollRetransmit_e_ms1000_v1310 = 56,
	SQN_T_PollRetransmit_e_ms2000_v1310 = 57,
	SQN_T_PollRetransmit_e_ms4000_v1310 = 58,
	SQN_T_PollRetransmit_e_spare5 = 59,
	SQN_T_PollRetransmit_e_spare4 = 60,
	SQN_T_PollRetransmit_e_spare3 = 61,
	SQN_T_PollRetransmit_e_spare2 = 62,
	SQN_T_PollRetransmit_e_spare1 = 63,
};

typedef enum SQN_T_PollRetransmit_e SQN_T_PollRetransmit_e;

enum SQN_PollPDU_e {
	SQN_PollPDU_e_p4 = 0,
	SQN_PollPDU_e_p8 = 1,
	SQN_PollPDU_e_p16 = 2,
	SQN_PollPDU_e_p32 = 3,
	SQN_PollPDU_e_p64 = 4,
	SQN_PollPDU_e_p128 = 5,
	SQN_PollPDU_e_p256 = 6,
	SQN_PollPDU_e_pInfinity = 7,
};

typedef enum SQN_PollPDU_e SQN_PollPDU_e;

enum SQN_PollByte_e {
	SQN_PollByte_e_kB25 = 0,
	SQN_PollByte_e_kB50 = 1,
	SQN_PollByte_e_kB75 = 2,
	SQN_PollByte_e_kB100 = 3,
	SQN_PollByte_e_kB125 = 4,
	SQN_PollByte_e_kB250 = 5,
	SQN_PollByte_e_kB375 = 6,
	SQN_PollByte_e_kB500 = 7,
	SQN_PollByte_e_kB750 = 8,
	SQN_PollByte_e_kB1000 = 9,
	SQN_PollByte_e_kB1250 = 10,
	SQN_PollByte_e_kB1500 = 11,
	SQN_PollByte_e_kB2000 = 12,
	SQN_PollByte_e_kB3000 = 13,
	SQN_PollByte_e_kBinfinity = 14,
	SQN_PollByte_e_spare1 = 15,
};

typedef enum SQN_PollByte_e SQN_PollByte_e;

enum SQN_UL_AM_RLC_maxRetxThreshold_e {
	SQN_UL_AM_RLC_maxRetxThreshold_e_t1 = 0,
	SQN_UL_AM_RLC_maxRetxThreshold_e_t2 = 1,
	SQN_UL_AM_RLC_maxRetxThreshold_e_t3 = 2,
	SQN_UL_AM_RLC_maxRetxThreshold_e_t4 = 3,
	SQN_UL_AM_RLC_maxRetxThreshold_e_t6 = 4,
	SQN_UL_AM_RLC_maxRetxThreshold_e_t8 = 5,
	SQN_UL_AM_RLC_maxRetxThreshold_e_t16 = 6,
	SQN_UL_AM_RLC_maxRetxThreshold_e_t32 = 7,
};

typedef enum SQN_UL_AM_RLC_maxRetxThreshold_e SQN_UL_AM_RLC_maxRetxThreshold_e;

struct SQN_UL_AM_RLC {
	SQN_T_PollRetransmit_e t_PollRetransmit;
	SQN_PollPDU_e pollPDU;
	SQN_PollByte_e pollByte;
	SQN_UL_AM_RLC_maxRetxThreshold_e maxRetxThreshold;
};

struct SQN_UL_UM_RLC {
	SQN_SN_FieldLength_e sn_FieldLength;
};

enum SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e {
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF_1 = 0,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF0 = 1,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF1 = 2,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF2 = 3,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF3 = 4,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF4 = 5,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF5 = 6,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e_deltaF6 = 7,
};

typedef enum SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e;

enum SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e {
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e_deltaF1 = 0,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e_deltaF2 = 1,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e_spare2 = 2,
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e_spare1 = 3,
};

typedef enum SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e;

struct SQN_UplinkPowerControlCommonPSCell_r12 {
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format3_r12_e deltaF_PUCCH_Format3_r12;
	SQN_UplinkPowerControlCommonPSCell_r12_deltaF_PUCCH_Format1bCS_r12_e deltaF_PUCCH_Format1bCS_r12;
	int8_t p0_NominalPUCCH_r12;
	struct SQN_DeltaFList_PUCCH deltaFList_PUCCH_r12;
};

struct SQN_UplinkPowerControlCommonSCell_v1130 {
	int8_t deltaPreambleMsg3_r11;
};

enum SQN_UplinkPowerControlDedicated_deltaMCS_Enabled_e {
	SQN_UplinkPowerControlDedicated_deltaMCS_Enabled_e_en0 = 0,
	SQN_UplinkPowerControlDedicated_deltaMCS_Enabled_e_en1 = 1,
};

typedef enum SQN_UplinkPowerControlDedicated_deltaMCS_Enabled_e SQN_UplinkPowerControlDedicated_deltaMCS_Enabled_e;

struct SQN_FilterCoefficient_e_SQN_UplinkPowerControlDedicated_filterCoefficient_Optional {
	bool d;
	SQN_FilterCoefficient_e v;
};

struct SQN_UplinkPowerControlDedicated {
	int8_t p0_UE_PUSCH;
	SQN_UplinkPowerControlDedicated_deltaMCS_Enabled_e deltaMCS_Enabled;
	bool accumulationEnabled;
	int8_t p0_UE_PUCCH;
	uint8_t pSRS_Offset;
	struct SQN_FilterCoefficient_e_SQN_UplinkPowerControlDedicated_filterCoefficient_Optional filterCoefficient;
};

enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1_r10_e {
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1_r10_e_dB0 = 0,
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1_r10_e_dB_2 = 1,
};

typedef enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1_r10_e SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1_r10_e;

enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1a1b_r10_e {
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1a1b_r10_e_dB0 = 0,
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1a1b_r10_e_dB_2 = 1,
};

typedef enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1a1b_r10_e SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1a1b_r10_e;

enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format22a2b_r10_e {
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format22a2b_r10_e_dB0 = 0,
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format22a2b_r10_e_dB_2 = 1,
};

typedef enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format22a2b_r10_e SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format22a2b_r10_e;

enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format3_r10_e {
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format3_r10_e_dB0 = 0,
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format3_r10_e_dB_2 = 1,
};

typedef enum SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format3_r10_e SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format3_r10_e;

struct SQN_DeltaTxD_OffsetListPUCCH_r10 {
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1_r10_e deltaTxD_OffsetPUCCH_Format1_r10;
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format1a1b_r10_e deltaTxD_OffsetPUCCH_Format1a1b_r10;
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format22a2b_r10_e deltaTxD_OffsetPUCCH_Format22a2b_r10;
	SQN_DeltaTxD_OffsetListPUCCH_r10_deltaTxD_OffsetPUCCH_Format3_r10_e deltaTxD_OffsetPUCCH_Format3_r10;
};

struct SQN_DeltaTxD_OffsetListPUCCH_r10_SQN_UplinkPowerControlDedicated_v1020_deltaTxD_OffsetListPUCCH_r10_Optional {
	bool d;
	struct SQN_DeltaTxD_OffsetListPUCCH_r10 v;
};

struct uint8_t_SQN_UplinkPowerControlDedicated_v1020_pSRS_OffsetAp_r10_Optional {
	bool d;
	uint8_t v;
};

struct SQN_UplinkPowerControlDedicated_v1020 {
	struct SQN_DeltaTxD_OffsetListPUCCH_r10_SQN_UplinkPowerControlDedicated_v1020_deltaTxD_OffsetListPUCCH_r10_Optional deltaTxD_OffsetListPUCCH_r10;
	struct uint8_t_SQN_UplinkPowerControlDedicated_v1020_pSRS_OffsetAp_r10_Optional pSRS_OffsetAp_r10;
};

enum SQN_DeltaTxD_OffsetListPUCCH_v1130_deltaTxD_OffsetPUCCH_Format1bCS_r11_e {
	SQN_DeltaTxD_OffsetListPUCCH_v1130_deltaTxD_OffsetPUCCH_Format1bCS_r11_e_dB0 = 0,
	SQN_DeltaTxD_OffsetListPUCCH_v1130_deltaTxD_OffsetPUCCH_Format1bCS_r11_e_dB_1 = 1,
};

typedef enum SQN_DeltaTxD_OffsetListPUCCH_v1130_deltaTxD_OffsetPUCCH_Format1bCS_r11_e SQN_DeltaTxD_OffsetListPUCCH_v1130_deltaTxD_OffsetPUCCH_Format1bCS_r11_e;

struct SQN_DeltaTxD_OffsetListPUCCH_v1130 {
	SQN_DeltaTxD_OffsetListPUCCH_v1130_deltaTxD_OffsetPUCCH_Format1bCS_r11_e deltaTxD_OffsetPUCCH_Format1bCS_r11;
};

struct uint8_t_SQN_UplinkPowerControlDedicated_v1130_pSRS_Offset_v1130_Optional {
	bool d;
	uint8_t v;
};

struct uint8_t_SQN_UplinkPowerControlDedicated_v1130_pSRS_OffsetAp_v1130_Optional {
	bool d;
	uint8_t v;
};

struct SQN_DeltaTxD_OffsetListPUCCH_v1130_SQN_UplinkPowerControlDedicated_v1130_deltaTxD_OffsetListPUCCH_v1130_Optional {
	bool d;
	struct SQN_DeltaTxD_OffsetListPUCCH_v1130 v;
};

struct SQN_UplinkPowerControlDedicated_v1130 {
	struct uint8_t_SQN_UplinkPowerControlDedicated_v1130_pSRS_Offset_v1130_Optional pSRS_Offset_v1130;
	struct uint8_t_SQN_UplinkPowerControlDedicated_v1130_pSRS_OffsetAp_v1130_Optional pSRS_OffsetAp_v1130;
	struct SQN_DeltaTxD_OffsetListPUCCH_v1130_SQN_UplinkPowerControlDedicated_v1130_deltaTxD_OffsetListPUCCH_v1130_Optional deltaTxD_OffsetListPUCCH_v1130;
};

struct SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_setup {
	B10 tpc_SubframeSet_r12;
	int8_t p0_NominalPUSCH_SubframeSet2_r12;
	SQN_Alpha_r12_e alpha_SubframeSet2_r12;
	int8_t p0_UE_PUSCH_SubframeSet2_r12;
};

enum SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_Sel {
	SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_UNBOUND_VALUE = 0,
	SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_release = 1,
	SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_setup = 2,
};

union SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_Value {
	Null release;
	struct SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_setup setup;
};

struct SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter {
	enum SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_Sel d;
	union SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter_Value v;
};

struct SQN_UplinkPowerControlDedicated_v1250 {
	struct SQN_UplinkPowerControlDedicated_v1250_set2PowerControlParameter set2PowerControlParameter;
};

enum SQN_UplinkPowerControlDedicatedSCell_r10_pathlossReferenceLinking_r10_e {
	SQN_UplinkPowerControlDedicatedSCell_r10_pathlossReferenceLinking_r10_e_pCell = 0,
	SQN_UplinkPowerControlDedicatedSCell_r10_pathlossReferenceLinking_r10_e_sCell = 1,
};

typedef enum SQN_UplinkPowerControlDedicatedSCell_r10_pathlossReferenceLinking_r10_e SQN_UplinkPowerControlDedicatedSCell_r10_pathlossReferenceLinking_r10_e;

SIDL_END_C_INTERFACE
